﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ebs/EBS_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ebs/model/RequestThrottledExceptionReason.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace EBS
{
namespace Model
{

  /**
   * <p>The number of API requests has exceeded the maximum allowed API request
   * throttling limit for the snapshot. For more information see <a
   * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/error-retries.html">Error
   * retries</a>.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/ebs-2019-11-02/RequestThrottledException">AWS
   * API Reference</a></p>
   */
  class RequestThrottledException
  {
  public:
    AWS_EBS_API RequestThrottledException();
    AWS_EBS_API RequestThrottledException(Aws::Utils::Json::JsonView jsonValue);
    AWS_EBS_API RequestThrottledException& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_EBS_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    
    inline const Aws::String& GetMessage() const{ return m_message; }
    inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
    inline void SetMessage(const Aws::String& value) { m_messageHasBeenSet = true; m_message = value; }
    inline void SetMessage(Aws::String&& value) { m_messageHasBeenSet = true; m_message = std::move(value); }
    inline void SetMessage(const char* value) { m_messageHasBeenSet = true; m_message.assign(value); }
    inline RequestThrottledException& WithMessage(const Aws::String& value) { SetMessage(value); return *this;}
    inline RequestThrottledException& WithMessage(Aws::String&& value) { SetMessage(std::move(value)); return *this;}
    inline RequestThrottledException& WithMessage(const char* value) { SetMessage(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The reason for the exception.</p>
     */
    inline const RequestThrottledExceptionReason& GetReason() const{ return m_reason; }
    inline bool ReasonHasBeenSet() const { return m_reasonHasBeenSet; }
    inline void SetReason(const RequestThrottledExceptionReason& value) { m_reasonHasBeenSet = true; m_reason = value; }
    inline void SetReason(RequestThrottledExceptionReason&& value) { m_reasonHasBeenSet = true; m_reason = std::move(value); }
    inline RequestThrottledException& WithReason(const RequestThrottledExceptionReason& value) { SetReason(value); return *this;}
    inline RequestThrottledException& WithReason(RequestThrottledExceptionReason&& value) { SetReason(std::move(value)); return *this;}
    ///@}
  private:

    Aws::String m_message;
    bool m_messageHasBeenSet = false;

    RequestThrottledExceptionReason m_reason;
    bool m_reasonHasBeenSet = false;
  };

} // namespace Model
} // namespace EBS
} // namespace Aws
