﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/appsync/AppSyncRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace AppSync
{
namespace Model
{

  /**
   */
  class DisassociateSourceGraphqlApiRequest : public AppSyncRequest
  {
  public:
    AWS_APPSYNC_API DisassociateSourceGraphqlApiRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "DisassociateSourceGraphqlApi"; }

    AWS_APPSYNC_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>The identifier of the AppSync Merged API. This is generated by the AppSync
     * service. In most cases, Merged APIs (especially in your account) only require
     * the API ID value or ARN of the merged API. However, Merged APIs in other
     * accounts (cross-account use cases) strictly require the full resource ARN of the
     * merged API.</p>
     */
    inline const Aws::String& GetMergedApiIdentifier() const{ return m_mergedApiIdentifier; }
    inline bool MergedApiIdentifierHasBeenSet() const { return m_mergedApiIdentifierHasBeenSet; }
    inline void SetMergedApiIdentifier(const Aws::String& value) { m_mergedApiIdentifierHasBeenSet = true; m_mergedApiIdentifier = value; }
    inline void SetMergedApiIdentifier(Aws::String&& value) { m_mergedApiIdentifierHasBeenSet = true; m_mergedApiIdentifier = std::move(value); }
    inline void SetMergedApiIdentifier(const char* value) { m_mergedApiIdentifierHasBeenSet = true; m_mergedApiIdentifier.assign(value); }
    inline DisassociateSourceGraphqlApiRequest& WithMergedApiIdentifier(const Aws::String& value) { SetMergedApiIdentifier(value); return *this;}
    inline DisassociateSourceGraphqlApiRequest& WithMergedApiIdentifier(Aws::String&& value) { SetMergedApiIdentifier(std::move(value)); return *this;}
    inline DisassociateSourceGraphqlApiRequest& WithMergedApiIdentifier(const char* value) { SetMergedApiIdentifier(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ID generated by the AppSync service for the source API association.</p>
     */
    inline const Aws::String& GetAssociationId() const{ return m_associationId; }
    inline bool AssociationIdHasBeenSet() const { return m_associationIdHasBeenSet; }
    inline void SetAssociationId(const Aws::String& value) { m_associationIdHasBeenSet = true; m_associationId = value; }
    inline void SetAssociationId(Aws::String&& value) { m_associationIdHasBeenSet = true; m_associationId = std::move(value); }
    inline void SetAssociationId(const char* value) { m_associationIdHasBeenSet = true; m_associationId.assign(value); }
    inline DisassociateSourceGraphqlApiRequest& WithAssociationId(const Aws::String& value) { SetAssociationId(value); return *this;}
    inline DisassociateSourceGraphqlApiRequest& WithAssociationId(Aws::String&& value) { SetAssociationId(std::move(value)); return *this;}
    inline DisassociateSourceGraphqlApiRequest& WithAssociationId(const char* value) { SetAssociationId(value); return *this;}
    ///@}
  private:

    Aws::String m_mergedApiIdentifier;
    bool m_mergedApiIdentifierHasBeenSet = false;

    Aws::String m_associationId;
    bool m_associationIdHasBeenSet = false;
  };

} // namespace Model
} // namespace AppSync
} // namespace Aws
