﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent/BedrockAgent_EXPORTS.h>
#include <aws/bedrock-agent/model/ChunkingConfiguration.h>
#include <aws/bedrock-agent/model/CustomTransformationConfiguration.h>
#include <aws/bedrock-agent/model/ParsingConfiguration.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace BedrockAgent
{
namespace Model
{

  /**
   * <p>Contains details about how to ingest the documents in a data
   * source.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/VectorIngestionConfiguration">AWS
   * API Reference</a></p>
   */
  class VectorIngestionConfiguration
  {
  public:
    AWS_BEDROCKAGENT_API VectorIngestionConfiguration();
    AWS_BEDROCKAGENT_API VectorIngestionConfiguration(Aws::Utils::Json::JsonView jsonValue);
    AWS_BEDROCKAGENT_API VectorIngestionConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_BEDROCKAGENT_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>Details about how to chunk the documents in the data source. A <i>chunk</i>
     * refers to an excerpt from a data source that is returned when the knowledge base
     * that it belongs to is queried.</p>
     */
    inline const ChunkingConfiguration& GetChunkingConfiguration() const{ return m_chunkingConfiguration; }
    inline bool ChunkingConfigurationHasBeenSet() const { return m_chunkingConfigurationHasBeenSet; }
    inline void SetChunkingConfiguration(const ChunkingConfiguration& value) { m_chunkingConfigurationHasBeenSet = true; m_chunkingConfiguration = value; }
    inline void SetChunkingConfiguration(ChunkingConfiguration&& value) { m_chunkingConfigurationHasBeenSet = true; m_chunkingConfiguration = std::move(value); }
    inline VectorIngestionConfiguration& WithChunkingConfiguration(const ChunkingConfiguration& value) { SetChunkingConfiguration(value); return *this;}
    inline VectorIngestionConfiguration& WithChunkingConfiguration(ChunkingConfiguration&& value) { SetChunkingConfiguration(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A custom document transformer for parsed data source documents.</p>
     */
    inline const CustomTransformationConfiguration& GetCustomTransformationConfiguration() const{ return m_customTransformationConfiguration; }
    inline bool CustomTransformationConfigurationHasBeenSet() const { return m_customTransformationConfigurationHasBeenSet; }
    inline void SetCustomTransformationConfiguration(const CustomTransformationConfiguration& value) { m_customTransformationConfigurationHasBeenSet = true; m_customTransformationConfiguration = value; }
    inline void SetCustomTransformationConfiguration(CustomTransformationConfiguration&& value) { m_customTransformationConfigurationHasBeenSet = true; m_customTransformationConfiguration = std::move(value); }
    inline VectorIngestionConfiguration& WithCustomTransformationConfiguration(const CustomTransformationConfiguration& value) { SetCustomTransformationConfiguration(value); return *this;}
    inline VectorIngestionConfiguration& WithCustomTransformationConfiguration(CustomTransformationConfiguration&& value) { SetCustomTransformationConfiguration(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Configurations for a parser to use for parsing documents in your data source.
     * If you exclude this field, the default parser will be used.</p>
     */
    inline const ParsingConfiguration& GetParsingConfiguration() const{ return m_parsingConfiguration; }
    inline bool ParsingConfigurationHasBeenSet() const { return m_parsingConfigurationHasBeenSet; }
    inline void SetParsingConfiguration(const ParsingConfiguration& value) { m_parsingConfigurationHasBeenSet = true; m_parsingConfiguration = value; }
    inline void SetParsingConfiguration(ParsingConfiguration&& value) { m_parsingConfigurationHasBeenSet = true; m_parsingConfiguration = std::move(value); }
    inline VectorIngestionConfiguration& WithParsingConfiguration(const ParsingConfiguration& value) { SetParsingConfiguration(value); return *this;}
    inline VectorIngestionConfiguration& WithParsingConfiguration(ParsingConfiguration&& value) { SetParsingConfiguration(std::move(value)); return *this;}
    ///@}
  private:

    ChunkingConfiguration m_chunkingConfiguration;
    bool m_chunkingConfigurationHasBeenSet = false;

    CustomTransformationConfiguration m_customTransformationConfiguration;
    bool m_customTransformationConfigurationHasBeenSet = false;

    ParsingConfiguration m_parsingConfiguration;
    bool m_parsingConfigurationHasBeenSet = false;
  };

} // namespace Model
} // namespace BedrockAgent
} // namespace Aws
