﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Connect
{
namespace Model
{
  class CreateUseCaseResult
  {
  public:
    AWS_CONNECT_API CreateUseCaseResult();
    AWS_CONNECT_API CreateUseCaseResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_CONNECT_API CreateUseCaseResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The identifier of the use case.</p>
     */
    inline const Aws::String& GetUseCaseId() const{ return m_useCaseId; }
    inline void SetUseCaseId(const Aws::String& value) { m_useCaseId = value; }
    inline void SetUseCaseId(Aws::String&& value) { m_useCaseId = std::move(value); }
    inline void SetUseCaseId(const char* value) { m_useCaseId.assign(value); }
    inline CreateUseCaseResult& WithUseCaseId(const Aws::String& value) { SetUseCaseId(value); return *this;}
    inline CreateUseCaseResult& WithUseCaseId(Aws::String&& value) { SetUseCaseId(std::move(value)); return *this;}
    inline CreateUseCaseResult& WithUseCaseId(const char* value) { SetUseCaseId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) for the use case.</p>
     */
    inline const Aws::String& GetUseCaseArn() const{ return m_useCaseArn; }
    inline void SetUseCaseArn(const Aws::String& value) { m_useCaseArn = value; }
    inline void SetUseCaseArn(Aws::String&& value) { m_useCaseArn = std::move(value); }
    inline void SetUseCaseArn(const char* value) { m_useCaseArn.assign(value); }
    inline CreateUseCaseResult& WithUseCaseArn(const Aws::String& value) { SetUseCaseArn(value); return *this;}
    inline CreateUseCaseResult& WithUseCaseArn(Aws::String&& value) { SetUseCaseArn(std::move(value)); return *this;}
    inline CreateUseCaseResult& WithUseCaseArn(const char* value) { SetUseCaseArn(value); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline CreateUseCaseResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline CreateUseCaseResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline CreateUseCaseResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_useCaseId;

    Aws::String m_useCaseArn;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Connect
} // namespace Aws
