﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/customer-profiles/model/SegmentDefinitionItem.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace CustomerProfiles
{
namespace Model
{

SegmentDefinitionItem::SegmentDefinitionItem() : 
    m_segmentDefinitionNameHasBeenSet(false),
    m_displayNameHasBeenSet(false),
    m_descriptionHasBeenSet(false),
    m_segmentDefinitionArnHasBeenSet(false),
    m_createdAtHasBeenSet(false),
    m_tagsHasBeenSet(false)
{
}

SegmentDefinitionItem::SegmentDefinitionItem(JsonView jsonValue)
  : SegmentDefinitionItem()
{
  *this = jsonValue;
}

SegmentDefinitionItem& SegmentDefinitionItem::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("SegmentDefinitionName"))
  {
    m_segmentDefinitionName = jsonValue.GetString("SegmentDefinitionName");

    m_segmentDefinitionNameHasBeenSet = true;
  }

  if(jsonValue.ValueExists("DisplayName"))
  {
    m_displayName = jsonValue.GetString("DisplayName");

    m_displayNameHasBeenSet = true;
  }

  if(jsonValue.ValueExists("Description"))
  {
    m_description = jsonValue.GetString("Description");

    m_descriptionHasBeenSet = true;
  }

  if(jsonValue.ValueExists("SegmentDefinitionArn"))
  {
    m_segmentDefinitionArn = jsonValue.GetString("SegmentDefinitionArn");

    m_segmentDefinitionArnHasBeenSet = true;
  }

  if(jsonValue.ValueExists("CreatedAt"))
  {
    m_createdAt = jsonValue.GetDouble("CreatedAt");

    m_createdAtHasBeenSet = true;
  }

  if(jsonValue.ValueExists("Tags"))
  {
    Aws::Map<Aws::String, JsonView> tagsJsonMap = jsonValue.GetObject("Tags").GetAllObjects();
    for(auto& tagsItem : tagsJsonMap)
    {
      m_tags[tagsItem.first] = tagsItem.second.AsString();
    }
    m_tagsHasBeenSet = true;
  }

  return *this;
}

JsonValue SegmentDefinitionItem::Jsonize() const
{
  JsonValue payload;

  if(m_segmentDefinitionNameHasBeenSet)
  {
   payload.WithString("SegmentDefinitionName", m_segmentDefinitionName);

  }

  if(m_displayNameHasBeenSet)
  {
   payload.WithString("DisplayName", m_displayName);

  }

  if(m_descriptionHasBeenSet)
  {
   payload.WithString("Description", m_description);

  }

  if(m_segmentDefinitionArnHasBeenSet)
  {
   payload.WithString("SegmentDefinitionArn", m_segmentDefinitionArn);

  }

  if(m_createdAtHasBeenSet)
  {
   payload.WithDouble("CreatedAt", m_createdAt.SecondsWithMSPrecision());
  }

  if(m_tagsHasBeenSet)
  {
   JsonValue tagsJsonMap;
   for(auto& tagsItem : m_tags)
   {
     tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
   }
   payload.WithObject("Tags", std::move(tagsJsonMap));

  }

  return payload;
}

} // namespace Model
} // namespace CustomerProfiles
} // namespace Aws
