﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/datazone/model/DeleteTimeSeriesDataPointsRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::DataZone::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

DeleteTimeSeriesDataPointsRequest::DeleteTimeSeriesDataPointsRequest() : 
    m_clientToken(Aws::Utils::UUID::PseudoRandomUUID()),
    m_clientTokenHasBeenSet(true),
    m_domainIdentifierHasBeenSet(false),
    m_entityIdentifierHasBeenSet(false),
    m_entityType(TimeSeriesEntityType::NOT_SET),
    m_entityTypeHasBeenSet(false),
    m_formNameHasBeenSet(false)
{
}

Aws::String DeleteTimeSeriesDataPointsRequest::SerializePayload() const
{
  return {};
}

void DeleteTimeSeriesDataPointsRequest::AddQueryStringParameters(URI& uri) const
{
    Aws::StringStream ss;
    if(m_clientTokenHasBeenSet)
    {
      ss << m_clientToken;
      uri.AddQueryStringParameter("clientToken", ss.str());
      ss.str("");
    }

    if(m_formNameHasBeenSet)
    {
      ss << m_formName;
      uri.AddQueryStringParameter("formName", ss.str());
      ss.str("");
    }

}



