;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.

;; RUN: wasm-opt %s -all --roundtrip -S -o - | filecheck %s

;; Regression test for a bug in which we could pop the expression stack past an
;; unreachable if we were already in unreachable parsing mode.

(module

 ;; CHECK:      (type $array (array i8))
 (type $array (array i8))
 (type $func (func (result i32)))

 ;; CHECK:      (func $double-unreachable (type $1) (param $x (ref $array)) (result i32)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (ref.null nofunc)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (local.get $x)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (ref.null nofunc)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (block ;; (replaces unreachable ArrayGet we can't emit)
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $double-unreachable (param $x (ref $array)) (result i32)

  (drop
   ;; This gets emitted as an unreachable, but it doesn't have type
   ;; unreachable, so we continue emitting instructions afterward. When
   ;; parsing, this will put us into unreachable mode.
   (call_ref $func
    (ref.null nofunc)
   )
  )

  (array.get_u $array
   (local.get $x)

   ;; Since this call_ref will be emitted as an unreachable, it does not consume
   ;; the ref.null when parsing. Due to the bug, the ref.null would remain on
   ;; the stack and would be incorrectly consumed as the index to the
   ;; array.get_u, producing a type error.
   (call_ref $func
    (ref.null nofunc)
   )
  )
 )
)
