/* SPDX-FileCopyrightText: 2011-2022 Blender Authors
 *
 * SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef __QUEUE_H__
#define __QUEUE_H__

#include "MemoryAllocator.h"

struct gridQueueEle {
  int x, y, z;
  UCHAR dir;
  gridQueueEle *next;
};

class GridQueue {
  gridQueueEle *head;
  gridQueueEle *tail;
  int numEles;

 public:
  GridQueue()
  {
    head = nullptr;
    tail = nullptr;
    numEles = 0;
  }

  gridQueueEle *getHead()
  {
    return head;
  }

  int getNumElements()
  {
    return numEles;
  }

  void pushQueue(const int st[3], int dir)
  {
    gridQueueEle *ele = new gridQueueEle;
    ele->x = st[0];
    ele->y = st[1];
    ele->z = st[2];
    ele->dir = (UCHAR)dir;
    ele->next = nullptr;
    if (head == nullptr) {
      head = ele;
    }
    else {
      tail->next = ele;
    }
    tail = ele;
    numEles++;
  }

  int popQueue(int st[3], int &dir)
  {
    if (head == nullptr) {
      return 0;
    }

    st[0] = head->x;
    st[1] = head->y;
    st[2] = head->z;
    dir = (int)(head->dir);

    gridQueueEle *temp = head;
    head = head->next;
    delete temp;

    if (head == nullptr) {
      tail = nullptr;
    }
    numEles--;

    return 1;
  }

  MEM_CXX_CLASS_ALLOC_FUNCS("DUALCON:GridQueue")
};

#endif /* __QUEUE_H__ */
