/* { dg-do compile { target { ! riscv_abi_e } } } */
/* { dg-require-effective-target rv64 } */
/* We aggressively skip as we really just need to test the basic synthesis
   which shouldn't vary based on the optimization level.  -O1 seems to work
   and eliminates the usual sources of extraneous dead code that would throw
   off the counts.  */
/* { dg-skip-if "" { *-*-* } { "-O0" "-Og" "-O2" "-O3" "-Os" "-Oz" "-flto" } } */
/* { dg-options "-march=rv64gcb" } */

/* Rather than test for a specific synthesis of all these constants or
   having thousands of tests each testing one variant, we just test the
   total number of instructions. 

   This isn't expected to change much and any change is worthy of a look.  */
/* { dg-final { scan-assembler-times "\\t(add|addi|bseti|li|ret|sh1add|sh2add|sh3add|slli)" 5822 } } */

 unsigned long foo_0x3(void) { return 0x3UL; }
 unsigned long foo_0x5(void) { return 0x5UL; }
 unsigned long foo_0x9(void) { return 0x9UL; }
 unsigned long foo_0x11(void) { return 0x11UL; }
 unsigned long foo_0x21(void) { return 0x21UL; }
 unsigned long foo_0x41(void) { return 0x41UL; }
 unsigned long foo_0x81(void) { return 0x81UL; }
 unsigned long foo_0x101(void) { return 0x101UL; }
 unsigned long foo_0x201(void) { return 0x201UL; }
 unsigned long foo_0x401(void) { return 0x401UL; }
 unsigned long foo_0x801(void) { return 0x801UL; }
 unsigned long foo_0x1001(void) { return 0x1001UL; }
 unsigned long foo_0x2001(void) { return 0x2001UL; }
 unsigned long foo_0x4001(void) { return 0x4001UL; }
 unsigned long foo_0x8001(void) { return 0x8001UL; }
 unsigned long foo_0x10001(void) { return 0x10001UL; }
 unsigned long foo_0x20001(void) { return 0x20001UL; }
 unsigned long foo_0x40001(void) { return 0x40001UL; }
 unsigned long foo_0x80001(void) { return 0x80001UL; }
 unsigned long foo_0x100001(void) { return 0x100001UL; }
 unsigned long foo_0x200001(void) { return 0x200001UL; }
 unsigned long foo_0x400001(void) { return 0x400001UL; }
 unsigned long foo_0x800001(void) { return 0x800001UL; }
 unsigned long foo_0x1000001(void) { return 0x1000001UL; }
 unsigned long foo_0x2000001(void) { return 0x2000001UL; }
 unsigned long foo_0x4000001(void) { return 0x4000001UL; }
 unsigned long foo_0x8000001(void) { return 0x8000001UL; }
 unsigned long foo_0x10000001(void) { return 0x10000001UL; }
 unsigned long foo_0x20000001(void) { return 0x20000001UL; }
 unsigned long foo_0x40000001(void) { return 0x40000001UL; }
 unsigned long foo_0x80000001(void) { return 0x80000001UL; }
 unsigned long foo_0x100000001(void) { return 0x100000001UL; }
 unsigned long foo_0x200000001(void) { return 0x200000001UL; }
 unsigned long foo_0x400000001(void) { return 0x400000001UL; }
 unsigned long foo_0x800000001(void) { return 0x800000001UL; }
 unsigned long foo_0x1000000001(void) { return 0x1000000001UL; }
 unsigned long foo_0x2000000001(void) { return 0x2000000001UL; }
 unsigned long foo_0x4000000001(void) { return 0x4000000001UL; }
 unsigned long foo_0x8000000001(void) { return 0x8000000001UL; }
 unsigned long foo_0x10000000001(void) { return 0x10000000001UL; }
 unsigned long foo_0x20000000001(void) { return 0x20000000001UL; }
 unsigned long foo_0x40000000001(void) { return 0x40000000001UL; }
 unsigned long foo_0x80000000001(void) { return 0x80000000001UL; }
 unsigned long foo_0x100000000001(void) { return 0x100000000001UL; }
 unsigned long foo_0x200000000001(void) { return 0x200000000001UL; }
 unsigned long foo_0x400000000001(void) { return 0x400000000001UL; }
 unsigned long foo_0x800000000001(void) { return 0x800000000001UL; }
 unsigned long foo_0x1000000000001(void) { return 0x1000000000001UL; }
 unsigned long foo_0x2000000000001(void) { return 0x2000000000001UL; }
 unsigned long foo_0x4000000000001(void) { return 0x4000000000001UL; }
 unsigned long foo_0x8000000000001(void) { return 0x8000000000001UL; }
 unsigned long foo_0x10000000000001(void) { return 0x10000000000001UL; }
 unsigned long foo_0x20000000000001(void) { return 0x20000000000001UL; }
 unsigned long foo_0x40000000000001(void) { return 0x40000000000001UL; }
 unsigned long foo_0x80000000000001(void) { return 0x80000000000001UL; }
 unsigned long foo_0x100000000000001(void) { return 0x100000000000001UL; }
 unsigned long foo_0x200000000000001(void) { return 0x200000000000001UL; }
 unsigned long foo_0x400000000000001(void) { return 0x400000000000001UL; }
 unsigned long foo_0x800000000000001(void) { return 0x800000000000001UL; }
 unsigned long foo_0x1000000000000001(void) { return 0x1000000000000001UL; }
 unsigned long foo_0x2000000000000001(void) { return 0x2000000000000001UL; }
 unsigned long foo_0x4000000000000001(void) { return 0x4000000000000001UL; }
 unsigned long foo_0x8000000000000001(void) { return 0x8000000000000001UL; }
 unsigned long foo_0x6(void) { return 0x6UL; }
 unsigned long foo_0xa(void) { return 0xaUL; }
 unsigned long foo_0x12(void) { return 0x12UL; }
 unsigned long foo_0x22(void) { return 0x22UL; }
 unsigned long foo_0x42(void) { return 0x42UL; }
 unsigned long foo_0x82(void) { return 0x82UL; }
 unsigned long foo_0x102(void) { return 0x102UL; }
 unsigned long foo_0x202(void) { return 0x202UL; }
 unsigned long foo_0x402(void) { return 0x402UL; }
 unsigned long foo_0x802(void) { return 0x802UL; }
 unsigned long foo_0x1002(void) { return 0x1002UL; }
 unsigned long foo_0x2002(void) { return 0x2002UL; }
 unsigned long foo_0x4002(void) { return 0x4002UL; }
 unsigned long foo_0x8002(void) { return 0x8002UL; }
 unsigned long foo_0x10002(void) { return 0x10002UL; }
 unsigned long foo_0x20002(void) { return 0x20002UL; }
 unsigned long foo_0x40002(void) { return 0x40002UL; }
 unsigned long foo_0x80002(void) { return 0x80002UL; }
 unsigned long foo_0x100002(void) { return 0x100002UL; }
 unsigned long foo_0x200002(void) { return 0x200002UL; }
 unsigned long foo_0x400002(void) { return 0x400002UL; }
 unsigned long foo_0x800002(void) { return 0x800002UL; }
 unsigned long foo_0x1000002(void) { return 0x1000002UL; }
 unsigned long foo_0x2000002(void) { return 0x2000002UL; }
 unsigned long foo_0x4000002(void) { return 0x4000002UL; }
 unsigned long foo_0x8000002(void) { return 0x8000002UL; }
 unsigned long foo_0x10000002(void) { return 0x10000002UL; }
 unsigned long foo_0x20000002(void) { return 0x20000002UL; }
 unsigned long foo_0x40000002(void) { return 0x40000002UL; }
 unsigned long foo_0x80000002(void) { return 0x80000002UL; }
 unsigned long foo_0x100000002(void) { return 0x100000002UL; }
 unsigned long foo_0x200000002(void) { return 0x200000002UL; }
 unsigned long foo_0x400000002(void) { return 0x400000002UL; }
 unsigned long foo_0x800000002(void) { return 0x800000002UL; }
 unsigned long foo_0x1000000002(void) { return 0x1000000002UL; }
 unsigned long foo_0x2000000002(void) { return 0x2000000002UL; }
 unsigned long foo_0x4000000002(void) { return 0x4000000002UL; }
 unsigned long foo_0x8000000002(void) { return 0x8000000002UL; }
 unsigned long foo_0x10000000002(void) { return 0x10000000002UL; }
 unsigned long foo_0x20000000002(void) { return 0x20000000002UL; }
 unsigned long foo_0x40000000002(void) { return 0x40000000002UL; }
 unsigned long foo_0x80000000002(void) { return 0x80000000002UL; }
 unsigned long foo_0x100000000002(void) { return 0x100000000002UL; }
 unsigned long foo_0x200000000002(void) { return 0x200000000002UL; }
 unsigned long foo_0x400000000002(void) { return 0x400000000002UL; }
 unsigned long foo_0x800000000002(void) { return 0x800000000002UL; }
 unsigned long foo_0x1000000000002(void) { return 0x1000000000002UL; }
 unsigned long foo_0x2000000000002(void) { return 0x2000000000002UL; }
 unsigned long foo_0x4000000000002(void) { return 0x4000000000002UL; }
 unsigned long foo_0x8000000000002(void) { return 0x8000000000002UL; }
 unsigned long foo_0x10000000000002(void) { return 0x10000000000002UL; }
 unsigned long foo_0x20000000000002(void) { return 0x20000000000002UL; }
 unsigned long foo_0x40000000000002(void) { return 0x40000000000002UL; }
 unsigned long foo_0x80000000000002(void) { return 0x80000000000002UL; }
 unsigned long foo_0x100000000000002(void) { return 0x100000000000002UL; }
 unsigned long foo_0x200000000000002(void) { return 0x200000000000002UL; }
 unsigned long foo_0x400000000000002(void) { return 0x400000000000002UL; }
 unsigned long foo_0x800000000000002(void) { return 0x800000000000002UL; }
 unsigned long foo_0x1000000000000002(void) { return 0x1000000000000002UL; }
 unsigned long foo_0x2000000000000002(void) { return 0x2000000000000002UL; }
 unsigned long foo_0x4000000000000002(void) { return 0x4000000000000002UL; }
 unsigned long foo_0x8000000000000002(void) { return 0x8000000000000002UL; }
 unsigned long foo_0xc(void) { return 0xcUL; }
 unsigned long foo_0x14(void) { return 0x14UL; }
 unsigned long foo_0x24(void) { return 0x24UL; }
 unsigned long foo_0x44(void) { return 0x44UL; }
 unsigned long foo_0x84(void) { return 0x84UL; }
 unsigned long foo_0x104(void) { return 0x104UL; }
 unsigned long foo_0x204(void) { return 0x204UL; }
 unsigned long foo_0x404(void) { return 0x404UL; }
 unsigned long foo_0x804(void) { return 0x804UL; }
 unsigned long foo_0x1004(void) { return 0x1004UL; }
 unsigned long foo_0x2004(void) { return 0x2004UL; }
 unsigned long foo_0x4004(void) { return 0x4004UL; }
 unsigned long foo_0x8004(void) { return 0x8004UL; }
 unsigned long foo_0x10004(void) { return 0x10004UL; }
 unsigned long foo_0x20004(void) { return 0x20004UL; }
 unsigned long foo_0x40004(void) { return 0x40004UL; }
 unsigned long foo_0x80004(void) { return 0x80004UL; }
 unsigned long foo_0x100004(void) { return 0x100004UL; }
 unsigned long foo_0x200004(void) { return 0x200004UL; }
 unsigned long foo_0x400004(void) { return 0x400004UL; }
 unsigned long foo_0x800004(void) { return 0x800004UL; }
 unsigned long foo_0x1000004(void) { return 0x1000004UL; }
 unsigned long foo_0x2000004(void) { return 0x2000004UL; }
 unsigned long foo_0x4000004(void) { return 0x4000004UL; }
 unsigned long foo_0x8000004(void) { return 0x8000004UL; }
 unsigned long foo_0x10000004(void) { return 0x10000004UL; }
 unsigned long foo_0x20000004(void) { return 0x20000004UL; }
 unsigned long foo_0x40000004(void) { return 0x40000004UL; }
 unsigned long foo_0x80000004(void) { return 0x80000004UL; }
 unsigned long foo_0x100000004(void) { return 0x100000004UL; }
 unsigned long foo_0x200000004(void) { return 0x200000004UL; }
 unsigned long foo_0x400000004(void) { return 0x400000004UL; }
 unsigned long foo_0x800000004(void) { return 0x800000004UL; }
 unsigned long foo_0x1000000004(void) { return 0x1000000004UL; }
 unsigned long foo_0x2000000004(void) { return 0x2000000004UL; }
 unsigned long foo_0x4000000004(void) { return 0x4000000004UL; }
 unsigned long foo_0x8000000004(void) { return 0x8000000004UL; }
 unsigned long foo_0x10000000004(void) { return 0x10000000004UL; }
 unsigned long foo_0x20000000004(void) { return 0x20000000004UL; }
 unsigned long foo_0x40000000004(void) { return 0x40000000004UL; }
 unsigned long foo_0x80000000004(void) { return 0x80000000004UL; }
 unsigned long foo_0x100000000004(void) { return 0x100000000004UL; }
 unsigned long foo_0x200000000004(void) { return 0x200000000004UL; }
 unsigned long foo_0x400000000004(void) { return 0x400000000004UL; }
 unsigned long foo_0x800000000004(void) { return 0x800000000004UL; }
 unsigned long foo_0x1000000000004(void) { return 0x1000000000004UL; }
 unsigned long foo_0x2000000000004(void) { return 0x2000000000004UL; }
 unsigned long foo_0x4000000000004(void) { return 0x4000000000004UL; }
 unsigned long foo_0x8000000000004(void) { return 0x8000000000004UL; }
 unsigned long foo_0x10000000000004(void) { return 0x10000000000004UL; }
 unsigned long foo_0x20000000000004(void) { return 0x20000000000004UL; }
 unsigned long foo_0x40000000000004(void) { return 0x40000000000004UL; }
 unsigned long foo_0x80000000000004(void) { return 0x80000000000004UL; }
 unsigned long foo_0x100000000000004(void) { return 0x100000000000004UL; }
 unsigned long foo_0x200000000000004(void) { return 0x200000000000004UL; }
 unsigned long foo_0x400000000000004(void) { return 0x400000000000004UL; }
 unsigned long foo_0x800000000000004(void) { return 0x800000000000004UL; }
 unsigned long foo_0x1000000000000004(void) { return 0x1000000000000004UL; }
 unsigned long foo_0x2000000000000004(void) { return 0x2000000000000004UL; }
 unsigned long foo_0x4000000000000004(void) { return 0x4000000000000004UL; }
 unsigned long foo_0x8000000000000004(void) { return 0x8000000000000004UL; }
 unsigned long foo_0x18(void) { return 0x18UL; }
 unsigned long foo_0x28(void) { return 0x28UL; }
 unsigned long foo_0x48(void) { return 0x48UL; }
 unsigned long foo_0x88(void) { return 0x88UL; }
 unsigned long foo_0x108(void) { return 0x108UL; }
 unsigned long foo_0x208(void) { return 0x208UL; }
 unsigned long foo_0x408(void) { return 0x408UL; }
 unsigned long foo_0x808(void) { return 0x808UL; }
 unsigned long foo_0x1008(void) { return 0x1008UL; }
 unsigned long foo_0x2008(void) { return 0x2008UL; }
 unsigned long foo_0x4008(void) { return 0x4008UL; }
 unsigned long foo_0x8008(void) { return 0x8008UL; }
 unsigned long foo_0x10008(void) { return 0x10008UL; }
 unsigned long foo_0x20008(void) { return 0x20008UL; }
 unsigned long foo_0x40008(void) { return 0x40008UL; }
 unsigned long foo_0x80008(void) { return 0x80008UL; }
 unsigned long foo_0x100008(void) { return 0x100008UL; }
 unsigned long foo_0x200008(void) { return 0x200008UL; }
 unsigned long foo_0x400008(void) { return 0x400008UL; }
 unsigned long foo_0x800008(void) { return 0x800008UL; }
 unsigned long foo_0x1000008(void) { return 0x1000008UL; }
 unsigned long foo_0x2000008(void) { return 0x2000008UL; }
 unsigned long foo_0x4000008(void) { return 0x4000008UL; }
 unsigned long foo_0x8000008(void) { return 0x8000008UL; }
 unsigned long foo_0x10000008(void) { return 0x10000008UL; }
 unsigned long foo_0x20000008(void) { return 0x20000008UL; }
 unsigned long foo_0x40000008(void) { return 0x40000008UL; }
 unsigned long foo_0x80000008(void) { return 0x80000008UL; }
 unsigned long foo_0x100000008(void) { return 0x100000008UL; }
 unsigned long foo_0x200000008(void) { return 0x200000008UL; }
 unsigned long foo_0x400000008(void) { return 0x400000008UL; }
 unsigned long foo_0x800000008(void) { return 0x800000008UL; }
 unsigned long foo_0x1000000008(void) { return 0x1000000008UL; }
 unsigned long foo_0x2000000008(void) { return 0x2000000008UL; }
 unsigned long foo_0x4000000008(void) { return 0x4000000008UL; }
 unsigned long foo_0x8000000008(void) { return 0x8000000008UL; }
 unsigned long foo_0x10000000008(void) { return 0x10000000008UL; }
 unsigned long foo_0x20000000008(void) { return 0x20000000008UL; }
 unsigned long foo_0x40000000008(void) { return 0x40000000008UL; }
 unsigned long foo_0x80000000008(void) { return 0x80000000008UL; }
 unsigned long foo_0x100000000008(void) { return 0x100000000008UL; }
 unsigned long foo_0x200000000008(void) { return 0x200000000008UL; }
 unsigned long foo_0x400000000008(void) { return 0x400000000008UL; }
 unsigned long foo_0x800000000008(void) { return 0x800000000008UL; }
 unsigned long foo_0x1000000000008(void) { return 0x1000000000008UL; }
 unsigned long foo_0x2000000000008(void) { return 0x2000000000008UL; }
 unsigned long foo_0x4000000000008(void) { return 0x4000000000008UL; }
 unsigned long foo_0x8000000000008(void) { return 0x8000000000008UL; }
 unsigned long foo_0x10000000000008(void) { return 0x10000000000008UL; }
 unsigned long foo_0x20000000000008(void) { return 0x20000000000008UL; }
 unsigned long foo_0x40000000000008(void) { return 0x40000000000008UL; }
 unsigned long foo_0x80000000000008(void) { return 0x80000000000008UL; }
 unsigned long foo_0x100000000000008(void) { return 0x100000000000008UL; }
 unsigned long foo_0x200000000000008(void) { return 0x200000000000008UL; }
 unsigned long foo_0x400000000000008(void) { return 0x400000000000008UL; }
 unsigned long foo_0x800000000000008(void) { return 0x800000000000008UL; }
 unsigned long foo_0x1000000000000008(void) { return 0x1000000000000008UL; }
 unsigned long foo_0x2000000000000008(void) { return 0x2000000000000008UL; }
 unsigned long foo_0x4000000000000008(void) { return 0x4000000000000008UL; }
 unsigned long foo_0x8000000000000008(void) { return 0x8000000000000008UL; }
 unsigned long foo_0x30(void) { return 0x30UL; }
 unsigned long foo_0x50(void) { return 0x50UL; }
 unsigned long foo_0x90(void) { return 0x90UL; }
 unsigned long foo_0x110(void) { return 0x110UL; }
 unsigned long foo_0x210(void) { return 0x210UL; }
 unsigned long foo_0x410(void) { return 0x410UL; }
 unsigned long foo_0x810(void) { return 0x810UL; }
 unsigned long foo_0x1010(void) { return 0x1010UL; }
 unsigned long foo_0x2010(void) { return 0x2010UL; }
 unsigned long foo_0x4010(void) { return 0x4010UL; }
 unsigned long foo_0x8010(void) { return 0x8010UL; }
 unsigned long foo_0x10010(void) { return 0x10010UL; }
 unsigned long foo_0x20010(void) { return 0x20010UL; }
 unsigned long foo_0x40010(void) { return 0x40010UL; }
 unsigned long foo_0x80010(void) { return 0x80010UL; }
 unsigned long foo_0x100010(void) { return 0x100010UL; }
 unsigned long foo_0x200010(void) { return 0x200010UL; }
 unsigned long foo_0x400010(void) { return 0x400010UL; }
 unsigned long foo_0x800010(void) { return 0x800010UL; }
 unsigned long foo_0x1000010(void) { return 0x1000010UL; }
 unsigned long foo_0x2000010(void) { return 0x2000010UL; }
 unsigned long foo_0x4000010(void) { return 0x4000010UL; }
 unsigned long foo_0x8000010(void) { return 0x8000010UL; }
 unsigned long foo_0x10000010(void) { return 0x10000010UL; }
 unsigned long foo_0x20000010(void) { return 0x20000010UL; }
 unsigned long foo_0x40000010(void) { return 0x40000010UL; }
 unsigned long foo_0x80000010(void) { return 0x80000010UL; }
 unsigned long foo_0x100000010(void) { return 0x100000010UL; }
 unsigned long foo_0x200000010(void) { return 0x200000010UL; }
 unsigned long foo_0x400000010(void) { return 0x400000010UL; }
 unsigned long foo_0x800000010(void) { return 0x800000010UL; }
 unsigned long foo_0x1000000010(void) { return 0x1000000010UL; }
 unsigned long foo_0x2000000010(void) { return 0x2000000010UL; }
 unsigned long foo_0x4000000010(void) { return 0x4000000010UL; }
 unsigned long foo_0x8000000010(void) { return 0x8000000010UL; }
 unsigned long foo_0x10000000010(void) { return 0x10000000010UL; }
 unsigned long foo_0x20000000010(void) { return 0x20000000010UL; }
 unsigned long foo_0x40000000010(void) { return 0x40000000010UL; }
 unsigned long foo_0x80000000010(void) { return 0x80000000010UL; }
 unsigned long foo_0x100000000010(void) { return 0x100000000010UL; }
 unsigned long foo_0x200000000010(void) { return 0x200000000010UL; }
 unsigned long foo_0x400000000010(void) { return 0x400000000010UL; }
 unsigned long foo_0x800000000010(void) { return 0x800000000010UL; }
 unsigned long foo_0x1000000000010(void) { return 0x1000000000010UL; }
 unsigned long foo_0x2000000000010(void) { return 0x2000000000010UL; }
 unsigned long foo_0x4000000000010(void) { return 0x4000000000010UL; }
 unsigned long foo_0x8000000000010(void) { return 0x8000000000010UL; }
 unsigned long foo_0x10000000000010(void) { return 0x10000000000010UL; }
 unsigned long foo_0x20000000000010(void) { return 0x20000000000010UL; }
 unsigned long foo_0x40000000000010(void) { return 0x40000000000010UL; }
 unsigned long foo_0x80000000000010(void) { return 0x80000000000010UL; }
 unsigned long foo_0x100000000000010(void) { return 0x100000000000010UL; }
 unsigned long foo_0x200000000000010(void) { return 0x200000000000010UL; }
 unsigned long foo_0x400000000000010(void) { return 0x400000000000010UL; }
 unsigned long foo_0x800000000000010(void) { return 0x800000000000010UL; }
 unsigned long foo_0x1000000000000010(void) { return 0x1000000000000010UL; }
 unsigned long foo_0x2000000000000010(void) { return 0x2000000000000010UL; }
 unsigned long foo_0x4000000000000010(void) { return 0x4000000000000010UL; }
 unsigned long foo_0x8000000000000010(void) { return 0x8000000000000010UL; }
 unsigned long foo_0x60(void) { return 0x60UL; }
 unsigned long foo_0xa0(void) { return 0xa0UL; }
 unsigned long foo_0x120(void) { return 0x120UL; }
 unsigned long foo_0x220(void) { return 0x220UL; }
 unsigned long foo_0x420(void) { return 0x420UL; }
 unsigned long foo_0x820(void) { return 0x820UL; }
 unsigned long foo_0x1020(void) { return 0x1020UL; }
 unsigned long foo_0x2020(void) { return 0x2020UL; }
 unsigned long foo_0x4020(void) { return 0x4020UL; }
 unsigned long foo_0x8020(void) { return 0x8020UL; }
 unsigned long foo_0x10020(void) { return 0x10020UL; }
 unsigned long foo_0x20020(void) { return 0x20020UL; }
 unsigned long foo_0x40020(void) { return 0x40020UL; }
 unsigned long foo_0x80020(void) { return 0x80020UL; }
 unsigned long foo_0x100020(void) { return 0x100020UL; }
 unsigned long foo_0x200020(void) { return 0x200020UL; }
 unsigned long foo_0x400020(void) { return 0x400020UL; }
 unsigned long foo_0x800020(void) { return 0x800020UL; }
 unsigned long foo_0x1000020(void) { return 0x1000020UL; }
 unsigned long foo_0x2000020(void) { return 0x2000020UL; }
 unsigned long foo_0x4000020(void) { return 0x4000020UL; }
 unsigned long foo_0x8000020(void) { return 0x8000020UL; }
 unsigned long foo_0x10000020(void) { return 0x10000020UL; }
 unsigned long foo_0x20000020(void) { return 0x20000020UL; }
 unsigned long foo_0x40000020(void) { return 0x40000020UL; }
 unsigned long foo_0x80000020(void) { return 0x80000020UL; }
 unsigned long foo_0x100000020(void) { return 0x100000020UL; }
 unsigned long foo_0x200000020(void) { return 0x200000020UL; }
 unsigned long foo_0x400000020(void) { return 0x400000020UL; }
 unsigned long foo_0x800000020(void) { return 0x800000020UL; }
 unsigned long foo_0x1000000020(void) { return 0x1000000020UL; }
 unsigned long foo_0x2000000020(void) { return 0x2000000020UL; }
 unsigned long foo_0x4000000020(void) { return 0x4000000020UL; }
 unsigned long foo_0x8000000020(void) { return 0x8000000020UL; }
 unsigned long foo_0x10000000020(void) { return 0x10000000020UL; }
 unsigned long foo_0x20000000020(void) { return 0x20000000020UL; }
 unsigned long foo_0x40000000020(void) { return 0x40000000020UL; }
 unsigned long foo_0x80000000020(void) { return 0x80000000020UL; }
 unsigned long foo_0x100000000020(void) { return 0x100000000020UL; }
 unsigned long foo_0x200000000020(void) { return 0x200000000020UL; }
 unsigned long foo_0x400000000020(void) { return 0x400000000020UL; }
 unsigned long foo_0x800000000020(void) { return 0x800000000020UL; }
 unsigned long foo_0x1000000000020(void) { return 0x1000000000020UL; }
 unsigned long foo_0x2000000000020(void) { return 0x2000000000020UL; }
 unsigned long foo_0x4000000000020(void) { return 0x4000000000020UL; }
 unsigned long foo_0x8000000000020(void) { return 0x8000000000020UL; }
 unsigned long foo_0x10000000000020(void) { return 0x10000000000020UL; }
 unsigned long foo_0x20000000000020(void) { return 0x20000000000020UL; }
 unsigned long foo_0x40000000000020(void) { return 0x40000000000020UL; }
 unsigned long foo_0x80000000000020(void) { return 0x80000000000020UL; }
 unsigned long foo_0x100000000000020(void) { return 0x100000000000020UL; }
 unsigned long foo_0x200000000000020(void) { return 0x200000000000020UL; }
 unsigned long foo_0x400000000000020(void) { return 0x400000000000020UL; }
 unsigned long foo_0x800000000000020(void) { return 0x800000000000020UL; }
 unsigned long foo_0x1000000000000020(void) { return 0x1000000000000020UL; }
 unsigned long foo_0x2000000000000020(void) { return 0x2000000000000020UL; }
 unsigned long foo_0x4000000000000020(void) { return 0x4000000000000020UL; }
 unsigned long foo_0x8000000000000020(void) { return 0x8000000000000020UL; }
 unsigned long foo_0xc0(void) { return 0xc0UL; }
 unsigned long foo_0x140(void) { return 0x140UL; }
 unsigned long foo_0x240(void) { return 0x240UL; }
 unsigned long foo_0x440(void) { return 0x440UL; }
 unsigned long foo_0x840(void) { return 0x840UL; }
 unsigned long foo_0x1040(void) { return 0x1040UL; }
 unsigned long foo_0x2040(void) { return 0x2040UL; }
 unsigned long foo_0x4040(void) { return 0x4040UL; }
 unsigned long foo_0x8040(void) { return 0x8040UL; }
 unsigned long foo_0x10040(void) { return 0x10040UL; }
 unsigned long foo_0x20040(void) { return 0x20040UL; }
 unsigned long foo_0x40040(void) { return 0x40040UL; }
 unsigned long foo_0x80040(void) { return 0x80040UL; }
 unsigned long foo_0x100040(void) { return 0x100040UL; }
 unsigned long foo_0x200040(void) { return 0x200040UL; }
 unsigned long foo_0x400040(void) { return 0x400040UL; }
 unsigned long foo_0x800040(void) { return 0x800040UL; }
 unsigned long foo_0x1000040(void) { return 0x1000040UL; }
 unsigned long foo_0x2000040(void) { return 0x2000040UL; }
 unsigned long foo_0x4000040(void) { return 0x4000040UL; }
 unsigned long foo_0x8000040(void) { return 0x8000040UL; }
 unsigned long foo_0x10000040(void) { return 0x10000040UL; }
 unsigned long foo_0x20000040(void) { return 0x20000040UL; }
 unsigned long foo_0x40000040(void) { return 0x40000040UL; }
 unsigned long foo_0x80000040(void) { return 0x80000040UL; }
 unsigned long foo_0x100000040(void) { return 0x100000040UL; }
 unsigned long foo_0x200000040(void) { return 0x200000040UL; }
 unsigned long foo_0x400000040(void) { return 0x400000040UL; }
 unsigned long foo_0x800000040(void) { return 0x800000040UL; }
 unsigned long foo_0x1000000040(void) { return 0x1000000040UL; }
 unsigned long foo_0x2000000040(void) { return 0x2000000040UL; }
 unsigned long foo_0x4000000040(void) { return 0x4000000040UL; }
 unsigned long foo_0x8000000040(void) { return 0x8000000040UL; }
 unsigned long foo_0x10000000040(void) { return 0x10000000040UL; }
 unsigned long foo_0x20000000040(void) { return 0x20000000040UL; }
 unsigned long foo_0x40000000040(void) { return 0x40000000040UL; }
 unsigned long foo_0x80000000040(void) { return 0x80000000040UL; }
 unsigned long foo_0x100000000040(void) { return 0x100000000040UL; }
 unsigned long foo_0x200000000040(void) { return 0x200000000040UL; }
 unsigned long foo_0x400000000040(void) { return 0x400000000040UL; }
 unsigned long foo_0x800000000040(void) { return 0x800000000040UL; }
 unsigned long foo_0x1000000000040(void) { return 0x1000000000040UL; }
 unsigned long foo_0x2000000000040(void) { return 0x2000000000040UL; }
 unsigned long foo_0x4000000000040(void) { return 0x4000000000040UL; }
 unsigned long foo_0x8000000000040(void) { return 0x8000000000040UL; }
 unsigned long foo_0x10000000000040(void) { return 0x10000000000040UL; }
 unsigned long foo_0x20000000000040(void) { return 0x20000000000040UL; }
 unsigned long foo_0x40000000000040(void) { return 0x40000000000040UL; }
 unsigned long foo_0x80000000000040(void) { return 0x80000000000040UL; }
 unsigned long foo_0x100000000000040(void) { return 0x100000000000040UL; }
 unsigned long foo_0x200000000000040(void) { return 0x200000000000040UL; }
 unsigned long foo_0x400000000000040(void) { return 0x400000000000040UL; }
 unsigned long foo_0x800000000000040(void) { return 0x800000000000040UL; }
 unsigned long foo_0x1000000000000040(void) { return 0x1000000000000040UL; }
 unsigned long foo_0x2000000000000040(void) { return 0x2000000000000040UL; }
 unsigned long foo_0x4000000000000040(void) { return 0x4000000000000040UL; }
 unsigned long foo_0x8000000000000040(void) { return 0x8000000000000040UL; }
 unsigned long foo_0x180(void) { return 0x180UL; }
 unsigned long foo_0x280(void) { return 0x280UL; }
 unsigned long foo_0x480(void) { return 0x480UL; }
 unsigned long foo_0x880(void) { return 0x880UL; }
 unsigned long foo_0x1080(void) { return 0x1080UL; }
 unsigned long foo_0x2080(void) { return 0x2080UL; }
 unsigned long foo_0x4080(void) { return 0x4080UL; }
 unsigned long foo_0x8080(void) { return 0x8080UL; }
 unsigned long foo_0x10080(void) { return 0x10080UL; }
 unsigned long foo_0x20080(void) { return 0x20080UL; }
 unsigned long foo_0x40080(void) { return 0x40080UL; }
 unsigned long foo_0x80080(void) { return 0x80080UL; }
 unsigned long foo_0x100080(void) { return 0x100080UL; }
 unsigned long foo_0x200080(void) { return 0x200080UL; }
 unsigned long foo_0x400080(void) { return 0x400080UL; }
 unsigned long foo_0x800080(void) { return 0x800080UL; }
 unsigned long foo_0x1000080(void) { return 0x1000080UL; }
 unsigned long foo_0x2000080(void) { return 0x2000080UL; }
 unsigned long foo_0x4000080(void) { return 0x4000080UL; }
 unsigned long foo_0x8000080(void) { return 0x8000080UL; }
 unsigned long foo_0x10000080(void) { return 0x10000080UL; }
 unsigned long foo_0x20000080(void) { return 0x20000080UL; }
 unsigned long foo_0x40000080(void) { return 0x40000080UL; }
 unsigned long foo_0x80000080(void) { return 0x80000080UL; }
 unsigned long foo_0x100000080(void) { return 0x100000080UL; }
 unsigned long foo_0x200000080(void) { return 0x200000080UL; }
 unsigned long foo_0x400000080(void) { return 0x400000080UL; }
 unsigned long foo_0x800000080(void) { return 0x800000080UL; }
 unsigned long foo_0x1000000080(void) { return 0x1000000080UL; }
 unsigned long foo_0x2000000080(void) { return 0x2000000080UL; }
 unsigned long foo_0x4000000080(void) { return 0x4000000080UL; }
 unsigned long foo_0x8000000080(void) { return 0x8000000080UL; }
 unsigned long foo_0x10000000080(void) { return 0x10000000080UL; }
 unsigned long foo_0x20000000080(void) { return 0x20000000080UL; }
 unsigned long foo_0x40000000080(void) { return 0x40000000080UL; }
 unsigned long foo_0x80000000080(void) { return 0x80000000080UL; }
 unsigned long foo_0x100000000080(void) { return 0x100000000080UL; }
 unsigned long foo_0x200000000080(void) { return 0x200000000080UL; }
 unsigned long foo_0x400000000080(void) { return 0x400000000080UL; }
 unsigned long foo_0x800000000080(void) { return 0x800000000080UL; }
 unsigned long foo_0x1000000000080(void) { return 0x1000000000080UL; }
 unsigned long foo_0x2000000000080(void) { return 0x2000000000080UL; }
 unsigned long foo_0x4000000000080(void) { return 0x4000000000080UL; }
 unsigned long foo_0x8000000000080(void) { return 0x8000000000080UL; }
 unsigned long foo_0x10000000000080(void) { return 0x10000000000080UL; }
 unsigned long foo_0x20000000000080(void) { return 0x20000000000080UL; }
 unsigned long foo_0x40000000000080(void) { return 0x40000000000080UL; }
 unsigned long foo_0x80000000000080(void) { return 0x80000000000080UL; }
 unsigned long foo_0x100000000000080(void) { return 0x100000000000080UL; }
 unsigned long foo_0x200000000000080(void) { return 0x200000000000080UL; }
 unsigned long foo_0x400000000000080(void) { return 0x400000000000080UL; }
 unsigned long foo_0x800000000000080(void) { return 0x800000000000080UL; }
 unsigned long foo_0x1000000000000080(void) { return 0x1000000000000080UL; }
 unsigned long foo_0x2000000000000080(void) { return 0x2000000000000080UL; }
 unsigned long foo_0x4000000000000080(void) { return 0x4000000000000080UL; }
 unsigned long foo_0x8000000000000080(void) { return 0x8000000000000080UL; }
 unsigned long foo_0x300(void) { return 0x300UL; }
 unsigned long foo_0x500(void) { return 0x500UL; }
 unsigned long foo_0x900(void) { return 0x900UL; }
 unsigned long foo_0x1100(void) { return 0x1100UL; }
 unsigned long foo_0x2100(void) { return 0x2100UL; }
 unsigned long foo_0x4100(void) { return 0x4100UL; }
 unsigned long foo_0x8100(void) { return 0x8100UL; }
 unsigned long foo_0x10100(void) { return 0x10100UL; }
 unsigned long foo_0x20100(void) { return 0x20100UL; }
 unsigned long foo_0x40100(void) { return 0x40100UL; }
 unsigned long foo_0x80100(void) { return 0x80100UL; }
 unsigned long foo_0x100100(void) { return 0x100100UL; }
 unsigned long foo_0x200100(void) { return 0x200100UL; }
 unsigned long foo_0x400100(void) { return 0x400100UL; }
 unsigned long foo_0x800100(void) { return 0x800100UL; }
 unsigned long foo_0x1000100(void) { return 0x1000100UL; }
 unsigned long foo_0x2000100(void) { return 0x2000100UL; }
 unsigned long foo_0x4000100(void) { return 0x4000100UL; }
 unsigned long foo_0x8000100(void) { return 0x8000100UL; }
 unsigned long foo_0x10000100(void) { return 0x10000100UL; }
 unsigned long foo_0x20000100(void) { return 0x20000100UL; }
 unsigned long foo_0x40000100(void) { return 0x40000100UL; }
 unsigned long foo_0x80000100(void) { return 0x80000100UL; }
 unsigned long foo_0x100000100(void) { return 0x100000100UL; }
 unsigned long foo_0x200000100(void) { return 0x200000100UL; }
 unsigned long foo_0x400000100(void) { return 0x400000100UL; }
 unsigned long foo_0x800000100(void) { return 0x800000100UL; }
 unsigned long foo_0x1000000100(void) { return 0x1000000100UL; }
 unsigned long foo_0x2000000100(void) { return 0x2000000100UL; }
 unsigned long foo_0x4000000100(void) { return 0x4000000100UL; }
 unsigned long foo_0x8000000100(void) { return 0x8000000100UL; }
 unsigned long foo_0x10000000100(void) { return 0x10000000100UL; }
 unsigned long foo_0x20000000100(void) { return 0x20000000100UL; }
 unsigned long foo_0x40000000100(void) { return 0x40000000100UL; }
 unsigned long foo_0x80000000100(void) { return 0x80000000100UL; }
 unsigned long foo_0x100000000100(void) { return 0x100000000100UL; }
 unsigned long foo_0x200000000100(void) { return 0x200000000100UL; }
 unsigned long foo_0x400000000100(void) { return 0x400000000100UL; }
 unsigned long foo_0x800000000100(void) { return 0x800000000100UL; }
 unsigned long foo_0x1000000000100(void) { return 0x1000000000100UL; }
 unsigned long foo_0x2000000000100(void) { return 0x2000000000100UL; }
 unsigned long foo_0x4000000000100(void) { return 0x4000000000100UL; }
 unsigned long foo_0x8000000000100(void) { return 0x8000000000100UL; }
 unsigned long foo_0x10000000000100(void) { return 0x10000000000100UL; }
 unsigned long foo_0x20000000000100(void) { return 0x20000000000100UL; }
 unsigned long foo_0x40000000000100(void) { return 0x40000000000100UL; }
 unsigned long foo_0x80000000000100(void) { return 0x80000000000100UL; }
 unsigned long foo_0x100000000000100(void) { return 0x100000000000100UL; }
 unsigned long foo_0x200000000000100(void) { return 0x200000000000100UL; }
 unsigned long foo_0x400000000000100(void) { return 0x400000000000100UL; }
 unsigned long foo_0x800000000000100(void) { return 0x800000000000100UL; }
 unsigned long foo_0x1000000000000100(void) { return 0x1000000000000100UL; }
 unsigned long foo_0x2000000000000100(void) { return 0x2000000000000100UL; }
 unsigned long foo_0x4000000000000100(void) { return 0x4000000000000100UL; }
 unsigned long foo_0x8000000000000100(void) { return 0x8000000000000100UL; }
 unsigned long foo_0x600(void) { return 0x600UL; }
 unsigned long foo_0xa00(void) { return 0xa00UL; }
 unsigned long foo_0x1200(void) { return 0x1200UL; }
 unsigned long foo_0x2200(void) { return 0x2200UL; }
 unsigned long foo_0x4200(void) { return 0x4200UL; }
 unsigned long foo_0x8200(void) { return 0x8200UL; }
 unsigned long foo_0x10200(void) { return 0x10200UL; }
 unsigned long foo_0x20200(void) { return 0x20200UL; }
 unsigned long foo_0x40200(void) { return 0x40200UL; }
 unsigned long foo_0x80200(void) { return 0x80200UL; }
 unsigned long foo_0x100200(void) { return 0x100200UL; }
 unsigned long foo_0x200200(void) { return 0x200200UL; }
 unsigned long foo_0x400200(void) { return 0x400200UL; }
 unsigned long foo_0x800200(void) { return 0x800200UL; }
 unsigned long foo_0x1000200(void) { return 0x1000200UL; }
 unsigned long foo_0x2000200(void) { return 0x2000200UL; }
 unsigned long foo_0x4000200(void) { return 0x4000200UL; }
 unsigned long foo_0x8000200(void) { return 0x8000200UL; }
 unsigned long foo_0x10000200(void) { return 0x10000200UL; }
 unsigned long foo_0x20000200(void) { return 0x20000200UL; }
 unsigned long foo_0x40000200(void) { return 0x40000200UL; }
 unsigned long foo_0x80000200(void) { return 0x80000200UL; }
 unsigned long foo_0x100000200(void) { return 0x100000200UL; }
 unsigned long foo_0x200000200(void) { return 0x200000200UL; }
 unsigned long foo_0x400000200(void) { return 0x400000200UL; }
 unsigned long foo_0x800000200(void) { return 0x800000200UL; }
 unsigned long foo_0x1000000200(void) { return 0x1000000200UL; }
 unsigned long foo_0x2000000200(void) { return 0x2000000200UL; }
 unsigned long foo_0x4000000200(void) { return 0x4000000200UL; }
 unsigned long foo_0x8000000200(void) { return 0x8000000200UL; }
 unsigned long foo_0x10000000200(void) { return 0x10000000200UL; }
 unsigned long foo_0x20000000200(void) { return 0x20000000200UL; }
 unsigned long foo_0x40000000200(void) { return 0x40000000200UL; }
 unsigned long foo_0x80000000200(void) { return 0x80000000200UL; }
 unsigned long foo_0x100000000200(void) { return 0x100000000200UL; }
 unsigned long foo_0x200000000200(void) { return 0x200000000200UL; }
 unsigned long foo_0x400000000200(void) { return 0x400000000200UL; }
 unsigned long foo_0x800000000200(void) { return 0x800000000200UL; }
 unsigned long foo_0x1000000000200(void) { return 0x1000000000200UL; }
 unsigned long foo_0x2000000000200(void) { return 0x2000000000200UL; }
 unsigned long foo_0x4000000000200(void) { return 0x4000000000200UL; }
 unsigned long foo_0x8000000000200(void) { return 0x8000000000200UL; }
 unsigned long foo_0x10000000000200(void) { return 0x10000000000200UL; }
 unsigned long foo_0x20000000000200(void) { return 0x20000000000200UL; }
 unsigned long foo_0x40000000000200(void) { return 0x40000000000200UL; }
 unsigned long foo_0x80000000000200(void) { return 0x80000000000200UL; }
 unsigned long foo_0x100000000000200(void) { return 0x100000000000200UL; }
 unsigned long foo_0x200000000000200(void) { return 0x200000000000200UL; }
 unsigned long foo_0x400000000000200(void) { return 0x400000000000200UL; }
 unsigned long foo_0x800000000000200(void) { return 0x800000000000200UL; }
 unsigned long foo_0x1000000000000200(void) { return 0x1000000000000200UL; }
 unsigned long foo_0x2000000000000200(void) { return 0x2000000000000200UL; }
 unsigned long foo_0x4000000000000200(void) { return 0x4000000000000200UL; }
 unsigned long foo_0x8000000000000200(void) { return 0x8000000000000200UL; }
 unsigned long foo_0xc00(void) { return 0xc00UL; }
 unsigned long foo_0x1400(void) { return 0x1400UL; }
 unsigned long foo_0x2400(void) { return 0x2400UL; }
 unsigned long foo_0x4400(void) { return 0x4400UL; }
 unsigned long foo_0x8400(void) { return 0x8400UL; }
 unsigned long foo_0x10400(void) { return 0x10400UL; }
 unsigned long foo_0x20400(void) { return 0x20400UL; }
 unsigned long foo_0x40400(void) { return 0x40400UL; }
 unsigned long foo_0x80400(void) { return 0x80400UL; }
 unsigned long foo_0x100400(void) { return 0x100400UL; }
 unsigned long foo_0x200400(void) { return 0x200400UL; }
 unsigned long foo_0x400400(void) { return 0x400400UL; }
 unsigned long foo_0x800400(void) { return 0x800400UL; }
 unsigned long foo_0x1000400(void) { return 0x1000400UL; }
 unsigned long foo_0x2000400(void) { return 0x2000400UL; }
 unsigned long foo_0x4000400(void) { return 0x4000400UL; }
 unsigned long foo_0x8000400(void) { return 0x8000400UL; }
 unsigned long foo_0x10000400(void) { return 0x10000400UL; }
 unsigned long foo_0x20000400(void) { return 0x20000400UL; }
 unsigned long foo_0x40000400(void) { return 0x40000400UL; }
 unsigned long foo_0x80000400(void) { return 0x80000400UL; }
 unsigned long foo_0x100000400(void) { return 0x100000400UL; }
 unsigned long foo_0x200000400(void) { return 0x200000400UL; }
 unsigned long foo_0x400000400(void) { return 0x400000400UL; }
 unsigned long foo_0x800000400(void) { return 0x800000400UL; }
 unsigned long foo_0x1000000400(void) { return 0x1000000400UL; }
 unsigned long foo_0x2000000400(void) { return 0x2000000400UL; }
 unsigned long foo_0x4000000400(void) { return 0x4000000400UL; }
 unsigned long foo_0x8000000400(void) { return 0x8000000400UL; }
 unsigned long foo_0x10000000400(void) { return 0x10000000400UL; }
 unsigned long foo_0x20000000400(void) { return 0x20000000400UL; }
 unsigned long foo_0x40000000400(void) { return 0x40000000400UL; }
 unsigned long foo_0x80000000400(void) { return 0x80000000400UL; }
 unsigned long foo_0x100000000400(void) { return 0x100000000400UL; }
 unsigned long foo_0x200000000400(void) { return 0x200000000400UL; }
 unsigned long foo_0x400000000400(void) { return 0x400000000400UL; }
 unsigned long foo_0x800000000400(void) { return 0x800000000400UL; }
 unsigned long foo_0x1000000000400(void) { return 0x1000000000400UL; }
 unsigned long foo_0x2000000000400(void) { return 0x2000000000400UL; }
 unsigned long foo_0x4000000000400(void) { return 0x4000000000400UL; }
 unsigned long foo_0x8000000000400(void) { return 0x8000000000400UL; }
 unsigned long foo_0x10000000000400(void) { return 0x10000000000400UL; }
 unsigned long foo_0x20000000000400(void) { return 0x20000000000400UL; }
 unsigned long foo_0x40000000000400(void) { return 0x40000000000400UL; }
 unsigned long foo_0x80000000000400(void) { return 0x80000000000400UL; }
 unsigned long foo_0x100000000000400(void) { return 0x100000000000400UL; }
 unsigned long foo_0x200000000000400(void) { return 0x200000000000400UL; }
 unsigned long foo_0x400000000000400(void) { return 0x400000000000400UL; }
 unsigned long foo_0x800000000000400(void) { return 0x800000000000400UL; }
 unsigned long foo_0x1000000000000400(void) { return 0x1000000000000400UL; }
 unsigned long foo_0x2000000000000400(void) { return 0x2000000000000400UL; }
 unsigned long foo_0x4000000000000400(void) { return 0x4000000000000400UL; }
 unsigned long foo_0x8000000000000400(void) { return 0x8000000000000400UL; }
 unsigned long foo_0x1800(void) { return 0x1800UL; }
 unsigned long foo_0x2800(void) { return 0x2800UL; }
 unsigned long foo_0x4800(void) { return 0x4800UL; }
 unsigned long foo_0x8800(void) { return 0x8800UL; }
 unsigned long foo_0x10800(void) { return 0x10800UL; }
 unsigned long foo_0x20800(void) { return 0x20800UL; }
 unsigned long foo_0x40800(void) { return 0x40800UL; }
 unsigned long foo_0x80800(void) { return 0x80800UL; }
 unsigned long foo_0x100800(void) { return 0x100800UL; }
 unsigned long foo_0x200800(void) { return 0x200800UL; }
 unsigned long foo_0x400800(void) { return 0x400800UL; }
 unsigned long foo_0x800800(void) { return 0x800800UL; }
 unsigned long foo_0x1000800(void) { return 0x1000800UL; }
 unsigned long foo_0x2000800(void) { return 0x2000800UL; }
 unsigned long foo_0x4000800(void) { return 0x4000800UL; }
 unsigned long foo_0x8000800(void) { return 0x8000800UL; }
 unsigned long foo_0x10000800(void) { return 0x10000800UL; }
 unsigned long foo_0x20000800(void) { return 0x20000800UL; }
 unsigned long foo_0x40000800(void) { return 0x40000800UL; }
 unsigned long foo_0x80000800(void) { return 0x80000800UL; }
 unsigned long foo_0x100000800(void) { return 0x100000800UL; }
 unsigned long foo_0x200000800(void) { return 0x200000800UL; }
 unsigned long foo_0x400000800(void) { return 0x400000800UL; }
 unsigned long foo_0x800000800(void) { return 0x800000800UL; }
 unsigned long foo_0x1000000800(void) { return 0x1000000800UL; }
 unsigned long foo_0x2000000800(void) { return 0x2000000800UL; }
 unsigned long foo_0x4000000800(void) { return 0x4000000800UL; }
 unsigned long foo_0x8000000800(void) { return 0x8000000800UL; }
 unsigned long foo_0x10000000800(void) { return 0x10000000800UL; }
 unsigned long foo_0x20000000800(void) { return 0x20000000800UL; }
 unsigned long foo_0x40000000800(void) { return 0x40000000800UL; }
 unsigned long foo_0x80000000800(void) { return 0x80000000800UL; }
 unsigned long foo_0x100000000800(void) { return 0x100000000800UL; }
 unsigned long foo_0x200000000800(void) { return 0x200000000800UL; }
 unsigned long foo_0x400000000800(void) { return 0x400000000800UL; }
 unsigned long foo_0x800000000800(void) { return 0x800000000800UL; }
 unsigned long foo_0x1000000000800(void) { return 0x1000000000800UL; }
 unsigned long foo_0x2000000000800(void) { return 0x2000000000800UL; }
 unsigned long foo_0x4000000000800(void) { return 0x4000000000800UL; }
 unsigned long foo_0x8000000000800(void) { return 0x8000000000800UL; }
 unsigned long foo_0x10000000000800(void) { return 0x10000000000800UL; }
 unsigned long foo_0x20000000000800(void) { return 0x20000000000800UL; }
 unsigned long foo_0x40000000000800(void) { return 0x40000000000800UL; }
 unsigned long foo_0x80000000000800(void) { return 0x80000000000800UL; }
 unsigned long foo_0x100000000000800(void) { return 0x100000000000800UL; }
 unsigned long foo_0x200000000000800(void) { return 0x200000000000800UL; }
 unsigned long foo_0x400000000000800(void) { return 0x400000000000800UL; }
 unsigned long foo_0x800000000000800(void) { return 0x800000000000800UL; }
 unsigned long foo_0x1000000000000800(void) { return 0x1000000000000800UL; }
 unsigned long foo_0x2000000000000800(void) { return 0x2000000000000800UL; }
 unsigned long foo_0x4000000000000800(void) { return 0x4000000000000800UL; }
 unsigned long foo_0x8000000000000800(void) { return 0x8000000000000800UL; }
 unsigned long foo_0x3000(void) { return 0x3000UL; }
 unsigned long foo_0x5000(void) { return 0x5000UL; }
 unsigned long foo_0x9000(void) { return 0x9000UL; }
 unsigned long foo_0x11000(void) { return 0x11000UL; }
 unsigned long foo_0x21000(void) { return 0x21000UL; }
 unsigned long foo_0x41000(void) { return 0x41000UL; }
 unsigned long foo_0x81000(void) { return 0x81000UL; }
 unsigned long foo_0x101000(void) { return 0x101000UL; }
 unsigned long foo_0x201000(void) { return 0x201000UL; }
 unsigned long foo_0x401000(void) { return 0x401000UL; }
 unsigned long foo_0x801000(void) { return 0x801000UL; }
 unsigned long foo_0x1001000(void) { return 0x1001000UL; }
 unsigned long foo_0x2001000(void) { return 0x2001000UL; }
 unsigned long foo_0x4001000(void) { return 0x4001000UL; }
 unsigned long foo_0x8001000(void) { return 0x8001000UL; }
 unsigned long foo_0x10001000(void) { return 0x10001000UL; }
 unsigned long foo_0x20001000(void) { return 0x20001000UL; }
 unsigned long foo_0x40001000(void) { return 0x40001000UL; }
 unsigned long foo_0x80001000(void) { return 0x80001000UL; }
 unsigned long foo_0x100001000(void) { return 0x100001000UL; }
 unsigned long foo_0x200001000(void) { return 0x200001000UL; }
 unsigned long foo_0x400001000(void) { return 0x400001000UL; }
 unsigned long foo_0x800001000(void) { return 0x800001000UL; }
 unsigned long foo_0x1000001000(void) { return 0x1000001000UL; }
 unsigned long foo_0x2000001000(void) { return 0x2000001000UL; }
 unsigned long foo_0x4000001000(void) { return 0x4000001000UL; }
 unsigned long foo_0x8000001000(void) { return 0x8000001000UL; }
 unsigned long foo_0x10000001000(void) { return 0x10000001000UL; }
 unsigned long foo_0x20000001000(void) { return 0x20000001000UL; }
 unsigned long foo_0x40000001000(void) { return 0x40000001000UL; }
 unsigned long foo_0x80000001000(void) { return 0x80000001000UL; }
 unsigned long foo_0x100000001000(void) { return 0x100000001000UL; }
 unsigned long foo_0x200000001000(void) { return 0x200000001000UL; }
 unsigned long foo_0x400000001000(void) { return 0x400000001000UL; }
 unsigned long foo_0x800000001000(void) { return 0x800000001000UL; }
 unsigned long foo_0x1000000001000(void) { return 0x1000000001000UL; }
 unsigned long foo_0x2000000001000(void) { return 0x2000000001000UL; }
 unsigned long foo_0x4000000001000(void) { return 0x4000000001000UL; }
 unsigned long foo_0x8000000001000(void) { return 0x8000000001000UL; }
 unsigned long foo_0x10000000001000(void) { return 0x10000000001000UL; }
 unsigned long foo_0x20000000001000(void) { return 0x20000000001000UL; }
 unsigned long foo_0x40000000001000(void) { return 0x40000000001000UL; }
 unsigned long foo_0x80000000001000(void) { return 0x80000000001000UL; }
 unsigned long foo_0x100000000001000(void) { return 0x100000000001000UL; }
 unsigned long foo_0x200000000001000(void) { return 0x200000000001000UL; }
 unsigned long foo_0x400000000001000(void) { return 0x400000000001000UL; }
 unsigned long foo_0x800000000001000(void) { return 0x800000000001000UL; }
 unsigned long foo_0x1000000000001000(void) { return 0x1000000000001000UL; }
 unsigned long foo_0x2000000000001000(void) { return 0x2000000000001000UL; }
 unsigned long foo_0x4000000000001000(void) { return 0x4000000000001000UL; }
 unsigned long foo_0x8000000000001000(void) { return 0x8000000000001000UL; }
 unsigned long foo_0x6000(void) { return 0x6000UL; }
 unsigned long foo_0xa000(void) { return 0xa000UL; }
 unsigned long foo_0x12000(void) { return 0x12000UL; }
 unsigned long foo_0x22000(void) { return 0x22000UL; }
 unsigned long foo_0x42000(void) { return 0x42000UL; }
 unsigned long foo_0x82000(void) { return 0x82000UL; }
 unsigned long foo_0x102000(void) { return 0x102000UL; }
 unsigned long foo_0x202000(void) { return 0x202000UL; }
 unsigned long foo_0x402000(void) { return 0x402000UL; }
 unsigned long foo_0x802000(void) { return 0x802000UL; }
 unsigned long foo_0x1002000(void) { return 0x1002000UL; }
 unsigned long foo_0x2002000(void) { return 0x2002000UL; }
 unsigned long foo_0x4002000(void) { return 0x4002000UL; }
 unsigned long foo_0x8002000(void) { return 0x8002000UL; }
 unsigned long foo_0x10002000(void) { return 0x10002000UL; }
 unsigned long foo_0x20002000(void) { return 0x20002000UL; }
 unsigned long foo_0x40002000(void) { return 0x40002000UL; }
 unsigned long foo_0x80002000(void) { return 0x80002000UL; }
 unsigned long foo_0x100002000(void) { return 0x100002000UL; }
 unsigned long foo_0x200002000(void) { return 0x200002000UL; }
 unsigned long foo_0x400002000(void) { return 0x400002000UL; }
 unsigned long foo_0x800002000(void) { return 0x800002000UL; }
 unsigned long foo_0x1000002000(void) { return 0x1000002000UL; }
 unsigned long foo_0x2000002000(void) { return 0x2000002000UL; }
 unsigned long foo_0x4000002000(void) { return 0x4000002000UL; }
 unsigned long foo_0x8000002000(void) { return 0x8000002000UL; }
 unsigned long foo_0x10000002000(void) { return 0x10000002000UL; }
 unsigned long foo_0x20000002000(void) { return 0x20000002000UL; }
 unsigned long foo_0x40000002000(void) { return 0x40000002000UL; }
 unsigned long foo_0x80000002000(void) { return 0x80000002000UL; }
 unsigned long foo_0x100000002000(void) { return 0x100000002000UL; }
 unsigned long foo_0x200000002000(void) { return 0x200000002000UL; }
 unsigned long foo_0x400000002000(void) { return 0x400000002000UL; }
 unsigned long foo_0x800000002000(void) { return 0x800000002000UL; }
 unsigned long foo_0x1000000002000(void) { return 0x1000000002000UL; }
 unsigned long foo_0x2000000002000(void) { return 0x2000000002000UL; }
 unsigned long foo_0x4000000002000(void) { return 0x4000000002000UL; }
 unsigned long foo_0x8000000002000(void) { return 0x8000000002000UL; }
 unsigned long foo_0x10000000002000(void) { return 0x10000000002000UL; }
 unsigned long foo_0x20000000002000(void) { return 0x20000000002000UL; }
 unsigned long foo_0x40000000002000(void) { return 0x40000000002000UL; }
 unsigned long foo_0x80000000002000(void) { return 0x80000000002000UL; }
 unsigned long foo_0x100000000002000(void) { return 0x100000000002000UL; }
 unsigned long foo_0x200000000002000(void) { return 0x200000000002000UL; }
 unsigned long foo_0x400000000002000(void) { return 0x400000000002000UL; }
 unsigned long foo_0x800000000002000(void) { return 0x800000000002000UL; }
 unsigned long foo_0x1000000000002000(void) { return 0x1000000000002000UL; }
 unsigned long foo_0x2000000000002000(void) { return 0x2000000000002000UL; }
 unsigned long foo_0x4000000000002000(void) { return 0x4000000000002000UL; }
 unsigned long foo_0x8000000000002000(void) { return 0x8000000000002000UL; }
 unsigned long foo_0xc000(void) { return 0xc000UL; }
 unsigned long foo_0x14000(void) { return 0x14000UL; }
 unsigned long foo_0x24000(void) { return 0x24000UL; }
 unsigned long foo_0x44000(void) { return 0x44000UL; }
 unsigned long foo_0x84000(void) { return 0x84000UL; }
 unsigned long foo_0x104000(void) { return 0x104000UL; }
 unsigned long foo_0x204000(void) { return 0x204000UL; }
 unsigned long foo_0x404000(void) { return 0x404000UL; }
 unsigned long foo_0x804000(void) { return 0x804000UL; }
 unsigned long foo_0x1004000(void) { return 0x1004000UL; }
 unsigned long foo_0x2004000(void) { return 0x2004000UL; }
 unsigned long foo_0x4004000(void) { return 0x4004000UL; }
 unsigned long foo_0x8004000(void) { return 0x8004000UL; }
 unsigned long foo_0x10004000(void) { return 0x10004000UL; }
 unsigned long foo_0x20004000(void) { return 0x20004000UL; }
 unsigned long foo_0x40004000(void) { return 0x40004000UL; }
 unsigned long foo_0x80004000(void) { return 0x80004000UL; }
 unsigned long foo_0x100004000(void) { return 0x100004000UL; }
 unsigned long foo_0x200004000(void) { return 0x200004000UL; }
 unsigned long foo_0x400004000(void) { return 0x400004000UL; }
 unsigned long foo_0x800004000(void) { return 0x800004000UL; }
 unsigned long foo_0x1000004000(void) { return 0x1000004000UL; }
 unsigned long foo_0x2000004000(void) { return 0x2000004000UL; }
 unsigned long foo_0x4000004000(void) { return 0x4000004000UL; }
 unsigned long foo_0x8000004000(void) { return 0x8000004000UL; }
 unsigned long foo_0x10000004000(void) { return 0x10000004000UL; }
 unsigned long foo_0x20000004000(void) { return 0x20000004000UL; }
 unsigned long foo_0x40000004000(void) { return 0x40000004000UL; }
 unsigned long foo_0x80000004000(void) { return 0x80000004000UL; }
 unsigned long foo_0x100000004000(void) { return 0x100000004000UL; }
 unsigned long foo_0x200000004000(void) { return 0x200000004000UL; }
 unsigned long foo_0x400000004000(void) { return 0x400000004000UL; }
 unsigned long foo_0x800000004000(void) { return 0x800000004000UL; }
 unsigned long foo_0x1000000004000(void) { return 0x1000000004000UL; }
 unsigned long foo_0x2000000004000(void) { return 0x2000000004000UL; }
 unsigned long foo_0x4000000004000(void) { return 0x4000000004000UL; }
 unsigned long foo_0x8000000004000(void) { return 0x8000000004000UL; }
 unsigned long foo_0x10000000004000(void) { return 0x10000000004000UL; }
 unsigned long foo_0x20000000004000(void) { return 0x20000000004000UL; }
 unsigned long foo_0x40000000004000(void) { return 0x40000000004000UL; }
 unsigned long foo_0x80000000004000(void) { return 0x80000000004000UL; }
 unsigned long foo_0x100000000004000(void) { return 0x100000000004000UL; }
 unsigned long foo_0x200000000004000(void) { return 0x200000000004000UL; }
 unsigned long foo_0x400000000004000(void) { return 0x400000000004000UL; }
 unsigned long foo_0x800000000004000(void) { return 0x800000000004000UL; }
 unsigned long foo_0x1000000000004000(void) { return 0x1000000000004000UL; }
 unsigned long foo_0x2000000000004000(void) { return 0x2000000000004000UL; }
 unsigned long foo_0x4000000000004000(void) { return 0x4000000000004000UL; }
 unsigned long foo_0x8000000000004000(void) { return 0x8000000000004000UL; }
 unsigned long foo_0x18000(void) { return 0x18000UL; }
 unsigned long foo_0x28000(void) { return 0x28000UL; }
 unsigned long foo_0x48000(void) { return 0x48000UL; }
 unsigned long foo_0x88000(void) { return 0x88000UL; }
 unsigned long foo_0x108000(void) { return 0x108000UL; }
 unsigned long foo_0x208000(void) { return 0x208000UL; }
 unsigned long foo_0x408000(void) { return 0x408000UL; }
 unsigned long foo_0x808000(void) { return 0x808000UL; }
 unsigned long foo_0x1008000(void) { return 0x1008000UL; }
 unsigned long foo_0x2008000(void) { return 0x2008000UL; }
 unsigned long foo_0x4008000(void) { return 0x4008000UL; }
 unsigned long foo_0x8008000(void) { return 0x8008000UL; }
 unsigned long foo_0x10008000(void) { return 0x10008000UL; }
 unsigned long foo_0x20008000(void) { return 0x20008000UL; }
 unsigned long foo_0x40008000(void) { return 0x40008000UL; }
 unsigned long foo_0x80008000(void) { return 0x80008000UL; }
 unsigned long foo_0x100008000(void) { return 0x100008000UL; }
 unsigned long foo_0x200008000(void) { return 0x200008000UL; }
 unsigned long foo_0x400008000(void) { return 0x400008000UL; }
 unsigned long foo_0x800008000(void) { return 0x800008000UL; }
 unsigned long foo_0x1000008000(void) { return 0x1000008000UL; }
 unsigned long foo_0x2000008000(void) { return 0x2000008000UL; }
 unsigned long foo_0x4000008000(void) { return 0x4000008000UL; }
 unsigned long foo_0x8000008000(void) { return 0x8000008000UL; }
 unsigned long foo_0x10000008000(void) { return 0x10000008000UL; }
 unsigned long foo_0x20000008000(void) { return 0x20000008000UL; }
 unsigned long foo_0x40000008000(void) { return 0x40000008000UL; }
 unsigned long foo_0x80000008000(void) { return 0x80000008000UL; }
 unsigned long foo_0x100000008000(void) { return 0x100000008000UL; }
 unsigned long foo_0x200000008000(void) { return 0x200000008000UL; }
 unsigned long foo_0x400000008000(void) { return 0x400000008000UL; }
 unsigned long foo_0x800000008000(void) { return 0x800000008000UL; }
 unsigned long foo_0x1000000008000(void) { return 0x1000000008000UL; }
 unsigned long foo_0x2000000008000(void) { return 0x2000000008000UL; }
 unsigned long foo_0x4000000008000(void) { return 0x4000000008000UL; }
 unsigned long foo_0x8000000008000(void) { return 0x8000000008000UL; }
 unsigned long foo_0x10000000008000(void) { return 0x10000000008000UL; }
 unsigned long foo_0x20000000008000(void) { return 0x20000000008000UL; }
 unsigned long foo_0x40000000008000(void) { return 0x40000000008000UL; }
 unsigned long foo_0x80000000008000(void) { return 0x80000000008000UL; }
 unsigned long foo_0x100000000008000(void) { return 0x100000000008000UL; }
 unsigned long foo_0x200000000008000(void) { return 0x200000000008000UL; }
 unsigned long foo_0x400000000008000(void) { return 0x400000000008000UL; }
 unsigned long foo_0x800000000008000(void) { return 0x800000000008000UL; }
 unsigned long foo_0x1000000000008000(void) { return 0x1000000000008000UL; }
 unsigned long foo_0x2000000000008000(void) { return 0x2000000000008000UL; }
 unsigned long foo_0x4000000000008000(void) { return 0x4000000000008000UL; }
 unsigned long foo_0x8000000000008000(void) { return 0x8000000000008000UL; }
 unsigned long foo_0x30000(void) { return 0x30000UL; }
 unsigned long foo_0x50000(void) { return 0x50000UL; }
 unsigned long foo_0x90000(void) { return 0x90000UL; }
 unsigned long foo_0x110000(void) { return 0x110000UL; }
 unsigned long foo_0x210000(void) { return 0x210000UL; }
 unsigned long foo_0x410000(void) { return 0x410000UL; }
 unsigned long foo_0x810000(void) { return 0x810000UL; }
 unsigned long foo_0x1010000(void) { return 0x1010000UL; }
 unsigned long foo_0x2010000(void) { return 0x2010000UL; }
 unsigned long foo_0x4010000(void) { return 0x4010000UL; }
 unsigned long foo_0x8010000(void) { return 0x8010000UL; }
 unsigned long foo_0x10010000(void) { return 0x10010000UL; }
 unsigned long foo_0x20010000(void) { return 0x20010000UL; }
 unsigned long foo_0x40010000(void) { return 0x40010000UL; }
 unsigned long foo_0x80010000(void) { return 0x80010000UL; }
 unsigned long foo_0x100010000(void) { return 0x100010000UL; }
 unsigned long foo_0x200010000(void) { return 0x200010000UL; }
 unsigned long foo_0x400010000(void) { return 0x400010000UL; }
 unsigned long foo_0x800010000(void) { return 0x800010000UL; }
 unsigned long foo_0x1000010000(void) { return 0x1000010000UL; }
 unsigned long foo_0x2000010000(void) { return 0x2000010000UL; }
 unsigned long foo_0x4000010000(void) { return 0x4000010000UL; }
 unsigned long foo_0x8000010000(void) { return 0x8000010000UL; }
 unsigned long foo_0x10000010000(void) { return 0x10000010000UL; }
 unsigned long foo_0x20000010000(void) { return 0x20000010000UL; }
 unsigned long foo_0x40000010000(void) { return 0x40000010000UL; }
 unsigned long foo_0x80000010000(void) { return 0x80000010000UL; }
 unsigned long foo_0x100000010000(void) { return 0x100000010000UL; }
 unsigned long foo_0x200000010000(void) { return 0x200000010000UL; }
 unsigned long foo_0x400000010000(void) { return 0x400000010000UL; }
 unsigned long foo_0x800000010000(void) { return 0x800000010000UL; }
 unsigned long foo_0x1000000010000(void) { return 0x1000000010000UL; }
 unsigned long foo_0x2000000010000(void) { return 0x2000000010000UL; }
 unsigned long foo_0x4000000010000(void) { return 0x4000000010000UL; }
 unsigned long foo_0x8000000010000(void) { return 0x8000000010000UL; }
 unsigned long foo_0x10000000010000(void) { return 0x10000000010000UL; }
 unsigned long foo_0x20000000010000(void) { return 0x20000000010000UL; }
 unsigned long foo_0x40000000010000(void) { return 0x40000000010000UL; }
 unsigned long foo_0x80000000010000(void) { return 0x80000000010000UL; }
 unsigned long foo_0x100000000010000(void) { return 0x100000000010000UL; }
 unsigned long foo_0x200000000010000(void) { return 0x200000000010000UL; }
 unsigned long foo_0x400000000010000(void) { return 0x400000000010000UL; }
 unsigned long foo_0x800000000010000(void) { return 0x800000000010000UL; }
 unsigned long foo_0x1000000000010000(void) { return 0x1000000000010000UL; }
 unsigned long foo_0x2000000000010000(void) { return 0x2000000000010000UL; }
 unsigned long foo_0x4000000000010000(void) { return 0x4000000000010000UL; }
 unsigned long foo_0x8000000000010000(void) { return 0x8000000000010000UL; }
 unsigned long foo_0x60000(void) { return 0x60000UL; }
 unsigned long foo_0xa0000(void) { return 0xa0000UL; }
 unsigned long foo_0x120000(void) { return 0x120000UL; }
 unsigned long foo_0x220000(void) { return 0x220000UL; }
 unsigned long foo_0x420000(void) { return 0x420000UL; }
 unsigned long foo_0x820000(void) { return 0x820000UL; }
 unsigned long foo_0x1020000(void) { return 0x1020000UL; }
 unsigned long foo_0x2020000(void) { return 0x2020000UL; }
 unsigned long foo_0x4020000(void) { return 0x4020000UL; }
 unsigned long foo_0x8020000(void) { return 0x8020000UL; }
 unsigned long foo_0x10020000(void) { return 0x10020000UL; }
 unsigned long foo_0x20020000(void) { return 0x20020000UL; }
 unsigned long foo_0x40020000(void) { return 0x40020000UL; }
 unsigned long foo_0x80020000(void) { return 0x80020000UL; }
 unsigned long foo_0x100020000(void) { return 0x100020000UL; }
 unsigned long foo_0x200020000(void) { return 0x200020000UL; }
 unsigned long foo_0x400020000(void) { return 0x400020000UL; }
 unsigned long foo_0x800020000(void) { return 0x800020000UL; }
 unsigned long foo_0x1000020000(void) { return 0x1000020000UL; }
 unsigned long foo_0x2000020000(void) { return 0x2000020000UL; }
 unsigned long foo_0x4000020000(void) { return 0x4000020000UL; }
 unsigned long foo_0x8000020000(void) { return 0x8000020000UL; }
 unsigned long foo_0x10000020000(void) { return 0x10000020000UL; }
 unsigned long foo_0x20000020000(void) { return 0x20000020000UL; }
 unsigned long foo_0x40000020000(void) { return 0x40000020000UL; }
 unsigned long foo_0x80000020000(void) { return 0x80000020000UL; }
 unsigned long foo_0x100000020000(void) { return 0x100000020000UL; }
 unsigned long foo_0x200000020000(void) { return 0x200000020000UL; }
 unsigned long foo_0x400000020000(void) { return 0x400000020000UL; }
 unsigned long foo_0x800000020000(void) { return 0x800000020000UL; }
 unsigned long foo_0x1000000020000(void) { return 0x1000000020000UL; }
 unsigned long foo_0x2000000020000(void) { return 0x2000000020000UL; }
 unsigned long foo_0x4000000020000(void) { return 0x4000000020000UL; }
 unsigned long foo_0x8000000020000(void) { return 0x8000000020000UL; }
 unsigned long foo_0x10000000020000(void) { return 0x10000000020000UL; }
 unsigned long foo_0x20000000020000(void) { return 0x20000000020000UL; }
 unsigned long foo_0x40000000020000(void) { return 0x40000000020000UL; }
 unsigned long foo_0x80000000020000(void) { return 0x80000000020000UL; }
 unsigned long foo_0x100000000020000(void) { return 0x100000000020000UL; }
 unsigned long foo_0x200000000020000(void) { return 0x200000000020000UL; }
 unsigned long foo_0x400000000020000(void) { return 0x400000000020000UL; }
 unsigned long foo_0x800000000020000(void) { return 0x800000000020000UL; }
 unsigned long foo_0x1000000000020000(void) { return 0x1000000000020000UL; }
 unsigned long foo_0x2000000000020000(void) { return 0x2000000000020000UL; }
 unsigned long foo_0x4000000000020000(void) { return 0x4000000000020000UL; }
 unsigned long foo_0x8000000000020000(void) { return 0x8000000000020000UL; }
 unsigned long foo_0xc0000(void) { return 0xc0000UL; }
 unsigned long foo_0x140000(void) { return 0x140000UL; }
 unsigned long foo_0x240000(void) { return 0x240000UL; }
 unsigned long foo_0x440000(void) { return 0x440000UL; }
 unsigned long foo_0x840000(void) { return 0x840000UL; }
 unsigned long foo_0x1040000(void) { return 0x1040000UL; }
 unsigned long foo_0x2040000(void) { return 0x2040000UL; }
 unsigned long foo_0x4040000(void) { return 0x4040000UL; }
 unsigned long foo_0x8040000(void) { return 0x8040000UL; }
 unsigned long foo_0x10040000(void) { return 0x10040000UL; }
 unsigned long foo_0x20040000(void) { return 0x20040000UL; }
 unsigned long foo_0x40040000(void) { return 0x40040000UL; }
 unsigned long foo_0x80040000(void) { return 0x80040000UL; }
 unsigned long foo_0x100040000(void) { return 0x100040000UL; }
 unsigned long foo_0x200040000(void) { return 0x200040000UL; }
 unsigned long foo_0x400040000(void) { return 0x400040000UL; }
 unsigned long foo_0x800040000(void) { return 0x800040000UL; }
 unsigned long foo_0x1000040000(void) { return 0x1000040000UL; }
 unsigned long foo_0x2000040000(void) { return 0x2000040000UL; }
 unsigned long foo_0x4000040000(void) { return 0x4000040000UL; }
 unsigned long foo_0x8000040000(void) { return 0x8000040000UL; }
 unsigned long foo_0x10000040000(void) { return 0x10000040000UL; }
 unsigned long foo_0x20000040000(void) { return 0x20000040000UL; }
 unsigned long foo_0x40000040000(void) { return 0x40000040000UL; }
 unsigned long foo_0x80000040000(void) { return 0x80000040000UL; }
 unsigned long foo_0x100000040000(void) { return 0x100000040000UL; }
 unsigned long foo_0x200000040000(void) { return 0x200000040000UL; }
 unsigned long foo_0x400000040000(void) { return 0x400000040000UL; }
 unsigned long foo_0x800000040000(void) { return 0x800000040000UL; }
 unsigned long foo_0x1000000040000(void) { return 0x1000000040000UL; }
 unsigned long foo_0x2000000040000(void) { return 0x2000000040000UL; }
 unsigned long foo_0x4000000040000(void) { return 0x4000000040000UL; }
 unsigned long foo_0x8000000040000(void) { return 0x8000000040000UL; }
 unsigned long foo_0x10000000040000(void) { return 0x10000000040000UL; }
 unsigned long foo_0x20000000040000(void) { return 0x20000000040000UL; }
 unsigned long foo_0x40000000040000(void) { return 0x40000000040000UL; }
 unsigned long foo_0x80000000040000(void) { return 0x80000000040000UL; }
 unsigned long foo_0x100000000040000(void) { return 0x100000000040000UL; }
 unsigned long foo_0x200000000040000(void) { return 0x200000000040000UL; }
 unsigned long foo_0x400000000040000(void) { return 0x400000000040000UL; }
 unsigned long foo_0x800000000040000(void) { return 0x800000000040000UL; }
 unsigned long foo_0x1000000000040000(void) { return 0x1000000000040000UL; }
 unsigned long foo_0x2000000000040000(void) { return 0x2000000000040000UL; }
 unsigned long foo_0x4000000000040000(void) { return 0x4000000000040000UL; }
 unsigned long foo_0x8000000000040000(void) { return 0x8000000000040000UL; }
 unsigned long foo_0x180000(void) { return 0x180000UL; }
 unsigned long foo_0x280000(void) { return 0x280000UL; }
 unsigned long foo_0x480000(void) { return 0x480000UL; }
 unsigned long foo_0x880000(void) { return 0x880000UL; }
 unsigned long foo_0x1080000(void) { return 0x1080000UL; }
 unsigned long foo_0x2080000(void) { return 0x2080000UL; }
 unsigned long foo_0x4080000(void) { return 0x4080000UL; }
 unsigned long foo_0x8080000(void) { return 0x8080000UL; }
 unsigned long foo_0x10080000(void) { return 0x10080000UL; }
 unsigned long foo_0x20080000(void) { return 0x20080000UL; }
 unsigned long foo_0x40080000(void) { return 0x40080000UL; }
 unsigned long foo_0x80080000(void) { return 0x80080000UL; }
 unsigned long foo_0x100080000(void) { return 0x100080000UL; }
 unsigned long foo_0x200080000(void) { return 0x200080000UL; }
 unsigned long foo_0x400080000(void) { return 0x400080000UL; }
 unsigned long foo_0x800080000(void) { return 0x800080000UL; }
 unsigned long foo_0x1000080000(void) { return 0x1000080000UL; }
 unsigned long foo_0x2000080000(void) { return 0x2000080000UL; }
 unsigned long foo_0x4000080000(void) { return 0x4000080000UL; }
 unsigned long foo_0x8000080000(void) { return 0x8000080000UL; }
 unsigned long foo_0x10000080000(void) { return 0x10000080000UL; }
 unsigned long foo_0x20000080000(void) { return 0x20000080000UL; }
 unsigned long foo_0x40000080000(void) { return 0x40000080000UL; }
 unsigned long foo_0x80000080000(void) { return 0x80000080000UL; }
 unsigned long foo_0x100000080000(void) { return 0x100000080000UL; }
 unsigned long foo_0x200000080000(void) { return 0x200000080000UL; }
 unsigned long foo_0x400000080000(void) { return 0x400000080000UL; }
 unsigned long foo_0x800000080000(void) { return 0x800000080000UL; }
 unsigned long foo_0x1000000080000(void) { return 0x1000000080000UL; }
 unsigned long foo_0x2000000080000(void) { return 0x2000000080000UL; }
 unsigned long foo_0x4000000080000(void) { return 0x4000000080000UL; }
 unsigned long foo_0x8000000080000(void) { return 0x8000000080000UL; }
 unsigned long foo_0x10000000080000(void) { return 0x10000000080000UL; }
 unsigned long foo_0x20000000080000(void) { return 0x20000000080000UL; }
 unsigned long foo_0x40000000080000(void) { return 0x40000000080000UL; }
 unsigned long foo_0x80000000080000(void) { return 0x80000000080000UL; }
 unsigned long foo_0x100000000080000(void) { return 0x100000000080000UL; }
 unsigned long foo_0x200000000080000(void) { return 0x200000000080000UL; }
 unsigned long foo_0x400000000080000(void) { return 0x400000000080000UL; }
 unsigned long foo_0x800000000080000(void) { return 0x800000000080000UL; }
 unsigned long foo_0x1000000000080000(void) { return 0x1000000000080000UL; }
 unsigned long foo_0x2000000000080000(void) { return 0x2000000000080000UL; }
 unsigned long foo_0x4000000000080000(void) { return 0x4000000000080000UL; }
 unsigned long foo_0x8000000000080000(void) { return 0x8000000000080000UL; }
 unsigned long foo_0x300000(void) { return 0x300000UL; }
 unsigned long foo_0x500000(void) { return 0x500000UL; }
 unsigned long foo_0x900000(void) { return 0x900000UL; }
 unsigned long foo_0x1100000(void) { return 0x1100000UL; }
 unsigned long foo_0x2100000(void) { return 0x2100000UL; }
 unsigned long foo_0x4100000(void) { return 0x4100000UL; }
 unsigned long foo_0x8100000(void) { return 0x8100000UL; }
 unsigned long foo_0x10100000(void) { return 0x10100000UL; }
 unsigned long foo_0x20100000(void) { return 0x20100000UL; }
 unsigned long foo_0x40100000(void) { return 0x40100000UL; }
 unsigned long foo_0x80100000(void) { return 0x80100000UL; }
 unsigned long foo_0x100100000(void) { return 0x100100000UL; }
 unsigned long foo_0x200100000(void) { return 0x200100000UL; }
 unsigned long foo_0x400100000(void) { return 0x400100000UL; }
 unsigned long foo_0x800100000(void) { return 0x800100000UL; }
 unsigned long foo_0x1000100000(void) { return 0x1000100000UL; }
 unsigned long foo_0x2000100000(void) { return 0x2000100000UL; }
 unsigned long foo_0x4000100000(void) { return 0x4000100000UL; }
 unsigned long foo_0x8000100000(void) { return 0x8000100000UL; }
 unsigned long foo_0x10000100000(void) { return 0x10000100000UL; }
 unsigned long foo_0x20000100000(void) { return 0x20000100000UL; }
 unsigned long foo_0x40000100000(void) { return 0x40000100000UL; }
 unsigned long foo_0x80000100000(void) { return 0x80000100000UL; }
 unsigned long foo_0x100000100000(void) { return 0x100000100000UL; }
 unsigned long foo_0x200000100000(void) { return 0x200000100000UL; }
 unsigned long foo_0x400000100000(void) { return 0x400000100000UL; }
 unsigned long foo_0x800000100000(void) { return 0x800000100000UL; }
 unsigned long foo_0x1000000100000(void) { return 0x1000000100000UL; }
 unsigned long foo_0x2000000100000(void) { return 0x2000000100000UL; }
 unsigned long foo_0x4000000100000(void) { return 0x4000000100000UL; }
 unsigned long foo_0x8000000100000(void) { return 0x8000000100000UL; }
 unsigned long foo_0x10000000100000(void) { return 0x10000000100000UL; }
 unsigned long foo_0x20000000100000(void) { return 0x20000000100000UL; }
 unsigned long foo_0x40000000100000(void) { return 0x40000000100000UL; }
 unsigned long foo_0x80000000100000(void) { return 0x80000000100000UL; }
 unsigned long foo_0x100000000100000(void) { return 0x100000000100000UL; }
 unsigned long foo_0x200000000100000(void) { return 0x200000000100000UL; }
 unsigned long foo_0x400000000100000(void) { return 0x400000000100000UL; }
 unsigned long foo_0x800000000100000(void) { return 0x800000000100000UL; }
 unsigned long foo_0x1000000000100000(void) { return 0x1000000000100000UL; }
 unsigned long foo_0x2000000000100000(void) { return 0x2000000000100000UL; }
 unsigned long foo_0x4000000000100000(void) { return 0x4000000000100000UL; }
 unsigned long foo_0x8000000000100000(void) { return 0x8000000000100000UL; }
 unsigned long foo_0x600000(void) { return 0x600000UL; }
 unsigned long foo_0xa00000(void) { return 0xa00000UL; }
 unsigned long foo_0x1200000(void) { return 0x1200000UL; }
 unsigned long foo_0x2200000(void) { return 0x2200000UL; }
 unsigned long foo_0x4200000(void) { return 0x4200000UL; }
 unsigned long foo_0x8200000(void) { return 0x8200000UL; }
 unsigned long foo_0x10200000(void) { return 0x10200000UL; }
 unsigned long foo_0x20200000(void) { return 0x20200000UL; }
 unsigned long foo_0x40200000(void) { return 0x40200000UL; }
 unsigned long foo_0x80200000(void) { return 0x80200000UL; }
 unsigned long foo_0x100200000(void) { return 0x100200000UL; }
 unsigned long foo_0x200200000(void) { return 0x200200000UL; }
 unsigned long foo_0x400200000(void) { return 0x400200000UL; }
 unsigned long foo_0x800200000(void) { return 0x800200000UL; }
 unsigned long foo_0x1000200000(void) { return 0x1000200000UL; }
 unsigned long foo_0x2000200000(void) { return 0x2000200000UL; }
 unsigned long foo_0x4000200000(void) { return 0x4000200000UL; }
 unsigned long foo_0x8000200000(void) { return 0x8000200000UL; }
 unsigned long foo_0x10000200000(void) { return 0x10000200000UL; }
 unsigned long foo_0x20000200000(void) { return 0x20000200000UL; }
 unsigned long foo_0x40000200000(void) { return 0x40000200000UL; }
 unsigned long foo_0x80000200000(void) { return 0x80000200000UL; }
 unsigned long foo_0x100000200000(void) { return 0x100000200000UL; }
 unsigned long foo_0x200000200000(void) { return 0x200000200000UL; }
 unsigned long foo_0x400000200000(void) { return 0x400000200000UL; }
 unsigned long foo_0x800000200000(void) { return 0x800000200000UL; }
 unsigned long foo_0x1000000200000(void) { return 0x1000000200000UL; }
 unsigned long foo_0x2000000200000(void) { return 0x2000000200000UL; }
 unsigned long foo_0x4000000200000(void) { return 0x4000000200000UL; }
 unsigned long foo_0x8000000200000(void) { return 0x8000000200000UL; }
 unsigned long foo_0x10000000200000(void) { return 0x10000000200000UL; }
 unsigned long foo_0x20000000200000(void) { return 0x20000000200000UL; }
 unsigned long foo_0x40000000200000(void) { return 0x40000000200000UL; }
 unsigned long foo_0x80000000200000(void) { return 0x80000000200000UL; }
 unsigned long foo_0x100000000200000(void) { return 0x100000000200000UL; }
 unsigned long foo_0x200000000200000(void) { return 0x200000000200000UL; }
 unsigned long foo_0x400000000200000(void) { return 0x400000000200000UL; }
 unsigned long foo_0x800000000200000(void) { return 0x800000000200000UL; }
 unsigned long foo_0x1000000000200000(void) { return 0x1000000000200000UL; }
 unsigned long foo_0x2000000000200000(void) { return 0x2000000000200000UL; }
 unsigned long foo_0x4000000000200000(void) { return 0x4000000000200000UL; }
 unsigned long foo_0x8000000000200000(void) { return 0x8000000000200000UL; }
 unsigned long foo_0xc00000(void) { return 0xc00000UL; }
 unsigned long foo_0x1400000(void) { return 0x1400000UL; }
 unsigned long foo_0x2400000(void) { return 0x2400000UL; }
 unsigned long foo_0x4400000(void) { return 0x4400000UL; }
 unsigned long foo_0x8400000(void) { return 0x8400000UL; }
 unsigned long foo_0x10400000(void) { return 0x10400000UL; }
 unsigned long foo_0x20400000(void) { return 0x20400000UL; }
 unsigned long foo_0x40400000(void) { return 0x40400000UL; }
 unsigned long foo_0x80400000(void) { return 0x80400000UL; }
 unsigned long foo_0x100400000(void) { return 0x100400000UL; }
 unsigned long foo_0x200400000(void) { return 0x200400000UL; }
 unsigned long foo_0x400400000(void) { return 0x400400000UL; }
 unsigned long foo_0x800400000(void) { return 0x800400000UL; }
 unsigned long foo_0x1000400000(void) { return 0x1000400000UL; }
 unsigned long foo_0x2000400000(void) { return 0x2000400000UL; }
 unsigned long foo_0x4000400000(void) { return 0x4000400000UL; }
 unsigned long foo_0x8000400000(void) { return 0x8000400000UL; }
 unsigned long foo_0x10000400000(void) { return 0x10000400000UL; }
 unsigned long foo_0x20000400000(void) { return 0x20000400000UL; }
 unsigned long foo_0x40000400000(void) { return 0x40000400000UL; }
 unsigned long foo_0x80000400000(void) { return 0x80000400000UL; }
 unsigned long foo_0x100000400000(void) { return 0x100000400000UL; }
 unsigned long foo_0x200000400000(void) { return 0x200000400000UL; }
 unsigned long foo_0x400000400000(void) { return 0x400000400000UL; }
 unsigned long foo_0x800000400000(void) { return 0x800000400000UL; }
 unsigned long foo_0x1000000400000(void) { return 0x1000000400000UL; }
 unsigned long foo_0x2000000400000(void) { return 0x2000000400000UL; }
 unsigned long foo_0x4000000400000(void) { return 0x4000000400000UL; }
 unsigned long foo_0x8000000400000(void) { return 0x8000000400000UL; }
 unsigned long foo_0x10000000400000(void) { return 0x10000000400000UL; }
 unsigned long foo_0x20000000400000(void) { return 0x20000000400000UL; }
 unsigned long foo_0x40000000400000(void) { return 0x40000000400000UL; }
 unsigned long foo_0x80000000400000(void) { return 0x80000000400000UL; }
 unsigned long foo_0x100000000400000(void) { return 0x100000000400000UL; }
 unsigned long foo_0x200000000400000(void) { return 0x200000000400000UL; }
 unsigned long foo_0x400000000400000(void) { return 0x400000000400000UL; }
 unsigned long foo_0x800000000400000(void) { return 0x800000000400000UL; }
 unsigned long foo_0x1000000000400000(void) { return 0x1000000000400000UL; }
 unsigned long foo_0x2000000000400000(void) { return 0x2000000000400000UL; }
 unsigned long foo_0x4000000000400000(void) { return 0x4000000000400000UL; }
 unsigned long foo_0x8000000000400000(void) { return 0x8000000000400000UL; }
 unsigned long foo_0x1800000(void) { return 0x1800000UL; }
 unsigned long foo_0x2800000(void) { return 0x2800000UL; }
 unsigned long foo_0x4800000(void) { return 0x4800000UL; }
 unsigned long foo_0x8800000(void) { return 0x8800000UL; }
 unsigned long foo_0x10800000(void) { return 0x10800000UL; }
 unsigned long foo_0x20800000(void) { return 0x20800000UL; }
 unsigned long foo_0x40800000(void) { return 0x40800000UL; }
 unsigned long foo_0x80800000(void) { return 0x80800000UL; }
 unsigned long foo_0x100800000(void) { return 0x100800000UL; }
 unsigned long foo_0x200800000(void) { return 0x200800000UL; }
 unsigned long foo_0x400800000(void) { return 0x400800000UL; }
 unsigned long foo_0x800800000(void) { return 0x800800000UL; }
 unsigned long foo_0x1000800000(void) { return 0x1000800000UL; }
 unsigned long foo_0x2000800000(void) { return 0x2000800000UL; }
 unsigned long foo_0x4000800000(void) { return 0x4000800000UL; }
 unsigned long foo_0x8000800000(void) { return 0x8000800000UL; }
 unsigned long foo_0x10000800000(void) { return 0x10000800000UL; }
 unsigned long foo_0x20000800000(void) { return 0x20000800000UL; }
 unsigned long foo_0x40000800000(void) { return 0x40000800000UL; }
 unsigned long foo_0x80000800000(void) { return 0x80000800000UL; }
 unsigned long foo_0x100000800000(void) { return 0x100000800000UL; }
 unsigned long foo_0x200000800000(void) { return 0x200000800000UL; }
 unsigned long foo_0x400000800000(void) { return 0x400000800000UL; }
 unsigned long foo_0x800000800000(void) { return 0x800000800000UL; }
 unsigned long foo_0x1000000800000(void) { return 0x1000000800000UL; }
 unsigned long foo_0x2000000800000(void) { return 0x2000000800000UL; }
 unsigned long foo_0x4000000800000(void) { return 0x4000000800000UL; }
 unsigned long foo_0x8000000800000(void) { return 0x8000000800000UL; }
 unsigned long foo_0x10000000800000(void) { return 0x10000000800000UL; }
 unsigned long foo_0x20000000800000(void) { return 0x20000000800000UL; }
 unsigned long foo_0x40000000800000(void) { return 0x40000000800000UL; }
 unsigned long foo_0x80000000800000(void) { return 0x80000000800000UL; }
 unsigned long foo_0x100000000800000(void) { return 0x100000000800000UL; }
 unsigned long foo_0x200000000800000(void) { return 0x200000000800000UL; }
 unsigned long foo_0x400000000800000(void) { return 0x400000000800000UL; }
 unsigned long foo_0x800000000800000(void) { return 0x800000000800000UL; }
 unsigned long foo_0x1000000000800000(void) { return 0x1000000000800000UL; }
 unsigned long foo_0x2000000000800000(void) { return 0x2000000000800000UL; }
 unsigned long foo_0x4000000000800000(void) { return 0x4000000000800000UL; }
 unsigned long foo_0x8000000000800000(void) { return 0x8000000000800000UL; }
 unsigned long foo_0x3000000(void) { return 0x3000000UL; }
 unsigned long foo_0x5000000(void) { return 0x5000000UL; }
 unsigned long foo_0x9000000(void) { return 0x9000000UL; }
 unsigned long foo_0x11000000(void) { return 0x11000000UL; }
 unsigned long foo_0x21000000(void) { return 0x21000000UL; }
 unsigned long foo_0x41000000(void) { return 0x41000000UL; }
 unsigned long foo_0x81000000(void) { return 0x81000000UL; }
 unsigned long foo_0x101000000(void) { return 0x101000000UL; }
 unsigned long foo_0x201000000(void) { return 0x201000000UL; }
 unsigned long foo_0x401000000(void) { return 0x401000000UL; }
 unsigned long foo_0x801000000(void) { return 0x801000000UL; }
 unsigned long foo_0x1001000000(void) { return 0x1001000000UL; }
 unsigned long foo_0x2001000000(void) { return 0x2001000000UL; }
 unsigned long foo_0x4001000000(void) { return 0x4001000000UL; }
 unsigned long foo_0x8001000000(void) { return 0x8001000000UL; }
 unsigned long foo_0x10001000000(void) { return 0x10001000000UL; }
 unsigned long foo_0x20001000000(void) { return 0x20001000000UL; }
 unsigned long foo_0x40001000000(void) { return 0x40001000000UL; }
 unsigned long foo_0x80001000000(void) { return 0x80001000000UL; }
 unsigned long foo_0x100001000000(void) { return 0x100001000000UL; }
 unsigned long foo_0x200001000000(void) { return 0x200001000000UL; }
 unsigned long foo_0x400001000000(void) { return 0x400001000000UL; }
 unsigned long foo_0x800001000000(void) { return 0x800001000000UL; }
 unsigned long foo_0x1000001000000(void) { return 0x1000001000000UL; }
 unsigned long foo_0x2000001000000(void) { return 0x2000001000000UL; }
 unsigned long foo_0x4000001000000(void) { return 0x4000001000000UL; }
 unsigned long foo_0x8000001000000(void) { return 0x8000001000000UL; }
 unsigned long foo_0x10000001000000(void) { return 0x10000001000000UL; }
 unsigned long foo_0x20000001000000(void) { return 0x20000001000000UL; }
 unsigned long foo_0x40000001000000(void) { return 0x40000001000000UL; }
 unsigned long foo_0x80000001000000(void) { return 0x80000001000000UL; }
 unsigned long foo_0x100000001000000(void) { return 0x100000001000000UL; }
 unsigned long foo_0x200000001000000(void) { return 0x200000001000000UL; }
 unsigned long foo_0x400000001000000(void) { return 0x400000001000000UL; }
 unsigned long foo_0x800000001000000(void) { return 0x800000001000000UL; }
 unsigned long foo_0x1000000001000000(void) { return 0x1000000001000000UL; }
 unsigned long foo_0x2000000001000000(void) { return 0x2000000001000000UL; }
 unsigned long foo_0x4000000001000000(void) { return 0x4000000001000000UL; }
 unsigned long foo_0x8000000001000000(void) { return 0x8000000001000000UL; }
 unsigned long foo_0x6000000(void) { return 0x6000000UL; }
 unsigned long foo_0xa000000(void) { return 0xa000000UL; }
 unsigned long foo_0x12000000(void) { return 0x12000000UL; }
 unsigned long foo_0x22000000(void) { return 0x22000000UL; }
 unsigned long foo_0x42000000(void) { return 0x42000000UL; }
 unsigned long foo_0x82000000(void) { return 0x82000000UL; }
 unsigned long foo_0x102000000(void) { return 0x102000000UL; }
 unsigned long foo_0x202000000(void) { return 0x202000000UL; }
 unsigned long foo_0x402000000(void) { return 0x402000000UL; }
 unsigned long foo_0x802000000(void) { return 0x802000000UL; }
 unsigned long foo_0x1002000000(void) { return 0x1002000000UL; }
 unsigned long foo_0x2002000000(void) { return 0x2002000000UL; }
 unsigned long foo_0x4002000000(void) { return 0x4002000000UL; }
 unsigned long foo_0x8002000000(void) { return 0x8002000000UL; }
 unsigned long foo_0x10002000000(void) { return 0x10002000000UL; }
 unsigned long foo_0x20002000000(void) { return 0x20002000000UL; }
 unsigned long foo_0x40002000000(void) { return 0x40002000000UL; }
 unsigned long foo_0x80002000000(void) { return 0x80002000000UL; }
 unsigned long foo_0x100002000000(void) { return 0x100002000000UL; }
 unsigned long foo_0x200002000000(void) { return 0x200002000000UL; }
 unsigned long foo_0x400002000000(void) { return 0x400002000000UL; }
 unsigned long foo_0x800002000000(void) { return 0x800002000000UL; }
 unsigned long foo_0x1000002000000(void) { return 0x1000002000000UL; }
 unsigned long foo_0x2000002000000(void) { return 0x2000002000000UL; }
 unsigned long foo_0x4000002000000(void) { return 0x4000002000000UL; }
 unsigned long foo_0x8000002000000(void) { return 0x8000002000000UL; }
 unsigned long foo_0x10000002000000(void) { return 0x10000002000000UL; }
 unsigned long foo_0x20000002000000(void) { return 0x20000002000000UL; }
 unsigned long foo_0x40000002000000(void) { return 0x40000002000000UL; }
 unsigned long foo_0x80000002000000(void) { return 0x80000002000000UL; }
 unsigned long foo_0x100000002000000(void) { return 0x100000002000000UL; }
 unsigned long foo_0x200000002000000(void) { return 0x200000002000000UL; }
 unsigned long foo_0x400000002000000(void) { return 0x400000002000000UL; }
 unsigned long foo_0x800000002000000(void) { return 0x800000002000000UL; }
 unsigned long foo_0x1000000002000000(void) { return 0x1000000002000000UL; }
 unsigned long foo_0x2000000002000000(void) { return 0x2000000002000000UL; }
 unsigned long foo_0x4000000002000000(void) { return 0x4000000002000000UL; }
 unsigned long foo_0x8000000002000000(void) { return 0x8000000002000000UL; }
 unsigned long foo_0xc000000(void) { return 0xc000000UL; }
 unsigned long foo_0x14000000(void) { return 0x14000000UL; }
 unsigned long foo_0x24000000(void) { return 0x24000000UL; }
 unsigned long foo_0x44000000(void) { return 0x44000000UL; }
 unsigned long foo_0x84000000(void) { return 0x84000000UL; }
 unsigned long foo_0x104000000(void) { return 0x104000000UL; }
 unsigned long foo_0x204000000(void) { return 0x204000000UL; }
 unsigned long foo_0x404000000(void) { return 0x404000000UL; }
 unsigned long foo_0x804000000(void) { return 0x804000000UL; }
 unsigned long foo_0x1004000000(void) { return 0x1004000000UL; }
 unsigned long foo_0x2004000000(void) { return 0x2004000000UL; }
 unsigned long foo_0x4004000000(void) { return 0x4004000000UL; }
 unsigned long foo_0x8004000000(void) { return 0x8004000000UL; }
 unsigned long foo_0x10004000000(void) { return 0x10004000000UL; }
 unsigned long foo_0x20004000000(void) { return 0x20004000000UL; }
 unsigned long foo_0x40004000000(void) { return 0x40004000000UL; }
 unsigned long foo_0x80004000000(void) { return 0x80004000000UL; }
 unsigned long foo_0x100004000000(void) { return 0x100004000000UL; }
 unsigned long foo_0x200004000000(void) { return 0x200004000000UL; }
 unsigned long foo_0x400004000000(void) { return 0x400004000000UL; }
 unsigned long foo_0x800004000000(void) { return 0x800004000000UL; }
 unsigned long foo_0x1000004000000(void) { return 0x1000004000000UL; }
 unsigned long foo_0x2000004000000(void) { return 0x2000004000000UL; }
 unsigned long foo_0x4000004000000(void) { return 0x4000004000000UL; }
 unsigned long foo_0x8000004000000(void) { return 0x8000004000000UL; }
 unsigned long foo_0x10000004000000(void) { return 0x10000004000000UL; }
 unsigned long foo_0x20000004000000(void) { return 0x20000004000000UL; }
 unsigned long foo_0x40000004000000(void) { return 0x40000004000000UL; }
 unsigned long foo_0x80000004000000(void) { return 0x80000004000000UL; }
 unsigned long foo_0x100000004000000(void) { return 0x100000004000000UL; }
 unsigned long foo_0x200000004000000(void) { return 0x200000004000000UL; }
 unsigned long foo_0x400000004000000(void) { return 0x400000004000000UL; }
 unsigned long foo_0x800000004000000(void) { return 0x800000004000000UL; }
 unsigned long foo_0x1000000004000000(void) { return 0x1000000004000000UL; }
 unsigned long foo_0x2000000004000000(void) { return 0x2000000004000000UL; }
 unsigned long foo_0x4000000004000000(void) { return 0x4000000004000000UL; }
 unsigned long foo_0x8000000004000000(void) { return 0x8000000004000000UL; }
 unsigned long foo_0x18000000(void) { return 0x18000000UL; }
 unsigned long foo_0x28000000(void) { return 0x28000000UL; }
 unsigned long foo_0x48000000(void) { return 0x48000000UL; }
 unsigned long foo_0x88000000(void) { return 0x88000000UL; }
 unsigned long foo_0x108000000(void) { return 0x108000000UL; }
 unsigned long foo_0x208000000(void) { return 0x208000000UL; }
 unsigned long foo_0x408000000(void) { return 0x408000000UL; }
 unsigned long foo_0x808000000(void) { return 0x808000000UL; }
 unsigned long foo_0x1008000000(void) { return 0x1008000000UL; }
 unsigned long foo_0x2008000000(void) { return 0x2008000000UL; }
 unsigned long foo_0x4008000000(void) { return 0x4008000000UL; }
 unsigned long foo_0x8008000000(void) { return 0x8008000000UL; }
 unsigned long foo_0x10008000000(void) { return 0x10008000000UL; }
 unsigned long foo_0x20008000000(void) { return 0x20008000000UL; }
 unsigned long foo_0x40008000000(void) { return 0x40008000000UL; }
 unsigned long foo_0x80008000000(void) { return 0x80008000000UL; }
 unsigned long foo_0x100008000000(void) { return 0x100008000000UL; }
 unsigned long foo_0x200008000000(void) { return 0x200008000000UL; }
 unsigned long foo_0x400008000000(void) { return 0x400008000000UL; }
 unsigned long foo_0x800008000000(void) { return 0x800008000000UL; }
 unsigned long foo_0x1000008000000(void) { return 0x1000008000000UL; }
 unsigned long foo_0x2000008000000(void) { return 0x2000008000000UL; }
 unsigned long foo_0x4000008000000(void) { return 0x4000008000000UL; }
 unsigned long foo_0x8000008000000(void) { return 0x8000008000000UL; }
 unsigned long foo_0x10000008000000(void) { return 0x10000008000000UL; }
 unsigned long foo_0x20000008000000(void) { return 0x20000008000000UL; }
 unsigned long foo_0x40000008000000(void) { return 0x40000008000000UL; }
 unsigned long foo_0x80000008000000(void) { return 0x80000008000000UL; }
 unsigned long foo_0x100000008000000(void) { return 0x100000008000000UL; }
 unsigned long foo_0x200000008000000(void) { return 0x200000008000000UL; }
 unsigned long foo_0x400000008000000(void) { return 0x400000008000000UL; }
 unsigned long foo_0x800000008000000(void) { return 0x800000008000000UL; }
 unsigned long foo_0x1000000008000000(void) { return 0x1000000008000000UL; }
 unsigned long foo_0x2000000008000000(void) { return 0x2000000008000000UL; }
 unsigned long foo_0x4000000008000000(void) { return 0x4000000008000000UL; }
 unsigned long foo_0x8000000008000000(void) { return 0x8000000008000000UL; }
 unsigned long foo_0x30000000(void) { return 0x30000000UL; }
 unsigned long foo_0x50000000(void) { return 0x50000000UL; }
 unsigned long foo_0x90000000(void) { return 0x90000000UL; }
 unsigned long foo_0x110000000(void) { return 0x110000000UL; }
 unsigned long foo_0x210000000(void) { return 0x210000000UL; }
 unsigned long foo_0x410000000(void) { return 0x410000000UL; }
 unsigned long foo_0x810000000(void) { return 0x810000000UL; }
 unsigned long foo_0x1010000000(void) { return 0x1010000000UL; }
 unsigned long foo_0x2010000000(void) { return 0x2010000000UL; }
 unsigned long foo_0x4010000000(void) { return 0x4010000000UL; }
 unsigned long foo_0x8010000000(void) { return 0x8010000000UL; }
 unsigned long foo_0x10010000000(void) { return 0x10010000000UL; }
 unsigned long foo_0x20010000000(void) { return 0x20010000000UL; }
 unsigned long foo_0x40010000000(void) { return 0x40010000000UL; }
 unsigned long foo_0x80010000000(void) { return 0x80010000000UL; }
 unsigned long foo_0x100010000000(void) { return 0x100010000000UL; }
 unsigned long foo_0x200010000000(void) { return 0x200010000000UL; }
 unsigned long foo_0x400010000000(void) { return 0x400010000000UL; }
 unsigned long foo_0x800010000000(void) { return 0x800010000000UL; }
 unsigned long foo_0x1000010000000(void) { return 0x1000010000000UL; }
 unsigned long foo_0x2000010000000(void) { return 0x2000010000000UL; }
 unsigned long foo_0x4000010000000(void) { return 0x4000010000000UL; }
 unsigned long foo_0x8000010000000(void) { return 0x8000010000000UL; }
 unsigned long foo_0x10000010000000(void) { return 0x10000010000000UL; }
 unsigned long foo_0x20000010000000(void) { return 0x20000010000000UL; }
 unsigned long foo_0x40000010000000(void) { return 0x40000010000000UL; }
 unsigned long foo_0x80000010000000(void) { return 0x80000010000000UL; }
 unsigned long foo_0x100000010000000(void) { return 0x100000010000000UL; }
 unsigned long foo_0x200000010000000(void) { return 0x200000010000000UL; }
 unsigned long foo_0x400000010000000(void) { return 0x400000010000000UL; }
 unsigned long foo_0x800000010000000(void) { return 0x800000010000000UL; }
 unsigned long foo_0x1000000010000000(void) { return 0x1000000010000000UL; }
 unsigned long foo_0x2000000010000000(void) { return 0x2000000010000000UL; }
 unsigned long foo_0x4000000010000000(void) { return 0x4000000010000000UL; }
 unsigned long foo_0x8000000010000000(void) { return 0x8000000010000000UL; }
 unsigned long foo_0x60000000(void) { return 0x60000000UL; }
 unsigned long foo_0xa0000000(void) { return 0xa0000000UL; }
 unsigned long foo_0x120000000(void) { return 0x120000000UL; }
 unsigned long foo_0x220000000(void) { return 0x220000000UL; }
 unsigned long foo_0x420000000(void) { return 0x420000000UL; }
 unsigned long foo_0x820000000(void) { return 0x820000000UL; }
 unsigned long foo_0x1020000000(void) { return 0x1020000000UL; }
 unsigned long foo_0x2020000000(void) { return 0x2020000000UL; }
 unsigned long foo_0x4020000000(void) { return 0x4020000000UL; }
 unsigned long foo_0x8020000000(void) { return 0x8020000000UL; }
 unsigned long foo_0x10020000000(void) { return 0x10020000000UL; }
 unsigned long foo_0x20020000000(void) { return 0x20020000000UL; }
 unsigned long foo_0x40020000000(void) { return 0x40020000000UL; }
 unsigned long foo_0x80020000000(void) { return 0x80020000000UL; }
 unsigned long foo_0x100020000000(void) { return 0x100020000000UL; }
 unsigned long foo_0x200020000000(void) { return 0x200020000000UL; }
 unsigned long foo_0x400020000000(void) { return 0x400020000000UL; }
 unsigned long foo_0x800020000000(void) { return 0x800020000000UL; }
 unsigned long foo_0x1000020000000(void) { return 0x1000020000000UL; }
 unsigned long foo_0x2000020000000(void) { return 0x2000020000000UL; }
 unsigned long foo_0x4000020000000(void) { return 0x4000020000000UL; }
 unsigned long foo_0x8000020000000(void) { return 0x8000020000000UL; }
 unsigned long foo_0x10000020000000(void) { return 0x10000020000000UL; }
 unsigned long foo_0x20000020000000(void) { return 0x20000020000000UL; }
 unsigned long foo_0x40000020000000(void) { return 0x40000020000000UL; }
 unsigned long foo_0x80000020000000(void) { return 0x80000020000000UL; }
 unsigned long foo_0x100000020000000(void) { return 0x100000020000000UL; }
 unsigned long foo_0x200000020000000(void) { return 0x200000020000000UL; }
 unsigned long foo_0x400000020000000(void) { return 0x400000020000000UL; }
 unsigned long foo_0x800000020000000(void) { return 0x800000020000000UL; }
 unsigned long foo_0x1000000020000000(void) { return 0x1000000020000000UL; }
 unsigned long foo_0x2000000020000000(void) { return 0x2000000020000000UL; }
 unsigned long foo_0x4000000020000000(void) { return 0x4000000020000000UL; }
 unsigned long foo_0x8000000020000000(void) { return 0x8000000020000000UL; }
 unsigned long foo_0xc0000000(void) { return 0xc0000000UL; }
 unsigned long foo_0x140000000(void) { return 0x140000000UL; }
 unsigned long foo_0x240000000(void) { return 0x240000000UL; }
 unsigned long foo_0x440000000(void) { return 0x440000000UL; }
 unsigned long foo_0x840000000(void) { return 0x840000000UL; }
 unsigned long foo_0x1040000000(void) { return 0x1040000000UL; }
 unsigned long foo_0x2040000000(void) { return 0x2040000000UL; }
 unsigned long foo_0x4040000000(void) { return 0x4040000000UL; }
 unsigned long foo_0x8040000000(void) { return 0x8040000000UL; }
 unsigned long foo_0x10040000000(void) { return 0x10040000000UL; }
 unsigned long foo_0x20040000000(void) { return 0x20040000000UL; }
 unsigned long foo_0x40040000000(void) { return 0x40040000000UL; }
 unsigned long foo_0x80040000000(void) { return 0x80040000000UL; }
 unsigned long foo_0x100040000000(void) { return 0x100040000000UL; }
 unsigned long foo_0x200040000000(void) { return 0x200040000000UL; }
 unsigned long foo_0x400040000000(void) { return 0x400040000000UL; }
 unsigned long foo_0x800040000000(void) { return 0x800040000000UL; }
 unsigned long foo_0x1000040000000(void) { return 0x1000040000000UL; }
 unsigned long foo_0x2000040000000(void) { return 0x2000040000000UL; }
 unsigned long foo_0x4000040000000(void) { return 0x4000040000000UL; }
 unsigned long foo_0x8000040000000(void) { return 0x8000040000000UL; }
 unsigned long foo_0x10000040000000(void) { return 0x10000040000000UL; }
 unsigned long foo_0x20000040000000(void) { return 0x20000040000000UL; }
 unsigned long foo_0x40000040000000(void) { return 0x40000040000000UL; }
 unsigned long foo_0x80000040000000(void) { return 0x80000040000000UL; }
 unsigned long foo_0x100000040000000(void) { return 0x100000040000000UL; }
 unsigned long foo_0x200000040000000(void) { return 0x200000040000000UL; }
 unsigned long foo_0x400000040000000(void) { return 0x400000040000000UL; }
 unsigned long foo_0x800000040000000(void) { return 0x800000040000000UL; }
 unsigned long foo_0x1000000040000000(void) { return 0x1000000040000000UL; }
 unsigned long foo_0x2000000040000000(void) { return 0x2000000040000000UL; }
 unsigned long foo_0x4000000040000000(void) { return 0x4000000040000000UL; }
 unsigned long foo_0x8000000040000000(void) { return 0x8000000040000000UL; }
 unsigned long foo_0x180000000(void) { return 0x180000000UL; }
 unsigned long foo_0x280000000(void) { return 0x280000000UL; }
 unsigned long foo_0x480000000(void) { return 0x480000000UL; }
 unsigned long foo_0x880000000(void) { return 0x880000000UL; }
 unsigned long foo_0x1080000000(void) { return 0x1080000000UL; }
 unsigned long foo_0x2080000000(void) { return 0x2080000000UL; }
 unsigned long foo_0x4080000000(void) { return 0x4080000000UL; }
 unsigned long foo_0x8080000000(void) { return 0x8080000000UL; }
 unsigned long foo_0x10080000000(void) { return 0x10080000000UL; }
 unsigned long foo_0x20080000000(void) { return 0x20080000000UL; }
 unsigned long foo_0x40080000000(void) { return 0x40080000000UL; }
 unsigned long foo_0x80080000000(void) { return 0x80080000000UL; }
 unsigned long foo_0x100080000000(void) { return 0x100080000000UL; }
 unsigned long foo_0x200080000000(void) { return 0x200080000000UL; }
 unsigned long foo_0x400080000000(void) { return 0x400080000000UL; }
 unsigned long foo_0x800080000000(void) { return 0x800080000000UL; }
 unsigned long foo_0x1000080000000(void) { return 0x1000080000000UL; }
 unsigned long foo_0x2000080000000(void) { return 0x2000080000000UL; }
 unsigned long foo_0x4000080000000(void) { return 0x4000080000000UL; }
 unsigned long foo_0x8000080000000(void) { return 0x8000080000000UL; }
 unsigned long foo_0x10000080000000(void) { return 0x10000080000000UL; }
 unsigned long foo_0x20000080000000(void) { return 0x20000080000000UL; }
 unsigned long foo_0x40000080000000(void) { return 0x40000080000000UL; }
 unsigned long foo_0x80000080000000(void) { return 0x80000080000000UL; }
 unsigned long foo_0x100000080000000(void) { return 0x100000080000000UL; }
 unsigned long foo_0x200000080000000(void) { return 0x200000080000000UL; }
 unsigned long foo_0x400000080000000(void) { return 0x400000080000000UL; }
 unsigned long foo_0x800000080000000(void) { return 0x800000080000000UL; }
 unsigned long foo_0x1000000080000000(void) { return 0x1000000080000000UL; }
 unsigned long foo_0x2000000080000000(void) { return 0x2000000080000000UL; }
 unsigned long foo_0x4000000080000000(void) { return 0x4000000080000000UL; }
 unsigned long foo_0x8000000080000000(void) { return 0x8000000080000000UL; }
 unsigned long foo_0x300000000(void) { return 0x300000000UL; }
 unsigned long foo_0x500000000(void) { return 0x500000000UL; }
 unsigned long foo_0x900000000(void) { return 0x900000000UL; }
 unsigned long foo_0x1100000000(void) { return 0x1100000000UL; }
 unsigned long foo_0x2100000000(void) { return 0x2100000000UL; }
 unsigned long foo_0x4100000000(void) { return 0x4100000000UL; }
 unsigned long foo_0x8100000000(void) { return 0x8100000000UL; }
 unsigned long foo_0x10100000000(void) { return 0x10100000000UL; }
 unsigned long foo_0x20100000000(void) { return 0x20100000000UL; }
 unsigned long foo_0x40100000000(void) { return 0x40100000000UL; }
 unsigned long foo_0x80100000000(void) { return 0x80100000000UL; }
 unsigned long foo_0x100100000000(void) { return 0x100100000000UL; }
 unsigned long foo_0x200100000000(void) { return 0x200100000000UL; }
 unsigned long foo_0x400100000000(void) { return 0x400100000000UL; }
 unsigned long foo_0x800100000000(void) { return 0x800100000000UL; }
 unsigned long foo_0x1000100000000(void) { return 0x1000100000000UL; }
 unsigned long foo_0x2000100000000(void) { return 0x2000100000000UL; }
 unsigned long foo_0x4000100000000(void) { return 0x4000100000000UL; }
 unsigned long foo_0x8000100000000(void) { return 0x8000100000000UL; }
 unsigned long foo_0x10000100000000(void) { return 0x10000100000000UL; }
 unsigned long foo_0x20000100000000(void) { return 0x20000100000000UL; }
 unsigned long foo_0x40000100000000(void) { return 0x40000100000000UL; }
 unsigned long foo_0x80000100000000(void) { return 0x80000100000000UL; }
 unsigned long foo_0x100000100000000(void) { return 0x100000100000000UL; }
 unsigned long foo_0x200000100000000(void) { return 0x200000100000000UL; }
 unsigned long foo_0x400000100000000(void) { return 0x400000100000000UL; }
 unsigned long foo_0x800000100000000(void) { return 0x800000100000000UL; }
 unsigned long foo_0x1000000100000000(void) { return 0x1000000100000000UL; }
 unsigned long foo_0x2000000100000000(void) { return 0x2000000100000000UL; }
 unsigned long foo_0x4000000100000000(void) { return 0x4000000100000000UL; }
 unsigned long foo_0x8000000100000000(void) { return 0x8000000100000000UL; }
 unsigned long foo_0x600000000(void) { return 0x600000000UL; }
 unsigned long foo_0xa00000000(void) { return 0xa00000000UL; }
 unsigned long foo_0x1200000000(void) { return 0x1200000000UL; }
 unsigned long foo_0x2200000000(void) { return 0x2200000000UL; }
 unsigned long foo_0x4200000000(void) { return 0x4200000000UL; }
 unsigned long foo_0x8200000000(void) { return 0x8200000000UL; }
 unsigned long foo_0x10200000000(void) { return 0x10200000000UL; }
 unsigned long foo_0x20200000000(void) { return 0x20200000000UL; }
 unsigned long foo_0x40200000000(void) { return 0x40200000000UL; }
 unsigned long foo_0x80200000000(void) { return 0x80200000000UL; }
 unsigned long foo_0x100200000000(void) { return 0x100200000000UL; }
 unsigned long foo_0x200200000000(void) { return 0x200200000000UL; }
 unsigned long foo_0x400200000000(void) { return 0x400200000000UL; }
 unsigned long foo_0x800200000000(void) { return 0x800200000000UL; }
 unsigned long foo_0x1000200000000(void) { return 0x1000200000000UL; }
 unsigned long foo_0x2000200000000(void) { return 0x2000200000000UL; }
 unsigned long foo_0x4000200000000(void) { return 0x4000200000000UL; }
 unsigned long foo_0x8000200000000(void) { return 0x8000200000000UL; }
 unsigned long foo_0x10000200000000(void) { return 0x10000200000000UL; }
 unsigned long foo_0x20000200000000(void) { return 0x20000200000000UL; }
 unsigned long foo_0x40000200000000(void) { return 0x40000200000000UL; }
 unsigned long foo_0x80000200000000(void) { return 0x80000200000000UL; }
 unsigned long foo_0x100000200000000(void) { return 0x100000200000000UL; }
 unsigned long foo_0x200000200000000(void) { return 0x200000200000000UL; }
 unsigned long foo_0x400000200000000(void) { return 0x400000200000000UL; }
 unsigned long foo_0x800000200000000(void) { return 0x800000200000000UL; }
 unsigned long foo_0x1000000200000000(void) { return 0x1000000200000000UL; }
 unsigned long foo_0x2000000200000000(void) { return 0x2000000200000000UL; }
 unsigned long foo_0x4000000200000000(void) { return 0x4000000200000000UL; }
 unsigned long foo_0x8000000200000000(void) { return 0x8000000200000000UL; }
 unsigned long foo_0xc00000000(void) { return 0xc00000000UL; }
 unsigned long foo_0x1400000000(void) { return 0x1400000000UL; }
 unsigned long foo_0x2400000000(void) { return 0x2400000000UL; }
 unsigned long foo_0x4400000000(void) { return 0x4400000000UL; }
 unsigned long foo_0x8400000000(void) { return 0x8400000000UL; }
 unsigned long foo_0x10400000000(void) { return 0x10400000000UL; }
 unsigned long foo_0x20400000000(void) { return 0x20400000000UL; }
 unsigned long foo_0x40400000000(void) { return 0x40400000000UL; }
 unsigned long foo_0x80400000000(void) { return 0x80400000000UL; }
 unsigned long foo_0x100400000000(void) { return 0x100400000000UL; }
 unsigned long foo_0x200400000000(void) { return 0x200400000000UL; }
 unsigned long foo_0x400400000000(void) { return 0x400400000000UL; }
 unsigned long foo_0x800400000000(void) { return 0x800400000000UL; }
 unsigned long foo_0x1000400000000(void) { return 0x1000400000000UL; }
 unsigned long foo_0x2000400000000(void) { return 0x2000400000000UL; }
 unsigned long foo_0x4000400000000(void) { return 0x4000400000000UL; }
 unsigned long foo_0x8000400000000(void) { return 0x8000400000000UL; }
 unsigned long foo_0x10000400000000(void) { return 0x10000400000000UL; }
 unsigned long foo_0x20000400000000(void) { return 0x20000400000000UL; }
 unsigned long foo_0x40000400000000(void) { return 0x40000400000000UL; }
 unsigned long foo_0x80000400000000(void) { return 0x80000400000000UL; }
 unsigned long foo_0x100000400000000(void) { return 0x100000400000000UL; }
 unsigned long foo_0x200000400000000(void) { return 0x200000400000000UL; }
 unsigned long foo_0x400000400000000(void) { return 0x400000400000000UL; }
 unsigned long foo_0x800000400000000(void) { return 0x800000400000000UL; }
 unsigned long foo_0x1000000400000000(void) { return 0x1000000400000000UL; }
 unsigned long foo_0x2000000400000000(void) { return 0x2000000400000000UL; }
 unsigned long foo_0x4000000400000000(void) { return 0x4000000400000000UL; }
 unsigned long foo_0x8000000400000000(void) { return 0x8000000400000000UL; }
 unsigned long foo_0x1800000000(void) { return 0x1800000000UL; }
 unsigned long foo_0x2800000000(void) { return 0x2800000000UL; }
 unsigned long foo_0x4800000000(void) { return 0x4800000000UL; }
 unsigned long foo_0x8800000000(void) { return 0x8800000000UL; }
 unsigned long foo_0x10800000000(void) { return 0x10800000000UL; }
 unsigned long foo_0x20800000000(void) { return 0x20800000000UL; }
 unsigned long foo_0x40800000000(void) { return 0x40800000000UL; }
 unsigned long foo_0x80800000000(void) { return 0x80800000000UL; }
 unsigned long foo_0x100800000000(void) { return 0x100800000000UL; }
 unsigned long foo_0x200800000000(void) { return 0x200800000000UL; }
 unsigned long foo_0x400800000000(void) { return 0x400800000000UL; }
 unsigned long foo_0x800800000000(void) { return 0x800800000000UL; }
 unsigned long foo_0x1000800000000(void) { return 0x1000800000000UL; }
 unsigned long foo_0x2000800000000(void) { return 0x2000800000000UL; }
 unsigned long foo_0x4000800000000(void) { return 0x4000800000000UL; }
 unsigned long foo_0x8000800000000(void) { return 0x8000800000000UL; }
 unsigned long foo_0x10000800000000(void) { return 0x10000800000000UL; }
 unsigned long foo_0x20000800000000(void) { return 0x20000800000000UL; }
 unsigned long foo_0x40000800000000(void) { return 0x40000800000000UL; }
 unsigned long foo_0x80000800000000(void) { return 0x80000800000000UL; }
 unsigned long foo_0x100000800000000(void) { return 0x100000800000000UL; }
 unsigned long foo_0x200000800000000(void) { return 0x200000800000000UL; }
 unsigned long foo_0x400000800000000(void) { return 0x400000800000000UL; }
 unsigned long foo_0x800000800000000(void) { return 0x800000800000000UL; }
 unsigned long foo_0x1000000800000000(void) { return 0x1000000800000000UL; }
 unsigned long foo_0x2000000800000000(void) { return 0x2000000800000000UL; }
 unsigned long foo_0x4000000800000000(void) { return 0x4000000800000000UL; }
 unsigned long foo_0x8000000800000000(void) { return 0x8000000800000000UL; }
 unsigned long foo_0x3000000000(void) { return 0x3000000000UL; }
 unsigned long foo_0x5000000000(void) { return 0x5000000000UL; }
 unsigned long foo_0x9000000000(void) { return 0x9000000000UL; }
 unsigned long foo_0x11000000000(void) { return 0x11000000000UL; }
 unsigned long foo_0x21000000000(void) { return 0x21000000000UL; }
 unsigned long foo_0x41000000000(void) { return 0x41000000000UL; }
 unsigned long foo_0x81000000000(void) { return 0x81000000000UL; }
 unsigned long foo_0x101000000000(void) { return 0x101000000000UL; }
 unsigned long foo_0x201000000000(void) { return 0x201000000000UL; }
 unsigned long foo_0x401000000000(void) { return 0x401000000000UL; }
 unsigned long foo_0x801000000000(void) { return 0x801000000000UL; }
 unsigned long foo_0x1001000000000(void) { return 0x1001000000000UL; }
 unsigned long foo_0x2001000000000(void) { return 0x2001000000000UL; }
 unsigned long foo_0x4001000000000(void) { return 0x4001000000000UL; }
 unsigned long foo_0x8001000000000(void) { return 0x8001000000000UL; }
 unsigned long foo_0x10001000000000(void) { return 0x10001000000000UL; }
 unsigned long foo_0x20001000000000(void) { return 0x20001000000000UL; }
 unsigned long foo_0x40001000000000(void) { return 0x40001000000000UL; }
 unsigned long foo_0x80001000000000(void) { return 0x80001000000000UL; }
 unsigned long foo_0x100001000000000(void) { return 0x100001000000000UL; }
 unsigned long foo_0x200001000000000(void) { return 0x200001000000000UL; }
 unsigned long foo_0x400001000000000(void) { return 0x400001000000000UL; }
 unsigned long foo_0x800001000000000(void) { return 0x800001000000000UL; }
 unsigned long foo_0x1000001000000000(void) { return 0x1000001000000000UL; }
 unsigned long foo_0x2000001000000000(void) { return 0x2000001000000000UL; }
 unsigned long foo_0x4000001000000000(void) { return 0x4000001000000000UL; }
 unsigned long foo_0x8000001000000000(void) { return 0x8000001000000000UL; }
 unsigned long foo_0x6000000000(void) { return 0x6000000000UL; }
 unsigned long foo_0xa000000000(void) { return 0xa000000000UL; }
 unsigned long foo_0x12000000000(void) { return 0x12000000000UL; }
 unsigned long foo_0x22000000000(void) { return 0x22000000000UL; }
 unsigned long foo_0x42000000000(void) { return 0x42000000000UL; }
 unsigned long foo_0x82000000000(void) { return 0x82000000000UL; }
 unsigned long foo_0x102000000000(void) { return 0x102000000000UL; }
 unsigned long foo_0x202000000000(void) { return 0x202000000000UL; }
 unsigned long foo_0x402000000000(void) { return 0x402000000000UL; }
 unsigned long foo_0x802000000000(void) { return 0x802000000000UL; }
 unsigned long foo_0x1002000000000(void) { return 0x1002000000000UL; }
 unsigned long foo_0x2002000000000(void) { return 0x2002000000000UL; }
 unsigned long foo_0x4002000000000(void) { return 0x4002000000000UL; }
 unsigned long foo_0x8002000000000(void) { return 0x8002000000000UL; }
 unsigned long foo_0x10002000000000(void) { return 0x10002000000000UL; }
 unsigned long foo_0x20002000000000(void) { return 0x20002000000000UL; }
 unsigned long foo_0x40002000000000(void) { return 0x40002000000000UL; }
 unsigned long foo_0x80002000000000(void) { return 0x80002000000000UL; }
 unsigned long foo_0x100002000000000(void) { return 0x100002000000000UL; }
 unsigned long foo_0x200002000000000(void) { return 0x200002000000000UL; }
 unsigned long foo_0x400002000000000(void) { return 0x400002000000000UL; }
 unsigned long foo_0x800002000000000(void) { return 0x800002000000000UL; }
 unsigned long foo_0x1000002000000000(void) { return 0x1000002000000000UL; }
 unsigned long foo_0x2000002000000000(void) { return 0x2000002000000000UL; }
 unsigned long foo_0x4000002000000000(void) { return 0x4000002000000000UL; }
 unsigned long foo_0x8000002000000000(void) { return 0x8000002000000000UL; }
 unsigned long foo_0xc000000000(void) { return 0xc000000000UL; }
 unsigned long foo_0x14000000000(void) { return 0x14000000000UL; }
 unsigned long foo_0x24000000000(void) { return 0x24000000000UL; }
 unsigned long foo_0x44000000000(void) { return 0x44000000000UL; }
 unsigned long foo_0x84000000000(void) { return 0x84000000000UL; }
 unsigned long foo_0x104000000000(void) { return 0x104000000000UL; }
 unsigned long foo_0x204000000000(void) { return 0x204000000000UL; }
 unsigned long foo_0x404000000000(void) { return 0x404000000000UL; }
 unsigned long foo_0x804000000000(void) { return 0x804000000000UL; }
 unsigned long foo_0x1004000000000(void) { return 0x1004000000000UL; }
 unsigned long foo_0x2004000000000(void) { return 0x2004000000000UL; }
 unsigned long foo_0x4004000000000(void) { return 0x4004000000000UL; }
 unsigned long foo_0x8004000000000(void) { return 0x8004000000000UL; }
 unsigned long foo_0x10004000000000(void) { return 0x10004000000000UL; }
 unsigned long foo_0x20004000000000(void) { return 0x20004000000000UL; }
 unsigned long foo_0x40004000000000(void) { return 0x40004000000000UL; }
 unsigned long foo_0x80004000000000(void) { return 0x80004000000000UL; }
 unsigned long foo_0x100004000000000(void) { return 0x100004000000000UL; }
 unsigned long foo_0x200004000000000(void) { return 0x200004000000000UL; }
 unsigned long foo_0x400004000000000(void) { return 0x400004000000000UL; }
 unsigned long foo_0x800004000000000(void) { return 0x800004000000000UL; }
 unsigned long foo_0x1000004000000000(void) { return 0x1000004000000000UL; }
 unsigned long foo_0x2000004000000000(void) { return 0x2000004000000000UL; }
 unsigned long foo_0x4000004000000000(void) { return 0x4000004000000000UL; }
 unsigned long foo_0x8000004000000000(void) { return 0x8000004000000000UL; }
 unsigned long foo_0x18000000000(void) { return 0x18000000000UL; }
 unsigned long foo_0x28000000000(void) { return 0x28000000000UL; }
 unsigned long foo_0x48000000000(void) { return 0x48000000000UL; }
 unsigned long foo_0x88000000000(void) { return 0x88000000000UL; }
 unsigned long foo_0x108000000000(void) { return 0x108000000000UL; }
 unsigned long foo_0x208000000000(void) { return 0x208000000000UL; }
 unsigned long foo_0x408000000000(void) { return 0x408000000000UL; }
 unsigned long foo_0x808000000000(void) { return 0x808000000000UL; }
 unsigned long foo_0x1008000000000(void) { return 0x1008000000000UL; }
 unsigned long foo_0x2008000000000(void) { return 0x2008000000000UL; }
 unsigned long foo_0x4008000000000(void) { return 0x4008000000000UL; }
 unsigned long foo_0x8008000000000(void) { return 0x8008000000000UL; }
 unsigned long foo_0x10008000000000(void) { return 0x10008000000000UL; }
 unsigned long foo_0x20008000000000(void) { return 0x20008000000000UL; }
 unsigned long foo_0x40008000000000(void) { return 0x40008000000000UL; }
 unsigned long foo_0x80008000000000(void) { return 0x80008000000000UL; }
 unsigned long foo_0x100008000000000(void) { return 0x100008000000000UL; }
 unsigned long foo_0x200008000000000(void) { return 0x200008000000000UL; }
 unsigned long foo_0x400008000000000(void) { return 0x400008000000000UL; }
 unsigned long foo_0x800008000000000(void) { return 0x800008000000000UL; }
 unsigned long foo_0x1000008000000000(void) { return 0x1000008000000000UL; }
 unsigned long foo_0x2000008000000000(void) { return 0x2000008000000000UL; }
 unsigned long foo_0x4000008000000000(void) { return 0x4000008000000000UL; }
 unsigned long foo_0x8000008000000000(void) { return 0x8000008000000000UL; }
 unsigned long foo_0x30000000000(void) { return 0x30000000000UL; }
 unsigned long foo_0x50000000000(void) { return 0x50000000000UL; }
 unsigned long foo_0x90000000000(void) { return 0x90000000000UL; }
 unsigned long foo_0x110000000000(void) { return 0x110000000000UL; }
 unsigned long foo_0x210000000000(void) { return 0x210000000000UL; }
 unsigned long foo_0x410000000000(void) { return 0x410000000000UL; }
 unsigned long foo_0x810000000000(void) { return 0x810000000000UL; }
 unsigned long foo_0x1010000000000(void) { return 0x1010000000000UL; }
 unsigned long foo_0x2010000000000(void) { return 0x2010000000000UL; }
 unsigned long foo_0x4010000000000(void) { return 0x4010000000000UL; }
 unsigned long foo_0x8010000000000(void) { return 0x8010000000000UL; }
 unsigned long foo_0x10010000000000(void) { return 0x10010000000000UL; }
 unsigned long foo_0x20010000000000(void) { return 0x20010000000000UL; }
 unsigned long foo_0x40010000000000(void) { return 0x40010000000000UL; }
 unsigned long foo_0x80010000000000(void) { return 0x80010000000000UL; }
 unsigned long foo_0x100010000000000(void) { return 0x100010000000000UL; }
 unsigned long foo_0x200010000000000(void) { return 0x200010000000000UL; }
 unsigned long foo_0x400010000000000(void) { return 0x400010000000000UL; }
 unsigned long foo_0x800010000000000(void) { return 0x800010000000000UL; }
 unsigned long foo_0x1000010000000000(void) { return 0x1000010000000000UL; }
 unsigned long foo_0x2000010000000000(void) { return 0x2000010000000000UL; }
 unsigned long foo_0x4000010000000000(void) { return 0x4000010000000000UL; }
 unsigned long foo_0x8000010000000000(void) { return 0x8000010000000000UL; }
 unsigned long foo_0x60000000000(void) { return 0x60000000000UL; }
 unsigned long foo_0xa0000000000(void) { return 0xa0000000000UL; }
 unsigned long foo_0x120000000000(void) { return 0x120000000000UL; }
 unsigned long foo_0x220000000000(void) { return 0x220000000000UL; }
 unsigned long foo_0x420000000000(void) { return 0x420000000000UL; }
 unsigned long foo_0x820000000000(void) { return 0x820000000000UL; }
 unsigned long foo_0x1020000000000(void) { return 0x1020000000000UL; }
 unsigned long foo_0x2020000000000(void) { return 0x2020000000000UL; }
 unsigned long foo_0x4020000000000(void) { return 0x4020000000000UL; }
 unsigned long foo_0x8020000000000(void) { return 0x8020000000000UL; }
 unsigned long foo_0x10020000000000(void) { return 0x10020000000000UL; }
 unsigned long foo_0x20020000000000(void) { return 0x20020000000000UL; }
 unsigned long foo_0x40020000000000(void) { return 0x40020000000000UL; }
 unsigned long foo_0x80020000000000(void) { return 0x80020000000000UL; }
 unsigned long foo_0x100020000000000(void) { return 0x100020000000000UL; }
 unsigned long foo_0x200020000000000(void) { return 0x200020000000000UL; }
 unsigned long foo_0x400020000000000(void) { return 0x400020000000000UL; }
 unsigned long foo_0x800020000000000(void) { return 0x800020000000000UL; }
 unsigned long foo_0x1000020000000000(void) { return 0x1000020000000000UL; }
 unsigned long foo_0x2000020000000000(void) { return 0x2000020000000000UL; }
 unsigned long foo_0x4000020000000000(void) { return 0x4000020000000000UL; }
 unsigned long foo_0x8000020000000000(void) { return 0x8000020000000000UL; }
 unsigned long foo_0xc0000000000(void) { return 0xc0000000000UL; }
 unsigned long foo_0x140000000000(void) { return 0x140000000000UL; }
 unsigned long foo_0x240000000000(void) { return 0x240000000000UL; }
 unsigned long foo_0x440000000000(void) { return 0x440000000000UL; }
 unsigned long foo_0x840000000000(void) { return 0x840000000000UL; }
 unsigned long foo_0x1040000000000(void) { return 0x1040000000000UL; }
 unsigned long foo_0x2040000000000(void) { return 0x2040000000000UL; }
 unsigned long foo_0x4040000000000(void) { return 0x4040000000000UL; }
 unsigned long foo_0x8040000000000(void) { return 0x8040000000000UL; }
 unsigned long foo_0x10040000000000(void) { return 0x10040000000000UL; }
 unsigned long foo_0x20040000000000(void) { return 0x20040000000000UL; }
 unsigned long foo_0x40040000000000(void) { return 0x40040000000000UL; }
 unsigned long foo_0x80040000000000(void) { return 0x80040000000000UL; }
 unsigned long foo_0x100040000000000(void) { return 0x100040000000000UL; }
 unsigned long foo_0x200040000000000(void) { return 0x200040000000000UL; }
 unsigned long foo_0x400040000000000(void) { return 0x400040000000000UL; }
 unsigned long foo_0x800040000000000(void) { return 0x800040000000000UL; }
 unsigned long foo_0x1000040000000000(void) { return 0x1000040000000000UL; }
 unsigned long foo_0x2000040000000000(void) { return 0x2000040000000000UL; }
 unsigned long foo_0x4000040000000000(void) { return 0x4000040000000000UL; }
 unsigned long foo_0x8000040000000000(void) { return 0x8000040000000000UL; }
 unsigned long foo_0x180000000000(void) { return 0x180000000000UL; }
 unsigned long foo_0x280000000000(void) { return 0x280000000000UL; }
 unsigned long foo_0x480000000000(void) { return 0x480000000000UL; }
 unsigned long foo_0x880000000000(void) { return 0x880000000000UL; }
 unsigned long foo_0x1080000000000(void) { return 0x1080000000000UL; }
 unsigned long foo_0x2080000000000(void) { return 0x2080000000000UL; }
 unsigned long foo_0x4080000000000(void) { return 0x4080000000000UL; }
 unsigned long foo_0x8080000000000(void) { return 0x8080000000000UL; }
 unsigned long foo_0x10080000000000(void) { return 0x10080000000000UL; }
 unsigned long foo_0x20080000000000(void) { return 0x20080000000000UL; }
 unsigned long foo_0x40080000000000(void) { return 0x40080000000000UL; }
 unsigned long foo_0x80080000000000(void) { return 0x80080000000000UL; }
 unsigned long foo_0x100080000000000(void) { return 0x100080000000000UL; }
 unsigned long foo_0x200080000000000(void) { return 0x200080000000000UL; }
 unsigned long foo_0x400080000000000(void) { return 0x400080000000000UL; }
 unsigned long foo_0x800080000000000(void) { return 0x800080000000000UL; }
 unsigned long foo_0x1000080000000000(void) { return 0x1000080000000000UL; }
 unsigned long foo_0x2000080000000000(void) { return 0x2000080000000000UL; }
 unsigned long foo_0x4000080000000000(void) { return 0x4000080000000000UL; }
 unsigned long foo_0x8000080000000000(void) { return 0x8000080000000000UL; }
 unsigned long foo_0x300000000000(void) { return 0x300000000000UL; }
 unsigned long foo_0x500000000000(void) { return 0x500000000000UL; }
 unsigned long foo_0x900000000000(void) { return 0x900000000000UL; }
 unsigned long foo_0x1100000000000(void) { return 0x1100000000000UL; }
 unsigned long foo_0x2100000000000(void) { return 0x2100000000000UL; }
 unsigned long foo_0x4100000000000(void) { return 0x4100000000000UL; }
 unsigned long foo_0x8100000000000(void) { return 0x8100000000000UL; }
 unsigned long foo_0x10100000000000(void) { return 0x10100000000000UL; }
 unsigned long foo_0x20100000000000(void) { return 0x20100000000000UL; }
 unsigned long foo_0x40100000000000(void) { return 0x40100000000000UL; }
 unsigned long foo_0x80100000000000(void) { return 0x80100000000000UL; }
 unsigned long foo_0x100100000000000(void) { return 0x100100000000000UL; }
 unsigned long foo_0x200100000000000(void) { return 0x200100000000000UL; }
 unsigned long foo_0x400100000000000(void) { return 0x400100000000000UL; }
 unsigned long foo_0x800100000000000(void) { return 0x800100000000000UL; }
 unsigned long foo_0x1000100000000000(void) { return 0x1000100000000000UL; }
 unsigned long foo_0x2000100000000000(void) { return 0x2000100000000000UL; }
 unsigned long foo_0x4000100000000000(void) { return 0x4000100000000000UL; }
 unsigned long foo_0x8000100000000000(void) { return 0x8000100000000000UL; }
 unsigned long foo_0x600000000000(void) { return 0x600000000000UL; }
 unsigned long foo_0xa00000000000(void) { return 0xa00000000000UL; }
 unsigned long foo_0x1200000000000(void) { return 0x1200000000000UL; }
 unsigned long foo_0x2200000000000(void) { return 0x2200000000000UL; }
 unsigned long foo_0x4200000000000(void) { return 0x4200000000000UL; }
 unsigned long foo_0x8200000000000(void) { return 0x8200000000000UL; }
 unsigned long foo_0x10200000000000(void) { return 0x10200000000000UL; }
 unsigned long foo_0x20200000000000(void) { return 0x20200000000000UL; }
 unsigned long foo_0x40200000000000(void) { return 0x40200000000000UL; }
 unsigned long foo_0x80200000000000(void) { return 0x80200000000000UL; }
 unsigned long foo_0x100200000000000(void) { return 0x100200000000000UL; }
 unsigned long foo_0x200200000000000(void) { return 0x200200000000000UL; }
 unsigned long foo_0x400200000000000(void) { return 0x400200000000000UL; }
 unsigned long foo_0x800200000000000(void) { return 0x800200000000000UL; }
 unsigned long foo_0x1000200000000000(void) { return 0x1000200000000000UL; }
 unsigned long foo_0x2000200000000000(void) { return 0x2000200000000000UL; }
 unsigned long foo_0x4000200000000000(void) { return 0x4000200000000000UL; }
 unsigned long foo_0x8000200000000000(void) { return 0x8000200000000000UL; }
 unsigned long foo_0xc00000000000(void) { return 0xc00000000000UL; }
 unsigned long foo_0x1400000000000(void) { return 0x1400000000000UL; }
 unsigned long foo_0x2400000000000(void) { return 0x2400000000000UL; }
 unsigned long foo_0x4400000000000(void) { return 0x4400000000000UL; }
 unsigned long foo_0x8400000000000(void) { return 0x8400000000000UL; }
 unsigned long foo_0x10400000000000(void) { return 0x10400000000000UL; }
 unsigned long foo_0x20400000000000(void) { return 0x20400000000000UL; }
 unsigned long foo_0x40400000000000(void) { return 0x40400000000000UL; }
 unsigned long foo_0x80400000000000(void) { return 0x80400000000000UL; }
 unsigned long foo_0x100400000000000(void) { return 0x100400000000000UL; }
 unsigned long foo_0x200400000000000(void) { return 0x200400000000000UL; }
 unsigned long foo_0x400400000000000(void) { return 0x400400000000000UL; }
 unsigned long foo_0x800400000000000(void) { return 0x800400000000000UL; }
 unsigned long foo_0x1000400000000000(void) { return 0x1000400000000000UL; }
 unsigned long foo_0x2000400000000000(void) { return 0x2000400000000000UL; }
 unsigned long foo_0x4000400000000000(void) { return 0x4000400000000000UL; }
 unsigned long foo_0x8000400000000000(void) { return 0x8000400000000000UL; }
 unsigned long foo_0x1800000000000(void) { return 0x1800000000000UL; }
 unsigned long foo_0x2800000000000(void) { return 0x2800000000000UL; }
 unsigned long foo_0x4800000000000(void) { return 0x4800000000000UL; }
 unsigned long foo_0x8800000000000(void) { return 0x8800000000000UL; }
 unsigned long foo_0x10800000000000(void) { return 0x10800000000000UL; }
 unsigned long foo_0x20800000000000(void) { return 0x20800000000000UL; }
 unsigned long foo_0x40800000000000(void) { return 0x40800000000000UL; }
 unsigned long foo_0x80800000000000(void) { return 0x80800000000000UL; }
 unsigned long foo_0x100800000000000(void) { return 0x100800000000000UL; }
 unsigned long foo_0x200800000000000(void) { return 0x200800000000000UL; }
 unsigned long foo_0x400800000000000(void) { return 0x400800000000000UL; }
 unsigned long foo_0x800800000000000(void) { return 0x800800000000000UL; }
 unsigned long foo_0x1000800000000000(void) { return 0x1000800000000000UL; }
 unsigned long foo_0x2000800000000000(void) { return 0x2000800000000000UL; }
 unsigned long foo_0x4000800000000000(void) { return 0x4000800000000000UL; }
 unsigned long foo_0x8000800000000000(void) { return 0x8000800000000000UL; }
 unsigned long foo_0x3000000000000(void) { return 0x3000000000000UL; }
 unsigned long foo_0x5000000000000(void) { return 0x5000000000000UL; }
 unsigned long foo_0x9000000000000(void) { return 0x9000000000000UL; }
 unsigned long foo_0x11000000000000(void) { return 0x11000000000000UL; }
 unsigned long foo_0x21000000000000(void) { return 0x21000000000000UL; }
 unsigned long foo_0x41000000000000(void) { return 0x41000000000000UL; }
 unsigned long foo_0x81000000000000(void) { return 0x81000000000000UL; }
 unsigned long foo_0x101000000000000(void) { return 0x101000000000000UL; }
 unsigned long foo_0x201000000000000(void) { return 0x201000000000000UL; }
 unsigned long foo_0x401000000000000(void) { return 0x401000000000000UL; }
 unsigned long foo_0x801000000000000(void) { return 0x801000000000000UL; }
 unsigned long foo_0x1001000000000000(void) { return 0x1001000000000000UL; }
 unsigned long foo_0x2001000000000000(void) { return 0x2001000000000000UL; }
 unsigned long foo_0x4001000000000000(void) { return 0x4001000000000000UL; }
 unsigned long foo_0x8001000000000000(void) { return 0x8001000000000000UL; }
 unsigned long foo_0x6000000000000(void) { return 0x6000000000000UL; }
 unsigned long foo_0xa000000000000(void) { return 0xa000000000000UL; }
 unsigned long foo_0x12000000000000(void) { return 0x12000000000000UL; }
 unsigned long foo_0x22000000000000(void) { return 0x22000000000000UL; }
 unsigned long foo_0x42000000000000(void) { return 0x42000000000000UL; }
 unsigned long foo_0x82000000000000(void) { return 0x82000000000000UL; }
 unsigned long foo_0x102000000000000(void) { return 0x102000000000000UL; }
 unsigned long foo_0x202000000000000(void) { return 0x202000000000000UL; }
 unsigned long foo_0x402000000000000(void) { return 0x402000000000000UL; }
 unsigned long foo_0x802000000000000(void) { return 0x802000000000000UL; }
 unsigned long foo_0x1002000000000000(void) { return 0x1002000000000000UL; }
 unsigned long foo_0x2002000000000000(void) { return 0x2002000000000000UL; }
 unsigned long foo_0x4002000000000000(void) { return 0x4002000000000000UL; }
 unsigned long foo_0x8002000000000000(void) { return 0x8002000000000000UL; }
 unsigned long foo_0xc000000000000(void) { return 0xc000000000000UL; }
 unsigned long foo_0x14000000000000(void) { return 0x14000000000000UL; }
 unsigned long foo_0x24000000000000(void) { return 0x24000000000000UL; }
 unsigned long foo_0x44000000000000(void) { return 0x44000000000000UL; }
 unsigned long foo_0x84000000000000(void) { return 0x84000000000000UL; }
 unsigned long foo_0x104000000000000(void) { return 0x104000000000000UL; }
 unsigned long foo_0x204000000000000(void) { return 0x204000000000000UL; }
 unsigned long foo_0x404000000000000(void) { return 0x404000000000000UL; }
 unsigned long foo_0x804000000000000(void) { return 0x804000000000000UL; }
 unsigned long foo_0x1004000000000000(void) { return 0x1004000000000000UL; }
 unsigned long foo_0x2004000000000000(void) { return 0x2004000000000000UL; }
 unsigned long foo_0x4004000000000000(void) { return 0x4004000000000000UL; }
 unsigned long foo_0x8004000000000000(void) { return 0x8004000000000000UL; }
 unsigned long foo_0x18000000000000(void) { return 0x18000000000000UL; }
 unsigned long foo_0x28000000000000(void) { return 0x28000000000000UL; }
 unsigned long foo_0x48000000000000(void) { return 0x48000000000000UL; }
 unsigned long foo_0x88000000000000(void) { return 0x88000000000000UL; }
 unsigned long foo_0x108000000000000(void) { return 0x108000000000000UL; }
 unsigned long foo_0x208000000000000(void) { return 0x208000000000000UL; }
 unsigned long foo_0x408000000000000(void) { return 0x408000000000000UL; }
 unsigned long foo_0x808000000000000(void) { return 0x808000000000000UL; }
 unsigned long foo_0x1008000000000000(void) { return 0x1008000000000000UL; }
 unsigned long foo_0x2008000000000000(void) { return 0x2008000000000000UL; }
 unsigned long foo_0x4008000000000000(void) { return 0x4008000000000000UL; }
 unsigned long foo_0x8008000000000000(void) { return 0x8008000000000000UL; }
 unsigned long foo_0x30000000000000(void) { return 0x30000000000000UL; }
 unsigned long foo_0x50000000000000(void) { return 0x50000000000000UL; }
 unsigned long foo_0x90000000000000(void) { return 0x90000000000000UL; }
 unsigned long foo_0x110000000000000(void) { return 0x110000000000000UL; }
 unsigned long foo_0x210000000000000(void) { return 0x210000000000000UL; }
 unsigned long foo_0x410000000000000(void) { return 0x410000000000000UL; }
 unsigned long foo_0x810000000000000(void) { return 0x810000000000000UL; }
 unsigned long foo_0x1010000000000000(void) { return 0x1010000000000000UL; }
 unsigned long foo_0x2010000000000000(void) { return 0x2010000000000000UL; }
 unsigned long foo_0x4010000000000000(void) { return 0x4010000000000000UL; }
 unsigned long foo_0x8010000000000000(void) { return 0x8010000000000000UL; }
 unsigned long foo_0x60000000000000(void) { return 0x60000000000000UL; }
 unsigned long foo_0xa0000000000000(void) { return 0xa0000000000000UL; }
 unsigned long foo_0x120000000000000(void) { return 0x120000000000000UL; }
 unsigned long foo_0x220000000000000(void) { return 0x220000000000000UL; }
 unsigned long foo_0x420000000000000(void) { return 0x420000000000000UL; }
 unsigned long foo_0x820000000000000(void) { return 0x820000000000000UL; }
 unsigned long foo_0x1020000000000000(void) { return 0x1020000000000000UL; }
 unsigned long foo_0x2020000000000000(void) { return 0x2020000000000000UL; }
 unsigned long foo_0x4020000000000000(void) { return 0x4020000000000000UL; }
 unsigned long foo_0x8020000000000000(void) { return 0x8020000000000000UL; }
 unsigned long foo_0xc0000000000000(void) { return 0xc0000000000000UL; }
 unsigned long foo_0x140000000000000(void) { return 0x140000000000000UL; }
 unsigned long foo_0x240000000000000(void) { return 0x240000000000000UL; }
 unsigned long foo_0x440000000000000(void) { return 0x440000000000000UL; }
 unsigned long foo_0x840000000000000(void) { return 0x840000000000000UL; }
 unsigned long foo_0x1040000000000000(void) { return 0x1040000000000000UL; }
 unsigned long foo_0x2040000000000000(void) { return 0x2040000000000000UL; }
 unsigned long foo_0x4040000000000000(void) { return 0x4040000000000000UL; }
 unsigned long foo_0x8040000000000000(void) { return 0x8040000000000000UL; }
 unsigned long foo_0x180000000000000(void) { return 0x180000000000000UL; }
 unsigned long foo_0x280000000000000(void) { return 0x280000000000000UL; }
 unsigned long foo_0x480000000000000(void) { return 0x480000000000000UL; }
 unsigned long foo_0x880000000000000(void) { return 0x880000000000000UL; }
 unsigned long foo_0x1080000000000000(void) { return 0x1080000000000000UL; }
 unsigned long foo_0x2080000000000000(void) { return 0x2080000000000000UL; }
 unsigned long foo_0x4080000000000000(void) { return 0x4080000000000000UL; }
 unsigned long foo_0x8080000000000000(void) { return 0x8080000000000000UL; }
 unsigned long foo_0x300000000000000(void) { return 0x300000000000000UL; }
 unsigned long foo_0x500000000000000(void) { return 0x500000000000000UL; }
 unsigned long foo_0x900000000000000(void) { return 0x900000000000000UL; }
 unsigned long foo_0x1100000000000000(void) { return 0x1100000000000000UL; }
 unsigned long foo_0x2100000000000000(void) { return 0x2100000000000000UL; }
 unsigned long foo_0x4100000000000000(void) { return 0x4100000000000000UL; }
 unsigned long foo_0x8100000000000000(void) { return 0x8100000000000000UL; }
 unsigned long foo_0x600000000000000(void) { return 0x600000000000000UL; }
 unsigned long foo_0xa00000000000000(void) { return 0xa00000000000000UL; }
 unsigned long foo_0x1200000000000000(void) { return 0x1200000000000000UL; }
 unsigned long foo_0x2200000000000000(void) { return 0x2200000000000000UL; }
 unsigned long foo_0x4200000000000000(void) { return 0x4200000000000000UL; }
 unsigned long foo_0x8200000000000000(void) { return 0x8200000000000000UL; }
 unsigned long foo_0xc00000000000000(void) { return 0xc00000000000000UL; }
 unsigned long foo_0x1400000000000000(void) { return 0x1400000000000000UL; }
 unsigned long foo_0x2400000000000000(void) { return 0x2400000000000000UL; }
 unsigned long foo_0x4400000000000000(void) { return 0x4400000000000000UL; }
 unsigned long foo_0x8400000000000000(void) { return 0x8400000000000000UL; }
 unsigned long foo_0x1800000000000000(void) { return 0x1800000000000000UL; }
 unsigned long foo_0x2800000000000000(void) { return 0x2800000000000000UL; }
 unsigned long foo_0x4800000000000000(void) { return 0x4800000000000000UL; }
 unsigned long foo_0x8800000000000000(void) { return 0x8800000000000000UL; }
 unsigned long foo_0x3000000000000000(void) { return 0x3000000000000000UL; }
 unsigned long foo_0x5000000000000000(void) { return 0x5000000000000000UL; }
 unsigned long foo_0x9000000000000000(void) { return 0x9000000000000000UL; }
 unsigned long foo_0x6000000000000000(void) { return 0x6000000000000000UL; }
 unsigned long foo_0xa000000000000000(void) { return 0xa000000000000000UL; }
 unsigned long foo_0xc000000000000000(void) { return 0xc000000000000000UL; }


