---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab config`

Set and get glab settings.

## Synopsis

Get and set key/value strings.

Current respected settings:

- token: Your GitLab access token. Defaults to environment variables.
- host: If unset, defaults to `https://gitlab.com`.
- browser: If unset, uses the default browser. Override with environment variable $BROWSER.
- editor: If unset, uses the default editor. Override with environment variable $EDITOR.
- visual: Takes precedence over 'editor'. If unset, uses the default editor. Override with environment variable $VISUAL.
- glamour_style: Your desired Markdown renderer style. Options are dark, light, notty. Custom styles are available using [glamour](https://github.com/charmbracelet/glamour#styles).
- glab_pager: Your desired pager command to use, such as 'less -R'.
- check_update: If true, notifies of new versions of glab. Defaults to true.
- display_hyperlinks: If true, and using a TTY, outputs hyperlinks for issues and merge request lists. Defaults to false.

## Aliases

```plaintext
conf
```

## Options

```plaintext
  -g, --global   Use global config file.
```

## Options inherited from parent commands

```plaintext
      --help   Show help for this command.
```

## Subcommands

- [`get`](get.md)
- [`set`](set.md)
