// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#ifndef GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_15_15_H
#define GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_15_15_H
#include <cstddef>
#include <cstdint>

#include <grpc/support/port_platform.h>
namespace grpc_core {
namespace geometry_15_15 {
class HuffDecoderCommon {
 protected:
  static inline uint64_t GetOp2(size_t i) { return table2_0_ops_[i]; }
  static inline uint64_t GetEmit2(size_t, size_t emit) {
    return table2_0_emit_[emit];
  }
  static inline uint64_t GetOp3(size_t i) { return table3_0_ops_[i]; }
  static inline uint64_t GetEmit3(size_t, size_t emit) {
    return table3_0_emit_[emit];
  }
  static inline uint64_t GetOp4(size_t i) {
    return table4_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit4(size_t i, size_t emit) {
    return table4_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp5(size_t i) {
    return table5_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit5(size_t i, size_t emit) {
    return table5_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp6(size_t i) {
    return table6_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit6(size_t i, size_t emit) {
    return table6_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp7(size_t i) {
    return table7_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit7(size_t i, size_t emit) {
    return table7_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp8(size_t i) {
    return table8_inner_[i >> 6][table8_outer_[i >> 6][i & 0x3f]];
  }
  static inline uint64_t GetEmit8(size_t i, size_t emit) {
    return table8_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp9(size_t i) {
    return table9_ops_[i >> 5][i & 0x1f];
  }
  static inline uint64_t GetEmit9(size_t i, size_t emit) {
    return table9_emit_[i >> 5][emit];
  }
  static inline uint64_t GetOp10(size_t i) {
    return table10_inner_[i >> 6][table10_outer_[i >> 6][i & 0x3f]];
  }
  static inline uint64_t GetEmit10(size_t i, size_t emit) {
    return table10_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp11(size_t i) {
    return table11_inner_[i >> 6][table11_outer_[i >> 6][i & 0x3f]];
  }
  static inline uint64_t GetEmit11(size_t i, size_t emit) {
    return table11_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp1(size_t i) {
    return table1_inner_[i >> 6][table1_outer_[i >> 6][i & 0x3f]];
  }
  static inline uint64_t GetEmit1(size_t i, size_t emit) {
    return table1_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp13(size_t i) {
    return table13_0_inner_[(i < 3 ? (i) : ((i - 3) / 12 + 3))];
  }
  static inline uint64_t GetEmit13(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 92)) : ((emit - 1) ? 208 : 195));
  }
  static inline uint64_t GetOp14(size_t i) { return table14_0_ops_[i]; }
  static inline uint64_t GetEmit14(size_t, size_t emit) {
    return table14_0_emit_[emit];
  }
  static inline uint64_t GetOp15(size_t i) { return table15_0_ops_[i]; }
  static inline uint64_t GetEmit15(size_t, size_t emit) {
    return table15_0_emit_[emit];
  }
  static inline uint64_t GetOp16(size_t i) { return table16_0_ops_[i]; }
  static inline uint64_t GetEmit16(size_t, size_t emit) {
    return table16_0_emit_[emit];
  }
  static inline uint64_t GetOp17(size_t i) {
    return table17_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit17(size_t i, size_t emit) {
    return table17_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp18(size_t i) {
    return table18_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit18(size_t i, size_t emit) {
    return table18_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp19(size_t i) {
    return table19_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit19(size_t i, size_t emit) {
    return table19_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp20(size_t i) {
    return table20_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit20(size_t i, size_t emit) {
    return table20_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp21(size_t i) {
    return table21_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit21(size_t i, size_t emit) {
    return table21_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp22(size_t i) {
    return table22_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit22(size_t i, size_t emit) {
    return table22_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp23(size_t i) {
    return table23_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit23(size_t i, size_t emit) {
    return table23_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp12(size_t i) {
    return table12_ops_[i >> 8][i & 0xff];
  }
  static inline uint64_t GetEmit12(size_t i, size_t emit) {
    return table12_emit_[i >> 8][emit];
  }

 private:
  static const uint8_t table2_0_emit_[10];
  static const uint8_t table2_0_ops_[32];
  static const uint8_t table3_0_emit_[36];
  static const uint8_t table3_0_ops_[64];
  static const uint8_t table4_0_emit_[22];
  static const uint8_t table4_0_ops_[64];
  static const uint8_t table4_1_emit_[46];
  static const uint8_t table4_1_ops_[64];
  static const uint8_t* const table4_emit_[2];
  static const uint8_t* const table4_ops_[2];
  static const uint8_t table5_0_ops_[128];
  static const uint8_t table5_1_emit_[52];
  static const uint8_t table5_1_ops_[128];
  static const uint8_t* const table5_emit_[2];
  static const uint8_t* const table5_ops_[2];
  static const uint8_t table6_0_emit_[2];
  static const uint8_t table6_0_ops_[32];
  static const uint8_t table6_1_emit_[2];
  static const uint8_t table6_2_emit_[2];
  static const uint8_t table6_3_emit_[2];
  static const uint8_t table6_4_emit_[2];
  static const uint8_t table6_5_emit_[4];
  static const uint8_t table6_5_ops_[32];
  static const uint8_t table6_6_emit_[4];
  static const uint8_t table6_7_emit_[4];
  static const uint8_t table6_8_emit_[4];
  static const uint8_t table6_9_emit_[4];
  static const uint8_t table6_10_emit_[4];
  static const uint8_t table6_11_emit_[6];
  static const uint8_t table6_11_ops_[32];
  static const uint8_t table6_12_emit_[8];
  static const uint8_t table6_12_ops_[32];
  static const uint8_t table6_13_emit_[8];
  static const uint8_t table6_14_emit_[8];
  static const uint8_t table6_15_emit_[10];
  static const uint8_t table6_15_ops_[32];
  static const uint8_t* const table6_emit_[16];
  static const uint8_t* const table6_ops_[16];
  static const uint8_t table7_0_emit_[36];
  static const uint8_t table7_0_ops_[64];
  static const uint8_t table7_1_emit_[36];
  static const uint8_t table7_1_ops_[64];
  static const uint8_t table7_2_emit_[36];
  static const uint8_t table7_2_ops_[64];
  static const uint8_t table7_3_emit_[36];
  static const uint8_t table7_3_ops_[64];
  static const uint8_t table7_4_emit_[38];
  static const uint8_t table7_4_ops_[64];
  static const uint8_t table7_5_ops_[64];
  static const uint8_t table7_11_ops_[64];
  static const uint8_t table7_12_ops_[64];
  static const uint8_t table7_15_emit_[15];
  static const uint8_t table7_15_ops_[64];
  static const uint8_t* const table7_emit_[16];
  static const uint8_t* const table7_ops_[16];
  static const uint8_t table8_0_emit_[71];
  static const uint16_t table8_0_inner_[38];
  static const uint8_t table8_0_outer_[64];
  static const uint8_t table8_1_emit_[71];
  static const uint16_t table8_1_inner_[38];
  static const uint8_t table8_2_emit_[71];
  static const uint16_t table8_2_inner_[38];
  static const uint8_t table8_3_emit_[71];
  static const uint16_t table8_3_inner_[38];
  static const uint8_t table8_4_emit_[71];
  static const uint16_t table8_4_inner_[38];
  static const uint8_t table8_5_emit_[71];
  static const uint16_t table8_5_inner_[38];
  static const uint8_t table8_6_emit_[71];
  static const uint16_t table8_6_inner_[38];
  static const uint8_t table8_7_emit_[71];
  static const uint16_t table8_7_inner_[38];
  static const uint8_t table8_8_emit_[71];
  static const uint16_t table8_8_inner_[38];
  static const uint8_t table8_9_emit_[71];
  static const uint16_t table8_9_inner_[38];
  static const uint8_t table8_10_emit_[40];
  static const uint16_t table8_10_inner_[23];
  static const uint8_t table8_10_outer_[64];
  static const uint8_t table8_11_emit_[40];
  static const uint8_t table8_12_emit_[40];
  static const uint8_t table8_13_emit_[40];
  static const uint8_t table8_14_emit_[40];
  static const uint8_t table8_15_emit_[40];
  static const uint8_t table8_16_emit_[40];
  static const uint8_t table8_17_emit_[40];
  static const uint8_t table8_18_emit_[40];
  static const uint8_t table8_19_emit_[40];
  static const uint8_t table8_20_emit_[40];
  static const uint8_t table8_21_emit_[40];
  static const uint8_t table8_22_emit_[40];
  static const uint8_t table8_23_emit_[4];
  static const uint16_t table8_23_inner_[5];
  static const uint8_t table8_23_outer_[64];
  static const uint8_t table8_24_emit_[4];
  static const uint8_t table8_25_emit_[4];
  static const uint8_t table8_26_emit_[4];
  static const uint8_t table8_27_emit_[4];
  static const uint8_t table8_28_emit_[4];
  static const uint8_t table8_29_emit_[4];
  static const uint8_t table8_30_emit_[4];
  static const uint8_t table8_31_emit_[14];
  static const uint16_t table8_31_inner_[16];
  static const uint8_t table8_31_outer_[64];
  static const uint8_t* const table8_emit_[32];
  static const uint16_t* const table8_inner_[32];
  static const uint8_t* const table8_outer_[32];
  static const uint8_t table9_0_emit_[15];
  static const uint8_t table9_0_ops_[32];
  static const uint8_t table9_1_emit_[28];
  static const uint8_t table9_1_ops_[32];
  static const uint8_t table9_2_emit_[36];
  static const uint8_t table9_2_ops_[32];
  static const uint8_t table9_3_emit_[56];
  static const uint8_t table9_3_ops_[32];
  static const uint8_t table9_4_emit_[15];
  static const uint8_t table9_4_ops_[32];
  static const uint8_t table9_5_emit_[28];
  static const uint8_t table9_6_emit_[36];
  static const uint8_t table9_7_emit_[56];
  static const uint8_t table9_8_emit_[15];
  static const uint8_t table9_8_ops_[32];
  static const uint8_t table9_9_emit_[28];
  static const uint8_t table9_10_emit_[36];
  static const uint8_t table9_11_emit_[56];
  static const uint8_t table9_12_emit_[15];
  static const uint8_t table9_12_ops_[32];
  static const uint8_t table9_13_emit_[28];
  static const uint8_t table9_14_emit_[36];
  static const uint8_t table9_15_emit_[56];
  static const uint8_t table9_16_emit_[15];
  static const uint8_t table9_16_ops_[32];
  static const uint8_t table9_17_emit_[28];
  static const uint8_t table9_18_emit_[36];
  static const uint8_t table9_19_emit_[56];
  static const uint8_t table9_20_emit_[15];
  static const uint8_t table9_20_ops_[32];
  static const uint8_t table9_21_emit_[28];
  static const uint8_t table9_22_emit_[36];
  static const uint8_t table9_23_emit_[56];
  static const uint8_t table9_24_emit_[15];
  static const uint8_t table9_24_ops_[32];
  static const uint8_t table9_25_emit_[28];
  static const uint8_t table9_26_emit_[36];
  static const uint8_t table9_27_emit_[56];
  static const uint8_t table9_28_emit_[16];
  static const uint8_t table9_28_ops_[32];
  static const uint8_t table9_29_emit_[28];
  static const uint8_t table9_30_emit_[36];
  static const uint8_t table9_31_emit_[56];
  static const uint8_t table9_32_emit_[16];
  static const uint8_t table9_33_emit_[27];
  static const uint8_t table9_33_ops_[32];
  static const uint8_t table9_34_emit_[36];
  static const uint8_t table9_35_emit_[56];
  static const uint8_t table9_36_emit_[16];
  static const uint8_t table9_37_emit_[27];
  static const uint8_t table9_37_ops_[32];
  static const uint8_t table9_38_emit_[36];
  static const uint8_t table9_39_emit_[56];
  static const uint8_t table9_40_emit_[43];
  static const uint8_t table9_40_ops_[32];
  static const uint8_t table9_41_emit_[28];
  static const uint8_t table9_41_ops_[32];
  static const uint8_t table9_42_emit_[43];
  static const uint8_t table9_42_ops_[32];
  static const uint8_t table9_43_emit_[28];
  static const uint8_t table9_44_emit_[43];
  static const uint8_t table9_44_ops_[32];
  static const uint8_t table9_45_emit_[28];
  static const uint8_t table9_46_emit_[43];
  static const uint8_t table9_46_ops_[32];
  static const uint8_t table9_47_emit_[28];
  static const uint8_t table9_48_emit_[43];
  static const uint8_t table9_48_ops_[32];
  static const uint8_t table9_49_emit_[28];
  static const uint8_t table9_50_emit_[43];
  static const uint8_t table9_50_ops_[32];
  static const uint8_t table9_51_emit_[28];
  static const uint8_t table9_52_emit_[43];
  static const uint8_t table9_52_ops_[32];
  static const uint8_t table9_53_emit_[28];
  static const uint8_t table9_54_emit_[43];
  static const uint8_t table9_54_ops_[32];
  static const uint8_t table9_55_emit_[28];
  static const uint8_t table9_56_emit_[43];
  static const uint8_t table9_56_ops_[32];
  static const uint8_t table9_57_emit_[28];
  static const uint8_t table9_58_emit_[43];
  static const uint8_t table9_58_ops_[32];
  static const uint8_t table9_59_emit_[28];
  static const uint8_t table9_60_emit_[43];
  static const uint8_t table9_60_ops_[32];
  static const uint8_t table9_61_emit_[28];
  static const uint8_t table9_62_emit_[44];
  static const uint8_t table9_62_ops_[32];
  static const uint8_t table9_63_emit_[28];
  static const uint8_t table9_64_emit_[44];
  static const uint8_t table9_65_emit_[27];
  static const uint8_t table9_65_ops_[32];
  static const uint8_t table9_66_emit_[44];
  static const uint8_t table9_67_emit_[27];
  static const uint8_t table9_67_ops_[32];
  static const uint8_t table9_68_emit_[44];
  static const uint8_t table9_69_emit_[27];
  static const uint8_t table9_69_ops_[32];
  static const uint8_t table9_70_emit_[44];
  static const uint8_t table9_71_emit_[27];
  static const uint8_t table9_71_ops_[32];
  static const uint8_t table9_72_emit_[44];
  static const uint8_t table9_73_emit_[27];
  static const uint8_t table9_73_ops_[32];
  static const uint8_t table9_74_emit_[44];
  static const uint8_t table9_75_emit_[27];
  static const uint8_t table9_75_ops_[32];
  static const uint8_t table9_76_emit_[44];
  static const uint8_t table9_77_emit_[27];
  static const uint8_t table9_77_ops_[32];
  static const uint8_t table9_78_emit_[44];
  static const uint8_t table9_79_emit_[27];
  static const uint8_t table9_79_ops_[32];
  static const uint8_t table9_80_emit_[44];
  static const uint8_t table9_81_emit_[27];
  static const uint8_t table9_81_ops_[32];
  static const uint8_t table9_82_emit_[44];
  static const uint8_t table9_83_emit_[27];
  static const uint8_t table9_83_ops_[32];
  static const uint8_t table9_84_emit_[44];
  static const uint8_t table9_85_emit_[27];
  static const uint8_t table9_85_ops_[32];
  static const uint8_t table9_86_emit_[44];
  static const uint8_t table9_87_emit_[27];
  static const uint8_t table9_87_ops_[32];
  static const uint8_t table9_88_emit_[44];
  static const uint8_t table9_89_emit_[27];
  static const uint8_t table9_89_ops_[32];
  static const uint8_t table9_90_emit_[44];
  static const uint8_t table9_91_emit_[28];
  static const uint8_t table9_92_emit_[20];
  static const uint8_t table9_92_ops_[32];
  static const uint8_t table9_93_emit_[20];
  static const uint8_t table9_94_emit_[20];
  static const uint8_t table9_95_emit_[20];
  static const uint8_t table9_96_emit_[20];
  static const uint8_t table9_97_emit_[20];
  static const uint8_t table9_98_emit_[20];
  static const uint8_t table9_99_emit_[20];
  static const uint8_t table9_100_emit_[20];
  static const uint8_t table9_101_emit_[20];
  static const uint8_t table9_102_emit_[20];
  static const uint8_t table9_103_emit_[20];
  static const uint8_t table9_104_emit_[20];
  static const uint8_t table9_105_emit_[20];
  static const uint8_t table9_106_emit_[20];
  static const uint8_t table9_107_emit_[20];
  static const uint8_t table9_108_emit_[20];
  static const uint8_t table9_109_emit_[20];
  static const uint8_t table9_110_emit_[20];
  static const uint8_t table9_111_emit_[20];
  static const uint8_t table9_112_emit_[20];
  static const uint8_t table9_113_emit_[20];
  static const uint8_t table9_114_emit_[20];
  static const uint8_t table9_115_emit_[20];
  static const uint8_t table9_116_emit_[20];
  static const uint8_t table9_117_emit_[20];
  static const uint8_t table9_118_emit_[20];
  static const uint8_t table9_119_emit_[20];
  static const uint8_t table9_120_emit_[20];
  static const uint8_t table9_121_emit_[20];
  static const uint8_t table9_122_emit_[20];
  static const uint8_t table9_123_emit_[20];
  static const uint8_t table9_124_emit_[2];
  static const uint8_t table9_124_ops_[32];
  static const uint8_t table9_125_emit_[2];
  static const uint8_t table9_126_emit_[2];
  static const uint8_t table9_127_emit_[10];
  static const uint8_t table9_127_ops_[32];
  static const uint8_t* const table9_emit_[128];
  static const uint8_t* const table9_ops_[128];
  static const uint16_t table10_0_inner_[9];
  static const uint8_t table10_0_outer_[64];
  static const uint16_t table10_1_inner_[15];
  static const uint8_t table10_1_outer_[64];
  static const uint16_t table10_2_inner_[19];
  static const uint8_t table10_2_outer_[64];
  static const uint8_t table10_3_emit_[68];
  static const uint16_t table10_3_inner_[36];
  static const uint8_t table10_3_outer_[64];
  static const uint16_t table10_4_inner_[9];
  static const uint8_t table10_7_emit_[68];
  static const uint16_t table10_8_inner_[9];
  static const uint8_t table10_11_emit_[68];
  static const uint16_t table10_12_inner_[9];
  static const uint8_t table10_15_emit_[68];
  static const uint16_t table10_16_inner_[9];
  static const uint8_t table10_19_emit_[68];
  static const uint16_t table10_20_inner_[9];
  static const uint8_t table10_23_emit_[68];
  static const uint16_t table10_24_inner_[9];
  static const uint8_t table10_27_emit_[68];
  static const uint16_t table10_28_inner_[9];
  static const uint8_t table10_31_emit_[68];
  static const uint16_t table10_33_inner_[15];
  static const uint8_t table10_35_emit_[68];
  static const uint16_t table10_37_inner_[15];
  static const uint8_t table10_39_emit_[68];
  static const uint16_t table10_40_inner_[23];
  static const uint8_t table10_40_outer_[64];
  static const uint8_t table10_41_emit_[92];
  static const uint16_t table10_41_inner_[48];
  static const uint8_t table10_41_outer_[64];
  static const uint16_t table10_42_inner_[23];
  static const uint8_t table10_43_emit_[92];
  static const uint16_t table10_44_inner_[23];
  static const uint8_t table10_45_emit_[92];
  static const uint16_t table10_46_inner_[23];
  static const uint8_t table10_47_emit_[92];
  static const uint16_t table10_48_inner_[23];
  static const uint8_t table10_49_emit_[92];
  static const uint16_t table10_50_inner_[23];
  static const uint8_t table10_51_emit_[92];
  static const uint16_t table10_52_inner_[23];
  static const uint8_t table10_53_emit_[92];
  static const uint16_t table10_54_inner_[23];
  static const uint8_t table10_55_emit_[92];
  static const uint16_t table10_56_inner_[23];
  static const uint8_t table10_57_emit_[92];
  static const uint16_t table10_58_inner_[23];
  static const uint8_t table10_59_emit_[92];
  static const uint16_t table10_60_inner_[23];
  static const uint8_t table10_61_emit_[92];
  static const uint16_t table10_62_inner_[23];
  static const uint8_t table10_63_emit_[92];
  static const uint8_t table10_65_emit_[91];
  static const uint16_t table10_65_inner_[48];
  static const uint8_t table10_67_emit_[91];
  static const uint16_t table10_67_inner_[48];
  static const uint8_t table10_69_emit_[91];
  static const uint16_t table10_69_inner_[48];
  static const uint8_t table10_71_emit_[91];
  static const uint16_t table10_71_inner_[48];
  static const uint8_t table10_73_emit_[91];
  static const uint16_t table10_73_inner_[48];
  static const uint8_t table10_75_emit_[91];
  static const uint16_t table10_75_inner_[48];
  static const uint8_t table10_77_emit_[91];
  static const uint16_t table10_77_inner_[48];
  static const uint8_t table10_79_emit_[91];
  static const uint16_t table10_79_inner_[48];
  static const uint8_t table10_81_emit_[91];
  static const uint16_t table10_81_inner_[48];
  static const uint8_t table10_83_emit_[91];
  static const uint16_t table10_83_inner_[48];
  static const uint8_t table10_85_emit_[91];
  static const uint16_t table10_85_inner_[48];
  static const uint8_t table10_87_emit_[91];
  static const uint16_t table10_87_inner_[48];
  static const uint8_t table10_89_emit_[91];
  static const uint16_t table10_89_inner_[48];
  static const uint8_t table10_91_emit_[91];
  static const uint16_t table10_91_inner_[48];
  static const uint8_t table10_92_emit_[72];
  static const uint16_t table10_92_inner_[38];
  static const uint8_t table10_93_emit_[72];
  static const uint8_t table10_94_emit_[72];
  static const uint8_t table10_95_emit_[72];
  static const uint8_t table10_96_emit_[72];
  static const uint8_t table10_97_emit_[72];
  static const uint8_t table10_98_emit_[72];
  static const uint8_t table10_99_emit_[72];
  static const uint8_t table10_100_emit_[72];
  static const uint8_t table10_101_emit_[72];
  static const uint8_t table10_102_emit_[72];
  static const uint8_t table10_103_emit_[72];
  static const uint8_t table10_104_emit_[72];
  static const uint8_t table10_105_emit_[72];
  static const uint8_t table10_106_emit_[72];
  static const uint8_t table10_107_emit_[72];
  static const uint8_t table10_108_emit_[72];
  static const uint8_t table10_109_emit_[72];
  static const uint8_t table10_110_emit_[72];
  static const uint8_t table10_111_emit_[72];
  static const uint8_t table10_112_emit_[72];
  static const uint8_t table10_113_emit_[72];
  static const uint8_t table10_114_emit_[72];
  static const uint8_t table10_115_emit_[72];
  static const uint8_t table10_116_emit_[72];
  static const uint8_t table10_117_emit_[72];
  static const uint8_t table10_118_emit_[72];
  static const uint8_t table10_119_emit_[72];
  static const uint8_t table10_120_emit_[72];
  static const uint8_t table10_121_emit_[72];
  static const uint8_t table10_122_emit_[72];
  static const uint8_t table10_123_emit_[72];
  static const uint8_t table10_124_emit_[40];
  static const uint8_t table10_125_emit_[40];
  static const uint8_t table10_126_emit_[40];
  static const uint8_t table10_127_emit_[16];
  static const uint16_t table10_127_inner_[18];
  static const uint8_t table10_127_outer_[64];
  static const uint8_t* const table10_emit_[128];
  static const uint16_t* const table10_inner_[128];
  static const uint8_t* const table10_outer_[128];
  static const uint8_t table11_0_emit_[7];
  static const uint16_t table11_0_inner_[5];
  static const uint8_t table11_1_emit_[8];
  static const uint16_t table11_1_inner_[5];
  static const uint8_t table11_2_emit_[12];
  static const uint16_t table11_2_inner_[7];
  static const uint8_t table11_2_outer_[64];
  static const uint8_t table11_3_emit_[16];
  static const uint8_t table11_4_emit_[16];
  static const uint8_t table11_5_emit_[20];
  static const uint16_t table11_5_inner_[11];
  static const uint8_t table11_5_outer_[64];
  static const uint8_t table11_6_emit_[32];
  static const uint16_t table11_6_inner_[17];
  static const uint8_t table11_6_outer_[64];
  static const uint8_t table11_7_emit_[36];
  static const uint16_t table11_7_inner_[20];
  static const uint8_t table11_7_outer_[64];
  static const uint8_t table11_8_emit_[7];
  static const uint16_t table11_8_inner_[5];
  static const uint8_t table11_9_emit_[8];
  static const uint8_t table11_10_emit_[12];
  static const uint8_t table11_11_emit_[16];
  static const uint8_t table11_12_emit_[16];
  static const uint8_t table11_13_emit_[20];
  static const uint8_t table11_14_emit_[32];
  static const uint8_t table11_15_emit_[36];
  static const uint8_t table11_16_emit_[7];
  static const uint16_t table11_16_inner_[5];
  static const uint8_t table11_17_emit_[8];
  static const uint8_t table11_18_emit_[12];
  static const uint8_t table11_19_emit_[16];
  static const uint8_t table11_20_emit_[16];
  static const uint8_t table11_21_emit_[20];
  static const uint8_t table11_22_emit_[32];
  static const uint8_t table11_23_emit_[36];
  static const uint8_t table11_24_emit_[8];
  static const uint8_t table11_25_emit_[8];
  static const uint8_t table11_26_emit_[12];
  static const uint8_t table11_27_emit_[16];
  static const uint8_t table11_28_emit_[16];
  static const uint8_t table11_29_emit_[20];
  static const uint8_t table11_30_emit_[32];
  static const uint8_t table11_31_emit_[36];
  static const uint8_t table11_32_emit_[8];
  static const uint8_t table11_33_emit_[7];
  static const uint8_t table11_34_emit_[12];
  static const uint8_t table11_35_emit_[16];
  static const uint8_t table11_36_emit_[16];
  static const uint8_t table11_37_emit_[20];
  static const uint8_t table11_38_emit_[32];
  static const uint8_t table11_39_emit_[36];
  static const uint8_t table11_40_emit_[8];
  static const uint8_t table11_41_emit_[7];
  static const uint8_t table11_42_emit_[12];
  static const uint8_t table11_43_emit_[16];
  static const uint8_t table11_44_emit_[16];
  static const uint8_t table11_45_emit_[20];
  static const uint8_t table11_46_emit_[32];
  static const uint8_t table11_47_emit_[36];
  static const uint8_t table11_48_emit_[8];
  static const uint8_t table11_49_emit_[7];
  static const uint8_t table11_50_emit_[12];
  static const uint8_t table11_51_emit_[16];
  static const uint8_t table11_52_emit_[16];
  static const uint8_t table11_53_emit_[20];
  static const uint8_t table11_54_emit_[32];
  static const uint8_t table11_55_emit_[36];
  static const uint8_t table11_56_emit_[8];
  static const uint8_t table11_57_emit_[8];
  static const uint8_t table11_58_emit_[12];
  static const uint8_t table11_59_emit_[16];
  static const uint8_t table11_60_emit_[16];
  static const uint8_t table11_61_emit_[20];
  static const uint8_t table11_62_emit_[32];
  static const uint8_t table11_63_emit_[36];
  static const uint8_t table11_64_emit_[8];
  static const uint8_t table11_65_emit_[8];
  static const uint8_t table11_66_emit_[11];
  static const uint16_t table11_66_inner_[7];
  static const uint8_t table11_67_emit_[16];
  static const uint8_t table11_68_emit_[16];
  static const uint8_t table11_69_emit_[20];
  static const uint8_t table11_70_emit_[32];
  static const uint8_t table11_71_emit_[36];
  static const uint8_t table11_72_emit_[8];
  static const uint8_t table11_73_emit_[8];
  static const uint8_t table11_74_emit_[11];
  static const uint16_t table11_74_inner_[7];
  static const uint8_t table11_75_emit_[16];
  static const uint8_t table11_76_emit_[16];
  static const uint8_t table11_77_emit_[20];
  static const uint8_t table11_78_emit_[32];
  static const uint8_t table11_79_emit_[36];
  static const uint8_t table11_80_emit_[16];
  static const uint8_t table11_81_emit_[27];
  static const uint16_t table11_81_inner_[15];
  static const uint8_t table11_82_emit_[36];
  static const uint8_t table11_83_emit_[68];
  static const uint8_t table11_84_emit_[16];
  static const uint8_t table11_85_emit_[27];
  static const uint16_t table11_85_inner_[15];
  static const uint8_t table11_86_emit_[36];
  static const uint8_t table11_87_emit_[68];
  static const uint8_t table11_88_emit_[16];
  static const uint8_t table11_89_emit_[27];
  static const uint16_t table11_89_inner_[15];
  static const uint8_t table11_90_emit_[36];
  static const uint8_t table11_91_emit_[68];
  static const uint8_t table11_92_emit_[16];
  static const uint8_t table11_93_emit_[27];
  static const uint16_t table11_93_inner_[15];
  static const uint8_t table11_94_emit_[36];
  static const uint8_t table11_95_emit_[68];
  static const uint8_t table11_96_emit_[16];
  static const uint8_t table11_97_emit_[27];
  static const uint16_t table11_97_inner_[15];
  static const uint8_t table11_98_emit_[36];
  static const uint8_t table11_99_emit_[68];
  static const uint8_t table11_100_emit_[16];
  static const uint8_t table11_101_emit_[27];
  static const uint16_t table11_101_inner_[15];
  static const uint8_t table11_102_emit_[36];
  static const uint8_t table11_103_emit_[68];
  static const uint8_t table11_104_emit_[16];
  static const uint8_t table11_105_emit_[27];
  static const uint16_t table11_105_inner_[15];
  static const uint8_t table11_106_emit_[36];
  static const uint8_t table11_107_emit_[68];
  static const uint8_t table11_108_emit_[16];
  static const uint8_t table11_109_emit_[27];
  static const uint16_t table11_109_inner_[15];
  static const uint8_t table11_110_emit_[36];
  static const uint8_t table11_111_emit_[68];
  static const uint8_t table11_112_emit_[16];
  static const uint8_t table11_113_emit_[27];
  static const uint16_t table11_113_inner_[15];
  static const uint8_t table11_114_emit_[36];
  static const uint8_t table11_115_emit_[68];
  static const uint8_t table11_116_emit_[16];
  static const uint8_t table11_117_emit_[27];
  static const uint16_t table11_117_inner_[15];
  static const uint8_t table11_118_emit_[36];
  static const uint8_t table11_119_emit_[68];
  static const uint8_t table11_120_emit_[16];
  static const uint8_t table11_121_emit_[27];
  static const uint16_t table11_121_inner_[15];
  static const uint8_t table11_122_emit_[36];
  static const uint8_t table11_123_emit_[68];
  static const uint8_t table11_124_emit_[16];
  static const uint8_t table11_125_emit_[28];
  static const uint8_t table11_126_emit_[36];
  static const uint8_t table11_127_emit_[68];
  static const uint8_t table11_128_emit_[16];
  static const uint8_t table11_129_emit_[28];
  static const uint8_t table11_130_emit_[35];
  static const uint16_t table11_130_inner_[19];
  static const uint8_t table11_131_emit_[68];
  static const uint8_t table11_132_emit_[16];
  static const uint8_t table11_133_emit_[28];
  static const uint8_t table11_134_emit_[35];
  static const uint16_t table11_134_inner_[19];
  static const uint8_t table11_135_emit_[68];
  static const uint8_t table11_136_emit_[16];
  static const uint8_t table11_137_emit_[28];
  static const uint8_t table11_138_emit_[35];
  static const uint16_t table11_138_inner_[19];
  static const uint8_t table11_139_emit_[68];
  static const uint8_t table11_140_emit_[16];
  static const uint8_t table11_141_emit_[28];
  static const uint8_t table11_142_emit_[35];
  static const uint16_t table11_142_inner_[19];
  static const uint8_t table11_143_emit_[68];
  static const uint8_t table11_144_emit_[16];
  static const uint8_t table11_145_emit_[28];
  static const uint8_t table11_146_emit_[35];
  static const uint16_t table11_146_inner_[19];
  static const uint8_t table11_147_emit_[68];
  static const uint8_t table11_148_emit_[16];
  static const uint8_t table11_149_emit_[28];
  static const uint8_t table11_150_emit_[35];
  static const uint16_t table11_150_inner_[19];
  static const uint8_t table11_151_emit_[68];
  static const uint8_t table11_152_emit_[16];
  static const uint8_t table11_153_emit_[28];
  static const uint8_t table11_154_emit_[35];
  static const uint16_t table11_154_inner_[19];
  static const uint8_t table11_155_emit_[68];
  static const uint8_t table11_156_emit_[16];
  static const uint8_t table11_157_emit_[28];
  static const uint8_t table11_158_emit_[35];
  static const uint16_t table11_158_inner_[19];
  static const uint8_t table11_159_emit_[68];
  static const uint8_t table11_160_emit_[16];
  static const uint8_t table11_161_emit_[28];
  static const uint8_t table11_162_emit_[35];
  static const uint16_t table11_162_inner_[19];
  static const uint8_t table11_163_emit_[68];
  static const uint8_t table11_164_emit_[16];
  static const uint8_t table11_165_emit_[28];
  static const uint8_t table11_166_emit_[35];
  static const uint16_t table11_166_inner_[19];
  static const uint8_t table11_167_emit_[68];
  static const uint8_t table11_168_emit_[16];
  static const uint8_t table11_169_emit_[28];
  static const uint8_t table11_170_emit_[35];
  static const uint16_t table11_170_inner_[19];
  static const uint8_t table11_171_emit_[68];
  static const uint8_t table11_172_emit_[16];
  static const uint8_t table11_173_emit_[28];
  static const uint8_t table11_174_emit_[35];
  static const uint16_t table11_174_inner_[19];
  static const uint8_t table11_175_emit_[68];
  static const uint8_t table11_176_emit_[16];
  static const uint8_t table11_177_emit_[28];
  static const uint8_t table11_178_emit_[35];
  static const uint16_t table11_178_inner_[19];
  static const uint8_t table11_179_emit_[68];
  static const uint8_t table11_180_emit_[16];
  static const uint8_t table11_181_emit_[28];
  static const uint8_t table11_182_emit_[35];
  static const uint16_t table11_182_inner_[19];
  static const uint8_t table11_183_emit_[68];
  static const uint8_t table11_184_emit_[44];
  static const uint8_t table11_185_emit_[91];
  static const uint16_t table11_185_inner_[48];
  static const uint8_t table11_186_emit_[44];
  static const uint8_t table11_187_emit_[91];
  static const uint16_t table11_187_inner_[48];
  static const uint8_t table11_188_emit_[44];
  static const uint8_t table11_189_emit_[91];
  static const uint16_t table11_189_inner_[48];
  static const uint8_t table11_190_emit_[44];
  static const uint8_t table11_191_emit_[91];
  static const uint16_t table11_191_inner_[48];
  static const uint8_t table11_192_emit_[44];
  static const uint8_t table11_193_emit_[91];
  static const uint16_t table11_193_inner_[48];
  static const uint8_t table11_194_emit_[44];
  static const uint8_t table11_195_emit_[91];
  static const uint16_t table11_195_inner_[48];
  static const uint8_t table11_196_emit_[44];
  static const uint8_t table11_197_emit_[91];
  static const uint16_t table11_197_inner_[48];
  static const uint8_t table11_198_emit_[44];
  static const uint8_t table11_199_emit_[91];
  static const uint16_t table11_199_inner_[48];
  static const uint8_t table11_200_emit_[44];
  static const uint8_t table11_201_emit_[91];
  static const uint16_t table11_201_inner_[48];
  static const uint8_t table11_202_emit_[44];
  static const uint8_t table11_203_emit_[91];
  static const uint16_t table11_203_inner_[48];
  static const uint8_t table11_204_emit_[44];
  static const uint8_t table11_205_emit_[91];
  static const uint16_t table11_205_inner_[48];
  static const uint8_t table11_206_emit_[44];
  static const uint8_t table11_207_emit_[91];
  static const uint16_t table11_207_inner_[48];
  static const uint8_t table11_208_emit_[44];
  static const uint8_t table11_209_emit_[91];
  static const uint16_t table11_209_inner_[48];
  static const uint8_t table11_210_emit_[44];
  static const uint8_t table11_211_emit_[91];
  static const uint16_t table11_211_inner_[48];
  static const uint8_t table11_212_emit_[44];
  static const uint8_t table11_213_emit_[91];
  static const uint16_t table11_213_inner_[48];
  static const uint8_t table11_214_emit_[44];
  static const uint8_t table11_215_emit_[91];
  static const uint16_t table11_215_inner_[48];
  static const uint8_t table11_216_emit_[44];
  static const uint8_t table11_217_emit_[91];
  static const uint16_t table11_217_inner_[48];
  static const uint8_t table11_218_emit_[44];
  static const uint8_t table11_219_emit_[91];
  static const uint16_t table11_219_inner_[48];
  static const uint8_t table11_220_emit_[44];
  static const uint8_t table11_221_emit_[91];
  static const uint16_t table11_221_inner_[48];
  static const uint8_t table11_222_emit_[44];
  static const uint8_t table11_223_emit_[91];
  static const uint16_t table11_223_inner_[48];
  static const uint8_t table11_224_emit_[44];
  static const uint8_t table11_225_emit_[91];
  static const uint16_t table11_225_inner_[48];
  static const uint8_t table11_226_emit_[44];
  static const uint8_t table11_227_emit_[91];
  static const uint16_t table11_227_inner_[48];
  static const uint8_t table11_228_emit_[44];
  static const uint8_t table11_229_emit_[91];
  static const uint16_t table11_229_inner_[48];
  static const uint8_t table11_230_emit_[44];
  static const uint8_t table11_231_emit_[91];
  static const uint16_t table11_231_inner_[48];
  static const uint8_t table11_232_emit_[44];
  static const uint8_t table11_233_emit_[91];
  static const uint16_t table11_233_inner_[48];
  static const uint8_t table11_234_emit_[44];
  static const uint8_t table11_235_emit_[91];
  static const uint16_t table11_235_inner_[48];
  static const uint8_t table11_236_emit_[44];
  static const uint8_t table11_237_emit_[91];
  static const uint16_t table11_237_inner_[48];
  static const uint8_t table11_238_emit_[44];
  static const uint8_t table11_239_emit_[91];
  static const uint16_t table11_239_inner_[48];
  static const uint8_t table11_240_emit_[44];
  static const uint8_t table11_241_emit_[91];
  static const uint16_t table11_241_inner_[48];
  static const uint8_t table11_242_emit_[44];
  static const uint8_t table11_243_emit_[91];
  static const uint16_t table11_243_inner_[48];
  static const uint8_t table11_244_emit_[44];
  static const uint8_t table11_245_emit_[91];
  static const uint16_t table11_245_inner_[48];
  static const uint8_t table11_246_emit_[44];
  static const uint8_t table11_247_emit_[92];
  static const uint8_t table11_248_emit_[72];
  static const uint8_t table11_249_emit_[72];
  static const uint8_t table11_250_emit_[72];
  static const uint8_t table11_251_emit_[72];
  static const uint8_t table11_252_emit_[72];
  static const uint8_t table11_253_emit_[72];
  static const uint8_t table11_254_emit_[4];
  static const uint8_t table11_255_emit_[14];
  static const uint8_t table11_255_outer_[64];
  static const uint8_t* const table11_emit_[256];
  static const uint16_t* const table11_inner_[256];
  static const uint8_t* const table11_outer_[256];
  static const uint8_t table1_0_emit_[55];
  static const uint16_t table1_0_inner_[22];
  static const uint8_t table1_0_outer_[64];
  static const uint8_t table1_1_emit_[58];
  static const uint16_t table1_1_inner_[22];
  static const uint8_t table1_2_emit_[58];
  static const uint8_t table1_3_emit_[58];
  static const uint8_t table1_4_emit_[58];
  static const uint8_t table1_5_emit_[8];
  static const uint16_t table1_5_inner_[4];
  static const uint8_t table1_5_outer_[64];
  static const uint8_t table1_6_emit_[8];
  static const uint8_t table1_7_emit_[8];
  static const uint8_t table1_8_emit_[8];
  static const uint8_t table1_9_emit_[8];
  static const uint8_t table1_10_emit_[8];
  static const uint8_t table1_11_emit_[12];
  static const uint16_t table1_11_inner_[6];
  static const uint8_t table1_11_outer_[64];
  static const uint8_t table1_12_emit_[16];
  static const uint16_t table1_12_inner_[8];
  static const uint8_t table1_12_outer_[64];
  static const uint8_t table1_13_emit_[16];
  static const uint8_t table1_14_emit_[16];
  static const uint8_t table1_15_emit_[30];
  static const uint16_t table1_15_inner_[16];
  static const uint8_t table1_15_outer_[64];
  static const uint8_t table1_16_emit_[57];
  static const uint16_t table1_16_inner_[22];
  static const uint8_t table1_17_emit_[58];
  static const uint16_t table1_17_inner_[22];
  static const uint8_t table1_18_emit_[58];
  static const uint8_t table1_19_emit_[58];
  static const uint8_t table1_20_emit_[58];
  static const uint8_t table1_21_emit_[8];
  static const uint8_t table1_22_emit_[8];
  static const uint8_t table1_23_emit_[8];
  static const uint8_t table1_24_emit_[8];
  static const uint8_t table1_25_emit_[8];
  static const uint8_t table1_26_emit_[8];
  static const uint8_t table1_27_emit_[12];
  static const uint8_t table1_28_emit_[16];
  static const uint8_t table1_29_emit_[16];
  static const uint8_t table1_30_emit_[16];
  static const uint8_t table1_31_emit_[30];
  static const uint8_t table1_32_emit_[58];
  static const uint16_t table1_32_inner_[22];
  static const uint8_t table1_33_emit_[55];
  static const uint16_t table1_33_inner_[22];
  static const uint8_t table1_34_emit_[58];
  static const uint8_t table1_35_emit_[58];
  static const uint8_t table1_36_emit_[58];
  static const uint8_t table1_37_emit_[8];
  static const uint8_t table1_38_emit_[8];
  static const uint8_t table1_39_emit_[8];
  static const uint8_t table1_40_emit_[8];
  static const uint8_t table1_41_emit_[8];
  static const uint8_t table1_42_emit_[8];
  static const uint8_t table1_43_emit_[12];
  static const uint8_t table1_44_emit_[16];
  static const uint8_t table1_45_emit_[16];
  static const uint8_t table1_46_emit_[16];
  static const uint8_t table1_47_emit_[30];
  static const uint8_t table1_48_emit_[58];
  static const uint16_t table1_48_inner_[22];
  static const uint8_t table1_49_emit_[57];
  static const uint16_t table1_49_inner_[22];
  static const uint8_t table1_50_emit_[58];
  static const uint8_t table1_51_emit_[58];
  static const uint8_t table1_52_emit_[58];
  static const uint8_t table1_53_emit_[8];
  static const uint8_t table1_54_emit_[8];
  static const uint8_t table1_55_emit_[8];
  static const uint8_t table1_56_emit_[8];
  static const uint8_t table1_57_emit_[8];
  static const uint8_t table1_58_emit_[8];
  static const uint8_t table1_59_emit_[12];
  static const uint8_t table1_60_emit_[16];
  static const uint8_t table1_61_emit_[16];
  static const uint8_t table1_62_emit_[16];
  static const uint8_t table1_63_emit_[30];
  static const uint8_t table1_64_emit_[58];
  static const uint16_t table1_64_inner_[22];
  static const uint8_t table1_65_emit_[58];
  static const uint8_t table1_66_emit_[55];
  static const uint16_t table1_66_inner_[22];
  static const uint8_t table1_67_emit_[58];
  static const uint8_t table1_68_emit_[58];
  static const uint8_t table1_69_emit_[8];
  static const uint8_t table1_70_emit_[8];
  static const uint8_t table1_71_emit_[8];
  static const uint8_t table1_72_emit_[8];
  static const uint8_t table1_73_emit_[8];
  static const uint8_t table1_74_emit_[8];
  static const uint8_t table1_75_emit_[12];
  static const uint8_t table1_76_emit_[16];
  static const uint8_t table1_77_emit_[16];
  static const uint8_t table1_78_emit_[16];
  static const uint8_t table1_79_emit_[30];
  static const uint8_t table1_80_emit_[58];
  static const uint16_t table1_80_inner_[22];
  static const uint8_t table1_81_emit_[58];
  static const uint8_t table1_82_emit_[57];
  static const uint16_t table1_82_inner_[22];
  static const uint8_t table1_83_emit_[58];
  static const uint8_t table1_84_emit_[58];
  static const uint8_t table1_85_emit_[8];
  static const uint8_t table1_86_emit_[8];
  static const uint8_t table1_87_emit_[8];
  static const uint8_t table1_88_emit_[8];
  static const uint8_t table1_89_emit_[8];
  static const uint8_t table1_90_emit_[8];
  static const uint8_t table1_91_emit_[12];
  static const uint8_t table1_92_emit_[16];
  static const uint8_t table1_93_emit_[16];
  static const uint8_t table1_94_emit_[16];
  static const uint8_t table1_95_emit_[30];
  static const uint8_t table1_96_emit_[58];
  static const uint16_t table1_96_inner_[22];
  static const uint8_t table1_97_emit_[58];
  static const uint8_t table1_98_emit_[58];
  static const uint8_t table1_99_emit_[55];
  static const uint16_t table1_99_inner_[22];
  static const uint8_t table1_100_emit_[58];
  static const uint8_t table1_101_emit_[8];
  static const uint8_t table1_102_emit_[8];
  static const uint8_t table1_103_emit_[8];
  static const uint8_t table1_104_emit_[8];
  static const uint8_t table1_105_emit_[8];
  static const uint8_t table1_106_emit_[8];
  static const uint8_t table1_107_emit_[12];
  static const uint8_t table1_108_emit_[16];
  static const uint8_t table1_109_emit_[16];
  static const uint8_t table1_110_emit_[16];
  static const uint8_t table1_111_emit_[30];
  static const uint8_t table1_112_emit_[58];
  static const uint16_t table1_112_inner_[22];
  static const uint8_t table1_113_emit_[58];
  static const uint8_t table1_114_emit_[58];
  static const uint8_t table1_115_emit_[57];
  static const uint16_t table1_115_inner_[22];
  static const uint8_t table1_116_emit_[58];
  static const uint8_t table1_117_emit_[8];
  static const uint8_t table1_118_emit_[8];
  static const uint8_t table1_119_emit_[8];
  static const uint8_t table1_120_emit_[8];
  static const uint8_t table1_121_emit_[8];
  static const uint8_t table1_122_emit_[8];
  static const uint8_t table1_123_emit_[12];
  static const uint8_t table1_124_emit_[16];
  static const uint8_t table1_125_emit_[16];
  static const uint8_t table1_126_emit_[16];
  static const uint8_t table1_127_emit_[30];
  static const uint8_t table1_128_emit_[58];
  static const uint16_t table1_128_inner_[22];
  static const uint8_t table1_129_emit_[58];
  static const uint8_t table1_130_emit_[58];
  static const uint8_t table1_131_emit_[58];
  static const uint8_t table1_132_emit_[55];
  static const uint16_t table1_132_inner_[22];
  static const uint8_t table1_133_emit_[8];
  static const uint8_t table1_134_emit_[8];
  static const uint8_t table1_135_emit_[8];
  static const uint8_t table1_136_emit_[8];
  static const uint8_t table1_137_emit_[8];
  static const uint8_t table1_138_emit_[8];
  static const uint8_t table1_139_emit_[12];
  static const uint8_t table1_140_emit_[16];
  static const uint8_t table1_141_emit_[16];
  static const uint8_t table1_142_emit_[16];
  static const uint8_t table1_143_emit_[30];
  static const uint8_t table1_144_emit_[59];
  static const uint16_t table1_144_inner_[22];
  static const uint8_t table1_145_emit_[59];
  static const uint8_t table1_146_emit_[59];
  static const uint8_t table1_147_emit_[59];
  static const uint8_t table1_148_emit_[59];
  static const uint8_t table1_149_emit_[8];
  static const uint8_t table1_150_emit_[8];
  static const uint8_t table1_151_emit_[8];
  static const uint8_t table1_152_emit_[8];
  static const uint8_t table1_153_emit_[8];
  static const uint8_t table1_154_emit_[8];
  static const uint8_t table1_155_emit_[12];
  static const uint8_t table1_156_emit_[16];
  static const uint8_t table1_157_emit_[16];
  static const uint8_t table1_158_emit_[16];
  static const uint8_t table1_159_emit_[30];
  static const uint8_t table1_160_emit_[8];
  static const uint8_t table1_161_emit_[8];
  static const uint8_t table1_162_emit_[11];
  static const uint16_t table1_162_inner_[6];
  static const uint8_t table1_163_emit_[16];
  static const uint8_t table1_164_emit_[16];
  static const uint8_t table1_165_emit_[20];
  static const uint16_t table1_165_inner_[10];
  static const uint8_t table1_165_outer_[64];
  static const uint8_t table1_166_emit_[32];
  static const uint16_t table1_166_inner_[16];
  static const uint8_t table1_166_outer_[64];
  static const uint8_t table1_167_emit_[36];
  static const uint16_t table1_167_inner_[19];
  static const uint8_t table1_167_outer_[64];
  static const uint8_t table1_168_emit_[8];
  static const uint8_t table1_169_emit_[8];
  static const uint8_t table1_170_emit_[11];
  static const uint16_t table1_170_inner_[6];
  static const uint8_t table1_171_emit_[16];
  static const uint8_t table1_172_emit_[16];
  static const uint8_t table1_173_emit_[20];
  static const uint8_t table1_174_emit_[32];
  static const uint8_t table1_175_emit_[36];
  static const uint8_t table1_176_emit_[8];
  static const uint8_t table1_177_emit_[8];
  static const uint8_t table1_178_emit_[11];
  static const uint16_t table1_178_inner_[6];
  static const uint8_t table1_179_emit_[16];
  static const uint8_t table1_180_emit_[16];
  static const uint8_t table1_181_emit_[20];
  static const uint8_t table1_182_emit_[32];
  static const uint8_t table1_183_emit_[36];
  static const uint8_t table1_184_emit_[8];
  static const uint8_t table1_185_emit_[8];
  static const uint8_t table1_186_emit_[12];
  static const uint8_t table1_187_emit_[16];
  static const uint8_t table1_188_emit_[16];
  static const uint8_t table1_189_emit_[20];
  static const uint8_t table1_190_emit_[32];
  static const uint8_t table1_191_emit_[36];
  static const uint8_t table1_192_emit_[8];
  static const uint8_t table1_193_emit_[8];
  static const uint8_t table1_194_emit_[12];
  static const uint8_t table1_195_emit_[15];
  static const uint16_t table1_195_inner_[8];
  static const uint8_t table1_196_emit_[16];
  static const uint8_t table1_197_emit_[20];
  static const uint8_t table1_198_emit_[32];
  static const uint8_t table1_199_emit_[36];
  static const uint8_t table1_200_emit_[8];
  static const uint8_t table1_201_emit_[8];
  static const uint8_t table1_202_emit_[12];
  static const uint8_t table1_203_emit_[15];
  static const uint16_t table1_203_inner_[8];
  static const uint8_t table1_204_emit_[16];
  static const uint8_t table1_205_emit_[20];
  static const uint8_t table1_206_emit_[32];
  static const uint8_t table1_207_emit_[36];
  static const uint8_t table1_208_emit_[8];
  static const uint8_t table1_209_emit_[8];
  static const uint8_t table1_210_emit_[12];
  static const uint8_t table1_211_emit_[15];
  static const uint16_t table1_211_inner_[8];
  static const uint8_t table1_212_emit_[16];
  static const uint8_t table1_213_emit_[20];
  static const uint8_t table1_214_emit_[32];
  static const uint8_t table1_215_emit_[36];
  static const uint8_t table1_216_emit_[8];
  static const uint8_t table1_217_emit_[8];
  static const uint8_t table1_218_emit_[12];
  static const uint8_t table1_219_emit_[15];
  static const uint16_t table1_219_inner_[8];
  static const uint8_t table1_220_emit_[16];
  static const uint8_t table1_221_emit_[20];
  static const uint8_t table1_222_emit_[32];
  static const uint8_t table1_223_emit_[36];
  static const uint8_t table1_224_emit_[8];
  static const uint8_t table1_225_emit_[8];
  static const uint8_t table1_226_emit_[12];
  static const uint8_t table1_227_emit_[15];
  static const uint16_t table1_227_inner_[8];
  static const uint8_t table1_228_emit_[16];
  static const uint8_t table1_229_emit_[20];
  static const uint8_t table1_230_emit_[32];
  static const uint8_t table1_231_emit_[36];
  static const uint8_t table1_232_emit_[8];
  static const uint8_t table1_233_emit_[8];
  static const uint8_t table1_234_emit_[12];
  static const uint8_t table1_235_emit_[15];
  static const uint16_t table1_235_inner_[8];
  static const uint8_t table1_236_emit_[16];
  static const uint8_t table1_237_emit_[20];
  static const uint8_t table1_238_emit_[32];
  static const uint8_t table1_239_emit_[36];
  static const uint8_t table1_240_emit_[8];
  static const uint8_t table1_241_emit_[8];
  static const uint8_t table1_242_emit_[12];
  static const uint8_t table1_243_emit_[15];
  static const uint16_t table1_243_inner_[8];
  static const uint8_t table1_244_emit_[16];
  static const uint8_t table1_245_emit_[20];
  static const uint8_t table1_246_emit_[32];
  static const uint8_t table1_247_emit_[36];
  static const uint8_t table1_248_emit_[8];
  static const uint8_t table1_249_emit_[8];
  static const uint8_t table1_250_emit_[12];
  static const uint8_t table1_251_emit_[16];
  static const uint8_t table1_252_emit_[16];
  static const uint8_t table1_253_emit_[20];
  static const uint8_t table1_254_emit_[32];
  static const uint8_t table1_255_emit_[36];
  static const uint8_t table1_256_emit_[8];
  static const uint8_t table1_257_emit_[8];
  static const uint8_t table1_258_emit_[12];
  static const uint8_t table1_259_emit_[16];
  static const uint8_t table1_260_emit_[15];
  static const uint8_t table1_261_emit_[20];
  static const uint8_t table1_262_emit_[32];
  static const uint8_t table1_263_emit_[36];
  static const uint8_t table1_264_emit_[8];
  static const uint8_t table1_265_emit_[8];
  static const uint8_t table1_266_emit_[12];
  static const uint8_t table1_267_emit_[16];
  static const uint8_t table1_268_emit_[15];
  static const uint8_t table1_269_emit_[20];
  static const uint8_t table1_270_emit_[32];
  static const uint8_t table1_271_emit_[36];
  static const uint8_t table1_272_emit_[8];
  static const uint8_t table1_273_emit_[8];
  static const uint8_t table1_274_emit_[12];
  static const uint8_t table1_275_emit_[16];
  static const uint8_t table1_276_emit_[15];
  static const uint8_t table1_277_emit_[20];
  static const uint8_t table1_278_emit_[32];
  static const uint8_t table1_279_emit_[36];
  static const uint8_t table1_280_emit_[8];
  static const uint8_t table1_281_emit_[8];
  static const uint8_t table1_282_emit_[12];
  static const uint8_t table1_283_emit_[16];
  static const uint8_t table1_284_emit_[15];
  static const uint8_t table1_285_emit_[20];
  static const uint8_t table1_286_emit_[32];
  static const uint8_t table1_287_emit_[36];
  static const uint8_t table1_288_emit_[8];
  static const uint8_t table1_289_emit_[8];
  static const uint8_t table1_290_emit_[12];
  static const uint8_t table1_291_emit_[16];
  static const uint8_t table1_292_emit_[15];
  static const uint8_t table1_293_emit_[20];
  static const uint8_t table1_294_emit_[32];
  static const uint8_t table1_295_emit_[36];
  static const uint8_t table1_296_emit_[8];
  static const uint8_t table1_297_emit_[8];
  static const uint8_t table1_298_emit_[12];
  static const uint8_t table1_299_emit_[16];
  static const uint8_t table1_300_emit_[15];
  static const uint8_t table1_301_emit_[20];
  static const uint8_t table1_302_emit_[32];
  static const uint8_t table1_303_emit_[36];
  static const uint8_t table1_304_emit_[8];
  static const uint8_t table1_305_emit_[8];
  static const uint8_t table1_306_emit_[12];
  static const uint8_t table1_307_emit_[16];
  static const uint8_t table1_308_emit_[15];
  static const uint8_t table1_309_emit_[20];
  static const uint8_t table1_310_emit_[32];
  static const uint8_t table1_311_emit_[36];
  static const uint8_t table1_312_emit_[8];
  static const uint8_t table1_313_emit_[8];
  static const uint8_t table1_314_emit_[12];
  static const uint8_t table1_315_emit_[16];
  static const uint8_t table1_316_emit_[16];
  static const uint8_t table1_317_emit_[20];
  static const uint8_t table1_318_emit_[32];
  static const uint8_t table1_319_emit_[36];
  static const uint8_t table1_320_emit_[8];
  static const uint8_t table1_321_emit_[8];
  static const uint8_t table1_322_emit_[12];
  static const uint8_t table1_323_emit_[16];
  static const uint8_t table1_324_emit_[16];
  static const uint8_t table1_325_emit_[19];
  static const uint16_t table1_325_inner_[10];
  static const uint8_t table1_326_emit_[32];
  static const uint8_t table1_327_emit_[36];
  static const uint8_t table1_328_emit_[8];
  static const uint8_t table1_329_emit_[8];
  static const uint8_t table1_330_emit_[12];
  static const uint8_t table1_331_emit_[16];
  static const uint8_t table1_332_emit_[16];
  static const uint8_t table1_333_emit_[19];
  static const uint16_t table1_333_inner_[10];
  static const uint8_t table1_334_emit_[32];
  static const uint8_t table1_335_emit_[36];
  static const uint8_t table1_336_emit_[8];
  static const uint8_t table1_337_emit_[8];
  static const uint8_t table1_338_emit_[12];
  static const uint8_t table1_339_emit_[16];
  static const uint8_t table1_340_emit_[16];
  static const uint8_t table1_341_emit_[19];
  static const uint16_t table1_341_inner_[10];
  static const uint8_t table1_342_emit_[32];
  static const uint8_t table1_343_emit_[36];
  static const uint8_t table1_344_emit_[8];
  static const uint8_t table1_345_emit_[8];
  static const uint8_t table1_346_emit_[12];
  static const uint8_t table1_347_emit_[16];
  static const uint8_t table1_348_emit_[16];
  static const uint8_t table1_349_emit_[19];
  static const uint16_t table1_349_inner_[10];
  static const uint8_t table1_350_emit_[32];
  static const uint8_t table1_351_emit_[36];
  static const uint8_t table1_352_emit_[8];
  static const uint8_t table1_353_emit_[8];
  static const uint8_t table1_354_emit_[12];
  static const uint8_t table1_355_emit_[16];
  static const uint8_t table1_356_emit_[16];
  static const uint8_t table1_357_emit_[19];
  static const uint16_t table1_357_inner_[10];
  static const uint8_t table1_358_emit_[32];
  static const uint8_t table1_359_emit_[36];
  static const uint8_t table1_360_emit_[8];
  static const uint8_t table1_361_emit_[8];
  static const uint8_t table1_362_emit_[12];
  static const uint8_t table1_363_emit_[16];
  static const uint8_t table1_364_emit_[16];
  static const uint8_t table1_365_emit_[19];
  static const uint16_t table1_365_inner_[10];
  static const uint8_t table1_366_emit_[32];
  static const uint8_t table1_367_emit_[36];
  static const uint8_t table1_368_emit_[16];
  static const uint8_t table1_369_emit_[28];
  static const uint16_t table1_369_inner_[14];
  static const uint8_t table1_369_outer_[64];
  static const uint8_t table1_370_emit_[35];
  static const uint16_t table1_370_inner_[18];
  static const uint8_t table1_370_outer_[64];
  static const uint8_t table1_371_emit_[68];
  static const uint16_t table1_371_inner_[35];
  static const uint8_t table1_371_outer_[64];
  static const uint8_t table1_372_emit_[16];
  static const uint8_t table1_373_emit_[28];
  static const uint8_t table1_374_emit_[35];
  static const uint16_t table1_374_inner_[18];
  static const uint8_t table1_375_emit_[68];
  static const uint8_t table1_376_emit_[16];
  static const uint8_t table1_377_emit_[28];
  static const uint8_t table1_378_emit_[35];
  static const uint16_t table1_378_inner_[18];
  static const uint8_t table1_379_emit_[68];
  static const uint8_t table1_380_emit_[16];
  static const uint8_t table1_381_emit_[28];
  static const uint8_t table1_382_emit_[36];
  static const uint16_t table1_382_inner_[18];
  static const uint8_t table1_383_emit_[68];
  static const uint8_t table1_384_emit_[16];
  static const uint8_t table1_385_emit_[28];
  static const uint8_t table1_386_emit_[36];
  static const uint8_t table1_387_emit_[67];
  static const uint16_t table1_387_inner_[35];
  static const uint8_t table1_388_emit_[16];
  static const uint8_t table1_389_emit_[28];
  static const uint8_t table1_390_emit_[36];
  static const uint8_t table1_391_emit_[67];
  static const uint16_t table1_391_inner_[35];
  static const uint8_t table1_392_emit_[16];
  static const uint8_t table1_393_emit_[28];
  static const uint8_t table1_394_emit_[36];
  static const uint8_t table1_395_emit_[67];
  static const uint16_t table1_395_inner_[35];
  static const uint8_t table1_396_emit_[16];
  static const uint8_t table1_397_emit_[28];
  static const uint8_t table1_398_emit_[36];
  static const uint8_t table1_399_emit_[67];
  static const uint16_t table1_399_inner_[35];
  static const uint8_t table1_400_emit_[16];
  static const uint8_t table1_401_emit_[28];
  static const uint8_t table1_402_emit_[36];
  static const uint8_t table1_403_emit_[67];
  static const uint16_t table1_403_inner_[35];
  static const uint8_t table1_404_emit_[16];
  static const uint8_t table1_405_emit_[28];
  static const uint8_t table1_406_emit_[36];
  static const uint8_t table1_407_emit_[67];
  static const uint16_t table1_407_inner_[35];
  static const uint8_t table1_408_emit_[16];
  static const uint8_t table1_409_emit_[28];
  static const uint8_t table1_410_emit_[36];
  static const uint8_t table1_411_emit_[67];
  static const uint16_t table1_411_inner_[35];
  static const uint8_t table1_412_emit_[16];
  static const uint8_t table1_413_emit_[28];
  static const uint8_t table1_414_emit_[36];
  static const uint8_t table1_415_emit_[67];
  static const uint16_t table1_415_inner_[35];
  static const uint8_t table1_416_emit_[16];
  static const uint8_t table1_417_emit_[28];
  static const uint8_t table1_418_emit_[36];
  static const uint8_t table1_419_emit_[67];
  static const uint16_t table1_419_inner_[35];
  static const uint8_t table1_420_emit_[16];
  static const uint8_t table1_421_emit_[28];
  static const uint8_t table1_422_emit_[36];
  static const uint8_t table1_423_emit_[67];
  static const uint16_t table1_423_inner_[35];
  static const uint8_t table1_424_emit_[16];
  static const uint8_t table1_425_emit_[28];
  static const uint8_t table1_426_emit_[36];
  static const uint8_t table1_427_emit_[67];
  static const uint16_t table1_427_inner_[35];
  static const uint8_t table1_428_emit_[16];
  static const uint8_t table1_429_emit_[28];
  static const uint8_t table1_430_emit_[36];
  static const uint8_t table1_431_emit_[67];
  static const uint16_t table1_431_inner_[35];
  static const uint8_t table1_432_emit_[16];
  static const uint8_t table1_433_emit_[28];
  static const uint8_t table1_434_emit_[36];
  static const uint8_t table1_435_emit_[67];
  static const uint16_t table1_435_inner_[35];
  static const uint8_t table1_436_emit_[16];
  static const uint8_t table1_437_emit_[28];
  static const uint8_t table1_438_emit_[36];
  static const uint8_t table1_439_emit_[67];
  static const uint16_t table1_439_inner_[35];
  static const uint8_t table1_440_emit_[16];
  static const uint8_t table1_441_emit_[28];
  static const uint8_t table1_442_emit_[36];
  static const uint8_t table1_443_emit_[67];
  static const uint16_t table1_443_inner_[35];
  static const uint8_t table1_444_emit_[16];
  static const uint8_t table1_445_emit_[28];
  static const uint8_t table1_446_emit_[36];
  static const uint8_t table1_447_emit_[67];
  static const uint16_t table1_447_inner_[35];
  static const uint8_t table1_448_emit_[16];
  static const uint8_t table1_449_emit_[28];
  static const uint8_t table1_450_emit_[36];
  static const uint8_t table1_451_emit_[67];
  static const uint16_t table1_451_inner_[35];
  static const uint8_t table1_452_emit_[16];
  static const uint8_t table1_453_emit_[28];
  static const uint8_t table1_454_emit_[36];
  static const uint8_t table1_455_emit_[67];
  static const uint16_t table1_455_inner_[35];
  static const uint8_t table1_456_emit_[16];
  static const uint8_t table1_457_emit_[28];
  static const uint8_t table1_458_emit_[36];
  static const uint8_t table1_459_emit_[67];
  static const uint16_t table1_459_inner_[35];
  static const uint8_t table1_460_emit_[16];
  static const uint8_t table1_461_emit_[28];
  static const uint8_t table1_462_emit_[36];
  static const uint8_t table1_463_emit_[67];
  static const uint16_t table1_463_inner_[35];
  static const uint8_t table1_464_emit_[16];
  static const uint8_t table1_465_emit_[28];
  static const uint8_t table1_466_emit_[36];
  static const uint8_t table1_467_emit_[67];
  static const uint16_t table1_467_inner_[35];
  static const uint8_t table1_468_emit_[16];
  static const uint8_t table1_469_emit_[28];
  static const uint8_t table1_470_emit_[36];
  static const uint8_t table1_471_emit_[67];
  static const uint16_t table1_471_inner_[35];
  static const uint8_t table1_472_emit_[16];
  static const uint8_t table1_473_emit_[28];
  static const uint8_t table1_474_emit_[36];
  static const uint8_t table1_475_emit_[67];
  static const uint16_t table1_475_inner_[35];
  static const uint8_t table1_476_emit_[16];
  static const uint8_t table1_477_emit_[28];
  static const uint8_t table1_478_emit_[36];
  static const uint8_t table1_479_emit_[67];
  static const uint16_t table1_479_inner_[35];
  static const uint8_t table1_480_emit_[16];
  static const uint8_t table1_481_emit_[28];
  static const uint8_t table1_482_emit_[36];
  static const uint8_t table1_483_emit_[67];
  static const uint16_t table1_483_inner_[35];
  static const uint8_t table1_484_emit_[16];
  static const uint8_t table1_485_emit_[28];
  static const uint8_t table1_486_emit_[36];
  static const uint8_t table1_487_emit_[67];
  static const uint16_t table1_487_inner_[35];
  static const uint8_t table1_488_emit_[16];
  static const uint8_t table1_489_emit_[28];
  static const uint8_t table1_490_emit_[36];
  static const uint8_t table1_491_emit_[67];
  static const uint16_t table1_491_inner_[35];
  static const uint8_t table1_492_emit_[16];
  static const uint8_t table1_493_emit_[28];
  static const uint8_t table1_494_emit_[36];
  static const uint8_t table1_495_emit_[67];
  static const uint16_t table1_495_inner_[35];
  static const uint8_t table1_496_emit_[44];
  static const uint16_t table1_496_inner_[22];
  static const uint8_t table1_496_outer_[64];
  static const uint8_t table1_497_emit_[92];
  static const uint16_t table1_497_inner_[47];
  static const uint8_t table1_497_outer_[64];
  static const uint8_t table1_498_emit_[44];
  static const uint8_t table1_499_emit_[92];
  static const uint8_t table1_500_emit_[44];
  static const uint8_t table1_501_emit_[92];
  static const uint8_t table1_502_emit_[44];
  static const uint8_t table1_503_emit_[92];
  static const uint8_t table1_504_emit_[44];
  static const uint8_t table1_505_emit_[92];
  static const uint8_t table1_506_emit_[44];
  static const uint8_t table1_507_emit_[92];
  static const uint8_t table1_508_emit_[40];
  static const uint16_t table1_508_inner_[22];
  static const uint8_t table1_509_emit_[40];
  static const uint8_t table1_510_emit_[22];
  static const uint16_t table1_510_inner_[13];
  static const uint8_t table1_510_outer_[64];
  static const uint8_t table1_511_emit_[14];
  static const uint16_t table1_511_inner_[15];
  static const uint8_t table1_511_outer_[64];
  static const uint8_t* const table1_emit_[512];
  static const uint16_t* const table1_inner_[512];
  static const uint8_t* const table1_outer_[512];
  static const uint8_t table13_0_inner_[5];
  static const uint8_t table14_0_emit_[11];
  static const uint8_t table14_0_ops_[32];
  static const uint8_t table15_0_emit_[24];
  static const uint8_t table15_0_ops_[64];
  static const uint8_t table16_0_emit_[50];
  static const uint8_t table16_0_ops_[128];
  static const uint8_t table17_0_emit_[15];
  static const uint8_t table17_0_ops_[128];
  static const uint8_t table17_1_emit_[64];
  static const uint8_t table17_1_ops_[128];
  static const uint8_t* const table17_emit_[2];
  static const uint8_t* const table17_ops_[2];
  static const uint8_t table18_0_emit_[62];
  static const uint8_t table18_0_ops_[128];
  static const uint8_t table18_1_emit_[10];
  static const uint8_t table18_1_ops_[128];
  static const uint8_t table18_2_emit_[23];
  static const uint8_t table18_2_ops_[128];
  static const uint8_t table18_3_emit_[53];
  static const uint8_t table18_3_ops_[128];
  static const uint8_t* const table18_emit_[4];
  static const uint8_t* const table18_ops_[4];
  static const uint8_t table19_0_emit_[72];
  static const uint16_t table19_0_ops_[64];
  static const uint8_t table19_1_emit_[72];
  static const uint8_t table19_2_emit_[72];
  static const uint8_t table19_3_emit_[40];
  static const uint16_t table19_3_ops_[64];
  static const uint8_t table19_4_emit_[40];
  static const uint8_t table19_5_emit_[40];
  static const uint8_t table19_6_emit_[40];
  static const uint8_t table19_7_emit_[4];
  static const uint16_t table19_7_ops_[64];
  static const uint8_t table19_8_emit_[4];
  static const uint8_t table19_9_emit_[4];
  static const uint8_t table19_10_emit_[7];
  static const uint16_t table19_10_ops_[64];
  static const uint8_t table19_11_emit_[8];
  static const uint16_t table19_11_ops_[64];
  static const uint8_t table19_12_emit_[8];
  static const uint8_t table19_13_emit_[12];
  static const uint16_t table19_13_ops_[64];
  static const uint8_t table19_14_emit_[16];
  static const uint16_t table19_14_ops_[64];
  static const uint8_t table19_15_emit_[21];
  static const uint16_t table19_15_ops_[64];
  static const uint8_t* const table19_emit_[16];
  static const uint16_t* const table19_ops_[16];
  static const uint8_t table20_0_emit_[44];
  static const uint16_t table20_0_ops_[64];
  static const uint8_t table20_1_emit_[92];
  static const uint16_t table20_1_ops_[64];
  static const uint8_t table20_2_emit_[44];
  static const uint8_t table20_3_emit_[92];
  static const uint8_t table20_4_emit_[44];
  static const uint8_t table20_5_emit_[92];
  static const uint8_t table20_6_emit_[72];
  static const uint8_t table20_7_emit_[72];
  static const uint8_t table20_8_emit_[72];
  static const uint8_t table20_9_emit_[72];
  static const uint8_t table20_10_emit_[72];
  static const uint8_t table20_11_emit_[72];
  static const uint8_t table20_12_emit_[72];
  static const uint8_t table20_13_emit_[72];
  static const uint8_t table20_14_emit_[40];
  static const uint8_t table20_15_emit_[40];
  static const uint8_t table20_16_emit_[40];
  static const uint8_t table20_17_emit_[40];
  static const uint8_t table20_18_emit_[40];
  static const uint8_t table20_19_emit_[40];
  static const uint8_t table20_20_emit_[22];
  static const uint16_t table20_20_ops_[64];
  static const uint8_t table20_21_emit_[4];
  static const uint8_t table20_22_emit_[4];
  static const uint8_t table20_23_emit_[4];
  static const uint8_t table20_24_emit_[4];
  static const uint8_t table20_25_emit_[4];
  static const uint8_t table20_26_emit_[4];
  static const uint8_t table20_27_emit_[8];
  static const uint8_t table20_28_emit_[8];
  static const uint8_t table20_29_emit_[8];
  static const uint8_t table20_30_emit_[11];
  static const uint16_t table20_30_ops_[64];
  static const uint8_t table20_31_emit_[25];
  static const uint16_t table20_31_ops_[64];
  static const uint8_t* const table20_emit_[32];
  static const uint16_t* const table20_ops_[32];
  static const uint8_t table21_0_emit_[16];
  static const uint16_t table21_0_ops_[64];
  static const uint8_t table21_1_emit_[28];
  static const uint16_t table21_1_ops_[64];
  static const uint8_t table21_2_emit_[36];
  static const uint16_t table21_2_ops_[64];
  static const uint8_t table21_3_emit_[68];
  static const uint16_t table21_3_ops_[64];
  static const uint8_t table21_4_emit_[16];
  static const uint8_t table21_5_emit_[28];
  static const uint8_t table21_6_emit_[36];
  static const uint8_t table21_7_emit_[68];
  static const uint8_t table21_8_emit_[16];
  static const uint8_t table21_9_emit_[28];
  static const uint8_t table21_10_emit_[36];
  static const uint8_t table21_11_emit_[68];
  static const uint8_t table21_12_emit_[44];
  static const uint8_t table21_13_emit_[92];
  static const uint8_t table21_14_emit_[44];
  static const uint8_t table21_15_emit_[92];
  static const uint8_t table21_16_emit_[44];
  static const uint8_t table21_17_emit_[92];
  static const uint8_t table21_18_emit_[44];
  static const uint8_t table21_19_emit_[92];
  static const uint8_t table21_20_emit_[44];
  static const uint8_t table21_21_emit_[92];
  static const uint8_t table21_22_emit_[44];
  static const uint8_t table21_23_emit_[92];
  static const uint8_t table21_24_emit_[44];
  static const uint8_t table21_25_emit_[92];
  static const uint8_t table21_26_emit_[44];
  static const uint8_t table21_27_emit_[92];
  static const uint8_t table21_28_emit_[72];
  static const uint8_t table21_29_emit_[72];
  static const uint8_t table21_30_emit_[72];
  static const uint8_t table21_31_emit_[72];
  static const uint8_t table21_32_emit_[72];
  static const uint8_t table21_33_emit_[72];
  static const uint8_t table21_34_emit_[72];
  static const uint8_t table21_35_emit_[72];
  static const uint8_t table21_36_emit_[72];
  static const uint8_t table21_37_emit_[72];
  static const uint8_t table21_38_emit_[72];
  static const uint8_t table21_39_emit_[72];
  static const uint8_t table21_40_emit_[72];
  static const uint8_t table21_41_emit_[40];
  static const uint8_t table21_42_emit_[40];
  static const uint8_t table21_43_emit_[40];
  static const uint8_t table21_44_emit_[40];
  static const uint8_t table21_45_emit_[40];
  static const uint8_t table21_46_emit_[40];
  static const uint8_t table21_47_emit_[40];
  static const uint8_t table21_48_emit_[40];
  static const uint8_t table21_49_emit_[40];
  static const uint8_t table21_50_emit_[40];
  static const uint8_t table21_51_emit_[40];
  static const uint8_t table21_52_emit_[40];
  static const uint8_t table21_53_emit_[40];
  static const uint8_t table21_54_emit_[4];
  static const uint8_t table21_55_emit_[4];
  static const uint8_t table21_56_emit_[4];
  static const uint8_t table21_57_emit_[4];
  static const uint8_t table21_58_emit_[4];
  static const uint8_t table21_59_emit_[4];
  static const uint8_t table21_60_emit_[4];
  static const uint8_t table21_61_emit_[7];
  static const uint8_t table21_62_emit_[10];
  static const uint16_t table21_62_ops_[64];
  static const uint8_t table21_63_emit_[34];
  static const uint16_t table21_63_ops_[64];
  static const uint8_t* const table21_emit_[64];
  static const uint16_t* const table21_ops_[64];
  static const uint16_t table22_0_ops_[128];
  static const uint16_t table22_1_ops_[128];
  static const uint16_t table22_2_ops_[128];
  static const uint16_t table22_3_ops_[128];
  static const uint16_t table22_12_ops_[128];
  static const uint8_t table22_13_emit_[104];
  static const uint16_t table22_13_ops_[128];
  static const uint8_t table22_15_emit_[104];
  static const uint8_t table22_17_emit_[104];
  static const uint8_t table22_19_emit_[104];
  static const uint8_t table22_21_emit_[104];
  static const uint8_t table22_23_emit_[104];
  static const uint8_t table22_25_emit_[104];
  static const uint8_t table22_27_emit_[104];
  static const uint8_t table22_28_emit_[136];
  static const uint16_t table22_28_ops_[128];
  static const uint8_t table22_29_emit_[136];
  static const uint8_t table22_30_emit_[136];
  static const uint8_t table22_31_emit_[136];
  static const uint8_t table22_32_emit_[136];
  static const uint8_t table22_33_emit_[136];
  static const uint8_t table22_34_emit_[136];
  static const uint8_t table22_35_emit_[136];
  static const uint8_t table22_36_emit_[136];
  static const uint8_t table22_37_emit_[136];
  static const uint8_t table22_38_emit_[136];
  static const uint8_t table22_39_emit_[136];
  static const uint8_t table22_40_emit_[136];
  static const uint8_t table22_41_emit_[144];
  static const uint16_t table22_41_ops_[128];
  static const uint8_t table22_42_emit_[144];
  static const uint8_t table22_43_emit_[144];
  static const uint8_t table22_44_emit_[144];
  static const uint8_t table22_45_emit_[144];
  static const uint8_t table22_46_emit_[144];
  static const uint8_t table22_47_emit_[144];
  static const uint8_t table22_48_emit_[144];
  static const uint8_t table22_49_emit_[144];
  static const uint8_t table22_50_emit_[144];
  static const uint8_t table22_51_emit_[144];
  static const uint8_t table22_52_emit_[144];
  static const uint8_t table22_53_emit_[144];
  static const uint8_t table22_54_emit_[80];
  static const uint16_t table22_54_ops_[128];
  static const uint8_t table22_55_emit_[80];
  static const uint8_t table22_56_emit_[80];
  static const uint8_t table22_57_emit_[80];
  static const uint8_t table22_58_emit_[80];
  static const uint8_t table22_59_emit_[80];
  static const uint8_t table22_60_emit_[80];
  static const uint8_t table22_61_emit_[26];
  static const uint16_t table22_61_ops_[128];
  static const uint16_t table22_62_ops_[128];
  static const uint8_t table22_63_emit_[63];
  static const uint16_t table22_63_ops_[128];
  static const uint8_t* const table22_emit_[64];
  static const uint16_t* const table22_ops_[64];
  static const uint8_t table23_0_emit_[120];
  static const uint16_t table23_0_ops_[128];
  static const uint8_t table23_1_emit_[120];
  static const uint8_t table23_2_emit_[68];
  static const uint16_t table23_2_ops_[128];
  static const uint8_t table23_3_emit_[16];
  static const uint16_t table23_3_ops_[128];
  static const uint8_t table23_4_emit_[16];
  static const uint8_t table23_5_emit_[20];
  static const uint16_t table23_5_ops_[128];
  static const uint8_t table23_6_emit_[32];
  static const uint16_t table23_6_ops_[128];
  static const uint8_t table23_7_emit_[46];
  static const uint16_t table23_7_ops_[128];
  static const uint8_t table23_8_emit_[120];
  static const uint8_t table23_9_emit_[120];
  static const uint8_t table23_10_emit_[68];
  static const uint8_t table23_11_emit_[16];
  static const uint8_t table23_12_emit_[16];
  static const uint8_t table23_13_emit_[20];
  static const uint8_t table23_14_emit_[32];
  static const uint8_t table23_15_emit_[46];
  static const uint8_t table23_16_emit_[120];
  static const uint8_t table23_17_emit_[120];
  static const uint8_t table23_18_emit_[68];
  static const uint8_t table23_19_emit_[16];
  static const uint8_t table23_20_emit_[16];
  static const uint8_t table23_21_emit_[20];
  static const uint8_t table23_22_emit_[32];
  static const uint8_t table23_23_emit_[46];
  static const uint8_t table23_24_emit_[16];
  static const uint8_t table23_25_emit_[28];
  static const uint16_t table23_25_ops_[128];
  static const uint8_t table23_26_emit_[36];
  static const uint16_t table23_26_ops_[128];
  static const uint8_t table23_27_emit_[68];
  static const uint16_t table23_27_ops_[128];
  static const uint8_t table23_28_emit_[16];
  static const uint8_t table23_29_emit_[28];
  static const uint8_t table23_30_emit_[36];
  static const uint8_t table23_31_emit_[68];
  static const uint8_t table23_32_emit_[16];
  static const uint8_t table23_33_emit_[28];
  static const uint8_t table23_34_emit_[36];
  static const uint8_t table23_35_emit_[68];
  static const uint8_t table23_36_emit_[16];
  static const uint8_t table23_37_emit_[28];
  static const uint8_t table23_38_emit_[36];
  static const uint8_t table23_39_emit_[68];
  static const uint8_t table23_40_emit_[16];
  static const uint8_t table23_41_emit_[28];
  static const uint8_t table23_42_emit_[36];
  static const uint8_t table23_43_emit_[68];
  static const uint8_t table23_44_emit_[16];
  static const uint8_t table23_45_emit_[28];
  static const uint8_t table23_46_emit_[36];
  static const uint8_t table23_47_emit_[68];
  static const uint8_t table23_48_emit_[16];
  static const uint8_t table23_49_emit_[28];
  static const uint8_t table23_50_emit_[36];
  static const uint8_t table23_51_emit_[68];
  static const uint8_t table23_52_emit_[16];
  static const uint8_t table23_53_emit_[28];
  static const uint8_t table23_54_emit_[36];
  static const uint8_t table23_55_emit_[68];
  static const uint8_t table23_56_emit_[44];
  static const uint16_t table23_56_ops_[128];
  static const uint8_t table23_57_emit_[104];
  static const uint16_t table23_57_ops_[128];
  static const uint8_t table23_58_emit_[44];
  static const uint8_t table23_59_emit_[104];
  static const uint8_t table23_60_emit_[44];
  static const uint8_t table23_61_emit_[104];
  static const uint8_t table23_62_emit_[44];
  static const uint8_t table23_63_emit_[104];
  static const uint8_t table23_64_emit_[44];
  static const uint8_t table23_65_emit_[104];
  static const uint8_t table23_66_emit_[44];
  static const uint8_t table23_67_emit_[104];
  static const uint8_t table23_68_emit_[44];
  static const uint8_t table23_69_emit_[104];
  static const uint8_t table23_70_emit_[44];
  static const uint8_t table23_71_emit_[104];
  static const uint8_t table23_72_emit_[44];
  static const uint8_t table23_73_emit_[104];
  static const uint8_t table23_74_emit_[44];
  static const uint8_t table23_75_emit_[104];
  static const uint8_t table23_76_emit_[44];
  static const uint8_t table23_77_emit_[104];
  static const uint8_t table23_78_emit_[44];
  static const uint8_t table23_79_emit_[104];
  static const uint8_t table23_80_emit_[44];
  static const uint8_t table23_81_emit_[104];
  static const uint8_t table23_82_emit_[136];
  static const uint16_t table23_82_ops_[128];
  static const uint8_t table23_83_emit_[136];
  static const uint8_t table23_84_emit_[136];
  static const uint8_t table23_85_emit_[136];
  static const uint8_t table23_86_emit_[136];
  static const uint8_t table23_87_emit_[136];
  static const uint8_t table23_88_emit_[136];
  static const uint8_t table23_89_emit_[136];
  static const uint8_t table23_90_emit_[136];
  static const uint8_t table23_91_emit_[136];
  static const uint8_t table23_92_emit_[136];
  static const uint8_t table23_93_emit_[136];
  static const uint8_t table23_94_emit_[136];
  static const uint8_t table23_95_emit_[136];
  static const uint8_t table23_96_emit_[136];
  static const uint8_t table23_97_emit_[136];
  static const uint8_t table23_98_emit_[136];
  static const uint8_t table23_99_emit_[136];
  static const uint8_t table23_100_emit_[136];
  static const uint8_t table23_101_emit_[136];
  static const uint8_t table23_102_emit_[136];
  static const uint8_t table23_103_emit_[136];
  static const uint8_t table23_104_emit_[136];
  static const uint8_t table23_105_emit_[136];
  static const uint8_t table23_106_emit_[136];
  static const uint8_t table23_107_emit_[136];
  static const uint8_t table23_108_emit_[144];
  static const uint16_t table23_108_ops_[128];
  static const uint8_t table23_109_emit_[144];
  static const uint8_t table23_110_emit_[144];
  static const uint8_t table23_111_emit_[144];
  static const uint8_t table23_112_emit_[144];
  static const uint8_t table23_113_emit_[144];
  static const uint8_t table23_114_emit_[144];
  static const uint8_t table23_115_emit_[144];
  static const uint8_t table23_116_emit_[144];
  static const uint8_t table23_117_emit_[144];
  static const uint8_t table23_118_emit_[144];
  static const uint8_t table23_119_emit_[144];
  static const uint8_t table23_120_emit_[144];
  static const uint8_t table23_121_emit_[144];
  static const uint8_t table23_122_emit_[112];
  static const uint16_t table23_122_ops_[128];
  static const uint8_t table23_123_emit_[80];
  static const uint16_t table23_123_ops_[128];
  static const uint8_t table23_124_emit_[80];
  static const uint8_t table23_125_emit_[44];
  static const uint16_t table23_125_ops_[128];
  static const uint8_t table23_126_emit_[17];
  static const uint16_t table23_126_ops_[128];
  static const uint8_t table23_127_emit_[46];
  static const uint16_t table23_127_ops_[128];
  static const uint8_t* const table23_emit_[128];
  static const uint16_t* const table23_ops_[128];
  static const uint8_t table12_0_emit_[1];
  static const uint16_t table12_0_ops_[256];
  static const uint8_t table12_8_emit_[1];
  static const uint8_t table12_16_emit_[1];
  static const uint8_t table12_24_emit_[1];
  static const uint16_t table12_24_ops_[256];
  static const uint8_t table12_28_emit_[1];
  static const uint8_t table12_32_emit_[1];
  static const uint8_t table12_36_emit_[1];
  static const uint8_t table12_40_emit_[1];
  static const uint8_t table12_44_emit_[1];
  static const uint8_t table12_48_emit_[1];
  static const uint8_t table12_52_emit_[1];
  static const uint8_t table12_56_emit_[1];
  static const uint16_t table12_56_ops_[256];
  static const uint8_t table12_58_emit_[1];
  static const uint8_t table12_60_emit_[1];
  static const uint8_t table12_62_emit_[1];
  static const uint8_t table12_64_emit_[1];
  static const uint8_t table12_66_emit_[1];
  static const uint8_t table12_68_emit_[1];
  static const uint8_t table12_70_emit_[1];
  static const uint8_t table12_72_emit_[1];
  static const uint8_t table12_74_emit_[1];
  static const uint8_t table12_76_emit_[1];
  static const uint8_t table12_78_emit_[1];
  static const uint8_t table12_80_emit_[1];
  static const uint8_t table12_82_emit_[1];
  static const uint16_t table12_82_ops_[256];
  static const uint8_t table12_83_emit_[1];
  static const uint8_t table12_84_emit_[1];
  static const uint8_t table12_85_emit_[1];
  static const uint8_t table12_86_emit_[1];
  static const uint8_t table12_87_emit_[1];
  static const uint8_t table12_88_emit_[1];
  static const uint8_t table12_89_emit_[1];
  static const uint8_t table12_90_emit_[1];
  static const uint8_t table12_91_emit_[1];
  static const uint8_t table12_92_emit_[1];
  static const uint8_t table12_93_emit_[1];
  static const uint8_t table12_94_emit_[1];
  static const uint8_t table12_95_emit_[1];
  static const uint8_t table12_96_emit_[1];
  static const uint8_t table12_97_emit_[1];
  static const uint8_t table12_98_emit_[1];
  static const uint8_t table12_99_emit_[1];
  static const uint8_t table12_100_emit_[1];
  static const uint8_t table12_101_emit_[1];
  static const uint8_t table12_102_emit_[1];
  static const uint8_t table12_103_emit_[1];
  static const uint8_t table12_104_emit_[1];
  static const uint8_t table12_105_emit_[1];
  static const uint8_t table12_106_emit_[1];
  static const uint8_t table12_107_emit_[1];
  static const uint8_t table12_108_emit_[2];
  static const uint16_t table12_108_ops_[256];
  static const uint8_t table12_109_emit_[2];
  static const uint8_t table12_110_emit_[2];
  static const uint8_t table12_111_emit_[2];
  static const uint8_t table12_112_emit_[2];
  static const uint8_t table12_113_emit_[2];
  static const uint8_t table12_114_emit_[2];
  static const uint8_t table12_115_emit_[2];
  static const uint8_t table12_116_emit_[2];
  static const uint8_t table12_117_emit_[2];
  static const uint8_t table12_118_emit_[2];
  static const uint8_t table12_119_emit_[2];
  static const uint8_t table12_120_emit_[2];
  static const uint8_t table12_121_emit_[2];
  static const uint8_t table12_122_emit_[3];
  static const uint16_t table12_122_ops_[256];
  static const uint8_t table12_123_emit_[4];
  static const uint16_t table12_123_ops_[256];
  static const uint8_t table12_124_emit_[4];
  static const uint8_t table12_125_emit_[6];
  static const uint16_t table12_125_ops_[256];
  static const uint16_t table12_126_ops_[256];
  static const uint8_t table12_127_emit_[49];
  static const uint16_t table12_127_ops_[256];
  static const uint8_t* const table12_emit_[128];
  static const uint16_t* const table12_ops_[128];
};
template <typename F>
class HuffDecoder : public HuffDecoderCommon {
 public:
  HuffDecoder(F sink, const uint8_t* begin, const uint8_t* end)
      : sink_(sink), begin_(begin), end_(end) {}
  bool Run() {
    while (!done_) {
      if (!RefillTo15()) {
        Done0();
        break;
      }
      const auto index = (buffer_ >> (buffer_len_ - 15)) & 0x7fff;
      const auto op = GetOp1(index);
      const int consumed = op & 15;
      buffer_len_ -= consumed;
      const auto emit_ofs = op >> 6;
      switch ((op >> 4) & 3) {
        case 0: {
          sink_(GetEmit1(index, emit_ofs + 0));
          sink_(GetEmit1(index, emit_ofs + 1));
          sink_(GetEmit1(index, emit_ofs + 2));
          break;
        }
        case 1: {
          sink_(GetEmit1(index, emit_ofs + 0));
          sink_(GetEmit1(index, emit_ofs + 1));
          break;
        }
        case 2: {
          sink_(GetEmit1(index, emit_ofs + 0));
          break;
        }
        case 3: {
          DecodeStep0();
          break;
        }
      }
    }
    return ok_;
  }

 private:
  bool RefillTo15() {
    switch (buffer_len_) {
      case 0: {
        return Read2to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6: {
        return Read2to7Bytes();
      }
      case 7:
      case 8: {
        return Read1to7Bytes();
      }
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14: {
        return Read1to6Bytes();
      }
    }
    return true;
  }
  bool Read2to8Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  void Fill2() {
    buffer_ = (buffer_ << 16) | (static_cast<uint64_t>(begin_[0]) << 8) |
              (static_cast<uint64_t>(begin_[1]) << 0);
    begin_ += 2;
    buffer_len_ += 16;
  }
  void Fill3() {
    buffer_ = (buffer_ << 24) | (static_cast<uint64_t>(begin_[0]) << 16) |
              (static_cast<uint64_t>(begin_[1]) << 8) |
              (static_cast<uint64_t>(begin_[2]) << 0);
    begin_ += 3;
    buffer_len_ += 24;
  }
  void Fill4() {
    buffer_ = (buffer_ << 32) | (static_cast<uint64_t>(begin_[0]) << 24) |
              (static_cast<uint64_t>(begin_[1]) << 16) |
              (static_cast<uint64_t>(begin_[2]) << 8) |
              (static_cast<uint64_t>(begin_[3]) << 0);
    begin_ += 4;
    buffer_len_ += 32;
  }
  void Fill5() {
    buffer_ = (buffer_ << 40) | (static_cast<uint64_t>(begin_[0]) << 32) |
              (static_cast<uint64_t>(begin_[1]) << 24) |
              (static_cast<uint64_t>(begin_[2]) << 16) |
              (static_cast<uint64_t>(begin_[3]) << 8) |
              (static_cast<uint64_t>(begin_[4]) << 0);
    begin_ += 5;
    buffer_len_ += 40;
  }
  void Fill6() {
    buffer_ = (buffer_ << 48) | (static_cast<uint64_t>(begin_[0]) << 40) |
              (static_cast<uint64_t>(begin_[1]) << 32) |
              (static_cast<uint64_t>(begin_[2]) << 24) |
              (static_cast<uint64_t>(begin_[3]) << 16) |
              (static_cast<uint64_t>(begin_[4]) << 8) |
              (static_cast<uint64_t>(begin_[5]) << 0);
    begin_ += 6;
    buffer_len_ += 48;
  }
  void Fill7() {
    buffer_ = (buffer_ << 56) | (static_cast<uint64_t>(begin_[0]) << 48) |
              (static_cast<uint64_t>(begin_[1]) << 40) |
              (static_cast<uint64_t>(begin_[2]) << 32) |
              (static_cast<uint64_t>(begin_[3]) << 24) |
              (static_cast<uint64_t>(begin_[4]) << 16) |
              (static_cast<uint64_t>(begin_[5]) << 8) |
              (static_cast<uint64_t>(begin_[6]) << 0);
    begin_ += 7;
    buffer_len_ += 56;
  }
  void Fill8() {
    buffer_ = 0 | (static_cast<uint64_t>(begin_[0]) << 56) |
              (static_cast<uint64_t>(begin_[1]) << 48) |
              (static_cast<uint64_t>(begin_[2]) << 40) |
              (static_cast<uint64_t>(begin_[3]) << 32) |
              (static_cast<uint64_t>(begin_[4]) << 24) |
              (static_cast<uint64_t>(begin_[5]) << 16) |
              (static_cast<uint64_t>(begin_[6]) << 8) |
              (static_cast<uint64_t>(begin_[7]) << 0);
    begin_ += 8;
    buffer_len_ += 64;
  }
  bool Read2to7Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  bool Read1to7Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  void Fill1() {
    buffer_ = (buffer_ << 8) | (static_cast<uint64_t>(begin_[0]) << 0);
    begin_ += 1;
    buffer_len_ += 8;
  }
  bool Read1to6Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      default: {
        Fill6();
        return true;
      }
    }
  }
  void Done0() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3:
      case 4: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp2(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit2(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp3(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit3(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp4(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit4(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp5(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit5(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 9: {
        const auto index = buffer_ & 511;
        const auto op = GetOp6(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit6(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 10: {
        const auto index = buffer_ & 1023;
        const auto op = GetOp7(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit7(index, (op >> 2) + 0));
            sink_(GetEmit7(index, (op >> 2) + 1));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit7(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 11: {
        const auto index = buffer_ & 2047;
        const auto op = GetOp8(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit8(index, (op >> 2) + 0));
            sink_(GetEmit8(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit8(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 12: {
        const auto index = buffer_ & 4095;
        const auto op = GetOp9(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit9(index, (op >> 2) + 0));
            sink_(GetEmit9(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit9(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 13: {
        const auto index = buffer_ & 8191;
        const auto op = GetOp10(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit10(index, (op >> 2) + 0));
            sink_(GetEmit10(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit10(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 14: {
        const auto index = buffer_ & 16383;
        const auto op = GetOp11(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit11(index, (op >> 2) + 0));
            sink_(GetEmit11(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit11(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep0() {
    if (!RefillTo15()) {
      Done1();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 15)) & 0x7fff;
    const auto op = GetOp12(index);
    const int consumed = op & 15;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 5;
    switch ((op >> 4) & 1) {
      case 0: {
        sink_(GetEmit12(index, emit_ofs + 0));
        break;
      }
      case 1: {
        begin_ = end_;
        buffer_len_ = 0;
        break;
      }
    }
  }
  void Done1() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 4: {
        const auto index = buffer_ & 15;
        const auto op = GetOp13(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit13(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp14(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit14(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp15(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit15(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp16(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit16(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp17(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit17(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 9: {
        const auto index = buffer_ & 511;
        const auto op = GetOp18(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit18(index, (op >> 2) + 0));
            sink_(GetEmit18(index, (op >> 2) + 1));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit18(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 10: {
        const auto index = buffer_ & 1023;
        const auto op = GetOp19(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit19(index, (op >> 2) + 0));
            sink_(GetEmit19(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit19(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 11: {
        const auto index = buffer_ & 2047;
        const auto op = GetOp20(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit20(index, (op >> 2) + 0));
            sink_(GetEmit20(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit20(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 12: {
        const auto index = buffer_ & 4095;
        const auto op = GetOp21(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit21(index, (op >> 2) + 0));
            sink_(GetEmit21(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit21(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 13: {
        const auto index = buffer_ & 8191;
        const auto op = GetOp22(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit22(index, (op >> 2) + 0));
            sink_(GetEmit22(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit22(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 14: {
        const auto index = buffer_ & 16383;
        const auto op = GetOp23(index);
        switch (op & 7) {
          case 0: {
            sink_(GetEmit23(index, (op >> 3) + 0));
            sink_(GetEmit23(index, (op >> 3) + 1));
            sink_(GetEmit23(index, (op >> 3) + 2));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit23(index, (op >> 3) + 0));
            sink_(GetEmit23(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit23(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  F sink_;
  const uint8_t* begin_;
  const uint8_t* const end_;
  uint64_t buffer_ = 0;
  int buffer_len_ = 0;
  bool ok_ = true;
  bool done_ = false;
};
}  // namespace geometry_15_15
}  // namespace grpc_core
#endif  // GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_15_15_H
