// swift-tools-version:5.5
// The swift-tools-version declares the minimum version of Swift required to build this package.
import PackageDescription
import Foundation

var basePath = FileManager.default.fileExists(atPath: "native") ? "native" : "."

let package = Package(
  name: "gRPC",
  products: [
    .library(
      name: "gRPC-Core",
      targets: [
        "gRPC-Core",
      ]
    ),
    .library(
      name: "gRPC-cpp",
      targets: [
        "gRPC-cpp",
      ]
    )
  ],

  dependencies: [
    .package(url: "https://github.com/firebase/abseil-cpp-SwiftPM.git", "0.20240116.1"..<"0.20240117.0"),
    .package(url: "https://github.com/firebase/boringssl-SwiftPM.git", "0.32.0"..<"0.33.0"),
  ],

  targets: [
    .target(
      name: "gRPC-Core",
      dependencies: [
        .product(name:"abseil", package: "abseil-cpp-SwiftPM"),
        .product(name:"openssl_grpc", package: "boringssl-SwiftPM"),
      ],
      path: basePath,
      exclude: [
        "examples/",
        "src/objective-c/",
      ],
    
      sources: [
        "include/grpc/byte_buffer.h",
        "include/grpc/byte_buffer_reader.h",
        "include/grpc/census.h",
        "include/grpc/compression.h",
        "include/grpc/credentials.h",
        "include/grpc/event_engine/endpoint_config.h",
        "include/grpc/event_engine/event_engine.h",
        "include/grpc/event_engine/extensible.h",
        "include/grpc/event_engine/internal/memory_allocator_impl.h",
        "include/grpc/event_engine/internal/slice_cast.h",
        "include/grpc/event_engine/memory_allocator.h",
        "include/grpc/event_engine/memory_request.h",
        "include/grpc/event_engine/port.h",
        "include/grpc/event_engine/slice.h",
        "include/grpc/event_engine/slice_buffer.h",
        "include/grpc/fork.h",
        "include/grpc/grpc.h",
        "include/grpc/grpc_audit_logging.h",
        "include/grpc/grpc_crl_provider.h",
        "include/grpc/grpc_posix.h",
        "include/grpc/grpc_security.h",
        "include/grpc/grpc_security_constants.h",
        "include/grpc/impl/call.h",
        "include/grpc/impl/channel_arg_names.h",
        "include/grpc/impl/codegen/atm.h",
        "include/grpc/impl/codegen/atm_gcc_atomic.h",
        "include/grpc/impl/codegen/atm_gcc_sync.h",
        "include/grpc/impl/codegen/atm_windows.h",
        "include/grpc/impl/codegen/byte_buffer.h",
        "include/grpc/impl/codegen/byte_buffer_reader.h",
        "include/grpc/impl/codegen/compression_types.h",
        "include/grpc/impl/codegen/connectivity_state.h",
        "include/grpc/impl/codegen/fork.h",
        "include/grpc/impl/codegen/gpr_types.h",
        "include/grpc/impl/codegen/grpc_types.h",
        "include/grpc/impl/codegen/log.h",
        "include/grpc/impl/codegen/port_platform.h",
        "include/grpc/impl/codegen/propagation_bits.h",
        "include/grpc/impl/codegen/slice.h",
        "include/grpc/impl/codegen/status.h",
        "include/grpc/impl/codegen/sync.h",
        "include/grpc/impl/codegen/sync_abseil.h",
        "include/grpc/impl/codegen/sync_custom.h",
        "include/grpc/impl/codegen/sync_generic.h",
        "include/grpc/impl/codegen/sync_posix.h",
        "include/grpc/impl/codegen/sync_windows.h",
        "include/grpc/impl/compression_types.h",
        "include/grpc/impl/connectivity_state.h",
        "include/grpc/impl/grpc_types.h",
        "include/grpc/impl/propagation_bits.h",
        "include/grpc/impl/slice_type.h",
        "include/grpc/load_reporting.h",
        "include/grpc/passive_listener.h",
        "include/grpc/slice.h",
        "include/grpc/slice_buffer.h",
        "include/grpc/status.h",
        "include/grpc/support/alloc.h",
        "include/grpc/support/atm.h",
        "include/grpc/support/atm_gcc_atomic.h",
        "include/grpc/support/atm_gcc_sync.h",
        "include/grpc/support/atm_windows.h",
        "include/grpc/support/cpu.h",
        "include/grpc/support/json.h",
        "include/grpc/support/log.h",
        "include/grpc/support/log_windows.h",
        "include/grpc/support/metrics.h",
        "include/grpc/support/port_platform.h",
        "include/grpc/support/string_util.h",
        "include/grpc/support/sync.h",
        "include/grpc/support/sync_abseil.h",
        "include/grpc/support/sync_custom.h",
        "include/grpc/support/sync_generic.h",
        "include/grpc/support/sync_posix.h",
        "include/grpc/support/sync_windows.h",
        "include/grpc/support/thd_id.h",
        "include/grpc/support/time.h",
        "include/grpc/support/workaround_list.h",
        "src/core/channelz/channel_trace.cc",
        "src/core/channelz/channel_trace.h",
        "src/core/channelz/channelz.cc",
        "src/core/channelz/channelz.h",
        "src/core/channelz/channelz_registry.cc",
        "src/core/channelz/channelz_registry.h",
        "src/core/client_channel/backup_poller.cc",
        "src/core/client_channel/backup_poller.h",
        "src/core/client_channel/client_channel.cc",
        "src/core/client_channel/client_channel.h",
        "src/core/client_channel/client_channel_factory.cc",
        "src/core/client_channel/client_channel_factory.h",
        "src/core/client_channel/client_channel_filter.cc",
        "src/core/client_channel/client_channel_filter.h",
        "src/core/client_channel/client_channel_internal.h",
        "src/core/client_channel/client_channel_plugin.cc",
        "src/core/client_channel/client_channel_service_config.cc",
        "src/core/client_channel/client_channel_service_config.h",
        "src/core/client_channel/config_selector.h",
        "src/core/client_channel/connector.h",
        "src/core/client_channel/direct_channel.cc",
        "src/core/client_channel/direct_channel.h",
        "src/core/client_channel/dynamic_filters.cc",
        "src/core/client_channel/dynamic_filters.h",
        "src/core/client_channel/global_subchannel_pool.cc",
        "src/core/client_channel/global_subchannel_pool.h",
        "src/core/client_channel/lb_metadata.cc",
        "src/core/client_channel/lb_metadata.h",
        "src/core/client_channel/load_balanced_call_destination.cc",
        "src/core/client_channel/load_balanced_call_destination.h",
        "src/core/client_channel/local_subchannel_pool.cc",
        "src/core/client_channel/local_subchannel_pool.h",
        "src/core/client_channel/retry_filter.cc",
        "src/core/client_channel/retry_filter.h",
        "src/core/client_channel/retry_filter_legacy_call_data.cc",
        "src/core/client_channel/retry_filter_legacy_call_data.h",
        "src/core/client_channel/retry_service_config.cc",
        "src/core/client_channel/retry_service_config.h",
        "src/core/client_channel/retry_throttle.cc",
        "src/core/client_channel/retry_throttle.h",
        "src/core/client_channel/subchannel.cc",
        "src/core/client_channel/subchannel.h",
        "src/core/client_channel/subchannel_interface_internal.h",
        "src/core/client_channel/subchannel_pool_interface.cc",
        "src/core/client_channel/subchannel_pool_interface.h",
        "src/core/client_channel/subchannel_stream_client.cc",
        "src/core/client_channel/subchannel_stream_client.h",
        "src/core/config/config_vars.cc",
        "src/core/config/config_vars.h",
        "src/core/config/config_vars_non_generated.cc",
        "src/core/config/core_configuration.cc",
        "src/core/config/core_configuration.h",
        "src/core/config/load_config.cc",
        "src/core/config/load_config.h",
        "src/core/ext/filters/backend_metrics/backend_metric_filter.cc",
        "src/core/ext/filters/backend_metrics/backend_metric_filter.h",
        "src/core/ext/filters/backend_metrics/backend_metric_provider.h",
        "src/core/ext/filters/census/grpc_context.cc",
        "src/core/ext/filters/channel_idle/idle_filter_state.cc",
        "src/core/ext/filters/channel_idle/idle_filter_state.h",
        "src/core/ext/filters/channel_idle/legacy_channel_idle_filter.cc",
        "src/core/ext/filters/channel_idle/legacy_channel_idle_filter.h",
        "src/core/ext/filters/fault_injection/fault_injection_filter.cc",
        "src/core/ext/filters/fault_injection/fault_injection_filter.h",
        "src/core/ext/filters/fault_injection/fault_injection_service_config_parser.cc",
        "src/core/ext/filters/fault_injection/fault_injection_service_config_parser.h",
        "src/core/ext/filters/gcp_authentication/gcp_authentication_filter.cc",
        "src/core/ext/filters/gcp_authentication/gcp_authentication_filter.h",
        "src/core/ext/filters/gcp_authentication/gcp_authentication_service_config_parser.cc",
        "src/core/ext/filters/gcp_authentication/gcp_authentication_service_config_parser.h",
        "src/core/ext/filters/http/client/http_client_filter.cc",
        "src/core/ext/filters/http/client/http_client_filter.h",
        "src/core/ext/filters/http/client_authority_filter.cc",
        "src/core/ext/filters/http/client_authority_filter.h",
        "src/core/ext/filters/http/http_filters_plugin.cc",
        "src/core/ext/filters/http/message_compress/compression_filter.cc",
        "src/core/ext/filters/http/message_compress/compression_filter.h",
        "src/core/ext/filters/http/server/http_server_filter.cc",
        "src/core/ext/filters/http/server/http_server_filter.h",
        "src/core/ext/filters/message_size/message_size_filter.cc",
        "src/core/ext/filters/message_size/message_size_filter.h",
        "src/core/ext/filters/rbac/rbac_filter.cc",
        "src/core/ext/filters/rbac/rbac_filter.h",
        "src/core/ext/filters/rbac/rbac_service_config_parser.cc",
        "src/core/ext/filters/rbac/rbac_service_config_parser.h",
        "src/core/ext/filters/stateful_session/stateful_session_filter.cc",
        "src/core/ext/filters/stateful_session/stateful_session_filter.h",
        "src/core/ext/filters/stateful_session/stateful_session_service_config_parser.cc",
        "src/core/ext/filters/stateful_session/stateful_session_service_config_parser.h",
        "src/core/ext/transport/chttp2/alpn/alpn.cc",
        "src/core/ext/transport/chttp2/alpn/alpn.h",
        "src/core/ext/transport/chttp2/client/chttp2_connector.cc",
        "src/core/ext/transport/chttp2/client/chttp2_connector.h",
        "src/core/ext/transport/chttp2/server/chttp2_server.cc",
        "src/core/ext/transport/chttp2/server/chttp2_server.h",
        "src/core/ext/transport/chttp2/transport/bin_decoder.cc",
        "src/core/ext/transport/chttp2/transport/bin_decoder.h",
        "src/core/ext/transport/chttp2/transport/bin_encoder.cc",
        "src/core/ext/transport/chttp2/transport/bin_encoder.h",
        "src/core/ext/transport/chttp2/transport/call_tracer_wrapper.cc",
        "src/core/ext/transport/chttp2/transport/call_tracer_wrapper.h",
        "src/core/ext/transport/chttp2/transport/chttp2_transport.cc",
        "src/core/ext/transport/chttp2/transport/chttp2_transport.h",
        "src/core/ext/transport/chttp2/transport/context_list_entry.h",
        "src/core/ext/transport/chttp2/transport/decode_huff.cc",
        "src/core/ext/transport/chttp2/transport/decode_huff.h",
        "src/core/ext/transport/chttp2/transport/flow_control.cc",
        "src/core/ext/transport/chttp2/transport/flow_control.h",
        "src/core/ext/transport/chttp2/transport/frame.cc",
        "src/core/ext/transport/chttp2/transport/frame.h",
        "src/core/ext/transport/chttp2/transport/frame_data.cc",
        "src/core/ext/transport/chttp2/transport/frame_data.h",
        "src/core/ext/transport/chttp2/transport/frame_goaway.cc",
        "src/core/ext/transport/chttp2/transport/frame_goaway.h",
        "src/core/ext/transport/chttp2/transport/frame_ping.cc",
        "src/core/ext/transport/chttp2/transport/frame_ping.h",
        "src/core/ext/transport/chttp2/transport/frame_rst_stream.cc",
        "src/core/ext/transport/chttp2/transport/frame_rst_stream.h",
        "src/core/ext/transport/chttp2/transport/frame_security.cc",
        "src/core/ext/transport/chttp2/transport/frame_security.h",
        "src/core/ext/transport/chttp2/transport/frame_settings.cc",
        "src/core/ext/transport/chttp2/transport/frame_settings.h",
        "src/core/ext/transport/chttp2/transport/frame_window_update.cc",
        "src/core/ext/transport/chttp2/transport/frame_window_update.h",
        "src/core/ext/transport/chttp2/transport/hpack_constants.h",
        "src/core/ext/transport/chttp2/transport/hpack_encoder.cc",
        "src/core/ext/transport/chttp2/transport/hpack_encoder.h",
        "src/core/ext/transport/chttp2/transport/hpack_encoder_table.cc",
        "src/core/ext/transport/chttp2/transport/hpack_encoder_table.h",
        "src/core/ext/transport/chttp2/transport/hpack_parse_result.cc",
        "src/core/ext/transport/chttp2/transport/hpack_parse_result.h",
        "src/core/ext/transport/chttp2/transport/hpack_parser.cc",
        "src/core/ext/transport/chttp2/transport/hpack_parser.h",
        "src/core/ext/transport/chttp2/transport/hpack_parser_table.cc",
        "src/core/ext/transport/chttp2/transport/hpack_parser_table.h",
        "src/core/ext/transport/chttp2/transport/http2_settings.cc",
        "src/core/ext/transport/chttp2/transport/http2_settings.h",
        "src/core/ext/transport/chttp2/transport/huffsyms.cc",
        "src/core/ext/transport/chttp2/transport/huffsyms.h",
        "src/core/ext/transport/chttp2/transport/internal.h",
        "src/core/ext/transport/chttp2/transport/legacy_frame.h",
        "src/core/ext/transport/chttp2/transport/parsing.cc",
        "src/core/ext/transport/chttp2/transport/ping_abuse_policy.cc",
        "src/core/ext/transport/chttp2/transport/ping_abuse_policy.h",
        "src/core/ext/transport/chttp2/transport/ping_callbacks.cc",
        "src/core/ext/transport/chttp2/transport/ping_callbacks.h",
        "src/core/ext/transport/chttp2/transport/ping_rate_policy.cc",
        "src/core/ext/transport/chttp2/transport/ping_rate_policy.h",
        "src/core/ext/transport/chttp2/transport/stream_lists.cc",
        "src/core/ext/transport/chttp2/transport/stream_lists.h",
        "src/core/ext/transport/chttp2/transport/varint.cc",
        "src/core/ext/transport/chttp2/transport/varint.h",
        "src/core/ext/transport/chttp2/transport/write_size_policy.cc",
        "src/core/ext/transport/chttp2/transport/write_size_policy.h",
        "src/core/ext/transport/chttp2/transport/writing.cc",
        "src/core/ext/transport/inproc/inproc_transport.cc",
        "src/core/ext/transport/inproc/inproc_transport.h",
        "src/core/ext/transport/inproc/legacy_inproc_transport.cc",
        "src/core/ext/transport/inproc/legacy_inproc_transport.h",
        "src/core/ext/upb-gen/envoy/admin/v3/certs.upb.h",
        "src/core/ext/upb-gen/envoy/admin/v3/certs.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/admin/v3/certs.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/admin/v3/clusters.upb.h",
        "src/core/ext/upb-gen/envoy/admin/v3/clusters.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/admin/v3/clusters.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/admin/v3/config_dump.upb.h",
        "src/core/ext/upb-gen/envoy/admin/v3/config_dump.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/admin/v3/config_dump.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/admin/v3/config_dump_shared.upb.h",
        "src/core/ext/upb-gen/envoy/admin/v3/config_dump_shared.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/admin/v3/config_dump_shared.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/admin/v3/init_dump.upb.h",
        "src/core/ext/upb-gen/envoy/admin/v3/init_dump.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/admin/v3/init_dump.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/admin/v3/listeners.upb.h",
        "src/core/ext/upb-gen/envoy/admin/v3/listeners.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/admin/v3/listeners.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/admin/v3/memory.upb.h",
        "src/core/ext/upb-gen/envoy/admin/v3/memory.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/admin/v3/memory.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/admin/v3/metrics.upb.h",
        "src/core/ext/upb-gen/envoy/admin/v3/metrics.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/admin/v3/metrics.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/admin/v3/mutex_stats.upb.h",
        "src/core/ext/upb-gen/envoy/admin/v3/mutex_stats.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/admin/v3/mutex_stats.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/admin/v3/server_info.upb.h",
        "src/core/ext/upb-gen/envoy/admin/v3/server_info.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/admin/v3/server_info.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/admin/v3/tap.upb.h",
        "src/core/ext/upb-gen/envoy/admin/v3/tap.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/admin/v3/tap.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/annotations/deprecation.upb.h",
        "src/core/ext/upb-gen/envoy/annotations/deprecation.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/annotations/deprecation.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/annotations/resource.upb.h",
        "src/core/ext/upb-gen/envoy/annotations/resource.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/annotations/resource.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/accesslog/v3/accesslog.upb.h",
        "src/core/ext/upb-gen/envoy/config/accesslog/v3/accesslog.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/accesslog/v3/accesslog.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/bootstrap/v3/bootstrap.upb.h",
        "src/core/ext/upb-gen/envoy/config/bootstrap/v3/bootstrap.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/bootstrap/v3/bootstrap.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/cluster/v3/circuit_breaker.upb.h",
        "src/core/ext/upb-gen/envoy/config/cluster/v3/circuit_breaker.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/cluster/v3/circuit_breaker.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/cluster/v3/cluster.upb.h",
        "src/core/ext/upb-gen/envoy/config/cluster/v3/cluster.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/cluster/v3/cluster.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/cluster/v3/filter.upb.h",
        "src/core/ext/upb-gen/envoy/config/cluster/v3/filter.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/cluster/v3/filter.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/cluster/v3/outlier_detection.upb.h",
        "src/core/ext/upb-gen/envoy/config/cluster/v3/outlier_detection.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/cluster/v3/outlier_detection.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/common/matcher/v3/matcher.upb.h",
        "src/core/ext/upb-gen/envoy/config/common/matcher/v3/matcher.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/common/matcher/v3/matcher.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/address.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/address.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/address.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/backoff.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/backoff.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/backoff.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/base.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/base.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/base.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/config_source.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/config_source.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/config_source.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/event_service_config.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/event_service_config.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/event_service_config.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/extension.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/extension.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/extension.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/grpc_method_list.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/grpc_method_list.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/grpc_method_list.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/grpc_service.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/grpc_service.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/grpc_service.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/health_check.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/health_check.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/health_check.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/http_service.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/http_service.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/http_service.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/http_uri.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/http_uri.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/http_uri.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/protocol.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/protocol.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/protocol.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/proxy_protocol.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/proxy_protocol.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/proxy_protocol.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/resolver.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/resolver.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/resolver.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/socket_option.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/socket_option.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/socket_option.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/substitution_format_string.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/substitution_format_string.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/substitution_format_string.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/udp_socket_config.upb.h",
        "src/core/ext/upb-gen/envoy/config/core/v3/udp_socket_config.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/core/v3/udp_socket_config.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint.upb.h",
        "src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint_components.upb.h",
        "src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint_components.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint_components.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/endpoint/v3/load_report.upb.h",
        "src/core/ext/upb-gen/envoy/config/endpoint/v3/load_report.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/endpoint/v3/load_report.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/listener/v3/api_listener.upb.h",
        "src/core/ext/upb-gen/envoy/config/listener/v3/api_listener.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/listener/v3/api_listener.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/listener/v3/listener.upb.h",
        "src/core/ext/upb-gen/envoy/config/listener/v3/listener.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/listener/v3/listener.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/listener/v3/listener_components.upb.h",
        "src/core/ext/upb-gen/envoy/config/listener/v3/listener_components.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/listener/v3/listener_components.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/listener/v3/quic_config.upb.h",
        "src/core/ext/upb-gen/envoy/config/listener/v3/quic_config.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/listener/v3/quic_config.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/listener/v3/udp_listener_config.upb.h",
        "src/core/ext/upb-gen/envoy/config/listener/v3/udp_listener_config.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/listener/v3/udp_listener_config.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/metrics/v3/metrics_service.upb.h",
        "src/core/ext/upb-gen/envoy/config/metrics/v3/metrics_service.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/metrics/v3/metrics_service.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/metrics/v3/stats.upb.h",
        "src/core/ext/upb-gen/envoy/config/metrics/v3/stats.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/metrics/v3/stats.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/overload/v3/overload.upb.h",
        "src/core/ext/upb-gen/envoy/config/overload/v3/overload.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/overload/v3/overload.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/rbac/v3/rbac.upb.h",
        "src/core/ext/upb-gen/envoy/config/rbac/v3/rbac.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/rbac/v3/rbac.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/route/v3/route.upb.h",
        "src/core/ext/upb-gen/envoy/config/route/v3/route.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/route/v3/route.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/route/v3/route_components.upb.h",
        "src/core/ext/upb-gen/envoy/config/route/v3/route_components.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/route/v3/route_components.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/route/v3/scoped_route.upb.h",
        "src/core/ext/upb-gen/envoy/config/route/v3/scoped_route.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/route/v3/scoped_route.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/tap/v3/common.upb.h",
        "src/core/ext/upb-gen/envoy/config/tap/v3/common.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/tap/v3/common.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/datadog.upb.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/datadog.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/trace/v3/datadog.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/dynamic_ot.upb.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/dynamic_ot.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/trace/v3/dynamic_ot.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/http_tracer.upb.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/http_tracer.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/trace/v3/http_tracer.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/lightstep.upb.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/lightstep.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/trace/v3/lightstep.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/opencensus.upb.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/opencensus.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/trace/v3/opencensus.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/opentelemetry.upb.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/opentelemetry.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/trace/v3/opentelemetry.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/service.upb.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/service.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/trace/v3/service.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/skywalking.upb.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/skywalking.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/trace/v3/skywalking.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/trace.upb.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/trace.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/trace/v3/trace.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/xray.upb.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/xray.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/trace/v3/xray.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/zipkin.upb.h",
        "src/core/ext/upb-gen/envoy/config/trace/v3/zipkin.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/config/trace/v3/zipkin.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/data/accesslog/v3/accesslog.upb.h",
        "src/core/ext/upb-gen/envoy/data/accesslog/v3/accesslog.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/data/accesslog/v3/accesslog.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/clusters/aggregate/v3/cluster.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/clusters/aggregate/v3/cluster.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/clusters/aggregate/v3/cluster.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/filters/common/fault/v3/fault.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/filters/common/fault/v3/fault.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/filters/common/fault/v3/fault.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/fault/v3/fault.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/fault/v3/fault.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/fault/v3/fault.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/rbac/v3/rbac.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/rbac/v3/rbac.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/rbac/v3/rbac.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/router/v3/router.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/router/v3/router.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/router/v3/router.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/client_side_weighted_round_robin/v3/client_side_weighted_round_robin.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/client_side_weighted_round_robin/v3/client_side_weighted_round_robin.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/client_side_weighted_round_robin/v3/client_side_weighted_round_robin.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/common/v3/common.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/common/v3/common.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/common/v3/common.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/pick_first/v3/pick_first.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/pick_first/v3/pick_first.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/pick_first/v3/pick_first.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/cert.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/cert.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/cert.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/common.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/common.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/common.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/secret.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/secret.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/secret.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upb.h",
        "src/core/ext/upb-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/service/discovery/v3/ads.upb.h",
        "src/core/ext/upb-gen/envoy/service/discovery/v3/ads.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/service/discovery/v3/ads.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/service/discovery/v3/discovery.upb.h",
        "src/core/ext/upb-gen/envoy/service/discovery/v3/discovery.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/service/discovery/v3/discovery.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/service/load_stats/v3/lrs.upb.h",
        "src/core/ext/upb-gen/envoy/service/load_stats/v3/lrs.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/service/load_stats/v3/lrs.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/service/status/v3/csds.upb.h",
        "src/core/ext/upb-gen/envoy/service/status/v3/csds.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/service/status/v3/csds.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/http/v3/cookie.upb.h",
        "src/core/ext/upb-gen/envoy/type/http/v3/cookie.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/http/v3/cookie.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/http/v3/path_transformation.upb.h",
        "src/core/ext/upb-gen/envoy/type/http/v3/path_transformation.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/http/v3/path_transformation.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/filter_state.upb.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/filter_state.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/filter_state.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/http_inputs.upb.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/http_inputs.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/http_inputs.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/metadata.upb.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/metadata.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/metadata.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/node.upb.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/node.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/node.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/number.upb.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/number.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/number.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/path.upb.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/path.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/path.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/regex.upb.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/regex.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/regex.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/status_code_input.upb.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/status_code_input.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/status_code_input.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/string.upb.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/string.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/string.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/struct.upb.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/struct.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/struct.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/value.upb.h",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/value.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/matcher/v3/value.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/metadata/v3/metadata.upb.h",
        "src/core/ext/upb-gen/envoy/type/metadata/v3/metadata.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/metadata/v3/metadata.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/tracing/v3/custom_tag.upb.h",
        "src/core/ext/upb-gen/envoy/type/tracing/v3/custom_tag.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/tracing/v3/custom_tag.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/v3/hash_policy.upb.h",
        "src/core/ext/upb-gen/envoy/type/v3/hash_policy.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/v3/hash_policy.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/v3/http.upb.h",
        "src/core/ext/upb-gen/envoy/type/v3/http.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/v3/http.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/v3/http_status.upb.h",
        "src/core/ext/upb-gen/envoy/type/v3/http_status.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/v3/http_status.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/v3/percent.upb.h",
        "src/core/ext/upb-gen/envoy/type/v3/percent.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/v3/percent.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/v3/range.upb.h",
        "src/core/ext/upb-gen/envoy/type/v3/range.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/v3/range.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/v3/ratelimit_strategy.upb.h",
        "src/core/ext/upb-gen/envoy/type/v3/ratelimit_strategy.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/v3/ratelimit_strategy.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/v3/ratelimit_unit.upb.h",
        "src/core/ext/upb-gen/envoy/type/v3/ratelimit_unit.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/v3/ratelimit_unit.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/v3/semantic_version.upb.h",
        "src/core/ext/upb-gen/envoy/type/v3/semantic_version.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/v3/semantic_version.upb_minitable.h",
        "src/core/ext/upb-gen/envoy/type/v3/token_bucket.upb.h",
        "src/core/ext/upb-gen/envoy/type/v3/token_bucket.upb_minitable.c",
        "src/core/ext/upb-gen/envoy/type/v3/token_bucket.upb_minitable.h",
        "src/core/ext/upb-gen/google/api/annotations.upb.h",
        "src/core/ext/upb-gen/google/api/annotations.upb_minitable.c",
        "src/core/ext/upb-gen/google/api/annotations.upb_minitable.h",
        "src/core/ext/upb-gen/google/api/expr/v1alpha1/checked.upb.h",
        "src/core/ext/upb-gen/google/api/expr/v1alpha1/checked.upb_minitable.c",
        "src/core/ext/upb-gen/google/api/expr/v1alpha1/checked.upb_minitable.h",
        "src/core/ext/upb-gen/google/api/expr/v1alpha1/syntax.upb.h",
        "src/core/ext/upb-gen/google/api/expr/v1alpha1/syntax.upb_minitable.c",
        "src/core/ext/upb-gen/google/api/expr/v1alpha1/syntax.upb_minitable.h",
        "src/core/ext/upb-gen/google/api/http.upb.h",
        "src/core/ext/upb-gen/google/api/http.upb_minitable.c",
        "src/core/ext/upb-gen/google/api/http.upb_minitable.h",
        "src/core/ext/upb-gen/google/api/httpbody.upb.h",
        "src/core/ext/upb-gen/google/api/httpbody.upb_minitable.c",
        "src/core/ext/upb-gen/google/api/httpbody.upb_minitable.h",
        "src/core/ext/upb-gen/google/protobuf/any.upb.h",
        "src/core/ext/upb-gen/google/protobuf/any.upb_minitable.c",
        "src/core/ext/upb-gen/google/protobuf/any.upb_minitable.h",
        "src/core/ext/upb-gen/google/protobuf/descriptor.upb.h",
        "src/core/ext/upb-gen/google/protobuf/descriptor.upb_minitable.c",
        "src/core/ext/upb-gen/google/protobuf/descriptor.upb_minitable.h",
        "src/core/ext/upb-gen/google/protobuf/duration.upb.h",
        "src/core/ext/upb-gen/google/protobuf/duration.upb_minitable.c",
        "src/core/ext/upb-gen/google/protobuf/duration.upb_minitable.h",
        "src/core/ext/upb-gen/google/protobuf/empty.upb.h",
        "src/core/ext/upb-gen/google/protobuf/empty.upb_minitable.c",
        "src/core/ext/upb-gen/google/protobuf/empty.upb_minitable.h",
        "src/core/ext/upb-gen/google/protobuf/struct.upb.h",
        "src/core/ext/upb-gen/google/protobuf/struct.upb_minitable.c",
        "src/core/ext/upb-gen/google/protobuf/struct.upb_minitable.h",
        "src/core/ext/upb-gen/google/protobuf/timestamp.upb.h",
        "src/core/ext/upb-gen/google/protobuf/timestamp.upb_minitable.c",
        "src/core/ext/upb-gen/google/protobuf/timestamp.upb_minitable.h",
        "src/core/ext/upb-gen/google/protobuf/wrappers.upb.h",
        "src/core/ext/upb-gen/google/protobuf/wrappers.upb_minitable.c",
        "src/core/ext/upb-gen/google/protobuf/wrappers.upb_minitable.h",
        "src/core/ext/upb-gen/google/rpc/status.upb.h",
        "src/core/ext/upb-gen/google/rpc/status.upb_minitable.c",
        "src/core/ext/upb-gen/google/rpc/status.upb_minitable.h",
        "src/core/ext/upb-gen/opencensus/proto/trace/v1/trace_config.upb.h",
        "src/core/ext/upb-gen/opencensus/proto/trace/v1/trace_config.upb_minitable.c",
        "src/core/ext/upb-gen/opencensus/proto/trace/v1/trace_config.upb_minitable.h",
        "src/core/ext/upb-gen/src/proto/grpc/gcp/altscontext.upb.h",
        "src/core/ext/upb-gen/src/proto/grpc/gcp/altscontext.upb_minitable.c",
        "src/core/ext/upb-gen/src/proto/grpc/gcp/altscontext.upb_minitable.h",
        "src/core/ext/upb-gen/src/proto/grpc/gcp/handshaker.upb.h",
        "src/core/ext/upb-gen/src/proto/grpc/gcp/handshaker.upb_minitable.c",
        "src/core/ext/upb-gen/src/proto/grpc/gcp/handshaker.upb_minitable.h",
        "src/core/ext/upb-gen/src/proto/grpc/gcp/transport_security_common.upb.h",
        "src/core/ext/upb-gen/src/proto/grpc/gcp/transport_security_common.upb_minitable.c",
        "src/core/ext/upb-gen/src/proto/grpc/gcp/transport_security_common.upb_minitable.h",
        "src/core/ext/upb-gen/src/proto/grpc/health/v1/health.upb.h",
        "src/core/ext/upb-gen/src/proto/grpc/health/v1/health.upb_minitable.c",
        "src/core/ext/upb-gen/src/proto/grpc/health/v1/health.upb_minitable.h",
        "src/core/ext/upb-gen/src/proto/grpc/lb/v1/load_balancer.upb.h",
        "src/core/ext/upb-gen/src/proto/grpc/lb/v1/load_balancer.upb_minitable.c",
        "src/core/ext/upb-gen/src/proto/grpc/lb/v1/load_balancer.upb_minitable.h",
        "src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls.upb.h",
        "src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls.upb_minitable.c",
        "src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls.upb_minitable.h",
        "src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls_config.upb.h",
        "src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls_config.upb_minitable.c",
        "src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls_config.upb_minitable.h",
        "src/core/ext/upb-gen/udpa/annotations/migrate.upb.h",
        "src/core/ext/upb-gen/udpa/annotations/migrate.upb_minitable.c",
        "src/core/ext/upb-gen/udpa/annotations/migrate.upb_minitable.h",
        "src/core/ext/upb-gen/udpa/annotations/security.upb.h",
        "src/core/ext/upb-gen/udpa/annotations/security.upb_minitable.c",
        "src/core/ext/upb-gen/udpa/annotations/security.upb_minitable.h",
        "src/core/ext/upb-gen/udpa/annotations/sensitive.upb.h",
        "src/core/ext/upb-gen/udpa/annotations/sensitive.upb_minitable.c",
        "src/core/ext/upb-gen/udpa/annotations/sensitive.upb_minitable.h",
        "src/core/ext/upb-gen/udpa/annotations/status.upb.h",
        "src/core/ext/upb-gen/udpa/annotations/status.upb_minitable.c",
        "src/core/ext/upb-gen/udpa/annotations/status.upb_minitable.h",
        "src/core/ext/upb-gen/udpa/annotations/versioning.upb.h",
        "src/core/ext/upb-gen/udpa/annotations/versioning.upb_minitable.c",
        "src/core/ext/upb-gen/udpa/annotations/versioning.upb_minitable.h",
        "src/core/ext/upb-gen/validate/validate.upb.h",
        "src/core/ext/upb-gen/validate/validate.upb_minitable.c",
        "src/core/ext/upb-gen/validate/validate.upb_minitable.h",
        "src/core/ext/upb-gen/xds/annotations/v3/migrate.upb.h",
        "src/core/ext/upb-gen/xds/annotations/v3/migrate.upb_minitable.c",
        "src/core/ext/upb-gen/xds/annotations/v3/migrate.upb_minitable.h",
        "src/core/ext/upb-gen/xds/annotations/v3/security.upb.h",
        "src/core/ext/upb-gen/xds/annotations/v3/security.upb_minitable.c",
        "src/core/ext/upb-gen/xds/annotations/v3/security.upb_minitable.h",
        "src/core/ext/upb-gen/xds/annotations/v3/sensitive.upb.h",
        "src/core/ext/upb-gen/xds/annotations/v3/sensitive.upb_minitable.c",
        "src/core/ext/upb-gen/xds/annotations/v3/sensitive.upb_minitable.h",
        "src/core/ext/upb-gen/xds/annotations/v3/status.upb.h",
        "src/core/ext/upb-gen/xds/annotations/v3/status.upb_minitable.c",
        "src/core/ext/upb-gen/xds/annotations/v3/status.upb_minitable.h",
        "src/core/ext/upb-gen/xds/annotations/v3/versioning.upb.h",
        "src/core/ext/upb-gen/xds/annotations/v3/versioning.upb_minitable.c",
        "src/core/ext/upb-gen/xds/annotations/v3/versioning.upb_minitable.h",
        "src/core/ext/upb-gen/xds/core/v3/authority.upb.h",
        "src/core/ext/upb-gen/xds/core/v3/authority.upb_minitable.c",
        "src/core/ext/upb-gen/xds/core/v3/authority.upb_minitable.h",
        "src/core/ext/upb-gen/xds/core/v3/cidr.upb.h",
        "src/core/ext/upb-gen/xds/core/v3/cidr.upb_minitable.c",
        "src/core/ext/upb-gen/xds/core/v3/cidr.upb_minitable.h",
        "src/core/ext/upb-gen/xds/core/v3/collection_entry.upb.h",
        "src/core/ext/upb-gen/xds/core/v3/collection_entry.upb_minitable.c",
        "src/core/ext/upb-gen/xds/core/v3/collection_entry.upb_minitable.h",
        "src/core/ext/upb-gen/xds/core/v3/context_params.upb.h",
        "src/core/ext/upb-gen/xds/core/v3/context_params.upb_minitable.c",
        "src/core/ext/upb-gen/xds/core/v3/context_params.upb_minitable.h",
        "src/core/ext/upb-gen/xds/core/v3/extension.upb.h",
        "src/core/ext/upb-gen/xds/core/v3/extension.upb_minitable.c",
        "src/core/ext/upb-gen/xds/core/v3/extension.upb_minitable.h",
        "src/core/ext/upb-gen/xds/core/v3/resource.upb.h",
        "src/core/ext/upb-gen/xds/core/v3/resource.upb_minitable.c",
        "src/core/ext/upb-gen/xds/core/v3/resource.upb_minitable.h",
        "src/core/ext/upb-gen/xds/core/v3/resource_locator.upb.h",
        "src/core/ext/upb-gen/xds/core/v3/resource_locator.upb_minitable.c",
        "src/core/ext/upb-gen/xds/core/v3/resource_locator.upb_minitable.h",
        "src/core/ext/upb-gen/xds/core/v3/resource_name.upb.h",
        "src/core/ext/upb-gen/xds/core/v3/resource_name.upb_minitable.c",
        "src/core/ext/upb-gen/xds/core/v3/resource_name.upb_minitable.h",
        "src/core/ext/upb-gen/xds/data/orca/v3/orca_load_report.upb.h",
        "src/core/ext/upb-gen/xds/data/orca/v3/orca_load_report.upb_minitable.c",
        "src/core/ext/upb-gen/xds/data/orca/v3/orca_load_report.upb_minitable.h",
        "src/core/ext/upb-gen/xds/service/orca/v3/orca.upb.h",
        "src/core/ext/upb-gen/xds/service/orca/v3/orca.upb_minitable.c",
        "src/core/ext/upb-gen/xds/service/orca/v3/orca.upb_minitable.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/cel.upb.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/cel.upb_minitable.c",
        "src/core/ext/upb-gen/xds/type/matcher/v3/cel.upb_minitable.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/domain.upb.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/domain.upb_minitable.c",
        "src/core/ext/upb-gen/xds/type/matcher/v3/domain.upb_minitable.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/http_inputs.upb.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/http_inputs.upb_minitable.c",
        "src/core/ext/upb-gen/xds/type/matcher/v3/http_inputs.upb_minitable.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/ip.upb.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/ip.upb_minitable.c",
        "src/core/ext/upb-gen/xds/type/matcher/v3/ip.upb_minitable.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/matcher.upb.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/matcher.upb_minitable.c",
        "src/core/ext/upb-gen/xds/type/matcher/v3/matcher.upb_minitable.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/range.upb.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/range.upb_minitable.c",
        "src/core/ext/upb-gen/xds/type/matcher/v3/range.upb_minitable.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/regex.upb.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/regex.upb_minitable.c",
        "src/core/ext/upb-gen/xds/type/matcher/v3/regex.upb_minitable.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/string.upb.h",
        "src/core/ext/upb-gen/xds/type/matcher/v3/string.upb_minitable.c",
        "src/core/ext/upb-gen/xds/type/matcher/v3/string.upb_minitable.h",
        "src/core/ext/upb-gen/xds/type/v3/cel.upb.h",
        "src/core/ext/upb-gen/xds/type/v3/cel.upb_minitable.c",
        "src/core/ext/upb-gen/xds/type/v3/cel.upb_minitable.h",
        "src/core/ext/upb-gen/xds/type/v3/range.upb.h",
        "src/core/ext/upb-gen/xds/type/v3/range.upb_minitable.c",
        "src/core/ext/upb-gen/xds/type/v3/range.upb_minitable.h",
        "src/core/ext/upb-gen/xds/type/v3/typed_struct.upb.h",
        "src/core/ext/upb-gen/xds/type/v3/typed_struct.upb_minitable.c",
        "src/core/ext/upb-gen/xds/type/v3/typed_struct.upb_minitable.h",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/certs.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/certs.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/clusters.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/clusters.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/config_dump.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/config_dump.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/config_dump_shared.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/config_dump_shared.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/init_dump.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/init_dump.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/listeners.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/listeners.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/memory.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/memory.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/metrics.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/metrics.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/mutex_stats.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/mutex_stats.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/server_info.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/server_info.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/tap.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/admin/v3/tap.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/annotations/deprecation.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/annotations/deprecation.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/annotations/resource.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/annotations/resource.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/accesslog/v3/accesslog.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/accesslog/v3/accesslog.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/bootstrap/v3/bootstrap.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/bootstrap/v3/bootstrap.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/cluster/v3/circuit_breaker.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/cluster/v3/circuit_breaker.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/cluster/v3/cluster.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/cluster/v3/cluster.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/cluster/v3/filter.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/cluster/v3/filter.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/cluster/v3/outlier_detection.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/cluster/v3/outlier_detection.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/common/matcher/v3/matcher.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/common/matcher/v3/matcher.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/address.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/address.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/backoff.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/backoff.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/base.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/base.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/config_source.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/config_source.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/event_service_config.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/event_service_config.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/extension.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/extension.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/grpc_method_list.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/grpc_method_list.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/grpc_service.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/grpc_service.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/health_check.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/health_check.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/http_service.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/http_service.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/http_uri.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/http_uri.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/protocol.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/protocol.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/proxy_protocol.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/proxy_protocol.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/resolver.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/resolver.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/socket_option.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/socket_option.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/substitution_format_string.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/substitution_format_string.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/udp_socket_config.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/core/v3/udp_socket_config.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/endpoint.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/endpoint.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/endpoint_components.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/endpoint_components.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/load_report.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/load_report.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/listener/v3/api_listener.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/listener/v3/api_listener.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/listener/v3/listener.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/listener/v3/listener.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/listener/v3/listener_components.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/listener/v3/listener_components.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/listener/v3/quic_config.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/listener/v3/quic_config.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/listener/v3/udp_listener_config.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/listener/v3/udp_listener_config.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/metrics/v3/metrics_service.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/metrics/v3/metrics_service.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/metrics/v3/stats.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/metrics/v3/stats.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/overload/v3/overload.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/overload/v3/overload.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/rbac/v3/rbac.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/rbac/v3/rbac.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/route/v3/route.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/route/v3/route.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/route/v3/route_components.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/route/v3/route_components.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/route/v3/scoped_route.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/route/v3/scoped_route.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/tap/v3/common.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/tap/v3/common.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/datadog.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/datadog.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/dynamic_ot.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/dynamic_ot.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/http_tracer.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/http_tracer.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/lightstep.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/lightstep.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/opencensus.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/opencensus.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/opentelemetry.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/opentelemetry.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/service.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/service.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/skywalking.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/skywalking.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/trace.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/trace.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/xray.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/xray.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/zipkin.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/config/trace/v3/zipkin.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/data/accesslog/v3/accesslog.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/data/accesslog/v3/accesslog.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/clusters/aggregate/v3/cluster.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/clusters/aggregate/v3/cluster.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/filters/common/fault/v3/fault.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/filters/common/fault/v3/fault.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/filters/http/fault/v3/fault.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/filters/http/fault/v3/fault.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/filters/http/rbac/v3/rbac.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/filters/http/rbac/v3/rbac.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/filters/http/router/v3/router.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/filters/http/router/v3/router.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/cert.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/cert.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/common.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/common.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/secret.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/secret.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/tls.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/tls.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/service/discovery/v3/ads.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/service/discovery/v3/ads.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/service/discovery/v3/discovery.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/service/discovery/v3/discovery.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/service/load_stats/v3/lrs.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/service/load_stats/v3/lrs.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/service/status/v3/csds.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/service/status/v3/csds.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/http/v3/cookie.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/http/v3/cookie.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/http/v3/path_transformation.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/http/v3/path_transformation.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/filter_state.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/filter_state.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/http_inputs.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/http_inputs.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/metadata.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/metadata.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/node.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/node.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/number.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/number.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/path.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/path.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/regex.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/regex.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/status_code_input.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/status_code_input.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/string.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/string.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/struct.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/struct.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/value.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/matcher/v3/value.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/metadata/v3/metadata.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/metadata/v3/metadata.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/tracing/v3/custom_tag.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/tracing/v3/custom_tag.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/v3/hash_policy.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/v3/hash_policy.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/v3/http.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/v3/http.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/v3/http_status.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/v3/http_status.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/v3/percent.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/v3/percent.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/v3/range.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/v3/range.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/v3/ratelimit_strategy.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/v3/ratelimit_strategy.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/v3/ratelimit_unit.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/v3/ratelimit_unit.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/v3/semantic_version.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/v3/semantic_version.upbdefs.h",
        "src/core/ext/upbdefs-gen/envoy/type/v3/token_bucket.upbdefs.c",
        "src/core/ext/upbdefs-gen/envoy/type/v3/token_bucket.upbdefs.h",
        "src/core/ext/upbdefs-gen/google/api/annotations.upbdefs.c",
        "src/core/ext/upbdefs-gen/google/api/annotations.upbdefs.h",
        "src/core/ext/upbdefs-gen/google/api/expr/v1alpha1/checked.upbdefs.c",
        "src/core/ext/upbdefs-gen/google/api/expr/v1alpha1/checked.upbdefs.h",
        "src/core/ext/upbdefs-gen/google/api/expr/v1alpha1/syntax.upbdefs.c",
        "src/core/ext/upbdefs-gen/google/api/expr/v1alpha1/syntax.upbdefs.h",
        "src/core/ext/upbdefs-gen/google/api/http.upbdefs.c",
        "src/core/ext/upbdefs-gen/google/api/http.upbdefs.h",
        "src/core/ext/upbdefs-gen/google/api/httpbody.upbdefs.c",
        "src/core/ext/upbdefs-gen/google/api/httpbody.upbdefs.h",
        "src/core/ext/upbdefs-gen/google/protobuf/any.upbdefs.c",
        "src/core/ext/upbdefs-gen/google/protobuf/any.upbdefs.h",
        "src/core/ext/upbdefs-gen/google/protobuf/descriptor.upbdefs.c",
        "src/core/ext/upbdefs-gen/google/protobuf/descriptor.upbdefs.h",
        "src/core/ext/upbdefs-gen/google/protobuf/duration.upbdefs.c",
        "src/core/ext/upbdefs-gen/google/protobuf/duration.upbdefs.h",
        "src/core/ext/upbdefs-gen/google/protobuf/empty.upbdefs.c",
        "src/core/ext/upbdefs-gen/google/protobuf/empty.upbdefs.h",
        "src/core/ext/upbdefs-gen/google/protobuf/struct.upbdefs.c",
        "src/core/ext/upbdefs-gen/google/protobuf/struct.upbdefs.h",
        "src/core/ext/upbdefs-gen/google/protobuf/timestamp.upbdefs.c",
        "src/core/ext/upbdefs-gen/google/protobuf/timestamp.upbdefs.h",
        "src/core/ext/upbdefs-gen/google/protobuf/wrappers.upbdefs.c",
        "src/core/ext/upbdefs-gen/google/protobuf/wrappers.upbdefs.h",
        "src/core/ext/upbdefs-gen/google/rpc/status.upbdefs.c",
        "src/core/ext/upbdefs-gen/google/rpc/status.upbdefs.h",
        "src/core/ext/upbdefs-gen/opencensus/proto/trace/v1/trace_config.upbdefs.c",
        "src/core/ext/upbdefs-gen/opencensus/proto/trace/v1/trace_config.upbdefs.h",
        "src/core/ext/upbdefs-gen/src/proto/grpc/lookup/v1/rls_config.upbdefs.c",
        "src/core/ext/upbdefs-gen/src/proto/grpc/lookup/v1/rls_config.upbdefs.h",
        "src/core/ext/upbdefs-gen/udpa/annotations/migrate.upbdefs.c",
        "src/core/ext/upbdefs-gen/udpa/annotations/migrate.upbdefs.h",
        "src/core/ext/upbdefs-gen/udpa/annotations/security.upbdefs.c",
        "src/core/ext/upbdefs-gen/udpa/annotations/security.upbdefs.h",
        "src/core/ext/upbdefs-gen/udpa/annotations/sensitive.upbdefs.c",
        "src/core/ext/upbdefs-gen/udpa/annotations/sensitive.upbdefs.h",
        "src/core/ext/upbdefs-gen/udpa/annotations/status.upbdefs.c",
        "src/core/ext/upbdefs-gen/udpa/annotations/status.upbdefs.h",
        "src/core/ext/upbdefs-gen/udpa/annotations/versioning.upbdefs.c",
        "src/core/ext/upbdefs-gen/udpa/annotations/versioning.upbdefs.h",
        "src/core/ext/upbdefs-gen/validate/validate.upbdefs.c",
        "src/core/ext/upbdefs-gen/validate/validate.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/annotations/v3/migrate.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/annotations/v3/migrate.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/annotations/v3/security.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/annotations/v3/security.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/annotations/v3/sensitive.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/annotations/v3/sensitive.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/annotations/v3/status.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/annotations/v3/status.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/annotations/v3/versioning.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/annotations/v3/versioning.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/core/v3/authority.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/core/v3/authority.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/core/v3/cidr.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/core/v3/cidr.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/core/v3/collection_entry.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/core/v3/collection_entry.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/core/v3/context_params.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/core/v3/context_params.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/core/v3/extension.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/core/v3/extension.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/core/v3/resource.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/core/v3/resource.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/core/v3/resource_locator.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/core/v3/resource_locator.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/core/v3/resource_name.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/core/v3/resource_name.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/cel.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/cel.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/domain.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/domain.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/http_inputs.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/http_inputs.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/ip.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/ip.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/matcher.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/matcher.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/range.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/range.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/regex.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/regex.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/string.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/type/matcher/v3/string.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/type/v3/cel.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/type/v3/cel.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/type/v3/range.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/type/v3/range.upbdefs.h",
        "src/core/ext/upbdefs-gen/xds/type/v3/typed_struct.upbdefs.c",
        "src/core/ext/upbdefs-gen/xds/type/v3/typed_struct.upbdefs.h",
        "src/core/filter/blackboard.cc",
        "src/core/filter/blackboard.h",
        "src/core/handshaker/endpoint_info/endpoint_info_handshaker.cc",
        "src/core/handshaker/endpoint_info/endpoint_info_handshaker.h",
        "src/core/handshaker/handshaker.cc",
        "src/core/handshaker/handshaker.h",
        "src/core/handshaker/handshaker_factory.h",
        "src/core/handshaker/handshaker_registry.cc",
        "src/core/handshaker/handshaker_registry.h",
        "src/core/handshaker/http_connect/http_connect_handshaker.cc",
        "src/core/handshaker/http_connect/http_connect_handshaker.h",
        "src/core/handshaker/http_connect/http_proxy_mapper.cc",
        "src/core/handshaker/http_connect/http_proxy_mapper.h",
        "src/core/handshaker/http_connect/xds_http_proxy_mapper.cc",
        "src/core/handshaker/http_connect/xds_http_proxy_mapper.h",
        "src/core/handshaker/proxy_mapper.h",
        "src/core/handshaker/proxy_mapper_registry.cc",
        "src/core/handshaker/proxy_mapper_registry.h",
        "src/core/handshaker/security/secure_endpoint.cc",
        "src/core/handshaker/security/secure_endpoint.h",
        "src/core/handshaker/security/security_handshaker.cc",
        "src/core/handshaker/security/security_handshaker.h",
        "src/core/handshaker/tcp_connect/tcp_connect_handshaker.cc",
        "src/core/handshaker/tcp_connect/tcp_connect_handshaker.h",
        "src/core/lib/address_utils/parse_address.cc",
        "src/core/lib/address_utils/parse_address.h",
        "src/core/lib/address_utils/sockaddr_utils.cc",
        "src/core/lib/address_utils/sockaddr_utils.h",
        "src/core/lib/channel/call_finalization.h",
        "src/core/lib/channel/channel_args.cc",
        "src/core/lib/channel/channel_args.h",
        "src/core/lib/channel/channel_args_preconditioning.cc",
        "src/core/lib/channel/channel_args_preconditioning.h",
        "src/core/lib/channel/channel_fwd.h",
        "src/core/lib/channel/channel_stack.cc",
        "src/core/lib/channel/channel_stack.h",
        "src/core/lib/channel/channel_stack_builder.cc",
        "src/core/lib/channel/channel_stack_builder.h",
        "src/core/lib/channel/channel_stack_builder_impl.cc",
        "src/core/lib/channel/channel_stack_builder_impl.h",
        "src/core/lib/channel/connected_channel.cc",
        "src/core/lib/channel/connected_channel.h",
        "src/core/lib/channel/promise_based_filter.cc",
        "src/core/lib/channel/promise_based_filter.h",
        "src/core/lib/channel/status_util.cc",
        "src/core/lib/channel/status_util.h",
        "src/core/lib/compression/compression.cc",
        "src/core/lib/compression/compression_internal.cc",
        "src/core/lib/compression/compression_internal.h",
        "src/core/lib/compression/message_compress.cc",
        "src/core/lib/compression/message_compress.h",
        "src/core/lib/debug/trace.cc",
        "src/core/lib/debug/trace.h",
        "src/core/lib/debug/trace_flags.cc",
        "src/core/lib/debug/trace_flags.h",
        "src/core/lib/debug/trace_impl.h",
        "src/core/lib/event_engine/ares_resolver.cc",
        "src/core/lib/event_engine/ares_resolver.h",
        "src/core/lib/event_engine/cf_engine/cf_engine.cc",
        "src/core/lib/event_engine/cf_engine/cf_engine.h",
        "src/core/lib/event_engine/cf_engine/cfstream_endpoint.cc",
        "src/core/lib/event_engine/cf_engine/cfstream_endpoint.h",
        "src/core/lib/event_engine/cf_engine/cftype_unique_ref.h",
        "src/core/lib/event_engine/cf_engine/dns_service_resolver.cc",
        "src/core/lib/event_engine/cf_engine/dns_service_resolver.h",
        "src/core/lib/event_engine/channel_args_endpoint_config.cc",
        "src/core/lib/event_engine/channel_args_endpoint_config.h",
        "src/core/lib/event_engine/common_closures.h",
        "src/core/lib/event_engine/default_event_engine.cc",
        "src/core/lib/event_engine/default_event_engine.h",
        "src/core/lib/event_engine/default_event_engine_factory.cc",
        "src/core/lib/event_engine/default_event_engine_factory.h",
        "src/core/lib/event_engine/event_engine.cc",
        "src/core/lib/event_engine/event_engine_context.h",
        "src/core/lib/event_engine/extensions/can_track_errors.h",
        "src/core/lib/event_engine/extensions/chaotic_good_extension.h",
        "src/core/lib/event_engine/extensions/supports_fd.h",
        "src/core/lib/event_engine/extensions/tcp_trace.h",
        "src/core/lib/event_engine/forkable.cc",
        "src/core/lib/event_engine/forkable.h",
        "src/core/lib/event_engine/grpc_polled_fd.h",
        "src/core/lib/event_engine/handle_containers.h",
        "src/core/lib/event_engine/memory_allocator_factory.h",
        "src/core/lib/event_engine/nameser.h",
        "src/core/lib/event_engine/poller.h",
        "src/core/lib/event_engine/posix.h",
        "src/core/lib/event_engine/posix_engine/ev_epoll1_linux.cc",
        "src/core/lib/event_engine/posix_engine/ev_epoll1_linux.h",
        "src/core/lib/event_engine/posix_engine/ev_poll_posix.cc",
        "src/core/lib/event_engine/posix_engine/ev_poll_posix.h",
        "src/core/lib/event_engine/posix_engine/event_poller.h",
        "src/core/lib/event_engine/posix_engine/event_poller_posix_default.cc",
        "src/core/lib/event_engine/posix_engine/event_poller_posix_default.h",
        "src/core/lib/event_engine/posix_engine/grpc_polled_fd_posix.h",
        "src/core/lib/event_engine/posix_engine/internal_errqueue.cc",
        "src/core/lib/event_engine/posix_engine/internal_errqueue.h",
        "src/core/lib/event_engine/posix_engine/lockfree_event.cc",
        "src/core/lib/event_engine/posix_engine/lockfree_event.h",
        "src/core/lib/event_engine/posix_engine/native_posix_dns_resolver.cc",
        "src/core/lib/event_engine/posix_engine/native_posix_dns_resolver.h",
        "src/core/lib/event_engine/posix_engine/posix_endpoint.cc",
        "src/core/lib/event_engine/posix_engine/posix_endpoint.h",
        "src/core/lib/event_engine/posix_engine/posix_engine.cc",
        "src/core/lib/event_engine/posix_engine/posix_engine.h",
        "src/core/lib/event_engine/posix_engine/posix_engine_closure.h",
        "src/core/lib/event_engine/posix_engine/posix_engine_listener.cc",
        "src/core/lib/event_engine/posix_engine/posix_engine_listener.h",
        "src/core/lib/event_engine/posix_engine/posix_engine_listener_utils.cc",
        "src/core/lib/event_engine/posix_engine/posix_engine_listener_utils.h",
        "src/core/lib/event_engine/posix_engine/tcp_socket_utils.cc",
        "src/core/lib/event_engine/posix_engine/tcp_socket_utils.h",
        "src/core/lib/event_engine/posix_engine/timer.cc",
        "src/core/lib/event_engine/posix_engine/timer.h",
        "src/core/lib/event_engine/posix_engine/timer_heap.cc",
        "src/core/lib/event_engine/posix_engine/timer_heap.h",
        "src/core/lib/event_engine/posix_engine/timer_manager.cc",
        "src/core/lib/event_engine/posix_engine/timer_manager.h",
        "src/core/lib/event_engine/posix_engine/traced_buffer_list.cc",
        "src/core/lib/event_engine/posix_engine/traced_buffer_list.h",
        "src/core/lib/event_engine/posix_engine/wakeup_fd_eventfd.cc",
        "src/core/lib/event_engine/posix_engine/wakeup_fd_eventfd.h",
        "src/core/lib/event_engine/posix_engine/wakeup_fd_pipe.cc",
        "src/core/lib/event_engine/posix_engine/wakeup_fd_pipe.h",
        "src/core/lib/event_engine/posix_engine/wakeup_fd_posix.h",
        "src/core/lib/event_engine/posix_engine/wakeup_fd_posix_default.cc",
        "src/core/lib/event_engine/posix_engine/wakeup_fd_posix_default.h",
        "src/core/lib/event_engine/query_extensions.h",
        "src/core/lib/event_engine/ref_counted_dns_resolver_interface.h",
        "src/core/lib/event_engine/resolved_address.cc",
        "src/core/lib/event_engine/resolved_address_internal.h",
        "src/core/lib/event_engine/shim.cc",
        "src/core/lib/event_engine/shim.h",
        "src/core/lib/event_engine/slice.cc",
        "src/core/lib/event_engine/slice_buffer.cc",
        "src/core/lib/event_engine/tcp_socket_utils.cc",
        "src/core/lib/event_engine/tcp_socket_utils.h",
        "src/core/lib/event_engine/thread_local.cc",
        "src/core/lib/event_engine/thread_local.h",
        "src/core/lib/event_engine/thread_pool/thread_count.cc",
        "src/core/lib/event_engine/thread_pool/thread_count.h",
        "src/core/lib/event_engine/thread_pool/thread_pool.h",
        "src/core/lib/event_engine/thread_pool/thread_pool_factory.cc",
        "src/core/lib/event_engine/thread_pool/work_stealing_thread_pool.cc",
        "src/core/lib/event_engine/thread_pool/work_stealing_thread_pool.h",
        "src/core/lib/event_engine/thready_event_engine/thready_event_engine.cc",
        "src/core/lib/event_engine/thready_event_engine/thready_event_engine.h",
        "src/core/lib/event_engine/time_util.cc",
        "src/core/lib/event_engine/time_util.h",
        "src/core/lib/event_engine/utils.cc",
        "src/core/lib/event_engine/utils.h",
        "src/core/lib/event_engine/windows/grpc_polled_fd_windows.cc",
        "src/core/lib/event_engine/windows/grpc_polled_fd_windows.h",
        "src/core/lib/event_engine/windows/iocp.cc",
        "src/core/lib/event_engine/windows/iocp.h",
        "src/core/lib/event_engine/windows/native_windows_dns_resolver.cc",
        "src/core/lib/event_engine/windows/native_windows_dns_resolver.h",
        "src/core/lib/event_engine/windows/win_socket.cc",
        "src/core/lib/event_engine/windows/win_socket.h",
        "src/core/lib/event_engine/windows/windows_endpoint.cc",
        "src/core/lib/event_engine/windows/windows_endpoint.h",
        "src/core/lib/event_engine/windows/windows_engine.cc",
        "src/core/lib/event_engine/windows/windows_engine.h",
        "src/core/lib/event_engine/windows/windows_listener.cc",
        "src/core/lib/event_engine/windows/windows_listener.h",
        "src/core/lib/event_engine/work_queue/basic_work_queue.cc",
        "src/core/lib/event_engine/work_queue/basic_work_queue.h",
        "src/core/lib/event_engine/work_queue/work_queue.h",
        "src/core/lib/experiments/config.cc",
        "src/core/lib/experiments/config.h",
        "src/core/lib/experiments/experiments.cc",
        "src/core/lib/experiments/experiments.h",
        "src/core/lib/iomgr/block_annotate.h",
        "src/core/lib/iomgr/buffer_list.cc",
        "src/core/lib/iomgr/buffer_list.h",
        "src/core/lib/iomgr/call_combiner.cc",
        "src/core/lib/iomgr/call_combiner.h",
        "src/core/lib/iomgr/cfstream_handle.cc",
        "src/core/lib/iomgr/cfstream_handle.h",
        "src/core/lib/iomgr/closure.cc",
        "src/core/lib/iomgr/closure.h",
        "src/core/lib/iomgr/combiner.cc",
        "src/core/lib/iomgr/combiner.h",
        "src/core/lib/iomgr/dualstack_socket_posix.cc",
        "src/core/lib/iomgr/dynamic_annotations.h",
        "src/core/lib/iomgr/endpoint.cc",
        "src/core/lib/iomgr/endpoint.h",
        "src/core/lib/iomgr/endpoint_cfstream.cc",
        "src/core/lib/iomgr/endpoint_cfstream.h",
        "src/core/lib/iomgr/endpoint_pair.h",
        "src/core/lib/iomgr/endpoint_pair_posix.cc",
        "src/core/lib/iomgr/endpoint_pair_windows.cc",
        "src/core/lib/iomgr/error.cc",
        "src/core/lib/iomgr/error.h",
        "src/core/lib/iomgr/error_cfstream.cc",
        "src/core/lib/iomgr/error_cfstream.h",
        "src/core/lib/iomgr/ev_apple.cc",
        "src/core/lib/iomgr/ev_apple.h",
        "src/core/lib/iomgr/ev_epoll1_linux.cc",
        "src/core/lib/iomgr/ev_epoll1_linux.h",
        "src/core/lib/iomgr/ev_poll_posix.cc",
        "src/core/lib/iomgr/ev_poll_posix.h",
        "src/core/lib/iomgr/ev_posix.cc",
        "src/core/lib/iomgr/ev_posix.h",
        "src/core/lib/iomgr/event_engine_shims/closure.cc",
        "src/core/lib/iomgr/event_engine_shims/closure.h",
        "src/core/lib/iomgr/event_engine_shims/endpoint.cc",
        "src/core/lib/iomgr/event_engine_shims/endpoint.h",
        "src/core/lib/iomgr/event_engine_shims/tcp_client.cc",
        "src/core/lib/iomgr/event_engine_shims/tcp_client.h",
        "src/core/lib/iomgr/exec_ctx.cc",
        "src/core/lib/iomgr/exec_ctx.h",
        "src/core/lib/iomgr/executor.cc",
        "src/core/lib/iomgr/executor.h",
        "src/core/lib/iomgr/fork_posix.cc",
        "src/core/lib/iomgr/fork_windows.cc",
        "src/core/lib/iomgr/internal_errqueue.cc",
        "src/core/lib/iomgr/internal_errqueue.h",
        "src/core/lib/iomgr/iocp_windows.cc",
        "src/core/lib/iomgr/iocp_windows.h",
        "src/core/lib/iomgr/iomgr.cc",
        "src/core/lib/iomgr/iomgr.h",
        "src/core/lib/iomgr/iomgr_fwd.h",
        "src/core/lib/iomgr/iomgr_internal.cc",
        "src/core/lib/iomgr/iomgr_internal.h",
        "src/core/lib/iomgr/iomgr_posix.cc",
        "src/core/lib/iomgr/iomgr_posix_cfstream.cc",
        "src/core/lib/iomgr/iomgr_windows.cc",
        "src/core/lib/iomgr/lockfree_event.cc",
        "src/core/lib/iomgr/lockfree_event.h",
        "src/core/lib/iomgr/nameser.h",
        "src/core/lib/iomgr/polling_entity.cc",
        "src/core/lib/iomgr/polling_entity.h",
        "src/core/lib/iomgr/pollset.cc",
        "src/core/lib/iomgr/pollset.h",
        "src/core/lib/iomgr/pollset_set.cc",
        "src/core/lib/iomgr/pollset_set.h",
        "src/core/lib/iomgr/pollset_set_windows.cc",
        "src/core/lib/iomgr/pollset_set_windows.h",
        "src/core/lib/iomgr/pollset_windows.cc",
        "src/core/lib/iomgr/pollset_windows.h",
        "src/core/lib/iomgr/port.h",
        "src/core/lib/iomgr/python_util.h",
        "src/core/lib/iomgr/resolve_address.cc",
        "src/core/lib/iomgr/resolve_address.h",
        "src/core/lib/iomgr/resolve_address_impl.h",
        "src/core/lib/iomgr/resolve_address_posix.cc",
        "src/core/lib/iomgr/resolve_address_posix.h",
        "src/core/lib/iomgr/resolve_address_windows.cc",
        "src/core/lib/iomgr/resolve_address_windows.h",
        "src/core/lib/iomgr/resolved_address.h",
        "src/core/lib/iomgr/sockaddr.h",
        "src/core/lib/iomgr/sockaddr_posix.h",
        "src/core/lib/iomgr/sockaddr_utils_posix.cc",
        "src/core/lib/iomgr/sockaddr_windows.h",
        "src/core/lib/iomgr/socket_factory_posix.cc",
        "src/core/lib/iomgr/socket_factory_posix.h",
        "src/core/lib/iomgr/socket_mutator.cc",
        "src/core/lib/iomgr/socket_mutator.h",
        "src/core/lib/iomgr/socket_utils.h",
        "src/core/lib/iomgr/socket_utils_common_posix.cc",
        "src/core/lib/iomgr/socket_utils_linux.cc",
        "src/core/lib/iomgr/socket_utils_posix.cc",
        "src/core/lib/iomgr/socket_utils_posix.h",
        "src/core/lib/iomgr/socket_utils_windows.cc",
        "src/core/lib/iomgr/socket_windows.cc",
        "src/core/lib/iomgr/socket_windows.h",
        "src/core/lib/iomgr/systemd_utils.cc",
        "src/core/lib/iomgr/systemd_utils.h",
        "src/core/lib/iomgr/tcp_client.cc",
        "src/core/lib/iomgr/tcp_client.h",
        "src/core/lib/iomgr/tcp_client_cfstream.cc",
        "src/core/lib/iomgr/tcp_client_posix.cc",
        "src/core/lib/iomgr/tcp_client_posix.h",
        "src/core/lib/iomgr/tcp_client_windows.cc",
        "src/core/lib/iomgr/tcp_posix.cc",
        "src/core/lib/iomgr/tcp_posix.h",
        "src/core/lib/iomgr/tcp_server.cc",
        "src/core/lib/iomgr/tcp_server.h",
        "src/core/lib/iomgr/tcp_server_posix.cc",
        "src/core/lib/iomgr/tcp_server_utils_posix.h",
        "src/core/lib/iomgr/tcp_server_utils_posix_common.cc",
        "src/core/lib/iomgr/tcp_server_utils_posix_ifaddrs.cc",
        "src/core/lib/iomgr/tcp_server_utils_posix_noifaddrs.cc",
        "src/core/lib/iomgr/tcp_server_windows.cc",
        "src/core/lib/iomgr/tcp_windows.cc",
        "src/core/lib/iomgr/tcp_windows.h",
        "src/core/lib/iomgr/timer.cc",
        "src/core/lib/iomgr/timer.h",
        "src/core/lib/iomgr/timer_generic.cc",
        "src/core/lib/iomgr/timer_generic.h",
        "src/core/lib/iomgr/timer_heap.cc",
        "src/core/lib/iomgr/timer_heap.h",
        "src/core/lib/iomgr/timer_manager.cc",
        "src/core/lib/iomgr/timer_manager.h",
        "src/core/lib/iomgr/unix_sockets_posix.cc",
        "src/core/lib/iomgr/unix_sockets_posix.h",
        "src/core/lib/iomgr/unix_sockets_posix_noop.cc",
        "src/core/lib/iomgr/vsock.cc",
        "src/core/lib/iomgr/vsock.h",
        "src/core/lib/iomgr/wakeup_fd_eventfd.cc",
        "src/core/lib/iomgr/wakeup_fd_nospecial.cc",
        "src/core/lib/iomgr/wakeup_fd_pipe.cc",
        "src/core/lib/iomgr/wakeup_fd_pipe.h",
        "src/core/lib/iomgr/wakeup_fd_posix.cc",
        "src/core/lib/iomgr/wakeup_fd_posix.h",
        "src/core/lib/promise/activity.cc",
        "src/core/lib/promise/activity.h",
        "src/core/lib/promise/all_ok.h",
        "src/core/lib/promise/arena_promise.h",
        "src/core/lib/promise/cancel_callback.h",
        "src/core/lib/promise/context.h",
        "src/core/lib/promise/detail/basic_seq.h",
        "src/core/lib/promise/detail/join_state.h",
        "src/core/lib/promise/detail/promise_factory.h",
        "src/core/lib/promise/detail/promise_like.h",
        "src/core/lib/promise/detail/seq_state.h",
        "src/core/lib/promise/detail/status.h",
        "src/core/lib/promise/exec_ctx_wakeup_scheduler.h",
        "src/core/lib/promise/for_each.h",
        "src/core/lib/promise/if.h",
        "src/core/lib/promise/interceptor_list.h",
        "src/core/lib/promise/latch.h",
        "src/core/lib/promise/loop.h",
        "src/core/lib/promise/map.h",
        "src/core/lib/promise/observable.h",
        "src/core/lib/promise/party.cc",
        "src/core/lib/promise/party.h",
        "src/core/lib/promise/pipe.h",
        "src/core/lib/promise/poll.h",
        "src/core/lib/promise/prioritized_race.h",
        "src/core/lib/promise/promise.h",
        "src/core/lib/promise/race.h",
        "src/core/lib/promise/seq.h",
        "src/core/lib/promise/sleep.cc",
        "src/core/lib/promise/sleep.h",
        "src/core/lib/promise/status_flag.h",
        "src/core/lib/promise/try_join.h",
        "src/core/lib/promise/try_seq.h",
        "src/core/lib/resource_quota/api.cc",
        "src/core/lib/resource_quota/api.h",
        "src/core/lib/resource_quota/arena.cc",
        "src/core/lib/resource_quota/arena.h",
        "src/core/lib/resource_quota/connection_quota.cc",
        "src/core/lib/resource_quota/connection_quota.h",
        "src/core/lib/resource_quota/memory_quota.cc",
        "src/core/lib/resource_quota/memory_quota.h",
        "src/core/lib/resource_quota/periodic_update.cc",
        "src/core/lib/resource_quota/periodic_update.h",
        "src/core/lib/resource_quota/resource_quota.cc",
        "src/core/lib/resource_quota/resource_quota.h",
        "src/core/lib/resource_quota/thread_quota.cc",
        "src/core/lib/resource_quota/thread_quota.h",
        "src/core/lib/security/authorization/audit_logging.cc",
        "src/core/lib/security/authorization/audit_logging.h",
        "src/core/lib/security/authorization/authorization_engine.h",
        "src/core/lib/security/authorization/authorization_policy_provider.h",
        "src/core/lib/security/authorization/authorization_policy_provider_vtable.cc",
        "src/core/lib/security/authorization/evaluate_args.cc",
        "src/core/lib/security/authorization/evaluate_args.h",
        "src/core/lib/security/authorization/grpc_authorization_engine.cc",
        "src/core/lib/security/authorization/grpc_authorization_engine.h",
        "src/core/lib/security/authorization/grpc_authorization_policy_provider.cc",
        "src/core/lib/security/authorization/grpc_authorization_policy_provider.h",
        "src/core/lib/security/authorization/grpc_server_authz_filter.cc",
        "src/core/lib/security/authorization/grpc_server_authz_filter.h",
        "src/core/lib/security/authorization/matchers.cc",
        "src/core/lib/security/authorization/matchers.h",
        "src/core/lib/security/authorization/rbac_policy.cc",
        "src/core/lib/security/authorization/rbac_policy.h",
        "src/core/lib/security/authorization/rbac_translator.cc",
        "src/core/lib/security/authorization/rbac_translator.h",
        "src/core/lib/security/authorization/stdout_logger.cc",
        "src/core/lib/security/authorization/stdout_logger.h",
        "src/core/lib/security/certificate_provider/certificate_provider_factory.h",
        "src/core/lib/security/certificate_provider/certificate_provider_registry.cc",
        "src/core/lib/security/certificate_provider/certificate_provider_registry.h",
        "src/core/lib/security/context/security_context.cc",
        "src/core/lib/security/context/security_context.h",
        "src/core/lib/security/credentials/alts/alts_credentials.cc",
        "src/core/lib/security/credentials/alts/alts_credentials.h",
        "src/core/lib/security/credentials/alts/check_gcp_environment.cc",
        "src/core/lib/security/credentials/alts/check_gcp_environment.h",
        "src/core/lib/security/credentials/alts/check_gcp_environment_linux.cc",
        "src/core/lib/security/credentials/alts/check_gcp_environment_no_op.cc",
        "src/core/lib/security/credentials/alts/check_gcp_environment_windows.cc",
        "src/core/lib/security/credentials/alts/grpc_alts_credentials_client_options.cc",
        "src/core/lib/security/credentials/alts/grpc_alts_credentials_options.cc",
        "src/core/lib/security/credentials/alts/grpc_alts_credentials_options.h",
        "src/core/lib/security/credentials/alts/grpc_alts_credentials_server_options.cc",
        "src/core/lib/security/credentials/call_creds_util.cc",
        "src/core/lib/security/credentials/call_creds_util.h",
        "src/core/lib/security/credentials/channel_creds_registry.h",
        "src/core/lib/security/credentials/channel_creds_registry_init.cc",
        "src/core/lib/security/credentials/composite/composite_credentials.cc",
        "src/core/lib/security/credentials/composite/composite_credentials.h",
        "src/core/lib/security/credentials/credentials.cc",
        "src/core/lib/security/credentials/credentials.h",
        "src/core/lib/security/credentials/external/aws_external_account_credentials.cc",
        "src/core/lib/security/credentials/external/aws_external_account_credentials.h",
        "src/core/lib/security/credentials/external/aws_request_signer.cc",
        "src/core/lib/security/credentials/external/aws_request_signer.h",
        "src/core/lib/security/credentials/external/external_account_credentials.cc",
        "src/core/lib/security/credentials/external/external_account_credentials.h",
        "src/core/lib/security/credentials/external/file_external_account_credentials.cc",
        "src/core/lib/security/credentials/external/file_external_account_credentials.h",
        "src/core/lib/security/credentials/external/url_external_account_credentials.cc",
        "src/core/lib/security/credentials/external/url_external_account_credentials.h",
        "src/core/lib/security/credentials/fake/fake_credentials.cc",
        "src/core/lib/security/credentials/fake/fake_credentials.h",
        "src/core/lib/security/credentials/gcp_service_account_identity/gcp_service_account_identity_credentials.cc",
        "src/core/lib/security/credentials/gcp_service_account_identity/gcp_service_account_identity_credentials.h",
        "src/core/lib/security/credentials/google_default/credentials_generic.cc",
        "src/core/lib/security/credentials/google_default/google_default_credentials.cc",
        "src/core/lib/security/credentials/google_default/google_default_credentials.h",
        "src/core/lib/security/credentials/iam/iam_credentials.cc",
        "src/core/lib/security/credentials/iam/iam_credentials.h",
        "src/core/lib/security/credentials/insecure/insecure_credentials.cc",
        "src/core/lib/security/credentials/insecure/insecure_credentials.h",
        "src/core/lib/security/credentials/jwt/json_token.cc",
        "src/core/lib/security/credentials/jwt/json_token.h",
        "src/core/lib/security/credentials/jwt/jwt_credentials.cc",
        "src/core/lib/security/credentials/jwt/jwt_credentials.h",
        "src/core/lib/security/credentials/jwt/jwt_verifier.cc",
        "src/core/lib/security/credentials/jwt/jwt_verifier.h",
        "src/core/lib/security/credentials/local/local_credentials.cc",
        "src/core/lib/security/credentials/local/local_credentials.h",
        "src/core/lib/security/credentials/oauth2/oauth2_credentials.cc",
        "src/core/lib/security/credentials/oauth2/oauth2_credentials.h",
        "src/core/lib/security/credentials/plugin/plugin_credentials.cc",
        "src/core/lib/security/credentials/plugin/plugin_credentials.h",
        "src/core/lib/security/credentials/ssl/ssl_credentials.cc",
        "src/core/lib/security/credentials/ssl/ssl_credentials.h",
        "src/core/lib/security/credentials/tls/grpc_tls_certificate_distributor.cc",
        "src/core/lib/security/credentials/tls/grpc_tls_certificate_distributor.h",
        "src/core/lib/security/credentials/tls/grpc_tls_certificate_match.cc",
        "src/core/lib/security/credentials/tls/grpc_tls_certificate_provider.cc",
        "src/core/lib/security/credentials/tls/grpc_tls_certificate_provider.h",
        "src/core/lib/security/credentials/tls/grpc_tls_certificate_verifier.cc",
        "src/core/lib/security/credentials/tls/grpc_tls_certificate_verifier.h",
        "src/core/lib/security/credentials/tls/grpc_tls_credentials_options.cc",
        "src/core/lib/security/credentials/tls/grpc_tls_credentials_options.h",
        "src/core/lib/security/credentials/tls/grpc_tls_crl_provider.cc",
        "src/core/lib/security/credentials/tls/grpc_tls_crl_provider.h",
        "src/core/lib/security/credentials/tls/tls_credentials.cc",
        "src/core/lib/security/credentials/tls/tls_credentials.h",
        "src/core/lib/security/credentials/tls/tls_utils.cc",
        "src/core/lib/security/credentials/tls/tls_utils.h",
        "src/core/lib/security/credentials/token_fetcher/token_fetcher_credentials.cc",
        "src/core/lib/security/credentials/token_fetcher/token_fetcher_credentials.h",
        "src/core/lib/security/credentials/xds/xds_credentials.cc",
        "src/core/lib/security/credentials/xds/xds_credentials.h",
        "src/core/lib/security/security_connector/alts/alts_security_connector.cc",
        "src/core/lib/security/security_connector/alts/alts_security_connector.h",
        "src/core/lib/security/security_connector/fake/fake_security_connector.cc",
        "src/core/lib/security/security_connector/fake/fake_security_connector.h",
        "src/core/lib/security/security_connector/insecure/insecure_security_connector.cc",
        "src/core/lib/security/security_connector/insecure/insecure_security_connector.h",
        "src/core/lib/security/security_connector/load_system_roots.h",
        "src/core/lib/security/security_connector/load_system_roots_fallback.cc",
        "src/core/lib/security/security_connector/load_system_roots_supported.cc",
        "src/core/lib/security/security_connector/load_system_roots_supported.h",
        "src/core/lib/security/security_connector/load_system_roots_windows.cc",
        "src/core/lib/security/security_connector/local/local_security_connector.cc",
        "src/core/lib/security/security_connector/local/local_security_connector.h",
        "src/core/lib/security/security_connector/security_connector.cc",
        "src/core/lib/security/security_connector/security_connector.h",
        "src/core/lib/security/security_connector/ssl/ssl_security_connector.cc",
        "src/core/lib/security/security_connector/ssl/ssl_security_connector.h",
        "src/core/lib/security/security_connector/ssl_utils.cc",
        "src/core/lib/security/security_connector/ssl_utils.h",
        "src/core/lib/security/security_connector/tls/tls_security_connector.cc",
        "src/core/lib/security/security_connector/tls/tls_security_connector.h",
        "src/core/lib/security/transport/auth_filters.h",
        "src/core/lib/security/transport/client_auth_filter.cc",
        "src/core/lib/security/transport/server_auth_filter.cc",
        "src/core/lib/security/util/json_util.cc",
        "src/core/lib/security/util/json_util.h",
        "src/core/lib/slice/percent_encoding.cc",
        "src/core/lib/slice/percent_encoding.h",
        "src/core/lib/slice/slice.cc",
        "src/core/lib/slice/slice.h",
        "src/core/lib/slice/slice_buffer.cc",
        "src/core/lib/slice/slice_buffer.h",
        "src/core/lib/slice/slice_internal.h",
        "src/core/lib/slice/slice_refcount.h",
        "src/core/lib/slice/slice_string_helpers.cc",
        "src/core/lib/slice/slice_string_helpers.h",
        "src/core/lib/surface/byte_buffer.cc",
        "src/core/lib/surface/byte_buffer_reader.cc",
        "src/core/lib/surface/call.cc",
        "src/core/lib/surface/call.h",
        "src/core/lib/surface/call_details.cc",
        "src/core/lib/surface/call_log_batch.cc",
        "src/core/lib/surface/call_test_only.h",
        "src/core/lib/surface/call_utils.cc",
        "src/core/lib/surface/call_utils.h",
        "src/core/lib/surface/channel.cc",
        "src/core/lib/surface/channel.h",
        "src/core/lib/surface/channel_create.cc",
        "src/core/lib/surface/channel_create.h",
        "src/core/lib/surface/channel_init.cc",
        "src/core/lib/surface/channel_init.h",
        "src/core/lib/surface/channel_stack_type.cc",
        "src/core/lib/surface/channel_stack_type.h",
        "src/core/lib/surface/client_call.cc",
        "src/core/lib/surface/client_call.h",
        "src/core/lib/surface/completion_queue.cc",
        "src/core/lib/surface/completion_queue.h",
        "src/core/lib/surface/completion_queue_factory.cc",
        "src/core/lib/surface/completion_queue_factory.h",
        "src/core/lib/surface/connection_context.cc",
        "src/core/lib/surface/connection_context.h",
        "src/core/lib/surface/event_string.cc",
        "src/core/lib/surface/event_string.h",
        "src/core/lib/surface/filter_stack_call.cc",
        "src/core/lib/surface/filter_stack_call.h",
        "src/core/lib/surface/init.cc",
        "src/core/lib/surface/init.h",
        "src/core/lib/surface/init_internally.cc",
        "src/core/lib/surface/init_internally.h",
        "src/core/lib/surface/lame_client.cc",
        "src/core/lib/surface/lame_client.h",
        "src/core/lib/surface/legacy_channel.cc",
        "src/core/lib/surface/legacy_channel.h",
        "src/core/lib/surface/metadata_array.cc",
        "src/core/lib/surface/server_call.cc",
        "src/core/lib/surface/server_call.h",
        "src/core/lib/surface/validate_metadata.cc",
        "src/core/lib/surface/validate_metadata.h",
        "src/core/lib/surface/version.cc",
        "src/core/lib/transport/bdp_estimator.cc",
        "src/core/lib/transport/bdp_estimator.h",
        "src/core/lib/transport/call_arena_allocator.cc",
        "src/core/lib/transport/call_arena_allocator.h",
        "src/core/lib/transport/call_destination.h",
        "src/core/lib/transport/call_filters.cc",
        "src/core/lib/transport/call_filters.h",
        "src/core/lib/transport/call_final_info.cc",
        "src/core/lib/transport/call_final_info.h",
        "src/core/lib/transport/call_spine.cc",
        "src/core/lib/transport/call_spine.h",
        "src/core/lib/transport/call_state.cc",
        "src/core/lib/transport/call_state.h",
        "src/core/lib/transport/connectivity_state.cc",
        "src/core/lib/transport/connectivity_state.h",
        "src/core/lib/transport/custom_metadata.h",
        "src/core/lib/transport/error_utils.cc",
        "src/core/lib/transport/error_utils.h",
        "src/core/lib/transport/http2_errors.h",
        "src/core/lib/transport/interception_chain.cc",
        "src/core/lib/transport/interception_chain.h",
        "src/core/lib/transport/message.cc",
        "src/core/lib/transport/message.h",
        "src/core/lib/transport/metadata.cc",
        "src/core/lib/transport/metadata.h",
        "src/core/lib/transport/metadata_batch.cc",
        "src/core/lib/transport/metadata_batch.h",
        "src/core/lib/transport/metadata_compression_traits.h",
        "src/core/lib/transport/metadata_info.cc",
        "src/core/lib/transport/metadata_info.h",
        "src/core/lib/transport/parsed_metadata.cc",
        "src/core/lib/transport/parsed_metadata.h",
        "src/core/lib/transport/simple_slice_based_metadata.h",
        "src/core/lib/transport/status_conversion.cc",
        "src/core/lib/transport/status_conversion.h",
        "src/core/lib/transport/timeout_encoding.cc",
        "src/core/lib/transport/timeout_encoding.h",
        "src/core/lib/transport/transport.cc",
        "src/core/lib/transport/transport.h",
        "src/core/lib/transport/transport_framing_endpoint_extension.h",
        "src/core/lib/transport/transport_fwd.h",
        "src/core/lib/transport/transport_op_string.cc",
        "src/core/load_balancing/address_filtering.cc",
        "src/core/load_balancing/address_filtering.h",
        "src/core/load_balancing/backend_metric_data.h",
        "src/core/load_balancing/backend_metric_parser.cc",
        "src/core/load_balancing/backend_metric_parser.h",
        "src/core/load_balancing/child_policy_handler.cc",
        "src/core/load_balancing/child_policy_handler.h",
        "src/core/load_balancing/delegating_helper.h",
        "src/core/load_balancing/endpoint_list.cc",
        "src/core/load_balancing/endpoint_list.h",
        "src/core/load_balancing/grpclb/client_load_reporting_filter.cc",
        "src/core/load_balancing/grpclb/client_load_reporting_filter.h",
        "src/core/load_balancing/grpclb/grpclb.cc",
        "src/core/load_balancing/grpclb/grpclb.h",
        "src/core/load_balancing/grpclb/grpclb_balancer_addresses.cc",
        "src/core/load_balancing/grpclb/grpclb_balancer_addresses.h",
        "src/core/load_balancing/grpclb/grpclb_client_stats.cc",
        "src/core/load_balancing/grpclb/grpclb_client_stats.h",
        "src/core/load_balancing/grpclb/load_balancer_api.cc",
        "src/core/load_balancing/grpclb/load_balancer_api.h",
        "src/core/load_balancing/health_check_client.cc",
        "src/core/load_balancing/health_check_client.h",
        "src/core/load_balancing/health_check_client_internal.h",
        "src/core/load_balancing/lb_policy.cc",
        "src/core/load_balancing/lb_policy.h",
        "src/core/load_balancing/lb_policy_factory.h",
        "src/core/load_balancing/lb_policy_registry.cc",
        "src/core/load_balancing/lb_policy_registry.h",
        "src/core/load_balancing/oob_backend_metric.cc",
        "src/core/load_balancing/oob_backend_metric.h",
        "src/core/load_balancing/oob_backend_metric_internal.h",
        "src/core/load_balancing/outlier_detection/outlier_detection.cc",
        "src/core/load_balancing/outlier_detection/outlier_detection.h",
        "src/core/load_balancing/pick_first/pick_first.cc",
        "src/core/load_balancing/pick_first/pick_first.h",
        "src/core/load_balancing/priority/priority.cc",
        "src/core/load_balancing/ring_hash/ring_hash.cc",
        "src/core/load_balancing/ring_hash/ring_hash.h",
        "src/core/load_balancing/rls/rls.cc",
        "src/core/load_balancing/rls/rls.h",
        "src/core/load_balancing/round_robin/round_robin.cc",
        "src/core/load_balancing/subchannel_interface.h",
        "src/core/load_balancing/weighted_round_robin/static_stride_scheduler.cc",
        "src/core/load_balancing/weighted_round_robin/static_stride_scheduler.h",
        "src/core/load_balancing/weighted_round_robin/weighted_round_robin.cc",
        "src/core/load_balancing/weighted_target/weighted_target.cc",
        "src/core/load_balancing/weighted_target/weighted_target.h",
        "src/core/load_balancing/xds/cds.cc",
        "src/core/load_balancing/xds/xds_channel_args.h",
        "src/core/load_balancing/xds/xds_cluster_impl.cc",
        "src/core/load_balancing/xds/xds_cluster_manager.cc",
        "src/core/load_balancing/xds/xds_override_host.cc",
        "src/core/load_balancing/xds/xds_override_host.h",
        "src/core/load_balancing/xds/xds_wrr_locality.cc",
        "src/core/plugin_registry/grpc_plugin_registry.cc",
        "src/core/plugin_registry/grpc_plugin_registry_extra.cc",
        "src/core/resolver/dns/c_ares/dns_resolver_ares.cc",
        "src/core/resolver/dns/c_ares/dns_resolver_ares.h",
        "src/core/resolver/dns/c_ares/grpc_ares_ev_driver.h",
        "src/core/resolver/dns/c_ares/grpc_ares_ev_driver_posix.cc",
        "src/core/resolver/dns/c_ares/grpc_ares_ev_driver_windows.cc",
        "src/core/resolver/dns/c_ares/grpc_ares_wrapper.cc",
        "src/core/resolver/dns/c_ares/grpc_ares_wrapper.h",
        "src/core/resolver/dns/c_ares/grpc_ares_wrapper_posix.cc",
        "src/core/resolver/dns/c_ares/grpc_ares_wrapper_windows.cc",
        "src/core/resolver/dns/dns_resolver_plugin.cc",
        "src/core/resolver/dns/dns_resolver_plugin.h",
        "src/core/resolver/dns/event_engine/event_engine_client_channel_resolver.cc",
        "src/core/resolver/dns/event_engine/event_engine_client_channel_resolver.h",
        "src/core/resolver/dns/event_engine/service_config_helper.cc",
        "src/core/resolver/dns/event_engine/service_config_helper.h",
        "src/core/resolver/dns/native/dns_resolver.cc",
        "src/core/resolver/dns/native/dns_resolver.h",
        "src/core/resolver/endpoint_addresses.cc",
        "src/core/resolver/endpoint_addresses.h",
        "src/core/resolver/fake/fake_resolver.cc",
        "src/core/resolver/fake/fake_resolver.h",
        "src/core/resolver/google_c2p/google_c2p_resolver.cc",
        "src/core/resolver/polling_resolver.cc",
        "src/core/resolver/polling_resolver.h",
        "src/core/resolver/resolver.cc",
        "src/core/resolver/resolver.h",
        "src/core/resolver/resolver_factory.h",
        "src/core/resolver/resolver_registry.cc",
        "src/core/resolver/resolver_registry.h",
        "src/core/resolver/server_address.h",
        "src/core/resolver/sockaddr/sockaddr_resolver.cc",
        "src/core/resolver/xds/xds_config.cc",
        "src/core/resolver/xds/xds_config.h",
        "src/core/resolver/xds/xds_dependency_manager.cc",
        "src/core/resolver/xds/xds_dependency_manager.h",
        "src/core/resolver/xds/xds_resolver.cc",
        "src/core/resolver/xds/xds_resolver_attributes.h",
        "src/core/server/server.cc",
        "src/core/server/server.h",
        "src/core/server/server_call_tracer_filter.cc",
        "src/core/server/server_call_tracer_filter.h",
        "src/core/server/server_config_selector.h",
        "src/core/server/server_config_selector_filter.cc",
        "src/core/server/server_config_selector_filter.h",
        "src/core/server/server_interface.h",
        "src/core/server/xds_channel_stack_modifier.cc",
        "src/core/server/xds_channel_stack_modifier.h",
        "src/core/server/xds_server_config_fetcher.cc",
        "src/core/service_config/service_config.h",
        "src/core/service_config/service_config_call_data.h",
        "src/core/service_config/service_config_channel_arg_filter.cc",
        "src/core/service_config/service_config_impl.cc",
        "src/core/service_config/service_config_impl.h",
        "src/core/service_config/service_config_parser.cc",
        "src/core/service_config/service_config_parser.h",
        "src/core/telemetry/call_tracer.cc",
        "src/core/telemetry/call_tracer.h",
        "src/core/telemetry/histogram_view.cc",
        "src/core/telemetry/histogram_view.h",
        "src/core/telemetry/metrics.cc",
        "src/core/telemetry/metrics.h",
        "src/core/telemetry/stats.cc",
        "src/core/telemetry/stats.h",
        "src/core/telemetry/stats_data.cc",
        "src/core/telemetry/stats_data.h",
        "src/core/telemetry/tcp_tracer.h",
        "src/core/tsi/alts/crypt/aes_gcm.cc",
        "src/core/tsi/alts/crypt/gsec.cc",
        "src/core/tsi/alts/crypt/gsec.h",
        "src/core/tsi/alts/frame_protector/alts_counter.cc",
        "src/core/tsi/alts/frame_protector/alts_counter.h",
        "src/core/tsi/alts/frame_protector/alts_crypter.cc",
        "src/core/tsi/alts/frame_protector/alts_crypter.h",
        "src/core/tsi/alts/frame_protector/alts_frame_protector.cc",
        "src/core/tsi/alts/frame_protector/alts_frame_protector.h",
        "src/core/tsi/alts/frame_protector/alts_record_protocol_crypter_common.cc",
        "src/core/tsi/alts/frame_protector/alts_record_protocol_crypter_common.h",
        "src/core/tsi/alts/frame_protector/alts_seal_privacy_integrity_crypter.cc",
        "src/core/tsi/alts/frame_protector/alts_unseal_privacy_integrity_crypter.cc",
        "src/core/tsi/alts/frame_protector/frame_handler.cc",
        "src/core/tsi/alts/frame_protector/frame_handler.h",
        "src/core/tsi/alts/handshaker/alts_handshaker_client.cc",
        "src/core/tsi/alts/handshaker/alts_handshaker_client.h",
        "src/core/tsi/alts/handshaker/alts_shared_resource.cc",
        "src/core/tsi/alts/handshaker/alts_shared_resource.h",
        "src/core/tsi/alts/handshaker/alts_tsi_handshaker.cc",
        "src/core/tsi/alts/handshaker/alts_tsi_handshaker.h",
        "src/core/tsi/alts/handshaker/alts_tsi_handshaker_private.h",
        "src/core/tsi/alts/handshaker/alts_tsi_utils.cc",
        "src/core/tsi/alts/handshaker/alts_tsi_utils.h",
        "src/core/tsi/alts/handshaker/transport_security_common_api.cc",
        "src/core/tsi/alts/handshaker/transport_security_common_api.h",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_integrity_only_record_protocol.cc",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_integrity_only_record_protocol.h",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_privacy_integrity_record_protocol.cc",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_privacy_integrity_record_protocol.h",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol.h",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol_common.cc",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol_common.h",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_iovec_record_protocol.cc",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_iovec_record_protocol.h",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_zero_copy_grpc_protector.cc",
        "src/core/tsi/alts/zero_copy_frame_protector/alts_zero_copy_grpc_protector.h",
        "src/core/tsi/fake_transport_security.cc",
        "src/core/tsi/fake_transport_security.h",
        "src/core/tsi/local_transport_security.cc",
        "src/core/tsi/local_transport_security.h",
        "src/core/tsi/ssl/key_logging/ssl_key_logging.cc",
        "src/core/tsi/ssl/key_logging/ssl_key_logging.h",
        "src/core/tsi/ssl/session_cache/ssl_session.h",
        "src/core/tsi/ssl/session_cache/ssl_session_boringssl.cc",
        "src/core/tsi/ssl/session_cache/ssl_session_cache.cc",
        "src/core/tsi/ssl/session_cache/ssl_session_cache.h",
        "src/core/tsi/ssl/session_cache/ssl_session_openssl.cc",
        "src/core/tsi/ssl_transport_security.cc",
        "src/core/tsi/ssl_transport_security.h",
        "src/core/tsi/ssl_transport_security_utils.cc",
        "src/core/tsi/ssl_transport_security_utils.h",
        "src/core/tsi/ssl_types.h",
        "src/core/tsi/transport_security.cc",
        "src/core/tsi/transport_security.h",
        "src/core/tsi/transport_security_grpc.cc",
        "src/core/tsi/transport_security_grpc.h",
        "src/core/tsi/transport_security_interface.h",
        "src/core/util/alloc.cc",
        "src/core/util/alloc.h",
        "src/core/util/atm.cc",
        "src/core/util/atomic_utils.h",
        "src/core/util/avl.h",
        "src/core/util/backoff.cc",
        "src/core/util/backoff.h",
        "src/core/util/bitset.h",
        "src/core/util/chunked_vector.h",
        "src/core/util/construct_destruct.h",
        "src/core/util/cpp_impl_of.h",
        "src/core/util/crash.cc",
        "src/core/util/crash.h",
        "src/core/util/debug_location.h",
        "src/core/util/directory_reader.h",
        "src/core/util/down_cast.h",
        "src/core/util/dual_ref_counted.h",
        "src/core/util/dump_args.cc",
        "src/core/util/dump_args.h",
        "src/core/util/env.h",
        "src/core/util/event_log.cc",
        "src/core/util/event_log.h",
        "src/core/util/examine_stack.cc",
        "src/core/util/examine_stack.h",
        "src/core/util/fork.cc",
        "src/core/util/fork.h",
        "src/core/util/gcp_metadata_query.cc",
        "src/core/util/gcp_metadata_query.h",
        "src/core/util/gethostname.h",
        "src/core/util/gethostname_fallback.cc",
        "src/core/util/gethostname_host_name_max.cc",
        "src/core/util/gethostname_sysconf.cc",
        "src/core/util/glob.cc",
        "src/core/util/glob.h",
        "src/core/util/gpr_time.cc",
        "src/core/util/grpc_if_nametoindex.h",
        "src/core/util/grpc_if_nametoindex_posix.cc",
        "src/core/util/grpc_if_nametoindex_unsupported.cc",
        "src/core/util/host_port.cc",
        "src/core/util/host_port.h",
        "src/core/util/http_client/format_request.cc",
        "src/core/util/http_client/format_request.h",
        "src/core/util/http_client/httpcli.cc",
        "src/core/util/http_client/httpcli.h",
        "src/core/util/http_client/httpcli_security_connector.cc",
        "src/core/util/http_client/httpcli_ssl_credentials.h",
        "src/core/util/http_client/parser.cc",
        "src/core/util/http_client/parser.h",
        "src/core/util/if_list.h",
        "src/core/util/iphone/cpu.cc",
        "src/core/util/json/json.h",
        "src/core/util/json/json_args.h",
        "src/core/util/json/json_channel_args.h",
        "src/core/util/json/json_object_loader.cc",
        "src/core/util/json/json_object_loader.h",
        "src/core/util/json/json_reader.cc",
        "src/core/util/json/json_reader.h",
        "src/core/util/json/json_util.cc",
        "src/core/util/json/json_util.h",
        "src/core/util/json/json_writer.cc",
        "src/core/util/json/json_writer.h",
        "src/core/util/latent_see.cc",
        "src/core/util/latent_see.h",
        "src/core/util/linux/cpu.cc",
        "src/core/util/linux/env.cc",
        "src/core/util/load_file.cc",
        "src/core/util/load_file.h",
        "src/core/util/log.cc",
        "src/core/util/lru_cache.h",
        "src/core/util/manual_constructor.h",
        "src/core/util/match.h",
        "src/core/util/matchers.cc",
        "src/core/util/matchers.h",
        "src/core/util/memory.h",
        "src/core/util/mpscq.cc",
        "src/core/util/mpscq.h",
        "src/core/util/msys/tmpfile.cc",
        "src/core/util/no_destruct.h",
        "src/core/util/notification.h",
        "src/core/util/orphanable.h",
        "src/core/util/overload.h",
        "src/core/util/packed_table.h",
        "src/core/util/per_cpu.cc",
        "src/core/util/per_cpu.h",
        "src/core/util/posix/cpu.cc",
        "src/core/util/posix/directory_reader.cc",
        "src/core/util/posix/env.cc",
        "src/core/util/posix/stat.cc",
        "src/core/util/posix/string.cc",
        "src/core/util/posix/sync.cc",
        "src/core/util/posix/thd.cc",
        "src/core/util/posix/time.cc",
        "src/core/util/posix/tmpfile.cc",
        "src/core/util/random_early_detection.cc",
        "src/core/util/random_early_detection.h",
        "src/core/util/ref_counted.h",
        "src/core/util/ref_counted_ptr.h",
        "src/core/util/ref_counted_string.cc",
        "src/core/util/ref_counted_string.h",
        "src/core/util/ring_buffer.h",
        "src/core/util/single_set_ptr.h",
        "src/core/util/sorted_pack.h",
        "src/core/util/spinlock.h",
        "src/core/util/stat.h",
        "src/core/util/status_helper.cc",
        "src/core/util/status_helper.h",
        "src/core/util/strerror.cc",
        "src/core/util/strerror.h",
        "src/core/util/string.cc",
        "src/core/util/string.h",
        "src/core/util/sync.cc",
        "src/core/util/sync.h",
        "src/core/util/sync_abseil.cc",
        "src/core/util/table.h",
        "src/core/util/tchar.cc",
        "src/core/util/tchar.h",
        "src/core/util/thd.h",
        "src/core/util/time.cc",
        "src/core/util/time.h",
        "src/core/util/time_averaged_stats.cc",
        "src/core/util/time_averaged_stats.h",
        "src/core/util/time_precise.cc",
        "src/core/util/time_precise.h",
        "src/core/util/time_util.cc",
        "src/core/util/time_util.h",
        "src/core/util/tmpfile.h",
        "src/core/util/type_list.h",
        "src/core/util/unique_ptr_with_bitset.h",
        "src/core/util/unique_type_name.h",
        "src/core/util/upb_utils.h",
        "src/core/util/uri.cc",
        "src/core/util/uri.h",
        "src/core/util/useful.h",
        "src/core/util/uuid_v4.cc",
        "src/core/util/uuid_v4.h",
        "src/core/util/validation_errors.cc",
        "src/core/util/validation_errors.h",
        "src/core/util/windows/cpu.cc",
        "src/core/util/windows/directory_reader.cc",
        "src/core/util/windows/env.cc",
        "src/core/util/windows/stat.cc",
        "src/core/util/windows/string.cc",
        "src/core/util/windows/string_util.cc",
        "src/core/util/windows/sync.cc",
        "src/core/util/windows/thd.cc",
        "src/core/util/windows/time.cc",
        "src/core/util/windows/tmpfile.cc",
        "src/core/util/work_serializer.cc",
        "src/core/util/work_serializer.h",
        "src/core/util/xxhash_inline.h",
        "src/core/xds/grpc/certificate_provider_store.cc",
        "src/core/xds/grpc/certificate_provider_store.h",
        "src/core/xds/grpc/file_watcher_certificate_provider_factory.cc",
        "src/core/xds/grpc/file_watcher_certificate_provider_factory.h",
        "src/core/xds/grpc/xds_audit_logger_registry.cc",
        "src/core/xds/grpc/xds_audit_logger_registry.h",
        "src/core/xds/grpc/xds_bootstrap_grpc.cc",
        "src/core/xds/grpc/xds_bootstrap_grpc.h",
        "src/core/xds/grpc/xds_certificate_provider.cc",
        "src/core/xds/grpc/xds_certificate_provider.h",
        "src/core/xds/grpc/xds_client_grpc.cc",
        "src/core/xds/grpc/xds_client_grpc.h",
        "src/core/xds/grpc/xds_cluster.cc",
        "src/core/xds/grpc/xds_cluster.h",
        "src/core/xds/grpc/xds_cluster_parser.cc",
        "src/core/xds/grpc/xds_cluster_parser.h",
        "src/core/xds/grpc/xds_cluster_specifier_plugin.cc",
        "src/core/xds/grpc/xds_cluster_specifier_plugin.h",
        "src/core/xds/grpc/xds_common_types.cc",
        "src/core/xds/grpc/xds_common_types.h",
        "src/core/xds/grpc/xds_common_types_parser.cc",
        "src/core/xds/grpc/xds_common_types_parser.h",
        "src/core/xds/grpc/xds_endpoint.cc",
        "src/core/xds/grpc/xds_endpoint.h",
        "src/core/xds/grpc/xds_endpoint_parser.cc",
        "src/core/xds/grpc/xds_endpoint_parser.h",
        "src/core/xds/grpc/xds_health_status.cc",
        "src/core/xds/grpc/xds_health_status.h",
        "src/core/xds/grpc/xds_http_fault_filter.cc",
        "src/core/xds/grpc/xds_http_fault_filter.h",
        "src/core/xds/grpc/xds_http_filter.h",
        "src/core/xds/grpc/xds_http_filter_registry.cc",
        "src/core/xds/grpc/xds_http_filter_registry.h",
        "src/core/xds/grpc/xds_http_gcp_authn_filter.cc",
        "src/core/xds/grpc/xds_http_gcp_authn_filter.h",
        "src/core/xds/grpc/xds_http_rbac_filter.cc",
        "src/core/xds/grpc/xds_http_rbac_filter.h",
        "src/core/xds/grpc/xds_http_stateful_session_filter.cc",
        "src/core/xds/grpc/xds_http_stateful_session_filter.h",
        "src/core/xds/grpc/xds_lb_policy_registry.cc",
        "src/core/xds/grpc/xds_lb_policy_registry.h",
        "src/core/xds/grpc/xds_listener.cc",
        "src/core/xds/grpc/xds_listener.h",
        "src/core/xds/grpc/xds_listener_parser.cc",
        "src/core/xds/grpc/xds_listener_parser.h",
        "src/core/xds/grpc/xds_metadata.cc",
        "src/core/xds/grpc/xds_metadata.h",
        "src/core/xds/grpc/xds_metadata_parser.cc",
        "src/core/xds/grpc/xds_metadata_parser.h",
        "src/core/xds/grpc/xds_route_config.cc",
        "src/core/xds/grpc/xds_route_config.h",
        "src/core/xds/grpc/xds_route_config_parser.cc",
        "src/core/xds/grpc/xds_route_config_parser.h",
        "src/core/xds/grpc/xds_routing.cc",
        "src/core/xds/grpc/xds_routing.h",
        "src/core/xds/grpc/xds_server_grpc.cc",
        "src/core/xds/grpc/xds_server_grpc.h",
        "src/core/xds/grpc/xds_transport_grpc.cc",
        "src/core/xds/grpc/xds_transport_grpc.h",
        "src/core/xds/xds_client/lrs_client.cc",
        "src/core/xds/xds_client/lrs_client.h",
        "src/core/xds/xds_client/xds_api.cc",
        "src/core/xds/xds_client/xds_api.h",
        "src/core/xds/xds_client/xds_backend_metric_propagation.cc",
        "src/core/xds/xds_client/xds_backend_metric_propagation.h",
        "src/core/xds/xds_client/xds_bootstrap.cc",
        "src/core/xds/xds_client/xds_bootstrap.h",
        "src/core/xds/xds_client/xds_channel_args.h",
        "src/core/xds/xds_client/xds_client.cc",
        "src/core/xds/xds_client/xds_client.h",
        "src/core/xds/xds_client/xds_locality.h",
        "src/core/xds/xds_client/xds_metrics.h",
        "src/core/xds/xds_client/xds_resource_type.h",
        "src/core/xds/xds_client/xds_resource_type_impl.h",
        "src/core/xds/xds_client/xds_transport.h",
        "third_party/address_sorting/address_sorting.c",
        "third_party/address_sorting/address_sorting_internal.h",
        "third_party/address_sorting/address_sorting_posix.c",
        "third_party/address_sorting/address_sorting_windows.c",
        "third_party/address_sorting/include/address_sorting/address_sorting.h",
        "third_party/re2/re2/bitmap256.h",
        "third_party/re2/re2/bitstate.cc",
        "third_party/re2/re2/compile.cc",
        "third_party/re2/re2/dfa.cc",
        "third_party/re2/re2/filtered_re2.cc",
        "third_party/re2/re2/filtered_re2.h",
        "third_party/re2/re2/mimics_pcre.cc",
        "third_party/re2/re2/nfa.cc",
        "third_party/re2/re2/onepass.cc",
        "third_party/re2/re2/parse.cc",
        "third_party/re2/re2/perl_groups.cc",
        "third_party/re2/re2/pod_array.h",
        "third_party/re2/re2/prefilter.cc",
        "third_party/re2/re2/prefilter.h",
        "third_party/re2/re2/prefilter_tree.cc",
        "third_party/re2/re2/prefilter_tree.h",
        "third_party/re2/re2/prog.cc",
        "third_party/re2/re2/prog.h",
        "third_party/re2/re2/re2.cc",
        "third_party/re2/re2/re2.h",
        "third_party/re2/re2/regexp.cc",
        "third_party/re2/re2/regexp.h",
        "third_party/re2/re2/set.cc",
        "third_party/re2/re2/set.h",
        "third_party/re2/re2/simplify.cc",
        "third_party/re2/re2/sparse_array.h",
        "third_party/re2/re2/sparse_set.h",
        "third_party/re2/re2/stringpiece.cc",
        "third_party/re2/re2/stringpiece.h",
        "third_party/re2/re2/tostring.cc",
        "third_party/re2/re2/unicode_casefold.cc",
        "third_party/re2/re2/unicode_casefold.h",
        "third_party/re2/re2/unicode_groups.cc",
        "third_party/re2/re2/unicode_groups.h",
        "third_party/re2/re2/walker-inl.h",
        "third_party/re2/util/logging.h",
        "third_party/re2/util/mix.h",
        "third_party/re2/util/mutex.h",
        "third_party/re2/util/rune.cc",
        "third_party/re2/util/strutil.cc",
        "third_party/re2/util/strutil.h",
        "third_party/re2/util/utf.h",
        "third_party/re2/util/util.h",
        "third_party/upb/upb/base/descriptor_constants.h",
        "third_party/upb/upb/base/internal/endian.h",
        "third_party/upb/upb/base/internal/log2.h",
        "third_party/upb/upb/base/status.c",
        "third_party/upb/upb/base/status.h",
        "third_party/upb/upb/base/status.hpp",
        "third_party/upb/upb/base/string_view.h",
        "third_party/upb/upb/base/upcast.h",
        "third_party/upb/upb/generated_code_support.h",
        "third_party/upb/upb/hash/common.c",
        "third_party/upb/upb/hash/common.h",
        "third_party/upb/upb/hash/int_table.h",
        "third_party/upb/upb/hash/str_table.h",
        "third_party/upb/upb/json/decode.c",
        "third_party/upb/upb/json/decode.h",
        "third_party/upb/upb/json/encode.c",
        "third_party/upb/upb/json/encode.h",
        "third_party/upb/upb/lex/atoi.c",
        "third_party/upb/upb/lex/atoi.h",
        "third_party/upb/upb/lex/round_trip.c",
        "third_party/upb/upb/lex/round_trip.h",
        "third_party/upb/upb/lex/strtod.c",
        "third_party/upb/upb/lex/strtod.h",
        "third_party/upb/upb/lex/unicode.c",
        "third_party/upb/upb/lex/unicode.h",
        "third_party/upb/upb/mem/alloc.c",
        "third_party/upb/upb/mem/alloc.h",
        "third_party/upb/upb/mem/arena.c",
        "third_party/upb/upb/mem/arena.h",
        "third_party/upb/upb/mem/arena.hpp",
        "third_party/upb/upb/mem/internal/arena.h",
        "third_party/upb/upb/message/accessors.c",
        "third_party/upb/upb/message/accessors.h",
        "third_party/upb/upb/message/array.c",
        "third_party/upb/upb/message/array.h",
        "third_party/upb/upb/message/compat.c",
        "third_party/upb/upb/message/compat.h",
        "third_party/upb/upb/message/copy.c",
        "third_party/upb/upb/message/copy.h",
        "third_party/upb/upb/message/internal/accessors.h",
        "third_party/upb/upb/message/internal/array.h",
        "third_party/upb/upb/message/internal/compare_unknown.c",
        "third_party/upb/upb/message/internal/compare_unknown.h",
        "third_party/upb/upb/message/internal/extension.c",
        "third_party/upb/upb/message/internal/extension.h",
        "third_party/upb/upb/message/internal/map.h",
        "third_party/upb/upb/message/internal/map_entry.h",
        "third_party/upb/upb/message/internal/map_sorter.h",
        "third_party/upb/upb/message/internal/message.c",
        "third_party/upb/upb/message/internal/message.h",
        "third_party/upb/upb/message/internal/tagged_ptr.h",
        "third_party/upb/upb/message/internal/types.h",
        "third_party/upb/upb/message/map.c",
        "third_party/upb/upb/message/map.h",
        "third_party/upb/upb/message/map_gencode_util.h",
        "third_party/upb/upb/message/map_sorter.c",
        "third_party/upb/upb/message/merge.c",
        "third_party/upb/upb/message/merge.h",
        "third_party/upb/upb/message/message.c",
        "third_party/upb/upb/message/message.h",
        "third_party/upb/upb/message/tagged_ptr.h",
        "third_party/upb/upb/message/value.h",
        "third_party/upb/upb/mini_table/enum.h",
        "third_party/upb/upb/mini_table/extension.h",
        "third_party/upb/upb/mini_table/extension_registry.c",
        "third_party/upb/upb/mini_table/extension_registry.h",
        "third_party/upb/upb/mini_table/field.h",
        "third_party/upb/upb/mini_table/file.h",
        "third_party/upb/upb/mini_table/internal/enum.h",
        "third_party/upb/upb/mini_table/internal/extension.h",
        "third_party/upb/upb/mini_table/internal/field.h",
        "third_party/upb/upb/mini_table/internal/file.h",
        "third_party/upb/upb/mini_table/internal/message.c",
        "third_party/upb/upb/mini_table/internal/message.h",
        "third_party/upb/upb/mini_table/internal/size_log2.h",
        "third_party/upb/upb/mini_table/internal/sub.h",
        "third_party/upb/upb/mini_table/message.c",
        "third_party/upb/upb/mini_table/message.h",
        "third_party/upb/upb/mini_table/sub.h",
        "third_party/upb/upb/port/atomic.h",
        "third_party/upb/upb/port/def.inc",
        "third_party/upb/upb/port/undef.inc",
        "third_party/upb/upb/port/vsnprintf_compat.h",
        "third_party/upb/upb/reflection/common.h",
        "third_party/upb/upb/reflection/def.h",
        "third_party/upb/upb/reflection/def.hpp",
        "third_party/upb/upb/reflection/def_pool.c",
        "third_party/upb/upb/reflection/def_pool.h",
        "third_party/upb/upb/reflection/def_type.c",
        "third_party/upb/upb/reflection/def_type.h",
        "third_party/upb/upb/reflection/desc_state.c",
        "third_party/upb/upb/reflection/descriptor_bootstrap.h",
        "third_party/upb/upb/reflection/enum_def.c",
        "third_party/upb/upb/reflection/enum_def.h",
        "third_party/upb/upb/reflection/enum_reserved_range.c",
        "third_party/upb/upb/reflection/enum_reserved_range.h",
        "third_party/upb/upb/reflection/enum_value_def.c",
        "third_party/upb/upb/reflection/enum_value_def.h",
        "third_party/upb/upb/reflection/extension_range.c",
        "third_party/upb/upb/reflection/extension_range.h",
        "third_party/upb/upb/reflection/field_def.c",
        "third_party/upb/upb/reflection/field_def.h",
        "third_party/upb/upb/reflection/file_def.c",
        "third_party/upb/upb/reflection/file_def.h",
        "third_party/upb/upb/reflection/internal/def_builder.c",
        "third_party/upb/upb/reflection/internal/def_builder.h",
        "third_party/upb/upb/reflection/internal/def_pool.h",
        "third_party/upb/upb/reflection/internal/desc_state.h",
        "third_party/upb/upb/reflection/internal/enum_def.h",
        "third_party/upb/upb/reflection/internal/enum_reserved_range.h",
        "third_party/upb/upb/reflection/internal/enum_value_def.h",
        "third_party/upb/upb/reflection/internal/extension_range.h",
        "third_party/upb/upb/reflection/internal/field_def.h",
        "third_party/upb/upb/reflection/internal/file_def.h",
        "third_party/upb/upb/reflection/internal/message_def.h",
        "third_party/upb/upb/reflection/internal/message_reserved_range.h",
        "third_party/upb/upb/reflection/internal/method_def.h",
        "third_party/upb/upb/reflection/internal/oneof_def.h",
        "third_party/upb/upb/reflection/internal/service_def.h",
        "third_party/upb/upb/reflection/internal/strdup2.c",
        "third_party/upb/upb/reflection/internal/strdup2.h",
        "third_party/upb/upb/reflection/internal/upb_edition_defaults.h",
        "third_party/upb/upb/reflection/message.c",
        "third_party/upb/upb/reflection/message.h",
        "third_party/upb/upb/reflection/message.hpp",
        "third_party/upb/upb/reflection/message_def.c",
        "third_party/upb/upb/reflection/message_def.h",
        "third_party/upb/upb/reflection/message_reserved_range.c",
        "third_party/upb/upb/reflection/message_reserved_range.h",
        "third_party/upb/upb/reflection/method_def.c",
        "third_party/upb/upb/reflection/method_def.h",
        "third_party/upb/upb/reflection/oneof_def.c",
        "third_party/upb/upb/reflection/oneof_def.h",
        "third_party/upb/upb/reflection/service_def.c",
        "third_party/upb/upb/reflection/service_def.h",
        "third_party/upb/upb/text/encode.c",
        "third_party/upb/upb/text/encode.h",
        "third_party/upb/upb/text/internal/encode.c",
        "third_party/upb/upb/text/internal/encode.h",
        "third_party/upb/upb/text/options.h",
        "third_party/upb/upb/wire/eps_copy_input_stream.c",
        "third_party/upb/upb/wire/eps_copy_input_stream.h",
        "third_party/upb/upb/wire/internal/reader.h",
        "third_party/upb/upb/wire/reader.c",
        "third_party/upb/upb/wire/reader.h",
        "third_party/upb/upb/wire/types.h",
        "third_party/utf8_range/utf8_range.c",
        "third_party/utf8_range/utf8_range.h",
        "third_party/xxhash/xxhash.h",
      ],
      resources: [
        .copy("src/objective-c/PrivacyInfo.xcprivacy"),
      ],
      publicHeadersPath: "spm-core-include",
      cSettings: [
        .headerSearchPath("./"),
        .headerSearchPath("include/"),
        .headerSearchPath("third_party/re2/"),
        .headerSearchPath("third_party/upb/"),
        .headerSearchPath("third_party/utf8_range/"),
        .headerSearchPath("third_party/xxhash/"),
        .headerSearchPath("third_party/address_sorting/include/"),
        .headerSearchPath("src/core/ext/upb-gen/"),
        .headerSearchPath("src/core/ext/upbdefs-gen/"),
        .define("GRPC_ARES", to: "0"),
      ],
      linkerSettings: [
        .linkedFramework("CoreFoundation"),
        .linkedLibrary("z"),
      ]
    ),
    .target(
      name: "gRPC-cpp",
      dependencies: [
        .product(name:"abseil", package: "abseil-cpp-SwiftPM"),
        "gRPC-Core",
      ],
      path: basePath,
      exclude: [
        "examples/",
        "src/cpp/client/cronet_credentials.cc",
        "src/cpp/client/channel_test_peer.cc",
        "src/cpp/common/alts_util.cc",
        "src/cpp/common/alts_context.cc",
        "src/cpp/common/insecure_create_auth_context.cc",
        "src/cpp/server/admin/",
        "src/cpp/server/channelz/",
        "src/cpp/server/csds/",
        "src/cpp/server/load_reporter/",
        "src/cpp/ext/",
        "src/cpp/util/core_stats.cc",
        "src/cpp/util/core_stats.h",
        "src/cpp/util/error_details.cc",
        "src/objective-c/examples/",
        "src/objective-c/manual_tests/",
        "src/objective-c/tests/",
      ],
      sources: [
        "src/cpp/",
      ],
      resources: [
        .copy("src/objective-c/PrivacyInfo.xcprivacy"),
      ],
      publicHeadersPath: "spm-cpp-include",
      cSettings: [
        .headerSearchPath("./"),
        .headerSearchPath("include/"),
        .headerSearchPath("third_party/upb/"),
        .headerSearchPath("src/core/ext/upb-gen"),
      ]
    ),
    .testTarget(
      name: "build-test",
      dependencies: [
        "gRPC-cpp",
      ],
      path: basePath + "/test/spm_build"
    ),
  ],
  cLanguageStandard: .gnu11,
  cxxLanguageStandard: .cxx14
)
