# ITK 5.4.2 Release Notes

We are pleased to announce the release of [ITK 5.4.2](https://docs.itk.org), the latest maintenance update for this cross-platform, open-source toolkit supporting N-dimensional scientific image analysis with spatially-aware algorithms. 🎉 🍻 🥳 This patch release addresses several key issues identified since ITK 5.4.0 while maintaining API stability.

🔦 Highlights
-------------

As a maintenance update following 5.4.0, version 5.4.2 incorporates critical improvements including:

- **Enhanced Label Map Handling**: Improved unique label map filter behavior for segmentation workflows
- **Modern Library Support**: Updated compatibility with recent libtiff versions
- **Large Data Optimization**: Expanded `VectorImage` support for high-dimensional datasets
- **Performance Improvements**: Fixed thread-based parallelism in SLIC filter implementations
- **Cross-Platform Enhancements**: Build system updates and compiler compatibility fixes

A full list of changes can be found in the changelog below.

🔢 Versioning Note
------------------

This release follows 5.4.0 directly, as the intermediate 5.4.1 patch was reserved for an urgent hotfix that required immediate distribution prior to full release documentation.

For comprehensive details on ITK 5.4.0, please review the [ITK 5.4.0 Release Notes](https://docs.itk.org/en/latest/releases/5.4.0.html).

💾 Download
-----------

**Python Packages**

Install [ITK Python packages](https://docs.itk.org/en/latest/learn/python_quick_start.html) with:

```bash
pip install itk
```

**Guide and Textbook**

- [InsightSoftwareGuide-Book1-5.4.2.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.2/InsightSoftwareGuide-Book1-5.4.2.pdf)
- [InsightSoftwareGuide-Book2-5.4.2.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.2/InsightSoftwareGuide-Book2-5.4.2.pdf)

**Library Sources**

- [InsightToolkit-5.4.2.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.2/InsightToolkit-5.4.2.tar.gz)
- [InsightToolkit-5.4.2.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.2/InsightToolkit-5.4.2.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.4.2.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.2/InsightData-5.4.2.tar.gz)
- [InsightData-5.4.2.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.2/InsightData-5.4.2.zip)

**Checksums and Signatures**

- [InsightToolkit-5.4.2.tar.gz.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.2/InsightToolkit-5.4.2.tar.gz.asc)
- [InsightToolkit-5.4.2.zip.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.2/InsightToolkit-5.4.2.zip.asc)

- [InsightData-5.4.2.tar.gz.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.2/InsightData-5.4.2.tar.gz.asc)
- [InsightData-5.4.2.zip.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.2/InsightData-5.4.2.zip.asc)

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.2/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.2/SHA512SUMS)

🙏 Congratulations
------------------

Congratulations and **thank you** to everyone who contributed to this release.

🗣️ What's Next
---------------

**ITK 6 Preparation**

The development community is currently focused on delivering **ITK 6**, a major modernization release featuring:

- Architectural upgrades for contemporary C++ development
- Enhanced template metaprogramming capabilities
- Streamlined build system configurations

Early access builds (alpha/beta releases) will become available during ongoing 5.4.x maintenance, enabling parallel evaluation of new features while maintaining production stability.

**5.4 Maintenance Commitment**

We remain dedicated to supporting current users through:

- Regular security and regression patches
- Critical bug resolution
- Platform compatibility updates

**Enjoy ITK!**

ITK Changes Since v5.4.0
------------------------

### Andras Lasso (1):

#### Enhancements

- Backport libtiff fix of not displaying warning for unknown tags ([15e47178d6](https://github.com/InsightSoftwareConsortium/ITK/commit/15e47178d6))


### Brad King (1):

#### Platform Fixes

- itktiff: Suppress C99 inline only on MSVC from VS 2013 and below ([6025654de3](https://github.com/InsightSoftwareConsortium/ITK/commit/6025654de3))


### Bradley Lowekamp (11):

#### Enhancements

- A GTest for LabelUniqueLabelMapFilter ([47eec5a2a2](https://github.com/InsightSoftwareConsortium/ITK/commit/47eec5a2a2))
- Download x86 clangformat on Darwin arm64 ([ee6bc26281](https://github.com/InsightSoftwareConsortium/ITK/commit/ee6bc26281))
- remove repetitive monochorme1 warning ([80a172e8c2](https://github.com/InsightSoftwareConsortium/ITK/commit/80a172e8c2))

#### Documentation Updates

- Correct Documentation for PadImageFilter::SizeGreatestPrimeFactor ([276a52a5c0](https://github.com/InsightSoftwareConsortium/ITK/commit/276a52a5c0))

#### Bug Fixes

- Check output of StatisticsUniqueLabelMapFilterTest1 ([8f32d71c8a](https://github.com/InsightSoftwareConsortium/ITK/commit/8f32d71c8a))
- Address bugs in unique label map filters ([00bfdb80e7](https://github.com/InsightSoftwareConsortium/ITK/commit/00bfdb80e7))
- Remove dilation output in test ([790af9eba0](https://github.com/InsightSoftwareConsortium/ITK/commit/790af9eba0))
- Address race condition in SLIC filter ([bbf9f17a40](https://github.com/InsightSoftwareConsortium/ITK/commit/bbf9f17a40))
- Enable system TIFF with modern TIFF and cmake ([7b83336a7e](https://github.com/InsightSoftwareConsortium/ITK/commit/7b83336a7e))
- Remove SpatialObjectProperty's writable string methods from SWIG ([efe773f555](https://github.com/InsightSoftwareConsortium/ITK/commit/efe773f555))
- Fix 32-bit truncation on VectorImage Accessors ([ee63f5eba3](https://github.com/InsightSoftwareConsortium/ITK/commit/ee63f5eba3))


### Dženan Zukić (1):

#### Platform Fixes

- Get ITK_USE_FLOAT_SPACE_PRECISION=ON to compile again ([e816336468](https://github.com/InsightSoftwareConsortium/ITK/commit/e816336468))


### Hans Johnson (1):

#### Platform Fixes

- macOS-11 Azure CI environment EOL ([e5de32ad02](https://github.com/InsightSoftwareConsortium/ITK/commit/e5de32ad02))


### Matt McCormick (25):

#### Enhancements

- Initial pixi configuration ([e2eef2d73d](https://github.com/InsightSoftwareConsortium/ITK/commit/e2eef2d73d))
- Add Pixi dev environment ([5037e7447c](https://github.com/InsightSoftwareConsortium/ITK/commit/5037e7447c))
- Add Pixi GitHub Actions Configuration ([bb705e50eb](https://github.com/InsightSoftwareConsortium/ITK/commit/bb705e50eb))
- Add Pixi python-exe and python-exe-debug tasks ([73841d0a89](https://github.com/InsightSoftwareConsortium/ITK/commit/73841d0a89))
- Python dispatch on the first RequiredInputName ([8185e10aab](https://github.com/InsightSoftwareConsortium/ITK/commit/8185e10aab))
- Add Pixi osx-64 configuration ([84a8386daa](https://github.com/InsightSoftwareConsortium/ITK/commit/84a8386daa))
- Add Intel Mac to Pixi GitHub Action tests ([7d759f2e4e](https://github.com/InsightSoftwareConsortium/ITK/commit/7d759f2e4e))
- Add Pixi mac ARM configuration ([0306e8e654](https://github.com/InsightSoftwareConsortium/ITK/commit/0306e8e654))
- Add ARM Mac to Pixi GitHub Action tests ([78a6cb7ca4](https://github.com/InsightSoftwareConsortium/ITK/commit/78a6cb7ca4))
- Bump ITK version to 5.4.2 ([898def6451](https://github.com/InsightSoftwareConsortium/ITK/commit/898def6451))

#### Documentation Updates

- Update .zenodo ([a890386f7d](https://github.com/InsightSoftwareConsortium/ITK/commit/a890386f7d))
- Improve itk_hdf5_mangle.h.in instructions ([c595d0b26b](https://github.com/InsightSoftwareConsortium/ITK/commit/c595d0b26b))
- Document development with Pixi ([1b75686e2c](https://github.com/InsightSoftwareConsortium/ITK/commit/1b75686e2c))
- Updates for release testing data uploads ([9a3a8d2961](https://github.com/InsightSoftwareConsortium/ITK/commit/9a3a8d2961))

#### Platform Fixes

- Set CastXML flag based on CMAKE_CXX_STANDARD ([9ebd1d6ff9](https://github.com/InsightSoftwareConsortium/ITK/commit/9ebd1d6ff9))
- Remove unused setuptools upgrade in Linux builds ([2734a97318](https://github.com/InsightSoftwareConsortium/ITK/commit/2734a97318))
- Bump ITKTotalVariation remote module ([da08898f21](https://github.com/InsightSoftwareConsortium/ITK/commit/da08898f21))
- Use .clang-format from release-5.4 branch ([6d3e550ba6](https://github.com/InsightSoftwareConsortium/ITK/commit/6d3e550ba6))

#### Bug Fixes

- Move InputSpaceName, OutputSpaceName from Transform to TransformBase ([107e3ad040](https://github.com/InsightSoftwareConsortium/ITK/commit/107e3ad040))
- Update HDF5 name mangled symbols ([be7d38694c](https://github.com/InsightSoftwareConsortium/ITK/commit/be7d38694c))
- Fix pixi caching of Python Debug builds ([0967a50721](https://github.com/InsightSoftwareConsortium/ITK/commit/0967a50721))
- GenerateImageSource sets Size from ReferenceImage ([c54f1b1a2b](https://github.com/InsightSoftwareConsortium/ITK/commit/c54f1b1a2b))

#### Style Changes

- clang-format fixes to itkSLICImageFilter.hxx ([d8614fa2c4](https://github.com/InsightSoftwareConsortium/ITK/commit/d8614fa2c4))
- clang-format updates to itkGridImageSourceTest2.cxx ([a54a6455e3](https://github.com/InsightSoftwareConsortium/ITK/commit/a54a6455e3))

### Mihail Isakov (1):

#### Bug Fixes

- Fix ExposeMetaData<std::vector<double>> im MetaImageIO ([087a1c4fb0](https://github.com/InsightSoftwareConsortium/ITK/commit/087a1c4fb0))


### Niels Dekker (3):

#### Enhancements

- Add nested CoordinateType aliases as alternative to CoordRepType ([bdfd0c2207](https://github.com/InsightSoftwareConsortium/ITK/commit/bdfd0c2207))
- Add ...CoordinateType aliases as alternative to ...CoordRepType ([be27beb8cb](https://github.com/InsightSoftwareConsortium/ITK/commit/be27beb8cb))

#### Bug Fixes

- `QuadEdgeMeshPoint` should be properly initialized by `{}` ([ef7521d2bd](https://github.com/InsightSoftwareConsortium/ITK/commit/ef7521d2bd))


### Ziv Yaniv (1):

#### Bug Fixes

- Missing writing of the nifti descrip field. ([9749611e77](https://github.com/InsightSoftwareConsortium/ITK/commit/9749611e77))


ITK Software Guide Changes Since v5.4.0
---------------------------------------------

### Dženan Zukić (2):

#### Documentation Updates

- Fix a typo in CreateAModule chapter ([1d04a60](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/1d04a60))
- Update supported compiler version information ([95b46fe](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/95b46fe))


### Matt McCormick (3):

#### Enhancements

- Bump ITK version to v5.4.0 ([c722c6a](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/c722c6a))

#### Documentation Updates

- Update ITK logo ([d341bad](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/d341bad))
- Update single PDF cover page for ITK 5.4.0 ([0e3ae9e](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/0e3ae9e))


### Niels Dekker (3):

#### Enhancements

- Add section "Initializing variables of fixed size array types" ([f10846c](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/f10846c))

#### Documentation Updates

- Describe `ITK_DEFAULT_COPY_AND_MOVE` ([8430b42](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/8430b42))

#### Platform Fixes

- Replace backticks with `\code{}` in Initialization and Assignment ([5246e64](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/5246e64))

Remote Module Changes Since v5.4.0
---------------------------------------------

## TotalVariation:
### Jon Haitz Legarreta Gorroño (1):

#### Enhancements

- Transition project configuration to `pyproject.toml` ([ad32c14](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/ad32c14))


### Matt McCormick (4):

#### Enhancements

- Bump CI configuration for ITK 5.4.0 ([2e7bcbe](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/2e7bcbe))

#### Platform Fixes

- Change from FetchContent_Populate to FetchContent_MakeAvailable ([a5484bd](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/a5484bd))
- Add find_package(OpenMP) to module export code ([a8ba12c](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/a8ba12c))

#### Bug Fixes

- Bump Python package version for re-deploy ([9f6654d](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/9f6654d))

