# Copyright (c) 2021, Shukant Pal and Contributors
# SPDX-License-Identifier: Apache-2.0

from enum import IntEnum


class GlInternalformat(IntEnum):
    """OpenGL internalformat constants."""

    R3_G3_B2 = 0x2A10
    RGB4 = 0x804F
    RGB5 = 0x8050
    RGB8 = 0x8051
    RGB10 = 0x8052
    RGB12 = 0x8053
    RGB16 = 0x8054
    RGBA2 = 0x8055
    RGBA4 = 0x8056
    RGB5_A1 = 0x8057
    RGBA8 = 0x8058
    RGB10_A2 = 0x8059
    RGBA12 = 0x805A
    RGBA16 = 0x805B

    COMPRESSED_RGB_S3TC_DXT1_EXT = 0x83F0
    COMPRESSED_RGBA_S3TC_DXT1_EXT = 0x83F1
    COMPRESSED_RGBA_S3TC_DXT3_EXT = 0x83F2
    COMPRESSED_RGBA_S3TC_DXT5_EXT = 0x83F3

    SRGB_EXT = 0x8C40
    SRGB8_EXT = 0x8C41
    SRGB_ALPHA_EXT = 0x8C42
    SRGB8_ALPHA8_EXT = 0x8C43
    SLUMINANCE_ALPHA_EXT = 0x8C44
    SLUMINANCE8_ALPHA8_EXT = 0x8C45
    SLUMINANCE_EXT = 0x8C46
    SLUMINANCE8_EXT = 0x8C47
    COMPRESSED_SRGB_EXT = 0x8C48
    COMPRESSED_SRGB_ALPHA_EXT = 0x8C49
    COMPRESSED_SLUMINANCE_EXT = 0x8C4A
    COMPRESSED_SLUMINANCE_ALPHA_EXT = 0x8C4B
    COMPRESSED_SRGB_S3TC_DXT1_EXT = 0x8C4C
    COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT = 0x8C4D
    COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT = 0x8C4E
    COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT = 0x8C4F

    COMPRESSED_RGB_PVRTC_4BPPV1_IMG = 0x8C00
    COMPRESSED_RGB_PVRTC_2BPPV1_IMG = 0x8C01
    COMPRESSED_RGBA_PVRTC_4BPPV1_IMG = 0x8C02
    COMPRESSED_RGBA_PVRTC_2BPPV1_IMG = 0x8C03

    ATC_RGB_AMD = 0x8C92
    ATC_RGBA_EXPLICIT_ALPHA_AMD = 0x8C93
    ATC_RGBA_INTERPOLATED_ALPHA_AMD = 0x87EE

    COMPRESSED_LUMINANCE_LATC1_EXT = 0x8C70
    COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT = 0x8C72
    COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT = 0x8C71
    COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT = 0x8C73

    ETC1_RGB8_OES = 0x8D64

    COMPRESSED_RGBA_BPTC_UNORM_EXT = 0x8E8C
    COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB = 0x8E8D
    COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB = 0x8E8E
    COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB = 0x8E8F

    COMPRESSED_RGB8_ETC2 = 0x9274
    COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9276
    COMPRESSED_RGBA8_ETC2_EAC = 0x9278
    COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 0x9279
    COMPRESSED_R11_EAC = 0x9270
    COMPRESSED_SIGNED_R11_EAC = 0x9271
    COMPRESSED_RG11_EAC = 0x9272
    COMPRESSED_SIGNED_RG11_EAC = 0x9273

    COMPRESSED_RGBA_ASTC_4x4_KHR = 0x93B0
    COMPRESSED_RGBA_ASTC_5x4_KHR = 0x93B1
    COMPRESSED_RGBA_ASTC_5x5_KHR = 0x93B2
    COMPRESSED_RGBA_ASTC_6x5_KHR = 0x93B3
    COMPRESSED_RGBA_ASTC_6x6_KHR = 0x93B4
    COMPRESSED_RGBA_ASTC_8x5_KHR = 0x93B5
    COMPRESSED_RGBA_ASTC_8x6_KHR = 0x93B6
    COMPRESSED_RGBA_ASTC_8x8_KHR = 0x93B7
    COMPRESSED_RGBA_ASTC_10x5_KHR = 0x93B8
    COMPRESSED_RGBA_ASTC_10x6_KHR = 0x93B9
    COMPRESSED_RGBA_ASTC_10x8_KHR = 0x93BA
    COMPRESSED_RGBA_ASTC_10x10_KHR = 0x93BB
    COMPRESSED_RGBA_ASTC_12x10_KHR = 0x93BC
    COMPRESSED_RGBA_ASTC_12x12_KHR = 0x93BD
    COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR = 0x93D0
    COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR = 0x93D1
    COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR = 0x93D2
    COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR = 0x93D3
    COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR = 0x93D4
    COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR = 0x93D5
    COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR = 0x93D6
    COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR = 0x93D7
    COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR = 0x93D8
    COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR = 0x93D9
    COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR = 0x93DA
    COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR = 0x93DB
    COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR = 0x93DC
    COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR = 0x93DD
