///////////////////////////////////////////////////////////////////////////////
//                                                         
// ListTest.cc - Testing the ListT template
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2002 by Bjoern Lemke                        
//
// IMPLEMENTATION MODULE
//
// 
// 
// Description: Testing the SetT class
//
///////////////////////////////////////////////////////////////////////////////

// #pragma implementation "ListT.h"

// INCLUDES
#include <stdlib.h>
#include <time.h>

#include "../src/Exception.h"
#include "../src/ListT.h"

// DEFINES

ostream& operator << (ostream& s, ListT<int>& x)
{

     int* pElement = x.First();
  
     s << "{";
     
     while (pElement)
     {      
	  s << *pElement ;
	  pElement = x.Next(); 
	  if (pElement)
	       s << ",";
     }
     s << "}";
     
     return s;
  
}

int main(int argc, char **argv)
{


    int numCheck = 4;
    int checkCount = 1;
    
    try {
	
	
	cout << "1.." << numCheck << endl;
		
	ListT<int> l1;
	
	l1.Insert(2);
	l1.Insert(10);
	l1.Insert(14);
	l1.Insert(35);
	l1.Insert(44);

	if ( l1.Size() == 5 )
	    cout << "ok " << checkCount << " - insert" << endl;
	else
	    cout << "not ok " << checkCount << " - insert" << endl;
	checkCount++;

	l1.Remove(35);
	l1.Remove(2);
	l1.Remove(44);

	if ( l1.Size() == 2 )
	    cout << "ok " << checkCount << " - remove" << endl;
	else
	    cout << "not ok " << checkCount << " - remove" << endl;
	checkCount++;
	
	/*
	cout << "Val before insert" << endl;
	int* pX = l1.First();
	while ( pX )
	{
	    cout << " Val = " << *pX << endl;;
	    pX = l1.Next();	    
	}
	*/
	l1.Insert(99);

	/*
	cout << "Val after insert" << endl;
	int* pY = l1.First();
	while ( pY )
	{
	    cout << " Val = " << *pY << endl;;
	    pY = l1.Next();	    
	}
	*/
	
	ListT<int> l2;
       
	l2.Insert(10);
	l2.Insert(14);
	l2.Insert(99);
	
	if ( l1 == l2 )
	    cout << "ok " << checkCount << " - list compare" << endl;
	else
	    cout << "not ok " << checkCount << " - list compare" << endl;
	checkCount++;


	int lastVal=0;
	int* pInt = l1.First();
	while ( pInt )
	{
	    lastVal = *pInt;
	    pInt = l1.Next();
	    
	}
	
	if ( lastVal == 99 )
	    cout << "ok " << checkCount << " - traverse" << endl;
	else
	    cout << "ok " << checkCount << " - traverse" << endl;
	checkCount++;
	
    }        
    catch (Exception e)
    {
	
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;          
}



