///////////////////////////////////////////////////////////////////////////////
//                                                         
// ShmTest.cc
// ----------
// Shared Meory class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 1996 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/SharedMemory.h"

#include <string.h>

int main(int argc, char **argv)
{


    int numCheck = 1;
    int checkCount = 1;
    
    try
    {
	
	cout << "1.." << numCheck << endl;

	SharedMemory myMem(12345);
	myMem.create(10000);
	char* ptr = (char*)myMem.getAddr();

	// mingw is just a dummy implementation
#ifndef HAVE_MINGW	
	char buf[1000];
	memcpy(buf, ptr, 1000);
#endif
	
	int id = myMem.getId();
	
	// myMem.printInfo();
	
	myMem.detach();
	myMem.attach();
	myMem.destroy();

	cout << "ok " << checkCount << " - shm test with id " << id << endl;
	checkCount++;
	
      
    }

    catch (Exception e)
    {
	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }
    
    return 0;

}

