#pragma once

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>
#include <libasr/asr_base_visitor.h>


namespace LCompilers::ASR {
/******************************************************************************/
// Statement Replacer Base class

template <class StructType>
class BaseStmtReplacer {
public:
    StructType& self() { return static_cast<StructType&>(*this); }

    ASR::stmt_t** current_stmt;
    ASR::stmt_t** current_stmt_copy;
    bool has_replacement_happened;

    BaseStmtReplacer() : current_stmt(nullptr), has_replacement_happened(false) {}


    void replace_Allocate(Allocate_t* x) {
        if (x) { }
    }


    void replace_ReAlloc(ReAlloc_t* x) {
        if (x) { }
    }


    void replace_Assign(Assign_t* x) {
        if (x) { }
    }


    void replace_Assignment(Assignment_t* x) {
        if (x) { }
    }


    void replace_Associate(Associate_t* x) {
        if (x) { }
    }


    void replace_Cycle(Cycle_t* x) {
        if (x) { }
    }


    void replace_ExplicitDeallocate(ExplicitDeallocate_t* x) {
        if (x) { }
    }


    void replace_ImplicitDeallocate(ImplicitDeallocate_t* x) {
        if (x) { }
    }


    void replace_DoConcurrentLoop(DoConcurrentLoop_t* x) {
        for (size_t i = 0; i < x->n_body; i++) {
            current_stmt_copy = current_stmt;
            current_stmt = &(x->m_body[i]);
            self().replace_stmt(x->m_body[i]);
            current_stmt = current_stmt_copy;
        }
    }


    void replace_DoLoop(DoLoop_t* x) {
        for (size_t i = 0; i < x->n_body; i++) {
            current_stmt_copy = current_stmt;
            current_stmt = &(x->m_body[i]);
            self().replace_stmt(x->m_body[i]);
            current_stmt = current_stmt_copy;
        }
        for (size_t i = 0; i < x->n_orelse; i++) {
            current_stmt_copy = current_stmt;
            current_stmt = &(x->m_orelse[i]);
            self().replace_stmt(x->m_orelse[i]);
            current_stmt = current_stmt_copy;
        }
    }


    void replace_ErrorStop(ErrorStop_t* x) {
        if (x) { }
    }


    void replace_Exit(Exit_t* x) {
        if (x) { }
    }


    void replace_ForAllSingle(ForAllSingle_t* x) {
        if (x) { }
    }


    void replace_GoTo(GoTo_t* x) {
        if (x) { }
    }


    void replace_GoToTarget(GoToTarget_t* x) {
        if (x) { }
    }


    void replace_If(If_t* x) {
        for (size_t i = 0; i < x->n_body; i++) {
            current_stmt_copy = current_stmt;
            current_stmt = &(x->m_body[i]);
            self().replace_stmt(x->m_body[i]);
            current_stmt = current_stmt_copy;
        }
        for (size_t i = 0; i < x->n_orelse; i++) {
            current_stmt_copy = current_stmt;
            current_stmt = &(x->m_orelse[i]);
            self().replace_stmt(x->m_orelse[i]);
            current_stmt = current_stmt_copy;
        }
    }


    void replace_IfArithmetic(IfArithmetic_t* x) {
        if (x) { }
    }


    void replace_Print(Print_t* x) {
        if (x) { }
    }


    void replace_FileOpen(FileOpen_t* x) {
        if (x) { }
    }


    void replace_FileClose(FileClose_t* x) {
        if (x) { }
    }


    void replace_FileRead(FileRead_t* x) {
        if (x) { }
    }


    void replace_FileBackspace(FileBackspace_t* x) {
        if (x) { }
    }


    void replace_FileRewind(FileRewind_t* x) {
        if (x) { }
    }


    void replace_FileInquire(FileInquire_t* x) {
        if (x) { }
    }


    void replace_FileWrite(FileWrite_t* x) {
        if (x) { }
    }


    void replace_Return(Return_t* x) {
        if (x) { }
    }


    void replace_Select(Select_t* x) {
        for (size_t i = 0; i < x->n_default; i++) {
            current_stmt_copy = current_stmt;
            current_stmt = &(x->m_default[i]);
            self().replace_stmt(x->m_default[i]);
            current_stmt = current_stmt_copy;
        }
    }


    void replace_Stop(Stop_t* x) {
        if (x) { }
    }


    void replace_Assert(Assert_t* x) {
        if (x) { }
    }


    void replace_SubroutineCall(SubroutineCall_t* x) {
        if (x) { }
    }


    void replace_IntrinsicImpureSubroutine(IntrinsicImpureSubroutine_t* x) {
        if (x) { }
    }


    void replace_Where(Where_t* x) {
        for (size_t i = 0; i < x->n_body; i++) {
            current_stmt_copy = current_stmt;
            current_stmt = &(x->m_body[i]);
            self().replace_stmt(x->m_body[i]);
            current_stmt = current_stmt_copy;
        }
        for (size_t i = 0; i < x->n_orelse; i++) {
            current_stmt_copy = current_stmt;
            current_stmt = &(x->m_orelse[i]);
            self().replace_stmt(x->m_orelse[i]);
            current_stmt = current_stmt_copy;
        }
    }


    void replace_WhileLoop(WhileLoop_t* x) {
        for (size_t i = 0; i < x->n_body; i++) {
            current_stmt_copy = current_stmt;
            current_stmt = &(x->m_body[i]);
            self().replace_stmt(x->m_body[i]);
            current_stmt = current_stmt_copy;
        }
        for (size_t i = 0; i < x->n_orelse; i++) {
            current_stmt_copy = current_stmt;
            current_stmt = &(x->m_orelse[i]);
            self().replace_stmt(x->m_orelse[i]);
            current_stmt = current_stmt_copy;
        }
    }


    void replace_Nullify(Nullify_t* x) {
        if (x) { }
    }


    void replace_Flush(Flush_t* x) {
        if (x) { }
    }


    void replace_ListAppend(ListAppend_t* x) {
        if (x) { }
    }


    void replace_AssociateBlockCall(AssociateBlockCall_t* x) {
        if (x) { }
    }


    void replace_SelectType(SelectType_t* x) {
        for (size_t i = 0; i < x->n_default; i++) {
            current_stmt_copy = current_stmt;
            current_stmt = &(x->m_default[i]);
            self().replace_stmt(x->m_default[i]);
            current_stmt = current_stmt_copy;
        }
    }


    void replace_CPtrToPointer(CPtrToPointer_t* x) {
        if (x) { }
    }


    void replace_BlockCall(BlockCall_t* x) {
        if (x) { }
    }


    void replace_SetInsert(SetInsert_t* x) {
        if (x) { }
    }


    void replace_SetRemove(SetRemove_t* x) {
        if (x) { }
    }


    void replace_ListInsert(ListInsert_t* x) {
        if (x) { }
    }


    void replace_ListRemove(ListRemove_t* x) {
        if (x) { }
    }


    void replace_ListClear(ListClear_t* x) {
        if (x) { }
    }


    void replace_DictInsert(DictInsert_t* x) {
        if (x) { }
    }


    void replace_Expr(Expr_t* x) {
        if (x) { }
    }

    void replace_stmt(ASR::stmt_t* x) {
        if( !x ) {
            return ;
        }

        switch(x->type) {
            case ASR::stmtType::Allocate: {
                self().replace_Allocate(down_cast<ASR::Allocate_t>(x));
                break;
            }
            case ASR::stmtType::ReAlloc: {
                self().replace_ReAlloc(down_cast<ASR::ReAlloc_t>(x));
                break;
            }
            case ASR::stmtType::Assign: {
                self().replace_Assign(down_cast<ASR::Assign_t>(x));
                break;
            }
            case ASR::stmtType::Assignment: {
                self().replace_Assignment(down_cast<ASR::Assignment_t>(x));
                break;
            }
            case ASR::stmtType::Associate: {
                self().replace_Associate(down_cast<ASR::Associate_t>(x));
                break;
            }
            case ASR::stmtType::Cycle: {
                self().replace_Cycle(down_cast<ASR::Cycle_t>(x));
                break;
            }
            case ASR::stmtType::ExplicitDeallocate: {
                self().replace_ExplicitDeallocate(down_cast<ASR::ExplicitDeallocate_t>(x));
                break;
            }
            case ASR::stmtType::ImplicitDeallocate: {
                self().replace_ImplicitDeallocate(down_cast<ASR::ImplicitDeallocate_t>(x));
                break;
            }
            case ASR::stmtType::DoConcurrentLoop: {
                self().replace_DoConcurrentLoop(down_cast<ASR::DoConcurrentLoop_t>(x));
                break;
            }
            case ASR::stmtType::DoLoop: {
                self().replace_DoLoop(down_cast<ASR::DoLoop_t>(x));
                break;
            }
            case ASR::stmtType::ErrorStop: {
                self().replace_ErrorStop(down_cast<ASR::ErrorStop_t>(x));
                break;
            }
            case ASR::stmtType::Exit: {
                self().replace_Exit(down_cast<ASR::Exit_t>(x));
                break;
            }
            case ASR::stmtType::ForAllSingle: {
                self().replace_ForAllSingle(down_cast<ASR::ForAllSingle_t>(x));
                break;
            }
            case ASR::stmtType::GoTo: {
                self().replace_GoTo(down_cast<ASR::GoTo_t>(x));
                break;
            }
            case ASR::stmtType::GoToTarget: {
                self().replace_GoToTarget(down_cast<ASR::GoToTarget_t>(x));
                break;
            }
            case ASR::stmtType::If: {
                self().replace_If(down_cast<ASR::If_t>(x));
                break;
            }
            case ASR::stmtType::IfArithmetic: {
                self().replace_IfArithmetic(down_cast<ASR::IfArithmetic_t>(x));
                break;
            }
            case ASR::stmtType::Print: {
                self().replace_Print(down_cast<ASR::Print_t>(x));
                break;
            }
            case ASR::stmtType::FileOpen: {
                self().replace_FileOpen(down_cast<ASR::FileOpen_t>(x));
                break;
            }
            case ASR::stmtType::FileClose: {
                self().replace_FileClose(down_cast<ASR::FileClose_t>(x));
                break;
            }
            case ASR::stmtType::FileRead: {
                self().replace_FileRead(down_cast<ASR::FileRead_t>(x));
                break;
            }
            case ASR::stmtType::FileBackspace: {
                self().replace_FileBackspace(down_cast<ASR::FileBackspace_t>(x));
                break;
            }
            case ASR::stmtType::FileRewind: {
                self().replace_FileRewind(down_cast<ASR::FileRewind_t>(x));
                break;
            }
            case ASR::stmtType::FileInquire: {
                self().replace_FileInquire(down_cast<ASR::FileInquire_t>(x));
                break;
            }
            case ASR::stmtType::FileWrite: {
                self().replace_FileWrite(down_cast<ASR::FileWrite_t>(x));
                break;
            }
            case ASR::stmtType::Return: {
                self().replace_Return(down_cast<ASR::Return_t>(x));
                break;
            }
            case ASR::stmtType::Select: {
                self().replace_Select(down_cast<ASR::Select_t>(x));
                break;
            }
            case ASR::stmtType::Stop: {
                self().replace_Stop(down_cast<ASR::Stop_t>(x));
                break;
            }
            case ASR::stmtType::Assert: {
                self().replace_Assert(down_cast<ASR::Assert_t>(x));
                break;
            }
            case ASR::stmtType::SubroutineCall: {
                self().replace_SubroutineCall(down_cast<ASR::SubroutineCall_t>(x));
                break;
            }
            case ASR::stmtType::IntrinsicImpureSubroutine: {
                self().replace_IntrinsicImpureSubroutine(down_cast<ASR::IntrinsicImpureSubroutine_t>(x));
                break;
            }
            case ASR::stmtType::Where: {
                self().replace_Where(down_cast<ASR::Where_t>(x));
                break;
            }
            case ASR::stmtType::WhileLoop: {
                self().replace_WhileLoop(down_cast<ASR::WhileLoop_t>(x));
                break;
            }
            case ASR::stmtType::Nullify: {
                self().replace_Nullify(down_cast<ASR::Nullify_t>(x));
                break;
            }
            case ASR::stmtType::Flush: {
                self().replace_Flush(down_cast<ASR::Flush_t>(x));
                break;
            }
            case ASR::stmtType::ListAppend: {
                self().replace_ListAppend(down_cast<ASR::ListAppend_t>(x));
                break;
            }
            case ASR::stmtType::AssociateBlockCall: {
                self().replace_AssociateBlockCall(down_cast<ASR::AssociateBlockCall_t>(x));
                break;
            }
            case ASR::stmtType::SelectType: {
                self().replace_SelectType(down_cast<ASR::SelectType_t>(x));
                break;
            }
            case ASR::stmtType::CPtrToPointer: {
                self().replace_CPtrToPointer(down_cast<ASR::CPtrToPointer_t>(x));
                break;
            }
            case ASR::stmtType::BlockCall: {
                self().replace_BlockCall(down_cast<ASR::BlockCall_t>(x));
                break;
            }
            case ASR::stmtType::SetInsert: {
                self().replace_SetInsert(down_cast<ASR::SetInsert_t>(x));
                break;
            }
            case ASR::stmtType::SetRemove: {
                self().replace_SetRemove(down_cast<ASR::SetRemove_t>(x));
                break;
            }
            case ASR::stmtType::ListInsert: {
                self().replace_ListInsert(down_cast<ASR::ListInsert_t>(x));
                break;
            }
            case ASR::stmtType::ListRemove: {
                self().replace_ListRemove(down_cast<ASR::ListRemove_t>(x));
                break;
            }
            case ASR::stmtType::ListClear: {
                self().replace_ListClear(down_cast<ASR::ListClear_t>(x));
                break;
            }
            case ASR::stmtType::DictInsert: {
                self().replace_DictInsert(down_cast<ASR::DictInsert_t>(x));
                break;
            }
            case ASR::stmtType::Expr: {
                self().replace_Expr(down_cast<ASR::Expr_t>(x));
                break;
            }
            default: {
                LCOMPILERS_ASSERT_MSG(false, "Replacement of " + std::to_string(x->type) + " statement is not supported yet.");
            }
        }

    }

};


}
