#pragma once

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>
#include <libasr/asr_base_visitor.h>


namespace LCompilers::ASR {
/******************************************************************************/
// Walk Visitor base class

template <class StructType>
class BaseWalkVisitor : public BaseVisitor<StructType>
{
private:
    StructType& self() { return static_cast<StructType&>(*this); }
public:
    bool visit_compile_time_value = true;
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
    }
    void visit_Program(const Program_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_Module(const Module_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
    }
    void visit_Function(const Function_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        self().visit_ttype(*x.m_function_signature);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        if (x.m_return_var)
            self().visit_expr(*x.m_return_var);
    }
    void visit_GenericProcedure(const GenericProcedure_t &x) {
        for (size_t i=0; i<x.n_procs; i++) {
        }
    }
    void visit_CustomOperator(const CustomOperator_t &x) {
        for (size_t i=0; i<x.n_procs; i++) {
        }
    }
    void visit_ExternalSymbol(const ExternalSymbol_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Struct(const Struct_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_initializers; i++) {
            self().visit_call_arg(x.m_initializers[i]);
        }
        if (x.m_alignment)
            self().visit_expr(*x.m_alignment);
    }
    void visit_Enum(const Enum_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_Union(const Union_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_initializers; i++) {
            self().visit_call_arg(x.m_initializers[i]);
        }
    }
    void visit_Variable(const Variable_t &x) {
        if (x.m_symbolic_value)
            self().visit_expr(*x.m_symbolic_value);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
        self().visit_ttype(*x.m_type);
    }
    void visit_Class(const Class_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
    }
    void visit_ClassProcedure(const ClassProcedure_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AssociateBlock(const AssociateBlock_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_Block(const Block_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_Requirement(const Requirement_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_requires; i++) {
            self().visit_require_instantiation(*x.m_requires[i]);
        }
    }
    void visit_Template(const Template_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_requires; i++) {
            self().visit_require_instantiation(*x.m_requires[i]);
        }
    }
    void visit_Allocate(const Allocate_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_alloc_arg(x.m_args[i]);
        }
        if (x.m_stat)
            self().visit_expr(*x.m_stat);
        if (x.m_errmsg)
            self().visit_expr(*x.m_errmsg);
        if (x.m_source)
            self().visit_expr(*x.m_source);
    }
    void visit_ReAlloc(const ReAlloc_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_alloc_arg(x.m_args[i]);
        }
    }
    void visit_Assign(const Assign_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assignment(const Assignment_t &x) {
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_value);
        if (x.m_overloaded)
            self().visit_stmt(*x.m_overloaded);
    }
    void visit_Associate(const Associate_t &x) {
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_value);
    }
    void visit_Cycle(const Cycle_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ExplicitDeallocate(const ExplicitDeallocate_t &x) {
        for (size_t i=0; i<x.n_vars; i++) {
            self().visit_expr(*x.m_vars[i]);
        }
    }
    void visit_ImplicitDeallocate(const ImplicitDeallocate_t &x) {
        for (size_t i=0; i<x.n_vars; i++) {
            self().visit_expr(*x.m_vars[i]);
        }
    }
    void visit_DoConcurrentLoop(const DoConcurrentLoop_t &x) {
        for (size_t i=0; i<x.n_head; i++) {
            self().visit_do_loop_head(x.m_head[i]);
        }
        for (size_t i=0; i<x.n_shared; i++) {
            self().visit_expr(*x.m_shared[i]);
        }
        for (size_t i=0; i<x.n_local; i++) {
            self().visit_expr(*x.m_local[i]);
        }
        for (size_t i=0; i<x.n_reduction; i++) {
            self().visit_reduction_expr(x.m_reduction[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_DoLoop(const DoLoop_t &x) {
        self().visit_do_loop_head(x.m_head);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        if (x.m_code)
            self().visit_expr(*x.m_code);
    }
    void visit_Exit(const Exit_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ForAllSingle(const ForAllSingle_t &x) {
        self().visit_do_loop_head(x.m_head);
        self().visit_stmt(*x.m_assign_stmt);
    }
    void visit_ForEach(const ForEach_t &x) {
        self().visit_expr(*x.m_var);
        self().visit_expr(*x.m_container);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_GoTo(const GoTo_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GoToTarget(const GoToTarget_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_If(const If_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
    }
    void visit_IfArithmetic(const IfArithmetic_t &x) {
        self().visit_expr(*x.m_test);
    }
    void visit_Print(const Print_t &x) {
        self().visit_expr(*x.m_text);
    }
    void visit_FileOpen(const FileOpen_t &x) {
        if (x.m_newunit)
            self().visit_expr(*x.m_newunit);
        if (x.m_filename)
            self().visit_expr(*x.m_filename);
        if (x.m_status)
            self().visit_expr(*x.m_status);
        if (x.m_form)
            self().visit_expr(*x.m_form);
        if (x.m_access)
            self().visit_expr(*x.m_access);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
        if (x.m_iomsg)
            self().visit_expr(*x.m_iomsg);
    }
    void visit_FileClose(const FileClose_t &x) {
        if (x.m_unit)
            self().visit_expr(*x.m_unit);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
        if (x.m_iomsg)
            self().visit_expr(*x.m_iomsg);
        if (x.m_err)
            self().visit_expr(*x.m_err);
        if (x.m_status)
            self().visit_expr(*x.m_status);
    }
    void visit_FileRead(const FileRead_t &x) {
        if (x.m_unit)
            self().visit_expr(*x.m_unit);
        if (x.m_fmt)
            self().visit_expr(*x.m_fmt);
        if (x.m_iomsg)
            self().visit_expr(*x.m_iomsg);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
        if (x.m_advance)
            self().visit_expr(*x.m_advance);
        if (x.m_size)
            self().visit_expr(*x.m_size);
        if (x.m_id)
            self().visit_expr(*x.m_id);
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        if (x.m_overloaded)
            self().visit_stmt(*x.m_overloaded);
    }
    void visit_FileBackspace(const FileBackspace_t &x) {
        if (x.m_unit)
            self().visit_expr(*x.m_unit);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
        if (x.m_err)
            self().visit_expr(*x.m_err);
    }
    void visit_FileRewind(const FileRewind_t &x) {
        if (x.m_unit)
            self().visit_expr(*x.m_unit);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
        if (x.m_err)
            self().visit_expr(*x.m_err);
    }
    void visit_FileInquire(const FileInquire_t &x) {
        if (x.m_unit)
            self().visit_expr(*x.m_unit);
        if (x.m_file)
            self().visit_expr(*x.m_file);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
        if (x.m_err)
            self().visit_expr(*x.m_err);
        if (x.m_exist)
            self().visit_expr(*x.m_exist);
        if (x.m_opened)
            self().visit_expr(*x.m_opened);
        if (x.m_number)
            self().visit_expr(*x.m_number);
        if (x.m_named)
            self().visit_expr(*x.m_named);
        if (x.m_name)
            self().visit_expr(*x.m_name);
        if (x.m_access)
            self().visit_expr(*x.m_access);
        if (x.m_sequential)
            self().visit_expr(*x.m_sequential);
        if (x.m_direct)
            self().visit_expr(*x.m_direct);
        if (x.m_form)
            self().visit_expr(*x.m_form);
        if (x.m_formatted)
            self().visit_expr(*x.m_formatted);
        if (x.m_unformatted)
            self().visit_expr(*x.m_unformatted);
        if (x.m_recl)
            self().visit_expr(*x.m_recl);
        if (x.m_nextrec)
            self().visit_expr(*x.m_nextrec);
        if (x.m_blank)
            self().visit_expr(*x.m_blank);
        if (x.m_position)
            self().visit_expr(*x.m_position);
        if (x.m_action)
            self().visit_expr(*x.m_action);
        if (x.m_read)
            self().visit_expr(*x.m_read);
        if (x.m_write)
            self().visit_expr(*x.m_write);
        if (x.m_readwrite)
            self().visit_expr(*x.m_readwrite);
        if (x.m_delim)
            self().visit_expr(*x.m_delim);
        if (x.m_pad)
            self().visit_expr(*x.m_pad);
        if (x.m_flen)
            self().visit_expr(*x.m_flen);
        if (x.m_blocksize)
            self().visit_expr(*x.m_blocksize);
        if (x.m_convert)
            self().visit_expr(*x.m_convert);
        if (x.m_carriagecontrol)
            self().visit_expr(*x.m_carriagecontrol);
        if (x.m_size)
            self().visit_expr(*x.m_size);
        if (x.m_pos)
            self().visit_expr(*x.m_pos);
        if (x.m_iolength)
            self().visit_expr(*x.m_iolength);
    }
    void visit_FileWrite(const FileWrite_t &x) {
        if (x.m_unit)
            self().visit_expr(*x.m_unit);
        if (x.m_iomsg)
            self().visit_expr(*x.m_iomsg);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
        if (x.m_id)
            self().visit_expr(*x.m_id);
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        if (x.m_separator)
            self().visit_expr(*x.m_separator);
        if (x.m_end)
            self().visit_expr(*x.m_end);
        if (x.m_overloaded)
            self().visit_stmt(*x.m_overloaded);
    }
    void visit_Return(const Return_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Select(const Select_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_case_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_default; i++) {
            self().visit_stmt(*x.m_default[i]);
        }
    }
    void visit_Stop(const Stop_t &x) {
        if (x.m_code)
            self().visit_expr(*x.m_code);
    }
    void visit_Assert(const Assert_t &x) {
        self().visit_expr(*x.m_test);
        if (x.m_msg)
            self().visit_expr(*x.m_msg);
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        if (x.m_dt)
            self().visit_expr(*x.m_dt);
    }
    void visit_IntrinsicImpureSubroutine(const IntrinsicImpureSubroutine_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
    }
    void visit_Where(const Where_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
    }
    void visit_Nullify(const Nullify_t &x) {
        for (size_t i=0; i<x.n_vars; i++) {
            self().visit_expr(*x.m_vars[i]);
        }
    }
    void visit_Flush(const Flush_t &x) {
        self().visit_expr(*x.m_unit);
        if (x.m_err)
            self().visit_expr(*x.m_err);
        if (x.m_iomsg)
            self().visit_expr(*x.m_iomsg);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
    }
    void visit_ListAppend(const ListAppend_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_ele);
    }
    void visit_AssociateBlockCall(const AssociateBlockCall_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SelectType(const SelectType_t &x) {
        self().visit_expr(*x.m_selector);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_type_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_default; i++) {
            self().visit_stmt(*x.m_default[i]);
        }
    }
    void visit_CPtrToPointer(const CPtrToPointer_t &x) {
        self().visit_expr(*x.m_cptr);
        self().visit_expr(*x.m_ptr);
        if (x.m_shape)
            self().visit_expr(*x.m_shape);
        if (x.m_lower_bounds)
            self().visit_expr(*x.m_lower_bounds);
    }
    void visit_BlockCall(const BlockCall_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SetInsert(const SetInsert_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_ele);
    }
    void visit_SetRemove(const SetRemove_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_ele);
    }
    void visit_ListInsert(const ListInsert_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_pos);
        self().visit_expr(*x.m_ele);
    }
    void visit_ListRemove(const ListRemove_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_ele);
    }
    void visit_ListClear(const ListClear_t &x) {
        self().visit_expr(*x.m_a);
    }
    void visit_DictInsert(const DictInsert_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_key);
        self().visit_expr(*x.m_value);
    }
    void visit_DictClear(const DictClear_t &x) {
        self().visit_expr(*x.m_a);
    }
    void visit_SetClear(const SetClear_t &x) {
        self().visit_expr(*x.m_a);
    }
    void visit_Expr(const Expr_t &x) {
        self().visit_expr(*x.m_expression);
    }
    void visit_IfExp(const IfExp_t &x) {
        self().visit_expr(*x.m_test);
        self().visit_expr(*x.m_body);
        self().visit_expr(*x.m_orelse);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ComplexConstructor(const ComplexConstructor_t &x) {
        self().visit_expr(*x.m_re);
        self().visit_expr(*x.m_im);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_NamedExpr(const NamedExpr_t &x) {
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_value);
        self().visit_ttype(*x.m_type);
    }
    void visit_FunctionCall(const FunctionCall_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
        if (x.m_dt)
            self().visit_expr(*x.m_dt);
    }
    void visit_IntrinsicElementalFunction(const IntrinsicElementalFunction_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        if (x.m_type)
            self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_IntrinsicArrayFunction(const IntrinsicArrayFunction_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        if (x.m_type)
            self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_IntrinsicImpureFunction(const IntrinsicImpureFunction_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        if (x.m_type)
            self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_TypeInquiry(const TypeInquiry_t &x) {
        self().visit_ttype(*x.m_arg_type);
        if (x.m_arg)
            self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        self().visit_expr(*x.m_value);
    }
    void visit_StructConstructor(const StructConstructor_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StructConstant(const StructConstant_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_EnumConstructor(const EnumConstructor_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_UnionConstructor(const UnionConstructor_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ImpliedDoLoop(const ImpliedDoLoop_t &x) {
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        self().visit_expr(*x.m_var);
        self().visit_expr(*x.m_start);
        self().visit_expr(*x.m_end);
        if (x.m_increment)
            self().visit_expr(*x.m_increment);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_IntegerConstant(const IntegerConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_IntegerBitNot(const IntegerBitNot_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_IntegerUnaryMinus(const IntegerUnaryMinus_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_IntegerCompare(const IntegerCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_IntegerBinOp(const IntegerBinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_UnsignedIntegerConstant(const UnsignedIntegerConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_UnsignedIntegerUnaryMinus(const UnsignedIntegerUnaryMinus_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_UnsignedIntegerBitNot(const UnsignedIntegerBitNot_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_UnsignedIntegerCompare(const UnsignedIntegerCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_UnsignedIntegerBinOp(const UnsignedIntegerBinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_RealConstant(const RealConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_RealUnaryMinus(const RealUnaryMinus_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_RealCompare(const RealCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_RealBinOp(const RealBinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_RealCopySign(const RealCopySign_t &x) {
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_source);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ComplexConstant(const ComplexConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_ComplexUnaryMinus(const ComplexUnaryMinus_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ComplexCompare(const ComplexCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ComplexBinOp(const ComplexBinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_LogicalConstant(const LogicalConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_LogicalNot(const LogicalNot_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_LogicalCompare(const LogicalCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_LogicalBinOp(const LogicalBinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListConstant(const ListConstant_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_ListLen(const ListLen_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListConcat(const ListConcat_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListCompare(const ListCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListCount(const ListCount_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_expr(*x.m_ele);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListContains(const ListContains_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_SetConstant(const SetConstant_t &x) {
        for (size_t i=0; i<x.n_elements; i++) {
            self().visit_expr(*x.m_elements[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_SetLen(const SetLen_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_TupleConstant(const TupleConstant_t &x) {
        for (size_t i=0; i<x.n_elements; i++) {
            self().visit_expr(*x.m_elements[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_TupleLen(const TupleLen_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        self().visit_expr(*x.m_value);
    }
    void visit_TupleCompare(const TupleCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_TupleConcat(const TupleConcat_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_TupleContains(const TupleContains_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringConstant(const StringConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_StringConcat(const StringConcat_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringRepeat(const StringRepeat_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringLen(const StringLen_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringItem(const StringItem_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_expr(*x.m_idx);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringSection(const StringSection_t &x) {
        self().visit_expr(*x.m_arg);
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_end)
            self().visit_expr(*x.m_end);
        if (x.m_step)
            self().visit_expr(*x.m_step);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringCompare(const StringCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringContains(const StringContains_t &x) {
        self().visit_expr(*x.m_substr);
        self().visit_expr(*x.m_str);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringOrd(const StringOrd_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringChr(const StringChr_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringFormat(const StringFormat_t &x) {
        if (x.m_fmt)
            self().visit_expr(*x.m_fmt);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringPhysicalCast(const StringPhysicalCast_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_CPtrCompare(const CPtrCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_SymbolicCompare(const SymbolicCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_DictConstant(const DictConstant_t &x) {
        for (size_t i=0; i<x.n_keys; i++) {
            self().visit_expr(*x.m_keys[i]);
        }
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_DictLen(const DictLen_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_Var(const Var_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FunctionParam(const FunctionParam_t &x) {
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayConstructor(const ArrayConstructor_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayConstant(const ArrayConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_ArrayItem(const ArrayItem_t &x) {
        self().visit_expr(*x.m_v);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_array_index(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArraySection(const ArraySection_t &x) {
        self().visit_expr(*x.m_v);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_array_index(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArraySize(const ArraySize_t &x) {
        self().visit_expr(*x.m_v);
        if (x.m_dim)
            self().visit_expr(*x.m_dim);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayBound(const ArrayBound_t &x) {
        self().visit_expr(*x.m_v);
        if (x.m_dim)
            self().visit_expr(*x.m_dim);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayTranspose(const ArrayTranspose_t &x) {
        self().visit_expr(*x.m_matrix);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayPack(const ArrayPack_t &x) {
        self().visit_expr(*x.m_array);
        self().visit_expr(*x.m_mask);
        if (x.m_vector)
            self().visit_expr(*x.m_vector);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayReshape(const ArrayReshape_t &x) {
        self().visit_expr(*x.m_array);
        self().visit_expr(*x.m_shape);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayBroadcast(const ArrayBroadcast_t &x) {
        self().visit_expr(*x.m_array);
        self().visit_expr(*x.m_shape);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_BitCast(const BitCast_t &x) {
        self().visit_expr(*x.m_source);
        self().visit_expr(*x.m_mold);
        if (x.m_size)
            self().visit_expr(*x.m_size);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StructInstanceMember(const StructInstanceMember_t &x) {
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StructStaticMember(const StructStaticMember_t &x) {
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_EnumStaticMember(const EnumStaticMember_t &x) {
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_UnionInstanceMember(const UnionInstanceMember_t &x) {
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_EnumName(const EnumName_t &x) {
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_enum_type);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_EnumValue(const EnumValue_t &x) {
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_enum_type);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_OverloadedCompare(const OverloadedCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
        self().visit_expr(*x.m_overloaded);
    }
    void visit_OverloadedBinOp(const OverloadedBinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
        self().visit_expr(*x.m_overloaded);
    }
    void visit_OverloadedUnaryMinus(const OverloadedUnaryMinus_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
        self().visit_expr(*x.m_overloaded);
    }
    void visit_OverloadedStringConcat(const OverloadedStringConcat_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
        self().visit_expr(*x.m_overloaded);
    }
    void visit_Cast(const Cast_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayPhysicalCast(const ArrayPhysicalCast_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ComplexRe(const ComplexRe_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ComplexIm(const ComplexIm_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_DictItem(const DictItem_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_key);
        if (x.m_default)
            self().visit_expr(*x.m_default);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_CLoc(const CLoc_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_PointerToCPtr(const PointerToCPtr_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_GetPointer(const GetPointer_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListItem(const ListItem_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_pos);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_TupleItem(const TupleItem_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_pos);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListSection(const ListSection_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_array_index(x.m_section);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListRepeat(const ListRepeat_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_DictPop(const DictPop_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_key);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_SetPop(const SetPop_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_SetContains(const SetContains_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_DictContains(const DictContains_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_IntegerBitLen(const IntegerBitLen_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_Ichar(const Ichar_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_Iachar(const Iachar_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_SizeOfType(const SizeOfType_t &x) {
        self().visit_ttype(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_PointerNullConstant(const PointerNullConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_PointerAssociated(const PointerAssociated_t &x) {
        self().visit_expr(*x.m_ptr);
        if (x.m_tgt)
            self().visit_expr(*x.m_tgt);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_RealSqrt(const RealSqrt_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayIsContiguous(const ArrayIsContiguous_t &x) {
        self().visit_expr(*x.m_array);
        self().visit_ttype(*x.m_type);
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_Integer(const Integer_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedInteger(const UnsignedInteger_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Real(const Real_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Complex(const Complex_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_String(const String_t &x) {
        if (x.m_len_expr)
            self().visit_expr(*x.m_len_expr);
    }
    void visit_Logical(const Logical_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Set(const Set_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_List(const List_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_Tuple(const Tuple_t &x) {
        for (size_t i=0; i<x.n_type; i++) {
            self().visit_ttype(*x.m_type[i]);
        }
    }
    void visit_StructType(const StructType_t &x) {
        for (size_t i=0; i<x.n_data_member_types; i++) {
            self().visit_ttype(*x.m_data_member_types[i]);
        }
        for (size_t i=0; i<x.n_member_function_types; i++) {
            self().visit_ttype(*x.m_member_function_types[i]);
        }
    }
    void visit_EnumType(const EnumType_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnionType(const UnionType_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ClassType(const ClassType_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Dict(const Dict_t &x) {
        self().visit_ttype(*x.m_key_type);
        self().visit_ttype(*x.m_value_type);
    }
    void visit_Pointer(const Pointer_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_Allocatable(const Allocatable_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_CPtr(const CPtr_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SymbolicExpression(const SymbolicExpression_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeParameter(const TypeParameter_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Array(const Array_t &x) {
        self().visit_ttype(*x.m_type);
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
        }
    }
    void visit_FunctionType(const FunctionType_t &x) {
        for (size_t i=0; i<x.n_arg_types; i++) {
            self().visit_ttype(*x.m_arg_types[i]);
        }
        if (x.m_return_var_type)
            self().visit_ttype(*x.m_return_var_type);
        for (size_t i=0; i<x.n_restrictions; i++) {
        }
    }
    void visit_dimension(const dimension_t &x) {
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_length)
            self().visit_expr(*x.m_length);
    }
    void visit_alloc_arg(const alloc_arg_t &x) {
        self().visit_expr(*x.m_a);
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
        }
        if (x.m_len_expr)
            self().visit_expr(*x.m_len_expr);
        if (x.m_type)
            self().visit_ttype(*x.m_type);
    }
    void visit_Attribute(const Attribute_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_attribute_arg(x.m_args[i]);
        }
    }
    void visit_attribute_arg(const attribute_arg_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_call_arg(const call_arg_t &x) {
        if (x.m_value && visit_compile_time_value)
            self().visit_expr(*x.m_value);
    }
    void visit_reduction_expr(const reduction_expr_t &x) {
        self().visit_expr(*x.m_arg);
    }
    void visit_Bind(const Bind_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_index(const array_index_t &x) {
        if (x.m_left)
            self().visit_expr(*x.m_left);
        if (x.m_right)
            self().visit_expr(*x.m_right);
        if (x.m_step)
            self().visit_expr(*x.m_step);
    }
    void visit_do_loop_head(const do_loop_head_t &x) {
        if (x.m_v)
            self().visit_expr(*x.m_v);
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_end)
            self().visit_expr(*x.m_end);
        if (x.m_increment)
            self().visit_expr(*x.m_increment);
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        for (size_t i=0; i<x.n_test; i++) {
            self().visit_expr(*x.m_test[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_CaseStmt_Range(const CaseStmt_Range_t &x) {
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_end)
            self().visit_expr(*x.m_end);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_TypeStmtName(const TypeStmtName_t &x) {
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_ClassStmt(const ClassStmt_t &x) {
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_TypeStmtType(const TypeStmtType_t &x) {
        self().visit_ttype(*x.m_type);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_Require(const Require_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
};


}
