/*++

Copyright (C) 2019 3MF Consortium

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Abstract:

NMR_Architecture_Utils.h defines helper functions for working on big-endian architecture

--*/

#ifndef __NMR_ARCHITECTURE_UTILS
#define __NMR_ARCHITECTURE_UTILS

#include "NMR_Types.h" 

namespace NMR {

	template<int N>
	void swapBytesArray(unsigned char(&bytes)[N]) {
		// Optimize this with a platform-specific API as desired.
		for (unsigned char *p = bytes, *end = bytes + N - 1; p < end; ++p, --end) {
			unsigned char tmp = *p;
			*p = *end;
			*end = tmp;
		}
	}
	template<typename T>
	T swapBytes(T value) {
		swapBytesArray(*reinterpret_cast<unsigned char(*)[sizeof(value)]>(&value));
		return value;
	}

	inline bool isBigEndian(void)
	{
		union {
			nfUint32 i;
			char c[4];
		} bint = { 0x01020304 };

		return bint.c[0] == 1;
	}
}

#endif // __NMR_ARCHITECTURE_UTILS
