; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -mattr=+architected-sgprs --verify-machineinstrs < %s | FileCheck -check-prefix=GCN-SDAG %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -mattr=+architected-sgprs -global-isel --verify-machineinstrs < %s | FileCheck -check-prefix=GCN-GISEL %s

define amdgpu_kernel void @workgroup_id_x(ptr addrspace(1) %ptrx) {
; GCN-SDAG-LABEL: workgroup_id_x:
; GCN-SDAG:       ; %bb.0:
; GCN-SDAG-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GCN-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GCN-SDAG-NEXT:    v_mov_b32_e32 v1, ttmp9
; GCN-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GCN-SDAG-NEXT:    s_endpgm
;
; GCN-GISEL-LABEL: workgroup_id_x:
; GCN-GISEL:       ; %bb.0:
; GCN-GISEL-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GCN-GISEL-NEXT:    v_mov_b32_e32 v0, ttmp9
; GCN-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GCN-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GCN-GISEL-NEXT:    s_endpgm
  %idx = call i32 @llvm.amdgcn.workgroup.id.x()
  store i32 %idx, ptr addrspace(1) %ptrx

  ret void
}

define amdgpu_kernel void @workgroup_id_xy(ptr addrspace(1) %ptrx, ptr addrspace(1) %ptry) {
; GCN-SDAG-LABEL: workgroup_id_xy:
; GCN-SDAG:       ; %bb.0:
; GCN-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GCN-SDAG-NEXT:    v_mov_b32_e32 v1, ttmp9
; GCN-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GCN-SDAG-NEXT:    v_mov_b32_e32 v1, ttmp7
; GCN-SDAG-NEXT:    global_store_dword v0, v1, s[2:3]
; GCN-SDAG-NEXT:    s_endpgm
;
; GCN-GISEL-LABEL: workgroup_id_xy:
; GCN-GISEL:       ; %bb.0:
; GCN-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-GISEL-NEXT:    v_mov_b32_e32 v0, 0
; GCN-GISEL-NEXT:    v_mov_b32_e32 v1, ttmp9
; GCN-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-GISEL-NEXT:    global_store_dword v0, v1, s[0:1]
; GCN-GISEL-NEXT:    v_mov_b32_e32 v1, ttmp7
; GCN-GISEL-NEXT:    global_store_dword v0, v1, s[2:3]
; GCN-GISEL-NEXT:    s_endpgm
  %idx = call i32 @llvm.amdgcn.workgroup.id.x()
  store i32 %idx, ptr addrspace(1) %ptrx
  %idy = call i32 @llvm.amdgcn.workgroup.id.y()
  store i32 %idy, ptr addrspace(1) %ptry

  ret void
}

define amdgpu_kernel void @workgroup_id_xyz(ptr addrspace(1) %ptrx, ptr addrspace(1) %ptry, ptr addrspace(1) %ptrz) {
; GCN-SDAG-LABEL: workgroup_id_xyz:
; GCN-SDAG:       ; %bb.0:
; GCN-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-SDAG-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x10
; GCN-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; GCN-SDAG-NEXT:    v_mov_b32_e32 v1, ttmp9
; GCN-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-SDAG-NEXT:    global_store_dword v0, v1, s[0:1]
; GCN-SDAG-NEXT:    s_and_b32 s0, ttmp7, 0xffff
; GCN-SDAG-NEXT:    v_mov_b32_e32 v1, s0
; GCN-SDAG-NEXT:    s_lshr_b32 s0, ttmp7, 16
; GCN-SDAG-NEXT:    global_store_dword v0, v1, s[2:3]
; GCN-SDAG-NEXT:    v_mov_b32_e32 v1, s0
; GCN-SDAG-NEXT:    global_store_dword v0, v1, s[6:7]
; GCN-SDAG-NEXT:    s_endpgm
;
; GCN-GISEL-LABEL: workgroup_id_xyz:
; GCN-GISEL:       ; %bb.0:
; GCN-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GCN-GISEL-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x10
; GCN-GISEL-NEXT:    v_mov_b32_e32 v0, ttmp9
; GCN-GISEL-NEXT:    v_mov_b32_e32 v1, 0
; GCN-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-GISEL-NEXT:    global_store_dword v1, v0, s[0:1]
; GCN-GISEL-NEXT:    s_and_b32 s0, ttmp7, 0xffff
; GCN-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GCN-GISEL-NEXT:    s_lshr_b32 s0, ttmp7, 16
; GCN-GISEL-NEXT:    global_store_dword v1, v0, s[2:3]
; GCN-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; GCN-GISEL-NEXT:    global_store_dword v1, v0, s[6:7]
; GCN-GISEL-NEXT:    s_endpgm
  %idx = call i32 @llvm.amdgcn.workgroup.id.x()
  store i32 %idx, ptr addrspace(1) %ptrx
  %idy = call i32 @llvm.amdgcn.workgroup.id.y()
  store i32 %idy, ptr addrspace(1) %ptry
  %idz = call i32 @llvm.amdgcn.workgroup.id.z()
  store i32 %idz, ptr addrspace(1) %ptrz

  ret void
}

declare i32 @llvm.amdgcn.workgroup.id.x()
declare i32 @llvm.amdgcn.workgroup.id.y()
declare i32 @llvm.amdgcn.workgroup.id.z()
