; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=indvars -S < %s | FileCheck %s

; PR59777
define i2 @iv_hoist_nsw_poison(i2 %arg) {
; CHECK-LABEL: @iv_hoist_nsw_poison(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br label [[BB1:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[DOT07:%.*]] = phi i2 [ 1, [[BB:%.*]] ], [ [[I:%.*]], [[BB1]] ]
; CHECK-NEXT:    [[I]] = add nuw i2 [[DOT07]], 1
; CHECK-NEXT:    [[DOTNOT_NOT:%.*]] = icmp ult i2 1, [[ARG:%.*]]
; CHECK-NEXT:    br i1 [[DOTNOT_NOT]], label [[COMMON_RET:%.*]], label [[BB1]]
; CHECK:       common.ret:
; CHECK-NEXT:    [[I2_LCSSA:%.*]] = phi i2 [ [[I]], [[BB1]] ]
; CHECK-NEXT:    ret i2 [[I2_LCSSA]]
;
bb:
  br label %bb1

bb1:                                              ; preds = %bb1, %bb
  %.07 = phi i2 [ 1, %bb ], [ %i, %bb1 ]
  %.0 = phi i2 [ 1, %bb ], [ %i2, %bb1 ]
  %i = add nsw i2 %.07, 1
  %i2 = add i2 %.0, 1
  %.not.not = icmp ult i2 %.07, %arg
  br i1 %.not.not, label %common.ret, label %bb1

common.ret:                                       ; preds = %bb1
  ret i2 %i2
}

define i4 @iv_hoist_nsw_poison2(i4 %0, i4 %end, i4 %start) {
; CHECK-LABEL: @iv_hoist_nsw_poison2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV_0:%.*]] = phi i4 [ [[START:%.*]], [[ENTRY:%.*]] ], [ [[IV_0_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[IV_0_NEXT]] = add i4 [[IV_0]], 1
; CHECK-NEXT:    [[DOTNOT_NOT:%.*]] = icmp ult i4 [[IV_0]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[DOTNOT_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_1_NEXT_LCSSA:%.*]] = phi i4 [ [[IV_0_NEXT]], [[LOOP]] ]
; CHECK-NEXT:    ret i4 [[IV_1_NEXT_LCSSA]]
;
entry:
  br label %loop

loop:
  %iv.0 = phi i4 [ %start, %entry ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ %start, %entry ], [ %iv.1.next, %loop ]
  %iv.0.next = add i4 %iv.0, 1
  %iv.1.next = add nsw i4 %iv.1, 1
  %.not.not = icmp ult i4 %iv.0, %end
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}

define i2 @iv_hoist_both_adds_nsw(i2 %arg) {
; CHECK-LABEL: @iv_hoist_both_adds_nsw(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV_0:%.*]] = phi i2 [ 1, [[BB:%.*]] ], [ [[IV_0_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[IV_0_NEXT]] = add nuw i2 [[IV_0]], 1
; CHECK-NEXT:    [[DOTNOT_NOT:%.*]] = icmp ult i2 1, [[ARG:%.*]]
; CHECK-NEXT:    br i1 [[DOTNOT_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_1_NEXT_LCSSA:%.*]] = phi i2 [ [[IV_0_NEXT]], [[LOOP]] ]
; CHECK-NEXT:    ret i2 [[IV_1_NEXT_LCSSA]]
;
bb:
  br label %loop

loop:
  %iv.0 = phi i2 [ 1, %bb ], [ %iv.0.next, %loop ]
  %iv.1 = phi i2 [ 1, %bb ], [ %iv.1.next, %loop ]
  %iv.0.next = add nsw i2 %iv.0, 1
  %iv.1.next = add nsw i2 %iv.1, 1
  %.not.not = icmp ult i2 %iv.0, %arg
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i2 %iv.1.next
}

define i4 @iv_hoist_both_adds_nsw_extra_use(i4 %arg) {
; CHECK-LABEL: @iv_hoist_both_adds_nsw_extra_use(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV_0:%.*]] = phi i4 [ 1, [[BB:%.*]] ], [ [[IV_0_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[IV_0_NEXT]] = add nuw i4 [[IV_0]], 1
; CHECK-NEXT:    call void @use(i4 [[IV_0_NEXT]])
; CHECK-NEXT:    call void @use(i4 [[IV_0_NEXT]])
; CHECK-NEXT:    [[DOTNOT_NOT:%.*]] = icmp ult i4 1, [[ARG:%.*]]
; CHECK-NEXT:    br i1 [[DOTNOT_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_1_NEXT_LCSSA:%.*]] = phi i4 [ [[IV_0_NEXT]], [[LOOP]] ]
; CHECK-NEXT:    ret i4 [[IV_1_NEXT_LCSSA]]
;
bb:
  br label %loop

loop:
  %iv.0 = phi i4 [ 1, %bb ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ 1, %bb ], [ %iv.1.next, %loop ]
  %iv.0.next = add nsw i4 %iv.0, 1
  call void @use(i4 %iv.0.next)
  %iv.1.next = add nsw i4 %iv.1, 1
  call void @use(i4 %iv.1.next)
  %.not.not = icmp ult i4 %iv.0, %arg
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}

define i4 @iv_hoist_both_adds_nsw_extra_use_incs_reordered(i4 %arg) {
; CHECK-LABEL: @iv_hoist_both_adds_nsw_extra_use_incs_reordered(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV_0:%.*]] = phi i4 [ 1, [[BB:%.*]] ], [ [[IV_0_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[IV_0_NEXT]] = add nuw i4 [[IV_0]], 1
; CHECK-NEXT:    call void @use(i4 [[IV_0_NEXT]])
; CHECK-NEXT:    call void @use(i4 [[IV_0_NEXT]])
; CHECK-NEXT:    [[DOTNOT_NOT:%.*]] = icmp ult i4 1, [[ARG:%.*]]
; CHECK-NEXT:    br i1 [[DOTNOT_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_1_NEXT_LCSSA:%.*]] = phi i4 [ [[IV_0_NEXT]], [[LOOP]] ]
; CHECK-NEXT:    ret i4 [[IV_1_NEXT_LCSSA]]
;
bb:
  br label %loop

loop:
  %iv.0 = phi i4 [ 1, %bb ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ 1, %bb ], [ %iv.1.next, %loop ]
  %iv.1.next = add nsw i4 %iv.1, 1
  call void @use(i4 %iv.1.next)
  %iv.0.next = add nsw i4 %iv.0, 1
  call void @use(i4 %iv.0.next)
  %.not.not = icmp ult i4 %iv.0, %arg
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}

define i4 @iv_hoist_nsw_poison_extra_use(i4 %0, i4 %end, i4 %start) {
; CHECK-LABEL: @iv_hoist_nsw_poison_extra_use(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV_0:%.*]] = phi i4 [ [[START:%.*]], [[ENTRY:%.*]] ], [ [[IV_0_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[IV_0_NEXT]] = add i4 [[IV_0]], 1
; CHECK-NEXT:    call void @use(i4 [[IV_0_NEXT]])
; CHECK-NEXT:    [[DOTNOT_NOT:%.*]] = icmp ult i4 [[IV_0]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[DOTNOT_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_1_NEXT_LCSSA:%.*]] = phi i4 [ [[IV_0_NEXT]], [[LOOP]] ]
; CHECK-NEXT:    ret i4 [[IV_1_NEXT_LCSSA]]
;
entry:
  br label %loop

loop:
  %iv.0 = phi i4 [ %start, %entry ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ %start, %entry ], [ %iv.1.next, %loop ]
  %iv.0.next = add i4 %iv.0, 1
  call void @use(i4 %iv.0.next)
  %iv.1.next = add nsw i4 %iv.1, 1
  %.not.not = icmp ult i4 %iv.0, %end
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}

declare void @use(i4)

define i2 @iv_hoist_nuw_poison(i2 %arg, i2 %start) {
; CHECK-LABEL: @iv_hoist_nuw_poison(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br label [[BB1:%.*]]
; CHECK:       bb1:
; CHECK-NEXT:    [[DOT07:%.*]] = phi i2 [ [[START:%.*]], [[BB:%.*]] ], [ [[I:%.*]], [[BB1]] ]
; CHECK-NEXT:    [[I]] = add i2 [[DOT07]], 1
; CHECK-NEXT:    [[DOTNOT_NOT:%.*]] = icmp ult i2 [[START]], [[ARG:%.*]]
; CHECK-NEXT:    br i1 [[DOTNOT_NOT]], label [[COMMON_RET:%.*]], label [[BB1]]
; CHECK:       common.ret:
; CHECK-NEXT:    [[I2_LCSSA:%.*]] = phi i2 [ [[I]], [[BB1]] ]
; CHECK-NEXT:    ret i2 [[I2_LCSSA]]
;
bb:
  br label %bb1

bb1:                                              ; preds = %bb1, %bb
  %.07 = phi i2 [ %start, %bb ], [ %i, %bb1 ]
  %.0 = phi i2 [ %start, %bb ], [ %i2, %bb1 ]
  %i = add nuw i2 %.07, 1
  %i2 = add i2 %.0, 1
  %.not.not = icmp ult i2 %.07, %arg
  br i1 %.not.not, label %common.ret, label %bb1

common.ret:                                       ; preds = %bb1
  ret i2 %i2
}

define i4 @iv_hoist_nuw_poison2(i4 %0, i4 %end, i4 %start) {
; CHECK-LABEL: @iv_hoist_nuw_poison2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV_0:%.*]] = phi i4 [ [[START:%.*]], [[ENTRY:%.*]] ], [ [[IV_0_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[IV_0_NEXT]] = add i4 [[IV_0]], 1
; CHECK-NEXT:    [[DOTNOT_NOT:%.*]] = icmp ult i4 [[START]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[DOTNOT_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_1_NEXT_LCSSA:%.*]] = phi i4 [ [[IV_0_NEXT]], [[LOOP]] ]
; CHECK-NEXT:    ret i4 [[IV_1_NEXT_LCSSA]]
;
entry:
  br label %loop

loop:
  %iv.0 = phi i4 [ %start, %entry ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ %start, %entry ], [ %iv.1.next, %loop ]
  %iv.0.next = add i4 %iv.0, 1
  %iv.1.next = add nuw i4 %iv.1, 1
  %.not.not = icmp ult i4 %iv.0, %end
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}

define i2 @iv_hoist_both_adds_nuw(i2 %arg, i2 %start) {
; CHECK-LABEL: @iv_hoist_both_adds_nuw(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV_0:%.*]] = phi i2 [ [[START:%.*]], [[BB:%.*]] ], [ [[IV_0_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[IV_0_NEXT]] = add i2 [[IV_0]], 1
; CHECK-NEXT:    [[DOTNOT_NOT:%.*]] = icmp ult i2 [[START]], [[ARG:%.*]]
; CHECK-NEXT:    br i1 [[DOTNOT_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_1_NEXT_LCSSA:%.*]] = phi i2 [ [[IV_0_NEXT]], [[LOOP]] ]
; CHECK-NEXT:    ret i2 [[IV_1_NEXT_LCSSA]]
;
bb:
  br label %loop

loop:
  %iv.0 = phi i2 [ %start, %bb ], [ %iv.0.next, %loop ]
  %iv.1 = phi i2 [ %start, %bb ], [ %iv.1.next, %loop ]
  %iv.0.next = add nuw i2 %iv.0, 1
  %iv.1.next = add nuw i2 %iv.1, 1
  %.not.not = icmp ult i2 %iv.0, %arg
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i2 %iv.1.next
}

define i4 @iv_hoist_both_adds_nuw_extra_use(i4 %arg, i4 %start) {
; CHECK-LABEL: @iv_hoist_both_adds_nuw_extra_use(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV_0:%.*]] = phi i4 [ [[START:%.*]], [[BB:%.*]] ], [ [[IV_0_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[IV_0_NEXT]] = add i4 [[IV_0]], 1
; CHECK-NEXT:    call void @use(i4 [[IV_0_NEXT]])
; CHECK-NEXT:    call void @use(i4 [[IV_0_NEXT]])
; CHECK-NEXT:    [[DOTNOT_NOT:%.*]] = icmp ult i4 [[START]], [[ARG:%.*]]
; CHECK-NEXT:    br i1 [[DOTNOT_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_1_NEXT_LCSSA:%.*]] = phi i4 [ [[IV_0_NEXT]], [[LOOP]] ]
; CHECK-NEXT:    ret i4 [[IV_1_NEXT_LCSSA]]
;
bb:
  br label %loop

loop:
  %iv.0 = phi i4 [ %start, %bb ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ %start, %bb ], [ %iv.1.next, %loop ]
  %iv.0.next = add nuw i4 %iv.0, 1
  call void @use(i4 %iv.0.next)
  %iv.1.next = add nuw i4 %iv.1, 1
  call void @use(i4 %iv.1.next)
  %.not.not = icmp ult i4 %iv.0, %arg
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}

define i4 @iv_hoist_both_adds_nuw_extra_use_incs_reordered(i4 %arg, i4 %start) {
; CHECK-LABEL: @iv_hoist_both_adds_nuw_extra_use_incs_reordered(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV_0:%.*]] = phi i4 [ [[START:%.*]], [[BB:%.*]] ], [ [[IV_0_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[IV_0_NEXT]] = add i4 [[IV_0]], 1
; CHECK-NEXT:    call void @use(i4 [[IV_0_NEXT]])
; CHECK-NEXT:    call void @use(i4 [[IV_0_NEXT]])
; CHECK-NEXT:    [[DOTNOT_NOT:%.*]] = icmp ult i4 [[START]], [[ARG:%.*]]
; CHECK-NEXT:    br i1 [[DOTNOT_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_1_NEXT_LCSSA:%.*]] = phi i4 [ [[IV_0_NEXT]], [[LOOP]] ]
; CHECK-NEXT:    ret i4 [[IV_1_NEXT_LCSSA]]
;
bb:
  br label %loop

loop:
  %iv.0 = phi i4 [ %start, %bb ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ %start, %bb ], [ %iv.1.next, %loop ]
  %iv.1.next = add nuw i4 %iv.1, 1
  call void @use(i4 %iv.1.next)
  %iv.0.next = add nuw i4 %iv.0, 1
  call void @use(i4 %iv.0.next)
  %.not.not = icmp ult i4 %iv.0, %arg
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}

define i4 @iv_hoist_nuw_poison_extra_use(i4 %0, i4 %end, i4 %start) {
; CHECK-LABEL: @iv_hoist_nuw_poison_extra_use(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV_0:%.*]] = phi i4 [ [[START:%.*]], [[ENTRY:%.*]] ], [ [[IV_0_NEXT:%.*]], [[LOOP]] ]
; CHECK-NEXT:    [[IV_0_NEXT]] = add i4 [[IV_0]], 1
; CHECK-NEXT:    call void @use(i4 [[IV_0_NEXT]])
; CHECK-NEXT:    [[DOTNOT_NOT:%.*]] = icmp ult i4 [[START]], [[END:%.*]]
; CHECK-NEXT:    br i1 [[DOTNOT_NOT]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[IV_1_NEXT_LCSSA:%.*]] = phi i4 [ [[IV_0_NEXT]], [[LOOP]] ]
; CHECK-NEXT:    ret i4 [[IV_1_NEXT_LCSSA]]
;
entry:
  br label %loop

loop:
  %iv.0 = phi i4 [ %start, %entry ], [ %iv.0.next, %loop ]
  %iv.1 = phi i4 [ %start, %entry ], [ %iv.1.next, %loop ]
  %iv.0.next = add i4 %iv.0, 1
  call void @use(i4 %iv.0.next)
  %iv.1.next = add nuw i4 %iv.1, 1
  %.not.not = icmp ult i4 %iv.0, %end
  br i1 %.not.not, label %exit, label %loop

exit:
  ret i4 %iv.1.next
}
