; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -aa-pipeline=basic-aa,globals-aa -passes="require<globals-aa>,function(gvn,instcombine)" -S -enable-unsafe-globalsmodref-alias-results | FileCheck %s
;
; Note that this test relies on an unsafe feature of GlobalsModRef. While this
; test is correct and safe, GMR's technique for handling this isn't generally.

target datalayout = "p:32:32:32"

@G = internal global ptr null		; <ptr> [#uses=3]

declare noalias ptr @malloc(i32) allockind("alloc,uninitialized") allocsize(0) inaccessiblememonly
define void @malloc_init() {
; CHECK-LABEL: @malloc_init(
; CHECK-NEXT:    [[A:%.*]] = call dereferenceable_or_null(4) ptr @malloc(i32 4)
; CHECK-NEXT:    store ptr [[A]], ptr @G, align 4
; CHECK-NEXT:    ret void
;
  %a = call ptr @malloc(i32 4)
  store ptr %a, ptr @G
  ret void
}

define i32 @malloc_test(ptr %P) {
; CHECK-LABEL: @malloc_test(
; CHECK-NEXT:    store i32 123, ptr [[P:%.*]], align 4
; CHECK-NEXT:    ret i32 0
;
  %g1 = load ptr, ptr @G		; <ptr> [#uses=2]
  %h1 = load i32, ptr %g1		; <i32> [#uses=1]
  store i32 123, ptr %P
  %g2 = load ptr, ptr @G		; <ptr> [#uses=0]
  %h2 = load i32, ptr %g1		; <i32> [#uses=1]
  %X = sub i32 %h1, %h2		; <i32> [#uses=1]
  ret i32 %X
}

@G2 = internal global ptr null		; <ptr> [#uses=3]

declare noalias ptr @calloc(i32, i32) allockind("alloc,zeroed") allocsize(0,1) inaccessiblememonly
define void @calloc_init() {
; CHECK-LABEL: @calloc_init(
; CHECK-NEXT:    [[A:%.*]] = call dereferenceable_or_null(4) ptr @calloc(i32 4, i32 1)
; CHECK-NEXT:    store ptr [[A]], ptr @G2, align 4
; CHECK-NEXT:    ret void
;
  %a = call ptr @calloc(i32 4, i32 1)
  store ptr %a, ptr @G2
  ret void
}

define i32 @calloc_test(ptr %P) {
; CHECK-LABEL: @calloc_test(
; CHECK-NEXT:    store i32 123, ptr [[P:%.*]], align 4
; CHECK-NEXT:    ret i32 0
;
  %g1 = load ptr, ptr @G2		; <ptr> [#uses=2]
  %h1 = load i32, ptr %g1		; <i32> [#uses=1]
  store i32 123, ptr %P
  %g2 = load ptr, ptr @G2		; <ptr> [#uses=0]
  %h2 = load i32, ptr %g1		; <i32> [#uses=1]
  %X = sub i32 %h1, %h2		; <i32> [#uses=1]
  ret i32 %X
}

@G3 = internal global ptr null		; <ptr> [#uses=3]

declare noalias ptr @my_alloc(i32)
define void @my_alloc_init() {
; CHECK-LABEL: @my_alloc_init(
; CHECK-NEXT:    [[A:%.*]] = call ptr @my_alloc(i32 4)
; CHECK-NEXT:    store ptr [[A]], ptr @G3, align 4
; CHECK-NEXT:    ret void
;
  %a = call ptr @my_alloc(i32 4)
  store ptr %a, ptr @G3
  ret void
}

define i32 @my_alloc_test(ptr %P) {
; CHECK-LABEL: @my_alloc_test(
; CHECK-NEXT:    store i32 123, ptr [[P:%.*]], align 4
; CHECK-NEXT:    ret i32 0
;
  %g1 = load ptr, ptr @G3		; <ptr> [#uses=2]
  %h1 = load i32, ptr %g1		; <i32> [#uses=1]
  store i32 123, ptr %P
  %g2 = load ptr, ptr @G3		; <ptr> [#uses=0]
  %h2 = load i32, ptr %g1		; <i32> [#uses=1]
  %X = sub i32 %h1, %h2		; <i32> [#uses=1]
  ret i32 %X
}
