; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -mtriple=aarch64-none-eabi -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD,CHECK-SD-NOFP16
; RUN: llc -mtriple=aarch64-none-eabi -mattr=+fullfp16 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-SD,CHECK-SD-FP16
; RUN: llc -mtriple=aarch64-none-eabi -global-isel -global-isel-abort=2 -verify-machineinstrs %s -o - 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-GI,CHECK-GI-NOFP16
; RUN: llc -mtriple=aarch64-none-eabi -mattr=+fullfp16 -global-isel -global-isel-abort=2 -verify-machineinstrs %s -o - 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-GI,CHECK-GI-FP16

; CHECK-GI:       warning: Instruction selection used fallback path for stofp_v3i8_v3f64
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for utofp_v3i8_v3f64
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for stofp_v3i8_v3f32
; CHECK-GI-NEXT:  warning: Instruction selection used fallback path for utofp_v3i8_v3f32
; CHECK-GI-NOFP16-NEXT:  warning: Instruction selection used fallback path for stofp_v3i8_v3f16
; CHECK-GI-NOFP16-NEXT:  warning: Instruction selection used fallback path for utofp_v3i8_v3f16

define double @stofp_i64_f64(i64 %a) {
; CHECK-LABEL: stofp_i64_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf d0, x0
; CHECK-NEXT:    ret
entry:
  %c = sitofp i64 %a to double
  ret double %c
}

define double @utofp_i64_f64(i64 %a) {
; CHECK-LABEL: utofp_i64_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf d0, x0
; CHECK-NEXT:    ret
entry:
  %c = uitofp i64 %a to double
  ret double %c
}

define double @stofp_i32_f64(i32 %a) {
; CHECK-LABEL: stofp_i32_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf d0, w0
; CHECK-NEXT:    ret
entry:
  %c = sitofp i32 %a to double
  ret double %c
}

define double @utofp_i32_f64(i32 %a) {
; CHECK-LABEL: utofp_i32_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf d0, w0
; CHECK-NEXT:    ret
entry:
  %c = uitofp i32 %a to double
  ret double %c
}

define double @stofp_i16_f64(i16 %a) {
; CHECK-LABEL: stofp_i16_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sxth w8, w0
; CHECK-NEXT:    scvtf d0, w8
; CHECK-NEXT:    ret
entry:
  %c = sitofp i16 %a to double
  ret double %c
}

define double @utofp_i16_f64(i16 %a) {
; CHECK-LABEL: utofp_i16_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and w8, w0, #0xffff
; CHECK-NEXT:    ucvtf d0, w8
; CHECK-NEXT:    ret
entry:
  %c = uitofp i16 %a to double
  ret double %c
}

define double @stofp_i8_f64(i8 %a) {
; CHECK-LABEL: stofp_i8_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sxtb w8, w0
; CHECK-NEXT:    scvtf d0, w8
; CHECK-NEXT:    ret
entry:
  %c = sitofp i8 %a to double
  ret double %c
}

define double @utofp_i8_f64(i8 %a) {
; CHECK-LABEL: utofp_i8_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and w8, w0, #0xff
; CHECK-NEXT:    ucvtf d0, w8
; CHECK-NEXT:    ret
entry:
  %c = uitofp i8 %a to double
  ret double %c
}

define float @stofp_i64_f32(i64 %a) {
; CHECK-LABEL: stofp_i64_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf s0, x0
; CHECK-NEXT:    ret
entry:
  %c = sitofp i64 %a to float
  ret float %c
}

define float @utofp_i64_f32(i64 %a) {
; CHECK-LABEL: utofp_i64_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf s0, x0
; CHECK-NEXT:    ret
entry:
  %c = uitofp i64 %a to float
  ret float %c
}

define float @stofp_i32_f32(i32 %a) {
; CHECK-LABEL: stofp_i32_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf s0, w0
; CHECK-NEXT:    ret
entry:
  %c = sitofp i32 %a to float
  ret float %c
}

define float @utofp_i32_f32(i32 %a) {
; CHECK-LABEL: utofp_i32_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf s0, w0
; CHECK-NEXT:    ret
entry:
  %c = uitofp i32 %a to float
  ret float %c
}

define float @stofp_i16_f32(i16 %a) {
; CHECK-LABEL: stofp_i16_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sxth w8, w0
; CHECK-NEXT:    scvtf s0, w8
; CHECK-NEXT:    ret
entry:
  %c = sitofp i16 %a to float
  ret float %c
}

define float @utofp_i16_f32(i16 %a) {
; CHECK-LABEL: utofp_i16_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and w8, w0, #0xffff
; CHECK-NEXT:    ucvtf s0, w8
; CHECK-NEXT:    ret
entry:
  %c = uitofp i16 %a to float
  ret float %c
}

define float @stofp_i8_f32(i8 %a) {
; CHECK-LABEL: stofp_i8_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sxtb w8, w0
; CHECK-NEXT:    scvtf s0, w8
; CHECK-NEXT:    ret
entry:
  %c = sitofp i8 %a to float
  ret float %c
}

define float @utofp_i8_f32(i8 %a) {
; CHECK-LABEL: utofp_i8_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and w8, w0, #0xff
; CHECK-NEXT:    ucvtf s0, w8
; CHECK-NEXT:    ret
entry:
  %c = uitofp i8 %a to float
  ret float %c
}

define half @stofp_i64_f16(i64 %a) {
; CHECK-SD-NOFP16-LABEL: stofp_i64_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    scvtf s0, x0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_i64_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    scvtf h0, x0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_i64_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    scvtf s0, x0
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_i64_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    scvtf h0, x0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp i64 %a to half
  ret half %c
}

define half @utofp_i64_f16(i64 %a) {
; CHECK-SD-NOFP16-LABEL: utofp_i64_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    ucvtf s0, x0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_i64_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    ucvtf h0, x0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_i64_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ucvtf s0, x0
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_i64_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ucvtf h0, x0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp i64 %a to half
  ret half %c
}

define half @stofp_i32_f16(i32 %a) {
; CHECK-SD-NOFP16-LABEL: stofp_i32_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    scvtf s0, w0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_i32_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    scvtf h0, w0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_i32_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    scvtf s0, w0
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_i32_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    scvtf h0, w0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp i32 %a to half
  ret half %c
}

define half @utofp_i32_f16(i32 %a) {
; CHECK-SD-NOFP16-LABEL: utofp_i32_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    ucvtf s0, w0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_i32_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    ucvtf h0, w0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_i32_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ucvtf s0, w0
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_i32_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ucvtf h0, w0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp i32 %a to half
  ret half %c
}

define half @stofp_i16_f16(i16 %a) {
; CHECK-SD-NOFP16-LABEL: stofp_i16_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    sxth w8, w0
; CHECK-SD-NOFP16-NEXT:    scvtf s0, w8
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_i16_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    sxth w8, w0
; CHECK-SD-FP16-NEXT:    scvtf h0, w8
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_i16_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    sxth w8, w0
; CHECK-GI-NOFP16-NEXT:    scvtf s0, w8
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_i16_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    sxth w8, w0
; CHECK-GI-FP16-NEXT:    scvtf h0, w8
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp i16 %a to half
  ret half %c
}

define half @utofp_i16_f16(i16 %a) {
; CHECK-SD-NOFP16-LABEL: utofp_i16_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    and w8, w0, #0xffff
; CHECK-SD-NOFP16-NEXT:    ucvtf s0, w8
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_i16_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    and w8, w0, #0xffff
; CHECK-SD-FP16-NEXT:    ucvtf h0, w8
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_i16_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    and w8, w0, #0xffff
; CHECK-GI-NOFP16-NEXT:    ucvtf s0, w8
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_i16_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    and w8, w0, #0xffff
; CHECK-GI-FP16-NEXT:    ucvtf h0, w8
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp i16 %a to half
  ret half %c
}

define half @stofp_i8_f16(i8 %a) {
; CHECK-SD-NOFP16-LABEL: stofp_i8_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    sxtb w8, w0
; CHECK-SD-NOFP16-NEXT:    scvtf s0, w8
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_i8_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    sxtb w8, w0
; CHECK-SD-FP16-NEXT:    scvtf h0, w8
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_i8_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    sxtb w8, w0
; CHECK-GI-NOFP16-NEXT:    scvtf s0, w8
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_i8_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    sxtb w8, w0
; CHECK-GI-FP16-NEXT:    scvtf h0, w8
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp i8 %a to half
  ret half %c
}

define half @utofp_i8_f16(i8 %a) {
; CHECK-SD-NOFP16-LABEL: utofp_i8_f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    and w8, w0, #0xff
; CHECK-SD-NOFP16-NEXT:    ucvtf s0, w8
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_i8_f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    and w8, w0, #0xff
; CHECK-SD-FP16-NEXT:    ucvtf h0, w8
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_i8_f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    and w8, w0, #0xff
; CHECK-GI-NOFP16-NEXT:    ucvtf s0, w8
; CHECK-GI-NOFP16-NEXT:    fcvt h0, s0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_i8_f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    and w8, w0, #0xff
; CHECK-GI-FP16-NEXT:    ucvtf h0, w8
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp i8 %a to half
  ret half %c
}

define <2 x double> @stofp_v2i64_v2f64(<2 x i64> %a) {
; CHECK-LABEL: stofp_v2i64_v2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = sitofp <2 x i64> %a to <2 x double>
  ret <2 x double> %c
}

define <2 x double> @utofp_v2i64_v2f64(<2 x i64> %a) {
; CHECK-LABEL: utofp_v2i64_v2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = uitofp <2 x i64> %a to <2 x double>
  ret <2 x double> %c
}

define <3 x double> @stofp_v3i64_v3f64(<3 x i64> %a) {
; CHECK-SD-LABEL: stofp_v3i64_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    scvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v3i64_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    scvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-GI-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <3 x i64> %a to <3 x double>
  ret <3 x double> %c
}

define <3 x double> @utofp_v3i64_v3f64(<3 x i64> %a) {
; CHECK-SD-LABEL: utofp_v3i64_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v3i64_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-GI-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <3 x i64> %a to <3 x double>
  ret <3 x double> %c
}

define <4 x double> @stofp_v4i64_v4f64(<4 x i64> %a) {
; CHECK-LABEL: stofp_v4i64_v4f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.2d, v0.2d
; CHECK-NEXT:    scvtf v1.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %c = sitofp <4 x i64> %a to <4 x double>
  ret <4 x double> %c
}

define <4 x double> @utofp_v4i64_v4f64(<4 x i64> %a) {
; CHECK-LABEL: utofp_v4i64_v4f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %c = uitofp <4 x i64> %a to <4 x double>
  ret <4 x double> %c
}

define <8 x double> @stofp_v8i64_v8f64(<8 x i64> %a) {
; CHECK-LABEL: stofp_v8i64_v8f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.2d, v0.2d
; CHECK-NEXT:    scvtf v1.2d, v1.2d
; CHECK-NEXT:    scvtf v2.2d, v2.2d
; CHECK-NEXT:    scvtf v3.2d, v3.2d
; CHECK-NEXT:    ret
entry:
  %c = sitofp <8 x i64> %a to <8 x double>
  ret <8 x double> %c
}

define <8 x double> @utofp_v8i64_v8f64(<8 x i64> %a) {
; CHECK-LABEL: utofp_v8i64_v8f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-NEXT:    ret
entry:
  %c = uitofp <8 x i64> %a to <8 x double>
  ret <8 x double> %c
}

define <16 x double> @stofp_v16i64_v16f64(<16 x i64> %a) {
; CHECK-LABEL: stofp_v16i64_v16f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.2d, v0.2d
; CHECK-NEXT:    scvtf v1.2d, v1.2d
; CHECK-NEXT:    scvtf v2.2d, v2.2d
; CHECK-NEXT:    scvtf v3.2d, v3.2d
; CHECK-NEXT:    scvtf v4.2d, v4.2d
; CHECK-NEXT:    scvtf v5.2d, v5.2d
; CHECK-NEXT:    scvtf v6.2d, v6.2d
; CHECK-NEXT:    scvtf v7.2d, v7.2d
; CHECK-NEXT:    ret
entry:
  %c = sitofp <16 x i64> %a to <16 x double>
  ret <16 x double> %c
}

define <16 x double> @utofp_v16i64_v16f64(<16 x i64> %a) {
; CHECK-LABEL: utofp_v16i64_v16f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-NEXT:    ucvtf v7.2d, v7.2d
; CHECK-NEXT:    ret
entry:
  %c = uitofp <16 x i64> %a to <16 x double>
  ret <16 x double> %c
}

define <32 x double> @stofp_v32i64_v32f64(<32 x i64> %a) {
; CHECK-SD-LABEL: stofp_v32i64_v32f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldp q17, q16, [sp, #96]
; CHECK-SD-NEXT:    scvtf v7.2d, v7.2d
; CHECK-SD-NEXT:    ldp q19, q18, [sp, #64]
; CHECK-SD-NEXT:    scvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    ldp q21, q20, [sp, #32]
; CHECK-SD-NEXT:    scvtf v5.2d, v5.2d
; CHECK-SD-NEXT:    scvtf v16.2d, v16.2d
; CHECK-SD-NEXT:    scvtf v17.2d, v17.2d
; CHECK-SD-NEXT:    scvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    scvtf v18.2d, v18.2d
; CHECK-SD-NEXT:    scvtf v19.2d, v19.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    scvtf v20.2d, v20.2d
; CHECK-SD-NEXT:    scvtf v21.2d, v21.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    scvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    stp q5, q6, [x8, #80]
; CHECK-SD-NEXT:    str q16, [x8, #240]
; CHECK-SD-NEXT:    ldp q22, q16, [sp]
; CHECK-SD-NEXT:    stp q3, q4, [x8, #48]
; CHECK-SD-NEXT:    stp q20, q19, [x8, #176]
; CHECK-SD-NEXT:    scvtf v16.2d, v16.2d
; CHECK-SD-NEXT:    stp q1, q2, [x8, #16]
; CHECK-SD-NEXT:    stp q18, q17, [x8, #208]
; CHECK-SD-NEXT:    scvtf v17.2d, v22.2d
; CHECK-SD-NEXT:    str q0, [x8]
; CHECK-SD-NEXT:    stp q16, q21, [x8, #144]
; CHECK-SD-NEXT:    stp q7, q17, [x8, #112]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v32i64_v32f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    scvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    scvtf v3.2d, v3.2d
; CHECK-GI-NEXT:    scvtf v4.2d, v4.2d
; CHECK-GI-NEXT:    stp q0, q1, [x8]
; CHECK-GI-NEXT:    scvtf v0.2d, v5.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v6.2d
; CHECK-GI-NEXT:    str q2, [x8, #32]
; CHECK-GI-NEXT:    ldp q2, q5, [sp]
; CHECK-GI-NEXT:    scvtf v6.2d, v7.2d
; CHECK-GI-NEXT:    stp q3, q4, [x8, #48]
; CHECK-GI-NEXT:    ldp q3, q4, [sp, #32]
; CHECK-GI-NEXT:    scvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    scvtf v5.2d, v5.2d
; CHECK-GI-NEXT:    stp q0, q1, [x8, #80]
; CHECK-GI-NEXT:    scvtf v0.2d, v3.2d
; CHECK-GI-NEXT:    ldp q1, q3, [sp, #64]
; CHECK-GI-NEXT:    scvtf v4.2d, v4.2d
; CHECK-GI-NEXT:    stp q6, q2, [x8, #112]
; CHECK-GI-NEXT:    ldp q2, q6, [sp, #96]
; CHECK-GI-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    scvtf v3.2d, v3.2d
; CHECK-GI-NEXT:    stp q5, q0, [x8, #144]
; CHECK-GI-NEXT:    scvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    scvtf v0.2d, v6.2d
; CHECK-GI-NEXT:    stp q4, q1, [x8, #176]
; CHECK-GI-NEXT:    stp q3, q2, [x8, #208]
; CHECK-GI-NEXT:    str q0, [x8, #240]
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <32 x i64> %a to <32 x double>
  ret <32 x double> %c
}

define <32 x double> @utofp_v32i64_v32f64(<32 x i64> %a) {
; CHECK-SD-LABEL: utofp_v32i64_v32f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldp q17, q16, [sp, #96]
; CHECK-SD-NEXT:    ucvtf v7.2d, v7.2d
; CHECK-SD-NEXT:    ldp q19, q18, [sp, #64]
; CHECK-SD-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    ldp q21, q20, [sp, #32]
; CHECK-SD-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-SD-NEXT:    ucvtf v16.2d, v16.2d
; CHECK-SD-NEXT:    ucvtf v17.2d, v17.2d
; CHECK-SD-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    ucvtf v18.2d, v18.2d
; CHECK-SD-NEXT:    ucvtf v19.2d, v19.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    ucvtf v20.2d, v20.2d
; CHECK-SD-NEXT:    ucvtf v21.2d, v21.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    stp q5, q6, [x8, #80]
; CHECK-SD-NEXT:    str q16, [x8, #240]
; CHECK-SD-NEXT:    ldp q22, q16, [sp]
; CHECK-SD-NEXT:    stp q3, q4, [x8, #48]
; CHECK-SD-NEXT:    stp q20, q19, [x8, #176]
; CHECK-SD-NEXT:    ucvtf v16.2d, v16.2d
; CHECK-SD-NEXT:    stp q1, q2, [x8, #16]
; CHECK-SD-NEXT:    stp q18, q17, [x8, #208]
; CHECK-SD-NEXT:    ucvtf v17.2d, v22.2d
; CHECK-SD-NEXT:    str q0, [x8]
; CHECK-SD-NEXT:    stp q16, q21, [x8, #144]
; CHECK-SD-NEXT:    stp q7, q17, [x8, #112]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v32i64_v32f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-GI-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-GI-NEXT:    stp q0, q1, [x8]
; CHECK-GI-NEXT:    ucvtf v0.2d, v5.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v6.2d
; CHECK-GI-NEXT:    str q2, [x8, #32]
; CHECK-GI-NEXT:    ldp q2, q5, [sp]
; CHECK-GI-NEXT:    ucvtf v6.2d, v7.2d
; CHECK-GI-NEXT:    stp q3, q4, [x8, #48]
; CHECK-GI-NEXT:    ldp q3, q4, [sp, #32]
; CHECK-GI-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-GI-NEXT:    stp q0, q1, [x8, #80]
; CHECK-GI-NEXT:    ucvtf v0.2d, v3.2d
; CHECK-GI-NEXT:    ldp q1, q3, [sp, #64]
; CHECK-GI-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-GI-NEXT:    stp q6, q2, [x8, #112]
; CHECK-GI-NEXT:    ldp q2, q6, [sp, #96]
; CHECK-GI-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-GI-NEXT:    stp q5, q0, [x8, #144]
; CHECK-GI-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    ucvtf v0.2d, v6.2d
; CHECK-GI-NEXT:    stp q4, q1, [x8, #176]
; CHECK-GI-NEXT:    stp q3, q2, [x8, #208]
; CHECK-GI-NEXT:    str q0, [x8, #240]
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <32 x i64> %a to <32 x double>
  ret <32 x double> %c
}

define <2 x double> @stofp_v2i32_v2f64(<2 x i32> %a) {
; CHECK-LABEL: stofp_v2i32_v2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-NEXT:    scvtf v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = sitofp <2 x i32> %a to <2 x double>
  ret <2 x double> %c
}

define <2 x double> @utofp_v2i32_v2f64(<2 x i32> %a) {
; CHECK-LABEL: utofp_v2i32_v2f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = uitofp <2 x i32> %a to <2 x double>
  ret <2 x double> %c
}

define <3 x double> @stofp_v3i32_v3f64(<3 x i32> %a) {
; CHECK-SD-LABEL: stofp_v3i32_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v1.2d, v0.2s, #0
; CHECK-SD-NEXT:    sshll2 v0.2d, v0.4s, #0
; CHECK-SD-NEXT:    scvtf v3.2d, v1.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v0.2d
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    fmov d0, d3
; CHECK-SD-NEXT:    ext v1.16b, v3.16b, v3.16b, #8
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v3i32_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v1.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    scvtf v3.2d, v1.2d
; CHECK-GI-NEXT:    scvtf v2.2d, v0.2d
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-GI-NEXT:    mov d1, v3.d[1]
; CHECK-GI-NEXT:    fmov d0, d3
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <3 x i32> %a to <3 x double>
  ret <3 x double> %c
}

define <3 x double> @utofp_v3i32_v3f64(<3 x i32> %a) {
; CHECK-SD-LABEL: utofp_v3i32_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v1.2d, v0.2s, #0
; CHECK-SD-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-SD-NEXT:    ucvtf v3.2d, v1.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v0.2d
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    fmov d0, d3
; CHECK-SD-NEXT:    ext v1.16b, v3.16b, v3.16b, #8
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v3i32_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v1.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    ucvtf v3.2d, v1.2d
; CHECK-GI-NEXT:    ucvtf v2.2d, v0.2d
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-GI-NEXT:    mov d1, v3.d[1]
; CHECK-GI-NEXT:    fmov d0, d3
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <3 x i32> %a to <3 x double>
  ret <3 x double> %c
}

define <4 x double> @stofp_v4i32_v4f64(<4 x i32> %a) {
; CHECK-SD-LABEL: stofp_v4i32_v4f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll2 v1.2d, v0.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    scvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v4i32_v4f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v1.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v2.2d, v0.4s, #0
; CHECK-GI-NEXT:    scvtf v0.2d, v1.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v2.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <4 x i32> %a to <4 x double>
  ret <4 x double> %c
}

define <4 x double> @utofp_v4i32_v4f64(<4 x i32> %a) {
; CHECK-SD-LABEL: utofp_v4i32_v4f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll2 v1.2d, v0.4s, #0
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v4i32_v4f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v1.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v2.2d, v0.4s, #0
; CHECK-GI-NEXT:    ucvtf v0.2d, v1.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v2.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <4 x i32> %a to <4 x double>
  ret <4 x double> %c
}

define <8 x double> @stofp_v8i32_v8f64(<8 x i32> %a) {
; CHECK-SD-LABEL: stofp_v8i32_v8f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v2.2d, v0.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v0.4s, #0
; CHECK-SD-NEXT:    sshll2 v4.2d, v1.4s, #0
; CHECK-SD-NEXT:    sshll v5.2d, v1.2s, #0
; CHECK-SD-NEXT:    scvtf v0.2d, v2.2d
; CHECK-SD-NEXT:    scvtf v1.2d, v3.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v4.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v5.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v8i32_v8f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v2.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v0.4s, #0
; CHECK-GI-NEXT:    sshll v4.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v5.2d, v1.4s, #0
; CHECK-GI-NEXT:    scvtf v0.2d, v2.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v3.2d
; CHECK-GI-NEXT:    scvtf v2.2d, v4.2d
; CHECK-GI-NEXT:    scvtf v3.2d, v5.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <8 x i32> %a to <8 x double>
  ret <8 x double> %c
}

define <8 x double> @utofp_v8i32_v8f64(<8 x i32> %a) {
; CHECK-SD-LABEL: utofp_v8i32_v8f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v2.2d, v0.2s, #0
; CHECK-SD-NEXT:    ushll2 v3.2d, v0.4s, #0
; CHECK-SD-NEXT:    ushll2 v4.2d, v1.4s, #0
; CHECK-SD-NEXT:    ushll v5.2d, v1.2s, #0
; CHECK-SD-NEXT:    ucvtf v0.2d, v2.2d
; CHECK-SD-NEXT:    ucvtf v1.2d, v3.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v4.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v5.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v8i32_v8f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v2.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v3.2d, v0.4s, #0
; CHECK-GI-NEXT:    ushll v4.2d, v1.2s, #0
; CHECK-GI-NEXT:    ushll2 v5.2d, v1.4s, #0
; CHECK-GI-NEXT:    ucvtf v0.2d, v2.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v3.2d
; CHECK-GI-NEXT:    ucvtf v2.2d, v4.2d
; CHECK-GI-NEXT:    ucvtf v3.2d, v5.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <8 x i32> %a to <8 x double>
  ret <8 x double> %c
}

define <16 x double> @stofp_v16i32_v16f64(<16 x i32> %a) {
; CHECK-SD-LABEL: stofp_v16i32_v16f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll2 v4.2d, v0.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    sshll2 v5.2d, v1.4s, #0
; CHECK-SD-NEXT:    sshll v6.2d, v1.2s, #0
; CHECK-SD-NEXT:    sshll v7.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll2 v16.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll2 v17.2d, v3.4s, #0
; CHECK-SD-NEXT:    sshll v18.2d, v3.2s, #0
; CHECK-SD-NEXT:    scvtf v1.2d, v4.2d
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v5.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v6.2d
; CHECK-SD-NEXT:    scvtf v4.2d, v7.2d
; CHECK-SD-NEXT:    scvtf v5.2d, v16.2d
; CHECK-SD-NEXT:    scvtf v7.2d, v17.2d
; CHECK-SD-NEXT:    scvtf v6.2d, v18.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v16i32_v16f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v4.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v5.2d, v0.4s, #0
; CHECK-GI-NEXT:    sshll v6.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v7.2d, v1.4s, #0
; CHECK-GI-NEXT:    sshll v16.2d, v2.2s, #0
; CHECK-GI-NEXT:    sshll2 v17.2d, v2.4s, #0
; CHECK-GI-NEXT:    sshll v18.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v19.2d, v3.4s, #0
; CHECK-GI-NEXT:    scvtf v0.2d, v4.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v5.2d
; CHECK-GI-NEXT:    scvtf v2.2d, v6.2d
; CHECK-GI-NEXT:    scvtf v3.2d, v7.2d
; CHECK-GI-NEXT:    scvtf v4.2d, v16.2d
; CHECK-GI-NEXT:    scvtf v5.2d, v17.2d
; CHECK-GI-NEXT:    scvtf v6.2d, v18.2d
; CHECK-GI-NEXT:    scvtf v7.2d, v19.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <16 x i32> %a to <16 x double>
  ret <16 x double> %c
}

define <16 x double> @utofp_v16i32_v16f64(<16 x i32> %a) {
; CHECK-SD-LABEL: utofp_v16i32_v16f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll2 v4.2d, v0.4s, #0
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ushll2 v5.2d, v1.4s, #0
; CHECK-SD-NEXT:    ushll v6.2d, v1.2s, #0
; CHECK-SD-NEXT:    ushll v7.2d, v2.2s, #0
; CHECK-SD-NEXT:    ushll2 v16.2d, v2.4s, #0
; CHECK-SD-NEXT:    ushll2 v17.2d, v3.4s, #0
; CHECK-SD-NEXT:    ushll v18.2d, v3.2s, #0
; CHECK-SD-NEXT:    ucvtf v1.2d, v4.2d
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v5.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v6.2d
; CHECK-SD-NEXT:    ucvtf v4.2d, v7.2d
; CHECK-SD-NEXT:    ucvtf v5.2d, v16.2d
; CHECK-SD-NEXT:    ucvtf v7.2d, v17.2d
; CHECK-SD-NEXT:    ucvtf v6.2d, v18.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v16i32_v16f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v4.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v5.2d, v0.4s, #0
; CHECK-GI-NEXT:    ushll v6.2d, v1.2s, #0
; CHECK-GI-NEXT:    ushll2 v7.2d, v1.4s, #0
; CHECK-GI-NEXT:    ushll v16.2d, v2.2s, #0
; CHECK-GI-NEXT:    ushll2 v17.2d, v2.4s, #0
; CHECK-GI-NEXT:    ushll v18.2d, v3.2s, #0
; CHECK-GI-NEXT:    ushll2 v19.2d, v3.4s, #0
; CHECK-GI-NEXT:    ucvtf v0.2d, v4.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v5.2d
; CHECK-GI-NEXT:    ucvtf v2.2d, v6.2d
; CHECK-GI-NEXT:    ucvtf v3.2d, v7.2d
; CHECK-GI-NEXT:    ucvtf v4.2d, v16.2d
; CHECK-GI-NEXT:    ucvtf v5.2d, v17.2d
; CHECK-GI-NEXT:    ucvtf v6.2d, v18.2d
; CHECK-GI-NEXT:    ucvtf v7.2d, v19.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <16 x i32> %a to <16 x double>
  ret <16 x double> %c
}

define <32 x double> @stofp_v32i32_v32f64(<32 x i32> %a) {
; CHECK-SD-LABEL: stofp_v32i32_v32f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll2 v16.2d, v7.4s, #0
; CHECK-SD-NEXT:    sshll v7.2d, v7.2s, #0
; CHECK-SD-NEXT:    sshll2 v17.2d, v6.4s, #0
; CHECK-SD-NEXT:    sshll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    sshll2 v19.2d, v4.4s, #0
; CHECK-SD-NEXT:    sshll v4.2d, v4.2s, #0
; CHECK-SD-NEXT:    sshll2 v18.2d, v5.4s, #0
; CHECK-SD-NEXT:    sshll v5.2d, v5.2s, #0
; CHECK-SD-NEXT:    scvtf v16.2d, v16.2d
; CHECK-SD-NEXT:    scvtf v7.2d, v7.2d
; CHECK-SD-NEXT:    scvtf v17.2d, v17.2d
; CHECK-SD-NEXT:    scvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    scvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    scvtf v18.2d, v18.2d
; CHECK-SD-NEXT:    scvtf v5.2d, v5.2d
; CHECK-SD-NEXT:    stp q7, q16, [x8, #224]
; CHECK-SD-NEXT:    sshll2 v16.2d, v3.4s, #0
; CHECK-SD-NEXT:    sshll v3.2d, v3.2s, #0
; CHECK-SD-NEXT:    scvtf v7.2d, v19.2d
; CHECK-SD-NEXT:    stp q6, q17, [x8, #192]
; CHECK-SD-NEXT:    sshll2 v17.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    stp q5, q18, [x8, #160]
; CHECK-SD-NEXT:    scvtf v6.2d, v16.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    sshll2 v16.2d, v1.4s, #0
; CHECK-SD-NEXT:    sshll v1.2d, v1.2s, #0
; CHECK-SD-NEXT:    scvtf v5.2d, v17.2d
; CHECK-SD-NEXT:    stp q4, q7, [x8, #128]
; CHECK-SD-NEXT:    sshll2 v7.2d, v0.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    scvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    scvtf v4.2d, v16.2d
; CHECK-SD-NEXT:    stp q3, q6, [x8, #96]
; CHECK-SD-NEXT:    scvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v7.2d
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    stp q2, q5, [x8, #64]
; CHECK-SD-NEXT:    stp q1, q4, [x8, #32]
; CHECK-SD-NEXT:    stp q0, q3, [x8]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v32i32_v32f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v16.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    sshll v17.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    sshll v18.2d, v2.2s, #0
; CHECK-GI-NEXT:    sshll2 v2.2d, v2.4s, #0
; CHECK-GI-NEXT:    sshll v19.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    scvtf v16.2d, v16.2d
; CHECK-GI-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    scvtf v17.2d, v17.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    scvtf v18.2d, v18.2d
; CHECK-GI-NEXT:    scvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    scvtf v3.2d, v3.2d
; CHECK-GI-NEXT:    stp q16, q0, [x8]
; CHECK-GI-NEXT:    sshll v16.2d, v4.2s, #0
; CHECK-GI-NEXT:    sshll2 v0.2d, v4.4s, #0
; CHECK-GI-NEXT:    scvtf v4.2d, v19.2d
; CHECK-GI-NEXT:    stp q17, q1, [x8, #32]
; CHECK-GI-NEXT:    sshll v17.2d, v5.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v5.4s, #0
; CHECK-GI-NEXT:    stp q18, q2, [x8, #64]
; CHECK-GI-NEXT:    sshll2 v2.2d, v6.4s, #0
; CHECK-GI-NEXT:    scvtf v5.2d, v16.2d
; CHECK-GI-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    sshll v16.2d, v6.2s, #0
; CHECK-GI-NEXT:    scvtf v6.2d, v17.2d
; CHECK-GI-NEXT:    stp q4, q3, [x8, #96]
; CHECK-GI-NEXT:    sshll v4.2d, v7.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v7.4s, #0
; CHECK-GI-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    scvtf v7.2d, v16.2d
; CHECK-GI-NEXT:    scvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    stp q5, q0, [x8, #128]
; CHECK-GI-NEXT:    scvtf v0.2d, v4.2d
; CHECK-GI-NEXT:    scvtf v3.2d, v3.2d
; CHECK-GI-NEXT:    stp q6, q1, [x8, #160]
; CHECK-GI-NEXT:    stp q7, q2, [x8, #192]
; CHECK-GI-NEXT:    stp q0, q3, [x8, #224]
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <32 x i32> %a to <32 x double>
  ret <32 x double> %c
}

define <32 x double> @utofp_v32i32_v32f64(<32 x i32> %a) {
; CHECK-SD-LABEL: utofp_v32i32_v32f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll2 v16.2d, v7.4s, #0
; CHECK-SD-NEXT:    ushll v7.2d, v7.2s, #0
; CHECK-SD-NEXT:    ushll2 v17.2d, v6.4s, #0
; CHECK-SD-NEXT:    ushll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    ushll2 v19.2d, v4.4s, #0
; CHECK-SD-NEXT:    ushll v4.2d, v4.2s, #0
; CHECK-SD-NEXT:    ushll2 v18.2d, v5.4s, #0
; CHECK-SD-NEXT:    ushll v5.2d, v5.2s, #0
; CHECK-SD-NEXT:    ucvtf v16.2d, v16.2d
; CHECK-SD-NEXT:    ucvtf v7.2d, v7.2d
; CHECK-SD-NEXT:    ucvtf v17.2d, v17.2d
; CHECK-SD-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    ucvtf v18.2d, v18.2d
; CHECK-SD-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-SD-NEXT:    stp q7, q16, [x8, #224]
; CHECK-SD-NEXT:    ushll2 v16.2d, v3.4s, #0
; CHECK-SD-NEXT:    ushll v3.2d, v3.2s, #0
; CHECK-SD-NEXT:    ucvtf v7.2d, v19.2d
; CHECK-SD-NEXT:    stp q6, q17, [x8, #192]
; CHECK-SD-NEXT:    ushll2 v17.2d, v2.4s, #0
; CHECK-SD-NEXT:    ushll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    stp q5, q18, [x8, #160]
; CHECK-SD-NEXT:    ucvtf v6.2d, v16.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    ushll2 v16.2d, v1.4s, #0
; CHECK-SD-NEXT:    ushll v1.2d, v1.2s, #0
; CHECK-SD-NEXT:    ucvtf v5.2d, v17.2d
; CHECK-SD-NEXT:    stp q4, q7, [x8, #128]
; CHECK-SD-NEXT:    ushll2 v7.2d, v0.4s, #0
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    ucvtf v4.2d, v16.2d
; CHECK-SD-NEXT:    stp q3, q6, [x8, #96]
; CHECK-SD-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v7.2d
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    stp q2, q5, [x8, #64]
; CHECK-SD-NEXT:    stp q1, q4, [x8, #32]
; CHECK-SD-NEXT:    stp q0, q3, [x8]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v32i32_v32f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v16.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    ushll v17.2d, v1.2s, #0
; CHECK-GI-NEXT:    ushll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    ushll v18.2d, v2.2s, #0
; CHECK-GI-NEXT:    ushll2 v2.2d, v2.4s, #0
; CHECK-GI-NEXT:    ushll v19.2d, v3.2s, #0
; CHECK-GI-NEXT:    ushll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    ucvtf v16.2d, v16.2d
; CHECK-GI-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    ucvtf v17.2d, v17.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    ucvtf v18.2d, v18.2d
; CHECK-GI-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-GI-NEXT:    stp q16, q0, [x8]
; CHECK-GI-NEXT:    ushll v16.2d, v4.2s, #0
; CHECK-GI-NEXT:    ushll2 v0.2d, v4.4s, #0
; CHECK-GI-NEXT:    ucvtf v4.2d, v19.2d
; CHECK-GI-NEXT:    stp q17, q1, [x8, #32]
; CHECK-GI-NEXT:    ushll v17.2d, v5.2s, #0
; CHECK-GI-NEXT:    ushll2 v1.2d, v5.4s, #0
; CHECK-GI-NEXT:    stp q18, q2, [x8, #64]
; CHECK-GI-NEXT:    ushll2 v2.2d, v6.4s, #0
; CHECK-GI-NEXT:    ucvtf v5.2d, v16.2d
; CHECK-GI-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    ushll v16.2d, v6.2s, #0
; CHECK-GI-NEXT:    ucvtf v6.2d, v17.2d
; CHECK-GI-NEXT:    stp q4, q3, [x8, #96]
; CHECK-GI-NEXT:    ushll v4.2d, v7.2s, #0
; CHECK-GI-NEXT:    ushll2 v3.2d, v7.4s, #0
; CHECK-GI-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    ucvtf v7.2d, v16.2d
; CHECK-GI-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    stp q5, q0, [x8, #128]
; CHECK-GI-NEXT:    ucvtf v0.2d, v4.2d
; CHECK-GI-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-GI-NEXT:    stp q6, q1, [x8, #160]
; CHECK-GI-NEXT:    stp q7, q2, [x8, #192]
; CHECK-GI-NEXT:    stp q0, q3, [x8, #224]
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <32 x i32> %a to <32 x double>
  ret <32 x double> %c
}

define <2 x double> @stofp_v2i16_v2f64(<2 x i16> %a) {
; CHECK-SD-LABEL: stofp_v2i16_v2f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    shl v0.2s, v0.2s, #16
; CHECK-SD-NEXT:    sshr v0.2s, v0.2s, #16
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v2i16_v2f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-GI-NEXT:    shl v0.2d, v0.2d, #48
; CHECK-GI-NEXT:    sshr v0.2d, v0.2d, #48
; CHECK-GI-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <2 x i16> %a to <2 x double>
  ret <2 x double> %c
}

define <2 x double> @utofp_v2i16_v2f64(<2 x i16> %a) {
; CHECK-SD-LABEL: utofp_v2i16_v2f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    movi d1, #0x00ffff0000ffff
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v2i16_v2f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    movi v1.2d, #0x0000000000ffff
; CHECK-GI-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <2 x i16> %a to <2 x double>
  ret <2 x double> %c
}

define <3 x double> @stofp_v3i16_v3f64(<3 x i16> %a) {
; CHECK-SD-LABEL: stofp_v3i16_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v1.2d
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v3i16_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    scvtf v2.2d, v1.2d
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <3 x i16> %a to <3 x double>
  ret <3 x double> %c
}

define <3 x double> @utofp_v3i16_v3f64(<3 x i16> %a) {
; CHECK-SD-LABEL: utofp_v3i16_v3f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll v0.2d, v1.2s, #0
; CHECK-SD-NEXT:    ushll2 v1.2d, v1.4s, #0
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v1.2d
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v3i16_v3f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    ushll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    ucvtf v2.2d, v1.2d
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <3 x i16> %a to <3 x double>
  ret <3 x double> %c
}

define <4 x double> @stofp_v4i16_v4f64(<4 x i16> %a) {
; CHECK-SD-LABEL: stofp_v4i16_v4f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v0.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    scvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v4i16_v4f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll v1.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v2.2d, v0.4s, #0
; CHECK-GI-NEXT:    scvtf v0.2d, v1.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v2.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <4 x i16> %a to <4 x double>
  ret <4 x double> %c
}

define <4 x double> @utofp_v4i16_v4f64(<4 x i16> %a) {
; CHECK-SD-LABEL: utofp_v4i16_v4f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll2 v1.2d, v0.4s, #0
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v4i16_v4f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll v1.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v2.2d, v0.4s, #0
; CHECK-GI-NEXT:    ucvtf v0.2d, v1.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v2.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <4 x i16> %a to <4 x double>
  ret <4 x double> %c
}

define <8 x double> @stofp_v8i16_v8f64(<8 x i16> %a) {
; CHECK-SD-LABEL: stofp_v8i16_v8f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v2.2d, v1.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v0.4s, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-SD-NEXT:    sshll v4.2d, v0.2s, #0
; CHECK-SD-NEXT:    scvtf v0.2d, v2.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    scvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v4.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v8i16_v8f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v2.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    sshll v3.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v4.2d, v0.4s, #0
; CHECK-GI-NEXT:    scvtf v0.2d, v2.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    scvtf v2.2d, v3.2d
; CHECK-GI-NEXT:    scvtf v3.2d, v4.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <8 x i16> %a to <8 x double>
  ret <8 x double> %c
}

define <8 x double> @utofp_v8i16_v8f64(<8 x i16> %a) {
; CHECK-SD-LABEL: utofp_v8i16_v8f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-SD-NEXT:    ushll v2.2d, v1.2s, #0
; CHECK-SD-NEXT:    ushll2 v3.2d, v0.4s, #0
; CHECK-SD-NEXT:    ushll2 v1.2d, v1.4s, #0
; CHECK-SD-NEXT:    ushll v4.2d, v0.2s, #0
; CHECK-SD-NEXT:    ucvtf v0.2d, v2.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v4.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v8i16_v8f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    ushll v2.2d, v1.2s, #0
; CHECK-GI-NEXT:    ushll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    ushll v3.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v4.2d, v0.4s, #0
; CHECK-GI-NEXT:    ucvtf v0.2d, v2.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    ucvtf v2.2d, v3.2d
; CHECK-GI-NEXT:    ucvtf v3.2d, v4.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <8 x i16> %a to <8 x double>
  ret <8 x double> %c
}

define <16 x double> @stofp_v16i16_v16f64(<16 x i16> %a) {
; CHECK-SD-LABEL: stofp_v16i16_v16f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v2.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v3.4s, v1.4h, #0
; CHECK-SD-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-SD-NEXT:    sshll2 v4.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll2 v5.2d, v0.4s, #0
; CHECK-SD-NEXT:    sshll v6.2d, v0.2s, #0
; CHECK-SD-NEXT:    sshll v7.2d, v3.2s, #0
; CHECK-SD-NEXT:    sshll2 v16.2d, v1.4s, #0
; CHECK-SD-NEXT:    sshll2 v17.2d, v3.4s, #0
; CHECK-SD-NEXT:    sshll v18.2d, v1.2s, #0
; CHECK-SD-NEXT:    scvtf v1.2d, v4.2d
; CHECK-SD-NEXT:    scvtf v0.2d, v2.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v5.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v6.2d
; CHECK-SD-NEXT:    scvtf v4.2d, v7.2d
; CHECK-SD-NEXT:    scvtf v7.2d, v16.2d
; CHECK-SD-NEXT:    scvtf v5.2d, v17.2d
; CHECK-SD-NEXT:    scvtf v6.2d, v18.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v16i16_v16f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v2.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v3.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    sshll v4.2d, v2.2s, #0
; CHECK-GI-NEXT:    sshll2 v2.2d, v2.4s, #0
; CHECK-GI-NEXT:    sshll v5.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v6.2d, v0.4s, #0
; CHECK-GI-NEXT:    sshll v7.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v16.2d, v3.4s, #0
; CHECK-GI-NEXT:    sshll v17.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v18.2d, v1.4s, #0
; CHECK-GI-NEXT:    scvtf v0.2d, v4.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v2.2d
; CHECK-GI-NEXT:    scvtf v2.2d, v5.2d
; CHECK-GI-NEXT:    scvtf v3.2d, v6.2d
; CHECK-GI-NEXT:    scvtf v4.2d, v7.2d
; CHECK-GI-NEXT:    scvtf v5.2d, v16.2d
; CHECK-GI-NEXT:    scvtf v6.2d, v17.2d
; CHECK-GI-NEXT:    scvtf v7.2d, v18.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <16 x i16> %a to <16 x double>
  ret <16 x double> %c
}

define <16 x double> @utofp_v16i16_v16f64(<16 x i16> %a) {
; CHECK-SD-LABEL: utofp_v16i16_v16f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v2.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-SD-NEXT:    ushll v3.4s, v1.4h, #0
; CHECK-SD-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-SD-NEXT:    ushll2 v4.2d, v2.4s, #0
; CHECK-SD-NEXT:    ushll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    ushll2 v5.2d, v0.4s, #0
; CHECK-SD-NEXT:    ushll v6.2d, v0.2s, #0
; CHECK-SD-NEXT:    ushll v7.2d, v3.2s, #0
; CHECK-SD-NEXT:    ushll2 v16.2d, v1.4s, #0
; CHECK-SD-NEXT:    ushll2 v17.2d, v3.4s, #0
; CHECK-SD-NEXT:    ushll v18.2d, v1.2s, #0
; CHECK-SD-NEXT:    ucvtf v1.2d, v4.2d
; CHECK-SD-NEXT:    ucvtf v0.2d, v2.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v5.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v6.2d
; CHECK-SD-NEXT:    ucvtf v4.2d, v7.2d
; CHECK-SD-NEXT:    ucvtf v7.2d, v16.2d
; CHECK-SD-NEXT:    ucvtf v5.2d, v17.2d
; CHECK-SD-NEXT:    ucvtf v6.2d, v18.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v16i16_v16f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v2.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    ushll v3.4s, v1.4h, #0
; CHECK-GI-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    ushll v4.2d, v2.2s, #0
; CHECK-GI-NEXT:    ushll2 v2.2d, v2.4s, #0
; CHECK-GI-NEXT:    ushll v5.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v6.2d, v0.4s, #0
; CHECK-GI-NEXT:    ushll v7.2d, v3.2s, #0
; CHECK-GI-NEXT:    ushll2 v16.2d, v3.4s, #0
; CHECK-GI-NEXT:    ushll v17.2d, v1.2s, #0
; CHECK-GI-NEXT:    ushll2 v18.2d, v1.4s, #0
; CHECK-GI-NEXT:    ucvtf v0.2d, v4.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v2.2d
; CHECK-GI-NEXT:    ucvtf v2.2d, v5.2d
; CHECK-GI-NEXT:    ucvtf v3.2d, v6.2d
; CHECK-GI-NEXT:    ucvtf v4.2d, v7.2d
; CHECK-GI-NEXT:    ucvtf v5.2d, v16.2d
; CHECK-GI-NEXT:    ucvtf v6.2d, v17.2d
; CHECK-GI-NEXT:    ucvtf v7.2d, v18.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <16 x i16> %a to <16 x double>
  ret <16 x double> %c
}

define <32 x double> @stofp_v32i16_v32f64(<32 x i16> %a) {
; CHECK-SD-LABEL: stofp_v32i16_v32f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll2 v4.4s, v3.8h, #0
; CHECK-SD-NEXT:    sshll2 v5.4s, v2.8h, #0
; CHECK-SD-NEXT:    sshll2 v7.4s, v1.8h, #0
; CHECK-SD-NEXT:    sshll2 v17.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v3.4s, v3.4h, #0
; CHECK-SD-NEXT:    sshll v1.4s, v1.4h, #0
; CHECK-SD-NEXT:    sshll v2.4s, v2.4h, #0
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v6.2d, v4.4s, #0
; CHECK-SD-NEXT:    sshll v4.2d, v4.2s, #0
; CHECK-SD-NEXT:    sshll2 v16.2d, v5.4s, #0
; CHECK-SD-NEXT:    sshll v5.2d, v5.2s, #0
; CHECK-SD-NEXT:    sshll2 v18.2d, v7.4s, #0
; CHECK-SD-NEXT:    sshll v7.2d, v7.2s, #0
; CHECK-SD-NEXT:    sshll2 v19.2d, v17.4s, #0
; CHECK-SD-NEXT:    scvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    scvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    scvtf v16.2d, v16.2d
; CHECK-SD-NEXT:    scvtf v5.2d, v5.2d
; CHECK-SD-NEXT:    scvtf v7.2d, v7.2d
; CHECK-SD-NEXT:    stp q4, q6, [x8, #224]
; CHECK-SD-NEXT:    sshll v6.2d, v17.2s, #0
; CHECK-SD-NEXT:    scvtf v17.2d, v18.2d
; CHECK-SD-NEXT:    sshll2 v4.2d, v3.4s, #0
; CHECK-SD-NEXT:    stp q5, q16, [x8, #160]
; CHECK-SD-NEXT:    sshll v3.2d, v3.2s, #0
; CHECK-SD-NEXT:    scvtf v16.2d, v19.2d
; CHECK-SD-NEXT:    scvtf v5.2d, v6.2d
; CHECK-SD-NEXT:    sshll2 v6.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    scvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    stp q7, q17, [x8, #96]
; CHECK-SD-NEXT:    sshll2 v7.2d, v1.4s, #0
; CHECK-SD-NEXT:    sshll v1.2d, v1.2s, #0
; CHECK-SD-NEXT:    scvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    stp q5, q16, [x8, #32]
; CHECK-SD-NEXT:    sshll2 v5.2d, v0.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    scvtf v7.2d, v7.2d
; CHECK-SD-NEXT:    stp q3, q4, [x8, #192]
; CHECK-SD-NEXT:    scvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v5.2d
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    stp q2, q6, [x8, #128]
; CHECK-SD-NEXT:    stp q1, q7, [x8, #64]
; CHECK-SD-NEXT:    stp q0, q3, [x8]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v32i16_v32f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v4.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v6.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    sshll v16.4s, v2.4h, #0
; CHECK-GI-NEXT:    sshll2 v2.4s, v2.8h, #0
; CHECK-GI-NEXT:    sshll v18.4s, v3.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v3.8h, #0
; CHECK-GI-NEXT:    sshll v5.2d, v4.2s, #0
; CHECK-GI-NEXT:    sshll2 v4.2d, v4.4s, #0
; CHECK-GI-NEXT:    sshll v7.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    sshll v17.2d, v6.2s, #0
; CHECK-GI-NEXT:    sshll2 v6.2d, v6.4s, #0
; CHECK-GI-NEXT:    sshll v19.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    scvtf v5.2d, v5.2d
; CHECK-GI-NEXT:    scvtf v4.2d, v4.2d
; CHECK-GI-NEXT:    scvtf v7.2d, v7.2d
; CHECK-GI-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    scvtf v6.2d, v6.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    stp q5, q4, [x8]
; CHECK-GI-NEXT:    scvtf v5.2d, v17.2d
; CHECK-GI-NEXT:    sshll v4.2d, v16.2s, #0
; CHECK-GI-NEXT:    stp q7, q0, [x8, #32]
; CHECK-GI-NEXT:    sshll2 v7.2d, v16.4s, #0
; CHECK-GI-NEXT:    scvtf v16.2d, v19.2d
; CHECK-GI-NEXT:    sshll v0.2d, v2.2s, #0
; CHECK-GI-NEXT:    sshll2 v2.2d, v2.4s, #0
; CHECK-GI-NEXT:    scvtf v4.2d, v4.2d
; CHECK-GI-NEXT:    stp q5, q6, [x8, #64]
; CHECK-GI-NEXT:    scvtf v6.2d, v7.2d
; CHECK-GI-NEXT:    sshll v5.2d, v18.2s, #0
; CHECK-GI-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    stp q16, q1, [x8, #96]
; CHECK-GI-NEXT:    scvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    sshll2 v7.2d, v18.4s, #0
; CHECK-GI-NEXT:    sshll v1.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    scvtf v5.2d, v5.2d
; CHECK-GI-NEXT:    stp q4, q6, [x8, #128]
; CHECK-GI-NEXT:    scvtf v4.2d, v7.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    stp q0, q2, [x8, #160]
; CHECK-GI-NEXT:    scvtf v0.2d, v3.2d
; CHECK-GI-NEXT:    stp q5, q4, [x8, #192]
; CHECK-GI-NEXT:    stp q1, q0, [x8, #224]
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <32 x i16> %a to <32 x double>
  ret <32 x double> %c
}

define <32 x double> @utofp_v32i16_v32f64(<32 x i16> %a) {
; CHECK-SD-LABEL: utofp_v32i16_v32f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll2 v4.4s, v3.8h, #0
; CHECK-SD-NEXT:    ushll2 v5.4s, v2.8h, #0
; CHECK-SD-NEXT:    ushll2 v7.4s, v1.8h, #0
; CHECK-SD-NEXT:    ushll2 v17.4s, v0.8h, #0
; CHECK-SD-NEXT:    ushll v3.4s, v3.4h, #0
; CHECK-SD-NEXT:    ushll v1.4s, v1.4h, #0
; CHECK-SD-NEXT:    ushll v2.4s, v2.4h, #0
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll2 v6.2d, v4.4s, #0
; CHECK-SD-NEXT:    ushll v4.2d, v4.2s, #0
; CHECK-SD-NEXT:    ushll2 v16.2d, v5.4s, #0
; CHECK-SD-NEXT:    ushll v5.2d, v5.2s, #0
; CHECK-SD-NEXT:    ushll2 v18.2d, v7.4s, #0
; CHECK-SD-NEXT:    ushll v7.2d, v7.2s, #0
; CHECK-SD-NEXT:    ushll2 v19.2d, v17.4s, #0
; CHECK-SD-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    ucvtf v16.2d, v16.2d
; CHECK-SD-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-SD-NEXT:    ucvtf v7.2d, v7.2d
; CHECK-SD-NEXT:    stp q4, q6, [x8, #224]
; CHECK-SD-NEXT:    ushll v6.2d, v17.2s, #0
; CHECK-SD-NEXT:    ucvtf v17.2d, v18.2d
; CHECK-SD-NEXT:    ushll2 v4.2d, v3.4s, #0
; CHECK-SD-NEXT:    stp q5, q16, [x8, #160]
; CHECK-SD-NEXT:    ushll v3.2d, v3.2s, #0
; CHECK-SD-NEXT:    ucvtf v16.2d, v19.2d
; CHECK-SD-NEXT:    ucvtf v5.2d, v6.2d
; CHECK-SD-NEXT:    ushll2 v6.2d, v2.4s, #0
; CHECK-SD-NEXT:    ushll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    stp q7, q17, [x8, #96]
; CHECK-SD-NEXT:    ushll2 v7.2d, v1.4s, #0
; CHECK-SD-NEXT:    ushll v1.2d, v1.2s, #0
; CHECK-SD-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    stp q5, q16, [x8, #32]
; CHECK-SD-NEXT:    ushll2 v5.2d, v0.4s, #0
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ucvtf v7.2d, v7.2d
; CHECK-SD-NEXT:    stp q3, q4, [x8, #192]
; CHECK-SD-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v5.2d
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    stp q2, q6, [x8, #128]
; CHECK-SD-NEXT:    stp q1, q7, [x8, #64]
; CHECK-SD-NEXT:    stp q0, q3, [x8]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v32i16_v32f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v4.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    ushll v6.4s, v1.4h, #0
; CHECK-GI-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    ushll v16.4s, v2.4h, #0
; CHECK-GI-NEXT:    ushll2 v2.4s, v2.8h, #0
; CHECK-GI-NEXT:    ushll v18.4s, v3.4h, #0
; CHECK-GI-NEXT:    ushll2 v3.4s, v3.8h, #0
; CHECK-GI-NEXT:    ushll v5.2d, v4.2s, #0
; CHECK-GI-NEXT:    ushll2 v4.2d, v4.4s, #0
; CHECK-GI-NEXT:    ushll v7.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    ushll v17.2d, v6.2s, #0
; CHECK-GI-NEXT:    ushll2 v6.2d, v6.4s, #0
; CHECK-GI-NEXT:    ushll v19.2d, v1.2s, #0
; CHECK-GI-NEXT:    ushll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-GI-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-GI-NEXT:    ucvtf v7.2d, v7.2d
; CHECK-GI-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    stp q5, q4, [x8]
; CHECK-GI-NEXT:    ucvtf v5.2d, v17.2d
; CHECK-GI-NEXT:    ushll v4.2d, v16.2s, #0
; CHECK-GI-NEXT:    stp q7, q0, [x8, #32]
; CHECK-GI-NEXT:    ushll2 v7.2d, v16.4s, #0
; CHECK-GI-NEXT:    ucvtf v16.2d, v19.2d
; CHECK-GI-NEXT:    ushll v0.2d, v2.2s, #0
; CHECK-GI-NEXT:    ushll2 v2.2d, v2.4s, #0
; CHECK-GI-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-GI-NEXT:    stp q5, q6, [x8, #64]
; CHECK-GI-NEXT:    ucvtf v6.2d, v7.2d
; CHECK-GI-NEXT:    ushll v5.2d, v18.2s, #0
; CHECK-GI-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    stp q16, q1, [x8, #96]
; CHECK-GI-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    ushll2 v7.2d, v18.4s, #0
; CHECK-GI-NEXT:    ushll v1.2d, v3.2s, #0
; CHECK-GI-NEXT:    ushll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-GI-NEXT:    stp q4, q6, [x8, #128]
; CHECK-GI-NEXT:    ucvtf v4.2d, v7.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    stp q0, q2, [x8, #160]
; CHECK-GI-NEXT:    ucvtf v0.2d, v3.2d
; CHECK-GI-NEXT:    stp q5, q4, [x8, #192]
; CHECK-GI-NEXT:    stp q1, q0, [x8, #224]
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <32 x i16> %a to <32 x double>
  ret <32 x double> %c
}

define <2 x double> @stofp_v2i8_v2f64(<2 x i8> %a) {
; CHECK-SD-LABEL: stofp_v2i8_v2f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    shl v0.2s, v0.2s, #24
; CHECK-SD-NEXT:    sshr v0.2s, v0.2s, #24
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v2i8_v2f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-GI-NEXT:    shl v0.2d, v0.2d, #56
; CHECK-GI-NEXT:    sshr v0.2d, v0.2d, #56
; CHECK-GI-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <2 x i8> %a to <2 x double>
  ret <2 x double> %c
}

define <2 x double> @utofp_v2i8_v2f64(<2 x i8> %a) {
; CHECK-SD-LABEL: utofp_v2i8_v2f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    movi d1, #0x0000ff000000ff
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v2i8_v2f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    movi v1.2d, #0x000000000000ff
; CHECK-GI-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <2 x i8> %a to <2 x double>
  ret <2 x double> %c
}

define <3 x double> @stofp_v3i8_v3f64(<3 x i8> %a) {
; CHECK-LABEL: stofp_v3i8_v3f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov s0, w0
; CHECK-NEXT:    fmov s1, w2
; CHECK-NEXT:    mov v0.s[1], w1
; CHECK-NEXT:    shl v1.2s, v1.2s, #24
; CHECK-NEXT:    sshr v1.2s, v1.2s, #24
; CHECK-NEXT:    shl v0.2s, v0.2s, #24
; CHECK-NEXT:    sshll v1.2d, v1.2s, #0
; CHECK-NEXT:    sshr v0.2s, v0.2s, #24
; CHECK-NEXT:    scvtf v2.2d, v1.2d
; CHECK-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-NEXT:    scvtf v0.2d, v0.2d
; CHECK-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-NEXT:    ret
entry:
  %c = sitofp <3 x i8> %a to <3 x double>
  ret <3 x double> %c
}

define <3 x double> @utofp_v3i8_v3f64(<3 x i8> %a) {
; CHECK-LABEL: utofp_v3i8_v3f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov s0, w0
; CHECK-NEXT:    movi d1, #0x0000ff000000ff
; CHECK-NEXT:    fmov s2, w2
; CHECK-NEXT:    mov v0.s[1], w1
; CHECK-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    and v1.8b, v2.8b, v1.8b
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    ushll v1.2d, v1.2s, #0
; CHECK-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-NEXT:    ucvtf v2.2d, v1.2d
; CHECK-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-NEXT:    ret
entry:
  %c = uitofp <3 x i8> %a to <3 x double>
  ret <3 x double> %c
}

define <4 x double> @stofp_v4i8_v4f64(<4 x i8> %a) {
; CHECK-SD-LABEL: stofp_v4i8_v4f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    shl v0.2s, v0.2s, #24
; CHECK-SD-NEXT:    sshr v0.2s, v0.2s, #24
; CHECK-SD-NEXT:    shl v1.2s, v1.2s, #24
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    sshr v1.2s, v1.2s, #24
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    sshll v1.2d, v1.2s, #0
; CHECK-SD-NEXT:    scvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v4i8_v4f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll v1.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    shl v1.2d, v1.2d, #56
; CHECK-GI-NEXT:    shl v0.2d, v0.2d, #56
; CHECK-GI-NEXT:    sshr v1.2d, v1.2d, #56
; CHECK-GI-NEXT:    sshr v2.2d, v0.2d, #56
; CHECK-GI-NEXT:    scvtf v0.2d, v1.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v2.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <4 x i8> %a to <4 x double>
  ret <4 x double> %c
}

define <4 x double> @utofp_v4i8_v4f64(<4 x i8> %a) {
; CHECK-SD-LABEL: utofp_v4i8_v4f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    movi d1, #0x0000ff000000ff
; CHECK-SD-NEXT:    ext v2.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    and v1.8b, v2.8b, v1.8b
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ushll v1.2d, v1.2s, #0
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v4i8_v4f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    movi v1.2d, #0x000000000000ff
; CHECK-GI-NEXT:    ushll v2.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    and v2.16b, v2.16b, v1.16b
; CHECK-GI-NEXT:    and v1.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ucvtf v0.2d, v2.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <4 x i8> %a to <4 x double>
  ret <4 x double> %c
}

define <8 x double> @stofp_v8i8_v8f64(<8 x i8> %a) {
; CHECK-SD-LABEL: stofp_v8i8_v8f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    umov w8, v0.b[0]
; CHECK-SD-NEXT:    umov w9, v0.b[2]
; CHECK-SD-NEXT:    umov w11, v0.b[4]
; CHECK-SD-NEXT:    umov w12, v0.b[6]
; CHECK-SD-NEXT:    umov w10, v0.b[1]
; CHECK-SD-NEXT:    umov w13, v0.b[3]
; CHECK-SD-NEXT:    umov w14, v0.b[5]
; CHECK-SD-NEXT:    umov w15, v0.b[7]
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    fmov s1, w9
; CHECK-SD-NEXT:    fmov s2, w11
; CHECK-SD-NEXT:    fmov s3, w12
; CHECK-SD-NEXT:    mov v0.s[1], w10
; CHECK-SD-NEXT:    mov v1.s[1], w13
; CHECK-SD-NEXT:    mov v2.s[1], w14
; CHECK-SD-NEXT:    mov v3.s[1], w15
; CHECK-SD-NEXT:    shl v0.2s, v0.2s, #24
; CHECK-SD-NEXT:    shl v1.2s, v1.2s, #24
; CHECK-SD-NEXT:    shl v2.2s, v2.2s, #24
; CHECK-SD-NEXT:    shl v3.2s, v3.2s, #24
; CHECK-SD-NEXT:    sshr v0.2s, v0.2s, #24
; CHECK-SD-NEXT:    sshr v1.2s, v1.2s, #24
; CHECK-SD-NEXT:    sshr v2.2s, v2.2s, #24
; CHECK-SD-NEXT:    sshr v3.2s, v3.2s, #24
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    sshll v1.2d, v1.2s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll v3.2d, v3.2s, #0
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    scvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v8i8_v8f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v2.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    sshll v3.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v4.2d, v0.4s, #0
; CHECK-GI-NEXT:    scvtf v0.2d, v2.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    scvtf v2.2d, v3.2d
; CHECK-GI-NEXT:    scvtf v3.2d, v4.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <8 x i8> %a to <8 x double>
  ret <8 x double> %c
}

define <8 x double> @utofp_v8i8_v8f64(<8 x i8> %a) {
; CHECK-SD-LABEL: utofp_v8i8_v8f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    umov w8, v0.b[0]
; CHECK-SD-NEXT:    umov w9, v0.b[2]
; CHECK-SD-NEXT:    umov w11, v0.b[4]
; CHECK-SD-NEXT:    umov w12, v0.b[6]
; CHECK-SD-NEXT:    umov w10, v0.b[1]
; CHECK-SD-NEXT:    umov w13, v0.b[3]
; CHECK-SD-NEXT:    umov w14, v0.b[5]
; CHECK-SD-NEXT:    umov w15, v0.b[7]
; CHECK-SD-NEXT:    movi d1, #0x0000ff000000ff
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    fmov s2, w9
; CHECK-SD-NEXT:    fmov s3, w11
; CHECK-SD-NEXT:    fmov s4, w12
; CHECK-SD-NEXT:    mov v0.s[1], w10
; CHECK-SD-NEXT:    mov v2.s[1], w13
; CHECK-SD-NEXT:    mov v3.s[1], w14
; CHECK-SD-NEXT:    mov v4.s[1], w15
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    and v2.8b, v2.8b, v1.8b
; CHECK-SD-NEXT:    and v3.8b, v3.8b, v1.8b
; CHECK-SD-NEXT:    and v1.8b, v4.8b, v1.8b
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ushll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    ushll v3.2d, v3.2s, #0
; CHECK-SD-NEXT:    ushll v4.2d, v1.2s, #0
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ucvtf v1.2d, v2.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v3.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v4.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v8i8_v8f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    ushll v2.2d, v1.2s, #0
; CHECK-GI-NEXT:    ushll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    ushll v3.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v4.2d, v0.4s, #0
; CHECK-GI-NEXT:    ucvtf v0.2d, v2.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    ucvtf v2.2d, v3.2d
; CHECK-GI-NEXT:    ucvtf v3.2d, v4.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <8 x i8> %a to <8 x double>
  ret <8 x double> %c
}

define <16 x double> @stofp_v16i8_v16f64(<16 x i8> %a) {
; CHECK-SD-LABEL: stofp_v16i8_v16f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    umov w8, v0.b[0]
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    umov w9, v0.b[1]
; CHECK-SD-NEXT:    umov w10, v0.b[2]
; CHECK-SD-NEXT:    umov w12, v0.b[4]
; CHECK-SD-NEXT:    umov w14, v0.b[6]
; CHECK-SD-NEXT:    umov w11, v0.b[3]
; CHECK-SD-NEXT:    umov w13, v0.b[5]
; CHECK-SD-NEXT:    fmov s2, w8
; CHECK-SD-NEXT:    umov w15, v1.b[0]
; CHECK-SD-NEXT:    umov w17, v1.b[2]
; CHECK-SD-NEXT:    umov w0, v1.b[4]
; CHECK-SD-NEXT:    umov w16, v1.b[1]
; CHECK-SD-NEXT:    umov w18, v1.b[3]
; CHECK-SD-NEXT:    umov w8, v0.b[7]
; CHECK-SD-NEXT:    fmov s0, w10
; CHECK-SD-NEXT:    umov w10, v1.b[5]
; CHECK-SD-NEXT:    mov v2.s[1], w9
; CHECK-SD-NEXT:    umov w9, v1.b[6]
; CHECK-SD-NEXT:    fmov s3, w12
; CHECK-SD-NEXT:    umov w12, v1.b[7]
; CHECK-SD-NEXT:    fmov s1, w14
; CHECK-SD-NEXT:    fmov s4, w15
; CHECK-SD-NEXT:    fmov s5, w17
; CHECK-SD-NEXT:    fmov s6, w0
; CHECK-SD-NEXT:    mov v0.s[1], w11
; CHECK-SD-NEXT:    mov v3.s[1], w13
; CHECK-SD-NEXT:    fmov s7, w9
; CHECK-SD-NEXT:    mov v1.s[1], w8
; CHECK-SD-NEXT:    mov v4.s[1], w16
; CHECK-SD-NEXT:    mov v5.s[1], w18
; CHECK-SD-NEXT:    mov v6.s[1], w10
; CHECK-SD-NEXT:    shl v2.2s, v2.2s, #24
; CHECK-SD-NEXT:    shl v0.2s, v0.2s, #24
; CHECK-SD-NEXT:    mov v7.s[1], w12
; CHECK-SD-NEXT:    shl v3.2s, v3.2s, #24
; CHECK-SD-NEXT:    shl v1.2s, v1.2s, #24
; CHECK-SD-NEXT:    shl v4.2s, v4.2s, #24
; CHECK-SD-NEXT:    sshr v2.2s, v2.2s, #24
; CHECK-SD-NEXT:    shl v5.2s, v5.2s, #24
; CHECK-SD-NEXT:    shl v6.2s, v6.2s, #24
; CHECK-SD-NEXT:    sshr v0.2s, v0.2s, #24
; CHECK-SD-NEXT:    sshr v3.2s, v3.2s, #24
; CHECK-SD-NEXT:    shl v7.2s, v7.2s, #24
; CHECK-SD-NEXT:    sshr v4.2s, v4.2s, #24
; CHECK-SD-NEXT:    sshr v1.2s, v1.2s, #24
; CHECK-SD-NEXT:    sshr v5.2s, v5.2s, #24
; CHECK-SD-NEXT:    sshr v6.2s, v6.2s, #24
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll v16.2d, v0.2s, #0
; CHECK-SD-NEXT:    sshll v3.2d, v3.2s, #0
; CHECK-SD-NEXT:    sshr v7.2s, v7.2s, #24
; CHECK-SD-NEXT:    sshll v4.2d, v4.2s, #0
; CHECK-SD-NEXT:    sshll v17.2d, v1.2s, #0
; CHECK-SD-NEXT:    sshll v5.2d, v5.2s, #0
; CHECK-SD-NEXT:    sshll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    scvtf v0.2d, v2.2d
; CHECK-SD-NEXT:    scvtf v1.2d, v16.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v3.2d
; CHECK-SD-NEXT:    sshll v7.2d, v7.2s, #0
; CHECK-SD-NEXT:    scvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v17.2d
; CHECK-SD-NEXT:    scvtf v5.2d, v5.2d
; CHECK-SD-NEXT:    scvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    scvtf v7.2d, v7.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v16i8_v16f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v1.8h, v0.8b, #0
; CHECK-GI-NEXT:    sshll2 v0.8h, v0.16b, #0
; CHECK-GI-NEXT:    sshll v2.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    sshll v3.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v4.2d, v2.2s, #0
; CHECK-GI-NEXT:    sshll2 v2.2d, v2.4s, #0
; CHECK-GI-NEXT:    sshll v5.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v6.2d, v1.4s, #0
; CHECK-GI-NEXT:    sshll v7.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v16.2d, v3.4s, #0
; CHECK-GI-NEXT:    sshll v17.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v18.2d, v0.4s, #0
; CHECK-GI-NEXT:    scvtf v0.2d, v4.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v2.2d
; CHECK-GI-NEXT:    scvtf v2.2d, v5.2d
; CHECK-GI-NEXT:    scvtf v3.2d, v6.2d
; CHECK-GI-NEXT:    scvtf v4.2d, v7.2d
; CHECK-GI-NEXT:    scvtf v5.2d, v16.2d
; CHECK-GI-NEXT:    scvtf v6.2d, v17.2d
; CHECK-GI-NEXT:    scvtf v7.2d, v18.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <16 x i8> %a to <16 x double>
  ret <16 x double> %c
}

define <16 x double> @utofp_v16i8_v16f64(<16 x i8> %a) {
; CHECK-SD-LABEL: utofp_v16i8_v16f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ext v2.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    umov w8, v0.b[0]
; CHECK-SD-NEXT:    umov w10, v0.b[2]
; CHECK-SD-NEXT:    umov w9, v0.b[1]
; CHECK-SD-NEXT:    umov w12, v0.b[4]
; CHECK-SD-NEXT:    umov w11, v0.b[3]
; CHECK-SD-NEXT:    umov w13, v0.b[5]
; CHECK-SD-NEXT:    umov w18, v0.b[6]
; CHECK-SD-NEXT:    movi d1, #0x0000ff000000ff
; CHECK-SD-NEXT:    umov w14, v2.b[0]
; CHECK-SD-NEXT:    umov w16, v2.b[2]
; CHECK-SD-NEXT:    umov w0, v2.b[4]
; CHECK-SD-NEXT:    fmov s3, w8
; CHECK-SD-NEXT:    umov w8, v0.b[7]
; CHECK-SD-NEXT:    fmov s0, w10
; CHECK-SD-NEXT:    umov w10, v2.b[6]
; CHECK-SD-NEXT:    umov w15, v2.b[1]
; CHECK-SD-NEXT:    umov w17, v2.b[3]
; CHECK-SD-NEXT:    fmov s4, w12
; CHECK-SD-NEXT:    umov w12, v2.b[5]
; CHECK-SD-NEXT:    fmov s7, w18
; CHECK-SD-NEXT:    mov v3.s[1], w9
; CHECK-SD-NEXT:    umov w9, v2.b[7]
; CHECK-SD-NEXT:    fmov s2, w14
; CHECK-SD-NEXT:    fmov s5, w16
; CHECK-SD-NEXT:    fmov s6, w0
; CHECK-SD-NEXT:    mov v0.s[1], w11
; CHECK-SD-NEXT:    fmov s16, w10
; CHECK-SD-NEXT:    mov v4.s[1], w13
; CHECK-SD-NEXT:    mov v7.s[1], w8
; CHECK-SD-NEXT:    mov v2.s[1], w15
; CHECK-SD-NEXT:    mov v5.s[1], w17
; CHECK-SD-NEXT:    mov v6.s[1], w12
; CHECK-SD-NEXT:    and v3.8b, v3.8b, v1.8b
; CHECK-SD-NEXT:    mov v16.s[1], w9
; CHECK-SD-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-SD-NEXT:    and v4.8b, v4.8b, v1.8b
; CHECK-SD-NEXT:    and v7.8b, v7.8b, v1.8b
; CHECK-SD-NEXT:    and v2.8b, v2.8b, v1.8b
; CHECK-SD-NEXT:    ushll v3.2d, v3.2s, #0
; CHECK-SD-NEXT:    and v5.8b, v5.8b, v1.8b
; CHECK-SD-NEXT:    and v6.8b, v6.8b, v1.8b
; CHECK-SD-NEXT:    and v1.8b, v16.8b, v1.8b
; CHECK-SD-NEXT:    ushll v16.2d, v0.2s, #0
; CHECK-SD-NEXT:    ushll v17.2d, v4.2s, #0
; CHECK-SD-NEXT:    ushll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    ushll v7.2d, v7.2s, #0
; CHECK-SD-NEXT:    ucvtf v0.2d, v3.2d
; CHECK-SD-NEXT:    ushll v5.2d, v5.2s, #0
; CHECK-SD-NEXT:    ushll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    ushll v18.2d, v1.2s, #0
; CHECK-SD-NEXT:    ucvtf v1.2d, v16.2d
; CHECK-SD-NEXT:    ucvtf v4.2d, v2.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v17.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v7.2d
; CHECK-SD-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-SD-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    ucvtf v7.2d, v18.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v16i8_v16f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v1.8h, v0.8b, #0
; CHECK-GI-NEXT:    ushll2 v0.8h, v0.16b, #0
; CHECK-GI-NEXT:    ushll v2.4s, v1.4h, #0
; CHECK-GI-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    ushll v3.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    ushll v4.2d, v2.2s, #0
; CHECK-GI-NEXT:    ushll2 v2.2d, v2.4s, #0
; CHECK-GI-NEXT:    ushll v5.2d, v1.2s, #0
; CHECK-GI-NEXT:    ushll2 v6.2d, v1.4s, #0
; CHECK-GI-NEXT:    ushll v7.2d, v3.2s, #0
; CHECK-GI-NEXT:    ushll2 v16.2d, v3.4s, #0
; CHECK-GI-NEXT:    ushll v17.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v18.2d, v0.4s, #0
; CHECK-GI-NEXT:    ucvtf v0.2d, v4.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v2.2d
; CHECK-GI-NEXT:    ucvtf v2.2d, v5.2d
; CHECK-GI-NEXT:    ucvtf v3.2d, v6.2d
; CHECK-GI-NEXT:    ucvtf v4.2d, v7.2d
; CHECK-GI-NEXT:    ucvtf v5.2d, v16.2d
; CHECK-GI-NEXT:    ucvtf v6.2d, v17.2d
; CHECK-GI-NEXT:    ucvtf v7.2d, v18.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <16 x i8> %a to <16 x double>
  ret <16 x double> %c
}

define <32 x double> @stofp_v32i8_v32f64(<32 x i8> %a) {
; CHECK-SD-LABEL: stofp_v32i8_v32f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ext v3.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    ext v2.16b, v1.16b, v1.16b, #8
; CHECK-SD-NEXT:    umov w9, v3.b[0]
; CHECK-SD-NEXT:    umov w11, v3.b[4]
; CHECK-SD-NEXT:    umov w13, v3.b[6]
; CHECK-SD-NEXT:    umov w18, v2.b[2]
; CHECK-SD-NEXT:    umov w10, v3.b[2]
; CHECK-SD-NEXT:    umov w12, v3.b[1]
; CHECK-SD-NEXT:    umov w16, v2.b[0]
; CHECK-SD-NEXT:    umov w14, v3.b[3]
; CHECK-SD-NEXT:    umov w15, v3.b[5]
; CHECK-SD-NEXT:    umov w17, v3.b[7]
; CHECK-SD-NEXT:    fmov s6, w9
; CHECK-SD-NEXT:    fmov s5, w11
; CHECK-SD-NEXT:    fmov s7, w13
; CHECK-SD-NEXT:    umov w13, v2.b[4]
; CHECK-SD-NEXT:    umov w11, v2.b[3]
; CHECK-SD-NEXT:    umov w9, v2.b[6]
; CHECK-SD-NEXT:    fmov s17, w18
; CHECK-SD-NEXT:    fmov s4, w10
; CHECK-SD-NEXT:    umov w10, v2.b[1]
; CHECK-SD-NEXT:    mov v6.s[1], w12
; CHECK-SD-NEXT:    fmov s3, w16
; CHECK-SD-NEXT:    umov w12, v2.b[5]
; CHECK-SD-NEXT:    mov v5.s[1], w15
; CHECK-SD-NEXT:    umov w15, v1.b[0]
; CHECK-SD-NEXT:    umov w16, v0.b[6]
; CHECK-SD-NEXT:    fmov s16, w13
; CHECK-SD-NEXT:    umov w13, v1.b[2]
; CHECK-SD-NEXT:    mov v17.s[1], w11
; CHECK-SD-NEXT:    umov w11, v1.b[6]
; CHECK-SD-NEXT:    fmov s18, w9
; CHECK-SD-NEXT:    umov w9, v1.b[4]
; CHECK-SD-NEXT:    mov v3.s[1], w10
; CHECK-SD-NEXT:    umov w10, v0.b[0]
; CHECK-SD-NEXT:    mov v4.s[1], w14
; CHECK-SD-NEXT:    mov v16.s[1], w12
; CHECK-SD-NEXT:    umov w12, v1.b[7]
; CHECK-SD-NEXT:    umov w14, v1.b[5]
; CHECK-SD-NEXT:    fmov s20, w13
; CHECK-SD-NEXT:    umov w13, v1.b[3]
; CHECK-SD-NEXT:    fmov s22, w15
; CHECK-SD-NEXT:    fmov s21, w11
; CHECK-SD-NEXT:    umov w11, v1.b[1]
; CHECK-SD-NEXT:    fmov s1, w9
; CHECK-SD-NEXT:    fmov s19, w10
; CHECK-SD-NEXT:    umov w10, v0.b[4]
; CHECK-SD-NEXT:    umov w9, v0.b[7]
; CHECK-SD-NEXT:    fmov s23, w16
; CHECK-SD-NEXT:    mov v7.s[1], w17
; CHECK-SD-NEXT:    shl v17.2s, v17.2s, #24
; CHECK-SD-NEXT:    mov v21.s[1], w12
; CHECK-SD-NEXT:    mov v1.s[1], w14
; CHECK-SD-NEXT:    umov w14, v0.b[5]
; CHECK-SD-NEXT:    umov w12, v0.b[1]
; CHECK-SD-NEXT:    mov v20.s[1], w13
; CHECK-SD-NEXT:    umov w13, v0.b[2]
; CHECK-SD-NEXT:    mov v22.s[1], w11
; CHECK-SD-NEXT:    umov w11, v0.b[3]
; CHECK-SD-NEXT:    fmov s0, w10
; CHECK-SD-NEXT:    mov v23.s[1], w9
; CHECK-SD-NEXT:    umov w9, v2.b[7]
; CHECK-SD-NEXT:    shl v16.2s, v16.2s, #24
; CHECK-SD-NEXT:    shl v21.2s, v21.2s, #24
; CHECK-SD-NEXT:    shl v1.2s, v1.2s, #24
; CHECK-SD-NEXT:    sshr v17.2s, v17.2s, #24
; CHECK-SD-NEXT:    mov v0.s[1], w14
; CHECK-SD-NEXT:    fmov s24, w13
; CHECK-SD-NEXT:    mov v19.s[1], w12
; CHECK-SD-NEXT:    sshr v16.2s, v16.2s, #24
; CHECK-SD-NEXT:    shl v6.2s, v6.2s, #24
; CHECK-SD-NEXT:    shl v20.2s, v20.2s, #24
; CHECK-SD-NEXT:    sshr v21.2s, v21.2s, #24
; CHECK-SD-NEXT:    sshr v1.2s, v1.2s, #24
; CHECK-SD-NEXT:    shl v2.2s, v23.2s, #24
; CHECK-SD-NEXT:    mov v18.s[1], w9
; CHECK-SD-NEXT:    mov v24.s[1], w11
; CHECK-SD-NEXT:    shl v22.2s, v22.2s, #24
; CHECK-SD-NEXT:    shl v0.2s, v0.2s, #24
; CHECK-SD-NEXT:    shl v4.2s, v4.2s, #24
; CHECK-SD-NEXT:    shl v5.2s, v5.2s, #24
; CHECK-SD-NEXT:    sshll v21.2d, v21.2s, #0
; CHECK-SD-NEXT:    sshll v1.2d, v1.2s, #0
; CHECK-SD-NEXT:    sshr v2.2s, v2.2s, #24
; CHECK-SD-NEXT:    shl v7.2s, v7.2s, #24
; CHECK-SD-NEXT:    shl v19.2s, v19.2s, #24
; CHECK-SD-NEXT:    sshr v20.2s, v20.2s, #24
; CHECK-SD-NEXT:    sshr v0.2s, v0.2s, #24
; CHECK-SD-NEXT:    shl v18.2s, v18.2s, #24
; CHECK-SD-NEXT:    shl v23.2s, v24.2s, #24
; CHECK-SD-NEXT:    scvtf v21.2d, v21.2d
; CHECK-SD-NEXT:    scvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshr v22.2s, v22.2s, #24
; CHECK-SD-NEXT:    sshr v19.2s, v19.2s, #24
; CHECK-SD-NEXT:    sshr v5.2s, v5.2s, #24
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    sshr v23.2s, v23.2s, #24
; CHECK-SD-NEXT:    sshr v4.2s, v4.2s, #24
; CHECK-SD-NEXT:    scvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    sshr v6.2s, v6.2s, #24
; CHECK-SD-NEXT:    sshll v20.2d, v20.2s, #0
; CHECK-SD-NEXT:    stp q1, q21, [x8, #160]
; CHECK-SD-NEXT:    shl v1.2s, v3.2s, #24
; CHECK-SD-NEXT:    sshr v3.2s, v18.2s, #24
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    sshll v22.2d, v22.2s, #0
; CHECK-SD-NEXT:    sshll v18.2d, v23.2s, #0
; CHECK-SD-NEXT:    sshll v19.2d, v19.2s, #0
; CHECK-SD-NEXT:    sshll v5.2d, v5.2s, #0
; CHECK-SD-NEXT:    sshll v4.2d, v4.2s, #0
; CHECK-SD-NEXT:    sshr v1.2s, v1.2s, #24
; CHECK-SD-NEXT:    sshll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    scvtf v20.2d, v20.2d
; CHECK-SD-NEXT:    scvtf v22.2d, v22.2d
; CHECK-SD-NEXT:    stp q0, q2, [x8, #32]
; CHECK-SD-NEXT:    sshll v2.2d, v3.2s, #0
; CHECK-SD-NEXT:    sshll v3.2d, v16.2s, #0
; CHECK-SD-NEXT:    sshll v16.2d, v17.2s, #0
; CHECK-SD-NEXT:    sshll v1.2d, v1.2s, #0
; CHECK-SD-NEXT:    sshr v0.2s, v7.2s, #24
; CHECK-SD-NEXT:    scvtf v7.2d, v18.2d
; CHECK-SD-NEXT:    scvtf v17.2d, v19.2d
; CHECK-SD-NEXT:    stp q22, q20, [x8, #128]
; CHECK-SD-NEXT:    scvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    scvtf v16.2d, v16.2d
; CHECK-SD-NEXT:    scvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    stp q17, q7, [x8]
; CHECK-SD-NEXT:    stp q3, q2, [x8, #224]
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v5.2d
; CHECK-SD-NEXT:    stp q1, q16, [x8, #192]
; CHECK-SD-NEXT:    scvtf v3.2d, v4.2d
; CHECK-SD-NEXT:    scvtf v1.2d, v6.2d
; CHECK-SD-NEXT:    stp q2, q0, [x8, #96]
; CHECK-SD-NEXT:    stp q1, q3, [x8, #64]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v32i8_v32f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v2.8h, v0.8b, #0
; CHECK-GI-NEXT:    sshll2 v0.8h, v0.16b, #0
; CHECK-GI-NEXT:    sshll v4.8h, v1.8b, #0
; CHECK-GI-NEXT:    sshll2 v1.8h, v1.16b, #0
; CHECK-GI-NEXT:    sshll v3.4s, v2.4h, #0
; CHECK-GI-NEXT:    sshll2 v2.4s, v2.8h, #0
; CHECK-GI-NEXT:    sshll v6.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v16.4s, v4.4h, #0
; CHECK-GI-NEXT:    sshll2 v4.4s, v4.8h, #0
; CHECK-GI-NEXT:    sshll v18.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    sshll v5.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    sshll v7.2d, v2.2s, #0
; CHECK-GI-NEXT:    sshll2 v2.2d, v2.4s, #0
; CHECK-GI-NEXT:    sshll v17.2d, v6.2s, #0
; CHECK-GI-NEXT:    sshll2 v6.2d, v6.4s, #0
; CHECK-GI-NEXT:    sshll v19.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    sshll v20.2d, v16.2s, #0
; CHECK-GI-NEXT:    scvtf v5.2d, v5.2d
; CHECK-GI-NEXT:    scvtf v3.2d, v3.2d
; CHECK-GI-NEXT:    scvtf v7.2d, v7.2d
; CHECK-GI-NEXT:    scvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    scvtf v17.2d, v17.2d
; CHECK-GI-NEXT:    scvtf v6.2d, v6.2d
; CHECK-GI-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    stp q5, q3, [x8]
; CHECK-GI-NEXT:    sshll2 v5.2d, v16.4s, #0
; CHECK-GI-NEXT:    scvtf v16.2d, v19.2d
; CHECK-GI-NEXT:    stp q7, q2, [x8, #32]
; CHECK-GI-NEXT:    scvtf v2.2d, v20.2d
; CHECK-GI-NEXT:    sshll v3.2d, v4.2s, #0
; CHECK-GI-NEXT:    stp q17, q6, [x8, #64]
; CHECK-GI-NEXT:    sshll2 v4.2d, v4.4s, #0
; CHECK-GI-NEXT:    sshll v6.2d, v18.2s, #0
; CHECK-GI-NEXT:    scvtf v5.2d, v5.2d
; CHECK-GI-NEXT:    sshll2 v7.2d, v18.4s, #0
; CHECK-GI-NEXT:    stp q16, q0, [x8, #96]
; CHECK-GI-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    scvtf v3.2d, v3.2d
; CHECK-GI-NEXT:    scvtf v4.2d, v4.2d
; CHECK-GI-NEXT:    scvtf v6.2d, v6.2d
; CHECK-GI-NEXT:    stp q2, q5, [x8, #128]
; CHECK-GI-NEXT:    scvtf v2.2d, v7.2d
; CHECK-GI-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    stp q3, q4, [x8, #160]
; CHECK-GI-NEXT:    stp q6, q2, [x8, #192]
; CHECK-GI-NEXT:    stp q0, q1, [x8, #224]
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <32 x i8> %a to <32 x double>
  ret <32 x double> %c
}

define <32 x double> @utofp_v32i8_v32f64(<32 x i8> %a) {
; CHECK-SD-LABEL: utofp_v32i8_v32f64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ext v2.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    ext v16.16b, v1.16b, v1.16b, #8
; CHECK-SD-NEXT:    movi d3, #0x0000ff000000ff
; CHECK-SD-NEXT:    umov w11, v2.b[0]
; CHECK-SD-NEXT:    umov w14, v2.b[4]
; CHECK-SD-NEXT:    umov w12, v2.b[2]
; CHECK-SD-NEXT:    umov w15, v2.b[6]
; CHECK-SD-NEXT:    umov w16, v2.b[1]
; CHECK-SD-NEXT:    umov w13, v16.b[2]
; CHECK-SD-NEXT:    umov w17, v16.b[0]
; CHECK-SD-NEXT:    umov w9, v2.b[3]
; CHECK-SD-NEXT:    umov w10, v2.b[5]
; CHECK-SD-NEXT:    fmov s4, w11
; CHECK-SD-NEXT:    fmov s6, w14
; CHECK-SD-NEXT:    umov w14, v16.b[6]
; CHECK-SD-NEXT:    fmov s5, w12
; CHECK-SD-NEXT:    umov w12, v16.b[4]
; CHECK-SD-NEXT:    umov w11, v16.b[1]
; CHECK-SD-NEXT:    fmov s7, w15
; CHECK-SD-NEXT:    umov w15, v16.b[7]
; CHECK-SD-NEXT:    fmov s18, w13
; CHECK-SD-NEXT:    mov v4.s[1], w16
; CHECK-SD-NEXT:    umov w16, v1.b[4]
; CHECK-SD-NEXT:    umov w13, v1.b[6]
; CHECK-SD-NEXT:    fmov s17, w17
; CHECK-SD-NEXT:    fmov s20, w14
; CHECK-SD-NEXT:    mov v5.s[1], w9
; CHECK-SD-NEXT:    umov w9, v1.b[7]
; CHECK-SD-NEXT:    fmov s19, w12
; CHECK-SD-NEXT:    mov v6.s[1], w10
; CHECK-SD-NEXT:    umov w10, v1.b[2]
; CHECK-SD-NEXT:    umov w12, v0.b[6]
; CHECK-SD-NEXT:    umov w14, v1.b[0]
; CHECK-SD-NEXT:    mov v17.s[1], w11
; CHECK-SD-NEXT:    mov v20.s[1], w15
; CHECK-SD-NEXT:    umov w11, v1.b[5]
; CHECK-SD-NEXT:    umov w15, v1.b[3]
; CHECK-SD-NEXT:    fmov s21, w16
; CHECK-SD-NEXT:    umov w16, v1.b[1]
; CHECK-SD-NEXT:    fmov s1, w13
; CHECK-SD-NEXT:    umov w13, v0.b[4]
; CHECK-SD-NEXT:    and v6.8b, v6.8b, v3.8b
; CHECK-SD-NEXT:    fmov s22, w10
; CHECK-SD-NEXT:    fmov s23, w12
; CHECK-SD-NEXT:    fmov s24, w14
; CHECK-SD-NEXT:    mov v21.s[1], w11
; CHECK-SD-NEXT:    umov w10, v0.b[5]
; CHECK-SD-NEXT:    umov w12, v0.b[0]
; CHECK-SD-NEXT:    mov v1.s[1], w9
; CHECK-SD-NEXT:    umov w9, v0.b[7]
; CHECK-SD-NEXT:    umov w11, v16.b[3]
; CHECK-SD-NEXT:    mov v22.s[1], w15
; CHECK-SD-NEXT:    mov v24.s[1], w16
; CHECK-SD-NEXT:    fmov s25, w13
; CHECK-SD-NEXT:    umov w13, v0.b[3]
; CHECK-SD-NEXT:    and v20.8b, v20.8b, v3.8b
; CHECK-SD-NEXT:    and v5.8b, v5.8b, v3.8b
; CHECK-SD-NEXT:    and v21.8b, v21.8b, v3.8b
; CHECK-SD-NEXT:    mov v23.s[1], w9
; CHECK-SD-NEXT:    umov w9, v0.b[2]
; CHECK-SD-NEXT:    and v1.8b, v1.8b, v3.8b
; CHECK-SD-NEXT:    mov v25.s[1], w10
; CHECK-SD-NEXT:    umov w10, v0.b[1]
; CHECK-SD-NEXT:    and v0.8b, v22.8b, v3.8b
; CHECK-SD-NEXT:    fmov s22, w12
; CHECK-SD-NEXT:    and v24.8b, v24.8b, v3.8b
; CHECK-SD-NEXT:    umov w12, v16.b[5]
; CHECK-SD-NEXT:    ushll v1.2d, v1.2s, #0
; CHECK-SD-NEXT:    ushll v21.2d, v21.2s, #0
; CHECK-SD-NEXT:    mov v18.s[1], w11
; CHECK-SD-NEXT:    and v16.8b, v23.8b, v3.8b
; CHECK-SD-NEXT:    fmov s23, w9
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    and v25.8b, v25.8b, v3.8b
; CHECK-SD-NEXT:    ushll v24.2d, v24.2s, #0
; CHECK-SD-NEXT:    mov v22.s[1], w10
; CHECK-SD-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    ucvtf v21.2d, v21.2d
; CHECK-SD-NEXT:    umov w9, v2.b[7]
; CHECK-SD-NEXT:    mov v23.s[1], w13
; CHECK-SD-NEXT:    ushll v16.2d, v16.2s, #0
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ushll v2.2d, v25.2s, #0
; CHECK-SD-NEXT:    mov v19.s[1], w12
; CHECK-SD-NEXT:    ucvtf v24.2d, v24.2d
; CHECK-SD-NEXT:    and v18.8b, v18.8b, v3.8b
; CHECK-SD-NEXT:    stp q21, q1, [x8, #160]
; CHECK-SD-NEXT:    and v1.8b, v22.8b, v3.8b
; CHECK-SD-NEXT:    ucvtf v16.2d, v16.2d
; CHECK-SD-NEXT:    and v23.8b, v23.8b, v3.8b
; CHECK-SD-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    mov v7.s[1], w9
; CHECK-SD-NEXT:    stp q24, q0, [x8, #128]
; CHECK-SD-NEXT:    and v0.8b, v19.8b, v3.8b
; CHECK-SD-NEXT:    ushll v18.2d, v18.2s, #0
; CHECK-SD-NEXT:    ushll v1.2d, v1.2s, #0
; CHECK-SD-NEXT:    ushll v19.2d, v23.2s, #0
; CHECK-SD-NEXT:    stp q2, q16, [x8, #32]
; CHECK-SD-NEXT:    and v16.8b, v17.8b, v3.8b
; CHECK-SD-NEXT:    ushll v17.2d, v20.2s, #0
; CHECK-SD-NEXT:    and v2.8b, v7.8b, v3.8b
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    ucvtf v7.2d, v19.2d
; CHECK-SD-NEXT:    and v3.8b, v4.8b, v3.8b
; CHECK-SD-NEXT:    ushll v4.2d, v6.2s, #0
; CHECK-SD-NEXT:    ucvtf v17.2d, v17.2d
; CHECK-SD-NEXT:    ushll v16.2d, v16.2s, #0
; CHECK-SD-NEXT:    ucvtf v6.2d, v18.2d
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ushll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    ushll v3.2d, v3.2s, #0
; CHECK-SD-NEXT:    stp q1, q7, [x8]
; CHECK-SD-NEXT:    ushll v1.2d, v5.2s, #0
; CHECK-SD-NEXT:    ucvtf v5.2d, v16.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    stp q0, q17, [x8, #224]
; CHECK-SD-NEXT:    ucvtf v0.2d, v4.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    stp q5, q6, [x8, #192]
; CHECK-SD-NEXT:    stp q0, q2, [x8, #96]
; CHECK-SD-NEXT:    stp q3, q1, [x8, #64]
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v32i8_v32f64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v2.8h, v0.8b, #0
; CHECK-GI-NEXT:    ushll2 v0.8h, v0.16b, #0
; CHECK-GI-NEXT:    ushll v4.8h, v1.8b, #0
; CHECK-GI-NEXT:    ushll2 v1.8h, v1.16b, #0
; CHECK-GI-NEXT:    ushll v3.4s, v2.4h, #0
; CHECK-GI-NEXT:    ushll2 v2.4s, v2.8h, #0
; CHECK-GI-NEXT:    ushll v6.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    ushll v16.4s, v4.4h, #0
; CHECK-GI-NEXT:    ushll2 v4.4s, v4.8h, #0
; CHECK-GI-NEXT:    ushll v18.4s, v1.4h, #0
; CHECK-GI-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    ushll v5.2d, v3.2s, #0
; CHECK-GI-NEXT:    ushll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    ushll v7.2d, v2.2s, #0
; CHECK-GI-NEXT:    ushll2 v2.2d, v2.4s, #0
; CHECK-GI-NEXT:    ushll v17.2d, v6.2s, #0
; CHECK-GI-NEXT:    ushll2 v6.2d, v6.4s, #0
; CHECK-GI-NEXT:    ushll v19.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    ushll v20.2d, v16.2s, #0
; CHECK-GI-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-GI-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-GI-NEXT:    ucvtf v7.2d, v7.2d
; CHECK-GI-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    ucvtf v17.2d, v17.2d
; CHECK-GI-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-GI-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    stp q5, q3, [x8]
; CHECK-GI-NEXT:    ushll2 v5.2d, v16.4s, #0
; CHECK-GI-NEXT:    ucvtf v16.2d, v19.2d
; CHECK-GI-NEXT:    stp q7, q2, [x8, #32]
; CHECK-GI-NEXT:    ucvtf v2.2d, v20.2d
; CHECK-GI-NEXT:    ushll v3.2d, v4.2s, #0
; CHECK-GI-NEXT:    stp q17, q6, [x8, #64]
; CHECK-GI-NEXT:    ushll2 v4.2d, v4.4s, #0
; CHECK-GI-NEXT:    ushll v6.2d, v18.2s, #0
; CHECK-GI-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-GI-NEXT:    ushll2 v7.2d, v18.4s, #0
; CHECK-GI-NEXT:    stp q16, q0, [x8, #96]
; CHECK-GI-NEXT:    ushll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    ushll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-GI-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-GI-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-GI-NEXT:    stp q2, q5, [x8, #128]
; CHECK-GI-NEXT:    ucvtf v2.2d, v7.2d
; CHECK-GI-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-NEXT:    stp q3, q4, [x8, #160]
; CHECK-GI-NEXT:    stp q6, q2, [x8, #192]
; CHECK-GI-NEXT:    stp q0, q1, [x8, #224]
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <32 x i8> %a to <32 x double>
  ret <32 x double> %c
}

define <2 x float> @stofp_v2i64_v2f32(<2 x i64> %a) {
; CHECK-LABEL: stofp_v2i64_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.2d, v0.2d
; CHECK-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = sitofp <2 x i64> %a to <2 x float>
  ret <2 x float> %c
}

define <2 x float> @utofp_v2i64_v2f32(<2 x i64> %a) {
; CHECK-LABEL: utofp_v2i64_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-NEXT:    ret
entry:
  %c = uitofp <2 x i64> %a to <2 x float>
  ret <2 x float> %c
}

define <3 x float> @stofp_v3i64_v3f32(<3 x i64> %a) {
; CHECK-SD-LABEL: stofp_v3i64_v3f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    scvtf v1.2d, v2.2d
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-SD-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v3i64_v3f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    scvtf v1.2d, v2.2d
; CHECK-GI-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    fcvtn v1.2s, v1.2d
; CHECK-GI-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NEXT:    mov s2, v0.s[1]
; CHECK-GI-NEXT:    mov v0.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v0.s[2], v1.s[0]
; CHECK-GI-NEXT:    mov v0.s[3], v0.s[0]
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <3 x i64> %a to <3 x float>
  ret <3 x float> %c
}

define <3 x float> @utofp_v3i64_v3f32(<3 x i64> %a) {
; CHECK-SD-LABEL: utofp_v3i64_v3f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    ucvtf v1.2d, v2.2d
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-SD-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v3i64_v3f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NEXT:    ucvtf v1.2d, v2.2d
; CHECK-GI-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    fcvtn v1.2s, v1.2d
; CHECK-GI-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NEXT:    mov s2, v0.s[1]
; CHECK-GI-NEXT:    mov v0.s[1], v2.s[0]
; CHECK-GI-NEXT:    mov v0.s[2], v1.s[0]
; CHECK-GI-NEXT:    mov v0.s[3], v0.s[0]
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <3 x i64> %a to <3 x float>
  ret <3 x float> %c
}

define <4 x float> @stofp_v4i64_v4f32(<4 x i64> %a) {
; CHECK-LABEL: stofp_v4i64_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.2d, v0.2d
; CHECK-NEXT:    scvtf v1.2d, v1.2d
; CHECK-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-NEXT:    ret
entry:
  %c = sitofp <4 x i64> %a to <4 x float>
  ret <4 x float> %c
}

define <4 x float> @utofp_v4i64_v4f32(<4 x i64> %a) {
; CHECK-LABEL: utofp_v4i64_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-NEXT:    ret
entry:
  %c = uitofp <4 x i64> %a to <4 x float>
  ret <4 x float> %c
}

define <8 x float> @stofp_v8i64_v8f32(<8 x i64> %a) {
; CHECK-SD-LABEL: stofp_v8i64_v8f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    scvtf v4.2d, v1.2d
; CHECK-SD-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-SD-NEXT:    fcvtn v1.2s, v2.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v3.2d
; CHECK-SD-NEXT:    fcvtn2 v0.4s, v4.2d
; CHECK-SD-NEXT:    fcvtn2 v1.4s, v2.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v8i64_v8f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    scvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    scvtf v4.2d, v1.2d
; CHECK-GI-NEXT:    scvtf v3.2d, v3.2d
; CHECK-GI-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NEXT:    fcvtn v1.2s, v2.2d
; CHECK-GI-NEXT:    fcvtn2 v0.4s, v4.2d
; CHECK-GI-NEXT:    fcvtn2 v1.4s, v3.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <8 x i64> %a to <8 x float>
  ret <8 x float> %c
}

define <8 x float> @utofp_v8i64_v8f32(<8 x i64> %a) {
; CHECK-SD-LABEL: utofp_v8i64_v8f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    ucvtf v4.2d, v1.2d
; CHECK-SD-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-SD-NEXT:    fcvtn v1.2s, v2.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v3.2d
; CHECK-SD-NEXT:    fcvtn2 v0.4s, v4.2d
; CHECK-SD-NEXT:    fcvtn2 v1.4s, v2.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v8i64_v8f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-GI-NEXT:    ucvtf v4.2d, v1.2d
; CHECK-GI-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-GI-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NEXT:    fcvtn v1.2s, v2.2d
; CHECK-GI-NEXT:    fcvtn2 v0.4s, v4.2d
; CHECK-GI-NEXT:    fcvtn2 v1.4s, v3.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <8 x i64> %a to <8 x float>
  ret <8 x float> %c
}

define <16 x float> @stofp_v16i64_v16f32(<16 x i64> %a) {
; CHECK-LABEL: stofp_v16i64_v16f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.2d, v0.2d
; CHECK-NEXT:    scvtf v2.2d, v2.2d
; CHECK-NEXT:    scvtf v4.2d, v4.2d
; CHECK-NEXT:    scvtf v6.2d, v6.2d
; CHECK-NEXT:    scvtf v16.2d, v1.2d
; CHECK-NEXT:    scvtf v17.2d, v3.2d
; CHECK-NEXT:    scvtf v5.2d, v5.2d
; CHECK-NEXT:    scvtf v7.2d, v7.2d
; CHECK-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-NEXT:    fcvtn v1.2s, v2.2d
; CHECK-NEXT:    fcvtn v2.2s, v4.2d
; CHECK-NEXT:    fcvtn v3.2s, v6.2d
; CHECK-NEXT:    fcvtn2 v0.4s, v16.2d
; CHECK-NEXT:    fcvtn2 v1.4s, v17.2d
; CHECK-NEXT:    fcvtn2 v2.4s, v5.2d
; CHECK-NEXT:    fcvtn2 v3.4s, v7.2d
; CHECK-NEXT:    ret
entry:
  %c = sitofp <16 x i64> %a to <16 x float>
  ret <16 x float> %c
}

define <16 x float> @utofp_v16i64_v16f32(<16 x i64> %a) {
; CHECK-LABEL: utofp_v16i64_v16f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-NEXT:    ucvtf v16.2d, v1.2d
; CHECK-NEXT:    ucvtf v17.2d, v3.2d
; CHECK-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-NEXT:    ucvtf v7.2d, v7.2d
; CHECK-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-NEXT:    fcvtn v1.2s, v2.2d
; CHECK-NEXT:    fcvtn v2.2s, v4.2d
; CHECK-NEXT:    fcvtn v3.2s, v6.2d
; CHECK-NEXT:    fcvtn2 v0.4s, v16.2d
; CHECK-NEXT:    fcvtn2 v1.4s, v17.2d
; CHECK-NEXT:    fcvtn2 v2.4s, v5.2d
; CHECK-NEXT:    fcvtn2 v3.4s, v7.2d
; CHECK-NEXT:    ret
entry:
  %c = uitofp <16 x i64> %a to <16 x float>
  ret <16 x float> %c
}

define <32 x float> @stofp_v32i64_v32f32(<32 x i64> %a) {
; CHECK-SD-LABEL: stofp_v32i64_v32f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldp q17, q16, [sp, #64]
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ldp q19, q18, [sp, #32]
; CHECK-SD-NEXT:    scvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    ldp q21, q20, [sp]
; CHECK-SD-NEXT:    scvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    ldp q23, q22, [sp, #96]
; CHECK-SD-NEXT:    scvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    scvtf v19.2d, v19.2d
; CHECK-SD-NEXT:    scvtf v17.2d, v17.2d
; CHECK-SD-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-SD-NEXT:    scvtf v21.2d, v21.2d
; CHECK-SD-NEXT:    scvtf v24.2d, v1.2d
; CHECK-SD-NEXT:    fcvtn v1.2s, v2.2d
; CHECK-SD-NEXT:    scvtf v23.2d, v23.2d
; CHECK-SD-NEXT:    scvtf v25.2d, v3.2d
; CHECK-SD-NEXT:    fcvtn v2.2s, v4.2d
; CHECK-SD-NEXT:    scvtf v26.2d, v5.2d
; CHECK-SD-NEXT:    fcvtn v3.2s, v6.2d
; CHECK-SD-NEXT:    scvtf v27.2d, v7.2d
; CHECK-SD-NEXT:    scvtf v20.2d, v20.2d
; CHECK-SD-NEXT:    fcvtn v5.2s, v19.2d
; CHECK-SD-NEXT:    scvtf v18.2d, v18.2d
; CHECK-SD-NEXT:    fcvtn v4.2s, v21.2d
; CHECK-SD-NEXT:    fcvtn v6.2s, v17.2d
; CHECK-SD-NEXT:    scvtf v16.2d, v16.2d
; CHECK-SD-NEXT:    fcvtn v7.2s, v23.2d
; CHECK-SD-NEXT:    scvtf v17.2d, v22.2d
; CHECK-SD-NEXT:    fcvtn2 v0.4s, v24.2d
; CHECK-SD-NEXT:    fcvtn2 v1.4s, v25.2d
; CHECK-SD-NEXT:    fcvtn2 v2.4s, v26.2d
; CHECK-SD-NEXT:    fcvtn2 v3.4s, v27.2d
; CHECK-SD-NEXT:    fcvtn2 v5.4s, v18.2d
; CHECK-SD-NEXT:    fcvtn2 v4.4s, v20.2d
; CHECK-SD-NEXT:    fcvtn2 v6.4s, v16.2d
; CHECK-SD-NEXT:    fcvtn2 v7.4s, v17.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v32i64_v32f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldp q16, q17, [sp]
; CHECK-GI-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    ldp q18, q19, [sp, #32]
; CHECK-GI-NEXT:    scvtf v24.2d, v1.2d
; CHECK-GI-NEXT:    ldp q20, q21, [sp, #64]
; CHECK-GI-NEXT:    scvtf v1.2d, v2.2d
; CHECK-GI-NEXT:    ldp q22, q23, [sp, #96]
; CHECK-GI-NEXT:    scvtf v25.2d, v3.2d
; CHECK-GI-NEXT:    scvtf v2.2d, v4.2d
; CHECK-GI-NEXT:    scvtf v26.2d, v5.2d
; CHECK-GI-NEXT:    scvtf v3.2d, v6.2d
; CHECK-GI-NEXT:    scvtf v27.2d, v7.2d
; CHECK-GI-NEXT:    scvtf v4.2d, v16.2d
; CHECK-GI-NEXT:    scvtf v5.2d, v18.2d
; CHECK-GI-NEXT:    scvtf v6.2d, v20.2d
; CHECK-GI-NEXT:    scvtf v7.2d, v22.2d
; CHECK-GI-NEXT:    scvtf v16.2d, v17.2d
; CHECK-GI-NEXT:    scvtf v17.2d, v19.2d
; CHECK-GI-NEXT:    scvtf v18.2d, v21.2d
; CHECK-GI-NEXT:    scvtf v19.2d, v23.2d
; CHECK-GI-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NEXT:    fcvtn v1.2s, v1.2d
; CHECK-GI-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-GI-NEXT:    fcvtn v3.2s, v3.2d
; CHECK-GI-NEXT:    fcvtn v4.2s, v4.2d
; CHECK-GI-NEXT:    fcvtn v5.2s, v5.2d
; CHECK-GI-NEXT:    fcvtn v6.2s, v6.2d
; CHECK-GI-NEXT:    fcvtn v7.2s, v7.2d
; CHECK-GI-NEXT:    fcvtn2 v0.4s, v24.2d
; CHECK-GI-NEXT:    fcvtn2 v1.4s, v25.2d
; CHECK-GI-NEXT:    fcvtn2 v2.4s, v26.2d
; CHECK-GI-NEXT:    fcvtn2 v3.4s, v27.2d
; CHECK-GI-NEXT:    fcvtn2 v4.4s, v16.2d
; CHECK-GI-NEXT:    fcvtn2 v5.4s, v17.2d
; CHECK-GI-NEXT:    fcvtn2 v6.4s, v18.2d
; CHECK-GI-NEXT:    fcvtn2 v7.4s, v19.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <32 x i64> %a to <32 x float>
  ret <32 x float> %c
}

define <32 x float> @utofp_v32i64_v32f32(<32 x i64> %a) {
; CHECK-SD-LABEL: utofp_v32i64_v32f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldp q17, q16, [sp, #64]
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ldp q19, q18, [sp, #32]
; CHECK-SD-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    ldp q21, q20, [sp]
; CHECK-SD-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    ldp q23, q22, [sp, #96]
; CHECK-SD-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    ucvtf v19.2d, v19.2d
; CHECK-SD-NEXT:    ucvtf v17.2d, v17.2d
; CHECK-SD-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-SD-NEXT:    ucvtf v21.2d, v21.2d
; CHECK-SD-NEXT:    ucvtf v24.2d, v1.2d
; CHECK-SD-NEXT:    fcvtn v1.2s, v2.2d
; CHECK-SD-NEXT:    ucvtf v23.2d, v23.2d
; CHECK-SD-NEXT:    ucvtf v25.2d, v3.2d
; CHECK-SD-NEXT:    fcvtn v2.2s, v4.2d
; CHECK-SD-NEXT:    ucvtf v26.2d, v5.2d
; CHECK-SD-NEXT:    fcvtn v3.2s, v6.2d
; CHECK-SD-NEXT:    ucvtf v27.2d, v7.2d
; CHECK-SD-NEXT:    ucvtf v20.2d, v20.2d
; CHECK-SD-NEXT:    fcvtn v5.2s, v19.2d
; CHECK-SD-NEXT:    ucvtf v18.2d, v18.2d
; CHECK-SD-NEXT:    fcvtn v4.2s, v21.2d
; CHECK-SD-NEXT:    fcvtn v6.2s, v17.2d
; CHECK-SD-NEXT:    ucvtf v16.2d, v16.2d
; CHECK-SD-NEXT:    fcvtn v7.2s, v23.2d
; CHECK-SD-NEXT:    ucvtf v17.2d, v22.2d
; CHECK-SD-NEXT:    fcvtn2 v0.4s, v24.2d
; CHECK-SD-NEXT:    fcvtn2 v1.4s, v25.2d
; CHECK-SD-NEXT:    fcvtn2 v2.4s, v26.2d
; CHECK-SD-NEXT:    fcvtn2 v3.4s, v27.2d
; CHECK-SD-NEXT:    fcvtn2 v5.4s, v18.2d
; CHECK-SD-NEXT:    fcvtn2 v4.4s, v20.2d
; CHECK-SD-NEXT:    fcvtn2 v6.4s, v16.2d
; CHECK-SD-NEXT:    fcvtn2 v7.4s, v17.2d
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v32i64_v32f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldp q16, q17, [sp]
; CHECK-GI-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NEXT:    ldp q18, q19, [sp, #32]
; CHECK-GI-NEXT:    ucvtf v24.2d, v1.2d
; CHECK-GI-NEXT:    ldp q20, q21, [sp, #64]
; CHECK-GI-NEXT:    ucvtf v1.2d, v2.2d
; CHECK-GI-NEXT:    ldp q22, q23, [sp, #96]
; CHECK-GI-NEXT:    ucvtf v25.2d, v3.2d
; CHECK-GI-NEXT:    ucvtf v2.2d, v4.2d
; CHECK-GI-NEXT:    ucvtf v26.2d, v5.2d
; CHECK-GI-NEXT:    ucvtf v3.2d, v6.2d
; CHECK-GI-NEXT:    ucvtf v27.2d, v7.2d
; CHECK-GI-NEXT:    ucvtf v4.2d, v16.2d
; CHECK-GI-NEXT:    ucvtf v5.2d, v18.2d
; CHECK-GI-NEXT:    ucvtf v6.2d, v20.2d
; CHECK-GI-NEXT:    ucvtf v7.2d, v22.2d
; CHECK-GI-NEXT:    ucvtf v16.2d, v17.2d
; CHECK-GI-NEXT:    ucvtf v17.2d, v19.2d
; CHECK-GI-NEXT:    ucvtf v18.2d, v21.2d
; CHECK-GI-NEXT:    ucvtf v19.2d, v23.2d
; CHECK-GI-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NEXT:    fcvtn v1.2s, v1.2d
; CHECK-GI-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-GI-NEXT:    fcvtn v3.2s, v3.2d
; CHECK-GI-NEXT:    fcvtn v4.2s, v4.2d
; CHECK-GI-NEXT:    fcvtn v5.2s, v5.2d
; CHECK-GI-NEXT:    fcvtn v6.2s, v6.2d
; CHECK-GI-NEXT:    fcvtn v7.2s, v7.2d
; CHECK-GI-NEXT:    fcvtn2 v0.4s, v24.2d
; CHECK-GI-NEXT:    fcvtn2 v1.4s, v25.2d
; CHECK-GI-NEXT:    fcvtn2 v2.4s, v26.2d
; CHECK-GI-NEXT:    fcvtn2 v3.4s, v27.2d
; CHECK-GI-NEXT:    fcvtn2 v4.4s, v16.2d
; CHECK-GI-NEXT:    fcvtn2 v5.4s, v17.2d
; CHECK-GI-NEXT:    fcvtn2 v6.4s, v18.2d
; CHECK-GI-NEXT:    fcvtn2 v7.4s, v19.2d
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <32 x i64> %a to <32 x float>
  ret <32 x float> %c
}

define <2 x float> @stofp_v2i32_v2f32(<2 x i32> %a) {
; CHECK-LABEL: stofp_v2i32_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <2 x i32> %a to <2 x float>
  ret <2 x float> %c
}

define <2 x float> @utofp_v2i32_v2f32(<2 x i32> %a) {
; CHECK-LABEL: utofp_v2i32_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <2 x i32> %a to <2 x float>
  ret <2 x float> %c
}

define <3 x float> @stofp_v3i32_v3f32(<3 x i32> %a) {
; CHECK-LABEL: stofp_v3i32_v3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <3 x i32> %a to <3 x float>
  ret <3 x float> %c
}

define <3 x float> @utofp_v3i32_v3f32(<3 x i32> %a) {
; CHECK-LABEL: utofp_v3i32_v3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <3 x i32> %a to <3 x float>
  ret <3 x float> %c
}

define <4 x float> @stofp_v4i32_v4f32(<4 x i32> %a) {
; CHECK-LABEL: stofp_v4i32_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <4 x i32> %a to <4 x float>
  ret <4 x float> %c
}

define <4 x float> @utofp_v4i32_v4f32(<4 x i32> %a) {
; CHECK-LABEL: utofp_v4i32_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <4 x i32> %a to <4 x float>
  ret <4 x float> %c
}

define <8 x float> @stofp_v8i32_v8f32(<8 x i32> %a) {
; CHECK-LABEL: stofp_v8i32_v8f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.4s, v0.4s
; CHECK-NEXT:    scvtf v1.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <8 x i32> %a to <8 x float>
  ret <8 x float> %c
}

define <8 x float> @utofp_v8i32_v8f32(<8 x i32> %a) {
; CHECK-LABEL: utofp_v8i32_v8f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <8 x i32> %a to <8 x float>
  ret <8 x float> %c
}

define <16 x float> @stofp_v16i32_v16f32(<16 x i32> %a) {
; CHECK-LABEL: stofp_v16i32_v16f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.4s, v0.4s
; CHECK-NEXT:    scvtf v1.4s, v1.4s
; CHECK-NEXT:    scvtf v2.4s, v2.4s
; CHECK-NEXT:    scvtf v3.4s, v3.4s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <16 x i32> %a to <16 x float>
  ret <16 x float> %c
}

define <16 x float> @utofp_v16i32_v16f32(<16 x i32> %a) {
; CHECK-LABEL: utofp_v16i32_v16f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-NEXT:    ucvtf v2.4s, v2.4s
; CHECK-NEXT:    ucvtf v3.4s, v3.4s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <16 x i32> %a to <16 x float>
  ret <16 x float> %c
}

define <32 x float> @stofp_v32i32_v32f32(<32 x i32> %a) {
; CHECK-LABEL: stofp_v32i32_v32f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.4s, v0.4s
; CHECK-NEXT:    scvtf v1.4s, v1.4s
; CHECK-NEXT:    scvtf v2.4s, v2.4s
; CHECK-NEXT:    scvtf v3.4s, v3.4s
; CHECK-NEXT:    scvtf v4.4s, v4.4s
; CHECK-NEXT:    scvtf v5.4s, v5.4s
; CHECK-NEXT:    scvtf v6.4s, v6.4s
; CHECK-NEXT:    scvtf v7.4s, v7.4s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <32 x i32> %a to <32 x float>
  ret <32 x float> %c
}

define <32 x float> @utofp_v32i32_v32f32(<32 x i32> %a) {
; CHECK-LABEL: utofp_v32i32_v32f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-NEXT:    ucvtf v2.4s, v2.4s
; CHECK-NEXT:    ucvtf v3.4s, v3.4s
; CHECK-NEXT:    ucvtf v4.4s, v4.4s
; CHECK-NEXT:    ucvtf v5.4s, v5.4s
; CHECK-NEXT:    ucvtf v6.4s, v6.4s
; CHECK-NEXT:    ucvtf v7.4s, v7.4s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <32 x i32> %a to <32 x float>
  ret <32 x float> %c
}

define <2 x float> @stofp_v2i16_v2f32(<2 x i16> %a) {
; CHECK-LABEL: stofp_v2i16_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    shl v0.2s, v0.2s, #16
; CHECK-NEXT:    sshr v0.2s, v0.2s, #16
; CHECK-NEXT:    scvtf v0.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <2 x i16> %a to <2 x float>
  ret <2 x float> %c
}

define <2 x float> @utofp_v2i16_v2f32(<2 x i16> %a) {
; CHECK-LABEL: utofp_v2i16_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi d1, #0x00ffff0000ffff
; CHECK-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ucvtf v0.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <2 x i16> %a to <2 x float>
  ret <2 x float> %c
}

define <3 x float> @stofp_v3i16_v3f32(<3 x i16> %a) {
; CHECK-LABEL: stofp_v3i16_v3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-NEXT:    scvtf v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <3 x i16> %a to <3 x float>
  ret <3 x float> %c
}

define <3 x float> @utofp_v3i16_v3f32(<3 x i16> %a) {
; CHECK-LABEL: utofp_v3i16_v3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <3 x i16> %a to <3 x float>
  ret <3 x float> %c
}

define <4 x float> @stofp_v4i16_v4f32(<4 x i16> %a) {
; CHECK-LABEL: stofp_v4i16_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-NEXT:    scvtf v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <4 x i16> %a to <4 x float>
  ret <4 x float> %c
}

define <4 x float> @utofp_v4i16_v4f32(<4 x i16> %a) {
; CHECK-LABEL: utofp_v4i16_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <4 x i16> %a to <4 x float>
  ret <4 x float> %c
}

define <8 x float> @stofp_v8i16_v8f32(<8 x i16> %a) {
; CHECK-SD-LABEL: stofp_v8i16_v8f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll2 v1.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    scvtf v1.4s, v1.4s
; CHECK-SD-NEXT:    scvtf v0.4s, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v8i16_v8f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v2.4s, v0.8h, #0
; CHECK-GI-NEXT:    scvtf v0.4s, v1.4s
; CHECK-GI-NEXT:    scvtf v1.4s, v2.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <8 x i16> %a to <8 x float>
  ret <8 x float> %c
}

define <8 x float> @utofp_v8i16_v8f32(<8 x i16> %a) {
; CHECK-SD-LABEL: utofp_v8i16_v8f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll2 v1.4s, v0.8h, #0
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-SD-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v8i16_v8f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v2.4s, v0.8h, #0
; CHECK-GI-NEXT:    ucvtf v0.4s, v1.4s
; CHECK-GI-NEXT:    ucvtf v1.4s, v2.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <8 x i16> %a to <8 x float>
  ret <8 x float> %c
}

define <16 x float> @stofp_v16i16_v16f32(<16 x i16> %a) {
; CHECK-SD-LABEL: stofp_v16i16_v16f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v2.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v3.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll2 v4.4s, v1.8h, #0
; CHECK-SD-NEXT:    sshll v5.4s, v1.4h, #0
; CHECK-SD-NEXT:    scvtf v0.4s, v2.4s
; CHECK-SD-NEXT:    scvtf v1.4s, v3.4s
; CHECK-SD-NEXT:    scvtf v3.4s, v4.4s
; CHECK-SD-NEXT:    scvtf v2.4s, v5.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v16i16_v16f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v2.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v4.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v5.4s, v1.8h, #0
; CHECK-GI-NEXT:    scvtf v0.4s, v2.4s
; CHECK-GI-NEXT:    scvtf v1.4s, v3.4s
; CHECK-GI-NEXT:    scvtf v2.4s, v4.4s
; CHECK-GI-NEXT:    scvtf v3.4s, v5.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <16 x i16> %a to <16 x float>
  ret <16 x float> %c
}

define <16 x float> @utofp_v16i16_v16f32(<16 x i16> %a) {
; CHECK-SD-LABEL: utofp_v16i16_v16f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v2.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll2 v3.4s, v0.8h, #0
; CHECK-SD-NEXT:    ushll2 v4.4s, v1.8h, #0
; CHECK-SD-NEXT:    ushll v5.4s, v1.4h, #0
; CHECK-SD-NEXT:    ucvtf v0.4s, v2.4s
; CHECK-SD-NEXT:    ucvtf v1.4s, v3.4s
; CHECK-SD-NEXT:    ucvtf v3.4s, v4.4s
; CHECK-SD-NEXT:    ucvtf v2.4s, v5.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v16i16_v16f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v2.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v3.4s, v0.8h, #0
; CHECK-GI-NEXT:    ushll v4.4s, v1.4h, #0
; CHECK-GI-NEXT:    ushll2 v5.4s, v1.8h, #0
; CHECK-GI-NEXT:    ucvtf v0.4s, v2.4s
; CHECK-GI-NEXT:    ucvtf v1.4s, v3.4s
; CHECK-GI-NEXT:    ucvtf v2.4s, v4.4s
; CHECK-GI-NEXT:    ucvtf v3.4s, v5.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <16 x i16> %a to <16 x float>
  ret <16 x float> %c
}

define <32 x float> @stofp_v32i16_v32f32(<32 x i16> %a) {
; CHECK-SD-LABEL: stofp_v32i16_v32f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll2 v4.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v5.4s, v1.8h, #0
; CHECK-SD-NEXT:    sshll v6.4s, v1.4h, #0
; CHECK-SD-NEXT:    sshll v7.4s, v2.4h, #0
; CHECK-SD-NEXT:    sshll2 v16.4s, v2.8h, #0
; CHECK-SD-NEXT:    sshll2 v17.4s, v3.8h, #0
; CHECK-SD-NEXT:    sshll v18.4s, v3.4h, #0
; CHECK-SD-NEXT:    scvtf v1.4s, v4.4s
; CHECK-SD-NEXT:    scvtf v0.4s, v0.4s
; CHECK-SD-NEXT:    scvtf v3.4s, v5.4s
; CHECK-SD-NEXT:    scvtf v2.4s, v6.4s
; CHECK-SD-NEXT:    scvtf v4.4s, v7.4s
; CHECK-SD-NEXT:    scvtf v5.4s, v16.4s
; CHECK-SD-NEXT:    scvtf v7.4s, v17.4s
; CHECK-SD-NEXT:    scvtf v6.4s, v18.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v32i16_v32f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v4.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v5.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v6.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v7.4s, v1.8h, #0
; CHECK-GI-NEXT:    sshll v16.4s, v2.4h, #0
; CHECK-GI-NEXT:    sshll2 v17.4s, v2.8h, #0
; CHECK-GI-NEXT:    sshll v18.4s, v3.4h, #0
; CHECK-GI-NEXT:    sshll2 v19.4s, v3.8h, #0
; CHECK-GI-NEXT:    scvtf v0.4s, v4.4s
; CHECK-GI-NEXT:    scvtf v1.4s, v5.4s
; CHECK-GI-NEXT:    scvtf v2.4s, v6.4s
; CHECK-GI-NEXT:    scvtf v3.4s, v7.4s
; CHECK-GI-NEXT:    scvtf v4.4s, v16.4s
; CHECK-GI-NEXT:    scvtf v5.4s, v17.4s
; CHECK-GI-NEXT:    scvtf v6.4s, v18.4s
; CHECK-GI-NEXT:    scvtf v7.4s, v19.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <32 x i16> %a to <32 x float>
  ret <32 x float> %c
}

define <32 x float> @utofp_v32i16_v32f32(<32 x i16> %a) {
; CHECK-SD-LABEL: utofp_v32i16_v32f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll2 v4.4s, v0.8h, #0
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll2 v5.4s, v1.8h, #0
; CHECK-SD-NEXT:    ushll v6.4s, v1.4h, #0
; CHECK-SD-NEXT:    ushll v7.4s, v2.4h, #0
; CHECK-SD-NEXT:    ushll2 v16.4s, v2.8h, #0
; CHECK-SD-NEXT:    ushll2 v17.4s, v3.8h, #0
; CHECK-SD-NEXT:    ushll v18.4s, v3.4h, #0
; CHECK-SD-NEXT:    ucvtf v1.4s, v4.4s
; CHECK-SD-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-SD-NEXT:    ucvtf v3.4s, v5.4s
; CHECK-SD-NEXT:    ucvtf v2.4s, v6.4s
; CHECK-SD-NEXT:    ucvtf v4.4s, v7.4s
; CHECK-SD-NEXT:    ucvtf v5.4s, v16.4s
; CHECK-SD-NEXT:    ucvtf v7.4s, v17.4s
; CHECK-SD-NEXT:    ucvtf v6.4s, v18.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v32i16_v32f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v4.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v5.4s, v0.8h, #0
; CHECK-GI-NEXT:    ushll v6.4s, v1.4h, #0
; CHECK-GI-NEXT:    ushll2 v7.4s, v1.8h, #0
; CHECK-GI-NEXT:    ushll v16.4s, v2.4h, #0
; CHECK-GI-NEXT:    ushll2 v17.4s, v2.8h, #0
; CHECK-GI-NEXT:    ushll v18.4s, v3.4h, #0
; CHECK-GI-NEXT:    ushll2 v19.4s, v3.8h, #0
; CHECK-GI-NEXT:    ucvtf v0.4s, v4.4s
; CHECK-GI-NEXT:    ucvtf v1.4s, v5.4s
; CHECK-GI-NEXT:    ucvtf v2.4s, v6.4s
; CHECK-GI-NEXT:    ucvtf v3.4s, v7.4s
; CHECK-GI-NEXT:    ucvtf v4.4s, v16.4s
; CHECK-GI-NEXT:    ucvtf v5.4s, v17.4s
; CHECK-GI-NEXT:    ucvtf v6.4s, v18.4s
; CHECK-GI-NEXT:    ucvtf v7.4s, v19.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <32 x i16> %a to <32 x float>
  ret <32 x float> %c
}

define <2 x float> @stofp_v2i8_v2f32(<2 x i8> %a) {
; CHECK-LABEL: stofp_v2i8_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    shl v0.2s, v0.2s, #24
; CHECK-NEXT:    sshr v0.2s, v0.2s, #24
; CHECK-NEXT:    scvtf v0.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <2 x i8> %a to <2 x float>
  ret <2 x float> %c
}

define <2 x float> @utofp_v2i8_v2f32(<2 x i8> %a) {
; CHECK-LABEL: utofp_v2i8_v2f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi d1, #0x0000ff000000ff
; CHECK-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    ucvtf v0.2s, v0.2s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <2 x i8> %a to <2 x float>
  ret <2 x float> %c
}

define <3 x float> @stofp_v3i8_v3f32(<3 x i8> %a) {
; CHECK-LABEL: stofp_v3i8_v3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov s0, w0
; CHECK-NEXT:    mov v0.h[1], w1
; CHECK-NEXT:    mov v0.h[2], w2
; CHECK-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-NEXT:    scvtf v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <3 x i8> %a to <3 x float>
  ret <3 x float> %c
}

define <3 x float> @utofp_v3i8_v3f32(<3 x i8> %a) {
; CHECK-LABEL: utofp_v3i8_v3f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov s0, w0
; CHECK-NEXT:    mov v0.h[1], w1
; CHECK-NEXT:    mov v0.h[2], w2
; CHECK-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <3 x i8> %a to <3 x float>
  ret <3 x float> %c
}

define <4 x float> @stofp_v4i8_v4f32(<4 x i8> %a) {
; CHECK-SD-LABEL: stofp_v4i8_v4f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-SD-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    scvtf v0.4s, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v4i8_v4f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    shl v0.4s, v0.4s, #24
; CHECK-GI-NEXT:    sshr v0.4s, v0.4s, #24
; CHECK-GI-NEXT:    scvtf v0.4s, v0.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <4 x i8> %a to <4 x float>
  ret <4 x float> %c
}

define <4 x float> @utofp_v4i8_v4f32(<4 x i8> %a) {
; CHECK-SD-LABEL: utofp_v4i8_v4f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v4i8_v4f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    movi v1.2d, #0x0000ff000000ff
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <4 x i8> %a to <4 x float>
  ret <4 x float> %c
}

define <8 x float> @stofp_v8i8_v8f32(<8 x i8> %a) {
; CHECK-SD-LABEL: stofp_v8i8_v8f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    zip1 v1.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    zip2 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    shl v1.4h, v1.4h, #8
; CHECK-SD-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-SD-NEXT:    sshr v1.4h, v1.4h, #8
; CHECK-SD-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-SD-NEXT:    sshll v1.4s, v1.4h, #0
; CHECK-SD-NEXT:    sshll v2.4s, v0.4h, #0
; CHECK-SD-NEXT:    scvtf v0.4s, v1.4s
; CHECK-SD-NEXT:    scvtf v1.4s, v2.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v8i8_v8f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v2.4s, v0.8h, #0
; CHECK-GI-NEXT:    scvtf v0.4s, v1.4s
; CHECK-GI-NEXT:    scvtf v1.4s, v2.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <8 x i8> %a to <8 x float>
  ret <8 x float> %c
}

define <8 x float> @utofp_v8i8_v8f32(<8 x i8> %a) {
; CHECK-SD-LABEL: utofp_v8i8_v8f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    zip1 v1.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    zip2 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    bic v1.4h, #255, lsl #8
; CHECK-SD-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    ushll v1.4s, v1.4h, #0
; CHECK-SD-NEXT:    ushll v2.4s, v0.4h, #0
; CHECK-SD-NEXT:    ucvtf v0.4s, v1.4s
; CHECK-SD-NEXT:    ucvtf v1.4s, v2.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v8i8_v8f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v2.4s, v0.8h, #0
; CHECK-GI-NEXT:    ucvtf v0.4s, v1.4s
; CHECK-GI-NEXT:    ucvtf v1.4s, v2.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <8 x i8> %a to <8 x float>
  ret <8 x float> %c
}

define <16 x float> @stofp_v16i8_v16f32(<16 x i8> %a) {
; CHECK-SD-LABEL: stofp_v16i8_v16f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    zip1 v2.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    zip2 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    zip1 v3.8b, v1.8b, v0.8b
; CHECK-SD-NEXT:    zip2 v1.8b, v1.8b, v0.8b
; CHECK-SD-NEXT:    shl v2.4h, v2.4h, #8
; CHECK-SD-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-SD-NEXT:    sshr v2.4h, v2.4h, #8
; CHECK-SD-NEXT:    shl v3.4h, v3.4h, #8
; CHECK-SD-NEXT:    shl v1.4h, v1.4h, #8
; CHECK-SD-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-SD-NEXT:    sshll v2.4s, v2.4h, #0
; CHECK-SD-NEXT:    sshr v3.4h, v3.4h, #8
; CHECK-SD-NEXT:    sshr v1.4h, v1.4h, #8
; CHECK-SD-NEXT:    sshll v4.4s, v0.4h, #0
; CHECK-SD-NEXT:    scvtf v0.4s, v2.4s
; CHECK-SD-NEXT:    sshll v3.4s, v3.4h, #0
; CHECK-SD-NEXT:    sshll v5.4s, v1.4h, #0
; CHECK-SD-NEXT:    scvtf v1.4s, v4.4s
; CHECK-SD-NEXT:    scvtf v2.4s, v3.4s
; CHECK-SD-NEXT:    scvtf v3.4s, v5.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v16i8_v16f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v1.8h, v0.8b, #0
; CHECK-GI-NEXT:    sshll2 v0.8h, v0.16b, #0
; CHECK-GI-NEXT:    sshll v2.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    sshll v3.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v4.4s, v0.8h, #0
; CHECK-GI-NEXT:    scvtf v0.4s, v2.4s
; CHECK-GI-NEXT:    scvtf v1.4s, v1.4s
; CHECK-GI-NEXT:    scvtf v2.4s, v3.4s
; CHECK-GI-NEXT:    scvtf v3.4s, v4.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <16 x i8> %a to <16 x float>
  ret <16 x float> %c
}

define <16 x float> @utofp_v16i8_v16f32(<16 x i8> %a) {
; CHECK-SD-LABEL: utofp_v16i8_v16f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    zip1 v2.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    zip2 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    zip1 v3.8b, v1.8b, v0.8b
; CHECK-SD-NEXT:    zip2 v1.8b, v1.8b, v0.8b
; CHECK-SD-NEXT:    bic v2.4h, #255, lsl #8
; CHECK-SD-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    ushll v2.4s, v2.4h, #0
; CHECK-SD-NEXT:    bic v3.4h, #255, lsl #8
; CHECK-SD-NEXT:    bic v1.4h, #255, lsl #8
; CHECK-SD-NEXT:    ushll v4.4s, v0.4h, #0
; CHECK-SD-NEXT:    ucvtf v0.4s, v2.4s
; CHECK-SD-NEXT:    ushll v3.4s, v3.4h, #0
; CHECK-SD-NEXT:    ushll v5.4s, v1.4h, #0
; CHECK-SD-NEXT:    ucvtf v1.4s, v4.4s
; CHECK-SD-NEXT:    ucvtf v2.4s, v3.4s
; CHECK-SD-NEXT:    ucvtf v3.4s, v5.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v16i8_v16f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v1.8h, v0.8b, #0
; CHECK-GI-NEXT:    ushll2 v0.8h, v0.16b, #0
; CHECK-GI-NEXT:    ushll v2.4s, v1.4h, #0
; CHECK-GI-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    ushll v3.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v4.4s, v0.8h, #0
; CHECK-GI-NEXT:    ucvtf v0.4s, v2.4s
; CHECK-GI-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-GI-NEXT:    ucvtf v2.4s, v3.4s
; CHECK-GI-NEXT:    ucvtf v3.4s, v4.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <16 x i8> %a to <16 x float>
  ret <16 x float> %c
}

define <32 x float> @stofp_v32i8_v32f32(<32 x i8> %a) {
; CHECK-SD-LABEL: stofp_v32i8_v32f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ext v2.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    ext v3.16b, v1.16b, v1.16b, #8
; CHECK-SD-NEXT:    zip1 v4.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    zip2 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    shl v4.4h, v4.4h, #8
; CHECK-SD-NEXT:    zip1 v5.8b, v1.8b, v0.8b
; CHECK-SD-NEXT:    zip1 v6.8b, v2.8b, v0.8b
; CHECK-SD-NEXT:    zip2 v2.8b, v2.8b, v0.8b
; CHECK-SD-NEXT:    zip2 v1.8b, v1.8b, v0.8b
; CHECK-SD-NEXT:    zip1 v7.8b, v3.8b, v0.8b
; CHECK-SD-NEXT:    zip2 v3.8b, v3.8b, v0.8b
; CHECK-SD-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-SD-NEXT:    sshr v4.4h, v4.4h, #8
; CHECK-SD-NEXT:    shl v5.4h, v5.4h, #8
; CHECK-SD-NEXT:    shl v6.4h, v6.4h, #8
; CHECK-SD-NEXT:    shl v2.4h, v2.4h, #8
; CHECK-SD-NEXT:    shl v1.4h, v1.4h, #8
; CHECK-SD-NEXT:    shl v7.4h, v7.4h, #8
; CHECK-SD-NEXT:    shl v3.4h, v3.4h, #8
; CHECK-SD-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-SD-NEXT:    sshll v4.4s, v4.4h, #0
; CHECK-SD-NEXT:    sshr v5.4h, v5.4h, #8
; CHECK-SD-NEXT:    sshr v6.4h, v6.4h, #8
; CHECK-SD-NEXT:    sshr v2.4h, v2.4h, #8
; CHECK-SD-NEXT:    sshr v1.4h, v1.4h, #8
; CHECK-SD-NEXT:    sshr v7.4h, v7.4h, #8
; CHECK-SD-NEXT:    sshr v3.4h, v3.4h, #8
; CHECK-SD-NEXT:    sshll v16.4s, v0.4h, #0
; CHECK-SD-NEXT:    scvtf v0.4s, v4.4s
; CHECK-SD-NEXT:    sshll v5.4s, v5.4h, #0
; CHECK-SD-NEXT:    sshll v6.4s, v6.4h, #0
; CHECK-SD-NEXT:    sshll v17.4s, v2.4h, #0
; CHECK-SD-NEXT:    sshll v18.4s, v1.4h, #0
; CHECK-SD-NEXT:    sshll v7.4s, v7.4h, #0
; CHECK-SD-NEXT:    sshll v19.4s, v3.4h, #0
; CHECK-SD-NEXT:    scvtf v1.4s, v16.4s
; CHECK-SD-NEXT:    scvtf v4.4s, v5.4s
; CHECK-SD-NEXT:    scvtf v2.4s, v6.4s
; CHECK-SD-NEXT:    scvtf v3.4s, v17.4s
; CHECK-SD-NEXT:    scvtf v5.4s, v18.4s
; CHECK-SD-NEXT:    scvtf v6.4s, v7.4s
; CHECK-SD-NEXT:    scvtf v7.4s, v19.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v32i8_v32f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v2.8h, v0.8b, #0
; CHECK-GI-NEXT:    sshll2 v0.8h, v0.16b, #0
; CHECK-GI-NEXT:    sshll v3.8h, v1.8b, #0
; CHECK-GI-NEXT:    sshll2 v1.8h, v1.16b, #0
; CHECK-GI-NEXT:    sshll v4.4s, v2.4h, #0
; CHECK-GI-NEXT:    sshll2 v2.4s, v2.8h, #0
; CHECK-GI-NEXT:    sshll v5.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v6.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v7.4s, v3.4h, #0
; CHECK-GI-NEXT:    sshll2 v16.4s, v3.8h, #0
; CHECK-GI-NEXT:    sshll v17.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v18.4s, v1.8h, #0
; CHECK-GI-NEXT:    scvtf v0.4s, v4.4s
; CHECK-GI-NEXT:    scvtf v1.4s, v2.4s
; CHECK-GI-NEXT:    scvtf v2.4s, v5.4s
; CHECK-GI-NEXT:    scvtf v3.4s, v6.4s
; CHECK-GI-NEXT:    scvtf v4.4s, v7.4s
; CHECK-GI-NEXT:    scvtf v5.4s, v16.4s
; CHECK-GI-NEXT:    scvtf v6.4s, v17.4s
; CHECK-GI-NEXT:    scvtf v7.4s, v18.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <32 x i8> %a to <32 x float>
  ret <32 x float> %c
}

define <32 x float> @utofp_v32i8_v32f32(<32 x i8> %a) {
; CHECK-SD-LABEL: utofp_v32i8_v32f32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ext v2.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    ext v3.16b, v1.16b, v1.16b, #8
; CHECK-SD-NEXT:    zip1 v4.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    zip2 v0.8b, v0.8b, v0.8b
; CHECK-SD-NEXT:    bic v4.4h, #255, lsl #8
; CHECK-SD-NEXT:    zip1 v5.8b, v1.8b, v0.8b
; CHECK-SD-NEXT:    zip1 v6.8b, v2.8b, v0.8b
; CHECK-SD-NEXT:    zip2 v2.8b, v2.8b, v0.8b
; CHECK-SD-NEXT:    zip2 v1.8b, v1.8b, v0.8b
; CHECK-SD-NEXT:    zip1 v7.8b, v3.8b, v0.8b
; CHECK-SD-NEXT:    zip2 v3.8b, v3.8b, v0.8b
; CHECK-SD-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-NEXT:    ushll v4.4s, v4.4h, #0
; CHECK-SD-NEXT:    bic v5.4h, #255, lsl #8
; CHECK-SD-NEXT:    bic v6.4h, #255, lsl #8
; CHECK-SD-NEXT:    bic v2.4h, #255, lsl #8
; CHECK-SD-NEXT:    bic v1.4h, #255, lsl #8
; CHECK-SD-NEXT:    bic v7.4h, #255, lsl #8
; CHECK-SD-NEXT:    bic v3.4h, #255, lsl #8
; CHECK-SD-NEXT:    ushll v16.4s, v0.4h, #0
; CHECK-SD-NEXT:    ucvtf v0.4s, v4.4s
; CHECK-SD-NEXT:    ushll v5.4s, v5.4h, #0
; CHECK-SD-NEXT:    ushll v6.4s, v6.4h, #0
; CHECK-SD-NEXT:    ushll v17.4s, v2.4h, #0
; CHECK-SD-NEXT:    ushll v18.4s, v1.4h, #0
; CHECK-SD-NEXT:    ushll v7.4s, v7.4h, #0
; CHECK-SD-NEXT:    ushll v19.4s, v3.4h, #0
; CHECK-SD-NEXT:    ucvtf v1.4s, v16.4s
; CHECK-SD-NEXT:    ucvtf v4.4s, v5.4s
; CHECK-SD-NEXT:    ucvtf v2.4s, v6.4s
; CHECK-SD-NEXT:    ucvtf v3.4s, v17.4s
; CHECK-SD-NEXT:    ucvtf v5.4s, v18.4s
; CHECK-SD-NEXT:    ucvtf v6.4s, v7.4s
; CHECK-SD-NEXT:    ucvtf v7.4s, v19.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v32i8_v32f32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v2.8h, v0.8b, #0
; CHECK-GI-NEXT:    ushll2 v0.8h, v0.16b, #0
; CHECK-GI-NEXT:    ushll v3.8h, v1.8b, #0
; CHECK-GI-NEXT:    ushll2 v1.8h, v1.16b, #0
; CHECK-GI-NEXT:    ushll v4.4s, v2.4h, #0
; CHECK-GI-NEXT:    ushll2 v2.4s, v2.8h, #0
; CHECK-GI-NEXT:    ushll v5.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v6.4s, v0.8h, #0
; CHECK-GI-NEXT:    ushll v7.4s, v3.4h, #0
; CHECK-GI-NEXT:    ushll2 v16.4s, v3.8h, #0
; CHECK-GI-NEXT:    ushll v17.4s, v1.4h, #0
; CHECK-GI-NEXT:    ushll2 v18.4s, v1.8h, #0
; CHECK-GI-NEXT:    ucvtf v0.4s, v4.4s
; CHECK-GI-NEXT:    ucvtf v1.4s, v2.4s
; CHECK-GI-NEXT:    ucvtf v2.4s, v5.4s
; CHECK-GI-NEXT:    ucvtf v3.4s, v6.4s
; CHECK-GI-NEXT:    ucvtf v4.4s, v7.4s
; CHECK-GI-NEXT:    ucvtf v5.4s, v16.4s
; CHECK-GI-NEXT:    ucvtf v6.4s, v17.4s
; CHECK-GI-NEXT:    ucvtf v7.4s, v18.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <32 x i8> %a to <32 x float>
  ret <32 x float> %c
}

define <2 x half> @stofp_v2i64_v2f16(<2 x i64> %a) {
; CHECK-SD-NOFP16-LABEL: stofp_v2i64_v2f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    mov x8, v0.d[1]
; CHECK-SD-NOFP16-NEXT:    fmov x9, d0
; CHECK-SD-NOFP16-NEXT:    scvtf s1, x9
; CHECK-SD-NOFP16-NEXT:    scvtf s0, x8
; CHECK-SD-NOFP16-NEXT:    fcvt h2, s0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s1
; CHECK-SD-NOFP16-NEXT:    mov v0.h[1], v2.h[0]
; CHECK-SD-NOFP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_v2i64_v2f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    mov x8, v0.d[1]
; CHECK-SD-FP16-NEXT:    fmov x9, d0
; CHECK-SD-FP16-NEXT:    scvtf h0, x9
; CHECK-SD-FP16-NEXT:    scvtf h1, x8
; CHECK-SD-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v2i64_v2f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NOFP16-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[2], v0.s[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[3], v0.s[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-NOFP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v2i64_v2f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-FP16-NEXT:    mov d1, v0.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h0, d0
; CHECK-GI-FP16-NEXT:    fcvt h1, d1
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <2 x i64> %a to <2 x half>
  ret <2 x half> %c
}

define <2 x half> @utofp_v2i64_v2f16(<2 x i64> %a) {
; CHECK-SD-NOFP16-LABEL: utofp_v2i64_v2f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    mov x8, v0.d[1]
; CHECK-SD-NOFP16-NEXT:    fmov x9, d0
; CHECK-SD-NOFP16-NEXT:    ucvtf s1, x9
; CHECK-SD-NOFP16-NEXT:    ucvtf s0, x8
; CHECK-SD-NOFP16-NEXT:    fcvt h2, s0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s1
; CHECK-SD-NOFP16-NEXT:    mov v0.h[1], v2.h[0]
; CHECK-SD-NOFP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_v2i64_v2f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    mov x8, v0.d[1]
; CHECK-SD-FP16-NEXT:    fmov x9, d0
; CHECK-SD-FP16-NEXT:    ucvtf h0, x9
; CHECK-SD-FP16-NEXT:    ucvtf h1, x8
; CHECK-SD-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v2i64_v2f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NOFP16-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[2], v0.s[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[3], v0.s[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-NOFP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v2i64_v2f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-FP16-NEXT:    mov d1, v0.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h0, d0
; CHECK-GI-FP16-NEXT:    fcvt h1, d1
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <2 x i64> %a to <2 x half>
  ret <2 x half> %c
}

define <3 x half> @stofp_v3i64_v3f16(<3 x i64> %a) {
; CHECK-SD-LABEL: stofp_v3i64_v3f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    scvtf v1.2d, v2.2d
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-SD-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-SD-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v3i64_v3f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NOFP16-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NOFP16-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-NOFP16-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NOFP16-NEXT:    scvtf v1.2d, v2.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v3i64_v3f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-FP16-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-FP16-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-FP16-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-FP16-NEXT:    scvtf v2.2d, v2.2d
; CHECK-GI-FP16-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-FP16-NEXT:    fcvt h2, d2
; CHECK-GI-FP16-NEXT:    mov d1, v0.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h0, d0
; CHECK-GI-FP16-NEXT:    fcvt h1, d1
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v2.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <3 x i64> %a to <3 x half>
  ret <3 x half> %c
}

define <3 x half> @utofp_v3i64_v3f16(<3 x i64> %a) {
; CHECK-SD-LABEL: utofp_v3i64_v3f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-SD-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-SD-NEXT:    ucvtf v1.2d, v2.2d
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-SD-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-SD-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v3i64_v3f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NOFP16-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-NOFP16-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-NOFP16-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-NOFP16-NEXT:    ucvtf v1.2d, v2.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v3i64_v3f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-FP16-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-GI-FP16-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-GI-FP16-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-GI-FP16-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-GI-FP16-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-FP16-NEXT:    fcvt h2, d2
; CHECK-GI-FP16-NEXT:    mov d1, v0.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h0, d0
; CHECK-GI-FP16-NEXT:    fcvt h1, d1
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v2.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <3 x i64> %a to <3 x half>
  ret <3 x half> %c
}

define <4 x half> @stofp_v4i64_v4f16(<4 x i64> %a) {
; CHECK-SD-LABEL: stofp_v4i64_v4f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    scvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-SD-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-SD-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v4i64_v4f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v4i64_v4f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-FP16-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-FP16-NEXT:    mov d2, v0.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h0, d0
; CHECK-GI-FP16-NEXT:    mov d3, v1.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h1, d1
; CHECK-GI-FP16-NEXT:    fcvt h2, d2
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v2.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h2, d3
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v2.h[0]
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <4 x i64> %a to <4 x half>
  ret <4 x half> %c
}

define <4 x half> @utofp_v4i64_v4f16(<4 x i64> %a) {
; CHECK-SD-LABEL: utofp_v4i64_v4f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-SD-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-SD-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v4i64_v4f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v4i64_v4f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-FP16-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-FP16-NEXT:    mov d2, v0.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h0, d0
; CHECK-GI-FP16-NEXT:    mov d3, v1.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h1, d1
; CHECK-GI-FP16-NEXT:    fcvt h2, d2
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v2.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h2, d3
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v2.h[0]
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <4 x i64> %a to <4 x half>
  ret <4 x half> %c
}

define <8 x half> @stofp_v8i64_v8f16(<8 x i64> %a) {
; CHECK-SD-LABEL: stofp_v8i64_v8f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    scvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-SD-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-SD-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-SD-NEXT:    fcvtn2 v2.4s, v3.2d
; CHECK-SD-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v8i64_v8f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v2.2d, v2.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v3.2d, v3.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v2.4s, v3.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v8i64_v8f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-FP16-NEXT:    scvtf v2.2d, v2.2d
; CHECK-GI-FP16-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-FP16-NEXT:    scvtf v3.2d, v3.2d
; CHECK-GI-FP16-NEXT:    mov d4, v0.d[1]
; CHECK-GI-FP16-NEXT:    mov d5, v2.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h0, d0
; CHECK-GI-FP16-NEXT:    fcvt h2, d2
; CHECK-GI-FP16-NEXT:    fcvt h4, d4
; CHECK-GI-FP16-NEXT:    fcvt h5, d5
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v4.h[0]
; CHECK-GI-FP16-NEXT:    mov d4, v1.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h1, d1
; CHECK-GI-FP16-NEXT:    mov v2.h[1], v5.h[0]
; CHECK-GI-FP16-NEXT:    mov d5, v3.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h3, d3
; CHECK-GI-FP16-NEXT:    fcvt h4, d4
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v1.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h1, d5
; CHECK-GI-FP16-NEXT:    mov v2.h[2], v3.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v4.h[0]
; CHECK-GI-FP16-NEXT:    mov v2.h[3], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.d[1], v2.d[0]
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <8 x i64> %a to <8 x half>
  ret <8 x half> %c
}

define <8 x half> @utofp_v8i64_v8f16(<8 x i64> %a) {
; CHECK-SD-LABEL: utofp_v8i64_v8f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-SD-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-SD-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-SD-NEXT:    fcvtn2 v2.4s, v3.2d
; CHECK-SD-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v8i64_v8f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v2.4s, v3.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v8i64_v8f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-FP16-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-GI-FP16-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-FP16-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-GI-FP16-NEXT:    mov d4, v0.d[1]
; CHECK-GI-FP16-NEXT:    mov d5, v2.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h0, d0
; CHECK-GI-FP16-NEXT:    fcvt h2, d2
; CHECK-GI-FP16-NEXT:    fcvt h4, d4
; CHECK-GI-FP16-NEXT:    fcvt h5, d5
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v4.h[0]
; CHECK-GI-FP16-NEXT:    mov d4, v1.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h1, d1
; CHECK-GI-FP16-NEXT:    mov v2.h[1], v5.h[0]
; CHECK-GI-FP16-NEXT:    mov d5, v3.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h3, d3
; CHECK-GI-FP16-NEXT:    fcvt h4, d4
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v1.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h1, d5
; CHECK-GI-FP16-NEXT:    mov v2.h[2], v3.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v4.h[0]
; CHECK-GI-FP16-NEXT:    mov v2.h[3], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.d[1], v2.d[0]
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <8 x i64> %a to <8 x half>
  ret <8 x half> %c
}

define <16 x half> @stofp_v16i64_v16f16(<16 x i64> %a) {
; CHECK-SD-LABEL: stofp_v16i64_v16f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    scvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    scvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    scvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    scvtf v5.2d, v5.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-SD-NEXT:    fcvtn v4.2s, v4.2d
; CHECK-SD-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-SD-NEXT:    fcvtn v6.2s, v6.2d
; CHECK-SD-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-SD-NEXT:    scvtf v1.2d, v7.2d
; CHECK-SD-NEXT:    fcvtn2 v4.4s, v5.2d
; CHECK-SD-NEXT:    fcvtn2 v2.4s, v3.2d
; CHECK-SD-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NEXT:    fcvtn2 v6.4s, v1.2d
; CHECK-SD-NEXT:    fcvtn v1.4h, v4.4s
; CHECK-SD-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-SD-NEXT:    fcvtn2 v1.8h, v6.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v16i64_v16f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v4.2d, v4.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v2.2d, v2.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v5.2d, v5.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v6.2d, v6.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v3.2d, v3.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v7.2d, v7.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v4.2s, v4.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v6.2s, v6.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v4.4s, v5.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v2.4s, v3.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v6.4s, v7.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v6.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v16i64_v16f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-FP16-NEXT:    scvtf v16.2d, v2.2d
; CHECK-GI-FP16-NEXT:    scvtf v4.2d, v4.2d
; CHECK-GI-FP16-NEXT:    scvtf v2.2d, v6.2d
; CHECK-GI-FP16-NEXT:    scvtf v20.2d, v1.2d
; CHECK-GI-FP16-NEXT:    scvtf v3.2d, v3.2d
; CHECK-GI-FP16-NEXT:    scvtf v5.2d, v5.2d
; CHECK-GI-FP16-NEXT:    scvtf v7.2d, v7.2d
; CHECK-GI-FP16-NEXT:    mov d6, v0.d[1]
; CHECK-GI-FP16-NEXT:    mov d17, v16.d[1]
; CHECK-GI-FP16-NEXT:    mov d18, v4.d[1]
; CHECK-GI-FP16-NEXT:    mov d19, v2.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h0, d0
; CHECK-GI-FP16-NEXT:    fcvt h16, d16
; CHECK-GI-FP16-NEXT:    fcvt h1, d4
; CHECK-GI-FP16-NEXT:    fcvt h2, d2
; CHECK-GI-FP16-NEXT:    fcvt h6, d6
; CHECK-GI-FP16-NEXT:    fcvt h17, d17
; CHECK-GI-FP16-NEXT:    fcvt h4, d18
; CHECK-GI-FP16-NEXT:    fcvt h18, d19
; CHECK-GI-FP16-NEXT:    fcvt h19, d20
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v6.h[0]
; CHECK-GI-FP16-NEXT:    mov d6, v20.d[1]
; CHECK-GI-FP16-NEXT:    mov v16.h[1], v17.h[0]
; CHECK-GI-FP16-NEXT:    mov d17, v3.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h3, d3
; CHECK-GI-FP16-NEXT:    mov v1.h[1], v4.h[0]
; CHECK-GI-FP16-NEXT:    mov d4, v5.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h5, d5
; CHECK-GI-FP16-NEXT:    mov v2.h[1], v18.h[0]
; CHECK-GI-FP16-NEXT:    mov d18, v7.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h7, d7
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v19.h[0]
; CHECK-GI-FP16-NEXT:    mov v16.h[2], v3.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h3, d6
; CHECK-GI-FP16-NEXT:    fcvt h6, d17
; CHECK-GI-FP16-NEXT:    fcvt h4, d4
; CHECK-GI-FP16-NEXT:    mov v1.h[2], v5.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h5, d18
; CHECK-GI-FP16-NEXT:    mov v2.h[2], v7.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v3.h[0]
; CHECK-GI-FP16-NEXT:    mov v16.h[3], v6.h[0]
; CHECK-GI-FP16-NEXT:    mov v1.h[3], v4.h[0]
; CHECK-GI-FP16-NEXT:    mov v2.h[3], v5.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.d[1], v16.d[0]
; CHECK-GI-FP16-NEXT:    mov v1.d[1], v2.d[0]
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <16 x i64> %a to <16 x half>
  ret <16 x half> %c
}

define <16 x half> @utofp_v16i64_v16f16(<16 x i64> %a) {
; CHECK-SD-LABEL: utofp_v16i64_v16f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-SD-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-SD-NEXT:    fcvtn v4.2s, v4.2d
; CHECK-SD-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-SD-NEXT:    fcvtn v6.2s, v6.2d
; CHECK-SD-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-SD-NEXT:    ucvtf v1.2d, v7.2d
; CHECK-SD-NEXT:    fcvtn2 v4.4s, v5.2d
; CHECK-SD-NEXT:    fcvtn2 v2.4s, v3.2d
; CHECK-SD-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NEXT:    fcvtn2 v6.4s, v1.2d
; CHECK-SD-NEXT:    fcvtn v1.4h, v4.4s
; CHECK-SD-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-SD-NEXT:    fcvtn2 v1.8h, v6.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v16i64_v16f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v7.2d, v7.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v4.2s, v4.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v2.2s, v2.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v6.2s, v6.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v4.4s, v5.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v2.4s, v3.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v6.4s, v7.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v6.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v16i64_v16f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-FP16-NEXT:    ucvtf v16.2d, v2.2d
; CHECK-GI-FP16-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-GI-FP16-NEXT:    ucvtf v2.2d, v6.2d
; CHECK-GI-FP16-NEXT:    ucvtf v20.2d, v1.2d
; CHECK-GI-FP16-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-GI-FP16-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-GI-FP16-NEXT:    ucvtf v7.2d, v7.2d
; CHECK-GI-FP16-NEXT:    mov d6, v0.d[1]
; CHECK-GI-FP16-NEXT:    mov d17, v16.d[1]
; CHECK-GI-FP16-NEXT:    mov d18, v4.d[1]
; CHECK-GI-FP16-NEXT:    mov d19, v2.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h0, d0
; CHECK-GI-FP16-NEXT:    fcvt h16, d16
; CHECK-GI-FP16-NEXT:    fcvt h1, d4
; CHECK-GI-FP16-NEXT:    fcvt h2, d2
; CHECK-GI-FP16-NEXT:    fcvt h6, d6
; CHECK-GI-FP16-NEXT:    fcvt h17, d17
; CHECK-GI-FP16-NEXT:    fcvt h4, d18
; CHECK-GI-FP16-NEXT:    fcvt h18, d19
; CHECK-GI-FP16-NEXT:    fcvt h19, d20
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v6.h[0]
; CHECK-GI-FP16-NEXT:    mov d6, v20.d[1]
; CHECK-GI-FP16-NEXT:    mov v16.h[1], v17.h[0]
; CHECK-GI-FP16-NEXT:    mov d17, v3.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h3, d3
; CHECK-GI-FP16-NEXT:    mov v1.h[1], v4.h[0]
; CHECK-GI-FP16-NEXT:    mov d4, v5.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h5, d5
; CHECK-GI-FP16-NEXT:    mov v2.h[1], v18.h[0]
; CHECK-GI-FP16-NEXT:    mov d18, v7.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h7, d7
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v19.h[0]
; CHECK-GI-FP16-NEXT:    mov v16.h[2], v3.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h3, d6
; CHECK-GI-FP16-NEXT:    fcvt h6, d17
; CHECK-GI-FP16-NEXT:    fcvt h4, d4
; CHECK-GI-FP16-NEXT:    mov v1.h[2], v5.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h5, d18
; CHECK-GI-FP16-NEXT:    mov v2.h[2], v7.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v3.h[0]
; CHECK-GI-FP16-NEXT:    mov v16.h[3], v6.h[0]
; CHECK-GI-FP16-NEXT:    mov v1.h[3], v4.h[0]
; CHECK-GI-FP16-NEXT:    mov v2.h[3], v5.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.d[1], v16.d[0]
; CHECK-GI-FP16-NEXT:    mov v1.d[1], v2.d[0]
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <16 x i64> %a to <16 x half>
  ret <16 x half> %c
}

define <32 x half> @stofp_v32i64_v32f16(<32 x i64> %a) {
; CHECK-SD-LABEL: stofp_v32i64_v32f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldp q17, q16, [sp]
; CHECK-SD-NEXT:    scvtf v18.2d, v0.2d
; CHECK-SD-NEXT:    ldp q19, q0, [sp, #64]
; CHECK-SD-NEXT:    scvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    ldp q21, q20, [sp, #96]
; CHECK-SD-NEXT:    scvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    scvtf v17.2d, v17.2d
; CHECK-SD-NEXT:    ldp q23, q22, [sp, #32]
; CHECK-SD-NEXT:    scvtf v19.2d, v19.2d
; CHECK-SD-NEXT:    fcvtn v18.2s, v18.2d
; CHECK-SD-NEXT:    scvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    scvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    fcvtn v4.2s, v4.2d
; CHECK-SD-NEXT:    scvtf v5.2d, v5.2d
; CHECK-SD-NEXT:    scvtf v23.2d, v23.2d
; CHECK-SD-NEXT:    scvtf v16.2d, v16.2d
; CHECK-SD-NEXT:    scvtf v21.2d, v21.2d
; CHECK-SD-NEXT:    fcvtn v17.2s, v17.2d
; CHECK-SD-NEXT:    scvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    fcvtn v24.2s, v2.2d
; CHECK-SD-NEXT:    fcvtn v19.2s, v19.2d
; CHECK-SD-NEXT:    scvtf v2.2d, v3.2d
; CHECK-SD-NEXT:    fcvtn2 v18.4s, v1.2d
; CHECK-SD-NEXT:    fcvtn v6.2s, v6.2d
; CHECK-SD-NEXT:    scvtf v1.2d, v7.2d
; CHECK-SD-NEXT:    fcvtn2 v4.4s, v5.2d
; CHECK-SD-NEXT:    fcvtn v5.2s, v23.2d
; CHECK-SD-NEXT:    scvtf v3.2d, v22.2d
; CHECK-SD-NEXT:    fcvtn v7.2s, v21.2d
; CHECK-SD-NEXT:    fcvtn2 v17.4s, v16.2d
; CHECK-SD-NEXT:    scvtf v16.2d, v20.2d
; CHECK-SD-NEXT:    fcvtn2 v19.4s, v0.2d
; CHECK-SD-NEXT:    fcvtn2 v24.4s, v2.2d
; CHECK-SD-NEXT:    fcvtn v0.4h, v18.4s
; CHECK-SD-NEXT:    fcvtn2 v6.4s, v1.2d
; CHECK-SD-NEXT:    fcvtn v1.4h, v4.4s
; CHECK-SD-NEXT:    fcvtn2 v5.4s, v3.2d
; CHECK-SD-NEXT:    fcvtn v2.4h, v17.4s
; CHECK-SD-NEXT:    fcvtn2 v7.4s, v16.2d
; CHECK-SD-NEXT:    fcvtn v3.4h, v19.4s
; CHECK-SD-NEXT:    fcvtn2 v0.8h, v24.4s
; CHECK-SD-NEXT:    fcvtn2 v1.8h, v6.4s
; CHECK-SD-NEXT:    fcvtn2 v2.8h, v5.4s
; CHECK-SD-NEXT:    fcvtn2 v3.8h, v7.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v32i64_v32f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ldp q16, q17, [sp]
; CHECK-GI-NOFP16-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-NOFP16-NEXT:    ldp q20, q21, [sp, #64]
; CHECK-GI-NOFP16-NEXT:    scvtf v4.2d, v4.2d
; CHECK-GI-NOFP16-NEXT:    ldp q18, q19, [sp, #32]
; CHECK-GI-NOFP16-NEXT:    scvtf v1.2d, v1.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v16.2d, v16.2d
; CHECK-GI-NOFP16-NEXT:    ldp q22, q23, [sp, #96]
; CHECK-GI-NOFP16-NEXT:    scvtf v20.2d, v20.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v2.2d, v2.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v5.2d, v5.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v6.2d, v6.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v17.2d, v17.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v18.2d, v18.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v21.2d, v21.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v22.2d, v22.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v4.2s, v4.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v16.2s, v16.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v3.2d, v3.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v20.2s, v20.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v7.2d, v7.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v19.2d, v19.2d
; CHECK-GI-NOFP16-NEXT:    scvtf v23.2d, v23.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v24.2s, v2.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v6.2s, v6.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v18.2s, v18.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v22.2s, v22.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v4.4s, v5.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v16.4s, v17.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v20.4s, v21.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v24.4s, v3.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v6.4s, v7.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v18.4s, v19.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v22.4s, v23.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v2.4h, v16.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v3.4h, v20.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v24.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v6.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v2.8h, v18.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v3.8h, v22.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v32i64_v32f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    scvtf v16.2d, v2.2d
; CHECK-GI-FP16-NEXT:    scvtf v0.2d, v0.2d
; CHECK-GI-FP16-NEXT:    scvtf v18.2d, v4.2d
; CHECK-GI-FP16-NEXT:    scvtf v17.2d, v6.2d
; CHECK-GI-FP16-NEXT:    scvtf v4.2d, v1.2d
; CHECK-GI-FP16-NEXT:    scvtf v3.2d, v3.2d
; CHECK-GI-FP16-NEXT:    ldp q1, q23, [sp]
; CHECK-GI-FP16-NEXT:    scvtf v5.2d, v5.2d
; CHECK-GI-FP16-NEXT:    scvtf v6.2d, v7.2d
; CHECK-GI-FP16-NEXT:    mov d20, v16.d[1]
; CHECK-GI-FP16-NEXT:    mov d19, v0.d[1]
; CHECK-GI-FP16-NEXT:    mov d21, v18.d[1]
; CHECK-GI-FP16-NEXT:    mov d22, v17.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h16, d16
; CHECK-GI-FP16-NEXT:    scvtf v2.2d, v1.2d
; CHECK-GI-FP16-NEXT:    fcvt h0, d0
; CHECK-GI-FP16-NEXT:    fcvt h1, d18
; CHECK-GI-FP16-NEXT:    ldr q18, [sp, #32]
; CHECK-GI-FP16-NEXT:    fcvt h7, d17
; CHECK-GI-FP16-NEXT:    ldp q25, q17, [sp, #48]
; CHECK-GI-FP16-NEXT:    fcvt h20, d20
; CHECK-GI-FP16-NEXT:    fcvt h24, d19
; CHECK-GI-FP16-NEXT:    fcvt h21, d21
; CHECK-GI-FP16-NEXT:    fcvt h22, d22
; CHECK-GI-FP16-NEXT:    scvtf v18.2d, v18.2d
; CHECK-GI-FP16-NEXT:    fcvt h26, d4
; CHECK-GI-FP16-NEXT:    scvtf v17.2d, v17.2d
; CHECK-GI-FP16-NEXT:    fcvt h27, d3
; CHECK-GI-FP16-NEXT:    fcvt h28, d6
; CHECK-GI-FP16-NEXT:    scvtf v23.2d, v23.2d
; CHECK-GI-FP16-NEXT:    scvtf v25.2d, v25.2d
; CHECK-GI-FP16-NEXT:    mov d4, v4.d[1]
; CHECK-GI-FP16-NEXT:    mov v16.h[1], v20.h[0]
; CHECK-GI-FP16-NEXT:    ldp q19, q20, [sp, #80]
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v24.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h24, d5
; CHECK-GI-FP16-NEXT:    mov v1.h[1], v21.h[0]
; CHECK-GI-FP16-NEXT:    ldr q21, [sp, #112]
; CHECK-GI-FP16-NEXT:    mov v7.h[1], v22.h[0]
; CHECK-GI-FP16-NEXT:    mov d22, v2.d[1]
; CHECK-GI-FP16-NEXT:    scvtf v20.2d, v20.2d
; CHECK-GI-FP16-NEXT:    fcvt h2, d2
; CHECK-GI-FP16-NEXT:    scvtf v19.2d, v19.2d
; CHECK-GI-FP16-NEXT:    mov v16.h[2], v27.h[0]
; CHECK-GI-FP16-NEXT:    scvtf v21.2d, v21.2d
; CHECK-GI-FP16-NEXT:    mov d5, v5.d[1]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v26.h[0]
; CHECK-GI-FP16-NEXT:    mov d26, v18.d[1]
; CHECK-GI-FP16-NEXT:    mov v1.h[2], v24.h[0]
; CHECK-GI-FP16-NEXT:    mov d24, v17.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h22, d22
; CHECK-GI-FP16-NEXT:    mov v7.h[2], v28.h[0]
; CHECK-GI-FP16-NEXT:    mov d27, v20.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h18, d18
; CHECK-GI-FP16-NEXT:    mov d28, v3.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h3, d17
; CHECK-GI-FP16-NEXT:    fcvt h20, d20
; CHECK-GI-FP16-NEXT:    mov d6, v6.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h26, d26
; CHECK-GI-FP16-NEXT:    fcvt h4, d4
; CHECK-GI-FP16-NEXT:    fcvt h5, d5
; CHECK-GI-FP16-NEXT:    fcvt h17, d24
; CHECK-GI-FP16-NEXT:    mov v2.h[1], v22.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h24, d23
; CHECK-GI-FP16-NEXT:    fcvt h22, d27
; CHECK-GI-FP16-NEXT:    mov d23, v23.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h6, d6
; CHECK-GI-FP16-NEXT:    mov v18.h[1], v26.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h26, d25
; CHECK-GI-FP16-NEXT:    mov d25, v25.d[1]
; CHECK-GI-FP16-NEXT:    mov v3.h[1], v17.h[0]
; CHECK-GI-FP16-NEXT:    mov d17, v19.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h19, d19
; CHECK-GI-FP16-NEXT:    mov v20.h[1], v22.h[0]
; CHECK-GI-FP16-NEXT:    mov d22, v21.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h21, d21
; CHECK-GI-FP16-NEXT:    mov v2.h[2], v24.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h24, d28
; CHECK-GI-FP16-NEXT:    fcvt h23, d23
; CHECK-GI-FP16-NEXT:    mov v18.h[2], v26.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h25, d25
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v4.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h17, d17
; CHECK-GI-FP16-NEXT:    mov v3.h[2], v19.h[0]
; CHECK-GI-FP16-NEXT:    mov v1.h[3], v5.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h19, d22
; CHECK-GI-FP16-NEXT:    mov v20.h[2], v21.h[0]
; CHECK-GI-FP16-NEXT:    mov v7.h[3], v6.h[0]
; CHECK-GI-FP16-NEXT:    mov v16.h[3], v24.h[0]
; CHECK-GI-FP16-NEXT:    mov v2.h[3], v23.h[0]
; CHECK-GI-FP16-NEXT:    mov v18.h[3], v25.h[0]
; CHECK-GI-FP16-NEXT:    mov v3.h[3], v17.h[0]
; CHECK-GI-FP16-NEXT:    mov v20.h[3], v19.h[0]
; CHECK-GI-FP16-NEXT:    mov v1.d[1], v7.d[0]
; CHECK-GI-FP16-NEXT:    mov v0.d[1], v16.d[0]
; CHECK-GI-FP16-NEXT:    mov v2.d[1], v18.d[0]
; CHECK-GI-FP16-NEXT:    mov v3.d[1], v20.d[0]
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <32 x i64> %a to <32 x half>
  ret <32 x half> %c
}

define <32 x half> @utofp_v32i64_v32f16(<32 x i64> %a) {
; CHECK-SD-LABEL: utofp_v32i64_v32f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldp q17, q16, [sp]
; CHECK-SD-NEXT:    ucvtf v18.2d, v0.2d
; CHECK-SD-NEXT:    ldp q19, q0, [sp, #64]
; CHECK-SD-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-SD-NEXT:    ldp q21, q20, [sp, #96]
; CHECK-SD-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-SD-NEXT:    ucvtf v17.2d, v17.2d
; CHECK-SD-NEXT:    ldp q23, q22, [sp, #32]
; CHECK-SD-NEXT:    ucvtf v19.2d, v19.2d
; CHECK-SD-NEXT:    fcvtn v18.2s, v18.2d
; CHECK-SD-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-SD-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-SD-NEXT:    fcvtn v4.2s, v4.2d
; CHECK-SD-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-SD-NEXT:    ucvtf v23.2d, v23.2d
; CHECK-SD-NEXT:    ucvtf v16.2d, v16.2d
; CHECK-SD-NEXT:    ucvtf v21.2d, v21.2d
; CHECK-SD-NEXT:    fcvtn v17.2s, v17.2d
; CHECK-SD-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-SD-NEXT:    fcvtn v24.2s, v2.2d
; CHECK-SD-NEXT:    fcvtn v19.2s, v19.2d
; CHECK-SD-NEXT:    ucvtf v2.2d, v3.2d
; CHECK-SD-NEXT:    fcvtn2 v18.4s, v1.2d
; CHECK-SD-NEXT:    fcvtn v6.2s, v6.2d
; CHECK-SD-NEXT:    ucvtf v1.2d, v7.2d
; CHECK-SD-NEXT:    fcvtn2 v4.4s, v5.2d
; CHECK-SD-NEXT:    fcvtn v5.2s, v23.2d
; CHECK-SD-NEXT:    ucvtf v3.2d, v22.2d
; CHECK-SD-NEXT:    fcvtn v7.2s, v21.2d
; CHECK-SD-NEXT:    fcvtn2 v17.4s, v16.2d
; CHECK-SD-NEXT:    ucvtf v16.2d, v20.2d
; CHECK-SD-NEXT:    fcvtn2 v19.4s, v0.2d
; CHECK-SD-NEXT:    fcvtn2 v24.4s, v2.2d
; CHECK-SD-NEXT:    fcvtn v0.4h, v18.4s
; CHECK-SD-NEXT:    fcvtn2 v6.4s, v1.2d
; CHECK-SD-NEXT:    fcvtn v1.4h, v4.4s
; CHECK-SD-NEXT:    fcvtn2 v5.4s, v3.2d
; CHECK-SD-NEXT:    fcvtn v2.4h, v17.4s
; CHECK-SD-NEXT:    fcvtn2 v7.4s, v16.2d
; CHECK-SD-NEXT:    fcvtn v3.4h, v19.4s
; CHECK-SD-NEXT:    fcvtn2 v0.8h, v24.4s
; CHECK-SD-NEXT:    fcvtn2 v1.8h, v6.4s
; CHECK-SD-NEXT:    fcvtn2 v2.8h, v5.4s
; CHECK-SD-NEXT:    fcvtn2 v3.8h, v7.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v32i64_v32f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ldp q16, q17, [sp]
; CHECK-GI-NOFP16-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-NOFP16-NEXT:    ldp q20, q21, [sp, #64]
; CHECK-GI-NOFP16-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-GI-NOFP16-NEXT:    ldp q18, q19, [sp, #32]
; CHECK-GI-NOFP16-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v16.2d, v16.2d
; CHECK-GI-NOFP16-NEXT:    ldp q22, q23, [sp, #96]
; CHECK-GI-NOFP16-NEXT:    ucvtf v20.2d, v20.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v17.2d, v17.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v18.2d, v18.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v21.2d, v21.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v22.2d, v22.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v4.2s, v4.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v16.2s, v16.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v20.2s, v20.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v7.2d, v7.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v19.2d, v19.2d
; CHECK-GI-NOFP16-NEXT:    ucvtf v23.2d, v23.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v24.2s, v2.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v6.2s, v6.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v18.2s, v18.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v22.2s, v22.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v4.4s, v5.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v16.4s, v17.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v20.4s, v21.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v24.4s, v3.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v6.4s, v7.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v18.4s, v19.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v22.4s, v23.2d
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v2.4h, v16.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v3.4h, v20.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v24.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v6.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v2.8h, v18.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v3.8h, v22.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v32i64_v32f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ucvtf v16.2d, v2.2d
; CHECK-GI-FP16-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-GI-FP16-NEXT:    ucvtf v18.2d, v4.2d
; CHECK-GI-FP16-NEXT:    ucvtf v17.2d, v6.2d
; CHECK-GI-FP16-NEXT:    ucvtf v4.2d, v1.2d
; CHECK-GI-FP16-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-GI-FP16-NEXT:    ldp q1, q23, [sp]
; CHECK-GI-FP16-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-GI-FP16-NEXT:    ucvtf v6.2d, v7.2d
; CHECK-GI-FP16-NEXT:    mov d20, v16.d[1]
; CHECK-GI-FP16-NEXT:    mov d19, v0.d[1]
; CHECK-GI-FP16-NEXT:    mov d21, v18.d[1]
; CHECK-GI-FP16-NEXT:    mov d22, v17.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h16, d16
; CHECK-GI-FP16-NEXT:    ucvtf v2.2d, v1.2d
; CHECK-GI-FP16-NEXT:    fcvt h0, d0
; CHECK-GI-FP16-NEXT:    fcvt h1, d18
; CHECK-GI-FP16-NEXT:    ldr q18, [sp, #32]
; CHECK-GI-FP16-NEXT:    fcvt h7, d17
; CHECK-GI-FP16-NEXT:    ldp q25, q17, [sp, #48]
; CHECK-GI-FP16-NEXT:    fcvt h20, d20
; CHECK-GI-FP16-NEXT:    fcvt h24, d19
; CHECK-GI-FP16-NEXT:    fcvt h21, d21
; CHECK-GI-FP16-NEXT:    fcvt h22, d22
; CHECK-GI-FP16-NEXT:    ucvtf v18.2d, v18.2d
; CHECK-GI-FP16-NEXT:    fcvt h26, d4
; CHECK-GI-FP16-NEXT:    ucvtf v17.2d, v17.2d
; CHECK-GI-FP16-NEXT:    fcvt h27, d3
; CHECK-GI-FP16-NEXT:    fcvt h28, d6
; CHECK-GI-FP16-NEXT:    ucvtf v23.2d, v23.2d
; CHECK-GI-FP16-NEXT:    ucvtf v25.2d, v25.2d
; CHECK-GI-FP16-NEXT:    mov d4, v4.d[1]
; CHECK-GI-FP16-NEXT:    mov v16.h[1], v20.h[0]
; CHECK-GI-FP16-NEXT:    ldp q19, q20, [sp, #80]
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v24.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h24, d5
; CHECK-GI-FP16-NEXT:    mov v1.h[1], v21.h[0]
; CHECK-GI-FP16-NEXT:    ldr q21, [sp, #112]
; CHECK-GI-FP16-NEXT:    mov v7.h[1], v22.h[0]
; CHECK-GI-FP16-NEXT:    mov d22, v2.d[1]
; CHECK-GI-FP16-NEXT:    ucvtf v20.2d, v20.2d
; CHECK-GI-FP16-NEXT:    fcvt h2, d2
; CHECK-GI-FP16-NEXT:    ucvtf v19.2d, v19.2d
; CHECK-GI-FP16-NEXT:    mov v16.h[2], v27.h[0]
; CHECK-GI-FP16-NEXT:    ucvtf v21.2d, v21.2d
; CHECK-GI-FP16-NEXT:    mov d5, v5.d[1]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v26.h[0]
; CHECK-GI-FP16-NEXT:    mov d26, v18.d[1]
; CHECK-GI-FP16-NEXT:    mov v1.h[2], v24.h[0]
; CHECK-GI-FP16-NEXT:    mov d24, v17.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h22, d22
; CHECK-GI-FP16-NEXT:    mov v7.h[2], v28.h[0]
; CHECK-GI-FP16-NEXT:    mov d27, v20.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h18, d18
; CHECK-GI-FP16-NEXT:    mov d28, v3.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h3, d17
; CHECK-GI-FP16-NEXT:    fcvt h20, d20
; CHECK-GI-FP16-NEXT:    mov d6, v6.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h26, d26
; CHECK-GI-FP16-NEXT:    fcvt h4, d4
; CHECK-GI-FP16-NEXT:    fcvt h5, d5
; CHECK-GI-FP16-NEXT:    fcvt h17, d24
; CHECK-GI-FP16-NEXT:    mov v2.h[1], v22.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h24, d23
; CHECK-GI-FP16-NEXT:    fcvt h22, d27
; CHECK-GI-FP16-NEXT:    mov d23, v23.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h6, d6
; CHECK-GI-FP16-NEXT:    mov v18.h[1], v26.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h26, d25
; CHECK-GI-FP16-NEXT:    mov d25, v25.d[1]
; CHECK-GI-FP16-NEXT:    mov v3.h[1], v17.h[0]
; CHECK-GI-FP16-NEXT:    mov d17, v19.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h19, d19
; CHECK-GI-FP16-NEXT:    mov v20.h[1], v22.h[0]
; CHECK-GI-FP16-NEXT:    mov d22, v21.d[1]
; CHECK-GI-FP16-NEXT:    fcvt h21, d21
; CHECK-GI-FP16-NEXT:    mov v2.h[2], v24.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h24, d28
; CHECK-GI-FP16-NEXT:    fcvt h23, d23
; CHECK-GI-FP16-NEXT:    mov v18.h[2], v26.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h25, d25
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v4.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h17, d17
; CHECK-GI-FP16-NEXT:    mov v3.h[2], v19.h[0]
; CHECK-GI-FP16-NEXT:    mov v1.h[3], v5.h[0]
; CHECK-GI-FP16-NEXT:    fcvt h19, d22
; CHECK-GI-FP16-NEXT:    mov v20.h[2], v21.h[0]
; CHECK-GI-FP16-NEXT:    mov v7.h[3], v6.h[0]
; CHECK-GI-FP16-NEXT:    mov v16.h[3], v24.h[0]
; CHECK-GI-FP16-NEXT:    mov v2.h[3], v23.h[0]
; CHECK-GI-FP16-NEXT:    mov v18.h[3], v25.h[0]
; CHECK-GI-FP16-NEXT:    mov v3.h[3], v17.h[0]
; CHECK-GI-FP16-NEXT:    mov v20.h[3], v19.h[0]
; CHECK-GI-FP16-NEXT:    mov v1.d[1], v7.d[0]
; CHECK-GI-FP16-NEXT:    mov v0.d[1], v16.d[0]
; CHECK-GI-FP16-NEXT:    mov v2.d[1], v18.d[0]
; CHECK-GI-FP16-NEXT:    mov v3.d[1], v20.d[0]
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <32 x i64> %a to <32 x half>
  ret <32 x half> %c
}

define <2 x half> @stofp_v2i32_v2f16(<2 x i32> %a) {
; CHECK-SD-LABEL: stofp_v2i32_v2f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    scvtf v0.4s, v0.4s
; CHECK-SD-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v2i32_v2f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    scvtf v0.2s, v0.2s
; CHECK-GI-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-GI-NEXT:    mov v0.s[2], v0.s[0]
; CHECK-GI-NEXT:    mov v0.s[3], v0.s[0]
; CHECK-GI-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <2 x i32> %a to <2 x half>
  ret <2 x half> %c
}

define <2 x half> @utofp_v2i32_v2f16(<2 x i32> %a) {
; CHECK-SD-LABEL: utofp_v2i32_v2f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-SD-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v2i32_v2f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ucvtf v0.2s, v0.2s
; CHECK-GI-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-GI-NEXT:    mov v0.s[2], v0.s[0]
; CHECK-GI-NEXT:    mov v0.s[3], v0.s[0]
; CHECK-GI-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <2 x i32> %a to <2 x half>
  ret <2 x half> %c
}

define <3 x half> @stofp_v3i32_v3f16(<3 x i32> %a) {
; CHECK-LABEL: stofp_v3i32_v3f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.4s, v0.4s
; CHECK-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <3 x i32> %a to <3 x half>
  ret <3 x half> %c
}

define <3 x half> @utofp_v3i32_v3f16(<3 x i32> %a) {
; CHECK-LABEL: utofp_v3i32_v3f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <3 x i32> %a to <3 x half>
  ret <3 x half> %c
}

define <4 x half> @stofp_v4i32_v4f16(<4 x i32> %a) {
; CHECK-LABEL: stofp_v4i32_v4f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.4s, v0.4s
; CHECK-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <4 x i32> %a to <4 x half>
  ret <4 x half> %c
}

define <4 x half> @utofp_v4i32_v4f16(<4 x i32> %a) {
; CHECK-LABEL: utofp_v4i32_v4f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <4 x i32> %a to <4 x half>
  ret <4 x half> %c
}

define <8 x half> @stofp_v8i32_v8f16(<8 x i32> %a) {
; CHECK-LABEL: stofp_v8i32_v8f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.4s, v0.4s
; CHECK-NEXT:    scvtf v1.4s, v1.4s
; CHECK-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <8 x i32> %a to <8 x half>
  ret <8 x half> %c
}

define <8 x half> @utofp_v8i32_v8f16(<8 x i32> %a) {
; CHECK-LABEL: utofp_v8i32_v8f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <8 x i32> %a to <8 x half>
  ret <8 x half> %c
}

define <16 x half> @stofp_v16i32_v16f16(<16 x i32> %a) {
; CHECK-SD-LABEL: stofp_v16i32_v16f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    scvtf v0.4s, v0.4s
; CHECK-SD-NEXT:    scvtf v2.4s, v2.4s
; CHECK-SD-NEXT:    scvtf v4.4s, v1.4s
; CHECK-SD-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NEXT:    fcvtn v1.4h, v2.4s
; CHECK-SD-NEXT:    scvtf v2.4s, v3.4s
; CHECK-SD-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-SD-NEXT:    fcvtn2 v1.8h, v2.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: stofp_v16i32_v16f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    scvtf v0.4s, v0.4s
; CHECK-GI-NEXT:    scvtf v2.4s, v2.4s
; CHECK-GI-NEXT:    scvtf v4.4s, v1.4s
; CHECK-GI-NEXT:    scvtf v3.4s, v3.4s
; CHECK-GI-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NEXT:    fcvtn v1.4h, v2.4s
; CHECK-GI-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-GI-NEXT:    fcvtn2 v1.8h, v3.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = sitofp <16 x i32> %a to <16 x half>
  ret <16 x half> %c
}

define <16 x half> @utofp_v16i32_v16f16(<16 x i32> %a) {
; CHECK-SD-LABEL: utofp_v16i32_v16f16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-SD-NEXT:    ucvtf v2.4s, v2.4s
; CHECK-SD-NEXT:    ucvtf v4.4s, v1.4s
; CHECK-SD-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NEXT:    fcvtn v1.4h, v2.4s
; CHECK-SD-NEXT:    ucvtf v2.4s, v3.4s
; CHECK-SD-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-SD-NEXT:    fcvtn2 v1.8h, v2.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: utofp_v16i32_v16f16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-GI-NEXT:    ucvtf v2.4s, v2.4s
; CHECK-GI-NEXT:    ucvtf v4.4s, v1.4s
; CHECK-GI-NEXT:    ucvtf v3.4s, v3.4s
; CHECK-GI-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NEXT:    fcvtn v1.4h, v2.4s
; CHECK-GI-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-GI-NEXT:    fcvtn2 v1.8h, v3.4s
; CHECK-GI-NEXT:    ret
entry:
  %c = uitofp <16 x i32> %a to <16 x half>
  ret <16 x half> %c
}

define <32 x half> @stofp_v32i32_v32f16(<32 x i32> %a) {
; CHECK-LABEL: stofp_v32i32_v32f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf v0.4s, v0.4s
; CHECK-NEXT:    scvtf v2.4s, v2.4s
; CHECK-NEXT:    scvtf v4.4s, v4.4s
; CHECK-NEXT:    scvtf v6.4s, v6.4s
; CHECK-NEXT:    scvtf v16.4s, v1.4s
; CHECK-NEXT:    scvtf v17.4s, v3.4s
; CHECK-NEXT:    scvtf v5.4s, v5.4s
; CHECK-NEXT:    scvtf v7.4s, v7.4s
; CHECK-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NEXT:    fcvtn v1.4h, v2.4s
; CHECK-NEXT:    fcvtn v2.4h, v4.4s
; CHECK-NEXT:    fcvtn v3.4h, v6.4s
; CHECK-NEXT:    fcvtn2 v0.8h, v16.4s
; CHECK-NEXT:    fcvtn2 v1.8h, v17.4s
; CHECK-NEXT:    fcvtn2 v2.8h, v5.4s
; CHECK-NEXT:    fcvtn2 v3.8h, v7.4s
; CHECK-NEXT:    ret
entry:
  %c = sitofp <32 x i32> %a to <32 x half>
  ret <32 x half> %c
}

define <32 x half> @utofp_v32i32_v32f16(<32 x i32> %a) {
; CHECK-LABEL: utofp_v32i32_v32f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-NEXT:    ucvtf v2.4s, v2.4s
; CHECK-NEXT:    ucvtf v4.4s, v4.4s
; CHECK-NEXT:    ucvtf v6.4s, v6.4s
; CHECK-NEXT:    ucvtf v16.4s, v1.4s
; CHECK-NEXT:    ucvtf v17.4s, v3.4s
; CHECK-NEXT:    ucvtf v5.4s, v5.4s
; CHECK-NEXT:    ucvtf v7.4s, v7.4s
; CHECK-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NEXT:    fcvtn v1.4h, v2.4s
; CHECK-NEXT:    fcvtn v2.4h, v4.4s
; CHECK-NEXT:    fcvtn v3.4h, v6.4s
; CHECK-NEXT:    fcvtn2 v0.8h, v16.4s
; CHECK-NEXT:    fcvtn2 v1.8h, v17.4s
; CHECK-NEXT:    fcvtn2 v2.8h, v5.4s
; CHECK-NEXT:    fcvtn2 v3.8h, v7.4s
; CHECK-NEXT:    ret
entry:
  %c = uitofp <32 x i32> %a to <32 x half>
  ret <32 x half> %c
}

define <2 x half> @stofp_v2i16_v2f16(<2 x i16> %a) {
; CHECK-SD-NOFP16-LABEL: stofp_v2i16_v2f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    uzp1 v0.4h, v0.4h, v0.4h
; CHECK-SD-NOFP16-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    scvtf v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_v2i16_v2f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    uzp1 v0.4h, v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    scvtf v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v2i16_v2f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    shl v0.2s, v0.2s, #16
; CHECK-GI-NOFP16-NEXT:    sshr v0.2s, v0.2s, #16
; CHECK-GI-NOFP16-NEXT:    scvtf v0.2s, v0.2s
; CHECK-GI-NOFP16-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[2], v0.s[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[3], v0.s[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-NOFP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v2i16_v2f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-FP16-NEXT:    mov s1, v0.s[1]
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    scvtf v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <2 x i16> %a to <2 x half>
  ret <2 x half> %c
}

define <2 x half> @utofp_v2i16_v2f16(<2 x i16> %a) {
; CHECK-SD-NOFP16-LABEL: utofp_v2i16_v2f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    uzp1 v0.4h, v0.4h, v0.4h
; CHECK-SD-NOFP16-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_v2i16_v2f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    uzp1 v0.4h, v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ucvtf v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v2i16_v2f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    movi d1, #0x00ffff0000ffff
; CHECK-GI-NOFP16-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NOFP16-NEXT:    ucvtf v0.2s, v0.2s
; CHECK-GI-NOFP16-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[2], v0.s[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[3], v0.s[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-NOFP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v2i16_v2f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-FP16-NEXT:    mov s1, v0.s[1]
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    ucvtf v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <2 x i16> %a to <2 x half>
  ret <2 x half> %c
}

define <3 x half> @stofp_v3i16_v3f16(<3 x i16> %a) {
; CHECK-SD-NOFP16-LABEL: stofp_v3i16_v3f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    scvtf v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_v3i16_v3f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    scvtf v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v3i16_v3f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    scvtf v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v3i16_v3f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    scvtf v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <3 x i16> %a to <3 x half>
  ret <3 x half> %c
}

define <3 x half> @utofp_v3i16_v3f16(<3 x i16> %a) {
; CHECK-SD-NOFP16-LABEL: utofp_v3i16_v3f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_v3i16_v3f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    ucvtf v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v3i16_v3f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v3i16_v3f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ucvtf v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <3 x i16> %a to <3 x half>
  ret <3 x half> %c
}

define <4 x half> @stofp_v4i16_v4f16(<4 x i16> %a) {
; CHECK-SD-NOFP16-LABEL: stofp_v4i16_v4f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    scvtf v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_v4i16_v4f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    scvtf v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v4i16_v4f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    scvtf v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v4i16_v4f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    scvtf v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <4 x i16> %a to <4 x half>
  ret <4 x half> %c
}

define <4 x half> @utofp_v4i16_v4f16(<4 x i16> %a) {
; CHECK-SD-NOFP16-LABEL: utofp_v4i16_v4f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_v4i16_v4f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    ucvtf v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v4i16_v4f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v4i16_v4f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ucvtf v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <4 x i16> %a to <4 x half>
  ret <4 x half> %c
}

define <8 x half> @stofp_v8i16_v8f16(<8 x i16> %a) {
; CHECK-SD-NOFP16-LABEL: stofp_v8i16_v8f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v2.4s, v0.8h, #0
; CHECK-SD-NOFP16-NEXT:    scvtf v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_v8i16_v8f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    scvtf v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v8i16_v8f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-GI-NOFP16-NEXT:    scvtf v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v2.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v8i16_v8f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    scvtf v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <8 x i16> %a to <8 x half>
  ret <8 x half> %c
}

define <8 x half> @utofp_v8i16_v8f16(<8 x i16> %a) {
; CHECK-SD-NOFP16-LABEL: utofp_v8i16_v8f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v2.4s, v0.8h, #0
; CHECK-SD-NOFP16-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_v8i16_v8f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    ucvtf v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v8i16_v8f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NOFP16-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v2.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v8i16_v8f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ucvtf v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <8 x i16> %a to <8 x half>
  ret <8 x half> %c
}

define <16 x half> @stofp_v16i16_v16f16(<16 x i16> %a) {
; CHECK-SD-NOFP16-LABEL: stofp_v16i16_v16f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    sshll v2.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    sshll v3.4s, v1.4h, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v4.4s, v0.8h, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v5.4s, v1.8h, #0
; CHECK-SD-NOFP16-NEXT:    scvtf v2.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v3.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v2.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v3.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v3.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v3.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_v16i16_v16f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    scvtf v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    scvtf v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v16i16_v16f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    sshll v2.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    sshll v3.4s, v1.4h, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-GI-NOFP16-NEXT:    scvtf v2.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v3.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v4.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v5.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v3.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v5.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v16i16_v16f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    scvtf v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    scvtf v1.8h, v1.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <16 x i16> %a to <16 x half>
  ret <16 x half> %c
}

define <16 x half> @utofp_v16i16_v16f16(<16 x i16> %a) {
; CHECK-SD-NOFP16-LABEL: utofp_v16i16_v16f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    ushll v2.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    ushll v3.4s, v1.4h, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v4.4s, v0.8h, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v5.4s, v1.8h, #0
; CHECK-SD-NOFP16-NEXT:    ucvtf v2.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v3.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v2.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v3.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v3.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v3.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_v16i16_v16f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    ucvtf v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ucvtf v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v16i16_v16f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ushll v2.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    ushll v3.4s, v1.4h, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-GI-NOFP16-NEXT:    ucvtf v2.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v3.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v4.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v5.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v3.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v5.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v16i16_v16f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ucvtf v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ucvtf v1.8h, v1.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <16 x i16> %a to <16 x half>
  ret <16 x half> %c
}

define <32 x half> @stofp_v32i16_v32f16(<32 x i16> %a) {
; CHECK-SD-NOFP16-LABEL: stofp_v32i16_v32f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    sshll v4.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    sshll v5.4s, v1.4h, #0
; CHECK-SD-NOFP16-NEXT:    sshll v6.4s, v2.4h, #0
; CHECK-SD-NOFP16-NEXT:    sshll v7.4s, v3.4h, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v2.4s, v2.8h, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v3.4s, v3.8h, #0
; CHECK-SD-NOFP16-NEXT:    scvtf v4.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v5.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v6.4s, v6.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v7.4s, v7.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v16.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v17.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v18.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v19.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v2.4h, v6.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v3.4h, v7.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v16.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v17.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v2.8h, v18.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v3.8h, v19.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_v32i16_v32f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    scvtf v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    scvtf v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    scvtf v2.8h, v2.8h
; CHECK-SD-FP16-NEXT:    scvtf v3.8h, v3.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v32i16_v32f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    sshll v4.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    sshll v5.4s, v1.4h, #0
; CHECK-GI-NOFP16-NEXT:    sshll v6.4s, v2.4h, #0
; CHECK-GI-NOFP16-NEXT:    sshll v7.4s, v3.4h, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v2.4s, v2.8h, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v3.4s, v3.8h, #0
; CHECK-GI-NOFP16-NEXT:    scvtf v4.4s, v4.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v5.4s, v5.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v6.4s, v6.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v7.4s, v7.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v16.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v17.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v18.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v19.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v5.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v2.4h, v6.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v3.4h, v7.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v16.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v17.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v2.8h, v18.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v3.8h, v19.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v32i16_v32f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    scvtf v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    scvtf v1.8h, v1.8h
; CHECK-GI-FP16-NEXT:    scvtf v2.8h, v2.8h
; CHECK-GI-FP16-NEXT:    scvtf v3.8h, v3.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <32 x i16> %a to <32 x half>
  ret <32 x half> %c
}

define <32 x half> @utofp_v32i16_v32f16(<32 x i16> %a) {
; CHECK-SD-NOFP16-LABEL: utofp_v32i16_v32f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    ushll v4.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    ushll v5.4s, v1.4h, #0
; CHECK-SD-NOFP16-NEXT:    ushll v6.4s, v2.4h, #0
; CHECK-SD-NOFP16-NEXT:    ushll v7.4s, v3.4h, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v2.4s, v2.8h, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v3.4s, v3.8h, #0
; CHECK-SD-NOFP16-NEXT:    ucvtf v4.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v5.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v6.4s, v6.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v7.4s, v7.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v16.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v17.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v18.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v19.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v2.4h, v6.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v3.4h, v7.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v16.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v17.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v2.8h, v18.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v3.8h, v19.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_v32i16_v32f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    ucvtf v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ucvtf v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    ucvtf v2.8h, v2.8h
; CHECK-SD-FP16-NEXT:    ucvtf v3.8h, v3.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v32i16_v32f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ushll v4.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    ushll v5.4s, v1.4h, #0
; CHECK-GI-NOFP16-NEXT:    ushll v6.4s, v2.4h, #0
; CHECK-GI-NOFP16-NEXT:    ushll v7.4s, v3.4h, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v2.4s, v2.8h, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v3.4s, v3.8h, #0
; CHECK-GI-NOFP16-NEXT:    ucvtf v4.4s, v4.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v5.4s, v5.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v6.4s, v6.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v7.4s, v7.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v16.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v17.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v18.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v19.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v5.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v2.4h, v6.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v3.4h, v7.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v16.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v17.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v2.8h, v18.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v3.8h, v19.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v32i16_v32f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ucvtf v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ucvtf v1.8h, v1.8h
; CHECK-GI-FP16-NEXT:    ucvtf v2.8h, v2.8h
; CHECK-GI-FP16-NEXT:    ucvtf v3.8h, v3.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <32 x i16> %a to <32 x half>
  ret <32 x half> %c
}

define <2 x half> @stofp_v2i8_v2f16(<2 x i8> %a) {
; CHECK-SD-NOFP16-LABEL: stofp_v2i8_v2f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NOFP16-NEXT:    mov w8, v0.s[1]
; CHECK-SD-NOFP16-NEXT:    fmov w9, s0
; CHECK-SD-NOFP16-NEXT:    sxtb w9, w9
; CHECK-SD-NOFP16-NEXT:    sxtb w8, w8
; CHECK-SD-NOFP16-NEXT:    scvtf s1, w9
; CHECK-SD-NOFP16-NEXT:    scvtf s0, w8
; CHECK-SD-NOFP16-NEXT:    fcvt h2, s0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s1
; CHECK-SD-NOFP16-NEXT:    mov v0.h[1], v2.h[0]
; CHECK-SD-NOFP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_v2i8_v2f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-FP16-NEXT:    mov w8, v0.s[1]
; CHECK-SD-FP16-NEXT:    fmov w9, s0
; CHECK-SD-FP16-NEXT:    sxtb w9, w9
; CHECK-SD-FP16-NEXT:    sxtb w8, w8
; CHECK-SD-FP16-NEXT:    scvtf h0, w9
; CHECK-SD-FP16-NEXT:    scvtf h1, w8
; CHECK-SD-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v2i8_v2f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    shl v0.2s, v0.2s, #24
; CHECK-GI-NOFP16-NEXT:    sshr v0.2s, v0.2s, #24
; CHECK-GI-NOFP16-NEXT:    scvtf v0.2s, v0.2s
; CHECK-GI-NOFP16-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[2], v0.s[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[3], v0.s[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-NOFP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v2i8_v2f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-FP16-NEXT:    mov s1, v0.s[1]
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-GI-FP16-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    scvtf v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <2 x i8> %a to <2 x half>
  ret <2 x half> %c
}

define <2 x half> @utofp_v2i8_v2f16(<2 x i8> %a) {
; CHECK-SD-NOFP16-LABEL: utofp_v2i8_v2f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-NOFP16-NEXT:    mov w8, v0.s[1]
; CHECK-SD-NOFP16-NEXT:    fmov w9, s0
; CHECK-SD-NOFP16-NEXT:    and w9, w9, #0xff
; CHECK-SD-NOFP16-NEXT:    and w8, w8, #0xff
; CHECK-SD-NOFP16-NEXT:    ucvtf s1, w9
; CHECK-SD-NOFP16-NEXT:    ucvtf s0, w8
; CHECK-SD-NOFP16-NEXT:    fcvt h2, s0
; CHECK-SD-NOFP16-NEXT:    fcvt h0, s1
; CHECK-SD-NOFP16-NEXT:    mov v0.h[1], v2.h[0]
; CHECK-SD-NOFP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_v2i8_v2f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-SD-FP16-NEXT:    mov w8, v0.s[1]
; CHECK-SD-FP16-NEXT:    fmov w9, s0
; CHECK-SD-FP16-NEXT:    and w9, w9, #0xff
; CHECK-SD-FP16-NEXT:    and w8, w8, #0xff
; CHECK-SD-FP16-NEXT:    ucvtf h0, w9
; CHECK-SD-FP16-NEXT:    ucvtf h1, w8
; CHECK-SD-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-SD-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v2i8_v2f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    movi d1, #0x0000ff000000ff
; CHECK-GI-NOFP16-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-NOFP16-NEXT:    ucvtf v0.2s, v0.2s
; CHECK-GI-NOFP16-NEXT:    mov s1, v0.s[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[2], v0.s[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.s[3], v0.s[0]
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-NOFP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-NOFP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v2i8_v2f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    movi d1, #0x0000ff000000ff
; CHECK-GI-FP16-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-FP16-NEXT:    mov s1, v0.s[1]
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    ucvtf v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    mov h1, v0.h[1]
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v0.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <2 x i8> %a to <2 x half>
  ret <2 x half> %c
}

define <3 x half> @stofp_v3i8_v3f16(<3 x i8> %a) {
; CHECK-SD-NOFP16-LABEL: stofp_v3i8_v3f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fmov s0, w0
; CHECK-SD-NOFP16-NEXT:    mov v0.h[1], w1
; CHECK-SD-NOFP16-NEXT:    mov v0.h[2], w2
; CHECK-SD-NOFP16-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-SD-NOFP16-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-SD-NOFP16-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    scvtf v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_v3i8_v3f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    fmov s0, w0
; CHECK-SD-FP16-NEXT:    mov v0.h[1], w1
; CHECK-SD-FP16-NEXT:    mov v0.h[2], w2
; CHECK-SD-FP16-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-SD-FP16-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-SD-FP16-NEXT:    scvtf v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v3i8_v3f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fmov s0, w0
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], w1
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], w2
; CHECK-GI-NOFP16-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-GI-NOFP16-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-GI-NOFP16-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    scvtf v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v3i8_v3f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    fmov s0, w0
; CHECK-GI-FP16-NEXT:    fmov s1, w1
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    fmov s1, w2
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v1.h[0]
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-GI-FP16-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-GI-FP16-NEXT:    scvtf v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <3 x i8> %a to <3 x half>
  ret <3 x half> %c
}

define <3 x half> @utofp_v3i8_v3f16(<3 x i8> %a) {
; CHECK-SD-NOFP16-LABEL: utofp_v3i8_v3f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    fmov s0, w0
; CHECK-SD-NOFP16-NEXT:    mov v0.h[1], w1
; CHECK-SD-NOFP16-NEXT:    mov v0.h[2], w2
; CHECK-SD-NOFP16-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-NOFP16-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_v3i8_v3f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    fmov s0, w0
; CHECK-SD-FP16-NEXT:    mov v0.h[1], w1
; CHECK-SD-FP16-NEXT:    mov v0.h[2], w2
; CHECK-SD-FP16-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-FP16-NEXT:    ucvtf v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v3i8_v3f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    fmov s0, w0
; CHECK-GI-NOFP16-NEXT:    mov v0.h[1], w1
; CHECK-GI-NOFP16-NEXT:    mov v0.h[2], w2
; CHECK-GI-NOFP16-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-GI-NOFP16-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v3i8_v3f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    fmov s0, w0
; CHECK-GI-FP16-NEXT:    fmov s1, w1
; CHECK-GI-FP16-NEXT:    mov v0.h[1], v1.h[0]
; CHECK-GI-FP16-NEXT:    fmov s1, w2
; CHECK-GI-FP16-NEXT:    mov v0.h[2], v1.h[0]
; CHECK-GI-FP16-NEXT:    movi d1, #0xff00ff00ff00ff
; CHECK-GI-FP16-NEXT:    mov v0.h[3], v0.h[0]
; CHECK-GI-FP16-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-FP16-NEXT:    ucvtf v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <3 x i8> %a to <3 x half>
  ret <3 x half> %c
}

define <4 x half> @stofp_v4i8_v4f16(<4 x i8> %a) {
; CHECK-SD-NOFP16-LABEL: stofp_v4i8_v4f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-SD-NOFP16-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-SD-NOFP16-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    scvtf v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_v4i8_v4f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-SD-FP16-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-SD-FP16-NEXT:    scvtf v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v4i8_v4f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    shl v0.4s, v0.4s, #24
; CHECK-GI-NOFP16-NEXT:    sshr v0.4s, v0.4s, #24
; CHECK-GI-NOFP16-NEXT:    scvtf v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v4i8_v4f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-GI-FP16-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-GI-FP16-NEXT:    scvtf v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <4 x i8> %a to <4 x half>
  ret <4 x half> %c
}

define <4 x half> @utofp_v4i8_v4f16(<4 x i8> %a) {
; CHECK-SD-NOFP16-LABEL: utofp_v4i8_v4f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-NOFP16-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_v4i8_v4f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    bic v0.4h, #255, lsl #8
; CHECK-SD-FP16-NEXT:    ucvtf v0.4h, v0.4h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v4i8_v4f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    movi v1.2d, #0x0000ff000000ff
; CHECK-GI-NOFP16-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NOFP16-NEXT:    ucvtf v0.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v4i8_v4f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    movi d1, #0xff00ff00ff00ff
; CHECK-GI-FP16-NEXT:    and v0.8b, v0.8b, v1.8b
; CHECK-GI-FP16-NEXT:    ucvtf v0.4h, v0.4h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <4 x i8> %a to <4 x half>
  ret <4 x half> %c
}

define <8 x half> @stofp_v8i8_v8f16(<8 x i8> %a) {
; CHECK-SD-NOFP16-LABEL: stofp_v8i8_v8f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-SD-NOFP16-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v2.4s, v0.8h, #0
; CHECK-SD-NOFP16-NEXT:    scvtf v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_v8i8_v8f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-SD-FP16-NEXT:    scvtf v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v8i8_v8f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-GI-NOFP16-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-GI-NOFP16-NEXT:    scvtf v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v2.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v8i8_v8f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-GI-FP16-NEXT:    scvtf v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <8 x i8> %a to <8 x half>
  ret <8 x half> %c
}

define <8 x half> @utofp_v8i8_v8f16(<8 x i8> %a) {
; CHECK-SD-NOFP16-LABEL: utofp_v8i8_v8f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-SD-NOFP16-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v2.4s, v0.8h, #0
; CHECK-SD-NOFP16-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v1.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v1.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_v8i8_v8f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-SD-FP16-NEXT:    ucvtf v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v8i8_v8f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-GI-NOFP16-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NOFP16-NEXT:    ucvtf v1.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v2.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v2.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v8i8_v8f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-GI-FP16-NEXT:    ucvtf v0.8h, v0.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <8 x i8> %a to <8 x half>
  ret <8 x half> %c
}

define <16 x half> @stofp_v16i8_v16f16(<16 x i8> %a) {
; CHECK-SD-NOFP16-LABEL: stofp_v16i8_v16f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    sshll2 v1.8h, v0.16b, #0
; CHECK-SD-NOFP16-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-SD-NOFP16-NEXT:    sshll v2.4s, v1.4h, #0
; CHECK-SD-NOFP16-NEXT:    sshll v3.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v4.4s, v1.8h, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v5.4s, v0.8h, #0
; CHECK-SD-NOFP16-NEXT:    scvtf v2.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v3.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v2.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v2.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v3.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v3.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v3.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_v16i8_v16f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    sshll2 v1.8h, v0.16b, #0
; CHECK-SD-FP16-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-SD-FP16-NEXT:    scvtf v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    scvtf v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v16i8_v16f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    sshll v1.8h, v0.8b, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v0.8h, v0.16b, #0
; CHECK-GI-NOFP16-NEXT:    sshll v2.4s, v1.4h, #0
; CHECK-GI-NOFP16-NEXT:    sshll v3.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-GI-NOFP16-NEXT:    scvtf v2.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v3.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v4.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v5.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v3.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v5.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v16i8_v16f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    sshll v1.8h, v0.8b, #0
; CHECK-GI-FP16-NEXT:    sshll2 v2.8h, v0.16b, #0
; CHECK-GI-FP16-NEXT:    scvtf v0.8h, v1.8h
; CHECK-GI-FP16-NEXT:    scvtf v1.8h, v2.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <16 x i8> %a to <16 x half>
  ret <16 x half> %c
}

define <16 x half> @utofp_v16i8_v16f16(<16 x i8> %a) {
; CHECK-SD-NOFP16-LABEL: utofp_v16i8_v16f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    ushll2 v1.8h, v0.16b, #0
; CHECK-SD-NOFP16-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-SD-NOFP16-NEXT:    ushll v2.4s, v1.4h, #0
; CHECK-SD-NOFP16-NEXT:    ushll v3.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v4.4s, v1.8h, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v5.4s, v0.8h, #0
; CHECK-SD-NOFP16-NEXT:    ucvtf v2.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v3.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v2.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v2.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v3.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v3.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v2.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v3.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_v16i8_v16f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    ushll2 v1.8h, v0.16b, #0
; CHECK-SD-FP16-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-SD-FP16-NEXT:    ucvtf v1.8h, v1.8h
; CHECK-SD-FP16-NEXT:    ucvtf v0.8h, v0.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v16i8_v16f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ushll v1.8h, v0.8b, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v0.8h, v0.16b, #0
; CHECK-GI-NOFP16-NEXT:    ushll v2.4s, v1.4h, #0
; CHECK-GI-NOFP16-NEXT:    ushll v3.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NOFP16-NEXT:    ucvtf v2.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v3.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v4.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v5.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v2.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v3.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v5.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v16i8_v16f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ushll v1.8h, v0.8b, #0
; CHECK-GI-FP16-NEXT:    ushll2 v2.8h, v0.16b, #0
; CHECK-GI-FP16-NEXT:    ucvtf v0.8h, v1.8h
; CHECK-GI-FP16-NEXT:    ucvtf v1.8h, v2.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <16 x i8> %a to <16 x half>
  ret <16 x half> %c
}

define <32 x half> @stofp_v32i8_v32f16(<32 x i8> %a) {
; CHECK-SD-NOFP16-LABEL: stofp_v32i8_v32f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    sshll v2.8h, v0.8b, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v0.8h, v0.16b, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v3.8h, v1.16b, #0
; CHECK-SD-NOFP16-NEXT:    sshll v1.8h, v1.8b, #0
; CHECK-SD-NOFP16-NEXT:    sshll v4.4s, v2.4h, #0
; CHECK-SD-NOFP16-NEXT:    sshll v5.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    sshll v6.4s, v3.4h, #0
; CHECK-SD-NOFP16-NEXT:    sshll v7.4s, v1.4h, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v3.4s, v3.8h, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v2.4s, v2.8h, #0
; CHECK-SD-NOFP16-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-SD-NOFP16-NEXT:    scvtf v4.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v5.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v6.4s, v6.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v7.4s, v7.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v16.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v17.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v18.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    scvtf v19.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v3.4h, v6.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v2.4h, v7.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v18.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v16.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v3.8h, v17.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v2.8h, v19.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: stofp_v32i8_v32f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    sshll v2.8h, v0.8b, #0
; CHECK-SD-FP16-NEXT:    sshll2 v3.8h, v0.16b, #0
; CHECK-SD-FP16-NEXT:    sshll2 v4.8h, v1.16b, #0
; CHECK-SD-FP16-NEXT:    sshll v5.8h, v1.8b, #0
; CHECK-SD-FP16-NEXT:    scvtf v0.8h, v2.8h
; CHECK-SD-FP16-NEXT:    scvtf v1.8h, v3.8h
; CHECK-SD-FP16-NEXT:    scvtf v3.8h, v4.8h
; CHECK-SD-FP16-NEXT:    scvtf v2.8h, v5.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: stofp_v32i8_v32f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    sshll v2.8h, v0.8b, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v0.8h, v0.16b, #0
; CHECK-GI-NOFP16-NEXT:    sshll v3.8h, v1.8b, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v1.8h, v1.16b, #0
; CHECK-GI-NOFP16-NEXT:    sshll v4.4s, v2.4h, #0
; CHECK-GI-NOFP16-NEXT:    sshll v5.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    sshll v6.4s, v3.4h, #0
; CHECK-GI-NOFP16-NEXT:    sshll v7.4s, v1.4h, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v2.4s, v2.8h, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v0.4s, v0.8h, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v3.4s, v3.8h, #0
; CHECK-GI-NOFP16-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-GI-NOFP16-NEXT:    scvtf v4.4s, v4.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v5.4s, v5.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v6.4s, v6.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v7.4s, v7.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v16.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v17.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v18.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    scvtf v19.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v5.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v2.4h, v6.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v3.4h, v7.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v16.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v17.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v2.8h, v18.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v3.8h, v19.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: stofp_v32i8_v32f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    sshll v2.8h, v0.8b, #0
; CHECK-GI-FP16-NEXT:    sshll2 v3.8h, v0.16b, #0
; CHECK-GI-FP16-NEXT:    sshll v4.8h, v1.8b, #0
; CHECK-GI-FP16-NEXT:    sshll2 v5.8h, v1.16b, #0
; CHECK-GI-FP16-NEXT:    scvtf v0.8h, v2.8h
; CHECK-GI-FP16-NEXT:    scvtf v1.8h, v3.8h
; CHECK-GI-FP16-NEXT:    scvtf v2.8h, v4.8h
; CHECK-GI-FP16-NEXT:    scvtf v3.8h, v5.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = sitofp <32 x i8> %a to <32 x half>
  ret <32 x half> %c
}

define <32 x half> @utofp_v32i8_v32f16(<32 x i8> %a) {
; CHECK-SD-NOFP16-LABEL: utofp_v32i8_v32f16:
; CHECK-SD-NOFP16:       // %bb.0: // %entry
; CHECK-SD-NOFP16-NEXT:    ushll v2.8h, v0.8b, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v0.8h, v0.16b, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v3.8h, v1.16b, #0
; CHECK-SD-NOFP16-NEXT:    ushll v1.8h, v1.8b, #0
; CHECK-SD-NOFP16-NEXT:    ushll v4.4s, v2.4h, #0
; CHECK-SD-NOFP16-NEXT:    ushll v5.4s, v0.4h, #0
; CHECK-SD-NOFP16-NEXT:    ushll v6.4s, v3.4h, #0
; CHECK-SD-NOFP16-NEXT:    ushll v7.4s, v1.4h, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v3.4s, v3.8h, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v2.4s, v2.8h, #0
; CHECK-SD-NOFP16-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-SD-NOFP16-NEXT:    ucvtf v4.4s, v4.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v5.4s, v5.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v6.4s, v6.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v7.4s, v7.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v16.4s, v0.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v17.4s, v3.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v18.4s, v2.4s
; CHECK-SD-NOFP16-NEXT:    ucvtf v19.4s, v1.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v0.4h, v4.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v1.4h, v5.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v3.4h, v6.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn v2.4h, v7.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v0.8h, v18.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v1.8h, v16.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v3.8h, v17.4s
; CHECK-SD-NOFP16-NEXT:    fcvtn2 v2.8h, v19.4s
; CHECK-SD-NOFP16-NEXT:    ret
;
; CHECK-SD-FP16-LABEL: utofp_v32i8_v32f16:
; CHECK-SD-FP16:       // %bb.0: // %entry
; CHECK-SD-FP16-NEXT:    ushll v2.8h, v0.8b, #0
; CHECK-SD-FP16-NEXT:    ushll2 v3.8h, v0.16b, #0
; CHECK-SD-FP16-NEXT:    ushll2 v4.8h, v1.16b, #0
; CHECK-SD-FP16-NEXT:    ushll v5.8h, v1.8b, #0
; CHECK-SD-FP16-NEXT:    ucvtf v0.8h, v2.8h
; CHECK-SD-FP16-NEXT:    ucvtf v1.8h, v3.8h
; CHECK-SD-FP16-NEXT:    ucvtf v3.8h, v4.8h
; CHECK-SD-FP16-NEXT:    ucvtf v2.8h, v5.8h
; CHECK-SD-FP16-NEXT:    ret
;
; CHECK-GI-NOFP16-LABEL: utofp_v32i8_v32f16:
; CHECK-GI-NOFP16:       // %bb.0: // %entry
; CHECK-GI-NOFP16-NEXT:    ushll v2.8h, v0.8b, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v0.8h, v0.16b, #0
; CHECK-GI-NOFP16-NEXT:    ushll v3.8h, v1.8b, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v1.8h, v1.16b, #0
; CHECK-GI-NOFP16-NEXT:    ushll v4.4s, v2.4h, #0
; CHECK-GI-NOFP16-NEXT:    ushll v5.4s, v0.4h, #0
; CHECK-GI-NOFP16-NEXT:    ushll v6.4s, v3.4h, #0
; CHECK-GI-NOFP16-NEXT:    ushll v7.4s, v1.4h, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v2.4s, v2.8h, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v3.4s, v3.8h, #0
; CHECK-GI-NOFP16-NEXT:    ushll2 v1.4s, v1.8h, #0
; CHECK-GI-NOFP16-NEXT:    ucvtf v4.4s, v4.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v5.4s, v5.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v6.4s, v6.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v7.4s, v7.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v16.4s, v2.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v17.4s, v0.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v18.4s, v3.4s
; CHECK-GI-NOFP16-NEXT:    ucvtf v19.4s, v1.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v0.4h, v4.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v1.4h, v5.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v2.4h, v6.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn v3.4h, v7.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v0.8h, v16.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v1.8h, v17.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v2.8h, v18.4s
; CHECK-GI-NOFP16-NEXT:    fcvtn2 v3.8h, v19.4s
; CHECK-GI-NOFP16-NEXT:    ret
;
; CHECK-GI-FP16-LABEL: utofp_v32i8_v32f16:
; CHECK-GI-FP16:       // %bb.0: // %entry
; CHECK-GI-FP16-NEXT:    ushll v2.8h, v0.8b, #0
; CHECK-GI-FP16-NEXT:    ushll2 v3.8h, v0.16b, #0
; CHECK-GI-FP16-NEXT:    ushll v4.8h, v1.8b, #0
; CHECK-GI-FP16-NEXT:    ushll2 v5.8h, v1.16b, #0
; CHECK-GI-FP16-NEXT:    ucvtf v0.8h, v2.8h
; CHECK-GI-FP16-NEXT:    ucvtf v1.8h, v3.8h
; CHECK-GI-FP16-NEXT:    ucvtf v2.8h, v4.8h
; CHECK-GI-FP16-NEXT:    ucvtf v3.8h, v5.8h
; CHECK-GI-FP16-NEXT:    ret
entry:
  %c = uitofp <32 x i8> %a to <32 x half>
  ret <32 x half> %c
}
