; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 -code-model=tiny -verify-machineinstrs | FileCheck %s

%struct.T = type <{ i32, i64, i8, i32 }>

@ptr = external dso_local local_unnamed_addr global i32*, align 8
@ch = external dso_local local_unnamed_addr global i32, align 4
@ch8 = external dso_local local_unnamed_addr global i8, align 4
@t = external dso_local local_unnamed_addr global %struct.T, align 4
@t2 = external dso_local local_unnamed_addr global %struct.T, align 2
@f = external dso_local local_unnamed_addr global float, align 4

define i32 @barp() {
; CHECK-LABEL: barp:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr x8, ptr
; CHECK-NEXT:    ldr w0, [x8]
; CHECK-NEXT:    ret
entry:
  %0 = load i32*, i32** @ptr, align 8
  %1 = load i32, i32* %0, align 4
  ret i32 %1
}

define i32 @barch() {
; CHECK-LABEL: barch:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr w0, ch
; CHECK-NEXT:    ret
entry:
  %0 = load i32, i32* @ch, align 4
  ret i32 %0
}

define i32 @barta() {
; CHECK-LABEL: barta:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr w0, t
; CHECK-NEXT:    ret
entry:
  %0 = load i32, i32* getelementptr inbounds (%struct.T, %struct.T* @t, i64 0, i32 0), align 4
  ret i32 %0
}

define i64 @bartb() {
; CHECK-LABEL: bartb:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr x0, t+4
; CHECK-NEXT:    ret
entry:
  %0 = load i64, i64* getelementptr inbounds (%struct.T, %struct.T* @t, i64 0, i32 1), align 8
  ret i64 %0
}

define i32 @bartc() {
; CHECK-LABEL: bartc:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adr x8, t+13
; CHECK-NEXT:    ldr w0, [x8]
; CHECK-NEXT:    ret
entry:
  %0 = load i32, i32* getelementptr inbounds (%struct.T, %struct.T* @t, i64 0, i32 3), align 1
  ret i32 %0
}

define i32 @bart2a() {
; CHECK-LABEL: bart2a:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adr x8, t2
; CHECK-NEXT:    ldr w0, [x8]
; CHECK-NEXT:    ret
entry:
  %0 = load i32, i32* getelementptr inbounds (%struct.T, %struct.T* @t2, i64 0, i32 0), align 2
  ret i32 %0
}

define i64 @zextload() {
; CHECK-LABEL: zextload:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr w0, ch
; CHECK-NEXT:    ret
entry:
  %0 = load i32, i32* @ch, align 4
  %1 = zext i32 %0 to i64
  ret i64 %1
}

define i64 @zextload8() {
; CHECK-LABEL: zextload8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adr x8, ch8
; CHECK-NEXT:    ldrb w0, [x8]
; CHECK-NEXT:    ret
entry:
  %0 = load i8, i8* @ch8, align 4
  %1 = zext i8 %0 to i64
  ret i64 %1
}

define i64 @sextload() {
; CHECK-LABEL: sextload:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldrsw x0, ch
; CHECK-NEXT:    ret
entry:
  %0 = load i32, i32* @ch, align 4
  %1 = sext i32 %0 to i64
  ret i64 %1
}

define i64 @sextload8() {
; CHECK-LABEL: sextload8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adr x8, ch8
; CHECK-NEXT:    ldrsb x0, [x8]
; CHECK-NEXT:    ret
entry:
  %0 = load i8, i8* @ch8, align 4
  %1 = sext i8 %0 to i64
  ret i64 %1
}

define float @floatload() {
; CHECK-LABEL: floatload:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr s0, f
; CHECK-NEXT:    ret
entry:
  %0 = load float, float* @f, align 4
  ret float %0
}

