; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=csky -csky-no-aliases -relocation-model=pic -mattr=+2e3 < %s \
; RUN:     | FileCheck -check-prefix=CSKY-PIC %s
; RUN: llc -mtriple=csky -csky-no-aliases -mattr=+2e3 < %s | FileCheck -check-prefix=CSKY-NOPIC %s

; Check that TLS symbols are lowered correctly based on the specified
; model. Make sure they're external to avoid them all being optimised to Local
; Exec for the executable.

@unspecified = external thread_local global i32
@ld = external thread_local(localdynamic) global i32
@ie = external thread_local(initialexec) global i32
@le = external thread_local(localexec) global i32


; No model specified

define i32* @f1() nounwind {
; CSKY-PIC-LABEL: f1:
; CSKY-PIC:       # %bb.0: # %entry
; CSKY-PIC-NEXT:    subi16 sp, sp, 8
; CSKY-PIC-NEXT:    st32.w rgb, (sp, 4) # 4-byte Folded Spill
; CSKY-PIC-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CSKY-PIC-NEXT:    lrw32 rgb, [.LCPI0_0]
; CSKY-PIC-NEXT:  .LPC0_1:
; CSKY-PIC-NEXT:    lrw32 a0, [.LCPI0_1]
; CSKY-PIC-NEXT:    grs32 a1, .LPC0_1
; CSKY-PIC-NEXT:    addu16 a0, a1
; CSKY-PIC-NEXT:    lrw32 a1, [.LCPI0_2]
; CSKY-PIC-NEXT:    ldr32.w a1, (rgb, a1 << 0)
; CSKY-PIC-NEXT:    jsr16 a1
; CSKY-PIC-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CSKY-PIC-NEXT:    ld32.w rgb, (sp, 4) # 4-byte Folded Reload
; CSKY-PIC-NEXT:    addi16 sp, sp, 8
; CSKY-PIC-NEXT:    rts16
; CSKY-PIC-NEXT:    .p2align 1
; CSKY-PIC-NEXT:  # %bb.1:
; CSKY-PIC-NEXT:    .p2align 2
; CSKY-PIC-NEXT:  .LCPI0_0:
; CSKY-PIC-NEXT:    .long _GLOBAL_OFFSET_TABLE_
; CSKY-PIC-NEXT:  .LCPI0_1:
; CSKY-PIC-NEXT:  .Ltmp0:
; CSKY-PIC-NEXT:    .long unspecified-(.LPC0_1-.Ltmp0)@TLSGD32
; CSKY-PIC-NEXT:  .LCPI0_2:
; CSKY-PIC-NEXT:    .long __tls_get_addr@PLT
;
; CSKY-NOPIC-LABEL: f1:
; CSKY-NOPIC:       # %bb.0: # %entry
; CSKY-NOPIC-NEXT:  .LPC0_1:
; CSKY-NOPIC-NEXT:    lrw32 a0, [.LCPI0_0]
; CSKY-NOPIC-NEXT:    grs32 a1, .LPC0_1
; CSKY-NOPIC-NEXT:    ldr32.w a0, (a0, a1 << 0)
; CSKY-NOPIC-NEXT:    addu32 a0, a0, tls
; CSKY-NOPIC-NEXT:    rts16
; CSKY-NOPIC-NEXT:    .p2align 1
; CSKY-NOPIC-NEXT:  # %bb.1:
; CSKY-NOPIC-NEXT:    .p2align 2
; CSKY-NOPIC-NEXT:  .LCPI0_0:
; CSKY-NOPIC-NEXT:  .Ltmp0:
; CSKY-NOPIC-NEXT:    .long unspecified-(.LPC0_1-.Ltmp0)@GOTTPOFF
entry:
  ret i32* @unspecified
}


; localdynamic specified

define i32* @f2() nounwind {
; CSKY-PIC-LABEL: f2:
; CSKY-PIC:       # %bb.0: # %entry
; CSKY-PIC-NEXT:    subi16 sp, sp, 8
; CSKY-PIC-NEXT:    st32.w rgb, (sp, 4) # 4-byte Folded Spill
; CSKY-PIC-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CSKY-PIC-NEXT:    lrw32 rgb, [.LCPI1_0]
; CSKY-PIC-NEXT:  .LPC1_1:
; CSKY-PIC-NEXT:    lrw32 a0, [.LCPI1_1]
; CSKY-PIC-NEXT:    grs32 a1, .LPC1_1
; CSKY-PIC-NEXT:    addu16 a0, a1
; CSKY-PIC-NEXT:    lrw32 a1, [.LCPI1_2]
; CSKY-PIC-NEXT:    ldr32.w a1, (rgb, a1 << 0)
; CSKY-PIC-NEXT:    jsr16 a1
; CSKY-PIC-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CSKY-PIC-NEXT:    ld32.w rgb, (sp, 4) # 4-byte Folded Reload
; CSKY-PIC-NEXT:    addi16 sp, sp, 8
; CSKY-PIC-NEXT:    rts16
; CSKY-PIC-NEXT:    .p2align 1
; CSKY-PIC-NEXT:  # %bb.1:
; CSKY-PIC-NEXT:    .p2align 2
; CSKY-PIC-NEXT:  .LCPI1_0:
; CSKY-PIC-NEXT:    .long _GLOBAL_OFFSET_TABLE_
; CSKY-PIC-NEXT:  .LCPI1_1:
; CSKY-PIC-NEXT:  .Ltmp1:
; CSKY-PIC-NEXT:    .long ld-(.LPC1_1-.Ltmp1)@TLSGD32
; CSKY-PIC-NEXT:  .LCPI1_2:
; CSKY-PIC-NEXT:    .long __tls_get_addr@PLT
;
; CSKY-NOPIC-LABEL: f2:
; CSKY-NOPIC:       # %bb.0: # %entry
; CSKY-NOPIC-NEXT:  .LPC1_1:
; CSKY-NOPIC-NEXT:    lrw32 a0, [.LCPI1_0]
; CSKY-NOPIC-NEXT:    grs32 a1, .LPC1_1
; CSKY-NOPIC-NEXT:    ldr32.w a0, (a0, a1 << 0)
; CSKY-NOPIC-NEXT:    addu32 a0, a0, tls
; CSKY-NOPIC-NEXT:    rts16
; CSKY-NOPIC-NEXT:    .p2align 1
; CSKY-NOPIC-NEXT:  # %bb.1:
; CSKY-NOPIC-NEXT:    .p2align 2
; CSKY-NOPIC-NEXT:  .LCPI1_0:
; CSKY-NOPIC-NEXT:  .Ltmp1:
; CSKY-NOPIC-NEXT:    .long ld-(.LPC1_1-.Ltmp1)@GOTTPOFF
entry:
  ret i32* @ld
}


; initialexec specified

define i32* @f3() nounwind {
; CSKY-PIC-LABEL: f3:
; CSKY-PIC:       # %bb.0: # %entry
; CSKY-PIC-NEXT:  .LPC2_1:
; CSKY-PIC-NEXT:    lrw32 a0, [.LCPI2_0]
; CSKY-PIC-NEXT:    grs32 a1, .LPC2_1
; CSKY-PIC-NEXT:    ldr32.w a0, (a0, a1 << 0)
; CSKY-PIC-NEXT:    addu32 a0, a0, tls
; CSKY-PIC-NEXT:    rts16
; CSKY-PIC-NEXT:    .p2align 1
; CSKY-PIC-NEXT:  # %bb.1:
; CSKY-PIC-NEXT:    .p2align 2
; CSKY-PIC-NEXT:  .LCPI2_0:
; CSKY-PIC-NEXT:  .Ltmp2:
; CSKY-PIC-NEXT:    .long ie-(.LPC2_1-.Ltmp2)@GOTTPOFF
;
; CSKY-NOPIC-LABEL: f3:
; CSKY-NOPIC:       # %bb.0: # %entry
; CSKY-NOPIC-NEXT:  .LPC2_1:
; CSKY-NOPIC-NEXT:    lrw32 a0, [.LCPI2_0]
; CSKY-NOPIC-NEXT:    grs32 a1, .LPC2_1
; CSKY-NOPIC-NEXT:    ldr32.w a0, (a0, a1 << 0)
; CSKY-NOPIC-NEXT:    addu32 a0, a0, tls
; CSKY-NOPIC-NEXT:    rts16
; CSKY-NOPIC-NEXT:    .p2align 1
; CSKY-NOPIC-NEXT:  # %bb.1:
; CSKY-NOPIC-NEXT:    .p2align 2
; CSKY-NOPIC-NEXT:  .LCPI2_0:
; CSKY-NOPIC-NEXT:  .Ltmp2:
; CSKY-NOPIC-NEXT:    .long ie-(.LPC2_1-.Ltmp2)@GOTTPOFF
entry:
  ret i32* @ie
}


; localexec specified

define i32* @f4() nounwind {
; CSKY-PIC-LABEL: f4:
; CSKY-PIC:       # %bb.0: # %entry
; CSKY-PIC-NEXT:    lrw32 a0, [.LCPI3_0]
; CSKY-PIC-NEXT:    addu32 a0, a0, tls
; CSKY-PIC-NEXT:    rts16
; CSKY-PIC-NEXT:    .p2align 1
; CSKY-PIC-NEXT:  # %bb.1:
; CSKY-PIC-NEXT:    .p2align 2
; CSKY-PIC-NEXT:  .LCPI3_0:
; CSKY-PIC-NEXT:    .long le@TPOFF
;
; CSKY-NOPIC-LABEL: f4:
; CSKY-NOPIC:       # %bb.0: # %entry
; CSKY-NOPIC-NEXT:    lrw32 a0, [.LCPI3_0]
; CSKY-NOPIC-NEXT:    addu32 a0, a0, tls
; CSKY-NOPIC-NEXT:    rts16
; CSKY-NOPIC-NEXT:    .p2align 1
; CSKY-NOPIC-NEXT:  # %bb.1:
; CSKY-NOPIC-NEXT:    .p2align 2
; CSKY-NOPIC-NEXT:  .LCPI3_0:
; CSKY-NOPIC-NEXT:    .long le@TPOFF
entry:
  ret i32* @le
}
