; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s | FileCheck %s -check-prefixes=RV64I
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s | FileCheck %s -check-prefixes=RV32I

define void @lshr_4bytes(ptr %src.ptr, ptr %byteOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: lshr_4bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    lbu a4, 0(a0)
; RV64I-NEXT:    lbu a5, 2(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    lb a0, 3(a0)
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    lbu a1, 0(a1)
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, a5
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    slli a1, a1, 3
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: lshr_4bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lbu a3, 1(a0)
; RV32I-NEXT:    lbu a4, 0(a0)
; RV32I-NEXT:    lbu a5, 2(a0)
; RV32I-NEXT:    lbu a0, 3(a0)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a5
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    lbu a3, 1(a1)
; RV32I-NEXT:    lbu a4, 0(a1)
; RV32I-NEXT:    lbu a5, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a5
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    slli a1, a1, 3
; RV32I-NEXT:    srl a0, a0, a1
; RV32I-NEXT:    sb a0, 0(a2)
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    sb a1, 2(a2)
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    sb a1, 3(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 1(a2)
; RV32I-NEXT:    ret
  %src = load i32, ptr %src.ptr, align 1
  %byteOff = load i32, ptr %byteOff.ptr, align 1
  %bitOff = shl i32 %byteOff, 3
  %res = lshr i32 %src, %bitOff
  store i32 %res, ptr %dst, align 1
  ret void
}
define void @shl_4bytes(ptr %src.ptr, ptr %byteOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: shl_4bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    lbu a4, 0(a0)
; RV64I-NEXT:    lbu a5, 2(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    lb a0, 3(a0)
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    lbu a1, 0(a1)
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, a5
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    slli a1, a1, 3
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: shl_4bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lbu a3, 1(a0)
; RV32I-NEXT:    lbu a4, 0(a0)
; RV32I-NEXT:    lbu a5, 2(a0)
; RV32I-NEXT:    lbu a0, 3(a0)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a5
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    lbu a3, 1(a1)
; RV32I-NEXT:    lbu a4, 0(a1)
; RV32I-NEXT:    lbu a5, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a5
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    slli a1, a1, 3
; RV32I-NEXT:    sll a0, a0, a1
; RV32I-NEXT:    sb a0, 0(a2)
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    sb a1, 2(a2)
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    sb a1, 3(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 1(a2)
; RV32I-NEXT:    ret
  %src = load i32, ptr %src.ptr, align 1
  %byteOff = load i32, ptr %byteOff.ptr, align 1
  %bitOff = shl i32 %byteOff, 3
  %res = shl i32 %src, %bitOff
  store i32 %res, ptr %dst, align 1
  ret void
}
define void @ashr_4bytes(ptr %src.ptr, ptr %byteOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: ashr_4bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    lbu a4, 0(a0)
; RV64I-NEXT:    lbu a5, 2(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    lb a0, 3(a0)
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    lbu a1, 0(a1)
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, a5
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    slli a1, a1, 3
; RV64I-NEXT:    sraw a0, a0, a1
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: ashr_4bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lbu a3, 1(a0)
; RV32I-NEXT:    lbu a4, 0(a0)
; RV32I-NEXT:    lbu a5, 2(a0)
; RV32I-NEXT:    lbu a0, 3(a0)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a5
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:    lbu a3, 1(a1)
; RV32I-NEXT:    lbu a4, 0(a1)
; RV32I-NEXT:    lbu a5, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a5
; RV32I-NEXT:    or a1, a1, a3
; RV32I-NEXT:    slli a1, a1, 3
; RV32I-NEXT:    sra a0, a0, a1
; RV32I-NEXT:    sb a0, 0(a2)
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    sb a1, 2(a2)
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    sb a1, 3(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 1(a2)
; RV32I-NEXT:    ret
  %src = load i32, ptr %src.ptr, align 1
  %byteOff = load i32, ptr %byteOff.ptr, align 1
  %bitOff = shl i32 %byteOff, 3
  %res = ashr i32 %src, %bitOff
  store i32 %res, ptr %dst, align 1
  ret void
}

define void @lshr_8bytes(ptr %src.ptr, ptr %byteOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: lshr_8bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    lbu a4, 0(a0)
; RV64I-NEXT:    lbu a5, 2(a0)
; RV64I-NEXT:    lbu a6, 3(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 5(a0)
; RV64I-NEXT:    lbu a5, 4(a0)
; RV64I-NEXT:    lbu a6, 6(a0)
; RV64I-NEXT:    lbu a0, 7(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, a6
; RV64I-NEXT:    or a0, a0, a4
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    lbu a3, 5(a1)
; RV64I-NEXT:    lbu a4, 4(a1)
; RV64I-NEXT:    lbu a5, 6(a1)
; RV64I-NEXT:    lbu a6, 7(a1)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 1(a1)
; RV64I-NEXT:    lbu a5, 0(a1)
; RV64I-NEXT:    lbu a6, 2(a1)
; RV64I-NEXT:    lbu a1, 3(a1)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, a6
; RV64I-NEXT:    or a1, a1, a4
; RV64I-NEXT:    slli a1, a1, 3
; RV64I-NEXT:    slli a3, a3, 35
; RV64I-NEXT:    or a1, a3, a1
; RV64I-NEXT:    srl a0, a0, a1
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 48
; RV64I-NEXT:    sb a1, 6(a2)
; RV64I-NEXT:    srli a1, a0, 56
; RV64I-NEXT:    sb a1, 7(a2)
; RV64I-NEXT:    srli a1, a0, 32
; RV64I-NEXT:    sb a1, 4(a2)
; RV64I-NEXT:    srli a1, a0, 40
; RV64I-NEXT:    sb a1, 5(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: lshr_8bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lbu a3, 5(a0)
; RV32I-NEXT:    lbu a4, 4(a0)
; RV32I-NEXT:    lbu a5, 6(a0)
; RV32I-NEXT:    lbu a6, 7(a0)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a6, a6, 24
; RV32I-NEXT:    or a4, a6, a5
; RV32I-NEXT:    or a3, a4, a3
; RV32I-NEXT:    lbu a4, 1(a1)
; RV32I-NEXT:    lbu a5, 0(a1)
; RV32I-NEXT:    lbu a6, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    slli a4, a4, 8
; RV32I-NEXT:    or a4, a4, a5
; RV32I-NEXT:    slli a6, a6, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    or a1, a1, a4
; RV32I-NEXT:    slli a5, a1, 3
; RV32I-NEXT:    addi a4, a5, -32
; RV32I-NEXT:    srl a1, a3, a5
; RV32I-NEXT:    bltz a4, .LBB3_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    j .LBB3_3
; RV32I-NEXT:  .LBB3_2:
; RV32I-NEXT:    lbu a6, 1(a0)
; RV32I-NEXT:    lbu a7, 0(a0)
; RV32I-NEXT:    lbu t0, 2(a0)
; RV32I-NEXT:    lbu a0, 3(a0)
; RV32I-NEXT:    slli a6, a6, 8
; RV32I-NEXT:    or a6, a6, a7
; RV32I-NEXT:    slli t0, t0, 16
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, t0
; RV32I-NEXT:    or a0, a0, a6
; RV32I-NEXT:    srl a0, a0, a5
; RV32I-NEXT:    slli a3, a3, 1
; RV32I-NEXT:    not a5, a5
; RV32I-NEXT:    sll a3, a3, a5
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:  .LBB3_3:
; RV32I-NEXT:    srai a4, a4, 31
; RV32I-NEXT:    and a1, a4, a1
; RV32I-NEXT:    sb a1, 4(a2)
; RV32I-NEXT:    srli a3, a1, 16
; RV32I-NEXT:    sb a3, 6(a2)
; RV32I-NEXT:    srli a3, a1, 24
; RV32I-NEXT:    sb a3, 7(a2)
; RV32I-NEXT:    srli a1, a1, 8
; RV32I-NEXT:    sb a1, 5(a2)
; RV32I-NEXT:    sb a0, 0(a2)
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    sb a1, 2(a2)
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    sb a1, 3(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 1(a2)
; RV32I-NEXT:    ret
  %src = load i64, ptr %src.ptr, align 1
  %byteOff = load i64, ptr %byteOff.ptr, align 1
  %bitOff = shl i64 %byteOff, 3
  %res = lshr i64 %src, %bitOff
  store i64 %res, ptr %dst, align 1
  ret void
}
define void @shl_8bytes(ptr %src.ptr, ptr %byteOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: shl_8bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    lbu a4, 0(a0)
; RV64I-NEXT:    lbu a5, 2(a0)
; RV64I-NEXT:    lbu a6, 3(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 5(a0)
; RV64I-NEXT:    lbu a5, 4(a0)
; RV64I-NEXT:    lbu a6, 6(a0)
; RV64I-NEXT:    lbu a0, 7(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, a6
; RV64I-NEXT:    or a0, a0, a4
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    lbu a3, 5(a1)
; RV64I-NEXT:    lbu a4, 4(a1)
; RV64I-NEXT:    lbu a5, 6(a1)
; RV64I-NEXT:    lbu a6, 7(a1)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 1(a1)
; RV64I-NEXT:    lbu a5, 0(a1)
; RV64I-NEXT:    lbu a6, 2(a1)
; RV64I-NEXT:    lbu a1, 3(a1)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, a6
; RV64I-NEXT:    or a1, a1, a4
; RV64I-NEXT:    slli a1, a1, 3
; RV64I-NEXT:    slli a3, a3, 35
; RV64I-NEXT:    or a1, a3, a1
; RV64I-NEXT:    sll a0, a0, a1
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 48
; RV64I-NEXT:    sb a1, 6(a2)
; RV64I-NEXT:    srli a1, a0, 56
; RV64I-NEXT:    sb a1, 7(a2)
; RV64I-NEXT:    srli a1, a0, 32
; RV64I-NEXT:    sb a1, 4(a2)
; RV64I-NEXT:    srli a1, a0, 40
; RV64I-NEXT:    sb a1, 5(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: shl_8bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lbu a3, 1(a0)
; RV32I-NEXT:    lbu a4, 0(a0)
; RV32I-NEXT:    lbu a5, 2(a0)
; RV32I-NEXT:    lbu a6, 3(a0)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a6, a6, 24
; RV32I-NEXT:    or a4, a6, a5
; RV32I-NEXT:    or a3, a4, a3
; RV32I-NEXT:    lbu a4, 1(a1)
; RV32I-NEXT:    lbu a5, 0(a1)
; RV32I-NEXT:    lbu a6, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    slli a4, a4, 8
; RV32I-NEXT:    or a4, a4, a5
; RV32I-NEXT:    slli a6, a6, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a6
; RV32I-NEXT:    or a1, a1, a4
; RV32I-NEXT:    slli a5, a1, 3
; RV32I-NEXT:    addi a4, a5, -32
; RV32I-NEXT:    sll a1, a3, a5
; RV32I-NEXT:    bltz a4, .LBB4_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    j .LBB4_3
; RV32I-NEXT:  .LBB4_2:
; RV32I-NEXT:    lbu a6, 5(a0)
; RV32I-NEXT:    lbu a7, 4(a0)
; RV32I-NEXT:    lbu t0, 6(a0)
; RV32I-NEXT:    lbu a0, 7(a0)
; RV32I-NEXT:    slli a6, a6, 8
; RV32I-NEXT:    or a6, a6, a7
; RV32I-NEXT:    slli t0, t0, 16
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, t0
; RV32I-NEXT:    or a0, a0, a6
; RV32I-NEXT:    sll a0, a0, a5
; RV32I-NEXT:    srli a3, a3, 1
; RV32I-NEXT:    not a5, a5
; RV32I-NEXT:    srl a3, a3, a5
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:  .LBB4_3:
; RV32I-NEXT:    srai a4, a4, 31
; RV32I-NEXT:    and a1, a4, a1
; RV32I-NEXT:    sb a1, 0(a2)
; RV32I-NEXT:    sb a0, 4(a2)
; RV32I-NEXT:    srli a3, a1, 16
; RV32I-NEXT:    sb a3, 2(a2)
; RV32I-NEXT:    srli a3, a1, 24
; RV32I-NEXT:    sb a3, 3(a2)
; RV32I-NEXT:    srli a1, a1, 8
; RV32I-NEXT:    sb a1, 1(a2)
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    sb a1, 6(a2)
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    sb a1, 7(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 5(a2)
; RV32I-NEXT:    ret
  %src = load i64, ptr %src.ptr, align 1
  %byteOff = load i64, ptr %byteOff.ptr, align 1
  %bitOff = shl i64 %byteOff, 3
  %res = shl i64 %src, %bitOff
  store i64 %res, ptr %dst, align 1
  ret void
}
define void @ashr_8bytes(ptr %src.ptr, ptr %byteOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: ashr_8bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    lbu a4, 0(a0)
; RV64I-NEXT:    lbu a5, 2(a0)
; RV64I-NEXT:    lbu a6, 3(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 5(a0)
; RV64I-NEXT:    lbu a5, 4(a0)
; RV64I-NEXT:    lbu a6, 6(a0)
; RV64I-NEXT:    lbu a0, 7(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, a6
; RV64I-NEXT:    or a0, a0, a4
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    lbu a3, 5(a1)
; RV64I-NEXT:    lbu a4, 4(a1)
; RV64I-NEXT:    lbu a5, 6(a1)
; RV64I-NEXT:    lbu a6, 7(a1)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 1(a1)
; RV64I-NEXT:    lbu a5, 0(a1)
; RV64I-NEXT:    lbu a6, 2(a1)
; RV64I-NEXT:    lbu a1, 3(a1)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, a6
; RV64I-NEXT:    or a1, a1, a4
; RV64I-NEXT:    slli a1, a1, 3
; RV64I-NEXT:    slli a3, a3, 35
; RV64I-NEXT:    or a1, a3, a1
; RV64I-NEXT:    sra a0, a0, a1
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 48
; RV64I-NEXT:    sb a1, 6(a2)
; RV64I-NEXT:    srli a1, a0, 56
; RV64I-NEXT:    sb a1, 7(a2)
; RV64I-NEXT:    srli a1, a0, 32
; RV64I-NEXT:    sb a1, 4(a2)
; RV64I-NEXT:    srli a1, a0, 40
; RV64I-NEXT:    sb a1, 5(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: ashr_8bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lbu a3, 5(a0)
; RV32I-NEXT:    lbu a4, 4(a0)
; RV32I-NEXT:    lbu a5, 6(a0)
; RV32I-NEXT:    lbu a6, 7(a0)
; RV32I-NEXT:    slli a3, a3, 8
; RV32I-NEXT:    or a3, a3, a4
; RV32I-NEXT:    slli a5, a5, 16
; RV32I-NEXT:    slli a4, a6, 24
; RV32I-NEXT:    or a5, a4, a5
; RV32I-NEXT:    or a3, a5, a3
; RV32I-NEXT:    lbu a5, 1(a1)
; RV32I-NEXT:    lbu a6, 0(a1)
; RV32I-NEXT:    lbu a7, 2(a1)
; RV32I-NEXT:    lbu a1, 3(a1)
; RV32I-NEXT:    slli a5, a5, 8
; RV32I-NEXT:    or a5, a5, a6
; RV32I-NEXT:    slli a7, a7, 16
; RV32I-NEXT:    slli a1, a1, 24
; RV32I-NEXT:    or a1, a1, a7
; RV32I-NEXT:    or a1, a1, a5
; RV32I-NEXT:    slli a5, a1, 3
; RV32I-NEXT:    addi a6, a5, -32
; RV32I-NEXT:    sra a1, a3, a5
; RV32I-NEXT:    bltz a6, .LBB5_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    srai a4, a4, 31
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    mv a1, a4
; RV32I-NEXT:    j .LBB5_3
; RV32I-NEXT:  .LBB5_2:
; RV32I-NEXT:    lbu a4, 1(a0)
; RV32I-NEXT:    lbu a6, 0(a0)
; RV32I-NEXT:    lbu a7, 2(a0)
; RV32I-NEXT:    lbu a0, 3(a0)
; RV32I-NEXT:    slli a4, a4, 8
; RV32I-NEXT:    or a4, a4, a6
; RV32I-NEXT:    slli a7, a7, 16
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    or a0, a0, a7
; RV32I-NEXT:    or a0, a0, a4
; RV32I-NEXT:    srl a0, a0, a5
; RV32I-NEXT:    slli a3, a3, 1
; RV32I-NEXT:    not a4, a5
; RV32I-NEXT:    sll a3, a3, a4
; RV32I-NEXT:    or a0, a0, a3
; RV32I-NEXT:  .LBB5_3:
; RV32I-NEXT:    sb a1, 4(a2)
; RV32I-NEXT:    srli a3, a1, 16
; RV32I-NEXT:    sb a3, 6(a2)
; RV32I-NEXT:    srli a3, a1, 24
; RV32I-NEXT:    sb a3, 7(a2)
; RV32I-NEXT:    srli a1, a1, 8
; RV32I-NEXT:    sb a1, 5(a2)
; RV32I-NEXT:    sb a0, 0(a2)
; RV32I-NEXT:    srli a1, a0, 16
; RV32I-NEXT:    sb a1, 2(a2)
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    sb a1, 3(a2)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 1(a2)
; RV32I-NEXT:    ret
  %src = load i64, ptr %src.ptr, align 1
  %byteOff = load i64, ptr %byteOff.ptr, align 1
  %bitOff = shl i64 %byteOff, 3
  %res = ashr i64 %src, %bitOff
  store i64 %res, ptr %dst, align 1
  ret void
}

define void @lshr_16bytes(ptr %src.ptr, ptr %byteOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: lshr_16bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 9(a0)
; RV64I-NEXT:    lbu a4, 8(a0)
; RV64I-NEXT:    lbu a5, 10(a0)
; RV64I-NEXT:    lbu a6, 11(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 13(a0)
; RV64I-NEXT:    lbu a5, 12(a0)
; RV64I-NEXT:    lbu a6, 14(a0)
; RV64I-NEXT:    lbu a7, 15(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a7, a7, 24
; RV64I-NEXT:    or a5, a7, a6
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    slli a4, a4, 32
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 5(a1)
; RV64I-NEXT:    lbu a5, 4(a1)
; RV64I-NEXT:    lbu a6, 6(a1)
; RV64I-NEXT:    lbu a7, 7(a1)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a7, a7, 24
; RV64I-NEXT:    or a5, a7, a6
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    lbu a5, 1(a1)
; RV64I-NEXT:    lbu a6, 0(a1)
; RV64I-NEXT:    lbu a7, 2(a1)
; RV64I-NEXT:    lbu a1, 3(a1)
; RV64I-NEXT:    slli a5, a5, 8
; RV64I-NEXT:    or a5, a5, a6
; RV64I-NEXT:    slli a7, a7, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, a7
; RV64I-NEXT:    or a1, a1, a5
; RV64I-NEXT:    slli a1, a1, 3
; RV64I-NEXT:    slli a4, a4, 35
; RV64I-NEXT:    or a5, a4, a1
; RV64I-NEXT:    addi a4, a5, -64
; RV64I-NEXT:    srl a1, a3, a5
; RV64I-NEXT:    bltz a4, .LBB6_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    j .LBB6_3
; RV64I-NEXT:  .LBB6_2:
; RV64I-NEXT:    lbu a6, 1(a0)
; RV64I-NEXT:    lbu a7, 0(a0)
; RV64I-NEXT:    lbu t0, 2(a0)
; RV64I-NEXT:    lbu t1, 3(a0)
; RV64I-NEXT:    slli a6, a6, 8
; RV64I-NEXT:    or a6, a6, a7
; RV64I-NEXT:    slli t0, t0, 16
; RV64I-NEXT:    slli t1, t1, 24
; RV64I-NEXT:    or a7, t1, t0
; RV64I-NEXT:    or a6, a7, a6
; RV64I-NEXT:    lbu a7, 5(a0)
; RV64I-NEXT:    lbu t0, 4(a0)
; RV64I-NEXT:    lbu t1, 6(a0)
; RV64I-NEXT:    lbu a0, 7(a0)
; RV64I-NEXT:    slli a7, a7, 8
; RV64I-NEXT:    or a7, a7, t0
; RV64I-NEXT:    slli t1, t1, 16
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, t1
; RV64I-NEXT:    or a0, a0, a7
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    or a0, a0, a6
; RV64I-NEXT:    srl a0, a0, a5
; RV64I-NEXT:    not a5, a5
; RV64I-NEXT:    slli a3, a3, 1
; RV64I-NEXT:    sll a3, a3, a5
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:  .LBB6_3:
; RV64I-NEXT:    srai a4, a4, 63
; RV64I-NEXT:    and a1, a4, a1
; RV64I-NEXT:    sb a1, 8(a2)
; RV64I-NEXT:    srli a3, a1, 56
; RV64I-NEXT:    sb a3, 15(a2)
; RV64I-NEXT:    srli a3, a1, 48
; RV64I-NEXT:    sb a3, 14(a2)
; RV64I-NEXT:    srli a3, a1, 40
; RV64I-NEXT:    sb a3, 13(a2)
; RV64I-NEXT:    srli a3, a1, 32
; RV64I-NEXT:    sb a3, 12(a2)
; RV64I-NEXT:    srli a3, a1, 24
; RV64I-NEXT:    sb a3, 11(a2)
; RV64I-NEXT:    srli a3, a1, 16
; RV64I-NEXT:    sb a3, 10(a2)
; RV64I-NEXT:    srli a1, a1, 8
; RV64I-NEXT:    sb a1, 9(a2)
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 56
; RV64I-NEXT:    sb a1, 7(a2)
; RV64I-NEXT:    srli a1, a0, 48
; RV64I-NEXT:    sb a1, 6(a2)
; RV64I-NEXT:    srli a1, a0, 40
; RV64I-NEXT:    sb a1, 5(a2)
; RV64I-NEXT:    srli a1, a0, 32
; RV64I-NEXT:    sb a1, 4(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: lshr_16bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -48
; RV32I-NEXT:    sw s0, 44(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 40(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 36(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    lbu a4, 1(a0)
; RV32I-NEXT:    lbu a5, 2(a0)
; RV32I-NEXT:    lbu a6, 3(a0)
; RV32I-NEXT:    lbu a7, 4(a0)
; RV32I-NEXT:    lbu t0, 5(a0)
; RV32I-NEXT:    lbu t1, 6(a0)
; RV32I-NEXT:    lbu t2, 7(a0)
; RV32I-NEXT:    lbu t3, 8(a0)
; RV32I-NEXT:    lbu t4, 9(a0)
; RV32I-NEXT:    lbu t5, 10(a0)
; RV32I-NEXT:    lbu t6, 11(a0)
; RV32I-NEXT:    lbu s0, 12(a0)
; RV32I-NEXT:    lbu s1, 13(a0)
; RV32I-NEXT:    lbu s2, 14(a0)
; RV32I-NEXT:    lbu a0, 15(a0)
; RV32I-NEXT:    lbu a1, 0(a1)
; RV32I-NEXT:    sb zero, 35(sp)
; RV32I-NEXT:    sb zero, 34(sp)
; RV32I-NEXT:    sb zero, 33(sp)
; RV32I-NEXT:    sb zero, 32(sp)
; RV32I-NEXT:    sb zero, 31(sp)
; RV32I-NEXT:    sb zero, 30(sp)
; RV32I-NEXT:    sb zero, 29(sp)
; RV32I-NEXT:    sb zero, 28(sp)
; RV32I-NEXT:    sb zero, 27(sp)
; RV32I-NEXT:    sb zero, 26(sp)
; RV32I-NEXT:    sb zero, 25(sp)
; RV32I-NEXT:    sb zero, 24(sp)
; RV32I-NEXT:    sb zero, 23(sp)
; RV32I-NEXT:    sb zero, 22(sp)
; RV32I-NEXT:    sb zero, 21(sp)
; RV32I-NEXT:    sb zero, 20(sp)
; RV32I-NEXT:    sb a0, 19(sp)
; RV32I-NEXT:    sb s2, 18(sp)
; RV32I-NEXT:    sb s1, 17(sp)
; RV32I-NEXT:    sb s0, 16(sp)
; RV32I-NEXT:    sb t6, 15(sp)
; RV32I-NEXT:    sb t5, 14(sp)
; RV32I-NEXT:    sb t4, 13(sp)
; RV32I-NEXT:    sb t3, 12(sp)
; RV32I-NEXT:    sb t2, 11(sp)
; RV32I-NEXT:    sb t1, 10(sp)
; RV32I-NEXT:    sb t0, 9(sp)
; RV32I-NEXT:    sb a7, 8(sp)
; RV32I-NEXT:    sb a6, 7(sp)
; RV32I-NEXT:    sb a5, 6(sp)
; RV32I-NEXT:    sb a4, 5(sp)
; RV32I-NEXT:    sb a3, 4(sp)
; RV32I-NEXT:    andi a1, a1, 15
; RV32I-NEXT:    addi a0, sp, 4
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lbu a1, 5(a0)
; RV32I-NEXT:    lbu a3, 4(a0)
; RV32I-NEXT:    lbu a4, 7(a0)
; RV32I-NEXT:    lbu a5, 6(a0)
; RV32I-NEXT:    lbu a6, 1(a0)
; RV32I-NEXT:    lbu a7, 0(a0)
; RV32I-NEXT:    lbu t0, 3(a0)
; RV32I-NEXT:    lbu t1, 2(a0)
; RV32I-NEXT:    lbu t2, 13(a0)
; RV32I-NEXT:    lbu t3, 12(a0)
; RV32I-NEXT:    lbu t4, 15(a0)
; RV32I-NEXT:    lbu t5, 14(a0)
; RV32I-NEXT:    lbu t6, 10(a0)
; RV32I-NEXT:    lbu s0, 11(a0)
; RV32I-NEXT:    lbu s1, 8(a0)
; RV32I-NEXT:    lbu a0, 9(a0)
; RV32I-NEXT:    sb t6, 10(a2)
; RV32I-NEXT:    sb s0, 11(a2)
; RV32I-NEXT:    sb s1, 8(a2)
; RV32I-NEXT:    sb a0, 9(a2)
; RV32I-NEXT:    sb t5, 14(a2)
; RV32I-NEXT:    sb t4, 15(a2)
; RV32I-NEXT:    sb t3, 12(a2)
; RV32I-NEXT:    sb t2, 13(a2)
; RV32I-NEXT:    sb t1, 2(a2)
; RV32I-NEXT:    sb t0, 3(a2)
; RV32I-NEXT:    sb a7, 0(a2)
; RV32I-NEXT:    sb a6, 1(a2)
; RV32I-NEXT:    sb a5, 6(a2)
; RV32I-NEXT:    sb a4, 7(a2)
; RV32I-NEXT:    sb a3, 4(a2)
; RV32I-NEXT:    sb a1, 5(a2)
; RV32I-NEXT:    lw s0, 44(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 40(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 36(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 48
; RV32I-NEXT:    ret
  %src = load i128, ptr %src.ptr, align 1
  %byteOff = load i128, ptr %byteOff.ptr, align 1
  %bitOff = shl i128 %byteOff, 3
  %res = lshr i128 %src, %bitOff
  store i128 %res, ptr %dst, align 1
  ret void
}
define void @shl_16bytes(ptr %src.ptr, ptr %byteOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: shl_16bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    lbu a4, 0(a0)
; RV64I-NEXT:    lbu a5, 2(a0)
; RV64I-NEXT:    lbu a6, 3(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 5(a0)
; RV64I-NEXT:    lbu a5, 4(a0)
; RV64I-NEXT:    lbu a6, 6(a0)
; RV64I-NEXT:    lbu a7, 7(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a7, a7, 24
; RV64I-NEXT:    or a5, a7, a6
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    slli a4, a4, 32
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 5(a1)
; RV64I-NEXT:    lbu a5, 4(a1)
; RV64I-NEXT:    lbu a6, 6(a1)
; RV64I-NEXT:    lbu a7, 7(a1)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a7, a7, 24
; RV64I-NEXT:    or a5, a7, a6
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    lbu a5, 1(a1)
; RV64I-NEXT:    lbu a6, 0(a1)
; RV64I-NEXT:    lbu a7, 2(a1)
; RV64I-NEXT:    lbu a1, 3(a1)
; RV64I-NEXT:    slli a5, a5, 8
; RV64I-NEXT:    or a5, a5, a6
; RV64I-NEXT:    slli a7, a7, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, a7
; RV64I-NEXT:    or a1, a1, a5
; RV64I-NEXT:    slli a1, a1, 3
; RV64I-NEXT:    slli a4, a4, 35
; RV64I-NEXT:    or a5, a4, a1
; RV64I-NEXT:    addi a4, a5, -64
; RV64I-NEXT:    sll a1, a3, a5
; RV64I-NEXT:    bltz a4, .LBB7_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    j .LBB7_3
; RV64I-NEXT:  .LBB7_2:
; RV64I-NEXT:    lbu a6, 9(a0)
; RV64I-NEXT:    lbu a7, 8(a0)
; RV64I-NEXT:    lbu t0, 10(a0)
; RV64I-NEXT:    lbu t1, 11(a0)
; RV64I-NEXT:    slli a6, a6, 8
; RV64I-NEXT:    or a6, a6, a7
; RV64I-NEXT:    slli t0, t0, 16
; RV64I-NEXT:    slli t1, t1, 24
; RV64I-NEXT:    or a7, t1, t0
; RV64I-NEXT:    or a6, a7, a6
; RV64I-NEXT:    lbu a7, 13(a0)
; RV64I-NEXT:    lbu t0, 12(a0)
; RV64I-NEXT:    lbu t1, 14(a0)
; RV64I-NEXT:    lbu a0, 15(a0)
; RV64I-NEXT:    slli a7, a7, 8
; RV64I-NEXT:    or a7, a7, t0
; RV64I-NEXT:    slli t1, t1, 16
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, t1
; RV64I-NEXT:    or a0, a0, a7
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    or a0, a0, a6
; RV64I-NEXT:    sll a0, a0, a5
; RV64I-NEXT:    not a5, a5
; RV64I-NEXT:    srli a3, a3, 1
; RV64I-NEXT:    srl a3, a3, a5
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:  .LBB7_3:
; RV64I-NEXT:    srai a4, a4, 63
; RV64I-NEXT:    and a1, a4, a1
; RV64I-NEXT:    sb a1, 0(a2)
; RV64I-NEXT:    sb a0, 8(a2)
; RV64I-NEXT:    srli a3, a1, 56
; RV64I-NEXT:    sb a3, 7(a2)
; RV64I-NEXT:    srli a3, a1, 48
; RV64I-NEXT:    sb a3, 6(a2)
; RV64I-NEXT:    srli a3, a1, 40
; RV64I-NEXT:    sb a3, 5(a2)
; RV64I-NEXT:    srli a3, a1, 32
; RV64I-NEXT:    sb a3, 4(a2)
; RV64I-NEXT:    srli a3, a1, 24
; RV64I-NEXT:    sb a3, 3(a2)
; RV64I-NEXT:    srli a3, a1, 16
; RV64I-NEXT:    sb a3, 2(a2)
; RV64I-NEXT:    srli a1, a1, 8
; RV64I-NEXT:    sb a1, 1(a2)
; RV64I-NEXT:    srli a1, a0, 56
; RV64I-NEXT:    sb a1, 15(a2)
; RV64I-NEXT:    srli a1, a0, 48
; RV64I-NEXT:    sb a1, 14(a2)
; RV64I-NEXT:    srli a1, a0, 40
; RV64I-NEXT:    sb a1, 13(a2)
; RV64I-NEXT:    srli a1, a0, 32
; RV64I-NEXT:    sb a1, 12(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 11(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 10(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 9(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: shl_16bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -48
; RV32I-NEXT:    sw s0, 44(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 40(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 36(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    lbu a4, 1(a0)
; RV32I-NEXT:    lbu a5, 2(a0)
; RV32I-NEXT:    lbu a6, 3(a0)
; RV32I-NEXT:    lbu a7, 4(a0)
; RV32I-NEXT:    lbu t0, 5(a0)
; RV32I-NEXT:    lbu t1, 6(a0)
; RV32I-NEXT:    lbu t2, 7(a0)
; RV32I-NEXT:    lbu t3, 8(a0)
; RV32I-NEXT:    lbu t4, 9(a0)
; RV32I-NEXT:    lbu t5, 10(a0)
; RV32I-NEXT:    lbu t6, 11(a0)
; RV32I-NEXT:    lbu s0, 12(a0)
; RV32I-NEXT:    lbu s1, 13(a0)
; RV32I-NEXT:    lbu s2, 14(a0)
; RV32I-NEXT:    lbu a0, 15(a0)
; RV32I-NEXT:    lbu a1, 0(a1)
; RV32I-NEXT:    sb zero, 19(sp)
; RV32I-NEXT:    sb zero, 18(sp)
; RV32I-NEXT:    sb zero, 17(sp)
; RV32I-NEXT:    sb zero, 16(sp)
; RV32I-NEXT:    sb zero, 15(sp)
; RV32I-NEXT:    sb zero, 14(sp)
; RV32I-NEXT:    sb zero, 13(sp)
; RV32I-NEXT:    sb zero, 12(sp)
; RV32I-NEXT:    sb zero, 11(sp)
; RV32I-NEXT:    sb zero, 10(sp)
; RV32I-NEXT:    sb zero, 9(sp)
; RV32I-NEXT:    sb zero, 8(sp)
; RV32I-NEXT:    sb zero, 7(sp)
; RV32I-NEXT:    sb zero, 6(sp)
; RV32I-NEXT:    sb zero, 5(sp)
; RV32I-NEXT:    sb zero, 4(sp)
; RV32I-NEXT:    sb a0, 35(sp)
; RV32I-NEXT:    sb s2, 34(sp)
; RV32I-NEXT:    sb s1, 33(sp)
; RV32I-NEXT:    sb s0, 32(sp)
; RV32I-NEXT:    sb t6, 31(sp)
; RV32I-NEXT:    sb t5, 30(sp)
; RV32I-NEXT:    sb t4, 29(sp)
; RV32I-NEXT:    sb t3, 28(sp)
; RV32I-NEXT:    sb t2, 27(sp)
; RV32I-NEXT:    sb t1, 26(sp)
; RV32I-NEXT:    sb t0, 25(sp)
; RV32I-NEXT:    sb a7, 24(sp)
; RV32I-NEXT:    sb a6, 23(sp)
; RV32I-NEXT:    sb a5, 22(sp)
; RV32I-NEXT:    sb a4, 21(sp)
; RV32I-NEXT:    sb a3, 20(sp)
; RV32I-NEXT:    andi a1, a1, 15
; RV32I-NEXT:    addi a0, sp, 20
; RV32I-NEXT:    sub a0, a0, a1
; RV32I-NEXT:    lbu a1, 5(a0)
; RV32I-NEXT:    lbu a3, 4(a0)
; RV32I-NEXT:    lbu a4, 7(a0)
; RV32I-NEXT:    lbu a5, 6(a0)
; RV32I-NEXT:    lbu a6, 1(a0)
; RV32I-NEXT:    lbu a7, 0(a0)
; RV32I-NEXT:    lbu t0, 3(a0)
; RV32I-NEXT:    lbu t1, 2(a0)
; RV32I-NEXT:    lbu t2, 13(a0)
; RV32I-NEXT:    lbu t3, 12(a0)
; RV32I-NEXT:    lbu t4, 15(a0)
; RV32I-NEXT:    lbu t5, 14(a0)
; RV32I-NEXT:    lbu t6, 10(a0)
; RV32I-NEXT:    lbu s0, 11(a0)
; RV32I-NEXT:    lbu s1, 8(a0)
; RV32I-NEXT:    lbu a0, 9(a0)
; RV32I-NEXT:    sb t6, 10(a2)
; RV32I-NEXT:    sb s0, 11(a2)
; RV32I-NEXT:    sb s1, 8(a2)
; RV32I-NEXT:    sb a0, 9(a2)
; RV32I-NEXT:    sb t5, 14(a2)
; RV32I-NEXT:    sb t4, 15(a2)
; RV32I-NEXT:    sb t3, 12(a2)
; RV32I-NEXT:    sb t2, 13(a2)
; RV32I-NEXT:    sb t1, 2(a2)
; RV32I-NEXT:    sb t0, 3(a2)
; RV32I-NEXT:    sb a7, 0(a2)
; RV32I-NEXT:    sb a6, 1(a2)
; RV32I-NEXT:    sb a5, 6(a2)
; RV32I-NEXT:    sb a4, 7(a2)
; RV32I-NEXT:    sb a3, 4(a2)
; RV32I-NEXT:    sb a1, 5(a2)
; RV32I-NEXT:    lw s0, 44(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 40(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 36(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 48
; RV32I-NEXT:    ret
  %src = load i128, ptr %src.ptr, align 1
  %byteOff = load i128, ptr %byteOff.ptr, align 1
  %bitOff = shl i128 %byteOff, 3
  %res = shl i128 %src, %bitOff
  store i128 %res, ptr %dst, align 1
  ret void
}
define void @ashr_16bytes(ptr %src.ptr, ptr %byteOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: ashr_16bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lbu a3, 9(a0)
; RV64I-NEXT:    lbu a4, 8(a0)
; RV64I-NEXT:    lbu a5, 10(a0)
; RV64I-NEXT:    lbu a6, 11(a0)
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    slli a5, a5, 16
; RV64I-NEXT:    slli a6, a6, 24
; RV64I-NEXT:    or a4, a6, a5
; RV64I-NEXT:    or a3, a4, a3
; RV64I-NEXT:    lbu a4, 13(a0)
; RV64I-NEXT:    lbu a5, 12(a0)
; RV64I-NEXT:    lbu a6, 14(a0)
; RV64I-NEXT:    lbu a7, 15(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a5
; RV64I-NEXT:    slli a6, a6, 16
; RV64I-NEXT:    slli a7, a7, 24
; RV64I-NEXT:    or a5, a7, a6
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    slli a5, a4, 32
; RV64I-NEXT:    or a3, a5, a3
; RV64I-NEXT:    lbu a5, 5(a1)
; RV64I-NEXT:    lbu a6, 4(a1)
; RV64I-NEXT:    lbu a7, 6(a1)
; RV64I-NEXT:    lbu t0, 7(a1)
; RV64I-NEXT:    slli a5, a5, 8
; RV64I-NEXT:    or a5, a5, a6
; RV64I-NEXT:    slli a7, a7, 16
; RV64I-NEXT:    slli t0, t0, 24
; RV64I-NEXT:    or a6, t0, a7
; RV64I-NEXT:    or a5, a6, a5
; RV64I-NEXT:    lbu a6, 1(a1)
; RV64I-NEXT:    lbu a7, 0(a1)
; RV64I-NEXT:    lbu t0, 2(a1)
; RV64I-NEXT:    lbu a1, 3(a1)
; RV64I-NEXT:    slli a6, a6, 8
; RV64I-NEXT:    or a6, a6, a7
; RV64I-NEXT:    slli t0, t0, 16
; RV64I-NEXT:    slli a1, a1, 24
; RV64I-NEXT:    or a1, a1, t0
; RV64I-NEXT:    or a1, a1, a6
; RV64I-NEXT:    slli a1, a1, 3
; RV64I-NEXT:    slli a5, a5, 35
; RV64I-NEXT:    or a5, a5, a1
; RV64I-NEXT:    addi a6, a5, -64
; RV64I-NEXT:    sra a1, a3, a5
; RV64I-NEXT:    bltz a6, .LBB8_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    sraiw a3, a4, 31
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:    mv a1, a3
; RV64I-NEXT:    j .LBB8_3
; RV64I-NEXT:  .LBB8_2:
; RV64I-NEXT:    lbu a4, 1(a0)
; RV64I-NEXT:    lbu a6, 0(a0)
; RV64I-NEXT:    lbu a7, 2(a0)
; RV64I-NEXT:    lbu t0, 3(a0)
; RV64I-NEXT:    slli a4, a4, 8
; RV64I-NEXT:    or a4, a4, a6
; RV64I-NEXT:    slli a7, a7, 16
; RV64I-NEXT:    slli t0, t0, 24
; RV64I-NEXT:    or a6, t0, a7
; RV64I-NEXT:    or a4, a6, a4
; RV64I-NEXT:    lbu a6, 5(a0)
; RV64I-NEXT:    lbu a7, 4(a0)
; RV64I-NEXT:    lbu t0, 6(a0)
; RV64I-NEXT:    lbu a0, 7(a0)
; RV64I-NEXT:    slli a6, a6, 8
; RV64I-NEXT:    or a6, a6, a7
; RV64I-NEXT:    slli t0, t0, 16
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, t0
; RV64I-NEXT:    or a0, a0, a6
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    or a0, a0, a4
; RV64I-NEXT:    srl a0, a0, a5
; RV64I-NEXT:    not a4, a5
; RV64I-NEXT:    slli a3, a3, 1
; RV64I-NEXT:    sll a3, a3, a4
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:  .LBB8_3:
; RV64I-NEXT:    sb a1, 8(a2)
; RV64I-NEXT:    srli a3, a1, 56
; RV64I-NEXT:    sb a3, 15(a2)
; RV64I-NEXT:    srli a3, a1, 48
; RV64I-NEXT:    sb a3, 14(a2)
; RV64I-NEXT:    srli a3, a1, 40
; RV64I-NEXT:    sb a3, 13(a2)
; RV64I-NEXT:    srli a3, a1, 32
; RV64I-NEXT:    sb a3, 12(a2)
; RV64I-NEXT:    srli a3, a1, 24
; RV64I-NEXT:    sb a3, 11(a2)
; RV64I-NEXT:    srli a3, a1, 16
; RV64I-NEXT:    sb a3, 10(a2)
; RV64I-NEXT:    srli a1, a1, 8
; RV64I-NEXT:    sb a1, 9(a2)
; RV64I-NEXT:    sb a0, 0(a2)
; RV64I-NEXT:    srli a1, a0, 56
; RV64I-NEXT:    sb a1, 7(a2)
; RV64I-NEXT:    srli a1, a0, 48
; RV64I-NEXT:    sb a1, 6(a2)
; RV64I-NEXT:    srli a1, a0, 40
; RV64I-NEXT:    sb a1, 5(a2)
; RV64I-NEXT:    srli a1, a0, 32
; RV64I-NEXT:    sb a1, 4(a2)
; RV64I-NEXT:    srli a1, a0, 24
; RV64I-NEXT:    sb a1, 3(a2)
; RV64I-NEXT:    srli a1, a0, 16
; RV64I-NEXT:    sb a1, 2(a2)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 1(a2)
; RV64I-NEXT:    ret
;
; RV32I-LABEL: ashr_16bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -48
; RV32I-NEXT:    sw s0, 44(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 40(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 36(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 32(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 15(a0)
; RV32I-NEXT:    slli a4, a3, 24
; RV32I-NEXT:    lbu a5, 0(a0)
; RV32I-NEXT:    lbu a6, 1(a0)
; RV32I-NEXT:    lbu a7, 2(a0)
; RV32I-NEXT:    lbu t0, 3(a0)
; RV32I-NEXT:    lbu t1, 4(a0)
; RV32I-NEXT:    lbu t2, 5(a0)
; RV32I-NEXT:    lbu t3, 6(a0)
; RV32I-NEXT:    lbu t4, 7(a0)
; RV32I-NEXT:    lbu t5, 8(a0)
; RV32I-NEXT:    lbu t6, 9(a0)
; RV32I-NEXT:    lbu s0, 10(a0)
; RV32I-NEXT:    lbu s1, 11(a0)
; RV32I-NEXT:    lbu s2, 12(a0)
; RV32I-NEXT:    lbu s3, 14(a0)
; RV32I-NEXT:    lbu a0, 13(a0)
; RV32I-NEXT:    lbu a1, 0(a1)
; RV32I-NEXT:    sb a3, 15(sp)
; RV32I-NEXT:    sb s3, 14(sp)
; RV32I-NEXT:    sb a0, 13(sp)
; RV32I-NEXT:    sb s2, 12(sp)
; RV32I-NEXT:    sb s1, 11(sp)
; RV32I-NEXT:    sb s0, 10(sp)
; RV32I-NEXT:    sb t6, 9(sp)
; RV32I-NEXT:    sb t5, 8(sp)
; RV32I-NEXT:    sb t4, 7(sp)
; RV32I-NEXT:    sb t3, 6(sp)
; RV32I-NEXT:    sb t2, 5(sp)
; RV32I-NEXT:    sb t1, 4(sp)
; RV32I-NEXT:    sb t0, 3(sp)
; RV32I-NEXT:    sb a7, 2(sp)
; RV32I-NEXT:    sb a6, 1(sp)
; RV32I-NEXT:    sb a5, 0(sp)
; RV32I-NEXT:    srai a4, a4, 31
; RV32I-NEXT:    sb a4, 28(sp)
; RV32I-NEXT:    sb a4, 24(sp)
; RV32I-NEXT:    sb a4, 20(sp)
; RV32I-NEXT:    sb a4, 16(sp)
; RV32I-NEXT:    srli a0, a4, 24
; RV32I-NEXT:    sb a0, 31(sp)
; RV32I-NEXT:    srli a3, a4, 16
; RV32I-NEXT:    sb a3, 30(sp)
; RV32I-NEXT:    srli a4, a4, 8
; RV32I-NEXT:    sb a4, 29(sp)
; RV32I-NEXT:    sb a0, 27(sp)
; RV32I-NEXT:    sb a3, 26(sp)
; RV32I-NEXT:    sb a4, 25(sp)
; RV32I-NEXT:    sb a0, 23(sp)
; RV32I-NEXT:    sb a3, 22(sp)
; RV32I-NEXT:    sb a4, 21(sp)
; RV32I-NEXT:    sb a0, 19(sp)
; RV32I-NEXT:    sb a3, 18(sp)
; RV32I-NEXT:    sb a4, 17(sp)
; RV32I-NEXT:    andi a1, a1, 15
; RV32I-NEXT:    mv a0, sp
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lbu a1, 5(a0)
; RV32I-NEXT:    lbu a3, 4(a0)
; RV32I-NEXT:    lbu a4, 7(a0)
; RV32I-NEXT:    lbu a5, 6(a0)
; RV32I-NEXT:    lbu a6, 1(a0)
; RV32I-NEXT:    lbu a7, 0(a0)
; RV32I-NEXT:    lbu t0, 3(a0)
; RV32I-NEXT:    lbu t1, 2(a0)
; RV32I-NEXT:    lbu t2, 13(a0)
; RV32I-NEXT:    lbu t3, 12(a0)
; RV32I-NEXT:    lbu t4, 15(a0)
; RV32I-NEXT:    lbu t5, 14(a0)
; RV32I-NEXT:    lbu t6, 10(a0)
; RV32I-NEXT:    lbu s0, 11(a0)
; RV32I-NEXT:    lbu s1, 8(a0)
; RV32I-NEXT:    lbu a0, 9(a0)
; RV32I-NEXT:    sb t6, 10(a2)
; RV32I-NEXT:    sb s0, 11(a2)
; RV32I-NEXT:    sb s1, 8(a2)
; RV32I-NEXT:    sb a0, 9(a2)
; RV32I-NEXT:    sb t5, 14(a2)
; RV32I-NEXT:    sb t4, 15(a2)
; RV32I-NEXT:    sb t3, 12(a2)
; RV32I-NEXT:    sb t2, 13(a2)
; RV32I-NEXT:    sb t1, 2(a2)
; RV32I-NEXT:    sb t0, 3(a2)
; RV32I-NEXT:    sb a7, 0(a2)
; RV32I-NEXT:    sb a6, 1(a2)
; RV32I-NEXT:    sb a5, 6(a2)
; RV32I-NEXT:    sb a4, 7(a2)
; RV32I-NEXT:    sb a3, 4(a2)
; RV32I-NEXT:    sb a1, 5(a2)
; RV32I-NEXT:    lw s0, 44(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 40(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 36(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 32(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 48
; RV32I-NEXT:    ret
  %src = load i128, ptr %src.ptr, align 1
  %byteOff = load i128, ptr %byteOff.ptr, align 1
  %bitOff = shl i128 %byteOff, 3
  %res = ashr i128 %src, %bitOff
  store i128 %res, ptr %dst, align 1
  ret void
}

define void @lshr_32bytes(ptr %src.ptr, ptr %byteOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: lshr_32bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -224
; RV64I-NEXT:    sd ra, 216(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 208(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 200(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 192(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 184(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s4, 176(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s5, 168(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s6, 160(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s7, 152(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s8, 144(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s9, 136(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s10, 128(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s11, 120(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    sd a3, 48(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    sd a3, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 2(a0)
; RV64I-NEXT:    sd a3, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 3(a0)
; RV64I-NEXT:    sd a3, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 4(a0)
; RV64I-NEXT:    sd a3, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 5(a0)
; RV64I-NEXT:    sd a3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu t1, 6(a0)
; RV64I-NEXT:    lbu t2, 7(a0)
; RV64I-NEXT:    lbu t3, 8(a0)
; RV64I-NEXT:    lbu t4, 9(a0)
; RV64I-NEXT:    lbu t5, 10(a0)
; RV64I-NEXT:    lbu t6, 11(a0)
; RV64I-NEXT:    lbu s0, 12(a0)
; RV64I-NEXT:    lbu s1, 13(a0)
; RV64I-NEXT:    lbu s2, 14(a0)
; RV64I-NEXT:    lbu s3, 15(a0)
; RV64I-NEXT:    lbu s4, 16(a0)
; RV64I-NEXT:    lbu s5, 17(a0)
; RV64I-NEXT:    lbu s6, 18(a0)
; RV64I-NEXT:    lbu s7, 19(a0)
; RV64I-NEXT:    lbu s8, 20(a0)
; RV64I-NEXT:    lbu s9, 21(a0)
; RV64I-NEXT:    lbu s10, 22(a0)
; RV64I-NEXT:    lbu s11, 23(a0)
; RV64I-NEXT:    lbu ra, 24(a0)
; RV64I-NEXT:    lbu t0, 25(a0)
; RV64I-NEXT:    lbu a7, 26(a0)
; RV64I-NEXT:    lbu a6, 27(a0)
; RV64I-NEXT:    lbu a5, 28(a0)
; RV64I-NEXT:    lbu a3, 31(a0)
; RV64I-NEXT:    lbu a4, 30(a0)
; RV64I-NEXT:    lbu a0, 29(a0)
; RV64I-NEXT:    lbu a1, 0(a1)
; RV64I-NEXT:    sb a3, 87(sp)
; RV64I-NEXT:    sb a4, 86(sp)
; RV64I-NEXT:    sb a0, 85(sp)
; RV64I-NEXT:    sb a5, 84(sp)
; RV64I-NEXT:    sb a6, 83(sp)
; RV64I-NEXT:    sb a7, 82(sp)
; RV64I-NEXT:    sb zero, 119(sp)
; RV64I-NEXT:    sb zero, 118(sp)
; RV64I-NEXT:    sb zero, 117(sp)
; RV64I-NEXT:    sb zero, 116(sp)
; RV64I-NEXT:    sb zero, 115(sp)
; RV64I-NEXT:    sb zero, 114(sp)
; RV64I-NEXT:    sb zero, 113(sp)
; RV64I-NEXT:    sb zero, 112(sp)
; RV64I-NEXT:    sb zero, 111(sp)
; RV64I-NEXT:    sb zero, 110(sp)
; RV64I-NEXT:    sb zero, 109(sp)
; RV64I-NEXT:    sb zero, 108(sp)
; RV64I-NEXT:    sb zero, 107(sp)
; RV64I-NEXT:    sb zero, 106(sp)
; RV64I-NEXT:    sb zero, 105(sp)
; RV64I-NEXT:    sb zero, 104(sp)
; RV64I-NEXT:    sb zero, 103(sp)
; RV64I-NEXT:    sb zero, 102(sp)
; RV64I-NEXT:    sb zero, 101(sp)
; RV64I-NEXT:    sb zero, 100(sp)
; RV64I-NEXT:    sb zero, 99(sp)
; RV64I-NEXT:    sb zero, 98(sp)
; RV64I-NEXT:    sb zero, 97(sp)
; RV64I-NEXT:    sb zero, 96(sp)
; RV64I-NEXT:    sb zero, 95(sp)
; RV64I-NEXT:    sb zero, 94(sp)
; RV64I-NEXT:    sb zero, 93(sp)
; RV64I-NEXT:    sb zero, 92(sp)
; RV64I-NEXT:    sb zero, 91(sp)
; RV64I-NEXT:    sb zero, 90(sp)
; RV64I-NEXT:    sb zero, 89(sp)
; RV64I-NEXT:    sb zero, 88(sp)
; RV64I-NEXT:    sb t0, 81(sp)
; RV64I-NEXT:    sb ra, 80(sp)
; RV64I-NEXT:    sb s11, 79(sp)
; RV64I-NEXT:    sb s10, 78(sp)
; RV64I-NEXT:    sb s9, 77(sp)
; RV64I-NEXT:    sb s8, 76(sp)
; RV64I-NEXT:    sb s7, 75(sp)
; RV64I-NEXT:    sb s6, 74(sp)
; RV64I-NEXT:    sb s5, 73(sp)
; RV64I-NEXT:    sb s4, 72(sp)
; RV64I-NEXT:    sb s3, 71(sp)
; RV64I-NEXT:    sb s2, 70(sp)
; RV64I-NEXT:    sb s1, 69(sp)
; RV64I-NEXT:    sb s0, 68(sp)
; RV64I-NEXT:    sb t6, 67(sp)
; RV64I-NEXT:    sb t5, 66(sp)
; RV64I-NEXT:    sb t4, 65(sp)
; RV64I-NEXT:    sb t3, 64(sp)
; RV64I-NEXT:    sb t2, 63(sp)
; RV64I-NEXT:    sb t1, 62(sp)
; RV64I-NEXT:    ld a0, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 61(sp)
; RV64I-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 60(sp)
; RV64I-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 59(sp)
; RV64I-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 58(sp)
; RV64I-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 57(sp)
; RV64I-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 56(sp)
; RV64I-NEXT:    andi a1, a1, 31
; RV64I-NEXT:    addi a0, sp, 56
; RV64I-NEXT:    add a6, a0, a1
; RV64I-NEXT:    lbu a0, 8(a6)
; RV64I-NEXT:    sd a0, 48(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a0, 9(a6)
; RV64I-NEXT:    sd a0, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a0, 10(a6)
; RV64I-NEXT:    sd a0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a0, 11(a6)
; RV64I-NEXT:    sd a0, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a0, 12(a6)
; RV64I-NEXT:    sd a0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a7, 13(a6)
; RV64I-NEXT:    lbu t0, 14(a6)
; RV64I-NEXT:    lbu t1, 15(a6)
; RV64I-NEXT:    lbu t2, 0(a6)
; RV64I-NEXT:    lbu t3, 1(a6)
; RV64I-NEXT:    lbu t4, 2(a6)
; RV64I-NEXT:    lbu t5, 3(a6)
; RV64I-NEXT:    lbu t6, 4(a6)
; RV64I-NEXT:    lbu s0, 5(a6)
; RV64I-NEXT:    lbu s1, 6(a6)
; RV64I-NEXT:    lbu s2, 7(a6)
; RV64I-NEXT:    lbu s3, 24(a6)
; RV64I-NEXT:    lbu s4, 25(a6)
; RV64I-NEXT:    lbu s5, 26(a6)
; RV64I-NEXT:    lbu s6, 27(a6)
; RV64I-NEXT:    lbu s7, 28(a6)
; RV64I-NEXT:    lbu s8, 29(a6)
; RV64I-NEXT:    lbu s9, 30(a6)
; RV64I-NEXT:    lbu s10, 31(a6)
; RV64I-NEXT:    lbu s11, 16(a6)
; RV64I-NEXT:    lbu ra, 17(a6)
; RV64I-NEXT:    lbu a5, 18(a6)
; RV64I-NEXT:    lbu a4, 19(a6)
; RV64I-NEXT:    lbu a0, 23(a6)
; RV64I-NEXT:    lbu a1, 22(a6)
; RV64I-NEXT:    lbu a3, 21(a6)
; RV64I-NEXT:    lbu a6, 20(a6)
; RV64I-NEXT:    sb a0, 23(a2)
; RV64I-NEXT:    sb a1, 22(a2)
; RV64I-NEXT:    sb a3, 21(a2)
; RV64I-NEXT:    sb a6, 20(a2)
; RV64I-NEXT:    sb a4, 19(a2)
; RV64I-NEXT:    sb a5, 18(a2)
; RV64I-NEXT:    sb ra, 17(a2)
; RV64I-NEXT:    sb s11, 16(a2)
; RV64I-NEXT:    sb s10, 31(a2)
; RV64I-NEXT:    sb s9, 30(a2)
; RV64I-NEXT:    sb s8, 29(a2)
; RV64I-NEXT:    sb s7, 28(a2)
; RV64I-NEXT:    sb s6, 27(a2)
; RV64I-NEXT:    sb s5, 26(a2)
; RV64I-NEXT:    sb s4, 25(a2)
; RV64I-NEXT:    sb s3, 24(a2)
; RV64I-NEXT:    sb s2, 7(a2)
; RV64I-NEXT:    sb s1, 6(a2)
; RV64I-NEXT:    sb s0, 5(a2)
; RV64I-NEXT:    sb t6, 4(a2)
; RV64I-NEXT:    sb t5, 3(a2)
; RV64I-NEXT:    sb t4, 2(a2)
; RV64I-NEXT:    sb t3, 1(a2)
; RV64I-NEXT:    sb t2, 0(a2)
; RV64I-NEXT:    sb t1, 15(a2)
; RV64I-NEXT:    sb t0, 14(a2)
; RV64I-NEXT:    sb a7, 13(a2)
; RV64I-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 12(a2)
; RV64I-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 11(a2)
; RV64I-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 10(a2)
; RV64I-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 9(a2)
; RV64I-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 8(a2)
; RV64I-NEXT:    ld ra, 216(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 208(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 200(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 192(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 184(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s4, 176(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s5, 168(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s6, 160(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s7, 152(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s8, 144(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s9, 136(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s10, 128(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s11, 120(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 224
; RV64I-NEXT:    ret
;
; RV32I-LABEL: lshr_32bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -144
; RV32I-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 136(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 132(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 128(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 124(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 120(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 116(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s6, 112(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s7, 108(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s8, 104(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s9, 100(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s10, 96(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s11, 92(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    sw a3, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 1(a0)
; RV32I-NEXT:    sw a3, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 2(a0)
; RV32I-NEXT:    sw a3, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 3(a0)
; RV32I-NEXT:    sw a3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 4(a0)
; RV32I-NEXT:    sw a3, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 5(a0)
; RV32I-NEXT:    sw a3, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu t1, 6(a0)
; RV32I-NEXT:    lbu t2, 7(a0)
; RV32I-NEXT:    lbu t3, 8(a0)
; RV32I-NEXT:    lbu t4, 9(a0)
; RV32I-NEXT:    lbu t5, 10(a0)
; RV32I-NEXT:    lbu t6, 11(a0)
; RV32I-NEXT:    lbu s0, 12(a0)
; RV32I-NEXT:    lbu s1, 13(a0)
; RV32I-NEXT:    lbu s2, 14(a0)
; RV32I-NEXT:    lbu s3, 15(a0)
; RV32I-NEXT:    lbu s4, 16(a0)
; RV32I-NEXT:    lbu s5, 17(a0)
; RV32I-NEXT:    lbu s6, 18(a0)
; RV32I-NEXT:    lbu s7, 19(a0)
; RV32I-NEXT:    lbu s8, 20(a0)
; RV32I-NEXT:    lbu s9, 21(a0)
; RV32I-NEXT:    lbu s10, 22(a0)
; RV32I-NEXT:    lbu s11, 23(a0)
; RV32I-NEXT:    lbu ra, 24(a0)
; RV32I-NEXT:    lbu t0, 25(a0)
; RV32I-NEXT:    lbu a7, 26(a0)
; RV32I-NEXT:    lbu a6, 27(a0)
; RV32I-NEXT:    lbu a5, 28(a0)
; RV32I-NEXT:    lbu a3, 31(a0)
; RV32I-NEXT:    lbu a4, 30(a0)
; RV32I-NEXT:    lbu a0, 29(a0)
; RV32I-NEXT:    lbu a1, 0(a1)
; RV32I-NEXT:    sb a3, 59(sp)
; RV32I-NEXT:    sb a4, 58(sp)
; RV32I-NEXT:    sb a0, 57(sp)
; RV32I-NEXT:    sb a5, 56(sp)
; RV32I-NEXT:    sb a6, 55(sp)
; RV32I-NEXT:    sb a7, 54(sp)
; RV32I-NEXT:    sb zero, 91(sp)
; RV32I-NEXT:    sb zero, 90(sp)
; RV32I-NEXT:    sb zero, 89(sp)
; RV32I-NEXT:    sb zero, 88(sp)
; RV32I-NEXT:    sb zero, 87(sp)
; RV32I-NEXT:    sb zero, 86(sp)
; RV32I-NEXT:    sb zero, 85(sp)
; RV32I-NEXT:    sb zero, 84(sp)
; RV32I-NEXT:    sb zero, 83(sp)
; RV32I-NEXT:    sb zero, 82(sp)
; RV32I-NEXT:    sb zero, 81(sp)
; RV32I-NEXT:    sb zero, 80(sp)
; RV32I-NEXT:    sb zero, 79(sp)
; RV32I-NEXT:    sb zero, 78(sp)
; RV32I-NEXT:    sb zero, 77(sp)
; RV32I-NEXT:    sb zero, 76(sp)
; RV32I-NEXT:    sb zero, 75(sp)
; RV32I-NEXT:    sb zero, 74(sp)
; RV32I-NEXT:    sb zero, 73(sp)
; RV32I-NEXT:    sb zero, 72(sp)
; RV32I-NEXT:    sb zero, 71(sp)
; RV32I-NEXT:    sb zero, 70(sp)
; RV32I-NEXT:    sb zero, 69(sp)
; RV32I-NEXT:    sb zero, 68(sp)
; RV32I-NEXT:    sb zero, 67(sp)
; RV32I-NEXT:    sb zero, 66(sp)
; RV32I-NEXT:    sb zero, 65(sp)
; RV32I-NEXT:    sb zero, 64(sp)
; RV32I-NEXT:    sb zero, 63(sp)
; RV32I-NEXT:    sb zero, 62(sp)
; RV32I-NEXT:    sb zero, 61(sp)
; RV32I-NEXT:    sb zero, 60(sp)
; RV32I-NEXT:    sb t0, 53(sp)
; RV32I-NEXT:    sb ra, 52(sp)
; RV32I-NEXT:    sb s11, 51(sp)
; RV32I-NEXT:    sb s10, 50(sp)
; RV32I-NEXT:    sb s9, 49(sp)
; RV32I-NEXT:    sb s8, 48(sp)
; RV32I-NEXT:    sb s7, 47(sp)
; RV32I-NEXT:    sb s6, 46(sp)
; RV32I-NEXT:    sb s5, 45(sp)
; RV32I-NEXT:    sb s4, 44(sp)
; RV32I-NEXT:    sb s3, 43(sp)
; RV32I-NEXT:    sb s2, 42(sp)
; RV32I-NEXT:    sb s1, 41(sp)
; RV32I-NEXT:    sb s0, 40(sp)
; RV32I-NEXT:    sb t6, 39(sp)
; RV32I-NEXT:    sb t5, 38(sp)
; RV32I-NEXT:    sb t4, 37(sp)
; RV32I-NEXT:    sb t3, 36(sp)
; RV32I-NEXT:    sb t2, 35(sp)
; RV32I-NEXT:    sb t1, 34(sp)
; RV32I-NEXT:    lw a0, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 33(sp)
; RV32I-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 32(sp)
; RV32I-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 31(sp)
; RV32I-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 30(sp)
; RV32I-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 29(sp)
; RV32I-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 28(sp)
; RV32I-NEXT:    andi a1, a1, 31
; RV32I-NEXT:    addi a0, sp, 28
; RV32I-NEXT:    add a6, a0, a1
; RV32I-NEXT:    lbu a0, 6(a6)
; RV32I-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a0, 7(a6)
; RV32I-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a0, 4(a6)
; RV32I-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a0, 5(a6)
; RV32I-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a0, 0(a6)
; RV32I-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a7, 1(a6)
; RV32I-NEXT:    lbu t0, 2(a6)
; RV32I-NEXT:    lbu t1, 3(a6)
; RV32I-NEXT:    lbu t2, 14(a6)
; RV32I-NEXT:    lbu t3, 15(a6)
; RV32I-NEXT:    lbu t4, 12(a6)
; RV32I-NEXT:    lbu t5, 13(a6)
; RV32I-NEXT:    lbu t6, 10(a6)
; RV32I-NEXT:    lbu s0, 11(a6)
; RV32I-NEXT:    lbu s1, 8(a6)
; RV32I-NEXT:    lbu s2, 9(a6)
; RV32I-NEXT:    lbu s3, 22(a6)
; RV32I-NEXT:    lbu s4, 23(a6)
; RV32I-NEXT:    lbu s5, 20(a6)
; RV32I-NEXT:    lbu s6, 21(a6)
; RV32I-NEXT:    lbu s7, 18(a6)
; RV32I-NEXT:    lbu s8, 19(a6)
; RV32I-NEXT:    lbu s9, 16(a6)
; RV32I-NEXT:    lbu s10, 17(a6)
; RV32I-NEXT:    lbu s11, 30(a6)
; RV32I-NEXT:    lbu ra, 31(a6)
; RV32I-NEXT:    lbu a5, 28(a6)
; RV32I-NEXT:    lbu a4, 29(a6)
; RV32I-NEXT:    lbu a0, 25(a6)
; RV32I-NEXT:    lbu a1, 24(a6)
; RV32I-NEXT:    lbu a3, 27(a6)
; RV32I-NEXT:    lbu a6, 26(a6)
; RV32I-NEXT:    sb a0, 25(a2)
; RV32I-NEXT:    sb a1, 24(a2)
; RV32I-NEXT:    sb a3, 27(a2)
; RV32I-NEXT:    sb a6, 26(a2)
; RV32I-NEXT:    sb a4, 29(a2)
; RV32I-NEXT:    sb a5, 28(a2)
; RV32I-NEXT:    sb ra, 31(a2)
; RV32I-NEXT:    sb s11, 30(a2)
; RV32I-NEXT:    sb s10, 17(a2)
; RV32I-NEXT:    sb s9, 16(a2)
; RV32I-NEXT:    sb s8, 19(a2)
; RV32I-NEXT:    sb s7, 18(a2)
; RV32I-NEXT:    sb s6, 21(a2)
; RV32I-NEXT:    sb s5, 20(a2)
; RV32I-NEXT:    sb s4, 23(a2)
; RV32I-NEXT:    sb s3, 22(a2)
; RV32I-NEXT:    sb s2, 9(a2)
; RV32I-NEXT:    sb s1, 8(a2)
; RV32I-NEXT:    sb s0, 11(a2)
; RV32I-NEXT:    sb t6, 10(a2)
; RV32I-NEXT:    sb t5, 13(a2)
; RV32I-NEXT:    sb t4, 12(a2)
; RV32I-NEXT:    sb t3, 15(a2)
; RV32I-NEXT:    sb t2, 14(a2)
; RV32I-NEXT:    sb t1, 3(a2)
; RV32I-NEXT:    sb t0, 2(a2)
; RV32I-NEXT:    sb a7, 1(a2)
; RV32I-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 0(a2)
; RV32I-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 5(a2)
; RV32I-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 4(a2)
; RV32I-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 7(a2)
; RV32I-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 6(a2)
; RV32I-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 136(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 132(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 128(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 124(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 120(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 116(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s6, 112(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s7, 108(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s8, 104(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s9, 100(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s10, 96(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s11, 92(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 144
; RV32I-NEXT:    ret
  %src = load i256, ptr %src.ptr, align 1
  %byteOff = load i256, ptr %byteOff.ptr, align 1
  %bitOff = shl i256 %byteOff, 3
  %res = lshr i256 %src, %bitOff
  store i256 %res, ptr %dst, align 1
  ret void
}
define void @shl_32bytes(ptr %src.ptr, ptr %byteOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: shl_32bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -224
; RV64I-NEXT:    sd ra, 216(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 208(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 200(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 192(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 184(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s4, 176(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s5, 168(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s6, 160(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s7, 152(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s8, 144(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s9, 136(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s10, 128(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s11, 120(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 0(a0)
; RV64I-NEXT:    sd a3, 48(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 1(a0)
; RV64I-NEXT:    sd a3, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 2(a0)
; RV64I-NEXT:    sd a3, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 3(a0)
; RV64I-NEXT:    sd a3, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 4(a0)
; RV64I-NEXT:    sd a3, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a3, 5(a0)
; RV64I-NEXT:    sd a3, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu t1, 6(a0)
; RV64I-NEXT:    lbu t2, 7(a0)
; RV64I-NEXT:    lbu t3, 8(a0)
; RV64I-NEXT:    lbu t4, 9(a0)
; RV64I-NEXT:    lbu t5, 10(a0)
; RV64I-NEXT:    lbu t6, 11(a0)
; RV64I-NEXT:    lbu s0, 12(a0)
; RV64I-NEXT:    lbu s1, 13(a0)
; RV64I-NEXT:    lbu s2, 14(a0)
; RV64I-NEXT:    lbu s3, 15(a0)
; RV64I-NEXT:    lbu s4, 16(a0)
; RV64I-NEXT:    lbu s5, 17(a0)
; RV64I-NEXT:    lbu s6, 18(a0)
; RV64I-NEXT:    lbu s7, 19(a0)
; RV64I-NEXT:    lbu s8, 20(a0)
; RV64I-NEXT:    lbu s9, 21(a0)
; RV64I-NEXT:    lbu s10, 22(a0)
; RV64I-NEXT:    lbu s11, 23(a0)
; RV64I-NEXT:    lbu ra, 24(a0)
; RV64I-NEXT:    lbu t0, 25(a0)
; RV64I-NEXT:    lbu a7, 26(a0)
; RV64I-NEXT:    lbu a6, 27(a0)
; RV64I-NEXT:    lbu a5, 28(a0)
; RV64I-NEXT:    lbu a3, 31(a0)
; RV64I-NEXT:    lbu a4, 30(a0)
; RV64I-NEXT:    lbu a0, 29(a0)
; RV64I-NEXT:    lbu a1, 0(a1)
; RV64I-NEXT:    sb a3, 119(sp)
; RV64I-NEXT:    sb a4, 118(sp)
; RV64I-NEXT:    sb a0, 117(sp)
; RV64I-NEXT:    sb a5, 116(sp)
; RV64I-NEXT:    sb a6, 115(sp)
; RV64I-NEXT:    sb a7, 114(sp)
; RV64I-NEXT:    sb zero, 87(sp)
; RV64I-NEXT:    sb zero, 86(sp)
; RV64I-NEXT:    sb zero, 85(sp)
; RV64I-NEXT:    sb zero, 84(sp)
; RV64I-NEXT:    sb zero, 83(sp)
; RV64I-NEXT:    sb zero, 82(sp)
; RV64I-NEXT:    sb zero, 81(sp)
; RV64I-NEXT:    sb zero, 80(sp)
; RV64I-NEXT:    sb zero, 79(sp)
; RV64I-NEXT:    sb zero, 78(sp)
; RV64I-NEXT:    sb zero, 77(sp)
; RV64I-NEXT:    sb zero, 76(sp)
; RV64I-NEXT:    sb zero, 75(sp)
; RV64I-NEXT:    sb zero, 74(sp)
; RV64I-NEXT:    sb zero, 73(sp)
; RV64I-NEXT:    sb zero, 72(sp)
; RV64I-NEXT:    sb zero, 71(sp)
; RV64I-NEXT:    sb zero, 70(sp)
; RV64I-NEXT:    sb zero, 69(sp)
; RV64I-NEXT:    sb zero, 68(sp)
; RV64I-NEXT:    sb zero, 67(sp)
; RV64I-NEXT:    sb zero, 66(sp)
; RV64I-NEXT:    sb zero, 65(sp)
; RV64I-NEXT:    sb zero, 64(sp)
; RV64I-NEXT:    sb zero, 63(sp)
; RV64I-NEXT:    sb zero, 62(sp)
; RV64I-NEXT:    sb zero, 61(sp)
; RV64I-NEXT:    sb zero, 60(sp)
; RV64I-NEXT:    sb zero, 59(sp)
; RV64I-NEXT:    sb zero, 58(sp)
; RV64I-NEXT:    sb zero, 57(sp)
; RV64I-NEXT:    sb zero, 56(sp)
; RV64I-NEXT:    sb t0, 113(sp)
; RV64I-NEXT:    sb ra, 112(sp)
; RV64I-NEXT:    sb s11, 111(sp)
; RV64I-NEXT:    sb s10, 110(sp)
; RV64I-NEXT:    sb s9, 109(sp)
; RV64I-NEXT:    sb s8, 108(sp)
; RV64I-NEXT:    sb s7, 107(sp)
; RV64I-NEXT:    sb s6, 106(sp)
; RV64I-NEXT:    sb s5, 105(sp)
; RV64I-NEXT:    sb s4, 104(sp)
; RV64I-NEXT:    sb s3, 103(sp)
; RV64I-NEXT:    sb s2, 102(sp)
; RV64I-NEXT:    sb s1, 101(sp)
; RV64I-NEXT:    sb s0, 100(sp)
; RV64I-NEXT:    sb t6, 99(sp)
; RV64I-NEXT:    sb t5, 98(sp)
; RV64I-NEXT:    sb t4, 97(sp)
; RV64I-NEXT:    sb t3, 96(sp)
; RV64I-NEXT:    sb t2, 95(sp)
; RV64I-NEXT:    sb t1, 94(sp)
; RV64I-NEXT:    ld a0, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 93(sp)
; RV64I-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 92(sp)
; RV64I-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 91(sp)
; RV64I-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 90(sp)
; RV64I-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 89(sp)
; RV64I-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 88(sp)
; RV64I-NEXT:    andi a1, a1, 31
; RV64I-NEXT:    addi a0, sp, 88
; RV64I-NEXT:    sub a6, a0, a1
; RV64I-NEXT:    lbu a0, 8(a6)
; RV64I-NEXT:    sd a0, 48(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a0, 9(a6)
; RV64I-NEXT:    sd a0, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a0, 10(a6)
; RV64I-NEXT:    sd a0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a0, 11(a6)
; RV64I-NEXT:    sd a0, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a0, 12(a6)
; RV64I-NEXT:    sd a0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a7, 13(a6)
; RV64I-NEXT:    lbu t0, 14(a6)
; RV64I-NEXT:    lbu t1, 15(a6)
; RV64I-NEXT:    lbu t2, 0(a6)
; RV64I-NEXT:    lbu t3, 1(a6)
; RV64I-NEXT:    lbu t4, 2(a6)
; RV64I-NEXT:    lbu t5, 3(a6)
; RV64I-NEXT:    lbu t6, 4(a6)
; RV64I-NEXT:    lbu s0, 5(a6)
; RV64I-NEXT:    lbu s1, 6(a6)
; RV64I-NEXT:    lbu s2, 7(a6)
; RV64I-NEXT:    lbu s3, 24(a6)
; RV64I-NEXT:    lbu s4, 25(a6)
; RV64I-NEXT:    lbu s5, 26(a6)
; RV64I-NEXT:    lbu s6, 27(a6)
; RV64I-NEXT:    lbu s7, 28(a6)
; RV64I-NEXT:    lbu s8, 29(a6)
; RV64I-NEXT:    lbu s9, 30(a6)
; RV64I-NEXT:    lbu s10, 31(a6)
; RV64I-NEXT:    lbu s11, 16(a6)
; RV64I-NEXT:    lbu ra, 17(a6)
; RV64I-NEXT:    lbu a5, 18(a6)
; RV64I-NEXT:    lbu a4, 19(a6)
; RV64I-NEXT:    lbu a0, 23(a6)
; RV64I-NEXT:    lbu a1, 22(a6)
; RV64I-NEXT:    lbu a3, 21(a6)
; RV64I-NEXT:    lbu a6, 20(a6)
; RV64I-NEXT:    sb a0, 23(a2)
; RV64I-NEXT:    sb a1, 22(a2)
; RV64I-NEXT:    sb a3, 21(a2)
; RV64I-NEXT:    sb a6, 20(a2)
; RV64I-NEXT:    sb a4, 19(a2)
; RV64I-NEXT:    sb a5, 18(a2)
; RV64I-NEXT:    sb ra, 17(a2)
; RV64I-NEXT:    sb s11, 16(a2)
; RV64I-NEXT:    sb s10, 31(a2)
; RV64I-NEXT:    sb s9, 30(a2)
; RV64I-NEXT:    sb s8, 29(a2)
; RV64I-NEXT:    sb s7, 28(a2)
; RV64I-NEXT:    sb s6, 27(a2)
; RV64I-NEXT:    sb s5, 26(a2)
; RV64I-NEXT:    sb s4, 25(a2)
; RV64I-NEXT:    sb s3, 24(a2)
; RV64I-NEXT:    sb s2, 7(a2)
; RV64I-NEXT:    sb s1, 6(a2)
; RV64I-NEXT:    sb s0, 5(a2)
; RV64I-NEXT:    sb t6, 4(a2)
; RV64I-NEXT:    sb t5, 3(a2)
; RV64I-NEXT:    sb t4, 2(a2)
; RV64I-NEXT:    sb t3, 1(a2)
; RV64I-NEXT:    sb t2, 0(a2)
; RV64I-NEXT:    sb t1, 15(a2)
; RV64I-NEXT:    sb t0, 14(a2)
; RV64I-NEXT:    sb a7, 13(a2)
; RV64I-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 12(a2)
; RV64I-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 11(a2)
; RV64I-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 10(a2)
; RV64I-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 9(a2)
; RV64I-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 8(a2)
; RV64I-NEXT:    ld ra, 216(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 208(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 200(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 192(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 184(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s4, 176(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s5, 168(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s6, 160(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s7, 152(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s8, 144(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s9, 136(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s10, 128(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s11, 120(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 224
; RV64I-NEXT:    ret
;
; RV32I-LABEL: shl_32bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -144
; RV32I-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 136(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 132(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 128(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 124(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 120(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 116(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s6, 112(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s7, 108(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s8, 104(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s9, 100(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s10, 96(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s11, 92(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 0(a0)
; RV32I-NEXT:    sw a3, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 1(a0)
; RV32I-NEXT:    sw a3, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 2(a0)
; RV32I-NEXT:    sw a3, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 3(a0)
; RV32I-NEXT:    sw a3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 4(a0)
; RV32I-NEXT:    sw a3, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a3, 5(a0)
; RV32I-NEXT:    sw a3, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu t1, 6(a0)
; RV32I-NEXT:    lbu t2, 7(a0)
; RV32I-NEXT:    lbu t3, 8(a0)
; RV32I-NEXT:    lbu t4, 9(a0)
; RV32I-NEXT:    lbu t5, 10(a0)
; RV32I-NEXT:    lbu t6, 11(a0)
; RV32I-NEXT:    lbu s0, 12(a0)
; RV32I-NEXT:    lbu s1, 13(a0)
; RV32I-NEXT:    lbu s2, 14(a0)
; RV32I-NEXT:    lbu s3, 15(a0)
; RV32I-NEXT:    lbu s4, 16(a0)
; RV32I-NEXT:    lbu s5, 17(a0)
; RV32I-NEXT:    lbu s6, 18(a0)
; RV32I-NEXT:    lbu s7, 19(a0)
; RV32I-NEXT:    lbu s8, 20(a0)
; RV32I-NEXT:    lbu s9, 21(a0)
; RV32I-NEXT:    lbu s10, 22(a0)
; RV32I-NEXT:    lbu s11, 23(a0)
; RV32I-NEXT:    lbu ra, 24(a0)
; RV32I-NEXT:    lbu t0, 25(a0)
; RV32I-NEXT:    lbu a7, 26(a0)
; RV32I-NEXT:    lbu a6, 27(a0)
; RV32I-NEXT:    lbu a5, 28(a0)
; RV32I-NEXT:    lbu a3, 31(a0)
; RV32I-NEXT:    lbu a4, 30(a0)
; RV32I-NEXT:    lbu a0, 29(a0)
; RV32I-NEXT:    lbu a1, 0(a1)
; RV32I-NEXT:    sb a3, 91(sp)
; RV32I-NEXT:    sb a4, 90(sp)
; RV32I-NEXT:    sb a0, 89(sp)
; RV32I-NEXT:    sb a5, 88(sp)
; RV32I-NEXT:    sb a6, 87(sp)
; RV32I-NEXT:    sb a7, 86(sp)
; RV32I-NEXT:    sb zero, 59(sp)
; RV32I-NEXT:    sb zero, 58(sp)
; RV32I-NEXT:    sb zero, 57(sp)
; RV32I-NEXT:    sb zero, 56(sp)
; RV32I-NEXT:    sb zero, 55(sp)
; RV32I-NEXT:    sb zero, 54(sp)
; RV32I-NEXT:    sb zero, 53(sp)
; RV32I-NEXT:    sb zero, 52(sp)
; RV32I-NEXT:    sb zero, 51(sp)
; RV32I-NEXT:    sb zero, 50(sp)
; RV32I-NEXT:    sb zero, 49(sp)
; RV32I-NEXT:    sb zero, 48(sp)
; RV32I-NEXT:    sb zero, 47(sp)
; RV32I-NEXT:    sb zero, 46(sp)
; RV32I-NEXT:    sb zero, 45(sp)
; RV32I-NEXT:    sb zero, 44(sp)
; RV32I-NEXT:    sb zero, 43(sp)
; RV32I-NEXT:    sb zero, 42(sp)
; RV32I-NEXT:    sb zero, 41(sp)
; RV32I-NEXT:    sb zero, 40(sp)
; RV32I-NEXT:    sb zero, 39(sp)
; RV32I-NEXT:    sb zero, 38(sp)
; RV32I-NEXT:    sb zero, 37(sp)
; RV32I-NEXT:    sb zero, 36(sp)
; RV32I-NEXT:    sb zero, 35(sp)
; RV32I-NEXT:    sb zero, 34(sp)
; RV32I-NEXT:    sb zero, 33(sp)
; RV32I-NEXT:    sb zero, 32(sp)
; RV32I-NEXT:    sb zero, 31(sp)
; RV32I-NEXT:    sb zero, 30(sp)
; RV32I-NEXT:    sb zero, 29(sp)
; RV32I-NEXT:    sb zero, 28(sp)
; RV32I-NEXT:    sb t0, 85(sp)
; RV32I-NEXT:    sb ra, 84(sp)
; RV32I-NEXT:    sb s11, 83(sp)
; RV32I-NEXT:    sb s10, 82(sp)
; RV32I-NEXT:    sb s9, 81(sp)
; RV32I-NEXT:    sb s8, 80(sp)
; RV32I-NEXT:    sb s7, 79(sp)
; RV32I-NEXT:    sb s6, 78(sp)
; RV32I-NEXT:    sb s5, 77(sp)
; RV32I-NEXT:    sb s4, 76(sp)
; RV32I-NEXT:    sb s3, 75(sp)
; RV32I-NEXT:    sb s2, 74(sp)
; RV32I-NEXT:    sb s1, 73(sp)
; RV32I-NEXT:    sb s0, 72(sp)
; RV32I-NEXT:    sb t6, 71(sp)
; RV32I-NEXT:    sb t5, 70(sp)
; RV32I-NEXT:    sb t4, 69(sp)
; RV32I-NEXT:    sb t3, 68(sp)
; RV32I-NEXT:    sb t2, 67(sp)
; RV32I-NEXT:    sb t1, 66(sp)
; RV32I-NEXT:    lw a0, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 65(sp)
; RV32I-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 64(sp)
; RV32I-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 63(sp)
; RV32I-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 62(sp)
; RV32I-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 61(sp)
; RV32I-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 60(sp)
; RV32I-NEXT:    andi a1, a1, 31
; RV32I-NEXT:    addi a0, sp, 60
; RV32I-NEXT:    sub a6, a0, a1
; RV32I-NEXT:    lbu a0, 6(a6)
; RV32I-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a0, 7(a6)
; RV32I-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a0, 4(a6)
; RV32I-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a0, 5(a6)
; RV32I-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a0, 0(a6)
; RV32I-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a7, 1(a6)
; RV32I-NEXT:    lbu t0, 2(a6)
; RV32I-NEXT:    lbu t1, 3(a6)
; RV32I-NEXT:    lbu t2, 14(a6)
; RV32I-NEXT:    lbu t3, 15(a6)
; RV32I-NEXT:    lbu t4, 12(a6)
; RV32I-NEXT:    lbu t5, 13(a6)
; RV32I-NEXT:    lbu t6, 10(a6)
; RV32I-NEXT:    lbu s0, 11(a6)
; RV32I-NEXT:    lbu s1, 8(a6)
; RV32I-NEXT:    lbu s2, 9(a6)
; RV32I-NEXT:    lbu s3, 22(a6)
; RV32I-NEXT:    lbu s4, 23(a6)
; RV32I-NEXT:    lbu s5, 20(a6)
; RV32I-NEXT:    lbu s6, 21(a6)
; RV32I-NEXT:    lbu s7, 18(a6)
; RV32I-NEXT:    lbu s8, 19(a6)
; RV32I-NEXT:    lbu s9, 16(a6)
; RV32I-NEXT:    lbu s10, 17(a6)
; RV32I-NEXT:    lbu s11, 30(a6)
; RV32I-NEXT:    lbu ra, 31(a6)
; RV32I-NEXT:    lbu a5, 28(a6)
; RV32I-NEXT:    lbu a4, 29(a6)
; RV32I-NEXT:    lbu a0, 25(a6)
; RV32I-NEXT:    lbu a1, 24(a6)
; RV32I-NEXT:    lbu a3, 27(a6)
; RV32I-NEXT:    lbu a6, 26(a6)
; RV32I-NEXT:    sb a0, 25(a2)
; RV32I-NEXT:    sb a1, 24(a2)
; RV32I-NEXT:    sb a3, 27(a2)
; RV32I-NEXT:    sb a6, 26(a2)
; RV32I-NEXT:    sb a4, 29(a2)
; RV32I-NEXT:    sb a5, 28(a2)
; RV32I-NEXT:    sb ra, 31(a2)
; RV32I-NEXT:    sb s11, 30(a2)
; RV32I-NEXT:    sb s10, 17(a2)
; RV32I-NEXT:    sb s9, 16(a2)
; RV32I-NEXT:    sb s8, 19(a2)
; RV32I-NEXT:    sb s7, 18(a2)
; RV32I-NEXT:    sb s6, 21(a2)
; RV32I-NEXT:    sb s5, 20(a2)
; RV32I-NEXT:    sb s4, 23(a2)
; RV32I-NEXT:    sb s3, 22(a2)
; RV32I-NEXT:    sb s2, 9(a2)
; RV32I-NEXT:    sb s1, 8(a2)
; RV32I-NEXT:    sb s0, 11(a2)
; RV32I-NEXT:    sb t6, 10(a2)
; RV32I-NEXT:    sb t5, 13(a2)
; RV32I-NEXT:    sb t4, 12(a2)
; RV32I-NEXT:    sb t3, 15(a2)
; RV32I-NEXT:    sb t2, 14(a2)
; RV32I-NEXT:    sb t1, 3(a2)
; RV32I-NEXT:    sb t0, 2(a2)
; RV32I-NEXT:    sb a7, 1(a2)
; RV32I-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 0(a2)
; RV32I-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 5(a2)
; RV32I-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 4(a2)
; RV32I-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 7(a2)
; RV32I-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 6(a2)
; RV32I-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 136(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 132(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 128(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 124(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 120(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 116(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s6, 112(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s7, 108(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s8, 104(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s9, 100(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s10, 96(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s11, 92(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 144
; RV32I-NEXT:    ret
  %src = load i256, ptr %src.ptr, align 1
  %byteOff = load i256, ptr %byteOff.ptr, align 1
  %bitOff = shl i256 %byteOff, 3
  %res = shl i256 %src, %bitOff
  store i256 %res, ptr %dst, align 1
  ret void
}
define void @ashr_32bytes(ptr %src.ptr, ptr %byteOff.ptr, ptr %dst) nounwind {
; RV64I-LABEL: ashr_32bytes:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -224
; RV64I-NEXT:    sd ra, 216(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 208(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 200(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 192(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 184(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s4, 176(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s5, 168(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s6, 160(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s7, 152(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s8, 144(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s9, 136(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s10, 128(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s11, 120(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv t0, a1
; RV64I-NEXT:    lbu t1, 31(a0)
; RV64I-NEXT:    lbu a1, 0(a0)
; RV64I-NEXT:    sd a1, 48(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a1, 1(a0)
; RV64I-NEXT:    sd a1, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a1, 2(a0)
; RV64I-NEXT:    sd a1, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a1, 3(a0)
; RV64I-NEXT:    sd a1, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a1, 4(a0)
; RV64I-NEXT:    sd a1, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a1, 5(a0)
; RV64I-NEXT:    sd a1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu t2, 6(a0)
; RV64I-NEXT:    lbu t3, 7(a0)
; RV64I-NEXT:    lbu t4, 8(a0)
; RV64I-NEXT:    lbu t5, 9(a0)
; RV64I-NEXT:    lbu t6, 10(a0)
; RV64I-NEXT:    lbu s0, 11(a0)
; RV64I-NEXT:    lbu s1, 12(a0)
; RV64I-NEXT:    lbu s2, 13(a0)
; RV64I-NEXT:    lbu s3, 14(a0)
; RV64I-NEXT:    lbu s4, 15(a0)
; RV64I-NEXT:    lbu s5, 16(a0)
; RV64I-NEXT:    lbu s6, 17(a0)
; RV64I-NEXT:    lbu s7, 18(a0)
; RV64I-NEXT:    lbu s8, 19(a0)
; RV64I-NEXT:    lbu s9, 20(a0)
; RV64I-NEXT:    lbu s10, 21(a0)
; RV64I-NEXT:    lbu s11, 22(a0)
; RV64I-NEXT:    lbu ra, 23(a0)
; RV64I-NEXT:    lbu a7, 24(a0)
; RV64I-NEXT:    lbu a6, 25(a0)
; RV64I-NEXT:    lbu a5, 26(a0)
; RV64I-NEXT:    lbu a4, 27(a0)
; RV64I-NEXT:    lbu a1, 30(a0)
; RV64I-NEXT:    lbu a3, 29(a0)
; RV64I-NEXT:    lbu a0, 28(a0)
; RV64I-NEXT:    lbu t0, 0(t0)
; RV64I-NEXT:    sb a1, 86(sp)
; RV64I-NEXT:    sb a3, 85(sp)
; RV64I-NEXT:    sb a0, 84(sp)
; RV64I-NEXT:    sb a4, 83(sp)
; RV64I-NEXT:    sb a5, 82(sp)
; RV64I-NEXT:    sb a6, 81(sp)
; RV64I-NEXT:    sb t1, 87(sp)
; RV64I-NEXT:    slli t1, t1, 56
; RV64I-NEXT:    sb a7, 80(sp)
; RV64I-NEXT:    sb ra, 79(sp)
; RV64I-NEXT:    sb s11, 78(sp)
; RV64I-NEXT:    sb s10, 77(sp)
; RV64I-NEXT:    sb s9, 76(sp)
; RV64I-NEXT:    sb s8, 75(sp)
; RV64I-NEXT:    sb s7, 74(sp)
; RV64I-NEXT:    sb s6, 73(sp)
; RV64I-NEXT:    sb s5, 72(sp)
; RV64I-NEXT:    sb s4, 71(sp)
; RV64I-NEXT:    sb s3, 70(sp)
; RV64I-NEXT:    sb s2, 69(sp)
; RV64I-NEXT:    sb s1, 68(sp)
; RV64I-NEXT:    sb s0, 67(sp)
; RV64I-NEXT:    sb t6, 66(sp)
; RV64I-NEXT:    sb t5, 65(sp)
; RV64I-NEXT:    sb t4, 64(sp)
; RV64I-NEXT:    sb t3, 63(sp)
; RV64I-NEXT:    sb t2, 62(sp)
; RV64I-NEXT:    ld a0, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 61(sp)
; RV64I-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 60(sp)
; RV64I-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 59(sp)
; RV64I-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 58(sp)
; RV64I-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 57(sp)
; RV64I-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 56(sp)
; RV64I-NEXT:    srai a0, t1, 63
; RV64I-NEXT:    sb a0, 112(sp)
; RV64I-NEXT:    sb a0, 104(sp)
; RV64I-NEXT:    sb a0, 96(sp)
; RV64I-NEXT:    sb a0, 88(sp)
; RV64I-NEXT:    srli a1, a0, 56
; RV64I-NEXT:    sb a1, 119(sp)
; RV64I-NEXT:    srli a3, a0, 48
; RV64I-NEXT:    sb a3, 118(sp)
; RV64I-NEXT:    srli a4, a0, 40
; RV64I-NEXT:    sb a4, 117(sp)
; RV64I-NEXT:    srli a5, a0, 32
; RV64I-NEXT:    sb a5, 116(sp)
; RV64I-NEXT:    srli a6, a0, 24
; RV64I-NEXT:    sb a6, 115(sp)
; RV64I-NEXT:    srli a7, a0, 16
; RV64I-NEXT:    sb a7, 114(sp)
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sb a0, 113(sp)
; RV64I-NEXT:    sb a1, 111(sp)
; RV64I-NEXT:    sb a3, 110(sp)
; RV64I-NEXT:    sb a4, 109(sp)
; RV64I-NEXT:    sb a5, 108(sp)
; RV64I-NEXT:    sb a6, 107(sp)
; RV64I-NEXT:    sb a7, 106(sp)
; RV64I-NEXT:    sb a0, 105(sp)
; RV64I-NEXT:    sb a1, 103(sp)
; RV64I-NEXT:    sb a3, 102(sp)
; RV64I-NEXT:    sb a4, 101(sp)
; RV64I-NEXT:    sb a5, 100(sp)
; RV64I-NEXT:    sb a6, 99(sp)
; RV64I-NEXT:    sb a7, 98(sp)
; RV64I-NEXT:    sb a0, 97(sp)
; RV64I-NEXT:    sb a1, 95(sp)
; RV64I-NEXT:    sb a3, 94(sp)
; RV64I-NEXT:    sb a4, 93(sp)
; RV64I-NEXT:    sb a5, 92(sp)
; RV64I-NEXT:    sb a6, 91(sp)
; RV64I-NEXT:    sb a7, 90(sp)
; RV64I-NEXT:    sb a0, 89(sp)
; RV64I-NEXT:    andi a0, t0, 31
; RV64I-NEXT:    addi a1, sp, 56
; RV64I-NEXT:    add a6, a1, a0
; RV64I-NEXT:    lbu a0, 8(a6)
; RV64I-NEXT:    sd a0, 48(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a0, 9(a6)
; RV64I-NEXT:    sd a0, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a0, 10(a6)
; RV64I-NEXT:    sd a0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a0, 11(a6)
; RV64I-NEXT:    sd a0, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a0, 12(a6)
; RV64I-NEXT:    sd a0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lbu a7, 13(a6)
; RV64I-NEXT:    lbu t0, 14(a6)
; RV64I-NEXT:    lbu t1, 15(a6)
; RV64I-NEXT:    lbu t2, 0(a6)
; RV64I-NEXT:    lbu t3, 1(a6)
; RV64I-NEXT:    lbu t4, 2(a6)
; RV64I-NEXT:    lbu t5, 3(a6)
; RV64I-NEXT:    lbu t6, 4(a6)
; RV64I-NEXT:    lbu s0, 5(a6)
; RV64I-NEXT:    lbu s1, 6(a6)
; RV64I-NEXT:    lbu s2, 7(a6)
; RV64I-NEXT:    lbu s3, 24(a6)
; RV64I-NEXT:    lbu s4, 25(a6)
; RV64I-NEXT:    lbu s5, 26(a6)
; RV64I-NEXT:    lbu s6, 27(a6)
; RV64I-NEXT:    lbu s7, 28(a6)
; RV64I-NEXT:    lbu s8, 29(a6)
; RV64I-NEXT:    lbu s9, 30(a6)
; RV64I-NEXT:    lbu s10, 31(a6)
; RV64I-NEXT:    lbu s11, 16(a6)
; RV64I-NEXT:    lbu ra, 17(a6)
; RV64I-NEXT:    lbu a5, 18(a6)
; RV64I-NEXT:    lbu a4, 19(a6)
; RV64I-NEXT:    lbu a0, 23(a6)
; RV64I-NEXT:    lbu a1, 22(a6)
; RV64I-NEXT:    lbu a3, 21(a6)
; RV64I-NEXT:    lbu a6, 20(a6)
; RV64I-NEXT:    sb a0, 23(a2)
; RV64I-NEXT:    sb a1, 22(a2)
; RV64I-NEXT:    sb a3, 21(a2)
; RV64I-NEXT:    sb a6, 20(a2)
; RV64I-NEXT:    sb a4, 19(a2)
; RV64I-NEXT:    sb a5, 18(a2)
; RV64I-NEXT:    sb ra, 17(a2)
; RV64I-NEXT:    sb s11, 16(a2)
; RV64I-NEXT:    sb s10, 31(a2)
; RV64I-NEXT:    sb s9, 30(a2)
; RV64I-NEXT:    sb s8, 29(a2)
; RV64I-NEXT:    sb s7, 28(a2)
; RV64I-NEXT:    sb s6, 27(a2)
; RV64I-NEXT:    sb s5, 26(a2)
; RV64I-NEXT:    sb s4, 25(a2)
; RV64I-NEXT:    sb s3, 24(a2)
; RV64I-NEXT:    sb s2, 7(a2)
; RV64I-NEXT:    sb s1, 6(a2)
; RV64I-NEXT:    sb s0, 5(a2)
; RV64I-NEXT:    sb t6, 4(a2)
; RV64I-NEXT:    sb t5, 3(a2)
; RV64I-NEXT:    sb t4, 2(a2)
; RV64I-NEXT:    sb t3, 1(a2)
; RV64I-NEXT:    sb t2, 0(a2)
; RV64I-NEXT:    sb t1, 15(a2)
; RV64I-NEXT:    sb t0, 14(a2)
; RV64I-NEXT:    sb a7, 13(a2)
; RV64I-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 12(a2)
; RV64I-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 11(a2)
; RV64I-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 10(a2)
; RV64I-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 9(a2)
; RV64I-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sb a0, 8(a2)
; RV64I-NEXT:    ld ra, 216(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 208(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 200(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 192(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 184(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s4, 176(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s5, 168(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s6, 160(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s7, 152(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s8, 144(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s9, 136(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s10, 128(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s11, 120(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 224
; RV64I-NEXT:    ret
;
; RV32I-LABEL: ashr_32bytes:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -144
; RV32I-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 136(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 132(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 128(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 124(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 120(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 116(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s6, 112(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s7, 108(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s8, 104(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s9, 100(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s10, 96(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s11, 92(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv t0, a1
; RV32I-NEXT:    lbu t1, 31(a0)
; RV32I-NEXT:    lbu a1, 0(a0)
; RV32I-NEXT:    sw a1, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a1, 1(a0)
; RV32I-NEXT:    sw a1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a1, 2(a0)
; RV32I-NEXT:    sw a1, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a1, 3(a0)
; RV32I-NEXT:    sw a1, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a1, 4(a0)
; RV32I-NEXT:    sw a1, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a1, 5(a0)
; RV32I-NEXT:    sw a1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu t2, 6(a0)
; RV32I-NEXT:    lbu t3, 7(a0)
; RV32I-NEXT:    lbu t4, 8(a0)
; RV32I-NEXT:    lbu t5, 9(a0)
; RV32I-NEXT:    lbu t6, 10(a0)
; RV32I-NEXT:    lbu s0, 11(a0)
; RV32I-NEXT:    lbu s1, 12(a0)
; RV32I-NEXT:    lbu s2, 13(a0)
; RV32I-NEXT:    lbu s3, 14(a0)
; RV32I-NEXT:    lbu s4, 15(a0)
; RV32I-NEXT:    lbu s5, 16(a0)
; RV32I-NEXT:    lbu s6, 17(a0)
; RV32I-NEXT:    lbu s7, 18(a0)
; RV32I-NEXT:    lbu s8, 19(a0)
; RV32I-NEXT:    lbu s9, 20(a0)
; RV32I-NEXT:    lbu s10, 21(a0)
; RV32I-NEXT:    lbu s11, 22(a0)
; RV32I-NEXT:    lbu ra, 23(a0)
; RV32I-NEXT:    lbu a7, 24(a0)
; RV32I-NEXT:    lbu a6, 25(a0)
; RV32I-NEXT:    lbu a5, 26(a0)
; RV32I-NEXT:    lbu a4, 27(a0)
; RV32I-NEXT:    lbu a1, 30(a0)
; RV32I-NEXT:    lbu a3, 29(a0)
; RV32I-NEXT:    lbu a0, 28(a0)
; RV32I-NEXT:    lbu t0, 0(t0)
; RV32I-NEXT:    sb a1, 58(sp)
; RV32I-NEXT:    sb a3, 57(sp)
; RV32I-NEXT:    sb a0, 56(sp)
; RV32I-NEXT:    sb a4, 55(sp)
; RV32I-NEXT:    sb a5, 54(sp)
; RV32I-NEXT:    sb a6, 53(sp)
; RV32I-NEXT:    sb t1, 59(sp)
; RV32I-NEXT:    slli t1, t1, 24
; RV32I-NEXT:    sb a7, 52(sp)
; RV32I-NEXT:    sb ra, 51(sp)
; RV32I-NEXT:    sb s11, 50(sp)
; RV32I-NEXT:    sb s10, 49(sp)
; RV32I-NEXT:    sb s9, 48(sp)
; RV32I-NEXT:    sb s8, 47(sp)
; RV32I-NEXT:    sb s7, 46(sp)
; RV32I-NEXT:    sb s6, 45(sp)
; RV32I-NEXT:    sb s5, 44(sp)
; RV32I-NEXT:    sb s4, 43(sp)
; RV32I-NEXT:    sb s3, 42(sp)
; RV32I-NEXT:    sb s2, 41(sp)
; RV32I-NEXT:    sb s1, 40(sp)
; RV32I-NEXT:    sb s0, 39(sp)
; RV32I-NEXT:    sb t6, 38(sp)
; RV32I-NEXT:    sb t5, 37(sp)
; RV32I-NEXT:    sb t4, 36(sp)
; RV32I-NEXT:    sb t3, 35(sp)
; RV32I-NEXT:    sb t2, 34(sp)
; RV32I-NEXT:    lw a0, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 33(sp)
; RV32I-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 32(sp)
; RV32I-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 31(sp)
; RV32I-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 30(sp)
; RV32I-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 29(sp)
; RV32I-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 28(sp)
; RV32I-NEXT:    srai a0, t1, 31
; RV32I-NEXT:    sb a0, 88(sp)
; RV32I-NEXT:    sb a0, 84(sp)
; RV32I-NEXT:    sb a0, 80(sp)
; RV32I-NEXT:    sb a0, 76(sp)
; RV32I-NEXT:    sb a0, 72(sp)
; RV32I-NEXT:    sb a0, 68(sp)
; RV32I-NEXT:    sb a0, 64(sp)
; RV32I-NEXT:    sb a0, 60(sp)
; RV32I-NEXT:    srli a1, a0, 24
; RV32I-NEXT:    sb a1, 91(sp)
; RV32I-NEXT:    srli a3, a0, 16
; RV32I-NEXT:    sb a3, 90(sp)
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sb a0, 89(sp)
; RV32I-NEXT:    sb a1, 87(sp)
; RV32I-NEXT:    sb a3, 86(sp)
; RV32I-NEXT:    sb a0, 85(sp)
; RV32I-NEXT:    sb a1, 83(sp)
; RV32I-NEXT:    sb a3, 82(sp)
; RV32I-NEXT:    sb a0, 81(sp)
; RV32I-NEXT:    sb a1, 79(sp)
; RV32I-NEXT:    sb a3, 78(sp)
; RV32I-NEXT:    sb a0, 77(sp)
; RV32I-NEXT:    sb a1, 75(sp)
; RV32I-NEXT:    sb a3, 74(sp)
; RV32I-NEXT:    sb a0, 73(sp)
; RV32I-NEXT:    sb a1, 71(sp)
; RV32I-NEXT:    sb a3, 70(sp)
; RV32I-NEXT:    sb a0, 69(sp)
; RV32I-NEXT:    sb a1, 67(sp)
; RV32I-NEXT:    sb a3, 66(sp)
; RV32I-NEXT:    sb a0, 65(sp)
; RV32I-NEXT:    sb a1, 63(sp)
; RV32I-NEXT:    sb a3, 62(sp)
; RV32I-NEXT:    sb a0, 61(sp)
; RV32I-NEXT:    andi a0, t0, 31
; RV32I-NEXT:    addi a1, sp, 28
; RV32I-NEXT:    add a6, a1, a0
; RV32I-NEXT:    lbu a0, 6(a6)
; RV32I-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a0, 7(a6)
; RV32I-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a0, 4(a6)
; RV32I-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a0, 5(a6)
; RV32I-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a0, 0(a6)
; RV32I-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lbu a7, 1(a6)
; RV32I-NEXT:    lbu t0, 2(a6)
; RV32I-NEXT:    lbu t1, 3(a6)
; RV32I-NEXT:    lbu t2, 14(a6)
; RV32I-NEXT:    lbu t3, 15(a6)
; RV32I-NEXT:    lbu t4, 12(a6)
; RV32I-NEXT:    lbu t5, 13(a6)
; RV32I-NEXT:    lbu t6, 10(a6)
; RV32I-NEXT:    lbu s0, 11(a6)
; RV32I-NEXT:    lbu s1, 8(a6)
; RV32I-NEXT:    lbu s2, 9(a6)
; RV32I-NEXT:    lbu s3, 22(a6)
; RV32I-NEXT:    lbu s4, 23(a6)
; RV32I-NEXT:    lbu s5, 20(a6)
; RV32I-NEXT:    lbu s6, 21(a6)
; RV32I-NEXT:    lbu s7, 18(a6)
; RV32I-NEXT:    lbu s8, 19(a6)
; RV32I-NEXT:    lbu s9, 16(a6)
; RV32I-NEXT:    lbu s10, 17(a6)
; RV32I-NEXT:    lbu s11, 30(a6)
; RV32I-NEXT:    lbu ra, 31(a6)
; RV32I-NEXT:    lbu a5, 28(a6)
; RV32I-NEXT:    lbu a4, 29(a6)
; RV32I-NEXT:    lbu a0, 25(a6)
; RV32I-NEXT:    lbu a1, 24(a6)
; RV32I-NEXT:    lbu a3, 27(a6)
; RV32I-NEXT:    lbu a6, 26(a6)
; RV32I-NEXT:    sb a0, 25(a2)
; RV32I-NEXT:    sb a1, 24(a2)
; RV32I-NEXT:    sb a3, 27(a2)
; RV32I-NEXT:    sb a6, 26(a2)
; RV32I-NEXT:    sb a4, 29(a2)
; RV32I-NEXT:    sb a5, 28(a2)
; RV32I-NEXT:    sb ra, 31(a2)
; RV32I-NEXT:    sb s11, 30(a2)
; RV32I-NEXT:    sb s10, 17(a2)
; RV32I-NEXT:    sb s9, 16(a2)
; RV32I-NEXT:    sb s8, 19(a2)
; RV32I-NEXT:    sb s7, 18(a2)
; RV32I-NEXT:    sb s6, 21(a2)
; RV32I-NEXT:    sb s5, 20(a2)
; RV32I-NEXT:    sb s4, 23(a2)
; RV32I-NEXT:    sb s3, 22(a2)
; RV32I-NEXT:    sb s2, 9(a2)
; RV32I-NEXT:    sb s1, 8(a2)
; RV32I-NEXT:    sb s0, 11(a2)
; RV32I-NEXT:    sb t6, 10(a2)
; RV32I-NEXT:    sb t5, 13(a2)
; RV32I-NEXT:    sb t4, 12(a2)
; RV32I-NEXT:    sb t3, 15(a2)
; RV32I-NEXT:    sb t2, 14(a2)
; RV32I-NEXT:    sb t1, 3(a2)
; RV32I-NEXT:    sb t0, 2(a2)
; RV32I-NEXT:    sb a7, 1(a2)
; RV32I-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 0(a2)
; RV32I-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 5(a2)
; RV32I-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 4(a2)
; RV32I-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 7(a2)
; RV32I-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sb a0, 6(a2)
; RV32I-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 136(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 132(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 128(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 124(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 120(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 116(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s6, 112(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s7, 108(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s8, 104(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s9, 100(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s10, 96(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s11, 92(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 144
; RV32I-NEXT:    ret
  %src = load i256, ptr %src.ptr, align 1
  %byteOff = load i256, ptr %byteOff.ptr, align 1
  %bitOff = shl i256 %byteOff, 3
  %res = ashr i256 %src, %bitOff
  store i256 %res, ptr %dst, align 1
  ret void
}
