; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-linux | FileCheck %s -check-prefix=CHECK-32
; RUN: llc < %s -mtriple=x86_64-linux | FileCheck %s -check-prefix=CHECK-64

define i1 @is_nan_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_nan_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    fldt {{[0-9]+}}(%esp)
; CHECK-32-NEXT:    fucomp %st(0)
; CHECK-32-NEXT:    fnstsw %ax
; CHECK-32-NEXT:    # kill: def $ah killed $ah killed $ax
; CHECK-32-NEXT:    sahf
; CHECK-32-NEXT:    setp %al
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_nan_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    fldt {{[0-9]+}}(%rsp)
; CHECK-64-NEXT:    fucompi %st(0), %st
; CHECK-64-NEXT:    setp %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 3)  ; "nan"
  ret i1 %0
}

define i1 @is_nan_f80_strict(x86_fp80 %x) strictfp {
; CHECK-32-LABEL: is_nan_f80_strict:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    pushl %esi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 8
; CHECK-32-NEXT:    .cfi_offset %esi, -8
; CHECK-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    andl $32767, %ecx # imm = 0x7FFF
; CHECK-32-NEXT:    xorl %edx, %edx
; CHECK-32-NEXT:    cmpl {{[0-9]+}}(%esp), %edx
; CHECK-32-NEXT:    movl $-2147483648, %esi # imm = 0x80000000
; CHECK-32-NEXT:    sbbl %eax, %esi
; CHECK-32-NEXT:    movl $32767, %esi # imm = 0x7FFF
; CHECK-32-NEXT:    sbbl %ecx, %esi
; CHECK-32-NEXT:    sbbl %edx, %edx
; CHECK-32-NEXT:    setl %dl
; CHECK-32-NEXT:    testl %ecx, %ecx
; CHECK-32-NEXT:    sete %cl
; CHECK-32-NEXT:    shrl $31, %eax
; CHECK-32-NEXT:    xorb %cl, %al
; CHECK-32-NEXT:    xorb $1, %al
; CHECK-32-NEXT:    orb %dl, %al
; CHECK-32-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-32-NEXT:    popl %esi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 4
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_nan_f80_strict:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; CHECK-64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; CHECK-64-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-64-NEXT:    movabsq $-9223372036854775808, %rdx # imm = 0x8000000000000000
; CHECK-64-NEXT:    cmpq %rcx, %rdx
; CHECK-64-NEXT:    movl $32767, %edx # imm = 0x7FFF
; CHECK-64-NEXT:    sbbq %rax, %rdx
; CHECK-64-NEXT:    setl %dl
; CHECK-64-NEXT:    shrq $63, %rcx
; CHECK-64-NEXT:    testq %rax, %rax
; CHECK-64-NEXT:    sete %al
; CHECK-64-NEXT:    xorb %cl, %al
; CHECK-64-NEXT:    xorb $1, %al
; CHECK-64-NEXT:    orb %dl, %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 3) strictfp ; "nan"
  ret i1 %0
}

define i1 @is_snan_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_snan_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    pushl %ebx
; CHECK-32-NEXT:    .cfi_def_cfa_offset 8
; CHECK-32-NEXT:    pushl %esi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 12
; CHECK-32-NEXT:    .cfi_offset %esi, -12
; CHECK-32-NEXT:    .cfi_offset %ebx, -8
; CHECK-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; CHECK-32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-32-NEXT:    xorl %ecx, %ecx
; CHECK-32-NEXT:    cmpl {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    movl $-2147483648, %esi # imm = 0x80000000
; CHECK-32-NEXT:    sbbl %edx, %esi
; CHECK-32-NEXT:    movl $32767, %esi # imm = 0x7FFF
; CHECK-32-NEXT:    sbbl %eax, %esi
; CHECK-32-NEXT:    movl $0, %esi
; CHECK-32-NEXT:    sbbl %esi, %esi
; CHECK-32-NEXT:    setl %bl
; CHECK-32-NEXT:    cmpl $-1073741824, %edx # imm = 0xC0000000
; CHECK-32-NEXT:    sbbl $32767, %eax # imm = 0x7FFF
; CHECK-32-NEXT:    sbbl %ecx, %ecx
; CHECK-32-NEXT:    setl %al
; CHECK-32-NEXT:    andb %bl, %al
; CHECK-32-NEXT:    popl %esi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 8
; CHECK-32-NEXT:    popl %ebx
; CHECK-32-NEXT:    .cfi_def_cfa_offset 4
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_snan_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; CHECK-64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; CHECK-64-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-64-NEXT:    movabsq $-4611686018427387904, %rdx # imm = 0xC000000000000000
; CHECK-64-NEXT:    cmpq %rdx, %rcx
; CHECK-64-NEXT:    movq %rax, %rdx
; CHECK-64-NEXT:    sbbq $32767, %rdx # imm = 0x7FFF
; CHECK-64-NEXT:    setl %dl
; CHECK-64-NEXT:    movabsq $-9223372036854775808, %rsi # imm = 0x8000000000000000
; CHECK-64-NEXT:    cmpq %rcx, %rsi
; CHECK-64-NEXT:    movl $32767, %ecx # imm = 0x7FFF
; CHECK-64-NEXT:    sbbq %rax, %rcx
; CHECK-64-NEXT:    setl %al
; CHECK-64-NEXT:    andb %dl, %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 1)  ; "snan"
  ret i1 %0
}

define i1 @is_qnan_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_qnan_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-32-NEXT:    xorl %ecx, %ecx
; CHECK-32-NEXT:    movl $-1073741825, %edx # imm = 0xBFFFFFFF
; CHECK-32-NEXT:    cmpl {{[0-9]+}}(%esp), %edx
; CHECK-32-NEXT:    movl $32767, %edx # imm = 0x7FFF
; CHECK-32-NEXT:    sbbl %eax, %edx
; CHECK-32-NEXT:    sbbl %ecx, %ecx
; CHECK-32-NEXT:    setl %al
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_qnan_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; CHECK-64-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-64-NEXT:    movabsq $-4611686018427387905, %rcx # imm = 0xBFFFFFFFFFFFFFFF
; CHECK-64-NEXT:    cmpq {{[0-9]+}}(%rsp), %rcx
; CHECK-64-NEXT:    movl $32767, %ecx # imm = 0x7FFF
; CHECK-64-NEXT:    sbbq %rax, %rcx
; CHECK-64-NEXT:    setl %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 2)  ; "qnan"
  ret i1 %0
}

define i1 @is_zero_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_zero_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-32-NEXT:    orl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    orl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    sete %al
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_zero_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; CHECK-64-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-64-NEXT:    orq {{[0-9]+}}(%rsp), %rax
; CHECK-64-NEXT:    sete %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 96)  ; 0x60 = "zero"
  ret i1 %0
}

define i1 @is_zero_f80_strict(x86_fp80 %x) strictfp {
; CHECK-32-LABEL: is_zero_f80_strict:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-32-NEXT:    orl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    orl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    sete %al
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_zero_f80_strict:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; CHECK-64-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-64-NEXT:    orq {{[0-9]+}}(%rsp), %rax
; CHECK-64-NEXT:    sete %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 96) strictfp ; 0x60 = "zero"
  ret i1 %0
}

define i1 @is_poszero_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_poszero_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    orl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    orl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    sete %al
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_poszero_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; CHECK-64-NEXT:    orq {{[0-9]+}}(%rsp), %rax
; CHECK-64-NEXT:    sete %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 64)  ; 0x40 = "+zero"
  ret i1 %0
}

define i1 @is_negzero_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_negzero_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    xorl $32768, %eax # imm = 0x8000
; CHECK-32-NEXT:    orl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    orl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    sete %al
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_negzero_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; CHECK-64-NEXT:    xorq $32768, %rax # imm = 0x8000
; CHECK-64-NEXT:    orq {{[0-9]+}}(%rsp), %rax
; CHECK-64-NEXT:    sete %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 32)  ; 0x20 = "-zero"
  ret i1 %0
}

define i1 @is_inf_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_inf_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    notl %eax
; CHECK-32-NEXT:    movl $-2147483648, %ecx # imm = 0x80000000
; CHECK-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-32-NEXT:    orl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    orl %ecx, %eax
; CHECK-32-NEXT:    sete %al
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_inf_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movl {{[0-9]+}}(%rsp), %eax
; CHECK-64-NEXT:    notl %eax
; CHECK-64-NEXT:    movabsq $-9223372036854775808, %rcx # imm = 0x8000000000000000
; CHECK-64-NEXT:    xorq {{[0-9]+}}(%rsp), %rcx
; CHECK-64-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-64-NEXT:    orq %rcx, %rax
; CHECK-64-NEXT:    sete %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 516)  ; 0x204 = "inf"
  ret i1 %0
}

define i1 @is_posinf_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_posinf_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    movl $-2147483648, %ecx # imm = 0x80000000
; CHECK-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    xorl $32767, %eax # imm = 0x7FFF
; CHECK-32-NEXT:    orl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    orl %ecx, %eax
; CHECK-32-NEXT:    sete %al
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_posinf_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; CHECK-64-NEXT:    movabsq $-9223372036854775808, %rcx # imm = 0x8000000000000000
; CHECK-64-NEXT:    xorq {{[0-9]+}}(%rsp), %rcx
; CHECK-64-NEXT:    xorq $32767, %rax # imm = 0x7FFF
; CHECK-64-NEXT:    orq %rcx, %rax
; CHECK-64-NEXT:    sete %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 512)  ; 0x200 = "+inf"
  ret i1 %0
}

define i1 @is_neginf_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_neginf_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; CHECK-32-NEXT:    movl $-2147483648, %ecx # imm = 0x80000000
; CHECK-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    orl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    orl %ecx, %eax
; CHECK-32-NEXT:    sete %al
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_neginf_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; CHECK-64-NEXT:    xorq $65535, %rax # imm = 0xFFFF
; CHECK-64-NEXT:    movabsq $-9223372036854775808, %rcx # imm = 0x8000000000000000
; CHECK-64-NEXT:    xorq {{[0-9]+}}(%rsp), %rcx
; CHECK-64-NEXT:    orq %rax, %rcx
; CHECK-64-NEXT:    sete %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 4)  ; "-inf"
  ret i1 %0
}

define i1 @is_normal_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_normal_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    andl $32767, %ecx # imm = 0x7FFF
; CHECK-32-NEXT:    decl %ecx
; CHECK-32-NEXT:    movzwl %cx, %ecx
; CHECK-32-NEXT:    xorl %edx, %edx
; CHECK-32-NEXT:    cmpl $32766, %ecx # imm = 0x7FFE
; CHECK-32-NEXT:    sbbl %edx, %edx
; CHECK-32-NEXT:    setb %cl
; CHECK-32-NEXT:    shrl $31, %eax
; CHECK-32-NEXT:    andb %cl, %al
; CHECK-32-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_normal_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; CHECK-64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; CHECK-64-NEXT:    shrq $63, %rcx
; CHECK-64-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-64-NEXT:    decl %eax
; CHECK-64-NEXT:    movzwl %ax, %eax
; CHECK-64-NEXT:    cmpl $32766, %eax # imm = 0x7FFE
; CHECK-64-NEXT:    setb %al
; CHECK-64-NEXT:    andb %cl, %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 264)  ; 0x108 = "normal"
  ret i1 %0
}

define i1 @is_posnormal_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_posnormal_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    pushl %esi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 8
; CHECK-32-NEXT:    .cfi_offset %esi, -8
; CHECK-32-NEXT:    movzwl {{[0-9]+}}(%esp), %edx
; CHECK-32-NEXT:    movswl %dx, %ecx
; CHECK-32-NEXT:    sarl $15, %ecx
; CHECK-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    andl $32767, %edx # imm = 0x7FFF
; CHECK-32-NEXT:    decl %edx
; CHECK-32-NEXT:    movzwl %dx, %edx
; CHECK-32-NEXT:    xorl %esi, %esi
; CHECK-32-NEXT:    cmpl $32766, %edx # imm = 0x7FFE
; CHECK-32-NEXT:    sbbl %esi, %esi
; CHECK-32-NEXT:    setb %dl
; CHECK-32-NEXT:    testl %ecx, %ecx
; CHECK-32-NEXT:    setns %cl
; CHECK-32-NEXT:    shrl $31, %eax
; CHECK-32-NEXT:    andb %cl, %al
; CHECK-32-NEXT:    andb %dl, %al
; CHECK-32-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-32-NEXT:    popl %esi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 4
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_posnormal_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; CHECK-64-NEXT:    movswq {{[0-9]+}}(%rsp), %rcx
; CHECK-64-NEXT:    testq %rcx, %rcx
; CHECK-64-NEXT:    setns %dl
; CHECK-64-NEXT:    andl $32767, %ecx # imm = 0x7FFF
; CHECK-64-NEXT:    decl %ecx
; CHECK-64-NEXT:    movzwl %cx, %ecx
; CHECK-64-NEXT:    cmpl $32766, %ecx # imm = 0x7FFE
; CHECK-64-NEXT:    setb %cl
; CHECK-64-NEXT:    shrq $63, %rax
; CHECK-64-NEXT:    andb %dl, %al
; CHECK-64-NEXT:    andb %cl, %al
; CHECK-64-NEXT:    # kill: def $al killed $al killed $rax
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 256)  ; 0x100 = "+normal"
  ret i1 %0
}

define i1 @is_negnormal_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_negnormal_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    pushl %esi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 8
; CHECK-32-NEXT:    .cfi_offset %esi, -8
; CHECK-32-NEXT:    movzwl {{[0-9]+}}(%esp), %edx
; CHECK-32-NEXT:    movswl %dx, %ecx
; CHECK-32-NEXT:    sarl $15, %ecx
; CHECK-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    andl $32767, %edx # imm = 0x7FFF
; CHECK-32-NEXT:    decl %edx
; CHECK-32-NEXT:    movzwl %dx, %edx
; CHECK-32-NEXT:    xorl %esi, %esi
; CHECK-32-NEXT:    cmpl $32766, %edx # imm = 0x7FFE
; CHECK-32-NEXT:    sbbl %esi, %esi
; CHECK-32-NEXT:    setb %dl
; CHECK-32-NEXT:    testl %ecx, %ecx
; CHECK-32-NEXT:    sets %cl
; CHECK-32-NEXT:    shrl $31, %eax
; CHECK-32-NEXT:    andb %cl, %al
; CHECK-32-NEXT:    andb %dl, %al
; CHECK-32-NEXT:    # kill: def $al killed $al killed $eax
; CHECK-32-NEXT:    popl %esi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 4
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_negnormal_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; CHECK-64-NEXT:    movswq {{[0-9]+}}(%rsp), %rcx
; CHECK-64-NEXT:    testq %rcx, %rcx
; CHECK-64-NEXT:    sets %dl
; CHECK-64-NEXT:    andl $32767, %ecx # imm = 0x7FFF
; CHECK-64-NEXT:    decl %ecx
; CHECK-64-NEXT:    movzwl %cx, %ecx
; CHECK-64-NEXT:    cmpl $32766, %ecx # imm = 0x7FFE
; CHECK-64-NEXT:    setb %cl
; CHECK-64-NEXT:    shrq $63, %rax
; CHECK-64-NEXT:    andb %dl, %al
; CHECK-64-NEXT:    andb %cl, %al
; CHECK-64-NEXT:    # kill: def $al killed $al killed $rax
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 8)  ; "-normal"
  ret i1 %0
}

define i1 @is_subnormal_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_subnormal_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    pushl %esi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 8
; CHECK-32-NEXT:    .cfi_offset %esi, -8
; CHECK-32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-32-NEXT:    xorl %edx, %edx
; CHECK-32-NEXT:    addl $-1, %esi
; CHECK-32-NEXT:    adcl $-1, %ecx
; CHECK-32-NEXT:    adcl $-1, %eax
; CHECK-32-NEXT:    adcl $-1, %edx
; CHECK-32-NEXT:    cmpl $-1, %esi
; CHECK-32-NEXT:    sbbl $2147483647, %ecx # imm = 0x7FFFFFFF
; CHECK-32-NEXT:    sbbl $0, %eax
; CHECK-32-NEXT:    sbbl $0, %edx
; CHECK-32-NEXT:    setb %al
; CHECK-32-NEXT:    popl %esi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 4
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_subnormal_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; CHECK-64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; CHECK-64-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-64-NEXT:    addq $-1, %rcx
; CHECK-64-NEXT:    adcq $-1, %rax
; CHECK-64-NEXT:    movabsq $9223372036854775807, %rdx # imm = 0x7FFFFFFFFFFFFFFF
; CHECK-64-NEXT:    cmpq %rdx, %rcx
; CHECK-64-NEXT:    sbbq $0, %rax
; CHECK-64-NEXT:    setb %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 144)  ; 0x90 = "subnormal"
  ret i1 %0
}

define i1 @is_possubnormal_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_possubnormal_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    pushl %esi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 8
; CHECK-32-NEXT:    .cfi_offset %esi, -8
; CHECK-32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; CHECK-32-NEXT:    addl $-1, %ecx
; CHECK-32-NEXT:    adcl $-1, %edx
; CHECK-32-NEXT:    adcl $-1, %eax
; CHECK-32-NEXT:    movzwl %ax, %eax
; CHECK-32-NEXT:    xorl %esi, %esi
; CHECK-32-NEXT:    cmpl $-1, %ecx
; CHECK-32-NEXT:    sbbl $2147483647, %edx # imm = 0x7FFFFFFF
; CHECK-32-NEXT:    sbbl $0, %eax
; CHECK-32-NEXT:    sbbl %esi, %esi
; CHECK-32-NEXT:    setb %al
; CHECK-32-NEXT:    popl %esi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 4
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_possubnormal_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movl {{[0-9]+}}(%rsp), %eax
; CHECK-64-NEXT:    movq {{[0-9]+}}(%rsp), %rcx
; CHECK-64-NEXT:    addq $-1, %rcx
; CHECK-64-NEXT:    adcq $-1, %rax
; CHECK-64-NEXT:    movzwl %ax, %eax
; CHECK-64-NEXT:    movabsq $9223372036854775807, %rdx # imm = 0x7FFFFFFFFFFFFFFF
; CHECK-64-NEXT:    cmpq %rdx, %rcx
; CHECK-64-NEXT:    sbbq $0, %rax
; CHECK-64-NEXT:    setb %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 128)  ; 0x80 = "+subnormal"
  ret i1 %0
}

define i1 @is_negsubnormal_f80(x86_fp80 %x) {
; CHECK-32-LABEL: is_negsubnormal_f80:
; CHECK-32:       # %bb.0: # %entry
; CHECK-32-NEXT:    pushl %edi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 8
; CHECK-32-NEXT:    pushl %esi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 12
; CHECK-32-NEXT:    .cfi_offset %esi, -12
; CHECK-32-NEXT:    .cfi_offset %edi, -8
; CHECK-32-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; CHECK-32-NEXT:    movswl %cx, %eax
; CHECK-32-NEXT:    sarl $15, %eax
; CHECK-32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; CHECK-32-NEXT:    andl $32767, %ecx # imm = 0x7FFF
; CHECK-32-NEXT:    xorl %edx, %edx
; CHECK-32-NEXT:    addl $-1, %esi
; CHECK-32-NEXT:    adcl $-1, %edi
; CHECK-32-NEXT:    adcl $-1, %ecx
; CHECK-32-NEXT:    adcl $-1, %edx
; CHECK-32-NEXT:    cmpl $-1, %esi
; CHECK-32-NEXT:    sbbl $2147483647, %edi # imm = 0x7FFFFFFF
; CHECK-32-NEXT:    sbbl $0, %ecx
; CHECK-32-NEXT:    sbbl $0, %edx
; CHECK-32-NEXT:    setb %cl
; CHECK-32-NEXT:    testl %eax, %eax
; CHECK-32-NEXT:    sets %al
; CHECK-32-NEXT:    andb %cl, %al
; CHECK-32-NEXT:    popl %esi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 8
; CHECK-32-NEXT:    popl %edi
; CHECK-32-NEXT:    .cfi_def_cfa_offset 4
; CHECK-32-NEXT:    retl
;
; CHECK-64-LABEL: is_negsubnormal_f80:
; CHECK-64:       # %bb.0: # %entry
; CHECK-64-NEXT:    movzwl {{[0-9]+}}(%rsp), %eax
; CHECK-64-NEXT:    movswq %ax, %rcx
; CHECK-64-NEXT:    movq {{[0-9]+}}(%rsp), %rdx
; CHECK-64-NEXT:    andl $32767, %eax # imm = 0x7FFF
; CHECK-64-NEXT:    addq $-1, %rdx
; CHECK-64-NEXT:    adcq $-1, %rax
; CHECK-64-NEXT:    movabsq $9223372036854775807, %rsi # imm = 0x7FFFFFFFFFFFFFFF
; CHECK-64-NEXT:    cmpq %rsi, %rdx
; CHECK-64-NEXT:    sbbq $0, %rax
; CHECK-64-NEXT:    setb %dl
; CHECK-64-NEXT:    testq %rcx, %rcx
; CHECK-64-NEXT:    sets %al
; CHECK-64-NEXT:    andb %dl, %al
; CHECK-64-NEXT:    retq
entry:
  %0 = tail call i1 @llvm.is.fpclass.f80(x86_fp80 %x, i32 16)  ; 0x10 = "-subnormal"
  ret i1 %0
}

declare i1 @llvm.is.fpclass.f80(x86_fp80, i32)
