; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv32 -target-abi ilp32e -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I-ILP32E
; RUN: llc -mtriple=riscv32 -mattr=+f -target-abi ilp32f -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv32 -mattr=+d -target-abi ilp32f -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv32 -mattr=+d -target-abi ilp32d -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv32 -verify-machineinstrs -frame-pointer=all < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I-WITH-FP
; RUN: llc -mtriple=riscv32 -mattr=+zcmp -verify-machineinstrs < %s \
; RUN: | FileCheck %s -check-prefixes=RV32IZCMP
; RUN: llc -mtriple=riscv32 -mattr=+zcmp -verify-machineinstrs \
; RUN:  -frame-pointer=all < %s | FileCheck %s -check-prefixes=RV32IZCMP-WITH-FP
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I
; RUN: llc -mtriple=riscv64 -target-abi lp64e -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I-LP64E
; RUN: llc -mtriple=riscv64 -mattr=+f -target-abi lp64f -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I
; RUN: llc -mtriple=riscv64 -mattr=+d -target-abi lp64f -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I
; RUN: llc -mtriple=riscv64 -mattr=+d -target-abi lp64d -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I
; RUN: llc -mtriple=riscv64 -verify-machineinstrs -frame-pointer=all < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I-WITH-FP
; RUN: llc -mtriple=riscv64 -mattr=+zcmp -verify-machineinstrs < %s \
; RUN: | FileCheck %s -check-prefixes=RV64IZCMP
; RUN: llc -mtriple=riscv64 -mattr=+zcmp -verify-machineinstrs \
; RUN:  -frame-pointer=all < %s | FileCheck %s -check-prefixes=RV64IZCMP-WITH-FP

@var = global [32 x i32] zeroinitializer

; This function tests that RISCVRegisterInfo::getCalleeSavedRegs returns
; something appropriate.

define void @callee() nounwind {
; RV32I-LABEL: callee:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -80
; RV32I-NEXT:    sw ra, 76(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 72(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 68(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 64(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 60(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 56(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 52(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s6, 48(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s7, 44(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s8, 40(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s9, 36(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s10, 32(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s11, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lui a6, %hi(var)
; RV32I-NEXT:    lw a0, %lo(var)(a6)
; RV32I-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, %lo(var+4)(a6)
; RV32I-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, %lo(var+8)(a6)
; RV32I-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, %lo(var+12)(a6)
; RV32I-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi a5, a6, %lo(var)
; RV32I-NEXT:    lw a0, 16(a5)
; RV32I-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 20(a5)
; RV32I-NEXT:    sw a0, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw t0, 24(a5)
; RV32I-NEXT:    lw t1, 28(a5)
; RV32I-NEXT:    lw t2, 32(a5)
; RV32I-NEXT:    lw t3, 36(a5)
; RV32I-NEXT:    lw t4, 40(a5)
; RV32I-NEXT:    lw t5, 44(a5)
; RV32I-NEXT:    lw t6, 48(a5)
; RV32I-NEXT:    lw s0, 52(a5)
; RV32I-NEXT:    lw s1, 56(a5)
; RV32I-NEXT:    lw s2, 60(a5)
; RV32I-NEXT:    lw s3, 64(a5)
; RV32I-NEXT:    lw s4, 68(a5)
; RV32I-NEXT:    lw s5, 72(a5)
; RV32I-NEXT:    lw s6, 76(a5)
; RV32I-NEXT:    lw s7, 80(a5)
; RV32I-NEXT:    lw s8, 84(a5)
; RV32I-NEXT:    lw s9, 88(a5)
; RV32I-NEXT:    lw s10, 92(a5)
; RV32I-NEXT:    lw s11, 96(a5)
; RV32I-NEXT:    lw ra, 100(a5)
; RV32I-NEXT:    lw a7, 104(a5)
; RV32I-NEXT:    lw a4, 108(a5)
; RV32I-NEXT:    lw a0, 124(a5)
; RV32I-NEXT:    lw a1, 120(a5)
; RV32I-NEXT:    lw a2, 116(a5)
; RV32I-NEXT:    lw a3, 112(a5)
; RV32I-NEXT:    sw a0, 124(a5)
; RV32I-NEXT:    sw a1, 120(a5)
; RV32I-NEXT:    sw a2, 116(a5)
; RV32I-NEXT:    sw a3, 112(a5)
; RV32I-NEXT:    sw a4, 108(a5)
; RV32I-NEXT:    sw a7, 104(a5)
; RV32I-NEXT:    sw ra, 100(a5)
; RV32I-NEXT:    sw s11, 96(a5)
; RV32I-NEXT:    sw s10, 92(a5)
; RV32I-NEXT:    sw s9, 88(a5)
; RV32I-NEXT:    sw s8, 84(a5)
; RV32I-NEXT:    sw s7, 80(a5)
; RV32I-NEXT:    sw s6, 76(a5)
; RV32I-NEXT:    sw s5, 72(a5)
; RV32I-NEXT:    sw s4, 68(a5)
; RV32I-NEXT:    sw s3, 64(a5)
; RV32I-NEXT:    sw s2, 60(a5)
; RV32I-NEXT:    sw s1, 56(a5)
; RV32I-NEXT:    sw s0, 52(a5)
; RV32I-NEXT:    sw t6, 48(a5)
; RV32I-NEXT:    sw t5, 44(a5)
; RV32I-NEXT:    sw t4, 40(a5)
; RV32I-NEXT:    sw t3, 36(a5)
; RV32I-NEXT:    sw t2, 32(a5)
; RV32I-NEXT:    sw t1, 28(a5)
; RV32I-NEXT:    sw t0, 24(a5)
; RV32I-NEXT:    lw a0, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 20(a5)
; RV32I-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 16(a5)
; RV32I-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, %lo(var+12)(a6)
; RV32I-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, %lo(var+8)(a6)
; RV32I-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, %lo(var+4)(a6)
; RV32I-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, %lo(var)(a6)
; RV32I-NEXT:    lw ra, 76(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 72(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 68(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 64(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 60(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 56(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 52(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s6, 48(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s7, 44(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s8, 40(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s9, 36(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s10, 32(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s11, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 80
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: callee:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -48
; RV32I-ILP32E-NEXT:    sw ra, 44(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    sw s0, 40(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    sw s1, 36(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lui a6, %hi(var)
; RV32I-ILP32E-NEXT:    lw a0, %lo(var)(a6)
; RV32I-ILP32E-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, %lo(var+4)(a6)
; RV32I-ILP32E-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, %lo(var+8)(a6)
; RV32I-ILP32E-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, %lo(var+12)(a6)
; RV32I-ILP32E-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    addi a5, a6, %lo(var)
; RV32I-ILP32E-NEXT:    lw a0, 16(a5)
; RV32I-ILP32E-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 20(a5)
; RV32I-ILP32E-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw t0, 24(a5)
; RV32I-ILP32E-NEXT:    lw t1, 28(a5)
; RV32I-ILP32E-NEXT:    lw t2, 32(a5)
; RV32I-ILP32E-NEXT:    lw t3, 36(a5)
; RV32I-ILP32E-NEXT:    lw t4, 40(a5)
; RV32I-ILP32E-NEXT:    lw t5, 44(a5)
; RV32I-ILP32E-NEXT:    lw t6, 48(a5)
; RV32I-ILP32E-NEXT:    lw s2, 52(a5)
; RV32I-ILP32E-NEXT:    lw s3, 56(a5)
; RV32I-ILP32E-NEXT:    lw s4, 60(a5)
; RV32I-ILP32E-NEXT:    lw s5, 64(a5)
; RV32I-ILP32E-NEXT:    lw s6, 68(a5)
; RV32I-ILP32E-NEXT:    lw s7, 72(a5)
; RV32I-ILP32E-NEXT:    lw s8, 76(a5)
; RV32I-ILP32E-NEXT:    lw s9, 80(a5)
; RV32I-ILP32E-NEXT:    lw s10, 84(a5)
; RV32I-ILP32E-NEXT:    lw s11, 88(a5)
; RV32I-ILP32E-NEXT:    lw s0, 92(a5)
; RV32I-ILP32E-NEXT:    lw s1, 96(a5)
; RV32I-ILP32E-NEXT:    lw ra, 100(a5)
; RV32I-ILP32E-NEXT:    lw a7, 104(a5)
; RV32I-ILP32E-NEXT:    lw a4, 108(a5)
; RV32I-ILP32E-NEXT:    lw a0, 124(a5)
; RV32I-ILP32E-NEXT:    lw a1, 120(a5)
; RV32I-ILP32E-NEXT:    lw a2, 116(a5)
; RV32I-ILP32E-NEXT:    lw a3, 112(a5)
; RV32I-ILP32E-NEXT:    sw a0, 124(a5)
; RV32I-ILP32E-NEXT:    sw a1, 120(a5)
; RV32I-ILP32E-NEXT:    sw a2, 116(a5)
; RV32I-ILP32E-NEXT:    sw a3, 112(a5)
; RV32I-ILP32E-NEXT:    sw a4, 108(a5)
; RV32I-ILP32E-NEXT:    sw a7, 104(a5)
; RV32I-ILP32E-NEXT:    sw ra, 100(a5)
; RV32I-ILP32E-NEXT:    sw s1, 96(a5)
; RV32I-ILP32E-NEXT:    sw s0, 92(a5)
; RV32I-ILP32E-NEXT:    sw s11, 88(a5)
; RV32I-ILP32E-NEXT:    sw s10, 84(a5)
; RV32I-ILP32E-NEXT:    sw s9, 80(a5)
; RV32I-ILP32E-NEXT:    sw s8, 76(a5)
; RV32I-ILP32E-NEXT:    sw s7, 72(a5)
; RV32I-ILP32E-NEXT:    sw s6, 68(a5)
; RV32I-ILP32E-NEXT:    sw s5, 64(a5)
; RV32I-ILP32E-NEXT:    sw s4, 60(a5)
; RV32I-ILP32E-NEXT:    sw s3, 56(a5)
; RV32I-ILP32E-NEXT:    sw s2, 52(a5)
; RV32I-ILP32E-NEXT:    sw t6, 48(a5)
; RV32I-ILP32E-NEXT:    sw t5, 44(a5)
; RV32I-ILP32E-NEXT:    sw t4, 40(a5)
; RV32I-ILP32E-NEXT:    sw t3, 36(a5)
; RV32I-ILP32E-NEXT:    sw t2, 32(a5)
; RV32I-ILP32E-NEXT:    sw t1, 28(a5)
; RV32I-ILP32E-NEXT:    sw t0, 24(a5)
; RV32I-ILP32E-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 20(a5)
; RV32I-ILP32E-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 16(a5)
; RV32I-ILP32E-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, %lo(var+12)(a6)
; RV32I-ILP32E-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, %lo(var+8)(a6)
; RV32I-ILP32E-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, %lo(var+4)(a6)
; RV32I-ILP32E-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, %lo(var)(a6)
; RV32I-ILP32E-NEXT:    lw ra, 44(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    lw s0, 40(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    lw s1, 36(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    addi sp, sp, 48
; RV32I-ILP32E-NEXT:    ret
;
; RV32I-WITH-FP-LABEL: callee:
; RV32I-WITH-FP:       # %bb.0:
; RV32I-WITH-FP-NEXT:    addi sp, sp, -80
; RV32I-WITH-FP-NEXT:    sw ra, 76(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s0, 72(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s1, 68(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s2, 64(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s3, 60(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s4, 56(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s5, 52(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s6, 48(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s7, 44(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s8, 40(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s9, 36(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s10, 32(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s11, 28(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    addi s0, sp, 80
; RV32I-WITH-FP-NEXT:    lui a6, %hi(var)
; RV32I-WITH-FP-NEXT:    lw a0, %lo(var)(a6)
; RV32I-WITH-FP-NEXT:    sw a0, -56(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, %lo(var+4)(a6)
; RV32I-WITH-FP-NEXT:    sw a0, -60(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, %lo(var+8)(a6)
; RV32I-WITH-FP-NEXT:    sw a0, -64(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, %lo(var+12)(a6)
; RV32I-WITH-FP-NEXT:    sw a0, -68(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    addi a5, a6, %lo(var)
; RV32I-WITH-FP-NEXT:    lw a0, 16(a5)
; RV32I-WITH-FP-NEXT:    sw a0, -72(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 20(a5)
; RV32I-WITH-FP-NEXT:    sw a0, -76(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 24(a5)
; RV32I-WITH-FP-NEXT:    sw a0, -80(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw t1, 28(a5)
; RV32I-WITH-FP-NEXT:    lw t2, 32(a5)
; RV32I-WITH-FP-NEXT:    lw t3, 36(a5)
; RV32I-WITH-FP-NEXT:    lw t4, 40(a5)
; RV32I-WITH-FP-NEXT:    lw t5, 44(a5)
; RV32I-WITH-FP-NEXT:    lw t6, 48(a5)
; RV32I-WITH-FP-NEXT:    lw s1, 52(a5)
; RV32I-WITH-FP-NEXT:    lw s2, 56(a5)
; RV32I-WITH-FP-NEXT:    lw s3, 60(a5)
; RV32I-WITH-FP-NEXT:    lw s4, 64(a5)
; RV32I-WITH-FP-NEXT:    lw s5, 68(a5)
; RV32I-WITH-FP-NEXT:    lw s6, 72(a5)
; RV32I-WITH-FP-NEXT:    lw s7, 76(a5)
; RV32I-WITH-FP-NEXT:    lw s8, 80(a5)
; RV32I-WITH-FP-NEXT:    lw s9, 84(a5)
; RV32I-WITH-FP-NEXT:    lw s10, 88(a5)
; RV32I-WITH-FP-NEXT:    lw s11, 92(a5)
; RV32I-WITH-FP-NEXT:    lw ra, 96(a5)
; RV32I-WITH-FP-NEXT:    lw t0, 100(a5)
; RV32I-WITH-FP-NEXT:    lw a7, 104(a5)
; RV32I-WITH-FP-NEXT:    lw a4, 108(a5)
; RV32I-WITH-FP-NEXT:    lw a0, 124(a5)
; RV32I-WITH-FP-NEXT:    lw a1, 120(a5)
; RV32I-WITH-FP-NEXT:    lw a2, 116(a5)
; RV32I-WITH-FP-NEXT:    lw a3, 112(a5)
; RV32I-WITH-FP-NEXT:    sw a0, 124(a5)
; RV32I-WITH-FP-NEXT:    sw a1, 120(a5)
; RV32I-WITH-FP-NEXT:    sw a2, 116(a5)
; RV32I-WITH-FP-NEXT:    sw a3, 112(a5)
; RV32I-WITH-FP-NEXT:    sw a4, 108(a5)
; RV32I-WITH-FP-NEXT:    sw a7, 104(a5)
; RV32I-WITH-FP-NEXT:    sw t0, 100(a5)
; RV32I-WITH-FP-NEXT:    sw ra, 96(a5)
; RV32I-WITH-FP-NEXT:    sw s11, 92(a5)
; RV32I-WITH-FP-NEXT:    sw s10, 88(a5)
; RV32I-WITH-FP-NEXT:    sw s9, 84(a5)
; RV32I-WITH-FP-NEXT:    sw s8, 80(a5)
; RV32I-WITH-FP-NEXT:    sw s7, 76(a5)
; RV32I-WITH-FP-NEXT:    sw s6, 72(a5)
; RV32I-WITH-FP-NEXT:    sw s5, 68(a5)
; RV32I-WITH-FP-NEXT:    sw s4, 64(a5)
; RV32I-WITH-FP-NEXT:    sw s3, 60(a5)
; RV32I-WITH-FP-NEXT:    sw s2, 56(a5)
; RV32I-WITH-FP-NEXT:    sw s1, 52(a5)
; RV32I-WITH-FP-NEXT:    sw t6, 48(a5)
; RV32I-WITH-FP-NEXT:    sw t5, 44(a5)
; RV32I-WITH-FP-NEXT:    sw t4, 40(a5)
; RV32I-WITH-FP-NEXT:    sw t3, 36(a5)
; RV32I-WITH-FP-NEXT:    sw t2, 32(a5)
; RV32I-WITH-FP-NEXT:    sw t1, 28(a5)
; RV32I-WITH-FP-NEXT:    lw a0, -80(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 24(a5)
; RV32I-WITH-FP-NEXT:    lw a0, -76(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 20(a5)
; RV32I-WITH-FP-NEXT:    lw a0, -72(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 16(a5)
; RV32I-WITH-FP-NEXT:    lw a0, -68(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, %lo(var+12)(a6)
; RV32I-WITH-FP-NEXT:    lw a0, -64(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, %lo(var+8)(a6)
; RV32I-WITH-FP-NEXT:    lw a0, -60(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, %lo(var+4)(a6)
; RV32I-WITH-FP-NEXT:    lw a0, -56(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, %lo(var)(a6)
; RV32I-WITH-FP-NEXT:    lw ra, 76(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s0, 72(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s1, 68(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s2, 64(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s3, 60(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s4, 56(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s5, 52(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s6, 48(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s7, 44(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s8, 40(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s9, 36(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s10, 32(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s11, 28(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    addi sp, sp, 80
; RV32I-WITH-FP-NEXT:    ret
;
; RV32IZCMP-LABEL: callee:
; RV32IZCMP:       # %bb.0:
; RV32IZCMP-NEXT:    cm.push {ra, s0-s11}, -96
; RV32IZCMP-NEXT:    lui a6, %hi(var)
; RV32IZCMP-NEXT:    lw a0, %lo(var)(a6)
; RV32IZCMP-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, %lo(var+4)(a6)
; RV32IZCMP-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, %lo(var+8)(a6)
; RV32IZCMP-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, %lo(var+12)(a6)
; RV32IZCMP-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    addi a5, a6, %lo(var)
; RV32IZCMP-NEXT:    lw a0, 16(a5)
; RV32IZCMP-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 20(a5)
; RV32IZCMP-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw t4, 24(a5)
; RV32IZCMP-NEXT:    lw t5, 28(a5)
; RV32IZCMP-NEXT:    lw t6, 32(a5)
; RV32IZCMP-NEXT:    lw s2, 36(a5)
; RV32IZCMP-NEXT:    lw s3, 40(a5)
; RV32IZCMP-NEXT:    lw s4, 44(a5)
; RV32IZCMP-NEXT:    lw s5, 48(a5)
; RV32IZCMP-NEXT:    lw s6, 52(a5)
; RV32IZCMP-NEXT:    lw s7, 56(a5)
; RV32IZCMP-NEXT:    lw s8, 60(a5)
; RV32IZCMP-NEXT:    lw s9, 64(a5)
; RV32IZCMP-NEXT:    lw s10, 68(a5)
; RV32IZCMP-NEXT:    lw s11, 72(a5)
; RV32IZCMP-NEXT:    lw ra, 76(a5)
; RV32IZCMP-NEXT:    lw s1, 80(a5)
; RV32IZCMP-NEXT:    lw t3, 84(a5)
; RV32IZCMP-NEXT:    lw t2, 88(a5)
; RV32IZCMP-NEXT:    lw t1, 92(a5)
; RV32IZCMP-NEXT:    lw t0, 96(a5)
; RV32IZCMP-NEXT:    lw s0, 100(a5)
; RV32IZCMP-NEXT:    lw a7, 104(a5)
; RV32IZCMP-NEXT:    lw a4, 108(a5)
; RV32IZCMP-NEXT:    lw a0, 124(a5)
; RV32IZCMP-NEXT:    lw a1, 120(a5)
; RV32IZCMP-NEXT:    lw a2, 116(a5)
; RV32IZCMP-NEXT:    lw a3, 112(a5)
; RV32IZCMP-NEXT:    sw a0, 124(a5)
; RV32IZCMP-NEXT:    sw a1, 120(a5)
; RV32IZCMP-NEXT:    sw a2, 116(a5)
; RV32IZCMP-NEXT:    sw a3, 112(a5)
; RV32IZCMP-NEXT:    sw a4, 108(a5)
; RV32IZCMP-NEXT:    sw a7, 104(a5)
; RV32IZCMP-NEXT:    sw s0, 100(a5)
; RV32IZCMP-NEXT:    sw t0, 96(a5)
; RV32IZCMP-NEXT:    sw t1, 92(a5)
; RV32IZCMP-NEXT:    sw t2, 88(a5)
; RV32IZCMP-NEXT:    sw t3, 84(a5)
; RV32IZCMP-NEXT:    sw s1, 80(a5)
; RV32IZCMP-NEXT:    sw ra, 76(a5)
; RV32IZCMP-NEXT:    sw s11, 72(a5)
; RV32IZCMP-NEXT:    sw s10, 68(a5)
; RV32IZCMP-NEXT:    sw s9, 64(a5)
; RV32IZCMP-NEXT:    sw s8, 60(a5)
; RV32IZCMP-NEXT:    sw s7, 56(a5)
; RV32IZCMP-NEXT:    sw s6, 52(a5)
; RV32IZCMP-NEXT:    sw s5, 48(a5)
; RV32IZCMP-NEXT:    sw s4, 44(a5)
; RV32IZCMP-NEXT:    sw s3, 40(a5)
; RV32IZCMP-NEXT:    sw s2, 36(a5)
; RV32IZCMP-NEXT:    sw t6, 32(a5)
; RV32IZCMP-NEXT:    sw t5, 28(a5)
; RV32IZCMP-NEXT:    sw t4, 24(a5)
; RV32IZCMP-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 20(a5)
; RV32IZCMP-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 16(a5)
; RV32IZCMP-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, %lo(var+12)(a6)
; RV32IZCMP-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, %lo(var+8)(a6)
; RV32IZCMP-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, %lo(var+4)(a6)
; RV32IZCMP-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, %lo(var)(a6)
; RV32IZCMP-NEXT:    cm.popret {ra, s0-s11}, 96
;
; RV32IZCMP-WITH-FP-LABEL: callee:
; RV32IZCMP-WITH-FP:       # %bb.0:
; RV32IZCMP-WITH-FP-NEXT:    addi sp, sp, -80
; RV32IZCMP-WITH-FP-NEXT:    sw ra, 76(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s0, 72(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s1, 68(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s2, 64(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s3, 60(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s4, 56(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s5, 52(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s6, 48(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s7, 44(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s8, 40(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s9, 36(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s10, 32(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s11, 28(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    addi s0, sp, 80
; RV32IZCMP-WITH-FP-NEXT:    lui a6, %hi(var)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, %lo(var)(a6)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -56(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, %lo(var+4)(a6)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -60(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, %lo(var+8)(a6)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -64(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, %lo(var+12)(a6)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -68(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    addi a5, a6, %lo(var)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 16(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -72(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 20(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -76(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 24(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -80(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw t5, 28(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw t6, 32(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw s2, 36(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw s3, 40(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw s4, 44(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw s5, 48(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw s6, 52(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw s7, 56(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw s8, 60(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw s9, 64(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw s10, 68(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw s11, 72(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw ra, 76(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw t4, 80(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw t3, 84(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw t2, 88(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw s1, 92(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw t1, 96(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw t0, 100(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw a7, 104(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw a4, 108(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 124(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw a1, 120(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw a2, 116(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw a3, 112(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 124(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw a1, 120(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw a2, 116(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw a3, 112(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw a4, 108(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw a7, 104(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw t0, 100(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw t1, 96(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw s1, 92(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw t2, 88(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw t3, 84(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw t4, 80(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw ra, 76(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw s11, 72(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw s10, 68(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw s9, 64(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw s8, 60(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw s7, 56(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw s6, 52(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw s5, 48(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw s4, 44(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw s3, 40(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw s2, 36(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw t6, 32(a5)
; RV32IZCMP-WITH-FP-NEXT:    sw t5, 28(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -80(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 24(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -76(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 20(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -72(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 16(a5)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -68(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, %lo(var+12)(a6)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -64(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, %lo(var+8)(a6)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -60(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, %lo(var+4)(a6)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -56(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, %lo(var)(a6)
; RV32IZCMP-WITH-FP-NEXT:    lw ra, 76(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s0, 72(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s1, 68(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s2, 64(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s3, 60(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s4, 56(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s5, 52(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s6, 48(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s7, 44(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s8, 40(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s9, 36(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s10, 32(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s11, 28(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    addi sp, sp, 80
; RV32IZCMP-WITH-FP-NEXT:    ret
;
; RV64I-LABEL: callee:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -160
; RV64I-NEXT:    sd ra, 152(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 144(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 136(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 128(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 120(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s4, 112(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s5, 104(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s6, 96(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s7, 88(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s8, 80(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s9, 72(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s10, 64(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s11, 56(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lui a6, %hi(var)
; RV64I-NEXT:    lw a0, %lo(var)(a6)
; RV64I-NEXT:    sd a0, 48(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, %lo(var+4)(a6)
; RV64I-NEXT:    sd a0, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, %lo(var+8)(a6)
; RV64I-NEXT:    sd a0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, %lo(var+12)(a6)
; RV64I-NEXT:    sd a0, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi a5, a6, %lo(var)
; RV64I-NEXT:    lw a0, 16(a5)
; RV64I-NEXT:    sd a0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 20(a5)
; RV64I-NEXT:    sd a0, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw t0, 24(a5)
; RV64I-NEXT:    lw t1, 28(a5)
; RV64I-NEXT:    lw t2, 32(a5)
; RV64I-NEXT:    lw t3, 36(a5)
; RV64I-NEXT:    lw t4, 40(a5)
; RV64I-NEXT:    lw t5, 44(a5)
; RV64I-NEXT:    lw t6, 48(a5)
; RV64I-NEXT:    lw s0, 52(a5)
; RV64I-NEXT:    lw s1, 56(a5)
; RV64I-NEXT:    lw s2, 60(a5)
; RV64I-NEXT:    lw s3, 64(a5)
; RV64I-NEXT:    lw s4, 68(a5)
; RV64I-NEXT:    lw s5, 72(a5)
; RV64I-NEXT:    lw s6, 76(a5)
; RV64I-NEXT:    lw s7, 80(a5)
; RV64I-NEXT:    lw s8, 84(a5)
; RV64I-NEXT:    lw s9, 88(a5)
; RV64I-NEXT:    lw s10, 92(a5)
; RV64I-NEXT:    lw s11, 96(a5)
; RV64I-NEXT:    lw ra, 100(a5)
; RV64I-NEXT:    lw a7, 104(a5)
; RV64I-NEXT:    lw a4, 108(a5)
; RV64I-NEXT:    lw a0, 124(a5)
; RV64I-NEXT:    lw a1, 120(a5)
; RV64I-NEXT:    lw a2, 116(a5)
; RV64I-NEXT:    lw a3, 112(a5)
; RV64I-NEXT:    sw a0, 124(a5)
; RV64I-NEXT:    sw a1, 120(a5)
; RV64I-NEXT:    sw a2, 116(a5)
; RV64I-NEXT:    sw a3, 112(a5)
; RV64I-NEXT:    sw a4, 108(a5)
; RV64I-NEXT:    sw a7, 104(a5)
; RV64I-NEXT:    sw ra, 100(a5)
; RV64I-NEXT:    sw s11, 96(a5)
; RV64I-NEXT:    sw s10, 92(a5)
; RV64I-NEXT:    sw s9, 88(a5)
; RV64I-NEXT:    sw s8, 84(a5)
; RV64I-NEXT:    sw s7, 80(a5)
; RV64I-NEXT:    sw s6, 76(a5)
; RV64I-NEXT:    sw s5, 72(a5)
; RV64I-NEXT:    sw s4, 68(a5)
; RV64I-NEXT:    sw s3, 64(a5)
; RV64I-NEXT:    sw s2, 60(a5)
; RV64I-NEXT:    sw s1, 56(a5)
; RV64I-NEXT:    sw s0, 52(a5)
; RV64I-NEXT:    sw t6, 48(a5)
; RV64I-NEXT:    sw t5, 44(a5)
; RV64I-NEXT:    sw t4, 40(a5)
; RV64I-NEXT:    sw t3, 36(a5)
; RV64I-NEXT:    sw t2, 32(a5)
; RV64I-NEXT:    sw t1, 28(a5)
; RV64I-NEXT:    sw t0, 24(a5)
; RV64I-NEXT:    ld a0, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 20(a5)
; RV64I-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 16(a5)
; RV64I-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, %lo(var+12)(a6)
; RV64I-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, %lo(var+8)(a6)
; RV64I-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, %lo(var+4)(a6)
; RV64I-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, %lo(var)(a6)
; RV64I-NEXT:    ld ra, 152(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 144(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 136(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 128(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 120(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s4, 112(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s5, 104(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s6, 96(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s7, 88(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s8, 80(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s9, 72(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s10, 64(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s11, 56(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 160
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: callee:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -80
; RV64I-LP64E-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    sd s0, 64(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    sd s1, 56(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lui a6, %hi(var)
; RV64I-LP64E-NEXT:    lw a0, %lo(var)(a6)
; RV64I-LP64E-NEXT:    sd a0, 48(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, %lo(var+4)(a6)
; RV64I-LP64E-NEXT:    sd a0, 40(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, %lo(var+8)(a6)
; RV64I-LP64E-NEXT:    sd a0, 32(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, %lo(var+12)(a6)
; RV64I-LP64E-NEXT:    sd a0, 24(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    addi a5, a6, %lo(var)
; RV64I-LP64E-NEXT:    lw a0, 16(a5)
; RV64I-LP64E-NEXT:    sd a0, 16(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 20(a5)
; RV64I-LP64E-NEXT:    sd a0, 8(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw t0, 24(a5)
; RV64I-LP64E-NEXT:    lw t1, 28(a5)
; RV64I-LP64E-NEXT:    lw t2, 32(a5)
; RV64I-LP64E-NEXT:    lw t3, 36(a5)
; RV64I-LP64E-NEXT:    lw t4, 40(a5)
; RV64I-LP64E-NEXT:    lw t5, 44(a5)
; RV64I-LP64E-NEXT:    lw t6, 48(a5)
; RV64I-LP64E-NEXT:    lw s2, 52(a5)
; RV64I-LP64E-NEXT:    lw s3, 56(a5)
; RV64I-LP64E-NEXT:    lw s4, 60(a5)
; RV64I-LP64E-NEXT:    lw s5, 64(a5)
; RV64I-LP64E-NEXT:    lw s6, 68(a5)
; RV64I-LP64E-NEXT:    lw s7, 72(a5)
; RV64I-LP64E-NEXT:    lw s8, 76(a5)
; RV64I-LP64E-NEXT:    lw s9, 80(a5)
; RV64I-LP64E-NEXT:    lw s10, 84(a5)
; RV64I-LP64E-NEXT:    lw s11, 88(a5)
; RV64I-LP64E-NEXT:    lw s0, 92(a5)
; RV64I-LP64E-NEXT:    lw s1, 96(a5)
; RV64I-LP64E-NEXT:    lw ra, 100(a5)
; RV64I-LP64E-NEXT:    lw a7, 104(a5)
; RV64I-LP64E-NEXT:    lw a4, 108(a5)
; RV64I-LP64E-NEXT:    lw a0, 124(a5)
; RV64I-LP64E-NEXT:    lw a1, 120(a5)
; RV64I-LP64E-NEXT:    lw a2, 116(a5)
; RV64I-LP64E-NEXT:    lw a3, 112(a5)
; RV64I-LP64E-NEXT:    sw a0, 124(a5)
; RV64I-LP64E-NEXT:    sw a1, 120(a5)
; RV64I-LP64E-NEXT:    sw a2, 116(a5)
; RV64I-LP64E-NEXT:    sw a3, 112(a5)
; RV64I-LP64E-NEXT:    sw a4, 108(a5)
; RV64I-LP64E-NEXT:    sw a7, 104(a5)
; RV64I-LP64E-NEXT:    sw ra, 100(a5)
; RV64I-LP64E-NEXT:    sw s1, 96(a5)
; RV64I-LP64E-NEXT:    sw s0, 92(a5)
; RV64I-LP64E-NEXT:    sw s11, 88(a5)
; RV64I-LP64E-NEXT:    sw s10, 84(a5)
; RV64I-LP64E-NEXT:    sw s9, 80(a5)
; RV64I-LP64E-NEXT:    sw s8, 76(a5)
; RV64I-LP64E-NEXT:    sw s7, 72(a5)
; RV64I-LP64E-NEXT:    sw s6, 68(a5)
; RV64I-LP64E-NEXT:    sw s5, 64(a5)
; RV64I-LP64E-NEXT:    sw s4, 60(a5)
; RV64I-LP64E-NEXT:    sw s3, 56(a5)
; RV64I-LP64E-NEXT:    sw s2, 52(a5)
; RV64I-LP64E-NEXT:    sw t6, 48(a5)
; RV64I-LP64E-NEXT:    sw t5, 44(a5)
; RV64I-LP64E-NEXT:    sw t4, 40(a5)
; RV64I-LP64E-NEXT:    sw t3, 36(a5)
; RV64I-LP64E-NEXT:    sw t2, 32(a5)
; RV64I-LP64E-NEXT:    sw t1, 28(a5)
; RV64I-LP64E-NEXT:    sw t0, 24(a5)
; RV64I-LP64E-NEXT:    ld a0, 8(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 20(a5)
; RV64I-LP64E-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 16(a5)
; RV64I-LP64E-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, %lo(var+12)(a6)
; RV64I-LP64E-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, %lo(var+8)(a6)
; RV64I-LP64E-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, %lo(var+4)(a6)
; RV64I-LP64E-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, %lo(var)(a6)
; RV64I-LP64E-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    ld s0, 64(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    ld s1, 56(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    addi sp, sp, 80
; RV64I-LP64E-NEXT:    ret
;
; RV64I-WITH-FP-LABEL: callee:
; RV64I-WITH-FP:       # %bb.0:
; RV64I-WITH-FP-NEXT:    addi sp, sp, -160
; RV64I-WITH-FP-NEXT:    sd ra, 152(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s0, 144(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s1, 136(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s2, 128(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s3, 120(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s4, 112(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s5, 104(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s6, 96(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s7, 88(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s8, 80(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s9, 72(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s10, 64(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s11, 56(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    addi s0, sp, 160
; RV64I-WITH-FP-NEXT:    lui a6, %hi(var)
; RV64I-WITH-FP-NEXT:    lw a0, %lo(var)(a6)
; RV64I-WITH-FP-NEXT:    sd a0, -112(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, %lo(var+4)(a6)
; RV64I-WITH-FP-NEXT:    sd a0, -120(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, %lo(var+8)(a6)
; RV64I-WITH-FP-NEXT:    sd a0, -128(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, %lo(var+12)(a6)
; RV64I-WITH-FP-NEXT:    sd a0, -136(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    addi a5, a6, %lo(var)
; RV64I-WITH-FP-NEXT:    lw a0, 16(a5)
; RV64I-WITH-FP-NEXT:    sd a0, -144(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 20(a5)
; RV64I-WITH-FP-NEXT:    sd a0, -152(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 24(a5)
; RV64I-WITH-FP-NEXT:    sd a0, -160(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw t1, 28(a5)
; RV64I-WITH-FP-NEXT:    lw t2, 32(a5)
; RV64I-WITH-FP-NEXT:    lw t3, 36(a5)
; RV64I-WITH-FP-NEXT:    lw t4, 40(a5)
; RV64I-WITH-FP-NEXT:    lw t5, 44(a5)
; RV64I-WITH-FP-NEXT:    lw t6, 48(a5)
; RV64I-WITH-FP-NEXT:    lw s1, 52(a5)
; RV64I-WITH-FP-NEXT:    lw s2, 56(a5)
; RV64I-WITH-FP-NEXT:    lw s3, 60(a5)
; RV64I-WITH-FP-NEXT:    lw s4, 64(a5)
; RV64I-WITH-FP-NEXT:    lw s5, 68(a5)
; RV64I-WITH-FP-NEXT:    lw s6, 72(a5)
; RV64I-WITH-FP-NEXT:    lw s7, 76(a5)
; RV64I-WITH-FP-NEXT:    lw s8, 80(a5)
; RV64I-WITH-FP-NEXT:    lw s9, 84(a5)
; RV64I-WITH-FP-NEXT:    lw s10, 88(a5)
; RV64I-WITH-FP-NEXT:    lw s11, 92(a5)
; RV64I-WITH-FP-NEXT:    lw ra, 96(a5)
; RV64I-WITH-FP-NEXT:    lw t0, 100(a5)
; RV64I-WITH-FP-NEXT:    lw a7, 104(a5)
; RV64I-WITH-FP-NEXT:    lw a4, 108(a5)
; RV64I-WITH-FP-NEXT:    lw a0, 124(a5)
; RV64I-WITH-FP-NEXT:    lw a1, 120(a5)
; RV64I-WITH-FP-NEXT:    lw a2, 116(a5)
; RV64I-WITH-FP-NEXT:    lw a3, 112(a5)
; RV64I-WITH-FP-NEXT:    sw a0, 124(a5)
; RV64I-WITH-FP-NEXT:    sw a1, 120(a5)
; RV64I-WITH-FP-NEXT:    sw a2, 116(a5)
; RV64I-WITH-FP-NEXT:    sw a3, 112(a5)
; RV64I-WITH-FP-NEXT:    sw a4, 108(a5)
; RV64I-WITH-FP-NEXT:    sw a7, 104(a5)
; RV64I-WITH-FP-NEXT:    sw t0, 100(a5)
; RV64I-WITH-FP-NEXT:    sw ra, 96(a5)
; RV64I-WITH-FP-NEXT:    sw s11, 92(a5)
; RV64I-WITH-FP-NEXT:    sw s10, 88(a5)
; RV64I-WITH-FP-NEXT:    sw s9, 84(a5)
; RV64I-WITH-FP-NEXT:    sw s8, 80(a5)
; RV64I-WITH-FP-NEXT:    sw s7, 76(a5)
; RV64I-WITH-FP-NEXT:    sw s6, 72(a5)
; RV64I-WITH-FP-NEXT:    sw s5, 68(a5)
; RV64I-WITH-FP-NEXT:    sw s4, 64(a5)
; RV64I-WITH-FP-NEXT:    sw s3, 60(a5)
; RV64I-WITH-FP-NEXT:    sw s2, 56(a5)
; RV64I-WITH-FP-NEXT:    sw s1, 52(a5)
; RV64I-WITH-FP-NEXT:    sw t6, 48(a5)
; RV64I-WITH-FP-NEXT:    sw t5, 44(a5)
; RV64I-WITH-FP-NEXT:    sw t4, 40(a5)
; RV64I-WITH-FP-NEXT:    sw t3, 36(a5)
; RV64I-WITH-FP-NEXT:    sw t2, 32(a5)
; RV64I-WITH-FP-NEXT:    sw t1, 28(a5)
; RV64I-WITH-FP-NEXT:    ld a0, -160(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 24(a5)
; RV64I-WITH-FP-NEXT:    ld a0, -152(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 20(a5)
; RV64I-WITH-FP-NEXT:    ld a0, -144(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 16(a5)
; RV64I-WITH-FP-NEXT:    ld a0, -136(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, %lo(var+12)(a6)
; RV64I-WITH-FP-NEXT:    ld a0, -128(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, %lo(var+8)(a6)
; RV64I-WITH-FP-NEXT:    ld a0, -120(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, %lo(var+4)(a6)
; RV64I-WITH-FP-NEXT:    ld a0, -112(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, %lo(var)(a6)
; RV64I-WITH-FP-NEXT:    ld ra, 152(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s0, 144(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s1, 136(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s2, 128(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s3, 120(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s4, 112(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s5, 104(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s6, 96(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s7, 88(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s8, 80(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s9, 72(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s10, 64(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s11, 56(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    addi sp, sp, 160
; RV64I-WITH-FP-NEXT:    ret
;
; RV64IZCMP-LABEL: callee:
; RV64IZCMP:       # %bb.0:
; RV64IZCMP-NEXT:    cm.push {ra, s0-s11}, -160
; RV64IZCMP-NEXT:    lui a6, %hi(var)
; RV64IZCMP-NEXT:    lw a0, %lo(var)(a6)
; RV64IZCMP-NEXT:    sd a0, 40(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, %lo(var+4)(a6)
; RV64IZCMP-NEXT:    sd a0, 32(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, %lo(var+8)(a6)
; RV64IZCMP-NEXT:    sd a0, 24(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, %lo(var+12)(a6)
; RV64IZCMP-NEXT:    sd a0, 16(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    addi a5, a6, %lo(var)
; RV64IZCMP-NEXT:    lw a0, 16(a5)
; RV64IZCMP-NEXT:    sd a0, 8(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 20(a5)
; RV64IZCMP-NEXT:    sd a0, 0(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw t4, 24(a5)
; RV64IZCMP-NEXT:    lw t5, 28(a5)
; RV64IZCMP-NEXT:    lw t6, 32(a5)
; RV64IZCMP-NEXT:    lw s2, 36(a5)
; RV64IZCMP-NEXT:    lw s3, 40(a5)
; RV64IZCMP-NEXT:    lw s4, 44(a5)
; RV64IZCMP-NEXT:    lw s5, 48(a5)
; RV64IZCMP-NEXT:    lw s6, 52(a5)
; RV64IZCMP-NEXT:    lw s7, 56(a5)
; RV64IZCMP-NEXT:    lw s8, 60(a5)
; RV64IZCMP-NEXT:    lw s9, 64(a5)
; RV64IZCMP-NEXT:    lw s10, 68(a5)
; RV64IZCMP-NEXT:    lw s11, 72(a5)
; RV64IZCMP-NEXT:    lw ra, 76(a5)
; RV64IZCMP-NEXT:    lw s1, 80(a5)
; RV64IZCMP-NEXT:    lw t3, 84(a5)
; RV64IZCMP-NEXT:    lw t2, 88(a5)
; RV64IZCMP-NEXT:    lw t1, 92(a5)
; RV64IZCMP-NEXT:    lw t0, 96(a5)
; RV64IZCMP-NEXT:    lw s0, 100(a5)
; RV64IZCMP-NEXT:    lw a7, 104(a5)
; RV64IZCMP-NEXT:    lw a4, 108(a5)
; RV64IZCMP-NEXT:    lw a0, 124(a5)
; RV64IZCMP-NEXT:    lw a1, 120(a5)
; RV64IZCMP-NEXT:    lw a2, 116(a5)
; RV64IZCMP-NEXT:    lw a3, 112(a5)
; RV64IZCMP-NEXT:    sw a0, 124(a5)
; RV64IZCMP-NEXT:    sw a1, 120(a5)
; RV64IZCMP-NEXT:    sw a2, 116(a5)
; RV64IZCMP-NEXT:    sw a3, 112(a5)
; RV64IZCMP-NEXT:    sw a4, 108(a5)
; RV64IZCMP-NEXT:    sw a7, 104(a5)
; RV64IZCMP-NEXT:    sw s0, 100(a5)
; RV64IZCMP-NEXT:    sw t0, 96(a5)
; RV64IZCMP-NEXT:    sw t1, 92(a5)
; RV64IZCMP-NEXT:    sw t2, 88(a5)
; RV64IZCMP-NEXT:    sw t3, 84(a5)
; RV64IZCMP-NEXT:    sw s1, 80(a5)
; RV64IZCMP-NEXT:    sw ra, 76(a5)
; RV64IZCMP-NEXT:    sw s11, 72(a5)
; RV64IZCMP-NEXT:    sw s10, 68(a5)
; RV64IZCMP-NEXT:    sw s9, 64(a5)
; RV64IZCMP-NEXT:    sw s8, 60(a5)
; RV64IZCMP-NEXT:    sw s7, 56(a5)
; RV64IZCMP-NEXT:    sw s6, 52(a5)
; RV64IZCMP-NEXT:    sw s5, 48(a5)
; RV64IZCMP-NEXT:    sw s4, 44(a5)
; RV64IZCMP-NEXT:    sw s3, 40(a5)
; RV64IZCMP-NEXT:    sw s2, 36(a5)
; RV64IZCMP-NEXT:    sw t6, 32(a5)
; RV64IZCMP-NEXT:    sw t5, 28(a5)
; RV64IZCMP-NEXT:    sw t4, 24(a5)
; RV64IZCMP-NEXT:    ld a0, 0(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 20(a5)
; RV64IZCMP-NEXT:    ld a0, 8(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 16(a5)
; RV64IZCMP-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, %lo(var+12)(a6)
; RV64IZCMP-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, %lo(var+8)(a6)
; RV64IZCMP-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, %lo(var+4)(a6)
; RV64IZCMP-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, %lo(var)(a6)
; RV64IZCMP-NEXT:    cm.popret {ra, s0-s11}, 160
;
; RV64IZCMP-WITH-FP-LABEL: callee:
; RV64IZCMP-WITH-FP:       # %bb.0:
; RV64IZCMP-WITH-FP-NEXT:    addi sp, sp, -160
; RV64IZCMP-WITH-FP-NEXT:    sd ra, 152(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s0, 144(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s1, 136(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s2, 128(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s3, 120(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s4, 112(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s5, 104(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s6, 96(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s7, 88(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s8, 80(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s9, 72(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s10, 64(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s11, 56(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    addi s0, sp, 160
; RV64IZCMP-WITH-FP-NEXT:    lui a6, %hi(var)
; RV64IZCMP-WITH-FP-NEXT:    lw a0, %lo(var)(a6)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -112(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, %lo(var+4)(a6)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -120(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, %lo(var+8)(a6)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -128(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, %lo(var+12)(a6)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -136(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    addi a5, a6, %lo(var)
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 16(a5)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -144(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 20(a5)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -152(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 24(a5)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -160(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw t5, 28(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw t6, 32(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw s2, 36(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw s3, 40(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw s4, 44(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw s5, 48(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw s6, 52(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw s7, 56(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw s8, 60(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw s9, 64(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw s10, 68(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw s11, 72(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw ra, 76(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw t4, 80(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw t3, 84(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw t2, 88(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw s1, 92(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw t1, 96(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw t0, 100(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw a7, 104(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw a4, 108(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 124(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw a1, 120(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw a2, 116(a5)
; RV64IZCMP-WITH-FP-NEXT:    lw a3, 112(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 124(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw a1, 120(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw a2, 116(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw a3, 112(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw a4, 108(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw a7, 104(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw t0, 100(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw t1, 96(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw s1, 92(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw t2, 88(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw t3, 84(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw t4, 80(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw ra, 76(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw s11, 72(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw s10, 68(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw s9, 64(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw s8, 60(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw s7, 56(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw s6, 52(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw s5, 48(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw s4, 44(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw s3, 40(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw s2, 36(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw t6, 32(a5)
; RV64IZCMP-WITH-FP-NEXT:    sw t5, 28(a5)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -160(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 24(a5)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -152(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 20(a5)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -144(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 16(a5)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -136(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, %lo(var+12)(a6)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -128(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, %lo(var+8)(a6)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -120(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, %lo(var+4)(a6)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -112(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, %lo(var)(a6)
; RV64IZCMP-WITH-FP-NEXT:    ld ra, 152(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s0, 144(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s1, 136(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s2, 128(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s3, 120(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s4, 112(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s5, 104(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s6, 96(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s7, 88(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s8, 80(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s9, 72(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s10, 64(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s11, 56(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    addi sp, sp, 160
; RV64IZCMP-WITH-FP-NEXT:    ret
  %val = load [32 x i32], ptr @var
  store volatile [32 x i32] %val, ptr @var
  ret void
}

; This function tests that RISCVRegisterInfo::getCallPreservedMask returns
; something appropriate.

define void @caller() nounwind {
; RV32I-LABEL: caller:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -144
; RV32I-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 136(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 132(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 128(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 124(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 120(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 116(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s6, 112(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s7, 108(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s8, 104(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s9, 100(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s10, 96(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s11, 92(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lui s0, %hi(var)
; RV32I-NEXT:    lw a0, %lo(var)(s0)
; RV32I-NEXT:    sw a0, 88(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, %lo(var+4)(s0)
; RV32I-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, %lo(var+8)(s0)
; RV32I-NEXT:    sw a0, 80(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, %lo(var+12)(s0)
; RV32I-NEXT:    sw a0, 76(sp) # 4-byte Folded Spill
; RV32I-NEXT:    addi s5, s0, %lo(var)
; RV32I-NEXT:    lw a0, 16(s5)
; RV32I-NEXT:    sw a0, 72(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 20(s5)
; RV32I-NEXT:    sw a0, 68(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 24(s5)
; RV32I-NEXT:    sw a0, 64(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 28(s5)
; RV32I-NEXT:    sw a0, 60(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 32(s5)
; RV32I-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 36(s5)
; RV32I-NEXT:    sw a0, 52(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 40(s5)
; RV32I-NEXT:    sw a0, 48(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 44(s5)
; RV32I-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 48(s5)
; RV32I-NEXT:    sw a0, 40(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 52(s5)
; RV32I-NEXT:    sw a0, 36(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 56(s5)
; RV32I-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 60(s5)
; RV32I-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 64(s5)
; RV32I-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 68(s5)
; RV32I-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 72(s5)
; RV32I-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 76(s5)
; RV32I-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 80(s5)
; RV32I-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw a0, 84(s5)
; RV32I-NEXT:    sw a0, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    lw s3, 88(s5)
; RV32I-NEXT:    lw s4, 92(s5)
; RV32I-NEXT:    lw s6, 96(s5)
; RV32I-NEXT:    lw s7, 100(s5)
; RV32I-NEXT:    lw s8, 104(s5)
; RV32I-NEXT:    lw s9, 108(s5)
; RV32I-NEXT:    lw s10, 112(s5)
; RV32I-NEXT:    lw s11, 116(s5)
; RV32I-NEXT:    lw s1, 120(s5)
; RV32I-NEXT:    lw s2, 124(s5)
; RV32I-NEXT:    call callee
; RV32I-NEXT:    sw s2, 124(s5)
; RV32I-NEXT:    sw s1, 120(s5)
; RV32I-NEXT:    sw s11, 116(s5)
; RV32I-NEXT:    sw s10, 112(s5)
; RV32I-NEXT:    sw s9, 108(s5)
; RV32I-NEXT:    sw s8, 104(s5)
; RV32I-NEXT:    sw s7, 100(s5)
; RV32I-NEXT:    sw s6, 96(s5)
; RV32I-NEXT:    sw s4, 92(s5)
; RV32I-NEXT:    sw s3, 88(s5)
; RV32I-NEXT:    lw a0, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 84(s5)
; RV32I-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 80(s5)
; RV32I-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 76(s5)
; RV32I-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 72(s5)
; RV32I-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 68(s5)
; RV32I-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 64(s5)
; RV32I-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 60(s5)
; RV32I-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 56(s5)
; RV32I-NEXT:    lw a0, 36(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 52(s5)
; RV32I-NEXT:    lw a0, 40(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 48(s5)
; RV32I-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 44(s5)
; RV32I-NEXT:    lw a0, 48(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 40(s5)
; RV32I-NEXT:    lw a0, 52(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 36(s5)
; RV32I-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 32(s5)
; RV32I-NEXT:    lw a0, 60(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 28(s5)
; RV32I-NEXT:    lw a0, 64(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 24(s5)
; RV32I-NEXT:    lw a0, 68(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 20(s5)
; RV32I-NEXT:    lw a0, 72(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, 16(s5)
; RV32I-NEXT:    lw a0, 76(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, %lo(var+12)(s0)
; RV32I-NEXT:    lw a0, 80(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, %lo(var+8)(s0)
; RV32I-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, %lo(var+4)(s0)
; RV32I-NEXT:    lw a0, 88(sp) # 4-byte Folded Reload
; RV32I-NEXT:    sw a0, %lo(var)(s0)
; RV32I-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 136(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 132(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 128(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 124(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 120(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 116(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s6, 112(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s7, 108(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s8, 104(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s9, 100(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s10, 96(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s11, 92(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 144
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: caller:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -136
; RV32I-ILP32E-NEXT:    sw ra, 132(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    sw s0, 128(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    sw s1, 124(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lui a0, %hi(var)
; RV32I-ILP32E-NEXT:    lw a1, %lo(var)(a0)
; RV32I-ILP32E-NEXT:    sw a1, 120(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a1, %lo(var+4)(a0)
; RV32I-ILP32E-NEXT:    sw a1, 116(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a1, %lo(var+8)(a0)
; RV32I-ILP32E-NEXT:    sw a1, 112(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a1, %lo(var+12)(a0)
; RV32I-ILP32E-NEXT:    sw a1, 108(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    addi s1, a0, %lo(var)
; RV32I-ILP32E-NEXT:    lw a0, 16(s1)
; RV32I-ILP32E-NEXT:    sw a0, 104(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 20(s1)
; RV32I-ILP32E-NEXT:    sw a0, 100(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 24(s1)
; RV32I-ILP32E-NEXT:    sw a0, 96(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 28(s1)
; RV32I-ILP32E-NEXT:    sw a0, 92(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 32(s1)
; RV32I-ILP32E-NEXT:    sw a0, 88(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 36(s1)
; RV32I-ILP32E-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 40(s1)
; RV32I-ILP32E-NEXT:    sw a0, 80(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 44(s1)
; RV32I-ILP32E-NEXT:    sw a0, 76(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 48(s1)
; RV32I-ILP32E-NEXT:    sw a0, 72(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 52(s1)
; RV32I-ILP32E-NEXT:    sw a0, 68(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 56(s1)
; RV32I-ILP32E-NEXT:    sw a0, 64(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 60(s1)
; RV32I-ILP32E-NEXT:    sw a0, 60(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 64(s1)
; RV32I-ILP32E-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 68(s1)
; RV32I-ILP32E-NEXT:    sw a0, 52(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 72(s1)
; RV32I-ILP32E-NEXT:    sw a0, 48(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 76(s1)
; RV32I-ILP32E-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 80(s1)
; RV32I-ILP32E-NEXT:    sw a0, 40(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 84(s1)
; RV32I-ILP32E-NEXT:    sw a0, 36(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 88(s1)
; RV32I-ILP32E-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 92(s1)
; RV32I-ILP32E-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 96(s1)
; RV32I-ILP32E-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 100(s1)
; RV32I-ILP32E-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 104(s1)
; RV32I-ILP32E-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 108(s1)
; RV32I-ILP32E-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 112(s1)
; RV32I-ILP32E-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 116(s1)
; RV32I-ILP32E-NEXT:    sw a0, 4(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw a0, 120(s1)
; RV32I-ILP32E-NEXT:    sw a0, 0(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    lw s0, 124(s1)
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    sw s0, 124(s1)
; RV32I-ILP32E-NEXT:    lw a0, 0(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 120(s1)
; RV32I-ILP32E-NEXT:    lw a0, 4(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 116(s1)
; RV32I-ILP32E-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 112(s1)
; RV32I-ILP32E-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 108(s1)
; RV32I-ILP32E-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 104(s1)
; RV32I-ILP32E-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 100(s1)
; RV32I-ILP32E-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 96(s1)
; RV32I-ILP32E-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 92(s1)
; RV32I-ILP32E-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 88(s1)
; RV32I-ILP32E-NEXT:    lw a0, 36(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 84(s1)
; RV32I-ILP32E-NEXT:    lw a0, 40(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 80(s1)
; RV32I-ILP32E-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 76(s1)
; RV32I-ILP32E-NEXT:    lw a0, 48(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 72(s1)
; RV32I-ILP32E-NEXT:    lw a0, 52(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 68(s1)
; RV32I-ILP32E-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 64(s1)
; RV32I-ILP32E-NEXT:    lw a0, 60(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 60(s1)
; RV32I-ILP32E-NEXT:    lw a0, 64(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 56(s1)
; RV32I-ILP32E-NEXT:    lw a0, 68(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 52(s1)
; RV32I-ILP32E-NEXT:    lw a0, 72(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 48(s1)
; RV32I-ILP32E-NEXT:    lw a0, 76(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 44(s1)
; RV32I-ILP32E-NEXT:    lw a0, 80(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 40(s1)
; RV32I-ILP32E-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 36(s1)
; RV32I-ILP32E-NEXT:    lw a0, 88(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 32(s1)
; RV32I-ILP32E-NEXT:    lw a0, 92(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 28(s1)
; RV32I-ILP32E-NEXT:    lw a0, 96(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 24(s1)
; RV32I-ILP32E-NEXT:    lw a0, 100(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 20(s1)
; RV32I-ILP32E-NEXT:    lw a0, 104(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, 16(s1)
; RV32I-ILP32E-NEXT:    lui a1, %hi(var)
; RV32I-ILP32E-NEXT:    lw a0, 108(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, %lo(var+12)(a1)
; RV32I-ILP32E-NEXT:    lw a0, 112(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, %lo(var+8)(a1)
; RV32I-ILP32E-NEXT:    lw a0, 116(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, %lo(var+4)(a1)
; RV32I-ILP32E-NEXT:    lw a0, 120(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    sw a0, %lo(var)(a1)
; RV32I-ILP32E-NEXT:    lw ra, 132(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    lw s0, 128(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    lw s1, 124(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    addi sp, sp, 136
; RV32I-ILP32E-NEXT:    ret
;
; RV32I-WITH-FP-LABEL: caller:
; RV32I-WITH-FP:       # %bb.0:
; RV32I-WITH-FP-NEXT:    addi sp, sp, -144
; RV32I-WITH-FP-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s0, 136(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s1, 132(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s2, 128(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s3, 124(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s4, 120(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s5, 116(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s6, 112(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s7, 108(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s8, 104(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s9, 100(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s10, 96(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s11, 92(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    addi s0, sp, 144
; RV32I-WITH-FP-NEXT:    lui s1, %hi(var)
; RV32I-WITH-FP-NEXT:    lw a0, %lo(var)(s1)
; RV32I-WITH-FP-NEXT:    sw a0, -56(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, %lo(var+4)(s1)
; RV32I-WITH-FP-NEXT:    sw a0, -60(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, %lo(var+8)(s1)
; RV32I-WITH-FP-NEXT:    sw a0, -64(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, %lo(var+12)(s1)
; RV32I-WITH-FP-NEXT:    sw a0, -68(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    addi s6, s1, %lo(var)
; RV32I-WITH-FP-NEXT:    lw a0, 16(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -72(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 20(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -76(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 24(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -80(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 28(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -84(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 32(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -88(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 36(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -92(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 40(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -96(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 44(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -100(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 48(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -104(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 52(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -108(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 56(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -112(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 60(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -116(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 64(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -120(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 68(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -124(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 72(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -128(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 76(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -132(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 80(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -136(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 84(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -140(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw a0, 88(s6)
; RV32I-WITH-FP-NEXT:    sw a0, -144(s0) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    lw s8, 92(s6)
; RV32I-WITH-FP-NEXT:    lw s9, 96(s6)
; RV32I-WITH-FP-NEXT:    lw s10, 100(s6)
; RV32I-WITH-FP-NEXT:    lw s11, 104(s6)
; RV32I-WITH-FP-NEXT:    lw s2, 108(s6)
; RV32I-WITH-FP-NEXT:    lw s3, 112(s6)
; RV32I-WITH-FP-NEXT:    lw s4, 116(s6)
; RV32I-WITH-FP-NEXT:    lw s5, 120(s6)
; RV32I-WITH-FP-NEXT:    lw s7, 124(s6)
; RV32I-WITH-FP-NEXT:    call callee
; RV32I-WITH-FP-NEXT:    sw s7, 124(s6)
; RV32I-WITH-FP-NEXT:    sw s5, 120(s6)
; RV32I-WITH-FP-NEXT:    sw s4, 116(s6)
; RV32I-WITH-FP-NEXT:    sw s3, 112(s6)
; RV32I-WITH-FP-NEXT:    sw s2, 108(s6)
; RV32I-WITH-FP-NEXT:    sw s11, 104(s6)
; RV32I-WITH-FP-NEXT:    sw s10, 100(s6)
; RV32I-WITH-FP-NEXT:    sw s9, 96(s6)
; RV32I-WITH-FP-NEXT:    sw s8, 92(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -144(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 88(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -140(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 84(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -136(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 80(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -132(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 76(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -128(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 72(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -124(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 68(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -120(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 64(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -116(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 60(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -112(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 56(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -108(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 52(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -104(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 48(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -100(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 44(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -96(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 40(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -92(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 36(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -88(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 32(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -84(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 28(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -80(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 24(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -76(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 20(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -72(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, 16(s6)
; RV32I-WITH-FP-NEXT:    lw a0, -68(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, %lo(var+12)(s1)
; RV32I-WITH-FP-NEXT:    lw a0, -64(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, %lo(var+8)(s1)
; RV32I-WITH-FP-NEXT:    lw a0, -60(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, %lo(var+4)(s1)
; RV32I-WITH-FP-NEXT:    lw a0, -56(s0) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    sw a0, %lo(var)(s1)
; RV32I-WITH-FP-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s0, 136(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s1, 132(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s2, 128(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s3, 124(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s4, 120(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s5, 116(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s6, 112(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s7, 108(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s8, 104(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s9, 100(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s10, 96(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s11, 92(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    addi sp, sp, 144
; RV32I-WITH-FP-NEXT:    ret
;
; RV32IZCMP-LABEL: caller:
; RV32IZCMP:       # %bb.0:
; RV32IZCMP-NEXT:    cm.push {ra, s0-s11}, -112
; RV32IZCMP-NEXT:    addi sp, sp, -48
; RV32IZCMP-NEXT:    lui s0, %hi(var)
; RV32IZCMP-NEXT:    lw a0, %lo(var)(s0)
; RV32IZCMP-NEXT:    sw a0, 92(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, %lo(var+4)(s0)
; RV32IZCMP-NEXT:    sw a0, 88(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, %lo(var+8)(s0)
; RV32IZCMP-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, %lo(var+12)(s0)
; RV32IZCMP-NEXT:    sw a0, 80(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    addi s1, s0, %lo(var)
; RV32IZCMP-NEXT:    lw a0, 16(s1)
; RV32IZCMP-NEXT:    sw a0, 76(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 20(s1)
; RV32IZCMP-NEXT:    sw a0, 72(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 24(s1)
; RV32IZCMP-NEXT:    sw a0, 68(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 28(s1)
; RV32IZCMP-NEXT:    sw a0, 64(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 32(s1)
; RV32IZCMP-NEXT:    sw a0, 60(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 36(s1)
; RV32IZCMP-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 40(s1)
; RV32IZCMP-NEXT:    sw a0, 52(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 44(s1)
; RV32IZCMP-NEXT:    sw a0, 48(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 48(s1)
; RV32IZCMP-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 52(s1)
; RV32IZCMP-NEXT:    sw a0, 40(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 56(s1)
; RV32IZCMP-NEXT:    sw a0, 36(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 60(s1)
; RV32IZCMP-NEXT:    sw a0, 32(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 64(s1)
; RV32IZCMP-NEXT:    sw a0, 28(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 68(s1)
; RV32IZCMP-NEXT:    sw a0, 24(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 72(s1)
; RV32IZCMP-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 76(s1)
; RV32IZCMP-NEXT:    sw a0, 16(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 80(s1)
; RV32IZCMP-NEXT:    sw a0, 12(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw a0, 84(s1)
; RV32IZCMP-NEXT:    sw a0, 8(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    lw s4, 88(s1)
; RV32IZCMP-NEXT:    lw s5, 92(s1)
; RV32IZCMP-NEXT:    lw s6, 96(s1)
; RV32IZCMP-NEXT:    lw s7, 100(s1)
; RV32IZCMP-NEXT:    lw s8, 104(s1)
; RV32IZCMP-NEXT:    lw s9, 108(s1)
; RV32IZCMP-NEXT:    lw s10, 112(s1)
; RV32IZCMP-NEXT:    lw s11, 116(s1)
; RV32IZCMP-NEXT:    lw s2, 120(s1)
; RV32IZCMP-NEXT:    lw s3, 124(s1)
; RV32IZCMP-NEXT:    call callee
; RV32IZCMP-NEXT:    sw s3, 124(s1)
; RV32IZCMP-NEXT:    sw s2, 120(s1)
; RV32IZCMP-NEXT:    sw s11, 116(s1)
; RV32IZCMP-NEXT:    sw s10, 112(s1)
; RV32IZCMP-NEXT:    sw s9, 108(s1)
; RV32IZCMP-NEXT:    sw s8, 104(s1)
; RV32IZCMP-NEXT:    sw s7, 100(s1)
; RV32IZCMP-NEXT:    sw s6, 96(s1)
; RV32IZCMP-NEXT:    sw s5, 92(s1)
; RV32IZCMP-NEXT:    sw s4, 88(s1)
; RV32IZCMP-NEXT:    lw a0, 8(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 84(s1)
; RV32IZCMP-NEXT:    lw a0, 12(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 80(s1)
; RV32IZCMP-NEXT:    lw a0, 16(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 76(s1)
; RV32IZCMP-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 72(s1)
; RV32IZCMP-NEXT:    lw a0, 24(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 68(s1)
; RV32IZCMP-NEXT:    lw a0, 28(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 64(s1)
; RV32IZCMP-NEXT:    lw a0, 32(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 60(s1)
; RV32IZCMP-NEXT:    lw a0, 36(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 56(s1)
; RV32IZCMP-NEXT:    lw a0, 40(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 52(s1)
; RV32IZCMP-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 48(s1)
; RV32IZCMP-NEXT:    lw a0, 48(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 44(s1)
; RV32IZCMP-NEXT:    lw a0, 52(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 40(s1)
; RV32IZCMP-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 36(s1)
; RV32IZCMP-NEXT:    lw a0, 60(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 32(s1)
; RV32IZCMP-NEXT:    lw a0, 64(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 28(s1)
; RV32IZCMP-NEXT:    lw a0, 68(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 24(s1)
; RV32IZCMP-NEXT:    lw a0, 72(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 20(s1)
; RV32IZCMP-NEXT:    lw a0, 76(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, 16(s1)
; RV32IZCMP-NEXT:    lw a0, 80(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, %lo(var+12)(s0)
; RV32IZCMP-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, %lo(var+8)(s0)
; RV32IZCMP-NEXT:    lw a0, 88(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, %lo(var+4)(s0)
; RV32IZCMP-NEXT:    lw a0, 92(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    sw a0, %lo(var)(s0)
; RV32IZCMP-NEXT:    addi sp, sp, 48
; RV32IZCMP-NEXT:    cm.popret {ra, s0-s11}, 112
;
; RV32IZCMP-WITH-FP-LABEL: caller:
; RV32IZCMP-WITH-FP:       # %bb.0:
; RV32IZCMP-WITH-FP-NEXT:    addi sp, sp, -144
; RV32IZCMP-WITH-FP-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s0, 136(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s1, 132(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s2, 128(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s3, 124(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s4, 120(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s5, 116(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s6, 112(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s7, 108(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s8, 104(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s9, 100(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s10, 96(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s11, 92(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    addi s0, sp, 144
; RV32IZCMP-WITH-FP-NEXT:    lui s6, %hi(var)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, %lo(var)(s6)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -56(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, %lo(var+4)(s6)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -60(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, %lo(var+8)(s6)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -64(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, %lo(var+12)(s6)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -68(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    addi s1, s6, %lo(var)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 16(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -72(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 20(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -76(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 24(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -80(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 28(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -84(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 32(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -88(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 36(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -92(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 40(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -96(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 44(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -100(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 48(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -104(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 52(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -108(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 56(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -112(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 60(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -116(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 64(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -120(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 68(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -124(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 72(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -128(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 76(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -132(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 80(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -136(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 84(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -140(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw a0, 88(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, -144(s0) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    lw s8, 92(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw s9, 96(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw s10, 100(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw s11, 104(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw s2, 108(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw s3, 112(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw s4, 116(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw s5, 120(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw s7, 124(s1)
; RV32IZCMP-WITH-FP-NEXT:    call callee
; RV32IZCMP-WITH-FP-NEXT:    sw s7, 124(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw s5, 120(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw s4, 116(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw s3, 112(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw s2, 108(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw s11, 104(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw s10, 100(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw s9, 96(s1)
; RV32IZCMP-WITH-FP-NEXT:    sw s8, 92(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -144(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 88(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -140(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 84(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -136(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 80(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -132(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 76(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -128(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 72(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -124(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 68(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -120(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 64(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -116(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 60(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -112(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 56(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -108(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 52(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -104(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 48(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -100(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 44(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -96(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 40(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -92(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 36(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -88(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 32(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -84(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 28(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -80(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 24(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -76(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 20(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -72(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 16(s1)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -68(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, %lo(var+12)(s6)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -64(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, %lo(var+8)(s6)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -60(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, %lo(var+4)(s6)
; RV32IZCMP-WITH-FP-NEXT:    lw a0, -56(s0) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    sw a0, %lo(var)(s6)
; RV32IZCMP-WITH-FP-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s0, 136(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s1, 132(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s2, 128(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s3, 124(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s4, 120(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s5, 116(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s6, 112(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s7, 108(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s8, 104(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s9, 100(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s10, 96(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s11, 92(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    addi sp, sp, 144
; RV32IZCMP-WITH-FP-NEXT:    ret
;
; RV64I-LABEL: caller:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -288
; RV64I-NEXT:    sd ra, 280(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 272(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 264(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s2, 256(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 248(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s4, 240(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s5, 232(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s6, 224(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s7, 216(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s8, 208(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s9, 200(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s10, 192(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s11, 184(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lui s0, %hi(var)
; RV64I-NEXT:    lw a0, %lo(var)(s0)
; RV64I-NEXT:    sd a0, 176(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, %lo(var+4)(s0)
; RV64I-NEXT:    sd a0, 168(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, %lo(var+8)(s0)
; RV64I-NEXT:    sd a0, 160(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, %lo(var+12)(s0)
; RV64I-NEXT:    sd a0, 152(sp) # 8-byte Folded Spill
; RV64I-NEXT:    addi s5, s0, %lo(var)
; RV64I-NEXT:    lw a0, 16(s5)
; RV64I-NEXT:    sd a0, 144(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 20(s5)
; RV64I-NEXT:    sd a0, 136(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 24(s5)
; RV64I-NEXT:    sd a0, 128(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 28(s5)
; RV64I-NEXT:    sd a0, 120(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 32(s5)
; RV64I-NEXT:    sd a0, 112(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 36(s5)
; RV64I-NEXT:    sd a0, 104(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 40(s5)
; RV64I-NEXT:    sd a0, 96(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 44(s5)
; RV64I-NEXT:    sd a0, 88(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 48(s5)
; RV64I-NEXT:    sd a0, 80(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 52(s5)
; RV64I-NEXT:    sd a0, 72(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 56(s5)
; RV64I-NEXT:    sd a0, 64(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 60(s5)
; RV64I-NEXT:    sd a0, 56(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 64(s5)
; RV64I-NEXT:    sd a0, 48(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 68(s5)
; RV64I-NEXT:    sd a0, 40(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 72(s5)
; RV64I-NEXT:    sd a0, 32(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 76(s5)
; RV64I-NEXT:    sd a0, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 80(s5)
; RV64I-NEXT:    sd a0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw a0, 84(s5)
; RV64I-NEXT:    sd a0, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    lw s3, 88(s5)
; RV64I-NEXT:    lw s4, 92(s5)
; RV64I-NEXT:    lw s6, 96(s5)
; RV64I-NEXT:    lw s7, 100(s5)
; RV64I-NEXT:    lw s8, 104(s5)
; RV64I-NEXT:    lw s9, 108(s5)
; RV64I-NEXT:    lw s10, 112(s5)
; RV64I-NEXT:    lw s11, 116(s5)
; RV64I-NEXT:    lw s1, 120(s5)
; RV64I-NEXT:    lw s2, 124(s5)
; RV64I-NEXT:    call callee
; RV64I-NEXT:    sw s2, 124(s5)
; RV64I-NEXT:    sw s1, 120(s5)
; RV64I-NEXT:    sw s11, 116(s5)
; RV64I-NEXT:    sw s10, 112(s5)
; RV64I-NEXT:    sw s9, 108(s5)
; RV64I-NEXT:    sw s8, 104(s5)
; RV64I-NEXT:    sw s7, 100(s5)
; RV64I-NEXT:    sw s6, 96(s5)
; RV64I-NEXT:    sw s4, 92(s5)
; RV64I-NEXT:    sw s3, 88(s5)
; RV64I-NEXT:    ld a0, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 84(s5)
; RV64I-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 80(s5)
; RV64I-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 76(s5)
; RV64I-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 72(s5)
; RV64I-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 68(s5)
; RV64I-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 64(s5)
; RV64I-NEXT:    ld a0, 56(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 60(s5)
; RV64I-NEXT:    ld a0, 64(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 56(s5)
; RV64I-NEXT:    ld a0, 72(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 52(s5)
; RV64I-NEXT:    ld a0, 80(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 48(s5)
; RV64I-NEXT:    ld a0, 88(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 44(s5)
; RV64I-NEXT:    ld a0, 96(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 40(s5)
; RV64I-NEXT:    ld a0, 104(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 36(s5)
; RV64I-NEXT:    ld a0, 112(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 32(s5)
; RV64I-NEXT:    ld a0, 120(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 28(s5)
; RV64I-NEXT:    ld a0, 128(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 24(s5)
; RV64I-NEXT:    ld a0, 136(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 20(s5)
; RV64I-NEXT:    ld a0, 144(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, 16(s5)
; RV64I-NEXT:    ld a0, 152(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, %lo(var+12)(s0)
; RV64I-NEXT:    ld a0, 160(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, %lo(var+8)(s0)
; RV64I-NEXT:    ld a0, 168(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, %lo(var+4)(s0)
; RV64I-NEXT:    ld a0, 176(sp) # 8-byte Folded Reload
; RV64I-NEXT:    sw a0, %lo(var)(s0)
; RV64I-NEXT:    ld ra, 280(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 272(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 264(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s2, 256(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 248(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s4, 240(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s5, 232(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s6, 224(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s7, 216(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s8, 208(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s9, 200(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s10, 192(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s11, 184(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 288
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: caller:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -272
; RV64I-LP64E-NEXT:    sd ra, 264(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    sd s0, 256(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    sd s1, 248(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lui a0, %hi(var)
; RV64I-LP64E-NEXT:    lw a1, %lo(var)(a0)
; RV64I-LP64E-NEXT:    sd a1, 240(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a1, %lo(var+4)(a0)
; RV64I-LP64E-NEXT:    sd a1, 232(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a1, %lo(var+8)(a0)
; RV64I-LP64E-NEXT:    sd a1, 224(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a1, %lo(var+12)(a0)
; RV64I-LP64E-NEXT:    sd a1, 216(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    addi s1, a0, %lo(var)
; RV64I-LP64E-NEXT:    lw a0, 16(s1)
; RV64I-LP64E-NEXT:    sd a0, 208(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 20(s1)
; RV64I-LP64E-NEXT:    sd a0, 200(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 24(s1)
; RV64I-LP64E-NEXT:    sd a0, 192(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 28(s1)
; RV64I-LP64E-NEXT:    sd a0, 184(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 32(s1)
; RV64I-LP64E-NEXT:    sd a0, 176(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 36(s1)
; RV64I-LP64E-NEXT:    sd a0, 168(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 40(s1)
; RV64I-LP64E-NEXT:    sd a0, 160(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 44(s1)
; RV64I-LP64E-NEXT:    sd a0, 152(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 48(s1)
; RV64I-LP64E-NEXT:    sd a0, 144(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 52(s1)
; RV64I-LP64E-NEXT:    sd a0, 136(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 56(s1)
; RV64I-LP64E-NEXT:    sd a0, 128(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 60(s1)
; RV64I-LP64E-NEXT:    sd a0, 120(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 64(s1)
; RV64I-LP64E-NEXT:    sd a0, 112(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 68(s1)
; RV64I-LP64E-NEXT:    sd a0, 104(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 72(s1)
; RV64I-LP64E-NEXT:    sd a0, 96(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 76(s1)
; RV64I-LP64E-NEXT:    sd a0, 88(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 80(s1)
; RV64I-LP64E-NEXT:    sd a0, 80(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 84(s1)
; RV64I-LP64E-NEXT:    sd a0, 72(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 88(s1)
; RV64I-LP64E-NEXT:    sd a0, 64(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 92(s1)
; RV64I-LP64E-NEXT:    sd a0, 56(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 96(s1)
; RV64I-LP64E-NEXT:    sd a0, 48(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 100(s1)
; RV64I-LP64E-NEXT:    sd a0, 40(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 104(s1)
; RV64I-LP64E-NEXT:    sd a0, 32(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 108(s1)
; RV64I-LP64E-NEXT:    sd a0, 24(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 112(s1)
; RV64I-LP64E-NEXT:    sd a0, 16(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 116(s1)
; RV64I-LP64E-NEXT:    sd a0, 8(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw a0, 120(s1)
; RV64I-LP64E-NEXT:    sd a0, 0(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    lw s0, 124(s1)
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    sw s0, 124(s1)
; RV64I-LP64E-NEXT:    ld a0, 0(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 120(s1)
; RV64I-LP64E-NEXT:    ld a0, 8(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 116(s1)
; RV64I-LP64E-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 112(s1)
; RV64I-LP64E-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 108(s1)
; RV64I-LP64E-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 104(s1)
; RV64I-LP64E-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 100(s1)
; RV64I-LP64E-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 96(s1)
; RV64I-LP64E-NEXT:    ld a0, 56(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 92(s1)
; RV64I-LP64E-NEXT:    ld a0, 64(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 88(s1)
; RV64I-LP64E-NEXT:    ld a0, 72(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 84(s1)
; RV64I-LP64E-NEXT:    ld a0, 80(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 80(s1)
; RV64I-LP64E-NEXT:    ld a0, 88(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 76(s1)
; RV64I-LP64E-NEXT:    ld a0, 96(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 72(s1)
; RV64I-LP64E-NEXT:    ld a0, 104(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 68(s1)
; RV64I-LP64E-NEXT:    ld a0, 112(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 64(s1)
; RV64I-LP64E-NEXT:    ld a0, 120(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 60(s1)
; RV64I-LP64E-NEXT:    ld a0, 128(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 56(s1)
; RV64I-LP64E-NEXT:    ld a0, 136(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 52(s1)
; RV64I-LP64E-NEXT:    ld a0, 144(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 48(s1)
; RV64I-LP64E-NEXT:    ld a0, 152(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 44(s1)
; RV64I-LP64E-NEXT:    ld a0, 160(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 40(s1)
; RV64I-LP64E-NEXT:    ld a0, 168(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 36(s1)
; RV64I-LP64E-NEXT:    ld a0, 176(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 32(s1)
; RV64I-LP64E-NEXT:    ld a0, 184(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 28(s1)
; RV64I-LP64E-NEXT:    ld a0, 192(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 24(s1)
; RV64I-LP64E-NEXT:    ld a0, 200(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 20(s1)
; RV64I-LP64E-NEXT:    ld a0, 208(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, 16(s1)
; RV64I-LP64E-NEXT:    lui a1, %hi(var)
; RV64I-LP64E-NEXT:    ld a0, 216(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, %lo(var+12)(a1)
; RV64I-LP64E-NEXT:    ld a0, 224(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, %lo(var+8)(a1)
; RV64I-LP64E-NEXT:    ld a0, 232(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, %lo(var+4)(a1)
; RV64I-LP64E-NEXT:    ld a0, 240(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    sw a0, %lo(var)(a1)
; RV64I-LP64E-NEXT:    ld ra, 264(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    ld s0, 256(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    ld s1, 248(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    addi sp, sp, 272
; RV64I-LP64E-NEXT:    ret
;
; RV64I-WITH-FP-LABEL: caller:
; RV64I-WITH-FP:       # %bb.0:
; RV64I-WITH-FP-NEXT:    addi sp, sp, -288
; RV64I-WITH-FP-NEXT:    sd ra, 280(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s0, 272(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s1, 264(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s2, 256(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s3, 248(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s4, 240(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s5, 232(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s6, 224(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s7, 216(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s8, 208(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s9, 200(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s10, 192(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s11, 184(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    addi s0, sp, 288
; RV64I-WITH-FP-NEXT:    lui s1, %hi(var)
; RV64I-WITH-FP-NEXT:    lw a0, %lo(var)(s1)
; RV64I-WITH-FP-NEXT:    sd a0, -112(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, %lo(var+4)(s1)
; RV64I-WITH-FP-NEXT:    sd a0, -120(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, %lo(var+8)(s1)
; RV64I-WITH-FP-NEXT:    sd a0, -128(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, %lo(var+12)(s1)
; RV64I-WITH-FP-NEXT:    sd a0, -136(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    addi s6, s1, %lo(var)
; RV64I-WITH-FP-NEXT:    lw a0, 16(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -144(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 20(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -152(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 24(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -160(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 28(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -168(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 32(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -176(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 36(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -184(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 40(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -192(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 44(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -200(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 48(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -208(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 52(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -216(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 56(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -224(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 60(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -232(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 64(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -240(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 68(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -248(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 72(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -256(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 76(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -264(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 80(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -272(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 84(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -280(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw a0, 88(s6)
; RV64I-WITH-FP-NEXT:    sd a0, -288(s0) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    lw s8, 92(s6)
; RV64I-WITH-FP-NEXT:    lw s9, 96(s6)
; RV64I-WITH-FP-NEXT:    lw s10, 100(s6)
; RV64I-WITH-FP-NEXT:    lw s11, 104(s6)
; RV64I-WITH-FP-NEXT:    lw s2, 108(s6)
; RV64I-WITH-FP-NEXT:    lw s3, 112(s6)
; RV64I-WITH-FP-NEXT:    lw s4, 116(s6)
; RV64I-WITH-FP-NEXT:    lw s5, 120(s6)
; RV64I-WITH-FP-NEXT:    lw s7, 124(s6)
; RV64I-WITH-FP-NEXT:    call callee
; RV64I-WITH-FP-NEXT:    sw s7, 124(s6)
; RV64I-WITH-FP-NEXT:    sw s5, 120(s6)
; RV64I-WITH-FP-NEXT:    sw s4, 116(s6)
; RV64I-WITH-FP-NEXT:    sw s3, 112(s6)
; RV64I-WITH-FP-NEXT:    sw s2, 108(s6)
; RV64I-WITH-FP-NEXT:    sw s11, 104(s6)
; RV64I-WITH-FP-NEXT:    sw s10, 100(s6)
; RV64I-WITH-FP-NEXT:    sw s9, 96(s6)
; RV64I-WITH-FP-NEXT:    sw s8, 92(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -288(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 88(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -280(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 84(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -272(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 80(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -264(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 76(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -256(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 72(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -248(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 68(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -240(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 64(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -232(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 60(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -224(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 56(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -216(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 52(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -208(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 48(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -200(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 44(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -192(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 40(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -184(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 36(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -176(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 32(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -168(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 28(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -160(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 24(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -152(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 20(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -144(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, 16(s6)
; RV64I-WITH-FP-NEXT:    ld a0, -136(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, %lo(var+12)(s1)
; RV64I-WITH-FP-NEXT:    ld a0, -128(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, %lo(var+8)(s1)
; RV64I-WITH-FP-NEXT:    ld a0, -120(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, %lo(var+4)(s1)
; RV64I-WITH-FP-NEXT:    ld a0, -112(s0) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    sw a0, %lo(var)(s1)
; RV64I-WITH-FP-NEXT:    ld ra, 280(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s0, 272(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s1, 264(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s2, 256(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s3, 248(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s4, 240(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s5, 232(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s6, 224(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s7, 216(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s8, 208(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s9, 200(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s10, 192(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s11, 184(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    addi sp, sp, 288
; RV64I-WITH-FP-NEXT:    ret
;
; RV64IZCMP-LABEL: caller:
; RV64IZCMP:       # %bb.0:
; RV64IZCMP-NEXT:    cm.push {ra, s0-s11}, -160
; RV64IZCMP-NEXT:    addi sp, sp, -128
; RV64IZCMP-NEXT:    lui s0, %hi(var)
; RV64IZCMP-NEXT:    lw a0, %lo(var)(s0)
; RV64IZCMP-NEXT:    sd a0, 168(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, %lo(var+4)(s0)
; RV64IZCMP-NEXT:    sd a0, 160(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, %lo(var+8)(s0)
; RV64IZCMP-NEXT:    sd a0, 152(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, %lo(var+12)(s0)
; RV64IZCMP-NEXT:    sd a0, 144(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    addi s1, s0, %lo(var)
; RV64IZCMP-NEXT:    lw a0, 16(s1)
; RV64IZCMP-NEXT:    sd a0, 136(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 20(s1)
; RV64IZCMP-NEXT:    sd a0, 128(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 24(s1)
; RV64IZCMP-NEXT:    sd a0, 120(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 28(s1)
; RV64IZCMP-NEXT:    sd a0, 112(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 32(s1)
; RV64IZCMP-NEXT:    sd a0, 104(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 36(s1)
; RV64IZCMP-NEXT:    sd a0, 96(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 40(s1)
; RV64IZCMP-NEXT:    sd a0, 88(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 44(s1)
; RV64IZCMP-NEXT:    sd a0, 80(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 48(s1)
; RV64IZCMP-NEXT:    sd a0, 72(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 52(s1)
; RV64IZCMP-NEXT:    sd a0, 64(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 56(s1)
; RV64IZCMP-NEXT:    sd a0, 56(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 60(s1)
; RV64IZCMP-NEXT:    sd a0, 48(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 64(s1)
; RV64IZCMP-NEXT:    sd a0, 40(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 68(s1)
; RV64IZCMP-NEXT:    sd a0, 32(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 72(s1)
; RV64IZCMP-NEXT:    sd a0, 24(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 76(s1)
; RV64IZCMP-NEXT:    sd a0, 16(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 80(s1)
; RV64IZCMP-NEXT:    sd a0, 8(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw a0, 84(s1)
; RV64IZCMP-NEXT:    sd a0, 0(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    lw s4, 88(s1)
; RV64IZCMP-NEXT:    lw s5, 92(s1)
; RV64IZCMP-NEXT:    lw s6, 96(s1)
; RV64IZCMP-NEXT:    lw s7, 100(s1)
; RV64IZCMP-NEXT:    lw s8, 104(s1)
; RV64IZCMP-NEXT:    lw s9, 108(s1)
; RV64IZCMP-NEXT:    lw s10, 112(s1)
; RV64IZCMP-NEXT:    lw s11, 116(s1)
; RV64IZCMP-NEXT:    lw s2, 120(s1)
; RV64IZCMP-NEXT:    lw s3, 124(s1)
; RV64IZCMP-NEXT:    call callee
; RV64IZCMP-NEXT:    sw s3, 124(s1)
; RV64IZCMP-NEXT:    sw s2, 120(s1)
; RV64IZCMP-NEXT:    sw s11, 116(s1)
; RV64IZCMP-NEXT:    sw s10, 112(s1)
; RV64IZCMP-NEXT:    sw s9, 108(s1)
; RV64IZCMP-NEXT:    sw s8, 104(s1)
; RV64IZCMP-NEXT:    sw s7, 100(s1)
; RV64IZCMP-NEXT:    sw s6, 96(s1)
; RV64IZCMP-NEXT:    sw s5, 92(s1)
; RV64IZCMP-NEXT:    sw s4, 88(s1)
; RV64IZCMP-NEXT:    ld a0, 0(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 84(s1)
; RV64IZCMP-NEXT:    ld a0, 8(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 80(s1)
; RV64IZCMP-NEXT:    ld a0, 16(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 76(s1)
; RV64IZCMP-NEXT:    ld a0, 24(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 72(s1)
; RV64IZCMP-NEXT:    ld a0, 32(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 68(s1)
; RV64IZCMP-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 64(s1)
; RV64IZCMP-NEXT:    ld a0, 48(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 60(s1)
; RV64IZCMP-NEXT:    ld a0, 56(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 56(s1)
; RV64IZCMP-NEXT:    ld a0, 64(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 52(s1)
; RV64IZCMP-NEXT:    ld a0, 72(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 48(s1)
; RV64IZCMP-NEXT:    ld a0, 80(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 44(s1)
; RV64IZCMP-NEXT:    ld a0, 88(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 40(s1)
; RV64IZCMP-NEXT:    ld a0, 96(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 36(s1)
; RV64IZCMP-NEXT:    ld a0, 104(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 32(s1)
; RV64IZCMP-NEXT:    ld a0, 112(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 28(s1)
; RV64IZCMP-NEXT:    ld a0, 120(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 24(s1)
; RV64IZCMP-NEXT:    ld a0, 128(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 20(s1)
; RV64IZCMP-NEXT:    ld a0, 136(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, 16(s1)
; RV64IZCMP-NEXT:    ld a0, 144(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, %lo(var+12)(s0)
; RV64IZCMP-NEXT:    ld a0, 152(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, %lo(var+8)(s0)
; RV64IZCMP-NEXT:    ld a0, 160(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, %lo(var+4)(s0)
; RV64IZCMP-NEXT:    ld a0, 168(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    sw a0, %lo(var)(s0)
; RV64IZCMP-NEXT:    addi sp, sp, 128
; RV64IZCMP-NEXT:    cm.popret {ra, s0-s11}, 160
;
; RV64IZCMP-WITH-FP-LABEL: caller:
; RV64IZCMP-WITH-FP:       # %bb.0:
; RV64IZCMP-WITH-FP-NEXT:    addi sp, sp, -288
; RV64IZCMP-WITH-FP-NEXT:    sd ra, 280(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s0, 272(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s1, 264(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s2, 256(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s3, 248(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s4, 240(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s5, 232(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s6, 224(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s7, 216(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s8, 208(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s9, 200(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s10, 192(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s11, 184(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    addi s0, sp, 288
; RV64IZCMP-WITH-FP-NEXT:    lui s6, %hi(var)
; RV64IZCMP-WITH-FP-NEXT:    lw a0, %lo(var)(s6)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -112(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, %lo(var+4)(s6)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -120(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, %lo(var+8)(s6)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -128(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, %lo(var+12)(s6)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -136(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    addi s1, s6, %lo(var)
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 16(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -144(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 20(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -152(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 24(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -160(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 28(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -168(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 32(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -176(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 36(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -184(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 40(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -192(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 44(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -200(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 48(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -208(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 52(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -216(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 56(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -224(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 60(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -232(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 64(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -240(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 68(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -248(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 72(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -256(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 76(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -264(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 80(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -272(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 84(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -280(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw a0, 88(s1)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, -288(s0) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    lw s8, 92(s1)
; RV64IZCMP-WITH-FP-NEXT:    lw s9, 96(s1)
; RV64IZCMP-WITH-FP-NEXT:    lw s10, 100(s1)
; RV64IZCMP-WITH-FP-NEXT:    lw s11, 104(s1)
; RV64IZCMP-WITH-FP-NEXT:    lw s2, 108(s1)
; RV64IZCMP-WITH-FP-NEXT:    lw s3, 112(s1)
; RV64IZCMP-WITH-FP-NEXT:    lw s4, 116(s1)
; RV64IZCMP-WITH-FP-NEXT:    lw s5, 120(s1)
; RV64IZCMP-WITH-FP-NEXT:    lw s7, 124(s1)
; RV64IZCMP-WITH-FP-NEXT:    call callee
; RV64IZCMP-WITH-FP-NEXT:    sw s7, 124(s1)
; RV64IZCMP-WITH-FP-NEXT:    sw s5, 120(s1)
; RV64IZCMP-WITH-FP-NEXT:    sw s4, 116(s1)
; RV64IZCMP-WITH-FP-NEXT:    sw s3, 112(s1)
; RV64IZCMP-WITH-FP-NEXT:    sw s2, 108(s1)
; RV64IZCMP-WITH-FP-NEXT:    sw s11, 104(s1)
; RV64IZCMP-WITH-FP-NEXT:    sw s10, 100(s1)
; RV64IZCMP-WITH-FP-NEXT:    sw s9, 96(s1)
; RV64IZCMP-WITH-FP-NEXT:    sw s8, 92(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -288(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 88(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -280(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 84(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -272(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 80(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -264(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 76(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -256(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 72(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -248(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 68(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -240(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 64(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -232(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 60(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -224(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 56(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -216(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 52(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -208(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 48(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -200(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 44(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -192(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 40(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -184(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 36(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -176(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 32(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -168(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 28(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -160(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 24(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -152(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 20(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -144(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, 16(s1)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -136(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, %lo(var+12)(s6)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -128(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, %lo(var+8)(s6)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -120(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, %lo(var+4)(s6)
; RV64IZCMP-WITH-FP-NEXT:    ld a0, -112(s0) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    sw a0, %lo(var)(s6)
; RV64IZCMP-WITH-FP-NEXT:    ld ra, 280(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s0, 272(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s1, 264(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s2, 256(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s3, 248(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s4, 240(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s5, 232(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s6, 224(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s7, 216(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s8, 208(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s9, 200(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s10, 192(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s11, 184(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    addi sp, sp, 288
; RV64IZCMP-WITH-FP-NEXT:    ret
  %val = load [32 x i32], ptr @var
  call void @callee()
  store volatile [32 x i32] %val, ptr @var
  ret void
}

; This function tests if the stack size is correctly calculated when
; callee-saved registers are not a sequential list from $ra
define void @foo() {
; RV32I-LABEL: foo:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw s4, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset s4, -4
; RV32I-NEXT:    #APP
; RV32I-NEXT:    li s4, 0
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    lw s4, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: foo:
; RV32I-ILP32E:       # %bb.0: # %entry
; RV32I-ILP32E-NEXT:    #APP
; RV32I-ILP32E-NEXT:    li s4, 0
; RV32I-ILP32E-NEXT:    #NO_APP
; RV32I-ILP32E-NEXT:    ret
;
; RV32I-WITH-FP-LABEL: foo:
; RV32I-WITH-FP:       # %bb.0: # %entry
; RV32I-WITH-FP-NEXT:    addi sp, sp, -16
; RV32I-WITH-FP-NEXT:    .cfi_def_cfa_offset 16
; RV32I-WITH-FP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s4, 4(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    .cfi_offset ra, -4
; RV32I-WITH-FP-NEXT:    .cfi_offset s0, -8
; RV32I-WITH-FP-NEXT:    .cfi_offset s4, -12
; RV32I-WITH-FP-NEXT:    addi s0, sp, 16
; RV32I-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV32I-WITH-FP-NEXT:    #APP
; RV32I-WITH-FP-NEXT:    li s4, 0
; RV32I-WITH-FP-NEXT:    #NO_APP
; RV32I-WITH-FP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s4, 4(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    addi sp, sp, 16
; RV32I-WITH-FP-NEXT:    ret
;
; RV32IZCMP-LABEL: foo:
; RV32IZCMP:       # %bb.0: # %entry
; RV32IZCMP-NEXT:    cm.push {ra, s0-s4}, -32
; RV32IZCMP-NEXT:    .cfi_def_cfa_offset 32
; RV32IZCMP-NEXT:    .cfi_offset s4, -4
; RV32IZCMP-NEXT:    #APP
; RV32IZCMP-NEXT:    li s4, 0
; RV32IZCMP-NEXT:    #NO_APP
; RV32IZCMP-NEXT:    cm.popret {ra, s0-s4}, 32
;
; RV32IZCMP-WITH-FP-LABEL: foo:
; RV32IZCMP-WITH-FP:       # %bb.0: # %entry
; RV32IZCMP-WITH-FP-NEXT:    addi sp, sp, -16
; RV32IZCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 16
; RV32IZCMP-WITH-FP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s4, 4(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    .cfi_offset ra, -4
; RV32IZCMP-WITH-FP-NEXT:    .cfi_offset s0, -8
; RV32IZCMP-WITH-FP-NEXT:    .cfi_offset s4, -12
; RV32IZCMP-WITH-FP-NEXT:    addi s0, sp, 16
; RV32IZCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV32IZCMP-WITH-FP-NEXT:    #APP
; RV32IZCMP-WITH-FP-NEXT:    li s4, 0
; RV32IZCMP-WITH-FP-NEXT:    #NO_APP
; RV32IZCMP-WITH-FP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s4, 4(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    addi sp, sp, 16
; RV32IZCMP-WITH-FP-NEXT:    ret
;
; RV64I-LABEL: foo:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    .cfi_def_cfa_offset 16
; RV64I-NEXT:    sd s4, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset s4, -8
; RV64I-NEXT:    #APP
; RV64I-NEXT:    li s4, 0
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ld s4, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: foo:
; RV64I-LP64E:       # %bb.0: # %entry
; RV64I-LP64E-NEXT:    #APP
; RV64I-LP64E-NEXT:    li s4, 0
; RV64I-LP64E-NEXT:    #NO_APP
; RV64I-LP64E-NEXT:    ret
;
; RV64I-WITH-FP-LABEL: foo:
; RV64I-WITH-FP:       # %bb.0: # %entry
; RV64I-WITH-FP-NEXT:    addi sp, sp, -32
; RV64I-WITH-FP-NEXT:    .cfi_def_cfa_offset 32
; RV64I-WITH-FP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s4, 8(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    .cfi_offset ra, -8
; RV64I-WITH-FP-NEXT:    .cfi_offset s0, -16
; RV64I-WITH-FP-NEXT:    .cfi_offset s4, -24
; RV64I-WITH-FP-NEXT:    addi s0, sp, 32
; RV64I-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV64I-WITH-FP-NEXT:    #APP
; RV64I-WITH-FP-NEXT:    li s4, 0
; RV64I-WITH-FP-NEXT:    #NO_APP
; RV64I-WITH-FP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s4, 8(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    addi sp, sp, 32
; RV64I-WITH-FP-NEXT:    ret
;
; RV64IZCMP-LABEL: foo:
; RV64IZCMP:       # %bb.0: # %entry
; RV64IZCMP-NEXT:    cm.push {ra, s0-s4}, -48
; RV64IZCMP-NEXT:    .cfi_def_cfa_offset 48
; RV64IZCMP-NEXT:    .cfi_offset s4, -8
; RV64IZCMP-NEXT:    #APP
; RV64IZCMP-NEXT:    li s4, 0
; RV64IZCMP-NEXT:    #NO_APP
; RV64IZCMP-NEXT:    cm.popret {ra, s0-s4}, 48
;
; RV64IZCMP-WITH-FP-LABEL: foo:
; RV64IZCMP-WITH-FP:       # %bb.0: # %entry
; RV64IZCMP-WITH-FP-NEXT:    addi sp, sp, -32
; RV64IZCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 32
; RV64IZCMP-WITH-FP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s4, 8(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    .cfi_offset ra, -8
; RV64IZCMP-WITH-FP-NEXT:    .cfi_offset s0, -16
; RV64IZCMP-WITH-FP-NEXT:    .cfi_offset s4, -24
; RV64IZCMP-WITH-FP-NEXT:    addi s0, sp, 32
; RV64IZCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV64IZCMP-WITH-FP-NEXT:    #APP
; RV64IZCMP-WITH-FP-NEXT:    li s4, 0
; RV64IZCMP-WITH-FP-NEXT:    #NO_APP
; RV64IZCMP-WITH-FP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s4, 8(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    addi sp, sp, 32
; RV64IZCMP-WITH-FP-NEXT:    ret
entry:
  tail call void asm sideeffect "li s4, 0", "~{s4}"()
  ret void
}

; Check .cfi_offset of s11 is correct for Zcmp.
define void @bar() {
; RV32I-LABEL: bar:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw s11, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset s11, -4
; RV32I-NEXT:    #APP
; RV32I-NEXT:    li s11, 0
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    lw s11, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: bar:
; RV32I-ILP32E:       # %bb.0: # %entry
; RV32I-ILP32E-NEXT:    #APP
; RV32I-ILP32E-NEXT:    li s11, 0
; RV32I-ILP32E-NEXT:    #NO_APP
; RV32I-ILP32E-NEXT:    ret
;
; RV32I-WITH-FP-LABEL: bar:
; RV32I-WITH-FP:       # %bb.0: # %entry
; RV32I-WITH-FP-NEXT:    addi sp, sp, -16
; RV32I-WITH-FP-NEXT:    .cfi_def_cfa_offset 16
; RV32I-WITH-FP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s11, 4(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    .cfi_offset ra, -4
; RV32I-WITH-FP-NEXT:    .cfi_offset s0, -8
; RV32I-WITH-FP-NEXT:    .cfi_offset s11, -12
; RV32I-WITH-FP-NEXT:    addi s0, sp, 16
; RV32I-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV32I-WITH-FP-NEXT:    #APP
; RV32I-WITH-FP-NEXT:    li s11, 0
; RV32I-WITH-FP-NEXT:    #NO_APP
; RV32I-WITH-FP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s11, 4(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    addi sp, sp, 16
; RV32I-WITH-FP-NEXT:    ret
;
; RV32IZCMP-LABEL: bar:
; RV32IZCMP:       # %bb.0: # %entry
; RV32IZCMP-NEXT:    cm.push {ra, s0-s11}, -64
; RV32IZCMP-NEXT:    .cfi_def_cfa_offset 64
; RV32IZCMP-NEXT:    .cfi_offset s11, -4
; RV32IZCMP-NEXT:    #APP
; RV32IZCMP-NEXT:    li s11, 0
; RV32IZCMP-NEXT:    #NO_APP
; RV32IZCMP-NEXT:    cm.popret {ra, s0-s11}, 64
;
; RV32IZCMP-WITH-FP-LABEL: bar:
; RV32IZCMP-WITH-FP:       # %bb.0: # %entry
; RV32IZCMP-WITH-FP-NEXT:    addi sp, sp, -16
; RV32IZCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 16
; RV32IZCMP-WITH-FP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s11, 4(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    .cfi_offset ra, -4
; RV32IZCMP-WITH-FP-NEXT:    .cfi_offset s0, -8
; RV32IZCMP-WITH-FP-NEXT:    .cfi_offset s11, -12
; RV32IZCMP-WITH-FP-NEXT:    addi s0, sp, 16
; RV32IZCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV32IZCMP-WITH-FP-NEXT:    #APP
; RV32IZCMP-WITH-FP-NEXT:    li s11, 0
; RV32IZCMP-WITH-FP-NEXT:    #NO_APP
; RV32IZCMP-WITH-FP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s11, 4(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    addi sp, sp, 16
; RV32IZCMP-WITH-FP-NEXT:    ret
;
; RV64I-LABEL: bar:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    .cfi_def_cfa_offset 16
; RV64I-NEXT:    sd s11, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset s11, -8
; RV64I-NEXT:    #APP
; RV64I-NEXT:    li s11, 0
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ld s11, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: bar:
; RV64I-LP64E:       # %bb.0: # %entry
; RV64I-LP64E-NEXT:    #APP
; RV64I-LP64E-NEXT:    li s11, 0
; RV64I-LP64E-NEXT:    #NO_APP
; RV64I-LP64E-NEXT:    ret
;
; RV64I-WITH-FP-LABEL: bar:
; RV64I-WITH-FP:       # %bb.0: # %entry
; RV64I-WITH-FP-NEXT:    addi sp, sp, -32
; RV64I-WITH-FP-NEXT:    .cfi_def_cfa_offset 32
; RV64I-WITH-FP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s11, 8(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    .cfi_offset ra, -8
; RV64I-WITH-FP-NEXT:    .cfi_offset s0, -16
; RV64I-WITH-FP-NEXT:    .cfi_offset s11, -24
; RV64I-WITH-FP-NEXT:    addi s0, sp, 32
; RV64I-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV64I-WITH-FP-NEXT:    #APP
; RV64I-WITH-FP-NEXT:    li s11, 0
; RV64I-WITH-FP-NEXT:    #NO_APP
; RV64I-WITH-FP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s11, 8(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    addi sp, sp, 32
; RV64I-WITH-FP-NEXT:    ret
;
; RV64IZCMP-LABEL: bar:
; RV64IZCMP:       # %bb.0: # %entry
; RV64IZCMP-NEXT:    cm.push {ra, s0-s11}, -112
; RV64IZCMP-NEXT:    .cfi_def_cfa_offset 112
; RV64IZCMP-NEXT:    .cfi_offset s11, -8
; RV64IZCMP-NEXT:    #APP
; RV64IZCMP-NEXT:    li s11, 0
; RV64IZCMP-NEXT:    #NO_APP
; RV64IZCMP-NEXT:    cm.popret {ra, s0-s11}, 112
;
; RV64IZCMP-WITH-FP-LABEL: bar:
; RV64IZCMP-WITH-FP:       # %bb.0: # %entry
; RV64IZCMP-WITH-FP-NEXT:    addi sp, sp, -32
; RV64IZCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 32
; RV64IZCMP-WITH-FP-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s11, 8(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    .cfi_offset ra, -8
; RV64IZCMP-WITH-FP-NEXT:    .cfi_offset s0, -16
; RV64IZCMP-WITH-FP-NEXT:    .cfi_offset s11, -24
; RV64IZCMP-WITH-FP-NEXT:    addi s0, sp, 32
; RV64IZCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 0
; RV64IZCMP-WITH-FP-NEXT:    #APP
; RV64IZCMP-WITH-FP-NEXT:    li s11, 0
; RV64IZCMP-WITH-FP-NEXT:    #NO_APP
; RV64IZCMP-WITH-FP-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s11, 8(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    addi sp, sp, 32
; RV64IZCMP-WITH-FP-NEXT:    ret
entry:
  tail call void asm sideeffect "li s11, 0", "~{s11}"()
  ret void
}

define void @varargs(...) {
; RV32I-LABEL: varargs:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -48
; RV32I-NEXT:    .cfi_def_cfa_offset 48
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -36
; RV32I-NEXT:    sw a7, 44(sp)
; RV32I-NEXT:    sw a6, 40(sp)
; RV32I-NEXT:    sw a5, 36(sp)
; RV32I-NEXT:    sw a4, 32(sp)
; RV32I-NEXT:    sw a3, 28(sp)
; RV32I-NEXT:    sw a2, 24(sp)
; RV32I-NEXT:    sw a1, 20(sp)
; RV32I-NEXT:    sw a0, 16(sp)
; RV32I-NEXT:    call callee
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 48
; RV32I-NEXT:    ret
;
; RV32I-ILP32E-LABEL: varargs:
; RV32I-ILP32E:       # %bb.0:
; RV32I-ILP32E-NEXT:    addi sp, sp, -28
; RV32I-ILP32E-NEXT:    .cfi_def_cfa_offset 28
; RV32I-ILP32E-NEXT:    sw ra, 0(sp) # 4-byte Folded Spill
; RV32I-ILP32E-NEXT:    .cfi_offset ra, -28
; RV32I-ILP32E-NEXT:    sw a5, 24(sp)
; RV32I-ILP32E-NEXT:    sw a4, 20(sp)
; RV32I-ILP32E-NEXT:    sw a3, 16(sp)
; RV32I-ILP32E-NEXT:    sw a2, 12(sp)
; RV32I-ILP32E-NEXT:    sw a1, 8(sp)
; RV32I-ILP32E-NEXT:    sw a0, 4(sp)
; RV32I-ILP32E-NEXT:    call callee
; RV32I-ILP32E-NEXT:    lw ra, 0(sp) # 4-byte Folded Reload
; RV32I-ILP32E-NEXT:    addi sp, sp, 28
; RV32I-ILP32E-NEXT:    ret
;
; RV32I-WITH-FP-LABEL: varargs:
; RV32I-WITH-FP:       # %bb.0:
; RV32I-WITH-FP-NEXT:    addi sp, sp, -48
; RV32I-WITH-FP-NEXT:    .cfi_def_cfa_offset 48
; RV32I-WITH-FP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-WITH-FP-NEXT:    .cfi_offset ra, -36
; RV32I-WITH-FP-NEXT:    .cfi_offset s0, -40
; RV32I-WITH-FP-NEXT:    addi s0, sp, 16
; RV32I-WITH-FP-NEXT:    .cfi_def_cfa s0, 32
; RV32I-WITH-FP-NEXT:    sw a7, 28(s0)
; RV32I-WITH-FP-NEXT:    sw a6, 24(s0)
; RV32I-WITH-FP-NEXT:    sw a5, 20(s0)
; RV32I-WITH-FP-NEXT:    sw a4, 16(s0)
; RV32I-WITH-FP-NEXT:    sw a3, 12(s0)
; RV32I-WITH-FP-NEXT:    sw a2, 8(s0)
; RV32I-WITH-FP-NEXT:    sw a1, 4(s0)
; RV32I-WITH-FP-NEXT:    sw a0, 0(s0)
; RV32I-WITH-FP-NEXT:    call callee
; RV32I-WITH-FP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-WITH-FP-NEXT:    addi sp, sp, 48
; RV32I-WITH-FP-NEXT:    ret
;
; RV32IZCMP-LABEL: varargs:
; RV32IZCMP:       # %bb.0:
; RV32IZCMP-NEXT:    addi sp, sp, -48
; RV32IZCMP-NEXT:    .cfi_def_cfa_offset 48
; RV32IZCMP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZCMP-NEXT:    .cfi_offset ra, -36
; RV32IZCMP-NEXT:    sw a7, 44(sp)
; RV32IZCMP-NEXT:    sw a6, 40(sp)
; RV32IZCMP-NEXT:    sw a5, 36(sp)
; RV32IZCMP-NEXT:    sw a4, 32(sp)
; RV32IZCMP-NEXT:    sw a3, 28(sp)
; RV32IZCMP-NEXT:    sw a2, 24(sp)
; RV32IZCMP-NEXT:    sw a1, 20(sp)
; RV32IZCMP-NEXT:    sw a0, 16(sp)
; RV32IZCMP-NEXT:    call callee
; RV32IZCMP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZCMP-NEXT:    addi sp, sp, 48
; RV32IZCMP-NEXT:    ret
;
; RV32IZCMP-WITH-FP-LABEL: varargs:
; RV32IZCMP-WITH-FP:       # %bb.0:
; RV32IZCMP-WITH-FP-NEXT:    addi sp, sp, -48
; RV32IZCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 48
; RV32IZCMP-WITH-FP-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32IZCMP-WITH-FP-NEXT:    .cfi_offset ra, -36
; RV32IZCMP-WITH-FP-NEXT:    .cfi_offset s0, -40
; RV32IZCMP-WITH-FP-NEXT:    addi s0, sp, 16
; RV32IZCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 32
; RV32IZCMP-WITH-FP-NEXT:    sw a7, 28(s0)
; RV32IZCMP-WITH-FP-NEXT:    sw a6, 24(s0)
; RV32IZCMP-WITH-FP-NEXT:    sw a5, 20(s0)
; RV32IZCMP-WITH-FP-NEXT:    sw a4, 16(s0)
; RV32IZCMP-WITH-FP-NEXT:    sw a3, 12(s0)
; RV32IZCMP-WITH-FP-NEXT:    sw a2, 8(s0)
; RV32IZCMP-WITH-FP-NEXT:    sw a1, 4(s0)
; RV32IZCMP-WITH-FP-NEXT:    sw a0, 0(s0)
; RV32IZCMP-WITH-FP-NEXT:    call callee
; RV32IZCMP-WITH-FP-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32IZCMP-WITH-FP-NEXT:    addi sp, sp, 48
; RV32IZCMP-WITH-FP-NEXT:    ret
;
; RV64I-LABEL: varargs:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -80
; RV64I-NEXT:    .cfi_def_cfa_offset 80
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -72
; RV64I-NEXT:    sd a7, 72(sp)
; RV64I-NEXT:    sd a6, 64(sp)
; RV64I-NEXT:    sd a5, 56(sp)
; RV64I-NEXT:    sd a4, 48(sp)
; RV64I-NEXT:    sd a3, 40(sp)
; RV64I-NEXT:    sd a2, 32(sp)
; RV64I-NEXT:    sd a1, 24(sp)
; RV64I-NEXT:    sd a0, 16(sp)
; RV64I-NEXT:    call callee
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 80
; RV64I-NEXT:    ret
;
; RV64I-LP64E-LABEL: varargs:
; RV64I-LP64E:       # %bb.0:
; RV64I-LP64E-NEXT:    addi sp, sp, -56
; RV64I-LP64E-NEXT:    .cfi_def_cfa_offset 56
; RV64I-LP64E-NEXT:    sd ra, 0(sp) # 8-byte Folded Spill
; RV64I-LP64E-NEXT:    .cfi_offset ra, -56
; RV64I-LP64E-NEXT:    sd a5, 48(sp)
; RV64I-LP64E-NEXT:    sd a4, 40(sp)
; RV64I-LP64E-NEXT:    sd a3, 32(sp)
; RV64I-LP64E-NEXT:    sd a2, 24(sp)
; RV64I-LP64E-NEXT:    sd a1, 16(sp)
; RV64I-LP64E-NEXT:    sd a0, 8(sp)
; RV64I-LP64E-NEXT:    call callee
; RV64I-LP64E-NEXT:    ld ra, 0(sp) # 8-byte Folded Reload
; RV64I-LP64E-NEXT:    addi sp, sp, 56
; RV64I-LP64E-NEXT:    ret
;
; RV64I-WITH-FP-LABEL: varargs:
; RV64I-WITH-FP:       # %bb.0:
; RV64I-WITH-FP-NEXT:    addi sp, sp, -80
; RV64I-WITH-FP-NEXT:    .cfi_def_cfa_offset 80
; RV64I-WITH-FP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64I-WITH-FP-NEXT:    .cfi_offset ra, -72
; RV64I-WITH-FP-NEXT:    .cfi_offset s0, -80
; RV64I-WITH-FP-NEXT:    addi s0, sp, 16
; RV64I-WITH-FP-NEXT:    .cfi_def_cfa s0, 64
; RV64I-WITH-FP-NEXT:    sd a7, 56(s0)
; RV64I-WITH-FP-NEXT:    sd a6, 48(s0)
; RV64I-WITH-FP-NEXT:    sd a5, 40(s0)
; RV64I-WITH-FP-NEXT:    sd a4, 32(s0)
; RV64I-WITH-FP-NEXT:    sd a3, 24(s0)
; RV64I-WITH-FP-NEXT:    sd a2, 16(s0)
; RV64I-WITH-FP-NEXT:    sd a1, 8(s0)
; RV64I-WITH-FP-NEXT:    sd a0, 0(s0)
; RV64I-WITH-FP-NEXT:    call callee
; RV64I-WITH-FP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64I-WITH-FP-NEXT:    addi sp, sp, 80
; RV64I-WITH-FP-NEXT:    ret
;
; RV64IZCMP-LABEL: varargs:
; RV64IZCMP:       # %bb.0:
; RV64IZCMP-NEXT:    addi sp, sp, -80
; RV64IZCMP-NEXT:    .cfi_def_cfa_offset 80
; RV64IZCMP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZCMP-NEXT:    .cfi_offset ra, -72
; RV64IZCMP-NEXT:    sd a7, 72(sp)
; RV64IZCMP-NEXT:    sd a6, 64(sp)
; RV64IZCMP-NEXT:    sd a5, 56(sp)
; RV64IZCMP-NEXT:    sd a4, 48(sp)
; RV64IZCMP-NEXT:    sd a3, 40(sp)
; RV64IZCMP-NEXT:    sd a2, 32(sp)
; RV64IZCMP-NEXT:    sd a1, 24(sp)
; RV64IZCMP-NEXT:    sd a0, 16(sp)
; RV64IZCMP-NEXT:    call callee
; RV64IZCMP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZCMP-NEXT:    addi sp, sp, 80
; RV64IZCMP-NEXT:    ret
;
; RV64IZCMP-WITH-FP-LABEL: varargs:
; RV64IZCMP-WITH-FP:       # %bb.0:
; RV64IZCMP-WITH-FP-NEXT:    addi sp, sp, -80
; RV64IZCMP-WITH-FP-NEXT:    .cfi_def_cfa_offset 80
; RV64IZCMP-WITH-FP-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64IZCMP-WITH-FP-NEXT:    .cfi_offset ra, -72
; RV64IZCMP-WITH-FP-NEXT:    .cfi_offset s0, -80
; RV64IZCMP-WITH-FP-NEXT:    addi s0, sp, 16
; RV64IZCMP-WITH-FP-NEXT:    .cfi_def_cfa s0, 64
; RV64IZCMP-WITH-FP-NEXT:    sd a7, 56(s0)
; RV64IZCMP-WITH-FP-NEXT:    sd a6, 48(s0)
; RV64IZCMP-WITH-FP-NEXT:    sd a5, 40(s0)
; RV64IZCMP-WITH-FP-NEXT:    sd a4, 32(s0)
; RV64IZCMP-WITH-FP-NEXT:    sd a3, 24(s0)
; RV64IZCMP-WITH-FP-NEXT:    sd a2, 16(s0)
; RV64IZCMP-WITH-FP-NEXT:    sd a1, 8(s0)
; RV64IZCMP-WITH-FP-NEXT:    sd a0, 0(s0)
; RV64IZCMP-WITH-FP-NEXT:    call callee
; RV64IZCMP-WITH-FP-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64IZCMP-WITH-FP-NEXT:    addi sp, sp, 80
; RV64IZCMP-WITH-FP-NEXT:    ret
  call void @callee()
  ret void
}
