; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=armv7a-eabi -mattr=+neon -float-abi=hard %s -o - | FileCheck %s

define <8 x i8> @vmlsi8(<8 x i8> %A, <8 x i8> %B, <8 x i8>  %C) nounwind {
; CHECK-LABEL: vmlsi8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmls.i8 d0, d1, d2
; CHECK-NEXT:    bx lr
  %tmp4 = mul <8 x i8> %B, %C
  %tmp5 = sub <8 x i8> %A, %tmp4
  ret <8 x i8> %tmp5
}

define <4 x i16> @vmlsi16(<4 x i16> %A, <4 x i16> %B, <4 x i16> %C) nounwind {
; CHECK-LABEL: vmlsi16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmls.i16 d0, d1, d2
; CHECK-NEXT:    bx lr
  %tmp4 = mul <4 x i16> %B, %C
  %tmp5 = sub <4 x i16> %A, %tmp4
  ret <4 x i16> %tmp5
}

define <2 x i32> @vmlsi32(<2 x i32> %A, <2 x i32> %B, <2 x i32> %C) nounwind {
; CHECK-LABEL: vmlsi32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmls.i32 d0, d1, d2
; CHECK-NEXT:    bx lr
  %tmp4 = mul <2 x i32> %B, %C
  %tmp5 = sub <2 x i32> %A, %tmp4
  ret <2 x i32> %tmp5
}

define <2 x float> @vmlsf32(<2 x float> %A, <2 x float> %B, <2 x float> %C) nounwind {
; CHECK-LABEL: vmlsf32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmls.f32 d0, d1, d2
; CHECK-NEXT:    bx lr
  %tmp4 = fmul <2 x float> %B, %C
  %tmp5 = fsub <2 x float> %A, %tmp4
  ret <2 x float> %tmp5
}

define <16 x i8> @vmlsQi8(<16 x i8> %A, <16 x i8> %B, <16 x i8>  %C) nounwind {
; CHECK-LABEL: vmlsQi8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmls.i8 q0, q1, q2
; CHECK-NEXT:    bx lr
  %tmp4 = mul <16 x i8> %B, %C
  %tmp5 = sub <16 x i8> %A, %tmp4
  ret <16 x i8> %tmp5
}

define <8 x i16> @vmlsQi16(<8 x i16> %A, <8 x i16> %B, <8 x i16> %C) nounwind {
; CHECK-LABEL: vmlsQi16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmls.i16 q0, q1, q2
; CHECK-NEXT:    bx lr
  %tmp4 = mul <8 x i16> %B, %C
  %tmp5 = sub <8 x i16> %A, %tmp4
  ret <8 x i16> %tmp5
}

define <4 x i32> @vmlsQi32(<4 x i32> %A, <4 x i32> %B, <4 x i32> %C) nounwind {
; CHECK-LABEL: vmlsQi32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmls.i32 q0, q1, q2
; CHECK-NEXT:    bx lr
  %tmp4 = mul <4 x i32> %B, %C
  %tmp5 = sub <4 x i32> %A, %tmp4
  ret <4 x i32> %tmp5
}

define <4 x float> @vmlsQf32(<4 x float> %A, <4 x float> %B, <4 x float> %C) nounwind {
; CHECK-LABEL: vmlsQf32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmls.f32 q0, q1, q2
; CHECK-NEXT:    bx lr
  %tmp4 = fmul <4 x float> %B, %C
  %tmp5 = fsub <4 x float> %A, %tmp4
  ret <4 x float> %tmp5
}

define <8 x i16> @vmlsls8(<8 x i16> %A, <8 x i8> %B, <8 x i8> %C) nounwind {
; CHECK-LABEL: vmlsls8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmlsl.s8 q0, d2, d3
; CHECK-NEXT:    bx lr
  %tmp4 = sext <8 x i8> %B to <8 x i16>
  %tmp5 = sext <8 x i8> %C to <8 x i16>
  %tmp6 = mul <8 x i16> %tmp4, %tmp5
  %tmp7 = sub <8 x i16> %A, %tmp6
  ret <8 x i16> %tmp7
}

define <4 x i32> @vmlsls16(<4 x i32> %A, <4 x i16> %B, <4 x i16> %C) nounwind {
; CHECK-LABEL: vmlsls16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmlsl.s16 q0, d2, d3
; CHECK-NEXT:    bx lr
  %tmp4 = sext <4 x i16> %B to <4 x i32>
  %tmp5 = sext <4 x i16> %C to <4 x i32>
  %tmp6 = mul <4 x i32> %tmp4, %tmp5
  %tmp7 = sub <4 x i32> %A, %tmp6
  ret <4 x i32> %tmp7
}

define <2 x i64> @vmlsls32(<2 x i64> %A, <2 x i32> %B, <2 x i32> %C) nounwind {
; CHECK-LABEL: vmlsls32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmlsl.s32 q0, d2, d3
; CHECK-NEXT:    bx lr
  %tmp4 = sext <2 x i32> %B to <2 x i64>
  %tmp5 = sext <2 x i32> %C to <2 x i64>
  %tmp6 = mul <2 x i64> %tmp4, %tmp5
  %tmp7 = sub <2 x i64> %A, %tmp6
  ret <2 x i64> %tmp7
}

define <8 x i16> @vmlslu8(<8 x i16> %A, <8 x i8> %B, <8 x i8> %C) nounwind {
; CHECK-LABEL: vmlslu8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmlsl.u8 q0, d2, d3
; CHECK-NEXT:    bx lr
  %tmp4 = zext <8 x i8> %B to <8 x i16>
  %tmp5 = zext <8 x i8> %C to <8 x i16>
  %tmp6 = mul <8 x i16> %tmp4, %tmp5
  %tmp7 = sub <8 x i16> %A, %tmp6
  ret <8 x i16> %tmp7
}

define <4 x i32> @vmlslu16(<4 x i32> %A, <4 x i16> %B, <4 x i16> %C) nounwind {
; CHECK-LABEL: vmlslu16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmlsl.u16 q0, d2, d3
; CHECK-NEXT:    bx lr
  %tmp4 = zext <4 x i16> %B to <4 x i32>
  %tmp5 = zext <4 x i16> %C to <4 x i32>
  %tmp6 = mul <4 x i32> %tmp4, %tmp5
  %tmp7 = sub <4 x i32> %A, %tmp6
  ret <4 x i32> %tmp7
}

define <2 x i64> @vmlslu32(<2 x i64> %A, <2 x i32> %B, <2 x i32> %C) nounwind {
; CHECK-LABEL: vmlslu32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmlsl.u32 q0, d2, d3
; CHECK-NEXT:    bx lr
  %tmp4 = zext <2 x i32> %B to <2 x i64>
  %tmp5 = zext <2 x i32> %C to <2 x i64>
  %tmp6 = mul <2 x i64> %tmp4, %tmp5
  %tmp7 = sub <2 x i64> %A, %tmp6
  ret <2 x i64> %tmp7
}

define <8 x i16> @vmlsla8(<8 x i16> %A, <8 x i8> %B, <8 x i8> %C) nounwind {
; CHECK-LABEL: vmlsla8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmlsl.u8 q0, d2, d3
; CHECK-NEXT:    vbic.i16 q0, #0xff00
; CHECK-NEXT:    bx lr
  %tmp4 = zext <8 x i8> %B to <8 x i16>
  %tmp5 = zext <8 x i8> %C to <8 x i16>
  %tmp6 = mul <8 x i16> %tmp4, %tmp5
  %tmp7 = sub <8 x i16> %A, %tmp6
  %and = and <8 x i16> %tmp7, <i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255, i16 255>
  ret <8 x i16> %and
}

define <4 x i32> @vmlsla16(<4 x i32> %A, <4 x i16> %B, <4 x i16> %C) nounwind {
; CHECK-LABEL: vmlsla16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmlsl.u16 q0, d2, d3
; CHECK-NEXT:    vmov.i32 q8, #0xffff
; CHECK-NEXT:    vand q0, q0, q8
; CHECK-NEXT:    bx lr
  %tmp4 = zext <4 x i16> %B to <4 x i32>
  %tmp5 = zext <4 x i16> %C to <4 x i32>
  %tmp6 = mul <4 x i32> %tmp4, %tmp5
  %tmp7 = sub <4 x i32> %A, %tmp6
  %and = and <4 x i32> %tmp7, <i32 65535, i32 65535, i32 65535, i32 65535>
  ret <4 x i32> %and
}

define <2 x i64> @vmlsla32(<2 x i64> %A, <2 x i32> %B, <2 x i32> %C) nounwind {
; CHECK-LABEL: vmlsla32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmlsl.u32 q0, d2, d3
; CHECK-NEXT:    vmov.i64 q8, #0xffffffff
; CHECK-NEXT:    vand q0, q0, q8
; CHECK-NEXT:    bx lr
  %tmp4 = zext <2 x i32> %B to <2 x i64>
  %tmp5 = zext <2 x i32> %C to <2 x i64>
  %tmp6 = mul <2 x i64> %tmp4, %tmp5
  %tmp7 = sub <2 x i64> %A, %tmp6
  %and = and <2 x i64> %tmp7, <i64 4294967295, i64 4294967295>
  ret <2 x i64> %and
}

define arm_aapcs_vfpcc <4 x i32> @test_vmlsl_lanes16(<4 x i32> %arg0_int32x4_t, <4 x i16> %arg1_int16x4_t, <4 x i16> %arg2_int16x4_t) nounwind readnone {
; CHECK-LABEL: test_vmlsl_lanes16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlsl.s16 q0, d2, d3[1]
; CHECK-NEXT:    bx lr
entry:
  %0 = shufflevector <4 x i16> %arg2_int16x4_t, <4 x i16> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1> ; <<4 x i16>> [#uses=1]
  %1 = sext <4 x i16> %arg1_int16x4_t to <4 x i32>
  %2 = sext <4 x i16> %0 to <4 x i32>
  %3 = mul <4 x i32> %1, %2
  %4 = sub <4 x i32> %arg0_int32x4_t, %3
  ret <4 x i32> %4
}

define arm_aapcs_vfpcc <2 x i64> @test_vmlsl_lanes32(<2 x i64> %arg0_int64x2_t, <2 x i32> %arg1_int32x2_t, <2 x i32> %arg2_int32x2_t) nounwind readnone {
; CHECK-LABEL: test_vmlsl_lanes32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlsl.s32 q0, d2, d3[1]
; CHECK-NEXT:    bx lr
entry:
  %0 = shufflevector <2 x i32> %arg2_int32x2_t, <2 x i32> undef, <2 x i32> <i32 1, i32 1> ; <<2 x i32>> [#uses=1]
  %1 = sext <2 x i32> %arg1_int32x2_t to <2 x i64>
  %2 = sext <2 x i32> %0 to <2 x i64>
  %3 = mul <2 x i64> %1, %2
  %4 = sub <2 x i64> %arg0_int64x2_t, %3
  ret <2 x i64> %4
}

define arm_aapcs_vfpcc <4 x i32> @test_vmlsl_laneu16(<4 x i32> %arg0_uint32x4_t, <4 x i16> %arg1_uint16x4_t, <4 x i16> %arg2_uint16x4_t) nounwind readnone {
; CHECK-LABEL: test_vmlsl_laneu16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlsl.u16 q0, d2, d3[1]
; CHECK-NEXT:    bx lr
entry:
  %0 = shufflevector <4 x i16> %arg2_uint16x4_t, <4 x i16> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1> ; <<4 x i16>> [#uses=1]
  %1 = zext <4 x i16> %arg1_uint16x4_t to <4 x i32>
  %2 = zext <4 x i16> %0 to <4 x i32>
  %3 = mul <4 x i32> %1, %2
  %4 = sub <4 x i32> %arg0_uint32x4_t, %3
  ret <4 x i32> %4
}

define arm_aapcs_vfpcc <2 x i64> @test_vmlsl_laneu32(<2 x i64> %arg0_uint64x2_t, <2 x i32> %arg1_uint32x2_t, <2 x i32> %arg2_uint32x2_t) nounwind readnone {
; CHECK-LABEL: test_vmlsl_laneu32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlsl.u32 q0, d2, d3[1]
; CHECK-NEXT:    bx lr
entry:
  %0 = shufflevector <2 x i32> %arg2_uint32x2_t, <2 x i32> undef, <2 x i32> <i32 1, i32 1> ; <<2 x i32>> [#uses=1]
  %1 = zext <2 x i32> %arg1_uint32x2_t to <2 x i64>
  %2 = zext <2 x i32> %0 to <2 x i64>
  %3 = mul <2 x i64> %1, %2
  %4 = sub <2 x i64> %arg0_uint64x2_t, %3
  ret <2 x i64> %4
}

define arm_aapcs_vfpcc <4 x i32> @test_vmlsl_lanea16(<4 x i32> %arg0_uint32x4_t, <4 x i16> %arg1_uint16x4_t, <4 x i16> %arg2_uint16x4_t) nounwind readnone {
; CHECK-LABEL: test_vmlsl_lanea16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlsl.u16 q0, d2, d3[1]
; CHECK-NEXT:    vmov.i32 q8, #0xffff
; CHECK-NEXT:    vand q0, q0, q8
; CHECK-NEXT:    bx lr
entry:
  %0 = shufflevector <4 x i16> %arg2_uint16x4_t, <4 x i16> undef, <4 x i32> <i32 1, i32 1, i32 1, i32 1> ; <<4 x i16>> [#uses=1]
  %1 = zext <4 x i16> %arg1_uint16x4_t to <4 x i32>
  %2 = zext <4 x i16> %0 to <4 x i32>
  %3 = mul <4 x i32> %1, %2
  %4 = sub <4 x i32> %arg0_uint32x4_t, %3
  %and = and <4 x i32> %4, <i32 65535, i32 65535, i32 65535, i32 65535>
  ret <4 x i32> %and
}

define arm_aapcs_vfpcc <2 x i64> @test_vmlsl_lanea32(<2 x i64> %arg0_uint64x2_t, <2 x i32> %arg1_uint32x2_t, <2 x i32> %arg2_uint32x2_t) nounwind readnone {
; CHECK-LABEL: test_vmlsl_lanea32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmlsl.u32 q0, d2, d3[1]
; CHECK-NEXT:    vmov.i64 q8, #0xffffffff
; CHECK-NEXT:    vand q0, q0, q8
; CHECK-NEXT:    bx lr
entry:
  %0 = shufflevector <2 x i32> %arg2_uint32x2_t, <2 x i32> undef, <2 x i32> <i32 1, i32 1> ; <<2 x i32>> [#uses=1]
  %1 = zext <2 x i32> %arg1_uint32x2_t to <2 x i64>
  %2 = zext <2 x i32> %0 to <2 x i64>
  %3 = mul <2 x i64> %1, %2
  %4 = sub <2 x i64> %arg0_uint64x2_t, %3
  %and = and <2 x i64> %4, <i64 4294967295, i64 4294967295>
  ret <2 x i64> %and
}
