; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+d \
; RUN:   -verify-machineinstrs -disable-strictnode-mutation -target-abi=ilp32d \
; RUN:   | FileCheck -check-prefixes=CHECKIFD,RV32IFD %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+d \
; RUN:   -verify-machineinstrs -disable-strictnode-mutation -target-abi=lp64d \
; RUN:   | FileCheck -check-prefixes=CHECKIFD,RV64IFD %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+zdinx \
; RUN:   -verify-machineinstrs -disable-strictnode-mutation -target-abi=ilp32 \
; RUN:   | FileCheck -check-prefix=RV32IZFINXZDINX %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+zdinx \
; RUN:   -verify-machineinstrs -disable-strictnode-mutation -target-abi=lp64 \
; RUN:   | FileCheck -check-prefix=RV64IZFINXZDINX %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 \
; RUN:   -verify-machineinstrs -disable-strictnode-mutation \
; RUN:   | FileCheck -check-prefix=RV32I %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 \
; RUN:   -verify-machineinstrs -disable-strictnode-mutation \
; RUN:   | FileCheck -check-prefix=RV64I %s

declare double @llvm.experimental.constrained.sqrt.f64(double, metadata, metadata)

define double @sqrt_f64(double %a) nounwind strictfp {
; CHECKIFD-LABEL: sqrt_f64:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fsqrt.d fa0, fa0
; CHECKIFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: sqrt_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fsqrt.d a0, a0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: sqrt_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fsqrt.d a0, a0
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: sqrt_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call sqrt
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: sqrt_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call sqrt
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.sqrt.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.powi.f64.i32(double, i32, metadata, metadata)

define double @powi_f64(double %a, i32 %b) nounwind strictfp {
; RV32IFD-LABEL: powi_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call __powidf2
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: powi_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    sext.w a0, a0
; RV64IFD-NEXT:    call __powidf2
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: powi_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call __powidf2
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: powi_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    sext.w a1, a1
; RV64IZFINXZDINX-NEXT:    call __powidf2
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: powi_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call __powidf2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: powi_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sext.w a1, a1
; RV64I-NEXT:    call __powidf2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.powi.f64.i32(double %a, i32 %b, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.sin.f64(double, metadata, metadata)

define double @sin_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: sin_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call sin
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: sin_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call sin
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: sin_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call sin
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: sin_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call sin
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: sin_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call sin
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: sin_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call sin
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.sin.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.cos.f64(double, metadata, metadata)

define double @cos_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: cos_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call cos
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: cos_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call cos
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: cos_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call cos
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: cos_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call cos
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: cos_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call cos
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: cos_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call cos
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.cos.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

; The sin+cos combination results in an FSINCOS SelectionDAG node.
define double @sincos_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: sincos_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -32
; RV32IFD-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; RV32IFD-NEXT:    fsd fs1, 8(sp) # 8-byte Folded Spill
; RV32IFD-NEXT:    fmv.d fs0, fa0
; RV32IFD-NEXT:    call sin
; RV32IFD-NEXT:    fmv.d fs1, fa0
; RV32IFD-NEXT:    fmv.d fa0, fs0
; RV32IFD-NEXT:    call cos
; RV32IFD-NEXT:    fadd.d fa0, fs1, fa0
; RV32IFD-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; RV32IFD-NEXT:    fld fs1, 8(sp) # 8-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 32
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: sincos_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -32
; RV64IFD-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    fsd fs1, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    fmv.d fs0, fa0
; RV64IFD-NEXT:    call sin
; RV64IFD-NEXT:    fmv.d fs1, fa0
; RV64IFD-NEXT:    fmv.d fa0, fs0
; RV64IFD-NEXT:    call cos
; RV64IFD-NEXT:    fadd.d fa0, fs1, fa0
; RV64IFD-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    fld fs1, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 32
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: sincos_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -32
; RV32IZFINXZDINX-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    mv s0, a1
; RV32IZFINXZDINX-NEXT:    mv s1, a0
; RV32IZFINXZDINX-NEXT:    call sin
; RV32IZFINXZDINX-NEXT:    mv s2, a0
; RV32IZFINXZDINX-NEXT:    mv s3, a1
; RV32IZFINXZDINX-NEXT:    mv a0, s1
; RV32IZFINXZDINX-NEXT:    mv a1, s0
; RV32IZFINXZDINX-NEXT:    call cos
; RV32IZFINXZDINX-NEXT:    fadd.d a0, s2, a0
; RV32IZFINXZDINX-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 32
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: sincos_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -32
; RV64IZFINXZDINX-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    mv s0, a0
; RV64IZFINXZDINX-NEXT:    call sin
; RV64IZFINXZDINX-NEXT:    mv s1, a0
; RV64IZFINXZDINX-NEXT:    mv a0, s0
; RV64IZFINXZDINX-NEXT:    call cos
; RV64IZFINXZDINX-NEXT:    fadd.d a0, s1, a0
; RV64IZFINXZDINX-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 32
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: sincos_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -32
; RV32I-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 20(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s2, 16(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a1
; RV32I-NEXT:    mv s1, a0
; RV32I-NEXT:    call sin
; RV32I-NEXT:    mv s2, a0
; RV32I-NEXT:    mv s3, a1
; RV32I-NEXT:    mv a0, s1
; RV32I-NEXT:    mv a1, s0
; RV32I-NEXT:    call cos
; RV32I-NEXT:    mv a2, a0
; RV32I-NEXT:    mv a3, a1
; RV32I-NEXT:    mv a0, s2
; RV32I-NEXT:    mv a1, s3
; RV32I-NEXT:    call __adddf3
; RV32I-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 20(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s2, 16(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 32
; RV32I-NEXT:    ret
;
; RV64I-LABEL: sincos_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a0
; RV64I-NEXT:    call sin
; RV64I-NEXT:    mv s1, a0
; RV64I-NEXT:    mv a0, s0
; RV64I-NEXT:    call cos
; RV64I-NEXT:    mv a1, a0
; RV64I-NEXT:    mv a0, s1
; RV64I-NEXT:    call __adddf3
; RV64I-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.sin.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  %2 = call double @llvm.experimental.constrained.cos.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  %3 = fadd double %1, %2
  ret double %3
}

declare double @llvm.experimental.constrained.tan.f64(double, metadata, metadata)

define double @tan_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: tan_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call tan
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: tan_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call tan
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: tan_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call tan
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: tan_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call tan
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: tan_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call tan
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: tan_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call tan
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.tan.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.pow.f64(double, double, metadata, metadata)

define double @pow_f64(double %a, double %b) nounwind strictfp {
; RV32IFD-LABEL: pow_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call pow
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: pow_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call pow
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: pow_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call pow
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: pow_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call pow
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: pow_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call pow
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: pow_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call pow
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.pow.f64(double %a, double %b, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.exp.f64(double, metadata, metadata)

define double @exp_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: exp_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call exp
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: exp_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call exp
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: exp_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call exp
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: exp_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call exp
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: exp_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call exp
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: exp_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call exp
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.exp.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.exp2.f64(double, metadata, metadata)

define double @exp2_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: exp2_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call exp2
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: exp2_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call exp2
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: exp2_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call exp2
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: exp2_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call exp2
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: exp2_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call exp2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: exp2_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call exp2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.exp2.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.log.f64(double, metadata, metadata)

define double @log_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: log_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call log
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: log_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call log
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: log_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call log
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: log_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call log
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: log_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call log
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: log_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call log
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.log.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.log10.f64(double, metadata, metadata)

define double @log10_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: log10_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call log10
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: log10_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call log10
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: log10_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call log10
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: log10_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call log10
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: log10_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call log10
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: log10_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call log10
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.log10.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.log2.f64(double, metadata, metadata)

define double @log2_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: log2_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call log2
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: log2_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call log2
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: log2_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call log2
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: log2_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call log2
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: log2_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call log2
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: log2_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call log2
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.log2.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.fma.f64(double, double, double, metadata, metadata)

define double @fma_f64(double %a, double %b, double %c) nounwind strictfp {
; CHECKIFD-LABEL: fma_f64:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fmadd.d fa0, fa0, fa1, fa2
; CHECKIFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: fma_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fmadd.d a0, a0, a2, a4
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: fma_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fmadd.d a0, a0, a1, a2
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: fma_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call fma
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fma_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call fma
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.fma.f64(double %a, double %b, double %c, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.fmuladd.f64(double, double, double, metadata, metadata)

define double @fmuladd_f64(double %a, double %b, double %c) nounwind strictfp {
; CHECKIFD-LABEL: fmuladd_f64:
; CHECKIFD:       # %bb.0:
; CHECKIFD-NEXT:    fmadd.d fa0, fa0, fa1, fa2
; CHECKIFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: fmuladd_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fmadd.d a0, a0, a2, a4
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: fmuladd_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fmadd.d a0, a0, a1, a2
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: fmuladd_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    mv s0, a5
; RV32I-NEXT:    mv s1, a4
; RV32I-NEXT:    call __muldf3
; RV32I-NEXT:    mv a2, s1
; RV32I-NEXT:    mv a3, s0
; RV32I-NEXT:    call __adddf3
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: fmuladd_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    mv s0, a2
; RV64I-NEXT:    call __muldf3
; RV64I-NEXT:    mv a1, s0
; RV64I-NEXT:    call __adddf3
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.fmuladd.f64(double %a, double %b, double %c, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.minnum.f64(double, double, metadata)

define double @minnum_f64(double %a, double %b) nounwind strictfp {
; RV32IFD-LABEL: minnum_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call fmin
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: minnum_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call fmin
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: minnum_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call fmin
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: minnum_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call fmin
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: minnum_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call fmin
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: minnum_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call fmin
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.minnum.f64(double %a, double %b, metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.maxnum.f64(double, double, metadata)

define double @maxnum_f64(double %a, double %b) nounwind strictfp {
; RV32IFD-LABEL: maxnum_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call fmax
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: maxnum_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call fmax
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: maxnum_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call fmax
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: maxnum_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call fmax
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: maxnum_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call fmax
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: maxnum_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call fmax
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.maxnum.f64(double %a, double %b, metadata !"fpexcept.strict") strictfp
  ret double %1
}

; TODO: FMINNAN and FMAXNAN aren't handled in
; SelectionDAGLegalize::ExpandNode.

; declare double @llvm.experimental.constrained.minimum.f64(double, double, metadata)

; define double @fminimum_f64(double %a, double %b) nounwind strictfp {
;   %1 = call double @llvm.experimental.constrained.minimum.f64(double %a, double %b, metadata !"fpexcept.strict") strictfp
;   ret double %1
; }

; declare double @llvm.experimental.constrained.maximum.f64(double, double, metadata)

; define double @fmaximum_f64(double %a, double %b) nounwind strictfp {
;   %1 = call double @llvm.experimental.constrained.maximum.f64(double %a, double %b, metadata !"fpexcept.strict") strictfp
;   ret double %1
; }

declare double @llvm.experimental.constrained.floor.f64(double, metadata)

define double @floor_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: floor_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call floor
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: floor_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call floor
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: floor_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call floor
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: floor_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call floor
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: floor_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call floor
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: floor_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call floor
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.floor.f64(double %a, metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.ceil.f64(double, metadata)

define double @ceil_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: ceil_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call ceil
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: ceil_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call ceil
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: ceil_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call ceil
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: ceil_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call ceil
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: ceil_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call ceil
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ceil_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call ceil
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.ceil.f64(double %a, metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.trunc.f64(double, metadata)

define double @trunc_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: trunc_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call trunc
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: trunc_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call trunc
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: trunc_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call trunc
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: trunc_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call trunc
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: trunc_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call trunc
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: trunc_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call trunc
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.trunc.f64(double %a, metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.rint.f64(double, metadata, metadata)

define double @rint_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: rint_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call rint
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: rint_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call rint
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: rint_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call rint
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: rint_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call rint
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: rint_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call rint
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: rint_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call rint
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.rint.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.nearbyint.f64(double, metadata, metadata)

define double @nearbyint_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: nearbyint_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call nearbyint
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: nearbyint_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call nearbyint
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: nearbyint_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call nearbyint
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: nearbyint_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call nearbyint
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: nearbyint_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call nearbyint
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: nearbyint_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call nearbyint
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.nearbyint.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.round.f64(double, metadata)

define double @round_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: round_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call round
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: round_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call round
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: round_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call round
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: round_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call round
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: round_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call round
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: round_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call round
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.round.f64(double %a, metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare double @llvm.experimental.constrained.roundeven.f64(double, metadata)

define double @roundeven_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: roundeven_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call roundeven
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: roundeven_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    addi sp, sp, -16
; RV64IFD-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFD-NEXT:    call roundeven
; RV64IFD-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFD-NEXT:    addi sp, sp, 16
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: roundeven_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call roundeven
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: roundeven_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV64IZFINXZDINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFINXZDINX-NEXT:    call roundeven
; RV64IZFINXZDINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: roundeven_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call roundeven
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: roundeven_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call roundeven
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.roundeven.f64(double %a, metadata !"fpexcept.strict") strictfp
  ret double %1
}

declare iXLen @llvm.experimental.constrained.lrint.iXLen.f64(double, metadata, metadata)

define iXLen @lrint_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: lrint_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.w.d a0, fa0
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: lrint_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: lrint_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: lrint_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: lrint_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call lrint
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: lrint_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call lrint
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call iXLen @llvm.experimental.constrained.lrint.iXLen.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret iXLen %1
}

declare iXLen @llvm.experimental.constrained.lround.iXLen.f64(double, metadata)

define iXLen @lround_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: lround_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    fcvt.w.d a0, fa0, rmm
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: lround_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rmm
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: lround_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    fcvt.w.d a0, a0, rmm
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: lround_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rmm
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: lround_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call lround
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: lround_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call lround
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call iXLen @llvm.experimental.constrained.lround.iXLen.f64(double %a, metadata !"fpexcept.strict") strictfp
  ret iXLen %1
}

declare i64 @llvm.experimental.constrained.llrint.i64.f64(double, metadata, metadata)

define i64 @llrint_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: llrint_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call llrint
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: llrint_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: llrint_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call llrint
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: llrint_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: llrint_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call llrint
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: llrint_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call llrint
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call i64 @llvm.experimental.constrained.llrint.i64.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict") strictfp
  ret i64 %1
}

declare i64 @llvm.experimental.constrained.llround.i64.f64(double, metadata)

define i64 @llround_f64(double %a) nounwind strictfp {
; RV32IFD-LABEL: llround_f64:
; RV32IFD:       # %bb.0:
; RV32IFD-NEXT:    addi sp, sp, -16
; RV32IFD-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFD-NEXT:    call llround
; RV32IFD-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFD-NEXT:    addi sp, sp, 16
; RV32IFD-NEXT:    ret
;
; RV64IFD-LABEL: llround_f64:
; RV64IFD:       # %bb.0:
; RV64IFD-NEXT:    fcvt.l.d a0, fa0, rmm
; RV64IFD-NEXT:    ret
;
; RV32IZFINXZDINX-LABEL: llround_f64:
; RV32IZFINXZDINX:       # %bb.0:
; RV32IZFINXZDINX-NEXT:    addi sp, sp, -16
; RV32IZFINXZDINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFINXZDINX-NEXT:    call llround
; RV32IZFINXZDINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFINXZDINX-NEXT:    addi sp, sp, 16
; RV32IZFINXZDINX-NEXT:    ret
;
; RV64IZFINXZDINX-LABEL: llround_f64:
; RV64IZFINXZDINX:       # %bb.0:
; RV64IZFINXZDINX-NEXT:    fcvt.l.d a0, a0, rmm
; RV64IZFINXZDINX-NEXT:    ret
;
; RV32I-LABEL: llround_f64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    call llround
; RV32I-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    ret
;
; RV64I-LABEL: llround_f64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    call llround
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
  %1 = call i64 @llvm.experimental.constrained.llround.i64.f64(double %a, metadata !"fpexcept.strict") strictfp
  ret i64 %1
}
