; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+zvfh,+v,+m -target-abi=ilp32d \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+zvfh,+v,+m -target-abi=lp64d \
; RUN:   -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64

declare <2 x i8> @llvm.vp.bitreverse.v2i8(<2 x i8>, <2 x i1>, i32)

define <2 x i8> @vp_bitreverse_v2i8(<2 x i8> %va, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vand.vi v9, v8, 15, v0.t
; CHECK-NEXT:    vsll.vi v9, v9, 4, v0.t
; CHECK-NEXT:    vsrl.vi v8, v8, 4, v0.t
; CHECK-NEXT:    vand.vi v8, v8, 15, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 2, v0.t
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 1, v0.t
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <2 x i8> @llvm.vp.bitreverse.v2i8(<2 x i8> %va, <2 x i1> %m, i32 %evl)
  ret <2 x i8> %v
}

define <2 x i8> @vp_bitreverse_v2i8_unmasked(<2 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v2i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vand.vi v9, v8, 15
; CHECK-NEXT:    vsll.vi v9, v9, 4
; CHECK-NEXT:    vsrl.vi v8, v8, 4
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vsrl.vi v9, v8, 2
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 2
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    ret
  %v = call <2 x i8> @llvm.vp.bitreverse.v2i8(<2 x i8> %va, <2 x i1> splat (i1 true), i32 %evl)
  ret <2 x i8> %v
}

declare <4 x i8> @llvm.vp.bitreverse.v4i8(<4 x i8>, <4 x i1>, i32)

define <4 x i8> @vp_bitreverse_v4i8(<4 x i8> %va, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vand.vi v9, v8, 15, v0.t
; CHECK-NEXT:    vsll.vi v9, v9, 4, v0.t
; CHECK-NEXT:    vsrl.vi v8, v8, 4, v0.t
; CHECK-NEXT:    vand.vi v8, v8, 15, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 2, v0.t
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 1, v0.t
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <4 x i8> @llvm.vp.bitreverse.v4i8(<4 x i8> %va, <4 x i1> %m, i32 %evl)
  ret <4 x i8> %v
}

define <4 x i8> @vp_bitreverse_v4i8_unmasked(<4 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v4i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vand.vi v9, v8, 15
; CHECK-NEXT:    vsll.vi v9, v9, 4
; CHECK-NEXT:    vsrl.vi v8, v8, 4
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vsrl.vi v9, v8, 2
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 2
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    ret
  %v = call <4 x i8> @llvm.vp.bitreverse.v4i8(<4 x i8> %va, <4 x i1> splat (i1 true), i32 %evl)
  ret <4 x i8> %v
}

declare <8 x i8> @llvm.vp.bitreverse.v8i8(<8 x i8>, <8 x i1>, i32)

define <8 x i8> @vp_bitreverse_v8i8(<8 x i8> %va, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vand.vi v9, v8, 15, v0.t
; CHECK-NEXT:    vsll.vi v9, v9, 4, v0.t
; CHECK-NEXT:    vsrl.vi v8, v8, 4, v0.t
; CHECK-NEXT:    vand.vi v8, v8, 15, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 2, v0.t
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 1, v0.t
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <8 x i8> @llvm.vp.bitreverse.v8i8(<8 x i8> %va, <8 x i1> %m, i32 %evl)
  ret <8 x i8> %v
}

define <8 x i8> @vp_bitreverse_v8i8_unmasked(<8 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v8i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vand.vi v9, v8, 15
; CHECK-NEXT:    vsll.vi v9, v9, 4
; CHECK-NEXT:    vsrl.vi v8, v8, 4
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vsrl.vi v9, v8, 2
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 2
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    ret
  %v = call <8 x i8> @llvm.vp.bitreverse.v8i8(<8 x i8> %va, <8 x i1> splat (i1 true), i32 %evl)
  ret <8 x i8> %v
}

declare <16 x i8> @llvm.vp.bitreverse.v16i8(<16 x i8>, <16 x i1>, i32)

define <16 x i8> @vp_bitreverse_v16i8(<16 x i8> %va, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vand.vi v9, v8, 15, v0.t
; CHECK-NEXT:    vsll.vi v9, v9, 4, v0.t
; CHECK-NEXT:    vsrl.vi v8, v8, 4, v0.t
; CHECK-NEXT:    vand.vi v8, v8, 15, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 2, v0.t
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 1, v0.t
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <16 x i8> @llvm.vp.bitreverse.v16i8(<16 x i8> %va, <16 x i1> %m, i32 %evl)
  ret <16 x i8> %v
}

define <16 x i8> @vp_bitreverse_v16i8_unmasked(<16 x i8> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v16i8_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vand.vi v9, v8, 15
; CHECK-NEXT:    vsll.vi v9, v9, 4
; CHECK-NEXT:    vsrl.vi v8, v8, 4
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vsrl.vi v9, v8, 2
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 2
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    ret
  %v = call <16 x i8> @llvm.vp.bitreverse.v16i8(<16 x i8> %va, <16 x i1> splat (i1 true), i32 %evl)
  ret <16 x i8> %v
}

declare <2 x i16> @llvm.vp.bitreverse.v2i16(<2 x i16>, <2 x i1>, i32)

define <2 x i16> @vp_bitreverse_v2i16(<2 x i16> %va, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 4, v0.t
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 2, v0.t
; CHECK-NEXT:    lui a0, 3
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 1, v0.t
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <2 x i16> @llvm.vp.bitreverse.v2i16(<2 x i16> %va, <2 x i1> %m, i32 %evl)
  ret <2 x i16> %v
}

define <2 x i16> @vp_bitreverse_v2i16_unmasked(<2 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v2i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8
; CHECK-NEXT:    vsll.vi v8, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vsrl.vi v9, v8, 4
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 4
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 2
; CHECK-NEXT:    lui a0, 3
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 2
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    ret
  %v = call <2 x i16> @llvm.vp.bitreverse.v2i16(<2 x i16> %va, <2 x i1> splat (i1 true), i32 %evl)
  ret <2 x i16> %v
}

declare <4 x i16> @llvm.vp.bitreverse.v4i16(<4 x i16>, <4 x i1>, i32)

define <4 x i16> @vp_bitreverse_v4i16(<4 x i16> %va, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 4, v0.t
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 2, v0.t
; CHECK-NEXT:    lui a0, 3
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 1, v0.t
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <4 x i16> @llvm.vp.bitreverse.v4i16(<4 x i16> %va, <4 x i1> %m, i32 %evl)
  ret <4 x i16> %v
}

define <4 x i16> @vp_bitreverse_v4i16_unmasked(<4 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v4i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8
; CHECK-NEXT:    vsll.vi v8, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vsrl.vi v9, v8, 4
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 4
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 2
; CHECK-NEXT:    lui a0, 3
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 2
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    ret
  %v = call <4 x i16> @llvm.vp.bitreverse.v4i16(<4 x i16> %va, <4 x i1> splat (i1 true), i32 %evl)
  ret <4 x i16> %v
}

declare <8 x i16> @llvm.vp.bitreverse.v8i16(<8 x i16>, <8 x i1>, i32)

define <8 x i16> @vp_bitreverse_v8i16(<8 x i16> %va, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 4, v0.t
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 2, v0.t
; CHECK-NEXT:    lui a0, 3
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 1, v0.t
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <8 x i16> @llvm.vp.bitreverse.v8i16(<8 x i16> %va, <8 x i1> %m, i32 %evl)
  ret <8 x i16> %v
}

define <8 x i16> @vp_bitreverse_v8i16_unmasked(<8 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v8i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8
; CHECK-NEXT:    vsll.vi v8, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vsrl.vi v9, v8, 4
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 4
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 2
; CHECK-NEXT:    lui a0, 3
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 2
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    ret
  %v = call <8 x i16> @llvm.vp.bitreverse.v8i16(<8 x i16> %va, <8 x i1> splat (i1 true), i32 %evl)
  ret <8 x i16> %v
}

declare <16 x i16> @llvm.vp.bitreverse.v16i16(<16 x i16>, <16 x i1>, i32)

define <16 x i16> @vp_bitreverse_v16i16(<16 x i16> %va, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vsrl.vi v10, v8, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v10, v0.t
; CHECK-NEXT:    vsrl.vi v10, v8, 4, v0.t
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v10, v10, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v10, v8, v0.t
; CHECK-NEXT:    vsrl.vi v10, v8, 2, v0.t
; CHECK-NEXT:    lui a0, 3
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v10, v10, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v10, v8, v0.t
; CHECK-NEXT:    vsrl.vi v10, v8, 1, v0.t
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v10, v10, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v10, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <16 x i16> @llvm.vp.bitreverse.v16i16(<16 x i16> %va, <16 x i1> %m, i32 %evl)
  ret <16 x i16> %v
}

define <16 x i16> @vp_bitreverse_v16i16_unmasked(<16 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v16i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vsrl.vi v10, v8, 8
; CHECK-NEXT:    vsll.vi v8, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v10
; CHECK-NEXT:    vsrl.vi v10, v8, 4
; CHECK-NEXT:    lui a0, 1
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v10, v10, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 4
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    vsrl.vi v10, v8, 2
; CHECK-NEXT:    lui a0, 3
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v10, v10, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 2
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    vsrl.vi v10, v8, 1
; CHECK-NEXT:    lui a0, 5
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v10, v10, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
  %v = call <16 x i16> @llvm.vp.bitreverse.v16i16(<16 x i16> %va, <16 x i1> splat (i1 true), i32 %evl)
  ret <16 x i16> %v
}

declare <2 x i32> @llvm.vp.bitreverse.v2i32(<2 x i32>, <2 x i1>, i32)

define <2 x i32> @vp_bitreverse_v2i32(<2 x i32> %va, <2 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8, v0.t
; CHECK-NEXT:    lui a0, 16
; CHECK-NEXT:    addi a0, a0, -256
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vsrl.vi v10, v8, 24, v0.t
; CHECK-NEXT:    vor.vv v9, v9, v10, v0.t
; CHECK-NEXT:    vand.vx v10, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v10, v10, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 24, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 4, v0.t
; CHECK-NEXT:    lui a0, 61681
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 2, v0.t
; CHECK-NEXT:    lui a0, 209715
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 1, v0.t
; CHECK-NEXT:    lui a0, 349525
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <2 x i32> @llvm.vp.bitreverse.v2i32(<2 x i32> %va, <2 x i1> %m, i32 %evl)
  ret <2 x i32> %v
}

define <2 x i32> @vp_bitreverse_v2i32_unmasked(<2 x i32> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v2i32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8
; CHECK-NEXT:    lui a0, 16
; CHECK-NEXT:    addi a0, a0, -256
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vsrl.vi v10, v8, 24
; CHECK-NEXT:    vor.vv v9, v9, v10
; CHECK-NEXT:    vand.vx v10, v8, a0
; CHECK-NEXT:    vsll.vi v10, v10, 8
; CHECK-NEXT:    vsll.vi v8, v8, 24
; CHECK-NEXT:    vor.vv v8, v8, v10
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vsrl.vi v9, v8, 4
; CHECK-NEXT:    lui a0, 61681
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 4
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 2
; CHECK-NEXT:    lui a0, 209715
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 2
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    lui a0, 349525
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    ret
  %v = call <2 x i32> @llvm.vp.bitreverse.v2i32(<2 x i32> %va, <2 x i1> splat (i1 true), i32 %evl)
  ret <2 x i32> %v
}

declare <4 x i32> @llvm.vp.bitreverse.v4i32(<4 x i32>, <4 x i1>, i32)

define <4 x i32> @vp_bitreverse_v4i32(<4 x i32> %va, <4 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8, v0.t
; CHECK-NEXT:    lui a0, 16
; CHECK-NEXT:    addi a0, a0, -256
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vsrl.vi v10, v8, 24, v0.t
; CHECK-NEXT:    vor.vv v9, v9, v10, v0.t
; CHECK-NEXT:    vand.vx v10, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v10, v10, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 24, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v10, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v9, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 4, v0.t
; CHECK-NEXT:    lui a0, 61681
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 2, v0.t
; CHECK-NEXT:    lui a0, 209715
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    vsrl.vi v9, v8, 1, v0.t
; CHECK-NEXT:    lui a0, 349525
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v9, v9, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v9, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <4 x i32> @llvm.vp.bitreverse.v4i32(<4 x i32> %va, <4 x i1> %m, i32 %evl)
  ret <4 x i32> %v
}

define <4 x i32> @vp_bitreverse_v4i32_unmasked(<4 x i32> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v4i32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vsrl.vi v9, v8, 8
; CHECK-NEXT:    lui a0, 16
; CHECK-NEXT:    addi a0, a0, -256
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vsrl.vi v10, v8, 24
; CHECK-NEXT:    vor.vv v9, v9, v10
; CHECK-NEXT:    vand.vx v10, v8, a0
; CHECK-NEXT:    vsll.vi v10, v10, 8
; CHECK-NEXT:    vsll.vi v8, v8, 24
; CHECK-NEXT:    vor.vv v8, v8, v10
; CHECK-NEXT:    vor.vv v8, v8, v9
; CHECK-NEXT:    vsrl.vi v9, v8, 4
; CHECK-NEXT:    lui a0, 61681
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 4
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 2
; CHECK-NEXT:    lui a0, 209715
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 2
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    vsrl.vi v9, v8, 1
; CHECK-NEXT:    lui a0, 349525
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v9, v9, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vor.vv v8, v9, v8
; CHECK-NEXT:    ret
  %v = call <4 x i32> @llvm.vp.bitreverse.v4i32(<4 x i32> %va, <4 x i1> splat (i1 true), i32 %evl)
  ret <4 x i32> %v
}

declare <8 x i32> @llvm.vp.bitreverse.v8i32(<8 x i32>, <8 x i1>, i32)

define <8 x i32> @vp_bitreverse_v8i32(<8 x i32> %va, <8 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vsrl.vi v10, v8, 8, v0.t
; CHECK-NEXT:    lui a0, 16
; CHECK-NEXT:    addi a0, a0, -256
; CHECK-NEXT:    vand.vx v10, v10, a0, v0.t
; CHECK-NEXT:    vsrl.vi v12, v8, 24, v0.t
; CHECK-NEXT:    vor.vv v10, v10, v12, v0.t
; CHECK-NEXT:    vand.vx v12, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v12, v12, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 24, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v10, v0.t
; CHECK-NEXT:    vsrl.vi v10, v8, 4, v0.t
; CHECK-NEXT:    lui a0, 61681
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v10, v10, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v10, v8, v0.t
; CHECK-NEXT:    vsrl.vi v10, v8, 2, v0.t
; CHECK-NEXT:    lui a0, 209715
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v10, v10, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v10, v8, v0.t
; CHECK-NEXT:    vsrl.vi v10, v8, 1, v0.t
; CHECK-NEXT:    lui a0, 349525
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v10, v10, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v10, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <8 x i32> @llvm.vp.bitreverse.v8i32(<8 x i32> %va, <8 x i1> %m, i32 %evl)
  ret <8 x i32> %v
}

define <8 x i32> @vp_bitreverse_v8i32_unmasked(<8 x i32> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v8i32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vsrl.vi v10, v8, 8
; CHECK-NEXT:    lui a0, 16
; CHECK-NEXT:    addi a0, a0, -256
; CHECK-NEXT:    vand.vx v10, v10, a0
; CHECK-NEXT:    vsrl.vi v12, v8, 24
; CHECK-NEXT:    vor.vv v10, v10, v12
; CHECK-NEXT:    vand.vx v12, v8, a0
; CHECK-NEXT:    vsll.vi v12, v12, 8
; CHECK-NEXT:    vsll.vi v8, v8, 24
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vor.vv v8, v8, v10
; CHECK-NEXT:    vsrl.vi v10, v8, 4
; CHECK-NEXT:    lui a0, 61681
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v10, v10, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 4
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    vsrl.vi v10, v8, 2
; CHECK-NEXT:    lui a0, 209715
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v10, v10, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 2
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    vsrl.vi v10, v8, 1
; CHECK-NEXT:    lui a0, 349525
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v10, v10, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vor.vv v8, v10, v8
; CHECK-NEXT:    ret
  %v = call <8 x i32> @llvm.vp.bitreverse.v8i32(<8 x i32> %va, <8 x i1> splat (i1 true), i32 %evl)
  ret <8 x i32> %v
}

declare <16 x i32> @llvm.vp.bitreverse.v16i32(<16 x i32>, <16 x i1>, i32)

define <16 x i32> @vp_bitreverse_v16i32(<16 x i32> %va, <16 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v12, v8, 8, v0.t
; CHECK-NEXT:    lui a0, 16
; CHECK-NEXT:    addi a0, a0, -256
; CHECK-NEXT:    vand.vx v12, v12, a0, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 24, v0.t
; CHECK-NEXT:    vor.vv v12, v12, v16, v0.t
; CHECK-NEXT:    vand.vx v16, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v16, v16, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 24, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v12, v0.t
; CHECK-NEXT:    vsrl.vi v12, v8, 4, v0.t
; CHECK-NEXT:    lui a0, 61681
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v12, v12, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v12, v8, v0.t
; CHECK-NEXT:    vsrl.vi v12, v8, 2, v0.t
; CHECK-NEXT:    lui a0, 209715
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v12, v12, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v12, v8, v0.t
; CHECK-NEXT:    vsrl.vi v12, v8, 1, v0.t
; CHECK-NEXT:    lui a0, 349525
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v12, v12, a0, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a0, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v12, v8, v0.t
; CHECK-NEXT:    ret
  %v = call <16 x i32> @llvm.vp.bitreverse.v16i32(<16 x i32> %va, <16 x i1> %m, i32 %evl)
  ret <16 x i32> %v
}

define <16 x i32> @vp_bitreverse_v16i32_unmasked(<16 x i32> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v16i32_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vsrl.vi v12, v8, 8
; CHECK-NEXT:    lui a0, 16
; CHECK-NEXT:    addi a0, a0, -256
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    vsrl.vi v16, v8, 24
; CHECK-NEXT:    vor.vv v12, v12, v16
; CHECK-NEXT:    vand.vx v16, v8, a0
; CHECK-NEXT:    vsll.vi v16, v16, 8
; CHECK-NEXT:    vsll.vi v8, v8, 24
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    lui a0, 61681
; CHECK-NEXT:    addi a0, a0, -241
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 4
; CHECK-NEXT:    vor.vv v8, v12, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 2
; CHECK-NEXT:    lui a0, 209715
; CHECK-NEXT:    addi a0, a0, 819
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vsll.vi v8, v8, 2
; CHECK-NEXT:    vor.vv v8, v12, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    lui a0, 349525
; CHECK-NEXT:    addi a0, a0, 1365
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vor.vv v8, v12, v8
; CHECK-NEXT:    ret
  %v = call <16 x i32> @llvm.vp.bitreverse.v16i32(<16 x i32> %va, <16 x i1> splat (i1 true), i32 %evl)
  ret <16 x i32> %v
}

declare <2 x i64> @llvm.vp.bitreverse.v2i64(<2 x i64>, <2 x i1>, i32)

define <2 x i64> @vp_bitreverse_v2i64(<2 x i64> %va, <2 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bitreverse_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vsll.vx v9, v8, a1, v0.t
; RV32-NEXT:    lui a2, 16
; RV32-NEXT:    addi a2, a2, -256
; RV32-NEXT:    vand.vx v10, v8, a2, v0.t
; RV32-NEXT:    li a3, 40
; RV32-NEXT:    vsll.vx v10, v10, a3, v0.t
; RV32-NEXT:    vor.vv v9, v9, v10, v0.t
; RV32-NEXT:    addi a4, sp, 8
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v10, (a4), zero
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vand.vx v11, v8, a4, v0.t
; RV32-NEXT:    vsll.vi v11, v11, 24, v0.t
; RV32-NEXT:    vand.vv v12, v8, v10, v0.t
; RV32-NEXT:    vsll.vi v12, v12, 8, v0.t
; RV32-NEXT:    vor.vv v11, v11, v12, v0.t
; RV32-NEXT:    vor.vv v9, v9, v11, v0.t
; RV32-NEXT:    vsrl.vx v11, v8, a1, v0.t
; RV32-NEXT:    vsrl.vx v12, v8, a3, v0.t
; RV32-NEXT:    vand.vx v12, v12, a2, v0.t
; RV32-NEXT:    vor.vv v11, v12, v11, v0.t
; RV32-NEXT:    vsrl.vi v12, v8, 24, v0.t
; RV32-NEXT:    vand.vx v12, v12, a4, v0.t
; RV32-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV32-NEXT:    vand.vv v8, v8, v10, v0.t
; RV32-NEXT:    vor.vv v8, v8, v12, v0.t
; RV32-NEXT:    vor.vv v8, v8, v11, v0.t
; RV32-NEXT:    vor.vv v8, v9, v8, v0.t
; RV32-NEXT:    vsrl.vi v9, v8, 4, v0.t
; RV32-NEXT:    lui a1, 61681
; RV32-NEXT:    addi a1, a1, -241
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmv.v.x v10, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vand.vv v9, v9, v10, v0.t
; RV32-NEXT:    vand.vv v8, v8, v10, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 4, v0.t
; RV32-NEXT:    vor.vv v8, v9, v8, v0.t
; RV32-NEXT:    vsrl.vi v9, v8, 2, v0.t
; RV32-NEXT:    lui a1, 209715
; RV32-NEXT:    addi a1, a1, 819
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmv.v.x v10, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vand.vv v9, v9, v10, v0.t
; RV32-NEXT:    vand.vv v8, v8, v10, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 2, v0.t
; RV32-NEXT:    vor.vv v8, v9, v8, v0.t
; RV32-NEXT:    vsrl.vi v9, v8, 1, v0.t
; RV32-NEXT:    lui a1, 349525
; RV32-NEXT:    addi a1, a1, 1365
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmv.v.x v10, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vand.vv v9, v9, v10, v0.t
; RV32-NEXT:    vand.vv v8, v8, v10, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 1, v0.t
; RV32-NEXT:    vor.vv v8, v9, v8, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bitreverse_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV64-NEXT:    vand.vx v9, v8, a1, v0.t
; RV64-NEXT:    vsll.vi v9, v9, 24, v0.t
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v10, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v10, v10, 8, v0.t
; RV64-NEXT:    vor.vv v9, v9, v10, v0.t
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v10, v8, a2, v0.t
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v11, v8, a3, v0.t
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v11, v11, a4, v0.t
; RV64-NEXT:    vor.vv v10, v10, v11, v0.t
; RV64-NEXT:    vor.vv v9, v10, v9, v0.t
; RV64-NEXT:    vsrl.vx v10, v8, a2, v0.t
; RV64-NEXT:    vsrl.vx v11, v8, a4, v0.t
; RV64-NEXT:    vand.vx v11, v11, a3, v0.t
; RV64-NEXT:    vor.vv v10, v11, v10, v0.t
; RV64-NEXT:    vsrl.vi v11, v8, 24, v0.t
; RV64-NEXT:    vand.vx v11, v11, a1, v0.t
; RV64-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vor.vv v8, v8, v11, v0.t
; RV64-NEXT:    vor.vv v8, v8, v10, v0.t
; RV64-NEXT:    vor.vv v8, v9, v8, v0.t
; RV64-NEXT:    vsrl.vi v9, v8, 4, v0.t
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v9, v9, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 4, v0.t
; RV64-NEXT:    vor.vv v8, v9, v8, v0.t
; RV64-NEXT:    vsrl.vi v9, v8, 2, v0.t
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v9, v9, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 2, v0.t
; RV64-NEXT:    vor.vv v8, v9, v8, v0.t
; RV64-NEXT:    vsrl.vi v9, v8, 1, v0.t
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v9, v9, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 1, v0.t
; RV64-NEXT:    vor.vv v8, v9, v8, v0.t
; RV64-NEXT:    ret
  %v = call <2 x i64> @llvm.vp.bitreverse.v2i64(<2 x i64> %va, <2 x i1> %m, i32 %evl)
  ret <2 x i64> %v
}

define <2 x i64> @vp_bitreverse_v2i64_unmasked(<2 x i64> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bitreverse_v2i64_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vsll.vx v9, v8, a1
; RV32-NEXT:    lui a2, 16
; RV32-NEXT:    addi a2, a2, -256
; RV32-NEXT:    vand.vx v10, v8, a2
; RV32-NEXT:    li a3, 40
; RV32-NEXT:    vsll.vx v10, v10, a3
; RV32-NEXT:    vor.vv v9, v9, v10
; RV32-NEXT:    addi a4, sp, 8
; RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v10, (a4), zero
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vand.vx v11, v8, a4
; RV32-NEXT:    vsll.vi v11, v11, 24
; RV32-NEXT:    vand.vv v12, v8, v10
; RV32-NEXT:    vsll.vi v12, v12, 8
; RV32-NEXT:    vor.vv v11, v11, v12
; RV32-NEXT:    vor.vv v9, v9, v11
; RV32-NEXT:    vsrl.vx v11, v8, a1
; RV32-NEXT:    vsrl.vx v12, v8, a3
; RV32-NEXT:    vand.vx v12, v12, a2
; RV32-NEXT:    vor.vv v11, v12, v11
; RV32-NEXT:    vsrl.vi v12, v8, 24
; RV32-NEXT:    vand.vx v12, v12, a4
; RV32-NEXT:    vsrl.vi v8, v8, 8
; RV32-NEXT:    vand.vv v8, v8, v10
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    vor.vv v8, v8, v11
; RV32-NEXT:    vor.vv v8, v9, v8
; RV32-NEXT:    vsrl.vi v9, v8, 4
; RV32-NEXT:    lui a1, 61681
; RV32-NEXT:    addi a1, a1, -241
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmv.v.x v10, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vand.vv v9, v9, v10
; RV32-NEXT:    vand.vv v8, v8, v10
; RV32-NEXT:    vsll.vi v8, v8, 4
; RV32-NEXT:    vor.vv v8, v9, v8
; RV32-NEXT:    vsrl.vi v9, v8, 2
; RV32-NEXT:    lui a1, 209715
; RV32-NEXT:    addi a1, a1, 819
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmv.v.x v10, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vand.vv v9, v9, v10
; RV32-NEXT:    vand.vv v8, v8, v10
; RV32-NEXT:    vsll.vi v8, v8, 2
; RV32-NEXT:    vor.vv v8, v9, v8
; RV32-NEXT:    vsrl.vi v9, v8, 1
; RV32-NEXT:    lui a1, 349525
; RV32-NEXT:    addi a1, a1, 1365
; RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; RV32-NEXT:    vmv.v.x v10, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vand.vv v9, v9, v10
; RV32-NEXT:    vand.vv v8, v8, v10
; RV32-NEXT:    vadd.vv v8, v8, v8
; RV32-NEXT:    vor.vv v8, v9, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bitreverse_v2i64_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV64-NEXT:    vand.vx v9, v8, a1
; RV64-NEXT:    vsll.vi v9, v9, 24
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v10, v8, a0
; RV64-NEXT:    vsll.vi v10, v10, 8
; RV64-NEXT:    vor.vv v9, v9, v10
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v10, v8, a2
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v11, v8, a3
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v11, v11, a4
; RV64-NEXT:    vor.vv v10, v10, v11
; RV64-NEXT:    vor.vv v9, v10, v9
; RV64-NEXT:    vsrl.vx v10, v8, a2
; RV64-NEXT:    vsrl.vx v11, v8, a4
; RV64-NEXT:    vand.vx v11, v11, a3
; RV64-NEXT:    vor.vv v10, v11, v10
; RV64-NEXT:    vsrl.vi v11, v8, 24
; RV64-NEXT:    vand.vx v11, v11, a1
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v11
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vor.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 4
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v9, v9, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vsll.vi v8, v8, 4
; RV64-NEXT:    vor.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 2
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v9, v9, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vsll.vi v8, v8, 2
; RV64-NEXT:    vor.vv v8, v9, v8
; RV64-NEXT:    vsrl.vi v9, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v9, v9, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v8, v8
; RV64-NEXT:    vor.vv v8, v9, v8
; RV64-NEXT:    ret
  %v = call <2 x i64> @llvm.vp.bitreverse.v2i64(<2 x i64> %va, <2 x i1> splat (i1 true), i32 %evl)
  ret <2 x i64> %v
}

declare <4 x i64> @llvm.vp.bitreverse.v4i64(<4 x i64>, <4 x i1>, i32)

define <4 x i64> @vp_bitreverse_v4i64(<4 x i64> %va, <4 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bitreverse_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vsll.vx v10, v8, a1, v0.t
; RV32-NEXT:    lui a2, 16
; RV32-NEXT:    addi a2, a2, -256
; RV32-NEXT:    vand.vx v12, v8, a2, v0.t
; RV32-NEXT:    li a3, 40
; RV32-NEXT:    vsll.vx v12, v12, a3, v0.t
; RV32-NEXT:    vor.vv v10, v10, v12, v0.t
; RV32-NEXT:    addi a4, sp, 8
; RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; RV32-NEXT:    vlse64.v v12, (a4), zero
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vand.vx v14, v8, a4, v0.t
; RV32-NEXT:    vsll.vi v14, v14, 24, v0.t
; RV32-NEXT:    vand.vv v16, v8, v12, v0.t
; RV32-NEXT:    vsll.vi v16, v16, 8, v0.t
; RV32-NEXT:    vor.vv v14, v14, v16, v0.t
; RV32-NEXT:    vor.vv v10, v10, v14, v0.t
; RV32-NEXT:    vsrl.vx v14, v8, a1, v0.t
; RV32-NEXT:    vsrl.vx v16, v8, a3, v0.t
; RV32-NEXT:    vand.vx v16, v16, a2, v0.t
; RV32-NEXT:    vor.vv v14, v16, v14, v0.t
; RV32-NEXT:    vsrl.vi v16, v8, 24, v0.t
; RV32-NEXT:    vand.vx v16, v16, a4, v0.t
; RV32-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV32-NEXT:    vand.vv v8, v8, v12, v0.t
; RV32-NEXT:    vor.vv v8, v8, v16, v0.t
; RV32-NEXT:    vor.vv v8, v8, v14, v0.t
; RV32-NEXT:    vor.vv v8, v10, v8, v0.t
; RV32-NEXT:    vsrl.vi v10, v8, 4, v0.t
; RV32-NEXT:    lui a1, 61681
; RV32-NEXT:    addi a1, a1, -241
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vmv.v.x v12, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vand.vv v10, v10, v12, v0.t
; RV32-NEXT:    vand.vv v8, v8, v12, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 4, v0.t
; RV32-NEXT:    vor.vv v8, v10, v8, v0.t
; RV32-NEXT:    vsrl.vi v10, v8, 2, v0.t
; RV32-NEXT:    lui a1, 209715
; RV32-NEXT:    addi a1, a1, 819
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vmv.v.x v12, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vand.vv v10, v10, v12, v0.t
; RV32-NEXT:    vand.vv v8, v8, v12, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 2, v0.t
; RV32-NEXT:    vor.vv v8, v10, v8, v0.t
; RV32-NEXT:    vsrl.vi v10, v8, 1, v0.t
; RV32-NEXT:    lui a1, 349525
; RV32-NEXT:    addi a1, a1, 1365
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vmv.v.x v12, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vand.vv v10, v10, v12, v0.t
; RV32-NEXT:    vand.vv v8, v8, v12, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 1, v0.t
; RV32-NEXT:    vor.vv v8, v10, v8, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bitreverse_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV64-NEXT:    vand.vx v10, v8, a1, v0.t
; RV64-NEXT:    vsll.vi v10, v10, 24, v0.t
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v12, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v12, v12, 8, v0.t
; RV64-NEXT:    vor.vv v10, v10, v12, v0.t
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v12, v8, a2, v0.t
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v14, v8, a3, v0.t
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v14, v14, a4, v0.t
; RV64-NEXT:    vor.vv v12, v12, v14, v0.t
; RV64-NEXT:    vor.vv v10, v12, v10, v0.t
; RV64-NEXT:    vsrl.vx v12, v8, a2, v0.t
; RV64-NEXT:    vsrl.vx v14, v8, a4, v0.t
; RV64-NEXT:    vand.vx v14, v14, a3, v0.t
; RV64-NEXT:    vor.vv v12, v14, v12, v0.t
; RV64-NEXT:    vsrl.vi v14, v8, 24, v0.t
; RV64-NEXT:    vand.vx v14, v14, a1, v0.t
; RV64-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vor.vv v8, v8, v14, v0.t
; RV64-NEXT:    vor.vv v8, v8, v12, v0.t
; RV64-NEXT:    vor.vv v8, v10, v8, v0.t
; RV64-NEXT:    vsrl.vi v10, v8, 4, v0.t
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v10, v10, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 4, v0.t
; RV64-NEXT:    vor.vv v8, v10, v8, v0.t
; RV64-NEXT:    vsrl.vi v10, v8, 2, v0.t
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v10, v10, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 2, v0.t
; RV64-NEXT:    vor.vv v8, v10, v8, v0.t
; RV64-NEXT:    vsrl.vi v10, v8, 1, v0.t
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v10, v10, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 1, v0.t
; RV64-NEXT:    vor.vv v8, v10, v8, v0.t
; RV64-NEXT:    ret
  %v = call <4 x i64> @llvm.vp.bitreverse.v4i64(<4 x i64> %va, <4 x i1> %m, i32 %evl)
  ret <4 x i64> %v
}

define <4 x i64> @vp_bitreverse_v4i64_unmasked(<4 x i64> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bitreverse_v4i64_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vsll.vx v10, v8, a1
; RV32-NEXT:    lui a2, 16
; RV32-NEXT:    addi a2, a2, -256
; RV32-NEXT:    vand.vx v12, v8, a2
; RV32-NEXT:    li a3, 40
; RV32-NEXT:    vsll.vx v12, v12, a3
; RV32-NEXT:    vor.vv v10, v10, v12
; RV32-NEXT:    addi a4, sp, 8
; RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; RV32-NEXT:    vlse64.v v12, (a4), zero
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vand.vx v14, v8, a4
; RV32-NEXT:    vsll.vi v14, v14, 24
; RV32-NEXT:    vand.vv v16, v8, v12
; RV32-NEXT:    vsll.vi v16, v16, 8
; RV32-NEXT:    vor.vv v14, v14, v16
; RV32-NEXT:    vor.vv v10, v10, v14
; RV32-NEXT:    vsrl.vx v14, v8, a1
; RV32-NEXT:    vsrl.vx v16, v8, a3
; RV32-NEXT:    vand.vx v16, v16, a2
; RV32-NEXT:    vor.vv v14, v16, v14
; RV32-NEXT:    vsrl.vi v16, v8, 24
; RV32-NEXT:    vand.vx v16, v16, a4
; RV32-NEXT:    vsrl.vi v8, v8, 8
; RV32-NEXT:    vand.vv v8, v8, v12
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vor.vv v8, v8, v14
; RV32-NEXT:    vor.vv v8, v10, v8
; RV32-NEXT:    vsrl.vi v10, v8, 4
; RV32-NEXT:    lui a1, 61681
; RV32-NEXT:    addi a1, a1, -241
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vmv.v.x v12, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vand.vv v10, v10, v12
; RV32-NEXT:    vand.vv v8, v8, v12
; RV32-NEXT:    vsll.vi v8, v8, 4
; RV32-NEXT:    vor.vv v8, v10, v8
; RV32-NEXT:    vsrl.vi v10, v8, 2
; RV32-NEXT:    lui a1, 209715
; RV32-NEXT:    addi a1, a1, 819
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vmv.v.x v12, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vand.vv v10, v10, v12
; RV32-NEXT:    vand.vv v8, v8, v12
; RV32-NEXT:    vsll.vi v8, v8, 2
; RV32-NEXT:    vor.vv v8, v10, v8
; RV32-NEXT:    vsrl.vi v10, v8, 1
; RV32-NEXT:    lui a1, 349525
; RV32-NEXT:    addi a1, a1, 1365
; RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; RV32-NEXT:    vmv.v.x v12, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vand.vv v10, v10, v12
; RV32-NEXT:    vand.vv v8, v8, v12
; RV32-NEXT:    vadd.vv v8, v8, v8
; RV32-NEXT:    vor.vv v8, v10, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bitreverse_v4i64_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV64-NEXT:    vand.vx v10, v8, a1
; RV64-NEXT:    vsll.vi v10, v10, 24
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v12, v8, a0
; RV64-NEXT:    vsll.vi v12, v12, 8
; RV64-NEXT:    vor.vv v10, v10, v12
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v12, v8, a2
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v14, v8, a3
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v14, v14, a4
; RV64-NEXT:    vor.vv v12, v12, v14
; RV64-NEXT:    vor.vv v10, v12, v10
; RV64-NEXT:    vsrl.vx v12, v8, a2
; RV64-NEXT:    vsrl.vx v14, v8, a4
; RV64-NEXT:    vand.vx v14, v14, a3
; RV64-NEXT:    vor.vv v12, v14, v12
; RV64-NEXT:    vsrl.vi v14, v8, 24
; RV64-NEXT:    vand.vx v14, v14, a1
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v14
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    vor.vv v8, v10, v8
; RV64-NEXT:    vsrl.vi v10, v8, 4
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v10, v10, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vsll.vi v8, v8, 4
; RV64-NEXT:    vor.vv v8, v10, v8
; RV64-NEXT:    vsrl.vi v10, v8, 2
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v10, v10, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vsll.vi v8, v8, 2
; RV64-NEXT:    vor.vv v8, v10, v8
; RV64-NEXT:    vsrl.vi v10, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v10, v10, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v8, v8
; RV64-NEXT:    vor.vv v8, v10, v8
; RV64-NEXT:    ret
  %v = call <4 x i64> @llvm.vp.bitreverse.v4i64(<4 x i64> %va, <4 x i1> splat (i1 true), i32 %evl)
  ret <4 x i64> %v
}

declare <8 x i64> @llvm.vp.bitreverse.v8i64(<8 x i64>, <8 x i1>, i32)

define <8 x i64> @vp_bitreverse_v8i64(<8 x i64> %va, <8 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bitreverse_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vsll.vx v12, v8, a1, v0.t
; RV32-NEXT:    lui a2, 16
; RV32-NEXT:    addi a2, a2, -256
; RV32-NEXT:    vand.vx v16, v8, a2, v0.t
; RV32-NEXT:    li a3, 40
; RV32-NEXT:    vsll.vx v16, v16, a3, v0.t
; RV32-NEXT:    vor.vv v16, v12, v16, v0.t
; RV32-NEXT:    addi a4, sp, 8
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV32-NEXT:    vlse64.v v12, (a4), zero
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vand.vx v20, v8, a4, v0.t
; RV32-NEXT:    vsll.vi v20, v20, 24, v0.t
; RV32-NEXT:    vand.vv v24, v8, v12, v0.t
; RV32-NEXT:    vsll.vi v24, v24, 8, v0.t
; RV32-NEXT:    vor.vv v20, v20, v24, v0.t
; RV32-NEXT:    vor.vv v16, v16, v20, v0.t
; RV32-NEXT:    vsrl.vx v20, v8, a1, v0.t
; RV32-NEXT:    vsrl.vx v24, v8, a3, v0.t
; RV32-NEXT:    vand.vx v24, v24, a2, v0.t
; RV32-NEXT:    vor.vv v20, v24, v20, v0.t
; RV32-NEXT:    vsrl.vi v24, v8, 24, v0.t
; RV32-NEXT:    vand.vx v24, v24, a4, v0.t
; RV32-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV32-NEXT:    vand.vv v8, v8, v12, v0.t
; RV32-NEXT:    vor.vv v8, v8, v24, v0.t
; RV32-NEXT:    vor.vv v8, v8, v20, v0.t
; RV32-NEXT:    vor.vv v8, v16, v8, v0.t
; RV32-NEXT:    vsrl.vi v12, v8, 4, v0.t
; RV32-NEXT:    lui a1, 61681
; RV32-NEXT:    addi a1, a1, -241
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vmv.v.x v16, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vand.vv v12, v12, v16, v0.t
; RV32-NEXT:    vand.vv v8, v8, v16, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 4, v0.t
; RV32-NEXT:    vor.vv v8, v12, v8, v0.t
; RV32-NEXT:    vsrl.vi v12, v8, 2, v0.t
; RV32-NEXT:    lui a1, 209715
; RV32-NEXT:    addi a1, a1, 819
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vmv.v.x v16, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vand.vv v12, v12, v16, v0.t
; RV32-NEXT:    vand.vv v8, v8, v16, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 2, v0.t
; RV32-NEXT:    vor.vv v8, v12, v8, v0.t
; RV32-NEXT:    vsrl.vi v12, v8, 1, v0.t
; RV32-NEXT:    lui a1, 349525
; RV32-NEXT:    addi a1, a1, 1365
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vmv.v.x v16, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vand.vv v12, v12, v16, v0.t
; RV32-NEXT:    vand.vv v8, v8, v16, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 1, v0.t
; RV32-NEXT:    vor.vv v8, v12, v8, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bitreverse_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV64-NEXT:    vand.vx v12, v8, a1, v0.t
; RV64-NEXT:    vsll.vi v12, v12, 24, v0.t
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v16, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v16, v16, 8, v0.t
; RV64-NEXT:    vor.vv v12, v12, v16, v0.t
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v16, v8, a2, v0.t
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v20, v8, a3, v0.t
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v20, v20, a4, v0.t
; RV64-NEXT:    vor.vv v16, v16, v20, v0.t
; RV64-NEXT:    vor.vv v12, v16, v12, v0.t
; RV64-NEXT:    vsrl.vx v16, v8, a2, v0.t
; RV64-NEXT:    vsrl.vx v20, v8, a4, v0.t
; RV64-NEXT:    vand.vx v20, v20, a3, v0.t
; RV64-NEXT:    vor.vv v16, v20, v16, v0.t
; RV64-NEXT:    vsrl.vi v20, v8, 24, v0.t
; RV64-NEXT:    vand.vx v20, v20, a1, v0.t
; RV64-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vor.vv v8, v8, v20, v0.t
; RV64-NEXT:    vor.vv v8, v8, v16, v0.t
; RV64-NEXT:    vor.vv v8, v12, v8, v0.t
; RV64-NEXT:    vsrl.vi v12, v8, 4, v0.t
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v12, v12, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 4, v0.t
; RV64-NEXT:    vor.vv v8, v12, v8, v0.t
; RV64-NEXT:    vsrl.vi v12, v8, 2, v0.t
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v12, v12, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 2, v0.t
; RV64-NEXT:    vor.vv v8, v12, v8, v0.t
; RV64-NEXT:    vsrl.vi v12, v8, 1, v0.t
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v12, v12, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 1, v0.t
; RV64-NEXT:    vor.vv v8, v12, v8, v0.t
; RV64-NEXT:    ret
  %v = call <8 x i64> @llvm.vp.bitreverse.v8i64(<8 x i64> %va, <8 x i1> %m, i32 %evl)
  ret <8 x i64> %v
}

define <8 x i64> @vp_bitreverse_v8i64_unmasked(<8 x i64> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bitreverse_v8i64_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw zero, 12(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 8(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vsll.vx v12, v8, a1
; RV32-NEXT:    lui a2, 16
; RV32-NEXT:    addi a2, a2, -256
; RV32-NEXT:    vand.vx v16, v8, a2
; RV32-NEXT:    li a3, 40
; RV32-NEXT:    vsll.vx v16, v16, a3
; RV32-NEXT:    vor.vv v12, v12, v16
; RV32-NEXT:    addi a4, sp, 8
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV32-NEXT:    vlse64.v v16, (a4), zero
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vand.vx v20, v8, a4
; RV32-NEXT:    vsll.vi v20, v20, 24
; RV32-NEXT:    vand.vv v24, v8, v16
; RV32-NEXT:    vsll.vi v24, v24, 8
; RV32-NEXT:    vor.vv v20, v20, v24
; RV32-NEXT:    vor.vv v12, v12, v20
; RV32-NEXT:    vsrl.vx v20, v8, a1
; RV32-NEXT:    vsrl.vx v24, v8, a3
; RV32-NEXT:    vand.vx v24, v24, a2
; RV32-NEXT:    vor.vv v20, v24, v20
; RV32-NEXT:    vsrl.vi v24, v8, 24
; RV32-NEXT:    vand.vx v24, v24, a4
; RV32-NEXT:    vsrl.vi v8, v8, 8
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vor.vv v8, v8, v24
; RV32-NEXT:    vor.vv v8, v8, v20
; RV32-NEXT:    vor.vv v8, v12, v8
; RV32-NEXT:    vsrl.vi v12, v8, 4
; RV32-NEXT:    lui a1, 61681
; RV32-NEXT:    addi a1, a1, -241
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vmv.v.x v16, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vand.vv v12, v12, v16
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vsll.vi v8, v8, 4
; RV32-NEXT:    vor.vv v8, v12, v8
; RV32-NEXT:    vsrl.vi v12, v8, 2
; RV32-NEXT:    lui a1, 209715
; RV32-NEXT:    addi a1, a1, 819
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vmv.v.x v16, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vand.vv v12, v12, v16
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vsll.vi v8, v8, 2
; RV32-NEXT:    vor.vv v8, v12, v8
; RV32-NEXT:    vsrl.vi v12, v8, 1
; RV32-NEXT:    lui a1, 349525
; RV32-NEXT:    addi a1, a1, 1365
; RV32-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; RV32-NEXT:    vmv.v.x v16, a1
; RV32-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV32-NEXT:    vand.vv v12, v12, v16
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vadd.vv v8, v8, v8
; RV32-NEXT:    vor.vv v8, v12, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bitreverse_v8i64_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; RV64-NEXT:    vand.vx v12, v8, a1
; RV64-NEXT:    vsll.vi v12, v12, 24
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v16, v8, a0
; RV64-NEXT:    vsll.vi v16, v16, 8
; RV64-NEXT:    vor.vv v12, v12, v16
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v16, v8, a2
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v20, v8, a3
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v20, v20, a4
; RV64-NEXT:    vor.vv v16, v16, v20
; RV64-NEXT:    vor.vv v12, v16, v12
; RV64-NEXT:    vsrl.vx v16, v8, a2
; RV64-NEXT:    vsrl.vx v20, v8, a4
; RV64-NEXT:    vand.vx v20, v20, a3
; RV64-NEXT:    vor.vv v16, v20, v16
; RV64-NEXT:    vsrl.vi v20, v8, 24
; RV64-NEXT:    vand.vx v20, v20, a1
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v20
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vor.vv v8, v12, v8
; RV64-NEXT:    vsrl.vi v12, v8, 4
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v12, v12, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vsll.vi v8, v8, 4
; RV64-NEXT:    vor.vv v8, v12, v8
; RV64-NEXT:    vsrl.vi v12, v8, 2
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v12, v12, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vsll.vi v8, v8, 2
; RV64-NEXT:    vor.vv v8, v12, v8
; RV64-NEXT:    vsrl.vi v12, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v12, v12, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v8, v8
; RV64-NEXT:    vor.vv v8, v12, v8
; RV64-NEXT:    ret
  %v = call <8 x i64> @llvm.vp.bitreverse.v8i64(<8 x i64> %va, <8 x i1> splat (i1 true), i32 %evl)
  ret <8 x i64> %v
}

declare <15 x i64> @llvm.vp.bitreverse.v15i64(<15 x i64>, <15 x i1>, i32)

define <15 x i64> @vp_bitreverse_v15i64(<15 x i64> %va, <15 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bitreverse_v15i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -48
; RV32-NEXT:    .cfi_def_cfa_offset 48
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 24
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    sub sp, sp, a1
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x30, 0x22, 0x11, 0x18, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 48 + 24 * vlenb
; RV32-NEXT:    sw zero, 20(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 16(sp)
; RV32-NEXT:    lui a1, 61681
; RV32-NEXT:    addi a1, a1, -241
; RV32-NEXT:    sw a1, 44(sp)
; RV32-NEXT:    sw a1, 40(sp)
; RV32-NEXT:    lui a1, 209715
; RV32-NEXT:    addi a1, a1, 819
; RV32-NEXT:    sw a1, 36(sp)
; RV32-NEXT:    sw a1, 32(sp)
; RV32-NEXT:    lui a1, 349525
; RV32-NEXT:    addi a1, a1, 1365
; RV32-NEXT:    sw a1, 28(sp)
; RV32-NEXT:    sw a1, 24(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsll.vx v16, v8, a1, v0.t
; RV32-NEXT:    lui a2, 16
; RV32-NEXT:    addi a2, a2, -256
; RV32-NEXT:    vand.vx v24, v8, a2, v0.t
; RV32-NEXT:    li a3, 40
; RV32-NEXT:    vsll.vx v24, v24, a3, v0.t
; RV32-NEXT:    vor.vv v16, v16, v24, v0.t
; RV32-NEXT:    csrr a4, vlenb
; RV32-NEXT:    slli a4, a4, 4
; RV32-NEXT:    add a4, sp, a4
; RV32-NEXT:    addi a4, a4, 48
; RV32-NEXT:    vs8r.v v16, (a4) # Unknown-size Folded Spill
; RV32-NEXT:    addi a4, sp, 16
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a4), zero
; RV32-NEXT:    csrr a4, vlenb
; RV32-NEXT:    slli a4, a4, 3
; RV32-NEXT:    add a4, sp, a4
; RV32-NEXT:    addi a4, a4, 48
; RV32-NEXT:    vs8r.v v16, (a4) # Unknown-size Folded Spill
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vand.vx v24, v8, a4, v0.t
; RV32-NEXT:    vsll.vi v24, v24, 24, v0.t
; RV32-NEXT:    addi a5, sp, 48
; RV32-NEXT:    vs8r.v v24, (a5) # Unknown-size Folded Spill
; RV32-NEXT:    vand.vv v24, v8, v16, v0.t
; RV32-NEXT:    vsll.vi v16, v24, 8, v0.t
; RV32-NEXT:    vl8r.v v24, (a5) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v16, v24, v16, v0.t
; RV32-NEXT:    csrr a5, vlenb
; RV32-NEXT:    slli a5, a5, 4
; RV32-NEXT:    add a5, sp, a5
; RV32-NEXT:    addi a5, a5, 48
; RV32-NEXT:    vl8r.v v24, (a5) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v16, v24, v16, v0.t
; RV32-NEXT:    csrr a5, vlenb
; RV32-NEXT:    slli a5, a5, 4
; RV32-NEXT:    add a5, sp, a5
; RV32-NEXT:    addi a5, a5, 48
; RV32-NEXT:    vs8r.v v16, (a5) # Unknown-size Folded Spill
; RV32-NEXT:    vsrl.vx v16, v8, a1, v0.t
; RV32-NEXT:    vsrl.vx v24, v8, a3, v0.t
; RV32-NEXT:    vand.vx v24, v24, a2, v0.t
; RV32-NEXT:    vor.vv v16, v24, v16, v0.t
; RV32-NEXT:    addi a1, sp, 48
; RV32-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    vsrl.vi v24, v8, 24, v0.t
; RV32-NEXT:    vand.vx v24, v24, a4, v0.t
; RV32-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a1, a1, 3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 48
; RV32-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vand.vv v8, v8, v16, v0.t
; RV32-NEXT:    vor.vv v8, v8, v24, v0.t
; RV32-NEXT:    addi a1, sp, 40
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a1), zero
; RV32-NEXT:    addi a1, sp, 48
; RV32-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vor.vv v8, v8, v16, v0.t
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a1, a1, 4
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 48
; RV32-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v16, v16, v8, v0.t
; RV32-NEXT:    vsrl.vi v8, v16, 4, v0.t
; RV32-NEXT:    vand.vv v8, v8, v24, v0.t
; RV32-NEXT:    vand.vv v16, v16, v24, v0.t
; RV32-NEXT:    addi a1, sp, 32
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a1), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsll.vi v16, v16, 4, v0.t
; RV32-NEXT:    vor.vv v16, v8, v16, v0.t
; RV32-NEXT:    vsrl.vi v8, v16, 2, v0.t
; RV32-NEXT:    vand.vv v8, v8, v24, v0.t
; RV32-NEXT:    vand.vv v16, v16, v24, v0.t
; RV32-NEXT:    addi a1, sp, 24
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a1), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsll.vi v16, v16, 2, v0.t
; RV32-NEXT:    vor.vv v8, v8, v16, v0.t
; RV32-NEXT:    vsrl.vi v16, v8, 1, v0.t
; RV32-NEXT:    vand.vv v16, v16, v24, v0.t
; RV32-NEXT:    vand.vv v8, v8, v24, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 1, v0.t
; RV32-NEXT:    vor.vv v8, v16, v8, v0.t
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    li a1, 24
; RV32-NEXT:    mul a0, a0, a1
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    addi sp, sp, 48
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bitreverse_v15i64:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -16
; RV64-NEXT:    .cfi_def_cfa_offset 16
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 3
; RV64-NEXT:    sub sp, sp, a1
; RV64-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV64-NEXT:    vand.vx v16, v8, a1, v0.t
; RV64-NEXT:    vsll.vi v16, v16, 24, v0.t
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v24, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v24, v24, 8, v0.t
; RV64-NEXT:    vor.vv v16, v16, v24, v0.t
; RV64-NEXT:    addi a2, sp, 16
; RV64-NEXT:    vs8r.v v16, (a2) # Unknown-size Folded Spill
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v24, v8, a2, v0.t
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vand.vx v16, v8, a3, v0.t
; RV64-NEXT:    vsll.vx v16, v16, a4, v0.t
; RV64-NEXT:    vor.vv v16, v24, v16, v0.t
; RV64-NEXT:    addi a5, sp, 16
; RV64-NEXT:    vl8r.v v24, (a5) # Unknown-size Folded Reload
; RV64-NEXT:    vor.vv v16, v16, v24, v0.t
; RV64-NEXT:    vs8r.v v16, (a5) # Unknown-size Folded Spill
; RV64-NEXT:    vsrl.vx v24, v8, a2, v0.t
; RV64-NEXT:    vsrl.vx v16, v8, a4, v0.t
; RV64-NEXT:    vand.vx v16, v16, a3, v0.t
; RV64-NEXT:    vor.vv v24, v16, v24, v0.t
; RV64-NEXT:    vsrl.vi v16, v8, 24, v0.t
; RV64-NEXT:    vand.vx v16, v16, a1, v0.t
; RV64-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vor.vv v8, v8, v16, v0.t
; RV64-NEXT:    vor.vv v8, v8, v24, v0.t
; RV64-NEXT:    addi a0, sp, 16
; RV64-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; RV64-NEXT:    vor.vv v8, v16, v8, v0.t
; RV64-NEXT:    vsrl.vi v16, v8, 4, v0.t
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v16, v16, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 4, v0.t
; RV64-NEXT:    vor.vv v8, v16, v8, v0.t
; RV64-NEXT:    vsrl.vi v16, v8, 2, v0.t
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v16, v16, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 2, v0.t
; RV64-NEXT:    vor.vv v8, v16, v8, v0.t
; RV64-NEXT:    vsrl.vi v16, v8, 1, v0.t
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v16, v16, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 1, v0.t
; RV64-NEXT:    vor.vv v8, v16, v8, v0.t
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    slli a0, a0, 3
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    addi sp, sp, 16
; RV64-NEXT:    ret
  %v = call <15 x i64> @llvm.vp.bitreverse.v15i64(<15 x i64> %va, <15 x i1> %m, i32 %evl)
  ret <15 x i64> %v
}

define <15 x i64> @vp_bitreverse_v15i64_unmasked(<15 x i64> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bitreverse_v15i64_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -48
; RV32-NEXT:    .cfi_def_cfa_offset 48
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a1, a1, 3
; RV32-NEXT:    sub sp, sp, a1
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x30, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 48 + 8 * vlenb
; RV32-NEXT:    sw zero, 20(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 16(sp)
; RV32-NEXT:    lui a1, 61681
; RV32-NEXT:    addi a1, a1, -241
; RV32-NEXT:    sw a1, 44(sp)
; RV32-NEXT:    sw a1, 40(sp)
; RV32-NEXT:    lui a1, 209715
; RV32-NEXT:    addi a1, a1, 819
; RV32-NEXT:    sw a1, 36(sp)
; RV32-NEXT:    sw a1, 32(sp)
; RV32-NEXT:    lui a1, 349525
; RV32-NEXT:    addi a1, a1, 1365
; RV32-NEXT:    sw a1, 28(sp)
; RV32-NEXT:    sw a1, 24(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsll.vx v16, v8, a1
; RV32-NEXT:    lui a2, 16
; RV32-NEXT:    addi a2, a2, -256
; RV32-NEXT:    vand.vx v24, v8, a2
; RV32-NEXT:    li a3, 40
; RV32-NEXT:    vsll.vx v24, v24, a3
; RV32-NEXT:    vor.vv v16, v16, v24
; RV32-NEXT:    addi a4, sp, 48
; RV32-NEXT:    vs8r.v v16, (a4) # Unknown-size Folded Spill
; RV32-NEXT:    addi a4, sp, 16
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a4), zero
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vand.vx v0, v8, a4
; RV32-NEXT:    vsll.vi v0, v0, 24
; RV32-NEXT:    vand.vv v16, v8, v24
; RV32-NEXT:    vsll.vi v16, v16, 8
; RV32-NEXT:    vor.vv v16, v0, v16
; RV32-NEXT:    addi a5, sp, 48
; RV32-NEXT:    vl8r.v v0, (a5) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v16, v0, v16
; RV32-NEXT:    vs8r.v v16, (a5) # Unknown-size Folded Spill
; RV32-NEXT:    vsrl.vx v0, v8, a3
; RV32-NEXT:    vand.vx v0, v0, a2
; RV32-NEXT:    vsrl.vx v16, v8, a1
; RV32-NEXT:    vor.vv v0, v0, v16
; RV32-NEXT:    vsrl.vi v16, v8, 8
; RV32-NEXT:    vand.vv v16, v16, v24
; RV32-NEXT:    vsrl.vi v8, v8, 24
; RV32-NEXT:    vand.vx v8, v8, a4
; RV32-NEXT:    vor.vv v8, v16, v8
; RV32-NEXT:    addi a1, sp, 40
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a1), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vor.vv v8, v8, v0
; RV32-NEXT:    addi a1, sp, 48
; RV32-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v8, v24, v8
; RV32-NEXT:    vsrl.vi v24, v8, 4
; RV32-NEXT:    vand.vv v24, v24, v16
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    addi a1, sp, 32
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a1), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsll.vi v8, v8, 4
; RV32-NEXT:    vor.vv v8, v24, v8
; RV32-NEXT:    vsrl.vi v24, v8, 2
; RV32-NEXT:    vand.vv v24, v24, v16
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    addi a1, sp, 24
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a1), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsll.vi v8, v8, 2
; RV32-NEXT:    vor.vv v8, v24, v8
; RV32-NEXT:    vsrl.vi v24, v8, 1
; RV32-NEXT:    vand.vv v24, v24, v16
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vadd.vv v8, v8, v8
; RV32-NEXT:    vor.vv v8, v24, v8
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 3
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    addi sp, sp, 48
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bitreverse_v15i64_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV64-NEXT:    vand.vx v16, v8, a1
; RV64-NEXT:    vsll.vi v16, v16, 24
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v24, v8, a0
; RV64-NEXT:    vsll.vi v24, v24, 8
; RV64-NEXT:    vor.vv v16, v16, v24
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v24, v8, a2
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v0, v8, a3
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v0, v0, a4
; RV64-NEXT:    vor.vv v24, v24, v0
; RV64-NEXT:    vor.vv v16, v24, v16
; RV64-NEXT:    vsrl.vx v24, v8, a2
; RV64-NEXT:    vsrl.vx v0, v8, a4
; RV64-NEXT:    vand.vx v0, v0, a3
; RV64-NEXT:    vor.vv v24, v0, v24
; RV64-NEXT:    vsrl.vi v0, v8, 24
; RV64-NEXT:    vand.vx v0, v0, a1
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v0
; RV64-NEXT:    vor.vv v8, v8, v24
; RV64-NEXT:    vor.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vsll.vi v8, v8, 4
; RV64-NEXT:    vor.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 2
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vsll.vi v8, v8, 2
; RV64-NEXT:    vor.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v8, v8
; RV64-NEXT:    vor.vv v8, v16, v8
; RV64-NEXT:    ret
  %v = call <15 x i64> @llvm.vp.bitreverse.v15i64(<15 x i64> %va, <15 x i1> splat (i1 true), i32 %evl)
  ret <15 x i64> %v
}

declare <16 x i64> @llvm.vp.bitreverse.v16i64(<16 x i64>, <16 x i1>, i32)

define <16 x i64> @vp_bitreverse_v16i64(<16 x i64> %va, <16 x i1> %m, i32 zeroext %evl) {
; RV32-LABEL: vp_bitreverse_v16i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -48
; RV32-NEXT:    .cfi_def_cfa_offset 48
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    li a2, 24
; RV32-NEXT:    mul a1, a1, a2
; RV32-NEXT:    sub sp, sp, a1
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x30, 0x22, 0x11, 0x18, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 48 + 24 * vlenb
; RV32-NEXT:    sw zero, 20(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 16(sp)
; RV32-NEXT:    lui a1, 61681
; RV32-NEXT:    addi a1, a1, -241
; RV32-NEXT:    sw a1, 44(sp)
; RV32-NEXT:    sw a1, 40(sp)
; RV32-NEXT:    lui a1, 209715
; RV32-NEXT:    addi a1, a1, 819
; RV32-NEXT:    sw a1, 36(sp)
; RV32-NEXT:    sw a1, 32(sp)
; RV32-NEXT:    lui a1, 349525
; RV32-NEXT:    addi a1, a1, 1365
; RV32-NEXT:    sw a1, 28(sp)
; RV32-NEXT:    sw a1, 24(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsll.vx v16, v8, a1, v0.t
; RV32-NEXT:    lui a2, 16
; RV32-NEXT:    addi a2, a2, -256
; RV32-NEXT:    vand.vx v24, v8, a2, v0.t
; RV32-NEXT:    li a3, 40
; RV32-NEXT:    vsll.vx v24, v24, a3, v0.t
; RV32-NEXT:    vor.vv v16, v16, v24, v0.t
; RV32-NEXT:    csrr a4, vlenb
; RV32-NEXT:    slli a4, a4, 4
; RV32-NEXT:    add a4, sp, a4
; RV32-NEXT:    addi a4, a4, 48
; RV32-NEXT:    vs8r.v v16, (a4) # Unknown-size Folded Spill
; RV32-NEXT:    addi a4, sp, 16
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a4), zero
; RV32-NEXT:    csrr a4, vlenb
; RV32-NEXT:    slli a4, a4, 3
; RV32-NEXT:    add a4, sp, a4
; RV32-NEXT:    addi a4, a4, 48
; RV32-NEXT:    vs8r.v v16, (a4) # Unknown-size Folded Spill
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vand.vx v24, v8, a4, v0.t
; RV32-NEXT:    vsll.vi v24, v24, 24, v0.t
; RV32-NEXT:    addi a5, sp, 48
; RV32-NEXT:    vs8r.v v24, (a5) # Unknown-size Folded Spill
; RV32-NEXT:    vand.vv v24, v8, v16, v0.t
; RV32-NEXT:    vsll.vi v16, v24, 8, v0.t
; RV32-NEXT:    vl8r.v v24, (a5) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v16, v24, v16, v0.t
; RV32-NEXT:    csrr a5, vlenb
; RV32-NEXT:    slli a5, a5, 4
; RV32-NEXT:    add a5, sp, a5
; RV32-NEXT:    addi a5, a5, 48
; RV32-NEXT:    vl8r.v v24, (a5) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v16, v24, v16, v0.t
; RV32-NEXT:    csrr a5, vlenb
; RV32-NEXT:    slli a5, a5, 4
; RV32-NEXT:    add a5, sp, a5
; RV32-NEXT:    addi a5, a5, 48
; RV32-NEXT:    vs8r.v v16, (a5) # Unknown-size Folded Spill
; RV32-NEXT:    vsrl.vx v16, v8, a1, v0.t
; RV32-NEXT:    vsrl.vx v24, v8, a3, v0.t
; RV32-NEXT:    vand.vx v24, v24, a2, v0.t
; RV32-NEXT:    vor.vv v16, v24, v16, v0.t
; RV32-NEXT:    addi a1, sp, 48
; RV32-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; RV32-NEXT:    vsrl.vi v24, v8, 24, v0.t
; RV32-NEXT:    vand.vx v24, v24, a4, v0.t
; RV32-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a1, a1, 3
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 48
; RV32-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vand.vv v8, v8, v16, v0.t
; RV32-NEXT:    vor.vv v8, v8, v24, v0.t
; RV32-NEXT:    addi a1, sp, 40
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a1), zero
; RV32-NEXT:    addi a1, sp, 48
; RV32-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vor.vv v8, v8, v16, v0.t
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a1, a1, 4
; RV32-NEXT:    add a1, sp, a1
; RV32-NEXT:    addi a1, a1, 48
; RV32-NEXT:    vl8r.v v16, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v16, v16, v8, v0.t
; RV32-NEXT:    vsrl.vi v8, v16, 4, v0.t
; RV32-NEXT:    vand.vv v8, v8, v24, v0.t
; RV32-NEXT:    vand.vv v16, v16, v24, v0.t
; RV32-NEXT:    addi a1, sp, 32
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a1), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsll.vi v16, v16, 4, v0.t
; RV32-NEXT:    vor.vv v16, v8, v16, v0.t
; RV32-NEXT:    vsrl.vi v8, v16, 2, v0.t
; RV32-NEXT:    vand.vv v8, v8, v24, v0.t
; RV32-NEXT:    vand.vv v16, v16, v24, v0.t
; RV32-NEXT:    addi a1, sp, 24
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a1), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsll.vi v16, v16, 2, v0.t
; RV32-NEXT:    vor.vv v8, v8, v16, v0.t
; RV32-NEXT:    vsrl.vi v16, v8, 1, v0.t
; RV32-NEXT:    vand.vv v16, v16, v24, v0.t
; RV32-NEXT:    vand.vv v8, v8, v24, v0.t
; RV32-NEXT:    vsll.vi v8, v8, 1, v0.t
; RV32-NEXT:    vor.vv v8, v16, v8, v0.t
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    li a1, 24
; RV32-NEXT:    mul a0, a0, a1
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    addi sp, sp, 48
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bitreverse_v16i64:
; RV64:       # %bb.0:
; RV64-NEXT:    addi sp, sp, -16
; RV64-NEXT:    .cfi_def_cfa_offset 16
; RV64-NEXT:    csrr a1, vlenb
; RV64-NEXT:    slli a1, a1, 3
; RV64-NEXT:    sub sp, sp, a1
; RV64-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV64-NEXT:    vand.vx v16, v8, a1, v0.t
; RV64-NEXT:    vsll.vi v16, v16, 24, v0.t
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v24, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v24, v24, 8, v0.t
; RV64-NEXT:    vor.vv v16, v16, v24, v0.t
; RV64-NEXT:    addi a2, sp, 16
; RV64-NEXT:    vs8r.v v16, (a2) # Unknown-size Folded Spill
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v24, v8, a2, v0.t
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vand.vx v16, v8, a3, v0.t
; RV64-NEXT:    vsll.vx v16, v16, a4, v0.t
; RV64-NEXT:    vor.vv v16, v24, v16, v0.t
; RV64-NEXT:    addi a5, sp, 16
; RV64-NEXT:    vl8r.v v24, (a5) # Unknown-size Folded Reload
; RV64-NEXT:    vor.vv v16, v16, v24, v0.t
; RV64-NEXT:    vs8r.v v16, (a5) # Unknown-size Folded Spill
; RV64-NEXT:    vsrl.vx v24, v8, a2, v0.t
; RV64-NEXT:    vsrl.vx v16, v8, a4, v0.t
; RV64-NEXT:    vand.vx v16, v16, a3, v0.t
; RV64-NEXT:    vor.vv v24, v16, v24, v0.t
; RV64-NEXT:    vsrl.vi v16, v8, 24, v0.t
; RV64-NEXT:    vand.vx v16, v16, a1, v0.t
; RV64-NEXT:    vsrl.vi v8, v8, 8, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vor.vv v8, v8, v16, v0.t
; RV64-NEXT:    vor.vv v8, v8, v24, v0.t
; RV64-NEXT:    addi a0, sp, 16
; RV64-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; RV64-NEXT:    vor.vv v8, v16, v8, v0.t
; RV64-NEXT:    vsrl.vi v16, v8, 4, v0.t
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v16, v16, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 4, v0.t
; RV64-NEXT:    vor.vv v8, v16, v8, v0.t
; RV64-NEXT:    vsrl.vi v16, v8, 2, v0.t
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v16, v16, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 2, v0.t
; RV64-NEXT:    vor.vv v8, v16, v8, v0.t
; RV64-NEXT:    vsrl.vi v16, v8, 1, v0.t
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v16, v16, a0, v0.t
; RV64-NEXT:    vand.vx v8, v8, a0, v0.t
; RV64-NEXT:    vsll.vi v8, v8, 1, v0.t
; RV64-NEXT:    vor.vv v8, v16, v8, v0.t
; RV64-NEXT:    csrr a0, vlenb
; RV64-NEXT:    slli a0, a0, 3
; RV64-NEXT:    add sp, sp, a0
; RV64-NEXT:    addi sp, sp, 16
; RV64-NEXT:    ret
  %v = call <16 x i64> @llvm.vp.bitreverse.v16i64(<16 x i64> %va, <16 x i1> %m, i32 %evl)
  ret <16 x i64> %v
}

define <16 x i64> @vp_bitreverse_v16i64_unmasked(<16 x i64> %va, i32 zeroext %evl) {
; RV32-LABEL: vp_bitreverse_v16i64_unmasked:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -48
; RV32-NEXT:    .cfi_def_cfa_offset 48
; RV32-NEXT:    csrr a1, vlenb
; RV32-NEXT:    slli a1, a1, 3
; RV32-NEXT:    sub sp, sp, a1
; RV32-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x30, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 48 + 8 * vlenb
; RV32-NEXT:    sw zero, 20(sp)
; RV32-NEXT:    lui a1, 1044480
; RV32-NEXT:    sw a1, 16(sp)
; RV32-NEXT:    lui a1, 61681
; RV32-NEXT:    addi a1, a1, -241
; RV32-NEXT:    sw a1, 44(sp)
; RV32-NEXT:    sw a1, 40(sp)
; RV32-NEXT:    lui a1, 209715
; RV32-NEXT:    addi a1, a1, 819
; RV32-NEXT:    sw a1, 36(sp)
; RV32-NEXT:    sw a1, 32(sp)
; RV32-NEXT:    lui a1, 349525
; RV32-NEXT:    addi a1, a1, 1365
; RV32-NEXT:    sw a1, 28(sp)
; RV32-NEXT:    sw a1, 24(sp)
; RV32-NEXT:    li a1, 56
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsll.vx v16, v8, a1
; RV32-NEXT:    lui a2, 16
; RV32-NEXT:    addi a2, a2, -256
; RV32-NEXT:    vand.vx v24, v8, a2
; RV32-NEXT:    li a3, 40
; RV32-NEXT:    vsll.vx v24, v24, a3
; RV32-NEXT:    vor.vv v16, v16, v24
; RV32-NEXT:    addi a4, sp, 48
; RV32-NEXT:    vs8r.v v16, (a4) # Unknown-size Folded Spill
; RV32-NEXT:    addi a4, sp, 16
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v24, (a4), zero
; RV32-NEXT:    lui a4, 4080
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vand.vx v0, v8, a4
; RV32-NEXT:    vsll.vi v0, v0, 24
; RV32-NEXT:    vand.vv v16, v8, v24
; RV32-NEXT:    vsll.vi v16, v16, 8
; RV32-NEXT:    vor.vv v16, v0, v16
; RV32-NEXT:    addi a5, sp, 48
; RV32-NEXT:    vl8r.v v0, (a5) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v16, v0, v16
; RV32-NEXT:    vs8r.v v16, (a5) # Unknown-size Folded Spill
; RV32-NEXT:    vsrl.vx v0, v8, a3
; RV32-NEXT:    vand.vx v0, v0, a2
; RV32-NEXT:    vsrl.vx v16, v8, a1
; RV32-NEXT:    vor.vv v0, v0, v16
; RV32-NEXT:    vsrl.vi v16, v8, 8
; RV32-NEXT:    vand.vv v16, v16, v24
; RV32-NEXT:    vsrl.vi v8, v8, 24
; RV32-NEXT:    vand.vx v8, v8, a4
; RV32-NEXT:    vor.vv v8, v16, v8
; RV32-NEXT:    addi a1, sp, 40
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a1), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vor.vv v8, v8, v0
; RV32-NEXT:    addi a1, sp, 48
; RV32-NEXT:    vl8r.v v24, (a1) # Unknown-size Folded Reload
; RV32-NEXT:    vor.vv v8, v24, v8
; RV32-NEXT:    vsrl.vi v24, v8, 4
; RV32-NEXT:    vand.vv v24, v24, v16
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    addi a1, sp, 32
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a1), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsll.vi v8, v8, 4
; RV32-NEXT:    vor.vv v8, v24, v8
; RV32-NEXT:    vsrl.vi v24, v8, 2
; RV32-NEXT:    vand.vv v24, v24, v16
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    addi a1, sp, 24
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vlse64.v v16, (a1), zero
; RV32-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV32-NEXT:    vsll.vi v8, v8, 2
; RV32-NEXT:    vor.vv v8, v24, v8
; RV32-NEXT:    vsrl.vi v24, v8, 1
; RV32-NEXT:    vand.vv v24, v24, v16
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vadd.vv v8, v8, v8
; RV32-NEXT:    vor.vv v8, v24, v8
; RV32-NEXT:    csrr a0, vlenb
; RV32-NEXT:    slli a0, a0, 3
; RV32-NEXT:    add sp, sp, a0
; RV32-NEXT:    addi sp, sp, 48
; RV32-NEXT:    ret
;
; RV64-LABEL: vp_bitreverse_v16i64_unmasked:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a1, 4080
; RV64-NEXT:    vsetvli zero, a0, e64, m8, ta, ma
; RV64-NEXT:    vand.vx v16, v8, a1
; RV64-NEXT:    vsll.vi v16, v16, 24
; RV64-NEXT:    li a0, 255
; RV64-NEXT:    slli a0, a0, 24
; RV64-NEXT:    vand.vx v24, v8, a0
; RV64-NEXT:    vsll.vi v24, v24, 8
; RV64-NEXT:    vor.vv v16, v16, v24
; RV64-NEXT:    li a2, 56
; RV64-NEXT:    vsll.vx v24, v8, a2
; RV64-NEXT:    lui a3, 16
; RV64-NEXT:    addiw a3, a3, -256
; RV64-NEXT:    vand.vx v0, v8, a3
; RV64-NEXT:    li a4, 40
; RV64-NEXT:    vsll.vx v0, v0, a4
; RV64-NEXT:    vor.vv v24, v24, v0
; RV64-NEXT:    vor.vv v16, v24, v16
; RV64-NEXT:    vsrl.vx v24, v8, a2
; RV64-NEXT:    vsrl.vx v0, v8, a4
; RV64-NEXT:    vand.vx v0, v0, a3
; RV64-NEXT:    vor.vv v24, v0, v24
; RV64-NEXT:    vsrl.vi v0, v8, 24
; RV64-NEXT:    vand.vx v0, v0, a1
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v0
; RV64-NEXT:    vor.vv v8, v8, v24
; RV64-NEXT:    vor.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vsll.vi v8, v8, 4
; RV64-NEXT:    vor.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 2
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vsll.vi v8, v8, 2
; RV64-NEXT:    vor.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    add a0, a0, a1
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v8, v8
; RV64-NEXT:    vor.vv v8, v16, v8
; RV64-NEXT:    ret
  %v = call <16 x i64> @llvm.vp.bitreverse.v16i64(<16 x i64> %va, <16 x i1> splat (i1 true), i32 %evl)
  ret <16 x i64> %v
}

declare <128 x i16> @llvm.vp.bitreverse.v128i16(<128 x i16>, <128 x i1>, i32)

define <128 x i16> @vp_bitreverse_v128i16(<128 x i16> %va, <128 x i1> %m, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v128i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 4
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x10, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 16 * vlenb
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v16, (a1) # Unknown-size Folded Spill
; CHECK-NEXT:    li a2, 64
; CHECK-NEXT:    vsetivli zero, 8, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v24, v0, 8
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    bltu a0, a2, .LBB34_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:  .LBB34_2:
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 4, v0.t
; CHECK-NEXT:    lui a1, 1
; CHECK-NEXT:    addi a1, a1, -241
; CHECK-NEXT:    vand.vx v16, v16, a1, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a1, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v16, v8, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 2, v0.t
; CHECK-NEXT:    lui a2, 3
; CHECK-NEXT:    addi a2, a2, 819
; CHECK-NEXT:    vand.vx v16, v16, a2, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a2, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v16, v8, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 1, v0.t
; CHECK-NEXT:    lui a3, 5
; CHECK-NEXT:    addi a3, a3, 1365
; CHECK-NEXT:    vand.vx v16, v16, a3, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a3, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v8, v16, v8, v0.t
; CHECK-NEXT:    addi a4, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a4) # Unknown-size Folded Spill
; CHECK-NEXT:    addi a4, a0, -64
; CHECK-NEXT:    sltu a0, a0, a4
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    and a0, a0, a4
; CHECK-NEXT:    vmv1r.v v0, v24
; CHECK-NEXT:    csrr a4, vlenb
; CHECK-NEXT:    slli a4, a4, 3
; CHECK-NEXT:    add a4, sp, a4
; CHECK-NEXT:    addi a4, a4, 16
; CHECK-NEXT:    vl8r.v v8, (a4) # Unknown-size Folded Reload
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v16, v8, 8, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 8, v0.t
; CHECK-NEXT:    vor.vv v8, v8, v16, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 4, v0.t
; CHECK-NEXT:    vand.vx v16, v16, a1, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a1, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 4, v0.t
; CHECK-NEXT:    vor.vv v8, v16, v8, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 2, v0.t
; CHECK-NEXT:    vand.vx v16, v16, a2, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a2, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 2, v0.t
; CHECK-NEXT:    vor.vv v8, v16, v8, v0.t
; CHECK-NEXT:    vsrl.vi v16, v8, 1, v0.t
; CHECK-NEXT:    vand.vx v16, v16, a3, v0.t
; CHECK-NEXT:    vand.vx v8, v8, a3, v0.t
; CHECK-NEXT:    vsll.vi v8, v8, 1, v0.t
; CHECK-NEXT:    vor.vv v16, v16, v8, v0.t
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = call <128 x i16> @llvm.vp.bitreverse.v128i16(<128 x i16> %va, <128 x i1> %m, i32 %evl)
  ret <128 x i16> %v
}

define <128 x i16> @vp_bitreverse_v128i16_unmasked(<128 x i16> %va, i32 zeroext %evl) {
; CHECK-LABEL: vp_bitreverse_v128i16_unmasked:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a2, 64
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    bltu a0, a2, .LBB35_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:  .LBB35_2:
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v24, v8, 8
; CHECK-NEXT:    vsll.vi v8, v8, 8
; CHECK-NEXT:    vor.vv v8, v8, v24
; CHECK-NEXT:    vsrl.vi v24, v8, 4
; CHECK-NEXT:    lui a1, 1
; CHECK-NEXT:    addi a1, a1, -241
; CHECK-NEXT:    vand.vx v24, v24, a1
; CHECK-NEXT:    vand.vx v8, v8, a1
; CHECK-NEXT:    vsll.vi v8, v8, 4
; CHECK-NEXT:    vor.vv v8, v24, v8
; CHECK-NEXT:    vsrl.vi v24, v8, 2
; CHECK-NEXT:    lui a2, 3
; CHECK-NEXT:    addi a2, a2, 819
; CHECK-NEXT:    vand.vx v24, v24, a2
; CHECK-NEXT:    vand.vx v8, v8, a2
; CHECK-NEXT:    vsll.vi v8, v8, 2
; CHECK-NEXT:    vor.vv v8, v24, v8
; CHECK-NEXT:    vsrl.vi v24, v8, 1
; CHECK-NEXT:    lui a3, 5
; CHECK-NEXT:    addi a3, a3, 1365
; CHECK-NEXT:    vand.vx v24, v24, a3
; CHECK-NEXT:    vand.vx v8, v8, a3
; CHECK-NEXT:    vadd.vv v8, v8, v8
; CHECK-NEXT:    vor.vv v8, v24, v8
; CHECK-NEXT:    addi a4, a0, -64
; CHECK-NEXT:    sltu a0, a0, a4
; CHECK-NEXT:    addi a0, a0, -1
; CHECK-NEXT:    and a0, a0, a4
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vsrl.vi v24, v16, 8
; CHECK-NEXT:    vsll.vi v16, v16, 8
; CHECK-NEXT:    vor.vv v16, v16, v24
; CHECK-NEXT:    vsrl.vi v24, v16, 4
; CHECK-NEXT:    vand.vx v24, v24, a1
; CHECK-NEXT:    vand.vx v16, v16, a1
; CHECK-NEXT:    vsll.vi v16, v16, 4
; CHECK-NEXT:    vor.vv v16, v24, v16
; CHECK-NEXT:    vsrl.vi v24, v16, 2
; CHECK-NEXT:    vand.vx v24, v24, a2
; CHECK-NEXT:    vand.vx v16, v16, a2
; CHECK-NEXT:    vsll.vi v16, v16, 2
; CHECK-NEXT:    vor.vv v16, v24, v16
; CHECK-NEXT:    vsrl.vi v24, v16, 1
; CHECK-NEXT:    vand.vx v24, v24, a3
; CHECK-NEXT:    vand.vx v16, v16, a3
; CHECK-NEXT:    vadd.vv v16, v16, v16
; CHECK-NEXT:    vor.vv v16, v24, v16
; CHECK-NEXT:    ret
  %v = call <128 x i16> @llvm.vp.bitreverse.v128i16(<128 x i16> %va, <128 x i1> splat (i1 true), i32 %evl)
  ret <128 x i16> %v
}
