; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=instcombine < %s | FileCheck %s

declare double @llvm.exp.f64(double) nounwind readnone speculatable
declare void @use(double)

; exp(a) * exp(b) no reassoc flags
define double @exp_a_exp_b(double %a, double %b) {
; CHECK-LABEL: @exp_a_exp_b(
; CHECK-NEXT:    [[T:%.*]] = call double @llvm.exp.f64(double [[A:%.*]])
; CHECK-NEXT:    [[T1:%.*]] = call double @llvm.exp.f64(double [[B:%.*]])
; CHECK-NEXT:    [[MUL:%.*]] = fmul double [[T]], [[T1]]
; CHECK-NEXT:    ret double [[MUL]]
;
  %t = call double @llvm.exp.f64(double %a)
  %t1 = call double @llvm.exp.f64(double %b)
  %mul = fmul double %t, %t1
  ret double %mul
}

; exp(a) * exp(b) reassoc, multiple uses
define double @exp_a_exp_b_multiple_uses(double %a, double %b) {
; CHECK-LABEL: @exp_a_exp_b_multiple_uses(
; CHECK-NEXT:    [[T1:%.*]] = call double @llvm.exp.f64(double [[B:%.*]])
; CHECK-NEXT:    [[TMP1:%.*]] = fadd reassoc double [[A:%.*]], [[B]]
; CHECK-NEXT:    [[MUL:%.*]] = call reassoc double @llvm.exp.f64(double [[TMP1]])
; CHECK-NEXT:    call void @use(double [[T1]])
; CHECK-NEXT:    ret double [[MUL]]
;
  %t = call double @llvm.exp.f64(double %a)
  %t1 = call double @llvm.exp.f64(double %b)
  %mul = fmul reassoc double %t, %t1
  call void @use(double %t1)
  ret double %mul
}

; exp(a) * exp(b) reassoc, both with multiple uses
define double @exp_a_exp_b_multiple_uses_both(double %a, double %b) {
; CHECK-LABEL: @exp_a_exp_b_multiple_uses_both(
; CHECK-NEXT:    [[T:%.*]] = call double @llvm.exp.f64(double [[A:%.*]])
; CHECK-NEXT:    [[T1:%.*]] = call double @llvm.exp.f64(double [[B:%.*]])
; CHECK-NEXT:    [[MUL:%.*]] = fmul reassoc double [[T]], [[T1]]
; CHECK-NEXT:    call void @use(double [[T]])
; CHECK-NEXT:    call void @use(double [[T1]])
; CHECK-NEXT:    ret double [[MUL]]
;
  %t = call double @llvm.exp.f64(double %a)
  %t1 = call double @llvm.exp.f64(double %b)
  %mul = fmul reassoc double %t, %t1
  call void @use(double %t)
  call void @use(double %t1)
  ret double %mul
}

; exp(a) * exp(b) => exp(a+b) with reassoc
define double @exp_a_exp_b_reassoc(double %a, double %b) {
; CHECK-LABEL: @exp_a_exp_b_reassoc(
; CHECK-NEXT:    [[TMP1:%.*]] = fadd reassoc double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[MUL:%.*]] = call reassoc double @llvm.exp.f64(double [[TMP1]])
; CHECK-NEXT:    ret double [[MUL]]
;
  %t = call double @llvm.exp.f64(double %a)
  %t1 = call double @llvm.exp.f64(double %b)
  %mul = fmul reassoc double %t, %t1
  ret double %mul
}

define double @exp_a_a(double %a) {
; CHECK-LABEL: @exp_a_a(
; CHECK-NEXT:    [[TMP1:%.*]] = fadd reassoc double [[A:%.*]], [[A]]
; CHECK-NEXT:    [[M:%.*]] = call reassoc double @llvm.exp.f64(double [[TMP1]])
; CHECK-NEXT:    ret double [[M]]
;
  %t = call double @llvm.exp.f64(double %a)
  %m = fmul reassoc double %t, %t
  ret double %m
}

; negative test

define double @exp_a_a_extra_use(double %a) {
; CHECK-LABEL: @exp_a_a_extra_use(
; CHECK-NEXT:    [[T:%.*]] = call double @llvm.exp.f64(double [[A:%.*]])
; CHECK-NEXT:    call void @use(double [[T]])
; CHECK-NEXT:    [[M:%.*]] = fmul reassoc double [[T]], [[T]]
; CHECK-NEXT:    ret double [[M]]
;
  %t = call double @llvm.exp.f64(double %a)
  call void @use(double %t)
  %m = fmul reassoc double %t, %t
  ret double %m
}

; exp(a) * exp(b) * exp(c) * exp(d) => exp(a+b+c+d) with reassoc
define double @exp_a_exp_b_exp_c_exp_d_fast(double %a, double %b, double %c, double %d) {
; CHECK-LABEL: @exp_a_exp_b_exp_c_exp_d_fast(
; CHECK-NEXT:    [[TMP1:%.*]] = fadd reassoc double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[TMP2:%.*]] = fadd reassoc double [[TMP1]], [[C:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = fadd reassoc double [[TMP2]], [[D:%.*]]
; CHECK-NEXT:    [[MUL2:%.*]] = call reassoc double @llvm.exp.f64(double [[TMP3]])
; CHECK-NEXT:    ret double [[MUL2]]
;
  %t = call double @llvm.exp.f64(double %a)
  %t1 = call double @llvm.exp.f64(double %b)
  %mul = fmul reassoc double %t, %t1
  %t2 = call double @llvm.exp.f64(double %c)
  %mul1 = fmul reassoc double %mul, %t2
  %t3 = call double @llvm.exp.f64(double %d)
  %mul2 = fmul reassoc double %mul1, %t3
  ret double %mul2
}
