; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes='require<domtree>,loop(loop-simplifycfg),gvn' -S %s | FileCheck %s

define i32 @test_pointer_phi_select_simp_1(ptr %a, ptr %b, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[TMP0:%.*]] = select i1 [[CMP_I_I_I]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[RES_2_PRE:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES_2:%.*]] = phi i32 [ [[TMP0]], [[THEN]] ], [ [[RES_2_PRE]], [[ELSE]] ]
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_non_local(ptr %a, ptr %b, ptr %c)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_non_local(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[L_1]], 0
; CHECK-NEXT:    br i1 [[COND]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[TMP0:%.*]] = select i1 [[CMP_I_I_I]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[RES_2_PRE:%.*]] = load i32, ptr [[C:%.*]], align 4
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES_2:%.*]] = phi i32 [ [[TMP0]], [[THEN]] ], [ [[RES_2_PRE]], [[ELSE]] ]
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[C]], [[ELSE]] ]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  %l.1 = load i32, ptr %a, align 4
  %cond = icmp sgt i32 %l.1, 0
  br i1 %cond, label %then, label %else

then:
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %c, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_non_local_mismatched_type(ptr %a, ptr %b, ptr %c)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_non_local_mismatched_type(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_1:%.*]] = load float, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[CONV:%.*]] = fptosi float [[L_1]] to i32
; CHECK-NEXT:    [[COND:%.*]] = icmp sgt i32 [[CONV]], 0
; CHECK-NEXT:    br i1 [[COND]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[CONV]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[C:%.*]], [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  %l.1 = load float, ptr %a, align 4
  %conv = fptosi float %l.1 to i32
  %cond = icmp sgt i32 %conv, 0
  br i1 %cond, label %then, label %else

then:
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %conv, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %c, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_no_load_for_select_op_1(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_no_load_for_select_op_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A:%.*]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %c, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_no_load_for_select_op_2(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_no_load_for_select_op_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B:%.*]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %c, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_noclobber(ptr %a, ptr %b, ptr noalias %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_noclobber(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[TMP0:%.*]] = select i1 [[CMP_I_I_I]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[RES_2_PRE:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES_2:%.*]] = phi i32 [ [[TMP0]], [[THEN]] ], [ [[RES_2_PRE]], [[ELSE]] ]
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %c
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_1(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %c
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_2(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  store i32 99, ptr %c
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_3(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[TMP0:%.*]] = select i1 [[CMP_I_I_I]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[RES_2_PRE:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES_2:%.*]] = phi i32 [ [[TMP0]], [[THEN]] ], [ [[RES_2_PRE]], [[ELSE]] ]
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  store i32 99, ptr %c
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_4(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  store i32 99, ptr %c
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_5(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  store i32 99, ptr %c
  %res.2 = load i32, ptr %p, align 4
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_6(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    [[RES_0:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    [[RES_2_PRE:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES_2:%.*]] = phi i32 [ [[RES_0]], [[THEN]] ], [ [[RES_2_PRE]], [[ELSE]] ]
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ [[RES_0]], [[THEN]] ], [ 10, [[ELSE]] ]
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[RES_2]], [[V]]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %c
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %min.select, align 4
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %v = phi i32 [ %res.0, %then ], [ 10, %else ]
  %res.2 = load i32, ptr %p, align 4
  %add = add i32 %res.2, %v
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_7(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    [[RES_0:%.*]] = load i32, ptr [[A]], align 4
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ [[RES_0]], [[THEN]] ], [ 10, [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[RES_2]], [[V]]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %c
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %a, align 4
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %v = phi i32 [ %res.0, %then ], [ 10, %else ]
  %res.2 = load i32, ptr %p, align 4
  %add = add i32 %res.2, %v
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_8(ptr %a, ptr %b, ptr %c, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    [[RES_0:%.*]] = load i32, ptr [[B]], align 4
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ [[RES_0]], [[THEN]] ], [ 10, [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[RES_2]], [[V]]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %c
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %b, align 4
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %v = phi i32 [ %res.0, %then ], [ 10, %else ]
  %res.2 = load i32, ptr %p, align 4
  %add = add i32 %res.2, %v
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_9(ptr %a, ptr %b, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_9(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    [[RES_0:%.*]] = load i32, ptr [[B]], align 4
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ [[RES_0]], [[THEN]] ], [ 10, [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[RES_2]], [[V]]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %a
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %b, align 4
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %v = phi i32 [ %res.0, %then ], [ 10, %else ]
  %res.2 = load i32, ptr %p, align 4
  %add = add i32 %res.2, %v
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_10(ptr %a, ptr %b, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_10(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[A]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ [[L_2]], [[THEN]] ], [ 10, [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[RES_2]], [[V]]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  store i32 99, ptr %a
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %b, align 4
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %v = phi i32 [ %res.0, %then ], [ 10, %else ]
  %res.2 = load i32, ptr %p, align 4
  %add = add i32 %res.2, %v
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_11(ptr %a, ptr %b, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_11(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[B]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ 99, [[THEN]] ], [ 10, [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[RES_2]], [[V]]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %b
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %b, align 4
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %v = phi i32 [ %res.0, %then ], [ 10, %else ]
  %res.2 = load i32, ptr %p, align 4
  %add = add i32 %res.2, %v
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_simp_store_clobber_12(ptr %a, ptr %b, i1 %cond)  {
; CHECK-LABEL: @test_pointer_phi_select_simp_store_clobber_12(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[COND:%.*]], label [[THEN:%.*]], label [[ELSE:%.*]]
; CHECK:       then:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], 99
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       else:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi ptr [ [[MIN_SELECT]], [[THEN]] ], [ [[A]], [[ELSE]] ]
; CHECK-NEXT:    [[V:%.*]] = phi i32 [ 99, [[THEN]] ], [ 10, [[ELSE]] ]
; CHECK-NEXT:    [[RES_2:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add i32 [[RES_2]], [[V]]
; CHECK-NEXT:    ret i32 [[RES_2]]
;
entry:
  br i1 %cond, label %then, label %else

then:
  %l.1 = load i32, ptr %a, align 4
  store i32 99, ptr %b
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %b, align 4
  br label %exit

else:
  br label %exit

exit:
  %p = phi ptr [ %min.select, %then ], [ %a, %else ]
  %v = phi i32 [ %res.0, %then ], [ 10, %else ]
  %res.2 = load i32, ptr %p, align 4
  %add = add i32 %res.2, %v
  ret i32 %res.2
}

define i32 @test_pointer_phi_select_single_block_store(ptr %a, ptr %b)  {
; CHECK-LABEL: @test_pointer_phi_select_single_block_store(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[TMP0:%.*]] = select i1 [[CMP_I_I_I]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %min.select, align 4
  ret i32 %res.0
}

define i32 @test_pointer_phi_select_single_block_store_clobber_1(ptr %a, ptr %b, ptr %c)  {
; CHECK-LABEL: @test_pointer_phi_select_single_block_store_clobber_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    [[RES_0:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES_0]]
;
entry:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  store i32 99, ptr %c
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %min.select, align 4
  ret i32 %res.0
}

define i32 @test_pointer_phi_select_single_block_store_clobber_2(ptr %a, ptr %b, ptr %c)  {
; CHECK-LABEL: @test_pointer_phi_select_single_block_store_clobber_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[RES_0:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES_0]]
;
entry:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  store i32 99, ptr %c
  %res.0 = load i32, ptr %min.select, align 4
  ret i32 %res.0
}

define i32 @test_pointer_phi_select_single_block_store_clobber_3(ptr %a, ptr %b, ptr %c)  {
; CHECK-LABEL: @test_pointer_phi_select_single_block_store_clobber_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    [[RES_0:%.*]] = load i32, ptr [[MIN_SELECT]], align 4
; CHECK-NEXT:    ret i32 [[RES_0]]
;
entry:
  %l.1 = load i32, ptr %a, align 4
  store i32 99, ptr %c
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %min.select, align 4
  ret i32 %res.0
}

define i32 @test_pointer_phi_select_single_block_store_after(ptr %a, ptr %b, ptr %c)  {
; CHECK-LABEL: @test_pointer_phi_select_single_block_store_after(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L_1:%.*]] = load i32, ptr [[A:%.*]], align 4
; CHECK-NEXT:    [[L_2:%.*]] = load i32, ptr [[B:%.*]], align 4
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp ult i32 [[L_1]], [[L_2]]
; CHECK-NEXT:    [[TMP0:%.*]] = select i1 [[CMP_I_I_I]], i32 [[L_1]], i32 [[L_2]]
; CHECK-NEXT:    [[MIN_SELECT:%.*]] = select i1 [[CMP_I_I_I]], ptr [[A]], ptr [[B]]
; CHECK-NEXT:    store i32 99, ptr [[C:%.*]], align 4
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %l.1 = load i32, ptr %a, align 4
  %l.2 = load i32, ptr %b, align 4
  %cmp.i.i.i = icmp ult i32 %l.1, %l.2
  %min.select  = select i1 %cmp.i.i.i, ptr %a, ptr %b
  %res.0 = load i32, ptr %min.select, align 4
  store i32 99, ptr %c
  ret i32 %res.0
}
