; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -passes='print<scalar-evolution>' -disable-output %s 2>&1 | FileCheck %s

; Tests for PR47904.

define void @test_trip_multiple_4(i32 %num) {
; CHECK-LABEL: 'test_trip_multiple_4'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,-2147483648) S: [0,-2147483648) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp uge i32 %num, 4
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_guard(i32 %num) {
; CHECK-LABEL: 'test_trip_multiple_4_guard'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4_guard
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,-2147483648) S: [0,-2147483648) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4_guard
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  call void(i1, ...) @llvm.experimental.guard(i1 %cmp) [ "deopt"() ]
  %cmp.1 = icmp uge i32 %num, 4
  call void(i1, ...) @llvm.experimental.guard(i1 %cmp.1) [ "deopt"() ]
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}


define void @test_trip_multiple_4_ugt_5(i32 %num) {
; CHECK-LABEL: 'test_trip_multiple_4_ugt_5'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4_ugt_5
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,-2147483648) S: [0,-2147483648) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4_ugt_5
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp ugt i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_ugt_5_order_swapped(i32 %num) {
; TODO: Trip multiple can be 4, it is missed due to the processing order of the assumes.
; CHECK-LABEL: 'test_trip_multiple_4_ugt_5_order_swapped'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4_ugt_5_order_swapped
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,-2147483648) S: [0,-2147483648) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4_ugt_5_order_swapped
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp.1 = icmp ugt i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_sgt_5(i32 %num) {
; CHECK-LABEL: 'test_trip_multiple_4_sgt_5'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4_sgt_5
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,2147483647) S: [0,2147483647) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4_sgt_5
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is 2147483646
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp sgt i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp slt i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_sgt_5_order_swapped(i32 %num) {
; TODO: Trip multiple can be 4, it is missed due to the processing order of the assumes.
; CHECK-LABEL: 'test_trip_multiple_4_sgt_5_order_swapped'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4_sgt_5_order_swapped
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,2147483647) S: [0,2147483647) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4_sgt_5_order_swapped
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is 2147483646
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp.1 = icmp sgt i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp slt i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_uge_5(i32 %num) {
; CHECK-LABEL: 'test_trip_multiple_4_uge_5'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4_uge_5
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,-2147483648) S: [0,-2147483648) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4_uge_5
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp uge i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_uge_5_order_swapped(i32 %num) {
; TODO: Trip multiple can be 4, it is missed due to the processing order of the assumes.
; CHECK-LABEL: 'test_trip_multiple_4_uge_5_order_swapped'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4_uge_5_order_swapped
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,-2147483648) S: [0,-2147483648) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4_uge_5_order_swapped
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  %cmp.1 = icmp uge i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  tail call void @llvm.assume(i1 %cmp)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_sge_5(i32 %num) {
; TODO: Trip multiple can be 4, it is missed due to the processing order of the assumes.
; CHECK-LABEL: 'test_trip_multiple_4_sge_5'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4_sge_5
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,2147483647) S: [0,2147483647) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4_sge_5
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is 2147483646
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp sge i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp slt i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_sge_5_order_swapped(i32 %num) {
; CHECK-LABEL: 'test_trip_multiple_4_sge_5_order_swapped'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4_sge_5_order_swapped
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,2147483647) S: [0,2147483647) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4_sge_5_order_swapped
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is 2147483646
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  %cmp.1 = icmp sge i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  tail call void @llvm.assume(i1 %cmp)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp slt i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

; Same as @test_trip_multiple_4 but with the icmp operands swapped.
define void @test_trip_multiple_4_icmp_ops_swapped(i32 %num) {
; CHECK-LABEL: 'test_trip_multiple_4_icmp_ops_swapped'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4_icmp_ops_swapped
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,-2147483648) S: [0,-2147483648) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4_icmp_ops_swapped
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 4
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 0, %u
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp uge i32 %num, 4
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_upper_lower_bounds(i32 %num) {
; CHECK-LABEL: 'test_trip_multiple_4_upper_lower_bounds'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4_upper_lower_bounds
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,-2147483648) S: [0,-2147483648) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4_upper_lower_bounds
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 4
;
entry:
  %cmp.1 = icmp uge i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.2 = icmp ult i32 %num, 59000
  tail call void @llvm.assume(i1 %cmp.2)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_upper_lower_bounds_swapped1(i32 %num) {
; CHECK-LABEL: 'test_trip_multiple_4_upper_lower_bounds_swapped1'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4_upper_lower_bounds_swapped1
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,-2147483648) S: [0,-2147483648) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4_upper_lower_bounds_swapped1
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 4
;
entry:
  %cmp.1 = icmp uge i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.2 = icmp ult i32 %num, 59000
  tail call void @llvm.assume(i1 %cmp.2)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_4_upper_lower_bounds_swapped2(i32 %num) {
; CHECK-LABEL: 'test_trip_multiple_4_upper_lower_bounds_swapped2'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4_upper_lower_bounds_swapped2
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,-2147483648) S: [0,-2147483648) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4_upper_lower_bounds_swapped2
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 4
;
entry:
  %cmp.1 = icmp uge i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  %cmp.2 = icmp ult i32 %num, 59000
  tail call void @llvm.assume(i1 %cmp.2)
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trip_multiple_5(i32 %num) {
; CHECK-LABEL: 'test_trip_multiple_5'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_5
; CHECK-NEXT:    %u = urem i32 %num, 5
; CHECK-NEXT:    --> ((-5 * (%num /u 5)) + %num) U: full-set S: full-set
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,-2147483648) S: [0,-2147483648) Exits: (-1 + %num) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add nuw nsw i32 %i.010, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-2147483648) S: [1,-2147483648) Exits: %num LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_5
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is -2
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %num)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %num)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 5
;
entry:
  %u = urem i32 %num, 5
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  %cmp.1 = icmp uge i32 %num, 5
  tail call void @llvm.assume(i1 %cmp.1)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add nuw nsw i32 %i.010, 1
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

define void @test_trunc_operand_larger_than_urem_expr(i64 %N) {
; CHECK-LABEL: 'test_trunc_operand_larger_than_urem_expr'
; CHECK-NEXT:  Classifying expressions for: @test_trunc_operand_larger_than_urem_expr
; CHECK-NEXT:    %conv = trunc i64 %N to i32
; CHECK-NEXT:    --> (trunc i64 %N to i32) U: full-set S: full-set
; CHECK-NEXT:    %and = and i32 %conv, 1
; CHECK-NEXT:    --> (zext i1 (trunc i64 %N to i1) to i32) U: [0,2) S: [0,2)
; CHECK-NEXT:    %iv = phi i64 [ 0, %entry ], [ %iv.next, %for.body ]
; CHECK-NEXT:    --> {0,+,1}<nuw><nsw><%for.body> U: [0,-9223372036854775808) S: [0,-9223372036854775808) Exits: (-1 + %N) LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %iv.next = add nuw nsw i64 %iv, 1
; CHECK-NEXT:    --> {1,+,1}<nuw><nsw><%for.body> U: [1,-9223372036854775808) S: [1,-9223372036854775808) Exits: %N LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trunc_operand_larger_than_urem_expr
; CHECK-NEXT:  Loop %for.body: backedge-taken count is (-1 + %N)
; CHECK-NEXT:  Loop %for.body: constant max backedge-taken count is -1
; CHECK-NEXT:  Loop %for.body: symbolic max backedge-taken count is (-1 + %N)
; CHECK-NEXT:  Loop %for.body: Predicated backedge-taken count is (-1 + %N)
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:  Loop %for.body: Trip multiple is 1
;
entry:
  %conv = trunc i64 %N to i32
  %and = and i32 %conv, 1
  %cmp.pre = icmp eq i32 %and, 0
  br i1 %cmp.pre, label %for.body, label %exit

for.body:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %for.body ]
  %iv.next = add nuw nsw i64 %iv, 1
  %cmp.1 = icmp ne i64 %iv.next, %N
  br i1 %cmp.1, label %for.body, label %exit

exit:
  ret void
}

; TODO: Even though %num is known to divide by 4, and the loop's IV advances by 4, SCEV can't compute the trip count.
define void @test_trip_multiple_4_vectorized_iv(i32 %num) {
; CHECK-LABEL: 'test_trip_multiple_4_vectorized_iv'
; CHECK-NEXT:  Classifying expressions for: @test_trip_multiple_4_vectorized_iv
; CHECK-NEXT:    %u = urem i32 %num, 4
; CHECK-NEXT:    --> (zext i2 (trunc i32 %num to i2) to i32) U: [0,4) S: [0,4)
; CHECK-NEXT:    %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
; CHECK-NEXT:    --> {0,+,4}<%for.body> U: [0,-3) S: [-2147483648,2147483645) Exits: <<Unknown>> LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:    %inc = add i32 %i.010, 4
; CHECK-NEXT:    --> {4,+,4}<%for.body> U: [0,-3) S: [-2147483648,2147483645) Exits: <<Unknown>> LoopDispositions: { %for.body: Computable }
; CHECK-NEXT:  Determining loop execution counts for: @test_trip_multiple_4_vectorized_iv
; CHECK-NEXT:  Loop %for.body: Unpredictable backedge-taken count.
; CHECK-NEXT:  Loop %for.body: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %for.body: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:  Loop %for.body: Unpredictable predicated backedge-taken count.
;
entry:
  %u = urem i32 %num, 4
  %cmp = icmp eq i32 %u, 0
  tail call void @llvm.assume(i1 %cmp)
  br label %for.body

for.body:
  %i.010 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %inc = add i32 %i.010, 4
  %cmp2 = icmp ult i32 %inc, %num
  br i1 %cmp2, label %for.body, label %exit

exit:
  ret void
}

declare void @llvm.assume(i1)
declare void @llvm.experimental.guard(i1, ...)
