; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=riscv32 -mattr=+experimental-zfbfmin -verify-machineinstrs \
; RUN:   -target-abi ilp32f < %s | FileCheck -check-prefixes=CHECK,RV32IZFBFMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+experimental-zfbfmin -verify-machineinstrs \
; RUN:   -target-abi lp64f < %s | FileCheck -check-prefixes=CHECK,RV64IZFBFMIN %s

define bfloat @flh(ptr %a) nounwind {
; CHECK-LABEL: flh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    flh fa5, 6(a0)
; CHECK-NEXT:    flh fa4, 0(a0)
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa5
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa4
; CHECK-NEXT:    fadd.s fa5, fa4, fa5
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    ret
  %1 = load bfloat, ptr %a
  %2 = getelementptr bfloat, ptr %a, i32 3
  %3 = load bfloat, ptr %2
; Use both loaded values in an FP op to ensure an flh is used, even for the
; soft bfloat ABI
  %4 = fadd bfloat %1, %3
  ret bfloat %4
}

define dso_local void @fsh(ptr %a, bfloat %b, bfloat %c) nounwind {
; CHECK-LABEL: fsh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa1
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa0
; CHECK-NEXT:    fadd.s fa5, fa4, fa5
; CHECK-NEXT:    fcvt.bf16.s fa5, fa5
; CHECK-NEXT:    fsh fa5, 0(a0)
; CHECK-NEXT:    fsh fa5, 16(a0)
; CHECK-NEXT:    ret
  %1 = fadd bfloat %b, %c
  store bfloat %1, ptr %a
  %2 = getelementptr bfloat, ptr %a, i32 8
  store bfloat %1, ptr %2
  ret void
}

; Check load and store to a global
@G = dso_local global bfloat 0.0

define bfloat @flh_fsh_global(bfloat %a, bfloat %b) nounwind {
; Use %a and %b in an FP op to ensure bfloat precision floating point registers
; are used, even for the soft bfloat ABI
; CHECK-LABEL: flh_fsh_global:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fcvt.s.bf16 fa5, fa1
; CHECK-NEXT:    fcvt.s.bf16 fa4, fa0
; CHECK-NEXT:    fadd.s fa5, fa4, fa5
; CHECK-NEXT:    fcvt.bf16.s fa0, fa5
; CHECK-NEXT:    lui a0, %hi(G)
; CHECK-NEXT:    flh fa5, %lo(G)(a0)
; CHECK-NEXT:    addi a1, a0, %lo(G)
; CHECK-NEXT:    fsh fa0, %lo(G)(a0)
; CHECK-NEXT:    flh fa5, 18(a1)
; CHECK-NEXT:    fsh fa0, 18(a1)
; CHECK-NEXT:    ret
  %1 = fadd bfloat %a, %b
  %2 = load volatile bfloat, ptr @G
  store bfloat %1, ptr @G
  %3 = getelementptr bfloat, ptr @G, i32 9
  %4 = load volatile bfloat, ptr %3
  store bfloat %1, ptr %3
  ret bfloat %1
}

; Ensure that 1 is added to the high 20 bits if bit 11 of the low part is 1
define bfloat @flh_fsh_constant(bfloat %a) nounwind {
; RV32IZFBFMIN-LABEL: flh_fsh_constant:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    lui a0, 912092
; RV32IZFBFMIN-NEXT:    flh fa5, -273(a0)
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa5
; RV32IZFBFMIN-NEXT:    fadd.s fa5, fa4, fa5
; RV32IZFBFMIN-NEXT:    fcvt.bf16.s fa0, fa5
; RV32IZFBFMIN-NEXT:    fsh fa0, -273(a0)
; RV32IZFBFMIN-NEXT:    ret
;
; RV64IZFBFMIN-LABEL: flh_fsh_constant:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    lui a0, 228023
; RV64IZFBFMIN-NEXT:    slli a0, a0, 2
; RV64IZFBFMIN-NEXT:    flh fa5, -273(a0)
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa5
; RV64IZFBFMIN-NEXT:    fadd.s fa5, fa4, fa5
; RV64IZFBFMIN-NEXT:    fcvt.bf16.s fa0, fa5
; RV64IZFBFMIN-NEXT:    fsh fa0, -273(a0)
; RV64IZFBFMIN-NEXT:    ret
  %1 = inttoptr i32 3735928559 to ptr
  %2 = load volatile bfloat, ptr %1
  %3 = fadd bfloat %a, %2
  store bfloat %3, ptr %1
  ret bfloat %3
}

declare void @notdead(ptr)

define bfloat @flh_stack(bfloat %a) nounwind {
; RV32IZFBFMIN-LABEL: flh_stack:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    fsw fs0, 8(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    fmv.s fs0, fa0
; RV32IZFBFMIN-NEXT:    addi a0, sp, 4
; RV32IZFBFMIN-NEXT:    call notdead
; RV32IZFBFMIN-NEXT:    flh fa5, 4(sp)
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fs0
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa5
; RV32IZFBFMIN-NEXT:    fadd.s fa5, fa5, fa4
; RV32IZFBFMIN-NEXT:    fcvt.bf16.s fa0, fa5
; RV32IZFBFMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFBFMIN-NEXT:    flw fs0, 8(sp) # 4-byte Folded Reload
; RV32IZFBFMIN-NEXT:    addi sp, sp, 16
; RV32IZFBFMIN-NEXT:    ret
;
; RV64IZFBFMIN-LABEL: flh_stack:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    fsw fs0, 4(sp) # 4-byte Folded Spill
; RV64IZFBFMIN-NEXT:    fmv.s fs0, fa0
; RV64IZFBFMIN-NEXT:    mv a0, sp
; RV64IZFBFMIN-NEXT:    call notdead
; RV64IZFBFMIN-NEXT:    flh fa5, 0(sp)
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fs0
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa5
; RV64IZFBFMIN-NEXT:    fadd.s fa5, fa5, fa4
; RV64IZFBFMIN-NEXT:    fcvt.bf16.s fa0, fa5
; RV64IZFBFMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFBFMIN-NEXT:    flw fs0, 4(sp) # 4-byte Folded Reload
; RV64IZFBFMIN-NEXT:    addi sp, sp, 16
; RV64IZFBFMIN-NEXT:    ret
  %1 = alloca bfloat, align 4
  call void @notdead(ptr %1)
  %2 = load bfloat, ptr %1
  %3 = fadd bfloat %2, %a ; force load in to FPR16
  ret bfloat %3
}

define dso_local void @fsh_stack(bfloat %a, bfloat %b) nounwind {
; RV32IZFBFMIN-LABEL: fsh_stack:
; RV32IZFBFMIN:       # %bb.0:
; RV32IZFBFMIN-NEXT:    addi sp, sp, -16
; RV32IZFBFMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV32IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV32IZFBFMIN-NEXT:    fadd.s fa5, fa4, fa5
; RV32IZFBFMIN-NEXT:    fcvt.bf16.s fa5, fa5
; RV32IZFBFMIN-NEXT:    fsh fa5, 8(sp)
; RV32IZFBFMIN-NEXT:    addi a0, sp, 8
; RV32IZFBFMIN-NEXT:    call notdead
; RV32IZFBFMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFBFMIN-NEXT:    addi sp, sp, 16
; RV32IZFBFMIN-NEXT:    ret
;
; RV64IZFBFMIN-LABEL: fsh_stack:
; RV64IZFBFMIN:       # %bb.0:
; RV64IZFBFMIN-NEXT:    addi sp, sp, -16
; RV64IZFBFMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa5, fa1
; RV64IZFBFMIN-NEXT:    fcvt.s.bf16 fa4, fa0
; RV64IZFBFMIN-NEXT:    fadd.s fa5, fa4, fa5
; RV64IZFBFMIN-NEXT:    fcvt.bf16.s fa5, fa5
; RV64IZFBFMIN-NEXT:    fsh fa5, 4(sp)
; RV64IZFBFMIN-NEXT:    addi a0, sp, 4
; RV64IZFBFMIN-NEXT:    call notdead
; RV64IZFBFMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFBFMIN-NEXT:    addi sp, sp, 16
; RV64IZFBFMIN-NEXT:    ret
  %1 = fadd bfloat %a, %b ; force store from FPR16
  %2 = alloca bfloat, align 4
  store bfloat %1, ptr %2
  call void @notdead(ptr %2)
  ret void
}
