; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68000 | FileCheck %s --check-prefix=NO-ATOMIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68010 | FileCheck %s --check-prefix=NO-ATOMIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68020 | FileCheck %s --check-prefix=ATOMIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68030 | FileCheck %s --check-prefix=ATOMIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68040 | FileCheck %s --check-prefix=ATOMIC

define i1 @cmpxchg_i8_monotonic_monotonic(i8 %cmp, i8 %new, ptr %mem) nounwind {
; NO-ATOMIC-LABEL: cmpxchg_i8_monotonic_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #20, %sp
; NO-ATOMIC-NEXT:    movem.l %d2, (16,%sp) ; 8-byte Folded Spill
; NO-ATOMIC-NEXT:    move.b (31,%sp), %d0
; NO-ATOMIC-NEXT:    and.l #255, %d0
; NO-ATOMIC-NEXT:    move.l %d0, (8,%sp)
; NO-ATOMIC-NEXT:    move.b (27,%sp), %d2
; NO-ATOMIC-NEXT:    move.l %d2, %d0
; NO-ATOMIC-NEXT:    and.l #255, %d0
; NO-ATOMIC-NEXT:    move.l %d0, (4,%sp)
; NO-ATOMIC-NEXT:    move.l (32,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __sync_val_compare_and_swap_1
; NO-ATOMIC-NEXT:    sub.b %d2, %d0
; NO-ATOMIC-NEXT:    seq %d0
; NO-ATOMIC-NEXT:    movem.l (16,%sp), %d2 ; 8-byte Folded Reload
; NO-ATOMIC-NEXT:    adda.l #20, %sp
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: cmpxchg_i8_monotonic_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #4, %sp
; ATOMIC-NEXT:    movem.l %d2, (0,%sp) ; 8-byte Folded Spill
; ATOMIC-NEXT:    move.l (16,%sp), %a0
; ATOMIC-NEXT:    move.b (15,%sp), %d0
; ATOMIC-NEXT:    move.b (11,%sp), %d1
; ATOMIC-NEXT:    move.b %d1, %d2
; ATOMIC-NEXT:    cas.b %d2, %d0, (%a0)
; ATOMIC-NEXT:    sub.b %d1, %d2
; ATOMIC-NEXT:    seq %d0
; ATOMIC-NEXT:    movem.l (0,%sp), %d2 ; 8-byte Folded Reload
; ATOMIC-NEXT:    adda.l #4, %sp
; ATOMIC-NEXT:    rts
  %res = cmpxchg ptr %mem, i8 %cmp, i8 %new monotonic monotonic
  %val = extractvalue {i8, i1} %res, 1
  ret i1 %val
}

define i16 @cmpxchg_i16_release_monotonic(i16 %cmp, i16 %new, ptr %mem) nounwind {
; NO-ATOMIC-LABEL: cmpxchg_i16_release_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #12, %sp
; NO-ATOMIC-NEXT:    move.w (22,%sp), %d0
; NO-ATOMIC-NEXT:    and.l #65535, %d0
; NO-ATOMIC-NEXT:    move.l %d0, (8,%sp)
; NO-ATOMIC-NEXT:    move.w (18,%sp), %d0
; NO-ATOMIC-NEXT:    and.l #65535, %d0
; NO-ATOMIC-NEXT:    move.l %d0, (4,%sp)
; NO-ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __sync_val_compare_and_swap_2
; NO-ATOMIC-NEXT:    adda.l #12, %sp
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: cmpxchg_i16_release_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (12,%sp), %a0
; ATOMIC-NEXT:    move.w (10,%sp), %d1
; ATOMIC-NEXT:    move.w (6,%sp), %d0
; ATOMIC-NEXT:    cas.w %d0, %d1, (%a0)
; ATOMIC-NEXT:    rts
  %res = cmpxchg ptr %mem, i16 %cmp, i16 %new release monotonic
  %val = extractvalue {i16, i1} %res, 0
  ret i16 %val
}

define i32 @cmpxchg_i32_release_acquire(i32 %cmp, i32 %new, ptr %mem) nounwind {
; NO-ATOMIC-LABEL: cmpxchg_i32_release_acquire:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #12, %sp
; NO-ATOMIC-NEXT:    move.l (20,%sp), (8,%sp)
; NO-ATOMIC-NEXT:    move.l (16,%sp), (4,%sp)
; NO-ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __sync_val_compare_and_swap_4
; NO-ATOMIC-NEXT:    adda.l #12, %sp
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: cmpxchg_i32_release_acquire:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (12,%sp), %a0
; ATOMIC-NEXT:    move.l (8,%sp), %d1
; ATOMIC-NEXT:    move.l (4,%sp), %d0
; ATOMIC-NEXT:    cas.l %d0, %d1, (%a0)
; ATOMIC-NEXT:    rts
  %res = cmpxchg ptr %mem, i32 %cmp, i32 %new release acquire
  %val = extractvalue {i32, i1} %res, 0
  ret i32 %val
}

define i64 @cmpxchg_i64_seqcst_seqcst(i64 %cmp, i64 %new, ptr %mem) nounwind {
; NO-ATOMIC-LABEL: cmpxchg_i64_seqcst_seqcst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #36, %sp
; NO-ATOMIC-NEXT:    move.l (44,%sp), (28,%sp)
; NO-ATOMIC-NEXT:    move.l (40,%sp), (24,%sp)
; NO-ATOMIC-NEXT:    lea (24,%sp), %a0
; NO-ATOMIC-NEXT:    move.l %a0, (4,%sp)
; NO-ATOMIC-NEXT:    move.l #5, (20,%sp)
; NO-ATOMIC-NEXT:    move.l #5, (16,%sp)
; NO-ATOMIC-NEXT:    move.l (52,%sp), (12,%sp)
; NO-ATOMIC-NEXT:    move.l (48,%sp), (8,%sp)
; NO-ATOMIC-NEXT:    move.l (56,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_compare_exchange_8
; NO-ATOMIC-NEXT:    move.l (28,%sp), %d1
; NO-ATOMIC-NEXT:    move.l (24,%sp), %d0
; NO-ATOMIC-NEXT:    adda.l #36, %sp
; NO-ATOMIC-NEXT:    rts
;
; ATOMIC-LABEL: cmpxchg_i64_seqcst_seqcst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #36, %sp
; ATOMIC-NEXT:    move.l (44,%sp), (28,%sp)
; ATOMIC-NEXT:    move.l (40,%sp), (24,%sp)
; ATOMIC-NEXT:    lea (24,%sp), %a0
; ATOMIC-NEXT:    move.l %a0, (4,%sp)
; ATOMIC-NEXT:    move.l #5, (20,%sp)
; ATOMIC-NEXT:    move.l #5, (16,%sp)
; ATOMIC-NEXT:    move.l (52,%sp), (12,%sp)
; ATOMIC-NEXT:    move.l (48,%sp), (8,%sp)
; ATOMIC-NEXT:    move.l (56,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_compare_exchange_8
; ATOMIC-NEXT:    move.l (28,%sp), %d1
; ATOMIC-NEXT:    move.l (24,%sp), %d0
; ATOMIC-NEXT:    adda.l #36, %sp
; ATOMIC-NEXT:    rts
  %res = cmpxchg ptr %mem, i64 %cmp, i64 %new seq_cst seq_cst
  %val = extractvalue {i64, i1} %res, 0
  ret i64 %val
}
