; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv64 -mattr=+zicond < %s | FileCheck %s --check-prefixes=CHECK,CHEAP
; RUN: llc -mtriple=riscv64 -mattr=+zicond,+predictable-select-expensive < %s | FileCheck %s --check-prefixes=CHECK,EXPENSIVE

; Test has not predictable select, which should not be transformed to a branch
define i32 @test1(i32 %a) {
; CHECK-LABEL: test1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sext.w a1, a0
; CHECK-NEXT:    slti a1, a1, 1
; CHECK-NEXT:    addiw a0, a0, -1
; CHECK-NEXT:    czero.nez a0, a0, a1
; CHECK-NEXT:    ret
entry:
  %cmp = icmp slt i32 %a, 1
  %dec = sub i32 %a, 1
  %res = select i1 %cmp, i32 0, i32 %dec, !prof !0
  ret i32 %res
}

; Test has highly predictable select according to profile data,
; which should be transformed to a branch on cores with enabled FeaturePredictableSelectIsExpensive
define i32 @test2(i32 %a) {
; CHEAP-LABEL: test2:
; CHEAP:       # %bb.0: # %entry
; CHEAP-NEXT:    sext.w a1, a0
; CHEAP-NEXT:    slti a1, a1, 1
; CHEAP-NEXT:    addiw a0, a0, -1
; CHEAP-NEXT:    czero.nez a0, a0, a1
; CHEAP-NEXT:    ret
;
; EXPENSIVE-LABEL: test2:
; EXPENSIVE:       # %bb.0: # %entry
; EXPENSIVE-NEXT:    sext.w a1, a0
; EXPENSIVE-NEXT:    blez a1, .LBB1_2
; EXPENSIVE-NEXT:  # %bb.1: # %select.false
; EXPENSIVE-NEXT:    addiw a0, a0, -1
; EXPENSIVE-NEXT:    ret
; EXPENSIVE-NEXT:  .LBB1_2:
; EXPENSIVE-NEXT:    li a0, 0
; EXPENSIVE-NEXT:    ret
entry:
  %cmp = icmp slt i32 %a, 1
  %dec = sub i32 %a, 1
  %res = select i1 %cmp, i32 0, i32 %dec, !prof !1
  ret i32 %res
}

!0 = !{!"branch_weights", i32 1, i32 1}
!1 = !{!"branch_weights", i32 1, i32 1000}
