; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr10 -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names \
; RUN:     < %s | FileCheck %s --check-prefix=CHECK-P10LE

; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:     -mcpu=pwr10 -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names \
; RUN:     < %s | FileCheck %s --check-prefix=CHECK-P10BE

; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:     -mcpu=pwr9 -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names \
; RUN:     < %s | FileCheck %s --check-prefix=CHECK-P9

; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:     -mcpu=pwr9 -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names \
; RUN:     < %s | FileCheck %s --check-prefix=CHECK-P9

define <8 x i16> @test1(ptr  %a) {
; CHECK-P10LE-LABEL: test1:
; CHECK-P10LE:       # %bb.0: # %entry
; CHECK-P10LE-NEXT:    lxvrhx v2, 0, r3
; CHECK-P10LE-NEXT:    blr
;
; CHECK-P10BE-LABEL: test1:
; CHECK-P10BE:       # %bb.0: # %entry
; CHECK-P10BE-NEXT:    lxsihzx v2, 0, r3
; CHECK-P10BE-NEXT:    vsplth v2, v2, 3
; CHECK-P10BE-NEXT:    blr
;
; CHECK-P9-LABEL: test1:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxsihzx v2, 0, r3
; CHECK-P9-NEXT:    vsplth v2, v2, 3
; CHECK-P9-NEXT:    blr
entry:
  %0 = load i16, ptr %a, align 2
  %vecinit = insertelement <8 x i16> undef, i16 %0, i32 0
  ret <8 x i16> %vecinit
}

define <16 x i8> @test2(ptr  %a) {
; CHECK-P10LE-LABEL: test2:
; CHECK-P10LE:       # %bb.0: # %entry
; CHECK-P10LE-NEXT:    lxvrbx v2, 0, r3
; CHECK-P10LE-NEXT:    blr
;
; CHECK-P10BE-LABEL: test2:
; CHECK-P10BE:       # %bb.0: # %entry
; CHECK-P10BE-NEXT:    lxsibzx v2, 0, r3
; CHECK-P10BE-NEXT:    vspltb v2, v2, 7
; CHECK-P10BE-NEXT:    blr
;
; CHECK-P9-LABEL: test2:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lxsibzx v2, 0, r3
; CHECK-P9-NEXT:    vspltb v2, v2, 7
; CHECK-P9-NEXT:    blr
entry:
  %0 = load i8, ptr %a, align 1
  %vecins = insertelement <16 x i8> undef, i8 %0, i32 0
  ret <16 x i8> %vecins
}

