; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve < %s | FileCheck %s

; Check that DAGCombiner is not asserting with mis-matched vector element count, "Vector element counts must match in SIGN_EXTEND_INREG".
; Also no warning message of "warning: Possible incorrect use of EVT::getVectorNumElements() for scalable vector.".

define <vscale x 4 x i32> @sext_inreg(<vscale x 4 x i32> %a) {
; CHECK-LABEL: sext_inreg:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sxth z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %sext = shl <vscale x 4 x i32> %a, splat(i32 16)
  %conv = ashr <vscale x 4 x i32> %sext, splat(i32 16)
  ret <vscale x 4 x i32> %conv
}

define <vscale x 4 x i32> @ashr_shl(<vscale x 4 x i32> %a)  {
; CHECK-LABEL: ashr_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #8
; CHECK-NEXT:    asr z0.s, z0.s, #16
; CHECK-NEXT:    ret
  %shl = shl <vscale x 4 x i32> %a, splat(i32 8)
  %r = ashr <vscale x 4 x i32> %shl, splat(i32 16)
  ret <vscale x 4 x i32> %r
}

define <vscale x 4 x i32> @ashr_shl_illegal_trunc_vec_ty(<vscale x 4 x i32> %a)  {
; CHECK-LABEL: ashr_shl_illegal_trunc_vec_ty:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #8
; CHECK-NEXT:    asr z0.s, z0.s, #11
; CHECK-NEXT:    ret
  %shl = shl <vscale x 4 x i32> %a, splat(i32 8)
  %r = ashr <vscale x 4 x i32> %shl, splat(i32 11)
  ret <vscale x 4 x i32> %r
}

define <vscale x 4 x i32> @ashr_add_shl_nxv4i8(<vscale x 4 x i32> %a) {
; CHECK-LABEL: ashr_add_shl_nxv4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov z1.s, #0x1000000
; CHECK-NEXT:    lsl z0.s, z0.s, #24
; CHECK-NEXT:    add z0.s, z0.s, z1.s
; CHECK-NEXT:    asr z0.s, z0.s, #24
; CHECK-NEXT:    ret
  %conv = shl <vscale x 4 x i32> %a, splat(i32 24)
  %sext = add <vscale x 4 x i32> %conv, splat(i32 16777216)
  %conv1 = ashr <vscale x 4 x i32> %sext, splat(i32 24)
  ret <vscale x 4 x i32> %conv1
}
