# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-p550 -iterations=1 < %s | FileCheck %s

add t0, t0, t0
addw t2, t2, t2
sub t1, t1, t1
subw t3, t3, t3

addi t0, t0, 100
addiw t2, t2, 200

and t2, t2, t2
or  t3, t3, t3
xor t4, t4, t4

andi t2, t2, 10
ori  t3, t3, 20
xori t4, t4, 30

sll t5, t5, t6
srl t0, s0, t6
sra s1, s1, t6

slli t5, t5, 1
srli t0, s0, 2
srai s1, s1, 3

mul s6, s6, s7
mulw s4, s4, a2

div a0, a0, a0
divw a1, a1, a1
rem a2, a2, a2
remw a2, a2, a2

rol t5, t5, t6
ror t6, t6, t5
rori t5, t5, 5

rolw t5, t5, t6
rorw t6, t6, t5
roriw t5, t5, 5

andn a0, a0, a1
orn a1, a2, a3
xnor a2, a3, a4

min a3, a4, a5
max a4, a5, a6
minu a5, a6, a7
maxu a6, a7, s0

orc.b s0, s1
rev8 s1, s2

cpop t1, t1
cpopw t2, t2

sh1add t0, t1, t2
sh2add t0, t1, t2
sh3add t0, t1, t2

add.uw    s0, s1, s2
sh1add.uw t0, t1, t2
sh2add.uw t0, t1, t2
sh3add.uw t0, t1, t2

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      48
# CHECK-NEXT: Total Cycles:      120
# CHECK-NEXT: Total uOps:        48

# CHECK:      Dispatch Width:    3
# CHECK-NEXT: uOps Per Cycle:    0.40
# CHECK-NEXT: IPC:               0.40
# CHECK-NEXT: Block RThroughput: 106.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.33                        add	t0, t0, t0
# CHECK-NEXT:  1      1     0.33                        addw	t2, t2, t2
# CHECK-NEXT:  1      1     0.33                        sub	t1, t1, t1
# CHECK-NEXT:  1      1     0.33                        subw	t3, t3, t3
# CHECK-NEXT:  1      1     0.33                        addi	t0, t0, 100
# CHECK-NEXT:  1      1     0.33                        addiw	t2, t2, 200
# CHECK-NEXT:  1      1     0.33                        and	t2, t2, t2
# CHECK-NEXT:  1      1     0.33                        or	t3, t3, t3
# CHECK-NEXT:  1      1     0.33                        xor	t4, t4, t4
# CHECK-NEXT:  1      1     0.33                        andi	t2, t2, 10
# CHECK-NEXT:  1      1     0.33                        ori	t3, t3, 20
# CHECK-NEXT:  1      1     0.33                        xori	t4, t4, 30
# CHECK-NEXT:  1      1     0.33                        sll	t5, t5, t6
# CHECK-NEXT:  1      1     0.33                        srl	t0, s0, t6
# CHECK-NEXT:  1      1     0.33                        sra	s1, s1, t6
# CHECK-NEXT:  1      1     0.33                        slli	t5, t5, 1
# CHECK-NEXT:  1      1     0.33                        srli	t0, s0, 2
# CHECK-NEXT:  1      1     0.33                        srai	s1, s1, 3
# CHECK-NEXT:  1      3     1.00                        mul	s6, s6, s7
# CHECK-NEXT:  1      3     1.00                        mulw	s4, s4, a2
# CHECK-NEXT:  1      35    34.00                       div	a0, a0, a0
# CHECK-NEXT:  1      20    19.00                       divw	a1, a1, a1
# CHECK-NEXT:  1      35    34.00                       rem	a2, a2, a2
# CHECK-NEXT:  1      20    19.00                       remw	a2, a2, a2
# CHECK-NEXT:  1      1     0.33                        rol	t5, t5, t6
# CHECK-NEXT:  1      1     0.33                        ror	t6, t6, t5
# CHECK-NEXT:  1      1     0.33                        rori	t5, t5, 5
# CHECK-NEXT:  1      1     0.33                        rolw	t5, t5, t6
# CHECK-NEXT:  1      1     0.33                        rorw	t6, t6, t5
# CHECK-NEXT:  1      1     0.33                        roriw	t5, t5, 5
# CHECK-NEXT:  1      1     0.33                        andn	a0, a0, a1
# CHECK-NEXT:  1      1     0.33                        orn	a1, a2, a3
# CHECK-NEXT:  1      1     0.33                        xnor	a2, a3, a4
# CHECK-NEXT:  1      1     0.33                        min	a3, a4, a5
# CHECK-NEXT:  1      1     0.33                        max	a4, a5, a6
# CHECK-NEXT:  1      1     0.33                        minu	a5, a6, a7
# CHECK-NEXT:  1      1     0.33                        maxu	a6, a7, s0
# CHECK-NEXT:  1      1     0.33                        orc.b	s0, s1
# CHECK-NEXT:  1      1     0.33                        rev8	s1, s2
# CHECK-NEXT:  1      3     1.00                        cpop	t1, t1
# CHECK-NEXT:  1      3     1.00                        cpopw	t2, t2
# CHECK-NEXT:  1      1     0.33                        sh1add	t0, t1, t2
# CHECK-NEXT:  1      1     0.33                        sh2add	t0, t1, t2
# CHECK-NEXT:  1      1     0.33                        sh3add	t0, t1, t2
# CHECK-NEXT:  1      1     0.33                        add.uw	s0, s1, s2
# CHECK-NEXT:  1      1     0.33                        sh1add.uw	t0, t1, t2
# CHECK-NEXT:  1      1     0.33                        sh2add.uw	t0, t1, t2
# CHECK-NEXT:  1      1     0.33                        sh3add.uw	t0, t1, t2

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP500Div
# CHECK-NEXT: [1]   - SiFiveP500FEXQ0
# CHECK-NEXT: [2]   - SiFiveP500FEXQ1
# CHECK-NEXT: [3]   - SiFiveP500FloatDiv
# CHECK-NEXT: [4]   - SiFiveP500IEXQ0
# CHECK-NEXT: [5]   - SiFiveP500IEXQ1
# CHECK-NEXT: [6]   - SiFiveP500IEXQ2
# CHECK-NEXT: [7]   - SiFiveP500Load
# CHECK-NEXT: [8]   - SiFiveP500Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]
# CHECK-NEXT: 106.00  -      -      -     14.00  15.00  19.00   -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    Instructions:
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     add	t0, t0, t0
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     addw	t2, t2, t2
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     sub	t1, t1, t1
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     subw	t3, t3, t3
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     addi	t0, t0, 100
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     addiw	t2, t2, 200
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     and	t2, t2, t2
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     or	t3, t3, t3
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     xor	t4, t4, t4
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     andi	t2, t2, 10
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     ori	t3, t3, 20
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     xori	t4, t4, 30
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     sll	t5, t5, t6
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     srl	t0, s0, t6
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     sra	s1, s1, t6
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     slli	t5, t5, 1
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     srli	t0, s0, 2
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     srai	s1, s1, 3
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     mul	s6, s6, s7
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     mulw	s4, s4, a2
# CHECK-NEXT: 34.00   -      -      -      -      -     1.00    -      -     div	a0, a0, a0
# CHECK-NEXT: 19.00   -      -      -      -      -     1.00    -      -     divw	a1, a1, a1
# CHECK-NEXT: 34.00   -      -      -      -      -     1.00    -      -     rem	a2, a2, a2
# CHECK-NEXT: 19.00   -      -      -      -      -     1.00    -      -     remw	a2, a2, a2
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     rol	t5, t5, t6
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     ror	t6, t6, t5
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     rori	t5, t5, 5
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     rolw	t5, t5, t6
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     rorw	t6, t6, t5
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     roriw	t5, t5, 5
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     andn	a0, a0, a1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     orn	a1, a2, a3
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     xnor	a2, a3, a4
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     min	a3, a4, a5
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     max	a4, a5, a6
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     minu	a5, a6, a7
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     maxu	a6, a7, s0
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     orc.b	s0, s1
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     rev8	s1, s2
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     cpop	t1, t1
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     cpopw	t2, t2
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     sh1add	t0, t1, t2
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     sh2add	t0, t1, t2
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     sh3add	t0, t1, t2
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     add.uw	s0, s1, s2
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -      -     sh1add.uw	t0, t1, t2
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -     sh2add.uw	t0, t1, t2
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     sh3add.uw	t0, t1, t2
