; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=loop-vectorize \
; RUN: -force-tail-folding-style=data-with-evl \
; RUN: -prefer-predicate-over-epilogue=predicate-dont-vectorize \
; RUN: -mtriple=riscv64 -mattr=+v -S < %s | FileCheck %s

; RUN: opt -passes=loop-vectorize \
; RUN: -force-tail-folding-style=none \
; RUN: -prefer-predicate-over-epilogue=predicate-dont-vectorize \
; RUN: -mtriple=riscv64 -mattr=+v -S < %s | FileCheck %s

; No need to emit predicated vector code if the vector instructions with masking are not required.
define i32 @no_masking() {
; CHECK-LABEL: @no_masking(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[BODY:%.*]]
; CHECK:       body:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ 1, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[BODY]] ]
; CHECK-NEXT:    [[INC]] = add i32 [[P]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[INC]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[END:%.*]], label [[BODY]]
; CHECK:       end:
; CHECK-NEXT:    ret i32 0
;
entry:
  br label %body

body:
  %p = phi i32 [ 1, %entry ], [ %inc, %body ]
  %inc = add i32 %p, 1
  %cmp = icmp eq i32 %inc, 0
  br i1 %cmp, label %end, label %body

end:
  ret i32 0
}
