; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; Test that the case of (64 - shift) used by a shift/rotate instruction is
; implemented with an lcr. This should also work for any multiple of 64.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

define i64 @f1(i64 %in, i64 %sh) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lcr %r1, %r3
; CHECK-NEXT:    sllg %r2, %r2, 0(%r1)
; CHECK-NEXT:    br %r14
  %sub = sub i64 64, %sh
  %shl = shl i64 %in, %sub
  ret i64 %shl
}

define i64 @f2(i64 %in, i64 %sh) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lcr %r1, %r3
; CHECK-NEXT:    srag %r2, %r2, 0(%r1)
; CHECK-NEXT:    br %r14
  %sub = sub i64 64, %sh
  %shl = ashr i64 %in, %sub
  ret i64 %shl
}

define i64 @f3(i64 %in, i64 %sh) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lcr %r1, %r3
; CHECK-NEXT:    srlg %r2, %r2, 0(%r1)
; CHECK-NEXT:    br %r14
  %sub = sub i64 64, %sh
  %shl = lshr i64 %in, %sub
  ret i64 %shl
}

define i64 @f4(i64 %in, i64 %sh) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lcr %r1, %r3
; CHECK-NEXT:    rllg %r2, %r2, 0(%r1)
; CHECK-NEXT:    br %r14
  %shr = lshr i64 %in, %sh
  %sub = sub i64 64, %sh
  %shl = shl i64 %in, %sub
  %or = or i64 %shl, %shr
  ret i64 %or
}

define i64 @f5(i64 %in, i64 %sh) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lcr %r1, %r3
; CHECK-NEXT:    sllg %r2, %r2, 0(%r1)
; CHECK-NEXT:    br %r14
  %sub = sub i64 128, %sh
  %shl = shl i64 %in, %sub
  ret i64 %shl
}

define i64 @f6(i64 %in, i64 %sh) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lcr %r1, %r3
; CHECK-NEXT:    srag %r2, %r2, 0(%r1)
; CHECK-NEXT:    br %r14
  %sub = sub i64 256, %sh
  %shl = ashr i64 %in, %sub
  ret i64 %shl
}

define i64 @f7(i64 %in, i64 %sh) {
; CHECK-LABEL: f7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lcr %r1, %r3
; CHECK-NEXT:    srlg %r2, %r2, 0(%r1)
; CHECK-NEXT:    br %r14
  %sub = sub i64 512, %sh
  %shl = lshr i64 %in, %sub
  ret i64 %shl
}

define i64 @f8(i64 %in, i64 %sh) {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lcr %r1, %r3
; CHECK-NEXT:    srlg %r0, %r2, 0(%r3)
; CHECK-NEXT:    sllg %r2, %r2, 0(%r1)
; CHECK-NEXT:    ogr %r2, %r0
; CHECK-NEXT:    br %r14
  %shr = lshr i64 %in, %sh
  %sub = sub i64 1024, %sh
  %shl = shl i64 %in, %sub
  %or = or i64 %shl, %shr
  ret i64 %or
}
