/*
Copyright 2018 Ioannis Makris

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// This file was generated by glatter.py script.



#ifdef GLATTER_GL
#if defined(__gles2_gl2_h_)
#if defined(GL_ES_VERSION_2_0)
#ifndef glActiveTexture
#define glActiveTexture(texture) glatter_glActiveTexture((texture))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glActiveTexture, (GLenum texture))
#ifndef glAttachShader
#define glAttachShader(program, shader) glatter_glAttachShader((program), (shader))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glAttachShader, (GLuint program, GLuint shader))
#ifndef glBindAttribLocation
#define glBindAttribLocation(program, index, name) glatter_glBindAttribLocation((program), (index), (name))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBindAttribLocation, (GLuint program, GLuint index, const GLchar *name))
#ifndef glBindBuffer
#define glBindBuffer(target, buffer) glatter_glBindBuffer((target), (buffer))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBindBuffer, (GLenum target, GLuint buffer))
#ifndef glBindFramebuffer
#define glBindFramebuffer(target, framebuffer) glatter_glBindFramebuffer((target), (framebuffer))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBindFramebuffer, (GLenum target, GLuint framebuffer))
#ifndef glBindRenderbuffer
#define glBindRenderbuffer(target, renderbuffer) glatter_glBindRenderbuffer((target), (renderbuffer))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBindRenderbuffer, (GLenum target, GLuint renderbuffer))
#ifndef glBindTexture
#define glBindTexture(target, texture) glatter_glBindTexture((target), (texture))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBindTexture, (GLenum target, GLuint texture))
#ifndef glBlendColor
#define glBlendColor(red, green, blue, alpha) glatter_glBlendColor((red), (green), (blue), (alpha))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendColor, (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha))
#ifndef glBlendEquation
#define glBlendEquation(mode) glatter_glBlendEquation((mode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendEquation, (GLenum mode))
#ifndef glBlendEquationSeparate
#define glBlendEquationSeparate(modeRGB, modeAlpha) glatter_glBlendEquationSeparate((modeRGB), (modeAlpha))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendEquationSeparate, (GLenum modeRGB, GLenum modeAlpha))
#ifndef glBlendFunc
#define glBlendFunc(sfactor, dfactor) glatter_glBlendFunc((sfactor), (dfactor))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendFunc, (GLenum sfactor, GLenum dfactor))
#ifndef glBlendFuncSeparate
#define glBlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha) glatter_glBlendFuncSeparate((sfactorRGB), (dfactorRGB), (sfactorAlpha), (dfactorAlpha))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendFuncSeparate, (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha))
#ifndef glBufferData
#define glBufferData(target, size, data, usage) glatter_glBufferData((target), (size), (data), (usage))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBufferData, (GLenum target, GLsizeiptr size, const void *data, GLenum usage))
#ifndef glBufferSubData
#define glBufferSubData(target, offset, size, data) glatter_glBufferSubData((target), (offset), (size), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBufferSubData, (GLenum target, GLintptr offset, GLsizeiptr size, const void *data))
#ifndef glCheckFramebufferStatus
#define glCheckFramebufferStatus(target) glatter_glCheckFramebufferStatus((target))
#endif
GLATTER_UBLOCK(GLenum, GL_APIENTRY, glCheckFramebufferStatus, (GLenum target))
#ifndef glClear
#define glClear(mask) glatter_glClear((mask))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glClear, (GLbitfield mask))
#ifndef glClearColor
#define glClearColor(red, green, blue, alpha) glatter_glClearColor((red), (green), (blue), (alpha))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glClearColor, (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha))
#ifndef glClearDepthf
#define glClearDepthf(d) glatter_glClearDepthf((d))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glClearDepthf, (GLfloat d))
#ifndef glClearStencil
#define glClearStencil(s) glatter_glClearStencil((s))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glClearStencil, (GLint s))
#ifndef glColorMask
#define glColorMask(red, green, blue, alpha) glatter_glColorMask((red), (green), (blue), (alpha))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glColorMask, (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha))
#ifndef glCompileShader
#define glCompileShader(shader) glatter_glCompileShader((shader))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCompileShader, (GLuint shader))
#ifndef glCompressedTexImage2D
#define glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data) glatter_glCompressedTexImage2D((target), (level), (internalformat), (width), (height), (border), (imageSize), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCompressedTexImage2D, (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data))
#ifndef glCompressedTexSubImage2D
#define glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data) glatter_glCompressedTexSubImage2D((target), (level), (xoffset), (yoffset), (width), (height), (format), (imageSize), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCompressedTexSubImage2D, (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data))
#ifndef glCopyTexImage2D
#define glCopyTexImage2D(target, level, internalformat, x, y, width, height, border) glatter_glCopyTexImage2D((target), (level), (internalformat), (x), (y), (width), (height), (border))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCopyTexImage2D, (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border))
#ifndef glCopyTexSubImage2D
#define glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height) glatter_glCopyTexSubImage2D((target), (level), (xoffset), (yoffset), (x), (y), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCopyTexSubImage2D, (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height))
#ifndef glCreateProgram
#define glCreateProgram() glatter_glCreateProgram()
#endif
GLATTER_UBLOCK(GLuint, GL_APIENTRY, glCreateProgram, (void))
#ifndef glCreateShader
#define glCreateShader(type) glatter_glCreateShader((type))
#endif
GLATTER_UBLOCK(GLuint, GL_APIENTRY, glCreateShader, (GLenum type))
#ifndef glCullFace
#define glCullFace(mode) glatter_glCullFace((mode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCullFace, (GLenum mode))
#ifndef glDeleteBuffers
#define glDeleteBuffers(n, buffers) glatter_glDeleteBuffers((n), (buffers))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeleteBuffers, (GLsizei n, const GLuint *buffers))
#ifndef glDeleteFramebuffers
#define glDeleteFramebuffers(n, framebuffers) glatter_glDeleteFramebuffers((n), (framebuffers))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeleteFramebuffers, (GLsizei n, const GLuint *framebuffers))
#ifndef glDeleteProgram
#define glDeleteProgram(program) glatter_glDeleteProgram((program))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeleteProgram, (GLuint program))
#ifndef glDeleteRenderbuffers
#define glDeleteRenderbuffers(n, renderbuffers) glatter_glDeleteRenderbuffers((n), (renderbuffers))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeleteRenderbuffers, (GLsizei n, const GLuint *renderbuffers))
#ifndef glDeleteShader
#define glDeleteShader(shader) glatter_glDeleteShader((shader))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeleteShader, (GLuint shader))
#ifndef glDeleteTextures
#define glDeleteTextures(n, textures) glatter_glDeleteTextures((n), (textures))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeleteTextures, (GLsizei n, const GLuint *textures))
#ifndef glDepthFunc
#define glDepthFunc(func) glatter_glDepthFunc((func))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDepthFunc, (GLenum func))
#ifndef glDepthMask
#define glDepthMask(flag) glatter_glDepthMask((flag))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDepthMask, (GLboolean flag))
#ifndef glDepthRangef
#define glDepthRangef(n, f) glatter_glDepthRangef((n), (f))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDepthRangef, (GLfloat n, GLfloat f))
#ifndef glDetachShader
#define glDetachShader(program, shader) glatter_glDetachShader((program), (shader))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDetachShader, (GLuint program, GLuint shader))
#ifndef glDisable
#define glDisable(cap) glatter_glDisable((cap))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDisable, (GLenum cap))
#ifndef glDisableVertexAttribArray
#define glDisableVertexAttribArray(index) glatter_glDisableVertexAttribArray((index))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDisableVertexAttribArray, (GLuint index))
#ifndef glDrawArrays
#define glDrawArrays(mode, first, count) glatter_glDrawArrays((mode), (first), (count))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawArrays, (GLenum mode, GLint first, GLsizei count))
#ifndef glDrawElements
#define glDrawElements(mode, count, type, indices) glatter_glDrawElements((mode), (count), (type), (indices))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawElements, (GLenum mode, GLsizei count, GLenum type, const void *indices))
#ifndef glEnable
#define glEnable(cap) glatter_glEnable((cap))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEnable, (GLenum cap))
#ifndef glEnableVertexAttribArray
#define glEnableVertexAttribArray(index) glatter_glEnableVertexAttribArray((index))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEnableVertexAttribArray, (GLuint index))
#ifndef glFinish
#define glFinish() glatter_glFinish()
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFinish, (void))
#ifndef glFlush
#define glFlush() glatter_glFlush()
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFlush, (void))
#ifndef glFramebufferRenderbuffer
#define glFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer) glatter_glFramebufferRenderbuffer((target), (attachment), (renderbuffertarget), (renderbuffer))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferRenderbuffer, (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer))
#ifndef glFramebufferTexture2D
#define glFramebufferTexture2D(target, attachment, textarget, texture, level) glatter_glFramebufferTexture2D((target), (attachment), (textarget), (texture), (level))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferTexture2D, (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level))
#ifndef glFrontFace
#define glFrontFace(mode) glatter_glFrontFace((mode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFrontFace, (GLenum mode))
#ifndef glGenBuffers
#define glGenBuffers(n, buffers) glatter_glGenBuffers((n), (buffers))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGenBuffers, (GLsizei n, GLuint *buffers))
#ifndef glGenFramebuffers
#define glGenFramebuffers(n, framebuffers) glatter_glGenFramebuffers((n), (framebuffers))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGenFramebuffers, (GLsizei n, GLuint *framebuffers))
#ifndef glGenRenderbuffers
#define glGenRenderbuffers(n, renderbuffers) glatter_glGenRenderbuffers((n), (renderbuffers))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGenRenderbuffers, (GLsizei n, GLuint *renderbuffers))
#ifndef glGenTextures
#define glGenTextures(n, textures) glatter_glGenTextures((n), (textures))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGenTextures, (GLsizei n, GLuint *textures))
#ifndef glGenerateMipmap
#define glGenerateMipmap(target) glatter_glGenerateMipmap((target))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGenerateMipmap, (GLenum target))
#ifndef glGetActiveAttrib
#define glGetActiveAttrib(program, index, bufSize, length, size, type, name) glatter_glGetActiveAttrib((program), (index), (bufSize), (length), (size), (type), (name))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetActiveAttrib, (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name))
#ifndef glGetActiveUniform
#define glGetActiveUniform(program, index, bufSize, length, size, type, name) glatter_glGetActiveUniform((program), (index), (bufSize), (length), (size), (type), (name))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetActiveUniform, (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name))
#ifndef glGetAttachedShaders
#define glGetAttachedShaders(program, maxCount, count, shaders) glatter_glGetAttachedShaders((program), (maxCount), (count), (shaders))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetAttachedShaders, (GLuint program, GLsizei maxCount, GLsizei *count, GLuint *shaders))
#ifndef glGetAttribLocation
#define glGetAttribLocation(program, name) glatter_glGetAttribLocation((program), (name))
#endif
GLATTER_UBLOCK(GLint, GL_APIENTRY, glGetAttribLocation, (GLuint program, const GLchar *name))
#ifndef glGetBooleanv
#define glGetBooleanv(pname, data) glatter_glGetBooleanv((pname), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetBooleanv, (GLenum pname, GLboolean *data))
#ifndef glGetBufferParameteriv
#define glGetBufferParameteriv(target, pname, params) glatter_glGetBufferParameteriv((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetBufferParameteriv, (GLenum target, GLenum pname, GLint *params))
#ifndef glGetError
#define glGetError() glatter_glGetError()
#endif
GLATTER_UBLOCK(GLenum, GL_APIENTRY, glGetError, (void))
#ifndef glGetFloatv
#define glGetFloatv(pname, data) glatter_glGetFloatv((pname), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetFloatv, (GLenum pname, GLfloat *data))
#ifndef glGetFramebufferAttachmentParameteriv
#define glGetFramebufferAttachmentParameteriv(target, attachment, pname, params) glatter_glGetFramebufferAttachmentParameteriv((target), (attachment), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetFramebufferAttachmentParameteriv, (GLenum target, GLenum attachment, GLenum pname, GLint *params))
#ifndef glGetIntegerv
#define glGetIntegerv(pname, data) glatter_glGetIntegerv((pname), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetIntegerv, (GLenum pname, GLint *data))
#ifndef glGetProgramInfoLog
#define glGetProgramInfoLog(program, bufSize, length, infoLog) glatter_glGetProgramInfoLog((program), (bufSize), (length), (infoLog))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetProgramInfoLog, (GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog))
#ifndef glGetProgramiv
#define glGetProgramiv(program, pname, params) glatter_glGetProgramiv((program), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetProgramiv, (GLuint program, GLenum pname, GLint *params))
#ifndef glGetRenderbufferParameteriv
#define glGetRenderbufferParameteriv(target, pname, params) glatter_glGetRenderbufferParameteriv((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetRenderbufferParameteriv, (GLenum target, GLenum pname, GLint *params))
#ifndef glGetShaderInfoLog
#define glGetShaderInfoLog(shader, bufSize, length, infoLog) glatter_glGetShaderInfoLog((shader), (bufSize), (length), (infoLog))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetShaderInfoLog, (GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog))
#ifndef glGetShaderPrecisionFormat
#define glGetShaderPrecisionFormat(shadertype, precisiontype, range, precision) glatter_glGetShaderPrecisionFormat((shadertype), (precisiontype), (range), (precision))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetShaderPrecisionFormat, (GLenum shadertype, GLenum precisiontype, GLint *range, GLint *precision))
#ifndef glGetShaderSource
#define glGetShaderSource(shader, bufSize, length, source) glatter_glGetShaderSource((shader), (bufSize), (length), (source))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetShaderSource, (GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source))
#ifndef glGetShaderiv
#define glGetShaderiv(shader, pname, params) glatter_glGetShaderiv((shader), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetShaderiv, (GLuint shader, GLenum pname, GLint *params))
#ifndef glGetString
#define glGetString(name) glatter_glGetString((name))
#endif
GLATTER_UBLOCK(const GLubyte *, GL_APIENTRY, glGetString, (GLenum name))
#ifndef glGetTexParameterfv
#define glGetTexParameterfv(target, pname, params) glatter_glGetTexParameterfv((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetTexParameterfv, (GLenum target, GLenum pname, GLfloat *params))
#ifndef glGetTexParameteriv
#define glGetTexParameteriv(target, pname, params) glatter_glGetTexParameteriv((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetTexParameteriv, (GLenum target, GLenum pname, GLint *params))
#ifndef glGetUniformLocation
#define glGetUniformLocation(program, name) glatter_glGetUniformLocation((program), (name))
#endif
GLATTER_UBLOCK(GLint, GL_APIENTRY, glGetUniformLocation, (GLuint program, const GLchar *name))
#ifndef glGetUniformfv
#define glGetUniformfv(program, location, params) glatter_glGetUniformfv((program), (location), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetUniformfv, (GLuint program, GLint location, GLfloat *params))
#ifndef glGetUniformiv
#define glGetUniformiv(program, location, params) glatter_glGetUniformiv((program), (location), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetUniformiv, (GLuint program, GLint location, GLint *params))
#ifndef glGetVertexAttribPointerv
#define glGetVertexAttribPointerv(index, pname, pointer) glatter_glGetVertexAttribPointerv((index), (pname), (pointer))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetVertexAttribPointerv, (GLuint index, GLenum pname, void **pointer))
#ifndef glGetVertexAttribfv
#define glGetVertexAttribfv(index, pname, params) glatter_glGetVertexAttribfv((index), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetVertexAttribfv, (GLuint index, GLenum pname, GLfloat *params))
#ifndef glGetVertexAttribiv
#define glGetVertexAttribiv(index, pname, params) glatter_glGetVertexAttribiv((index), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetVertexAttribiv, (GLuint index, GLenum pname, GLint *params))
#ifndef glHint
#define glHint(target, mode) glatter_glHint((target), (mode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glHint, (GLenum target, GLenum mode))
#ifndef glIsBuffer
#define glIsBuffer(buffer) glatter_glIsBuffer((buffer))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsBuffer, (GLuint buffer))
#ifndef glIsEnabled
#define glIsEnabled(cap) glatter_glIsEnabled((cap))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsEnabled, (GLenum cap))
#ifndef glIsFramebuffer
#define glIsFramebuffer(framebuffer) glatter_glIsFramebuffer((framebuffer))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsFramebuffer, (GLuint framebuffer))
#ifndef glIsProgram
#define glIsProgram(program) glatter_glIsProgram((program))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsProgram, (GLuint program))
#ifndef glIsRenderbuffer
#define glIsRenderbuffer(renderbuffer) glatter_glIsRenderbuffer((renderbuffer))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsRenderbuffer, (GLuint renderbuffer))
#ifndef glIsShader
#define glIsShader(shader) glatter_glIsShader((shader))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsShader, (GLuint shader))
#ifndef glIsTexture
#define glIsTexture(texture) glatter_glIsTexture((texture))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsTexture, (GLuint texture))
#ifndef glLineWidth
#define glLineWidth(width) glatter_glLineWidth((width))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glLineWidth, (GLfloat width))
#ifndef glLinkProgram
#define glLinkProgram(program) glatter_glLinkProgram((program))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glLinkProgram, (GLuint program))
#ifndef glPixelStorei
#define glPixelStorei(pname, param) glatter_glPixelStorei((pname), (param))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPixelStorei, (GLenum pname, GLint param))
#ifndef glPolygonOffset
#define glPolygonOffset(factor, units) glatter_glPolygonOffset((factor), (units))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPolygonOffset, (GLfloat factor, GLfloat units))
#ifndef glReadPixels
#define glReadPixels(x, y, width, height, format, type, pixels) glatter_glReadPixels((x), (y), (width), (height), (format), (type), (pixels))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glReadPixels, (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, void *pixels))
#ifndef glReleaseShaderCompiler
#define glReleaseShaderCompiler() glatter_glReleaseShaderCompiler()
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glReleaseShaderCompiler, (void))
#ifndef glRenderbufferStorage
#define glRenderbufferStorage(target, internalformat, width, height) glatter_glRenderbufferStorage((target), (internalformat), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glRenderbufferStorage, (GLenum target, GLenum internalformat, GLsizei width, GLsizei height))
#ifndef glSampleCoverage
#define glSampleCoverage(value, invert) glatter_glSampleCoverage((value), (invert))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glSampleCoverage, (GLfloat value, GLboolean invert))
#ifndef glScissor
#define glScissor(x, y, width, height) glatter_glScissor((x), (y), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glScissor, (GLint x, GLint y, GLsizei width, GLsizei height))
#ifndef glShaderBinary
#define glShaderBinary(count, shaders, binaryformat, binary, length) glatter_glShaderBinary((count), (shaders), (binaryformat), (binary), (length))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glShaderBinary, (GLsizei count, const GLuint *shaders, GLenum binaryformat, const void *binary, GLsizei length))
#ifndef glShaderSource
#define glShaderSource(shader, count, string, length) glatter_glShaderSource((shader), (count), (string), (length))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glShaderSource, (GLuint shader, GLsizei count, const GLchar *const*string, const GLint *length))
#ifndef glStencilFunc
#define glStencilFunc(func, ref, mask) glatter_glStencilFunc((func), (ref), (mask))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStencilFunc, (GLenum func, GLint ref, GLuint mask))
#ifndef glStencilFuncSeparate
#define glStencilFuncSeparate(face, func, ref, mask) glatter_glStencilFuncSeparate((face), (func), (ref), (mask))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStencilFuncSeparate, (GLenum face, GLenum func, GLint ref, GLuint mask))
#ifndef glStencilMask
#define glStencilMask(mask) glatter_glStencilMask((mask))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStencilMask, (GLuint mask))
#ifndef glStencilMaskSeparate
#define glStencilMaskSeparate(face, mask) glatter_glStencilMaskSeparate((face), (mask))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStencilMaskSeparate, (GLenum face, GLuint mask))
#ifndef glStencilOp
#define glStencilOp(fail, zfail, zpass) glatter_glStencilOp((fail), (zfail), (zpass))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStencilOp, (GLenum fail, GLenum zfail, GLenum zpass))
#ifndef glStencilOpSeparate
#define glStencilOpSeparate(face, sfail, dpfail, dppass) glatter_glStencilOpSeparate((face), (sfail), (dpfail), (dppass))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStencilOpSeparate, (GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass))
#ifndef glTexImage2D
#define glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels) glatter_glTexImage2D((target), (level), (internalformat), (width), (height), (border), (format), (type), (pixels))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexImage2D, (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels))
#ifndef glTexParameterf
#define glTexParameterf(target, pname, param) glatter_glTexParameterf((target), (pname), (param))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexParameterf, (GLenum target, GLenum pname, GLfloat param))
#ifndef glTexParameterfv
#define glTexParameterfv(target, pname, params) glatter_glTexParameterfv((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexParameterfv, (GLenum target, GLenum pname, const GLfloat *params))
#ifndef glTexParameteri
#define glTexParameteri(target, pname, param) glatter_glTexParameteri((target), (pname), (param))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexParameteri, (GLenum target, GLenum pname, GLint param))
#ifndef glTexParameteriv
#define glTexParameteriv(target, pname, params) glatter_glTexParameteriv((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexParameteriv, (GLenum target, GLenum pname, const GLint *params))
#ifndef glTexSubImage2D
#define glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels) glatter_glTexSubImage2D((target), (level), (xoffset), (yoffset), (width), (height), (format), (type), (pixels))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexSubImage2D, (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels))
#ifndef glUniform1f
#define glUniform1f(location, v0) glatter_glUniform1f((location), (v0))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform1f, (GLint location, GLfloat v0))
#ifndef glUniform1fv
#define glUniform1fv(location, count, value) glatter_glUniform1fv((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform1fv, (GLint location, GLsizei count, const GLfloat *value))
#ifndef glUniform1i
#define glUniform1i(location, v0) glatter_glUniform1i((location), (v0))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform1i, (GLint location, GLint v0))
#ifndef glUniform1iv
#define glUniform1iv(location, count, value) glatter_glUniform1iv((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform1iv, (GLint location, GLsizei count, const GLint *value))
#ifndef glUniform2f
#define glUniform2f(location, v0, v1) glatter_glUniform2f((location), (v0), (v1))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform2f, (GLint location, GLfloat v0, GLfloat v1))
#ifndef glUniform2fv
#define glUniform2fv(location, count, value) glatter_glUniform2fv((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform2fv, (GLint location, GLsizei count, const GLfloat *value))
#ifndef glUniform2i
#define glUniform2i(location, v0, v1) glatter_glUniform2i((location), (v0), (v1))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform2i, (GLint location, GLint v0, GLint v1))
#ifndef glUniform2iv
#define glUniform2iv(location, count, value) glatter_glUniform2iv((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform2iv, (GLint location, GLsizei count, const GLint *value))
#ifndef glUniform3f
#define glUniform3f(location, v0, v1, v2) glatter_glUniform3f((location), (v0), (v1), (v2))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform3f, (GLint location, GLfloat v0, GLfloat v1, GLfloat v2))
#ifndef glUniform3fv
#define glUniform3fv(location, count, value) glatter_glUniform3fv((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform3fv, (GLint location, GLsizei count, const GLfloat *value))
#ifndef glUniform3i
#define glUniform3i(location, v0, v1, v2) glatter_glUniform3i((location), (v0), (v1), (v2))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform3i, (GLint location, GLint v0, GLint v1, GLint v2))
#ifndef glUniform3iv
#define glUniform3iv(location, count, value) glatter_glUniform3iv((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform3iv, (GLint location, GLsizei count, const GLint *value))
#ifndef glUniform4f
#define glUniform4f(location, v0, v1, v2, v3) glatter_glUniform4f((location), (v0), (v1), (v2), (v3))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform4f, (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3))
#ifndef glUniform4fv
#define glUniform4fv(location, count, value) glatter_glUniform4fv((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform4fv, (GLint location, GLsizei count, const GLfloat *value))
#ifndef glUniform4i
#define glUniform4i(location, v0, v1, v2, v3) glatter_glUniform4i((location), (v0), (v1), (v2), (v3))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform4i, (GLint location, GLint v0, GLint v1, GLint v2, GLint v3))
#ifndef glUniform4iv
#define glUniform4iv(location, count, value) glatter_glUniform4iv((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform4iv, (GLint location, GLsizei count, const GLint *value))
#ifndef glUniformMatrix2fv
#define glUniformMatrix2fv(location, count, transpose, value) glatter_glUniformMatrix2fv((location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniformMatrix2fv, (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glUniformMatrix3fv
#define glUniformMatrix3fv(location, count, transpose, value) glatter_glUniformMatrix3fv((location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniformMatrix3fv, (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glUniformMatrix4fv
#define glUniformMatrix4fv(location, count, transpose, value) glatter_glUniformMatrix4fv((location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniformMatrix4fv, (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glUseProgram
#define glUseProgram(program) glatter_glUseProgram((program))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUseProgram, (GLuint program))
#ifndef glValidateProgram
#define glValidateProgram(program) glatter_glValidateProgram((program))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glValidateProgram, (GLuint program))
#ifndef glVertexAttrib1f
#define glVertexAttrib1f(index, x) glatter_glVertexAttrib1f((index), (x))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glVertexAttrib1f, (GLuint index, GLfloat x))
#ifndef glVertexAttrib1fv
#define glVertexAttrib1fv(index, v) glatter_glVertexAttrib1fv((index), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glVertexAttrib1fv, (GLuint index, const GLfloat *v))
#ifndef glVertexAttrib2f
#define glVertexAttrib2f(index, x, y) glatter_glVertexAttrib2f((index), (x), (y))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glVertexAttrib2f, (GLuint index, GLfloat x, GLfloat y))
#ifndef glVertexAttrib2fv
#define glVertexAttrib2fv(index, v) glatter_glVertexAttrib2fv((index), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glVertexAttrib2fv, (GLuint index, const GLfloat *v))
#ifndef glVertexAttrib3f
#define glVertexAttrib3f(index, x, y, z) glatter_glVertexAttrib3f((index), (x), (y), (z))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glVertexAttrib3f, (GLuint index, GLfloat x, GLfloat y, GLfloat z))
#ifndef glVertexAttrib3fv
#define glVertexAttrib3fv(index, v) glatter_glVertexAttrib3fv((index), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glVertexAttrib3fv, (GLuint index, const GLfloat *v))
#ifndef glVertexAttrib4f
#define glVertexAttrib4f(index, x, y, z, w) glatter_glVertexAttrib4f((index), (x), (y), (z), (w))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glVertexAttrib4f, (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w))
#ifndef glVertexAttrib4fv
#define glVertexAttrib4fv(index, v) glatter_glVertexAttrib4fv((index), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glVertexAttrib4fv, (GLuint index, const GLfloat *v))
#ifndef glVertexAttribPointer
#define glVertexAttribPointer(index, size, type, normalized, stride, pointer) glatter_glVertexAttribPointer((index), (size), (type), (normalized), (stride), (pointer))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glVertexAttribPointer, (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void *pointer))
#ifndef glViewport
#define glViewport(x, y, width, height) glatter_glViewport((x), (y), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glViewport, (GLint x, GLint y, GLsizei width, GLsizei height))
#endif // defined(GL_ES_VERSION_2_0)
#endif // defined(__gles2_gl2_h_)
#if defined(__gles2_gl2ext_h_)
#if defined(GL_AMD_framebuffer_multisample_advanced)
#ifndef glNamedRenderbufferStorageMultisampleAdvancedAMD
#define glNamedRenderbufferStorageMultisampleAdvancedAMD(renderbuffer, samples, storageSamples, internalformat, width, height) glatter_glNamedRenderbufferStorageMultisampleAdvancedAMD((renderbuffer), (samples), (storageSamples), (internalformat), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glNamedRenderbufferStorageMultisampleAdvancedAMD, (GLuint renderbuffer, GLsizei samples, GLsizei storageSamples, GLenum internalformat, GLsizei width, GLsizei height))
#ifndef glRenderbufferStorageMultisampleAdvancedAMD
#define glRenderbufferStorageMultisampleAdvancedAMD(target, samples, storageSamples, internalformat, width, height) glatter_glRenderbufferStorageMultisampleAdvancedAMD((target), (samples), (storageSamples), (internalformat), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glRenderbufferStorageMultisampleAdvancedAMD, (GLenum target, GLsizei samples, GLsizei storageSamples, GLenum internalformat, GLsizei width, GLsizei height))
#endif // defined(GL_AMD_framebuffer_multisample_advanced)
#if defined(GL_AMD_performance_monitor)
#ifndef glBeginPerfMonitorAMD
#define glBeginPerfMonitorAMD(monitor) glatter_glBeginPerfMonitorAMD((monitor))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBeginPerfMonitorAMD, (GLuint monitor))
#ifndef glDeletePerfMonitorsAMD
#define glDeletePerfMonitorsAMD(n, monitors) glatter_glDeletePerfMonitorsAMD((n), (monitors))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeletePerfMonitorsAMD, (GLsizei n, GLuint *monitors))
#ifndef glEndPerfMonitorAMD
#define glEndPerfMonitorAMD(monitor) glatter_glEndPerfMonitorAMD((monitor))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEndPerfMonitorAMD, (GLuint monitor))
#ifndef glGenPerfMonitorsAMD
#define glGenPerfMonitorsAMD(n, monitors) glatter_glGenPerfMonitorsAMD((n), (monitors))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGenPerfMonitorsAMD, (GLsizei n, GLuint *monitors))
#ifndef glGetPerfMonitorCounterDataAMD
#define glGetPerfMonitorCounterDataAMD(monitor, pname, dataSize, data, bytesWritten) glatter_glGetPerfMonitorCounterDataAMD((monitor), (pname), (dataSize), (data), (bytesWritten))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPerfMonitorCounterDataAMD, (GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten))
#ifndef glGetPerfMonitorCounterInfoAMD
#define glGetPerfMonitorCounterInfoAMD(group, counter, pname, data) glatter_glGetPerfMonitorCounterInfoAMD((group), (counter), (pname), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPerfMonitorCounterInfoAMD, (GLuint group, GLuint counter, GLenum pname, void *data))
#ifndef glGetPerfMonitorCounterStringAMD
#define glGetPerfMonitorCounterStringAMD(group, counter, bufSize, length, counterString) glatter_glGetPerfMonitorCounterStringAMD((group), (counter), (bufSize), (length), (counterString))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPerfMonitorCounterStringAMD, (GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString))
#ifndef glGetPerfMonitorCountersAMD
#define glGetPerfMonitorCountersAMD(group, numCounters, maxActiveCounters, counterSize, counters) glatter_glGetPerfMonitorCountersAMD((group), (numCounters), (maxActiveCounters), (counterSize), (counters))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPerfMonitorCountersAMD, (GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters))
#ifndef glGetPerfMonitorGroupStringAMD
#define glGetPerfMonitorGroupStringAMD(group, bufSize, length, groupString) glatter_glGetPerfMonitorGroupStringAMD((group), (bufSize), (length), (groupString))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPerfMonitorGroupStringAMD, (GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString))
#ifndef glGetPerfMonitorGroupsAMD
#define glGetPerfMonitorGroupsAMD(numGroups, groupsSize, groups) glatter_glGetPerfMonitorGroupsAMD((numGroups), (groupsSize), (groups))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPerfMonitorGroupsAMD, (GLint *numGroups, GLsizei groupsSize, GLuint *groups))
#ifndef glSelectPerfMonitorCountersAMD
#define glSelectPerfMonitorCountersAMD(monitor, enable, group, numCounters, counterList) glatter_glSelectPerfMonitorCountersAMD((monitor), (enable), (group), (numCounters), (counterList))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glSelectPerfMonitorCountersAMD, (GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *counterList))
#endif // defined(GL_AMD_performance_monitor)
#if defined(GL_ANGLE_framebuffer_blit)
#ifndef glBlitFramebufferANGLE
#define glBlitFramebufferANGLE(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter) glatter_glBlitFramebufferANGLE((srcX0), (srcY0), (srcX1), (srcY1), (dstX0), (dstY0), (dstX1), (dstY1), (mask), (filter))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlitFramebufferANGLE, (GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter))
#endif // defined(GL_ANGLE_framebuffer_blit)
#if defined(GL_ANGLE_framebuffer_multisample)
#ifndef glRenderbufferStorageMultisampleANGLE
#define glRenderbufferStorageMultisampleANGLE(target, samples, internalformat, width, height) glatter_glRenderbufferStorageMultisampleANGLE((target), (samples), (internalformat), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glRenderbufferStorageMultisampleANGLE, (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
#endif // defined(GL_ANGLE_framebuffer_multisample)
#if defined(GL_ANGLE_instanced_arrays)
#ifndef glDrawArraysInstancedANGLE
#define glDrawArraysInstancedANGLE(mode, first, count, primcount) glatter_glDrawArraysInstancedANGLE((mode), (first), (count), (primcount))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawArraysInstancedANGLE, (GLenum mode, GLint first, GLsizei count, GLsizei primcount))
#ifndef glDrawElementsInstancedANGLE
#define glDrawElementsInstancedANGLE(mode, count, type, indices, primcount) glatter_glDrawElementsInstancedANGLE((mode), (count), (type), (indices), (primcount))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawElementsInstancedANGLE, (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount))
#ifndef glVertexAttribDivisorANGLE
#define glVertexAttribDivisorANGLE(index, divisor) glatter_glVertexAttribDivisorANGLE((index), (divisor))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glVertexAttribDivisorANGLE, (GLuint index, GLuint divisor))
#endif // defined(GL_ANGLE_instanced_arrays)
#if defined(GL_ANGLE_translated_shader_source)
#ifndef glGetTranslatedShaderSourceANGLE
#define glGetTranslatedShaderSourceANGLE(shader, bufsize, length, source) glatter_glGetTranslatedShaderSourceANGLE((shader), (bufsize), (length), (source))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetTranslatedShaderSourceANGLE, (GLuint shader, GLsizei bufsize, GLsizei *length, GLchar *source))
#endif // defined(GL_ANGLE_translated_shader_source)
#if defined(GL_APPLE_copy_texture_levels)
#ifndef glCopyTextureLevelsAPPLE
#define glCopyTextureLevelsAPPLE(destinationTexture, sourceTexture, sourceBaseLevel, sourceLevelCount) glatter_glCopyTextureLevelsAPPLE((destinationTexture), (sourceTexture), (sourceBaseLevel), (sourceLevelCount))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCopyTextureLevelsAPPLE, (GLuint destinationTexture, GLuint sourceTexture, GLint sourceBaseLevel, GLsizei sourceLevelCount))
#endif // defined(GL_APPLE_copy_texture_levels)
#if defined(GL_APPLE_framebuffer_multisample)
#ifndef glRenderbufferStorageMultisampleAPPLE
#define glRenderbufferStorageMultisampleAPPLE(target, samples, internalformat, width, height) glatter_glRenderbufferStorageMultisampleAPPLE((target), (samples), (internalformat), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glRenderbufferStorageMultisampleAPPLE, (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
#ifndef glResolveMultisampleFramebufferAPPLE
#define glResolveMultisampleFramebufferAPPLE() glatter_glResolveMultisampleFramebufferAPPLE()
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glResolveMultisampleFramebufferAPPLE, (void))
#endif // defined(GL_APPLE_framebuffer_multisample)
#if defined(GL_APPLE_sync)
#ifndef glClientWaitSyncAPPLE
#define glClientWaitSyncAPPLE(sync, flags, timeout) glatter_glClientWaitSyncAPPLE((sync), (flags), (timeout))
#endif
GLATTER_UBLOCK(GLenum, GL_APIENTRY, glClientWaitSyncAPPLE, (GLsync sync, GLbitfield flags, GLuint64 timeout))
#ifndef glDeleteSyncAPPLE
#define glDeleteSyncAPPLE(sync) glatter_glDeleteSyncAPPLE((sync))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeleteSyncAPPLE, (GLsync sync))
#ifndef glFenceSyncAPPLE
#define glFenceSyncAPPLE(condition, flags) glatter_glFenceSyncAPPLE((condition), (flags))
#endif
GLATTER_UBLOCK(GLsync, GL_APIENTRY, glFenceSyncAPPLE, (GLenum condition, GLbitfield flags))
#ifndef glGetInteger64vAPPLE
#define glGetInteger64vAPPLE(pname, params) glatter_glGetInteger64vAPPLE((pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetInteger64vAPPLE, (GLenum pname, GLint64 *params))
#ifndef glGetSyncivAPPLE
#define glGetSyncivAPPLE(sync, pname, bufSize, length, values) glatter_glGetSyncivAPPLE((sync), (pname), (bufSize), (length), (values))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetSyncivAPPLE, (GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values))
#ifndef glIsSyncAPPLE
#define glIsSyncAPPLE(sync) glatter_glIsSyncAPPLE((sync))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsSyncAPPLE, (GLsync sync))
#ifndef glWaitSyncAPPLE
#define glWaitSyncAPPLE(sync, flags, timeout) glatter_glWaitSyncAPPLE((sync), (flags), (timeout))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glWaitSyncAPPLE, (GLsync sync, GLbitfield flags, GLuint64 timeout))
#endif // defined(GL_APPLE_sync)
#if defined(GL_EXT_EGL_image_storage)
#ifndef glEGLImageTargetTexStorageEXT
#define glEGLImageTargetTexStorageEXT(target, image, attrib_list) glatter_glEGLImageTargetTexStorageEXT((target), (image), (attrib_list))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEGLImageTargetTexStorageEXT, (GLenum target, GLeglImageOES image, const GLint* attrib_list))
#ifndef glEGLImageTargetTextureStorageEXT
#define glEGLImageTargetTextureStorageEXT(texture, image, attrib_list) glatter_glEGLImageTargetTextureStorageEXT((texture), (image), (attrib_list))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEGLImageTargetTextureStorageEXT, (GLuint texture, GLeglImageOES image, const GLint* attrib_list))
#endif // defined(GL_EXT_EGL_image_storage)
#if defined(GL_EXT_base_instance)
#ifndef glDrawArraysInstancedBaseInstanceEXT
#define glDrawArraysInstancedBaseInstanceEXT(mode, first, count, instancecount, baseinstance) glatter_glDrawArraysInstancedBaseInstanceEXT((mode), (first), (count), (instancecount), (baseinstance))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawArraysInstancedBaseInstanceEXT, (GLenum mode, GLint first, GLsizei count, GLsizei instancecount, GLuint baseinstance))
#ifndef glDrawElementsInstancedBaseInstanceEXT
#define glDrawElementsInstancedBaseInstanceEXT(mode, count, type, indices, instancecount, baseinstance) glatter_glDrawElementsInstancedBaseInstanceEXT((mode), (count), (type), (indices), (instancecount), (baseinstance))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawElementsInstancedBaseInstanceEXT, (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLuint baseinstance))
#ifndef glDrawElementsInstancedBaseVertexBaseInstanceEXT
#define glDrawElementsInstancedBaseVertexBaseInstanceEXT(mode, count, type, indices, instancecount, basevertex, baseinstance) glatter_glDrawElementsInstancedBaseVertexBaseInstanceEXT((mode), (count), (type), (indices), (instancecount), (basevertex), (baseinstance))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawElementsInstancedBaseVertexBaseInstanceEXT, (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex, GLuint baseinstance))
#endif // defined(GL_EXT_base_instance)
#if defined(GL_EXT_blend_func_extended)
#ifndef glBindFragDataLocationEXT
#define glBindFragDataLocationEXT(program, color, name) glatter_glBindFragDataLocationEXT((program), (color), (name))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBindFragDataLocationEXT, (GLuint program, GLuint color, const GLchar *name))
#ifndef glBindFragDataLocationIndexedEXT
#define glBindFragDataLocationIndexedEXT(program, colorNumber, index, name) glatter_glBindFragDataLocationIndexedEXT((program), (colorNumber), (index), (name))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBindFragDataLocationIndexedEXT, (GLuint program, GLuint colorNumber, GLuint index, const GLchar *name))
#ifndef glGetFragDataIndexEXT
#define glGetFragDataIndexEXT(program, name) glatter_glGetFragDataIndexEXT((program), (name))
#endif
GLATTER_UBLOCK(GLint, GL_APIENTRY, glGetFragDataIndexEXT, (GLuint program, const GLchar *name))
#ifndef glGetProgramResourceLocationIndexEXT
#define glGetProgramResourceLocationIndexEXT(program, programInterface, name) glatter_glGetProgramResourceLocationIndexEXT((program), (programInterface), (name))
#endif
GLATTER_UBLOCK(GLint, GL_APIENTRY, glGetProgramResourceLocationIndexEXT, (GLuint program, GLenum programInterface, const GLchar *name))
#endif // defined(GL_EXT_blend_func_extended)
#if defined(GL_EXT_buffer_storage)
#ifndef glBufferStorageEXT
#define glBufferStorageEXT(target, size, data, flags) glatter_glBufferStorageEXT((target), (size), (data), (flags))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBufferStorageEXT, (GLenum target, GLsizeiptr size, const void *data, GLbitfield flags))
#endif // defined(GL_EXT_buffer_storage)
#if defined(GL_EXT_clear_texture)
#ifndef glClearTexImageEXT
#define glClearTexImageEXT(texture, level, format, type, data) glatter_glClearTexImageEXT((texture), (level), (format), (type), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glClearTexImageEXT, (GLuint texture, GLint level, GLenum format, GLenum type, const void *data))
#ifndef glClearTexSubImageEXT
#define glClearTexSubImageEXT(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data) glatter_glClearTexSubImageEXT((texture), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (type), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glClearTexSubImageEXT, (GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *data))
#endif // defined(GL_EXT_clear_texture)
#if defined(GL_EXT_clip_control)
#ifndef glClipControlEXT
#define glClipControlEXT(origin, depth) glatter_glClipControlEXT((origin), (depth))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glClipControlEXT, (GLenum origin, GLenum depth))
#endif // defined(GL_EXT_clip_control)
#if defined(GL_EXT_copy_image)
#ifndef glCopyImageSubDataEXT
#define glCopyImageSubDataEXT(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth) glatter_glCopyImageSubDataEXT((srcName), (srcTarget), (srcLevel), (srcX), (srcY), (srcZ), (dstName), (dstTarget), (dstLevel), (dstX), (dstY), (dstZ), (srcWidth), (srcHeight), (srcDepth))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCopyImageSubDataEXT, (GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth))
#endif // defined(GL_EXT_copy_image)
#if defined(GL_EXT_debug_label)
#ifndef glGetObjectLabelEXT
#define glGetObjectLabelEXT(type, object, bufSize, length, label) glatter_glGetObjectLabelEXT((type), (object), (bufSize), (length), (label))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetObjectLabelEXT, (GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label))
#ifndef glLabelObjectEXT
#define glLabelObjectEXT(type, object, length, label) glatter_glLabelObjectEXT((type), (object), (length), (label))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glLabelObjectEXT, (GLenum type, GLuint object, GLsizei length, const GLchar *label))
#endif // defined(GL_EXT_debug_label)
#if defined(GL_EXT_debug_marker)
#ifndef glInsertEventMarkerEXT
#define glInsertEventMarkerEXT(length, marker) glatter_glInsertEventMarkerEXT((length), (marker))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glInsertEventMarkerEXT, (GLsizei length, const GLchar *marker))
#ifndef glPopGroupMarkerEXT
#define glPopGroupMarkerEXT() glatter_glPopGroupMarkerEXT()
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPopGroupMarkerEXT, (void))
#ifndef glPushGroupMarkerEXT
#define glPushGroupMarkerEXT(length, marker) glatter_glPushGroupMarkerEXT((length), (marker))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPushGroupMarkerEXT, (GLsizei length, const GLchar *marker))
#endif // defined(GL_EXT_debug_marker)
#if defined(GL_EXT_discard_framebuffer)
#ifndef glDiscardFramebufferEXT
#define glDiscardFramebufferEXT(target, numAttachments, attachments) glatter_glDiscardFramebufferEXT((target), (numAttachments), (attachments))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDiscardFramebufferEXT, (GLenum target, GLsizei numAttachments, const GLenum *attachments))
#endif // defined(GL_EXT_discard_framebuffer)
#if defined(GL_EXT_disjoint_timer_query)
#ifndef glBeginQueryEXT
#define glBeginQueryEXT(target, id) glatter_glBeginQueryEXT((target), (id))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBeginQueryEXT, (GLenum target, GLuint id))
#ifndef glDeleteQueriesEXT
#define glDeleteQueriesEXT(n, ids) glatter_glDeleteQueriesEXT((n), (ids))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeleteQueriesEXT, (GLsizei n, const GLuint *ids))
#ifndef glEndQueryEXT
#define glEndQueryEXT(target) glatter_glEndQueryEXT((target))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEndQueryEXT, (GLenum target))
#ifndef glGenQueriesEXT
#define glGenQueriesEXT(n, ids) glatter_glGenQueriesEXT((n), (ids))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGenQueriesEXT, (GLsizei n, GLuint *ids))
#ifndef glGetQueryObjecti64vEXT
#define glGetQueryObjecti64vEXT(id, pname, params) glatter_glGetQueryObjecti64vEXT((id), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetQueryObjecti64vEXT, (GLuint id, GLenum pname, GLint64 *params))
#ifndef glGetQueryObjectivEXT
#define glGetQueryObjectivEXT(id, pname, params) glatter_glGetQueryObjectivEXT((id), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetQueryObjectivEXT, (GLuint id, GLenum pname, GLint *params))
#ifndef glGetQueryObjectui64vEXT
#define glGetQueryObjectui64vEXT(id, pname, params) glatter_glGetQueryObjectui64vEXT((id), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetQueryObjectui64vEXT, (GLuint id, GLenum pname, GLuint64 *params))
#ifndef glGetQueryObjectuivEXT
#define glGetQueryObjectuivEXT(id, pname, params) glatter_glGetQueryObjectuivEXT((id), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetQueryObjectuivEXT, (GLuint id, GLenum pname, GLuint *params))
#ifndef glGetQueryivEXT
#define glGetQueryivEXT(target, pname, params) glatter_glGetQueryivEXT((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetQueryivEXT, (GLenum target, GLenum pname, GLint *params))
#ifndef glIsQueryEXT
#define glIsQueryEXT(id) glatter_glIsQueryEXT((id))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsQueryEXT, (GLuint id))
#ifndef glQueryCounterEXT
#define glQueryCounterEXT(id, target) glatter_glQueryCounterEXT((id), (target))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glQueryCounterEXT, (GLuint id, GLenum target))
#endif // defined(GL_EXT_disjoint_timer_query)
#if defined(GL_EXT_draw_buffers)
#ifndef glDrawBuffersEXT
#define glDrawBuffersEXT(n, bufs) glatter_glDrawBuffersEXT((n), (bufs))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawBuffersEXT, (GLsizei n, const GLenum *bufs))
#endif // defined(GL_EXT_draw_buffers)
#if defined(GL_EXT_draw_buffers_indexed)
#ifndef glBlendEquationSeparateiEXT
#define glBlendEquationSeparateiEXT(buf, modeRGB, modeAlpha) glatter_glBlendEquationSeparateiEXT((buf), (modeRGB), (modeAlpha))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendEquationSeparateiEXT, (GLuint buf, GLenum modeRGB, GLenum modeAlpha))
#ifndef glBlendEquationiEXT
#define glBlendEquationiEXT(buf, mode) glatter_glBlendEquationiEXT((buf), (mode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendEquationiEXT, (GLuint buf, GLenum mode))
#ifndef glBlendFuncSeparateiEXT
#define glBlendFuncSeparateiEXT(buf, srcRGB, dstRGB, srcAlpha, dstAlpha) glatter_glBlendFuncSeparateiEXT((buf), (srcRGB), (dstRGB), (srcAlpha), (dstAlpha))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendFuncSeparateiEXT, (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha))
#ifndef glBlendFunciEXT
#define glBlendFunciEXT(buf, src, dst) glatter_glBlendFunciEXT((buf), (src), (dst))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendFunciEXT, (GLuint buf, GLenum src, GLenum dst))
#ifndef glColorMaskiEXT
#define glColorMaskiEXT(index, r, g, b, a) glatter_glColorMaskiEXT((index), (r), (g), (b), (a))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glColorMaskiEXT, (GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a))
#ifndef glDisableiEXT
#define glDisableiEXT(target, index) glatter_glDisableiEXT((target), (index))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDisableiEXT, (GLenum target, GLuint index))
#ifndef glEnableiEXT
#define glEnableiEXT(target, index) glatter_glEnableiEXT((target), (index))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEnableiEXT, (GLenum target, GLuint index))
#ifndef glIsEnablediEXT
#define glIsEnablediEXT(target, index) glatter_glIsEnablediEXT((target), (index))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsEnablediEXT, (GLenum target, GLuint index))
#endif // defined(GL_EXT_draw_buffers_indexed)
#if defined(GL_EXT_draw_elements_base_vertex)
#ifndef glDrawElementsBaseVertexEXT
#define glDrawElementsBaseVertexEXT(mode, count, type, indices, basevertex) glatter_glDrawElementsBaseVertexEXT((mode), (count), (type), (indices), (basevertex))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawElementsBaseVertexEXT, (GLenum mode, GLsizei count, GLenum type, const void *indices, GLint basevertex))
#ifndef glDrawElementsInstancedBaseVertexEXT
#define glDrawElementsInstancedBaseVertexEXT(mode, count, type, indices, instancecount, basevertex) glatter_glDrawElementsInstancedBaseVertexEXT((mode), (count), (type), (indices), (instancecount), (basevertex))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawElementsInstancedBaseVertexEXT, (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex))
#ifndef glDrawRangeElementsBaseVertexEXT
#define glDrawRangeElementsBaseVertexEXT(mode, start, end, count, type, indices, basevertex) glatter_glDrawRangeElementsBaseVertexEXT((mode), (start), (end), (count), (type), (indices), (basevertex))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawRangeElementsBaseVertexEXT, (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, GLint basevertex))
#endif // defined(GL_EXT_draw_elements_base_vertex)
#if defined(GL_EXT_draw_instanced)
#ifndef glDrawArraysInstancedEXT
#define glDrawArraysInstancedEXT(mode, start, count, primcount) glatter_glDrawArraysInstancedEXT((mode), (start), (count), (primcount))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawArraysInstancedEXT, (GLenum mode, GLint start, GLsizei count, GLsizei primcount))
#ifndef glDrawElementsInstancedEXT
#define glDrawElementsInstancedEXT(mode, count, type, indices, primcount) glatter_glDrawElementsInstancedEXT((mode), (count), (type), (indices), (primcount))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawElementsInstancedEXT, (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount))
#endif // defined(GL_EXT_draw_instanced)
#if defined(GL_EXT_draw_transform_feedback)
#ifndef glDrawTransformFeedbackEXT
#define glDrawTransformFeedbackEXT(mode, id) glatter_glDrawTransformFeedbackEXT((mode), (id))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawTransformFeedbackEXT, (GLenum mode, GLuint id))
#ifndef glDrawTransformFeedbackInstancedEXT
#define glDrawTransformFeedbackInstancedEXT(mode, id, instancecount) glatter_glDrawTransformFeedbackInstancedEXT((mode), (id), (instancecount))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawTransformFeedbackInstancedEXT, (GLenum mode, GLuint id, GLsizei instancecount))
#endif // defined(GL_EXT_draw_transform_feedback)
#if defined(GL_EXT_external_buffer)
#ifndef glBufferStorageExternalEXT
#define glBufferStorageExternalEXT(target, offset, size, clientBuffer, flags) glatter_glBufferStorageExternalEXT((target), (offset), (size), (clientBuffer), (flags))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBufferStorageExternalEXT, (GLenum target, GLintptr offset, GLsizeiptr size, GLeglClientBufferEXT clientBuffer, GLbitfield flags))
#ifndef glNamedBufferStorageExternalEXT
#define glNamedBufferStorageExternalEXT(buffer, offset, size, clientBuffer, flags) glatter_glNamedBufferStorageExternalEXT((buffer), (offset), (size), (clientBuffer), (flags))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glNamedBufferStorageExternalEXT, (GLuint buffer, GLintptr offset, GLsizeiptr size, GLeglClientBufferEXT clientBuffer, GLbitfield flags))
#endif // defined(GL_EXT_external_buffer)
#if defined(GL_EXT_geometry_shader)
#ifndef glFramebufferTextureEXT
#define glFramebufferTextureEXT(target, attachment, texture, level) glatter_glFramebufferTextureEXT((target), (attachment), (texture), (level))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferTextureEXT, (GLenum target, GLenum attachment, GLuint texture, GLint level))
#endif // defined(GL_EXT_geometry_shader)
#if defined(GL_EXT_instanced_arrays)
#ifndef glVertexAttribDivisorEXT
#define glVertexAttribDivisorEXT(index, divisor) glatter_glVertexAttribDivisorEXT((index), (divisor))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glVertexAttribDivisorEXT, (GLuint index, GLuint divisor))
#endif // defined(GL_EXT_instanced_arrays)
#if defined(GL_EXT_map_buffer_range)
#ifndef glFlushMappedBufferRangeEXT
#define glFlushMappedBufferRangeEXT(target, offset, length) glatter_glFlushMappedBufferRangeEXT((target), (offset), (length))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFlushMappedBufferRangeEXT, (GLenum target, GLintptr offset, GLsizeiptr length))
#ifndef glMapBufferRangeEXT
#define glMapBufferRangeEXT(target, offset, length, access) glatter_glMapBufferRangeEXT((target), (offset), (length), (access))
#endif
GLATTER_UBLOCK(void *, GL_APIENTRY, glMapBufferRangeEXT, (GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access))
#endif // defined(GL_EXT_map_buffer_range)
#if defined(GL_EXT_memory_object)
#ifndef glBufferStorageMemEXT
#define glBufferStorageMemEXT(target, size, memory, offset) glatter_glBufferStorageMemEXT((target), (size), (memory), (offset))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBufferStorageMemEXT, (GLenum target, GLsizeiptr size, GLuint memory, GLuint64 offset))
#ifndef glCreateMemoryObjectsEXT
#define glCreateMemoryObjectsEXT(n, memoryObjects) glatter_glCreateMemoryObjectsEXT((n), (memoryObjects))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCreateMemoryObjectsEXT, (GLsizei n, GLuint *memoryObjects))
#ifndef glDeleteMemoryObjectsEXT
#define glDeleteMemoryObjectsEXT(n, memoryObjects) glatter_glDeleteMemoryObjectsEXT((n), (memoryObjects))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeleteMemoryObjectsEXT, (GLsizei n, const GLuint *memoryObjects))
#ifndef glGetMemoryObjectParameterivEXT
#define glGetMemoryObjectParameterivEXT(memoryObject, pname, params) glatter_glGetMemoryObjectParameterivEXT((memoryObject), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetMemoryObjectParameterivEXT, (GLuint memoryObject, GLenum pname, GLint *params))
#ifndef glGetUnsignedBytei_vEXT
#define glGetUnsignedBytei_vEXT(target, index, data) glatter_glGetUnsignedBytei_vEXT((target), (index), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetUnsignedBytei_vEXT, (GLenum target, GLuint index, GLubyte *data))
#ifndef glGetUnsignedBytevEXT
#define glGetUnsignedBytevEXT(pname, data) glatter_glGetUnsignedBytevEXT((pname), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetUnsignedBytevEXT, (GLenum pname, GLubyte *data))
#ifndef glIsMemoryObjectEXT
#define glIsMemoryObjectEXT(memoryObject) glatter_glIsMemoryObjectEXT((memoryObject))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsMemoryObjectEXT, (GLuint memoryObject))
#ifndef glMemoryObjectParameterivEXT
#define glMemoryObjectParameterivEXT(memoryObject, pname, params) glatter_glMemoryObjectParameterivEXT((memoryObject), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMemoryObjectParameterivEXT, (GLuint memoryObject, GLenum pname, const GLint *params))
#ifndef glNamedBufferStorageMemEXT
#define glNamedBufferStorageMemEXT(buffer, size, memory, offset) glatter_glNamedBufferStorageMemEXT((buffer), (size), (memory), (offset))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glNamedBufferStorageMemEXT, (GLuint buffer, GLsizeiptr size, GLuint memory, GLuint64 offset))
#ifndef glTexStorageMem2DEXT
#define glTexStorageMem2DEXT(target, levels, internalFormat, width, height, memory, offset) glatter_glTexStorageMem2DEXT((target), (levels), (internalFormat), (width), (height), (memory), (offset))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexStorageMem2DEXT, (GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset))
#ifndef glTexStorageMem2DMultisampleEXT
#define glTexStorageMem2DMultisampleEXT(target, samples, internalFormat, width, height, fixedSampleLocations, memory, offset) glatter_glTexStorageMem2DMultisampleEXT((target), (samples), (internalFormat), (width), (height), (fixedSampleLocations), (memory), (offset))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexStorageMem2DMultisampleEXT, (GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset))
#ifndef glTexStorageMem3DEXT
#define glTexStorageMem3DEXT(target, levels, internalFormat, width, height, depth, memory, offset) glatter_glTexStorageMem3DEXT((target), (levels), (internalFormat), (width), (height), (depth), (memory), (offset))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexStorageMem3DEXT, (GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset))
#ifndef glTexStorageMem3DMultisampleEXT
#define glTexStorageMem3DMultisampleEXT(target, samples, internalFormat, width, height, depth, fixedSampleLocations, memory, offset) glatter_glTexStorageMem3DMultisampleEXT((target), (samples), (internalFormat), (width), (height), (depth), (fixedSampleLocations), (memory), (offset))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexStorageMem3DMultisampleEXT, (GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset))
#ifndef glTextureStorageMem2DEXT
#define glTextureStorageMem2DEXT(texture, levels, internalFormat, width, height, memory, offset) glatter_glTextureStorageMem2DEXT((texture), (levels), (internalFormat), (width), (height), (memory), (offset))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTextureStorageMem2DEXT, (GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset))
#ifndef glTextureStorageMem2DMultisampleEXT
#define glTextureStorageMem2DMultisampleEXT(texture, samples, internalFormat, width, height, fixedSampleLocations, memory, offset) glatter_glTextureStorageMem2DMultisampleEXT((texture), (samples), (internalFormat), (width), (height), (fixedSampleLocations), (memory), (offset))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTextureStorageMem2DMultisampleEXT, (GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset))
#ifndef glTextureStorageMem3DEXT
#define glTextureStorageMem3DEXT(texture, levels, internalFormat, width, height, depth, memory, offset) glatter_glTextureStorageMem3DEXT((texture), (levels), (internalFormat), (width), (height), (depth), (memory), (offset))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTextureStorageMem3DEXT, (GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset))
#ifndef glTextureStorageMem3DMultisampleEXT
#define glTextureStorageMem3DMultisampleEXT(texture, samples, internalFormat, width, height, depth, fixedSampleLocations, memory, offset) glatter_glTextureStorageMem3DMultisampleEXT((texture), (samples), (internalFormat), (width), (height), (depth), (fixedSampleLocations), (memory), (offset))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTextureStorageMem3DMultisampleEXT, (GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset))
#endif // defined(GL_EXT_memory_object)
#if defined(GL_EXT_memory_object_fd)
#ifndef glImportMemoryFdEXT
#define glImportMemoryFdEXT(memory, size, handleType, fd) glatter_glImportMemoryFdEXT((memory), (size), (handleType), (fd))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glImportMemoryFdEXT, (GLuint memory, GLuint64 size, GLenum handleType, GLint fd))
#endif // defined(GL_EXT_memory_object_fd)
#if defined(GL_EXT_memory_object_win32)
#ifndef glImportMemoryWin32HandleEXT
#define glImportMemoryWin32HandleEXT(memory, size, handleType, handle) glatter_glImportMemoryWin32HandleEXT((memory), (size), (handleType), (handle))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glImportMemoryWin32HandleEXT, (GLuint memory, GLuint64 size, GLenum handleType, void *handle))
#ifndef glImportMemoryWin32NameEXT
#define glImportMemoryWin32NameEXT(memory, size, handleType, name) glatter_glImportMemoryWin32NameEXT((memory), (size), (handleType), (name))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glImportMemoryWin32NameEXT, (GLuint memory, GLuint64 size, GLenum handleType, const void *name))
#endif // defined(GL_EXT_memory_object_win32)
#if defined(GL_EXT_multi_draw_arrays)
#ifndef glMultiDrawArraysEXT
#define glMultiDrawArraysEXT(mode, first, count, primcount) glatter_glMultiDrawArraysEXT((mode), (first), (count), (primcount))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMultiDrawArraysEXT, (GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount))
#ifndef glMultiDrawElementsEXT
#define glMultiDrawElementsEXT(mode, count, type, indices, primcount) glatter_glMultiDrawElementsEXT((mode), (count), (type), (indices), (primcount))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMultiDrawElementsEXT, (GLenum mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount))
#endif // defined(GL_EXT_multi_draw_arrays)
#if defined(GL_EXT_multi_draw_indirect)
#ifndef glMultiDrawArraysIndirectEXT
#define glMultiDrawArraysIndirectEXT(mode, indirect, drawcount, stride) glatter_glMultiDrawArraysIndirectEXT((mode), (indirect), (drawcount), (stride))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMultiDrawArraysIndirectEXT, (GLenum mode, const void *indirect, GLsizei drawcount, GLsizei stride))
#ifndef glMultiDrawElementsIndirectEXT
#define glMultiDrawElementsIndirectEXT(mode, type, indirect, drawcount, stride) glatter_glMultiDrawElementsIndirectEXT((mode), (type), (indirect), (drawcount), (stride))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMultiDrawElementsIndirectEXT, (GLenum mode, GLenum type, const void *indirect, GLsizei drawcount, GLsizei stride))
#endif // defined(GL_EXT_multi_draw_indirect)
#if defined(GL_EXT_multisampled_render_to_texture)
#ifndef glFramebufferTexture2DMultisampleEXT
#define glFramebufferTexture2DMultisampleEXT(target, attachment, textarget, texture, level, samples) glatter_glFramebufferTexture2DMultisampleEXT((target), (attachment), (textarget), (texture), (level), (samples))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferTexture2DMultisampleEXT, (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples))
#ifndef glRenderbufferStorageMultisampleEXT
#define glRenderbufferStorageMultisampleEXT(target, samples, internalformat, width, height) glatter_glRenderbufferStorageMultisampleEXT((target), (samples), (internalformat), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glRenderbufferStorageMultisampleEXT, (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
#endif // defined(GL_EXT_multisampled_render_to_texture)
#if defined(GL_EXT_multiview_draw_buffers)
#ifndef glDrawBuffersIndexedEXT
#define glDrawBuffersIndexedEXT(n, location, indices) glatter_glDrawBuffersIndexedEXT((n), (location), (indices))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawBuffersIndexedEXT, (GLint n, const GLenum *location, const GLint *indices))
#ifndef glGetIntegeri_vEXT
#define glGetIntegeri_vEXT(target, index, data) glatter_glGetIntegeri_vEXT((target), (index), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetIntegeri_vEXT, (GLenum target, GLuint index, GLint *data))
#ifndef glReadBufferIndexedEXT
#define glReadBufferIndexedEXT(src, index) glatter_glReadBufferIndexedEXT((src), (index))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glReadBufferIndexedEXT, (GLenum src, GLint index))
#endif // defined(GL_EXT_multiview_draw_buffers)
#if defined(GL_EXT_polygon_offset_clamp)
#ifndef glPolygonOffsetClampEXT
#define glPolygonOffsetClampEXT(factor, units, clamp) glatter_glPolygonOffsetClampEXT((factor), (units), (clamp))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPolygonOffsetClampEXT, (GLfloat factor, GLfloat units, GLfloat clamp))
#endif // defined(GL_EXT_polygon_offset_clamp)
#if defined(GL_EXT_primitive_bounding_box)
#ifndef glPrimitiveBoundingBoxEXT
#define glPrimitiveBoundingBoxEXT(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW) glatter_glPrimitiveBoundingBoxEXT((minX), (minY), (minZ), (minW), (maxX), (maxY), (maxZ), (maxW))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPrimitiveBoundingBoxEXT, (GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW))
#endif // defined(GL_EXT_primitive_bounding_box)
#if defined(GL_EXT_raster_multisample)
#ifndef glRasterSamplesEXT
#define glRasterSamplesEXT(samples, fixedsamplelocations) glatter_glRasterSamplesEXT((samples), (fixedsamplelocations))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glRasterSamplesEXT, (GLuint samples, GLboolean fixedsamplelocations))
#endif // defined(GL_EXT_raster_multisample)
#if defined(GL_EXT_robustness)
#ifndef glGetGraphicsResetStatusEXT
#define glGetGraphicsResetStatusEXT() glatter_glGetGraphicsResetStatusEXT()
#endif
GLATTER_UBLOCK(GLenum, GL_APIENTRY, glGetGraphicsResetStatusEXT, (void))
#ifndef glGetnUniformfvEXT
#define glGetnUniformfvEXT(program, location, bufSize, params) glatter_glGetnUniformfvEXT((program), (location), (bufSize), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetnUniformfvEXT, (GLuint program, GLint location, GLsizei bufSize, GLfloat *params))
#ifndef glGetnUniformivEXT
#define glGetnUniformivEXT(program, location, bufSize, params) glatter_glGetnUniformivEXT((program), (location), (bufSize), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetnUniformivEXT, (GLuint program, GLint location, GLsizei bufSize, GLint *params))
#ifndef glReadnPixelsEXT
#define glReadnPixelsEXT(x, y, width, height, format, type, bufSize, data) glatter_glReadnPixelsEXT((x), (y), (width), (height), (format), (type), (bufSize), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glReadnPixelsEXT, (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data))
#endif // defined(GL_EXT_robustness)
#if defined(GL_EXT_semaphore)
#ifndef glDeleteSemaphoresEXT
#define glDeleteSemaphoresEXT(n, semaphores) glatter_glDeleteSemaphoresEXT((n), (semaphores))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeleteSemaphoresEXT, (GLsizei n, const GLuint *semaphores))
#ifndef glGenSemaphoresEXT
#define glGenSemaphoresEXT(n, semaphores) glatter_glGenSemaphoresEXT((n), (semaphores))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGenSemaphoresEXT, (GLsizei n, GLuint *semaphores))
#ifndef glGetSemaphoreParameterui64vEXT
#define glGetSemaphoreParameterui64vEXT(semaphore, pname, params) glatter_glGetSemaphoreParameterui64vEXT((semaphore), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetSemaphoreParameterui64vEXT, (GLuint semaphore, GLenum pname, GLuint64 *params))
#ifndef glIsSemaphoreEXT
#define glIsSemaphoreEXT(semaphore) glatter_glIsSemaphoreEXT((semaphore))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsSemaphoreEXT, (GLuint semaphore))
#ifndef glSemaphoreParameterui64vEXT
#define glSemaphoreParameterui64vEXT(semaphore, pname, params) glatter_glSemaphoreParameterui64vEXT((semaphore), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glSemaphoreParameterui64vEXT, (GLuint semaphore, GLenum pname, const GLuint64 *params))
#ifndef glSignalSemaphoreEXT
#define glSignalSemaphoreEXT(semaphore, numBufferBarriers, buffers, numTextureBarriers, textures, dstLayouts) glatter_glSignalSemaphoreEXT((semaphore), (numBufferBarriers), (buffers), (numTextureBarriers), (textures), (dstLayouts))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glSignalSemaphoreEXT, (GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *dstLayouts))
#ifndef glWaitSemaphoreEXT
#define glWaitSemaphoreEXT(semaphore, numBufferBarriers, buffers, numTextureBarriers, textures, srcLayouts) glatter_glWaitSemaphoreEXT((semaphore), (numBufferBarriers), (buffers), (numTextureBarriers), (textures), (srcLayouts))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glWaitSemaphoreEXT, (GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *srcLayouts))
#endif // defined(GL_EXT_semaphore)
#if defined(GL_EXT_semaphore_fd)
#ifndef glImportSemaphoreFdEXT
#define glImportSemaphoreFdEXT(semaphore, handleType, fd) glatter_glImportSemaphoreFdEXT((semaphore), (handleType), (fd))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glImportSemaphoreFdEXT, (GLuint semaphore, GLenum handleType, GLint fd))
#endif // defined(GL_EXT_semaphore_fd)
#if defined(GL_EXT_semaphore_win32)
#ifndef glImportSemaphoreWin32HandleEXT
#define glImportSemaphoreWin32HandleEXT(semaphore, handleType, handle) glatter_glImportSemaphoreWin32HandleEXT((semaphore), (handleType), (handle))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glImportSemaphoreWin32HandleEXT, (GLuint semaphore, GLenum handleType, void *handle))
#ifndef glImportSemaphoreWin32NameEXT
#define glImportSemaphoreWin32NameEXT(semaphore, handleType, name) glatter_glImportSemaphoreWin32NameEXT((semaphore), (handleType), (name))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glImportSemaphoreWin32NameEXT, (GLuint semaphore, GLenum handleType, const void *name))
#endif // defined(GL_EXT_semaphore_win32)
#if defined(GL_EXT_separate_shader_objects)
#ifndef glActiveShaderProgramEXT
#define glActiveShaderProgramEXT(pipeline, program) glatter_glActiveShaderProgramEXT((pipeline), (program))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glActiveShaderProgramEXT, (GLuint pipeline, GLuint program))
#ifndef glBindProgramPipelineEXT
#define glBindProgramPipelineEXT(pipeline) glatter_glBindProgramPipelineEXT((pipeline))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBindProgramPipelineEXT, (GLuint pipeline))
#ifndef glCreateShaderProgramvEXT
#define glCreateShaderProgramvEXT(type, count, strings) glatter_glCreateShaderProgramvEXT((type), (count), (strings))
#endif
GLATTER_UBLOCK(GLuint, GL_APIENTRY, glCreateShaderProgramvEXT, (GLenum type, GLsizei count, const GLchar **strings))
#ifndef glDeleteProgramPipelinesEXT
#define glDeleteProgramPipelinesEXT(n, pipelines) glatter_glDeleteProgramPipelinesEXT((n), (pipelines))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeleteProgramPipelinesEXT, (GLsizei n, const GLuint *pipelines))
#ifndef glGenProgramPipelinesEXT
#define glGenProgramPipelinesEXT(n, pipelines) glatter_glGenProgramPipelinesEXT((n), (pipelines))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGenProgramPipelinesEXT, (GLsizei n, GLuint *pipelines))
#ifndef glGetProgramPipelineInfoLogEXT
#define glGetProgramPipelineInfoLogEXT(pipeline, bufSize, length, infoLog) glatter_glGetProgramPipelineInfoLogEXT((pipeline), (bufSize), (length), (infoLog))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetProgramPipelineInfoLogEXT, (GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog))
#ifndef glGetProgramPipelineivEXT
#define glGetProgramPipelineivEXT(pipeline, pname, params) glatter_glGetProgramPipelineivEXT((pipeline), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetProgramPipelineivEXT, (GLuint pipeline, GLenum pname, GLint *params))
#ifndef glIsProgramPipelineEXT
#define glIsProgramPipelineEXT(pipeline) glatter_glIsProgramPipelineEXT((pipeline))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsProgramPipelineEXT, (GLuint pipeline))
#ifndef glProgramParameteriEXT
#define glProgramParameteriEXT(program, pname, value) glatter_glProgramParameteriEXT((program), (pname), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramParameteriEXT, (GLuint program, GLenum pname, GLint value))
#ifndef glProgramUniform1fEXT
#define glProgramUniform1fEXT(program, location, v0) glatter_glProgramUniform1fEXT((program), (location), (v0))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform1fEXT, (GLuint program, GLint location, GLfloat v0))
#ifndef glProgramUniform1fvEXT
#define glProgramUniform1fvEXT(program, location, count, value) glatter_glProgramUniform1fvEXT((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform1fvEXT, (GLuint program, GLint location, GLsizei count, const GLfloat *value))
#ifndef glProgramUniform1iEXT
#define glProgramUniform1iEXT(program, location, v0) glatter_glProgramUniform1iEXT((program), (location), (v0))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform1iEXT, (GLuint program, GLint location, GLint v0))
#ifndef glProgramUniform1ivEXT
#define glProgramUniform1ivEXT(program, location, count, value) glatter_glProgramUniform1ivEXT((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform1ivEXT, (GLuint program, GLint location, GLsizei count, const GLint *value))
#ifndef glProgramUniform1uiEXT
#define glProgramUniform1uiEXT(program, location, v0) glatter_glProgramUniform1uiEXT((program), (location), (v0))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform1uiEXT, (GLuint program, GLint location, GLuint v0))
#ifndef glProgramUniform1uivEXT
#define glProgramUniform1uivEXT(program, location, count, value) glatter_glProgramUniform1uivEXT((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform1uivEXT, (GLuint program, GLint location, GLsizei count, const GLuint *value))
#ifndef glProgramUniform2fEXT
#define glProgramUniform2fEXT(program, location, v0, v1) glatter_glProgramUniform2fEXT((program), (location), (v0), (v1))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform2fEXT, (GLuint program, GLint location, GLfloat v0, GLfloat v1))
#ifndef glProgramUniform2fvEXT
#define glProgramUniform2fvEXT(program, location, count, value) glatter_glProgramUniform2fvEXT((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform2fvEXT, (GLuint program, GLint location, GLsizei count, const GLfloat *value))
#ifndef glProgramUniform2iEXT
#define glProgramUniform2iEXT(program, location, v0, v1) glatter_glProgramUniform2iEXT((program), (location), (v0), (v1))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform2iEXT, (GLuint program, GLint location, GLint v0, GLint v1))
#ifndef glProgramUniform2ivEXT
#define glProgramUniform2ivEXT(program, location, count, value) glatter_glProgramUniform2ivEXT((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform2ivEXT, (GLuint program, GLint location, GLsizei count, const GLint *value))
#ifndef glProgramUniform2uiEXT
#define glProgramUniform2uiEXT(program, location, v0, v1) glatter_glProgramUniform2uiEXT((program), (location), (v0), (v1))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform2uiEXT, (GLuint program, GLint location, GLuint v0, GLuint v1))
#ifndef glProgramUniform2uivEXT
#define glProgramUniform2uivEXT(program, location, count, value) glatter_glProgramUniform2uivEXT((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform2uivEXT, (GLuint program, GLint location, GLsizei count, const GLuint *value))
#ifndef glProgramUniform3fEXT
#define glProgramUniform3fEXT(program, location, v0, v1, v2) glatter_glProgramUniform3fEXT((program), (location), (v0), (v1), (v2))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform3fEXT, (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2))
#ifndef glProgramUniform3fvEXT
#define glProgramUniform3fvEXT(program, location, count, value) glatter_glProgramUniform3fvEXT((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform3fvEXT, (GLuint program, GLint location, GLsizei count, const GLfloat *value))
#ifndef glProgramUniform3iEXT
#define glProgramUniform3iEXT(program, location, v0, v1, v2) glatter_glProgramUniform3iEXT((program), (location), (v0), (v1), (v2))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform3iEXT, (GLuint program, GLint location, GLint v0, GLint v1, GLint v2))
#ifndef glProgramUniform3ivEXT
#define glProgramUniform3ivEXT(program, location, count, value) glatter_glProgramUniform3ivEXT((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform3ivEXT, (GLuint program, GLint location, GLsizei count, const GLint *value))
#ifndef glProgramUniform3uiEXT
#define glProgramUniform3uiEXT(program, location, v0, v1, v2) glatter_glProgramUniform3uiEXT((program), (location), (v0), (v1), (v2))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform3uiEXT, (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2))
#ifndef glProgramUniform3uivEXT
#define glProgramUniform3uivEXT(program, location, count, value) glatter_glProgramUniform3uivEXT((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform3uivEXT, (GLuint program, GLint location, GLsizei count, const GLuint *value))
#ifndef glProgramUniform4fEXT
#define glProgramUniform4fEXT(program, location, v0, v1, v2, v3) glatter_glProgramUniform4fEXT((program), (location), (v0), (v1), (v2), (v3))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform4fEXT, (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3))
#ifndef glProgramUniform4fvEXT
#define glProgramUniform4fvEXT(program, location, count, value) glatter_glProgramUniform4fvEXT((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform4fvEXT, (GLuint program, GLint location, GLsizei count, const GLfloat *value))
#ifndef glProgramUniform4iEXT
#define glProgramUniform4iEXT(program, location, v0, v1, v2, v3) glatter_glProgramUniform4iEXT((program), (location), (v0), (v1), (v2), (v3))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform4iEXT, (GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3))
#ifndef glProgramUniform4ivEXT
#define glProgramUniform4ivEXT(program, location, count, value) glatter_glProgramUniform4ivEXT((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform4ivEXT, (GLuint program, GLint location, GLsizei count, const GLint *value))
#ifndef glProgramUniform4uiEXT
#define glProgramUniform4uiEXT(program, location, v0, v1, v2, v3) glatter_glProgramUniform4uiEXT((program), (location), (v0), (v1), (v2), (v3))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform4uiEXT, (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3))
#ifndef glProgramUniform4uivEXT
#define glProgramUniform4uivEXT(program, location, count, value) glatter_glProgramUniform4uivEXT((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform4uivEXT, (GLuint program, GLint location, GLsizei count, const GLuint *value))
#ifndef glProgramUniformMatrix2fvEXT
#define glProgramUniformMatrix2fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix2fvEXT((program), (location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniformMatrix2fvEXT, (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glProgramUniformMatrix2x3fvEXT
#define glProgramUniformMatrix2x3fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix2x3fvEXT((program), (location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniformMatrix2x3fvEXT, (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glProgramUniformMatrix2x4fvEXT
#define glProgramUniformMatrix2x4fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix2x4fvEXT((program), (location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniformMatrix2x4fvEXT, (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glProgramUniformMatrix3fvEXT
#define glProgramUniformMatrix3fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix3fvEXT((program), (location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniformMatrix3fvEXT, (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glProgramUniformMatrix3x2fvEXT
#define glProgramUniformMatrix3x2fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix3x2fvEXT((program), (location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniformMatrix3x2fvEXT, (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glProgramUniformMatrix3x4fvEXT
#define glProgramUniformMatrix3x4fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix3x4fvEXT((program), (location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniformMatrix3x4fvEXT, (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glProgramUniformMatrix4fvEXT
#define glProgramUniformMatrix4fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix4fvEXT((program), (location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniformMatrix4fvEXT, (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glProgramUniformMatrix4x2fvEXT
#define glProgramUniformMatrix4x2fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix4x2fvEXT((program), (location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniformMatrix4x2fvEXT, (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glProgramUniformMatrix4x3fvEXT
#define glProgramUniformMatrix4x3fvEXT(program, location, count, transpose, value) glatter_glProgramUniformMatrix4x3fvEXT((program), (location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniformMatrix4x3fvEXT, (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glUseProgramStagesEXT
#define glUseProgramStagesEXT(pipeline, stages, program) glatter_glUseProgramStagesEXT((pipeline), (stages), (program))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUseProgramStagesEXT, (GLuint pipeline, GLbitfield stages, GLuint program))
#ifndef glValidateProgramPipelineEXT
#define glValidateProgramPipelineEXT(pipeline) glatter_glValidateProgramPipelineEXT((pipeline))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glValidateProgramPipelineEXT, (GLuint pipeline))
#endif // defined(GL_EXT_separate_shader_objects)
#if defined(GL_EXT_shader_framebuffer_fetch_non_coherent)
#ifndef glFramebufferFetchBarrierEXT
#define glFramebufferFetchBarrierEXT() glatter_glFramebufferFetchBarrierEXT()
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferFetchBarrierEXT, (void))
#endif // defined(GL_EXT_shader_framebuffer_fetch_non_coherent)
#if defined(GL_EXT_shader_pixel_local_storage2)
#ifndef glClearPixelLocalStorageuiEXT
#define glClearPixelLocalStorageuiEXT(offset, n, values) glatter_glClearPixelLocalStorageuiEXT((offset), (n), (values))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glClearPixelLocalStorageuiEXT, (GLsizei offset, GLsizei n, const GLuint *values))
#ifndef glFramebufferPixelLocalStorageSizeEXT
#define glFramebufferPixelLocalStorageSizeEXT(target, size) glatter_glFramebufferPixelLocalStorageSizeEXT((target), (size))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferPixelLocalStorageSizeEXT, (GLuint target, GLsizei size))
#ifndef glGetFramebufferPixelLocalStorageSizeEXT
#define glGetFramebufferPixelLocalStorageSizeEXT(target) glatter_glGetFramebufferPixelLocalStorageSizeEXT((target))
#endif
GLATTER_UBLOCK(GLsizei, GL_APIENTRY, glGetFramebufferPixelLocalStorageSizeEXT, (GLuint target))
#endif // defined(GL_EXT_shader_pixel_local_storage2)
#if defined(GL_EXT_sparse_texture)
#ifndef glTexPageCommitmentEXT
#define glTexPageCommitmentEXT(target, level, xoffset, yoffset, zoffset, width, height, depth, commit) glatter_glTexPageCommitmentEXT((target), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (commit))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexPageCommitmentEXT, (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit))
#endif // defined(GL_EXT_sparse_texture)
#if defined(GL_EXT_tessellation_shader)
#ifndef glPatchParameteriEXT
#define glPatchParameteriEXT(pname, value) glatter_glPatchParameteriEXT((pname), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPatchParameteriEXT, (GLenum pname, GLint value))
#endif // defined(GL_EXT_tessellation_shader)
#if defined(GL_EXT_texture_border_clamp)
#ifndef glGetSamplerParameterIivEXT
#define glGetSamplerParameterIivEXT(sampler, pname, params) glatter_glGetSamplerParameterIivEXT((sampler), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetSamplerParameterIivEXT, (GLuint sampler, GLenum pname, GLint *params))
#ifndef glGetSamplerParameterIuivEXT
#define glGetSamplerParameterIuivEXT(sampler, pname, params) glatter_glGetSamplerParameterIuivEXT((sampler), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetSamplerParameterIuivEXT, (GLuint sampler, GLenum pname, GLuint *params))
#ifndef glGetTexParameterIivEXT
#define glGetTexParameterIivEXT(target, pname, params) glatter_glGetTexParameterIivEXT((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetTexParameterIivEXT, (GLenum target, GLenum pname, GLint *params))
#ifndef glGetTexParameterIuivEXT
#define glGetTexParameterIuivEXT(target, pname, params) glatter_glGetTexParameterIuivEXT((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetTexParameterIuivEXT, (GLenum target, GLenum pname, GLuint *params))
#ifndef glSamplerParameterIivEXT
#define glSamplerParameterIivEXT(sampler, pname, param) glatter_glSamplerParameterIivEXT((sampler), (pname), (param))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glSamplerParameterIivEXT, (GLuint sampler, GLenum pname, const GLint *param))
#ifndef glSamplerParameterIuivEXT
#define glSamplerParameterIuivEXT(sampler, pname, param) glatter_glSamplerParameterIuivEXT((sampler), (pname), (param))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glSamplerParameterIuivEXT, (GLuint sampler, GLenum pname, const GLuint *param))
#ifndef glTexParameterIivEXT
#define glTexParameterIivEXT(target, pname, params) glatter_glTexParameterIivEXT((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexParameterIivEXT, (GLenum target, GLenum pname, const GLint *params))
#ifndef glTexParameterIuivEXT
#define glTexParameterIuivEXT(target, pname, params) glatter_glTexParameterIuivEXT((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexParameterIuivEXT, (GLenum target, GLenum pname, const GLuint *params))
#endif // defined(GL_EXT_texture_border_clamp)
#if defined(GL_EXT_texture_buffer)
#ifndef glTexBufferEXT
#define glTexBufferEXT(target, internalformat, buffer) glatter_glTexBufferEXT((target), (internalformat), (buffer))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexBufferEXT, (GLenum target, GLenum internalformat, GLuint buffer))
#ifndef glTexBufferRangeEXT
#define glTexBufferRangeEXT(target, internalformat, buffer, offset, size) glatter_glTexBufferRangeEXT((target), (internalformat), (buffer), (offset), (size))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexBufferRangeEXT, (GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size))
#endif // defined(GL_EXT_texture_buffer)
#if defined(GL_EXT_texture_storage)
#ifndef glTexStorage1DEXT
#define glTexStorage1DEXT(target, levels, internalformat, width) glatter_glTexStorage1DEXT((target), (levels), (internalformat), (width))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexStorage1DEXT, (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width))
#ifndef glTexStorage2DEXT
#define glTexStorage2DEXT(target, levels, internalformat, width, height) glatter_glTexStorage2DEXT((target), (levels), (internalformat), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexStorage2DEXT, (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height))
#ifndef glTexStorage3DEXT
#define glTexStorage3DEXT(target, levels, internalformat, width, height, depth) glatter_glTexStorage3DEXT((target), (levels), (internalformat), (width), (height), (depth))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexStorage3DEXT, (GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth))
#ifndef glTextureStorage1DEXT
#define glTextureStorage1DEXT(texture, target, levels, internalformat, width) glatter_glTextureStorage1DEXT((texture), (target), (levels), (internalformat), (width))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTextureStorage1DEXT, (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width))
#ifndef glTextureStorage2DEXT
#define glTextureStorage2DEXT(texture, target, levels, internalformat, width, height) glatter_glTextureStorage2DEXT((texture), (target), (levels), (internalformat), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTextureStorage2DEXT, (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height))
#ifndef glTextureStorage3DEXT
#define glTextureStorage3DEXT(texture, target, levels, internalformat, width, height, depth) glatter_glTextureStorage3DEXT((texture), (target), (levels), (internalformat), (width), (height), (depth))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTextureStorage3DEXT, (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth))
#endif // defined(GL_EXT_texture_storage)
#if defined(GL_EXT_texture_view)
#ifndef glTextureViewEXT
#define glTextureViewEXT(texture, target, origtexture, internalformat, minlevel, numlevels, minlayer, numlayers) glatter_glTextureViewEXT((texture), (target), (origtexture), (internalformat), (minlevel), (numlevels), (minlayer), (numlayers))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTextureViewEXT, (GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers))
#endif // defined(GL_EXT_texture_view)
#if defined(GL_EXT_win32_keyed_mutex)
#ifndef glAcquireKeyedMutexWin32EXT
#define glAcquireKeyedMutexWin32EXT(memory, key, timeout) glatter_glAcquireKeyedMutexWin32EXT((memory), (key), (timeout))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glAcquireKeyedMutexWin32EXT, (GLuint memory, GLuint64 key, GLuint timeout))
#ifndef glReleaseKeyedMutexWin32EXT
#define glReleaseKeyedMutexWin32EXT(memory, key) glatter_glReleaseKeyedMutexWin32EXT((memory), (key))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glReleaseKeyedMutexWin32EXT, (GLuint memory, GLuint64 key))
#endif // defined(GL_EXT_win32_keyed_mutex)
#if defined(GL_EXT_window_rectangles)
#ifndef glWindowRectanglesEXT
#define glWindowRectanglesEXT(mode, count, box) glatter_glWindowRectanglesEXT((mode), (count), (box))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glWindowRectanglesEXT, (GLenum mode, GLsizei count, const GLint *box))
#endif // defined(GL_EXT_window_rectangles)
#if defined(GL_IMG_bindless_texture)
#ifndef glGetTextureHandleIMG
#define glGetTextureHandleIMG(texture) glatter_glGetTextureHandleIMG((texture))
#endif
GLATTER_UBLOCK(GLuint64, GL_APIENTRY, glGetTextureHandleIMG, (GLuint texture))
#ifndef glGetTextureSamplerHandleIMG
#define glGetTextureSamplerHandleIMG(texture, sampler) glatter_glGetTextureSamplerHandleIMG((texture), (sampler))
#endif
GLATTER_UBLOCK(GLuint64, GL_APIENTRY, glGetTextureSamplerHandleIMG, (GLuint texture, GLuint sampler))
#ifndef glProgramUniformHandleui64IMG
#define glProgramUniformHandleui64IMG(program, location, value) glatter_glProgramUniformHandleui64IMG((program), (location), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniformHandleui64IMG, (GLuint program, GLint location, GLuint64 value))
#ifndef glProgramUniformHandleui64vIMG
#define glProgramUniformHandleui64vIMG(program, location, count, values) glatter_glProgramUniformHandleui64vIMG((program), (location), (count), (values))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniformHandleui64vIMG, (GLuint program, GLint location, GLsizei count, const GLuint64 *values))
#ifndef glUniformHandleui64IMG
#define glUniformHandleui64IMG(location, value) glatter_glUniformHandleui64IMG((location), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniformHandleui64IMG, (GLint location, GLuint64 value))
#ifndef glUniformHandleui64vIMG
#define glUniformHandleui64vIMG(location, count, value) glatter_glUniformHandleui64vIMG((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniformHandleui64vIMG, (GLint location, GLsizei count, const GLuint64 *value))
#endif // defined(GL_IMG_bindless_texture)
#if defined(GL_IMG_framebuffer_downsample)
#ifndef glFramebufferTexture2DDownsampleIMG
#define glFramebufferTexture2DDownsampleIMG(target, attachment, textarget, texture, level, xscale, yscale) glatter_glFramebufferTexture2DDownsampleIMG((target), (attachment), (textarget), (texture), (level), (xscale), (yscale))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferTexture2DDownsampleIMG, (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint xscale, GLint yscale))
#ifndef glFramebufferTextureLayerDownsampleIMG
#define glFramebufferTextureLayerDownsampleIMG(target, attachment, texture, level, layer, xscale, yscale) glatter_glFramebufferTextureLayerDownsampleIMG((target), (attachment), (texture), (level), (layer), (xscale), (yscale))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferTextureLayerDownsampleIMG, (GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer, GLint xscale, GLint yscale))
#endif // defined(GL_IMG_framebuffer_downsample)
#if defined(GL_IMG_multisampled_render_to_texture)
#ifndef glFramebufferTexture2DMultisampleIMG
#define glFramebufferTexture2DMultisampleIMG(target, attachment, textarget, texture, level, samples) glatter_glFramebufferTexture2DMultisampleIMG((target), (attachment), (textarget), (texture), (level), (samples))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferTexture2DMultisampleIMG, (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples))
#ifndef glRenderbufferStorageMultisampleIMG
#define glRenderbufferStorageMultisampleIMG(target, samples, internalformat, width, height) glatter_glRenderbufferStorageMultisampleIMG((target), (samples), (internalformat), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glRenderbufferStorageMultisampleIMG, (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
#endif // defined(GL_IMG_multisampled_render_to_texture)
#if defined(GL_INTEL_framebuffer_CMAA)
#ifndef glApplyFramebufferAttachmentCMAAINTEL
#define glApplyFramebufferAttachmentCMAAINTEL() glatter_glApplyFramebufferAttachmentCMAAINTEL()
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glApplyFramebufferAttachmentCMAAINTEL, (void))
#endif // defined(GL_INTEL_framebuffer_CMAA)
#if defined(GL_INTEL_performance_query)
#ifndef glBeginPerfQueryINTEL
#define glBeginPerfQueryINTEL(queryHandle) glatter_glBeginPerfQueryINTEL((queryHandle))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBeginPerfQueryINTEL, (GLuint queryHandle))
#ifndef glCreatePerfQueryINTEL
#define glCreatePerfQueryINTEL(queryId, queryHandle) glatter_glCreatePerfQueryINTEL((queryId), (queryHandle))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCreatePerfQueryINTEL, (GLuint queryId, GLuint *queryHandle))
#ifndef glDeletePerfQueryINTEL
#define glDeletePerfQueryINTEL(queryHandle) glatter_glDeletePerfQueryINTEL((queryHandle))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeletePerfQueryINTEL, (GLuint queryHandle))
#ifndef glEndPerfQueryINTEL
#define glEndPerfQueryINTEL(queryHandle) glatter_glEndPerfQueryINTEL((queryHandle))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEndPerfQueryINTEL, (GLuint queryHandle))
#ifndef glGetFirstPerfQueryIdINTEL
#define glGetFirstPerfQueryIdINTEL(queryId) glatter_glGetFirstPerfQueryIdINTEL((queryId))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetFirstPerfQueryIdINTEL, (GLuint *queryId))
#ifndef glGetNextPerfQueryIdINTEL
#define glGetNextPerfQueryIdINTEL(queryId, nextQueryId) glatter_glGetNextPerfQueryIdINTEL((queryId), (nextQueryId))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetNextPerfQueryIdINTEL, (GLuint queryId, GLuint *nextQueryId))
#ifndef glGetPerfCounterInfoINTEL
#define glGetPerfCounterInfoINTEL(queryId, counterId, counterNameLength, counterName, counterDescLength, counterDesc, counterOffset, counterDataSize, counterTypeEnum, counterDataTypeEnum, rawCounterMaxValue) glatter_glGetPerfCounterInfoINTEL((queryId), (counterId), (counterNameLength), (counterName), (counterDescLength), (counterDesc), (counterOffset), (counterDataSize), (counterTypeEnum), (counterDataTypeEnum), (rawCounterMaxValue))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPerfCounterInfoINTEL, (GLuint queryId, GLuint counterId, GLuint counterNameLength, GLchar *counterName, GLuint counterDescLength, GLchar *counterDesc, GLuint *counterOffset, GLuint *counterDataSize, GLuint *counterTypeEnum, GLuint *counterDataTypeEnum, GLuint64 *rawCounterMaxValue))
#ifndef glGetPerfQueryDataINTEL
#define glGetPerfQueryDataINTEL(queryHandle, flags, dataSize, data, bytesWritten) glatter_glGetPerfQueryDataINTEL((queryHandle), (flags), (dataSize), (data), (bytesWritten))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPerfQueryDataINTEL, (GLuint queryHandle, GLuint flags, GLsizei dataSize, void *data, GLuint *bytesWritten))
#ifndef glGetPerfQueryIdByNameINTEL
#define glGetPerfQueryIdByNameINTEL(queryName, queryId) glatter_glGetPerfQueryIdByNameINTEL((queryName), (queryId))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPerfQueryIdByNameINTEL, (GLchar *queryName, GLuint *queryId))
#ifndef glGetPerfQueryInfoINTEL
#define glGetPerfQueryInfoINTEL(queryId, queryNameLength, queryName, dataSize, noCounters, noInstances, capsMask) glatter_glGetPerfQueryInfoINTEL((queryId), (queryNameLength), (queryName), (dataSize), (noCounters), (noInstances), (capsMask))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPerfQueryInfoINTEL, (GLuint queryId, GLuint queryNameLength, GLchar *queryName, GLuint *dataSize, GLuint *noCounters, GLuint *noInstances, GLuint *capsMask))
#endif // defined(GL_INTEL_performance_query)
#if defined(GL_KHR_blend_equation_advanced)
#ifndef glBlendBarrierKHR
#define glBlendBarrierKHR() glatter_glBlendBarrierKHR()
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendBarrierKHR, (void))
#endif // defined(GL_KHR_blend_equation_advanced)
#if defined(GL_KHR_debug)
#ifndef glDebugMessageCallbackKHR
#define glDebugMessageCallbackKHR(callback, userParam) glatter_glDebugMessageCallbackKHR((callback), (userParam))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDebugMessageCallbackKHR, (GLDEBUGPROCKHR callback, const void *userParam))
#ifndef glDebugMessageControlKHR
#define glDebugMessageControlKHR(source, type, severity, count, ids, enabled) glatter_glDebugMessageControlKHR((source), (type), (severity), (count), (ids), (enabled))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDebugMessageControlKHR, (GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled))
#ifndef glDebugMessageInsertKHR
#define glDebugMessageInsertKHR(source, type, id, severity, length, buf) glatter_glDebugMessageInsertKHR((source), (type), (id), (severity), (length), (buf))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDebugMessageInsertKHR, (GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf))
#ifndef glGetDebugMessageLogKHR
#define glGetDebugMessageLogKHR(count, bufSize, sources, types, ids, severities, lengths, messageLog) glatter_glGetDebugMessageLogKHR((count), (bufSize), (sources), (types), (ids), (severities), (lengths), (messageLog))
#endif
GLATTER_UBLOCK(GLuint, GL_APIENTRY, glGetDebugMessageLogKHR, (GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog))
#ifndef glGetObjectLabelKHR
#define glGetObjectLabelKHR(identifier, name, bufSize, length, label) glatter_glGetObjectLabelKHR((identifier), (name), (bufSize), (length), (label))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetObjectLabelKHR, (GLenum identifier, GLuint name, GLsizei bufSize, GLsizei *length, GLchar *label))
#ifndef glGetObjectPtrLabelKHR
#define glGetObjectPtrLabelKHR(ptr, bufSize, length, label) glatter_glGetObjectPtrLabelKHR((ptr), (bufSize), (length), (label))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetObjectPtrLabelKHR, (const void *ptr, GLsizei bufSize, GLsizei *length, GLchar *label))
#ifndef glGetPointervKHR
#define glGetPointervKHR(pname, params) glatter_glGetPointervKHR((pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPointervKHR, (GLenum pname, void **params))
#ifndef glObjectLabelKHR
#define glObjectLabelKHR(identifier, name, length, label) glatter_glObjectLabelKHR((identifier), (name), (length), (label))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glObjectLabelKHR, (GLenum identifier, GLuint name, GLsizei length, const GLchar *label))
#ifndef glObjectPtrLabelKHR
#define glObjectPtrLabelKHR(ptr, length, label) glatter_glObjectPtrLabelKHR((ptr), (length), (label))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glObjectPtrLabelKHR, (const void *ptr, GLsizei length, const GLchar *label))
#ifndef glPopDebugGroupKHR
#define glPopDebugGroupKHR() glatter_glPopDebugGroupKHR()
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPopDebugGroupKHR, (void))
#ifndef glPushDebugGroupKHR
#define glPushDebugGroupKHR(source, id, length, message) glatter_glPushDebugGroupKHR((source), (id), (length), (message))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPushDebugGroupKHR, (GLenum source, GLuint id, GLsizei length, const GLchar *message))
#endif // defined(GL_KHR_debug)
#if defined(GL_KHR_parallel_shader_compile)
#ifndef glMaxShaderCompilerThreadsKHR
#define glMaxShaderCompilerThreadsKHR(count) glatter_glMaxShaderCompilerThreadsKHR((count))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMaxShaderCompilerThreadsKHR, (GLuint count))
#endif // defined(GL_KHR_parallel_shader_compile)
#if defined(GL_KHR_robustness)
#ifndef glGetGraphicsResetStatusKHR
#define glGetGraphicsResetStatusKHR() glatter_glGetGraphicsResetStatusKHR()
#endif
GLATTER_UBLOCK(GLenum, GL_APIENTRY, glGetGraphicsResetStatusKHR, (void))
#ifndef glGetnUniformfvKHR
#define glGetnUniformfvKHR(program, location, bufSize, params) glatter_glGetnUniformfvKHR((program), (location), (bufSize), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetnUniformfvKHR, (GLuint program, GLint location, GLsizei bufSize, GLfloat *params))
#ifndef glGetnUniformivKHR
#define glGetnUniformivKHR(program, location, bufSize, params) glatter_glGetnUniformivKHR((program), (location), (bufSize), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetnUniformivKHR, (GLuint program, GLint location, GLsizei bufSize, GLint *params))
#ifndef glGetnUniformuivKHR
#define glGetnUniformuivKHR(program, location, bufSize, params) glatter_glGetnUniformuivKHR((program), (location), (bufSize), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetnUniformuivKHR, (GLuint program, GLint location, GLsizei bufSize, GLuint *params))
#ifndef glReadnPixelsKHR
#define glReadnPixelsKHR(x, y, width, height, format, type, bufSize, data) glatter_glReadnPixelsKHR((x), (y), (width), (height), (format), (type), (bufSize), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glReadnPixelsKHR, (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data))
#endif // defined(GL_KHR_robustness)
#if defined(GL_NV_bindless_texture)
#ifndef glGetImageHandleNV
#define glGetImageHandleNV(texture, level, layered, layer, format) glatter_glGetImageHandleNV((texture), (level), (layered), (layer), (format))
#endif
GLATTER_UBLOCK(GLuint64, GL_APIENTRY, glGetImageHandleNV, (GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format))
#ifndef glGetTextureHandleNV
#define glGetTextureHandleNV(texture) glatter_glGetTextureHandleNV((texture))
#endif
GLATTER_UBLOCK(GLuint64, GL_APIENTRY, glGetTextureHandleNV, (GLuint texture))
#ifndef glGetTextureSamplerHandleNV
#define glGetTextureSamplerHandleNV(texture, sampler) glatter_glGetTextureSamplerHandleNV((texture), (sampler))
#endif
GLATTER_UBLOCK(GLuint64, GL_APIENTRY, glGetTextureSamplerHandleNV, (GLuint texture, GLuint sampler))
#ifndef glIsImageHandleResidentNV
#define glIsImageHandleResidentNV(handle) glatter_glIsImageHandleResidentNV((handle))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsImageHandleResidentNV, (GLuint64 handle))
#ifndef glIsTextureHandleResidentNV
#define glIsTextureHandleResidentNV(handle) glatter_glIsTextureHandleResidentNV((handle))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsTextureHandleResidentNV, (GLuint64 handle))
#ifndef glMakeImageHandleNonResidentNV
#define glMakeImageHandleNonResidentNV(handle) glatter_glMakeImageHandleNonResidentNV((handle))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMakeImageHandleNonResidentNV, (GLuint64 handle))
#ifndef glMakeImageHandleResidentNV
#define glMakeImageHandleResidentNV(handle, access) glatter_glMakeImageHandleResidentNV((handle), (access))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMakeImageHandleResidentNV, (GLuint64 handle, GLenum access))
#ifndef glMakeTextureHandleNonResidentNV
#define glMakeTextureHandleNonResidentNV(handle) glatter_glMakeTextureHandleNonResidentNV((handle))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMakeTextureHandleNonResidentNV, (GLuint64 handle))
#ifndef glMakeTextureHandleResidentNV
#define glMakeTextureHandleResidentNV(handle) glatter_glMakeTextureHandleResidentNV((handle))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMakeTextureHandleResidentNV, (GLuint64 handle))
#ifndef glProgramUniformHandleui64NV
#define glProgramUniformHandleui64NV(program, location, value) glatter_glProgramUniformHandleui64NV((program), (location), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniformHandleui64NV, (GLuint program, GLint location, GLuint64 value))
#ifndef glProgramUniformHandleui64vNV
#define glProgramUniformHandleui64vNV(program, location, count, values) glatter_glProgramUniformHandleui64vNV((program), (location), (count), (values))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniformHandleui64vNV, (GLuint program, GLint location, GLsizei count, const GLuint64 *values))
#ifndef glUniformHandleui64NV
#define glUniformHandleui64NV(location, value) glatter_glUniformHandleui64NV((location), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniformHandleui64NV, (GLint location, GLuint64 value))
#ifndef glUniformHandleui64vNV
#define glUniformHandleui64vNV(location, count, value) glatter_glUniformHandleui64vNV((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniformHandleui64vNV, (GLint location, GLsizei count, const GLuint64 *value))
#endif // defined(GL_NV_bindless_texture)
#if defined(GL_NV_blend_equation_advanced)
#ifndef glBlendBarrierNV
#define glBlendBarrierNV() glatter_glBlendBarrierNV()
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendBarrierNV, (void))
#ifndef glBlendParameteriNV
#define glBlendParameteriNV(pname, value) glatter_glBlendParameteriNV((pname), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendParameteriNV, (GLenum pname, GLint value))
#endif // defined(GL_NV_blend_equation_advanced)
#if defined(GL_NV_clip_space_w_scaling)
#ifndef glViewportPositionWScaleNV
#define glViewportPositionWScaleNV(index, xcoeff, ycoeff) glatter_glViewportPositionWScaleNV((index), (xcoeff), (ycoeff))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glViewportPositionWScaleNV, (GLuint index, GLfloat xcoeff, GLfloat ycoeff))
#endif // defined(GL_NV_clip_space_w_scaling)
#if defined(GL_NV_conditional_render)
#ifndef glBeginConditionalRenderNV
#define glBeginConditionalRenderNV(id, mode) glatter_glBeginConditionalRenderNV((id), (mode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBeginConditionalRenderNV, (GLuint id, GLenum mode))
#ifndef glEndConditionalRenderNV
#define glEndConditionalRenderNV() glatter_glEndConditionalRenderNV()
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEndConditionalRenderNV, (void))
#endif // defined(GL_NV_conditional_render)
#if defined(GL_NV_conservative_raster)
#ifndef glSubpixelPrecisionBiasNV
#define glSubpixelPrecisionBiasNV(xbits, ybits) glatter_glSubpixelPrecisionBiasNV((xbits), (ybits))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glSubpixelPrecisionBiasNV, (GLuint xbits, GLuint ybits))
#endif // defined(GL_NV_conservative_raster)
#if defined(GL_NV_conservative_raster_pre_snap_triangles)
#ifndef glConservativeRasterParameteriNV
#define glConservativeRasterParameteriNV(pname, param) glatter_glConservativeRasterParameteriNV((pname), (param))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glConservativeRasterParameteriNV, (GLenum pname, GLint param))
#endif // defined(GL_NV_conservative_raster_pre_snap_triangles)
#if defined(GL_NV_copy_buffer)
#ifndef glCopyBufferSubDataNV
#define glCopyBufferSubDataNV(readTarget, writeTarget, readOffset, writeOffset, size) glatter_glCopyBufferSubDataNV((readTarget), (writeTarget), (readOffset), (writeOffset), (size))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCopyBufferSubDataNV, (GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size))
#endif // defined(GL_NV_copy_buffer)
#if defined(GL_NV_coverage_sample)
#ifndef glCoverageMaskNV
#define glCoverageMaskNV(mask) glatter_glCoverageMaskNV((mask))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCoverageMaskNV, (GLboolean mask))
#ifndef glCoverageOperationNV
#define glCoverageOperationNV(operation) glatter_glCoverageOperationNV((operation))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCoverageOperationNV, (GLenum operation))
#endif // defined(GL_NV_coverage_sample)
#if defined(GL_NV_draw_buffers)
#ifndef glDrawBuffersNV
#define glDrawBuffersNV(n, bufs) glatter_glDrawBuffersNV((n), (bufs))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawBuffersNV, (GLsizei n, const GLenum *bufs))
#endif // defined(GL_NV_draw_buffers)
#if defined(GL_NV_draw_instanced)
#ifndef glDrawArraysInstancedNV
#define glDrawArraysInstancedNV(mode, first, count, primcount) glatter_glDrawArraysInstancedNV((mode), (first), (count), (primcount))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawArraysInstancedNV, (GLenum mode, GLint first, GLsizei count, GLsizei primcount))
#ifndef glDrawElementsInstancedNV
#define glDrawElementsInstancedNV(mode, count, type, indices, primcount) glatter_glDrawElementsInstancedNV((mode), (count), (type), (indices), (primcount))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawElementsInstancedNV, (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount))
#endif // defined(GL_NV_draw_instanced)
#if defined(GL_NV_draw_vulkan_image)
#ifndef glDrawVkImageNV
#define glDrawVkImageNV(vkImage, sampler, x0, y0, x1, y1, z, s0, t0, s1, t1) glatter_glDrawVkImageNV((vkImage), (sampler), (x0), (y0), (x1), (y1), (z), (s0), (t0), (s1), (t1))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawVkImageNV, (GLuint64 vkImage, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1))
#ifndef glGetVkProcAddrNV
#define glGetVkProcAddrNV(name) glatter_glGetVkProcAddrNV((name))
#endif
GLATTER_UBLOCK(GLVULKANPROCNV, GL_APIENTRY, glGetVkProcAddrNV, (const GLchar *name))
#ifndef glSignalVkFenceNV
#define glSignalVkFenceNV(vkFence) glatter_glSignalVkFenceNV((vkFence))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glSignalVkFenceNV, (GLuint64 vkFence))
#ifndef glSignalVkSemaphoreNV
#define glSignalVkSemaphoreNV(vkSemaphore) glatter_glSignalVkSemaphoreNV((vkSemaphore))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glSignalVkSemaphoreNV, (GLuint64 vkSemaphore))
#ifndef glWaitVkSemaphoreNV
#define glWaitVkSemaphoreNV(vkSemaphore) glatter_glWaitVkSemaphoreNV((vkSemaphore))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glWaitVkSemaphoreNV, (GLuint64 vkSemaphore))
#endif // defined(GL_NV_draw_vulkan_image)
#if defined(GL_NV_fence)
#ifndef glDeleteFencesNV
#define glDeleteFencesNV(n, fences) glatter_glDeleteFencesNV((n), (fences))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeleteFencesNV, (GLsizei n, const GLuint *fences))
#ifndef glFinishFenceNV
#define glFinishFenceNV(fence) glatter_glFinishFenceNV((fence))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFinishFenceNV, (GLuint fence))
#ifndef glGenFencesNV
#define glGenFencesNV(n, fences) glatter_glGenFencesNV((n), (fences))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGenFencesNV, (GLsizei n, GLuint *fences))
#ifndef glGetFenceivNV
#define glGetFenceivNV(fence, pname, params) glatter_glGetFenceivNV((fence), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetFenceivNV, (GLuint fence, GLenum pname, GLint *params))
#ifndef glIsFenceNV
#define glIsFenceNV(fence) glatter_glIsFenceNV((fence))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsFenceNV, (GLuint fence))
#ifndef glSetFenceNV
#define glSetFenceNV(fence, condition) glatter_glSetFenceNV((fence), (condition))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glSetFenceNV, (GLuint fence, GLenum condition))
#ifndef glTestFenceNV
#define glTestFenceNV(fence) glatter_glTestFenceNV((fence))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glTestFenceNV, (GLuint fence))
#endif // defined(GL_NV_fence)
#if defined(GL_NV_fragment_coverage_to_color)
#ifndef glFragmentCoverageColorNV
#define glFragmentCoverageColorNV(color) glatter_glFragmentCoverageColorNV((color))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFragmentCoverageColorNV, (GLuint color))
#endif // defined(GL_NV_fragment_coverage_to_color)
#if defined(GL_NV_framebuffer_blit)
#ifndef glBlitFramebufferNV
#define glBlitFramebufferNV(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter) glatter_glBlitFramebufferNV((srcX0), (srcY0), (srcX1), (srcY1), (dstX0), (dstY0), (dstX1), (dstY1), (mask), (filter))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlitFramebufferNV, (GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter))
#endif // defined(GL_NV_framebuffer_blit)
#if defined(GL_NV_framebuffer_mixed_samples)
#ifndef glCoverageModulationNV
#define glCoverageModulationNV(components) glatter_glCoverageModulationNV((components))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCoverageModulationNV, (GLenum components))
#ifndef glCoverageModulationTableNV
#define glCoverageModulationTableNV(n, v) glatter_glCoverageModulationTableNV((n), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCoverageModulationTableNV, (GLsizei n, const GLfloat *v))
#ifndef glGetCoverageModulationTableNV
#define glGetCoverageModulationTableNV(bufsize, v) glatter_glGetCoverageModulationTableNV((bufsize), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetCoverageModulationTableNV, (GLsizei bufsize, GLfloat *v))
#endif // defined(GL_NV_framebuffer_mixed_samples)
#if defined(GL_NV_framebuffer_multisample)
#ifndef glRenderbufferStorageMultisampleNV
#define glRenderbufferStorageMultisampleNV(target, samples, internalformat, width, height) glatter_glRenderbufferStorageMultisampleNV((target), (samples), (internalformat), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glRenderbufferStorageMultisampleNV, (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
#endif // defined(GL_NV_framebuffer_multisample)
#if defined(GL_NV_gpu_shader5)
#ifndef glGetUniformi64vNV
#define glGetUniformi64vNV(program, location, params) glatter_glGetUniformi64vNV((program), (location), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetUniformi64vNV, (GLuint program, GLint location, GLint64EXT *params))
#ifndef glProgramUniform1i64NV
#define glProgramUniform1i64NV(program, location, x) glatter_glProgramUniform1i64NV((program), (location), (x))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform1i64NV, (GLuint program, GLint location, GLint64EXT x))
#ifndef glProgramUniform1i64vNV
#define glProgramUniform1i64vNV(program, location, count, value) glatter_glProgramUniform1i64vNV((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform1i64vNV, (GLuint program, GLint location, GLsizei count, const GLint64EXT *value))
#ifndef glProgramUniform1ui64NV
#define glProgramUniform1ui64NV(program, location, x) glatter_glProgramUniform1ui64NV((program), (location), (x))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform1ui64NV, (GLuint program, GLint location, GLuint64EXT x))
#ifndef glProgramUniform1ui64vNV
#define glProgramUniform1ui64vNV(program, location, count, value) glatter_glProgramUniform1ui64vNV((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform1ui64vNV, (GLuint program, GLint location, GLsizei count, const GLuint64EXT *value))
#ifndef glProgramUniform2i64NV
#define glProgramUniform2i64NV(program, location, x, y) glatter_glProgramUniform2i64NV((program), (location), (x), (y))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform2i64NV, (GLuint program, GLint location, GLint64EXT x, GLint64EXT y))
#ifndef glProgramUniform2i64vNV
#define glProgramUniform2i64vNV(program, location, count, value) glatter_glProgramUniform2i64vNV((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform2i64vNV, (GLuint program, GLint location, GLsizei count, const GLint64EXT *value))
#ifndef glProgramUniform2ui64NV
#define glProgramUniform2ui64NV(program, location, x, y) glatter_glProgramUniform2ui64NV((program), (location), (x), (y))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform2ui64NV, (GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y))
#ifndef glProgramUniform2ui64vNV
#define glProgramUniform2ui64vNV(program, location, count, value) glatter_glProgramUniform2ui64vNV((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform2ui64vNV, (GLuint program, GLint location, GLsizei count, const GLuint64EXT *value))
#ifndef glProgramUniform3i64NV
#define glProgramUniform3i64NV(program, location, x, y, z) glatter_glProgramUniform3i64NV((program), (location), (x), (y), (z))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform3i64NV, (GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z))
#ifndef glProgramUniform3i64vNV
#define glProgramUniform3i64vNV(program, location, count, value) glatter_glProgramUniform3i64vNV((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform3i64vNV, (GLuint program, GLint location, GLsizei count, const GLint64EXT *value))
#ifndef glProgramUniform3ui64NV
#define glProgramUniform3ui64NV(program, location, x, y, z) glatter_glProgramUniform3ui64NV((program), (location), (x), (y), (z))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform3ui64NV, (GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z))
#ifndef glProgramUniform3ui64vNV
#define glProgramUniform3ui64vNV(program, location, count, value) glatter_glProgramUniform3ui64vNV((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform3ui64vNV, (GLuint program, GLint location, GLsizei count, const GLuint64EXT *value))
#ifndef glProgramUniform4i64NV
#define glProgramUniform4i64NV(program, location, x, y, z, w) glatter_glProgramUniform4i64NV((program), (location), (x), (y), (z), (w))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform4i64NV, (GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w))
#ifndef glProgramUniform4i64vNV
#define glProgramUniform4i64vNV(program, location, count, value) glatter_glProgramUniform4i64vNV((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform4i64vNV, (GLuint program, GLint location, GLsizei count, const GLint64EXT *value))
#ifndef glProgramUniform4ui64NV
#define glProgramUniform4ui64NV(program, location, x, y, z, w) glatter_glProgramUniform4ui64NV((program), (location), (x), (y), (z), (w))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform4ui64NV, (GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w))
#ifndef glProgramUniform4ui64vNV
#define glProgramUniform4ui64vNV(program, location, count, value) glatter_glProgramUniform4ui64vNV((program), (location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramUniform4ui64vNV, (GLuint program, GLint location, GLsizei count, const GLuint64EXT *value))
#ifndef glUniform1i64NV
#define glUniform1i64NV(location, x) glatter_glUniform1i64NV((location), (x))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform1i64NV, (GLint location, GLint64EXT x))
#ifndef glUniform1i64vNV
#define glUniform1i64vNV(location, count, value) glatter_glUniform1i64vNV((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform1i64vNV, (GLint location, GLsizei count, const GLint64EXT *value))
#ifndef glUniform1ui64NV
#define glUniform1ui64NV(location, x) glatter_glUniform1ui64NV((location), (x))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform1ui64NV, (GLint location, GLuint64EXT x))
#ifndef glUniform1ui64vNV
#define glUniform1ui64vNV(location, count, value) glatter_glUniform1ui64vNV((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform1ui64vNV, (GLint location, GLsizei count, const GLuint64EXT *value))
#ifndef glUniform2i64NV
#define glUniform2i64NV(location, x, y) glatter_glUniform2i64NV((location), (x), (y))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform2i64NV, (GLint location, GLint64EXT x, GLint64EXT y))
#ifndef glUniform2i64vNV
#define glUniform2i64vNV(location, count, value) glatter_glUniform2i64vNV((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform2i64vNV, (GLint location, GLsizei count, const GLint64EXT *value))
#ifndef glUniform2ui64NV
#define glUniform2ui64NV(location, x, y) glatter_glUniform2ui64NV((location), (x), (y))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform2ui64NV, (GLint location, GLuint64EXT x, GLuint64EXT y))
#ifndef glUniform2ui64vNV
#define glUniform2ui64vNV(location, count, value) glatter_glUniform2ui64vNV((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform2ui64vNV, (GLint location, GLsizei count, const GLuint64EXT *value))
#ifndef glUniform3i64NV
#define glUniform3i64NV(location, x, y, z) glatter_glUniform3i64NV((location), (x), (y), (z))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform3i64NV, (GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z))
#ifndef glUniform3i64vNV
#define glUniform3i64vNV(location, count, value) glatter_glUniform3i64vNV((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform3i64vNV, (GLint location, GLsizei count, const GLint64EXT *value))
#ifndef glUniform3ui64NV
#define glUniform3ui64NV(location, x, y, z) glatter_glUniform3ui64NV((location), (x), (y), (z))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform3ui64NV, (GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z))
#ifndef glUniform3ui64vNV
#define glUniform3ui64vNV(location, count, value) glatter_glUniform3ui64vNV((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform3ui64vNV, (GLint location, GLsizei count, const GLuint64EXT *value))
#ifndef glUniform4i64NV
#define glUniform4i64NV(location, x, y, z, w) glatter_glUniform4i64NV((location), (x), (y), (z), (w))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform4i64NV, (GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w))
#ifndef glUniform4i64vNV
#define glUniform4i64vNV(location, count, value) glatter_glUniform4i64vNV((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform4i64vNV, (GLint location, GLsizei count, const GLint64EXT *value))
#ifndef glUniform4ui64NV
#define glUniform4ui64NV(location, x, y, z, w) glatter_glUniform4ui64NV((location), (x), (y), (z), (w))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform4ui64NV, (GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w))
#ifndef glUniform4ui64vNV
#define glUniform4ui64vNV(location, count, value) glatter_glUniform4ui64vNV((location), (count), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniform4ui64vNV, (GLint location, GLsizei count, const GLuint64EXT *value))
#endif // defined(GL_NV_gpu_shader5)
#if defined(GL_NV_instanced_arrays)
#ifndef glVertexAttribDivisorNV
#define glVertexAttribDivisorNV(index, divisor) glatter_glVertexAttribDivisorNV((index), (divisor))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glVertexAttribDivisorNV, (GLuint index, GLuint divisor))
#endif // defined(GL_NV_instanced_arrays)
#if defined(GL_NV_internalformat_sample_query)
#ifndef glGetInternalformatSampleivNV
#define glGetInternalformatSampleivNV(target, internalformat, samples, pname, bufSize, params) glatter_glGetInternalformatSampleivNV((target), (internalformat), (samples), (pname), (bufSize), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetInternalformatSampleivNV, (GLenum target, GLenum internalformat, GLsizei samples, GLenum pname, GLsizei bufSize, GLint *params))
#endif // defined(GL_NV_internalformat_sample_query)
#if defined(GL_NV_non_square_matrices)
#ifndef glUniformMatrix2x3fvNV
#define glUniformMatrix2x3fvNV(location, count, transpose, value) glatter_glUniformMatrix2x3fvNV((location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniformMatrix2x3fvNV, (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glUniformMatrix2x4fvNV
#define glUniformMatrix2x4fvNV(location, count, transpose, value) glatter_glUniformMatrix2x4fvNV((location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniformMatrix2x4fvNV, (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glUniformMatrix3x2fvNV
#define glUniformMatrix3x2fvNV(location, count, transpose, value) glatter_glUniformMatrix3x2fvNV((location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniformMatrix3x2fvNV, (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glUniformMatrix3x4fvNV
#define glUniformMatrix3x4fvNV(location, count, transpose, value) glatter_glUniformMatrix3x4fvNV((location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniformMatrix3x4fvNV, (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glUniformMatrix4x2fvNV
#define glUniformMatrix4x2fvNV(location, count, transpose, value) glatter_glUniformMatrix4x2fvNV((location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniformMatrix4x2fvNV, (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#ifndef glUniformMatrix4x3fvNV
#define glUniformMatrix4x3fvNV(location, count, transpose, value) glatter_glUniformMatrix4x3fvNV((location), (count), (transpose), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glUniformMatrix4x3fvNV, (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
#endif // defined(GL_NV_non_square_matrices)
#if defined(GL_NV_path_rendering)
#ifndef glCopyPathNV
#define glCopyPathNV(resultPath, srcPath) glatter_glCopyPathNV((resultPath), (srcPath))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCopyPathNV, (GLuint resultPath, GLuint srcPath))
#ifndef glCoverFillPathInstancedNV
#define glCoverFillPathInstancedNV(numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues) glatter_glCoverFillPathInstancedNV((numPaths), (pathNameType), (paths), (pathBase), (coverMode), (transformType), (transformValues))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCoverFillPathInstancedNV, (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues))
#ifndef glCoverFillPathNV
#define glCoverFillPathNV(path, coverMode) glatter_glCoverFillPathNV((path), (coverMode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCoverFillPathNV, (GLuint path, GLenum coverMode))
#ifndef glCoverStrokePathInstancedNV
#define glCoverStrokePathInstancedNV(numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues) glatter_glCoverStrokePathInstancedNV((numPaths), (pathNameType), (paths), (pathBase), (coverMode), (transformType), (transformValues))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCoverStrokePathInstancedNV, (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues))
#ifndef glCoverStrokePathNV
#define glCoverStrokePathNV(path, coverMode) glatter_glCoverStrokePathNV((path), (coverMode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCoverStrokePathNV, (GLuint path, GLenum coverMode))
#ifndef glDeletePathsNV
#define glDeletePathsNV(path, range) glatter_glDeletePathsNV((path), (range))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeletePathsNV, (GLuint path, GLsizei range))
#ifndef glGenPathsNV
#define glGenPathsNV(range) glatter_glGenPathsNV((range))
#endif
GLATTER_UBLOCK(GLuint, GL_APIENTRY, glGenPathsNV, (GLsizei range))
#ifndef glGetPathCommandsNV
#define glGetPathCommandsNV(path, commands) glatter_glGetPathCommandsNV((path), (commands))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPathCommandsNV, (GLuint path, GLubyte *commands))
#ifndef glGetPathCoordsNV
#define glGetPathCoordsNV(path, coords) glatter_glGetPathCoordsNV((path), (coords))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPathCoordsNV, (GLuint path, GLfloat *coords))
#ifndef glGetPathDashArrayNV
#define glGetPathDashArrayNV(path, dashArray) glatter_glGetPathDashArrayNV((path), (dashArray))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPathDashArrayNV, (GLuint path, GLfloat *dashArray))
#ifndef glGetPathLengthNV
#define glGetPathLengthNV(path, startSegment, numSegments) glatter_glGetPathLengthNV((path), (startSegment), (numSegments))
#endif
GLATTER_UBLOCK(GLfloat, GL_APIENTRY, glGetPathLengthNV, (GLuint path, GLsizei startSegment, GLsizei numSegments))
#ifndef glGetPathMetricRangeNV
#define glGetPathMetricRangeNV(metricQueryMask, firstPathName, numPaths, stride, metrics) glatter_glGetPathMetricRangeNV((metricQueryMask), (firstPathName), (numPaths), (stride), (metrics))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPathMetricRangeNV, (GLbitfield metricQueryMask, GLuint firstPathName, GLsizei numPaths, GLsizei stride, GLfloat *metrics))
#ifndef glGetPathMetricsNV
#define glGetPathMetricsNV(metricQueryMask, numPaths, pathNameType, paths, pathBase, stride, metrics) glatter_glGetPathMetricsNV((metricQueryMask), (numPaths), (pathNameType), (paths), (pathBase), (stride), (metrics))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPathMetricsNV, (GLbitfield metricQueryMask, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLsizei stride, GLfloat *metrics))
#ifndef glGetPathParameterfvNV
#define glGetPathParameterfvNV(path, pname, value) glatter_glGetPathParameterfvNV((path), (pname), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPathParameterfvNV, (GLuint path, GLenum pname, GLfloat *value))
#ifndef glGetPathParameterivNV
#define glGetPathParameterivNV(path, pname, value) glatter_glGetPathParameterivNV((path), (pname), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPathParameterivNV, (GLuint path, GLenum pname, GLint *value))
#ifndef glGetPathSpacingNV
#define glGetPathSpacingNV(pathListMode, numPaths, pathNameType, paths, pathBase, advanceScale, kerningScale, transformType, returnedSpacing) glatter_glGetPathSpacingNV((pathListMode), (numPaths), (pathNameType), (paths), (pathBase), (advanceScale), (kerningScale), (transformType), (returnedSpacing))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetPathSpacingNV, (GLenum pathListMode, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLfloat advanceScale, GLfloat kerningScale, GLenum transformType, GLfloat *returnedSpacing))
#ifndef glGetProgramResourcefvNV
#define glGetProgramResourcefvNV(program, programInterface, index, propCount, props, bufSize, length, params) glatter_glGetProgramResourcefvNV((program), (programInterface), (index), (propCount), (props), (bufSize), (length), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetProgramResourcefvNV, (GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLfloat *params))
#ifndef glInterpolatePathsNV
#define glInterpolatePathsNV(resultPath, pathA, pathB, weight) glatter_glInterpolatePathsNV((resultPath), (pathA), (pathB), (weight))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glInterpolatePathsNV, (GLuint resultPath, GLuint pathA, GLuint pathB, GLfloat weight))
#ifndef glIsPathNV
#define glIsPathNV(path) glatter_glIsPathNV((path))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsPathNV, (GLuint path))
#ifndef glIsPointInFillPathNV
#define glIsPointInFillPathNV(path, mask, x, y) glatter_glIsPointInFillPathNV((path), (mask), (x), (y))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsPointInFillPathNV, (GLuint path, GLuint mask, GLfloat x, GLfloat y))
#ifndef glIsPointInStrokePathNV
#define glIsPointInStrokePathNV(path, x, y) glatter_glIsPointInStrokePathNV((path), (x), (y))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsPointInStrokePathNV, (GLuint path, GLfloat x, GLfloat y))
#ifndef glMatrixFrustumEXT
#define glMatrixFrustumEXT(mode, left, right, bottom, top, zNear, zFar) glatter_glMatrixFrustumEXT((mode), (left), (right), (bottom), (top), (zNear), (zFar))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixFrustumEXT, (GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
#ifndef glMatrixLoad3x2fNV
#define glMatrixLoad3x2fNV(matrixMode, m) glatter_glMatrixLoad3x2fNV((matrixMode), (m))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixLoad3x2fNV, (GLenum matrixMode, const GLfloat *m))
#ifndef glMatrixLoad3x3fNV
#define glMatrixLoad3x3fNV(matrixMode, m) glatter_glMatrixLoad3x3fNV((matrixMode), (m))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixLoad3x3fNV, (GLenum matrixMode, const GLfloat *m))
#ifndef glMatrixLoadIdentityEXT
#define glMatrixLoadIdentityEXT(mode) glatter_glMatrixLoadIdentityEXT((mode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixLoadIdentityEXT, (GLenum mode))
#ifndef glMatrixLoadTranspose3x3fNV
#define glMatrixLoadTranspose3x3fNV(matrixMode, m) glatter_glMatrixLoadTranspose3x3fNV((matrixMode), (m))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixLoadTranspose3x3fNV, (GLenum matrixMode, const GLfloat *m))
#ifndef glMatrixLoadTransposedEXT
#define glMatrixLoadTransposedEXT(mode, m) glatter_glMatrixLoadTransposedEXT((mode), (m))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixLoadTransposedEXT, (GLenum mode, const GLdouble *m))
#ifndef glMatrixLoadTransposefEXT
#define glMatrixLoadTransposefEXT(mode, m) glatter_glMatrixLoadTransposefEXT((mode), (m))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixLoadTransposefEXT, (GLenum mode, const GLfloat *m))
#ifndef glMatrixLoaddEXT
#define glMatrixLoaddEXT(mode, m) glatter_glMatrixLoaddEXT((mode), (m))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixLoaddEXT, (GLenum mode, const GLdouble *m))
#ifndef glMatrixLoadfEXT
#define glMatrixLoadfEXT(mode, m) glatter_glMatrixLoadfEXT((mode), (m))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixLoadfEXT, (GLenum mode, const GLfloat *m))
#ifndef glMatrixMult3x2fNV
#define glMatrixMult3x2fNV(matrixMode, m) glatter_glMatrixMult3x2fNV((matrixMode), (m))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixMult3x2fNV, (GLenum matrixMode, const GLfloat *m))
#ifndef glMatrixMult3x3fNV
#define glMatrixMult3x3fNV(matrixMode, m) glatter_glMatrixMult3x3fNV((matrixMode), (m))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixMult3x3fNV, (GLenum matrixMode, const GLfloat *m))
#ifndef glMatrixMultTranspose3x3fNV
#define glMatrixMultTranspose3x3fNV(matrixMode, m) glatter_glMatrixMultTranspose3x3fNV((matrixMode), (m))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixMultTranspose3x3fNV, (GLenum matrixMode, const GLfloat *m))
#ifndef glMatrixMultTransposedEXT
#define glMatrixMultTransposedEXT(mode, m) glatter_glMatrixMultTransposedEXT((mode), (m))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixMultTransposedEXT, (GLenum mode, const GLdouble *m))
#ifndef glMatrixMultTransposefEXT
#define glMatrixMultTransposefEXT(mode, m) glatter_glMatrixMultTransposefEXT((mode), (m))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixMultTransposefEXT, (GLenum mode, const GLfloat *m))
#ifndef glMatrixMultdEXT
#define glMatrixMultdEXT(mode, m) glatter_glMatrixMultdEXT((mode), (m))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixMultdEXT, (GLenum mode, const GLdouble *m))
#ifndef glMatrixMultfEXT
#define glMatrixMultfEXT(mode, m) glatter_glMatrixMultfEXT((mode), (m))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixMultfEXT, (GLenum mode, const GLfloat *m))
#ifndef glMatrixOrthoEXT
#define glMatrixOrthoEXT(mode, left, right, bottom, top, zNear, zFar) glatter_glMatrixOrthoEXT((mode), (left), (right), (bottom), (top), (zNear), (zFar))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixOrthoEXT, (GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
#ifndef glMatrixPopEXT
#define glMatrixPopEXT(mode) glatter_glMatrixPopEXT((mode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixPopEXT, (GLenum mode))
#ifndef glMatrixPushEXT
#define glMatrixPushEXT(mode) glatter_glMatrixPushEXT((mode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixPushEXT, (GLenum mode))
#ifndef glMatrixRotatedEXT
#define glMatrixRotatedEXT(mode, angle, x, y, z) glatter_glMatrixRotatedEXT((mode), (angle), (x), (y), (z))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixRotatedEXT, (GLenum mode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z))
#ifndef glMatrixRotatefEXT
#define glMatrixRotatefEXT(mode, angle, x, y, z) glatter_glMatrixRotatefEXT((mode), (angle), (x), (y), (z))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixRotatefEXT, (GLenum mode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z))
#ifndef glMatrixScaledEXT
#define glMatrixScaledEXT(mode, x, y, z) glatter_glMatrixScaledEXT((mode), (x), (y), (z))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixScaledEXT, (GLenum mode, GLdouble x, GLdouble y, GLdouble z))
#ifndef glMatrixScalefEXT
#define glMatrixScalefEXT(mode, x, y, z) glatter_glMatrixScalefEXT((mode), (x), (y), (z))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixScalefEXT, (GLenum mode, GLfloat x, GLfloat y, GLfloat z))
#ifndef glMatrixTranslatedEXT
#define glMatrixTranslatedEXT(mode, x, y, z) glatter_glMatrixTranslatedEXT((mode), (x), (y), (z))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixTranslatedEXT, (GLenum mode, GLdouble x, GLdouble y, GLdouble z))
#ifndef glMatrixTranslatefEXT
#define glMatrixTranslatefEXT(mode, x, y, z) glatter_glMatrixTranslatefEXT((mode), (x), (y), (z))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMatrixTranslatefEXT, (GLenum mode, GLfloat x, GLfloat y, GLfloat z))
#ifndef glPathCommandsNV
#define glPathCommandsNV(path, numCommands, commands, numCoords, coordType, coords) glatter_glPathCommandsNV((path), (numCommands), (commands), (numCoords), (coordType), (coords))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathCommandsNV, (GLuint path, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords))
#ifndef glPathCoordsNV
#define glPathCoordsNV(path, numCoords, coordType, coords) glatter_glPathCoordsNV((path), (numCoords), (coordType), (coords))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathCoordsNV, (GLuint path, GLsizei numCoords, GLenum coordType, const void *coords))
#ifndef glPathCoverDepthFuncNV
#define glPathCoverDepthFuncNV(func) glatter_glPathCoverDepthFuncNV((func))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathCoverDepthFuncNV, (GLenum func))
#ifndef glPathDashArrayNV
#define glPathDashArrayNV(path, dashCount, dashArray) glatter_glPathDashArrayNV((path), (dashCount), (dashArray))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathDashArrayNV, (GLuint path, GLsizei dashCount, const GLfloat *dashArray))
#ifndef glPathGlyphIndexArrayNV
#define glPathGlyphIndexArrayNV(firstPathName, fontTarget, fontName, fontStyle, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale) glatter_glPathGlyphIndexArrayNV((firstPathName), (fontTarget), (fontName), (fontStyle), (firstGlyphIndex), (numGlyphs), (pathParameterTemplate), (emScale))
#endif
GLATTER_UBLOCK(GLenum, GL_APIENTRY, glPathGlyphIndexArrayNV, (GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyphIndex, GLsizei numGlyphs, GLuint pathParameterTemplate, GLfloat emScale))
#ifndef glPathGlyphIndexRangeNV
#define glPathGlyphIndexRangeNV(fontTarget, fontName, fontStyle, pathParameterTemplate, emScale, baseAndCount) glatter_glPathGlyphIndexRangeNV((fontTarget), (fontName), (fontStyle), (pathParameterTemplate), (emScale), (baseAndCount))
#endif
GLATTER_UBLOCK(GLenum, GL_APIENTRY, glPathGlyphIndexRangeNV, (GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint pathParameterTemplate, GLfloat emScale, GLuint baseAndCount[2]))
#ifndef glPathGlyphRangeNV
#define glPathGlyphRangeNV(firstPathName, fontTarget, fontName, fontStyle, firstGlyph, numGlyphs, handleMissingGlyphs, pathParameterTemplate, emScale) glatter_glPathGlyphRangeNV((firstPathName), (fontTarget), (fontName), (fontStyle), (firstGlyph), (numGlyphs), (handleMissingGlyphs), (pathParameterTemplate), (emScale))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathGlyphRangeNV, (GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyph, GLsizei numGlyphs, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale))
#ifndef glPathGlyphsNV
#define glPathGlyphsNV(firstPathName, fontTarget, fontName, fontStyle, numGlyphs, type, charcodes, handleMissingGlyphs, pathParameterTemplate, emScale) glatter_glPathGlyphsNV((firstPathName), (fontTarget), (fontName), (fontStyle), (numGlyphs), (type), (charcodes), (handleMissingGlyphs), (pathParameterTemplate), (emScale))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathGlyphsNV, (GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLsizei numGlyphs, GLenum type, const void *charcodes, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale))
#ifndef glPathMemoryGlyphIndexArrayNV
#define glPathMemoryGlyphIndexArrayNV(firstPathName, fontTarget, fontSize, fontData, faceIndex, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale) glatter_glPathMemoryGlyphIndexArrayNV((firstPathName), (fontTarget), (fontSize), (fontData), (faceIndex), (firstGlyphIndex), (numGlyphs), (pathParameterTemplate), (emScale))
#endif
GLATTER_UBLOCK(GLenum, GL_APIENTRY, glPathMemoryGlyphIndexArrayNV, (GLuint firstPathName, GLenum fontTarget, GLsizeiptr fontSize, const void *fontData, GLsizei faceIndex, GLuint firstGlyphIndex, GLsizei numGlyphs, GLuint pathParameterTemplate, GLfloat emScale))
#ifndef glPathParameterfNV
#define glPathParameterfNV(path, pname, value) glatter_glPathParameterfNV((path), (pname), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathParameterfNV, (GLuint path, GLenum pname, GLfloat value))
#ifndef glPathParameterfvNV
#define glPathParameterfvNV(path, pname, value) glatter_glPathParameterfvNV((path), (pname), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathParameterfvNV, (GLuint path, GLenum pname, const GLfloat *value))
#ifndef glPathParameteriNV
#define glPathParameteriNV(path, pname, value) glatter_glPathParameteriNV((path), (pname), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathParameteriNV, (GLuint path, GLenum pname, GLint value))
#ifndef glPathParameterivNV
#define glPathParameterivNV(path, pname, value) glatter_glPathParameterivNV((path), (pname), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathParameterivNV, (GLuint path, GLenum pname, const GLint *value))
#ifndef glPathStencilDepthOffsetNV
#define glPathStencilDepthOffsetNV(factor, units) glatter_glPathStencilDepthOffsetNV((factor), (units))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathStencilDepthOffsetNV, (GLfloat factor, GLfloat units))
#ifndef glPathStencilFuncNV
#define glPathStencilFuncNV(func, ref, mask) glatter_glPathStencilFuncNV((func), (ref), (mask))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathStencilFuncNV, (GLenum func, GLint ref, GLuint mask))
#ifndef glPathStringNV
#define glPathStringNV(path, format, length, pathString) glatter_glPathStringNV((path), (format), (length), (pathString))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathStringNV, (GLuint path, GLenum format, GLsizei length, const void *pathString))
#ifndef glPathSubCommandsNV
#define glPathSubCommandsNV(path, commandStart, commandsToDelete, numCommands, commands, numCoords, coordType, coords) glatter_glPathSubCommandsNV((path), (commandStart), (commandsToDelete), (numCommands), (commands), (numCoords), (coordType), (coords))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathSubCommandsNV, (GLuint path, GLsizei commandStart, GLsizei commandsToDelete, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords))
#ifndef glPathSubCoordsNV
#define glPathSubCoordsNV(path, coordStart, numCoords, coordType, coords) glatter_glPathSubCoordsNV((path), (coordStart), (numCoords), (coordType), (coords))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPathSubCoordsNV, (GLuint path, GLsizei coordStart, GLsizei numCoords, GLenum coordType, const void *coords))
#ifndef glPointAlongPathNV
#define glPointAlongPathNV(path, startSegment, numSegments, distance, x, y, tangentX, tangentY) glatter_glPointAlongPathNV((path), (startSegment), (numSegments), (distance), (x), (y), (tangentX), (tangentY))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glPointAlongPathNV, (GLuint path, GLsizei startSegment, GLsizei numSegments, GLfloat distance, GLfloat *x, GLfloat *y, GLfloat *tangentX, GLfloat *tangentY))
#ifndef glProgramPathFragmentInputGenNV
#define glProgramPathFragmentInputGenNV(program, location, genMode, components, coeffs) glatter_glProgramPathFragmentInputGenNV((program), (location), (genMode), (components), (coeffs))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramPathFragmentInputGenNV, (GLuint program, GLint location, GLenum genMode, GLint components, const GLfloat *coeffs))
#ifndef glStencilFillPathInstancedNV
#define glStencilFillPathInstancedNV(numPaths, pathNameType, paths, pathBase, fillMode, mask, transformType, transformValues) glatter_glStencilFillPathInstancedNV((numPaths), (pathNameType), (paths), (pathBase), (fillMode), (mask), (transformType), (transformValues))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStencilFillPathInstancedNV, (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum transformType, const GLfloat *transformValues))
#ifndef glStencilFillPathNV
#define glStencilFillPathNV(path, fillMode, mask) glatter_glStencilFillPathNV((path), (fillMode), (mask))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStencilFillPathNV, (GLuint path, GLenum fillMode, GLuint mask))
#ifndef glStencilStrokePathInstancedNV
#define glStencilStrokePathInstancedNV(numPaths, pathNameType, paths, pathBase, reference, mask, transformType, transformValues) glatter_glStencilStrokePathInstancedNV((numPaths), (pathNameType), (paths), (pathBase), (reference), (mask), (transformType), (transformValues))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStencilStrokePathInstancedNV, (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum transformType, const GLfloat *transformValues))
#ifndef glStencilStrokePathNV
#define glStencilStrokePathNV(path, reference, mask) glatter_glStencilStrokePathNV((path), (reference), (mask))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStencilStrokePathNV, (GLuint path, GLint reference, GLuint mask))
#ifndef glStencilThenCoverFillPathInstancedNV
#define glStencilThenCoverFillPathInstancedNV(numPaths, pathNameType, paths, pathBase, fillMode, mask, coverMode, transformType, transformValues) glatter_glStencilThenCoverFillPathInstancedNV((numPaths), (pathNameType), (paths), (pathBase), (fillMode), (mask), (coverMode), (transformType), (transformValues))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStencilThenCoverFillPathInstancedNV, (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum coverMode, GLenum transformType, const GLfloat *transformValues))
#ifndef glStencilThenCoverFillPathNV
#define glStencilThenCoverFillPathNV(path, fillMode, mask, coverMode) glatter_glStencilThenCoverFillPathNV((path), (fillMode), (mask), (coverMode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStencilThenCoverFillPathNV, (GLuint path, GLenum fillMode, GLuint mask, GLenum coverMode))
#ifndef glStencilThenCoverStrokePathInstancedNV
#define glStencilThenCoverStrokePathInstancedNV(numPaths, pathNameType, paths, pathBase, reference, mask, coverMode, transformType, transformValues) glatter_glStencilThenCoverStrokePathInstancedNV((numPaths), (pathNameType), (paths), (pathBase), (reference), (mask), (coverMode), (transformType), (transformValues))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStencilThenCoverStrokePathInstancedNV, (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum coverMode, GLenum transformType, const GLfloat *transformValues))
#ifndef glStencilThenCoverStrokePathNV
#define glStencilThenCoverStrokePathNV(path, reference, mask, coverMode) glatter_glStencilThenCoverStrokePathNV((path), (reference), (mask), (coverMode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStencilThenCoverStrokePathNV, (GLuint path, GLint reference, GLuint mask, GLenum coverMode))
#ifndef glTransformPathNV
#define glTransformPathNV(resultPath, srcPath, transformType, transformValues) glatter_glTransformPathNV((resultPath), (srcPath), (transformType), (transformValues))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTransformPathNV, (GLuint resultPath, GLuint srcPath, GLenum transformType, const GLfloat *transformValues))
#ifndef glWeightPathsNV
#define glWeightPathsNV(resultPath, numPaths, paths, weights) glatter_glWeightPathsNV((resultPath), (numPaths), (paths), (weights))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glWeightPathsNV, (GLuint resultPath, GLsizei numPaths, const GLuint *paths, const GLfloat *weights))
#endif // defined(GL_NV_path_rendering)
#if defined(GL_NV_polygon_mode)
#ifndef glPolygonModeNV
#define glPolygonModeNV(face, mode) glatter_glPolygonModeNV((face), (mode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPolygonModeNV, (GLenum face, GLenum mode))
#endif // defined(GL_NV_polygon_mode)
#if defined(GL_NV_read_buffer)
#ifndef glReadBufferNV
#define glReadBufferNV(mode) glatter_glReadBufferNV((mode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glReadBufferNV, (GLenum mode))
#endif // defined(GL_NV_read_buffer)
#if defined(GL_NV_sample_locations)
#ifndef glFramebufferSampleLocationsfvNV
#define glFramebufferSampleLocationsfvNV(target, start, count, v) glatter_glFramebufferSampleLocationsfvNV((target), (start), (count), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferSampleLocationsfvNV, (GLenum target, GLuint start, GLsizei count, const GLfloat *v))
#ifndef glNamedFramebufferSampleLocationsfvNV
#define glNamedFramebufferSampleLocationsfvNV(framebuffer, start, count, v) glatter_glNamedFramebufferSampleLocationsfvNV((framebuffer), (start), (count), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glNamedFramebufferSampleLocationsfvNV, (GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v))
#ifndef glResolveDepthValuesNV
#define glResolveDepthValuesNV() glatter_glResolveDepthValuesNV()
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glResolveDepthValuesNV, (void))
#endif // defined(GL_NV_sample_locations)
#if defined(GL_NV_viewport_array)
#ifndef glDepthRangeArrayfvNV
#define glDepthRangeArrayfvNV(first, count, v) glatter_glDepthRangeArrayfvNV((first), (count), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDepthRangeArrayfvNV, (GLuint first, GLsizei count, const GLfloat *v))
#ifndef glDepthRangeIndexedfNV
#define glDepthRangeIndexedfNV(index, n, f) glatter_glDepthRangeIndexedfNV((index), (n), (f))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDepthRangeIndexedfNV, (GLuint index, GLfloat n, GLfloat f))
#ifndef glDisableiNV
#define glDisableiNV(target, index) glatter_glDisableiNV((target), (index))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDisableiNV, (GLenum target, GLuint index))
#ifndef glEnableiNV
#define glEnableiNV(target, index) glatter_glEnableiNV((target), (index))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEnableiNV, (GLenum target, GLuint index))
#ifndef glGetFloati_vNV
#define glGetFloati_vNV(target, index, data) glatter_glGetFloati_vNV((target), (index), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetFloati_vNV, (GLenum target, GLuint index, GLfloat *data))
#ifndef glIsEnablediNV
#define glIsEnablediNV(target, index) glatter_glIsEnablediNV((target), (index))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsEnablediNV, (GLenum target, GLuint index))
#ifndef glScissorArrayvNV
#define glScissorArrayvNV(first, count, v) glatter_glScissorArrayvNV((first), (count), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glScissorArrayvNV, (GLuint first, GLsizei count, const GLint *v))
#ifndef glScissorIndexedNV
#define glScissorIndexedNV(index, left, bottom, width, height) glatter_glScissorIndexedNV((index), (left), (bottom), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glScissorIndexedNV, (GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height))
#ifndef glScissorIndexedvNV
#define glScissorIndexedvNV(index, v) glatter_glScissorIndexedvNV((index), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glScissorIndexedvNV, (GLuint index, const GLint *v))
#ifndef glViewportArrayvNV
#define glViewportArrayvNV(first, count, v) glatter_glViewportArrayvNV((first), (count), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glViewportArrayvNV, (GLuint first, GLsizei count, const GLfloat *v))
#ifndef glViewportIndexedfNV
#define glViewportIndexedfNV(index, x, y, w, h) glatter_glViewportIndexedfNV((index), (x), (y), (w), (h))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glViewportIndexedfNV, (GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h))
#ifndef glViewportIndexedfvNV
#define glViewportIndexedfvNV(index, v) glatter_glViewportIndexedfvNV((index), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glViewportIndexedfvNV, (GLuint index, const GLfloat *v))
#endif // defined(GL_NV_viewport_array)
#if defined(GL_NV_viewport_swizzle)
#ifndef glViewportSwizzleNV
#define glViewportSwizzleNV(index, swizzlex, swizzley, swizzlez, swizzlew) glatter_glViewportSwizzleNV((index), (swizzlex), (swizzley), (swizzlez), (swizzlew))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glViewportSwizzleNV, (GLuint index, GLenum swizzlex, GLenum swizzley, GLenum swizzlez, GLenum swizzlew))
#endif // defined(GL_NV_viewport_swizzle)
#if defined(GL_OES_EGL_image)
#ifndef glEGLImageTargetRenderbufferStorageOES
#define glEGLImageTargetRenderbufferStorageOES(target, image) glatter_glEGLImageTargetRenderbufferStorageOES((target), (image))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEGLImageTargetRenderbufferStorageOES, (GLenum target, GLeglImageOES image))
#ifndef glEGLImageTargetTexture2DOES
#define glEGLImageTargetTexture2DOES(target, image) glatter_glEGLImageTargetTexture2DOES((target), (image))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEGLImageTargetTexture2DOES, (GLenum target, GLeglImageOES image))
#endif // defined(GL_OES_EGL_image)
#if defined(GL_OES_copy_image)
#ifndef glCopyImageSubDataOES
#define glCopyImageSubDataOES(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth) glatter_glCopyImageSubDataOES((srcName), (srcTarget), (srcLevel), (srcX), (srcY), (srcZ), (dstName), (dstTarget), (dstLevel), (dstX), (dstY), (dstZ), (srcWidth), (srcHeight), (srcDepth))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCopyImageSubDataOES, (GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth))
#endif // defined(GL_OES_copy_image)
#if defined(GL_OES_draw_buffers_indexed)
#ifndef glBlendEquationSeparateiOES
#define glBlendEquationSeparateiOES(buf, modeRGB, modeAlpha) glatter_glBlendEquationSeparateiOES((buf), (modeRGB), (modeAlpha))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendEquationSeparateiOES, (GLuint buf, GLenum modeRGB, GLenum modeAlpha))
#ifndef glBlendEquationiOES
#define glBlendEquationiOES(buf, mode) glatter_glBlendEquationiOES((buf), (mode))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendEquationiOES, (GLuint buf, GLenum mode))
#ifndef glBlendFuncSeparateiOES
#define glBlendFuncSeparateiOES(buf, srcRGB, dstRGB, srcAlpha, dstAlpha) glatter_glBlendFuncSeparateiOES((buf), (srcRGB), (dstRGB), (srcAlpha), (dstAlpha))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendFuncSeparateiOES, (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha))
#ifndef glBlendFunciOES
#define glBlendFunciOES(buf, src, dst) glatter_glBlendFunciOES((buf), (src), (dst))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBlendFunciOES, (GLuint buf, GLenum src, GLenum dst))
#ifndef glColorMaskiOES
#define glColorMaskiOES(index, r, g, b, a) glatter_glColorMaskiOES((index), (r), (g), (b), (a))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glColorMaskiOES, (GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a))
#ifndef glDisableiOES
#define glDisableiOES(target, index) glatter_glDisableiOES((target), (index))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDisableiOES, (GLenum target, GLuint index))
#ifndef glEnableiOES
#define glEnableiOES(target, index) glatter_glEnableiOES((target), (index))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEnableiOES, (GLenum target, GLuint index))
#ifndef glIsEnablediOES
#define glIsEnablediOES(target, index) glatter_glIsEnablediOES((target), (index))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsEnablediOES, (GLenum target, GLuint index))
#endif // defined(GL_OES_draw_buffers_indexed)
#if defined(GL_OES_draw_elements_base_vertex)
#ifndef glDrawElementsBaseVertexOES
#define glDrawElementsBaseVertexOES(mode, count, type, indices, basevertex) glatter_glDrawElementsBaseVertexOES((mode), (count), (type), (indices), (basevertex))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawElementsBaseVertexOES, (GLenum mode, GLsizei count, GLenum type, const void *indices, GLint basevertex))
#ifndef glDrawElementsInstancedBaseVertexOES
#define glDrawElementsInstancedBaseVertexOES(mode, count, type, indices, instancecount, basevertex) glatter_glDrawElementsInstancedBaseVertexOES((mode), (count), (type), (indices), (instancecount), (basevertex))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawElementsInstancedBaseVertexOES, (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei instancecount, GLint basevertex))
#ifndef glDrawRangeElementsBaseVertexOES
#define glDrawRangeElementsBaseVertexOES(mode, start, end, count, type, indices, basevertex) glatter_glDrawRangeElementsBaseVertexOES((mode), (start), (end), (count), (type), (indices), (basevertex))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDrawRangeElementsBaseVertexOES, (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, GLint basevertex))
#ifndef glMultiDrawElementsBaseVertexEXT
#define glMultiDrawElementsBaseVertexEXT(mode, count, type, indices, primcount, basevertex) glatter_glMultiDrawElementsBaseVertexEXT((mode), (count), (type), (indices), (primcount), (basevertex))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMultiDrawElementsBaseVertexEXT, (GLenum mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount, const GLint *basevertex))
#endif // defined(GL_OES_draw_elements_base_vertex)
#if defined(GL_OES_geometry_shader)
#ifndef glFramebufferTextureOES
#define glFramebufferTextureOES(target, attachment, texture, level) glatter_glFramebufferTextureOES((target), (attachment), (texture), (level))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferTextureOES, (GLenum target, GLenum attachment, GLuint texture, GLint level))
#endif // defined(GL_OES_geometry_shader)
#if defined(GL_OES_get_program_binary)
#ifndef glGetProgramBinaryOES
#define glGetProgramBinaryOES(program, bufSize, length, binaryFormat, binary) glatter_glGetProgramBinaryOES((program), (bufSize), (length), (binaryFormat), (binary))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetProgramBinaryOES, (GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, void *binary))
#ifndef glProgramBinaryOES
#define glProgramBinaryOES(program, binaryFormat, binary, length) glatter_glProgramBinaryOES((program), (binaryFormat), (binary), (length))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glProgramBinaryOES, (GLuint program, GLenum binaryFormat, const void *binary, GLint length))
#endif // defined(GL_OES_get_program_binary)
#if defined(GL_OES_mapbuffer)
#ifndef glGetBufferPointervOES
#define glGetBufferPointervOES(target, pname, params) glatter_glGetBufferPointervOES((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetBufferPointervOES, (GLenum target, GLenum pname, void **params))
#ifndef glMapBufferOES
#define glMapBufferOES(target, access) glatter_glMapBufferOES((target), (access))
#endif
GLATTER_UBLOCK(void *, GL_APIENTRY, glMapBufferOES, (GLenum target, GLenum access))
#ifndef glUnmapBufferOES
#define glUnmapBufferOES(target) glatter_glUnmapBufferOES((target))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glUnmapBufferOES, (GLenum target))
#endif // defined(GL_OES_mapbuffer)
#if defined(GL_OES_primitive_bounding_box)
#ifndef glPrimitiveBoundingBoxOES
#define glPrimitiveBoundingBoxOES(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW) glatter_glPrimitiveBoundingBoxOES((minX), (minY), (minZ), (minW), (maxX), (maxY), (maxZ), (maxW))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPrimitiveBoundingBoxOES, (GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW))
#endif // defined(GL_OES_primitive_bounding_box)
#if defined(GL_OES_sample_shading)
#ifndef glMinSampleShadingOES
#define glMinSampleShadingOES(value) glatter_glMinSampleShadingOES((value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glMinSampleShadingOES, (GLfloat value))
#endif // defined(GL_OES_sample_shading)
#if defined(GL_OES_tessellation_shader)
#ifndef glPatchParameteriOES
#define glPatchParameteriOES(pname, value) glatter_glPatchParameteriOES((pname), (value))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glPatchParameteriOES, (GLenum pname, GLint value))
#endif // defined(GL_OES_tessellation_shader)
#if defined(GL_OES_texture_3D)
#ifndef glCompressedTexImage3DOES
#define glCompressedTexImage3DOES(target, level, internalformat, width, height, depth, border, imageSize, data) glatter_glCompressedTexImage3DOES((target), (level), (internalformat), (width), (height), (depth), (border), (imageSize), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCompressedTexImage3DOES, (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data))
#ifndef glCompressedTexSubImage3DOES
#define glCompressedTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data) glatter_glCompressedTexSubImage3DOES((target), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (imageSize), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCompressedTexSubImage3DOES, (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data))
#ifndef glCopyTexSubImage3DOES
#define glCopyTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, x, y, width, height) glatter_glCopyTexSubImage3DOES((target), (level), (xoffset), (yoffset), (zoffset), (x), (y), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glCopyTexSubImage3DOES, (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height))
#ifndef glFramebufferTexture3DOES
#define glFramebufferTexture3DOES(target, attachment, textarget, texture, level, zoffset) glatter_glFramebufferTexture3DOES((target), (attachment), (textarget), (texture), (level), (zoffset))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferTexture3DOES, (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset))
#ifndef glTexImage3DOES
#define glTexImage3DOES(target, level, internalformat, width, height, depth, border, format, type, pixels) glatter_glTexImage3DOES((target), (level), (internalformat), (width), (height), (depth), (border), (format), (type), (pixels))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexImage3DOES, (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels))
#ifndef glTexSubImage3DOES
#define glTexSubImage3DOES(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels) glatter_glTexSubImage3DOES((target), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (type), (pixels))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexSubImage3DOES, (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels))
#endif // defined(GL_OES_texture_3D)
#if defined(GL_OES_texture_border_clamp)
#ifndef glGetSamplerParameterIivOES
#define glGetSamplerParameterIivOES(sampler, pname, params) glatter_glGetSamplerParameterIivOES((sampler), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetSamplerParameterIivOES, (GLuint sampler, GLenum pname, GLint *params))
#ifndef glGetSamplerParameterIuivOES
#define glGetSamplerParameterIuivOES(sampler, pname, params) glatter_glGetSamplerParameterIuivOES((sampler), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetSamplerParameterIuivOES, (GLuint sampler, GLenum pname, GLuint *params))
#ifndef glGetTexParameterIivOES
#define glGetTexParameterIivOES(target, pname, params) glatter_glGetTexParameterIivOES((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetTexParameterIivOES, (GLenum target, GLenum pname, GLint *params))
#ifndef glGetTexParameterIuivOES
#define glGetTexParameterIuivOES(target, pname, params) glatter_glGetTexParameterIuivOES((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetTexParameterIuivOES, (GLenum target, GLenum pname, GLuint *params))
#ifndef glSamplerParameterIivOES
#define glSamplerParameterIivOES(sampler, pname, param) glatter_glSamplerParameterIivOES((sampler), (pname), (param))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glSamplerParameterIivOES, (GLuint sampler, GLenum pname, const GLint *param))
#ifndef glSamplerParameterIuivOES
#define glSamplerParameterIuivOES(sampler, pname, param) glatter_glSamplerParameterIuivOES((sampler), (pname), (param))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glSamplerParameterIuivOES, (GLuint sampler, GLenum pname, const GLuint *param))
#ifndef glTexParameterIivOES
#define glTexParameterIivOES(target, pname, params) glatter_glTexParameterIivOES((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexParameterIivOES, (GLenum target, GLenum pname, const GLint *params))
#ifndef glTexParameterIuivOES
#define glTexParameterIuivOES(target, pname, params) glatter_glTexParameterIuivOES((target), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexParameterIuivOES, (GLenum target, GLenum pname, const GLuint *params))
#endif // defined(GL_OES_texture_border_clamp)
#if defined(GL_OES_texture_buffer)
#ifndef glTexBufferOES
#define glTexBufferOES(target, internalformat, buffer) glatter_glTexBufferOES((target), (internalformat), (buffer))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexBufferOES, (GLenum target, GLenum internalformat, GLuint buffer))
#ifndef glTexBufferRangeOES
#define glTexBufferRangeOES(target, internalformat, buffer, offset, size) glatter_glTexBufferRangeOES((target), (internalformat), (buffer), (offset), (size))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexBufferRangeOES, (GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size))
#endif // defined(GL_OES_texture_buffer)
#if defined(GL_OES_texture_storage_multisample_2d_array)
#ifndef glTexStorage3DMultisampleOES
#define glTexStorage3DMultisampleOES(target, samples, internalformat, width, height, depth, fixedsamplelocations) glatter_glTexStorage3DMultisampleOES((target), (samples), (internalformat), (width), (height), (depth), (fixedsamplelocations))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTexStorage3DMultisampleOES, (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations))
#endif // defined(GL_OES_texture_storage_multisample_2d_array)
#if defined(GL_OES_texture_view)
#ifndef glTextureViewOES
#define glTextureViewOES(texture, target, origtexture, internalformat, minlevel, numlevels, minlayer, numlayers) glatter_glTextureViewOES((texture), (target), (origtexture), (internalformat), (minlevel), (numlevels), (minlayer), (numlayers))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTextureViewOES, (GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers))
#endif // defined(GL_OES_texture_view)
#if defined(GL_OES_vertex_array_object)
#ifndef glBindVertexArrayOES
#define glBindVertexArrayOES(array) glatter_glBindVertexArrayOES((array))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glBindVertexArrayOES, (GLuint array))
#ifndef glDeleteVertexArraysOES
#define glDeleteVertexArraysOES(n, arrays) glatter_glDeleteVertexArraysOES((n), (arrays))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDeleteVertexArraysOES, (GLsizei n, const GLuint *arrays))
#ifndef glGenVertexArraysOES
#define glGenVertexArraysOES(n, arrays) glatter_glGenVertexArraysOES((n), (arrays))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGenVertexArraysOES, (GLsizei n, GLuint *arrays))
#ifndef glIsVertexArrayOES
#define glIsVertexArrayOES(array) glatter_glIsVertexArrayOES((array))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glIsVertexArrayOES, (GLuint array))
#endif // defined(GL_OES_vertex_array_object)
#if defined(GL_OES_viewport_array)
#ifndef glDepthRangeArrayfvOES
#define glDepthRangeArrayfvOES(first, count, v) glatter_glDepthRangeArrayfvOES((first), (count), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDepthRangeArrayfvOES, (GLuint first, GLsizei count, const GLfloat *v))
#ifndef glDepthRangeIndexedfOES
#define glDepthRangeIndexedfOES(index, n, f) glatter_glDepthRangeIndexedfOES((index), (n), (f))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDepthRangeIndexedfOES, (GLuint index, GLfloat n, GLfloat f))
#ifndef glGetFloati_vOES
#define glGetFloati_vOES(target, index, data) glatter_glGetFloati_vOES((target), (index), (data))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetFloati_vOES, (GLenum target, GLuint index, GLfloat *data))
#ifndef glScissorArrayvOES
#define glScissorArrayvOES(first, count, v) glatter_glScissorArrayvOES((first), (count), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glScissorArrayvOES, (GLuint first, GLsizei count, const GLint *v))
#ifndef glScissorIndexedOES
#define glScissorIndexedOES(index, left, bottom, width, height) glatter_glScissorIndexedOES((index), (left), (bottom), (width), (height))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glScissorIndexedOES, (GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height))
#ifndef glScissorIndexedvOES
#define glScissorIndexedvOES(index, v) glatter_glScissorIndexedvOES((index), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glScissorIndexedvOES, (GLuint index, const GLint *v))
#ifndef glViewportArrayvOES
#define glViewportArrayvOES(first, count, v) glatter_glViewportArrayvOES((first), (count), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glViewportArrayvOES, (GLuint first, GLsizei count, const GLfloat *v))
#ifndef glViewportIndexedfOES
#define glViewportIndexedfOES(index, x, y, w, h) glatter_glViewportIndexedfOES((index), (x), (y), (w), (h))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glViewportIndexedfOES, (GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h))
#ifndef glViewportIndexedfvOES
#define glViewportIndexedfvOES(index, v) glatter_glViewportIndexedfvOES((index), (v))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glViewportIndexedfvOES, (GLuint index, const GLfloat *v))
#endif // defined(GL_OES_viewport_array)
#if defined(GL_OVR_multiview)
#ifndef glFramebufferTextureMultiviewOVR
#define glFramebufferTextureMultiviewOVR(target, attachment, texture, level, baseViewIndex, numViews) glatter_glFramebufferTextureMultiviewOVR((target), (attachment), (texture), (level), (baseViewIndex), (numViews))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferTextureMultiviewOVR, (GLenum target, GLenum attachment, GLuint texture, GLint level, GLint baseViewIndex, GLsizei numViews))
#endif // defined(GL_OVR_multiview)
#if defined(GL_OVR_multiview_multisampled_render_to_texture)
#ifndef glFramebufferTextureMultisampleMultiviewOVR
#define glFramebufferTextureMultisampleMultiviewOVR(target, attachment, texture, level, samples, baseViewIndex, numViews) glatter_glFramebufferTextureMultisampleMultiviewOVR((target), (attachment), (texture), (level), (samples), (baseViewIndex), (numViews))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferTextureMultisampleMultiviewOVR, (GLenum target, GLenum attachment, GLuint texture, GLint level, GLsizei samples, GLint baseViewIndex, GLsizei numViews))
#endif // defined(GL_OVR_multiview_multisampled_render_to_texture)
#if defined(GL_QCOM_alpha_test)
#ifndef glAlphaFuncQCOM
#define glAlphaFuncQCOM(func, ref) glatter_glAlphaFuncQCOM((func), (ref))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glAlphaFuncQCOM, (GLenum func, GLclampf ref))
#endif // defined(GL_QCOM_alpha_test)
#if defined(GL_QCOM_driver_control)
#ifndef glDisableDriverControlQCOM
#define glDisableDriverControlQCOM(driverControl) glatter_glDisableDriverControlQCOM((driverControl))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glDisableDriverControlQCOM, (GLuint driverControl))
#ifndef glEnableDriverControlQCOM
#define glEnableDriverControlQCOM(driverControl) glatter_glEnableDriverControlQCOM((driverControl))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEnableDriverControlQCOM, (GLuint driverControl))
#ifndef glGetDriverControlStringQCOM
#define glGetDriverControlStringQCOM(driverControl, bufSize, length, driverControlString) glatter_glGetDriverControlStringQCOM((driverControl), (bufSize), (length), (driverControlString))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetDriverControlStringQCOM, (GLuint driverControl, GLsizei bufSize, GLsizei *length, GLchar *driverControlString))
#ifndef glGetDriverControlsQCOM
#define glGetDriverControlsQCOM(num, size, driverControls) glatter_glGetDriverControlsQCOM((num), (size), (driverControls))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glGetDriverControlsQCOM, (GLint *num, GLsizei size, GLuint *driverControls))
#endif // defined(GL_QCOM_driver_control)
#if defined(GL_QCOM_extended_get)
#ifndef glExtGetBufferPointervQCOM
#define glExtGetBufferPointervQCOM(target, params) glatter_glExtGetBufferPointervQCOM((target), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glExtGetBufferPointervQCOM, (GLenum target, void **params))
#ifndef glExtGetBuffersQCOM
#define glExtGetBuffersQCOM(buffers, maxBuffers, numBuffers) glatter_glExtGetBuffersQCOM((buffers), (maxBuffers), (numBuffers))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glExtGetBuffersQCOM, (GLuint *buffers, GLint maxBuffers, GLint *numBuffers))
#ifndef glExtGetFramebuffersQCOM
#define glExtGetFramebuffersQCOM(framebuffers, maxFramebuffers, numFramebuffers) glatter_glExtGetFramebuffersQCOM((framebuffers), (maxFramebuffers), (numFramebuffers))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glExtGetFramebuffersQCOM, (GLuint *framebuffers, GLint maxFramebuffers, GLint *numFramebuffers))
#ifndef glExtGetRenderbuffersQCOM
#define glExtGetRenderbuffersQCOM(renderbuffers, maxRenderbuffers, numRenderbuffers) glatter_glExtGetRenderbuffersQCOM((renderbuffers), (maxRenderbuffers), (numRenderbuffers))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glExtGetRenderbuffersQCOM, (GLuint *renderbuffers, GLint maxRenderbuffers, GLint *numRenderbuffers))
#ifndef glExtGetTexLevelParameterivQCOM
#define glExtGetTexLevelParameterivQCOM(texture, face, level, pname, params) glatter_glExtGetTexLevelParameterivQCOM((texture), (face), (level), (pname), (params))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glExtGetTexLevelParameterivQCOM, (GLuint texture, GLenum face, GLint level, GLenum pname, GLint *params))
#ifndef glExtGetTexSubImageQCOM
#define glExtGetTexSubImageQCOM(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, texels) glatter_glExtGetTexSubImageQCOM((target), (level), (xoffset), (yoffset), (zoffset), (width), (height), (depth), (format), (type), (texels))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glExtGetTexSubImageQCOM, (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, void *texels))
#ifndef glExtGetTexturesQCOM
#define glExtGetTexturesQCOM(textures, maxTextures, numTextures) glatter_glExtGetTexturesQCOM((textures), (maxTextures), (numTextures))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glExtGetTexturesQCOM, (GLuint *textures, GLint maxTextures, GLint *numTextures))
#ifndef glExtTexObjectStateOverrideiQCOM
#define glExtTexObjectStateOverrideiQCOM(target, pname, param) glatter_glExtTexObjectStateOverrideiQCOM((target), (pname), (param))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glExtTexObjectStateOverrideiQCOM, (GLenum target, GLenum pname, GLint param))
#endif // defined(GL_QCOM_extended_get)
#if defined(GL_QCOM_extended_get2)
#ifndef glExtGetProgramBinarySourceQCOM
#define glExtGetProgramBinarySourceQCOM(program, shadertype, source, length) glatter_glExtGetProgramBinarySourceQCOM((program), (shadertype), (source), (length))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glExtGetProgramBinarySourceQCOM, (GLuint program, GLenum shadertype, GLchar *source, GLint *length))
#ifndef glExtGetProgramsQCOM
#define glExtGetProgramsQCOM(programs, maxPrograms, numPrograms) glatter_glExtGetProgramsQCOM((programs), (maxPrograms), (numPrograms))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glExtGetProgramsQCOM, (GLuint *programs, GLint maxPrograms, GLint *numPrograms))
#ifndef glExtGetShadersQCOM
#define glExtGetShadersQCOM(shaders, maxShaders, numShaders) glatter_glExtGetShadersQCOM((shaders), (maxShaders), (numShaders))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glExtGetShadersQCOM, (GLuint *shaders, GLint maxShaders, GLint *numShaders))
#ifndef glExtIsProgramBinaryQCOM
#define glExtIsProgramBinaryQCOM(program) glatter_glExtIsProgramBinaryQCOM((program))
#endif
GLATTER_UBLOCK(GLboolean, GL_APIENTRY, glExtIsProgramBinaryQCOM, (GLuint program))
#endif // defined(GL_QCOM_extended_get2)
#if defined(GL_QCOM_framebuffer_foveated)
#ifndef glFramebufferFoveationConfigQCOM
#define glFramebufferFoveationConfigQCOM(framebuffer, numLayers, focalPointsPerLayer, requestedFeatures, providedFeatures) glatter_glFramebufferFoveationConfigQCOM((framebuffer), (numLayers), (focalPointsPerLayer), (requestedFeatures), (providedFeatures))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferFoveationConfigQCOM, (GLuint framebuffer, GLuint numLayers, GLuint focalPointsPerLayer, GLuint requestedFeatures, GLuint *providedFeatures))
#ifndef glFramebufferFoveationParametersQCOM
#define glFramebufferFoveationParametersQCOM(framebuffer, layer, focalPoint, focalX, focalY, gainX, gainY, foveaArea) glatter_glFramebufferFoveationParametersQCOM((framebuffer), (layer), (focalPoint), (focalX), (focalY), (gainX), (gainY), (foveaArea))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferFoveationParametersQCOM, (GLuint framebuffer, GLuint layer, GLuint focalPoint, GLfloat focalX, GLfloat focalY, GLfloat gainX, GLfloat gainY, GLfloat foveaArea))
#endif // defined(GL_QCOM_framebuffer_foveated)
#if defined(GL_QCOM_shader_framebuffer_fetch_noncoherent)
#ifndef glFramebufferFetchBarrierQCOM
#define glFramebufferFetchBarrierQCOM() glatter_glFramebufferFetchBarrierQCOM()
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glFramebufferFetchBarrierQCOM, (void))
#endif // defined(GL_QCOM_shader_framebuffer_fetch_noncoherent)
#if defined(GL_QCOM_texture_foveated)
#ifndef glTextureFoveationParametersQCOM
#define glTextureFoveationParametersQCOM(texture, layer, focalPoint, focalX, focalY, gainX, gainY, foveaArea) glatter_glTextureFoveationParametersQCOM((texture), (layer), (focalPoint), (focalX), (focalY), (gainX), (gainY), (foveaArea))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glTextureFoveationParametersQCOM, (GLuint texture, GLuint layer, GLuint focalPoint, GLfloat focalX, GLfloat focalY, GLfloat gainX, GLfloat gainY, GLfloat foveaArea))
#endif // defined(GL_QCOM_texture_foveated)
#if defined(GL_QCOM_tiled_rendering)
#ifndef glEndTilingQCOM
#define glEndTilingQCOM(preserveMask) glatter_glEndTilingQCOM((preserveMask))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glEndTilingQCOM, (GLbitfield preserveMask))
#ifndef glStartTilingQCOM
#define glStartTilingQCOM(x, y, width, height, preserveMask) glatter_glStartTilingQCOM((x), (y), (width), (height), (preserveMask))
#endif
GLATTER_UBLOCK(void, GL_APIENTRY, glStartTilingQCOM, (GLuint x, GLuint y, GLuint width, GLuint height, GLbitfield preserveMask))
#endif // defined(__gles2_gl2ext_h_)
#endif // defined(GL_QCOM_tiled_rendering)
#endif // GLATTER_GL

