/*
Copyright 2018 Ioannis Makris

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// This file was generated by glatter.py script.



#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable : 4702)
#endif

GLATTER_INLINE_OR_NOT
const char* enum_to_string_GL(GLenum e)
{
    switch (e) {
#if defined(__gl_h_)
        case 0x0: return "GL_POINTS";
        case 0x1: return "GL_LINES";
        case 0x2: return "GL_LINE_LOOP";
        case 0x3: return "GL_LINE_STRIP";
        case 0x4: return "GL_TRIANGLES";
        case 0x5: return "GL_TRIANGLE_STRIP";
        case 0x6: return "GL_TRIANGLE_FAN";
        case 0x7: return "GL_QUADS";
        case 0x8: return "GL_QUAD_STRIP";
        case 0x9: return "GL_POLYGON";
        case 0x100: return "GL_ACCUM";
        case 0x101: return "GL_LOAD";
        case 0x102: return "GL_RETURN";
        case 0x103: return "GL_MULT";
        case 0x104: return "GL_ADD";
        case 0x200: return "GL_NEVER";
        case 0x201: return "GL_LESS";
        case 0x202: return "GL_EQUAL";
        case 0x203: return "GL_LEQUAL";
        case 0x204: return "GL_GREATER";
        case 0x205: return "GL_NOTEQUAL";
        case 0x206: return "GL_GEQUAL";
        case 0x207: return "GL_ALWAYS";
        case 0x300: return "GL_SRC_COLOR";
        case 0x301: return "GL_ONE_MINUS_SRC_COLOR";
        case 0x302: return "GL_SRC_ALPHA";
        case 0x303: return "GL_ONE_MINUS_SRC_ALPHA";
        case 0x304: return "GL_DST_ALPHA";
        case 0x305: return "GL_ONE_MINUS_DST_ALPHA";
        case 0x306: return "GL_DST_COLOR";
        case 0x307: return "GL_ONE_MINUS_DST_COLOR";
        case 0x308: return "GL_SRC_ALPHA_SATURATE";
        case 0x400: return "GL_FRONT_LEFT";
        case 0x401: return "GL_FRONT_RIGHT";
        case 0x402: return "GL_BACK_LEFT";
        case 0x403: return "GL_BACK_RIGHT";
        case 0x404: return "GL_FRONT";
        case 0x405: return "GL_BACK";
        case 0x406: return "GL_LEFT";
        case 0x407: return "GL_RIGHT";
        case 0x408: return "GL_FRONT_AND_BACK";
        case 0x409: return "GL_AUX0";
        case 0x40a: return "GL_AUX1";
        case 0x40b: return "GL_AUX2";
        case 0x40c: return "GL_AUX3";
        case 0x500: return "GL_INVALID_ENUM";
        case 0x501: return "GL_INVALID_VALUE";
        case 0x502: return "GL_INVALID_OPERATION";
        case 0x503: return "GL_STACK_OVERFLOW";
        case 0x504: return "GL_STACK_UNDERFLOW";
        case 0x505: return "GL_OUT_OF_MEMORY";
#endif
        case 0x506:
#if defined(GL_VERSION_3_0)
                    return "GL_INVALID_FRAMEBUFFER_OPERATION";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_INVALID_FRAMEBUFFER_OPERATION_EXT";
#endif
            break;
#if defined(GL_VERSION_4_5)
        case 0x507: return "GL_CONTEXT_LOST";
#endif
#if defined(__gl_h_)
        case 0x600: return "GL_2D";
        case 0x601: return "GL_3D";
        case 0x602: return "GL_3D_COLOR";
        case 0x603: return "GL_3D_COLOR_TEXTURE";
        case 0x604: return "GL_4D_COLOR_TEXTURE";
        case 0x700: return "GL_PASS_THROUGH_TOKEN";
        case 0x701: return "GL_POINT_TOKEN";
        case 0x702: return "GL_LINE_TOKEN";
        case 0x703: return "GL_POLYGON_TOKEN";
        case 0x704: return "GL_BITMAP_TOKEN";
        case 0x705: return "GL_DRAW_PIXEL_TOKEN";
        case 0x706: return "GL_COPY_PIXEL_TOKEN";
        case 0x707: return "GL_LINE_RESET_TOKEN";
        case 0x800: return "GL_EXP";
        case 0x801: return "GL_EXP2";
        case 0x900: return "GL_CW";
        case 0x901: return "GL_CCW";
        case 0xa00: return "GL_COEFF";
        case 0xa01: return "GL_ORDER";
        case 0xa02: return "GL_DOMAIN";
        case 0xb00: return "GL_CURRENT_COLOR";
        case 0xb01: return "GL_CURRENT_INDEX";
        case 0xb02: return "GL_CURRENT_NORMAL";
        case 0xb03: return "GL_CURRENT_TEXTURE_COORDS";
        case 0xb04: return "GL_CURRENT_RASTER_COLOR";
        case 0xb05: return "GL_CURRENT_RASTER_INDEX";
        case 0xb06: return "GL_CURRENT_RASTER_TEXTURE_COORDS";
        case 0xb07: return "GL_CURRENT_RASTER_POSITION";
        case 0xb08: return "GL_CURRENT_RASTER_POSITION_VALID";
        case 0xb09: return "GL_CURRENT_RASTER_DISTANCE";
        case 0xb10: return "GL_POINT_SMOOTH";
        case 0xb11: return "GL_POINT_SIZE";
#endif
        case 0xb12:
#if defined(__gl_h_)
                    return "GL_POINT_SIZE_RANGE";
#endif
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_SMOOTH_POINT_SIZE_RANGE";
#endif
            break;
        case 0xb13:
#if defined(__gl_h_)
                    return "GL_POINT_SIZE_GRANULARITY";
#endif
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_SMOOTH_POINT_SIZE_GRANULARITY";
#endif
            break;
#if defined(__gl_h_)
        case 0xb20: return "GL_LINE_SMOOTH";
        case 0xb21: return "GL_LINE_WIDTH";
#endif
        case 0xb22:
#if defined(__gl_h_)
                    return "GL_LINE_WIDTH_RANGE";
#endif
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_SMOOTH_LINE_WIDTH_RANGE";
#endif
            break;
        case 0xb23:
#if defined(__gl_h_)
                    return "GL_LINE_WIDTH_GRANULARITY";
#endif
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_SMOOTH_LINE_WIDTH_GRANULARITY";
#endif
            break;
#if defined(__gl_h_)
        case 0xb24: return "GL_LINE_STIPPLE";
        case 0xb25: return "GL_LINE_STIPPLE_PATTERN";
        case 0xb26: return "GL_LINE_STIPPLE_REPEAT";
        case 0xb30: return "GL_LIST_MODE";
        case 0xb31: return "GL_MAX_LIST_NESTING";
        case 0xb32: return "GL_LIST_BASE";
        case 0xb33: return "GL_LIST_INDEX";
        case 0xb40: return "GL_POLYGON_MODE";
        case 0xb41: return "GL_POLYGON_SMOOTH";
        case 0xb42: return "GL_POLYGON_STIPPLE";
        case 0xb43: return "GL_EDGE_FLAG";
        case 0xb44: return "GL_CULL_FACE";
        case 0xb45: return "GL_CULL_FACE_MODE";
        case 0xb46: return "GL_FRONT_FACE";
        case 0xb50: return "GL_LIGHTING";
        case 0xb51: return "GL_LIGHT_MODEL_LOCAL_VIEWER";
        case 0xb52: return "GL_LIGHT_MODEL_TWO_SIDE";
        case 0xb53: return "GL_LIGHT_MODEL_AMBIENT";
        case 0xb54: return "GL_SHADE_MODEL";
        case 0xb55: return "GL_COLOR_MATERIAL_FACE";
        case 0xb56: return "GL_COLOR_MATERIAL_PARAMETER";
        case 0xb57: return "GL_COLOR_MATERIAL";
        case 0xb60: return "GL_FOG";
        case 0xb61: return "GL_FOG_INDEX";
        case 0xb62: return "GL_FOG_DENSITY";
        case 0xb63: return "GL_FOG_START";
        case 0xb64: return "GL_FOG_END";
        case 0xb65: return "GL_FOG_MODE";
        case 0xb66: return "GL_FOG_COLOR";
        case 0xb70: return "GL_DEPTH_RANGE";
        case 0xb71: return "GL_DEPTH_TEST";
        case 0xb72: return "GL_DEPTH_WRITEMASK";
        case 0xb73: return "GL_DEPTH_CLEAR_VALUE";
        case 0xb74: return "GL_DEPTH_FUNC";
        case 0xb80: return "GL_ACCUM_CLEAR_VALUE";
        case 0xb90: return "GL_STENCIL_TEST";
        case 0xb91: return "GL_STENCIL_CLEAR_VALUE";
        case 0xb92: return "GL_STENCIL_FUNC";
        case 0xb93: return "GL_STENCIL_VALUE_MASK";
        case 0xb94: return "GL_STENCIL_FAIL";
        case 0xb95: return "GL_STENCIL_PASS_DEPTH_FAIL";
        case 0xb96: return "GL_STENCIL_PASS_DEPTH_PASS";
        case 0xb97: return "GL_STENCIL_REF";
        case 0xb98: return "GL_STENCIL_WRITEMASK";
        case 0xba0: return "GL_MATRIX_MODE";
        case 0xba1: return "GL_NORMALIZE";
        case 0xba2: return "GL_VIEWPORT";
#endif
        case 0xba3:
#if defined(GL_EXT_vertex_weighting)
                    return "GL_MODELVIEW0_STACK_DEPTH_EXT";
#endif
#if defined(__gl_h_)
                    return "GL_MODELVIEW_STACK_DEPTH";
#endif
#if defined(GL_NV_path_rendering)
                    return "GL_PATH_MODELVIEW_STACK_DEPTH_NV";
#endif
            break;
        case 0xba4:
#if defined(GL_NV_path_rendering)
                    return "GL_PATH_PROJECTION_STACK_DEPTH_NV";
#endif
#if defined(__gl_h_)
                    return "GL_PROJECTION_STACK_DEPTH";
#endif
            break;
#if defined(__gl_h_)
        case 0xba5: return "GL_TEXTURE_STACK_DEPTH";
#endif
        case 0xba6:
#if defined(GL_EXT_vertex_weighting)
                    return "GL_MODELVIEW0_MATRIX_EXT";
#endif
#if defined(__gl_h_)
                    return "GL_MODELVIEW_MATRIX";
#endif
#if defined(GL_NV_path_rendering)
                    return "GL_PATH_MODELVIEW_MATRIX_NV";
#endif
            break;
        case 0xba7:
#if defined(GL_NV_path_rendering)
                    return "GL_PATH_PROJECTION_MATRIX_NV";
#endif
#if defined(__gl_h_)
                    return "GL_PROJECTION_MATRIX";
#endif
            break;
#if defined(__gl_h_)
        case 0xba8: return "GL_TEXTURE_MATRIX";
        case 0xbb0: return "GL_ATTRIB_STACK_DEPTH";
        case 0xbb1: return "GL_CLIENT_ATTRIB_STACK_DEPTH";
        case 0xbc0: return "GL_ALPHA_TEST";
        case 0xbc1: return "GL_ALPHA_TEST_FUNC";
        case 0xbc2: return "GL_ALPHA_TEST_REF";
        case 0xbd0: return "GL_DITHER";
        case 0xbe0: return "GL_BLEND_DST";
        case 0xbe1: return "GL_BLEND_SRC";
        case 0xbe2: return "GL_BLEND";
        case 0xbf0: return "GL_LOGIC_OP_MODE";
#endif
        case 0xbf1:
#if defined(__gl_h_)
                    return "GL_INDEX_LOGIC_OP";
#endif
#if defined(__gl_h_)
                    return "GL_LOGIC_OP";
#endif
            break;
#if defined(__gl_h_)
        case 0xbf2: return "GL_COLOR_LOGIC_OP";
        case 0xc00: return "GL_AUX_BUFFERS";
        case 0xc01: return "GL_DRAW_BUFFER";
        case 0xc02: return "GL_READ_BUFFER";
        case 0xc10: return "GL_SCISSOR_BOX";
        case 0xc11: return "GL_SCISSOR_TEST";
        case 0xc20: return "GL_INDEX_CLEAR_VALUE";
        case 0xc21: return "GL_INDEX_WRITEMASK";
        case 0xc22: return "GL_COLOR_CLEAR_VALUE";
        case 0xc23: return "GL_COLOR_WRITEMASK";
        case 0xc30: return "GL_INDEX_MODE";
        case 0xc31: return "GL_RGBA_MODE";
        case 0xc32: return "GL_DOUBLEBUFFER";
        case 0xc33: return "GL_STEREO";
        case 0xc40: return "GL_RENDER_MODE";
        case 0xc50: return "GL_PERSPECTIVE_CORRECTION_HINT";
        case 0xc51: return "GL_POINT_SMOOTH_HINT";
        case 0xc52: return "GL_LINE_SMOOTH_HINT";
        case 0xc53: return "GL_POLYGON_SMOOTH_HINT";
        case 0xc54: return "GL_FOG_HINT";
        case 0xc60: return "GL_TEXTURE_GEN_S";
        case 0xc61: return "GL_TEXTURE_GEN_T";
        case 0xc62: return "GL_TEXTURE_GEN_R";
        case 0xc63: return "GL_TEXTURE_GEN_Q";
        case 0xc70: return "GL_PIXEL_MAP_I_TO_I";
        case 0xc71: return "GL_PIXEL_MAP_S_TO_S";
        case 0xc72: return "GL_PIXEL_MAP_I_TO_R";
        case 0xc73: return "GL_PIXEL_MAP_I_TO_G";
        case 0xc74: return "GL_PIXEL_MAP_I_TO_B";
        case 0xc75: return "GL_PIXEL_MAP_I_TO_A";
        case 0xc76: return "GL_PIXEL_MAP_R_TO_R";
        case 0xc77: return "GL_PIXEL_MAP_G_TO_G";
        case 0xc78: return "GL_PIXEL_MAP_B_TO_B";
        case 0xc79: return "GL_PIXEL_MAP_A_TO_A";
        case 0xcb0: return "GL_PIXEL_MAP_I_TO_I_SIZE";
        case 0xcb1: return "GL_PIXEL_MAP_S_TO_S_SIZE";
        case 0xcb2: return "GL_PIXEL_MAP_I_TO_R_SIZE";
        case 0xcb3: return "GL_PIXEL_MAP_I_TO_G_SIZE";
        case 0xcb4: return "GL_PIXEL_MAP_I_TO_B_SIZE";
        case 0xcb5: return "GL_PIXEL_MAP_I_TO_A_SIZE";
        case 0xcb6: return "GL_PIXEL_MAP_R_TO_R_SIZE";
        case 0xcb7: return "GL_PIXEL_MAP_G_TO_G_SIZE";
        case 0xcb8: return "GL_PIXEL_MAP_B_TO_B_SIZE";
        case 0xcb9: return "GL_PIXEL_MAP_A_TO_A_SIZE";
        case 0xcf0: return "GL_UNPACK_SWAP_BYTES";
        case 0xcf1: return "GL_UNPACK_LSB_FIRST";
        case 0xcf2: return "GL_UNPACK_ROW_LENGTH";
        case 0xcf3: return "GL_UNPACK_SKIP_ROWS";
        case 0xcf4: return "GL_UNPACK_SKIP_PIXELS";
        case 0xcf5: return "GL_UNPACK_ALIGNMENT";
        case 0xd00: return "GL_PACK_SWAP_BYTES";
        case 0xd01: return "GL_PACK_LSB_FIRST";
        case 0xd02: return "GL_PACK_ROW_LENGTH";
        case 0xd03: return "GL_PACK_SKIP_ROWS";
        case 0xd04: return "GL_PACK_SKIP_PIXELS";
        case 0xd05: return "GL_PACK_ALIGNMENT";
        case 0xd10: return "GL_MAP_COLOR";
        case 0xd11: return "GL_MAP_STENCIL";
        case 0xd12: return "GL_INDEX_SHIFT";
        case 0xd13: return "GL_INDEX_OFFSET";
        case 0xd14: return "GL_RED_SCALE";
        case 0xd15: return "GL_RED_BIAS";
        case 0xd16: return "GL_ZOOM_X";
        case 0xd17: return "GL_ZOOM_Y";
        case 0xd18: return "GL_GREEN_SCALE";
        case 0xd19: return "GL_GREEN_BIAS";
        case 0xd1a: return "GL_BLUE_SCALE";
        case 0xd1b: return "GL_BLUE_BIAS";
        case 0xd1c: return "GL_ALPHA_SCALE";
        case 0xd1d: return "GL_ALPHA_BIAS";
        case 0xd1e: return "GL_DEPTH_SCALE";
        case 0xd1f: return "GL_DEPTH_BIAS";
        case 0xd30: return "GL_MAX_EVAL_ORDER";
        case 0xd31: return "GL_MAX_LIGHTS";
#endif
        case 0xd32:
#if defined(GL_VERSION_3_0)
                    return "GL_MAX_CLIP_DISTANCES";
#endif
#if defined(__gl_h_)
                    return "GL_MAX_CLIP_PLANES";
#endif
            break;
#if defined(__gl_h_)
        case 0xd33: return "GL_MAX_TEXTURE_SIZE";
        case 0xd34: return "GL_MAX_PIXEL_MAP_TABLE";
        case 0xd35: return "GL_MAX_ATTRIB_STACK_DEPTH";
#endif
        case 0xd36:
#if defined(__gl_h_)
                    return "GL_MAX_MODELVIEW_STACK_DEPTH";
#endif
#if defined(GL_NV_path_rendering)
                    return "GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV";
#endif
            break;
#if defined(__gl_h_)
        case 0xd37: return "GL_MAX_NAME_STACK_DEPTH";
#endif
        case 0xd38:
#if defined(__gl_h_)
                    return "GL_MAX_PROJECTION_STACK_DEPTH";
#endif
#if defined(GL_NV_path_rendering)
                    return "GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV";
#endif
            break;
#if defined(__gl_h_)
        case 0xd39: return "GL_MAX_TEXTURE_STACK_DEPTH";
        case 0xd3a: return "GL_MAX_VIEWPORT_DIMS";
        case 0xd3b: return "GL_MAX_CLIENT_ATTRIB_STACK_DEPTH";
        case 0xd70: return "GL_NAME_STACK_DEPTH";
        case 0xd80: return "GL_AUTO_NORMAL";
        case 0xd90: return "GL_MAP1_COLOR_4";
        case 0xd91: return "GL_MAP1_INDEX";
        case 0xd92: return "GL_MAP1_NORMAL";
        case 0xd93: return "GL_MAP1_TEXTURE_COORD_1";
        case 0xd94: return "GL_MAP1_TEXTURE_COORD_2";
        case 0xd95: return "GL_MAP1_TEXTURE_COORD_3";
        case 0xd96: return "GL_MAP1_TEXTURE_COORD_4";
        case 0xd97: return "GL_MAP1_VERTEX_3";
        case 0xd98: return "GL_MAP1_VERTEX_4";
        case 0xdb0: return "GL_MAP2_COLOR_4";
        case 0xdb1: return "GL_MAP2_INDEX";
        case 0xdb2: return "GL_MAP2_NORMAL";
        case 0xdb3: return "GL_MAP2_TEXTURE_COORD_1";
        case 0xdb4: return "GL_MAP2_TEXTURE_COORD_2";
        case 0xdb5: return "GL_MAP2_TEXTURE_COORD_3";
        case 0xdb6: return "GL_MAP2_TEXTURE_COORD_4";
        case 0xdb7: return "GL_MAP2_VERTEX_3";
        case 0xdb8: return "GL_MAP2_VERTEX_4";
        case 0xdd0: return "GL_MAP1_GRID_DOMAIN";
        case 0xdd1: return "GL_MAP1_GRID_SEGMENTS";
        case 0xdd2: return "GL_MAP2_GRID_DOMAIN";
        case 0xdd3: return "GL_MAP2_GRID_SEGMENTS";
        case 0xde0: return "GL_TEXTURE_1D";
        case 0xde1: return "GL_TEXTURE_2D";
        case 0xdf0: return "GL_FEEDBACK_BUFFER_POINTER";
        case 0xdf1: return "GL_FEEDBACK_BUFFER_SIZE";
        case 0xdf2: return "GL_FEEDBACK_BUFFER_TYPE";
        case 0xdf3: return "GL_SELECTION_BUFFER_POINTER";
        case 0xdf4: return "GL_SELECTION_BUFFER_SIZE";
        case 0x1000: return "GL_TEXTURE_WIDTH";
        case 0x1001: return "GL_TEXTURE_HEIGHT";
#endif
        case 0x1003:
#if defined(__gl_h_)
                    return "GL_TEXTURE_COMPONENTS";
#endif
#if defined(__gl_h_)
                    return "GL_TEXTURE_INTERNAL_FORMAT";
#endif
            break;
#if defined(__gl_h_)
        case 0x1004: return "GL_TEXTURE_BORDER_COLOR";
        case 0x1005: return "GL_TEXTURE_BORDER";
#endif
#if defined(GL_VERSION_4_5)
        case 0x1006: return "GL_TEXTURE_TARGET";
#endif
#if defined(__gl_h_)
        case 0x1100: return "GL_DONT_CARE";
        case 0x1101: return "GL_FASTEST";
        case 0x1102: return "GL_NICEST";
        case 0x1200: return "GL_AMBIENT";
        case 0x1201: return "GL_DIFFUSE";
        case 0x1202: return "GL_SPECULAR";
        case 0x1203: return "GL_POSITION";
        case 0x1204: return "GL_SPOT_DIRECTION";
        case 0x1205: return "GL_SPOT_EXPONENT";
        case 0x1206: return "GL_SPOT_CUTOFF";
        case 0x1207: return "GL_CONSTANT_ATTENUATION";
        case 0x1208: return "GL_LINEAR_ATTENUATION";
        case 0x1209: return "GL_QUADRATIC_ATTENUATION";
        case 0x1300: return "GL_COMPILE";
        case 0x1301: return "GL_COMPILE_AND_EXECUTE";
        case 0x1400: return "GL_BYTE";
        case 0x1401: return "GL_UNSIGNED_BYTE";
        case 0x1402: return "GL_SHORT";
        case 0x1403: return "GL_UNSIGNED_SHORT";
        case 0x1404: return "GL_INT";
        case 0x1405: return "GL_UNSIGNED_INT";
        case 0x1406: return "GL_FLOAT";
#endif
        case 0x1407:
#if defined(__gl_h_)
                    return "GL_2_BYTES";
#endif
#if defined(GL_NV_path_rendering)
                    return "GL_2_BYTES_NV";
#endif
            break;
        case 0x1408:
#if defined(__gl_h_)
                    return "GL_3_BYTES";
#endif
#if defined(GL_NV_path_rendering)
                    return "GL_3_BYTES_NV";
#endif
            break;
        case 0x1409:
#if defined(__gl_h_)
                    return "GL_4_BYTES";
#endif
#if defined(GL_NV_path_rendering)
                    return "GL_4_BYTES_NV";
#endif
            break;
#if defined(__gl_h_)
        case 0x140a: return "GL_DOUBLE";
#endif
        case 0x140b:
#if defined(GL_APPLE_float_pixels)
                    return "GL_HALF_APPLE";
#endif
#if defined(GL_VERSION_3_0)
                    return "GL_HALF_FLOAT";
#endif
#if defined(GL_ARB_half_float_pixel)
                    return "GL_HALF_FLOAT_ARB";
#endif
#if defined(GL_NV_half_float)
                    return "GL_HALF_FLOAT_NV";
#endif
            break;
        case 0x140c:
#if defined(GL_VERSION_4_1)
                    return "GL_FIXED";
#endif
#if defined(GL_OES_fixed_point)
                    return "GL_FIXED_OES";
#endif
            break;
        case 0x140e:
#if defined(GL_ARB_gpu_shader_int64)
                    return "GL_INT64_ARB";
#endif
#if defined(GL_AMD_gpu_shader_int64)
                    return "GL_INT64_NV";
#endif
            break;
        case 0x140f:
#if defined(GL_ARB_bindless_texture)
                    return "GL_UNSIGNED_INT64_ARB";
#endif
#if defined(GL_AMD_gpu_shader_int64)
                    return "GL_UNSIGNED_INT64_NV";
#endif
            break;
#if defined(__gl_h_)
        case 0x1500: return "GL_CLEAR";
        case 0x1501: return "GL_AND";
        case 0x1502: return "GL_AND_REVERSE";
        case 0x1503: return "GL_COPY";
        case 0x1504: return "GL_AND_INVERTED";
        case 0x1505: return "GL_NOOP";
#endif
        case 0x1506:
#if defined(__gl_h_)
                    return "GL_XOR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_XOR_NV";
#endif
            break;
#if defined(__gl_h_)
        case 0x1507: return "GL_OR";
        case 0x1508: return "GL_NOR";
        case 0x1509: return "GL_EQUIV";
        case 0x150a: return "GL_INVERT";
        case 0x150b: return "GL_OR_REVERSE";
        case 0x150c: return "GL_COPY_INVERTED";
        case 0x150d: return "GL_OR_INVERTED";
        case 0x150e: return "GL_NAND";
        case 0x150f: return "GL_SET";
        case 0x1600: return "GL_EMISSION";
        case 0x1601: return "GL_SHININESS";
        case 0x1602: return "GL_AMBIENT_AND_DIFFUSE";
        case 0x1603: return "GL_COLOR_INDEXES";
#endif
        case 0x1700:
#if defined(__gl_h_)
                    return "GL_MODELVIEW";
#endif
#if defined(GL_ARB_vertex_blend)
                    return "GL_MODELVIEW0_ARB";
#endif
#if defined(GL_EXT_vertex_weighting)
                    return "GL_MODELVIEW0_EXT";
#endif
#if defined(GL_NV_path_rendering)
                    return "GL_PATH_MODELVIEW_NV";
#endif
            break;
        case 0x1701:
#if defined(GL_NV_path_rendering)
                    return "GL_PATH_PROJECTION_NV";
#endif
#if defined(__gl_h_)
                    return "GL_PROJECTION";
#endif
            break;
#if defined(__gl_h_)
        case 0x1702: return "GL_TEXTURE";
        case 0x1800: return "GL_COLOR";
        case 0x1801: return "GL_DEPTH";
        case 0x1802: return "GL_STENCIL";
        case 0x1900: return "GL_COLOR_INDEX";
        case 0x1901: return "GL_STENCIL_INDEX";
        case 0x1902: return "GL_DEPTH_COMPONENT";
#endif
        case 0x1903:
#if defined(__gl_h_)
                    return "GL_RED";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_RED_NV";
#endif
            break;
        case 0x1904:
#if defined(__gl_h_)
                    return "GL_GREEN";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_GREEN_NV";
#endif
            break;
        case 0x1905:
#if defined(__gl_h_)
                    return "GL_BLUE";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_BLUE_NV";
#endif
            break;
#if defined(__gl_h_)
        case 0x1906: return "GL_ALPHA";
        case 0x1907: return "GL_RGB";
        case 0x1908: return "GL_RGBA";
        case 0x1909: return "GL_LUMINANCE";
        case 0x190a: return "GL_LUMINANCE_ALPHA";
        case 0x1a00: return "GL_BITMAP";
        case 0x1b00: return "GL_POINT";
        case 0x1b01: return "GL_LINE";
        case 0x1b02: return "GL_FILL";
        case 0x1c00: return "GL_RENDER";
        case 0x1c01: return "GL_FEEDBACK";
        case 0x1c02: return "GL_SELECT";
        case 0x1d00: return "GL_FLAT";
        case 0x1d01: return "GL_SMOOTH";
        case 0x1e00: return "GL_KEEP";
        case 0x1e01: return "GL_REPLACE";
        case 0x1e02: return "GL_INCR";
        case 0x1e03: return "GL_DECR";
        case 0x1f00: return "GL_VENDOR";
        case 0x1f01: return "GL_RENDERER";
        case 0x1f02: return "GL_VERSION";
        case 0x1f03: return "GL_EXTENSIONS";
        case 0x2000: return "GL_S";
        case 0x2001: return "GL_T";
        case 0x2002: return "GL_R";
        case 0x2003: return "GL_Q";
        case 0x2100: return "GL_MODULATE";
        case 0x2101: return "GL_DECAL";
        case 0x2200: return "GL_TEXTURE_ENV_MODE";
        case 0x2201: return "GL_TEXTURE_ENV_COLOR";
        case 0x2300: return "GL_TEXTURE_ENV";
#endif
        case 0x2400:
#if defined(__gl_h_)
                    return "GL_EYE_LINEAR";
#endif
#if defined(GL_NV_path_rendering)
                    return "GL_EYE_LINEAR_NV";
#endif
            break;
        case 0x2401:
#if defined(__gl_h_)
                    return "GL_OBJECT_LINEAR";
#endif
#if defined(GL_NV_path_rendering)
                    return "GL_OBJECT_LINEAR_NV";
#endif
            break;
#if defined(__gl_h_)
        case 0x2402: return "GL_SPHERE_MAP";
        case 0x2500: return "GL_TEXTURE_GEN_MODE";
        case 0x2501: return "GL_OBJECT_PLANE";
        case 0x2502: return "GL_EYE_PLANE";
        case 0x2600: return "GL_NEAREST";
        case 0x2601: return "GL_LINEAR";
        case 0x2700: return "GL_NEAREST_MIPMAP_NEAREST";
        case 0x2701: return "GL_LINEAR_MIPMAP_NEAREST";
        case 0x2702: return "GL_NEAREST_MIPMAP_LINEAR";
        case 0x2703: return "GL_LINEAR_MIPMAP_LINEAR";
        case 0x2800: return "GL_TEXTURE_MAG_FILTER";
        case 0x2801: return "GL_TEXTURE_MIN_FILTER";
        case 0x2802: return "GL_TEXTURE_WRAP_S";
        case 0x2803: return "GL_TEXTURE_WRAP_T";
        case 0x2900: return "GL_CLAMP";
        case 0x2901: return "GL_REPEAT";
        case 0x2a00: return "GL_POLYGON_OFFSET_UNITS";
        case 0x2a01: return "GL_POLYGON_OFFSET_POINT";
        case 0x2a02: return "GL_POLYGON_OFFSET_LINE";
        case 0x2a10: return "GL_R3_G3_B2";
        case 0x2a20: return "GL_V2F";
        case 0x2a21: return "GL_V3F";
        case 0x2a22: return "GL_C4UB_V2F";
        case 0x2a23: return "GL_C4UB_V3F";
        case 0x2a24: return "GL_C3F_V3F";
        case 0x2a25: return "GL_N3F_V3F";
        case 0x2a26: return "GL_C4F_N3F_V3F";
        case 0x2a27: return "GL_T2F_V3F";
        case 0x2a28: return "GL_T4F_V4F";
        case 0x2a29: return "GL_T2F_C4UB_V3F";
        case 0x2a2a: return "GL_T2F_C3F_V3F";
        case 0x2a2b: return "GL_T2F_N3F_V3F";
        case 0x2a2c: return "GL_T2F_C4F_N3F_V3F";
        case 0x2a2d: return "GL_T4F_C4F_N3F_V4F";
#endif
        case 0x3000:
#if defined(GL_VERSION_3_0)
                    return "GL_CLIP_DISTANCE0";
#endif
#if defined(__gl_h_)
                    return "GL_CLIP_PLANE0";
#endif
            break;
        case 0x3001:
#if defined(GL_VERSION_3_0)
                    return "GL_CLIP_DISTANCE1";
#endif
#if defined(__gl_h_)
                    return "GL_CLIP_PLANE1";
#endif
            break;
        case 0x3002:
#if defined(GL_VERSION_3_0)
                    return "GL_CLIP_DISTANCE2";
#endif
#if defined(__gl_h_)
                    return "GL_CLIP_PLANE2";
#endif
            break;
        case 0x3003:
#if defined(GL_VERSION_3_0)
                    return "GL_CLIP_DISTANCE3";
#endif
#if defined(__gl_h_)
                    return "GL_CLIP_PLANE3";
#endif
            break;
        case 0x3004:
#if defined(GL_VERSION_3_0)
                    return "GL_CLIP_DISTANCE4";
#endif
#if defined(__gl_h_)
                    return "GL_CLIP_PLANE4";
#endif
            break;
        case 0x3005:
#if defined(GL_VERSION_3_0)
                    return "GL_CLIP_DISTANCE5";
#endif
#if defined(__gl_h_)
                    return "GL_CLIP_PLANE5";
#endif
            break;
#if defined(GL_VERSION_3_0)
        case 0x3006: return "GL_CLIP_DISTANCE6";
        case 0x3007: return "GL_CLIP_DISTANCE7";
#endif
#if defined(__gl_h_)
        case 0x4000: return "GL_LIGHT0";
        case 0x4001: return "GL_LIGHT1";
        case 0x4002: return "GL_LIGHT2";
        case 0x4003: return "GL_LIGHT3";
        case 0x4004: return "GL_LIGHT4";
        case 0x4005: return "GL_LIGHT5";
        case 0x4006: return "GL_LIGHT6";
        case 0x4007: return "GL_LIGHT7";
#endif
#if defined(GL_EXT_abgr)
        case 0x8000: return "GL_ABGR_EXT";
#endif
        case 0x8001:
#if defined(__gl_h_) || defined(GL_VERSION_1_4)
                    return "GL_CONSTANT_COLOR";
#endif
#if defined(GL_EXT_blend_color)
                    return "GL_CONSTANT_COLOR_EXT";
#endif
            break;
        case 0x8002:
#if defined(__gl_h_) || defined(GL_VERSION_1_4)
                    return "GL_ONE_MINUS_CONSTANT_COLOR";
#endif
#if defined(GL_EXT_blend_color)
                    return "GL_ONE_MINUS_CONSTANT_COLOR_EXT";
#endif
            break;
        case 0x8003:
#if defined(__gl_h_) || defined(GL_VERSION_1_4)
                    return "GL_CONSTANT_ALPHA";
#endif
#if defined(GL_EXT_blend_color)
                    return "GL_CONSTANT_ALPHA_EXT";
#endif
            break;
        case 0x8004:
#if defined(__gl_h_) || defined(GL_VERSION_1_4)
                    return "GL_ONE_MINUS_CONSTANT_ALPHA";
#endif
#if defined(GL_EXT_blend_color)
                    return "GL_ONE_MINUS_CONSTANT_ALPHA_EXT";
#endif
            break;
        case 0x8005:
#if defined(__gl_h_) || defined(GL_VERSION_1_4)
                    return "GL_BLEND_COLOR";
#endif
#if defined(GL_EXT_blend_color)
                    return "GL_BLEND_COLOR_EXT";
#endif
            break;
        case 0x8006:
#if defined(__gl_h_) || defined(GL_VERSION_1_4)
                    return "GL_FUNC_ADD";
#endif
#if defined(GL_EXT_blend_minmax)
                    return "GL_FUNC_ADD_EXT";
#endif
            break;
        case 0x8007:
#if defined(__gl_h_) || defined(GL_VERSION_1_4)
                    return "GL_MIN";
#endif
#if defined(GL_EXT_blend_minmax)
                    return "GL_MIN_EXT";
#endif
            break;
        case 0x8008:
#if defined(__gl_h_) || defined(GL_VERSION_1_4)
                    return "GL_MAX";
#endif
#if defined(GL_EXT_blend_minmax)
                    return "GL_MAX_EXT";
#endif
            break;
        case 0x8009:
#if defined(__gl_h_) || defined(GL_VERSION_1_4)
                    return "GL_BLEND_EQUATION";
#endif
#if defined(GL_EXT_blend_minmax)
                    return "GL_BLEND_EQUATION_EXT";
#endif
#if defined(GL_VERSION_2_0)
                    return "GL_BLEND_EQUATION_RGB";
#endif
#if defined(GL_EXT_blend_equation_separate)
                    return "GL_BLEND_EQUATION_RGB_EXT";
#endif
            break;
        case 0x800a:
#if defined(__gl_h_) || defined(GL_VERSION_1_4)
                    return "GL_FUNC_SUBTRACT";
#endif
#if defined(GL_EXT_blend_subtract)
                    return "GL_FUNC_SUBTRACT_EXT";
#endif
            break;
        case 0x800b:
#if defined(__gl_h_) || defined(GL_VERSION_1_4)
                    return "GL_FUNC_REVERSE_SUBTRACT";
#endif
#if defined(GL_EXT_blend_subtract)
                    return "GL_FUNC_REVERSE_SUBTRACT_EXT";
#endif
            break;
#if defined(GL_EXT_cmyka)
        case 0x800c: return "GL_CMYK_EXT";
        case 0x800d: return "GL_CMYKA_EXT";
        case 0x800e: return "GL_PACK_CMYK_HINT_EXT";
        case 0x800f: return "GL_UNPACK_CMYK_HINT_EXT";
#endif
        case 0x8010:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_CONVOLUTION_1D";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_CONVOLUTION_1D_EXT";
#endif
            break;
        case 0x8011:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_CONVOLUTION_2D";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_CONVOLUTION_2D_EXT";
#endif
            break;
        case 0x8012:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_SEPARABLE_2D";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_SEPARABLE_2D_EXT";
#endif
            break;
        case 0x8013:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_CONVOLUTION_BORDER_MODE";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_CONVOLUTION_BORDER_MODE_EXT";
#endif
            break;
        case 0x8014:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_CONVOLUTION_FILTER_SCALE";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_CONVOLUTION_FILTER_SCALE_EXT";
#endif
            break;
        case 0x8015:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_CONVOLUTION_FILTER_BIAS";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_CONVOLUTION_FILTER_BIAS_EXT";
#endif
            break;
        case 0x8016:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_REDUCE";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_REDUCE_EXT";
#endif
            break;
        case 0x8017:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_CONVOLUTION_FORMAT";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_CONVOLUTION_FORMAT_EXT";
#endif
            break;
        case 0x8018:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_CONVOLUTION_WIDTH";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_CONVOLUTION_WIDTH_EXT";
#endif
            break;
        case 0x8019:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_CONVOLUTION_HEIGHT";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_CONVOLUTION_HEIGHT_EXT";
#endif
            break;
        case 0x801a:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_MAX_CONVOLUTION_WIDTH";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_MAX_CONVOLUTION_WIDTH_EXT";
#endif
            break;
        case 0x801b:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_MAX_CONVOLUTION_HEIGHT";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_MAX_CONVOLUTION_HEIGHT_EXT";
#endif
            break;
        case 0x801c:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_CONVOLUTION_RED_SCALE";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_POST_CONVOLUTION_RED_SCALE_EXT";
#endif
            break;
        case 0x801d:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_CONVOLUTION_GREEN_SCALE";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_POST_CONVOLUTION_GREEN_SCALE_EXT";
#endif
            break;
        case 0x801e:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_CONVOLUTION_BLUE_SCALE";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_POST_CONVOLUTION_BLUE_SCALE_EXT";
#endif
            break;
        case 0x801f:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_CONVOLUTION_ALPHA_SCALE";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_POST_CONVOLUTION_ALPHA_SCALE_EXT";
#endif
            break;
        case 0x8020:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_CONVOLUTION_RED_BIAS";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_POST_CONVOLUTION_RED_BIAS_EXT";
#endif
            break;
        case 0x8021:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_CONVOLUTION_GREEN_BIAS";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_POST_CONVOLUTION_GREEN_BIAS_EXT";
#endif
            break;
        case 0x8022:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_CONVOLUTION_BLUE_BIAS";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_POST_CONVOLUTION_BLUE_BIAS_EXT";
#endif
            break;
        case 0x8023:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_CONVOLUTION_ALPHA_BIAS";
#endif
#if defined(GL_EXT_convolution)
                    return "GL_POST_CONVOLUTION_ALPHA_BIAS_EXT";
#endif
            break;
        case 0x8024:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_HISTOGRAM";
#endif
#if defined(GL_EXT_histogram)
                    return "GL_HISTOGRAM_EXT";
#endif
            break;
        case 0x8025:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_PROXY_HISTOGRAM";
#endif
#if defined(GL_EXT_histogram)
                    return "GL_PROXY_HISTOGRAM_EXT";
#endif
            break;
        case 0x8026:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_HISTOGRAM_WIDTH";
#endif
#if defined(GL_EXT_histogram)
                    return "GL_HISTOGRAM_WIDTH_EXT";
#endif
            break;
        case 0x8027:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_HISTOGRAM_FORMAT";
#endif
#if defined(GL_EXT_histogram)
                    return "GL_HISTOGRAM_FORMAT_EXT";
#endif
            break;
        case 0x8028:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_HISTOGRAM_RED_SIZE";
#endif
#if defined(GL_EXT_histogram)
                    return "GL_HISTOGRAM_RED_SIZE_EXT";
#endif
            break;
        case 0x8029:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_HISTOGRAM_GREEN_SIZE";
#endif
#if defined(GL_EXT_histogram)
                    return "GL_HISTOGRAM_GREEN_SIZE_EXT";
#endif
            break;
        case 0x802a:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_HISTOGRAM_BLUE_SIZE";
#endif
#if defined(GL_EXT_histogram)
                    return "GL_HISTOGRAM_BLUE_SIZE_EXT";
#endif
            break;
        case 0x802b:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_HISTOGRAM_ALPHA_SIZE";
#endif
#if defined(GL_EXT_histogram)
                    return "GL_HISTOGRAM_ALPHA_SIZE_EXT";
#endif
            break;
        case 0x802c:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_HISTOGRAM_LUMINANCE_SIZE";
#endif
#if defined(GL_EXT_histogram)
                    return "GL_HISTOGRAM_LUMINANCE_SIZE_EXT";
#endif
            break;
        case 0x802d:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_HISTOGRAM_SINK";
#endif
#if defined(GL_EXT_histogram)
                    return "GL_HISTOGRAM_SINK_EXT";
#endif
            break;
        case 0x802e:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_MINMAX";
#endif
#if defined(GL_EXT_histogram)
                    return "GL_MINMAX_EXT";
#endif
            break;
        case 0x802f:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_MINMAX_FORMAT";
#endif
#if defined(GL_EXT_histogram)
                    return "GL_MINMAX_FORMAT_EXT";
#endif
            break;
        case 0x8030:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_MINMAX_SINK";
#endif
#if defined(GL_EXT_histogram)
                    return "GL_MINMAX_SINK_EXT";
#endif
            break;
        case 0x8031:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_TABLE_TOO_LARGE";
#endif
#if defined(GL_EXT_histogram)
                    return "GL_TABLE_TOO_LARGE_EXT";
#endif
            break;
        case 0x8032:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_UNSIGNED_BYTE_3_3_2";
#endif
#if defined(GL_EXT_packed_pixels)
                    return "GL_UNSIGNED_BYTE_3_3_2_EXT";
#endif
            break;
        case 0x8033:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_UNSIGNED_SHORT_4_4_4_4";
#endif
#if defined(GL_EXT_packed_pixels)
                    return "GL_UNSIGNED_SHORT_4_4_4_4_EXT";
#endif
            break;
        case 0x8034:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_UNSIGNED_SHORT_5_5_5_1";
#endif
#if defined(GL_EXT_packed_pixels)
                    return "GL_UNSIGNED_SHORT_5_5_5_1_EXT";
#endif
            break;
        case 0x8035:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_UNSIGNED_INT_8_8_8_8";
#endif
#if defined(GL_EXT_packed_pixels)
                    return "GL_UNSIGNED_INT_8_8_8_8_EXT";
#endif
            break;
        case 0x8036:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_UNSIGNED_INT_10_10_10_2";
#endif
#if defined(GL_EXT_packed_pixels)
                    return "GL_UNSIGNED_INT_10_10_10_2_EXT";
#endif
            break;
        case 0x8037:
#if defined(GL_EXT_polygon_offset)
                    return "GL_POLYGON_OFFSET_EXT";
#endif
#if defined(__gl_h_)
                    return "GL_POLYGON_OFFSET_FILL";
#endif
            break;
        case 0x8038:
#if defined(__gl_h_)
                    return "GL_POLYGON_OFFSET_FACTOR";
#endif
#if defined(GL_EXT_polygon_offset)
                    return "GL_POLYGON_OFFSET_FACTOR_EXT";
#endif
            break;
#if defined(GL_EXT_polygon_offset)
        case 0x8039: return "GL_POLYGON_OFFSET_BIAS_EXT";
#endif
        case 0x803a:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_RESCALE_NORMAL";
#endif
#if defined(GL_EXT_rescale_normal)
                    return "GL_RESCALE_NORMAL_EXT";
#endif
            break;
        case 0x803b:
#if defined(__gl_h_)
                    return "GL_ALPHA4";
#endif
#if defined(GL_EXT_texture)
                    return "GL_ALPHA4_EXT";
#endif
            break;
        case 0x803c:
#if defined(__gl_h_)
                    return "GL_ALPHA8";
#endif
#if defined(GL_EXT_texture)
                    return "GL_ALPHA8_EXT";
#endif
            break;
        case 0x803d:
#if defined(__gl_h_)
                    return "GL_ALPHA12";
#endif
#if defined(GL_EXT_texture)
                    return "GL_ALPHA12_EXT";
#endif
            break;
        case 0x803e:
#if defined(__gl_h_)
                    return "GL_ALPHA16";
#endif
#if defined(GL_EXT_texture)
                    return "GL_ALPHA16_EXT";
#endif
            break;
        case 0x803f:
#if defined(__gl_h_)
                    return "GL_LUMINANCE4";
#endif
#if defined(GL_EXT_texture)
                    return "GL_LUMINANCE4_EXT";
#endif
            break;
        case 0x8040:
#if defined(__gl_h_)
                    return "GL_LUMINANCE8";
#endif
#if defined(GL_EXT_texture)
                    return "GL_LUMINANCE8_EXT";
#endif
            break;
        case 0x8041:
#if defined(__gl_h_)
                    return "GL_LUMINANCE12";
#endif
#if defined(GL_EXT_texture)
                    return "GL_LUMINANCE12_EXT";
#endif
            break;
        case 0x8042:
#if defined(__gl_h_)
                    return "GL_LUMINANCE16";
#endif
#if defined(GL_EXT_texture)
                    return "GL_LUMINANCE16_EXT";
#endif
            break;
        case 0x8043:
#if defined(__gl_h_)
                    return "GL_LUMINANCE4_ALPHA4";
#endif
#if defined(GL_EXT_texture)
                    return "GL_LUMINANCE4_ALPHA4_EXT";
#endif
            break;
        case 0x8044:
#if defined(__gl_h_)
                    return "GL_LUMINANCE6_ALPHA2";
#endif
#if defined(GL_EXT_texture)
                    return "GL_LUMINANCE6_ALPHA2_EXT";
#endif
            break;
        case 0x8045:
#if defined(__gl_h_)
                    return "GL_LUMINANCE8_ALPHA8";
#endif
#if defined(GL_EXT_texture)
                    return "GL_LUMINANCE8_ALPHA8_EXT";
#endif
            break;
        case 0x8046:
#if defined(__gl_h_)
                    return "GL_LUMINANCE12_ALPHA4";
#endif
#if defined(GL_EXT_texture)
                    return "GL_LUMINANCE12_ALPHA4_EXT";
#endif
            break;
        case 0x8047:
#if defined(__gl_h_)
                    return "GL_LUMINANCE12_ALPHA12";
#endif
#if defined(GL_EXT_texture)
                    return "GL_LUMINANCE12_ALPHA12_EXT";
#endif
            break;
        case 0x8048:
#if defined(__gl_h_)
                    return "GL_LUMINANCE16_ALPHA16";
#endif
#if defined(GL_EXT_texture)
                    return "GL_LUMINANCE16_ALPHA16_EXT";
#endif
            break;
        case 0x8049:
#if defined(__gl_h_)
                    return "GL_INTENSITY";
#endif
#if defined(GL_EXT_texture)
                    return "GL_INTENSITY_EXT";
#endif
            break;
        case 0x804a:
#if defined(__gl_h_)
                    return "GL_INTENSITY4";
#endif
#if defined(GL_EXT_texture)
                    return "GL_INTENSITY4_EXT";
#endif
            break;
        case 0x804b:
#if defined(__gl_h_)
                    return "GL_INTENSITY8";
#endif
#if defined(GL_EXT_texture)
                    return "GL_INTENSITY8_EXT";
#endif
            break;
        case 0x804c:
#if defined(__gl_h_)
                    return "GL_INTENSITY12";
#endif
#if defined(GL_EXT_texture)
                    return "GL_INTENSITY12_EXT";
#endif
            break;
        case 0x804d:
#if defined(__gl_h_)
                    return "GL_INTENSITY16";
#endif
#if defined(GL_EXT_texture)
                    return "GL_INTENSITY16_EXT";
#endif
            break;
#if defined(GL_EXT_texture)
        case 0x804e: return "GL_RGB2_EXT";
#endif
        case 0x804f:
#if defined(__gl_h_)
                    return "GL_RGB4";
#endif
#if defined(GL_EXT_texture)
                    return "GL_RGB4_EXT";
#endif
            break;
        case 0x8050:
#if defined(__gl_h_)
                    return "GL_RGB5";
#endif
#if defined(GL_EXT_texture)
                    return "GL_RGB5_EXT";
#endif
            break;
        case 0x8051:
#if defined(__gl_h_)
                    return "GL_RGB8";
#endif
#if defined(GL_EXT_texture)
                    return "GL_RGB8_EXT";
#endif
            break;
        case 0x8052:
#if defined(__gl_h_)
                    return "GL_RGB10";
#endif
#if defined(GL_EXT_texture)
                    return "GL_RGB10_EXT";
#endif
            break;
        case 0x8053:
#if defined(__gl_h_)
                    return "GL_RGB12";
#endif
#if defined(GL_EXT_texture)
                    return "GL_RGB12_EXT";
#endif
            break;
        case 0x8054:
#if defined(__gl_h_)
                    return "GL_RGB16";
#endif
#if defined(GL_EXT_texture)
                    return "GL_RGB16_EXT";
#endif
            break;
        case 0x8055:
#if defined(__gl_h_)
                    return "GL_RGBA2";
#endif
#if defined(GL_EXT_texture)
                    return "GL_RGBA2_EXT";
#endif
            break;
        case 0x8056:
#if defined(__gl_h_)
                    return "GL_RGBA4";
#endif
#if defined(GL_EXT_texture)
                    return "GL_RGBA4_EXT";
#endif
            break;
        case 0x8057:
#if defined(__gl_h_)
                    return "GL_RGB5_A1";
#endif
#if defined(GL_EXT_texture)
                    return "GL_RGB5_A1_EXT";
#endif
            break;
        case 0x8058:
#if defined(__gl_h_)
                    return "GL_RGBA8";
#endif
#if defined(GL_EXT_texture)
                    return "GL_RGBA8_EXT";
#endif
            break;
        case 0x8059:
#if defined(__gl_h_)
                    return "GL_RGB10_A2";
#endif
#if defined(GL_EXT_texture)
                    return "GL_RGB10_A2_EXT";
#endif
            break;
        case 0x805a:
#if defined(__gl_h_)
                    return "GL_RGBA12";
#endif
#if defined(GL_EXT_texture)
                    return "GL_RGBA12_EXT";
#endif
            break;
        case 0x805b:
#if defined(__gl_h_)
                    return "GL_RGBA16";
#endif
#if defined(GL_EXT_texture)
                    return "GL_RGBA16_EXT";
#endif
            break;
        case 0x805c:
#if defined(__gl_h_)
                    return "GL_TEXTURE_RED_SIZE";
#endif
#if defined(GL_EXT_texture)
                    return "GL_TEXTURE_RED_SIZE_EXT";
#endif
            break;
        case 0x805d:
#if defined(__gl_h_)
                    return "GL_TEXTURE_GREEN_SIZE";
#endif
#if defined(GL_EXT_texture)
                    return "GL_TEXTURE_GREEN_SIZE_EXT";
#endif
            break;
        case 0x805e:
#if defined(__gl_h_)
                    return "GL_TEXTURE_BLUE_SIZE";
#endif
#if defined(GL_EXT_texture)
                    return "GL_TEXTURE_BLUE_SIZE_EXT";
#endif
            break;
        case 0x805f:
#if defined(__gl_h_)
                    return "GL_TEXTURE_ALPHA_SIZE";
#endif
#if defined(GL_EXT_texture)
                    return "GL_TEXTURE_ALPHA_SIZE_EXT";
#endif
            break;
        case 0x8060:
#if defined(__gl_h_)
                    return "GL_TEXTURE_LUMINANCE_SIZE";
#endif
#if defined(GL_EXT_texture)
                    return "GL_TEXTURE_LUMINANCE_SIZE_EXT";
#endif
            break;
        case 0x8061:
#if defined(__gl_h_)
                    return "GL_TEXTURE_INTENSITY_SIZE";
#endif
#if defined(GL_EXT_texture)
                    return "GL_TEXTURE_INTENSITY_SIZE_EXT";
#endif
            break;
#if defined(GL_EXT_texture)
        case 0x8062: return "GL_REPLACE_EXT";
#endif
        case 0x8063:
#if defined(__gl_h_)
                    return "GL_PROXY_TEXTURE_1D";
#endif
#if defined(GL_EXT_texture)
                    return "GL_PROXY_TEXTURE_1D_EXT";
#endif
            break;
        case 0x8064:
#if defined(__gl_h_)
                    return "GL_PROXY_TEXTURE_2D";
#endif
#if defined(GL_EXT_texture)
                    return "GL_PROXY_TEXTURE_2D_EXT";
#endif
            break;
#if defined(GL_EXT_texture)
        case 0x8065: return "GL_TEXTURE_TOO_LARGE_EXT";
#endif
        case 0x8066:
#if defined(__gl_h_)
                    return "GL_TEXTURE_PRIORITY";
#endif
#if defined(GL_EXT_texture_object)
                    return "GL_TEXTURE_PRIORITY_EXT";
#endif
            break;
        case 0x8067:
#if defined(__gl_h_)
                    return "GL_TEXTURE_RESIDENT";
#endif
#if defined(GL_EXT_texture_object)
                    return "GL_TEXTURE_RESIDENT_EXT";
#endif
            break;
        case 0x8068:
#if defined(GL_EXT_texture_object)
                    return "GL_TEXTURE_1D_BINDING_EXT";
#endif
#if defined(__gl_h_)
                    return "GL_TEXTURE_BINDING_1D";
#endif
            break;
        case 0x8069:
#if defined(GL_EXT_texture_object)
                    return "GL_TEXTURE_2D_BINDING_EXT";
#endif
#if defined(__gl_h_)
                    return "GL_TEXTURE_BINDING_2D";
#endif
            break;
        case 0x806a:
#if defined(GL_EXT_texture_object)
                    return "GL_TEXTURE_3D_BINDING_EXT";
#endif
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_TEXTURE_BINDING_3D";
#endif
            break;
        case 0x806b:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_PACK_SKIP_IMAGES";
#endif
#if defined(GL_EXT_texture3D)
                    return "GL_PACK_SKIP_IMAGES_EXT";
#endif
            break;
        case 0x806c:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_PACK_IMAGE_HEIGHT";
#endif
#if defined(GL_EXT_texture3D)
                    return "GL_PACK_IMAGE_HEIGHT_EXT";
#endif
            break;
        case 0x806d:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_UNPACK_SKIP_IMAGES";
#endif
#if defined(GL_EXT_texture3D)
                    return "GL_UNPACK_SKIP_IMAGES_EXT";
#endif
            break;
        case 0x806e:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_UNPACK_IMAGE_HEIGHT";
#endif
#if defined(GL_EXT_texture3D)
                    return "GL_UNPACK_IMAGE_HEIGHT_EXT";
#endif
            break;
        case 0x806f:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_TEXTURE_3D";
#endif
#if defined(GL_EXT_texture3D)
                    return "GL_TEXTURE_3D_EXT";
#endif
            break;
        case 0x8070:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_PROXY_TEXTURE_3D";
#endif
#if defined(GL_EXT_texture3D)
                    return "GL_PROXY_TEXTURE_3D_EXT";
#endif
            break;
        case 0x8071:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_TEXTURE_DEPTH";
#endif
#if defined(GL_EXT_texture3D)
                    return "GL_TEXTURE_DEPTH_EXT";
#endif
            break;
        case 0x8072:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_TEXTURE_WRAP_R";
#endif
#if defined(GL_EXT_texture3D)
                    return "GL_TEXTURE_WRAP_R_EXT";
#endif
            break;
        case 0x8073:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_MAX_3D_TEXTURE_SIZE";
#endif
#if defined(GL_EXT_texture3D)
                    return "GL_MAX_3D_TEXTURE_SIZE_EXT";
#endif
            break;
        case 0x8074:
#if defined(__gl_h_)
                    return "GL_VERTEX_ARRAY";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_VERTEX_ARRAY_EXT";
#endif
            break;
        case 0x8075:
#if defined(__gl_h_)
                    return "GL_NORMAL_ARRAY";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_NORMAL_ARRAY_EXT";
#endif
            break;
        case 0x8076:
#if defined(__gl_h_)
                    return "GL_COLOR_ARRAY";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_COLOR_ARRAY_EXT";
#endif
            break;
        case 0x8077:
#if defined(__gl_h_)
                    return "GL_INDEX_ARRAY";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_INDEX_ARRAY_EXT";
#endif
            break;
        case 0x8078:
#if defined(__gl_h_)
                    return "GL_TEXTURE_COORD_ARRAY";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_TEXTURE_COORD_ARRAY_EXT";
#endif
            break;
        case 0x8079:
#if defined(__gl_h_)
                    return "GL_EDGE_FLAG_ARRAY";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_EDGE_FLAG_ARRAY_EXT";
#endif
            break;
        case 0x807a:
#if defined(__gl_h_)
                    return "GL_VERTEX_ARRAY_SIZE";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_VERTEX_ARRAY_SIZE_EXT";
#endif
            break;
        case 0x807b:
#if defined(__gl_h_)
                    return "GL_VERTEX_ARRAY_TYPE";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_VERTEX_ARRAY_TYPE_EXT";
#endif
            break;
        case 0x807c:
#if defined(__gl_h_)
                    return "GL_VERTEX_ARRAY_STRIDE";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_VERTEX_ARRAY_STRIDE_EXT";
#endif
            break;
#if defined(GL_EXT_vertex_array)
        case 0x807d: return "GL_VERTEX_ARRAY_COUNT_EXT";
#endif
        case 0x807e:
#if defined(__gl_h_)
                    return "GL_NORMAL_ARRAY_TYPE";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_NORMAL_ARRAY_TYPE_EXT";
#endif
            break;
        case 0x807f:
#if defined(__gl_h_)
                    return "GL_NORMAL_ARRAY_STRIDE";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_NORMAL_ARRAY_STRIDE_EXT";
#endif
            break;
#if defined(GL_EXT_vertex_array)
        case 0x8080: return "GL_NORMAL_ARRAY_COUNT_EXT";
#endif
        case 0x8081:
#if defined(__gl_h_)
                    return "GL_COLOR_ARRAY_SIZE";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_COLOR_ARRAY_SIZE_EXT";
#endif
            break;
        case 0x8082:
#if defined(__gl_h_)
                    return "GL_COLOR_ARRAY_TYPE";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_COLOR_ARRAY_TYPE_EXT";
#endif
            break;
        case 0x8083:
#if defined(__gl_h_)
                    return "GL_COLOR_ARRAY_STRIDE";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_COLOR_ARRAY_STRIDE_EXT";
#endif
            break;
#if defined(GL_EXT_vertex_array)
        case 0x8084: return "GL_COLOR_ARRAY_COUNT_EXT";
#endif
        case 0x8085:
#if defined(__gl_h_)
                    return "GL_INDEX_ARRAY_TYPE";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_INDEX_ARRAY_TYPE_EXT";
#endif
            break;
        case 0x8086:
#if defined(__gl_h_)
                    return "GL_INDEX_ARRAY_STRIDE";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_INDEX_ARRAY_STRIDE_EXT";
#endif
            break;
#if defined(GL_EXT_vertex_array)
        case 0x8087: return "GL_INDEX_ARRAY_COUNT_EXT";
#endif
        case 0x8088:
#if defined(__gl_h_)
                    return "GL_TEXTURE_COORD_ARRAY_SIZE";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_TEXTURE_COORD_ARRAY_SIZE_EXT";
#endif
            break;
        case 0x8089:
#if defined(__gl_h_)
                    return "GL_TEXTURE_COORD_ARRAY_TYPE";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_TEXTURE_COORD_ARRAY_TYPE_EXT";
#endif
            break;
        case 0x808a:
#if defined(__gl_h_)
                    return "GL_TEXTURE_COORD_ARRAY_STRIDE";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_TEXTURE_COORD_ARRAY_STRIDE_EXT";
#endif
            break;
#if defined(GL_EXT_vertex_array)
        case 0x808b: return "GL_TEXTURE_COORD_ARRAY_COUNT_EXT";
#endif
        case 0x808c:
#if defined(__gl_h_)
                    return "GL_EDGE_FLAG_ARRAY_STRIDE";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_EDGE_FLAG_ARRAY_STRIDE_EXT";
#endif
            break;
#if defined(GL_EXT_vertex_array)
        case 0x808d: return "GL_EDGE_FLAG_ARRAY_COUNT_EXT";
#endif
        case 0x808e:
#if defined(__gl_h_)
                    return "GL_VERTEX_ARRAY_POINTER";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_VERTEX_ARRAY_POINTER_EXT";
#endif
            break;
        case 0x808f:
#if defined(__gl_h_)
                    return "GL_NORMAL_ARRAY_POINTER";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_NORMAL_ARRAY_POINTER_EXT";
#endif
            break;
        case 0x8090:
#if defined(__gl_h_)
                    return "GL_COLOR_ARRAY_POINTER";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_COLOR_ARRAY_POINTER_EXT";
#endif
            break;
        case 0x8091:
#if defined(__gl_h_)
                    return "GL_INDEX_ARRAY_POINTER";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_INDEX_ARRAY_POINTER_EXT";
#endif
            break;
        case 0x8092:
#if defined(__gl_h_)
                    return "GL_TEXTURE_COORD_ARRAY_POINTER";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_TEXTURE_COORD_ARRAY_POINTER_EXT";
#endif
            break;
        case 0x8093:
#if defined(__gl_h_)
                    return "GL_EDGE_FLAG_ARRAY_POINTER";
#endif
#if defined(GL_EXT_vertex_array)
                    return "GL_EDGE_FLAG_ARRAY_POINTER_EXT";
#endif
            break;
#if defined(GL_SGIX_interlace)
        case 0x8094: return "GL_INTERLACE_SGIX";
#endif
#if defined(GL_SGIS_detail_texture)
        case 0x8095: return "GL_DETAIL_TEXTURE_2D_SGIS";
        case 0x8096: return "GL_DETAIL_TEXTURE_2D_BINDING_SGIS";
        case 0x8097: return "GL_LINEAR_DETAIL_SGIS";
        case 0x8098: return "GL_LINEAR_DETAIL_ALPHA_SGIS";
        case 0x8099: return "GL_LINEAR_DETAIL_COLOR_SGIS";
        case 0x809a: return "GL_DETAIL_TEXTURE_LEVEL_SGIS";
        case 0x809b: return "GL_DETAIL_TEXTURE_MODE_SGIS";
        case 0x809c: return "GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS";
#endif
        case 0x809d:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_MULTISAMPLE";
#endif
#if defined(GL_ARB_multisample)
                    return "GL_MULTISAMPLE_ARB";
#endif
#if defined(GL_EXT_multisample)
                    return "GL_MULTISAMPLE_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_MULTISAMPLE_SGIS";
#endif
            break;
        case 0x809e:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_SAMPLE_ALPHA_TO_COVERAGE";
#endif
#if defined(GL_ARB_multisample)
                    return "GL_SAMPLE_ALPHA_TO_COVERAGE_ARB";
#endif
#if defined(GL_EXT_multisample)
                    return "GL_SAMPLE_ALPHA_TO_MASK_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_SAMPLE_ALPHA_TO_MASK_SGIS";
#endif
            break;
        case 0x809f:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_SAMPLE_ALPHA_TO_ONE";
#endif
#if defined(GL_ARB_multisample)
                    return "GL_SAMPLE_ALPHA_TO_ONE_ARB";
#endif
#if defined(GL_EXT_multisample)
                    return "GL_SAMPLE_ALPHA_TO_ONE_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_SAMPLE_ALPHA_TO_ONE_SGIS";
#endif
            break;
        case 0x80a0:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_SAMPLE_COVERAGE";
#endif
#if defined(GL_ARB_multisample)
                    return "GL_SAMPLE_COVERAGE_ARB";
#endif
#if defined(GL_EXT_multisample)
                    return "GL_SAMPLE_MASK_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_SAMPLE_MASK_SGIS";
#endif
            break;
        case 0x80a1:
#if defined(GL_EXT_multisample)
                    return "GL_1PASS_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_1PASS_SGIS";
#endif
            break;
        case 0x80a2:
#if defined(GL_EXT_multisample)
                    return "GL_2PASS_0_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_2PASS_0_SGIS";
#endif
            break;
        case 0x80a3:
#if defined(GL_EXT_multisample)
                    return "GL_2PASS_1_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_2PASS_1_SGIS";
#endif
            break;
        case 0x80a4:
#if defined(GL_EXT_multisample)
                    return "GL_4PASS_0_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_4PASS_0_SGIS";
#endif
            break;
        case 0x80a5:
#if defined(GL_EXT_multisample)
                    return "GL_4PASS_1_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_4PASS_1_SGIS";
#endif
            break;
        case 0x80a6:
#if defined(GL_EXT_multisample)
                    return "GL_4PASS_2_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_4PASS_2_SGIS";
#endif
            break;
        case 0x80a7:
#if defined(GL_EXT_multisample)
                    return "GL_4PASS_3_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_4PASS_3_SGIS";
#endif
            break;
        case 0x80a8:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_SAMPLE_BUFFERS";
#endif
#if defined(GL_ARB_multisample)
                    return "GL_SAMPLE_BUFFERS_ARB";
#endif
#if defined(GL_EXT_multisample)
                    return "GL_SAMPLE_BUFFERS_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_SAMPLE_BUFFERS_SGIS";
#endif
            break;
        case 0x80a9:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_SAMPLES";
#endif
#if defined(GL_ARB_multisample)
                    return "GL_SAMPLES_ARB";
#endif
#if defined(GL_EXT_multisample)
                    return "GL_SAMPLES_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_SAMPLES_SGIS";
#endif
            break;
        case 0x80aa:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_SAMPLE_COVERAGE_VALUE";
#endif
#if defined(GL_ARB_multisample)
                    return "GL_SAMPLE_COVERAGE_VALUE_ARB";
#endif
#if defined(GL_EXT_multisample)
                    return "GL_SAMPLE_MASK_VALUE_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_SAMPLE_MASK_VALUE_SGIS";
#endif
            break;
        case 0x80ab:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_SAMPLE_COVERAGE_INVERT";
#endif
#if defined(GL_ARB_multisample)
                    return "GL_SAMPLE_COVERAGE_INVERT_ARB";
#endif
#if defined(GL_EXT_multisample)
                    return "GL_SAMPLE_MASK_INVERT_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_SAMPLE_MASK_INVERT_SGIS";
#endif
            break;
        case 0x80ac:
#if defined(GL_EXT_multisample)
                    return "GL_SAMPLE_PATTERN_EXT";
#endif
#if defined(GL_SGIS_multisample)
                    return "GL_SAMPLE_PATTERN_SGIS";
#endif
            break;
#if defined(GL_SGIS_sharpen_texture)
        case 0x80ad: return "GL_LINEAR_SHARPEN_SGIS";
        case 0x80ae: return "GL_LINEAR_SHARPEN_ALPHA_SGIS";
        case 0x80af: return "GL_LINEAR_SHARPEN_COLOR_SGIS";
        case 0x80b0: return "GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS";
#endif
        case 0x80b1:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_COLOR_MATRIX";
#endif
#if defined(GL_SGI_color_matrix)
                    return "GL_COLOR_MATRIX_SGI";
#endif
            break;
        case 0x80b2:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_COLOR_MATRIX_STACK_DEPTH";
#endif
#if defined(GL_SGI_color_matrix)
                    return "GL_COLOR_MATRIX_STACK_DEPTH_SGI";
#endif
            break;
        case 0x80b3:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_MAX_COLOR_MATRIX_STACK_DEPTH";
#endif
#if defined(GL_SGI_color_matrix)
                    return "GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI";
#endif
            break;
        case 0x80b4:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_COLOR_MATRIX_RED_SCALE";
#endif
#if defined(GL_SGI_color_matrix)
                    return "GL_POST_COLOR_MATRIX_RED_SCALE_SGI";
#endif
            break;
        case 0x80b5:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_COLOR_MATRIX_GREEN_SCALE";
#endif
#if defined(GL_SGI_color_matrix)
                    return "GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI";
#endif
            break;
        case 0x80b6:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_COLOR_MATRIX_BLUE_SCALE";
#endif
#if defined(GL_SGI_color_matrix)
                    return "GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI";
#endif
            break;
        case 0x80b7:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_COLOR_MATRIX_ALPHA_SCALE";
#endif
#if defined(GL_SGI_color_matrix)
                    return "GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI";
#endif
            break;
        case 0x80b8:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_COLOR_MATRIX_RED_BIAS";
#endif
#if defined(GL_SGI_color_matrix)
                    return "GL_POST_COLOR_MATRIX_RED_BIAS_SGI";
#endif
            break;
        case 0x80b9:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_COLOR_MATRIX_GREEN_BIAS";
#endif
#if defined(GL_SGI_color_matrix)
                    return "GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI";
#endif
            break;
        case 0x80ba:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_COLOR_MATRIX_BLUE_BIAS";
#endif
#if defined(GL_SGI_color_matrix)
                    return "GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI";
#endif
            break;
        case 0x80bb:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_COLOR_MATRIX_ALPHA_BIAS";
#endif
#if defined(GL_SGI_color_matrix)
                    return "GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI";
#endif
            break;
#if defined(GL_SGI_texture_color_table)
        case 0x80bc: return "GL_TEXTURE_COLOR_TABLE_SGI";
        case 0x80bd: return "GL_PROXY_TEXTURE_COLOR_TABLE_SGI";
#endif
#if defined(GL_SGIX_texture_add_env)
        case 0x80be: return "GL_TEXTURE_ENV_BIAS_SGIX";
#endif
        case 0x80bf:
#if defined(GL_SGIX_shadow_ambient)
                    return "GL_SHADOW_AMBIENT_SGIX";
#endif
#if defined(GL_ARB_shadow_ambient)
                    return "GL_TEXTURE_COMPARE_FAIL_VALUE_ARB";
#endif
            break;
        case 0x80c8:
#if defined(GL_VERSION_1_4)
                    return "GL_BLEND_DST_RGB";
#endif
#if defined(GL_EXT_blend_func_separate)
                    return "GL_BLEND_DST_RGB_EXT";
#endif
            break;
        case 0x80c9:
#if defined(GL_VERSION_1_4)
                    return "GL_BLEND_SRC_RGB";
#endif
#if defined(GL_EXT_blend_func_separate)
                    return "GL_BLEND_SRC_RGB_EXT";
#endif
            break;
        case 0x80ca:
#if defined(GL_VERSION_1_4)
                    return "GL_BLEND_DST_ALPHA";
#endif
#if defined(GL_EXT_blend_func_separate)
                    return "GL_BLEND_DST_ALPHA_EXT";
#endif
            break;
        case 0x80cb:
#if defined(GL_VERSION_1_4)
                    return "GL_BLEND_SRC_ALPHA";
#endif
#if defined(GL_EXT_blend_func_separate)
                    return "GL_BLEND_SRC_ALPHA_EXT";
#endif
            break;
#if defined(GL_EXT_422_pixels)
        case 0x80cc: return "GL_422_EXT";
        case 0x80cd: return "GL_422_REV_EXT";
        case 0x80ce: return "GL_422_AVERAGE_EXT";
        case 0x80cf: return "GL_422_REV_AVERAGE_EXT";
#endif
        case 0x80d0:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_COLOR_TABLE";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_COLOR_TABLE_SGI";
#endif
            break;
        case 0x80d1:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_CONVOLUTION_COLOR_TABLE";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_POST_CONVOLUTION_COLOR_TABLE_SGI";
#endif
            break;
        case 0x80d2:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_POST_COLOR_MATRIX_COLOR_TABLE";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI";
#endif
            break;
        case 0x80d3:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_PROXY_COLOR_TABLE";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_PROXY_COLOR_TABLE_SGI";
#endif
            break;
        case 0x80d4:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_PROXY_POST_CONVOLUTION_COLOR_TABLE";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI";
#endif
            break;
        case 0x80d5:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI";
#endif
            break;
        case 0x80d6:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_COLOR_TABLE_SCALE";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_COLOR_TABLE_SCALE_SGI";
#endif
            break;
        case 0x80d7:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_COLOR_TABLE_BIAS";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_COLOR_TABLE_BIAS_SGI";
#endif
            break;
        case 0x80d8:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_COLOR_TABLE_FORMAT";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_COLOR_TABLE_FORMAT_SGI";
#endif
            break;
        case 0x80d9:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_COLOR_TABLE_WIDTH";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_COLOR_TABLE_WIDTH_SGI";
#endif
            break;
        case 0x80da:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_COLOR_TABLE_RED_SIZE";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_COLOR_TABLE_RED_SIZE_SGI";
#endif
            break;
        case 0x80db:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_COLOR_TABLE_GREEN_SIZE";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_COLOR_TABLE_GREEN_SIZE_SGI";
#endif
            break;
        case 0x80dc:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_COLOR_TABLE_BLUE_SIZE";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_COLOR_TABLE_BLUE_SIZE_SGI";
#endif
            break;
        case 0x80dd:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_COLOR_TABLE_ALPHA_SIZE";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_COLOR_TABLE_ALPHA_SIZE_SGI";
#endif
            break;
        case 0x80de:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_COLOR_TABLE_LUMINANCE_SIZE";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_COLOR_TABLE_LUMINANCE_SIZE_SGI";
#endif
            break;
        case 0x80df:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_COLOR_TABLE_INTENSITY_SIZE";
#endif
#if defined(GL_SGI_color_table)
                    return "GL_COLOR_TABLE_INTENSITY_SIZE_SGI";
#endif
            break;
        case 0x80e0:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_BGR";
#endif
#if defined(GL_EXT_bgra)
                    return "GL_BGR_EXT";
#endif
            break;
        case 0x80e1:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_BGRA";
#endif
#if defined(GL_EXT_bgra)
                    return "GL_BGRA_EXT";
#endif
            break;
#if defined(GL_EXT_paletted_texture)
        case 0x80e2: return "GL_COLOR_INDEX1_EXT";
        case 0x80e3: return "GL_COLOR_INDEX2_EXT";
        case 0x80e4: return "GL_COLOR_INDEX4_EXT";
        case 0x80e5: return "GL_COLOR_INDEX8_EXT";
        case 0x80e6: return "GL_COLOR_INDEX12_EXT";
        case 0x80e7: return "GL_COLOR_INDEX16_EXT";
#endif
        case 0x80e8:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_MAX_ELEMENTS_VERTICES";
#endif
#if defined(GL_EXT_draw_range_elements)
                    return "GL_MAX_ELEMENTS_VERTICES_EXT";
#endif
            break;
        case 0x80e9:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_MAX_ELEMENTS_INDICES";
#endif
#if defined(GL_EXT_draw_range_elements)
                    return "GL_MAX_ELEMENTS_INDICES_EXT";
#endif
            break;
#if defined(GL_WIN_phong_shading)
        case 0x80ea: return "GL_PHONG_WIN";
        case 0x80eb: return "GL_PHONG_HINT_WIN";
#endif
#if defined(GL_WIN_specular_fog)
        case 0x80ec: return "GL_FOG_SPECULAR_TEXTURE_WIN";
#endif
#if defined(GL_EXT_paletted_texture)
        case 0x80ed: return "GL_TEXTURE_INDEX_SIZE_EXT";
#endif
        case 0x80ee:
#if defined(GL_VERSION_4_6)
                    return "GL_PARAMETER_BUFFER";
#endif
#if defined(GL_ARB_indirect_parameters)
                    return "GL_PARAMETER_BUFFER_ARB";
#endif
            break;
        case 0x80ef:
#if defined(GL_VERSION_4_6)
                    return "GL_PARAMETER_BUFFER_BINDING";
#endif
#if defined(GL_ARB_indirect_parameters)
                    return "GL_PARAMETER_BUFFER_BINDING_ARB";
#endif
            break;
#if defined(GL_EXT_clip_volume_hint)
        case 0x80f0: return "GL_CLIP_VOLUME_CLIPPING_HINT_EXT";
#endif
#if defined(GL_SGIS_texture_select)
        case 0x8110: return "GL_DUAL_ALPHA4_SGIS";
        case 0x8111: return "GL_DUAL_ALPHA8_SGIS";
        case 0x8112: return "GL_DUAL_ALPHA12_SGIS";
        case 0x8113: return "GL_DUAL_ALPHA16_SGIS";
        case 0x8114: return "GL_DUAL_LUMINANCE4_SGIS";
        case 0x8115: return "GL_DUAL_LUMINANCE8_SGIS";
        case 0x8116: return "GL_DUAL_LUMINANCE12_SGIS";
        case 0x8117: return "GL_DUAL_LUMINANCE16_SGIS";
        case 0x8118: return "GL_DUAL_INTENSITY4_SGIS";
        case 0x8119: return "GL_DUAL_INTENSITY8_SGIS";
        case 0x811a: return "GL_DUAL_INTENSITY12_SGIS";
        case 0x811b: return "GL_DUAL_INTENSITY16_SGIS";
        case 0x811c: return "GL_DUAL_LUMINANCE_ALPHA4_SGIS";
        case 0x811d: return "GL_DUAL_LUMINANCE_ALPHA8_SGIS";
        case 0x811e: return "GL_QUAD_ALPHA4_SGIS";
        case 0x811f: return "GL_QUAD_ALPHA8_SGIS";
        case 0x8120: return "GL_QUAD_LUMINANCE4_SGIS";
        case 0x8121: return "GL_QUAD_LUMINANCE8_SGIS";
        case 0x8122: return "GL_QUAD_INTENSITY4_SGIS";
        case 0x8123: return "GL_QUAD_INTENSITY8_SGIS";
        case 0x8124: return "GL_DUAL_TEXTURE_SELECT_SGIS";
        case 0x8125: return "GL_QUAD_TEXTURE_SELECT_SGIS";
#endif
        case 0x8126:
#if defined(GL_VERSION_1_4)
                    return "GL_POINT_SIZE_MIN";
#endif
#if defined(GL_ARB_point_parameters)
                    return "GL_POINT_SIZE_MIN_ARB";
#endif
#if defined(GL_EXT_point_parameters)
                    return "GL_POINT_SIZE_MIN_EXT";
#endif
#if defined(GL_SGIS_point_parameters)
                    return "GL_POINT_SIZE_MIN_SGIS";
#endif
            break;
        case 0x8127:
#if defined(GL_VERSION_1_4)
                    return "GL_POINT_SIZE_MAX";
#endif
#if defined(GL_ARB_point_parameters)
                    return "GL_POINT_SIZE_MAX_ARB";
#endif
#if defined(GL_EXT_point_parameters)
                    return "GL_POINT_SIZE_MAX_EXT";
#endif
#if defined(GL_SGIS_point_parameters)
                    return "GL_POINT_SIZE_MAX_SGIS";
#endif
            break;
        case 0x8128:
#if defined(GL_VERSION_1_4)
                    return "GL_POINT_FADE_THRESHOLD_SIZE";
#endif
#if defined(GL_ARB_point_parameters)
                    return "GL_POINT_FADE_THRESHOLD_SIZE_ARB";
#endif
#if defined(GL_EXT_point_parameters)
                    return "GL_POINT_FADE_THRESHOLD_SIZE_EXT";
#endif
#if defined(GL_SGIS_point_parameters)
                    return "GL_POINT_FADE_THRESHOLD_SIZE_SGIS";
#endif
            break;
        case 0x8129:
#if defined(GL_EXT_point_parameters)
                    return "GL_DISTANCE_ATTENUATION_EXT";
#endif
#if defined(GL_SGIS_point_parameters)
                    return "GL_DISTANCE_ATTENUATION_SGIS";
#endif
#if defined(GL_VERSION_1_4)
                    return "GL_POINT_DISTANCE_ATTENUATION";
#endif
#if defined(GL_ARB_point_parameters)
                    return "GL_POINT_DISTANCE_ATTENUATION_ARB";
#endif
            break;
#if defined(GL_SGIS_fog_function)
        case 0x812a: return "GL_FOG_FUNC_SGIS";
        case 0x812b: return "GL_FOG_FUNC_POINTS_SGIS";
        case 0x812c: return "GL_MAX_FOG_FUNC_POINTS_SGIS";
#endif
        case 0x812d:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_CLAMP_TO_BORDER";
#endif
#if defined(GL_ARB_texture_border_clamp)
                    return "GL_CLAMP_TO_BORDER_ARB";
#endif
#if defined(GL_SGIS_texture_border_clamp)
                    return "GL_CLAMP_TO_BORDER_SGIS";
#endif
            break;
#if defined(GL_SGIX_texture_multi_buffer)
        case 0x812e: return "GL_TEXTURE_MULTI_BUFFER_HINT_SGIX";
#endif
        case 0x812f:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_CLAMP_TO_EDGE";
#endif
#if defined(GL_SGIS_texture_edge_clamp)
                    return "GL_CLAMP_TO_EDGE_SGIS";
#endif
            break;
#if defined(GL_SGIS_texture4D)
        case 0x8130: return "GL_PACK_SKIP_VOLUMES_SGIS";
        case 0x8131: return "GL_PACK_IMAGE_DEPTH_SGIS";
        case 0x8132: return "GL_UNPACK_SKIP_VOLUMES_SGIS";
        case 0x8133: return "GL_UNPACK_IMAGE_DEPTH_SGIS";
        case 0x8134: return "GL_TEXTURE_4D_SGIS";
        case 0x8135: return "GL_PROXY_TEXTURE_4D_SGIS";
        case 0x8136: return "GL_TEXTURE_4DSIZE_SGIS";
        case 0x8137: return "GL_TEXTURE_WRAP_Q_SGIS";
        case 0x8138: return "GL_MAX_4D_TEXTURE_SIZE_SGIS";
#endif
#if defined(GL_SGIX_pixel_texture)
        case 0x8139: return "GL_PIXEL_TEX_GEN_SGIX";
#endif
        case 0x813a:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_TEXTURE_MIN_LOD";
#endif
#if defined(GL_SGIS_texture_lod)
                    return "GL_TEXTURE_MIN_LOD_SGIS";
#endif
            break;
        case 0x813b:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_TEXTURE_MAX_LOD";
#endif
#if defined(GL_SGIS_texture_lod)
                    return "GL_TEXTURE_MAX_LOD_SGIS";
#endif
            break;
        case 0x813c:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_TEXTURE_BASE_LEVEL";
#endif
#if defined(GL_SGIS_texture_lod)
                    return "GL_TEXTURE_BASE_LEVEL_SGIS";
#endif
            break;
        case 0x813d:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_TEXTURE_MAX_LEVEL";
#endif
#if defined(GL_SGIS_texture_lod)
                    return "GL_TEXTURE_MAX_LEVEL_SGIS";
#endif
            break;
#if defined(GL_SGIX_pixel_tiles)
        case 0x813e: return "GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX";
        case 0x813f: return "GL_PIXEL_TILE_CACHE_INCREMENT_SGIX";
        case 0x8140: return "GL_PIXEL_TILE_WIDTH_SGIX";
        case 0x8141: return "GL_PIXEL_TILE_HEIGHT_SGIX";
        case 0x8142: return "GL_PIXEL_TILE_GRID_WIDTH_SGIX";
        case 0x8143: return "GL_PIXEL_TILE_GRID_HEIGHT_SGIX";
        case 0x8144: return "GL_PIXEL_TILE_GRID_DEPTH_SGIX";
        case 0x8145: return "GL_PIXEL_TILE_CACHE_SIZE_SGIX";
#endif
#if defined(GL_SGIS_texture_filter4)
        case 0x8146: return "GL_FILTER4_SGIS";
        case 0x8147: return "GL_TEXTURE_FILTER4_SIZE_SGIS";
#endif
#if defined(GL_SGIX_sprite)
        case 0x8148: return "GL_SPRITE_SGIX";
        case 0x8149: return "GL_SPRITE_MODE_SGIX";
        case 0x814a: return "GL_SPRITE_AXIS_SGIX";
        case 0x814b: return "GL_SPRITE_TRANSLATION_SGIX";
        case 0x814c: return "GL_SPRITE_AXIAL_SGIX";
        case 0x814d: return "GL_SPRITE_OBJECT_ALIGNED_SGIX";
        case 0x814e: return "GL_SPRITE_EYE_ALIGNED_SGIX";
#endif
#if defined(GL_SGIS_texture4D)
        case 0x814f: return "GL_TEXTURE_4D_BINDING_SGIS";
#endif
#if defined(GL_HP_convolution_border_modes)
        case 0x8150: return "GL_IGNORE_BORDER_HP";
#endif
        case 0x8151:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_CONSTANT_BORDER";
#endif
#if defined(GL_HP_convolution_border_modes)
                    return "GL_CONSTANT_BORDER_HP";
#endif
            break;
        case 0x8153:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_REPLICATE_BORDER";
#endif
#if defined(GL_HP_convolution_border_modes)
                    return "GL_REPLICATE_BORDER_HP";
#endif
            break;
        case 0x8154:
#if defined(__gl_h_) || defined(GL_ARB_imaging)
                    return "GL_CONVOLUTION_BORDER_COLOR";
#endif
#if defined(GL_HP_convolution_border_modes)
                    return "GL_CONVOLUTION_BORDER_COLOR_HP";
#endif
            break;
#if defined(GL_HP_image_transform)
        case 0x8155: return "GL_IMAGE_SCALE_X_HP";
        case 0x8156: return "GL_IMAGE_SCALE_Y_HP";
        case 0x8157: return "GL_IMAGE_TRANSLATE_X_HP";
        case 0x8158: return "GL_IMAGE_TRANSLATE_Y_HP";
        case 0x8159: return "GL_IMAGE_ROTATE_ANGLE_HP";
        case 0x815a: return "GL_IMAGE_ROTATE_ORIGIN_X_HP";
        case 0x815b: return "GL_IMAGE_ROTATE_ORIGIN_Y_HP";
        case 0x815c: return "GL_IMAGE_MAG_FILTER_HP";
        case 0x815d: return "GL_IMAGE_MIN_FILTER_HP";
        case 0x815e: return "GL_IMAGE_CUBIC_WEIGHT_HP";
        case 0x815f: return "GL_CUBIC_HP";
        case 0x8160: return "GL_AVERAGE_HP";
        case 0x8161: return "GL_IMAGE_TRANSFORM_2D_HP";
        case 0x8162: return "GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP";
        case 0x8163: return "GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP";
#endif
#if defined(GL_HP_occlusion_test)
        case 0x8165: return "GL_OCCLUSION_TEST_HP";
        case 0x8166: return "GL_OCCLUSION_TEST_RESULT_HP";
#endif
#if defined(GL_HP_texture_lighting)
        case 0x8167: return "GL_TEXTURE_LIGHTING_MODE_HP";
        case 0x8168: return "GL_TEXTURE_POST_SPECULAR_HP";
        case 0x8169: return "GL_TEXTURE_PRE_SPECULAR_HP";
#endif
#if defined(GL_SGIX_clipmap)
        case 0x8170: return "GL_LINEAR_CLIPMAP_LINEAR_SGIX";
        case 0x8171: return "GL_TEXTURE_CLIPMAP_CENTER_SGIX";
        case 0x8172: return "GL_TEXTURE_CLIPMAP_FRAME_SGIX";
        case 0x8173: return "GL_TEXTURE_CLIPMAP_OFFSET_SGIX";
        case 0x8174: return "GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX";
        case 0x8175: return "GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX";
        case 0x8176: return "GL_TEXTURE_CLIPMAP_DEPTH_SGIX";
        case 0x8177: return "GL_MAX_CLIPMAP_DEPTH_SGIX";
        case 0x8178: return "GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX";
#endif
#if defined(GL_SGIX_texture_scale_bias)
        case 0x8179: return "GL_POST_TEXTURE_FILTER_BIAS_SGIX";
        case 0x817a: return "GL_POST_TEXTURE_FILTER_SCALE_SGIX";
        case 0x817b: return "GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX";
        case 0x817c: return "GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX";
#endif
#if defined(GL_SGIX_reference_plane)
        case 0x817d: return "GL_REFERENCE_PLANE_SGIX";
        case 0x817e: return "GL_REFERENCE_PLANE_EQUATION_SGIX";
#endif
#if defined(GL_SGIX_ir_instrument1)
        case 0x817f: return "GL_IR_INSTRUMENT1_SGIX";
#endif
#if defined(GL_SGIX_instruments)
        case 0x8180: return "GL_INSTRUMENT_BUFFER_POINTER_SGIX";
        case 0x8181: return "GL_INSTRUMENT_MEASUREMENTS_SGIX";
#endif
#if defined(GL_SGIX_list_priority)
        case 0x8182: return "GL_LIST_PRIORITY_SGIX";
#endif
#if defined(GL_SGIX_calligraphic_fragment)
        case 0x8183: return "GL_CALLIGRAPHIC_FRAGMENT_SGIX";
#endif
#if defined(GL_SGIX_framezoom)
        case 0x818b: return "GL_FRAMEZOOM_SGIX";
        case 0x818c: return "GL_FRAMEZOOM_FACTOR_SGIX";
        case 0x818d: return "GL_MAX_FRAMEZOOM_FACTOR_SGIX";
#endif
#if defined(GL_SGIX_texture_lod_bias)
        case 0x818e: return "GL_TEXTURE_LOD_BIAS_S_SGIX";
        case 0x818f: return "GL_TEXTURE_LOD_BIAS_T_SGIX";
        case 0x8190: return "GL_TEXTURE_LOD_BIAS_R_SGIX";
#endif
        case 0x8191:
#if defined(GL_VERSION_1_4)
                    return "GL_GENERATE_MIPMAP";
#endif
#if defined(GL_SGIS_generate_mipmap)
                    return "GL_GENERATE_MIPMAP_SGIS";
#endif
            break;
        case 0x8192:
#if defined(GL_VERSION_1_4)
                    return "GL_GENERATE_MIPMAP_HINT";
#endif
#if defined(GL_SGIS_generate_mipmap)
                    return "GL_GENERATE_MIPMAP_HINT_SGIS";
#endif
            break;
#if defined(GL_SGIX_polynomial_ffd)
        case 0x8194: return "GL_GEOMETRY_DEFORMATION_SGIX";
        case 0x8195: return "GL_TEXTURE_DEFORMATION_SGIX";
        case 0x8196: return "GL_DEFORMATIONS_MASK_SGIX";
        case 0x8197: return "GL_MAX_DEFORMATION_ORDER_SGIX";
#endif
#if defined(GL_SGIX_fog_offset)
        case 0x8198: return "GL_FOG_OFFSET_SGIX";
        case 0x8199: return "GL_FOG_OFFSET_VALUE_SGIX";
#endif
#if defined(GL_SGIX_shadow)
        case 0x819a: return "GL_TEXTURE_COMPARE_SGIX";
        case 0x819b: return "GL_TEXTURE_COMPARE_OPERATOR_SGIX";
        case 0x819c: return "GL_TEXTURE_LEQUAL_R_SGIX";
        case 0x819d: return "GL_TEXTURE_GEQUAL_R_SGIX";
#endif
        case 0x81a5:
#if defined(GL_VERSION_1_4)
                    return "GL_DEPTH_COMPONENT16";
#endif
#if defined(GL_ARB_depth_texture)
                    return "GL_DEPTH_COMPONENT16_ARB";
#endif
#if defined(GL_SGIX_depth_texture)
                    return "GL_DEPTH_COMPONENT16_SGIX";
#endif
            break;
        case 0x81a6:
#if defined(GL_VERSION_1_4)
                    return "GL_DEPTH_COMPONENT24";
#endif
#if defined(GL_ARB_depth_texture)
                    return "GL_DEPTH_COMPONENT24_ARB";
#endif
#if defined(GL_SGIX_depth_texture)
                    return "GL_DEPTH_COMPONENT24_SGIX";
#endif
            break;
        case 0x81a7:
#if defined(GL_VERSION_1_4)
                    return "GL_DEPTH_COMPONENT32";
#endif
#if defined(GL_ARB_depth_texture)
                    return "GL_DEPTH_COMPONENT32_ARB";
#endif
#if defined(GL_SGIX_depth_texture)
                    return "GL_DEPTH_COMPONENT32_SGIX";
#endif
            break;
#if defined(GL_EXT_compiled_vertex_array)
        case 0x81a8: return "GL_ARRAY_ELEMENT_LOCK_FIRST_EXT";
        case 0x81a9: return "GL_ARRAY_ELEMENT_LOCK_COUNT_EXT";
#endif
#if defined(GL_EXT_cull_vertex)
        case 0x81aa: return "GL_CULL_VERTEX_EXT";
        case 0x81ab: return "GL_CULL_VERTEX_EYE_POSITION_EXT";
        case 0x81ac: return "GL_CULL_VERTEX_OBJECT_POSITION_EXT";
#endif
#if defined(GL_EXT_index_array_formats)
        case 0x81ad: return "GL_IUI_V2F_EXT";
        case 0x81ae: return "GL_IUI_V3F_EXT";
        case 0x81af: return "GL_IUI_N3F_V2F_EXT";
        case 0x81b0: return "GL_IUI_N3F_V3F_EXT";
        case 0x81b1: return "GL_T2F_IUI_V2F_EXT";
        case 0x81b2: return "GL_T2F_IUI_V3F_EXT";
        case 0x81b3: return "GL_T2F_IUI_N3F_V2F_EXT";
        case 0x81b4: return "GL_T2F_IUI_N3F_V3F_EXT";
#endif
#if defined(GL_EXT_index_func)
        case 0x81b5: return "GL_INDEX_TEST_EXT";
        case 0x81b6: return "GL_INDEX_TEST_FUNC_EXT";
        case 0x81b7: return "GL_INDEX_TEST_REF_EXT";
#endif
#if defined(GL_EXT_index_material)
        case 0x81b8: return "GL_INDEX_MATERIAL_EXT";
        case 0x81b9: return "GL_INDEX_MATERIAL_PARAMETER_EXT";
        case 0x81ba: return "GL_INDEX_MATERIAL_FACE_EXT";
#endif
#if defined(GL_SGIX_ycrcb)
        case 0x81bb: return "GL_YCRCB_422_SGIX";
        case 0x81bc: return "GL_YCRCB_444_SGIX";
#endif
#if defined(GL_SUN_convolution_border_modes)
        case 0x81d4: return "GL_WRAP_BORDER_SUN";
#endif
#if defined(GL_SUNX_constant_data)
        case 0x81d5: return "GL_UNPACK_CONSTANT_DATA_SUNX";
        case 0x81d6: return "GL_TEXTURE_CONSTANT_DATA_SUNX";
#endif
#if defined(GL_SUN_triangle_list)
        case 0x81d7: return "GL_TRIANGLE_LIST_SUN";
        case 0x81d8: return "GL_REPLACEMENT_CODE_SUN";
#endif
#if defined(GL_SUN_global_alpha)
        case 0x81d9: return "GL_GLOBAL_ALPHA_SUN";
        case 0x81da: return "GL_GLOBAL_ALPHA_FACTOR_SUN";
#endif
#if defined(GL_SGIS_texture_color_mask)
        case 0x81ef: return "GL_TEXTURE_COLOR_WRITEMASK_SGIS";
#endif
#if defined(GL_SGIS_point_line_texgen)
        case 0x81f0: return "GL_EYE_DISTANCE_TO_POINT_SGIS";
        case 0x81f1: return "GL_OBJECT_DISTANCE_TO_POINT_SGIS";
        case 0x81f2: return "GL_EYE_DISTANCE_TO_LINE_SGIS";
        case 0x81f3: return "GL_OBJECT_DISTANCE_TO_LINE_SGIS";
        case 0x81f4: return "GL_EYE_POINT_SGIS";
        case 0x81f5: return "GL_OBJECT_POINT_SGIS";
        case 0x81f6: return "GL_EYE_LINE_SGIS";
        case 0x81f7: return "GL_OBJECT_LINE_SGIS";
#endif
        case 0x81f8:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_LIGHT_MODEL_COLOR_CONTROL";
#endif
#if defined(GL_EXT_separate_specular_color)
                    return "GL_LIGHT_MODEL_COLOR_CONTROL_EXT";
#endif
            break;
        case 0x81f9:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_SINGLE_COLOR";
#endif
#if defined(GL_EXT_separate_specular_color)
                    return "GL_SINGLE_COLOR_EXT";
#endif
            break;
        case 0x81fa:
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
                    return "GL_SEPARATE_SPECULAR_COLOR";
#endif
#if defined(GL_EXT_separate_specular_color)
                    return "GL_SEPARATE_SPECULAR_COLOR_EXT";
#endif
            break;
#if defined(GL_EXT_shared_texture_palette)
        case 0x81fb: return "GL_SHARED_TEXTURE_PALETTE_EXT";
#endif
#if defined(GL_ATI_text_fragment_shader)
        case 0x8200: return "GL_TEXT_FRAGMENT_SHADER_ATI";
#endif
#if defined(GL_VERSION_3_0)
        case 0x8210: return "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING";
        case 0x8211: return "GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE";
        case 0x8212: return "GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE";
        case 0x8213: return "GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE";
        case 0x8214: return "GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE";
        case 0x8215: return "GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE";
        case 0x8216: return "GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE";
        case 0x8217: return "GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE";
        case 0x8218: return "GL_FRAMEBUFFER_DEFAULT";
        case 0x8219: return "GL_FRAMEBUFFER_UNDEFINED";
        case 0x821a: return "GL_DEPTH_STENCIL_ATTACHMENT";
        case 0x821b: return "GL_MAJOR_VERSION";
        case 0x821c: return "GL_MINOR_VERSION";
        case 0x821d: return "GL_NUM_EXTENSIONS";
        case 0x821e: return "GL_CONTEXT_FLAGS";
#endif
#if defined(GL_VERSION_4_4)
        case 0x821f: return "GL_BUFFER_IMMUTABLE_STORAGE";
        case 0x8220: return "GL_BUFFER_STORAGE_FLAGS";
        case 0x8221: return "GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED";
#endif
#if defined(GL_VERSION_3_0)
        case 0x8222: return "GL_INDEX";
        case 0x8225: return "GL_COMPRESSED_RED";
        case 0x8226: return "GL_COMPRESSED_RG";
        case 0x8227: return "GL_RG";
        case 0x8228: return "GL_RG_INTEGER";
        case 0x8229: return "GL_R8";
        case 0x822a: return "GL_R16";
        case 0x822b: return "GL_RG8";
        case 0x822c: return "GL_RG16";
        case 0x822d: return "GL_R16F";
        case 0x822e: return "GL_R32F";
        case 0x822f: return "GL_RG16F";
        case 0x8230: return "GL_RG32F";
        case 0x8231: return "GL_R8I";
        case 0x8232: return "GL_R8UI";
        case 0x8233: return "GL_R16I";
        case 0x8234: return "GL_R16UI";
        case 0x8235: return "GL_R32I";
        case 0x8236: return "GL_R32UI";
        case 0x8237: return "GL_RG8I";
        case 0x8238: return "GL_RG8UI";
        case 0x8239: return "GL_RG16I";
        case 0x823a: return "GL_RG16UI";
        case 0x823b: return "GL_RG32I";
        case 0x823c: return "GL_RG32UI";
#endif
#if defined(GL_ARB_cl_event)
        case 0x8240: return "GL_SYNC_CL_EVENT_ARB";
        case 0x8241: return "GL_SYNC_CL_EVENT_COMPLETE_ARB";
#endif
        case 0x8242:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_OUTPUT_SYNCHRONOUS";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB";
#endif
            break;
        case 0x8243:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB";
#endif
            break;
        case 0x8244:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_CALLBACK_FUNCTION";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_CALLBACK_FUNCTION_ARB";
#endif
            break;
        case 0x8245:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_CALLBACK_USER_PARAM";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_CALLBACK_USER_PARAM_ARB";
#endif
            break;
        case 0x8246:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_SOURCE_API";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_SOURCE_API_ARB";
#endif
            break;
        case 0x8247:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_SOURCE_WINDOW_SYSTEM";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB";
#endif
            break;
        case 0x8248:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_SOURCE_SHADER_COMPILER";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_SOURCE_SHADER_COMPILER_ARB";
#endif
            break;
        case 0x8249:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_SOURCE_THIRD_PARTY";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_SOURCE_THIRD_PARTY_ARB";
#endif
            break;
        case 0x824a:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_SOURCE_APPLICATION";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_SOURCE_APPLICATION_ARB";
#endif
            break;
        case 0x824b:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_SOURCE_OTHER";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_SOURCE_OTHER_ARB";
#endif
            break;
        case 0x824c:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_TYPE_ERROR";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_TYPE_ERROR_ARB";
#endif
            break;
        case 0x824d:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB";
#endif
            break;
        case 0x824e:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB";
#endif
            break;
        case 0x824f:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_TYPE_PORTABILITY";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_TYPE_PORTABILITY_ARB";
#endif
            break;
        case 0x8250:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_TYPE_PERFORMANCE";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_TYPE_PERFORMANCE_ARB";
#endif
            break;
        case 0x8251:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_TYPE_OTHER";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_TYPE_OTHER_ARB";
#endif
            break;
        case 0x8252:
#if defined(GL_VERSION_4_5)
                    return "GL_LOSE_CONTEXT_ON_RESET";
#endif
#if defined(GL_ARB_robustness)
                    return "GL_LOSE_CONTEXT_ON_RESET_ARB";
#endif
            break;
        case 0x8253:
#if defined(GL_VERSION_4_5)
                    return "GL_GUILTY_CONTEXT_RESET";
#endif
#if defined(GL_ARB_robustness)
                    return "GL_GUILTY_CONTEXT_RESET_ARB";
#endif
            break;
        case 0x8254:
#if defined(GL_VERSION_4_5)
                    return "GL_INNOCENT_CONTEXT_RESET";
#endif
#if defined(GL_ARB_robustness)
                    return "GL_INNOCENT_CONTEXT_RESET_ARB";
#endif
            break;
        case 0x8255:
#if defined(GL_VERSION_4_5)
                    return "GL_UNKNOWN_CONTEXT_RESET";
#endif
#if defined(GL_ARB_robustness)
                    return "GL_UNKNOWN_CONTEXT_RESET_ARB";
#endif
            break;
        case 0x8256:
#if defined(GL_VERSION_4_5)
                    return "GL_RESET_NOTIFICATION_STRATEGY";
#endif
#if defined(GL_ARB_robustness)
                    return "GL_RESET_NOTIFICATION_STRATEGY_ARB";
#endif
            break;
#if defined(GL_VERSION_4_1)
        case 0x8257: return "GL_PROGRAM_BINARY_RETRIEVABLE_HINT";
        case 0x8258: return "GL_PROGRAM_SEPARABLE";
        case 0x8259: return "GL_ACTIVE_PROGRAM";
        case 0x825a: return "GL_PROGRAM_PIPELINE_BINDING";
        case 0x825b: return "GL_MAX_VIEWPORTS";
        case 0x825d: return "GL_VIEWPORT_BOUNDS_RANGE";
        case 0x825e: return "GL_LAYER_PROVOKING_VERTEX";
        case 0x825f: return "GL_VIEWPORT_INDEX_PROVOKING_VERTEX";
        case 0x8260: return "GL_UNDEFINED_VERTEX";
#endif
        case 0x8261:
#if defined(GL_VERSION_4_5)
                    return "GL_NO_RESET_NOTIFICATION";
#endif
#if defined(GL_ARB_robustness)
                    return "GL_NO_RESET_NOTIFICATION_ARB";
#endif
            break;
#if defined(GL_VERSION_4_3)
        case 0x8262: return "GL_MAX_COMPUTE_SHARED_MEMORY_SIZE";
        case 0x8263: return "GL_MAX_COMPUTE_UNIFORM_COMPONENTS";
        case 0x8264: return "GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS";
        case 0x8265: return "GL_MAX_COMPUTE_ATOMIC_COUNTERS";
        case 0x8266: return "GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS";
        case 0x8267: return "GL_COMPUTE_WORK_GROUP_SIZE";
        case 0x8268: return "GL_DEBUG_TYPE_MARKER";
        case 0x8269: return "GL_DEBUG_TYPE_PUSH_GROUP";
        case 0x826a: return "GL_DEBUG_TYPE_POP_GROUP";
        case 0x826b: return "GL_DEBUG_SEVERITY_NOTIFICATION";
        case 0x826c: return "GL_MAX_DEBUG_GROUP_STACK_DEPTH";
        case 0x826d: return "GL_DEBUG_GROUP_STACK_DEPTH";
        case 0x826e: return "GL_MAX_UNIFORM_LOCATIONS";
        case 0x826f: return "GL_INTERNALFORMAT_SUPPORTED";
        case 0x8270: return "GL_INTERNALFORMAT_PREFERRED";
        case 0x8271: return "GL_INTERNALFORMAT_RED_SIZE";
        case 0x8272: return "GL_INTERNALFORMAT_GREEN_SIZE";
        case 0x8273: return "GL_INTERNALFORMAT_BLUE_SIZE";
        case 0x8274: return "GL_INTERNALFORMAT_ALPHA_SIZE";
        case 0x8275: return "GL_INTERNALFORMAT_DEPTH_SIZE";
        case 0x8276: return "GL_INTERNALFORMAT_STENCIL_SIZE";
        case 0x8277: return "GL_INTERNALFORMAT_SHARED_SIZE";
        case 0x8278: return "GL_INTERNALFORMAT_RED_TYPE";
        case 0x8279: return "GL_INTERNALFORMAT_GREEN_TYPE";
        case 0x827a: return "GL_INTERNALFORMAT_BLUE_TYPE";
        case 0x827b: return "GL_INTERNALFORMAT_ALPHA_TYPE";
        case 0x827c: return "GL_INTERNALFORMAT_DEPTH_TYPE";
        case 0x827d: return "GL_INTERNALFORMAT_STENCIL_TYPE";
        case 0x827e: return "GL_MAX_WIDTH";
        case 0x827f: return "GL_MAX_HEIGHT";
        case 0x8280: return "GL_MAX_DEPTH";
        case 0x8281: return "GL_MAX_LAYERS";
        case 0x8282: return "GL_MAX_COMBINED_DIMENSIONS";
        case 0x8283: return "GL_COLOR_COMPONENTS";
        case 0x8284: return "GL_DEPTH_COMPONENTS";
        case 0x8285: return "GL_STENCIL_COMPONENTS";
        case 0x8286: return "GL_COLOR_RENDERABLE";
        case 0x8287: return "GL_DEPTH_RENDERABLE";
        case 0x8288: return "GL_STENCIL_RENDERABLE";
        case 0x8289: return "GL_FRAMEBUFFER_RENDERABLE";
        case 0x828a: return "GL_FRAMEBUFFER_RENDERABLE_LAYERED";
        case 0x828b: return "GL_FRAMEBUFFER_BLEND";
        case 0x828c: return "GL_READ_PIXELS";
        case 0x828d: return "GL_READ_PIXELS_FORMAT";
        case 0x828e: return "GL_READ_PIXELS_TYPE";
        case 0x828f: return "GL_TEXTURE_IMAGE_FORMAT";
        case 0x8290: return "GL_TEXTURE_IMAGE_TYPE";
        case 0x8291: return "GL_GET_TEXTURE_IMAGE_FORMAT";
        case 0x8292: return "GL_GET_TEXTURE_IMAGE_TYPE";
        case 0x8293: return "GL_MIPMAP";
        case 0x8294: return "GL_MANUAL_GENERATE_MIPMAP";
        case 0x8295: return "GL_AUTO_GENERATE_MIPMAP";
        case 0x8296: return "GL_COLOR_ENCODING";
        case 0x8297: return "GL_SRGB_READ";
        case 0x8298: return "GL_SRGB_WRITE";
#endif
#if defined(GL_ARB_internalformat_query2)
        case 0x8299: return "GL_SRGB_DECODE_ARB";
#endif
#if defined(GL_VERSION_4_3)
        case 0x829a: return "GL_FILTER";
        case 0x829b: return "GL_VERTEX_TEXTURE";
        case 0x829c: return "GL_TESS_CONTROL_TEXTURE";
        case 0x829d: return "GL_TESS_EVALUATION_TEXTURE";
        case 0x829e: return "GL_GEOMETRY_TEXTURE";
        case 0x829f: return "GL_FRAGMENT_TEXTURE";
        case 0x82a0: return "GL_COMPUTE_TEXTURE";
        case 0x82a1: return "GL_TEXTURE_SHADOW";
        case 0x82a2: return "GL_TEXTURE_GATHER";
        case 0x82a3: return "GL_TEXTURE_GATHER_SHADOW";
        case 0x82a4: return "GL_SHADER_IMAGE_LOAD";
        case 0x82a5: return "GL_SHADER_IMAGE_STORE";
        case 0x82a6: return "GL_SHADER_IMAGE_ATOMIC";
        case 0x82a7: return "GL_IMAGE_TEXEL_SIZE";
        case 0x82a8: return "GL_IMAGE_COMPATIBILITY_CLASS";
        case 0x82a9: return "GL_IMAGE_PIXEL_FORMAT";
        case 0x82aa: return "GL_IMAGE_PIXEL_TYPE";
        case 0x82ac: return "GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST";
        case 0x82ad: return "GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST";
        case 0x82ae: return "GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE";
        case 0x82af: return "GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE";
        case 0x82b1: return "GL_TEXTURE_COMPRESSED_BLOCK_WIDTH";
        case 0x82b2: return "GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT";
        case 0x82b3: return "GL_TEXTURE_COMPRESSED_BLOCK_SIZE";
        case 0x82b4: return "GL_CLEAR_BUFFER";
        case 0x82b5: return "GL_TEXTURE_VIEW";
        case 0x82b6: return "GL_VIEW_COMPATIBILITY_CLASS";
        case 0x82b7: return "GL_FULL_SUPPORT";
        case 0x82b8: return "GL_CAVEAT_SUPPORT";
        case 0x82b9: return "GL_IMAGE_CLASS_4_X_32";
        case 0x82ba: return "GL_IMAGE_CLASS_2_X_32";
        case 0x82bb: return "GL_IMAGE_CLASS_1_X_32";
        case 0x82bc: return "GL_IMAGE_CLASS_4_X_16";
        case 0x82bd: return "GL_IMAGE_CLASS_2_X_16";
        case 0x82be: return "GL_IMAGE_CLASS_1_X_16";
        case 0x82bf: return "GL_IMAGE_CLASS_4_X_8";
        case 0x82c0: return "GL_IMAGE_CLASS_2_X_8";
        case 0x82c1: return "GL_IMAGE_CLASS_1_X_8";
        case 0x82c2: return "GL_IMAGE_CLASS_11_11_10";
        case 0x82c3: return "GL_IMAGE_CLASS_10_10_10_2";
        case 0x82cc: return "GL_VIEW_CLASS_S3TC_DXT1_RGB";
        case 0x82cd: return "GL_VIEW_CLASS_S3TC_DXT1_RGBA";
        case 0x82ce: return "GL_VIEW_CLASS_S3TC_DXT3_RGBA";
        case 0x82cf: return "GL_VIEW_CLASS_S3TC_DXT5_RGBA";
        case 0x82d0: return "GL_VIEW_CLASS_RGTC1_RED";
        case 0x82d1: return "GL_VIEW_CLASS_RGTC2_RG";
        case 0x82d2: return "GL_VIEW_CLASS_BPTC_UNORM";
        case 0x82d3: return "GL_VIEW_CLASS_BPTC_FLOAT";
        case 0x82d4: return "GL_VERTEX_ATTRIB_BINDING";
        case 0x82d5: return "GL_VERTEX_ATTRIB_RELATIVE_OFFSET";
        case 0x82d6: return "GL_VERTEX_BINDING_DIVISOR";
        case 0x82d7: return "GL_VERTEX_BINDING_OFFSET";
        case 0x82d8: return "GL_VERTEX_BINDING_STRIDE";
        case 0x82d9: return "GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET";
        case 0x82da: return "GL_MAX_VERTEX_ATTRIB_BINDINGS";
        case 0x82db: return "GL_TEXTURE_VIEW_MIN_LEVEL";
        case 0x82dc: return "GL_TEXTURE_VIEW_NUM_LEVELS";
        case 0x82dd: return "GL_TEXTURE_VIEW_MIN_LAYER";
        case 0x82de: return "GL_TEXTURE_VIEW_NUM_LAYERS";
        case 0x82df: return "GL_TEXTURE_IMMUTABLE_LEVELS";
        case 0x82e0: return "GL_BUFFER";
        case 0x82e1: return "GL_SHADER";
        case 0x82e2: return "GL_PROGRAM";
        case 0x82e3: return "GL_QUERY";
        case 0x82e4: return "GL_PROGRAM_PIPELINE";
#endif
#if defined(GL_VERSION_4_4)
        case 0x82e5: return "GL_MAX_VERTEX_ATTRIB_STRIDE";
#endif
#if defined(GL_VERSION_4_3)
        case 0x82e6: return "GL_SAMPLER";
        case 0x82e7: return "GL_DISPLAY_LIST";
        case 0x82e8: return "GL_MAX_LABEL_LENGTH";
        case 0x82e9: return "GL_NUM_SHADING_LANGUAGE_VERSIONS";
#endif
#if defined(GL_VERSION_4_5)
        case 0x82ea: return "GL_QUERY_TARGET";
#endif
        case 0x82ec:
#if defined(GL_VERSION_4_6)
                    return "GL_TRANSFORM_FEEDBACK_OVERFLOW";
#endif
#if defined(GL_ARB_transform_feedback_overflow_query)
                    return "GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB";
#endif
            break;
        case 0x82ed:
#if defined(GL_VERSION_4_6)
                    return "GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW";
#endif
#if defined(GL_ARB_transform_feedback_overflow_query)
                    return "GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB";
#endif
            break;
        case 0x82ee:
#if defined(GL_VERSION_4_6)
                    return "GL_VERTICES_SUBMITTED";
#endif
#if defined(GL_ARB_pipeline_statistics_query)
                    return "GL_VERTICES_SUBMITTED_ARB";
#endif
            break;
        case 0x82ef:
#if defined(GL_VERSION_4_6)
                    return "GL_PRIMITIVES_SUBMITTED";
#endif
#if defined(GL_ARB_pipeline_statistics_query)
                    return "GL_PRIMITIVES_SUBMITTED_ARB";
#endif
            break;
        case 0x82f0:
#if defined(GL_VERSION_4_6)
                    return "GL_VERTEX_SHADER_INVOCATIONS";
#endif
#if defined(GL_ARB_pipeline_statistics_query)
                    return "GL_VERTEX_SHADER_INVOCATIONS_ARB";
#endif
            break;
        case 0x82f1:
#if defined(GL_VERSION_4_6)
                    return "GL_TESS_CONTROL_SHADER_PATCHES";
#endif
#if defined(GL_ARB_pipeline_statistics_query)
                    return "GL_TESS_CONTROL_SHADER_PATCHES_ARB";
#endif
            break;
        case 0x82f2:
#if defined(GL_VERSION_4_6)
                    return "GL_TESS_EVALUATION_SHADER_INVOCATIONS";
#endif
#if defined(GL_ARB_pipeline_statistics_query)
                    return "GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB";
#endif
            break;
        case 0x82f3:
#if defined(GL_VERSION_4_6)
                    return "GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED";
#endif
#if defined(GL_ARB_pipeline_statistics_query)
                    return "GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB";
#endif
            break;
        case 0x82f4:
#if defined(GL_VERSION_4_6)
                    return "GL_FRAGMENT_SHADER_INVOCATIONS";
#endif
#if defined(GL_ARB_pipeline_statistics_query)
                    return "GL_FRAGMENT_SHADER_INVOCATIONS_ARB";
#endif
            break;
        case 0x82f5:
#if defined(GL_VERSION_4_6)
                    return "GL_COMPUTE_SHADER_INVOCATIONS";
#endif
#if defined(GL_ARB_pipeline_statistics_query)
                    return "GL_COMPUTE_SHADER_INVOCATIONS_ARB";
#endif
            break;
        case 0x82f6:
#if defined(GL_VERSION_4_6)
                    return "GL_CLIPPING_INPUT_PRIMITIVES";
#endif
#if defined(GL_ARB_pipeline_statistics_query)
                    return "GL_CLIPPING_INPUT_PRIMITIVES_ARB";
#endif
            break;
        case 0x82f7:
#if defined(GL_VERSION_4_6)
                    return "GL_CLIPPING_OUTPUT_PRIMITIVES";
#endif
#if defined(GL_ARB_pipeline_statistics_query)
                    return "GL_CLIPPING_OUTPUT_PRIMITIVES_ARB";
#endif
            break;
#if defined(GL_ARB_sparse_buffer)
        case 0x82f8: return "GL_SPARSE_BUFFER_PAGE_SIZE_ARB";
#endif
#if defined(GL_VERSION_4_5)
        case 0x82f9: return "GL_MAX_CULL_DISTANCES";
        case 0x82fa: return "GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES";
        case 0x82fb: return "GL_CONTEXT_RELEASE_BEHAVIOR";
        case 0x82fc: return "GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH";
#endif
#if defined(GL_SGIX_convolution_accuracy)
        case 0x8316: return "GL_CONVOLUTION_HINT_SGIX";
#endif
#if defined(GL_SGIX_ycrcba)
        case 0x8318: return "GL_YCRCB_SGIX";
        case 0x8319: return "GL_YCRCBA_SGIX";
#endif
#if defined(GL_SGIX_blend_alpha_minmax)
        case 0x8320: return "GL_ALPHA_MIN_SGIX";
        case 0x8321: return "GL_ALPHA_MAX_SGIX";
#endif
#if defined(GL_SGIX_scalebias_hint)
        case 0x8322: return "GL_SCALEBIAS_HINT_SGIX";
#endif
#if defined(GL_SGIX_async)
        case 0x8329: return "GL_ASYNC_MARKER_SGIX";
#endif
#if defined(GL_SGIX_pixel_texture)
        case 0x832b: return "GL_PIXEL_TEX_GEN_MODE_SGIX";
#endif
#if defined(GL_SGIX_async_histogram)
        case 0x832c: return "GL_ASYNC_HISTOGRAM_SGIX";
        case 0x832d: return "GL_MAX_ASYNC_HISTOGRAM_SGIX";
#endif
#if defined(GL_EXT_pixel_transform)
        case 0x8330: return "GL_PIXEL_TRANSFORM_2D_EXT";
        case 0x8331: return "GL_PIXEL_MAG_FILTER_EXT";
        case 0x8332: return "GL_PIXEL_MIN_FILTER_EXT";
        case 0x8333: return "GL_PIXEL_CUBIC_WEIGHT_EXT";
        case 0x8334: return "GL_CUBIC_EXT";
        case 0x8335: return "GL_AVERAGE_EXT";
        case 0x8336: return "GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT";
        case 0x8337: return "GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT";
        case 0x8338: return "GL_PIXEL_TRANSFORM_2D_MATRIX_EXT";
#endif
#if defined(GL_EXT_light_texture)
        case 0x8349: return "GL_FRAGMENT_MATERIAL_EXT";
        case 0x834a: return "GL_FRAGMENT_NORMAL_EXT";
        case 0x834c: return "GL_FRAGMENT_COLOR_EXT";
        case 0x834d: return "GL_ATTENUATION_EXT";
        case 0x834e: return "GL_SHADOW_ATTENUATION_EXT";
        case 0x834f: return "GL_TEXTURE_APPLICATION_MODE_EXT";
        case 0x8350: return "GL_TEXTURE_LIGHT_EXT";
        case 0x8351: return "GL_TEXTURE_MATERIAL_FACE_EXT";
        case 0x8352: return "GL_TEXTURE_MATERIAL_PARAMETER_EXT";
#endif
#if defined(GL_SGIS_pixel_texture)
        case 0x8353: return "GL_PIXEL_TEXTURE_SGIS";
        case 0x8354: return "GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS";
        case 0x8355: return "GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS";
        case 0x8356: return "GL_PIXEL_GROUP_COLOR_SGIS";
#endif
#if defined(GL_SGIX_async_pixel)
        case 0x835c: return "GL_ASYNC_TEX_IMAGE_SGIX";
        case 0x835d: return "GL_ASYNC_DRAW_PIXELS_SGIX";
        case 0x835e: return "GL_ASYNC_READ_PIXELS_SGIX";
        case 0x835f: return "GL_MAX_ASYNC_TEX_IMAGE_SGIX";
        case 0x8360: return "GL_MAX_ASYNC_DRAW_PIXELS_SGIX";
        case 0x8361: return "GL_MAX_ASYNC_READ_PIXELS_SGIX";
#endif
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
        case 0x8362: return "GL_UNSIGNED_BYTE_2_3_3_REV";
        case 0x8363: return "GL_UNSIGNED_SHORT_5_6_5";
        case 0x8364: return "GL_UNSIGNED_SHORT_5_6_5_REV";
        case 0x8365: return "GL_UNSIGNED_SHORT_4_4_4_4_REV";
        case 0x8366: return "GL_UNSIGNED_SHORT_1_5_5_5_REV";
        case 0x8367: return "GL_UNSIGNED_INT_8_8_8_8_REV";
        case 0x8368: return "GL_UNSIGNED_INT_2_10_10_10_REV";
#endif
#if defined(GL_SGIX_texture_coordinate_clamp)
        case 0x8369: return "GL_TEXTURE_MAX_CLAMP_S_SGIX";
        case 0x836a: return "GL_TEXTURE_MAX_CLAMP_T_SGIX";
        case 0x836b: return "GL_TEXTURE_MAX_CLAMP_R_SGIX";
#endif
        case 0x8370:
#if defined(GL_VERSION_1_4)
                    return "GL_MIRRORED_REPEAT";
#endif
#if defined(GL_ARB_texture_mirrored_repeat)
                    return "GL_MIRRORED_REPEAT_ARB";
#endif
#if defined(GL_IBM_texture_mirrored_repeat)
                    return "GL_MIRRORED_REPEAT_IBM";
#endif
            break;
#if defined(GL_S3_s3tc)
        case 0x83a0: return "GL_RGB_S3TC";
        case 0x83a1: return "GL_RGB4_S3TC";
        case 0x83a2: return "GL_RGBA_S3TC";
        case 0x83a3: return "GL_RGBA4_S3TC";
        case 0x83a4: return "GL_RGBA_DXT5_S3TC";
        case 0x83a5: return "GL_RGBA4_DXT5_S3TC";
#endif
#if defined(GL_SGIX_vertex_preclip)
        case 0x83ee: return "GL_VERTEX_PRECLIP_SGIX";
        case 0x83ef: return "GL_VERTEX_PRECLIP_HINT_SGIX";
#endif
#if defined(GL_EXT_texture_compression_s3tc)
        case 0x83f0: return "GL_COMPRESSED_RGB_S3TC_DXT1_EXT";
        case 0x83f1: return "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT";
        case 0x83f2: return "GL_COMPRESSED_RGBA_S3TC_DXT3_EXT";
        case 0x83f3: return "GL_COMPRESSED_RGBA_S3TC_DXT5_EXT";
#endif
#if defined(GL_INTEL_parallel_arrays)
        case 0x83f4: return "GL_PARALLEL_ARRAYS_INTEL";
        case 0x83f5: return "GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL";
        case 0x83f6: return "GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL";
        case 0x83f7: return "GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL";
        case 0x83f8: return "GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL";
#endif
#if defined(GL_INTEL_performance_query)
        case 0x83f9: return "GL_PERFQUERY_DONOT_FLUSH_INTEL";
        case 0x83fa: return "GL_PERFQUERY_FLUSH_INTEL";
        case 0x83fb: return "GL_PERFQUERY_WAIT_INTEL";
#endif
#if defined(GL_INTEL_blackhole_render)
        case 0x83fc: return "GL_BLACKHOLE_RENDER_INTEL";
#endif
#if defined(GL_INTEL_conservative_rasterization)
        case 0x83fe: return "GL_CONSERVATIVE_RASTERIZATION_INTEL";
#endif
#if defined(GL_INTEL_map_texture)
        case 0x83ff: return "GL_TEXTURE_MEMORY_LAYOUT_INTEL";
#endif
#if defined(GL_SGIX_fragment_lighting)
        case 0x8400: return "GL_FRAGMENT_LIGHTING_SGIX";
        case 0x8401: return "GL_FRAGMENT_COLOR_MATERIAL_SGIX";
        case 0x8402: return "GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX";
        case 0x8403: return "GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX";
        case 0x8404: return "GL_MAX_FRAGMENT_LIGHTS_SGIX";
        case 0x8405: return "GL_MAX_ACTIVE_LIGHTS_SGIX";
        case 0x8406: return "GL_CURRENT_RASTER_NORMAL_SGIX";
        case 0x8407: return "GL_LIGHT_ENV_MODE_SGIX";
        case 0x8408: return "GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX";
        case 0x8409: return "GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX";
        case 0x840a: return "GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX";
        case 0x840b: return "GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX";
        case 0x840c: return "GL_FRAGMENT_LIGHT0_SGIX";
        case 0x840d: return "GL_FRAGMENT_LIGHT1_SGIX";
        case 0x840e: return "GL_FRAGMENT_LIGHT2_SGIX";
        case 0x840f: return "GL_FRAGMENT_LIGHT3_SGIX";
        case 0x8410: return "GL_FRAGMENT_LIGHT4_SGIX";
        case 0x8411: return "GL_FRAGMENT_LIGHT5_SGIX";
        case 0x8412: return "GL_FRAGMENT_LIGHT6_SGIX";
        case 0x8413: return "GL_FRAGMENT_LIGHT7_SGIX";
#endif
#if defined(GL_SGIX_resample)
        case 0x842e: return "GL_PACK_RESAMPLE_SGIX";
        case 0x842f: return "GL_UNPACK_RESAMPLE_SGIX";
        case 0x8430: return "GL_RESAMPLE_DECIMATE_SGIX";
        case 0x8433: return "GL_RESAMPLE_REPLICATE_SGIX";
        case 0x8434: return "GL_RESAMPLE_ZERO_FILL_SGIX";
#endif
#if defined(GL_EXT_coordinate_frame)
        case 0x8439: return "GL_TANGENT_ARRAY_EXT";
        case 0x843a: return "GL_BINORMAL_ARRAY_EXT";
        case 0x843b: return "GL_CURRENT_TANGENT_EXT";
        case 0x843c: return "GL_CURRENT_BINORMAL_EXT";
        case 0x843e: return "GL_TANGENT_ARRAY_TYPE_EXT";
        case 0x843f: return "GL_TANGENT_ARRAY_STRIDE_EXT";
        case 0x8440: return "GL_BINORMAL_ARRAY_TYPE_EXT";
        case 0x8441: return "GL_BINORMAL_ARRAY_STRIDE_EXT";
        case 0x8442: return "GL_TANGENT_ARRAY_POINTER_EXT";
        case 0x8443: return "GL_BINORMAL_ARRAY_POINTER_EXT";
        case 0x8444: return "GL_MAP1_TANGENT_EXT";
        case 0x8445: return "GL_MAP2_TANGENT_EXT";
        case 0x8446: return "GL_MAP1_BINORMAL_EXT";
        case 0x8447: return "GL_MAP2_BINORMAL_EXT";
#endif
#if defined(GL_SGIX_clipmap)
        case 0x844d: return "GL_NEAREST_CLIPMAP_NEAREST_SGIX";
        case 0x844e: return "GL_NEAREST_CLIPMAP_LINEAR_SGIX";
        case 0x844f: return "GL_LINEAR_CLIPMAP_NEAREST_SGIX";
#endif
        case 0x8450:
#if defined(GL_VERSION_1_4)
                    return "GL_FOG_COORDINATE_SOURCE";
#endif
#if defined(GL_EXT_fog_coord)
                    return "GL_FOG_COORDINATE_SOURCE_EXT";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_FOG_COORD_SRC";
#endif
            break;
        case 0x8451:
#if defined(GL_VERSION_1_5)
                    return "GL_FOG_COORD";
#endif
#if defined(GL_VERSION_1_4)
                    return "GL_FOG_COORDINATE";
#endif
#if defined(GL_EXT_fog_coord)
                    return "GL_FOG_COORDINATE_EXT";
#endif
            break;
        case 0x8452:
#if defined(GL_VERSION_1_4)
                    return "GL_FRAGMENT_DEPTH";
#endif
#if defined(GL_EXT_fog_coord)
                    return "GL_FRAGMENT_DEPTH_EXT";
#endif
            break;
        case 0x8453:
#if defined(GL_VERSION_1_5)
                    return "GL_CURRENT_FOG_COORD";
#endif
#if defined(GL_VERSION_1_4)
                    return "GL_CURRENT_FOG_COORDINATE";
#endif
#if defined(GL_EXT_fog_coord)
                    return "GL_CURRENT_FOG_COORDINATE_EXT";
#endif
            break;
        case 0x8454:
#if defined(GL_VERSION_1_4)
                    return "GL_FOG_COORDINATE_ARRAY_TYPE";
#endif
#if defined(GL_EXT_fog_coord)
                    return "GL_FOG_COORDINATE_ARRAY_TYPE_EXT";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_FOG_COORD_ARRAY_TYPE";
#endif
            break;
        case 0x8455:
#if defined(GL_VERSION_1_4)
                    return "GL_FOG_COORDINATE_ARRAY_STRIDE";
#endif
#if defined(GL_EXT_fog_coord)
                    return "GL_FOG_COORDINATE_ARRAY_STRIDE_EXT";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_FOG_COORD_ARRAY_STRIDE";
#endif
            break;
        case 0x8456:
#if defined(GL_VERSION_1_4)
                    return "GL_FOG_COORDINATE_ARRAY_POINTER";
#endif
#if defined(GL_EXT_fog_coord)
                    return "GL_FOG_COORDINATE_ARRAY_POINTER_EXT";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_FOG_COORD_ARRAY_POINTER";
#endif
            break;
        case 0x8457:
#if defined(GL_VERSION_1_4)
                    return "GL_FOG_COORDINATE_ARRAY";
#endif
#if defined(GL_EXT_fog_coord)
                    return "GL_FOG_COORDINATE_ARRAY_EXT";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_FOG_COORD_ARRAY";
#endif
            break;
        case 0x8458:
#if defined(GL_VERSION_1_4)
                    return "GL_COLOR_SUM";
#endif
#if defined(GL_ARB_vertex_program)
                    return "GL_COLOR_SUM_ARB";
#endif
#if defined(GL_EXT_secondary_color)
                    return "GL_COLOR_SUM_EXT";
#endif
            break;
        case 0x8459:
#if defined(GL_VERSION_1_4)
                    return "GL_CURRENT_SECONDARY_COLOR";
#endif
#if defined(GL_EXT_secondary_color)
                    return "GL_CURRENT_SECONDARY_COLOR_EXT";
#endif
            break;
        case 0x845a:
#if defined(GL_VERSION_1_4)
                    return "GL_SECONDARY_COLOR_ARRAY_SIZE";
#endif
#if defined(GL_EXT_secondary_color)
                    return "GL_SECONDARY_COLOR_ARRAY_SIZE_EXT";
#endif
            break;
        case 0x845b:
#if defined(GL_VERSION_1_4)
                    return "GL_SECONDARY_COLOR_ARRAY_TYPE";
#endif
#if defined(GL_EXT_secondary_color)
                    return "GL_SECONDARY_COLOR_ARRAY_TYPE_EXT";
#endif
            break;
        case 0x845c:
#if defined(GL_VERSION_1_4)
                    return "GL_SECONDARY_COLOR_ARRAY_STRIDE";
#endif
#if defined(GL_EXT_secondary_color)
                    return "GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT";
#endif
            break;
        case 0x845d:
#if defined(GL_VERSION_1_4)
                    return "GL_SECONDARY_COLOR_ARRAY_POINTER";
#endif
#if defined(GL_EXT_secondary_color)
                    return "GL_SECONDARY_COLOR_ARRAY_POINTER_EXT";
#endif
            break;
        case 0x845e:
#if defined(GL_VERSION_1_4)
                    return "GL_SECONDARY_COLOR_ARRAY";
#endif
#if defined(GL_EXT_secondary_color)
                    return "GL_SECONDARY_COLOR_ARRAY_EXT";
#endif
            break;
#if defined(GL_VERSION_2_1)
        case 0x845f: return "GL_CURRENT_RASTER_SECONDARY_COLOR";
#endif
#if defined(__gl_h_) || defined(GL_VERSION_1_2)
        case 0x846d: return "GL_ALIASED_POINT_SIZE_RANGE";
        case 0x846e: return "GL_ALIASED_LINE_WIDTH_RANGE";
#endif
#if defined(GL_REND_screen_coordinates)
        case 0x8490: return "GL_SCREEN_COORDINATES_REND";
        case 0x8491: return "GL_INVERTED_SCREEN_W_REND";
#endif
        case 0x84c0:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE0";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE0_ARB";
#endif
            break;
        case 0x84c1:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE1";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE1_ARB";
#endif
            break;
        case 0x84c2:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE2";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE2_ARB";
#endif
            break;
        case 0x84c3:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE3";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE3_ARB";
#endif
            break;
        case 0x84c4:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE4";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE4_ARB";
#endif
            break;
        case 0x84c5:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE5";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE5_ARB";
#endif
            break;
        case 0x84c6:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE6";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE6_ARB";
#endif
            break;
        case 0x84c7:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE7";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE7_ARB";
#endif
            break;
        case 0x84c8:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE8";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE8_ARB";
#endif
            break;
        case 0x84c9:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE9";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE9_ARB";
#endif
            break;
        case 0x84ca:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE10";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE10_ARB";
#endif
            break;
        case 0x84cb:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE11";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE11_ARB";
#endif
            break;
        case 0x84cc:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE12";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE12_ARB";
#endif
            break;
        case 0x84cd:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE13";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE13_ARB";
#endif
            break;
        case 0x84ce:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE14";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE14_ARB";
#endif
            break;
        case 0x84cf:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE15";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE15_ARB";
#endif
            break;
        case 0x84d0:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE16";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE16_ARB";
#endif
            break;
        case 0x84d1:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE17";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE17_ARB";
#endif
            break;
        case 0x84d2:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE18";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE18_ARB";
#endif
            break;
        case 0x84d3:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE19";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE19_ARB";
#endif
            break;
        case 0x84d4:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE20";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE20_ARB";
#endif
            break;
        case 0x84d5:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE21";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE21_ARB";
#endif
            break;
        case 0x84d6:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE22";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE22_ARB";
#endif
            break;
        case 0x84d7:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE23";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE23_ARB";
#endif
            break;
        case 0x84d8:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE24";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE24_ARB";
#endif
            break;
        case 0x84d9:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE25";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE25_ARB";
#endif
            break;
        case 0x84da:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE26";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE26_ARB";
#endif
            break;
        case 0x84db:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE27";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE27_ARB";
#endif
            break;
        case 0x84dc:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE28";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE28_ARB";
#endif
            break;
        case 0x84dd:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE29";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE29_ARB";
#endif
            break;
        case 0x84de:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE30";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE30_ARB";
#endif
            break;
        case 0x84df:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE31";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_TEXTURE31_ARB";
#endif
            break;
        case 0x84e0:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_ACTIVE_TEXTURE";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_ACTIVE_TEXTURE_ARB";
#endif
            break;
        case 0x84e1:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_CLIENT_ACTIVE_TEXTURE";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_CLIENT_ACTIVE_TEXTURE_ARB";
#endif
            break;
        case 0x84e2:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_MAX_TEXTURE_UNITS";
#endif
#if defined(GL_ARB_multitexture)
                    return "GL_MAX_TEXTURE_UNITS_ARB";
#endif
            break;
        case 0x84e3:
#if defined(GL_NV_path_rendering)
                    return "GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV";
#endif
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TRANSPOSE_MODELVIEW_MATRIX";
#endif
#if defined(GL_ARB_transpose_matrix)
                    return "GL_TRANSPOSE_MODELVIEW_MATRIX_ARB";
#endif
            break;
        case 0x84e4:
#if defined(GL_NV_path_rendering)
                    return "GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV";
#endif
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TRANSPOSE_PROJECTION_MATRIX";
#endif
#if defined(GL_ARB_transpose_matrix)
                    return "GL_TRANSPOSE_PROJECTION_MATRIX_ARB";
#endif
            break;
        case 0x84e5:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TRANSPOSE_TEXTURE_MATRIX";
#endif
#if defined(GL_ARB_transpose_matrix)
                    return "GL_TRANSPOSE_TEXTURE_MATRIX_ARB";
#endif
            break;
        case 0x84e6:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TRANSPOSE_COLOR_MATRIX";
#endif
#if defined(GL_ARB_transpose_matrix)
                    return "GL_TRANSPOSE_COLOR_MATRIX_ARB";
#endif
            break;
        case 0x84e7:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_SUBTRACT";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_SUBTRACT_ARB";
#endif
            break;
        case 0x84e8:
#if defined(GL_VERSION_3_0)
                    return "GL_MAX_RENDERBUFFER_SIZE";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_MAX_RENDERBUFFER_SIZE_EXT";
#endif
            break;
        case 0x84e9:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_COMPRESSED_ALPHA";
#endif
#if defined(GL_ARB_texture_compression)
                    return "GL_COMPRESSED_ALPHA_ARB";
#endif
            break;
        case 0x84ea:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_COMPRESSED_LUMINANCE";
#endif
#if defined(GL_ARB_texture_compression)
                    return "GL_COMPRESSED_LUMINANCE_ARB";
#endif
            break;
        case 0x84eb:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_COMPRESSED_LUMINANCE_ALPHA";
#endif
#if defined(GL_ARB_texture_compression)
                    return "GL_COMPRESSED_LUMINANCE_ALPHA_ARB";
#endif
            break;
        case 0x84ec:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_COMPRESSED_INTENSITY";
#endif
#if defined(GL_ARB_texture_compression)
                    return "GL_COMPRESSED_INTENSITY_ARB";
#endif
            break;
        case 0x84ed:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_COMPRESSED_RGB";
#endif
#if defined(GL_ARB_texture_compression)
                    return "GL_COMPRESSED_RGB_ARB";
#endif
            break;
        case 0x84ee:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_COMPRESSED_RGBA";
#endif
#if defined(GL_ARB_texture_compression)
                    return "GL_COMPRESSED_RGBA_ARB";
#endif
            break;
        case 0x84ef:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE_COMPRESSION_HINT";
#endif
#if defined(GL_ARB_texture_compression)
                    return "GL_TEXTURE_COMPRESSION_HINT_ARB";
#endif
            break;
#if defined(GL_VERSION_4_0)
        case 0x84f0: return "GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER";
        case 0x84f1: return "GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER";
#endif
#if defined(GL_NV_fence)
        case 0x84f2: return "GL_ALL_COMPLETED_NV";
        case 0x84f3: return "GL_FENCE_STATUS_NV";
        case 0x84f4: return "GL_FENCE_CONDITION_NV";
#endif
        case 0x84f5:
#if defined(GL_VERSION_3_1)
                    return "GL_TEXTURE_RECTANGLE";
#endif
#if defined(GL_ARB_texture_rectangle)
                    return "GL_TEXTURE_RECTANGLE_ARB";
#endif
#if defined(GL_NV_texture_rectangle)
                    return "GL_TEXTURE_RECTANGLE_NV";
#endif
            break;
        case 0x84f6:
#if defined(GL_VERSION_3_1)
                    return "GL_TEXTURE_BINDING_RECTANGLE";
#endif
#if defined(GL_ARB_texture_rectangle)
                    return "GL_TEXTURE_BINDING_RECTANGLE_ARB";
#endif
#if defined(GL_NV_texture_rectangle)
                    return "GL_TEXTURE_BINDING_RECTANGLE_NV";
#endif
            break;
        case 0x84f7:
#if defined(GL_VERSION_3_1)
                    return "GL_PROXY_TEXTURE_RECTANGLE";
#endif
#if defined(GL_ARB_texture_rectangle)
                    return "GL_PROXY_TEXTURE_RECTANGLE_ARB";
#endif
#if defined(GL_NV_texture_rectangle)
                    return "GL_PROXY_TEXTURE_RECTANGLE_NV";
#endif
            break;
        case 0x84f8:
#if defined(GL_VERSION_3_1)
                    return "GL_MAX_RECTANGLE_TEXTURE_SIZE";
#endif
#if defined(GL_ARB_texture_rectangle)
                    return "GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB";
#endif
#if defined(GL_NV_texture_rectangle)
                    return "GL_MAX_RECTANGLE_TEXTURE_SIZE_NV";
#endif
            break;
        case 0x84f9:
#if defined(GL_VERSION_3_0)
                    return "GL_DEPTH_STENCIL";
#endif
#if defined(GL_EXT_packed_depth_stencil)
                    return "GL_DEPTH_STENCIL_EXT";
#endif
#if defined(GL_NV_packed_depth_stencil)
                    return "GL_DEPTH_STENCIL_NV";
#endif
            break;
        case 0x84fa:
#if defined(GL_VERSION_3_0)
                    return "GL_UNSIGNED_INT_24_8";
#endif
#if defined(GL_EXT_packed_depth_stencil)
                    return "GL_UNSIGNED_INT_24_8_EXT";
#endif
#if defined(GL_NV_packed_depth_stencil)
                    return "GL_UNSIGNED_INT_24_8_NV";
#endif
            break;
        case 0x84fd:
#if defined(GL_VERSION_1_4)
                    return "GL_MAX_TEXTURE_LOD_BIAS";
#endif
#if defined(GL_EXT_texture_lod_bias)
                    return "GL_MAX_TEXTURE_LOD_BIAS_EXT";
#endif
            break;
        case 0x84fe:
#if defined(GL_VERSION_4_6)
                    return "GL_TEXTURE_MAX_ANISOTROPY";
#endif
#if defined(GL_EXT_texture_filter_anisotropic)
                    return "GL_TEXTURE_MAX_ANISOTROPY_EXT";
#endif
            break;
        case 0x84ff:
#if defined(GL_VERSION_4_6)
                    return "GL_MAX_TEXTURE_MAX_ANISOTROPY";
#endif
#if defined(GL_EXT_texture_filter_anisotropic)
                    return "GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT";
#endif
            break;
        case 0x8500:
#if defined(GL_VERSION_1_4)
                    return "GL_TEXTURE_FILTER_CONTROL";
#endif
#if defined(GL_EXT_texture_lod_bias)
                    return "GL_TEXTURE_FILTER_CONTROL_EXT";
#endif
            break;
        case 0x8501:
#if defined(GL_VERSION_1_4)
                    return "GL_TEXTURE_LOD_BIAS";
#endif
#if defined(GL_EXT_texture_lod_bias)
                    return "GL_TEXTURE_LOD_BIAS_EXT";
#endif
            break;
#if defined(GL_EXT_vertex_weighting)
        case 0x8502: return "GL_MODELVIEW1_STACK_DEPTH_EXT";
#endif
#if defined(GL_NV_texture_env_combine4)
        case 0x8503: return "GL_COMBINE4_NV";
#endif
#if defined(GL_NV_light_max_exponent)
        case 0x8504: return "GL_MAX_SHININESS_NV";
        case 0x8505: return "GL_MAX_SPOT_EXPONENT_NV";
#endif
#if defined(GL_EXT_vertex_weighting)
        case 0x8506: return "GL_MODELVIEW1_MATRIX_EXT";
#endif
        case 0x8507:
#if defined(GL_VERSION_1_4)
                    return "GL_INCR_WRAP";
#endif
#if defined(GL_EXT_stencil_wrap)
                    return "GL_INCR_WRAP_EXT";
#endif
            break;
        case 0x8508:
#if defined(GL_VERSION_1_4)
                    return "GL_DECR_WRAP";
#endif
#if defined(GL_EXT_stencil_wrap)
                    return "GL_DECR_WRAP_EXT";
#endif
            break;
#if defined(GL_EXT_vertex_weighting)
        case 0x8509: return "GL_VERTEX_WEIGHTING_EXT";
#endif
        case 0x850a:
#if defined(GL_ARB_vertex_blend)
                    return "GL_MODELVIEW1_ARB";
#endif
#if defined(GL_EXT_vertex_weighting)
                    return "GL_MODELVIEW1_EXT";
#endif
            break;
#if defined(GL_EXT_vertex_weighting)
        case 0x850b: return "GL_CURRENT_VERTEX_WEIGHT_EXT";
        case 0x850c: return "GL_VERTEX_WEIGHT_ARRAY_EXT";
        case 0x850d: return "GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT";
        case 0x850e: return "GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT";
        case 0x850f: return "GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT";
        case 0x8510: return "GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT";
#endif
        case 0x8511:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_NORMAL_MAP";
#endif
#if defined(GL_ARB_texture_cube_map)
                    return "GL_NORMAL_MAP_ARB";
#endif
#if defined(GL_EXT_texture_cube_map)
                    return "GL_NORMAL_MAP_EXT";
#endif
#if defined(GL_NV_texgen_reflection)
                    return "GL_NORMAL_MAP_NV";
#endif
            break;
        case 0x8512:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_REFLECTION_MAP";
#endif
#if defined(GL_ARB_texture_cube_map)
                    return "GL_REFLECTION_MAP_ARB";
#endif
#if defined(GL_EXT_texture_cube_map)
                    return "GL_REFLECTION_MAP_EXT";
#endif
#if defined(GL_NV_texgen_reflection)
                    return "GL_REFLECTION_MAP_NV";
#endif
            break;
        case 0x8513:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE_CUBE_MAP";
#endif
#if defined(GL_ARB_texture_cube_map)
                    return "GL_TEXTURE_CUBE_MAP_ARB";
#endif
#if defined(GL_EXT_texture_cube_map)
                    return "GL_TEXTURE_CUBE_MAP_EXT";
#endif
            break;
        case 0x8514:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE_BINDING_CUBE_MAP";
#endif
#if defined(GL_ARB_texture_cube_map)
                    return "GL_TEXTURE_BINDING_CUBE_MAP_ARB";
#endif
#if defined(GL_EXT_texture_cube_map)
                    return "GL_TEXTURE_BINDING_CUBE_MAP_EXT";
#endif
            break;
        case 0x8515:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_X";
#endif
#if defined(GL_ARB_texture_cube_map)
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB";
#endif
#if defined(GL_EXT_texture_cube_map)
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT";
#endif
            break;
        case 0x8516:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_X";
#endif
#if defined(GL_ARB_texture_cube_map)
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB";
#endif
#if defined(GL_EXT_texture_cube_map)
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT";
#endif
            break;
        case 0x8517:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Y";
#endif
#if defined(GL_ARB_texture_cube_map)
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB";
#endif
#if defined(GL_EXT_texture_cube_map)
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT";
#endif
            break;
        case 0x8518:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y";
#endif
#if defined(GL_ARB_texture_cube_map)
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB";
#endif
#if defined(GL_EXT_texture_cube_map)
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT";
#endif
            break;
        case 0x8519:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Z";
#endif
#if defined(GL_ARB_texture_cube_map)
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB";
#endif
#if defined(GL_EXT_texture_cube_map)
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT";
#endif
            break;
        case 0x851a:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z";
#endif
#if defined(GL_ARB_texture_cube_map)
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB";
#endif
#if defined(GL_EXT_texture_cube_map)
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT";
#endif
            break;
        case 0x851b:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_PROXY_TEXTURE_CUBE_MAP";
#endif
#if defined(GL_ARB_texture_cube_map)
                    return "GL_PROXY_TEXTURE_CUBE_MAP_ARB";
#endif
#if defined(GL_EXT_texture_cube_map)
                    return "GL_PROXY_TEXTURE_CUBE_MAP_EXT";
#endif
            break;
        case 0x851c:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_MAX_CUBE_MAP_TEXTURE_SIZE";
#endif
#if defined(GL_ARB_texture_cube_map)
                    return "GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB";
#endif
#if defined(GL_EXT_texture_cube_map)
                    return "GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT";
#endif
            break;
        case 0x851d:
#if defined(GL_APPLE_vertex_array_range)
                    return "GL_VERTEX_ARRAY_RANGE_APPLE";
#endif
#if defined(GL_NV_vertex_array_range)
                    return "GL_VERTEX_ARRAY_RANGE_NV";
#endif
            break;
        case 0x851e:
#if defined(GL_APPLE_vertex_array_range)
                    return "GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE";
#endif
#if defined(GL_NV_vertex_array_range)
                    return "GL_VERTEX_ARRAY_RANGE_LENGTH_NV";
#endif
            break;
        case 0x851f:
#if defined(GL_NV_vertex_array_range)
                    return "GL_VERTEX_ARRAY_RANGE_VALID_NV";
#endif
#if defined(GL_APPLE_vertex_array_range)
                    return "GL_VERTEX_ARRAY_STORAGE_HINT_APPLE";
#endif
            break;
#if defined(GL_NV_vertex_array_range)
        case 0x8520: return "GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV";
#endif
        case 0x8521:
#if defined(GL_APPLE_vertex_array_range)
                    return "GL_VERTEX_ARRAY_RANGE_POINTER_APPLE";
#endif
#if defined(GL_NV_vertex_array_range)
                    return "GL_VERTEX_ARRAY_RANGE_POINTER_NV";
#endif
            break;
#if defined(GL_NV_register_combiners)
        case 0x8522: return "GL_REGISTER_COMBINERS_NV";
        case 0x8523: return "GL_VARIABLE_A_NV";
        case 0x8524: return "GL_VARIABLE_B_NV";
        case 0x8525: return "GL_VARIABLE_C_NV";
        case 0x8526: return "GL_VARIABLE_D_NV";
        case 0x8527: return "GL_VARIABLE_E_NV";
        case 0x8528: return "GL_VARIABLE_F_NV";
        case 0x8529: return "GL_VARIABLE_G_NV";
        case 0x852a: return "GL_CONSTANT_COLOR0_NV";
        case 0x852b: return "GL_CONSTANT_COLOR1_NV";
#endif
#if defined(GL_NV_path_rendering)
        case 0x852c: return "GL_PRIMARY_COLOR_NV";
        case 0x852d: return "GL_SECONDARY_COLOR_NV";
#endif
#if defined(GL_NV_register_combiners)
        case 0x852e: return "GL_SPARE0_NV";
        case 0x852f: return "GL_SPARE1_NV";
        case 0x8530: return "GL_DISCARD_NV";
        case 0x8531: return "GL_E_TIMES_F_NV";
        case 0x8532: return "GL_SPARE0_PLUS_SECONDARY_COLOR_NV";
#endif
#if defined(GL_NV_vertex_array_range2)
        case 0x8533: return "GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV";
#endif
#if defined(GL_NV_multisample_filter_hint)
        case 0x8534: return "GL_MULTISAMPLE_FILTER_HINT_NV";
#endif
#if defined(GL_NV_register_combiners2)
        case 0x8535: return "GL_PER_STAGE_CONSTANTS_NV";
#endif
#if defined(GL_NV_register_combiners)
        case 0x8536: return "GL_UNSIGNED_IDENTITY_NV";
        case 0x8537: return "GL_UNSIGNED_INVERT_NV";
        case 0x8538: return "GL_EXPAND_NORMAL_NV";
        case 0x8539: return "GL_EXPAND_NEGATE_NV";
        case 0x853a: return "GL_HALF_BIAS_NORMAL_NV";
        case 0x853b: return "GL_HALF_BIAS_NEGATE_NV";
        case 0x853c: return "GL_SIGNED_IDENTITY_NV";
        case 0x853d: return "GL_SIGNED_NEGATE_NV";
        case 0x853e: return "GL_SCALE_BY_TWO_NV";
        case 0x853f: return "GL_SCALE_BY_FOUR_NV";
        case 0x8540: return "GL_SCALE_BY_ONE_HALF_NV";
        case 0x8541: return "GL_BIAS_BY_NEGATIVE_ONE_HALF_NV";
        case 0x8542: return "GL_COMBINER_INPUT_NV";
        case 0x8543: return "GL_COMBINER_MAPPING_NV";
        case 0x8544: return "GL_COMBINER_COMPONENT_USAGE_NV";
        case 0x8545: return "GL_COMBINER_AB_DOT_PRODUCT_NV";
        case 0x8546: return "GL_COMBINER_CD_DOT_PRODUCT_NV";
        case 0x8547: return "GL_COMBINER_MUX_SUM_NV";
        case 0x8548: return "GL_COMBINER_SCALE_NV";
        case 0x8549: return "GL_COMBINER_BIAS_NV";
        case 0x854a: return "GL_COMBINER_AB_OUTPUT_NV";
        case 0x854b: return "GL_COMBINER_CD_OUTPUT_NV";
        case 0x854c: return "GL_COMBINER_SUM_OUTPUT_NV";
        case 0x854d: return "GL_MAX_GENERAL_COMBINERS_NV";
        case 0x854e: return "GL_NUM_GENERAL_COMBINERS_NV";
        case 0x854f: return "GL_COLOR_SUM_CLAMP_NV";
        case 0x8550: return "GL_COMBINER0_NV";
        case 0x8551: return "GL_COMBINER1_NV";
        case 0x8552: return "GL_COMBINER2_NV";
        case 0x8553: return "GL_COMBINER3_NV";
        case 0x8554: return "GL_COMBINER4_NV";
        case 0x8555: return "GL_COMBINER5_NV";
        case 0x8556: return "GL_COMBINER6_NV";
        case 0x8557: return "GL_COMBINER7_NV";
#endif
#if defined(GL_NV_primitive_restart)
        case 0x8558: return "GL_PRIMITIVE_RESTART_NV";
        case 0x8559: return "GL_PRIMITIVE_RESTART_INDEX_NV";
#endif
#if defined(GL_NV_fog_distance)
        case 0x855a: return "GL_FOG_DISTANCE_MODE_NV";
        case 0x855b: return "GL_EYE_RADIAL_NV";
        case 0x855c: return "GL_EYE_PLANE_ABSOLUTE_NV";
#endif
#if defined(GL_NV_texgen_emboss)
        case 0x855d: return "GL_EMBOSS_LIGHT_NV";
        case 0x855e: return "GL_EMBOSS_CONSTANT_NV";
        case 0x855f: return "GL_EMBOSS_MAP_NV";
#endif
#if defined(GL_INGR_color_clamp)
        case 0x8560: return "GL_RED_MIN_CLAMP_INGR";
        case 0x8561: return "GL_GREEN_MIN_CLAMP_INGR";
        case 0x8562: return "GL_BLUE_MIN_CLAMP_INGR";
        case 0x8563: return "GL_ALPHA_MIN_CLAMP_INGR";
        case 0x8564: return "GL_RED_MAX_CLAMP_INGR";
        case 0x8565: return "GL_GREEN_MAX_CLAMP_INGR";
        case 0x8566: return "GL_BLUE_MAX_CLAMP_INGR";
        case 0x8567: return "GL_ALPHA_MAX_CLAMP_INGR";
#endif
#if defined(GL_INGR_interlace_read)
        case 0x8568: return "GL_INTERLACE_READ_INGR";
#endif
        case 0x8570:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_COMBINE";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_COMBINE_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_COMBINE_EXT";
#endif
            break;
        case 0x8571:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_COMBINE_RGB";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_COMBINE_RGB_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_COMBINE_RGB_EXT";
#endif
            break;
        case 0x8572:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_COMBINE_ALPHA";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_COMBINE_ALPHA_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_COMBINE_ALPHA_EXT";
#endif
            break;
        case 0x8573:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_RGB_SCALE";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_RGB_SCALE_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_RGB_SCALE_EXT";
#endif
            break;
        case 0x8574:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_ADD_SIGNED";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_ADD_SIGNED_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_ADD_SIGNED_EXT";
#endif
            break;
        case 0x8575:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_INTERPOLATE";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_INTERPOLATE_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_INTERPOLATE_EXT";
#endif
            break;
        case 0x8576:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_CONSTANT";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_CONSTANT_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_CONSTANT_EXT";
#endif
#if defined(GL_NV_path_rendering)
                    return "GL_CONSTANT_NV";
#endif
            break;
        case 0x8577:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_PRIMARY_COLOR";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_PRIMARY_COLOR_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_PRIMARY_COLOR_EXT";
#endif
            break;
        case 0x8578:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_PREVIOUS";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_PREVIOUS_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_PREVIOUS_EXT";
#endif
            break;
        case 0x8580:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_SOURCE0_RGB";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_SOURCE0_RGB_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_SOURCE0_RGB_EXT";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_SRC0_RGB";
#endif
            break;
        case 0x8581:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_SOURCE1_RGB";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_SOURCE1_RGB_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_SOURCE1_RGB_EXT";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_SRC1_RGB";
#endif
            break;
        case 0x8582:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_SOURCE2_RGB";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_SOURCE2_RGB_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_SOURCE2_RGB_EXT";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_SRC2_RGB";
#endif
            break;
#if defined(GL_NV_texture_env_combine4)
        case 0x8583: return "GL_SOURCE3_RGB_NV";
#endif
        case 0x8588:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_SOURCE0_ALPHA";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_SOURCE0_ALPHA_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_SOURCE0_ALPHA_EXT";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_SRC0_ALPHA";
#endif
            break;
        case 0x8589:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_SOURCE1_ALPHA";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_SOURCE1_ALPHA_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_SOURCE1_ALPHA_EXT";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_SRC1_ALPHA";
#endif
            break;
        case 0x858a:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_SOURCE2_ALPHA";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_SOURCE2_ALPHA_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_SOURCE2_ALPHA_EXT";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_SRC2_ALPHA";
#endif
            break;
#if defined(GL_NV_texture_env_combine4)
        case 0x858b: return "GL_SOURCE3_ALPHA_NV";
#endif
        case 0x8590:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_OPERAND0_RGB";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_OPERAND0_RGB_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_OPERAND0_RGB_EXT";
#endif
            break;
        case 0x8591:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_OPERAND1_RGB";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_OPERAND1_RGB_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_OPERAND1_RGB_EXT";
#endif
            break;
        case 0x8592:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_OPERAND2_RGB";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_OPERAND2_RGB_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_OPERAND2_RGB_EXT";
#endif
            break;
#if defined(GL_NV_texture_env_combine4)
        case 0x8593: return "GL_OPERAND3_RGB_NV";
#endif
        case 0x8598:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_OPERAND0_ALPHA";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_OPERAND0_ALPHA_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_OPERAND0_ALPHA_EXT";
#endif
            break;
        case 0x8599:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_OPERAND1_ALPHA";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_OPERAND1_ALPHA_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_OPERAND1_ALPHA_EXT";
#endif
            break;
        case 0x859a:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_OPERAND2_ALPHA";
#endif
#if defined(GL_ARB_texture_env_combine)
                    return "GL_OPERAND2_ALPHA_ARB";
#endif
#if defined(GL_EXT_texture_env_combine)
                    return "GL_OPERAND2_ALPHA_EXT";
#endif
            break;
#if defined(GL_NV_texture_env_combine4)
        case 0x859b: return "GL_OPERAND3_ALPHA_NV";
#endif
#if defined(GL_SGIX_subsample)
        case 0x85a0: return "GL_PACK_SUBSAMPLE_RATE_SGIX";
        case 0x85a1: return "GL_UNPACK_SUBSAMPLE_RATE_SGIX";
        case 0x85a2: return "GL_PIXEL_SUBSAMPLE_4444_SGIX";
        case 0x85a3: return "GL_PIXEL_SUBSAMPLE_2424_SGIX";
        case 0x85a4: return "GL_PIXEL_SUBSAMPLE_4242_SGIX";
#endif
#if defined(GL_EXT_texture_perturb_normal)
        case 0x85ae: return "GL_PERTURB_EXT";
        case 0x85af: return "GL_TEXTURE_NORMAL_EXT";
#endif
#if defined(GL_APPLE_specular_vector)
        case 0x85b0: return "GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE";
#endif
#if defined(GL_APPLE_transform_hint)
        case 0x85b1: return "GL_TRANSFORM_HINT_APPLE";
#endif
#if defined(GL_APPLE_client_storage)
        case 0x85b2: return "GL_UNPACK_CLIENT_STORAGE_APPLE";
#endif
#if defined(GL_APPLE_object_purgeable)
        case 0x85b3: return "GL_BUFFER_OBJECT_APPLE";
#endif
#if defined(GL_APPLE_vertex_array_range)
        case 0x85b4: return "GL_STORAGE_CLIENT_APPLE";
#endif
        case 0x85b5:
#if defined(GL_VERSION_3_0)
                    return "GL_VERTEX_ARRAY_BINDING";
#endif
#if defined(GL_APPLE_vertex_array_object)
                    return "GL_VERTEX_ARRAY_BINDING_APPLE";
#endif
            break;
#if defined(GL_APPLE_texture_range)
        case 0x85b7: return "GL_TEXTURE_RANGE_LENGTH_APPLE";
        case 0x85b8: return "GL_TEXTURE_RANGE_POINTER_APPLE";
#endif
#if defined(GL_APPLE_ycbcr_422)
        case 0x85b9: return "GL_YCBCR_422_APPLE";
#endif
        case 0x85ba:
#if defined(GL_APPLE_rgb_422)
                    return "GL_UNSIGNED_SHORT_8_8_APPLE";
#endif
#if defined(GL_MESA_ycbcr_texture)
                    return "GL_UNSIGNED_SHORT_8_8_MESA";
#endif
            break;
        case 0x85bb:
#if defined(GL_APPLE_rgb_422)
                    return "GL_UNSIGNED_SHORT_8_8_REV_APPLE";
#endif
#if defined(GL_MESA_ycbcr_texture)
                    return "GL_UNSIGNED_SHORT_8_8_REV_MESA";
#endif
            break;
#if defined(GL_APPLE_texture_range)
        case 0x85bc: return "GL_TEXTURE_STORAGE_HINT_APPLE";
        case 0x85bd: return "GL_STORAGE_PRIVATE_APPLE";
        case 0x85be: return "GL_STORAGE_CACHED_APPLE";
        case 0x85bf: return "GL_STORAGE_SHARED_APPLE";
#endif
#if defined(GL_SUN_triangle_list)
        case 0x85c0: return "GL_REPLACEMENT_CODE_ARRAY_SUN";
        case 0x85c1: return "GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN";
        case 0x85c2: return "GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN";
        case 0x85c3: return "GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN";
        case 0x85c4: return "GL_R1UI_V3F_SUN";
        case 0x85c5: return "GL_R1UI_C4UB_V3F_SUN";
        case 0x85c6: return "GL_R1UI_C3F_V3F_SUN";
        case 0x85c7: return "GL_R1UI_N3F_V3F_SUN";
        case 0x85c8: return "GL_R1UI_C4F_N3F_V3F_SUN";
        case 0x85c9: return "GL_R1UI_T2F_V3F_SUN";
        case 0x85ca: return "GL_R1UI_T2F_N3F_V3F_SUN";
        case 0x85cb: return "GL_R1UI_T2F_C4F_N3F_V3F_SUN";
#endif
#if defined(GL_SUN_slice_accum)
        case 0x85cc: return "GL_SLICE_ACCUM_SUN";
#endif
#if defined(GL_SUN_mesh_array)
        case 0x8614: return "GL_QUAD_MESH_SUN";
        case 0x8615: return "GL_TRIANGLE_MESH_SUN";
#endif
        case 0x8620:
#if defined(GL_ARB_vertex_program)
                    return "GL_VERTEX_PROGRAM_ARB";
#endif
#if defined(GL_NV_vertex_program)
                    return "GL_VERTEX_PROGRAM_NV";
#endif
            break;
#if defined(GL_NV_vertex_program)
        case 0x8621: return "GL_VERTEX_STATE_PROGRAM_NV";
#endif
        case 0x8622:
#if defined(GL_VERSION_2_0)
                    return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
#endif
#if defined(GL_ARB_vertex_program)
                    return "GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB";
#endif
            break;
        case 0x8623:
#if defined(GL_NV_vertex_program)
                    return "GL_ATTRIB_ARRAY_SIZE_NV";
#endif
#if defined(GL_VERSION_2_0)
                    return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
#endif
#if defined(GL_ARB_vertex_program)
                    return "GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB";
#endif
            break;
        case 0x8624:
#if defined(GL_NV_vertex_program)
                    return "GL_ATTRIB_ARRAY_STRIDE_NV";
#endif
#if defined(GL_VERSION_2_0)
                    return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
#endif
#if defined(GL_ARB_vertex_program)
                    return "GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB";
#endif
            break;
        case 0x8625:
#if defined(GL_NV_vertex_program)
                    return "GL_ATTRIB_ARRAY_TYPE_NV";
#endif
#if defined(GL_VERSION_2_0)
                    return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
#endif
#if defined(GL_ARB_vertex_program)
                    return "GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB";
#endif
            break;
        case 0x8626:
#if defined(GL_NV_vertex_program)
                    return "GL_CURRENT_ATTRIB_NV";
#endif
#if defined(GL_VERSION_2_0)
                    return "GL_CURRENT_VERTEX_ATTRIB";
#endif
#if defined(GL_ARB_vertex_program)
                    return "GL_CURRENT_VERTEX_ATTRIB_ARB";
#endif
            break;
        case 0x8627:
#if defined(GL_ARB_fragment_program)
                    return "GL_PROGRAM_LENGTH_ARB";
#endif
#if defined(GL_NV_vertex_program)
                    return "GL_PROGRAM_LENGTH_NV";
#endif
            break;
        case 0x8628:
#if defined(GL_ARB_fragment_program)
                    return "GL_PROGRAM_STRING_ARB";
#endif
#if defined(GL_NV_vertex_program)
                    return "GL_PROGRAM_STRING_NV";
#endif
            break;
#if defined(GL_NV_vertex_program)
        case 0x8629: return "GL_MODELVIEW_PROJECTION_NV";
        case 0x862a: return "GL_IDENTITY_NV";
        case 0x862b: return "GL_INVERSE_NV";
        case 0x862c: return "GL_TRANSPOSE_NV";
        case 0x862d: return "GL_INVERSE_TRANSPOSE_NV";
#endif
        case 0x862e:
#if defined(GL_ARB_fragment_program)
                    return "GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB";
#endif
#if defined(GL_NV_vertex_program)
                    return "GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV";
#endif
            break;
        case 0x862f:
#if defined(GL_ARB_fragment_program)
                    return "GL_MAX_PROGRAM_MATRICES_ARB";
#endif
#if defined(GL_NV_vertex_program)
                    return "GL_MAX_TRACK_MATRICES_NV";
#endif
            break;
#if defined(GL_NV_vertex_program)
        case 0x8630: return "GL_MATRIX0_NV";
        case 0x8631: return "GL_MATRIX1_NV";
        case 0x8632: return "GL_MATRIX2_NV";
        case 0x8633: return "GL_MATRIX3_NV";
        case 0x8634: return "GL_MATRIX4_NV";
        case 0x8635: return "GL_MATRIX5_NV";
        case 0x8636: return "GL_MATRIX6_NV";
        case 0x8637: return "GL_MATRIX7_NV";
#endif
        case 0x8640:
#if defined(GL_ARB_fragment_program)
                    return "GL_CURRENT_MATRIX_STACK_DEPTH_ARB";
#endif
#if defined(GL_NV_vertex_program)
                    return "GL_CURRENT_MATRIX_STACK_DEPTH_NV";
#endif
            break;
        case 0x8641:
#if defined(GL_ARB_fragment_program)
                    return "GL_CURRENT_MATRIX_ARB";
#endif
#if defined(GL_NV_vertex_program)
                    return "GL_CURRENT_MATRIX_NV";
#endif
            break;
        case 0x8642:
#if defined(GL_VERSION_3_2)
                    return "GL_PROGRAM_POINT_SIZE";
#endif
#if defined(GL_ARB_geometry_shader4)
                    return "GL_PROGRAM_POINT_SIZE_ARB";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_PROGRAM_POINT_SIZE_EXT";
#endif
#if defined(GL_VERSION_2_0)
                    return "GL_VERTEX_PROGRAM_POINT_SIZE";
#endif
#if defined(GL_ARB_vertex_program)
                    return "GL_VERTEX_PROGRAM_POINT_SIZE_ARB";
#endif
#if defined(GL_NV_vertex_program)
                    return "GL_VERTEX_PROGRAM_POINT_SIZE_NV";
#endif
            break;
        case 0x8643:
#if defined(GL_VERSION_2_0)
                    return "GL_VERTEX_PROGRAM_TWO_SIDE";
#endif
#if defined(GL_ARB_vertex_program)
                    return "GL_VERTEX_PROGRAM_TWO_SIDE_ARB";
#endif
#if defined(GL_NV_vertex_program)
                    return "GL_VERTEX_PROGRAM_TWO_SIDE_NV";
#endif
            break;
#if defined(GL_NV_vertex_program)
        case 0x8644: return "GL_PROGRAM_PARAMETER_NV";
#endif
        case 0x8645:
#if defined(GL_NV_vertex_program)
                    return "GL_ATTRIB_ARRAY_POINTER_NV";
#endif
#if defined(GL_VERSION_2_0)
                    return "GL_VERTEX_ATTRIB_ARRAY_POINTER";
#endif
#if defined(GL_ARB_vertex_program)
                    return "GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB";
#endif
            break;
#if defined(GL_NV_vertex_program)
        case 0x8646: return "GL_PROGRAM_TARGET_NV";
        case 0x8647: return "GL_PROGRAM_RESIDENT_NV";
        case 0x8648: return "GL_TRACK_MATRIX_NV";
        case 0x8649: return "GL_TRACK_MATRIX_TRANSFORM_NV";
        case 0x864a: return "GL_VERTEX_PROGRAM_BINDING_NV";
#endif
        case 0x864b:
#if defined(GL_ARB_fragment_program)
                    return "GL_PROGRAM_ERROR_POSITION_ARB";
#endif
#if defined(GL_NV_vertex_program)
                    return "GL_PROGRAM_ERROR_POSITION_NV";
#endif
            break;
#if defined(GL_NV_texture_shader)
        case 0x864c: return "GL_OFFSET_TEXTURE_RECTANGLE_NV";
        case 0x864d: return "GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV";
        case 0x864e: return "GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV";
#endif
        case 0x864f:
#if defined(GL_VERSION_3_2)
                    return "GL_DEPTH_CLAMP";
#endif
#if defined(GL_NV_depth_clamp)
                    return "GL_DEPTH_CLAMP_NV";
#endif
            break;
#if defined(GL_NV_vertex_program)
        case 0x8650: return "GL_VERTEX_ATTRIB_ARRAY0_NV";
        case 0x8651: return "GL_VERTEX_ATTRIB_ARRAY1_NV";
        case 0x8652: return "GL_VERTEX_ATTRIB_ARRAY2_NV";
        case 0x8653: return "GL_VERTEX_ATTRIB_ARRAY3_NV";
        case 0x8654: return "GL_VERTEX_ATTRIB_ARRAY4_NV";
        case 0x8655: return "GL_VERTEX_ATTRIB_ARRAY5_NV";
        case 0x8656: return "GL_VERTEX_ATTRIB_ARRAY6_NV";
        case 0x8657: return "GL_VERTEX_ATTRIB_ARRAY7_NV";
        case 0x8658: return "GL_VERTEX_ATTRIB_ARRAY8_NV";
        case 0x8659: return "GL_VERTEX_ATTRIB_ARRAY9_NV";
        case 0x865a: return "GL_VERTEX_ATTRIB_ARRAY10_NV";
        case 0x865b: return "GL_VERTEX_ATTRIB_ARRAY11_NV";
        case 0x865c: return "GL_VERTEX_ATTRIB_ARRAY12_NV";
        case 0x865d: return "GL_VERTEX_ATTRIB_ARRAY13_NV";
        case 0x865e: return "GL_VERTEX_ATTRIB_ARRAY14_NV";
        case 0x865f: return "GL_VERTEX_ATTRIB_ARRAY15_NV";
        case 0x8660: return "GL_MAP1_VERTEX_ATTRIB0_4_NV";
        case 0x8661: return "GL_MAP1_VERTEX_ATTRIB1_4_NV";
        case 0x8662: return "GL_MAP1_VERTEX_ATTRIB2_4_NV";
        case 0x8663: return "GL_MAP1_VERTEX_ATTRIB3_4_NV";
        case 0x8664: return "GL_MAP1_VERTEX_ATTRIB4_4_NV";
        case 0x8665: return "GL_MAP1_VERTEX_ATTRIB5_4_NV";
        case 0x8666: return "GL_MAP1_VERTEX_ATTRIB6_4_NV";
        case 0x8667: return "GL_MAP1_VERTEX_ATTRIB7_4_NV";
        case 0x8668: return "GL_MAP1_VERTEX_ATTRIB8_4_NV";
        case 0x8669: return "GL_MAP1_VERTEX_ATTRIB9_4_NV";
        case 0x866a: return "GL_MAP1_VERTEX_ATTRIB10_4_NV";
        case 0x866b: return "GL_MAP1_VERTEX_ATTRIB11_4_NV";
        case 0x866c: return "GL_MAP1_VERTEX_ATTRIB12_4_NV";
        case 0x866d: return "GL_MAP1_VERTEX_ATTRIB13_4_NV";
        case 0x866e: return "GL_MAP1_VERTEX_ATTRIB14_4_NV";
        case 0x866f: return "GL_MAP1_VERTEX_ATTRIB15_4_NV";
        case 0x8670: return "GL_MAP2_VERTEX_ATTRIB0_4_NV";
        case 0x8671: return "GL_MAP2_VERTEX_ATTRIB1_4_NV";
        case 0x8672: return "GL_MAP2_VERTEX_ATTRIB2_4_NV";
        case 0x8673: return "GL_MAP2_VERTEX_ATTRIB3_4_NV";
        case 0x8674: return "GL_MAP2_VERTEX_ATTRIB4_4_NV";
        case 0x8675: return "GL_MAP2_VERTEX_ATTRIB5_4_NV";
        case 0x8676: return "GL_MAP2_VERTEX_ATTRIB6_4_NV";
#endif
        case 0x8677:
#if defined(GL_NV_vertex_program)
                    return "GL_MAP2_VERTEX_ATTRIB7_4_NV";
#endif
#if defined(GL_ARB_fragment_program)
                    return "GL_PROGRAM_BINDING_ARB";
#endif
            break;
#if defined(GL_NV_vertex_program)
        case 0x8678: return "GL_MAP2_VERTEX_ATTRIB8_4_NV";
        case 0x8679: return "GL_MAP2_VERTEX_ATTRIB9_4_NV";
        case 0x867a: return "GL_MAP2_VERTEX_ATTRIB10_4_NV";
        case 0x867b: return "GL_MAP2_VERTEX_ATTRIB11_4_NV";
        case 0x867c: return "GL_MAP2_VERTEX_ATTRIB12_4_NV";
        case 0x867d: return "GL_MAP2_VERTEX_ATTRIB13_4_NV";
        case 0x867e: return "GL_MAP2_VERTEX_ATTRIB14_4_NV";
        case 0x867f: return "GL_MAP2_VERTEX_ATTRIB15_4_NV";
#endif
        case 0x86a0:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE_COMPRESSED_IMAGE_SIZE";
#endif
#if defined(GL_ARB_texture_compression)
                    return "GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB";
#endif
            break;
        case 0x86a1:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_TEXTURE_COMPRESSED";
#endif
#if defined(GL_ARB_texture_compression)
                    return "GL_TEXTURE_COMPRESSED_ARB";
#endif
            break;
        case 0x86a2:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_NUM_COMPRESSED_TEXTURE_FORMATS";
#endif
#if defined(GL_ARB_texture_compression)
                    return "GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB";
#endif
            break;
        case 0x86a3:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_COMPRESSED_TEXTURE_FORMATS";
#endif
#if defined(GL_ARB_texture_compression)
                    return "GL_COMPRESSED_TEXTURE_FORMATS_ARB";
#endif
            break;
#if defined(GL_ARB_vertex_blend)
        case 0x86a4: return "GL_MAX_VERTEX_UNITS_ARB";
        case 0x86a5: return "GL_ACTIVE_VERTEX_UNITS_ARB";
        case 0x86a6: return "GL_WEIGHT_SUM_UNITY_ARB";
        case 0x86a7: return "GL_VERTEX_BLEND_ARB";
        case 0x86a8: return "GL_CURRENT_WEIGHT_ARB";
        case 0x86a9: return "GL_WEIGHT_ARRAY_TYPE_ARB";
        case 0x86aa: return "GL_WEIGHT_ARRAY_STRIDE_ARB";
        case 0x86ab: return "GL_WEIGHT_ARRAY_SIZE_ARB";
        case 0x86ac: return "GL_WEIGHT_ARRAY_POINTER_ARB";
        case 0x86ad: return "GL_WEIGHT_ARRAY_ARB";
#endif
        case 0x86ae:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_DOT3_RGB";
#endif
#if defined(GL_ARB_texture_env_dot3)
                    return "GL_DOT3_RGB_ARB";
#endif
            break;
        case 0x86af:
#if defined(__gl_h_) || defined(GL_VERSION_1_3)
                    return "GL_DOT3_RGBA";
#endif
#if defined(GL_ARB_texture_env_dot3)
                    return "GL_DOT3_RGBA_ARB";
#endif
            break;
#if defined(GL_3DFX_texture_compression_FXT1)
        case 0x86b0: return "GL_COMPRESSED_RGB_FXT1_3DFX";
        case 0x86b1: return "GL_COMPRESSED_RGBA_FXT1_3DFX";
#endif
#if defined(GL_3DFX_multisample)
        case 0x86b2: return "GL_MULTISAMPLE_3DFX";
        case 0x86b3: return "GL_SAMPLE_BUFFERS_3DFX";
        case 0x86b4: return "GL_SAMPLES_3DFX";
#endif
#if defined(GL_NV_evaluators)
        case 0x86c0: return "GL_EVAL_2D_NV";
        case 0x86c1: return "GL_EVAL_TRIANGULAR_2D_NV";
        case 0x86c2: return "GL_MAP_TESSELLATION_NV";
        case 0x86c3: return "GL_MAP_ATTRIB_U_ORDER_NV";
        case 0x86c4: return "GL_MAP_ATTRIB_V_ORDER_NV";
        case 0x86c5: return "GL_EVAL_FRACTIONAL_TESSELLATION_NV";
        case 0x86c6: return "GL_EVAL_VERTEX_ATTRIB0_NV";
        case 0x86c7: return "GL_EVAL_VERTEX_ATTRIB1_NV";
        case 0x86c8: return "GL_EVAL_VERTEX_ATTRIB2_NV";
        case 0x86c9: return "GL_EVAL_VERTEX_ATTRIB3_NV";
        case 0x86ca: return "GL_EVAL_VERTEX_ATTRIB4_NV";
        case 0x86cb: return "GL_EVAL_VERTEX_ATTRIB5_NV";
        case 0x86cc: return "GL_EVAL_VERTEX_ATTRIB6_NV";
        case 0x86cd: return "GL_EVAL_VERTEX_ATTRIB7_NV";
        case 0x86ce: return "GL_EVAL_VERTEX_ATTRIB8_NV";
        case 0x86cf: return "GL_EVAL_VERTEX_ATTRIB9_NV";
        case 0x86d0: return "GL_EVAL_VERTEX_ATTRIB10_NV";
        case 0x86d1: return "GL_EVAL_VERTEX_ATTRIB11_NV";
        case 0x86d2: return "GL_EVAL_VERTEX_ATTRIB12_NV";
        case 0x86d3: return "GL_EVAL_VERTEX_ATTRIB13_NV";
        case 0x86d4: return "GL_EVAL_VERTEX_ATTRIB14_NV";
        case 0x86d5: return "GL_EVAL_VERTEX_ATTRIB15_NV";
        case 0x86d6: return "GL_MAX_MAP_TESSELLATION_NV";
        case 0x86d7: return "GL_MAX_RATIONAL_EVAL_ORDER_NV";
#endif
#if defined(GL_NV_tessellation_program5)
        case 0x86d8: return "GL_MAX_PROGRAM_PATCH_ATTRIBS_NV";
#endif
#if defined(GL_NV_texture_shader)
        case 0x86d9: return "GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV";
        case 0x86da: return "GL_UNSIGNED_INT_S8_S8_8_8_NV";
        case 0x86db: return "GL_UNSIGNED_INT_8_8_S8_S8_REV_NV";
        case 0x86dc: return "GL_DSDT_MAG_INTENSITY_NV";
        case 0x86dd: return "GL_SHADER_CONSISTENT_NV";
        case 0x86de: return "GL_TEXTURE_SHADER_NV";
        case 0x86df: return "GL_SHADER_OPERATION_NV";
        case 0x86e0: return "GL_CULL_MODES_NV";
#endif
        case 0x86e1:
#if defined(GL_NV_texture_shader)
                    return "GL_OFFSET_TEXTURE_2D_MATRIX_NV";
#endif
#if defined(GL_NV_texture_shader)
                    return "GL_OFFSET_TEXTURE_MATRIX_NV";
#endif
            break;
        case 0x86e2:
#if defined(GL_NV_texture_shader)
                    return "GL_OFFSET_TEXTURE_2D_SCALE_NV";
#endif
#if defined(GL_NV_texture_shader)
                    return "GL_OFFSET_TEXTURE_SCALE_NV";
#endif
            break;
        case 0x86e3:
#if defined(GL_NV_texture_shader)
                    return "GL_OFFSET_TEXTURE_2D_BIAS_NV";
#endif
#if defined(GL_NV_texture_shader)
                    return "GL_OFFSET_TEXTURE_BIAS_NV";
#endif
            break;
#if defined(GL_NV_texture_shader)
        case 0x86e4: return "GL_PREVIOUS_TEXTURE_INPUT_NV";
        case 0x86e5: return "GL_CONST_EYE_NV";
        case 0x86e6: return "GL_PASS_THROUGH_NV";
        case 0x86e7: return "GL_CULL_FRAGMENT_NV";
        case 0x86e8: return "GL_OFFSET_TEXTURE_2D_NV";
        case 0x86e9: return "GL_DEPENDENT_AR_TEXTURE_2D_NV";
        case 0x86ea: return "GL_DEPENDENT_GB_TEXTURE_2D_NV";
#endif
#if defined(GL_NV_vdpau_interop)
        case 0x86eb: return "GL_SURFACE_STATE_NV";
#endif
#if defined(GL_NV_texture_shader)
        case 0x86ec: return "GL_DOT_PRODUCT_NV";
        case 0x86ed: return "GL_DOT_PRODUCT_DEPTH_REPLACE_NV";
        case 0x86ee: return "GL_DOT_PRODUCT_TEXTURE_2D_NV";
#endif
#if defined(GL_NV_texture_shader2)
        case 0x86ef: return "GL_DOT_PRODUCT_TEXTURE_3D_NV";
#endif
#if defined(GL_NV_texture_shader)
        case 0x86f0: return "GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV";
        case 0x86f1: return "GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV";
        case 0x86f2: return "GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV";
        case 0x86f3: return "GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV";
        case 0x86f4: return "GL_HILO_NV";
        case 0x86f5: return "GL_DSDT_NV";
        case 0x86f6: return "GL_DSDT_MAG_NV";
        case 0x86f7: return "GL_DSDT_MAG_VIB_NV";
        case 0x86f8: return "GL_HILO16_NV";
        case 0x86f9: return "GL_SIGNED_HILO_NV";
        case 0x86fa: return "GL_SIGNED_HILO16_NV";
        case 0x86fb: return "GL_SIGNED_RGBA_NV";
        case 0x86fc: return "GL_SIGNED_RGBA8_NV";
#endif
#if defined(GL_NV_vdpau_interop)
        case 0x86fd: return "GL_SURFACE_REGISTERED_NV";
#endif
#if defined(GL_NV_texture_shader)
        case 0x86fe: return "GL_SIGNED_RGB_NV";
        case 0x86ff: return "GL_SIGNED_RGB8_NV";
#endif
#if defined(GL_NV_vdpau_interop)
        case 0x8700: return "GL_SURFACE_MAPPED_NV";
#endif
#if defined(GL_NV_texture_shader)
        case 0x8701: return "GL_SIGNED_LUMINANCE_NV";
        case 0x8702: return "GL_SIGNED_LUMINANCE8_NV";
        case 0x8703: return "GL_SIGNED_LUMINANCE_ALPHA_NV";
        case 0x8704: return "GL_SIGNED_LUMINANCE8_ALPHA8_NV";
        case 0x8705: return "GL_SIGNED_ALPHA_NV";
        case 0x8706: return "GL_SIGNED_ALPHA8_NV";
        case 0x8707: return "GL_SIGNED_INTENSITY_NV";
        case 0x8708: return "GL_SIGNED_INTENSITY8_NV";
        case 0x8709: return "GL_DSDT8_NV";
        case 0x870a: return "GL_DSDT8_MAG8_NV";
        case 0x870b: return "GL_DSDT8_MAG8_INTENSITY8_NV";
        case 0x870c: return "GL_SIGNED_RGB_UNSIGNED_ALPHA_NV";
        case 0x870d: return "GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV";
        case 0x870e: return "GL_HI_SCALE_NV";
        case 0x870f: return "GL_LO_SCALE_NV";
        case 0x8710: return "GL_DS_SCALE_NV";
        case 0x8711: return "GL_DT_SCALE_NV";
        case 0x8712: return "GL_MAGNITUDE_SCALE_NV";
        case 0x8713: return "GL_VIBRANCE_SCALE_NV";
        case 0x8714: return "GL_HI_BIAS_NV";
        case 0x8715: return "GL_LO_BIAS_NV";
        case 0x8716: return "GL_DS_BIAS_NV";
        case 0x8717: return "GL_DT_BIAS_NV";
        case 0x8718: return "GL_MAGNITUDE_BIAS_NV";
        case 0x8719: return "GL_VIBRANCE_BIAS_NV";
        case 0x871a: return "GL_TEXTURE_BORDER_VALUES_NV";
        case 0x871b: return "GL_TEXTURE_HI_SIZE_NV";
        case 0x871c: return "GL_TEXTURE_LO_SIZE_NV";
        case 0x871d: return "GL_TEXTURE_DS_SIZE_NV";
        case 0x871e: return "GL_TEXTURE_DT_SIZE_NV";
        case 0x871f: return "GL_TEXTURE_MAG_SIZE_NV";
#endif
#if defined(GL_ARB_vertex_blend)
        case 0x8722: return "GL_MODELVIEW2_ARB";
        case 0x8723: return "GL_MODELVIEW3_ARB";
        case 0x8724: return "GL_MODELVIEW4_ARB";
        case 0x8725: return "GL_MODELVIEW5_ARB";
        case 0x8726: return "GL_MODELVIEW6_ARB";
        case 0x8727: return "GL_MODELVIEW7_ARB";
        case 0x8728: return "GL_MODELVIEW8_ARB";
        case 0x8729: return "GL_MODELVIEW9_ARB";
        case 0x872a: return "GL_MODELVIEW10_ARB";
        case 0x872b: return "GL_MODELVIEW11_ARB";
        case 0x872c: return "GL_MODELVIEW12_ARB";
        case 0x872d: return "GL_MODELVIEW13_ARB";
        case 0x872e: return "GL_MODELVIEW14_ARB";
        case 0x872f: return "GL_MODELVIEW15_ARB";
        case 0x8730: return "GL_MODELVIEW16_ARB";
        case 0x8731: return "GL_MODELVIEW17_ARB";
        case 0x8732: return "GL_MODELVIEW18_ARB";
        case 0x8733: return "GL_MODELVIEW19_ARB";
        case 0x8734: return "GL_MODELVIEW20_ARB";
        case 0x8735: return "GL_MODELVIEW21_ARB";
        case 0x8736: return "GL_MODELVIEW22_ARB";
        case 0x8737: return "GL_MODELVIEW23_ARB";
        case 0x8738: return "GL_MODELVIEW24_ARB";
        case 0x8739: return "GL_MODELVIEW25_ARB";
        case 0x873a: return "GL_MODELVIEW26_ARB";
        case 0x873b: return "GL_MODELVIEW27_ARB";
        case 0x873c: return "GL_MODELVIEW28_ARB";
        case 0x873d: return "GL_MODELVIEW29_ARB";
        case 0x873e: return "GL_MODELVIEW30_ARB";
        case 0x873f: return "GL_MODELVIEW31_ARB";
#endif
#if defined(GL_EXT_texture_env_dot3)
        case 0x8740: return "GL_DOT3_RGB_EXT";
#endif
        case 0x8741:
#if defined(GL_EXT_texture_env_dot3)
                    return "GL_DOT3_RGBA_EXT";
#endif
#if defined(GL_VERSION_4_1)
                    return "GL_PROGRAM_BINARY_LENGTH";
#endif
            break;
        case 0x8742:
#if defined(GL_ATI_texture_mirror_once)
                    return "GL_MIRROR_CLAMP_ATI";
#endif
#if defined(GL_EXT_texture_mirror_clamp)
                    return "GL_MIRROR_CLAMP_EXT";
#endif
            break;
        case 0x8743:
#if defined(GL_VERSION_4_4)
                    return "GL_MIRROR_CLAMP_TO_EDGE";
#endif
#if defined(GL_ATI_texture_mirror_once)
                    return "GL_MIRROR_CLAMP_TO_EDGE_ATI";
#endif
#if defined(GL_EXT_texture_mirror_clamp)
                    return "GL_MIRROR_CLAMP_TO_EDGE_EXT";
#endif
            break;
#if defined(GL_ATI_texture_env_combine3)
        case 0x8744: return "GL_MODULATE_ADD_ATI";
        case 0x8745: return "GL_MODULATE_SIGNED_ADD_ATI";
        case 0x8746: return "GL_MODULATE_SUBTRACT_ATI";
#endif
#if defined(GL_AMD_stencil_operation_extended)
        case 0x874a: return "GL_SET_AMD";
        case 0x874b: return "GL_REPLACE_VALUE_AMD";
        case 0x874c: return "GL_STENCIL_OP_VALUE_AMD";
        case 0x874d: return "GL_STENCIL_BACK_OP_VALUE_AMD";
#endif
#if defined(GL_VERSION_4_3)
        case 0x874e: return "GL_VERTEX_ATTRIB_ARRAY_LONG";
#endif
#if defined(GL_AMD_occlusion_query_event)
        case 0x874f: return "GL_OCCLUSION_QUERY_EVENT_MASK_AMD";
#endif
#if defined(GL_MESA_packed_depth_stencil)
        case 0x8750: return "GL_DEPTH_STENCIL_MESA";
        case 0x8751: return "GL_UNSIGNED_INT_24_8_MESA";
        case 0x8752: return "GL_UNSIGNED_INT_8_24_REV_MESA";
        case 0x8753: return "GL_UNSIGNED_SHORT_15_1_MESA";
        case 0x8754: return "GL_UNSIGNED_SHORT_1_15_REV_MESA";
#endif
#if defined(GL_MESA_ycbcr_texture)
        case 0x8757: return "GL_YCBCR_MESA";
#endif
#if defined(GL_MESA_pack_invert)
        case 0x8758: return "GL_PACK_INVERT_MESA";
#endif
#if defined(GL_MESAX_texture_stack)
        case 0x8759: return "GL_TEXTURE_1D_STACK_MESAX";
        case 0x875a: return "GL_TEXTURE_2D_STACK_MESAX";
        case 0x875b: return "GL_PROXY_TEXTURE_1D_STACK_MESAX";
        case 0x875c: return "GL_PROXY_TEXTURE_2D_STACK_MESAX";
        case 0x875d: return "GL_TEXTURE_1D_STACK_BINDING_MESAX";
        case 0x875e: return "GL_TEXTURE_2D_STACK_BINDING_MESAX";
#endif
#if defined(GL_MESA_program_binary_formats)
        case 0x875f: return "GL_PROGRAM_BINARY_FORMAT_MESA";
#endif
#if defined(GL_ATI_vertex_array_object)
        case 0x8760: return "GL_STATIC_ATI";
        case 0x8761: return "GL_DYNAMIC_ATI";
        case 0x8762: return "GL_PRESERVE_ATI";
        case 0x8763: return "GL_DISCARD_ATI";
#endif
        case 0x8764:
#if defined(GL_VERSION_1_5)
                    return "GL_BUFFER_SIZE";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_BUFFER_SIZE_ARB";
#endif
#if defined(GL_ATI_vertex_array_object)
                    return "GL_OBJECT_BUFFER_SIZE_ATI";
#endif
            break;
        case 0x8765:
#if defined(GL_VERSION_1_5)
                    return "GL_BUFFER_USAGE";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_BUFFER_USAGE_ARB";
#endif
#if defined(GL_ATI_vertex_array_object)
                    return "GL_OBJECT_BUFFER_USAGE_ATI";
#endif
            break;
#if defined(GL_ATI_vertex_array_object)
        case 0x8766: return "GL_ARRAY_OBJECT_BUFFER_ATI";
        case 0x8767: return "GL_ARRAY_OBJECT_OFFSET_ATI";
#endif
#if defined(GL_ATI_element_array)
        case 0x8768: return "GL_ELEMENT_ARRAY_ATI";
        case 0x8769: return "GL_ELEMENT_ARRAY_TYPE_ATI";
        case 0x876a: return "GL_ELEMENT_ARRAY_POINTER_ATI";
#endif
#if defined(GL_ATI_vertex_streams)
        case 0x876b: return "GL_MAX_VERTEX_STREAMS_ATI";
        case 0x876c: return "GL_VERTEX_STREAM0_ATI";
        case 0x876d: return "GL_VERTEX_STREAM1_ATI";
        case 0x876e: return "GL_VERTEX_STREAM2_ATI";
        case 0x876f: return "GL_VERTEX_STREAM3_ATI";
        case 0x8770: return "GL_VERTEX_STREAM4_ATI";
        case 0x8771: return "GL_VERTEX_STREAM5_ATI";
        case 0x8772: return "GL_VERTEX_STREAM6_ATI";
        case 0x8773: return "GL_VERTEX_STREAM7_ATI";
        case 0x8774: return "GL_VERTEX_SOURCE_ATI";
#endif
#if defined(GL_ATI_envmap_bumpmap)
        case 0x8775: return "GL_BUMP_ROT_MATRIX_ATI";
        case 0x8776: return "GL_BUMP_ROT_MATRIX_SIZE_ATI";
        case 0x8777: return "GL_BUMP_NUM_TEX_UNITS_ATI";
        case 0x8778: return "GL_BUMP_TEX_UNITS_ATI";
        case 0x8779: return "GL_DUDV_ATI";
        case 0x877a: return "GL_DU8DV8_ATI";
        case 0x877b: return "GL_BUMP_ENVMAP_ATI";
        case 0x877c: return "GL_BUMP_TARGET_ATI";
#endif
#if defined(GL_EXT_vertex_shader)
        case 0x8780: return "GL_VERTEX_SHADER_EXT";
        case 0x8781: return "GL_VERTEX_SHADER_BINDING_EXT";
        case 0x8782: return "GL_OP_INDEX_EXT";
        case 0x8783: return "GL_OP_NEGATE_EXT";
        case 0x8784: return "GL_OP_DOT3_EXT";
        case 0x8785: return "GL_OP_DOT4_EXT";
        case 0x8786: return "GL_OP_MUL_EXT";
        case 0x8787: return "GL_OP_ADD_EXT";
        case 0x8788: return "GL_OP_MADD_EXT";
        case 0x8789: return "GL_OP_FRAC_EXT";
        case 0x878a: return "GL_OP_MAX_EXT";
        case 0x878b: return "GL_OP_MIN_EXT";
        case 0x878c: return "GL_OP_SET_GE_EXT";
        case 0x878d: return "GL_OP_SET_LT_EXT";
        case 0x878e: return "GL_OP_CLAMP_EXT";
        case 0x878f: return "GL_OP_FLOOR_EXT";
        case 0x8790: return "GL_OP_ROUND_EXT";
        case 0x8791: return "GL_OP_EXP_BASE_2_EXT";
        case 0x8792: return "GL_OP_LOG_BASE_2_EXT";
        case 0x8793: return "GL_OP_POWER_EXT";
        case 0x8794: return "GL_OP_RECIP_EXT";
        case 0x8795: return "GL_OP_RECIP_SQRT_EXT";
        case 0x8796: return "GL_OP_SUB_EXT";
        case 0x8797: return "GL_OP_CROSS_PRODUCT_EXT";
        case 0x8798: return "GL_OP_MULTIPLY_MATRIX_EXT";
        case 0x8799: return "GL_OP_MOV_EXT";
        case 0x879a: return "GL_OUTPUT_VERTEX_EXT";
        case 0x879b: return "GL_OUTPUT_COLOR0_EXT";
        case 0x879c: return "GL_OUTPUT_COLOR1_EXT";
        case 0x879d: return "GL_OUTPUT_TEXTURE_COORD0_EXT";
        case 0x879e: return "GL_OUTPUT_TEXTURE_COORD1_EXT";
        case 0x879f: return "GL_OUTPUT_TEXTURE_COORD2_EXT";
        case 0x87a0: return "GL_OUTPUT_TEXTURE_COORD3_EXT";
        case 0x87a1: return "GL_OUTPUT_TEXTURE_COORD4_EXT";
        case 0x87a2: return "GL_OUTPUT_TEXTURE_COORD5_EXT";
        case 0x87a3: return "GL_OUTPUT_TEXTURE_COORD6_EXT";
        case 0x87a4: return "GL_OUTPUT_TEXTURE_COORD7_EXT";
        case 0x87a5: return "GL_OUTPUT_TEXTURE_COORD8_EXT";
        case 0x87a6: return "GL_OUTPUT_TEXTURE_COORD9_EXT";
        case 0x87a7: return "GL_OUTPUT_TEXTURE_COORD10_EXT";
        case 0x87a8: return "GL_OUTPUT_TEXTURE_COORD11_EXT";
        case 0x87a9: return "GL_OUTPUT_TEXTURE_COORD12_EXT";
        case 0x87aa: return "GL_OUTPUT_TEXTURE_COORD13_EXT";
        case 0x87ab: return "GL_OUTPUT_TEXTURE_COORD14_EXT";
        case 0x87ac: return "GL_OUTPUT_TEXTURE_COORD15_EXT";
        case 0x87ad: return "GL_OUTPUT_TEXTURE_COORD16_EXT";
        case 0x87ae: return "GL_OUTPUT_TEXTURE_COORD17_EXT";
        case 0x87af: return "GL_OUTPUT_TEXTURE_COORD18_EXT";
        case 0x87b0: return "GL_OUTPUT_TEXTURE_COORD19_EXT";
        case 0x87b1: return "GL_OUTPUT_TEXTURE_COORD20_EXT";
        case 0x87b2: return "GL_OUTPUT_TEXTURE_COORD21_EXT";
        case 0x87b3: return "GL_OUTPUT_TEXTURE_COORD22_EXT";
        case 0x87b4: return "GL_OUTPUT_TEXTURE_COORD23_EXT";
        case 0x87b5: return "GL_OUTPUT_TEXTURE_COORD24_EXT";
        case 0x87b6: return "GL_OUTPUT_TEXTURE_COORD25_EXT";
        case 0x87b7: return "GL_OUTPUT_TEXTURE_COORD26_EXT";
        case 0x87b8: return "GL_OUTPUT_TEXTURE_COORD27_EXT";
        case 0x87b9: return "GL_OUTPUT_TEXTURE_COORD28_EXT";
        case 0x87ba: return "GL_OUTPUT_TEXTURE_COORD29_EXT";
        case 0x87bb: return "GL_OUTPUT_TEXTURE_COORD30_EXT";
        case 0x87bc: return "GL_OUTPUT_TEXTURE_COORD31_EXT";
        case 0x87bd: return "GL_OUTPUT_FOG_EXT";
        case 0x87be: return "GL_SCALAR_EXT";
        case 0x87bf: return "GL_VECTOR_EXT";
        case 0x87c0: return "GL_MATRIX_EXT";
        case 0x87c1: return "GL_VARIANT_EXT";
        case 0x87c2: return "GL_INVARIANT_EXT";
        case 0x87c3: return "GL_LOCAL_CONSTANT_EXT";
        case 0x87c4: return "GL_LOCAL_EXT";
        case 0x87c5: return "GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT";
        case 0x87c6: return "GL_MAX_VERTEX_SHADER_VARIANTS_EXT";
        case 0x87c7: return "GL_MAX_VERTEX_SHADER_INVARIANTS_EXT";
        case 0x87c8: return "GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT";
        case 0x87c9: return "GL_MAX_VERTEX_SHADER_LOCALS_EXT";
        case 0x87ca: return "GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT";
        case 0x87cb: return "GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT";
        case 0x87cc: return "GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT";
        case 0x87cd: return "GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT";
        case 0x87ce: return "GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT";
        case 0x87cf: return "GL_VERTEX_SHADER_INSTRUCTIONS_EXT";
        case 0x87d0: return "GL_VERTEX_SHADER_VARIANTS_EXT";
        case 0x87d1: return "GL_VERTEX_SHADER_INVARIANTS_EXT";
        case 0x87d2: return "GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT";
        case 0x87d3: return "GL_VERTEX_SHADER_LOCALS_EXT";
        case 0x87d4: return "GL_VERTEX_SHADER_OPTIMIZED_EXT";
        case 0x87d5: return "GL_X_EXT";
        case 0x87d6: return "GL_Y_EXT";
        case 0x87d7: return "GL_Z_EXT";
        case 0x87d8: return "GL_W_EXT";
        case 0x87d9: return "GL_NEGATIVE_X_EXT";
        case 0x87da: return "GL_NEGATIVE_Y_EXT";
        case 0x87db: return "GL_NEGATIVE_Z_EXT";
        case 0x87dc: return "GL_NEGATIVE_W_EXT";
        case 0x87dd: return "GL_ZERO_EXT";
        case 0x87de: return "GL_ONE_EXT";
        case 0x87df: return "GL_NEGATIVE_ONE_EXT";
        case 0x87e0: return "GL_NORMALIZED_RANGE_EXT";
        case 0x87e1: return "GL_FULL_RANGE_EXT";
        case 0x87e2: return "GL_CURRENT_VERTEX_EXT";
        case 0x87e3: return "GL_MVP_MATRIX_EXT";
        case 0x87e4: return "GL_VARIANT_VALUE_EXT";
        case 0x87e5: return "GL_VARIANT_DATATYPE_EXT";
        case 0x87e6: return "GL_VARIANT_ARRAY_STRIDE_EXT";
        case 0x87e7: return "GL_VARIANT_ARRAY_TYPE_EXT";
        case 0x87e8: return "GL_VARIANT_ARRAY_EXT";
        case 0x87e9: return "GL_VARIANT_ARRAY_POINTER_EXT";
        case 0x87ea: return "GL_INVARIANT_VALUE_EXT";
        case 0x87eb: return "GL_INVARIANT_DATATYPE_EXT";
        case 0x87ec: return "GL_LOCAL_CONSTANT_VALUE_EXT";
        case 0x87ed: return "GL_LOCAL_CONSTANT_DATATYPE_EXT";
#endif
#if defined(GL_ATI_pn_triangles)
        case 0x87f0: return "GL_PN_TRIANGLES_ATI";
        case 0x87f1: return "GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI";
        case 0x87f2: return "GL_PN_TRIANGLES_POINT_MODE_ATI";
        case 0x87f3: return "GL_PN_TRIANGLES_NORMAL_MODE_ATI";
        case 0x87f4: return "GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI";
        case 0x87f5: return "GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI";
        case 0x87f6: return "GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI";
        case 0x87f7: return "GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI";
        case 0x87f8: return "GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI";
#endif
#if defined(GL_ATI_meminfo)
        case 0x87fb: return "GL_VBO_FREE_MEMORY_ATI";
        case 0x87fc: return "GL_TEXTURE_FREE_MEMORY_ATI";
        case 0x87fd: return "GL_RENDERBUFFER_FREE_MEMORY_ATI";
#endif
#if defined(GL_VERSION_4_1)
        case 0x87fe: return "GL_NUM_PROGRAM_BINARY_FORMATS";
        case 0x87ff: return "GL_PROGRAM_BINARY_FORMATS";
#endif
        case 0x8800:
#if defined(GL_VERSION_2_0)
                    return "GL_STENCIL_BACK_FUNC";
#endif
#if defined(GL_ATI_separate_stencil)
                    return "GL_STENCIL_BACK_FUNC_ATI";
#endif
            break;
        case 0x8801:
#if defined(GL_VERSION_2_0)
                    return "GL_STENCIL_BACK_FAIL";
#endif
#if defined(GL_ATI_separate_stencil)
                    return "GL_STENCIL_BACK_FAIL_ATI";
#endif
            break;
        case 0x8802:
#if defined(GL_VERSION_2_0)
                    return "GL_STENCIL_BACK_PASS_DEPTH_FAIL";
#endif
#if defined(GL_ATI_separate_stencil)
                    return "GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI";
#endif
            break;
        case 0x8803:
#if defined(GL_VERSION_2_0)
                    return "GL_STENCIL_BACK_PASS_DEPTH_PASS";
#endif
#if defined(GL_ATI_separate_stencil)
                    return "GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI";
#endif
            break;
#if defined(GL_ARB_fragment_program)
        case 0x8804: return "GL_FRAGMENT_PROGRAM_ARB";
        case 0x8805: return "GL_PROGRAM_ALU_INSTRUCTIONS_ARB";
        case 0x8806: return "GL_PROGRAM_TEX_INSTRUCTIONS_ARB";
        case 0x8807: return "GL_PROGRAM_TEX_INDIRECTIONS_ARB";
        case 0x8808: return "GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB";
        case 0x8809: return "GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB";
        case 0x880a: return "GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB";
        case 0x880b: return "GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB";
        case 0x880c: return "GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB";
        case 0x880d: return "GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB";
        case 0x880e: return "GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB";
        case 0x880f: return "GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB";
        case 0x8810: return "GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB";
#endif
        case 0x8814:
#if defined(GL_VERSION_3_0)
                    return "GL_RGBA32F";
#endif
#if defined(GL_ARB_texture_float)
                    return "GL_RGBA32F_ARB";
#endif
#if defined(GL_APPLE_float_pixels)
                    return "GL_RGBA_FLOAT32_APPLE";
#endif
#if defined(GL_ATI_texture_float)
                    return "GL_RGBA_FLOAT32_ATI";
#endif
            break;
        case 0x8815:
#if defined(GL_VERSION_3_0)
                    return "GL_RGB32F";
#endif
#if defined(GL_ARB_texture_float)
                    return "GL_RGB32F_ARB";
#endif
#if defined(GL_APPLE_float_pixels)
                    return "GL_RGB_FLOAT32_APPLE";
#endif
#if defined(GL_ATI_texture_float)
                    return "GL_RGB_FLOAT32_ATI";
#endif
            break;
        case 0x8816:
#if defined(GL_ARB_texture_float)
                    return "GL_ALPHA32F_ARB";
#endif
#if defined(GL_APPLE_float_pixels)
                    return "GL_ALPHA_FLOAT32_APPLE";
#endif
#if defined(GL_ATI_texture_float)
                    return "GL_ALPHA_FLOAT32_ATI";
#endif
            break;
        case 0x8817:
#if defined(GL_ARB_texture_float)
                    return "GL_INTENSITY32F_ARB";
#endif
#if defined(GL_APPLE_float_pixels)
                    return "GL_INTENSITY_FLOAT32_APPLE";
#endif
#if defined(GL_ATI_texture_float)
                    return "GL_INTENSITY_FLOAT32_ATI";
#endif
            break;
        case 0x8818:
#if defined(GL_ARB_texture_float)
                    return "GL_LUMINANCE32F_ARB";
#endif
#if defined(GL_APPLE_float_pixels)
                    return "GL_LUMINANCE_FLOAT32_APPLE";
#endif
#if defined(GL_ATI_texture_float)
                    return "GL_LUMINANCE_FLOAT32_ATI";
#endif
            break;
        case 0x8819:
#if defined(GL_ARB_texture_float)
                    return "GL_LUMINANCE_ALPHA32F_ARB";
#endif
#if defined(GL_APPLE_float_pixels)
                    return "GL_LUMINANCE_ALPHA_FLOAT32_APPLE";
#endif
#if defined(GL_ATI_texture_float)
                    return "GL_LUMINANCE_ALPHA_FLOAT32_ATI";
#endif
            break;
        case 0x881a:
#if defined(GL_VERSION_3_0)
                    return "GL_RGBA16F";
#endif
#if defined(GL_ARB_texture_float)
                    return "GL_RGBA16F_ARB";
#endif
#if defined(GL_APPLE_float_pixels)
                    return "GL_RGBA_FLOAT16_APPLE";
#endif
#if defined(GL_ATI_texture_float)
                    return "GL_RGBA_FLOAT16_ATI";
#endif
            break;
        case 0x881b:
#if defined(GL_VERSION_3_0)
                    return "GL_RGB16F";
#endif
#if defined(GL_ARB_texture_float)
                    return "GL_RGB16F_ARB";
#endif
#if defined(GL_APPLE_float_pixels)
                    return "GL_RGB_FLOAT16_APPLE";
#endif
#if defined(GL_ATI_texture_float)
                    return "GL_RGB_FLOAT16_ATI";
#endif
            break;
        case 0x881c:
#if defined(GL_ARB_texture_float)
                    return "GL_ALPHA16F_ARB";
#endif
#if defined(GL_APPLE_float_pixels)
                    return "GL_ALPHA_FLOAT16_APPLE";
#endif
#if defined(GL_ATI_texture_float)
                    return "GL_ALPHA_FLOAT16_ATI";
#endif
            break;
        case 0x881d:
#if defined(GL_ARB_texture_float)
                    return "GL_INTENSITY16F_ARB";
#endif
#if defined(GL_APPLE_float_pixels)
                    return "GL_INTENSITY_FLOAT16_APPLE";
#endif
#if defined(GL_ATI_texture_float)
                    return "GL_INTENSITY_FLOAT16_ATI";
#endif
            break;
        case 0x881e:
#if defined(GL_ARB_texture_float)
                    return "GL_LUMINANCE16F_ARB";
#endif
#if defined(GL_APPLE_float_pixels)
                    return "GL_LUMINANCE_FLOAT16_APPLE";
#endif
#if defined(GL_ATI_texture_float)
                    return "GL_LUMINANCE_FLOAT16_ATI";
#endif
            break;
        case 0x881f:
#if defined(GL_ARB_texture_float)
                    return "GL_LUMINANCE_ALPHA16F_ARB";
#endif
#if defined(GL_APPLE_float_pixels)
                    return "GL_LUMINANCE_ALPHA_FLOAT16_APPLE";
#endif
#if defined(GL_ATI_texture_float)
                    return "GL_LUMINANCE_ALPHA_FLOAT16_ATI";
#endif
            break;
        case 0x8820:
#if defined(GL_ARB_color_buffer_float)
                    return "GL_RGBA_FLOAT_MODE_ARB";
#endif
#if defined(GL_ATI_pixel_format_float)
                    return "GL_RGBA_FLOAT_MODE_ATI";
#endif
            break;
        case 0x8824:
#if defined(GL_VERSION_2_0)
                    return "GL_MAX_DRAW_BUFFERS";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_MAX_DRAW_BUFFERS_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_MAX_DRAW_BUFFERS_ATI";
#endif
            break;
        case 0x8825:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER0";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER0_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER0_ATI";
#endif
            break;
        case 0x8826:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER1";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER1_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER1_ATI";
#endif
            break;
        case 0x8827:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER2";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER2_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER2_ATI";
#endif
            break;
        case 0x8828:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER3";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER3_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER3_ATI";
#endif
            break;
        case 0x8829:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER4";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER4_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER4_ATI";
#endif
            break;
        case 0x882a:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER5";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER5_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER5_ATI";
#endif
            break;
        case 0x882b:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER6";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER6_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER6_ATI";
#endif
            break;
        case 0x882c:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER7";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER7_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER7_ATI";
#endif
            break;
        case 0x882d:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER8";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER8_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER8_ATI";
#endif
            break;
        case 0x882e:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER9";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER9_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER9_ATI";
#endif
            break;
        case 0x882f:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER10";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER10_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER10_ATI";
#endif
            break;
        case 0x8830:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER11";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER11_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER11_ATI";
#endif
            break;
        case 0x8831:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER12";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER12_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER12_ATI";
#endif
            break;
        case 0x8832:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER13";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER13_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER13_ATI";
#endif
            break;
        case 0x8833:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER14";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER14_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER14_ATI";
#endif
            break;
        case 0x8834:
#if defined(GL_VERSION_2_0)
                    return "GL_DRAW_BUFFER15";
#endif
#if defined(GL_ARB_draw_buffers)
                    return "GL_DRAW_BUFFER15_ARB";
#endif
#if defined(GL_ATI_draw_buffers)
                    return "GL_DRAW_BUFFER15_ATI";
#endif
            break;
#if defined(GL_ATI_pixel_format_float)
        case 0x8835: return "GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI";
#endif
        case 0x883d:
#if defined(GL_ATI_blend_equation_separate)
                    return "GL_ALPHA_BLEND_EQUATION_ATI";
#endif
#if defined(GL_VERSION_2_0)
                    return "GL_BLEND_EQUATION_ALPHA";
#endif
#if defined(GL_EXT_blend_equation_separate)
                    return "GL_BLEND_EQUATION_ALPHA_EXT";
#endif
            break;
#if defined(GL_AMD_framebuffer_sample_positions)
        case 0x883f: return "GL_SUBSAMPLE_DISTANCE_AMD";
#endif
#if defined(GL_ARB_matrix_palette)
        case 0x8840: return "GL_MATRIX_PALETTE_ARB";
        case 0x8841: return "GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB";
        case 0x8842: return "GL_MAX_PALETTE_MATRICES_ARB";
        case 0x8843: return "GL_CURRENT_PALETTE_MATRIX_ARB";
        case 0x8844: return "GL_MATRIX_INDEX_ARRAY_ARB";
        case 0x8845: return "GL_CURRENT_MATRIX_INDEX_ARB";
        case 0x8846: return "GL_MATRIX_INDEX_ARRAY_SIZE_ARB";
        case 0x8847: return "GL_MATRIX_INDEX_ARRAY_TYPE_ARB";
        case 0x8848: return "GL_MATRIX_INDEX_ARRAY_STRIDE_ARB";
        case 0x8849: return "GL_MATRIX_INDEX_ARRAY_POINTER_ARB";
#endif
        case 0x884a:
#if defined(GL_VERSION_1_4)
                    return "GL_TEXTURE_DEPTH_SIZE";
#endif
#if defined(GL_ARB_depth_texture)
                    return "GL_TEXTURE_DEPTH_SIZE_ARB";
#endif
            break;
        case 0x884b:
#if defined(GL_VERSION_1_4)
                    return "GL_DEPTH_TEXTURE_MODE";
#endif
#if defined(GL_ARB_depth_texture)
                    return "GL_DEPTH_TEXTURE_MODE_ARB";
#endif
            break;
        case 0x884c:
#if defined(GL_VERSION_1_4)
                    return "GL_TEXTURE_COMPARE_MODE";
#endif
#if defined(GL_ARB_shadow)
                    return "GL_TEXTURE_COMPARE_MODE_ARB";
#endif
            break;
        case 0x884d:
#if defined(GL_VERSION_1_4)
                    return "GL_TEXTURE_COMPARE_FUNC";
#endif
#if defined(GL_ARB_shadow)
                    return "GL_TEXTURE_COMPARE_FUNC_ARB";
#endif
            break;
        case 0x884e:
#if defined(GL_EXT_texture_array)
                    return "GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT";
#endif
#if defined(GL_VERSION_3_0)
                    return "GL_COMPARE_REF_TO_TEXTURE";
#endif
#if defined(GL_VERSION_1_4)
                    return "GL_COMPARE_R_TO_TEXTURE";
#endif
#if defined(GL_ARB_shadow)
                    return "GL_COMPARE_R_TO_TEXTURE_ARB";
#endif
            break;
#if defined(GL_VERSION_3_2)
        case 0x884f: return "GL_TEXTURE_CUBE_MAP_SEAMLESS";
#endif
#if defined(GL_NV_texture_shader3)
        case 0x8850: return "GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV";
        case 0x8851: return "GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV";
        case 0x8852: return "GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV";
        case 0x8853: return "GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV";
        case 0x8854: return "GL_OFFSET_HILO_TEXTURE_2D_NV";
        case 0x8855: return "GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV";
        case 0x8856: return "GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV";
        case 0x8857: return "GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV";
        case 0x8858: return "GL_DEPENDENT_HILO_TEXTURE_2D_NV";
        case 0x8859: return "GL_DEPENDENT_RGB_TEXTURE_3D_NV";
        case 0x885a: return "GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV";
        case 0x885b: return "GL_DOT_PRODUCT_PASS_THROUGH_NV";
        case 0x885c: return "GL_DOT_PRODUCT_TEXTURE_1D_NV";
        case 0x885d: return "GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV";
        case 0x885e: return "GL_HILO8_NV";
        case 0x885f: return "GL_SIGNED_HILO8_NV";
        case 0x8860: return "GL_FORCE_BLUE_TO_ONE_NV";
#endif
        case 0x8861:
#if defined(GL_VERSION_2_0)
                    return "GL_POINT_SPRITE";
#endif
#if defined(GL_ARB_point_sprite)
                    return "GL_POINT_SPRITE_ARB";
#endif
#if defined(GL_NV_point_sprite)
                    return "GL_POINT_SPRITE_NV";
#endif
            break;
        case 0x8862:
#if defined(GL_VERSION_2_0)
                    return "GL_COORD_REPLACE";
#endif
#if defined(GL_ARB_point_sprite)
                    return "GL_COORD_REPLACE_ARB";
#endif
#if defined(GL_NV_point_sprite)
                    return "GL_COORD_REPLACE_NV";
#endif
            break;
#if defined(GL_NV_point_sprite)
        case 0x8863: return "GL_POINT_SPRITE_R_MODE_NV";
#endif
        case 0x8865:
#if defined(GL_NV_occlusion_query)
                    return "GL_CURRENT_OCCLUSION_QUERY_ID_NV";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_CURRENT_QUERY";
#endif
#if defined(GL_ARB_occlusion_query)
                    return "GL_CURRENT_QUERY_ARB";
#endif
            break;
        case 0x8866:
#if defined(GL_NV_occlusion_query)
                    return "GL_PIXEL_COUNT_NV";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_QUERY_RESULT";
#endif
#if defined(GL_ARB_occlusion_query)
                    return "GL_QUERY_RESULT_ARB";
#endif
            break;
        case 0x8867:
#if defined(GL_NV_occlusion_query)
                    return "GL_PIXEL_COUNT_AVAILABLE_NV";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_QUERY_RESULT_AVAILABLE";
#endif
#if defined(GL_ARB_occlusion_query)
                    return "GL_QUERY_RESULT_AVAILABLE_ARB";
#endif
            break;
#if defined(GL_NV_fragment_program)
        case 0x8868: return "GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV";
#endif
        case 0x8869:
#if defined(GL_VERSION_2_0)
                    return "GL_MAX_VERTEX_ATTRIBS";
#endif
#if defined(GL_ARB_vertex_program)
                    return "GL_MAX_VERTEX_ATTRIBS_ARB";
#endif
            break;
        case 0x886a:
#if defined(GL_VERSION_2_0)
                    return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
#endif
#if defined(GL_ARB_vertex_program)
                    return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB";
#endif
            break;
#if defined(GL_VERSION_4_0)
        case 0x886c: return "GL_MAX_TESS_CONTROL_INPUT_COMPONENTS";
        case 0x886d: return "GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS";
#endif
#if defined(GL_NV_copy_depth_to_color)
        case 0x886e: return "GL_DEPTH_STENCIL_TO_RGBA_NV";
        case 0x886f: return "GL_DEPTH_STENCIL_TO_BGRA_NV";
#endif
#if defined(GL_NV_fragment_program)
        case 0x8870: return "GL_FRAGMENT_PROGRAM_NV";
#endif
        case 0x8871:
#if defined(GL_VERSION_2_0)
                    return "GL_MAX_TEXTURE_COORDS";
#endif
#if defined(GL_ARB_fragment_program)
                    return "GL_MAX_TEXTURE_COORDS_ARB";
#endif
#if defined(GL_NV_fragment_program)
                    return "GL_MAX_TEXTURE_COORDS_NV";
#endif
            break;
        case 0x8872:
#if defined(GL_VERSION_2_0)
                    return "GL_MAX_TEXTURE_IMAGE_UNITS";
#endif
#if defined(GL_ARB_fragment_program)
                    return "GL_MAX_TEXTURE_IMAGE_UNITS_ARB";
#endif
#if defined(GL_NV_fragment_program)
                    return "GL_MAX_TEXTURE_IMAGE_UNITS_NV";
#endif
            break;
#if defined(GL_NV_fragment_program)
        case 0x8873: return "GL_FRAGMENT_PROGRAM_BINDING_NV";
#endif
        case 0x8874:
#if defined(GL_ARB_fragment_program)
                    return "GL_PROGRAM_ERROR_STRING_ARB";
#endif
#if defined(GL_NV_fragment_program)
                    return "GL_PROGRAM_ERROR_STRING_NV";
#endif
            break;
#if defined(GL_ARB_fragment_program)
        case 0x8875: return "GL_PROGRAM_FORMAT_ASCII_ARB";
        case 0x8876: return "GL_PROGRAM_FORMAT_ARB";
#endif
#if defined(GL_NV_pixel_data_range)
        case 0x8878: return "GL_WRITE_PIXEL_DATA_RANGE_NV";
        case 0x8879: return "GL_READ_PIXEL_DATA_RANGE_NV";
        case 0x887a: return "GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV";
        case 0x887b: return "GL_READ_PIXEL_DATA_RANGE_LENGTH_NV";
        case 0x887c: return "GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV";
        case 0x887d: return "GL_READ_PIXEL_DATA_RANGE_POINTER_NV";
#endif
#if defined(GL_VERSION_4_0)
        case 0x887f: return "GL_GEOMETRY_SHADER_INVOCATIONS";
#endif
#if defined(GL_NV_float_buffer)
        case 0x8880: return "GL_FLOAT_R_NV";
        case 0x8881: return "GL_FLOAT_RG_NV";
        case 0x8882: return "GL_FLOAT_RGB_NV";
        case 0x8883: return "GL_FLOAT_RGBA_NV";
        case 0x8884: return "GL_FLOAT_R16_NV";
        case 0x8885: return "GL_FLOAT_R32_NV";
        case 0x8886: return "GL_FLOAT_RG16_NV";
        case 0x8887: return "GL_FLOAT_RG32_NV";
        case 0x8888: return "GL_FLOAT_RGB16_NV";
        case 0x8889: return "GL_FLOAT_RGB32_NV";
        case 0x888a: return "GL_FLOAT_RGBA16_NV";
        case 0x888b: return "GL_FLOAT_RGBA32_NV";
        case 0x888c: return "GL_TEXTURE_FLOAT_COMPONENTS_NV";
        case 0x888d: return "GL_FLOAT_CLEAR_COLOR_VALUE_NV";
        case 0x888e: return "GL_FLOAT_RGBA_MODE_NV";
#endif
#if defined(GL_NV_texture_expand_normal)
        case 0x888f: return "GL_TEXTURE_UNSIGNED_REMAP_MODE_NV";
#endif
#if defined(GL_EXT_depth_bounds_test)
        case 0x8890: return "GL_DEPTH_BOUNDS_TEST_EXT";
        case 0x8891: return "GL_DEPTH_BOUNDS_EXT";
#endif
        case 0x8892:
#if defined(GL_VERSION_1_5)
                    return "GL_ARRAY_BUFFER";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_ARRAY_BUFFER_ARB";
#endif
            break;
        case 0x8893:
#if defined(GL_VERSION_1_5)
                    return "GL_ELEMENT_ARRAY_BUFFER";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_ELEMENT_ARRAY_BUFFER_ARB";
#endif
            break;
        case 0x8894:
#if defined(GL_VERSION_1_5)
                    return "GL_ARRAY_BUFFER_BINDING";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_ARRAY_BUFFER_BINDING_ARB";
#endif
            break;
        case 0x8895:
#if defined(GL_VERSION_1_5)
                    return "GL_ELEMENT_ARRAY_BUFFER_BINDING";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB";
#endif
            break;
        case 0x8896:
#if defined(GL_VERSION_1_5)
                    return "GL_VERTEX_ARRAY_BUFFER_BINDING";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_VERTEX_ARRAY_BUFFER_BINDING_ARB";
#endif
            break;
        case 0x8897:
#if defined(GL_VERSION_1_5)
                    return "GL_NORMAL_ARRAY_BUFFER_BINDING";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_NORMAL_ARRAY_BUFFER_BINDING_ARB";
#endif
            break;
        case 0x8898:
#if defined(GL_VERSION_1_5)
                    return "GL_COLOR_ARRAY_BUFFER_BINDING";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_COLOR_ARRAY_BUFFER_BINDING_ARB";
#endif
            break;
        case 0x8899:
#if defined(GL_VERSION_1_5)
                    return "GL_INDEX_ARRAY_BUFFER_BINDING";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_INDEX_ARRAY_BUFFER_BINDING_ARB";
#endif
            break;
        case 0x889a:
#if defined(GL_VERSION_1_5)
                    return "GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB";
#endif
            break;
        case 0x889b:
#if defined(GL_VERSION_1_5)
                    return "GL_EDGE_FLAG_ARRAY_BUFFER_BINDING";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB";
#endif
            break;
        case 0x889c:
#if defined(GL_VERSION_1_5)
                    return "GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB";
#endif
            break;
        case 0x889d:
#if defined(GL_VERSION_1_5)
                    return "GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB";
#endif
#if defined(GL_VERSION_1_5)
                    return "GL_FOG_COORD_ARRAY_BUFFER_BINDING";
#endif
            break;
        case 0x889e:
#if defined(GL_VERSION_1_5)
                    return "GL_WEIGHT_ARRAY_BUFFER_BINDING";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB";
#endif
            break;
        case 0x889f:
#if defined(GL_VERSION_1_5)
                    return "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB";
#endif
            break;
#if defined(GL_ARB_fragment_program)
        case 0x88a0: return "GL_PROGRAM_INSTRUCTIONS_ARB";
        case 0x88a1: return "GL_MAX_PROGRAM_INSTRUCTIONS_ARB";
        case 0x88a2: return "GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB";
        case 0x88a3: return "GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB";
        case 0x88a4: return "GL_PROGRAM_TEMPORARIES_ARB";
        case 0x88a5: return "GL_MAX_PROGRAM_TEMPORARIES_ARB";
        case 0x88a6: return "GL_PROGRAM_NATIVE_TEMPORARIES_ARB";
        case 0x88a7: return "GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB";
        case 0x88a8: return "GL_PROGRAM_PARAMETERS_ARB";
        case 0x88a9: return "GL_MAX_PROGRAM_PARAMETERS_ARB";
        case 0x88aa: return "GL_PROGRAM_NATIVE_PARAMETERS_ARB";
        case 0x88ab: return "GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB";
        case 0x88ac: return "GL_PROGRAM_ATTRIBS_ARB";
        case 0x88ad: return "GL_MAX_PROGRAM_ATTRIBS_ARB";
        case 0x88ae: return "GL_PROGRAM_NATIVE_ATTRIBS_ARB";
        case 0x88af: return "GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB";
#endif
#if defined(GL_ARB_vertex_program)
        case 0x88b0: return "GL_PROGRAM_ADDRESS_REGISTERS_ARB";
        case 0x88b1: return "GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB";
        case 0x88b2: return "GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB";
        case 0x88b3: return "GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB";
#endif
#if defined(GL_ARB_fragment_program)
        case 0x88b4: return "GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB";
        case 0x88b5: return "GL_MAX_PROGRAM_ENV_PARAMETERS_ARB";
        case 0x88b6: return "GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB";
        case 0x88b7: return "GL_TRANSPOSE_CURRENT_MATRIX_ARB";
#endif
        case 0x88b8:
#if defined(GL_VERSION_1_5)
                    return "GL_READ_ONLY";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_READ_ONLY_ARB";
#endif
            break;
        case 0x88b9:
#if defined(GL_VERSION_1_5)
                    return "GL_WRITE_ONLY";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_WRITE_ONLY_ARB";
#endif
            break;
        case 0x88ba:
#if defined(GL_VERSION_1_5)
                    return "GL_READ_WRITE";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_READ_WRITE_ARB";
#endif
            break;
        case 0x88bb:
#if defined(GL_VERSION_1_5)
                    return "GL_BUFFER_ACCESS";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_BUFFER_ACCESS_ARB";
#endif
            break;
        case 0x88bc:
#if defined(GL_VERSION_1_5)
                    return "GL_BUFFER_MAPPED";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_BUFFER_MAPPED_ARB";
#endif
            break;
        case 0x88bd:
#if defined(GL_VERSION_1_5)
                    return "GL_BUFFER_MAP_POINTER";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_BUFFER_MAP_POINTER_ARB";
#endif
            break;
#if defined(GL_NV_vdpau_interop)
        case 0x88be: return "GL_WRITE_DISCARD_NV";
#endif
        case 0x88bf:
#if defined(GL_VERSION_3_3)
                    return "GL_TIME_ELAPSED";
#endif
#if defined(GL_EXT_timer_query)
                    return "GL_TIME_ELAPSED_EXT";
#endif
            break;
#if defined(GL_ARB_fragment_program)
        case 0x88c0: return "GL_MATRIX0_ARB";
        case 0x88c1: return "GL_MATRIX1_ARB";
        case 0x88c2: return "GL_MATRIX2_ARB";
        case 0x88c3: return "GL_MATRIX3_ARB";
        case 0x88c4: return "GL_MATRIX4_ARB";
        case 0x88c5: return "GL_MATRIX5_ARB";
        case 0x88c6: return "GL_MATRIX6_ARB";
        case 0x88c7: return "GL_MATRIX7_ARB";
        case 0x88c8: return "GL_MATRIX8_ARB";
        case 0x88c9: return "GL_MATRIX9_ARB";
        case 0x88ca: return "GL_MATRIX10_ARB";
        case 0x88cb: return "GL_MATRIX11_ARB";
        case 0x88cc: return "GL_MATRIX12_ARB";
        case 0x88cd: return "GL_MATRIX13_ARB";
        case 0x88ce: return "GL_MATRIX14_ARB";
        case 0x88cf: return "GL_MATRIX15_ARB";
        case 0x88d0: return "GL_MATRIX16_ARB";
        case 0x88d1: return "GL_MATRIX17_ARB";
        case 0x88d2: return "GL_MATRIX18_ARB";
        case 0x88d3: return "GL_MATRIX19_ARB";
        case 0x88d4: return "GL_MATRIX20_ARB";
        case 0x88d5: return "GL_MATRIX21_ARB";
        case 0x88d6: return "GL_MATRIX22_ARB";
        case 0x88d7: return "GL_MATRIX23_ARB";
        case 0x88d8: return "GL_MATRIX24_ARB";
        case 0x88d9: return "GL_MATRIX25_ARB";
        case 0x88da: return "GL_MATRIX26_ARB";
        case 0x88db: return "GL_MATRIX27_ARB";
        case 0x88dc: return "GL_MATRIX28_ARB";
        case 0x88dd: return "GL_MATRIX29_ARB";
        case 0x88de: return "GL_MATRIX30_ARB";
        case 0x88df: return "GL_MATRIX31_ARB";
#endif
        case 0x88e0:
#if defined(GL_VERSION_1_5)
                    return "GL_STREAM_DRAW";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_STREAM_DRAW_ARB";
#endif
            break;
        case 0x88e1:
#if defined(GL_VERSION_1_5)
                    return "GL_STREAM_READ";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_STREAM_READ_ARB";
#endif
            break;
        case 0x88e2:
#if defined(GL_VERSION_1_5)
                    return "GL_STREAM_COPY";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_STREAM_COPY_ARB";
#endif
            break;
        case 0x88e4:
#if defined(GL_VERSION_1_5)
                    return "GL_STATIC_DRAW";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_STATIC_DRAW_ARB";
#endif
            break;
        case 0x88e5:
#if defined(GL_VERSION_1_5)
                    return "GL_STATIC_READ";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_STATIC_READ_ARB";
#endif
            break;
        case 0x88e6:
#if defined(GL_VERSION_1_5)
                    return "GL_STATIC_COPY";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_STATIC_COPY_ARB";
#endif
            break;
        case 0x88e8:
#if defined(GL_VERSION_1_5)
                    return "GL_DYNAMIC_DRAW";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_DYNAMIC_DRAW_ARB";
#endif
            break;
        case 0x88e9:
#if defined(GL_VERSION_1_5)
                    return "GL_DYNAMIC_READ";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_DYNAMIC_READ_ARB";
#endif
            break;
        case 0x88ea:
#if defined(GL_VERSION_1_5)
                    return "GL_DYNAMIC_COPY";
#endif
#if defined(GL_ARB_vertex_buffer_object)
                    return "GL_DYNAMIC_COPY_ARB";
#endif
            break;
        case 0x88eb:
#if defined(GL_VERSION_2_1)
                    return "GL_PIXEL_PACK_BUFFER";
#endif
#if defined(GL_ARB_pixel_buffer_object)
                    return "GL_PIXEL_PACK_BUFFER_ARB";
#endif
#if defined(GL_EXT_pixel_buffer_object)
                    return "GL_PIXEL_PACK_BUFFER_EXT";
#endif
            break;
        case 0x88ec:
#if defined(GL_VERSION_2_1)
                    return "GL_PIXEL_UNPACK_BUFFER";
#endif
#if defined(GL_ARB_pixel_buffer_object)
                    return "GL_PIXEL_UNPACK_BUFFER_ARB";
#endif
#if defined(GL_EXT_pixel_buffer_object)
                    return "GL_PIXEL_UNPACK_BUFFER_EXT";
#endif
            break;
        case 0x88ed:
#if defined(GL_VERSION_2_1)
                    return "GL_PIXEL_PACK_BUFFER_BINDING";
#endif
#if defined(GL_ARB_pixel_buffer_object)
                    return "GL_PIXEL_PACK_BUFFER_BINDING_ARB";
#endif
#if defined(GL_EXT_pixel_buffer_object)
                    return "GL_PIXEL_PACK_BUFFER_BINDING_EXT";
#endif
            break;
        case 0x88ef:
#if defined(GL_VERSION_2_1)
                    return "GL_PIXEL_UNPACK_BUFFER_BINDING";
#endif
#if defined(GL_ARB_pixel_buffer_object)
                    return "GL_PIXEL_UNPACK_BUFFER_BINDING_ARB";
#endif
#if defined(GL_EXT_pixel_buffer_object)
                    return "GL_PIXEL_UNPACK_BUFFER_BINDING_EXT";
#endif
            break;
        case 0x88f0:
#if defined(GL_VERSION_3_0)
                    return "GL_DEPTH24_STENCIL8";
#endif
#if defined(GL_EXT_packed_depth_stencil)
                    return "GL_DEPTH24_STENCIL8_EXT";
#endif
            break;
        case 0x88f1:
#if defined(GL_VERSION_3_0)
                    return "GL_TEXTURE_STENCIL_SIZE";
#endif
#if defined(GL_EXT_packed_depth_stencil)
                    return "GL_TEXTURE_STENCIL_SIZE_EXT";
#endif
            break;
#if defined(GL_EXT_stencil_clear_tag)
        case 0x88f3: return "GL_STENCIL_CLEAR_TAG_VALUE_EXT";
#endif
#if defined(GL_NV_fragment_program2)
        case 0x88f4: return "GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV";
        case 0x88f5: return "GL_MAX_PROGRAM_CALL_DEPTH_NV";
        case 0x88f6: return "GL_MAX_PROGRAM_IF_DEPTH_NV";
        case 0x88f7: return "GL_MAX_PROGRAM_LOOP_DEPTH_NV";
        case 0x88f8: return "GL_MAX_PROGRAM_LOOP_COUNT_NV";
#endif
#if defined(GL_VERSION_3_3)
        case 0x88f9: return "GL_SRC1_COLOR";
        case 0x88fa: return "GL_ONE_MINUS_SRC1_COLOR";
        case 0x88fb: return "GL_ONE_MINUS_SRC1_ALPHA";
        case 0x88fc: return "GL_MAX_DUAL_SOURCE_DRAW_BUFFERS";
#endif
        case 0x88fd:
#if defined(GL_VERSION_3_0)
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT";
#endif
#if defined(GL_NV_vertex_program4)
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER_NV";
#endif
            break;
        case 0x88fe:
#if defined(GL_VERSION_3_3)
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
#endif
#if defined(GL_ARB_instanced_arrays)
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB";
#endif
            break;
        case 0x88ff:
#if defined(GL_VERSION_3_0)
                    return "GL_MAX_ARRAY_TEXTURE_LAYERS";
#endif
#if defined(GL_EXT_texture_array)
                    return "GL_MAX_ARRAY_TEXTURE_LAYERS_EXT";
#endif
            break;
        case 0x8904:
#if defined(GL_VERSION_3_0)
                    return "GL_MIN_PROGRAM_TEXEL_OFFSET";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_MIN_PROGRAM_TEXEL_OFFSET_EXT";
#endif
#if defined(GL_NV_gpu_program4)
                    return "GL_MIN_PROGRAM_TEXEL_OFFSET_NV";
#endif
            break;
        case 0x8905:
#if defined(GL_VERSION_3_0)
                    return "GL_MAX_PROGRAM_TEXEL_OFFSET";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_MAX_PROGRAM_TEXEL_OFFSET_EXT";
#endif
#if defined(GL_NV_gpu_program4)
                    return "GL_MAX_PROGRAM_TEXEL_OFFSET_NV";
#endif
            break;
#if defined(GL_NV_gpu_program4)
        case 0x8906: return "GL_PROGRAM_ATTRIB_COMPONENTS_NV";
        case 0x8907: return "GL_PROGRAM_RESULT_COMPONENTS_NV";
        case 0x8908: return "GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV";
        case 0x8909: return "GL_MAX_PROGRAM_RESULT_COMPONENTS_NV";
#endif
#if defined(GL_EXT_stencil_two_side)
        case 0x8910: return "GL_STENCIL_TEST_TWO_SIDE_EXT";
        case 0x8911: return "GL_ACTIVE_STENCIL_FACE_EXT";
#endif
#if defined(GL_EXT_texture_mirror_clamp)
        case 0x8912: return "GL_MIRROR_CLAMP_TO_BORDER_EXT";
#endif
        case 0x8914:
#if defined(GL_VERSION_1_5)
                    return "GL_SAMPLES_PASSED";
#endif
#if defined(GL_ARB_occlusion_query)
                    return "GL_SAMPLES_PASSED_ARB";
#endif
            break;
#if defined(GL_VERSION_3_2)
        case 0x8916: return "GL_GEOMETRY_VERTICES_OUT";
        case 0x8917: return "GL_GEOMETRY_INPUT_TYPE";
        case 0x8918: return "GL_GEOMETRY_OUTPUT_TYPE";
#endif
#if defined(GL_VERSION_3_3)
        case 0x8919: return "GL_SAMPLER_BINDING";
#endif
        case 0x891a:
#if defined(GL_VERSION_3_0)
                    return "GL_CLAMP_VERTEX_COLOR";
#endif
#if defined(GL_ARB_color_buffer_float)
                    return "GL_CLAMP_VERTEX_COLOR_ARB";
#endif
            break;
        case 0x891b:
#if defined(GL_VERSION_3_0)
                    return "GL_CLAMP_FRAGMENT_COLOR";
#endif
#if defined(GL_ARB_color_buffer_float)
                    return "GL_CLAMP_FRAGMENT_COLOR_ARB";
#endif
            break;
        case 0x891c:
#if defined(GL_VERSION_3_0)
                    return "GL_CLAMP_READ_COLOR";
#endif
#if defined(GL_ARB_color_buffer_float)
                    return "GL_CLAMP_READ_COLOR_ARB";
#endif
            break;
        case 0x891d:
#if defined(GL_VERSION_3_0)
                    return "GL_FIXED_ONLY";
#endif
#if defined(GL_ARB_color_buffer_float)
                    return "GL_FIXED_ONLY_ARB";
#endif
            break;
#if defined(GL_NV_tessellation_program5)
        case 0x891e: return "GL_TESS_CONTROL_PROGRAM_NV";
        case 0x891f: return "GL_TESS_EVALUATION_PROGRAM_NV";
#endif
#if defined(GL_ATI_fragment_shader)
        case 0x8920: return "GL_FRAGMENT_SHADER_ATI";
        case 0x8921: return "GL_REG_0_ATI";
        case 0x8922: return "GL_REG_1_ATI";
        case 0x8923: return "GL_REG_2_ATI";
        case 0x8924: return "GL_REG_3_ATI";
        case 0x8925: return "GL_REG_4_ATI";
        case 0x8926: return "GL_REG_5_ATI";
        case 0x8927: return "GL_REG_6_ATI";
        case 0x8928: return "GL_REG_7_ATI";
        case 0x8929: return "GL_REG_8_ATI";
        case 0x892a: return "GL_REG_9_ATI";
        case 0x892b: return "GL_REG_10_ATI";
        case 0x892c: return "GL_REG_11_ATI";
        case 0x892d: return "GL_REG_12_ATI";
        case 0x892e: return "GL_REG_13_ATI";
        case 0x892f: return "GL_REG_14_ATI";
        case 0x8930: return "GL_REG_15_ATI";
        case 0x8931: return "GL_REG_16_ATI";
        case 0x8932: return "GL_REG_17_ATI";
        case 0x8933: return "GL_REG_18_ATI";
        case 0x8934: return "GL_REG_19_ATI";
        case 0x8935: return "GL_REG_20_ATI";
        case 0x8936: return "GL_REG_21_ATI";
        case 0x8937: return "GL_REG_22_ATI";
        case 0x8938: return "GL_REG_23_ATI";
        case 0x8939: return "GL_REG_24_ATI";
        case 0x893a: return "GL_REG_25_ATI";
        case 0x893b: return "GL_REG_26_ATI";
        case 0x893c: return "GL_REG_27_ATI";
        case 0x893d: return "GL_REG_28_ATI";
        case 0x893e: return "GL_REG_29_ATI";
        case 0x893f: return "GL_REG_30_ATI";
        case 0x8940: return "GL_REG_31_ATI";
        case 0x8941: return "GL_CON_0_ATI";
        case 0x8942: return "GL_CON_1_ATI";
        case 0x8943: return "GL_CON_2_ATI";
        case 0x8944: return "GL_CON_3_ATI";
        case 0x8945: return "GL_CON_4_ATI";
        case 0x8946: return "GL_CON_5_ATI";
        case 0x8947: return "GL_CON_6_ATI";
        case 0x8948: return "GL_CON_7_ATI";
        case 0x8949: return "GL_CON_8_ATI";
        case 0x894a: return "GL_CON_9_ATI";
        case 0x894b: return "GL_CON_10_ATI";
        case 0x894c: return "GL_CON_11_ATI";
        case 0x894d: return "GL_CON_12_ATI";
        case 0x894e: return "GL_CON_13_ATI";
        case 0x894f: return "GL_CON_14_ATI";
        case 0x8950: return "GL_CON_15_ATI";
        case 0x8951: return "GL_CON_16_ATI";
        case 0x8952: return "GL_CON_17_ATI";
        case 0x8953: return "GL_CON_18_ATI";
        case 0x8954: return "GL_CON_19_ATI";
        case 0x8955: return "GL_CON_20_ATI";
        case 0x8956: return "GL_CON_21_ATI";
        case 0x8957: return "GL_CON_22_ATI";
        case 0x8958: return "GL_CON_23_ATI";
        case 0x8959: return "GL_CON_24_ATI";
        case 0x895a: return "GL_CON_25_ATI";
        case 0x895b: return "GL_CON_26_ATI";
        case 0x895c: return "GL_CON_27_ATI";
        case 0x895d: return "GL_CON_28_ATI";
        case 0x895e: return "GL_CON_29_ATI";
        case 0x895f: return "GL_CON_30_ATI";
        case 0x8960: return "GL_CON_31_ATI";
        case 0x8961: return "GL_MOV_ATI";
        case 0x8963: return "GL_ADD_ATI";
        case 0x8964: return "GL_MUL_ATI";
        case 0x8965: return "GL_SUB_ATI";
        case 0x8966: return "GL_DOT3_ATI";
        case 0x8967: return "GL_DOT4_ATI";
        case 0x8968: return "GL_MAD_ATI";
        case 0x8969: return "GL_LERP_ATI";
        case 0x896a: return "GL_CND_ATI";
        case 0x896b: return "GL_CND0_ATI";
        case 0x896c: return "GL_DOT2_ADD_ATI";
        case 0x896d: return "GL_SECONDARY_INTERPOLATOR_ATI";
        case 0x896e: return "GL_NUM_FRAGMENT_REGISTERS_ATI";
        case 0x896f: return "GL_NUM_FRAGMENT_CONSTANTS_ATI";
        case 0x8970: return "GL_NUM_PASSES_ATI";
        case 0x8971: return "GL_NUM_INSTRUCTIONS_PER_PASS_ATI";
        case 0x8972: return "GL_NUM_INSTRUCTIONS_TOTAL_ATI";
        case 0x8973: return "GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI";
        case 0x8974: return "GL_NUM_LOOPBACK_COMPONENTS_ATI";
        case 0x8975: return "GL_COLOR_ALPHA_PAIRING_ATI";
        case 0x8976: return "GL_SWIZZLE_STR_ATI";
        case 0x8977: return "GL_SWIZZLE_STQ_ATI";
        case 0x8978: return "GL_SWIZZLE_STR_DR_ATI";
        case 0x8979: return "GL_SWIZZLE_STQ_DQ_ATI";
        case 0x897a: return "GL_SWIZZLE_STRQ_ATI";
        case 0x897b: return "GL_SWIZZLE_STRQ_DQ_ATI";
#endif
#if defined(GL_OML_interlace)
        case 0x8980: return "GL_INTERLACE_OML";
        case 0x8981: return "GL_INTERLACE_READ_OML";
#endif
#if defined(GL_OML_subsample)
        case 0x8982: return "GL_FORMAT_SUBSAMPLE_24_24_OML";
        case 0x8983: return "GL_FORMAT_SUBSAMPLE_244_244_OML";
#endif
#if defined(GL_OML_resample)
        case 0x8984: return "GL_PACK_RESAMPLE_OML";
        case 0x8985: return "GL_UNPACK_RESAMPLE_OML";
        case 0x8986: return "GL_RESAMPLE_REPLICATE_OML";
        case 0x8987: return "GL_RESAMPLE_ZERO_FILL_OML";
        case 0x8988: return "GL_RESAMPLE_AVERAGE_OML";
        case 0x8989: return "GL_RESAMPLE_DECIMATE_OML";
#endif
#if defined(GL_APPLE_vertex_program_evaluators)
        case 0x8a00: return "GL_VERTEX_ATTRIB_MAP1_APPLE";
        case 0x8a01: return "GL_VERTEX_ATTRIB_MAP2_APPLE";
        case 0x8a02: return "GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE";
        case 0x8a03: return "GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE";
        case 0x8a04: return "GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE";
        case 0x8a05: return "GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE";
        case 0x8a06: return "GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE";
        case 0x8a07: return "GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE";
        case 0x8a08: return "GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE";
        case 0x8a09: return "GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE";
#endif
#if defined(GL_APPLE_fence)
        case 0x8a0a: return "GL_DRAW_PIXELS_APPLE";
        case 0x8a0b: return "GL_FENCE_APPLE";
#endif
#if defined(GL_APPLE_element_array)
        case 0x8a0c: return "GL_ELEMENT_ARRAY_APPLE";
        case 0x8a0d: return "GL_ELEMENT_ARRAY_TYPE_APPLE";
        case 0x8a0e: return "GL_ELEMENT_ARRAY_POINTER_APPLE";
#endif
#if defined(GL_APPLE_float_pixels)
        case 0x8a0f: return "GL_COLOR_FLOAT_APPLE";
#endif
#if defined(GL_VERSION_3_1)
        case 0x8a11: return "GL_UNIFORM_BUFFER";
#endif
#if defined(GL_APPLE_flush_buffer_range)
        case 0x8a12: return "GL_BUFFER_SERIALIZED_MODIFY_APPLE";
        case 0x8a13: return "GL_BUFFER_FLUSHING_UNMAP_APPLE";
#endif
#if defined(GL_APPLE_aux_depth_stencil)
        case 0x8a14: return "GL_AUX_DEPTH_STENCIL_APPLE";
#endif
#if defined(GL_APPLE_row_bytes)
        case 0x8a15: return "GL_PACK_ROW_BYTES_APPLE";
        case 0x8a16: return "GL_UNPACK_ROW_BYTES_APPLE";
#endif
#if defined(GL_APPLE_object_purgeable)
        case 0x8a19: return "GL_RELEASED_APPLE";
        case 0x8a1a: return "GL_VOLATILE_APPLE";
        case 0x8a1b: return "GL_RETAINED_APPLE";
        case 0x8a1c: return "GL_UNDEFINED_APPLE";
        case 0x8a1d: return "GL_PURGEABLE_APPLE";
#endif
#if defined(GL_APPLE_rgb_422)
        case 0x8a1f: return "GL_RGB_422_APPLE";
#endif
#if defined(GL_VERSION_3_1)
        case 0x8a28: return "GL_UNIFORM_BUFFER_BINDING";
        case 0x8a29: return "GL_UNIFORM_BUFFER_START";
        case 0x8a2a: return "GL_UNIFORM_BUFFER_SIZE";
        case 0x8a2b: return "GL_MAX_VERTEX_UNIFORM_BLOCKS";
        case 0x8a2c: return "GL_MAX_GEOMETRY_UNIFORM_BLOCKS";
        case 0x8a2d: return "GL_MAX_FRAGMENT_UNIFORM_BLOCKS";
        case 0x8a2e: return "GL_MAX_COMBINED_UNIFORM_BLOCKS";
        case 0x8a2f: return "GL_MAX_UNIFORM_BUFFER_BINDINGS";
        case 0x8a30: return "GL_MAX_UNIFORM_BLOCK_SIZE";
        case 0x8a31: return "GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS";
        case 0x8a32: return "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS";
        case 0x8a33: return "GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS";
        case 0x8a34: return "GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT";
        case 0x8a35: return "GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH";
        case 0x8a36: return "GL_ACTIVE_UNIFORM_BLOCKS";
        case 0x8a37: return "GL_UNIFORM_TYPE";
        case 0x8a38: return "GL_UNIFORM_SIZE";
        case 0x8a39: return "GL_UNIFORM_NAME_LENGTH";
        case 0x8a3a: return "GL_UNIFORM_BLOCK_INDEX";
        case 0x8a3b: return "GL_UNIFORM_OFFSET";
        case 0x8a3c: return "GL_UNIFORM_ARRAY_STRIDE";
        case 0x8a3d: return "GL_UNIFORM_MATRIX_STRIDE";
        case 0x8a3e: return "GL_UNIFORM_IS_ROW_MAJOR";
        case 0x8a3f: return "GL_UNIFORM_BLOCK_BINDING";
        case 0x8a40: return "GL_UNIFORM_BLOCK_DATA_SIZE";
        case 0x8a41: return "GL_UNIFORM_BLOCK_NAME_LENGTH";
        case 0x8a42: return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS";
        case 0x8a43: return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES";
        case 0x8a44: return "GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER";
        case 0x8a45: return "GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER";
        case 0x8a46: return "GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER";
#endif
#if defined(GL_EXT_texture_sRGB_decode)
        case 0x8a48: return "GL_TEXTURE_SRGB_DECODE_EXT";
        case 0x8a49: return "GL_DECODE_EXT";
        case 0x8a4a: return "GL_SKIP_DECODE_EXT";
#endif
#if defined(GL_EXT_debug_label)
        case 0x8a4f: return "GL_PROGRAM_PIPELINE_OBJECT_EXT";
#endif
#if defined(GL_APPLE_rgb_422)
        case 0x8a51: return "GL_RGB_RAW_422_APPLE";
#endif
#if defined(GL_EXT_shader_framebuffer_fetch)
        case 0x8a52: return "GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT";
#endif
        case 0x8b30:
#if defined(GL_VERSION_2_0)
                    return "GL_FRAGMENT_SHADER";
#endif
#if defined(GL_ARB_fragment_shader)
                    return "GL_FRAGMENT_SHADER_ARB";
#endif
            break;
        case 0x8b31:
#if defined(GL_VERSION_2_0)
                    return "GL_VERTEX_SHADER";
#endif
#if defined(GL_ARB_vertex_shader)
                    return "GL_VERTEX_SHADER_ARB";
#endif
            break;
        case 0x8b40:
#if defined(GL_ARB_shader_objects)
                    return "GL_PROGRAM_OBJECT_ARB";
#endif
#if defined(GL_EXT_debug_label)
                    return "GL_PROGRAM_OBJECT_EXT";
#endif
            break;
        case 0x8b48:
#if defined(GL_ARB_shader_objects)
                    return "GL_SHADER_OBJECT_ARB";
#endif
#if defined(GL_EXT_debug_label)
                    return "GL_SHADER_OBJECT_EXT";
#endif
            break;
        case 0x8b49:
#if defined(GL_VERSION_2_0)
                    return "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS";
#endif
#if defined(GL_ARB_fragment_shader)
                    return "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB";
#endif
            break;
        case 0x8b4a:
#if defined(GL_VERSION_2_0)
                    return "GL_MAX_VERTEX_UNIFORM_COMPONENTS";
#endif
#if defined(GL_ARB_vertex_shader)
                    return "GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB";
#endif
            break;
        case 0x8b4b:
#if defined(GL_VERSION_3_0)
                    return "GL_MAX_VARYING_COMPONENTS";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_MAX_VARYING_COMPONENTS_EXT";
#endif
#if defined(GL_VERSION_2_0)
                    return "GL_MAX_VARYING_FLOATS";
#endif
#if defined(GL_ARB_vertex_shader)
                    return "GL_MAX_VARYING_FLOATS_ARB";
#endif
            break;
        case 0x8b4c:
#if defined(GL_VERSION_2_0)
                    return "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS";
#endif
#if defined(GL_ARB_vertex_shader)
                    return "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB";
#endif
            break;
        case 0x8b4d:
#if defined(GL_VERSION_2_0)
                    return "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS";
#endif
#if defined(GL_ARB_vertex_shader)
                    return "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB";
#endif
            break;
#if defined(GL_ARB_shader_objects)
        case 0x8b4e: return "GL_OBJECT_TYPE_ARB";
#endif
        case 0x8b4f:
#if defined(GL_ARB_shader_objects)
                    return "GL_OBJECT_SUBTYPE_ARB";
#endif
#if defined(GL_VERSION_2_0)
                    return "GL_SHADER_TYPE";
#endif
            break;
        case 0x8b50:
#if defined(GL_VERSION_2_0)
                    return "GL_FLOAT_VEC2";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_FLOAT_VEC2_ARB";
#endif
            break;
        case 0x8b51:
#if defined(GL_VERSION_2_0)
                    return "GL_FLOAT_VEC3";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_FLOAT_VEC3_ARB";
#endif
            break;
        case 0x8b52:
#if defined(GL_VERSION_2_0)
                    return "GL_FLOAT_VEC4";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_FLOAT_VEC4_ARB";
#endif
            break;
        case 0x8b53:
#if defined(GL_VERSION_2_0)
                    return "GL_INT_VEC2";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_INT_VEC2_ARB";
#endif
            break;
        case 0x8b54:
#if defined(GL_VERSION_2_0)
                    return "GL_INT_VEC3";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_INT_VEC3_ARB";
#endif
            break;
        case 0x8b55:
#if defined(GL_VERSION_2_0)
                    return "GL_INT_VEC4";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_INT_VEC4_ARB";
#endif
            break;
        case 0x8b56:
#if defined(GL_VERSION_2_0)
                    return "GL_BOOL";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_BOOL_ARB";
#endif
            break;
        case 0x8b57:
#if defined(GL_VERSION_2_0)
                    return "GL_BOOL_VEC2";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_BOOL_VEC2_ARB";
#endif
            break;
        case 0x8b58:
#if defined(GL_VERSION_2_0)
                    return "GL_BOOL_VEC3";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_BOOL_VEC3_ARB";
#endif
            break;
        case 0x8b59:
#if defined(GL_VERSION_2_0)
                    return "GL_BOOL_VEC4";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_BOOL_VEC4_ARB";
#endif
            break;
        case 0x8b5a:
#if defined(GL_VERSION_2_0)
                    return "GL_FLOAT_MAT2";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_FLOAT_MAT2_ARB";
#endif
            break;
        case 0x8b5b:
#if defined(GL_VERSION_2_0)
                    return "GL_FLOAT_MAT3";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_FLOAT_MAT3_ARB";
#endif
            break;
        case 0x8b5c:
#if defined(GL_VERSION_2_0)
                    return "GL_FLOAT_MAT4";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_FLOAT_MAT4_ARB";
#endif
            break;
        case 0x8b5d:
#if defined(GL_VERSION_2_0)
                    return "GL_SAMPLER_1D";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_SAMPLER_1D_ARB";
#endif
            break;
        case 0x8b5e:
#if defined(GL_VERSION_2_0)
                    return "GL_SAMPLER_2D";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_SAMPLER_2D_ARB";
#endif
            break;
        case 0x8b5f:
#if defined(GL_VERSION_2_0)
                    return "GL_SAMPLER_3D";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_SAMPLER_3D_ARB";
#endif
            break;
        case 0x8b60:
#if defined(GL_VERSION_2_0)
                    return "GL_SAMPLER_CUBE";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_SAMPLER_CUBE_ARB";
#endif
            break;
        case 0x8b61:
#if defined(GL_VERSION_2_0)
                    return "GL_SAMPLER_1D_SHADOW";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_SAMPLER_1D_SHADOW_ARB";
#endif
            break;
        case 0x8b62:
#if defined(GL_VERSION_2_0)
                    return "GL_SAMPLER_2D_SHADOW";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_SAMPLER_2D_SHADOW_ARB";
#endif
            break;
        case 0x8b63:
#if defined(GL_VERSION_3_1)
                    return "GL_SAMPLER_2D_RECT";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_SAMPLER_2D_RECT_ARB";
#endif
            break;
        case 0x8b64:
#if defined(GL_VERSION_3_1)
                    return "GL_SAMPLER_2D_RECT_SHADOW";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_SAMPLER_2D_RECT_SHADOW_ARB";
#endif
            break;
#if defined(GL_VERSION_2_1)
        case 0x8b65: return "GL_FLOAT_MAT2x3";
        case 0x8b66: return "GL_FLOAT_MAT2x4";
        case 0x8b67: return "GL_FLOAT_MAT3x2";
        case 0x8b68: return "GL_FLOAT_MAT3x4";
        case 0x8b69: return "GL_FLOAT_MAT4x2";
        case 0x8b6a: return "GL_FLOAT_MAT4x3";
#endif
        case 0x8b80:
#if defined(GL_VERSION_2_0)
                    return "GL_DELETE_STATUS";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_OBJECT_DELETE_STATUS_ARB";
#endif
            break;
        case 0x8b81:
#if defined(GL_VERSION_2_0)
                    return "GL_COMPILE_STATUS";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_OBJECT_COMPILE_STATUS_ARB";
#endif
            break;
        case 0x8b82:
#if defined(GL_VERSION_2_0)
                    return "GL_LINK_STATUS";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_OBJECT_LINK_STATUS_ARB";
#endif
            break;
        case 0x8b83:
#if defined(GL_ARB_shader_objects)
                    return "GL_OBJECT_VALIDATE_STATUS_ARB";
#endif
#if defined(GL_VERSION_2_0)
                    return "GL_VALIDATE_STATUS";
#endif
            break;
        case 0x8b84:
#if defined(GL_VERSION_2_0)
                    return "GL_INFO_LOG_LENGTH";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_OBJECT_INFO_LOG_LENGTH_ARB";
#endif
            break;
        case 0x8b85:
#if defined(GL_VERSION_2_0)
                    return "GL_ATTACHED_SHADERS";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_OBJECT_ATTACHED_OBJECTS_ARB";
#endif
            break;
        case 0x8b86:
#if defined(GL_VERSION_2_0)
                    return "GL_ACTIVE_UNIFORMS";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_OBJECT_ACTIVE_UNIFORMS_ARB";
#endif
            break;
        case 0x8b87:
#if defined(GL_VERSION_2_0)
                    return "GL_ACTIVE_UNIFORM_MAX_LENGTH";
#endif
#if defined(GL_ARB_shader_objects)
                    return "GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB";
#endif
            break;
        case 0x8b88:
#if defined(GL_ARB_shader_objects)
                    return "GL_OBJECT_SHADER_SOURCE_LENGTH_ARB";
#endif
#if defined(GL_VERSION_2_0)
                    return "GL_SHADER_SOURCE_LENGTH";
#endif
            break;
        case 0x8b89:
#if defined(GL_VERSION_2_0)
                    return "GL_ACTIVE_ATTRIBUTES";
#endif
#if defined(GL_ARB_vertex_shader)
                    return "GL_OBJECT_ACTIVE_ATTRIBUTES_ARB";
#endif
            break;
        case 0x8b8a:
#if defined(GL_VERSION_2_0)
                    return "GL_ACTIVE_ATTRIBUTE_MAX_LENGTH";
#endif
#if defined(GL_ARB_vertex_shader)
                    return "GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB";
#endif
            break;
        case 0x8b8b:
#if defined(GL_VERSION_2_0)
                    return "GL_FRAGMENT_SHADER_DERIVATIVE_HINT";
#endif
#if defined(GL_ARB_fragment_shader)
                    return "GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB";
#endif
            break;
        case 0x8b8c:
#if defined(GL_VERSION_2_0)
                    return "GL_SHADING_LANGUAGE_VERSION";
#endif
#if defined(GL_ARB_shading_language_100)
                    return "GL_SHADING_LANGUAGE_VERSION_ARB";
#endif
            break;
        case 0x8b8d:
#if defined(GL_EXT_separate_shader_objects)
                    return "GL_ACTIVE_PROGRAM_EXT";
#endif
#if defined(GL_VERSION_2_0)
                    return "GL_CURRENT_PROGRAM";
#endif
            break;
#if defined(GL_OES_compressed_paletted_texture)
        case 0x8b90: return "GL_PALETTE4_RGB8_OES";
        case 0x8b91: return "GL_PALETTE4_RGBA8_OES";
        case 0x8b92: return "GL_PALETTE4_R5_G6_B5_OES";
        case 0x8b93: return "GL_PALETTE4_RGBA4_OES";
        case 0x8b94: return "GL_PALETTE4_RGB5_A1_OES";
        case 0x8b95: return "GL_PALETTE8_RGB8_OES";
        case 0x8b96: return "GL_PALETTE8_RGBA8_OES";
        case 0x8b97: return "GL_PALETTE8_R5_G6_B5_OES";
        case 0x8b98: return "GL_PALETTE8_RGBA4_OES";
        case 0x8b99: return "GL_PALETTE8_RGB5_A1_OES";
#endif
        case 0x8b9a:
#if defined(GL_VERSION_4_1)
                    return "GL_IMPLEMENTATION_COLOR_READ_TYPE";
#endif
#if defined(GL_OES_read_format)
                    return "GL_IMPLEMENTATION_COLOR_READ_TYPE_OES";
#endif
            break;
        case 0x8b9b:
#if defined(GL_VERSION_4_1)
                    return "GL_IMPLEMENTATION_COLOR_READ_FORMAT";
#endif
#if defined(GL_OES_read_format)
                    return "GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES";
#endif
            break;
#if defined(GL_MESA_tile_raster_order)
        case 0x8bb8: return "GL_TILE_RASTER_ORDER_FIXED_MESA";
        case 0x8bb9: return "GL_TILE_RASTER_ORDER_INCREASING_X_MESA";
        case 0x8bba: return "GL_TILE_RASTER_ORDER_INCREASING_Y_MESA";
#endif
#if defined(GL_AMD_performance_monitor)
        case 0x8bc0: return "GL_COUNTER_TYPE_AMD";
        case 0x8bc1: return "GL_COUNTER_RANGE_AMD";
        case 0x8bc2: return "GL_UNSIGNED_INT64_AMD";
        case 0x8bc3: return "GL_PERCENTAGE_AMD";
        case 0x8bc4: return "GL_PERFMON_RESULT_AVAILABLE_AMD";
        case 0x8bc5: return "GL_PERFMON_RESULT_SIZE_AMD";
        case 0x8bc6: return "GL_PERFMON_RESULT_AMD";
#endif
        case 0x8c10:
#if defined(GL_VERSION_3_0)
                    return "GL_TEXTURE_RED_TYPE";
#endif
#if defined(GL_ARB_texture_float)
                    return "GL_TEXTURE_RED_TYPE_ARB";
#endif
            break;
        case 0x8c11:
#if defined(GL_VERSION_3_0)
                    return "GL_TEXTURE_GREEN_TYPE";
#endif
#if defined(GL_ARB_texture_float)
                    return "GL_TEXTURE_GREEN_TYPE_ARB";
#endif
            break;
        case 0x8c12:
#if defined(GL_VERSION_3_0)
                    return "GL_TEXTURE_BLUE_TYPE";
#endif
#if defined(GL_ARB_texture_float)
                    return "GL_TEXTURE_BLUE_TYPE_ARB";
#endif
            break;
        case 0x8c13:
#if defined(GL_VERSION_3_0)
                    return "GL_TEXTURE_ALPHA_TYPE";
#endif
#if defined(GL_ARB_texture_float)
                    return "GL_TEXTURE_ALPHA_TYPE_ARB";
#endif
            break;
        case 0x8c14:
#if defined(GL_VERSION_3_0)
                    return "GL_TEXTURE_LUMINANCE_TYPE";
#endif
#if defined(GL_ARB_texture_float)
                    return "GL_TEXTURE_LUMINANCE_TYPE_ARB";
#endif
            break;
        case 0x8c15:
#if defined(GL_VERSION_3_0)
                    return "GL_TEXTURE_INTENSITY_TYPE";
#endif
#if defined(GL_ARB_texture_float)
                    return "GL_TEXTURE_INTENSITY_TYPE_ARB";
#endif
            break;
        case 0x8c16:
#if defined(GL_VERSION_3_0)
                    return "GL_TEXTURE_DEPTH_TYPE";
#endif
#if defined(GL_ARB_texture_float)
                    return "GL_TEXTURE_DEPTH_TYPE_ARB";
#endif
            break;
        case 0x8c17:
#if defined(GL_VERSION_3_0)
                    return "GL_UNSIGNED_NORMALIZED";
#endif
#if defined(GL_ARB_texture_float)
                    return "GL_UNSIGNED_NORMALIZED_ARB";
#endif
            break;
        case 0x8c18:
#if defined(GL_VERSION_3_0)
                    return "GL_TEXTURE_1D_ARRAY";
#endif
#if defined(GL_EXT_texture_array)
                    return "GL_TEXTURE_1D_ARRAY_EXT";
#endif
            break;
        case 0x8c19:
#if defined(GL_VERSION_3_0)
                    return "GL_PROXY_TEXTURE_1D_ARRAY";
#endif
#if defined(GL_EXT_texture_array)
                    return "GL_PROXY_TEXTURE_1D_ARRAY_EXT";
#endif
            break;
        case 0x8c1a:
#if defined(GL_VERSION_3_0)
                    return "GL_TEXTURE_2D_ARRAY";
#endif
#if defined(GL_EXT_texture_array)
                    return "GL_TEXTURE_2D_ARRAY_EXT";
#endif
            break;
        case 0x8c1b:
#if defined(GL_VERSION_3_0)
                    return "GL_PROXY_TEXTURE_2D_ARRAY";
#endif
#if defined(GL_EXT_texture_array)
                    return "GL_PROXY_TEXTURE_2D_ARRAY_EXT";
#endif
            break;
        case 0x8c1c:
#if defined(GL_VERSION_3_0)
                    return "GL_TEXTURE_BINDING_1D_ARRAY";
#endif
#if defined(GL_EXT_texture_array)
                    return "GL_TEXTURE_BINDING_1D_ARRAY_EXT";
#endif
            break;
        case 0x8c1d:
#if defined(GL_VERSION_3_0)
                    return "GL_TEXTURE_BINDING_2D_ARRAY";
#endif
#if defined(GL_EXT_texture_array)
                    return "GL_TEXTURE_BINDING_2D_ARRAY_EXT";
#endif
            break;
#if defined(GL_NV_geometry_program4)
        case 0x8c26: return "GL_GEOMETRY_PROGRAM_NV";
        case 0x8c27: return "GL_MAX_PROGRAM_OUTPUT_VERTICES_NV";
        case 0x8c28: return "GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV";
#endif
        case 0x8c29:
#if defined(GL_VERSION_3_2)
                    return "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS";
#endif
#if defined(GL_ARB_geometry_shader4)
                    return "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT";
#endif
            break;
        case 0x8c2a:
#if defined(GL_VERSION_3_1)
                    return "GL_TEXTURE_BUFFER";
#endif
#if defined(GL_ARB_texture_buffer_object)
                    return "GL_TEXTURE_BUFFER_ARB";
#endif
#if defined(GL_VERSION_4_4)
                    return "GL_TEXTURE_BUFFER_BINDING";
#endif
#if defined(GL_EXT_texture_buffer_object)
                    return "GL_TEXTURE_BUFFER_EXT";
#endif
            break;
        case 0x8c2b:
#if defined(GL_VERSION_3_1)
                    return "GL_MAX_TEXTURE_BUFFER_SIZE";
#endif
#if defined(GL_ARB_texture_buffer_object)
                    return "GL_MAX_TEXTURE_BUFFER_SIZE_ARB";
#endif
#if defined(GL_EXT_texture_buffer_object)
                    return "GL_MAX_TEXTURE_BUFFER_SIZE_EXT";
#endif
            break;
        case 0x8c2c:
#if defined(GL_VERSION_3_1)
                    return "GL_TEXTURE_BINDING_BUFFER";
#endif
#if defined(GL_ARB_texture_buffer_object)
                    return "GL_TEXTURE_BINDING_BUFFER_ARB";
#endif
#if defined(GL_EXT_texture_buffer_object)
                    return "GL_TEXTURE_BINDING_BUFFER_EXT";
#endif
            break;
        case 0x8c2d:
#if defined(GL_VERSION_3_1)
                    return "GL_TEXTURE_BUFFER_DATA_STORE_BINDING";
#endif
#if defined(GL_ARB_texture_buffer_object)
                    return "GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB";
#endif
#if defined(GL_EXT_texture_buffer_object)
                    return "GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT";
#endif
            break;
        case 0x8c2e:
#if defined(GL_ARB_texture_buffer_object)
                    return "GL_TEXTURE_BUFFER_FORMAT_ARB";
#endif
#if defined(GL_EXT_texture_buffer_object)
                    return "GL_TEXTURE_BUFFER_FORMAT_EXT";
#endif
            break;
#if defined(GL_VERSION_3_3)
        case 0x8c2f: return "GL_ANY_SAMPLES_PASSED";
#endif
        case 0x8c36:
#if defined(GL_VERSION_4_0)
                    return "GL_SAMPLE_SHADING";
#endif
#if defined(GL_ARB_sample_shading)
                    return "GL_SAMPLE_SHADING_ARB";
#endif
            break;
        case 0x8c37:
#if defined(GL_VERSION_4_0)
                    return "GL_MIN_SAMPLE_SHADING_VALUE";
#endif
#if defined(GL_ARB_sample_shading)
                    return "GL_MIN_SAMPLE_SHADING_VALUE_ARB";
#endif
            break;
        case 0x8c3a:
#if defined(GL_VERSION_3_0)
                    return "GL_R11F_G11F_B10F";
#endif
#if defined(GL_EXT_packed_float)
                    return "GL_R11F_G11F_B10F_EXT";
#endif
            break;
        case 0x8c3b:
#if defined(GL_VERSION_3_0)
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
#endif
#if defined(GL_EXT_packed_float)
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV_EXT";
#endif
            break;
#if defined(GL_EXT_packed_float)
        case 0x8c3c: return "GL_RGBA_SIGNED_COMPONENTS_EXT";
#endif
        case 0x8c3d:
#if defined(GL_VERSION_3_0)
                    return "GL_RGB9_E5";
#endif
#if defined(GL_EXT_texture_shared_exponent)
                    return "GL_RGB9_E5_EXT";
#endif
            break;
        case 0x8c3e:
#if defined(GL_VERSION_3_0)
                    return "GL_UNSIGNED_INT_5_9_9_9_REV";
#endif
#if defined(GL_EXT_texture_shared_exponent)
                    return "GL_UNSIGNED_INT_5_9_9_9_REV_EXT";
#endif
            break;
        case 0x8c3f:
#if defined(GL_VERSION_3_0)
                    return "GL_TEXTURE_SHARED_SIZE";
#endif
#if defined(GL_EXT_texture_shared_exponent)
                    return "GL_TEXTURE_SHARED_SIZE_EXT";
#endif
            break;
        case 0x8c40:
#if defined(GL_VERSION_2_1)
                    return "GL_SRGB";
#endif
#if defined(GL_EXT_texture_sRGB)
                    return "GL_SRGB_EXT";
#endif
            break;
        case 0x8c41:
#if defined(GL_VERSION_2_1)
                    return "GL_SRGB8";
#endif
#if defined(GL_EXT_texture_sRGB)
                    return "GL_SRGB8_EXT";
#endif
            break;
        case 0x8c42:
#if defined(GL_VERSION_2_1)
                    return "GL_SRGB_ALPHA";
#endif
#if defined(GL_EXT_texture_sRGB)
                    return "GL_SRGB_ALPHA_EXT";
#endif
            break;
        case 0x8c43:
#if defined(GL_VERSION_2_1)
                    return "GL_SRGB8_ALPHA8";
#endif
#if defined(GL_EXT_texture_sRGB)
                    return "GL_SRGB8_ALPHA8_EXT";
#endif
            break;
        case 0x8c44:
#if defined(GL_VERSION_2_1)
                    return "GL_SLUMINANCE_ALPHA";
#endif
#if defined(GL_EXT_texture_sRGB)
                    return "GL_SLUMINANCE_ALPHA_EXT";
#endif
            break;
        case 0x8c45:
#if defined(GL_VERSION_2_1)
                    return "GL_SLUMINANCE8_ALPHA8";
#endif
#if defined(GL_EXT_texture_sRGB)
                    return "GL_SLUMINANCE8_ALPHA8_EXT";
#endif
            break;
        case 0x8c46:
#if defined(GL_VERSION_2_1)
                    return "GL_SLUMINANCE";
#endif
#if defined(GL_EXT_texture_sRGB)
                    return "GL_SLUMINANCE_EXT";
#endif
            break;
        case 0x8c47:
#if defined(GL_VERSION_2_1)
                    return "GL_SLUMINANCE8";
#endif
#if defined(GL_EXT_texture_sRGB)
                    return "GL_SLUMINANCE8_EXT";
#endif
            break;
        case 0x8c48:
#if defined(GL_VERSION_2_1)
                    return "GL_COMPRESSED_SRGB";
#endif
#if defined(GL_EXT_texture_sRGB)
                    return "GL_COMPRESSED_SRGB_EXT";
#endif
            break;
        case 0x8c49:
#if defined(GL_VERSION_2_1)
                    return "GL_COMPRESSED_SRGB_ALPHA";
#endif
#if defined(GL_EXT_texture_sRGB)
                    return "GL_COMPRESSED_SRGB_ALPHA_EXT";
#endif
            break;
        case 0x8c4a:
#if defined(GL_VERSION_2_1)
                    return "GL_COMPRESSED_SLUMINANCE";
#endif
#if defined(GL_EXT_texture_sRGB)
                    return "GL_COMPRESSED_SLUMINANCE_EXT";
#endif
            break;
        case 0x8c4b:
#if defined(GL_VERSION_2_1)
                    return "GL_COMPRESSED_SLUMINANCE_ALPHA";
#endif
#if defined(GL_EXT_texture_sRGB)
                    return "GL_COMPRESSED_SLUMINANCE_ALPHA_EXT";
#endif
            break;
#if defined(GL_EXT_texture_sRGB)
        case 0x8c4c: return "GL_COMPRESSED_SRGB_S3TC_DXT1_EXT";
        case 0x8c4d: return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT";
        case 0x8c4e: return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT";
        case 0x8c4f: return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT";
#endif
#if defined(GL_EXT_texture_compression_latc)
        case 0x8c70: return "GL_COMPRESSED_LUMINANCE_LATC1_EXT";
        case 0x8c71: return "GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT";
        case 0x8c72: return "GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT";
        case 0x8c73: return "GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT";
#endif
#if defined(GL_NV_tessellation_program5)
        case 0x8c74: return "GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV";
        case 0x8c75: return "GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV";
#endif
        case 0x8c76:
#if defined(GL_VERSION_3_0)
                    return "GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT";
#endif
            break;
#if defined(GL_NV_transform_feedback)
        case 0x8c77: return "GL_BACK_PRIMARY_COLOR_NV";
        case 0x8c78: return "GL_BACK_SECONDARY_COLOR_NV";
        case 0x8c79: return "GL_TEXTURE_COORD_NV";
        case 0x8c7a: return "GL_CLIP_DISTANCE_NV";
        case 0x8c7b: return "GL_VERTEX_ID_NV";
        case 0x8c7c: return "GL_PRIMITIVE_ID_NV";
        case 0x8c7d: return "GL_GENERIC_ATTRIB_NV";
        case 0x8c7e: return "GL_TRANSFORM_FEEDBACK_ATTRIBS_NV";
#endif
        case 0x8c7f:
#if defined(GL_VERSION_3_0)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_MODE";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT";
#endif
#if defined(GL_NV_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV";
#endif
            break;
        case 0x8c80:
#if defined(GL_VERSION_3_0)
                    return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT";
#endif
#if defined(GL_NV_transform_feedback)
                    return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV";
#endif
            break;
#if defined(GL_NV_transform_feedback)
        case 0x8c81: return "GL_ACTIVE_VARYINGS_NV";
        case 0x8c82: return "GL_ACTIVE_VARYING_MAX_LENGTH_NV";
#endif
        case 0x8c83:
#if defined(GL_VERSION_3_0)
                    return "GL_TRANSFORM_FEEDBACK_VARYINGS";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_VARYINGS_EXT";
#endif
#if defined(GL_NV_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_VARYINGS_NV";
#endif
            break;
        case 0x8c84:
#if defined(GL_VERSION_3_0)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_START";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT";
#endif
#if defined(GL_NV_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_START_NV";
#endif
            break;
        case 0x8c85:
#if defined(GL_VERSION_3_0)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT";
#endif
#if defined(GL_NV_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV";
#endif
            break;
#if defined(GL_NV_transform_feedback)
        case 0x8c86: return "GL_TRANSFORM_FEEDBACK_RECORD_NV";
#endif
        case 0x8c87:
#if defined(GL_VERSION_3_0)
                    return "GL_PRIMITIVES_GENERATED";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_PRIMITIVES_GENERATED_EXT";
#endif
#if defined(GL_NV_transform_feedback)
                    return "GL_PRIMITIVES_GENERATED_NV";
#endif
            break;
        case 0x8c88:
#if defined(GL_VERSION_3_0)
                    return "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT";
#endif
#if defined(GL_NV_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV";
#endif
            break;
        case 0x8c89:
#if defined(GL_VERSION_3_0)
                    return "GL_RASTERIZER_DISCARD";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_RASTERIZER_DISCARD_EXT";
#endif
#if defined(GL_NV_transform_feedback)
                    return "GL_RASTERIZER_DISCARD_NV";
#endif
            break;
        case 0x8c8a:
#if defined(GL_VERSION_3_0)
                    return "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT";
#endif
#if defined(GL_NV_transform_feedback)
                    return "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV";
#endif
            break;
        case 0x8c8b:
#if defined(GL_VERSION_3_0)
                    return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT";
#endif
#if defined(GL_NV_transform_feedback)
                    return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV";
#endif
            break;
        case 0x8c8c:
#if defined(GL_VERSION_3_0)
                    return "GL_INTERLEAVED_ATTRIBS";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_INTERLEAVED_ATTRIBS_EXT";
#endif
#if defined(GL_NV_transform_feedback)
                    return "GL_INTERLEAVED_ATTRIBS_NV";
#endif
            break;
        case 0x8c8d:
#if defined(GL_VERSION_3_0)
                    return "GL_SEPARATE_ATTRIBS";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_SEPARATE_ATTRIBS_EXT";
#endif
#if defined(GL_NV_transform_feedback)
                    return "GL_SEPARATE_ATTRIBS_NV";
#endif
            break;
        case 0x8c8e:
#if defined(GL_VERSION_3_0)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_EXT";
#endif
#if defined(GL_NV_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_NV";
#endif
            break;
        case 0x8c8f:
#if defined(GL_VERSION_3_0)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING";
#endif
#if defined(GL_EXT_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT";
#endif
#if defined(GL_NV_transform_feedback)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV";
#endif
            break;
#if defined(GL_VERSION_2_0)
        case 0x8ca0: return "GL_POINT_SPRITE_COORD_ORIGIN";
        case 0x8ca1: return "GL_LOWER_LEFT";
        case 0x8ca2: return "GL_UPPER_LEFT";
        case 0x8ca3: return "GL_STENCIL_BACK_REF";
        case 0x8ca4: return "GL_STENCIL_BACK_VALUE_MASK";
        case 0x8ca5: return "GL_STENCIL_BACK_WRITEMASK";
#endif
        case 0x8ca6:
#if defined(GL_VERSION_3_0)
                    return "GL_DRAW_FRAMEBUFFER_BINDING";
#endif
#if defined(GL_EXT_framebuffer_blit)
                    return "GL_DRAW_FRAMEBUFFER_BINDING_EXT";
#endif
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER_BINDING";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_FRAMEBUFFER_BINDING_EXT";
#endif
            break;
        case 0x8ca7:
#if defined(GL_VERSION_3_0)
                    return "GL_RENDERBUFFER_BINDING";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_RENDERBUFFER_BINDING_EXT";
#endif
            break;
        case 0x8ca8:
#if defined(GL_VERSION_3_0)
                    return "GL_READ_FRAMEBUFFER";
#endif
#if defined(GL_EXT_framebuffer_blit)
                    return "GL_READ_FRAMEBUFFER_EXT";
#endif
            break;
        case 0x8ca9:
#if defined(GL_VERSION_3_0)
                    return "GL_DRAW_FRAMEBUFFER";
#endif
#if defined(GL_EXT_framebuffer_blit)
                    return "GL_DRAW_FRAMEBUFFER_EXT";
#endif
            break;
        case 0x8caa:
#if defined(GL_VERSION_3_0)
                    return "GL_READ_FRAMEBUFFER_BINDING";
#endif
#if defined(GL_EXT_framebuffer_blit)
                    return "GL_READ_FRAMEBUFFER_BINDING_EXT";
#endif
            break;
        case 0x8cab:
#if defined(GL_NV_framebuffer_multisample_coverage)
                    return "GL_RENDERBUFFER_COVERAGE_SAMPLES_NV";
#endif
#if defined(GL_VERSION_3_0)
                    return "GL_RENDERBUFFER_SAMPLES";
#endif
#if defined(GL_EXT_framebuffer_multisample)
                    return "GL_RENDERBUFFER_SAMPLES_EXT";
#endif
            break;
#if defined(GL_VERSION_3_0)
        case 0x8cac: return "GL_DEPTH_COMPONENT32F";
        case 0x8cad: return "GL_DEPTH32F_STENCIL8";
#endif
        case 0x8cd0:
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT";
#endif
            break;
        case 0x8cd1:
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT";
#endif
            break;
        case 0x8cd2:
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT";
#endif
            break;
        case 0x8cd3:
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT";
#endif
            break;
        case 0x8cd4:
#if defined(GL_EXT_framebuffer_object)
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT";
#endif
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT";
#endif
            break;
        case 0x8cd5:
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER_COMPLETE";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_FRAMEBUFFER_COMPLETE_EXT";
#endif
            break;
        case 0x8cd6:
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT";
#endif
            break;
        case 0x8cd7:
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT";
#endif
            break;
#if defined(GL_EXT_framebuffer_object)
        case 0x8cd9: return "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT";
        case 0x8cda: return "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT";
#endif
        case 0x8cdb:
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT";
#endif
            break;
        case 0x8cdc:
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT";
#endif
            break;
        case 0x8cdd:
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER_UNSUPPORTED";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_FRAMEBUFFER_UNSUPPORTED_EXT";
#endif
            break;
        case 0x8cdf:
#if defined(GL_VERSION_3_0)
                    return "GL_MAX_COLOR_ATTACHMENTS";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_MAX_COLOR_ATTACHMENTS_EXT";
#endif
            break;
        case 0x8ce0:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT0";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT0_EXT";
#endif
            break;
        case 0x8ce1:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT1";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT1_EXT";
#endif
            break;
        case 0x8ce2:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT2";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT2_EXT";
#endif
            break;
        case 0x8ce3:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT3";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT3_EXT";
#endif
            break;
        case 0x8ce4:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT4";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT4_EXT";
#endif
            break;
        case 0x8ce5:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT5";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT5_EXT";
#endif
            break;
        case 0x8ce6:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT6";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT6_EXT";
#endif
            break;
        case 0x8ce7:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT7";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT7_EXT";
#endif
            break;
        case 0x8ce8:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT8";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT8_EXT";
#endif
            break;
        case 0x8ce9:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT9";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT9_EXT";
#endif
            break;
        case 0x8cea:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT10";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT10_EXT";
#endif
            break;
        case 0x8ceb:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT11";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT11_EXT";
#endif
            break;
        case 0x8cec:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT12";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT12_EXT";
#endif
            break;
        case 0x8ced:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT13";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT13_EXT";
#endif
            break;
        case 0x8cee:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT14";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT14_EXT";
#endif
            break;
        case 0x8cef:
#if defined(GL_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT15";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_COLOR_ATTACHMENT15_EXT";
#endif
            break;
#if defined(GL_VERSION_3_0)
        case 0x8cf0: return "GL_COLOR_ATTACHMENT16";
        case 0x8cf1: return "GL_COLOR_ATTACHMENT17";
        case 0x8cf2: return "GL_COLOR_ATTACHMENT18";
        case 0x8cf3: return "GL_COLOR_ATTACHMENT19";
        case 0x8cf4: return "GL_COLOR_ATTACHMENT20";
        case 0x8cf5: return "GL_COLOR_ATTACHMENT21";
        case 0x8cf6: return "GL_COLOR_ATTACHMENT22";
        case 0x8cf7: return "GL_COLOR_ATTACHMENT23";
        case 0x8cf8: return "GL_COLOR_ATTACHMENT24";
        case 0x8cf9: return "GL_COLOR_ATTACHMENT25";
        case 0x8cfa: return "GL_COLOR_ATTACHMENT26";
        case 0x8cfb: return "GL_COLOR_ATTACHMENT27";
        case 0x8cfc: return "GL_COLOR_ATTACHMENT28";
        case 0x8cfd: return "GL_COLOR_ATTACHMENT29";
        case 0x8cfe: return "GL_COLOR_ATTACHMENT30";
        case 0x8cff: return "GL_COLOR_ATTACHMENT31";
#endif
        case 0x8d00:
#if defined(GL_VERSION_3_0)
                    return "GL_DEPTH_ATTACHMENT";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_DEPTH_ATTACHMENT_EXT";
#endif
            break;
        case 0x8d20:
#if defined(GL_VERSION_3_0)
                    return "GL_STENCIL_ATTACHMENT";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_STENCIL_ATTACHMENT_EXT";
#endif
            break;
        case 0x8d40:
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_FRAMEBUFFER_EXT";
#endif
            break;
        case 0x8d41:
#if defined(GL_VERSION_3_0)
                    return "GL_RENDERBUFFER";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_RENDERBUFFER_EXT";
#endif
            break;
        case 0x8d42:
#if defined(GL_VERSION_3_0)
                    return "GL_RENDERBUFFER_WIDTH";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_RENDERBUFFER_WIDTH_EXT";
#endif
            break;
        case 0x8d43:
#if defined(GL_VERSION_3_0)
                    return "GL_RENDERBUFFER_HEIGHT";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_RENDERBUFFER_HEIGHT_EXT";
#endif
            break;
        case 0x8d44:
#if defined(GL_VERSION_3_0)
                    return "GL_RENDERBUFFER_INTERNAL_FORMAT";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_RENDERBUFFER_INTERNAL_FORMAT_EXT";
#endif
            break;
        case 0x8d46:
#if defined(GL_VERSION_3_0)
                    return "GL_STENCIL_INDEX1";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_STENCIL_INDEX1_EXT";
#endif
            break;
        case 0x8d47:
#if defined(GL_VERSION_3_0)
                    return "GL_STENCIL_INDEX4";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_STENCIL_INDEX4_EXT";
#endif
            break;
        case 0x8d48:
#if defined(GL_VERSION_3_0)
                    return "GL_STENCIL_INDEX8";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_STENCIL_INDEX8_EXT";
#endif
            break;
        case 0x8d49:
#if defined(GL_VERSION_3_0)
                    return "GL_STENCIL_INDEX16";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_STENCIL_INDEX16_EXT";
#endif
            break;
        case 0x8d50:
#if defined(GL_VERSION_3_0)
                    return "GL_RENDERBUFFER_RED_SIZE";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_RENDERBUFFER_RED_SIZE_EXT";
#endif
            break;
        case 0x8d51:
#if defined(GL_VERSION_3_0)
                    return "GL_RENDERBUFFER_GREEN_SIZE";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_RENDERBUFFER_GREEN_SIZE_EXT";
#endif
            break;
        case 0x8d52:
#if defined(GL_VERSION_3_0)
                    return "GL_RENDERBUFFER_BLUE_SIZE";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_RENDERBUFFER_BLUE_SIZE_EXT";
#endif
            break;
        case 0x8d53:
#if defined(GL_VERSION_3_0)
                    return "GL_RENDERBUFFER_ALPHA_SIZE";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_RENDERBUFFER_ALPHA_SIZE_EXT";
#endif
            break;
        case 0x8d54:
#if defined(GL_VERSION_3_0)
                    return "GL_RENDERBUFFER_DEPTH_SIZE";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_RENDERBUFFER_DEPTH_SIZE_EXT";
#endif
            break;
        case 0x8d55:
#if defined(GL_VERSION_3_0)
                    return "GL_RENDERBUFFER_STENCIL_SIZE";
#endif
#if defined(GL_EXT_framebuffer_object)
                    return "GL_RENDERBUFFER_STENCIL_SIZE_EXT";
#endif
            break;
        case 0x8d56:
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE";
#endif
#if defined(GL_EXT_framebuffer_multisample)
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT";
#endif
            break;
        case 0x8d57:
#if defined(GL_VERSION_3_0)
                    return "GL_MAX_SAMPLES";
#endif
#if defined(GL_EXT_framebuffer_multisample)
                    return "GL_MAX_SAMPLES_EXT";
#endif
            break;
#if defined(GL_VERSION_4_1)
        case 0x8d62: return "GL_RGB565";
#endif
#if defined(GL_VERSION_4_3)
        case 0x8d69: return "GL_PRIMITIVE_RESTART_FIXED_INDEX";
        case 0x8d6a: return "GL_ANY_SAMPLES_PASSED_CONSERVATIVE";
        case 0x8d6b: return "GL_MAX_ELEMENT_INDEX";
#endif
        case 0x8d70:
#if defined(GL_VERSION_3_0)
                    return "GL_RGBA32UI";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RGBA32UI_EXT";
#endif
            break;
        case 0x8d71:
#if defined(GL_VERSION_3_0)
                    return "GL_RGB32UI";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RGB32UI_EXT";
#endif
            break;
#if defined(GL_EXT_texture_integer)
        case 0x8d72: return "GL_ALPHA32UI_EXT";
        case 0x8d73: return "GL_INTENSITY32UI_EXT";
        case 0x8d74: return "GL_LUMINANCE32UI_EXT";
        case 0x8d75: return "GL_LUMINANCE_ALPHA32UI_EXT";
#endif
        case 0x8d76:
#if defined(GL_VERSION_3_0)
                    return "GL_RGBA16UI";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RGBA16UI_EXT";
#endif
            break;
        case 0x8d77:
#if defined(GL_VERSION_3_0)
                    return "GL_RGB16UI";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RGB16UI_EXT";
#endif
            break;
#if defined(GL_EXT_texture_integer)
        case 0x8d78: return "GL_ALPHA16UI_EXT";
        case 0x8d79: return "GL_INTENSITY16UI_EXT";
        case 0x8d7a: return "GL_LUMINANCE16UI_EXT";
        case 0x8d7b: return "GL_LUMINANCE_ALPHA16UI_EXT";
#endif
        case 0x8d7c:
#if defined(GL_VERSION_3_0)
                    return "GL_RGBA8UI";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RGBA8UI_EXT";
#endif
            break;
        case 0x8d7d:
#if defined(GL_VERSION_3_0)
                    return "GL_RGB8UI";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RGB8UI_EXT";
#endif
            break;
#if defined(GL_EXT_texture_integer)
        case 0x8d7e: return "GL_ALPHA8UI_EXT";
        case 0x8d7f: return "GL_INTENSITY8UI_EXT";
        case 0x8d80: return "GL_LUMINANCE8UI_EXT";
        case 0x8d81: return "GL_LUMINANCE_ALPHA8UI_EXT";
#endif
        case 0x8d82:
#if defined(GL_VERSION_3_0)
                    return "GL_RGBA32I";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RGBA32I_EXT";
#endif
            break;
        case 0x8d83:
#if defined(GL_VERSION_3_0)
                    return "GL_RGB32I";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RGB32I_EXT";
#endif
            break;
#if defined(GL_EXT_texture_integer)
        case 0x8d84: return "GL_ALPHA32I_EXT";
        case 0x8d85: return "GL_INTENSITY32I_EXT";
        case 0x8d86: return "GL_LUMINANCE32I_EXT";
        case 0x8d87: return "GL_LUMINANCE_ALPHA32I_EXT";
#endif
        case 0x8d88:
#if defined(GL_VERSION_3_0)
                    return "GL_RGBA16I";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RGBA16I_EXT";
#endif
            break;
        case 0x8d89:
#if defined(GL_VERSION_3_0)
                    return "GL_RGB16I";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RGB16I_EXT";
#endif
            break;
#if defined(GL_EXT_texture_integer)
        case 0x8d8a: return "GL_ALPHA16I_EXT";
        case 0x8d8b: return "GL_INTENSITY16I_EXT";
        case 0x8d8c: return "GL_LUMINANCE16I_EXT";
        case 0x8d8d: return "GL_LUMINANCE_ALPHA16I_EXT";
#endif
        case 0x8d8e:
#if defined(GL_VERSION_3_0)
                    return "GL_RGBA8I";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RGBA8I_EXT";
#endif
            break;
        case 0x8d8f:
#if defined(GL_VERSION_3_0)
                    return "GL_RGB8I";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RGB8I_EXT";
#endif
            break;
#if defined(GL_EXT_texture_integer)
        case 0x8d90: return "GL_ALPHA8I_EXT";
        case 0x8d91: return "GL_INTENSITY8I_EXT";
        case 0x8d92: return "GL_LUMINANCE8I_EXT";
        case 0x8d93: return "GL_LUMINANCE_ALPHA8I_EXT";
#endif
        case 0x8d94:
#if defined(GL_VERSION_3_0)
                    return "GL_RED_INTEGER";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RED_INTEGER_EXT";
#endif
            break;
        case 0x8d95:
#if defined(GL_VERSION_3_0)
                    return "GL_GREEN_INTEGER";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_GREEN_INTEGER_EXT";
#endif
            break;
        case 0x8d96:
#if defined(GL_VERSION_3_0)
                    return "GL_BLUE_INTEGER";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_BLUE_INTEGER_EXT";
#endif
            break;
        case 0x8d97:
#if defined(GL_VERSION_3_0)
                    return "GL_ALPHA_INTEGER";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_ALPHA_INTEGER_EXT";
#endif
            break;
        case 0x8d98:
#if defined(GL_VERSION_3_0)
                    return "GL_RGB_INTEGER";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RGB_INTEGER_EXT";
#endif
            break;
        case 0x8d99:
#if defined(GL_VERSION_3_0)
                    return "GL_RGBA_INTEGER";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_RGBA_INTEGER_EXT";
#endif
            break;
        case 0x8d9a:
#if defined(GL_VERSION_3_0)
                    return "GL_BGR_INTEGER";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_BGR_INTEGER_EXT";
#endif
            break;
        case 0x8d9b:
#if defined(GL_VERSION_3_0)
                    return "GL_BGRA_INTEGER";
#endif
#if defined(GL_EXT_texture_integer)
                    return "GL_BGRA_INTEGER_EXT";
#endif
            break;
#if defined(GL_EXT_texture_integer)
        case 0x8d9c: return "GL_LUMINANCE_INTEGER_EXT";
        case 0x8d9d: return "GL_LUMINANCE_ALPHA_INTEGER_EXT";
        case 0x8d9e: return "GL_RGBA_INTEGER_MODE_EXT";
#endif
#if defined(GL_VERSION_3_3)
        case 0x8d9f: return "GL_INT_2_10_10_10_REV";
#endif
#if defined(GL_NV_parameter_buffer_object)
        case 0x8da0: return "GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV";
        case 0x8da1: return "GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV";
        case 0x8da2: return "GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV";
        case 0x8da3: return "GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV";
        case 0x8da4: return "GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV";
#endif
#if defined(GL_NV_gpu_program4)
        case 0x8da5: return "GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV";
        case 0x8da6: return "GL_MAX_PROGRAM_GENERIC_RESULTS_NV";
#endif
        case 0x8da7:
#if defined(GL_VERSION_3_2)
                    return "GL_FRAMEBUFFER_ATTACHMENT_LAYERED";
#endif
#if defined(GL_ARB_geometry_shader4)
                    return "GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT";
#endif
            break;
        case 0x8da8:
#if defined(GL_VERSION_3_2)
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS";
#endif
#if defined(GL_ARB_geometry_shader4)
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT";
#endif
            break;
        case 0x8da9:
#if defined(GL_ARB_geometry_shader4)
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT";
#endif
            break;
#if defined(GL_NV_transform_feedback)
        case 0x8daa: return "GL_LAYER_NV";
#endif
#if defined(GL_NV_depth_buffer_float)
        case 0x8dab: return "GL_DEPTH_COMPONENT32F_NV";
        case 0x8dac: return "GL_DEPTH32F_STENCIL8_NV";
#endif
        case 0x8dad:
#if defined(GL_VERSION_3_0)
                    return "GL_FLOAT_32_UNSIGNED_INT_24_8_REV";
#endif
#if defined(GL_NV_depth_buffer_float)
                    return "GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV";
#endif
            break;
#if defined(GL_ARB_shading_language_include)
        case 0x8dae: return "GL_SHADER_INCLUDE_ARB";
#endif
#if defined(GL_NV_depth_buffer_float)
        case 0x8daf: return "GL_DEPTH_BUFFER_FLOAT_MODE_NV";
#endif
        case 0x8db9:
#if defined(GL_VERSION_3_0)
                    return "GL_FRAMEBUFFER_SRGB";
#endif
#if defined(GL_EXT_framebuffer_sRGB)
                    return "GL_FRAMEBUFFER_SRGB_EXT";
#endif
            break;
#if defined(GL_EXT_framebuffer_sRGB)
        case 0x8dba: return "GL_FRAMEBUFFER_SRGB_CAPABLE_EXT";
#endif
        case 0x8dbb:
#if defined(GL_VERSION_3_0)
                    return "GL_COMPRESSED_RED_RGTC1";
#endif
#if defined(GL_EXT_texture_compression_rgtc)
                    return "GL_COMPRESSED_RED_RGTC1_EXT";
#endif
            break;
        case 0x8dbc:
#if defined(GL_VERSION_3_0)
                    return "GL_COMPRESSED_SIGNED_RED_RGTC1";
#endif
#if defined(GL_EXT_texture_compression_rgtc)
                    return "GL_COMPRESSED_SIGNED_RED_RGTC1_EXT";
#endif
            break;
        case 0x8dbd:
#if defined(GL_EXT_texture_compression_rgtc)
                    return "GL_COMPRESSED_RED_GREEN_RGTC2_EXT";
#endif
#if defined(GL_VERSION_3_0)
                    return "GL_COMPRESSED_RG_RGTC2";
#endif
            break;
        case 0x8dbe:
#if defined(GL_EXT_texture_compression_rgtc)
                    return "GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT";
#endif
#if defined(GL_VERSION_3_0)
                    return "GL_COMPRESSED_SIGNED_RG_RGTC2";
#endif
            break;
        case 0x8dc0:
#if defined(GL_VERSION_3_0)
                    return "GL_SAMPLER_1D_ARRAY";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_SAMPLER_1D_ARRAY_EXT";
#endif
            break;
        case 0x8dc1:
#if defined(GL_VERSION_3_0)
                    return "GL_SAMPLER_2D_ARRAY";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_SAMPLER_2D_ARRAY_EXT";
#endif
            break;
        case 0x8dc2:
#if defined(GL_VERSION_3_1)
                    return "GL_SAMPLER_BUFFER";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_SAMPLER_BUFFER_EXT";
#endif
            break;
        case 0x8dc3:
#if defined(GL_VERSION_3_0)
                    return "GL_SAMPLER_1D_ARRAY_SHADOW";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_SAMPLER_1D_ARRAY_SHADOW_EXT";
#endif
            break;
        case 0x8dc4:
#if defined(GL_VERSION_3_0)
                    return "GL_SAMPLER_2D_ARRAY_SHADOW";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_SAMPLER_2D_ARRAY_SHADOW_EXT";
#endif
            break;
        case 0x8dc5:
#if defined(GL_VERSION_3_0)
                    return "GL_SAMPLER_CUBE_SHADOW";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_SAMPLER_CUBE_SHADOW_EXT";
#endif
            break;
        case 0x8dc6:
#if defined(GL_VERSION_3_0)
                    return "GL_UNSIGNED_INT_VEC2";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_UNSIGNED_INT_VEC2_EXT";
#endif
            break;
        case 0x8dc7:
#if defined(GL_VERSION_3_0)
                    return "GL_UNSIGNED_INT_VEC3";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_UNSIGNED_INT_VEC3_EXT";
#endif
            break;
        case 0x8dc8:
#if defined(GL_VERSION_3_0)
                    return "GL_UNSIGNED_INT_VEC4";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_UNSIGNED_INT_VEC4_EXT";
#endif
            break;
        case 0x8dc9:
#if defined(GL_VERSION_3_0)
                    return "GL_INT_SAMPLER_1D";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_INT_SAMPLER_1D_EXT";
#endif
            break;
        case 0x8dca:
#if defined(GL_VERSION_3_0)
                    return "GL_INT_SAMPLER_2D";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_INT_SAMPLER_2D_EXT";
#endif
            break;
        case 0x8dcb:
#if defined(GL_VERSION_3_0)
                    return "GL_INT_SAMPLER_3D";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_INT_SAMPLER_3D_EXT";
#endif
            break;
        case 0x8dcc:
#if defined(GL_VERSION_3_0)
                    return "GL_INT_SAMPLER_CUBE";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_INT_SAMPLER_CUBE_EXT";
#endif
            break;
        case 0x8dcd:
#if defined(GL_VERSION_3_1)
                    return "GL_INT_SAMPLER_2D_RECT";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_INT_SAMPLER_2D_RECT_EXT";
#endif
            break;
        case 0x8dce:
#if defined(GL_VERSION_3_0)
                    return "GL_INT_SAMPLER_1D_ARRAY";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_INT_SAMPLER_1D_ARRAY_EXT";
#endif
            break;
        case 0x8dcf:
#if defined(GL_VERSION_3_0)
                    return "GL_INT_SAMPLER_2D_ARRAY";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_INT_SAMPLER_2D_ARRAY_EXT";
#endif
            break;
        case 0x8dd0:
#if defined(GL_VERSION_3_1)
                    return "GL_INT_SAMPLER_BUFFER";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_INT_SAMPLER_BUFFER_EXT";
#endif
            break;
        case 0x8dd1:
#if defined(GL_VERSION_3_0)
                    return "GL_UNSIGNED_INT_SAMPLER_1D";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_UNSIGNED_INT_SAMPLER_1D_EXT";
#endif
            break;
        case 0x8dd2:
#if defined(GL_VERSION_3_0)
                    return "GL_UNSIGNED_INT_SAMPLER_2D";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_UNSIGNED_INT_SAMPLER_2D_EXT";
#endif
            break;
        case 0x8dd3:
#if defined(GL_VERSION_3_0)
                    return "GL_UNSIGNED_INT_SAMPLER_3D";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_UNSIGNED_INT_SAMPLER_3D_EXT";
#endif
            break;
        case 0x8dd4:
#if defined(GL_VERSION_3_0)
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE_EXT";
#endif
            break;
        case 0x8dd5:
#if defined(GL_VERSION_3_1)
                    return "GL_UNSIGNED_INT_SAMPLER_2D_RECT";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT";
#endif
            break;
        case 0x8dd6:
#if defined(GL_VERSION_3_0)
                    return "GL_UNSIGNED_INT_SAMPLER_1D_ARRAY";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT";
#endif
            break;
        case 0x8dd7:
#if defined(GL_VERSION_3_0)
                    return "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT";
#endif
            break;
        case 0x8dd8:
#if defined(GL_VERSION_3_1)
                    return "GL_UNSIGNED_INT_SAMPLER_BUFFER";
#endif
#if defined(GL_EXT_gpu_shader4)
                    return "GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT";
#endif
            break;
        case 0x8dd9:
#if defined(GL_VERSION_3_2)
                    return "GL_GEOMETRY_SHADER";
#endif
#if defined(GL_ARB_geometry_shader4)
                    return "GL_GEOMETRY_SHADER_ARB";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_GEOMETRY_SHADER_EXT";
#endif
            break;
        case 0x8dda:
#if defined(GL_ARB_geometry_shader4)
                    return "GL_GEOMETRY_VERTICES_OUT_ARB";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_GEOMETRY_VERTICES_OUT_EXT";
#endif
            break;
        case 0x8ddb:
#if defined(GL_ARB_geometry_shader4)
                    return "GL_GEOMETRY_INPUT_TYPE_ARB";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_GEOMETRY_INPUT_TYPE_EXT";
#endif
            break;
        case 0x8ddc:
#if defined(GL_ARB_geometry_shader4)
                    return "GL_GEOMETRY_OUTPUT_TYPE_ARB";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_GEOMETRY_OUTPUT_TYPE_EXT";
#endif
            break;
        case 0x8ddd:
#if defined(GL_ARB_geometry_shader4)
                    return "GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT";
#endif
            break;
        case 0x8dde:
#if defined(GL_ARB_geometry_shader4)
                    return "GL_MAX_VERTEX_VARYING_COMPONENTS_ARB";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_MAX_VERTEX_VARYING_COMPONENTS_EXT";
#endif
            break;
        case 0x8ddf:
#if defined(GL_VERSION_3_2)
                    return "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS";
#endif
#if defined(GL_ARB_geometry_shader4)
                    return "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT";
#endif
            break;
        case 0x8de0:
#if defined(GL_VERSION_3_2)
                    return "GL_MAX_GEOMETRY_OUTPUT_VERTICES";
#endif
#if defined(GL_ARB_geometry_shader4)
                    return "GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT";
#endif
            break;
        case 0x8de1:
#if defined(GL_VERSION_3_2)
                    return "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS";
#endif
#if defined(GL_ARB_geometry_shader4)
                    return "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB";
#endif
#if defined(GL_EXT_geometry_shader4)
                    return "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT";
#endif
            break;
#if defined(GL_EXT_bindable_uniform)
        case 0x8de2: return "GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT";
        case 0x8de3: return "GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT";
        case 0x8de4: return "GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT";
#endif
#if defined(GL_VERSION_4_0)
        case 0x8de5: return "GL_ACTIVE_SUBROUTINES";
        case 0x8de6: return "GL_ACTIVE_SUBROUTINE_UNIFORMS";
        case 0x8de7: return "GL_MAX_SUBROUTINES";
        case 0x8de8: return "GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS";
#endif
#if defined(GL_ARB_shading_language_include)
        case 0x8de9: return "GL_NAMED_STRING_LENGTH_ARB";
        case 0x8dea: return "GL_NAMED_STRING_TYPE_ARB";
#endif
#if defined(GL_EXT_bindable_uniform)
        case 0x8ded: return "GL_MAX_BINDABLE_UNIFORM_SIZE_EXT";
        case 0x8dee: return "GL_UNIFORM_BUFFER_EXT";
        case 0x8def: return "GL_UNIFORM_BUFFER_BINDING_EXT";
#endif
#if defined(GL_VERSION_4_1)
        case 0x8df0: return "GL_LOW_FLOAT";
        case 0x8df1: return "GL_MEDIUM_FLOAT";
        case 0x8df2: return "GL_HIGH_FLOAT";
        case 0x8df3: return "GL_LOW_INT";
        case 0x8df4: return "GL_MEDIUM_INT";
        case 0x8df5: return "GL_HIGH_INT";
        case 0x8df8: return "GL_SHADER_BINARY_FORMATS";
        case 0x8df9: return "GL_NUM_SHADER_BINARY_FORMATS";
        case 0x8dfa: return "GL_SHADER_COMPILER";
        case 0x8dfb: return "GL_MAX_VERTEX_UNIFORM_VECTORS";
        case 0x8dfc: return "GL_MAX_VARYING_VECTORS";
        case 0x8dfd: return "GL_MAX_FRAGMENT_UNIFORM_VECTORS";
#endif
#if defined(GL_NV_framebuffer_multisample_coverage)
        case 0x8e10: return "GL_RENDERBUFFER_COLOR_SAMPLES_NV";
        case 0x8e11: return "GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV";
        case 0x8e12: return "GL_MULTISAMPLE_COVERAGE_MODES_NV";
#endif
        case 0x8e13:
#if defined(GL_VERSION_3_0)
                    return "GL_QUERY_WAIT";
#endif
#if defined(GL_NV_conditional_render)
                    return "GL_QUERY_WAIT_NV";
#endif
            break;
        case 0x8e14:
#if defined(GL_VERSION_3_0)
                    return "GL_QUERY_NO_WAIT";
#endif
#if defined(GL_NV_conditional_render)
                    return "GL_QUERY_NO_WAIT_NV";
#endif
            break;
        case 0x8e15:
#if defined(GL_VERSION_3_0)
                    return "GL_QUERY_BY_REGION_WAIT";
#endif
#if defined(GL_NV_conditional_render)
                    return "GL_QUERY_BY_REGION_WAIT_NV";
#endif
            break;
        case 0x8e16:
#if defined(GL_VERSION_3_0)
                    return "GL_QUERY_BY_REGION_NO_WAIT";
#endif
#if defined(GL_NV_conditional_render)
                    return "GL_QUERY_BY_REGION_NO_WAIT_NV";
#endif
            break;
#if defined(GL_VERSION_4_5)
        case 0x8e17: return "GL_QUERY_WAIT_INVERTED";
        case 0x8e18: return "GL_QUERY_NO_WAIT_INVERTED";
        case 0x8e19: return "GL_QUERY_BY_REGION_WAIT_INVERTED";
        case 0x8e1a: return "GL_QUERY_BY_REGION_NO_WAIT_INVERTED";
#endif
        case 0x8e1b:
#if defined(GL_VERSION_4_6)
                    return "GL_POLYGON_OFFSET_CLAMP";
#endif
#if defined(GL_EXT_polygon_offset_clamp)
                    return "GL_POLYGON_OFFSET_CLAMP_EXT";
#endif
            break;
#if defined(GL_VERSION_4_0)
        case 0x8e1e: return "GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS";
        case 0x8e1f: return "GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS";
#endif
#if defined(GL_NV_framebuffer_mixed_samples)
        case 0x8e20: return "GL_COLOR_SAMPLES_NV";
#endif
        case 0x8e22:
#if defined(GL_VERSION_4_0)
                    return "GL_TRANSFORM_FEEDBACK";
#endif
#if defined(GL_NV_transform_feedback2)
                    return "GL_TRANSFORM_FEEDBACK_NV";
#endif
            break;
        case 0x8e23:
#if defined(GL_VERSION_4_0)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED";
#endif
#if defined(GL_NV_transform_feedback2)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV";
#endif
#if defined(GL_VERSION_4_2)
                    return "GL_TRANSFORM_FEEDBACK_PAUSED";
#endif
            break;
        case 0x8e24:
#if defined(GL_VERSION_4_2)
                    return "GL_TRANSFORM_FEEDBACK_ACTIVE";
#endif
#if defined(GL_VERSION_4_0)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE";
#endif
#if defined(GL_NV_transform_feedback2)
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV";
#endif
            break;
        case 0x8e25:
#if defined(GL_VERSION_4_0)
                    return "GL_TRANSFORM_FEEDBACK_BINDING";
#endif
#if defined(GL_NV_transform_feedback2)
                    return "GL_TRANSFORM_FEEDBACK_BINDING_NV";
#endif
            break;
#if defined(GL_NV_present_video)
        case 0x8e26: return "GL_FRAME_NV";
        case 0x8e27: return "GL_FIELDS_NV";
#endif
        case 0x8e28:
#if defined(GL_NV_present_video)
                    return "GL_CURRENT_TIME_NV";
#endif
#if defined(GL_VERSION_3_3)
                    return "GL_TIMESTAMP";
#endif
            break;
#if defined(GL_NV_present_video)
        case 0x8e29: return "GL_NUM_FILL_STREAMS_NV";
        case 0x8e2a: return "GL_PRESENT_TIME_NV";
        case 0x8e2b: return "GL_PRESENT_DURATION_NV";
#endif
#if defined(GL_EXT_direct_state_access)
        case 0x8e2d: return "GL_PROGRAM_MATRIX_EXT";
        case 0x8e2e: return "GL_TRANSPOSE_PROGRAM_MATRIX_EXT";
        case 0x8e2f: return "GL_PROGRAM_MATRIX_STACK_DEPTH_EXT";
#endif
        case 0x8e42:
#if defined(GL_VERSION_3_3)
                    return "GL_TEXTURE_SWIZZLE_R";
#endif
#if defined(GL_EXT_texture_swizzle)
                    return "GL_TEXTURE_SWIZZLE_R_EXT";
#endif
            break;
        case 0x8e43:
#if defined(GL_VERSION_3_3)
                    return "GL_TEXTURE_SWIZZLE_G";
#endif
#if defined(GL_EXT_texture_swizzle)
                    return "GL_TEXTURE_SWIZZLE_G_EXT";
#endif
            break;
        case 0x8e44:
#if defined(GL_VERSION_3_3)
                    return "GL_TEXTURE_SWIZZLE_B";
#endif
#if defined(GL_EXT_texture_swizzle)
                    return "GL_TEXTURE_SWIZZLE_B_EXT";
#endif
            break;
        case 0x8e45:
#if defined(GL_VERSION_3_3)
                    return "GL_TEXTURE_SWIZZLE_A";
#endif
#if defined(GL_EXT_texture_swizzle)
                    return "GL_TEXTURE_SWIZZLE_A_EXT";
#endif
            break;
        case 0x8e46:
#if defined(GL_VERSION_3_3)
                    return "GL_TEXTURE_SWIZZLE_RGBA";
#endif
#if defined(GL_EXT_texture_swizzle)
                    return "GL_TEXTURE_SWIZZLE_RGBA_EXT";
#endif
            break;
#if defined(GL_VERSION_4_0)
        case 0x8e47: return "GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS";
        case 0x8e48: return "GL_ACTIVE_SUBROUTINE_MAX_LENGTH";
        case 0x8e49: return "GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH";
        case 0x8e4a: return "GL_NUM_COMPATIBLE_SUBROUTINES";
        case 0x8e4b: return "GL_COMPATIBLE_SUBROUTINES";
#endif
        case 0x8e4c:
#if defined(GL_VERSION_3_2)
                    return "GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION";
#endif
#if defined(GL_EXT_provoking_vertex)
                    return "GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT";
#endif
            break;
        case 0x8e4d:
#if defined(GL_VERSION_3_2)
                    return "GL_FIRST_VERTEX_CONVENTION";
#endif
#if defined(GL_EXT_provoking_vertex)
                    return "GL_FIRST_VERTEX_CONVENTION_EXT";
#endif
            break;
        case 0x8e4e:
#if defined(GL_VERSION_3_2)
                    return "GL_LAST_VERTEX_CONVENTION";
#endif
#if defined(GL_EXT_provoking_vertex)
                    return "GL_LAST_VERTEX_CONVENTION_EXT";
#endif
            break;
        case 0x8e4f:
#if defined(GL_VERSION_3_2)
                    return "GL_PROVOKING_VERTEX";
#endif
#if defined(GL_EXT_provoking_vertex)
                    return "GL_PROVOKING_VERTEX_EXT";
#endif
            break;
        case 0x8e50:
#if defined(GL_ARB_sample_locations)
                    return "GL_SAMPLE_LOCATION_ARB";
#endif
#if defined(GL_NV_sample_locations)
                    return "GL_SAMPLE_LOCATION_NV";
#endif
#if defined(GL_VERSION_3_2)
                    return "GL_SAMPLE_POSITION";
#endif
#if defined(GL_NV_explicit_multisample)
                    return "GL_SAMPLE_POSITION_NV";
#endif
            break;
        case 0x8e51:
#if defined(GL_VERSION_3_2)
                    return "GL_SAMPLE_MASK";
#endif
#if defined(GL_NV_explicit_multisample)
                    return "GL_SAMPLE_MASK_NV";
#endif
            break;
        case 0x8e52:
#if defined(GL_VERSION_3_2)
                    return "GL_SAMPLE_MASK_VALUE";
#endif
#if defined(GL_NV_explicit_multisample)
                    return "GL_SAMPLE_MASK_VALUE_NV";
#endif
            break;
#if defined(GL_NV_explicit_multisample)
        case 0x8e53: return "GL_TEXTURE_BINDING_RENDERBUFFER_NV";
        case 0x8e54: return "GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV";
        case 0x8e55: return "GL_TEXTURE_RENDERBUFFER_NV";
        case 0x8e56: return "GL_SAMPLER_RENDERBUFFER_NV";
        case 0x8e57: return "GL_INT_SAMPLER_RENDERBUFFER_NV";
        case 0x8e58: return "GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV";
#endif
        case 0x8e59:
#if defined(GL_VERSION_3_2)
                    return "GL_MAX_SAMPLE_MASK_WORDS";
#endif
#if defined(GL_NV_explicit_multisample)
                    return "GL_MAX_SAMPLE_MASK_WORDS_NV";
#endif
            break;
        case 0x8e5a:
#if defined(GL_NV_gpu_program5)
                    return "GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV";
#endif
#if defined(GL_VERSION_4_0)
                    return "GL_MAX_GEOMETRY_SHADER_INVOCATIONS";
#endif
            break;
        case 0x8e5b:
#if defined(GL_VERSION_4_0)
                    return "GL_MIN_FRAGMENT_INTERPOLATION_OFFSET";
#endif
#if defined(GL_NV_gpu_program5)
                    return "GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV";
#endif
            break;
        case 0x8e5c:
#if defined(GL_VERSION_4_0)
                    return "GL_MAX_FRAGMENT_INTERPOLATION_OFFSET";
#endif
#if defined(GL_NV_gpu_program5)
                    return "GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV";
#endif
            break;
        case 0x8e5e:
#if defined(GL_VERSION_4_0)
                    return "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET";
#endif
#if defined(GL_ARB_texture_gather)
                    return "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB";
#endif
#if defined(GL_NV_gpu_program5)
                    return "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV";
#endif
            break;
        case 0x8e5f:
#if defined(GL_VERSION_4_0)
                    return "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET";
#endif
#if defined(GL_ARB_texture_gather)
                    return "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB";
#endif
#if defined(GL_NV_gpu_program5)
                    return "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV";
#endif
            break;
#if defined(GL_VERSION_4_0)
        case 0x8e70: return "GL_MAX_TRANSFORM_FEEDBACK_BUFFERS";
        case 0x8e71: return "GL_MAX_VERTEX_STREAMS";
        case 0x8e72: return "GL_PATCH_VERTICES";
        case 0x8e73: return "GL_PATCH_DEFAULT_INNER_LEVEL";
        case 0x8e74: return "GL_PATCH_DEFAULT_OUTER_LEVEL";
        case 0x8e75: return "GL_TESS_CONTROL_OUTPUT_VERTICES";
        case 0x8e76: return "GL_TESS_GEN_MODE";
        case 0x8e77: return "GL_TESS_GEN_SPACING";
        case 0x8e78: return "GL_TESS_GEN_VERTEX_ORDER";
        case 0x8e79: return "GL_TESS_GEN_POINT_MODE";
        case 0x8e7a: return "GL_ISOLINES";
        case 0x8e7b: return "GL_FRACTIONAL_ODD";
        case 0x8e7c: return "GL_FRACTIONAL_EVEN";
        case 0x8e7d: return "GL_MAX_PATCH_VERTICES";
        case 0x8e7e: return "GL_MAX_TESS_GEN_LEVEL";
        case 0x8e7f: return "GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS";
        case 0x8e80: return "GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS";
        case 0x8e81: return "GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS";
        case 0x8e82: return "GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS";
        case 0x8e83: return "GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS";
        case 0x8e84: return "GL_MAX_TESS_PATCH_COMPONENTS";
        case 0x8e85: return "GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS";
        case 0x8e86: return "GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS";
        case 0x8e87: return "GL_TESS_EVALUATION_SHADER";
        case 0x8e88: return "GL_TESS_CONTROL_SHADER";
        case 0x8e89: return "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS";
        case 0x8e8a: return "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS";
#endif
        case 0x8e8c:
#if defined(GL_VERSION_4_2)
                    return "GL_COMPRESSED_RGBA_BPTC_UNORM";
#endif
#if defined(GL_ARB_texture_compression_bptc)
                    return "GL_COMPRESSED_RGBA_BPTC_UNORM_ARB";
#endif
            break;
        case 0x8e8d:
#if defined(GL_VERSION_4_2)
                    return "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM";
#endif
#if defined(GL_ARB_texture_compression_bptc)
                    return "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB";
#endif
            break;
        case 0x8e8e:
#if defined(GL_VERSION_4_2)
                    return "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT";
#endif
#if defined(GL_ARB_texture_compression_bptc)
                    return "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB";
#endif
            break;
        case 0x8e8f:
#if defined(GL_VERSION_4_2)
                    return "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT";
#endif
#if defined(GL_ARB_texture_compression_bptc)
                    return "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB";
#endif
            break;
#if defined(GL_EXT_window_rectangles)
        case 0x8f10: return "GL_INCLUSIVE_EXT";
        case 0x8f11: return "GL_EXCLUSIVE_EXT";
        case 0x8f12: return "GL_WINDOW_RECTANGLE_EXT";
        case 0x8f13: return "GL_WINDOW_RECTANGLE_MODE_EXT";
        case 0x8f14: return "GL_MAX_WINDOW_RECTANGLES_EXT";
        case 0x8f15: return "GL_NUM_WINDOW_RECTANGLES_EXT";
#endif
#if defined(GL_NV_shader_buffer_load)
        case 0x8f1d: return "GL_BUFFER_GPU_ADDRESS_NV";
#endif
#if defined(GL_NV_vertex_buffer_unified_memory)
        case 0x8f1e: return "GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV";
        case 0x8f1f: return "GL_ELEMENT_ARRAY_UNIFIED_NV";
        case 0x8f20: return "GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV";
        case 0x8f21: return "GL_VERTEX_ARRAY_ADDRESS_NV";
        case 0x8f22: return "GL_NORMAL_ARRAY_ADDRESS_NV";
        case 0x8f23: return "GL_COLOR_ARRAY_ADDRESS_NV";
        case 0x8f24: return "GL_INDEX_ARRAY_ADDRESS_NV";
        case 0x8f25: return "GL_TEXTURE_COORD_ARRAY_ADDRESS_NV";
        case 0x8f26: return "GL_EDGE_FLAG_ARRAY_ADDRESS_NV";
        case 0x8f27: return "GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV";
        case 0x8f28: return "GL_FOG_COORD_ARRAY_ADDRESS_NV";
        case 0x8f29: return "GL_ELEMENT_ARRAY_ADDRESS_NV";
        case 0x8f2a: return "GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV";
        case 0x8f2b: return "GL_VERTEX_ARRAY_LENGTH_NV";
        case 0x8f2c: return "GL_NORMAL_ARRAY_LENGTH_NV";
        case 0x8f2d: return "GL_COLOR_ARRAY_LENGTH_NV";
        case 0x8f2e: return "GL_INDEX_ARRAY_LENGTH_NV";
        case 0x8f2f: return "GL_TEXTURE_COORD_ARRAY_LENGTH_NV";
        case 0x8f30: return "GL_EDGE_FLAG_ARRAY_LENGTH_NV";
        case 0x8f31: return "GL_SECONDARY_COLOR_ARRAY_LENGTH_NV";
        case 0x8f32: return "GL_FOG_COORD_ARRAY_LENGTH_NV";
        case 0x8f33: return "GL_ELEMENT_ARRAY_LENGTH_NV";
#endif
#if defined(GL_NV_shader_buffer_load)
        case 0x8f34: return "GL_GPU_ADDRESS_NV";
        case 0x8f35: return "GL_MAX_SHADER_BUFFER_ADDRESS_NV";
#endif
        case 0x8f36:
#if defined(GL_VERSION_3_1)
                    return "GL_COPY_READ_BUFFER";
#endif
#if defined(GL_VERSION_4_2)
                    return "GL_COPY_READ_BUFFER_BINDING";
#endif
            break;
        case 0x8f37:
#if defined(GL_VERSION_3_1)
                    return "GL_COPY_WRITE_BUFFER";
#endif
#if defined(GL_VERSION_4_2)
                    return "GL_COPY_WRITE_BUFFER_BINDING";
#endif
            break;
        case 0x8f38:
#if defined(GL_VERSION_4_2)
                    return "GL_MAX_IMAGE_UNITS";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_MAX_IMAGE_UNITS_EXT";
#endif
            break;
        case 0x8f39:
#if defined(GL_VERSION_4_2)
                    return "GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT";
#endif
#if defined(GL_VERSION_4_3)
                    return "GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES";
#endif
            break;
        case 0x8f3a:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_BINDING_NAME";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_BINDING_NAME_EXT";
#endif
            break;
        case 0x8f3b:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_BINDING_LEVEL";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_BINDING_LEVEL_EXT";
#endif
            break;
        case 0x8f3c:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_BINDING_LAYERED";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_BINDING_LAYERED_EXT";
#endif
            break;
        case 0x8f3d:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_BINDING_LAYER";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_BINDING_LAYER_EXT";
#endif
            break;
        case 0x8f3e:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_BINDING_ACCESS";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_BINDING_ACCESS_EXT";
#endif
            break;
#if defined(GL_VERSION_4_0)
        case 0x8f3f: return "GL_DRAW_INDIRECT_BUFFER";
#endif
#if defined(GL_NV_vertex_buffer_unified_memory)
        case 0x8f40: return "GL_DRAW_INDIRECT_UNIFIED_NV";
        case 0x8f41: return "GL_DRAW_INDIRECT_ADDRESS_NV";
        case 0x8f42: return "GL_DRAW_INDIRECT_LENGTH_NV";
#endif
#if defined(GL_VERSION_4_0)
        case 0x8f43: return "GL_DRAW_INDIRECT_BUFFER_BINDING";
#endif
#if defined(GL_NV_gpu_program5)
        case 0x8f44: return "GL_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV";
        case 0x8f45: return "GL_MAX_PROGRAM_SUBROUTINE_NUM_NV";
#endif
        case 0x8f46:
#if defined(GL_VERSION_4_0)
                    return "GL_DOUBLE_MAT2";
#endif
#if defined(GL_EXT_vertex_attrib_64bit)
                    return "GL_DOUBLE_MAT2_EXT";
#endif
            break;
        case 0x8f47:
#if defined(GL_VERSION_4_0)
                    return "GL_DOUBLE_MAT3";
#endif
#if defined(GL_EXT_vertex_attrib_64bit)
                    return "GL_DOUBLE_MAT3_EXT";
#endif
            break;
        case 0x8f48:
#if defined(GL_VERSION_4_0)
                    return "GL_DOUBLE_MAT4";
#endif
#if defined(GL_EXT_vertex_attrib_64bit)
                    return "GL_DOUBLE_MAT4_EXT";
#endif
            break;
        case 0x8f49:
#if defined(GL_VERSION_4_0)
                    return "GL_DOUBLE_MAT2x3";
#endif
#if defined(GL_EXT_vertex_attrib_64bit)
                    return "GL_DOUBLE_MAT2x3_EXT";
#endif
            break;
        case 0x8f4a:
#if defined(GL_VERSION_4_0)
                    return "GL_DOUBLE_MAT2x4";
#endif
#if defined(GL_EXT_vertex_attrib_64bit)
                    return "GL_DOUBLE_MAT2x4_EXT";
#endif
            break;
        case 0x8f4b:
#if defined(GL_VERSION_4_0)
                    return "GL_DOUBLE_MAT3x2";
#endif
#if defined(GL_EXT_vertex_attrib_64bit)
                    return "GL_DOUBLE_MAT3x2_EXT";
#endif
            break;
        case 0x8f4c:
#if defined(GL_VERSION_4_0)
                    return "GL_DOUBLE_MAT3x4";
#endif
#if defined(GL_EXT_vertex_attrib_64bit)
                    return "GL_DOUBLE_MAT3x4_EXT";
#endif
            break;
        case 0x8f4d:
#if defined(GL_VERSION_4_0)
                    return "GL_DOUBLE_MAT4x2";
#endif
#if defined(GL_EXT_vertex_attrib_64bit)
                    return "GL_DOUBLE_MAT4x2_EXT";
#endif
            break;
        case 0x8f4e:
#if defined(GL_VERSION_4_0)
                    return "GL_DOUBLE_MAT4x3";
#endif
#if defined(GL_EXT_vertex_attrib_64bit)
                    return "GL_DOUBLE_MAT4x3_EXT";
#endif
            break;
#if defined(GL_VERSION_4_3)
        case 0x8f4f: return "GL_VERTEX_BINDING_BUFFER";
#endif
#if defined(GL_EXT_texture_snorm)
        case 0x8f90: return "GL_RED_SNORM";
        case 0x8f91: return "GL_RG_SNORM";
        case 0x8f92: return "GL_RGB_SNORM";
        case 0x8f93: return "GL_RGBA_SNORM";
#endif
#if defined(GL_VERSION_3_1)
        case 0x8f94: return "GL_R8_SNORM";
        case 0x8f95: return "GL_RG8_SNORM";
        case 0x8f96: return "GL_RGB8_SNORM";
        case 0x8f97: return "GL_RGBA8_SNORM";
        case 0x8f98: return "GL_R16_SNORM";
        case 0x8f99: return "GL_RG16_SNORM";
        case 0x8f9a: return "GL_RGB16_SNORM";
        case 0x8f9b: return "GL_RGBA16_SNORM";
        case 0x8f9c: return "GL_SIGNED_NORMALIZED";
        case 0x8f9d: return "GL_PRIMITIVE_RESTART";
        case 0x8f9e: return "GL_PRIMITIVE_RESTART_INDEX";
#endif
#if defined(GL_ARB_texture_gather)
        case 0x8f9f: return "GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB";
#endif
#if defined(GL_AMD_gpu_shader_int64)
        case 0x8fe0: return "GL_INT8_NV";
        case 0x8fe1: return "GL_INT8_VEC2_NV";
        case 0x8fe2: return "GL_INT8_VEC3_NV";
        case 0x8fe3: return "GL_INT8_VEC4_NV";
        case 0x8fe4: return "GL_INT16_NV";
        case 0x8fe5: return "GL_INT16_VEC2_NV";
        case 0x8fe6: return "GL_INT16_VEC3_NV";
        case 0x8fe7: return "GL_INT16_VEC4_NV";
#endif
        case 0x8fe9:
#if defined(GL_ARB_gpu_shader_int64)
                    return "GL_INT64_VEC2_ARB";
#endif
#if defined(GL_AMD_gpu_shader_int64)
                    return "GL_INT64_VEC2_NV";
#endif
            break;
        case 0x8fea:
#if defined(GL_ARB_gpu_shader_int64)
                    return "GL_INT64_VEC3_ARB";
#endif
#if defined(GL_AMD_gpu_shader_int64)
                    return "GL_INT64_VEC3_NV";
#endif
            break;
        case 0x8feb:
#if defined(GL_ARB_gpu_shader_int64)
                    return "GL_INT64_VEC4_ARB";
#endif
#if defined(GL_AMD_gpu_shader_int64)
                    return "GL_INT64_VEC4_NV";
#endif
            break;
#if defined(GL_AMD_gpu_shader_int64)
        case 0x8fec: return "GL_UNSIGNED_INT8_NV";
        case 0x8fed: return "GL_UNSIGNED_INT8_VEC2_NV";
        case 0x8fee: return "GL_UNSIGNED_INT8_VEC3_NV";
        case 0x8fef: return "GL_UNSIGNED_INT8_VEC4_NV";
        case 0x8ff0: return "GL_UNSIGNED_INT16_NV";
        case 0x8ff1: return "GL_UNSIGNED_INT16_VEC2_NV";
        case 0x8ff2: return "GL_UNSIGNED_INT16_VEC3_NV";
        case 0x8ff3: return "GL_UNSIGNED_INT16_VEC4_NV";
#endif
        case 0x8ff5:
#if defined(GL_ARB_gpu_shader_int64)
                    return "GL_UNSIGNED_INT64_VEC2_ARB";
#endif
#if defined(GL_AMD_gpu_shader_int64)
                    return "GL_UNSIGNED_INT64_VEC2_NV";
#endif
            break;
        case 0x8ff6:
#if defined(GL_ARB_gpu_shader_int64)
                    return "GL_UNSIGNED_INT64_VEC3_ARB";
#endif
#if defined(GL_AMD_gpu_shader_int64)
                    return "GL_UNSIGNED_INT64_VEC3_NV";
#endif
            break;
        case 0x8ff7:
#if defined(GL_ARB_gpu_shader_int64)
                    return "GL_UNSIGNED_INT64_VEC4_ARB";
#endif
#if defined(GL_AMD_gpu_shader_int64)
                    return "GL_UNSIGNED_INT64_VEC4_NV";
#endif
            break;
#if defined(GL_AMD_gpu_shader_half_float)
        case 0x8ff8: return "GL_FLOAT16_NV";
        case 0x8ff9: return "GL_FLOAT16_VEC2_NV";
        case 0x8ffa: return "GL_FLOAT16_VEC3_NV";
        case 0x8ffb: return "GL_FLOAT16_VEC4_NV";
#endif
        case 0x8ffc:
#if defined(GL_VERSION_4_0)
                    return "GL_DOUBLE_VEC2";
#endif
#if defined(GL_EXT_vertex_attrib_64bit)
                    return "GL_DOUBLE_VEC2_EXT";
#endif
            break;
        case 0x8ffd:
#if defined(GL_VERSION_4_0)
                    return "GL_DOUBLE_VEC3";
#endif
#if defined(GL_EXT_vertex_attrib_64bit)
                    return "GL_DOUBLE_VEC3_EXT";
#endif
            break;
        case 0x8ffe:
#if defined(GL_VERSION_4_0)
                    return "GL_DOUBLE_VEC4";
#endif
#if defined(GL_EXT_vertex_attrib_64bit)
                    return "GL_DOUBLE_VEC4_EXT";
#endif
            break;
#if defined(GL_AMD_vertex_shader_tessellator)
        case 0x9001: return "GL_SAMPLER_BUFFER_AMD";
        case 0x9002: return "GL_INT_SAMPLER_BUFFER_AMD";
        case 0x9003: return "GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD";
        case 0x9004: return "GL_TESSELLATION_MODE_AMD";
        case 0x9005: return "GL_TESSELLATION_FACTOR_AMD";
        case 0x9006: return "GL_DISCRETE_AMD";
        case 0x9007: return "GL_CONTINUOUS_AMD";
#endif
        case 0x9009:
#if defined(GL_VERSION_4_0)
                    return "GL_TEXTURE_CUBE_MAP_ARRAY";
#endif
#if defined(GL_ARB_texture_cube_map_array)
                    return "GL_TEXTURE_CUBE_MAP_ARRAY_ARB";
#endif
            break;
        case 0x900a:
#if defined(GL_VERSION_4_0)
                    return "GL_TEXTURE_BINDING_CUBE_MAP_ARRAY";
#endif
#if defined(GL_ARB_texture_cube_map_array)
                    return "GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB";
#endif
            break;
        case 0x900b:
#if defined(GL_VERSION_4_0)
                    return "GL_PROXY_TEXTURE_CUBE_MAP_ARRAY";
#endif
#if defined(GL_ARB_texture_cube_map_array)
                    return "GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB";
#endif
            break;
        case 0x900c:
#if defined(GL_VERSION_4_0)
                    return "GL_SAMPLER_CUBE_MAP_ARRAY";
#endif
#if defined(GL_ARB_texture_cube_map_array)
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_ARB";
#endif
            break;
        case 0x900d:
#if defined(GL_VERSION_4_0)
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW";
#endif
#if defined(GL_ARB_texture_cube_map_array)
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB";
#endif
            break;
        case 0x900e:
#if defined(GL_VERSION_4_0)
                    return "GL_INT_SAMPLER_CUBE_MAP_ARRAY";
#endif
#if defined(GL_ARB_texture_cube_map_array)
                    return "GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB";
#endif
            break;
        case 0x900f:
#if defined(GL_VERSION_4_0)
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY";
#endif
#if defined(GL_ARB_texture_cube_map_array)
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB";
#endif
            break;
#if defined(GL_EXT_texture_snorm)
        case 0x9010: return "GL_ALPHA_SNORM";
        case 0x9011: return "GL_LUMINANCE_SNORM";
        case 0x9012: return "GL_LUMINANCE_ALPHA_SNORM";
        case 0x9013: return "GL_INTENSITY_SNORM";
        case 0x9014: return "GL_ALPHA8_SNORM";
        case 0x9015: return "GL_LUMINANCE8_SNORM";
        case 0x9016: return "GL_LUMINANCE8_ALPHA8_SNORM";
        case 0x9017: return "GL_INTENSITY8_SNORM";
        case 0x9018: return "GL_ALPHA16_SNORM";
        case 0x9019: return "GL_LUMINANCE16_SNORM";
        case 0x901a: return "GL_LUMINANCE16_ALPHA16_SNORM";
        case 0x901b: return "GL_INTENSITY16_SNORM";
#endif
#if defined(GL_AMD_blend_minmax_factor)
        case 0x901c: return "GL_FACTOR_MIN_AMD";
        case 0x901d: return "GL_FACTOR_MAX_AMD";
#endif
#if defined(GL_AMD_depth_clamp_separate)
        case 0x901e: return "GL_DEPTH_CLAMP_NEAR_AMD";
        case 0x901f: return "GL_DEPTH_CLAMP_FAR_AMD";
#endif
#if defined(GL_NV_video_capture)
        case 0x9020: return "GL_VIDEO_BUFFER_NV";
        case 0x9021: return "GL_VIDEO_BUFFER_BINDING_NV";
        case 0x9022: return "GL_FIELD_UPPER_NV";
        case 0x9023: return "GL_FIELD_LOWER_NV";
        case 0x9024: return "GL_NUM_VIDEO_CAPTURE_STREAMS_NV";
        case 0x9025: return "GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV";
        case 0x9026: return "GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV";
        case 0x9027: return "GL_LAST_VIDEO_CAPTURE_STATUS_NV";
        case 0x9028: return "GL_VIDEO_BUFFER_PITCH_NV";
        case 0x9029: return "GL_VIDEO_COLOR_CONVERSION_MATRIX_NV";
        case 0x902a: return "GL_VIDEO_COLOR_CONVERSION_MAX_NV";
        case 0x902b: return "GL_VIDEO_COLOR_CONVERSION_MIN_NV";
        case 0x902c: return "GL_VIDEO_COLOR_CONVERSION_OFFSET_NV";
        case 0x902d: return "GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV";
        case 0x902e: return "GL_PARTIAL_SUCCESS_NV";
        case 0x902f: return "GL_SUCCESS_NV";
        case 0x9030: return "GL_FAILURE_NV";
        case 0x9031: return "GL_YCBYCR8_422_NV";
        case 0x9032: return "GL_YCBAYCR8A_4224_NV";
        case 0x9033: return "GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV";
        case 0x9034: return "GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV";
        case 0x9035: return "GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV";
        case 0x9036: return "GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV";
        case 0x9037: return "GL_Z4Y12Z4CB12Z4CR12_444_NV";
        case 0x9038: return "GL_VIDEO_CAPTURE_FRAME_WIDTH_NV";
        case 0x9039: return "GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV";
        case 0x903a: return "GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV";
        case 0x903b: return "GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV";
        case 0x903c: return "GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV";
#endif
#if defined(GL_NV_texture_multisample)
        case 0x9045: return "GL_TEXTURE_COVERAGE_SAMPLES_NV";
        case 0x9046: return "GL_TEXTURE_COLOR_SAMPLES_NV";
#endif
#if defined(GL_NVX_gpu_memory_info)
        case 0x9047: return "GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX";
        case 0x9048: return "GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX";
        case 0x9049: return "GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX";
        case 0x904a: return "GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX";
        case 0x904b: return "GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX";
#endif
        case 0x904c:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_1D";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_1D_EXT";
#endif
            break;
        case 0x904d:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_2D";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_2D_EXT";
#endif
            break;
        case 0x904e:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_3D";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_3D_EXT";
#endif
            break;
        case 0x904f:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_2D_RECT";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_2D_RECT_EXT";
#endif
            break;
        case 0x9050:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_CUBE";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_CUBE_EXT";
#endif
            break;
        case 0x9051:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_BUFFER";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_BUFFER_EXT";
#endif
            break;
        case 0x9052:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_1D_ARRAY";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_1D_ARRAY_EXT";
#endif
            break;
        case 0x9053:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_2D_ARRAY";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_2D_ARRAY_EXT";
#endif
            break;
        case 0x9054:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_CUBE_MAP_ARRAY";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_CUBE_MAP_ARRAY_EXT";
#endif
            break;
        case 0x9055:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_2D_MULTISAMPLE";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_2D_MULTISAMPLE_EXT";
#endif
            break;
        case 0x9056:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_2D_MULTISAMPLE_ARRAY";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT";
#endif
            break;
        case 0x9057:
#if defined(GL_VERSION_4_2)
                    return "GL_INT_IMAGE_1D";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_INT_IMAGE_1D_EXT";
#endif
            break;
        case 0x9058:
#if defined(GL_VERSION_4_2)
                    return "GL_INT_IMAGE_2D";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_INT_IMAGE_2D_EXT";
#endif
            break;
        case 0x9059:
#if defined(GL_VERSION_4_2)
                    return "GL_INT_IMAGE_3D";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_INT_IMAGE_3D_EXT";
#endif
            break;
        case 0x905a:
#if defined(GL_VERSION_4_2)
                    return "GL_INT_IMAGE_2D_RECT";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_INT_IMAGE_2D_RECT_EXT";
#endif
            break;
        case 0x905b:
#if defined(GL_VERSION_4_2)
                    return "GL_INT_IMAGE_CUBE";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_INT_IMAGE_CUBE_EXT";
#endif
            break;
        case 0x905c:
#if defined(GL_VERSION_4_2)
                    return "GL_INT_IMAGE_BUFFER";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_INT_IMAGE_BUFFER_EXT";
#endif
            break;
        case 0x905d:
#if defined(GL_VERSION_4_2)
                    return "GL_INT_IMAGE_1D_ARRAY";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_INT_IMAGE_1D_ARRAY_EXT";
#endif
            break;
        case 0x905e:
#if defined(GL_VERSION_4_2)
                    return "GL_INT_IMAGE_2D_ARRAY";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_INT_IMAGE_2D_ARRAY_EXT";
#endif
            break;
        case 0x905f:
#if defined(GL_VERSION_4_2)
                    return "GL_INT_IMAGE_CUBE_MAP_ARRAY";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT";
#endif
            break;
        case 0x9060:
#if defined(GL_VERSION_4_2)
                    return "GL_INT_IMAGE_2D_MULTISAMPLE";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_INT_IMAGE_2D_MULTISAMPLE_EXT";
#endif
            break;
        case 0x9061:
#if defined(GL_VERSION_4_2)
                    return "GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT";
#endif
            break;
        case 0x9062:
#if defined(GL_VERSION_4_2)
                    return "GL_UNSIGNED_INT_IMAGE_1D";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_UNSIGNED_INT_IMAGE_1D_EXT";
#endif
            break;
        case 0x9063:
#if defined(GL_VERSION_4_2)
                    return "GL_UNSIGNED_INT_IMAGE_2D";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_UNSIGNED_INT_IMAGE_2D_EXT";
#endif
            break;
        case 0x9064:
#if defined(GL_VERSION_4_2)
                    return "GL_UNSIGNED_INT_IMAGE_3D";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_UNSIGNED_INT_IMAGE_3D_EXT";
#endif
            break;
        case 0x9065:
#if defined(GL_VERSION_4_2)
                    return "GL_UNSIGNED_INT_IMAGE_2D_RECT";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_UNSIGNED_INT_IMAGE_2D_RECT_EXT";
#endif
            break;
        case 0x9066:
#if defined(GL_VERSION_4_2)
                    return "GL_UNSIGNED_INT_IMAGE_CUBE";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_UNSIGNED_INT_IMAGE_CUBE_EXT";
#endif
            break;
        case 0x9067:
#if defined(GL_VERSION_4_2)
                    return "GL_UNSIGNED_INT_IMAGE_BUFFER";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_UNSIGNED_INT_IMAGE_BUFFER_EXT";
#endif
            break;
        case 0x9068:
#if defined(GL_VERSION_4_2)
                    return "GL_UNSIGNED_INT_IMAGE_1D_ARRAY";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT";
#endif
            break;
        case 0x9069:
#if defined(GL_VERSION_4_2)
                    return "GL_UNSIGNED_INT_IMAGE_2D_ARRAY";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT";
#endif
            break;
        case 0x906a:
#if defined(GL_VERSION_4_2)
                    return "GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT";
#endif
            break;
        case 0x906b:
#if defined(GL_VERSION_4_2)
                    return "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT";
#endif
            break;
        case 0x906c:
#if defined(GL_VERSION_4_2)
                    return "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT";
#endif
            break;
        case 0x906d:
#if defined(GL_VERSION_4_2)
                    return "GL_MAX_IMAGE_SAMPLES";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_MAX_IMAGE_SAMPLES_EXT";
#endif
            break;
        case 0x906e:
#if defined(GL_VERSION_4_2)
                    return "GL_IMAGE_BINDING_FORMAT";
#endif
#if defined(GL_EXT_shader_image_load_store)
                    return "GL_IMAGE_BINDING_FORMAT_EXT";
#endif
            break;
#if defined(GL_VERSION_3_3)
        case 0x906f: return "GL_RGB10_A2UI";
#endif
#if defined(GL_NV_path_rendering)
        case 0x9070: return "GL_PATH_FORMAT_SVG_NV";
        case 0x9071: return "GL_PATH_FORMAT_PS_NV";
        case 0x9072: return "GL_STANDARD_FONT_NAME_NV";
        case 0x9073: return "GL_SYSTEM_FONT_NAME_NV";
        case 0x9074: return "GL_FILE_NAME_NV";
        case 0x9075: return "GL_PATH_STROKE_WIDTH_NV";
        case 0x9076: return "GL_PATH_END_CAPS_NV";
        case 0x9077: return "GL_PATH_INITIAL_END_CAP_NV";
        case 0x9078: return "GL_PATH_TERMINAL_END_CAP_NV";
        case 0x9079: return "GL_PATH_JOIN_STYLE_NV";
        case 0x907a: return "GL_PATH_MITER_LIMIT_NV";
        case 0x907b: return "GL_PATH_DASH_CAPS_NV";
        case 0x907c: return "GL_PATH_INITIAL_DASH_CAP_NV";
        case 0x907d: return "GL_PATH_TERMINAL_DASH_CAP_NV";
        case 0x907e: return "GL_PATH_DASH_OFFSET_NV";
        case 0x907f: return "GL_PATH_CLIENT_LENGTH_NV";
        case 0x9080: return "GL_PATH_FILL_MODE_NV";
        case 0x9081: return "GL_PATH_FILL_MASK_NV";
        case 0x9082: return "GL_PATH_FILL_COVER_MODE_NV";
        case 0x9083: return "GL_PATH_STROKE_COVER_MODE_NV";
        case 0x9084: return "GL_PATH_STROKE_MASK_NV";
        case 0x9088: return "GL_COUNT_UP_NV";
        case 0x9089: return "GL_COUNT_DOWN_NV";
        case 0x908a: return "GL_PATH_OBJECT_BOUNDING_BOX_NV";
        case 0x908b: return "GL_CONVEX_HULL_NV";
        case 0x908d: return "GL_BOUNDING_BOX_NV";
        case 0x908e: return "GL_TRANSLATE_X_NV";
        case 0x908f: return "GL_TRANSLATE_Y_NV";
        case 0x9090: return "GL_TRANSLATE_2D_NV";
        case 0x9091: return "GL_TRANSLATE_3D_NV";
        case 0x9092: return "GL_AFFINE_2D_NV";
        case 0x9094: return "GL_AFFINE_3D_NV";
        case 0x9096: return "GL_TRANSPOSE_AFFINE_2D_NV";
        case 0x9098: return "GL_TRANSPOSE_AFFINE_3D_NV";
        case 0x909a: return "GL_UTF8_NV";
        case 0x909b: return "GL_UTF16_NV";
        case 0x909c: return "GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV";
        case 0x909d: return "GL_PATH_COMMAND_COUNT_NV";
        case 0x909e: return "GL_PATH_COORD_COUNT_NV";
        case 0x909f: return "GL_PATH_DASH_ARRAY_COUNT_NV";
        case 0x90a0: return "GL_PATH_COMPUTED_LENGTH_NV";
        case 0x90a1: return "GL_PATH_FILL_BOUNDING_BOX_NV";
        case 0x90a2: return "GL_PATH_STROKE_BOUNDING_BOX_NV";
        case 0x90a3: return "GL_SQUARE_NV";
        case 0x90a4: return "GL_ROUND_NV";
        case 0x90a5: return "GL_TRIANGULAR_NV";
        case 0x90a6: return "GL_BEVEL_NV";
        case 0x90a7: return "GL_MITER_REVERT_NV";
        case 0x90a8: return "GL_MITER_TRUNCATE_NV";
        case 0x90a9: return "GL_SKIP_MISSING_GLYPH_NV";
        case 0x90aa: return "GL_USE_MISSING_GLYPH_NV";
        case 0x90ab: return "GL_PATH_ERROR_POSITION_NV";
        case 0x90ac: return "GL_PATH_FOG_GEN_MODE_NV";
        case 0x90ad: return "GL_ACCUM_ADJACENT_PAIRS_NV";
        case 0x90ae: return "GL_ADJACENT_PAIRS_NV";
        case 0x90af: return "GL_FIRST_TO_REST_NV";
        case 0x90b0: return "GL_PATH_GEN_MODE_NV";
        case 0x90b1: return "GL_PATH_GEN_COEFF_NV";
        case 0x90b2: return "GL_PATH_GEN_COLOR_FORMAT_NV";
        case 0x90b3: return "GL_PATH_GEN_COMPONENTS_NV";
        case 0x90b4: return "GL_PATH_DASH_OFFSET_RESET_NV";
        case 0x90b5: return "GL_MOVE_TO_RESETS_NV";
        case 0x90b6: return "GL_MOVE_TO_CONTINUES_NV";
        case 0x90b7: return "GL_PATH_STENCIL_FUNC_NV";
        case 0x90b8: return "GL_PATH_STENCIL_REF_NV";
        case 0x90b9: return "GL_PATH_STENCIL_VALUE_MASK_NV";
#endif
#if defined(GL_EXT_framebuffer_multisample_blit_scaled)
        case 0x90ba: return "GL_SCALED_RESOLVE_FASTEST_EXT";
        case 0x90bb: return "GL_SCALED_RESOLVE_NICEST_EXT";
#endif
#if defined(GL_VERSION_4_2)
        case 0x90bc: return "GL_MIN_MAP_BUFFER_ALIGNMENT";
#endif
#if defined(GL_NV_path_rendering)
        case 0x90bd: return "GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV";
        case 0x90be: return "GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV";
        case 0x90bf: return "GL_PATH_COVER_DEPTH_FUNC_NV";
#endif
#if defined(GL_VERSION_4_2)
        case 0x90c7: return "GL_IMAGE_FORMAT_COMPATIBILITY_TYPE";
        case 0x90c8: return "GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE";
        case 0x90c9: return "GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS";
        case 0x90ca: return "GL_MAX_VERTEX_IMAGE_UNIFORMS";
        case 0x90cb: return "GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS";
        case 0x90cc: return "GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS";
        case 0x90cd: return "GL_MAX_GEOMETRY_IMAGE_UNIFORMS";
        case 0x90ce: return "GL_MAX_FRAGMENT_IMAGE_UNIFORMS";
        case 0x90cf: return "GL_MAX_COMBINED_IMAGE_UNIFORMS";
#endif
#if defined(GL_NV_deep_texture3D)
        case 0x90d0: return "GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV";
        case 0x90d1: return "GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV";
#endif
#if defined(GL_VERSION_4_3)
        case 0x90d2: return "GL_SHADER_STORAGE_BUFFER";
        case 0x90d3: return "GL_SHADER_STORAGE_BUFFER_BINDING";
        case 0x90d4: return "GL_SHADER_STORAGE_BUFFER_START";
        case 0x90d5: return "GL_SHADER_STORAGE_BUFFER_SIZE";
        case 0x90d6: return "GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS";
        case 0x90d7: return "GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS";
        case 0x90d8: return "GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS";
        case 0x90d9: return "GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS";
        case 0x90da: return "GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS";
        case 0x90db: return "GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS";
        case 0x90dc: return "GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS";
        case 0x90dd: return "GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS";
        case 0x90de: return "GL_MAX_SHADER_STORAGE_BLOCK_SIZE";
        case 0x90df: return "GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT";
#endif
#if defined(GL_EXT_x11_sync_object)
        case 0x90e1: return "GL_SYNC_X11_FENCE_EXT";
#endif
#if defined(GL_VERSION_4_3)
        case 0x90ea: return "GL_DEPTH_STENCIL_TEXTURE_MODE";
#endif
        case 0x90eb:
#if defined(GL_ARB_compute_variable_group_size)
                    return "GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB";
#endif
#if defined(GL_VERSION_4_3)
                    return "GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS";
#endif
            break;
#if defined(GL_VERSION_4_3)
        case 0x90ec: return "GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER";
        case 0x90ed: return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER";
        case 0x90ee: return "GL_DISPATCH_INDIRECT_BUFFER";
        case 0x90ef: return "GL_DISPATCH_INDIRECT_BUFFER_BINDING";
#endif
#if defined(GL_KHR_robustness)
        case 0x90f3: return "GL_CONTEXT_ROBUST_ACCESS";
#endif
#if defined(GL_NV_compute_program5)
        case 0x90fb: return "GL_COMPUTE_PROGRAM_NV";
        case 0x90fc: return "GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV";
#endif
#if defined(GL_VERSION_3_2)
        case 0x9100: return "GL_TEXTURE_2D_MULTISAMPLE";
        case 0x9101: return "GL_PROXY_TEXTURE_2D_MULTISAMPLE";
        case 0x9102: return "GL_TEXTURE_2D_MULTISAMPLE_ARRAY";
        case 0x9103: return "GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY";
        case 0x9104: return "GL_TEXTURE_BINDING_2D_MULTISAMPLE";
        case 0x9105: return "GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY";
        case 0x9106: return "GL_TEXTURE_SAMPLES";
        case 0x9107: return "GL_TEXTURE_FIXED_SAMPLE_LOCATIONS";
        case 0x9108: return "GL_SAMPLER_2D_MULTISAMPLE";
        case 0x9109: return "GL_INT_SAMPLER_2D_MULTISAMPLE";
        case 0x910a: return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE";
        case 0x910b: return "GL_SAMPLER_2D_MULTISAMPLE_ARRAY";
        case 0x910c: return "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
        case 0x910d: return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
        case 0x910e: return "GL_MAX_COLOR_TEXTURE_SAMPLES";
        case 0x910f: return "GL_MAX_DEPTH_TEXTURE_SAMPLES";
        case 0x9110: return "GL_MAX_INTEGER_SAMPLES";
        case 0x9111: return "GL_MAX_SERVER_WAIT_TIMEOUT";
        case 0x9112: return "GL_OBJECT_TYPE";
        case 0x9113: return "GL_SYNC_CONDITION";
        case 0x9114: return "GL_SYNC_STATUS";
        case 0x9115: return "GL_SYNC_FLAGS";
        case 0x9116: return "GL_SYNC_FENCE";
        case 0x9117: return "GL_SYNC_GPU_COMMANDS_COMPLETE";
        case 0x9118: return "GL_UNSIGNALED";
        case 0x9119: return "GL_SIGNALED";
        case 0x911a: return "GL_ALREADY_SIGNALED";
        case 0x911b: return "GL_TIMEOUT_EXPIRED";
        case 0x911c: return "GL_CONDITION_SATISFIED";
        case 0x911d: return "GL_WAIT_FAILED";
#endif
#if defined(GL_VERSION_3_0)
        case 0x911f: return "GL_BUFFER_ACCESS_FLAGS";
        case 0x9120: return "GL_BUFFER_MAP_LENGTH";
        case 0x9121: return "GL_BUFFER_MAP_OFFSET";
#endif
#if defined(GL_VERSION_3_2)
        case 0x9122: return "GL_MAX_VERTEX_OUTPUT_COMPONENTS";
        case 0x9123: return "GL_MAX_GEOMETRY_INPUT_COMPONENTS";
        case 0x9124: return "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS";
        case 0x9125: return "GL_MAX_FRAGMENT_INPUT_COMPONENTS";
        case 0x9126: return "GL_CONTEXT_PROFILE_MASK";
#endif
#if defined(GL_VERSION_4_2)
        case 0x9127: return "GL_UNPACK_COMPRESSED_BLOCK_WIDTH";
        case 0x9128: return "GL_UNPACK_COMPRESSED_BLOCK_HEIGHT";
        case 0x9129: return "GL_UNPACK_COMPRESSED_BLOCK_DEPTH";
        case 0x912a: return "GL_UNPACK_COMPRESSED_BLOCK_SIZE";
        case 0x912b: return "GL_PACK_COMPRESSED_BLOCK_WIDTH";
        case 0x912c: return "GL_PACK_COMPRESSED_BLOCK_HEIGHT";
        case 0x912d: return "GL_PACK_COMPRESSED_BLOCK_DEPTH";
        case 0x912e: return "GL_PACK_COMPRESSED_BLOCK_SIZE";
        case 0x912f: return "GL_TEXTURE_IMMUTABLE_FORMAT";
#endif
        case 0x9143:
#if defined(GL_VERSION_4_3)
                    return "GL_MAX_DEBUG_MESSAGE_LENGTH";
#endif
#if defined(GL_AMD_debug_output)
                    return "GL_MAX_DEBUG_MESSAGE_LENGTH_AMD";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_MAX_DEBUG_MESSAGE_LENGTH_ARB";
#endif
            break;
        case 0x9144:
#if defined(GL_VERSION_4_3)
                    return "GL_MAX_DEBUG_LOGGED_MESSAGES";
#endif
#if defined(GL_AMD_debug_output)
                    return "GL_MAX_DEBUG_LOGGED_MESSAGES_AMD";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_MAX_DEBUG_LOGGED_MESSAGES_ARB";
#endif
            break;
        case 0x9145:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_LOGGED_MESSAGES";
#endif
#if defined(GL_AMD_debug_output)
                    return "GL_DEBUG_LOGGED_MESSAGES_AMD";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_LOGGED_MESSAGES_ARB";
#endif
            break;
        case 0x9146:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_SEVERITY_HIGH";
#endif
#if defined(GL_AMD_debug_output)
                    return "GL_DEBUG_SEVERITY_HIGH_AMD";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_SEVERITY_HIGH_ARB";
#endif
            break;
        case 0x9147:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_SEVERITY_MEDIUM";
#endif
#if defined(GL_AMD_debug_output)
                    return "GL_DEBUG_SEVERITY_MEDIUM_AMD";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_SEVERITY_MEDIUM_ARB";
#endif
            break;
        case 0x9148:
#if defined(GL_VERSION_4_3)
                    return "GL_DEBUG_SEVERITY_LOW";
#endif
#if defined(GL_AMD_debug_output)
                    return "GL_DEBUG_SEVERITY_LOW_AMD";
#endif
#if defined(GL_ARB_debug_output)
                    return "GL_DEBUG_SEVERITY_LOW_ARB";
#endif
            break;
#if defined(GL_AMD_debug_output)
        case 0x9149: return "GL_DEBUG_CATEGORY_API_ERROR_AMD";
        case 0x914a: return "GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD";
        case 0x914b: return "GL_DEBUG_CATEGORY_DEPRECATION_AMD";
        case 0x914c: return "GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD";
        case 0x914d: return "GL_DEBUG_CATEGORY_PERFORMANCE_AMD";
        case 0x914e: return "GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD";
        case 0x914f: return "GL_DEBUG_CATEGORY_APPLICATION_AMD";
        case 0x9150: return "GL_DEBUG_CATEGORY_OTHER_AMD";
#endif
        case 0x9151:
#if defined(GL_EXT_debug_label)
                    return "GL_BUFFER_OBJECT_EXT";
#endif
#if defined(GL_AMD_name_gen_delete)
                    return "GL_DATA_BUFFER_AMD";
#endif
            break;
#if defined(GL_AMD_name_gen_delete)
        case 0x9152: return "GL_PERFORMANCE_MONITOR_AMD";
#endif
        case 0x9153:
#if defined(GL_AMD_name_gen_delete)
                    return "GL_QUERY_OBJECT_AMD";
#endif
#if defined(GL_EXT_debug_label)
                    return "GL_QUERY_OBJECT_EXT";
#endif
            break;
        case 0x9154:
#if defined(GL_AMD_name_gen_delete)
                    return "GL_VERTEX_ARRAY_OBJECT_AMD";
#endif
#if defined(GL_EXT_debug_label)
                    return "GL_VERTEX_ARRAY_OBJECT_EXT";
#endif
            break;
#if defined(GL_AMD_name_gen_delete)
        case 0x9155: return "GL_SAMPLER_OBJECT_AMD";
#endif
#if defined(GL_AMD_pinned_memory)
        case 0x9160: return "GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD";
#endif
        case 0x9192:
#if defined(GL_VERSION_4_4)
                    return "GL_QUERY_BUFFER";
#endif
#if defined(GL_AMD_query_buffer_object)
                    return "GL_QUERY_BUFFER_AMD";
#endif
            break;
        case 0x9193:
#if defined(GL_VERSION_4_4)
                    return "GL_QUERY_BUFFER_BINDING";
#endif
#if defined(GL_AMD_query_buffer_object)
                    return "GL_QUERY_BUFFER_BINDING_AMD";
#endif
            break;
        case 0x9194:
#if defined(GL_VERSION_4_4)
                    return "GL_QUERY_RESULT_NO_WAIT";
#endif
#if defined(GL_AMD_query_buffer_object)
                    return "GL_QUERY_RESULT_NO_WAIT_AMD";
#endif
            break;
        case 0x9195:
#if defined(GL_AMD_sparse_texture)
                    return "GL_VIRTUAL_PAGE_SIZE_X_AMD";
#endif
#if defined(GL_ARB_sparse_texture)
                    return "GL_VIRTUAL_PAGE_SIZE_X_ARB";
#endif
            break;
        case 0x9196:
#if defined(GL_AMD_sparse_texture)
                    return "GL_VIRTUAL_PAGE_SIZE_Y_AMD";
#endif
#if defined(GL_ARB_sparse_texture)
                    return "GL_VIRTUAL_PAGE_SIZE_Y_ARB";
#endif
            break;
        case 0x9197:
#if defined(GL_AMD_sparse_texture)
                    return "GL_VIRTUAL_PAGE_SIZE_Z_AMD";
#endif
#if defined(GL_ARB_sparse_texture)
                    return "GL_VIRTUAL_PAGE_SIZE_Z_ARB";
#endif
            break;
        case 0x9198:
#if defined(GL_AMD_sparse_texture)
                    return "GL_MAX_SPARSE_TEXTURE_SIZE_AMD";
#endif
#if defined(GL_ARB_sparse_texture)
                    return "GL_MAX_SPARSE_TEXTURE_SIZE_ARB";
#endif
            break;
        case 0x9199:
#if defined(GL_AMD_sparse_texture)
                    return "GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD";
#endif
#if defined(GL_ARB_sparse_texture)
                    return "GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB";
#endif
            break;
        case 0x919a:
#if defined(GL_AMD_sparse_texture)
                    return "GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS";
#endif
#if defined(GL_ARB_sparse_texture)
                    return "GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB";
#endif
            break;
#if defined(GL_AMD_sparse_texture)
        case 0x919b: return "GL_MIN_SPARSE_LEVEL_AMD";
        case 0x919c: return "GL_MIN_LOD_WARNING_AMD";
#endif
#if defined(GL_VERSION_4_3)
        case 0x919d: return "GL_TEXTURE_BUFFER_OFFSET";
        case 0x919e: return "GL_TEXTURE_BUFFER_SIZE";
        case 0x919f: return "GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT";
#endif
#if defined(GL_AMD_transform_feedback4)
        case 0x91a0: return "GL_STREAM_RASTERIZATION_AMD";
#endif
#if defined(GL_AMD_interleaved_elements)
        case 0x91a4: return "GL_VERTEX_ELEMENT_SWIZZLE_AMD";
        case 0x91a5: return "GL_VERTEX_ID_SWIZZLE_AMD";
#endif
#if defined(GL_ARB_sparse_texture)
        case 0x91a6: return "GL_TEXTURE_SPARSE_ARB";
        case 0x91a7: return "GL_VIRTUAL_PAGE_SIZE_INDEX_ARB";
        case 0x91a8: return "GL_NUM_VIRTUAL_PAGE_SIZES_ARB";
        case 0x91a9: return "GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB";
        case 0x91aa: return "GL_NUM_SPARSE_LEVELS_ARB";
#endif
#if defined(GL_AMD_framebuffer_sample_positions)
        case 0x91ae: return "GL_PIXELS_PER_SAMPLE_PATTERN_X_AMD";
        case 0x91af: return "GL_PIXELS_PER_SAMPLE_PATTERN_Y_AMD";
#endif
        case 0x91b0:
#if defined(GL_ARB_parallel_shader_compile)
                    return "GL_MAX_SHADER_COMPILER_THREADS_ARB";
#endif
#if defined(GL_KHR_parallel_shader_compile)
                    return "GL_MAX_SHADER_COMPILER_THREADS_KHR";
#endif
            break;
        case 0x91b1:
#if defined(GL_ARB_parallel_shader_compile)
                    return "GL_COMPLETION_STATUS_ARB";
#endif
#if defined(GL_KHR_parallel_shader_compile)
                    return "GL_COMPLETION_STATUS_KHR";
#endif
            break;
#if defined(GL_AMD_framebuffer_multisample_advanced)
        case 0x91b2: return "GL_RENDERBUFFER_STORAGE_SAMPLES_AMD";
        case 0x91b3: return "GL_MAX_COLOR_FRAMEBUFFER_SAMPLES_AMD";
        case 0x91b4: return "GL_MAX_COLOR_FRAMEBUFFER_STORAGE_SAMPLES_AMD";
        case 0x91b5: return "GL_MAX_DEPTH_STENCIL_FRAMEBUFFER_SAMPLES_AMD";
        case 0x91b6: return "GL_NUM_SUPPORTED_MULTISAMPLE_MODES_AMD";
        case 0x91b7: return "GL_SUPPORTED_MULTISAMPLE_MODES_AMD";
#endif
#if defined(GL_VERSION_4_3)
        case 0x91b9: return "GL_COMPUTE_SHADER";
        case 0x91bb: return "GL_MAX_COMPUTE_UNIFORM_BLOCKS";
        case 0x91bc: return "GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS";
        case 0x91bd: return "GL_MAX_COMPUTE_IMAGE_UNIFORMS";
        case 0x91be: return "GL_MAX_COMPUTE_WORK_GROUP_COUNT";
#endif
        case 0x91bf:
#if defined(GL_ARB_compute_variable_group_size)
                    return "GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB";
#endif
#if defined(GL_VERSION_4_3)
                    return "GL_MAX_COMPUTE_WORK_GROUP_SIZE";
#endif
            break;
#if defined(GL_AMD_gpu_shader_half_float)
        case 0x91c5: return "GL_FLOAT16_MAT2_AMD";
        case 0x91c6: return "GL_FLOAT16_MAT3_AMD";
        case 0x91c7: return "GL_FLOAT16_MAT4_AMD";
        case 0x91c8: return "GL_FLOAT16_MAT2x3_AMD";
        case 0x91c9: return "GL_FLOAT16_MAT2x4_AMD";
        case 0x91ca: return "GL_FLOAT16_MAT3x2_AMD";
        case 0x91cb: return "GL_FLOAT16_MAT3x4_AMD";
        case 0x91cc: return "GL_FLOAT16_MAT4x2_AMD";
        case 0x91cd: return "GL_FLOAT16_MAT4x3_AMD";
#endif
#if defined(GL_VERSION_4_3)
        case 0x9270: return "GL_COMPRESSED_R11_EAC";
        case 0x9271: return "GL_COMPRESSED_SIGNED_R11_EAC";
        case 0x9272: return "GL_COMPRESSED_RG11_EAC";
        case 0x9273: return "GL_COMPRESSED_SIGNED_RG11_EAC";
        case 0x9274: return "GL_COMPRESSED_RGB8_ETC2";
        case 0x9275: return "GL_COMPRESSED_SRGB8_ETC2";
        case 0x9276: return "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2";
        case 0x9277: return "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2";
        case 0x9278: return "GL_COMPRESSED_RGBA8_ETC2_EAC";
        case 0x9279: return "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC";
#endif
#if defined(GL_NV_blend_equation_advanced)
        case 0x9280: return "GL_BLEND_PREMULTIPLIED_SRC_NV";
        case 0x9281: return "GL_BLEND_OVERLAP_NV";
        case 0x9282: return "GL_UNCORRELATED_NV";
        case 0x9283: return "GL_DISJOINT_NV";
        case 0x9284: return "GL_CONJOINT_NV";
#endif
        case 0x9285:
#if defined(GL_KHR_blend_equation_advanced_coherent)
                    return "GL_BLEND_ADVANCED_COHERENT_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced_coherent)
                    return "GL_BLEND_ADVANCED_COHERENT_NV";
#endif
            break;
#if defined(GL_NV_blend_equation_advanced)
        case 0x9286: return "GL_SRC_NV";
        case 0x9287: return "GL_DST_NV";
        case 0x9288: return "GL_SRC_OVER_NV";
        case 0x9289: return "GL_DST_OVER_NV";
        case 0x928a: return "GL_SRC_IN_NV";
        case 0x928b: return "GL_DST_IN_NV";
        case 0x928c: return "GL_SRC_OUT_NV";
        case 0x928d: return "GL_DST_OUT_NV";
        case 0x928e: return "GL_SRC_ATOP_NV";
        case 0x928f: return "GL_DST_ATOP_NV";
        case 0x9291: return "GL_PLUS_NV";
        case 0x9292: return "GL_PLUS_DARKER_NV";
#endif
        case 0x9294:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_MULTIPLY_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_MULTIPLY_NV";
#endif
            break;
        case 0x9295:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_SCREEN_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_SCREEN_NV";
#endif
            break;
        case 0x9296:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_OVERLAY_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_OVERLAY_NV";
#endif
            break;
        case 0x9297:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_DARKEN_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_DARKEN_NV";
#endif
            break;
        case 0x9298:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_LIGHTEN_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_LIGHTEN_NV";
#endif
            break;
        case 0x9299:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_COLORDODGE_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_COLORDODGE_NV";
#endif
            break;
        case 0x929a:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_COLORBURN_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_COLORBURN_NV";
#endif
            break;
        case 0x929b:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_HARDLIGHT_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_HARDLIGHT_NV";
#endif
            break;
        case 0x929c:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_SOFTLIGHT_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_SOFTLIGHT_NV";
#endif
            break;
        case 0x929e:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_DIFFERENCE_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_DIFFERENCE_NV";
#endif
            break;
#if defined(GL_NV_blend_equation_advanced)
        case 0x929f: return "GL_MINUS_NV";
#endif
        case 0x92a0:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_EXCLUSION_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_EXCLUSION_NV";
#endif
            break;
#if defined(GL_NV_blend_equation_advanced)
        case 0x92a1: return "GL_CONTRAST_NV";
        case 0x92a3: return "GL_INVERT_RGB_NV";
        case 0x92a4: return "GL_LINEARDODGE_NV";
        case 0x92a5: return "GL_LINEARBURN_NV";
        case 0x92a6: return "GL_VIVIDLIGHT_NV";
        case 0x92a7: return "GL_LINEARLIGHT_NV";
        case 0x92a8: return "GL_PINLIGHT_NV";
        case 0x92a9: return "GL_HARDMIX_NV";
#endif
        case 0x92ad:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_HSL_HUE_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_HSL_HUE_NV";
#endif
            break;
        case 0x92ae:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_HSL_SATURATION_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_HSL_SATURATION_NV";
#endif
            break;
        case 0x92af:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_HSL_COLOR_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_HSL_COLOR_NV";
#endif
            break;
        case 0x92b0:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_HSL_LUMINOSITY_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_HSL_LUMINOSITY_NV";
#endif
            break;
#if defined(GL_NV_blend_equation_advanced)
        case 0x92b1: return "GL_PLUS_CLAMPED_NV";
        case 0x92b2: return "GL_PLUS_CLAMPED_ALPHA_NV";
        case 0x92b3: return "GL_MINUS_CLAMPED_NV";
        case 0x92b4: return "GL_INVERT_OVG_NV";
#endif
        case 0x92ba:
#if defined(GL_NVX_linked_gpu_multicast)
                    return "GL_MAX_LGPU_GPUS_NVX";
#endif
#if defined(GL_NV_gpu_multicast)
                    return "GL_MULTICAST_GPUS_NV";
#endif
            break;
#if defined(GL_NV_robustness_video_memory_purge)
        case 0x92bb: return "GL_PURGED_CONTEXT_RESET_NV";
#endif
#if defined(GL_ARB_ES3_2_compatibility)
        case 0x92be: return "GL_PRIMITIVE_BOUNDING_BOX_ARB";
#endif
#if defined(GL_NV_alpha_to_coverage_dither_control)
        case 0x92bf: return "GL_ALPHA_TO_COVERAGE_DITHER_MODE_NV";
#endif
#if defined(GL_VERSION_4_2)
        case 0x92c0: return "GL_ATOMIC_COUNTER_BUFFER";
        case 0x92c1: return "GL_ATOMIC_COUNTER_BUFFER_BINDING";
        case 0x92c2: return "GL_ATOMIC_COUNTER_BUFFER_START";
        case 0x92c3: return "GL_ATOMIC_COUNTER_BUFFER_SIZE";
        case 0x92c4: return "GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE";
        case 0x92c5: return "GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS";
        case 0x92c6: return "GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES";
        case 0x92c7: return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER";
        case 0x92c8: return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER";
        case 0x92c9: return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER";
        case 0x92ca: return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER";
        case 0x92cb: return "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER";
        case 0x92cc: return "GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS";
        case 0x92cd: return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS";
        case 0x92ce: return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS";
        case 0x92cf: return "GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS";
        case 0x92d0: return "GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS";
        case 0x92d1: return "GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS";
        case 0x92d2: return "GL_MAX_VERTEX_ATOMIC_COUNTERS";
        case 0x92d3: return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS";
        case 0x92d4: return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS";
        case 0x92d5: return "GL_MAX_GEOMETRY_ATOMIC_COUNTERS";
        case 0x92d6: return "GL_MAX_FRAGMENT_ATOMIC_COUNTERS";
        case 0x92d7: return "GL_MAX_COMBINED_ATOMIC_COUNTERS";
        case 0x92d8: return "GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE";
        case 0x92d9: return "GL_ACTIVE_ATOMIC_COUNTER_BUFFERS";
        case 0x92da: return "GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX";
        case 0x92db: return "GL_UNSIGNED_INT_ATOMIC_COUNTER";
        case 0x92dc: return "GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS";
#endif
#if defined(GL_NV_fragment_coverage_to_color)
        case 0x92dd: return "GL_FRAGMENT_COVERAGE_TO_COLOR_NV";
        case 0x92de: return "GL_FRAGMENT_COVERAGE_COLOR_NV";
#endif
#if defined(GL_VERSION_4_3)
        case 0x92e0: return "GL_DEBUG_OUTPUT";
        case 0x92e1: return "GL_UNIFORM";
        case 0x92e2: return "GL_UNIFORM_BLOCK";
        case 0x92e3: return "GL_PROGRAM_INPUT";
        case 0x92e4: return "GL_PROGRAM_OUTPUT";
        case 0x92e5: return "GL_BUFFER_VARIABLE";
        case 0x92e6: return "GL_SHADER_STORAGE_BLOCK";
        case 0x92e7: return "GL_IS_PER_PATCH";
        case 0x92e8: return "GL_VERTEX_SUBROUTINE";
        case 0x92e9: return "GL_TESS_CONTROL_SUBROUTINE";
        case 0x92ea: return "GL_TESS_EVALUATION_SUBROUTINE";
        case 0x92eb: return "GL_GEOMETRY_SUBROUTINE";
        case 0x92ec: return "GL_FRAGMENT_SUBROUTINE";
        case 0x92ed: return "GL_COMPUTE_SUBROUTINE";
        case 0x92ee: return "GL_VERTEX_SUBROUTINE_UNIFORM";
        case 0x92ef: return "GL_TESS_CONTROL_SUBROUTINE_UNIFORM";
        case 0x92f0: return "GL_TESS_EVALUATION_SUBROUTINE_UNIFORM";
        case 0x92f1: return "GL_GEOMETRY_SUBROUTINE_UNIFORM";
        case 0x92f2: return "GL_FRAGMENT_SUBROUTINE_UNIFORM";
        case 0x92f3: return "GL_COMPUTE_SUBROUTINE_UNIFORM";
        case 0x92f4: return "GL_TRANSFORM_FEEDBACK_VARYING";
        case 0x92f5: return "GL_ACTIVE_RESOURCES";
        case 0x92f6: return "GL_MAX_NAME_LENGTH";
        case 0x92f7: return "GL_MAX_NUM_ACTIVE_VARIABLES";
        case 0x92f8: return "GL_MAX_NUM_COMPATIBLE_SUBROUTINES";
        case 0x92f9: return "GL_NAME_LENGTH";
        case 0x92fa: return "GL_TYPE";
        case 0x92fb: return "GL_ARRAY_SIZE";
        case 0x92fc: return "GL_OFFSET";
        case 0x92fd: return "GL_BLOCK_INDEX";
        case 0x92fe: return "GL_ARRAY_STRIDE";
        case 0x92ff: return "GL_MATRIX_STRIDE";
        case 0x9300: return "GL_IS_ROW_MAJOR";
        case 0x9301: return "GL_ATOMIC_COUNTER_BUFFER_INDEX";
        case 0x9302: return "GL_BUFFER_BINDING";
        case 0x9303: return "GL_BUFFER_DATA_SIZE";
        case 0x9304: return "GL_NUM_ACTIVE_VARIABLES";
        case 0x9305: return "GL_ACTIVE_VARIABLES";
        case 0x9306: return "GL_REFERENCED_BY_VERTEX_SHADER";
        case 0x9307: return "GL_REFERENCED_BY_TESS_CONTROL_SHADER";
        case 0x9308: return "GL_REFERENCED_BY_TESS_EVALUATION_SHADER";
        case 0x9309: return "GL_REFERENCED_BY_GEOMETRY_SHADER";
        case 0x930a: return "GL_REFERENCED_BY_FRAGMENT_SHADER";
        case 0x930b: return "GL_REFERENCED_BY_COMPUTE_SHADER";
        case 0x930c: return "GL_TOP_LEVEL_ARRAY_SIZE";
        case 0x930d: return "GL_TOP_LEVEL_ARRAY_STRIDE";
        case 0x930e: return "GL_LOCATION";
        case 0x930f: return "GL_LOCATION_INDEX";
        case 0x9310: return "GL_FRAMEBUFFER_DEFAULT_WIDTH";
        case 0x9311: return "GL_FRAMEBUFFER_DEFAULT_HEIGHT";
        case 0x9312: return "GL_FRAMEBUFFER_DEFAULT_LAYERS";
        case 0x9313: return "GL_FRAMEBUFFER_DEFAULT_SAMPLES";
        case 0x9314: return "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS";
        case 0x9315: return "GL_MAX_FRAMEBUFFER_WIDTH";
        case 0x9316: return "GL_MAX_FRAMEBUFFER_HEIGHT";
        case 0x9317: return "GL_MAX_FRAMEBUFFER_LAYERS";
        case 0x9318: return "GL_MAX_FRAMEBUFFER_SAMPLES";
#endif
#if defined(GL_EXT_raster_multisample)
        case 0x9327: return "GL_RASTER_MULTISAMPLE_EXT";
        case 0x9328: return "GL_RASTER_SAMPLES_EXT";
        case 0x9329: return "GL_MAX_RASTER_SAMPLES_EXT";
        case 0x932a: return "GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT";
        case 0x932b: return "GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT";
        case 0x932c: return "GL_EFFECTIVE_RASTER_SAMPLES_EXT";
#endif
#if defined(GL_NV_framebuffer_mixed_samples)
        case 0x932d: return "GL_DEPTH_SAMPLES_NV";
        case 0x932e: return "GL_STENCIL_SAMPLES_NV";
        case 0x932f: return "GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV";
        case 0x9330: return "GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV";
        case 0x9331: return "GL_COVERAGE_MODULATION_TABLE_NV";
        case 0x9332: return "GL_COVERAGE_MODULATION_NV";
        case 0x9333: return "GL_COVERAGE_MODULATION_TABLE_SIZE_NV";
#endif
#if defined(GL_NV_shader_thread_group)
        case 0x9339: return "GL_WARP_SIZE_NV";
        case 0x933a: return "GL_WARPS_PER_SM_NV";
        case 0x933b: return "GL_SM_COUNT_NV";
#endif
#if defined(GL_NV_fill_rectangle)
        case 0x933c: return "GL_FILL_RECTANGLE_NV";
#endif
        case 0x933e:
#if defined(GL_ARB_sample_locations)
                    return "GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB";
#endif
#if defined(GL_NV_sample_locations)
                    return "GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV";
#endif
            break;
        case 0x933f:
#if defined(GL_ARB_sample_locations)
                    return "GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB";
#endif
#if defined(GL_NV_sample_locations)
                    return "GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV";
#endif
            break;
        case 0x9340:
#if defined(GL_ARB_sample_locations)
                    return "GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB";
#endif
#if defined(GL_NV_sample_locations)
                    return "GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV";
#endif
            break;
        case 0x9341:
#if defined(GL_ARB_sample_locations)
                    return "GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB";
#endif
#if defined(GL_NV_sample_locations)
                    return "GL_PROGRAMMABLE_SAMPLE_LOCATION_NV";
#endif
            break;
        case 0x9342:
#if defined(GL_ARB_sample_locations)
                    return "GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB";
#endif
#if defined(GL_NV_sample_locations)
                    return "GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV";
#endif
            break;
        case 0x9343:
#if defined(GL_ARB_sample_locations)
                    return "GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB";
#endif
#if defined(GL_NV_sample_locations)
                    return "GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV";
#endif
            break;
#if defined(GL_ARB_compute_variable_group_size)
        case 0x9344: return "GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB";
        case 0x9345: return "GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB";
#endif
#if defined(GL_NV_conservative_raster)
        case 0x9346: return "GL_CONSERVATIVE_RASTERIZATION_NV";
#endif
#if defined(GL_VERSION_4_4)
        case 0x934a: return "GL_LOCATION_COMPONENT";
        case 0x934b: return "GL_TRANSFORM_FEEDBACK_BUFFER_INDEX";
        case 0x934c: return "GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE";
#endif
#if defined(GL_NV_alpha_to_coverage_dither_control)
        case 0x934d: return "GL_ALPHA_TO_COVERAGE_DITHER_DEFAULT_NV";
        case 0x934e: return "GL_ALPHA_TO_COVERAGE_DITHER_ENABLE_NV";
        case 0x934f: return "GL_ALPHA_TO_COVERAGE_DITHER_DISABLE_NV";
#endif
#if defined(GL_NV_viewport_swizzle)
        case 0x9350: return "GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV";
        case 0x9351: return "GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV";
        case 0x9352: return "GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV";
        case 0x9353: return "GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV";
        case 0x9354: return "GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV";
        case 0x9355: return "GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV";
        case 0x9356: return "GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV";
        case 0x9357: return "GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV";
        case 0x9358: return "GL_VIEWPORT_SWIZZLE_X_NV";
        case 0x9359: return "GL_VIEWPORT_SWIZZLE_Y_NV";
        case 0x935a: return "GL_VIEWPORT_SWIZZLE_Z_NV";
        case 0x935b: return "GL_VIEWPORT_SWIZZLE_W_NV";
#endif
#if defined(GL_VERSION_4_5)
        case 0x935c: return "GL_CLIP_ORIGIN";
        case 0x935d: return "GL_CLIP_DEPTH_MODE";
        case 0x935e: return "GL_NEGATIVE_ONE_TO_ONE";
        case 0x935f: return "GL_ZERO_TO_ONE";
#endif
#if defined(GL_VERSION_4_4)
        case 0x9365: return "GL_CLEAR_TEXTURE";
#endif
        case 0x9366:
#if defined(GL_ARB_texture_filter_minmax)
                    return "GL_TEXTURE_REDUCTION_MODE_ARB";
#endif
#if defined(GL_EXT_texture_filter_minmax)
                    return "GL_TEXTURE_REDUCTION_MODE_EXT";
#endif
            break;
        case 0x9367:
#if defined(GL_ARB_texture_filter_minmax)
                    return "GL_WEIGHTED_AVERAGE_ARB";
#endif
#if defined(GL_EXT_texture_filter_minmax)
                    return "GL_WEIGHTED_AVERAGE_EXT";
#endif
            break;
#if defined(GL_NV_path_rendering)
        case 0x9368: return "GL_FONT_GLYPHS_AVAILABLE_NV";
        case 0x9369: return "GL_FONT_TARGET_UNAVAILABLE_NV";
        case 0x936a: return "GL_FONT_UNAVAILABLE_NV";
        case 0x936b: return "GL_FONT_UNINTELLIGIBLE_NV";
        case 0x936c: return "GL_STANDARD_FONT_FORMAT_NV";
        case 0x936d: return "GL_FRAGMENT_INPUT_NV";
#endif
#if defined(GL_NV_uniform_buffer_unified_memory)
        case 0x936e: return "GL_UNIFORM_BUFFER_UNIFIED_NV";
        case 0x936f: return "GL_UNIFORM_BUFFER_ADDRESS_NV";
        case 0x9370: return "GL_UNIFORM_BUFFER_LENGTH_NV";
#endif
#if defined(GL_NV_internalformat_sample_query)
        case 0x9371: return "GL_MULTISAMPLES_NV";
        case 0x9372: return "GL_SUPERSAMPLE_SCALE_X_NV";
        case 0x9373: return "GL_SUPERSAMPLE_SCALE_Y_NV";
        case 0x9374: return "GL_CONFORMANT_NV";
#endif
#if defined(GL_NV_conservative_raster_dilate)
        case 0x9379: return "GL_CONSERVATIVE_RASTER_DILATE_NV";
        case 0x937a: return "GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV";
        case 0x937b: return "GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV";
#endif
#if defined(GL_NV_clip_space_w_scaling)
        case 0x937c: return "GL_VIEWPORT_POSITION_W_SCALE_NV";
        case 0x937d: return "GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV";
        case 0x937e: return "GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV";
#endif
#if defined(GL_VERSION_4_2)
        case 0x9380: return "GL_NUM_SAMPLE_COUNTS";
#endif
#if defined(GL_ARB_ES3_2_compatibility)
        case 0x9381: return "GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB";
        case 0x9382: return "GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB";
#endif
#if defined(GL_KHR_texture_compression_astc_hdr)
        case 0x93b0: return "GL_COMPRESSED_RGBA_ASTC_4x4_KHR";
        case 0x93b1: return "GL_COMPRESSED_RGBA_ASTC_5x4_KHR";
        case 0x93b2: return "GL_COMPRESSED_RGBA_ASTC_5x5_KHR";
        case 0x93b3: return "GL_COMPRESSED_RGBA_ASTC_6x5_KHR";
        case 0x93b4: return "GL_COMPRESSED_RGBA_ASTC_6x6_KHR";
        case 0x93b5: return "GL_COMPRESSED_RGBA_ASTC_8x5_KHR";
        case 0x93b6: return "GL_COMPRESSED_RGBA_ASTC_8x6_KHR";
        case 0x93b7: return "GL_COMPRESSED_RGBA_ASTC_8x8_KHR";
        case 0x93b8: return "GL_COMPRESSED_RGBA_ASTC_10x5_KHR";
        case 0x93b9: return "GL_COMPRESSED_RGBA_ASTC_10x6_KHR";
        case 0x93ba: return "GL_COMPRESSED_RGBA_ASTC_10x8_KHR";
        case 0x93bb: return "GL_COMPRESSED_RGBA_ASTC_10x10_KHR";
        case 0x93bc: return "GL_COMPRESSED_RGBA_ASTC_12x10_KHR";
        case 0x93bd: return "GL_COMPRESSED_RGBA_ASTC_12x12_KHR";
        case 0x93d0: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR";
        case 0x93d1: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR";
        case 0x93d2: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR";
        case 0x93d3: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR";
        case 0x93d4: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR";
        case 0x93d5: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR";
        case 0x93d6: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR";
        case 0x93d7: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR";
        case 0x93d8: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR";
        case 0x93d9: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR";
        case 0x93da: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR";
        case 0x93db: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR";
        case 0x93dc: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR";
        case 0x93dd: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR";
#endif
#if defined(GL_INTEL_performance_query)
        case 0x94f0: return "GL_PERFQUERY_COUNTER_EVENT_INTEL";
        case 0x94f1: return "GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL";
        case 0x94f2: return "GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL";
        case 0x94f3: return "GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL";
        case 0x94f4: return "GL_PERFQUERY_COUNTER_RAW_INTEL";
        case 0x94f5: return "GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL";
        case 0x94f8: return "GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL";
        case 0x94f9: return "GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL";
        case 0x94fa: return "GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL";
        case 0x94fb: return "GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL";
        case 0x94fc: return "GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL";
        case 0x94fd: return "GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL";
        case 0x94fe: return "GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL";
        case 0x94ff: return "GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL";
        case 0x9500: return "GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL";
#endif
#if defined(GL_EXT_semaphore)
        case 0x9530: return "GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT";
        case 0x9531: return "GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT";
#endif
#if defined(GL_NV_query_resource)
        case 0x9540: return "GL_QUERY_RESOURCE_TYPE_VIDMEM_ALLOC_NV";
        case 0x9542: return "GL_QUERY_RESOURCE_MEMTYPE_VIDMEM_NV";
        case 0x9544: return "GL_QUERY_RESOURCE_SYS_RESERVED_NV";
        case 0x9545: return "GL_QUERY_RESOURCE_TEXTURE_NV";
        case 0x9546: return "GL_QUERY_RESOURCE_RENDERBUFFER_NV";
        case 0x9547: return "GL_QUERY_RESOURCE_BUFFEROBJECT_NV";
#endif
#if defined(GL_NV_gpu_multicast)
        case 0x9548: return "GL_PER_GPU_STORAGE_NV";
        case 0x9549: return "GL_MULTICAST_PROGRAMMABLE_SAMPLE_LOCATION_NV";
#endif
#if defined(GL_NV_conservative_raster_pre_snap_triangles)
        case 0x954d: return "GL_CONSERVATIVE_RASTER_MODE_NV";
        case 0x954e: return "GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV";
        case 0x954f: return "GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV";
#endif
#if defined(GL_NV_conservative_raster_pre_snap)
        case 0x9550: return "GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_NV";
#endif
        case 0x9551:
#if defined(GL_VERSION_4_6)
                    return "GL_SHADER_BINARY_FORMAT_SPIR_V";
#endif
#if defined(GL_ARB_gl_spirv)
                    return "GL_SHADER_BINARY_FORMAT_SPIR_V_ARB";
#endif
            break;
        case 0x9552:
#if defined(GL_VERSION_4_6)
                    return "GL_SPIR_V_BINARY";
#endif
#if defined(GL_ARB_gl_spirv)
                    return "GL_SPIR_V_BINARY_ARB";
#endif
            break;
#if defined(GL_VERSION_4_6)
        case 0x9553: return "GL_SPIR_V_EXTENSIONS";
        case 0x9554: return "GL_NUM_SPIR_V_EXTENSIONS";
#endif
#if defined(GL_NV_gpu_multicast)
        case 0x9558: return "GL_RENDER_GPU_MASK_NV";
#endif
#if defined(GL_EXT_memory_object)
        case 0x9580: return "GL_TEXTURE_TILING_EXT";
        case 0x9581: return "GL_DEDICATED_MEMORY_OBJECT_EXT";
        case 0x9582: return "GL_NUM_TILING_TYPES_EXT";
        case 0x9583: return "GL_TILING_TYPES_EXT";
        case 0x9584: return "GL_OPTIMAL_TILING_EXT";
        case 0x9585: return "GL_LINEAR_TILING_EXT";
#endif
#if defined(GL_EXT_memory_object_fd)
        case 0x9586: return "GL_HANDLE_TYPE_OPAQUE_FD_EXT";
#endif
#if defined(GL_EXT_memory_object_win32)
        case 0x9587: return "GL_HANDLE_TYPE_OPAQUE_WIN32_EXT";
        case 0x9588: return "GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT";
        case 0x9589: return "GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT";
        case 0x958a: return "GL_HANDLE_TYPE_D3D12_RESOURCE_EXT";
        case 0x958b: return "GL_HANDLE_TYPE_D3D11_IMAGE_EXT";
        case 0x958c: return "GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT";
#endif
#if defined(GL_EXT_semaphore)
        case 0x958d: return "GL_LAYOUT_GENERAL_EXT";
        case 0x958e: return "GL_LAYOUT_COLOR_ATTACHMENT_EXT";
        case 0x958f: return "GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT";
        case 0x9590: return "GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT";
        case 0x9591: return "GL_LAYOUT_SHADER_READ_ONLY_EXT";
        case 0x9592: return "GL_LAYOUT_TRANSFER_SRC_EXT";
        case 0x9593: return "GL_LAYOUT_TRANSFER_DST_EXT";
#endif
#if defined(GL_EXT_semaphore_win32)
        case 0x9594: return "GL_HANDLE_TYPE_D3D12_FENCE_EXT";
        case 0x9595: return "GL_D3D12_FENCE_VALUE_EXT";
#endif
#if defined(GL_EXT_memory_object)
        case 0x9596: return "GL_NUM_DEVICE_UUIDS_EXT";
        case 0x9597: return "GL_DEVICE_UUID_EXT";
        case 0x9598: return "GL_DRIVER_UUID_EXT";
#endif
#if defined(GL_EXT_memory_object_win32)
        case 0x9599: return "GL_DEVICE_LUID_EXT";
        case 0x959a: return "GL_DEVICE_NODE_MASK_EXT";
#endif
#if defined(GL_EXT_memory_object)
        case 0x959b: return "GL_PROTECTED_MEMORY_OBJECT_EXT";
#endif
#if defined(GL_OVR_multiview)
        case 0x9630: return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR";
        case 0x9631: return "GL_MAX_VIEWS_OVR";
        case 0x9632: return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR";
        case 0x9633: return "GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR";
#endif
#if defined(GL_IBM_rasterpos_clip)
        case 0x19262: return "GL_RASTER_POSITION_UNCLIPPED_IBM";
#endif
#if defined(GL_IBM_cull_vertex)
        case 0x1928a: return "GL_CULL_VERTEX_IBM";
#endif
#if defined(GL_IBM_static_data)
        case 0x19294: return "GL_ALL_STATIC_DATA_IBM";
        case 0x19295: return "GL_STATIC_VERTEX_ARRAY_IBM";
#endif
#if defined(GL_IBM_vertex_array_lists)
        case 0x1929e: return "GL_VERTEX_ARRAY_LIST_IBM";
        case 0x1929f: return "GL_NORMAL_ARRAY_LIST_IBM";
        case 0x192a0: return "GL_COLOR_ARRAY_LIST_IBM";
        case 0x192a1: return "GL_INDEX_ARRAY_LIST_IBM";
        case 0x192a2: return "GL_TEXTURE_COORD_ARRAY_LIST_IBM";
        case 0x192a3: return "GL_EDGE_FLAG_ARRAY_LIST_IBM";
        case 0x192a4: return "GL_FOG_COORDINATE_ARRAY_LIST_IBM";
        case 0x192a5: return "GL_SECONDARY_COLOR_ARRAY_LIST_IBM";
        case 0x192a8: return "GL_VERTEX_ARRAY_LIST_STRIDE_IBM";
        case 0x192a9: return "GL_NORMAL_ARRAY_LIST_STRIDE_IBM";
        case 0x192aa: return "GL_COLOR_ARRAY_LIST_STRIDE_IBM";
        case 0x192ab: return "GL_INDEX_ARRAY_LIST_STRIDE_IBM";
        case 0x192ac: return "GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM";
        case 0x192ad: return "GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM";
        case 0x192ae: return "GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM";
        case 0x192af: return "GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM";
#endif
#if defined(GL_PGI_misc_hints)
        case 0x1a1f8: return "GL_PREFER_DOUBLEBUFFER_HINT_PGI";
        case 0x1a1fd: return "GL_CONSERVE_MEMORY_HINT_PGI";
        case 0x1a1fe: return "GL_RECLAIM_MEMORY_HINT_PGI";
        case 0x1a202: return "GL_NATIVE_GRAPHICS_HANDLE_PGI";
        case 0x1a203: return "GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI";
        case 0x1a204: return "GL_NATIVE_GRAPHICS_END_HINT_PGI";
        case 0x1a20c: return "GL_ALWAYS_FAST_HINT_PGI";
        case 0x1a20d: return "GL_ALWAYS_SOFT_HINT_PGI";
        case 0x1a20e: return "GL_ALLOW_DRAW_OBJ_HINT_PGI";
        case 0x1a20f: return "GL_ALLOW_DRAW_WIN_HINT_PGI";
        case 0x1a210: return "GL_ALLOW_DRAW_FRG_HINT_PGI";
        case 0x1a211: return "GL_ALLOW_DRAW_MEM_HINT_PGI";
        case 0x1a216: return "GL_STRICT_DEPTHFUNC_HINT_PGI";
        case 0x1a217: return "GL_STRICT_LIGHTING_HINT_PGI";
        case 0x1a218: return "GL_STRICT_SCISSOR_HINT_PGI";
        case 0x1a219: return "GL_FULL_STIPPLE_HINT_PGI";
        case 0x1a220: return "GL_CLIP_NEAR_HINT_PGI";
        case 0x1a221: return "GL_CLIP_FAR_HINT_PGI";
        case 0x1a222: return "GL_WIDE_LINE_HINT_PGI";
        case 0x1a223: return "GL_BACK_NORMALS_HINT_PGI";
#endif
#if defined(GL_PGI_vertex_hints)
        case 0x1a22a: return "GL_VERTEX_DATA_HINT_PGI";
        case 0x1a22b: return "GL_VERTEX_CONSISTENT_HINT_PGI";
        case 0x1a22c: return "GL_MATERIAL_SIDE_HINT_PGI";
        case 0x1a22d: return "GL_MAX_VERTEX_HINT_PGI";
#endif
    }
    return "<UNKNOWN ENUM>";
}

#ifdef _MSC_VER
#pragma warning(pop) 
#endif

