"use strict";
/* eslint no-shadow:0, import/export:0 */
// Plugin decorator
Object.defineProperty(exports, "__esModule", { value: true });
exports.NvimPlugin = exports.Neovim = void 0;
exports.plugin = plugin;
const properties_1 = require("./properties");
const Neovim_1 = require("../api/Neovim");
Object.defineProperty(exports, "Neovim", { enumerable: true, get: function () { return Neovim_1.Neovim; } });
const NvimPlugin_1 = require("../host/NvimPlugin");
Object.defineProperty(exports, "NvimPlugin", { enumerable: true, get: function () { return NvimPlugin_1.NvimPlugin; } });
function wrapper(cls, options) {
    return class extends cls {
        constructor(...args) {
            const plugin = args[0];
            super(plugin.nvim, plugin);
            this.setApi(plugin.nvim);
            if (options) {
                plugin.setOptions(options);
            }
            plugin.nvim.logger.info(`Decorating class ${cls}`);
            // Search for decorated methods
            Object.getOwnPropertyNames(cls.prototype).forEach(methodName => {
                plugin.nvim.logger.info(`Method name ${methodName}`);
                plugin.nvim.logger.info(`${cls.prototype[methodName]} ${typeof cls.prototype[methodName]}`);
                plugin.nvim.logger.info(`${this} ${typeof this}`);
                const method = cls.prototype[methodName];
                if (method && method[properties_1.NVIM_SPEC]) {
                    const spec = method[properties_1.NVIM_SPEC];
                    switch (spec.type) {
                        case 'autocmd':
                            const autoCmdOpts = {
                                pattern: spec.opts.pattern,
                                sync: spec.sync,
                            };
                            if (typeof spec.opts.eval !== 'undefined') {
                                autoCmdOpts.eval = spec.opts.eval;
                            }
                            plugin.registerAutocmd(spec.name, [this, method], autoCmdOpts);
                            break;
                        case 'command':
                            const cmdOpts = {
                                sync: spec.sync,
                            };
                            if (typeof spec.opts.range !== 'undefined') {
                                cmdOpts.range = spec.opts.range;
                            }
                            if (typeof spec.opts.nargs !== 'undefined') {
                                cmdOpts.nargs = spec.opts.nargs;
                            }
                            if (typeof spec.opts.complete !== 'undefined') {
                                cmdOpts.complete = spec.opts.complete;
                            }
                            plugin.registerCommand(spec.name, [this, method], cmdOpts);
                            break;
                        case 'function':
                            const funcOpts = {
                                sync: spec.sync,
                            };
                            if (typeof spec.opts.range !== 'undefined') {
                                funcOpts.range = spec.opts.range;
                            }
                            if (typeof spec.opts.eval !== 'undefined') {
                                funcOpts.eval = spec.opts.eval;
                            }
                            plugin.registerFunction(spec.name, [this, method], funcOpts);
                            break;
                        default:
                            break;
                    }
                }
            });
        }
        setApi(nvim) {
            this.nvim = nvim;
        }
    };
}
function plugin(outter) {
    /**
     * Decorator should support
     *
     * @Plugin(opts)
     * class TestPlug {}
     *
     * and
     *
     * @Plugin
     * class TestPlug {}
     *
     *and
     *
     * Plugin(opts)(TestPlugin)
     *
     * or
     *
     * Plugin(TestPlugin)
     */
    return typeof outter !== 'function'
        ? (cls) => wrapper(cls, outter)
        : wrapper(outter);
}
