#include "VMMPhaseFunctions.h"

namespace openpgl
{

std::array<VMMPhaseFunctionRepresentation, OPENPGL_VMM_NUM_PHASE_REP> VMMSingleLobeHenyeyGreensteinOracle::representations;
float VMMSingleLobeHenyeyGreensteinOracle::minMeanCosine;  //{0.f};
float VMMSingleLobeHenyeyGreensteinOracle::maxMeanCosine;  //{0.99f};
int VMMSingleLobeHenyeyGreensteinOracle::numRepresentations;

void VMMSingleLobeHenyeyGreensteinOracle::init()
{
    /* VMM representations of the single lobe HG phase function.
       The 3-lobe VMMs are fitted using a least squares optimization framework
       as described by S. Herholz:
                - "Path Guiding in Production"
                - - "Volumetric Zero-variance Based Path Guiding" (Chapter 11.5)
    */

    minMeanCosine = 0.0f;
    maxMeanCosine = 0.99f;
    numRepresentations = 128;

    representations[0].K = 3;
    representations[0].g = 0.0f;
    representations[0].weights[0] = 0.01688512612073299f;
    representations[0].meanCosines[0] = 0.0f;
    representations[0].kappas[0] = 0.0f;
    representations[0].normalizations[0] = 0.07957747154594767f;
    representations[0].weights[1] = 0.34940739552081895f;
    representations[0].meanCosines[1] = 0.0f;
    representations[0].kappas[1] = 0.0f;
    representations[0].normalizations[1] = 0.07957747154594767f;
    representations[0].weights[2] = 0.6337074783584481f;
    representations[0].meanCosines[2] = 0.0f;
    representations[0].kappas[2] = 0.0f;
    representations[0].normalizations[2] = 0.07957747154594767f;
    representations[0].weights[3] = 0.0f;
    representations[0].meanCosines[3] = 0.0f;
    representations[0].kappas[3] = 0.0f;
    representations[0].normalizations[3] = 0.0f;

    representations[1].K = 3;
    representations[1].g = 0.007795275590551181f;
    representations[1].weights[0] = 0.01688512612254555f;
    representations[1].meanCosines[0] = 0.03588398182493312f;
    representations[1].kappas[0] = 0.10774447737138962f;
    representations[1].normalizations[0] = 0.08845920147738665f;
    representations[1].weights[1] = 0.34940739552017397f;
    representations[1].meanCosines[1] = 0.014362686373439479f;
    representations[1].kappas[1] = 0.043093986007026464f;
    representations[1].normalizations[1] = 0.08305603677895068f;
    representations[1].weights[2] = 0.6337074783572806f;
    representations[1].meanCosines[2] = 0.003425584458792068f;
    representations[1].kappas[2] = 0.010276833773244303f;
    representations[1].normalizations[2] = 0.08039807745351672f;
    representations[1].weights[3] = 0.0f;
    representations[1].meanCosines[3] = 0.0f;
    representations[1].kappas[3] = 0.0f;
    representations[1].normalizations[3] = 0.0f;

    representations[2].K = 3;
    representations[2].g = 0.015590551181102362f;
    representations[2].weights[0] = 0.01688437903886321f;
    representations[2].meanCosines[0] = 0.07165186574299764f;
    representations[2].kappas[0] = 0.21569511380458395f;
    representations[2].normalizations[0] = 0.09797223006527885f;
    representations[2].weights[1] = 0.34940741896923394f;
    representations[2].meanCosines[1] = 0.028726867492049023f;
    representations[2].kappas[1] = 0.08622805434824445f;
    representations[2].normalizations[1] = 0.08663641125148722f;
    representations[2].weights[2] = 0.6337082019919029f;
    representations[2].meanCosines[2] = 0.006852355953716443f;
    representations[2].kappas[2] = 0.02055771139312781f;
    representations[2].normalizations[2] = 0.08122461225390147f;
    representations[2].weights[3] = 0.0f;
    representations[2].meanCosines[3] = 0.0f;
    representations[2].kappas[3] = 0.0f;
    representations[2].normalizations[3] = 0.0f;

    representations[3].K = 3;
    representations[3].g = 0.02338582677165354f;
    representations[3].weights[0] = 0.01688251644451822f;
    representations[3].meanCosines[0] = 0.10719000956269134f;
    representations[3].kappas[0] = 0.3240618203310573f;
    representations[3].normalizations[0] = 0.10813182001250154f;
    representations[3].weights[1] = 0.34940749421528944f;
    representations[3].meanCosines[1] = 0.043094103168718915f;
    representations[3].kappas[1] = 0.12944266757431747f;
    representations[3].normalizations[1] = 0.09032214696897492f;
    representations[3].weights[2] = 0.6337099893401924f;
    representations[3].meanCosines[2] = 0.010281511556840308f;
    representations[3].kappas[2] = 0.03084670860680498f;
    representations[3].normalizations[2] = 0.0820574128582956f;
    representations[3].weights[3] = 0.0f;
    representations[3].meanCosines[3] = 0.0f;
    representations[3].kappas[3] = 0.0f;
    representations[3].normalizations[3] = 0.0f;

    representations[4].K = 3;
    representations[4].g = 0.031181102362204723f;
    representations[4].weights[0] = 0.016879170271827615f;
    representations[4].meanCosines[0] = 0.14238854747740515f;
    representations[4].kappas[0] = 0.43305883676258095f;
    representations[4].normalizations[0] = 0.1189527446874129f;
    representations[4].weights[1] = 0.3494076744789957f;
    representations[4].meanCosines[1] = 0.05746593132255443f;
    representations[4].kappas[1] = 0.17277859481192268f;
    representations[4].normalizations[1] = 0.09411704443372311f;
    representations[4].weights[2] = 0.6337131552491766f;
    representations[4].meanCosines[2] = 0.013714266562698281f;
    representations[4].kappas[2] = 0.04114795944743138f;
    representations[4].normalizations[2] = 0.08289682936908468f;
    representations[4].weights[3] = 0.0f;
    representations[4].meanCosines[3] = 0.0f;
    representations[4].kappas[3] = 0.0f;
    representations[4].normalizations[3] = 0.0f;

    representations[5].K = 3;
    representations[5].g = 0.0389763779527559f;
    representations[5].weights[0] = 0.01688212081880487f;
    representations[5].meanCosines[0] = 0.17712402739360683f;
    representations[5].kappas[0] = 0.5428458438663006f;
    representations[5].normalizations[0] = 0.13044306812363982f;
    representations[5].weights[1] = 0.3494073468644722f;
    representations[5].meanCosines[1] = 0.07184106550223494f;
    representations[5].kappas[1] = 0.21626860707980294f;
    representations[5].normalizations[1] = 0.09802439780640325f;
    representations[5].weights[2] = 0.6337105323167227f;
    representations[5].meanCosines[2] = 0.017151877226518623f;
    representations[5].kappas[2] = 0.05146572636419975f;
    representations[5].normalizations[2] = 0.08374323102430331f;
    representations[5].weights[3] = 0.0f;
    representations[5].meanCosines[3] = 0.0f;
    representations[5].kappas[3] = 0.0f;
    representations[5].normalizations[3] = 0.0f;

    representations[6].K = 3;
    representations[6].g = 0.04677165354330708f;
    representations[6].weights[0] = 0.016911780064021775f;
    representations[6].meanCosines[0] = 0.2112319819771247f;
    representations[6].kappas[0] = 0.6534261871553656f;
    representations[6].normalizations[0] = 0.1425912900682853f;
    representations[6].weights[1] = 0.349406832800622f;
    representations[6].meanCosines[1] = 0.08621065078660167f;
    representations[6].kappas[1] = 0.25992303076611534f;
    representations[6].normalizations[1] = 0.10204555335170774f;
    representations[6].weights[2] = 0.6336813871353562f;
    representations[6].meanCosines[2] = 0.020595569081659132f;
    representations[6].kappas[2] = 0.061804187012100144f;
    representations[6].normalizations[2] = 0.08459698890239761f;
    representations[6].weights[3] = 0.0f;
    representations[6].meanCosines[3] = 0.0f;
    representations[6].kappas[3] = 0.0f;
    representations[6].normalizations[3] = 0.0f;

    representations[7].K = 3;
    representations[7].g = 0.054566929133858265f;
    representations[7].weights[0] = 0.01698431443686933f;
    representations[7].meanCosines[0] = 0.24453864844476111f;
    representations[7].kappas[0] = 0.764722497664732f;
    representations[7].normalizations[0] = 0.1553715185073856f;
    representations[7].weights[1] = 0.34940688968611067f;
    representations[7].meanCosines[1] = 0.10056215754823958f;
    representations[7].kappas[1] = 0.3037411707083553f;
    representations[7].normalizations[1] = 0.10618074302045714f;
    representations[7].weights[2] = 0.6336087958770199f;
    representations[7].meanCosines[2] = 0.024046530657178572f;
    representations[7].kappas[2] = 0.07216741718299197f;
    representations[7].normalizations[2] = 0.08545847429102746f;
    representations[7].weights[3] = 0.0f;
    representations[7].meanCosines[3] = 0.0f;
    representations[7].kappas[3] = 0.0f;
    representations[7].normalizations[3] = 0.0f;

    representations[8].K = 3;
    representations[8].g = 0.06236220472440945f;
    representations[8].weights[0] = 0.017178062978008293f;
    representations[8].meanCosines[0] = 0.2766513150830249f;
    representations[8].kappas[0] = 0.8758112176782963f;
    representations[8].normalizations[0] = 0.1686489715158632f;
    representations[8].weights[1] = 0.34940624966149436f;
    representations[8].meanCosines[1] = 0.11484549630313552f;
    representations[8].kappas[1] = 0.34760648721076526f;
    representations[8].normalizations[1] = 0.11041871452215614f;
    representations[8].weights[2] = 0.6334156873604974f;
    representations[8].meanCosines[2] = 0.027505759421599836f;
    representations[8].kappas[2] = 0.08255892966571578f;
    representations[8].normalizations[2] = 0.08632801972235461f;
    representations[8].weights[3] = 0.0f;
    representations[8].meanCosines[3] = 0.0f;
    representations[8].kappas[3] = 0.0f;
    representations[8].normalizations[3] = 0.0f;

    representations[9].K = 3;
    representations[9].g = 0.07015748031496062f;
    representations[9].weights[0] = 0.017371006808467492f;
    representations[9].meanCosines[0] = 0.30782730487102705f;
    representations[9].kappas[0] = 0.9879265175144101f;
    representations[9].normalizations[0] = 0.18254148705094658f;
    representations[9].weights[1] = 0.34928506189089986f;
    representations[9].meanCosines[1] = 0.129131147364166f;
    representations[9].kappas[1] = 0.3917729556957539f;
    representations[9].normalizations[1] = 0.11478405680653793f;
    representations[9].weights[2] = 0.6333439313006328f;
    representations[9].meanCosines[2] = 0.030983196797823992f;
    representations[9].kappas[2] = 0.09300913271687389f;
    representations[9].normalizations[2] = 0.08720823784227144f;
    representations[9].weights[3] = 0.0f;
    representations[9].meanCosines[3] = 0.0f;
    representations[9].kappas[3] = 0.0f;
    representations[9].normalizations[3] = 0.0f;

    representations[10].K = 3;
    representations[10].g = 0.0779527559055118f;
    representations[10].weights[0] = 0.017584981738709496f;
    representations[10].meanCosines[0] = 0.33794984524349103f;
    representations[10].kappas[0] = 1.1009972551142273f;
    representations[10].normalizations[0] = 0.1970156107265375f;
    representations[10].weights[1] = 0.349155889550176f;
    representations[10].meanCosines[1] = 0.1433912150580251f;
    representations[10].kappas[1] = 0.4361939745876183f;
    representations[10].normalizations[1] = 0.11927274711513454f;
    representations[10].weights[2] = 0.6332591287111146f;
    representations[10].meanCosines[2] = 0.034474217471298856f;
    representations[10].kappas[2] = 0.10350469317865921f;
    representations[10].normalizations[2] = 0.08809808759230493f;
    representations[10].weights[3] = 0.0f;
    representations[10].meanCosines[3] = 0.0f;
    representations[10].kappas[3] = 0.0f;
    representations[10].normalizations[3] = 0.0f;

    representations[11].K = 3;
    representations[11].g = 0.08574803149606298f;
    representations[11].weights[0] = 0.017809322999872215f;
    representations[11].meanCosines[0] = 0.3670064050195432f;
    representations[11].kappas[0] = 1.2152757532992868f;
    representations[11].normalizations[0] = 0.21207747870839172f;
    representations[11].weights[1] = 0.34897319658417403f;
    representations[11].meanCosines[1] = 0.1576390635881601f;
    representations[11].kappas[1] = 0.4809515295890107f;
    representations[11].normalizations[1] = 0.12389359991430093f;
    representations[11].weights[2] = 0.6332174804159536f;
    representations[11].meanCosines[2] = 0.037984321862009805f;
    representations[11].kappas[2] = 0.11406273217887339f;
    representations[11].normalizations[2] = 0.08899910551739097f;
    representations[11].weights[3] = 0.0f;
    representations[11].meanCosines[3] = 0.0f;
    representations[11].kappas[3] = 0.0f;
    representations[11].normalizations[3] = 0.0f;

    representations[12].K = 3;
    representations[12].g = 0.09354330708661417f;
    representations[12].weights[0] = 0.01826527507863583f;
    representations[12].meanCosines[0] = 0.3942271824887726f;
    representations[12].kappas[0] = 1.3277678345776889f;
    representations[12].normalizations[0] = 0.2272905167499025f;
    representations[12].weights[1] = 0.3497662056173708f;
    representations[12].meanCosines[1] = 0.17148377049971156f;
    representations[12].kappas[1] = 0.5248424174065418f;
    representations[12].normalizations[1] = 0.12851914003354303f;
    representations[12].weights[2] = 0.6319685193039934f;
    representations[12].meanCosines[2] = 0.04141831747731281f;
    representations[12].kappas[2] = 0.12439730097148566f;
    representations[12].normalizations[2] = 0.08988675023967237f;
    representations[12].weights[3] = 0.0f;
    representations[12].meanCosines[3] = 0.0f;
    representations[12].kappas[3] = 0.0f;
    representations[12].normalizations[3] = 0.0f;

    representations[13].K = 3;
    representations[13].g = 0.10133858267716535f;
    representations[13].weights[0] = 0.01876291998771093f;
    representations[13].meanCosines[0] = 0.42020042532807644f;
    representations[13].kappas[0] = 1.4408083884538716f;
    representations[13].normalizations[0] = 0.24292636119361116f;
    representations[13].weights[1] = 0.35061939871117465f;
    representations[13].meanCosines[1] = 0.18520867376560435f;
    representations[13].kappas[1] = 0.5687835020385287f;
    representations[13].normalizations[1] = 0.13324175902122393f;
    representations[13].weights[2] = 0.6306176813011145f;
    representations[13].meanCosines[2] = 0.04484781190877385f;
    representations[13].kappas[2] = 0.13472420647644337f;
    representations[13].normalizations[2] = 0.09077936160410964f;
    representations[13].weights[3] = 0.0f;
    representations[13].meanCosines[3] = 0.0f;
    representations[13].kappas[3] = 0.0f;
    representations[13].normalizations[3] = 0.0f;

    representations[14].K = 3;
    representations[14].g = 0.10913385826771653f;
    representations[14].weights[0] = 0.019306961289135425f;
    representations[14].meanCosines[0] = 0.44492057851788697f;
    representations[14].kappas[0] = 1.5543850149507152f;
    representations[14].normalizations[0] = 0.25895176916401214f;
    representations[14].weights[1] = 0.35154945670839527f;
    representations[14].meanCosines[1] = 0.19879827489247553f;
    representations[14].kappas[1] = 0.6127546945467943f;
    representations[14].normalizations[1] = 0.1380578383493104f;
    representations[14].weights[2] = 0.6291435820024692f;
    representations[14].meanCosines[2] = 0.0482705272418375f;
    representations[14].kappas[2] = 0.14503705196651462f;
    representations[14].normalizations[2] = 0.0916763629745512f;
    representations[14].weights[3] = 0.0f;
    representations[14].meanCosines[3] = 0.0f;
    representations[14].kappas[3] = 0.0f;
    representations[14].normalizations[3] = 0.0f;

    representations[15].K = 3;
    representations[15].g = 0.11692913385826771f;
    representations[15].weights[0] = 0.01989845510400388f;
    representations[15].meanCosines[0] = 0.4684068719141528f;
    representations[15].kappas[0] = 1.6685346475413192f;
    representations[15].normalizations[0] = 0.2753414373527367f;
    representations[15].weights[1] = 0.35255534710456443f;
    representations[15].meanCosines[1] = 0.21224370805221723f;
    representations[15].kappas[1] = 0.6567552077580507f;
    representations[15].normalizations[1] = 0.1429656644773955f;
    representations[15].weights[2] = 0.6275461977914317f;
    representations[15].meanCosines[2] = 0.051685704986140286f;
    representations[15].kappas[2] = 0.155334002273931f;
    representations[15].normalizations[2] = 0.09257756389054712f;
    representations[15].weights[3] = 0.0f;
    representations[15].meanCosines[3] = 0.0f;
    representations[15].kappas[3] = 0.0f;
    representations[15].normalizations[3] = 0.0f;

    representations[16].K = 3;
    representations[16].g = 0.1247244094488189f;
    representations[16].weights[0] = 0.020535354184989436f;
    representations[16].meanCosines[0] = 0.49069955616971095f;
    representations[16].kappas[0] = 1.7833511441174834f;
    representations[16].normalizations[0] = 0.292080078167316f;
    representations[16].weights[1] = 0.353622508898923f;
    representations[16].meanCosines[1] = 0.22554330566749264f;
    representations[16].kappas[1] = 0.7008064498892924f;
    representations[16].normalizations[1] = 0.14796596420736946f;
    representations[16].weights[2] = 0.6258421369160876f;
    representations[16].meanCosines[2] = 0.055094314525624195f;
    representations[16].kappas[2] = 0.16561842664237564f;
    representations[16].normalizations[2] = 0.09348322926408528f;
    representations[16].weights[3] = 0.0f;
    representations[16].meanCosines[3] = 0.0f;
    representations[16].kappas[3] = 0.0f;
    representations[16].normalizations[3] = 0.0f;

    representations[17].K = 3;
    representations[17].g = 0.13251968503937006f;
    representations[17].weights[0] = 0.021218949410057832f;
    representations[17].meanCosines[0] = 0.5118356933074103f;
    representations[17].kappas[0] = 1.8988787667383773f;
    representations[17].normalizations[0] = 0.30914733250021437f;
    representations[17].weights[1] = 0.3547509744956134f;
    representations[17].meanCosines[1] = 0.23868968600098744f;
    representations[17].kappas[1] = 0.7449098193050739f;
    representations[17].normalizations[1] = 0.15305721242482156f;
    representations[17].weights[2] = 0.6240300760943289f;
    representations[17].meanCosines[2] = 0.05849576027428436f;
    representations[17].kappas[2] = 0.1758889715094559f;
    representations[17].normalizations[2] = 0.09439321119322305f;
    representations[17].weights[3] = 0.0f;
    representations[17].meanCosines[3] = 0.0f;
    representations[17].kappas[3] = 0.0f;
    representations[17].normalizations[3] = 0.0f;

    representations[18].K = 3;
    representations[18].g = 0.14031496062992124f;
    representations[18].weights[0] = 0.021949824475763605f;
    representations[18].meanCosines[0] = 0.5318607735970473f;
    representations[18].kappas[0] = 2.0151765919095097f;
    representations[18].normalizations[0] = 0.32652706617217647f;
    representations[18].weights[1] = 0.355937499042096f;
    representations[18].meanCosines[1] = 0.2516775828350221f;
    representations[18].kappas[1] = 0.7890721855355327f;
    representations[18].normalizations[1] = 0.15823845763667177f;
    representations[18].weights[2] = 0.6221126764821404f;
    representations[18].meanCosines[2] = 0.06188987023100114f;
    representations[18].kappas[2] = 0.1861455542022604f;
    representations[18].normalizations[2] = 0.095307472119436f;
    representations[18].weights[3] = 0.0f;
    representations[18].meanCosines[3] = 0.0f;
    representations[18].kappas[3] = 0.0f;
    representations[18].normalizations[3] = 0.0f;

    representations[19].K = 3;
    representations[19].g = 0.14811023622047242f;
    representations[19].weights[0] = 0.02272913643627242f;
    representations[19].meanCosines[0] = 0.5508226752301884f;
    representations[19].kappas[0] = 2.1322958845677973f;
    representations[19].normalizations[0] = 0.34420411555954816f;
    representations[19].weights[1] = 0.35718094247354754f;
    representations[19].meanCosines[1] = 0.2645011566729811f;
    representations[19].kappas[1] = 0.83329691124312f;
    representations[19].normalizations[1] = 0.16350830114410747f;
    representations[19].weights[2] = 0.6200899210901799f;
    representations[19].meanCosines[2] = 0.06527619808965157f;
    representations[19].kappas[2] = 0.19638725613213096f;
    representations[19].normalizations[2] = 0.09622589876681735f;
    representations[19].weights[3] = 0.0f;
    representations[19].meanCosines[3] = 0.0f;
    representations[19].kappas[3] = 0.0f;
    representations[19].normalizations[3] = 0.0f;

    representations[20].K = 3;
    representations[20].g = 0.1559055118110236f;
    representations[20].weights[0] = 0.02355816434063645f;
    representations[20].meanCosines[0] = 0.5687717007838606f;
    representations[20].kappas[0] = 2.2502875905814577f;
    representations[20].normalizations[0] = 0.3621653738462567f;
    representations[20].weights[1] = 0.35848028814660143f;
    representations[20].meanCosines[1] = 0.27715490333500015f;
    representations[20].kappas[1] = 0.877586789540549f;
    representations[20].normalizations[1] = 0.1688652288634378f;
    representations[20].weights[2] = 0.6179615475127621f;
    representations[20].meanCosines[2] = 0.06865425253449127f;
    representations[20].kappas[2] = 0.20661301330820872f;
    representations[20].normalizations[2] = 0.09714836239583771f;
    representations[20].weights[3] = 0.0f;
    representations[20].meanCosines[3] = 0.0f;
    representations[20].kappas[3] = 0.0f;
    representations[20].normalizations[3] = 0.0f;

    representations[21].K = 3;
    representations[21].g = 0.1637007874015748f;
    representations[21].weights[0] = 0.024437905025832977f;
    representations[21].meanCosines[0] = 0.5857605240246847f;
    representations[21].kappas[0] = 2.369210817881718f;
    representations[21].normalizations[0] = 0.3804010540382946f;
    representations[21].weights[1] = 0.3598331385814581f;
    representations[21].meanCosines[1] = 0.2896345928505576f;
    representations[21].kappas[1] = 0.9219473564693016f;
    representations[21].normalizations[1] = 0.17430802225670775f;
    representations[21].weights[2] = 0.615728956392709f;
    representations[21].meanCosines[2] = 0.0720237515533397f;
    representations[21].kappas[2] = 0.21682238610695004f;
    representations[21].normalizations[2] = 0.0980747884961609f;
    representations[21].weights[3] = 0.0f;
    representations[21].meanCosines[3] = 0.0f;
    representations[21].kappas[3] = 0.0f;
    representations[21].normalizations[3] = 0.0f;

    representations[22].K = 3;
    representations[22].g = 0.17149606299212597f;
    representations[22].weights[0] = 0.02536961631311807f;
    representations[22].meanCosines[0] = 0.6018414369673392f;
    representations[22].kappas[0] = 2.4891221301227326f;
    representations[22].normalizations[0] = 0.3989029937166436f;
    representations[22].weights[1] = 0.36123782439484414f;
    representations[22].meanCosines[1] = 0.3019360372422726f;
    representations[22].kappas[1] = 0.9663826317493759f;
    representations[22].normalizations[1] = 0.1798352546930349f;
    representations[22].weights[2] = 0.6133925592920377f;
    representations[22].meanCosines[2] = 0.07538429370718021f;
    representations[22].kappas[2] = 0.227014564370858f;
    representations[22].normalizations[2] = 0.09900506739744325f;
    representations[22].weights[3] = 0.0f;
    representations[22].meanCosines[3] = 0.0f;
    representations[22].kappas[3] = 0.0f;
    representations[22].normalizations[3] = 0.0f;

    representations[23].K = 3;
    representations[23].g = 0.17929133858267715f;
    representations[23].weights[0] = 0.026354489815300336f;
    representations[23].meanCosines[0] = 0.6170665107763216f;
    representations[23].kappas[0] = 2.6100823069456927f;
    representations[23].normalizations[0] = 0.41766558456512115f;
    representations[23].weights[1] = 0.3626921762477047f;
    representations[23].meanCosines[1] = 0.3140558294414811f;
    representations[23].kappas[1] = 1.01089774821742f;
    representations[23].normalizations[1] = 0.18544561804238008f;
    representations[23].weights[2] = 0.6109533339369949f;
    representations[23].meanCosines[2] = 0.07873555976785689f;
    representations[23].kappas[2] = 0.23718897773507175f;
    representations[23].normalizations[2] = 0.09993910949879477f;
    representations[23].weights[3] = 0.0f;
    representations[23].meanCosines[3] = 0.0f;
    representations[23].kappas[3] = 0.0f;
    representations[23].normalizations[3] = 0.0f;

    representations[24].K = 3;
    representations[24].g = 0.18708661417322833f;
    representations[24].weights[0] = 0.027393813480758946f;
    representations[24].meanCosines[0] = 0.6314864653894078f;
    representations[24].kappas[0] = 2.732153035175755f;
    representations[24].normalizations[0] = 0.43668514425861027f;
    representations[24].weights[1] = 0.36419412912481675f;
    representations[24].meanCosines[1] = 0.3259909557058004f;
    representations[24].kappas[1] = 1.0554976150974884f;
    representations[24].normalizations[1] = 0.19113776574149305f;
    representations[24].weights[2] = 0.6084120573944244f;
    representations[24].meanCosines[2] = 0.0820772098121622f;
    representations[24].kappas[2] = 0.24734498362097554f;
    representations[24].normalizations[2] = 0.10087681703497244f;
    representations[24].weights[3] = 0.0f;
    representations[24].meanCosines[3] = 0.0f;
    representations[24].kappas[3] = 0.0f;
    representations[24].normalizations[3] = 0.0f;

    representations[25].K = 3;
    representations[25].g = 0.19488188976377951f;
    representations[25].weights[0] = 0.02848894330183947f;
    representations[25].meanCosines[0] = 0.6451502887946322f;
    representations[25].kappas[0] = 2.855397531861139f;
    representations[25].normalizations[0] = 0.4559598770309509f;
    representations[25].weights[1] = 0.3657416121853952f;
    representations[25].meanCosines[1] = 0.3377388443459699f;
    representations[25].kappas[1] = 1.1001871225871562f;
    representations[25].normalizations[1] = 0.19691034293610063f;
    representations[25].weights[2] = 0.6057694445127654f;
    representations[25].meanCosines[2] = 0.08540889854051824f;
    representations[25].kappas[2] = 0.2574819131914485f;
    representations[25].normalizations[2] = 0.10181808818723857f;
    representations[25].weights[3] = 0.0f;
    representations[25].meanCosines[3] = 0.0f;
    representations[25].kappas[3] = 0.0f;
    representations[25].normalizations[3] = 0.0f;

    representations[26].K = 3;
    representations[26].g = 0.2026771653543307f;
    representations[26].weights[0] = 0.029641232684561578f;
    representations[26].meanCosines[0] = 0.6581050795977398f;
    representations[26].kappas[0] = 2.979882270484645f;
    representations[26].normalizations[0] = 0.47549000441135625f;
    representations[26].weights[1] = 0.36733232742198196f;
    representations[26].meanCosines[1] = 0.34929751692855454f;
    representations[26].kappas[1] = 1.1449717768941352f;
    representations[26].normalizations[1] = 0.20276207496603466f;
    representations[26].weights[2] = 0.6030264398934564f;
    representations[26].meanCosines[2] = 0.0887303226670217f;
    representations[26].kappas[2] = 0.267599215342648f;
    representations[26].normalizations[2] = 0.10276283052115276f;
    representations[26].weights[3] = 0.0f;
    representations[26].meanCosines[3] = 0.0f;
    representations[26].kappas[3] = 0.0f;
    representations[26].normalizations[3] = 0.0f;

    representations[27].K = 3;
    representations[27].g = 0.21047244094488188f;
    representations[27].weights[0] = 0.03085210788273518f;
    representations[27].meanCosines[0] = 0.6703956245596104f;
    representations[27].kappas[0] = 3.1056753595617264f;
    representations[27].normalizations[0] = 0.4952773717297844f;
    representations[27].weights[1] = 0.3689640002885473f;
    representations[27].meanCosines[1] = 0.3606653920204467f;
    representations[27].kappas[1] = 1.1898570305342318f;
    representations[27].normalizations[1] = 0.20869168777485336f;
    representations[27].weights[2] = 0.6001838918287176f;
    representations[27].meanCosines[2] = 0.09204116986781731f;
    representations[27].kappas[2] = 0.27769630133596485f;
    representations[27].normalizations[2] = 0.10371094668741296f;
    representations[27].weights[3] = 0.0f;
    representations[27].meanCosines[3] = 0.0f;
    representations[27].kappas[3] = 0.0f;
    representations[27].normalizations[3] = 0.0f;

    representations[28].K = 3;
    representations[28].g = 0.21826771653543306f;
    representations[28].weights[0] = 0.03212300887954878f;
    representations[28].meanCosines[0] = 0.6820644132559194f;
    representations[28].kappas[0] = 3.2328480493359963f;
    representations[28].normalizations[0] = 0.5153255463626063f;
    representations[28].weights[1] = 0.3706342080413193f;
    representations[28].meanCosines[1] = 0.371841402019988f;
    representations[28].kappas[1] = 1.2348488131529798f;
    representations[28].normalizations[1] = 0.21469798321963257f;
    representations[28].weights[2] = 0.597242783079132f;
    representations[28].meanCosines[2] = 0.095341157518617f;
    representations[28].kappas[2] = 0.28777266268317936f;
    representations[28].normalizations[2] = 0.10466234550768412f;
    representations[28].weights[3] = 0.0f;
    representations[28].meanCosines[3] = 0.0f;
    representations[28].kappas[3] = 0.0f;
    representations[28].normalizations[3] = 0.0f;

    representations[29].K = 3;
    representations[29].g = 0.22606299212598424f;
    representations[29].weights[0] = 0.03345544514793685f;
    representations[29].meanCosines[0] = 0.6931514474568911f;
    representations[29].kappas[0] = 3.3614734966515782f;
    representations[29].normalizations[0] = 0.5356394908307532f;
    representations[29].weights[1] = 0.37234054521898624f;
    representations[29].meanCosines[1] = 0.3828248418078445f;
    representations[29].kappas[1] = 1.2799530194570734f;
    representations[29].normalizations[1] = 0.22077977707335444f;
    representations[29].weights[2] = 0.5942040096330768f;
    representations[29].meanCosines[2] = 0.09862999422597651f;
    representations[29].kappas[2] = 0.29782775373429926f;
    representations[29].normalizations[2] = 0.10561693102809376f;
    representations[29].weights[3] = 0.0f;
    representations[29].meanCosines[3] = 0.0f;
    representations[29].kappas[3] = 0.0f;
    representations[29].normalizations[3] = 0.0f;

    representations[30].K = 3;
    representations[30].g = 0.23385826771653542f;
    representations[30].weights[0] = 0.0348509218277539f;
    representations[30].meanCosines[0] = 0.703694400485129f;
    representations[30].kappas[0] = 3.491628707455712f;
    representations[30].normalizations[0] = 0.5562257439894829f;
    representations[30].weights[1] = 0.3740804275025195f;
    representations[30].meanCosines[1] = 0.39361551569233905f;
    representations[30].kappas[1] = 1.325176201006904f;
    representations[30].normalizations[1] = 0.22693599717230062f;
    representations[30].weights[2] = 0.5910686506697266f;
    representations[30].meanCosines[2] = 0.10190742993352812f;
    representations[30].kappas[2] = 0.3078611447237137f;
    representations[30].normalizations[2] = 0.10657461709345743f;
    representations[30].weights[3] = 0.0f;
    representations[30].meanCosines[3] = 0.0f;
    representations[30].kappas[3] = 0.0f;
    representations[30].normalizations[3] = 0.0f;

    representations[31].K = 3;
    representations[31].g = 0.2416535433070866f;
    representations[31].weights[0] = 0.0363110174513472f;
    representations[31].meanCosines[0] = 0.7137284878918613f;
    representations[31].kappas[0] = 3.6233927446497733f;
    representations[31].normalizations[0] = 0.5770920215898871f;
    representations[31].weights[1] = 0.3758513101926688f;
    representations[31].meanCosines[1] = 0.40421353232046997f;
    representations[31].kappas[1] = 1.370524826949544f;
    representations[31].normalizations[1] = 0.23316558894026745f;
    representations[31].weights[2] = 0.5878376723559839f;
    representations[31].meanCosines[2] = 0.10517320052735003f;
    representations[31].kappas[2] = 0.3178723524295186f;
    representations[31].normalizations[2] = 0.10753531137309834f;
    representations[31].weights[3] = 0.0f;
    representations[31].meanCosines[3] = 0.0f;
    representations[31].kappas[3] = 0.0f;
    representations[31].normalizations[3] = 0.0f;

    representations[32].K = 3;
    representations[32].g = 0.2494488188976378f;
    representations[32].weights[0] = 0.03783733033391697f;
    representations[32].meanCosines[0] = 0.7232866503493903f;
    representations[32].kappas[0] = 3.7568481915190235f;
    representations[32].normalizations[0] = 0.5982473403971204f;
    representations[32].weights[1] = 0.377650546588742f;
    representations[32].meanCosines[1] = 0.4146194044606831f;
    representations[32].kappas[1] = 1.416005797772609f;
    representations[32].normalizations[1] = 0.23946758934791837f;
    representations[32].weights[2] = 0.5845121230773409f;
    representations[32].meanCosines[2] = 0.10842706502773718f;
    representations[32].kappas[2] = 0.32786095389288733f;
    representations[32].normalizations[2] = 0.10849892624542931f;
    representations[32].weights[3] = 0.0f;
    representations[32].meanCosines[3] = 0.0f;
    representations[32].kappas[3] = 0.0f;
    representations[32].normalizations[3] = 0.0f;

    representations[33].K = 3;
    representations[33].g = 0.25724409448818897f;
    representations[33].weights[0] = 0.039431478172527346f;
    representations[33].meanCosines[0] = 0.7323996378740554f;
    representations[33].kappas[0] = 3.892081342390479f;
    representations[33].normalizations[0] = 0.6197019514445599f;
    representations[33].weights[1] = 0.37947540366321675f;
    representations[33].meanCosines[1] = 0.42483402082021005f;
    representations[33].kappas[1] = 1.4616264505862715f;
    representations[33].normalizations[1] = 0.2458411328184177f;
    representations[33].weights[2] = 0.5810931181642559f;
    representations[33].meanCosines[2] = 0.11166880441579947f;
    representations[33].kappas[2] = 0.33782658307981484f;
    representations[33].normalizations[2] = 0.10946537864825562f;
    representations[33].weights[3] = 0.0f;
    representations[33].meanCosines[3] = 0.0f;
    representations[33].kappas[3] = 0.0f;
    representations[33].normalizations[3] = 0.0f;

    representations[34].K = 3;
    representations[34].g = 0.2650393700787401f;
    representations[34].weights[0] = 0.04109511413829938f;
    representations[34].meanCosines[0] = 0.7410960812812006f;
    representations[34].kappas[0] = 4.029181949359587f;
    representations[34].normalizations[0] = 0.6414672123825825f;
    representations[34].weights[1] = 0.3813231066295435f;
    representations[34].meanCosines[1] = 0.43485858368855124f;
    representations[34].kappas[1] = 1.5073944073067256f;
    representations[34].normalizations[1] = 0.2522854344127896f;
    representations[34].weights[2] = 0.5775817792321571f;
    representations[34].meanCosines[2] = 0.1148982096999848f;
    representations[34].kappas[2] = 0.3477688944033129f;
    representations[34].normalizations[2] = 0.11043458667809568f;
    representations[34].weights[3] = 0.0f;
    representations[34].meanCosines[3] = 0.0f;
    representations[34].kappas[3] = 0.0f;
    representations[34].normalizations[3] = 0.0f;

    representations[35].K = 3;
    representations[35].g = 0.27283464566929133f;
    representations[35].weights[0] = 0.04282992980429418f;
    representations[35].meanCosines[0] = 0.7494026016728395f;
    representations[35].kappas[0] = 4.1682433077297265f;
    representations[35].normalizations[0] = 0.6635555227768634f;
    representations[35].weights[1] = 0.3831908473467149f;
    representations[35].meanCosines[1] = 0.4446945773353679f;
    representations[35].kappas[1] = 1.5533175460677648f;
    representations[35].normalizations[1] = 0.258799789085319f;
    representations[35].weights[2] = 0.5739792228489909f;
    representations[35].meanCosines[2] = 0.11811507896449913f;
    representations[35].kappas[2] = 0.35768755366547783f;
    representations[35].normalizations[2] = 0.11140646877150544f;
    representations[35].weights[3] = 0.0f;
    representations[35].meanCosines[3] = 0.0f;
    representations[35].kappas[3] = 0.0f;
    representations[35].normalizations[3] = 0.0f;

    representations[36].K = 3;
    representations[36].g = 0.2806299212598425f;
    representations[36].weights[0] = 0.04463760356304057f;
    representations[36].meanCosines[0] = 0.7573440065673147f;
    representations[36].kappas[0] = 4.309363834506902f;
    representations[36].normalizations[0] = 0.685980505664905f;
    representations[36].weights[1] = 0.3850756892916237f;
    representations[36].meanCosines[1] = 0.4543438495874592f;
    representations[36].kappas[1] = 1.5994045135644068f;
    representations[36].normalizations[1] = 0.2653836478950735f;
    representations[36].weights[2] = 0.5702867071453358f;
    representations[36].meanCosines[2] = 0.12131925204563446f;
    representations[36].kappas[2] = 0.3675823452228001f;
    representations[36].normalizations[2] = 0.1123809543338033f;
    representations[36].weights[3] = 0.0f;
    representations[36].meanCosines[3] = 0.0f;
    representations[36].kappas[3] = 0.0f;
    representations[36].normalizations[3] = 0.0f;

    representations[37].K = 3;
    representations[37].g = 0.2884251968503937f;
    representations[37].weights[0] = 0.04651992132996143f;
    representations[37].meanCosines[0] = 0.7649432204882097f;
    representations[37].kappas[0] = 4.452644004080665f;
    representations[37].normalizations[0] = 0.7087564597863664f;
    representations[37].weights[1] = 0.3869748043395022f;
    representations[37].meanCosines[1] = 0.46380833521269565f;
    representations[37].kappas[1] = 1.6456635357182618f;
    representations[37].normalizations[1] = 0.2720364511995345f;
    representations[37].weights[2] = 0.5665052743305363f;
    representations[37].meanCosines[2] = 0.12451052633673292f;
    representations[37].kappas[2] = 0.3774529122318213f;
    representations[37].normalizations[2] = 0.11335795827691708f;
    representations[37].weights[3] = 0.0f;
    representations[37].meanCosines[3] = 0.0f;
    representations[37].kappas[3] = 0.0f;
    representations[37].normalizations[3] = 0.0f;

    representations[38].K = 3;
    representations[38].g = 0.29622047244094485f;
    representations[38].weights[0] = 0.04847852891549287f;
    representations[38].meanCosines[0] = 0.7722217618748662f;
    representations[38].kappas[0] = 4.5981933220302285f;
    representations[38].normalizations[0] = 0.7318994148658073f;
    representations[38].weights[1] = 0.388885024846989f;
    representations[38].meanCosines[1] = 0.473090536062836f;
    representations[38].kappas[1] = 1.6921048843771227f;
    representations[38].normalizations[1] = 0.27875798554095554f;
    representations[38].weights[2] = 0.5626364462375181f;
    representations[38].meanCosines[2] = 0.12768882647952162f;
    representations[38].kappas[2] = 0.38729928159477f;
    representations[38].normalizations[2] = 0.11433743303630248f;
    representations[38].weights[3] = 0.0f;
    representations[38].meanCosines[3] = 0.0f;
    representations[38].kappas[3] = 0.0f;
    representations[38].normalizations[3] = 0.0f;

    representations[39].K = 3;
    representations[39].g = 0.30401574803149606f;
    representations[39].weights[0] = 0.050515288560540404f;
    representations[39].meanCosines[0] = 0.7791993428816343f;
    representations[39].kappas[0] = 4.746120804250555f;
    representations[39].normalizations[0] = 0.7554255718985057f;
    representations[39].weights[1] = 0.39080348821235833f;
    representations[39].meanCosines[1] = 0.4821927734544212f;
    representations[39].kappas[1] = 1.7387373336802003f;
    representations[39].normalizations[1] = 0.28554787556787525f;
    representations[39].weights[2] = 0.5586812232271012f;
    representations[39].meanCosines[2] = 0.13085395797040394f;
    representations[39].kappas[2] = 0.39712110186372734f;
    representations[39].normalizations[2] = 0.11531929316013426f;
    representations[39].weights[3] = 0.0f;
    representations[39].meanCosines[3] = 0.0f;
    representations[39].kappas[3] = 0.0f;
    representations[39].normalizations[3] = 0.0f;

    representations[40].K = 3;
    representations[40].g = 0.3118110236220472f;
    representations[40].weights[0] = 0.052631938361106065f;
    representations[40].meanCosines[0] = 0.785894454230334f;
    representations[40].kappas[0] = 4.896544587693031f;
    representations[40].normalizations[0] = 0.7793527912550628f;
    representations[40].weights[1] = 0.3927270435107326f;
    representations[40].meanCosines[1] = 0.4911178490442006f;
    representations[40].kappas[1] = 1.7855715658402957f;
    representations[40].normalizations[1] = 0.2924060777270106f;
    representations[40].weights[2] = 0.5546410181281614f;
    representations[40].meanCosines[2] = 0.13400584044657948f;
    representations[40].kappas[2] = 0.406918365828317f;
    representations[40].normalizations[2] = 0.1163034871611057f;
    representations[40].weights[3] = 0.0f;
    representations[40].meanCosines[3] = 0.0f;
    representations[40].kappas[3] = 0.0f;
    representations[40].normalizations[3] = 0.0f;

    representations[41].K = 3;
    representations[41].g = 0.3196062992125984f;
    representations[41].weights[0] = 0.054830320932235194f;
    representations[41].meanCosines[0] = 0.7923241563653624f;
    representations[41].kappas[0] = 5.049585889496475f;
    representations[41].normalizations[0] = 0.8036995978580225f;
    representations[41].weights[1] = 0.39465264154304214f;
    representations[41].meanCosines[1] = 0.49986856925941164f;
    representations[41].kappas[1] = 1.8326178990052264f;
    representations[41].normalizations[1] = 0.299332552386369f;
    representations[41].weights[2] = 0.5505170375247227f;
    representations[41].meanCosines[2] = 0.13714435057395352f;
    representations[41].kappas[2] = 0.4166909238221657f;
    representations[41].normalizations[2] = 0.11728994912473324f;
    representations[41].weights[3] = 0.0f;
    representations[41].meanCosines[3] = 0.0f;
    representations[41].kappas[3] = 0.0f;
    representations[41].normalizations[3] = 0.0f;

    representations[42].K = 3;
    representations[42].g = 0.3274015748031496f;
    representations[42].weights[0] = 0.05711223605872792f;
    representations[42].meanCosines[0] = 0.7985043630899611f;
    representations[42].kappas[0] = 5.205373425292967f;
    representations[42].normalizations[0] = 0.828485854647965f;
    representations[42].weights[1] = 0.39657710712907207f;
    representations[42].meanCosines[1] = 0.5084480072544973f;
    representations[42].kappas[1] = 1.8798877748028617f;
    representations[42].normalizations[1] = 0.30632748244974595f;
    representations[42].weights[2] = 0.5463106568122f;
    representations[42].meanCosines[2] = 0.14026942121314215f;
    representations[42].kappas[2] = 0.4264387921091299f;
    representations[42].normalizations[2] = 0.11827862972883287f;
    representations[42].weights[3] = 0.0f;
    representations[42].meanCosines[3] = 0.0f;
    representations[42].kappas[3] = 0.0f;
    representations[42].normalizations[3] = 0.0f;

    representations[43].K = 3;
    representations[43].g = 0.3351968503937008f;
    representations[43].weights[0] = 0.05947949976675226f;
    representations[43].meanCosines[0] = 0.8044498524567503f;
    representations[43].kappas[0] = 5.3640421044192195f;
    representations[43].normalizations[0] = 0.8537325301915992f;
    representations[43].weights[1] = 0.39849724129514225f;
    representations[43].meanCosines[1] = 0.516859365291507f;
    representations[43].kappas[1] = 1.9273931827012034f;
    representations[43].normalizations[1] = 0.31339119081328726f;
    representations[43].weights[2] = 0.5420232589381055f;
    representations[43].meanCosines[2] = 0.14338100028624415f;
    representations[43].kappas[2] = 0.4361620257500823f;
    representations[43].normalizations[2] = 0.11926948366904784f;
    representations[43].weights[3] = 0.0f;
    representations[43].meanCosines[3] = 0.0f;
    representations[43].kappas[3] = 0.0f;
    representations[43].normalizations[3] = 0.0f;

    representations[44].K = 3;
    representations[44].g = 0.34299212598425194f;
    representations[44].weights[0] = 0.061934017335778434f;
    representations[44].meanCosines[0] = 0.8101742785481437f;
    representations[44].kappas[0] = 5.525731270151455f;
    representations[44].normalizations[0] = 0.8794613975566535f;
    representations[44].weights[1] = 0.400409908304721f;
    representations[44].meanCosines[1] = 0.5251058303099392f;
    representations[44].kappas[1] = 1.9751459448430044f;
    representations[44].normalizations[1] = 0.32052403397373247f;
    representations[44].weights[2] = 0.5376560743595005f;
    representations[44].meanCosines[2] = 0.14647900283272577f;
    representations[44].kappas[2] = 0.4458605687980155f;
    representations[44].normalizations[2] = 0.12026245438736198f;
    representations[44].weights[3] = 0.0f;
    representations[44].meanCosines[3] = 0.0f;
    representations[44].kappas[3] = 0.0f;
    representations[44].normalizations[3] = 0.0f;

    representations[45].K = 3;
    representations[45].g = 0.35078740157480315f;
    representations[45].weights[0] = 0.06447760472630311f;
    representations[45].meanCosines[0] = 0.8156904376058959f;
    representations[45].kappas[0] = 5.6905902250879805f;
    representations[45].normalizations[0] = 0.9056958957694585f;
    representations[45].weights[1] = 0.40231181608214067f;
    representations[45].meanCosines[1] = 0.533190870036375f;
    representations[45].kappas[1] = 2.0231595316319937f;
    representations[45].normalizations[1] = 0.3277266730567593f;
    representations[45].weights[2] = 0.5332105791915562f;
    representations[45].meanCosines[2] = 0.14956342791040378f;
    representations[45].kappas[2] = 0.4555346203324962f;
    representations[45].normalizations[2] = 0.1212575115536747f;
    representations[45].weights[3] = 0.0f;
    representations[45].meanCosines[3] = 0.0f;
    representations[45].kappas[3] = 0.0f;
    representations[45].normalizations[3] = 0.0f;

    representations[46].K = 3;
    representations[46].g = 0.3585826771653543f;
    representations[46].weights[0] = 0.06711202650241141f;
    representations[46].meanCosines[0] = 0.8210102816127492f;
    representations[46].kappas[0] = 5.858777649296523f;
    representations[46].normalizations[0] = 0.9324610224429561f;
    representations[46].weights[1] = 0.4041995962417163f;
    representations[46].meanCosines[1] = 0.5411181321395668f;
    representations[46].kappas[1] = 2.071448705643941f;
    representations[46].normalizations[1] = 0.335000023620412f;
    representations[46].weights[2] = 0.5286883772558724f;
    representations[46].meanCosines[2] = 0.15263433078191485f;
    representations[46].kappas[2] = 0.4651845494691381f;
    representations[46].normalizations[2] = 0.12225464287484415f;
    representations[46].weights[3] = 0.0f;
    representations[46].meanCosines[3] = 0.0f;
    representations[46].kappas[3] = 0.0f;
    representations[46].normalizations[3] = 0.0f;

    representations[47].K = 3;
    representations[47].g = 0.3663779527559055f;
    representations[47].weights[0] = 0.06983934101319342f;
    representations[47].meanCosines[0] = 0.8261446758646345f;
    representations[47].kappas[0] = 6.030451916295631f;
    representations[47].normalizations[0] = 0.9597817802216335f;
    representations[47].weights[1] = 0.40607015469631597f;
    representations[47].meanCosines[1] = 0.5488908666357898f;
    representations[47].kappas[1] = 2.120026074834621f;
    representations[47].normalizations[1] = 0.3423447352950037f;
    representations[47].weights[2] = 0.5240905042904906f;
    representations[47].meanCosines[2] = 0.1556916023453696f;
    representations[47].kappas[2] = 0.47481020201532553f;
    representations[47].normalizations[2] = 0.12325378236504182f;
    representations[47].weights[3] = 0.0f;
    representations[47].meanCosines[3] = 0.0f;
    representations[47].kappas[3] = 0.0f;
    representations[47].normalizations[3] = 0.0f;

    representations[48].K = 3;
    representations[48].g = 0.37417322834645667f;
    representations[48].weights[0] = 0.07266134359728532f;
    representations[48].meanCosines[0] = 0.8311039776930013f;
    representations[48].kappas[0] = 6.20578789794099f;
    representations[48].normalizations[0] = 0.9876858407915654f;
    representations[48].weights[1] = 0.40792008616982384f;
    representations[48].meanCosines[1] = 0.5565128318769808f;
    representations[48].kappas[1] = 2.1689077268327046f;
    representations[48].normalizations[1] = 0.3497620402640429f;
    representations[48].weights[2] = 0.5194185702328908f;
    representations[48].meanCosines[2] = 0.158735326448921f;
    representations[48].kappas[2] = 0.4844120237797777f;
    representations[48].normalizations[2] = 0.1242549265117551f;
    representations[48].weights[3] = 0.0f;
    representations[48].meanCosines[3] = 0.0f;
    representations[48].kappas[3] = 0.0f;
    representations[48].normalizations[3] = 0.0f;

    representations[49].K = 3;
    representations[49].g = 0.3819685039370079f;
    representations[49].weights[0] = 0.07557993630147046f;
    representations[49].meanCosines[0] = 0.8358977483762517f;
    representations[49].kappas[0] = 6.384966707199992f;
    representations[49].normalizations[0] = 1.0162019040631736f;
    representations[49].weights[1] = 0.40974607087036374f;
    representations[49].meanCosines[1] = 0.5639876672029343f;
    representations[49].kappas[1] = 2.2181095428841404f;
    representations[49].normalizations[1] = 0.35725319828108354f;
    representations[49].weights[2] = 0.5146739928281657f;
    representations[49].meanCosines[2] = 0.16176554199961418f;
    representations[49].kappas[2] = 0.49399031392292975f;
    representations[49].normalizations[2] = 0.1252580573066742f;
    representations[49].weights[3] = 0.0f;
    representations[49].meanCosines[3] = 0.0f;
    representations[49].kappas[3] = 0.0f;
    representations[49].normalizations[3] = 0.0f;

    representations[50].K = 3;
    representations[50].g = 0.38976377952755903f;
    representations[50].weights[0] = 0.07859703707682453f;
    representations[50].meanCosines[0] = 0.8405348935900007f;
    representations[50].kappas[0] = 6.568178944104258f;
    representations[50].normalizations[0] = 1.0453602077318829f;
    representations[50].weights[1] = 0.4115447755011663f;
    representations[50].meanCosines[1] = 0.5713190337485659f;
    representations[50].kappas[1] = 2.2676481499650887f;
    representations[50].normalizations[1] = 0.36481963932118755f;
    representations[50].weights[2] = 0.5098581874220092f;
    representations[50].meanCosines[2] = 0.1647823017041069f;
    representations[50].kappas[2] = 0.5035454098977901f;
    representations[50].normalizations[2] = 0.1262631614013433f;
    representations[50].weights[3] = 0.0f;
    representations[50].meanCosines[3] = 0.0f;
    representations[50].kappas[3] = 0.0f;
    representations[50].normalizations[3] = 0.0f;

    representations[51].K = 3;
    representations[51].g = 0.39755905511811024f;
    representations[51].weights[0] = 0.08171458128636552f;
    representations[51].meanCosines[0] = 0.8450237123238858f;
    representations[51].kappas[0] = 6.755625297772691f;
    representations[51].normalizations[0] = 1.0751926173713249f;
    representations[51].weights[1] = 0.41331285366521353f;
    representations[51].meanCosines[1] = 0.5785106025878821f;
    representations[51].kappas[1] = 2.317540949797567f;
    representations[51].normalizations[1] = 0.3724629673385169f;
    representations[51].weights[2] = 0.504972565048421f;
    representations[51].meanCosines[2] = 0.16778567162512953f;
    representations[51].kappas[2] = 0.5130776865929203f;
    representations[51].normalizations[2] = 0.1272702301037747f;
    representations[51].weights[3] = 0.0f;
    representations[51].meanCosines[3] = 0.0f;
    representations[51].kappas[3] = 0.0f;
    representations[51].normalizations[3] = 0.0f;

    representations[52].K = 3;
    representations[52].g = 0.4053543307086614f;
    representations[52].weights[0] = 0.08493448605433432f;
    representations[52].meanCosines[0] = 0.8493719674172462f;
    representations[52].kappas[0] = 6.947518350251926f;
    representations[52].normalizations[0] = 1.1057329088681573f;
    representations[52].weights[1] = 0.4150469228659922f;
    representations[52].meanCosines[1] = 0.58556609571726f;
    representations[52].kappas[1] = 2.367806523563953f;
    representations[52].normalizations[1] = 0.3801850217003517f;
    representations[52].weights[2] = 0.5000185910796735f;
    representations[52].meanCosines[2] = 0.1707757528202662f;
    representations[52].kappas[2] = 0.5225876257851102f;
    representations[52].normalizations[2] = 0.12827926684695073f;
    representations[52].weights[3] = 0.0f;
    representations[52].meanCosines[3] = 0.0f;
    representations[52].kappas[3] = 0.0f;
    representations[52].normalizations[3] = 0.0f;

    representations[53].K = 3;
    representations[53].g = 0.4131496062992126f;
    representations[53].weights[0] = 0.08825869500909991f;
    representations[53].meanCosines[0] = 0.8535868936983303f;
    representations[53].kappas[0] = 7.144082003779275f;
    representations[53].normalizations[0] = 1.1370166735101817f;
    representations[53].weights[1] = 0.4167435990709438f;
    representations[53].meanCosines[1] = 0.5924892115715676f;
    representations[53].kappas[1] = 2.418464235702139f;
    representations[53].normalizations[1] = 0.38798781588098935f;
    representations[53].weights[2] = 0.49499770591995634f;
    representations[53].meanCosines[2] = 0.17375265446037172f;
    representations[53].kappas[2] = 0.5320757316832715f;
    representations[53].normalizations[2] = 0.12929027840892207f;
    representations[53].weights[3] = 0.0f;
    representations[53].meanCosines[3] = 0.0f;
    representations[53].kappas[3] = 0.0f;
    representations[53].normalizations[3] = 0.0f;

    representations[54].K = 3;
    representations[54].g = 0.42094488188976376f;
    representations[54].weights[0] = 0.09168916522716564f;
    representations[54].meanCosines[0] = 0.8576752472049249f;
    representations[54].kappas[0] = 7.345552722466723f;
    representations[54].normalizations[0] = 1.1690815125785594f;
    representations[54].weights[1] = 0.4183994860545349f;
    representations[54].meanCosines[1] = 0.5992836376054463f;
    representations[54].kappas[1] = 2.4695344222622806f;
    representations[54].normalizations[1] = 0.3958735653601526f;
    representations[54].weights[2] = 0.48991134871829956f;
    representations[54].meanCosines[2] = 0.17671650241051653f;
    representations[54].kappas[2] = 0.541542558806905f;
    representations[54].normalizations[2] = 0.13030327794671623f;
    representations[54].weights[3] = 0.0f;
    representations[54].meanCosines[3] = 0.0f;
    representations[54].kappas[3] = 0.0f;
    representations[54].normalizations[3] = 0.0f;

    representations[55].K = 3;
    representations[55].g = 0.42874015748031497f;
    representations[55].weights[0] = 0.09522786839368456f;
    representations[55].meanCosines[0] = 0.8616433403817125f;
    representations[55].kappas[0] = 7.552180422573271f;
    representations[55].normalizations[0] = 1.2019671766214413f;
    representations[55].weights[1] = 0.42001117566983376f;
    representations[55].meanCosines[1] = 0.6059530427287675f;
    representations[55].kappas[1] = 2.5210384425501737f;
    representations[55].normalizations[1] = 0.40384469461842903f;
    representations[55].weights[2] = 0.48476095593648155f;
    representations[55].meanCosines[2] = 0.17966743925929668f;
    representations[55].kappas[2] = 0.5509887128325508f;
    representations[55].normalizations[2] = 0.13131828519299638f;
    representations[55].weights[3] = 0.0f;
    representations[55].meanCosines[3] = 0.0f;
    representations[55].kappas[3] = 0.0f;
    representations[55].normalizations[3] = 0.0f;

    representations[56].K = 3;
    representations[56].g = 0.4365354330708661f;
    representations[56].weights[0] = 0.0988767934663242f;
    representations[56].meanCosines[0] = 0.8654970737530904f;
    representations[56].kappas[0] = 7.764229399563398f;
    representations[56].normalizations[0] = 1.2357157110806771f;
    representations[56].weights[1] = 0.42157524842882677f;
    representations[56].meanCosines[1] = 0.612501068934138f;
    representations[56].kappas[1] = 2.5729987214001024f;
    representations[56].normalizations[1] = 0.4119038426292747f;
    representations[56].weights[2] = 0.47954795810484907f;
    representations[56].meanCosines[2] = 0.18260562362373325f;
    representations[56].kappas[2] = 0.5604148491400338f;
    representations[56].normalizations[2] = 0.1323353264040619f;
    representations[56].weights[3] = 0.0f;
    representations[56].meanCosines[3] = 0.0f;
    representations[56].kappas[3] = 0.0f;
    representations[56].normalizations[3] = 0.0f;

    representations[57].K = 3;
    representations[57].g = 0.44433070866141733f;
    representations[57].weights[0] = 0.10263796004725238f;
    representations[57].meanCosines[0] = 0.8692419595769955f;
    representations[57].kappas[0] = 7.981979001500163f;
    representations[57].normalizations[0] = 1.270371561952546f;
    representations[57].weights[1] = 0.42308827723445225f;
    representations[57].meanCosines[1] = 0.6189313112296096f;
    representations[57].kappas[1] = 2.6254386902453777f;
    representations[57].normalizations[1] = 0.4200538525478618f;
    representations[57].weights[2] = 0.47427376271829536f;
    representations[57].meanCosines[2] = 0.18553122367844202f;
    representations[57].kappas[2] = 0.5698216527617949f;
    representations[57].normalizations[2] = 0.1333544322829776f;
    representations[57].weights[3] = 0.0f;
    representations[57].meanCosines[3] = 0.0f;
    representations[57].kappas[3] = 0.0f;
    representations[57].normalizations[3] = 0.0f;

    representations[58].K = 3;
    representations[58].g = 0.4521259842519685f;
    representations[58].weights[0] = 0.10651340265267141f;
    representations[58].meanCosines[0] = 0.8728831598504667f;
    representations[58].kappas[0] = 8.20572532527276f;
    representations[58].normalizations[0] = 1.3059818445660667f;
    representations[58].weights[1] = 0.4245468183339547f;
    representations[58].meanCosines[1] = 0.6252473352033313f;
    representations[58].kappas[1] = 2.6783830265653674f;
    representations[58].normalizations[1] = 0.42829780768018394f;
    representations[58].weights[2] = 0.4689397790133738f;
    representations[58].meanCosines[2] = 0.18844442736311248f;
    representations[58].kappas[2] = 0.5792098718805595f;
    representations[58].normalizations[2] = 0.13437564168445362f;
    representations[58].weights[3] = 0.0f;
    representations[58].meanCosines[3] = 0.0f;
    representations[58].kappas[3] = 0.0f;
    representations[58].normalizations[3] = 0.0f;

    representations[59].K = 3;
    representations[59].g = 0.4599212598425197f;
    representations[59].weights[0] = 0.11050517555935604f;
    representations[59].meanCosines[0] = 0.8764255095007417f;
    representations[59].kappas[0] = 8.435782379970613f;
    representations[59].normalizations[0] = 1.342596527819977f;
    representations[59].weights[1] = 0.42594741240052664f;
    representations[59].meanCosines[1] = 0.6314526684925892f;
    representations[59].kappas[1] = 2.7318576950764704f;
    representations[59].normalizations[1] = 0.436639036804549f;
    representations[59].weights[2] = 0.4635474120401174f;
    representations[59].meanCosines[2] = 0.1913454408889863f;
    representations[59].kappas[2] = 0.5885803139592967f;
    representations[59].normalizations[2] = 0.13539900131670243f;
    representations[59].weights[3] = 0.0f;
    representations[59].meanCosines[3] = 0.0f;
    representations[59].kappas[3] = 0.0f;
    representations[59].normalizations[3] = 0.0f;

    representations[60].K = 3;
    representations[60].g = 0.46771653543307085f;
    representations[60].weights[0] = 0.11461533860200686f;
    representations[60].meanCosines[0] = 0.8798735470937176f;
    representations[60].kappas[0] = 8.672483998747186f;
    representations[60].normalizations[0] = 1.3802687377565923f;
    representations[60].weights[1] = 0.42728658030803607f;
    representations[60].meanCosines[1] = 0.6375508149620032f;
    representations[60].kappas[1] = 2.7858901874628623f;
    representations[60].normalizations[1] = 0.4450811504792057f;
    representations[60].weights[2] = 0.45809808108995725f;
    representations[60].meanCosines[2] = 0.19423449766964776f;
    representations[60].kappas[2] = 0.5979338756232817f;
    representations[60].normalizations[2] = 0.13642456913873516f;
    representations[60].weights[3] = 0.0f;
    representations[60].meanCosines[3] = 0.0f;
    representations[60].kappas[3] = 0.0f;
    representations[60].normalizations[3] = 0.0f;

    representations[61].K = 3;
    representations[61].g = 0.47551181102362206f;
    representations[61].weights[0] = 0.11884599637104817f;
    representations[61].meanCosines[0] = 0.8832315179423937f;
    representations[61].kappas[0] = 8.916184139359721f;
    representations[61].normalizations[0] = 1.419054804853077f;
    representations[61].weights[1] = 0.4285608327734269f;
    representations[61].meanCosines[1] = 0.6435452084762158f;
    representations[61].kappas[1] = 2.8405092323844556f;
    representations[61].normalizations[1] = 0.4536279946281f;
    representations[61].weights[2] = 0.4525931708555248f;
    representations[61].meanCosines[2] = 0.19711183827311177f;
    representations[61].kappas[2] = 0.6072714788289457f;
    representations[61].normalizations[2] = 0.1374524074966876f;
    representations[61].weights[3] = 0.0f;
    representations[61].meanCosines[3] = 0.0f;
    representations[61].kappas[3] = 0.0f;
    representations[61].normalizations[3] = 0.0f;

    representations[62].K = 3;
    representations[62].g = 0.4833070866141732f;
    representations[62].weights[0] = 0.12319928766759637f;
    representations[62].meanCosines[0] = 0.8865034015121176f;
    representations[62].kappas[0] = 9.16725893612397f;
    representations[62].normalizations[0] = 1.4590145901905027f;
    representations[62].weights[1] = 0.42976666301618144f;
    representations[62].meanCosines[1] = 0.6494392269329624f;
    representations[62].kappas[1] = 2.8957450141747496f;
    representations[62].normalizations[1] = 0.46228368338595593f;
    representations[62].weights[2] = 0.44703404931622226f;
    representations[62].meanCosines[2] = 0.19997771817476762f;
    representations[62].kappas[2] = 0.616594096682104f;
    representations[62].normalizations[2] = 0.13848258601896915f;
    representations[62].weights[3] = 0.0f;
    representations[62].meanCosines[3] = 0.0f;
    representations[62].kappas[3] = 0.0f;
    representations[62].normalizations[3] = 0.0f;

    representations[63].K = 3;
    representations[63].g = 0.4911023622047244f;
    representations[63].weights[0] = 0.12767711326081116f;
    representations[63].meanCosines[0] = 0.8896930424203258f;
    representations[63].kappas[0] = 9.426117857395496f;
    representations[63].normalizations[0] = 1.500213260915139f;
    representations[63].weights[1] = 0.4309005122013021f;
    representations[63].meanCosines[1] = 0.6552364769534045f;
    representations[63].kappas[1] = 2.9516320648387557f;
    representations[63].normalizations[1] = 0.471053051906239f;
    representations[63].weights[2] = 0.44142237453788674f;
    representations[63].meanCosines[2] = 0.20283255209471382f;
    representations[63].kappas[2] = 0.6259032255561982f;
    representations[63].normalizations[2] = 0.13951523417822578f;
    representations[63].weights[3] = 0.0f;
    representations[63].meanCosines[3] = 0.0f;
    representations[63].kappas[3] = 0.0f;
    representations[63].normalizations[3] = 0.0f;

    representations[64].K = 3;
    representations[64].g = 0.4988976377952756f;
    representations[64].weights[0] = 0.13228217893070182f;
    representations[64].meanCosines[0] = 0.8928037371351293f;
    representations[64].kappas[0] = 9.693170363545615f;
    representations[64].normalizations[0] = 1.5427159834637596f;
    representations[64].weights[1] = 0.43195889896389156f;
    representations[64].meanCosines[1] = 0.6609397021872523f;
    representations[64].kappas[1] = 3.0081987975922257f;
    representations[64].normalizations[1] = 0.47994001241960793f;
    representations[64].weights[2] = 0.43575892210540673f;
    representations[64].meanCosines[2] = 0.20567636859603608f;
    representations[64].kappas[2] = 0.6351991067898674f;
    representations[64].normalizations[2] = 0.14055034398422908f;
    representations[64].weights[3] = 0.0f;
    representations[64].meanCosines[3] = 0.0f;
    representations[64].kappas[3] = 0.0f;
    representations[64].normalizations[3] = 0.0f;

    representations[65].K = 3;
    representations[65].g = 0.5066929133858268f;
    representations[65].weights[0] = 0.13701645780490154f;
    representations[65].meanCosines[0] = 0.8958388925416747f;
    representations[65].kappas[0] = 9.968880275772742f;
    representations[65].normalizations[0] = 1.5865965764607521f;
    representations[65].weights[1] = 0.43293821041468983f;
    representations[65].meanCosines[1] = 0.6665524055023117f;
    representations[65].kappas[1] = 3.0654832705645223f;
    representations[65].normalizations[1] = 0.4889500266604984f;
    representations[65].weights[2] = 0.4300453317804087f;
    representations[65].meanCosines[2] = 0.20850962101611986f;
    representations[65].kappas[2] = 0.6444833721001508f;
    representations[65].normalizations[2] = 0.14158806355836523f;
    representations[65].weights[3] = 0.0f;
    representations[65].meanCosines[3] = 0.0f;
    representations[65].kappas[3] = 0.0f;
    representations[65].normalizations[3] = 0.0f;

    representations[66].K = 3;
    representations[66].g = 0.5144881889763779f;
    representations[66].weights[0] = 0.14188167518350953f;
    representations[66].meanCosines[0] = 0.8988018020497218f;
    representations[66].kappas[0] = 10.253752777050046f;
    representations[66].normalizations[0] = 1.6319354417346774f;
    representations[66].weights[1] = 0.4338348440662771f;
    representations[66].meanCosines[1] = 0.672078283990385f;
    representations[66].kappas[1] = 3.123528477106368f;
    representations[66].normalizations[1] = 0.498089369724428f;
    representations[66].weights[2] = 0.42428348075021344f;
    representations[66].meanCosines[2] = 0.21133292088157304f;
    representations[66].kappas[2] = 0.6537581843157421f;
    representations[66].normalizations[2] = 0.14262860345015743f;
    representations[66].weights[3] = 0.0f;
    representations[66].meanCosines[3] = 0.0f;
    representations[66].kappas[3] = 0.0f;
    representations[66].normalizations[3] = 0.0f;

    representations[67].K = 3;
    representations[67].g = 0.5222834645669291f;
    representations[67].weights[0] = 0.14688190532912504f;
    representations[67].meanCosines[0] = 0.9016947510325678f;
    representations[67].kappas[0] = 10.548244803107089f;
    representations[67].normalizations[0] = 1.6788053025137655f;
    representations[67].weights[1] = 0.4346451786272443f;
    representations[67].meanCosines[1] = 0.6775187639861546f;
    representations[67].kappas[1] = 3.18235586208853f;
    representations[67].normalizations[1] = 0.5073609548705329f;
    representations[67].weights[2] = 0.41847291604363074f;
    representations[67].meanCosines[2] = 0.21414573980230114f;
    representations[67].kappas[2] = 0.6630219638878598f;
    representations[67].normalizations[2] = 0.14367175560038878f;
    representations[67].weights[3] = 0.0f;
    representations[67].meanCosines[3] = 0.0f;
    representations[67].kappas[3] = 0.0f;
    representations[67].normalizations[3] = 0.0f;

    representations[68].K = 3;
    representations[68].g = 0.5300787401574802f;
    representations[68].weights[0] = 0.15201802364423217f;
    representations[68].meanCosines[0] = 0.9045210208344292f;
    representations[68].kappas[0] = 10.852964167601495f;
    representations[68].normalizations[0] = 1.7273028951195475f;
    representations[68].weights[1] = 0.435365524307831f;
    representations[68].meanCosines[1] = 0.6828783513636263f;
    representations[68].kappas[1] = 3.2420223660584204f;
    representations[68].normalizations[1] = 0.5167733180958464f;
    representations[68].weights[2] = 0.41261645204793684f;
    representations[68].meanCosines[2] = 0.2169492083133833f;
    representations[68].kappas[2] = 0.6722785944850328f;
    representations[68].normalizations[2] = 0.14471792788382354f;
    representations[68].weights[3] = 0.0f;
    representations[68].meanCosines[3] = 0.0f;
    representations[68].kappas[3] = 0.0f;
    representations[68].normalizations[3] = 0.0f;

    representations[69].K = 3;
    representations[69].g = 0.5378740157480315f;
    representations[69].weights[0] = 0.15729294132110566f;
    representations[69].meanCosines[0] = 0.9072830203855161f;
    representations[69].kappas[0] = 11.168487946406515f;
    representations[69].normalizations[0] = 1.7775200638868365f;
    representations[69].weights[1] = 0.43599216989551043f;
    representations[69].meanCosines[1] = 0.6881595863609994f;
    representations[69].kappas[1] = 3.3025669779058386f;
    representations[69].normalizations[1] = 0.5263321984049527f;
    representations[69].weights[2] = 0.4067148887833839f;
    representations[69].meanCosines[2] = 0.21974347919085768f;
    representations[69].kappas[2] = 0.6815287539431827f;
    representations[69].normalizations[2] = 0.1457671702417904f;
    representations[69].weights[3] = 0.0f;
    representations[69].meanCosines[3] = 0.0f;
    representations[69].kappas[3] = 0.0f;
    representations[69].normalizations[3] = 0.0f;

    representations[70].K = 3;
    representations[70].g = 0.5456692913385827f;
    representations[70].weights[0] = 0.1627091674945393f;
    representations[70].meanCosines[0] = 0.9099831724121029f;
    representations[70].kappas[0] = 11.495452369732478f;
    representations[70].normalizations[0] = 1.8295580679098282f;
    representations[70].weights[1] = 0.43652135984600265f;
    representations[70].meanCosines[1] = 0.6933653968776663f;
    representations[70].kappas[1] = 3.364035938949523f;
    representations[70].normalizations[1] = 0.5360445070649383f;
    representations[70].weights[2] = 0.40076947265945795f;
    representations[70].meanCosines[2] = 0.22252895888323956f;
    representations[70].kappas[2] = 0.690773965537422f;
    representations[70].normalizations[2] = 0.1468196300804049f;
    representations[70].weights[3] = 0.0f;
    representations[70].meanCosines[3] = 0.0f;
    representations[70].kappas[3] = 0.0f;
    representations[70].normalizations[3] = 0.0f;

    representations[71].K = 3;
    representations[71].g = 0.5534645669291338f;
    representations[71].weights[0] = 0.16826931509786597f;
    representations[71].meanCosines[0] = 0.9126237466462465f;
    representations[71].kappas[0] = 11.834538906133483f;
    representations[71].normalizations[0] = 1.883525366223493f;
    representations[71].weights[1] = 0.436949287161954f;
    representations[71].meanCosines[1] = 0.6984986216586416f;
    representations[71].kappas[1] = 3.426477782827816f;
    representations[71].normalizations[1] = 0.545917545079653f;
    representations[71].weights[2] = 0.39478139774018f;
    representations[71].meanCosines[2] = 0.22530605709251292f;
    representations[71].kappas[2] = 0.7000157749339841f;
    representations[71].normalizations[2] = 0.14787545977774874f;
    representations[71].weights[3] = 0.0f;
    representations[71].meanCosines[3] = 0.0f;
    representations[71].kappas[3] = 0.0f;
    representations[71].normalizations[3] = 0.0f;

    representations[72].K = 3;
    representations[72].g = 0.561259842519685f;
    representations[72].weights[0] = 0.17397605681486036f;
    representations[72].meanCosines[0] = 0.91520688470064f;
    representations[72].kappas[0] = 12.186480389405208f;
    representations[72].normalizations[0] = 1.9395385929167108f;
    representations[72].weights[1] = 0.4372720921624159f;
    representations[72].meanCosines[1] = 0.7035620560829642f;
    representations[72].kappas[1] = 3.4899440461679654f;
    representations[72].normalizations[1] = 0.555959114489885f;
    representations[72].weights[2] = 0.3887518510227237f;
    representations[72].meanCosines[2] = 0.22807521187546123f;
    representations[72].kappas[2] = 0.7092558347125714f;
    representations[72].normalizations[2] = 0.1489348264074376f;
    representations[72].weights[3] = 0.0f;
    representations[72].meanCosines[3] = 0.0f;
    representations[72].kappas[3] = 0.0f;
    representations[72].normalizations[3] = 0.0f;

    representations[73].K = 3;
    representations[73].g = 0.5690551181102362f;
    representations[73].weights[0] = 0.17983214378421922f;
    representations[73].meanCosines[0] = 0.9177346040817985f;
    representations[73].kappas[0] = 12.552065355633442f;
    representations[73].normalizations[0] = 1.997723247386592f;
    representations[73].weights[1] = 0.4374858568977017f;
    representations[73].meanCosines[1] = 0.7085584413162697f;
    representations[73].kappas[1] = 3.554489351229144f;
    representations[73].normalizations[1] = 0.5661775306041705f;
    representations[73].weights[2] = 0.38268199931807917f;
    representations[73].meanCosines[2] = 0.23083688408868736f;
    representations[73].kappas[2] = 0.7184958875618854f;
    representations[73].normalizations[2] = 0.1499979099875054f;
    representations[73].weights[3] = 0.0f;
    representations[73].meanCosines[3] = 0.0f;
    representations[73].kappas[3] = 0.0f;
    representations[73].normalizations[3] = 0.0f;

    representations[74].K = 3;
    representations[74].g = 0.5768503937007874f;
    representations[74].weights[0] = 0.1858404095572948f;
    representations[74].meanCosines[0] = 0.9202088063452304f;
    representations[74].kappas[0] = 12.93214347991311f;
    representations[74].normalizations[0] = 2.0582145596138406f;
    representations[74].weights[1] = 0.4375866002297341f;
    representations[74].meanCosines[1] = 0.7134904673435183f;
    representations[74].kappas[1] = 3.620171668163421f;
    representations[74].normalizations[1] = 0.5765816626610434f;
    representations[74].weights[2] = 0.376572990212971f;
    representations[74].meanCosines[2] = 0.23359155944610333f;
    representations[74].kappas[2] = 0.7277377748041182f;
    representations[74].normalizations[2] = 0.15106490461580072f;
    representations[74].weights[3] = 0.0f;
    representations[74].meanCosines[3] = 0.0f;
    representations[74].kappas[3] = 0.0f;
    representations[74].normalizations[3] = 0.0f;

    representations[75].K = 3;
    representations[75].g = 0.5846456692913385f;
    representations[75].weights[0] = 0.1920037740311606f;
    representations[75].meanCosines[0] = 0.9226312846743214f;
    representations[75].kappas[0] = 13.327631663072642f;
    representations[75].normalizations[0] = 2.1211584588916965f;
    representations[75].weights[1] = 0.4375702730069559f;
    representations[75].meanCosines[1] = 0.7183607762114199f;
    representations[75].kappas[1] = 3.68705260568459f;
    representations[75].normalizations[1] = 0.587180979062321f;
    representations[75].weights[2] = 0.3704259529618835f;
    representations[75].meanCosines[2] = 0.23633975076704322f;
    representations[75].kappas[2] = 0.7369834457308975f;
    representations[75].normalizations[2] = 0.15213601971801666f;
    representations[75].weights[3] = 0.0f;
    representations[75].meanCosines[3] = 0.0f;
    representations[75].kappas[3] = 0.0f;
    representations[75].normalizations[3] = 0.0f;

    representations[76].K = 3;
    representations[76].g = 0.5924409448818897f;
    representations[76].weights[0] = 0.19832522506414976f;
    representations[76].meanCosines[0] = 0.9250037361138848f;
    representations[76].kappas[0] = 13.739521789305007f;
    representations[76].normalizations[0] = 2.1867128084892404f;
    representations[76].weights[1] = 0.43743275979935015f;
    representations[76].meanCosines[1] = 0.7231719821313055f;
    representations[76].kappas[1] = 3.755197973339379f;
    representations[76].normalizations[1] = 0.5979856357457428f;
    representations[76].weights[2] = 0.3642420151365001f;
    representations[76].meanCosines[2] = 0.23908201028376885f;
    representations[76].kappas[2] = 0.7462350011130275f;
    representations[76].normalizations[2] = 0.15321148529531584f;
    representations[76].weights[3] = 0.0f;
    representations[76].meanCosines[3] = 0.0f;
    representations[76].kappas[3] = 0.0f;
    representations[76].normalizations[3] = 0.0f;

    representations[77].K = 3;
    representations[77].g = 0.600236220472441f;
    representations[77].weights[0] = 0.2046370452946239f;
    representations[77].meanCosines[0] = 0.9273696065000837f;
    representations[77].kappas[0] = 14.176868423187258f;
    representations[77].normalizations[0] = 2.2563186871147516f;
    representations[77].weights[1] = 0.43734456589562715f;
    representations[77].meanCosines[1] = 0.7279873281080078f;
    representations[77].kappas[1] = 3.82557869797969f;
    representations[77].normalizations[1] = 0.6091494065393616f;
    representations[77].weights[2] = 0.35801838880974884f;
    representations[77].meanCosines[2] = 0.2418089043788005f;
    representations[77].kappas[2] = 0.7554607295835146f;
    representations[77].normalizations[2] = 0.15428758395409456f;
    representations[77].weights[3] = 0.0f;
    representations[77].meanCosines[3] = 0.0f;
    representations[77].kappas[3] = 0.0f;
    representations[77].normalizations[3] = 0.0f;

    representations[78].K = 3;
    representations[78].g = 0.6080314960629921f;
    representations[78].weights[0] = 0.21145522532501376f;
    representations[78].meanCosines[0] = 0.9296047853907953f;
    representations[78].kappas[0] = 14.61687501213509f;
    representations[78].normalizations[0] = 2.3263479107381757f;
    representations[78].weights[1] = 0.43677719515994007f;
    representations[78].meanCosines[1] = 0.732627039434998f;
    representations[78].kappas[1] = 3.8955627628160325f;
    representations[78].normalizations[1] = 0.6202544751769821f;
    representations[78].weights[2] = 0.35176757951504606f;
    representations[78].meanCosines[2] = 0.24455092610935678f;
    representations[78].kappas[2] = 0.7647642149394f;
    representations[78].normalizations[2] = 0.15537640901792682f;
    representations[78].weights[3] = 0.0f;
    representations[78].meanCosines[3] = 0.0f;
    representations[78].kappas[3] = 0.0f;
    representations[78].normalizations[3] = 0.0f;

    representations[79].K = 3;
    representations[79].g = 0.6158267716535433f;
    representations[79].weights[0] = 0.21827030956844096f;
    representations[79].meanCosines[0] = 0.9318363148472478f;
    representations[79].kappas[0] = 15.0847624352229f;
    representations[79].normalizations[0] = 2.400814506932851f;
    representations[79].weights[1] = 0.4362504726325965f;
    representations[79].meanCosines[1] = 0.7372758864789994f;
    representations[79].kappas[1] = 3.9679362147525175f;
    representations[79].normalizations[1] = 0.6317426240166054f;
    representations[79].weights[2] = 0.3454792177989626f;
    representations[79].meanCosines[2] = 0.24727883164854889f;
    representations[79].kappas[2] = 0.7740466736698095f;
    representations[79].normalizations[2] = 0.15646641319686902f;
    representations[79].weights[3] = 0.0f;
    representations[79].meanCosines[3] = 0.0f;
    representations[79].kappas[3] = 0.0f;
    representations[79].normalizations[3] = 0.0f;

    representations[80].K = 3;
    representations[80].g = 0.6236220472440944f;
    representations[80].weights[0] = 0.22525660341537493f;
    representations[80].meanCosines[0] = 0.9340236772779147f;
    representations[80].kappas[0] = 15.573919583003752f;
    representations[80].normalizations[0] = 2.47866628495079f;
    representations[80].weights[1] = 0.43558520774587756f;
    representations[80].meanCosines[1] = 0.741875590576798f;
    representations[80].kappas[1] = 4.0418826507574455f;
    representations[80].normalizations[1] = 0.6434841227651966f;
    representations[80].weights[2] = 0.3391581888387475f;
    representations[80].meanCosines[2] = 0.25000328942163386f;
    representations[80].kappas[2] = 0.7833445758656036f;
    representations[80].normalizations[2] = 0.15756185584196966f;
    representations[80].weights[3] = 0.0f;
    representations[80].meanCosines[3] = 0.0f;
    representations[80].kappas[3] = 0.0f;
    representations[80].normalizations[3] = 0.0f;

    representations[81].K = 3;
    representations[81].g = 0.6314173228346457f;
    representations[81].weights[0] = 0.23241776175313703f;
    representations[81].meanCosines[0] = 0.9361681219135087f;
    representations[81].kappas[0] = 16.085837543042345f;
    representations[81].normalizations[0] = 2.560140558748405f;
    representations[81].weights[1] = 0.43477678714167f;
    representations[81].meanCosines[1] = 0.7464284999133005f;
    representations[81].kappas[1] = 4.117492199043666f;
    representations[81].normalizations[1] = 0.6554930806692963f;
    representations[81].weights[2] = 0.3328054511051931f;
    representations[81].meanCosines[2] = 0.25272498180459707f;
    representations[81].kappas[2] = 0.7926605874210905f;
    representations[81].normalizations[2] = 0.15866305057516353f;
    representations[81].weights[3] = 0.0f;
    representations[81].meanCosines[3] = 0.0f;
    representations[81].kappas[3] = 0.0f;
    representations[81].normalizations[3] = 0.0f;

    representations[82].K = 3;
    representations[82].g = 0.6392125984251968f;
    representations[82].weights[0] = 0.23975751170874146f;
    representations[82].meanCosines[0] = 0.938270840447678f;
    representations[82].kappas[0] = 16.622146439652063f;
    representations[82].normalizations[0] = 2.6454967706679846f;
    representations[82].weights[1] = 0.4338205035338164f;
    representations[82].meanCosines[1] = 0.7509369787660656f;
    representations[82].kappas[1] = 4.19486225496789f;
    representations[82].normalizations[1] = 0.6677847773966972f;
    representations[82].weights[2] = 0.326421984757442f;
    representations[82].meanCosines[2] = 0.2554446622503517f;
    representations[82].kappas[2] = 0.8019976488252991f;
    representations[82].normalizations[2] = 0.15977034747756208f;
    representations[82].weights[3] = 0.0f;
    representations[82].meanCosines[3] = 0.0f;
    representations[82].kappas[3] = 0.0f;
    representations[82].normalizations[3] = 0.0f;

    representations[83].K = 3;
    representations[83].g = 0.647007874015748f;
    representations[83].weights[0] = 0.2472797267392922f;
    representations[83].meanCosines[0] = 0.9403329568840185f;
    representations[83].kappas[0] = 17.184628287927787f;
    representations[83].normalizations[0] = 2.735018537220525f;
    representations[83].weights[1] = 0.4327115257623153f;
    representations[83].meanCosines[1] = 0.755403364106f;
    representations[83].kappas[1] = 4.274097395549266f;
    representations[83].normalizations[1] = 0.6803756490612852f;
    representations[83].weights[2] = 0.32000874749839253f;
    representations[83].meanCosines[2] = 0.25816313034840566f;
    representations[83].kappas[2] = 0.8113588939736538f;
    representations[83].normalizations[2] = 0.16088412390685938f;
    representations[83].weights[3] = 0.0f;
    representations[83].meanCosines[3] = 0.0f;
    representations[83].kappas[3] = 0.0f;
    representations[83].normalizations[3] = 0.0f;

    representations[84].K = 3;
    representations[84].g = 0.6548031496062992f;
    representations[84].weights[0] = 0.25498843647079295f;
    representations[84].meanCosines[0] = 0.9423555310229852f;
    representations[84].kappas[0] = 17.775234863783915f;
    representations[84].normalizations[0] = 2.8290164931906037f;
    representations[84].weights[1] = 0.4314448895810194f;
    representations[84].meanCosines[1] = 0.7598299689358737f;
    representations[84].kappas[1] = 4.3553100825444515f;
    representations[84].normalizations[1] = 0.6932833994669038f;
    representations[84].weights[2] = 0.31356667394818777f;
    representations[84].meanCosines[2] = 0.26088123558629017f;
    representations[84].kappas[2] = 0.8207476668897828f;
    representations[84].normalizations[2] = 0.1620047868302051f;
    representations[84].weights[3] = 0.0f;
    representations[84].meanCosines[3] = 0.0f;
    representations[84].kappas[3] = 0.0f;
    representations[84].normalizations[3] = 0.0f;

    representations[85].K = 3;
    representations[85].g = 0.6625984251968504f;
    representations[85].weights[0] = 0.26288783702158497f;
    representations[85].meanCosines[0] = 0.9443395617200645f;
    representations[85].kappas[0] = 18.396108136191025f;
    representations[85].normalizations[0] = 2.927831543527836f;
    representations[85].weights[1] = 0.43001548795721395f;
    representations[85].meanCosines[1] = 0.7642190859151877f;
    representations[85].kappas[1] = 4.438621453366375f;
    representations[85].normalizations[1] = 0.7065271253657252f;
    representations[85].weights[2] = 0.3070966750212011f;
    representations[85].meanCosines[2] = 0.26359988157208303f;
    representations[85].kappas[2] = 0.8301675404574355f;
    representations[85].normalizations[2] = 0.1631327754356981f;
    representations[85].weights[3] = 0.0f;
    representations[85].meanCosines[3] = 0.0f;
    representations[85].kappas[3] = 0.0f;
    representations[85].normalizations[3] = 0.0f;

    representations[86].K = 3;
    representations[86].g = 0.6703937007874016f;
    representations[86].weights[0] = 0.2709823025842266f;
    representations[86].meanCosines[0] = 0.946285989794297f;
    representations[86].kappas[0] = 19.04960365116869f;
    representations[86].normalizations[0] = 3.0318385850249148f;
    representations[86].weights[1] = 0.42841806009583794f;
    representations[86].meanCosines[1] = 0.7685729910925694f;
    representations[86].kappas[1] = 4.524162209037049f;
    representations[86].normalizations[1] = 0.7201274571932929f;
    representations[86].weights[2] = 0.30059963731993555f;
    representations[86].meanCosines[2] = 0.26632003080603134f;
    representations[86].kappas[2] = 0.8396223375305958f;
    representations[86].normalizations[2] = 0.1642685640724313f;
    representations[86].weights[3] = 0.0f;
    representations[86].meanCosines[3] = 0.0f;
    representations[86].kappas[3] = 0.0f;
    representations[86].normalizations[3] = 0.0f;

    representations[87].K = 3;
    representations[87].g = 0.6781889763779527f;
    representations[87].weights[0] = 0.27927639895625234f;
    representations[87].meanCosines[0] = 0.9481957005904299f;
    representations[87].kappas[0] = 19.738317362685333f;
    representations[87].normalizations[0] = 3.141450776587954f;
    representations[87].weights[1] = 0.42664717956103104f;
    representations[87].meanCosines[1] = 0.7728939469951241f;
    representations[87].kappas[1] = 4.6120735976093465f;
    representations[87].normalizations[1] = 0.7341067150314727f;
    representations[87].weights[2] = 0.2940764214827166f;
    representations[87].meanCosines[2] = 0.26904270916915274f;
    representations[87].kappas[2] = 0.8491161515891782f;
    representations[87].normalizations[2] = 0.16541266518389522f;
    representations[87].weights[3] = 0.0f;
    representations[87].meanCosines[3] = 0.0f;
    representations[87].kappas[3] = 0.0f;
    representations[87].normalizations[3] = 0.0f;

    representations[88].K = 3;
    representations[88].g = 0.6859842519685039f;
    representations[88].weights[0] = 0.28777489737254797f;
    representations[88].meanCosines[0] = 0.950069526417547f;
    representations[88].kappas[0] = 20.46511658959084f;
    representations[88].normalizations[0] = 3.257124466185333f;
    representations[88].weights[1] = 0.4246972411959944f;
    representations[88].meanCosines[1] = 0.777184206751141f;
    representations[88].kappas[1] = 4.702508541381448f;
    representations[88].normalizations[1] = 0.7484890874829961f;
    representations[88].weights[2] = 0.2875278614314578f;
    representations[88].meanCosines[2] = 0.27176901175720886f;
    representations[88].kappas[2] = 0.8586533726595088f;
    representations[88].normalizations[2] = 0.16656563292649454f;
    representations[88].weights[3] = 0.0f;
    representations[88].meanCosines[3] = 0.0f;
    representations[88].kappas[3] = 0.0f;
    representations[88].normalizations[3] = 0.0f;

    representations[89].K = 3;
    representations[89].g = 0.6937795275590551f;
    representations[89].weights[0] = 0.29648279054616156f;
    representations[89].meanCosines[0] = 0.9519082486667635f;
    representations[89].kappas[0] = 21.233175767008145f;
    representations[89].normalizations[0] = 3.3793648808583927f;
    representations[89].weights[1] = 0.42256244663705916f;
    representations[89].meanCosines[1] = 0.7814460177839457f;
    representations[89].kappas[1] = 4.79563289895453f;
    representations[89].normalizations[1] = 0.7633008320368476f;
    representations[89].weights[2] = 0.2809547628167793f;
    representations[89].meanCosines[2] = 0.27450010877501546f;
    representations[89].kappas[2] = 0.8682387141297602f;
    representations[89].normalizations[2] = 0.16772806695708195f;
    representations[89].weights[3] = 0.0f;
    representations[89].meanCosines[3] = 0.0f;
    representations[89].kappas[3] = 0.0f;
    representations[89].normalizations[3] = 0.0f;

    representations[90].K = 3;
    representations[90].g = 0.7015748031496063f;
    representations[90].weights[0] = 0.30540725904987076f;
    representations[90].meanCosines[0] = 0.9537123443474214f;
    representations[90].kappas[0] = 22.04589839813786f;
    representations[90].normalizations[0] = 3.508713704965338f;
    representations[90].weights[1] = 0.4202357317039357f;
    representations[90].meanCosines[1] = 0.7856805379542191f;
    representations[90].kappas[1] = 4.891601785632994f;
    representations[90].normalizations[1] = 0.7785665078511023f;
    representations[90].weights[2] = 0.27435700924619355f;
    representations[90].meanCosines[2] = 0.27723648769685544f;
    representations[90].kappas[2] = 0.8778745463929781f;
    representations[90].normalizations[2] = 0.16890028814166394f;
    representations[90].weights[3] = 0.0f;
    representations[90].meanCosines[3] = 0.0f;
    representations[90].kappas[3] = 0.0f;
    representations[90].normalizations[3] = 0.0f;

    representations[91].K = 3;
    representations[91].g = 0.7093700787401575f;
    representations[91].weights[0] = 0.314550142879425f;
    representations[91].meanCosines[0] = 0.9554829884712971f;
    representations[91].kappas[0] = 22.907423174275007f;
    representations[91].normalizations[0] = 3.645829631683703f;
    representations[91].weights[1] = 0.41771281013698197f;
    representations[91].meanCosines[1] = 0.7898920757285216f;
    representations[91].kappas[1] = 4.990657929218684f;
    representations[91].normalizations[1] = 0.7943246211247126f;
    representations[91].weights[2] = 0.2677370469835929f;
    representations[91].meanCosines[2] = 0.2799809273695421f;
    representations[91].kappas[2] = 0.887571384710121f;
    representations[91].normalizations[2] = 0.1700836159252505f;
    representations[91].weights[3] = 0.0f;
    representations[91].meanCosines[3] = 0.0f;
    representations[91].kappas[3] = 0.0f;
    representations[91].normalizations[3] = 0.0f;

    representations[92].K = 3;
    representations[92].g = 0.7171653543307086f;
    representations[92].weights[0] = 0.323918941281032f;
    representations[92].meanCosines[0] = 0.9572205847121196f;
    representations[92].kappas[0] = 23.822020537466877f;
    representations[92].normalizations[0] = 3.791392322974503f;
    representations[92].weights[1] = 0.41498628744100596f;
    representations[92].meanCosines[1] = 0.7940819034205951f;
    representations[92].kappas[1] = 5.092993495012177f;
    representations[92].normalizations[1] = 0.8106056455269498f;
    representations[92].weights[2] = 0.2610947712779621f;
    representations[92].meanCosines[2] = 0.282734183473497f;
    representations[92].kappas[2] = 0.8973327073543883f;
    representations[92].normalizations[2] = 0.17127852245500216f;
    representations[92].weights[3] = 0.0f;
    representations[92].meanCosines[3] = 0.0f;
    representations[92].kappas[3] = 0.0f;
    representations[92].normalizations[3] = 0.0f;

    representations[93].K = 3;
    representations[93].g = 0.7249606299212599f;
    representations[93].weights[0] = 0.33351973492144515f;
    representations[93].meanCosines[0] = 0.9589257276203178f;
    representations[93].kappas[0] = 24.794582197555773f;
    representations[93].normalizations[0] = 3.9461803186393105f;
    representations[93].weights[1] = 0.4120494090831267f;
    representations[93].meanCosines[1] = 0.7982522854579217f;
    representations[93].kappas[1] = 5.198842429689294f;
    representations[93].normalizations[1] = 0.8274467106645826f;
    representations[93].weights[2] = 0.2544308559954282f;
    representations[93].meanCosines[2] = 0.28549779909773215f;
    representations[93].kappas[2] = 0.9071648530197196f;
    representations[93].normalizations[2] = 0.17248583639675724f;
    representations[93].weights[3] = 0.0f;
    representations[93].meanCosines[3] = 0.0f;
    representations[93].kappas[3] = 0.0f;
    representations[93].normalizations[3] = 0.0f;

    representations[94].K = 3;
    representations[94].g = 0.732755905511811f;
    representations[94].weights[0] = 0.34335893848221183f;
    representations[94].meanCosines[0] = 0.9605989682723478f;
    representations[94].kappas[0] = 25.830596813856708f;
    representations[94].normalizations[0] = 4.111067165939057f;
    representations[94].weights[1] = 0.4088951248319031f;
    representations[94].meanCosines[1] = 0.8024055019653422f;
    representations[94].kappas[1] = 5.308461053986367f;
    representations[94].normalizations[1] = 0.844888514968835f;
    representations[94].weights[2] = 0.24774593668588507f;
    representations[94].meanCosines[2] = 0.28827343354031715f;
    representations[94].kappas[2] = 0.9170746723463243f;
    representations[94].normalizations[2] = 0.17370645864779166f;
    representations[94].weights[3] = 0.0f;
    representations[94].meanCosines[3] = 0.0f;
    representations[94].kappas[3] = 0.0f;
    representations[94].normalizations[3] = 0.0f;

    representations[95].K = 3;
    representations[95].g = 0.7405511811023622f;
    representations[95].weights[0] = 0.3534433331276196f;
    representations[95].meanCosines[0] = 0.9622408150553718f;
    representations[95].kappas[0] = 26.936241870352298f;
    representations[95].normalizations[0] = 4.2870360419854485f;
    representations[95].weights[1] = 0.4055160595500465f;
    representations[95].meanCosines[1] = 0.8065438531577983f;
    representations[95].kappas[1] = 5.4221308324173805f;
    representations[95].normalizations[1] = 0.862975766145269f;
    representations[95].weights[2] = 0.241040607322334f;
    representations[95].meanCosines[2] = 0.29106287302029366f;
    representations[95].kappas[2] = 0.9270695781955348f;
    representations[95].normalizations[2] = 0.1749413695318436f;
    representations[95].weights[3] = 0.0f;
    representations[95].meanCosines[3] = 0.0f;
    representations[95].kappas[3] = 0.0f;
    representations[95].normalizations[3] = 0.0f;

    representations[96].K = 3;
    representations[96].g = 0.7483464566929133f;
    representations[96].weights[0] = 0.3637801026569973f;
    representations[96].meanCosines[0] = 0.9638517343301604f;
    representations[96].kappas[0] = 28.11849281221908f;
    representations[96].normalizations[0] = 4.475197123358596f;
    representations[96].weights[1] = 0.4019044800572026f;
    representations[96].meanCosines[1] = 0.8106696644633893f;
    representations[96].kappas[1] = 5.540161579519249f;
    representations[96].normalizations[1] = 0.8817576911146353f;
    representations[96].weights[2] = 0.23431541728580002f;
    representations[96].meanCosines[2] = 0.2938680432362927f;
    representations[96].kappas[2] = 0.937157604192799f;
    representations[96].normalizations[2] = 0.17619163714893982f;
    representations[96].weights[3] = 0.0f;
    representations[96].meanCosines[3] = 0.0f;
    representations[96].kappas[3] = 0.0f;
    representations[96].normalizations[3] = 0.0f;

    representations[97].K = 3;
    representations[97].g = 0.7561417322834645f;
    representations[97].weights[0] = 0.3743768742282063f;
    representations[97].meanCosines[0] = 0.9654321509327287f;
    representations[97].kappas[0] = 29.385253280066383f;
    representations[97].normalizations[0] = 4.676808313529897f;
    representations[97].weights[1] = 0.3980522577175622f;
    representations[97].meanCosines[1] = 0.8147852920835721f;
    representations[97].kappas[1] = 5.662895174359178f;
    representations[97].normalizations[1] = 0.9012886268604031f;
    representations[97].weights[2] = 0.22757086805423143f;
    representations[97].meanCosines[2] = 0.2966910234570728f;
    representations[97].kappas[2] = 0.947347470721517f;
    representations[97].normalizations[2] = 0.17745842680432455f;
    representations[97].weights[3] = 0.0f;
    representations[97].meanCosines[3] = 0.0f;
    representations[97].kappas[3] = 0.0f;
    representations[97].normalizations[3] = 0.0f;

    representations[98].K = 3;
    representations[98].g = 0.7639370078740157f;
    representations[98].weights[0] = 0.38524176513689695f;
    representations[98].meanCosines[0] = 0.9669824484448641f;
    representations[98].kappas[0] = 30.745511243403147f;
    representations[98].normalizations[0] = 4.893300092275056f;
    representations[98].weights[1] = 0.39395082537468784f;
    representations[98].meanCosines[1] = 0.8188931287879918f;
    representations[98].kappas[1] = 5.790709872115165f;
    representations[98].normalizations[1] = 0.921628706315985f;
    representations[98].weights[2] = 0.22080740948841507f;
    representations[98].meanCosines[2] = 0.29953406232822644f;
    representations[98].kappas[2] = 0.9576486593632786f;
    representations[98].normalizations[2] = 0.1787430116657337f;
    representations[98].weights[3] = 0.0f;
    representations[98].meanCosines[3] = 0.0f;
    representations[98].kappas[3] = 0.0f;
    representations[98].normalizations[3] = 0.0f;

    representations[99].K = 3;
    representations[99].g = 0.7717322834645669f;
    representations[99].weights[0] = 0.3963834354896696f;
    representations[99].meanCosines[0] = 0.9685029693213756f;
    representations[99].kappas[0] = 32.20952726109539f;
    representations[99].normalizations[0] = 5.126305478256488f;
    representations[99].weights[1] = 0.389591128435386f;
    representations[99].meanCosines[1] = 0.8229956105366834f;
    representations[99].kappas[1] = 5.924025346530906f;
    representations[99].normalizations[1] = 0.9428446605844728f;
    representations[99].weights[2] = 0.21402543607494445f;
    representations[99].meanCosines[2] = 0.30239959610284156f;
    representations[99].kappas[2] = 0.9680714987483626f;
    representations[99].normalizations[2] = 0.1800467850491632f;
    representations[99].weights[3] = 0.0f;
    representations[99].meanCosines[3] = 0.0f;
    representations[99].kappas[3] = 0.0f;
    representations[99].normalizations[3] = 0.0f;

    representations[100].K = 3;
    representations[100].g = 0.7795275590551181f;
    representations[100].weights[0] = 0.40781114817626546f;
    representations[100].meanCosines[0] = 0.9699940148344911f;
    representations[100].kappas[0] = 33.78906273533941f;
    representations[100].normalizations[0] = 5.377696356771425f;
    representations[100].weights[1] = 0.384963568809248f;
    representations[100].meanCosines[1] = 0.8270952239166515f;
    representations[100].kappas[1] = 6.0633086088731885f;
    representations[100].normalizations[1] = 0.9650107606665378f;
    representations[100].weights[2] = 0.20722528301448653f;
    representations[100].meanCosines[2] = 0.3052902696089327f;
    representations[100].kappas[2] = 0.9786272634654758f;
    representations[100].normalizations[2] = 0.18137127457879043f;
    representations[100].weights[3] = 0.0f;
    representations[100].meanCosines[3] = 0.0f;
    representations[100].kappas[3] = 0.0f;
    representations[100].normalizations[3] = 0.0f;

    representations[101].K = 3;
    representations[101].g = 0.7873228346456692f;
    representations[101].weights[0] = 0.41953483679279924f;
    representations[101].meanCosines[0] = 0.9714558448595689f;
    representations[101].kappas[0] = 35.49765836096025f;
    representations[101].normalizations[0] = 5.649627796334172f;
    representations[101].weights[1] = 0.3800579408710988f;
    representations[101].meanCosines[1] = 0.8311945147568722f;
    representations[101].kappas[1] = 6.209080996730074f;
    representations[101].normalizations[1] = 0.9882099294651575f;
    representations[101].weights[2] = 0.2004072223361021f;
    representations[101].meanCosines[2] = 0.3082089606822717f;
    representations[101].kappas[2] = 0.9893282893087417f;
    representations[101].normalizations[2] = 0.18271815867924948f;
    representations[101].weights[3] = 0.0f;
    representations[101].meanCosines[3] = 0.0f;
    representations[101].kappas[3] = 0.0f;
    representations[101].normalizations[3] = 0.0f;

    representations[102].K = 3;
    representations[102].g = 0.7951181102362205f;
    representations[102].weights[0] = 0.4315651834971288f;
    representations[102].meanCosines[0] = 0.9728886774534552f;
    representations[102].kappas[0] = 37.35097594771657f;
    representations[102].normalizations[0] = 5.944592451385582f;
    representations[102].weights[1] = 0.3748633576315606f;
    representations[102].meanCosines[1] = 0.8352960978646506f;
    representations[102].kappas[1] = 6.361926458461669f;
    representations[102].normalizations[1] = 1.0125350600042866f;
    representations[102].weights[2] = 0.1935714588713106f;
    representations[102].meanCosines[2] = 0.3111588084871263f;
    representations[102].kappas[2] = 1.0001881071793164f;
    representations[102].normalizations[2] = 0.18408928574987296f;
    representations[102].weights[3] = 0.0f;
    representations[102].meanCosines[3] = 0.0f;
    representations[102].kappas[3] = 0.0f;
    representations[102].normalizations[3] = 0.0f;

    representations[103].K = 3;
    representations[103].g = 0.8029133858267716f;
    representations[103].weights[0] = 0.44391370756781706f;
    representations[103].meanCosines[0] = 0.9742926882438233f;
    representations[103].kappas[0] = 39.367220961959f;
    representations[103].normalizations[0] = 6.265487811886654f;
    representations[103].weights[1] = 0.36936816605135847f;
    representations[103].meanCosines[1] = 0.8394026685967423f;
    representations[103].kappas[1] = 6.522501446086053f;
    representations[103].normalizations[1] = 1.038090589640147f;
    representations[103].weights[2] = 0.18671812638082452f;
    representations[103].meanCosines[2] = 0.31414324697871443f;
    representations[103].kappas[2] = 1.0112216011955533f;
    representations[103].normalizations[2] = 0.18548669679179886f;
    representations[103].weights[3] = 0.0f;
    representations[103].meanCosines[3] = 0.0f;
    representations[103].kappas[3] = 0.0f;
    representations[103].normalizations[3] = 0.0f;

    representations[104].K = 3;
    representations[104].g = 0.8107086614173228f;
    representations[104].weights[0] = 0.4565928655077412f;
    representations[104].meanCosines[0] = 0.9756680097086392f;
    representations[104].kappas[0] = 41.567668857394764f;
    representations[104].normalizations[0] = 6.615699971461414f;
    representations[104].weights[1] = 0.3635598499248879f;
    representations[104].meanCosines[1] = 0.8435170173064288f;
    representations[104].kappas[1] = 6.691546828263287f;
    representations[104].normalizations[1] = 1.0649943957813093f;
    representations[104].weights[2] = 0.17984728456737106f;
    representations[104].meanCosines[2] = 0.3171660455034625f;
    representations[104].kappas[2] = 1.0224451996197383f;
    representations[104].normalizations[2] = 0.18691265266954193f;
    representations[104].weights[3] = 0.0f;
    representations[104].meanCosines[3] = 0.0f;
    representations[104].kappas[3] = 0.0f;
    representations[104].normalizations[3] = 0.0f;

    representations[105].K = 3;
    representations[105].g = 0.8185039370078739f;
    representations[105].weights[0] = 0.4696161649129583f;
    representations[105].meanCosines[0] = 0.977014730283103f;
    representations[105].kappas[0] = 43.97732584501906f;
    representations[105].normalizations[0] = 6.999208792197747f;
    representations[105].weights[1] = 0.35742491854950126f;
    representations[105].meanCosines[1] = 0.84764204686941f;
    representations[105].kappas[1] = 6.869902315309078f;
    representations[105].normalizations[1] = 1.093380091409223f;
    representations[105].weights[2] = 0.17295891653754053f;
    representations[105].meanCosines[2] = 0.32023135742690917f;
    representations[105].kappas[2] = 1.0338771035147776f;
    representations[105].normalizations[2] = 0.18836966675060354f;
    representations[105].weights[3] = 0.0f;
    representations[105].meanCosines[3] = 0.0f;
    representations[105].kappas[3] = 0.0f;
    representations[105].normalizations[3] = 0.0f;

    representations[106].K = 3;
    representations[106].g = 0.8262992125984252f;
    representations[106].weights[0] = 0.4829982941672016f;
    representations[106].meanCosines[0] = 0.9783328932720207f;
    representations[106].kappas[0] = 46.62576555511482f;
    representations[106].normalizations[0] = 7.420721063540353f;
    representations[106].weights[1] = 0.35094877818208203f;
    representations[106].meanCosines[1] = 0.8517807946686041f;
    representations[106].kappas[1] = 7.058524082784808f;
    representations[106].normalizations[1] = 1.1233998296647842f;
    representations[106].weights[2] = 0.16605292765071641f;
    representations[106].meanCosines[2] = 0.3233437801620528f;
    representations[106].kappas[2] = 1.0455375677314898f;
    representations[106].normalizations[2] = 0.18986054493140442f;
    representations[106].weights[3] = 0.0f;
    representations[106].meanCosines[3] = 0.0f;
    representations[106].kappas[3] = 0.0f;
    representations[106].normalizations[3] = 0.0f;

    representations[107].K = 3;
    representations[107].g = 0.8340944881889764f;
    representations[107].weights[0] = 0.4967552695533019f;
    representations[107].meanCosines[0] = 0.9796224956118234f;
    representations[107].kappas[0] = 49.548198396402306f;
    representations[107].normalizations[0] = 7.885840696085349f;
    representations[107].weights[1] = 0.34411558431336736f;
    representations[107].meanCosines[1] = 0.8559364605914935f;
    representations[107].kappas[1] = 7.258506499478957f;
    representations[107].normalizations[1] = 1.155227761664598f;
    representations[107].weights[2] = 0.15912914613333057f;
    representations[107].meanCosines[2] = 0.32650842986505385f;
    representations[107].kappas[2] = 1.0574492492183072f;
    representations[107].normalizations[2] = 0.19138843516693316f;
    representations[107].weights[3] = 0.0f;
    representations[107].meanCosines[3] = 0.0f;
    representations[107].kappas[3] = 0.0f;
    representations[107].normalizations[3] = 0.0f;

    representations[108].K = 3;
    representations[108].g = 0.8418897637795275f;
    representations[108].weights[0] = 0.5109046020998166f;
    representations[108].meanCosines[0] = 0.9808834864797452f;
    representations[108].kappas[0] = 52.786852197566795f;
    representations[108].normalizations[0] = 8.401288457504034f;
    representations[108].weights[1] = 0.3369080716212091f;
    representations[108].meanCosines[1] = 0.8601124431065127f;
    representations[108].kappas[1] = 7.471109181727082f;
    representations[108].normalizations[1] = 1.1890643420250768f;
    representations[108].weights[2] = 0.15218732627897416f;
    representations[108].meanCosines[2] = 0.329731035892612f;
    representations[108].kappas[2] = 1.069637645498256f;
    representations[108].normalizations[2] = 0.19295688969917166f;
    representations[108].weights[3] = 0.0f;
    representations[108].meanCosines[3] = 0.0f;
    representations[108].kappas[3] = 0.0f;
    representations[108].normalizations[3] = 0.0f;

    representations[109].K = 3;
    representations[109].g = 0.8496850393700787f;
    representations[109].weights[0] = 0.5254626731586894f;
    representations[109].meanCosines[0] = 0.9821159342861068f;
    representations[109].kappas[0] = 56.39330160029513f;
    representations[109].normalizations[0] = 8.975272706959062f;
    representations[109].weights[1] = 0.3293094541752853f;
    representations[109].meanCosines[1] = 0.8643135954007387f;
    representations[109].kappas[1] = 7.69785828048804f;
    representations[109].normalizations[1] = 1.2251524488594658f;
    representations[109].weights[2] = 0.14522787266602524f;
    representations[109].meanCosines[2] = 0.333019161366721f;
    representations[109].kappas[2] = 1.0821358440292181f;
    representations[109].normalizations[2] = 0.19457048614110656f;
    representations[109].weights[3] = 0.0f;
    representations[109].meanCosines[3] = 0.0f;
    representations[109].kappas[3] = 0.0f;
    representations[109].normalizations[3] = 0.0f;

    representations[110].K = 3;
    representations[110].g = 0.8574803149606299f;
    representations[110].weights[0] = 0.5404523430049603f;
    representations[110].meanCosines[0] = 0.98331956425316f;
    representations[110].kappas[0] = 60.429586611677735f;
    representations[110].normalizations[0] = 9.617667418248331f;
    representations[110].weights[1] = 0.3212977300181286f;
    representations[110].meanCosines[1] = 0.8685431140960943f;
    representations[110].kappas[1] = 7.940423625414496f;
    representations[110].normalizations[1] = 1.2637578304420414f;
    representations[110].weights[2] = 0.1382499269769111f;
    representations[110].meanCosines[2] = 0.3363795356492694f;
    representations[110].kappas[2] = 1.094974535419832f;
    representations[110].normalizations[2] = 0.19623354919267594f;
    representations[110].weights[3] = 0.0f;
    representations[110].meanCosines[3] = 0.0f;
    representations[110].kappas[3] = 0.0f;
    representations[110].normalizations[3] = 0.0f;

    representations[111].K = 3;
    representations[111].g = 0.8652755905511811f;
    representations[111].weights[0] = 0.5559119561109656f;
    representations[111].meanCosines[0] = 0.9844933366024191f;
    representations[111].kappas[0] = 64.96899206355937f;
    representations[111].normalizations[0] = 10.340136234613592f;
    representations[111].weights[1] = 0.31283862434945703f;
    representations[111].meanCosines[1] = 0.8727988632471873f;
    representations[111].kappas[1] = 8.20040365631985f;
    representations[111].normalizations[1] = 1.3051348756250123f;
    representations[111].weights[2] = 0.13124941953957747f;
    representations[111].meanCosines[2] = 0.339814518724571f;
    representations[111].kappas[2] = 1.1081683784152283f;
    representations[111].normalizations[2] = 0.19794837195289897f;
    representations[111].weights[3] = 0.0f;
    representations[111].meanCosines[3] = 0.0f;
    representations[111].kappas[3] = 0.0f;
    representations[111].normalizations[3] = 0.0f;

    representations[112].K = 3;
    representations[112].g = 0.8730708661417322f;
    representations[112].weights[0] = 0.5718393884942973f;
    representations[112].meanCosines[0] = 0.9856385541741431f;
    representations[112].kappas[0] = 70.11289450093315f;
    representations[112].normalizations[0] = 11.158813734304077f;
    representations[112].weights[1] = 0.3039279013397253f;
    representations[112].meanCosines[1] = 0.877097567216021f;
    representations[112].kappas[1] = 8.480895648432082f;
    representations[112].normalizations[1] = 1.3497765223508311f;
    representations[112].weights[2] = 0.12423271016597735f;
    representations[112].meanCosines[2] = 0.34334507908236944f;
    representations[112].kappas[2] = 1.1218045936162597f;
    representations[112].normalizations[2] = 0.1997267555056942f;
    representations[112].weights[3] = 0.0f;
    representations[112].meanCosines[3] = 0.0f;
    representations[112].kappas[3] = 0.0f;
    representations[112].normalizations[3] = 0.0f;

    representations[113].K = 3;
    representations[113].g = 0.8808661417322834f;
    representations[113].weights[0] = 0.5882755569376641f;
    representations[113].meanCosines[0] = 0.9867541732199454f;
    representations[113].kappas[0] = 75.97889680688574f;
    representations[113].normalizations[0] = 12.09241699748489f;
    representations[113].weights[1] = 0.29452813547870665f;
    representations[113].meanCosines[1] = 0.8814393829516305f;
    representations[113].kappas[1] = 8.784435438014446f;
    representations[113].normalizations[1] = 1.3980863550011564f;
    representations[113].weights[2] = 0.11719630758362938f;
    representations[113].meanCosines[2] = 0.34697797664221613f;
    representations[113].kappas[2] = 1.1359172624615688f;
    representations[113].normalizations[2] = 0.201573696281553f;
    representations[113].weights[3] = 0.0f;
    representations[113].meanCosines[3] = 0.0f;
    representations[113].kappas[3] = 0.0f;
    representations[113].normalizations[3] = 0.0f;

    representations[114].K = 3;
    representations[114].g = 0.8886614173228347f;
    representations[114].weights[0] = 0.6052504230780653f;
    representations[114].meanCosines[0] = 0.9878398850719791f;
    representations[114].kappas[0] = 82.7208461258252f;
    representations[114].normalizations[0] = 13.165431557669141f;
    representations[114].weights[1] = 0.28460934660642634f;
    representations[114].meanCosines[1] = 0.8858313360968593f;
    representations[114].kappas[1] = 9.114532078598165f;
    representations[114].normalizations[1] = 1.450622851848577f;
    representations[114].weights[2] = 0.11014023031550828f;
    representations[114].meanCosines[2] = 0.35072796340726353f;
    representations[114].kappas[2] = 1.1505728992115452f;
    representations[114].normalizations[2] = 0.20349852757540107f;
    representations[114].weights[3] = 0.0f;
    representations[114].meanCosines[3] = 0.0f;
    representations[114].kappas[3] = 0.0f;
    representations[114].normalizations[3] = 0.0f;

    representations[115].K = 3;
    representations[115].g = 0.8964566929133858f;
    representations[115].weights[0] = 0.6228027995524672f;
    representations[115].meanCosines[0] = 0.9888950555229361f;
    representations[115].kappas[0] = 90.53608079149387f;
    representations[115].normalizations[0] = 14.409264786133447f;
    representations[115].weights[1] = 0.2741336567223465f;
    representations[115].meanCosines[1] = 0.8902793797177282f;
    representations[115].kappas[1] = 9.475314166168351f;
    representations[115].normalizations[1] = 1.5080430957712354f;
    representations[115].weights[2] = 0.10306354372518628f;
    representations[115].meanCosines[2] = 0.35461082756841766f;
    representations[115].kappas[2] = 1.1658441284758267f;
    representations[115].normalizations[2] = 0.20551152432759512f;
    representations[115].weights[3] = 0.0f;
    representations[115].meanCosines[3] = 0.0f;
    representations[115].kappas[3] = 0.0f;
    representations[115].normalizations[3] = 0.0f;

    representations[116].K = 3;
    representations[116].g = 0.904251968503937f;
    representations[116].weights[0] = 0.6409625400276326f;
    representations[116].meanCosines[0] = 0.9899195955960743f;
    representations[116].kappas[0] = 99.68975599147025f;
    representations[116].normalizations[0] = 15.866117441667381f;
    representations[116].weights[1] = 0.2630691381584243f;
    representations[116].meanCosines[1] = 0.8947966101812765f;
    representations[116].kappas[1] = 9.872432613573858f;
    representations[116].normalizations[1] = 1.571246454971746f;
    representations[116].weights[2] = 0.095968321813943f;
    representations[116].meanCosines[2] = 0.35865262749978183f;
    representations[116].kappas[2] = 1.1818467475255494f;
    representations[116].normalizations[2] = 0.20762883801820764f;
    representations[116].weights[3] = 0.0f;
    representations[116].meanCosines[3] = 0.0f;
    representations[116].kappas[3] = 0.0f;
    representations[116].normalizations[3] = 0.0f;

    representations[117].K = 3;
    representations[117].g = 0.9120472440944881f;
    representations[117].weights[0] = 0.6597760942835212f;
    representations[117].meanCosines[0] = 0.990912757734808f;
    representations[117].kappas[0] = 110.53301707231405f;
    representations[117].normalizations[0] = 17.59187604191964f;
    representations[117].weights[1] = 0.2513693157615257f;
    representations[117].meanCosines[1] = 0.8993933442306955f;
    representations[117].kappas[1] = 10.312609687465988f;
    representations[117].normalizations[1] = 1.6413028097479578f;
    representations[117].weights[2] = 0.08885458995495317f;
    representations[117].meanCosines[2] = 0.3628812013801927f;
    representations[117].kappas[2] = 1.1987075268355516f;
    representations[117].normalizations[2] = 0.20986833173806205f;
    representations[117].weights[3] = 0.0f;
    representations[117].meanCosines[3] = 0.0f;
    representations[117].kappas[3] = 0.0f;
    representations[117].normalizations[3] = 0.0f;

    representations[118].K = 3;
    representations[118].g = 0.9198425196850394f;
    representations[118].weights[0] = 0.6792894636829033f;
    representations[118].meanCosines[0] = 0.9918739739911012f;
    representations[118].kappas[0] = 123.55121730910922f;
    representations[118].normalizations[0] = 19.663786959765673f;
    representations[118].weights[1] = 0.23898619212136155f;
    representations[118].meanCosines[1] = 0.90408570736703f;
    representations[118].kappas[1] = 10.804874085633132f;
    representations[118].normalizations[1] = 1.719649120922708f;
    representations[118].weights[2] = 0.0817243441957352f;
    representations[118].meanCosines[2] = 0.3673375775419639f;
    representations[118].kappas[2] = 1.2166110601123843f;
    representations[118].normalizations[2] = 0.2122558873307257f;
    representations[118].weights[3] = 0.0f;
    representations[118].meanCosines[3] = 0.0f;
    representations[118].kappas[3] = 0.0f;
    representations[118].normalizations[3] = 0.0f;

    representations[119].K = 3;
    representations[119].g = 0.9276377952755905f;
    representations[119].weights[0] = 0.6995522112361258f;
    representations[119].meanCosines[0] = 0.9928026697072287f;
    representations[119].kappas[0] = 139.4314038120058f;
    representations[119].normalizations[0] = 22.191197138922863f;
    representations[119].weights[1] = 0.22586650550479143f;
    representations[119].meanCosines[1] = 0.9088960661837021f;
    representations[119].kappas[1] = 11.361507506541727f;
    representations[119].normalizations[1] = 1.8082400808865704f;
    representations[119].weights[2] = 0.07458128325908273f;
    representations[119].meanCosines[2] = 0.3720816407633235f;
    representations[119].kappas[2] = 1.2358257584794836f;
    representations[119].normalizations[2] = 0.21482908030767447f;
    representations[119].weights[3] = 0.0f;
    representations[119].meanCosines[3] = 0.0f;
    representations[119].kappas[3] = 0.0f;
    representations[119].normalizations[3] = 0.0f;

    representations[120].K = 3;
    representations[120].g = 0.9354330708661417f;
    representations[120].weights[0] = 0.7206159394099868f;
    representations[120].meanCosines[0] = 0.9936983266077104f;
    representations[120].kappas[0] = 159.18012629540559f;
    representations[120].normalizations[0] = 25.33430394190599f;
    representations[120].weights[1] = 0.2119520463912963f;
    representations[120].meanCosines[1] = 0.9138572737432618f;
    representations[120].kappas[1] = 11.999993458215888f;
    representations[120].normalizations[1] = 1.9098582760175666f;
    representations[120].weights[2] = 0.06743201419871682f;
    representations[120].meanCosines[2] = 0.37720700329635093f;
    representations[120].kappas[2] = 1.2567696961188874f;
    representations[120].normalizations[2] = 0.2176463521023088f;
    representations[120].weights[3] = 0.0f;
    representations[120].meanCosines[3] = 0.0f;
    representations[120].kappas[3] = 0.0f;
    representations[120].normalizations[3] = 0.0f;

    representations[121].K = 3;
    representations[121].g = 0.9432283464566928f;
    representations[121].weights[0] = 0.7425298903086794f;
    representations[121].meanCosines[0] = 0.9945606294046142f;
    representations[121].kappas[0] = 184.33799721904487f;
    representations[121].normalizations[0] = 29.338303457071046f;
    representations[121].weights[1] = 0.19718172827509786f;
    representations[121].meanCosines[1] = 0.9190211970423342f;
    representations[121].kappas[1] = 12.746832832976239f;
    representations[121].normalizations[1] = 2.028721454151434f;
    representations[121].weights[2] = 0.06028838141622271f;
    representations[121].meanCosines[2] = 0.3828729966523628f;
    representations[121].kappas[2] = 1.2801527883158197f;
    representations[121].normalizations[2] = 0.22080684477938303f;
    representations[121].weights[3] = 0.0f;
    representations[121].meanCosines[3] = 0.0f;
    representations[121].kappas[3] = 0.0f;
    representations[121].normalizations[3] = 0.0f;

    representations[122].K = 3;
    representations[122].g = 0.9510236220472441f;
    representations[122].weights[0] = 0.7653293103607429f;
    representations[122].meanCosines[0] = 0.9953898118117097f;
    representations[122].kappas[0] = 217.4051196152159f;
    representations[122].normalizations[0] = 34.60109944024639f;
    representations[122].weights[1] = 0.18149838112785868f;
    representations[122].meanCosines[1] = 0.9244773850283557f;
    representations[122].kappas[1] = 13.64592273008513f;
    representations[122].normalizations[1] = 2.1718160555461488f;
    representations[122].weights[2] = 0.05317230851139854f;
    representations[122].meanCosines[2] = 0.3893806024131917f;
    representations[122].kappas[2] = 1.3073167675130757f;
    representations[122].normalizations[2] = 0.22449796615062265f;
    representations[122].weights[3] = 0.0f;
    representations[122].meanCosines[3] = 0.0f;
    representations[122].kappas[3] = 0.0f;
    representations[122].normalizations[3] = 0.0f;

    representations[123].K = 3;
    representations[123].g = 0.9588188976377953f;
    representations[123].weights[0] = 0.7890052405183582f;
    representations[123].meanCosines[0] = 0.9961874879915438f;
    representations[123].kappas[0] = 262.7894883431296f;
    representations[123].normalizations[0] = 41.82424606239909f;
    representations[123].weights[1] = 0.16486806075823146f;
    representations[123].meanCosines[1] = 0.9303977710641655f;
    representations[123].kappas[1] = 14.779725799317857f;
    representations[123].normalizations[1] = 2.352266418504593f;
    representations[123].weights[2] = 0.04612669872341031f;
    representations[123].meanCosines[2] = 0.3973748382479435f;
    representations[123].kappas[2] = 1.3411535562102717f;
    representations[123].normalizations[2] = 0.22912451559489155f;
    representations[123].weights[3] = 0.0f;
    representations[123].meanCosines[3] = 0.0f;
    representations[123].kappas[3] = 0.0f;
    representations[123].normalizations[3] = 0.0f;

    representations[124].K = 3;
    representations[124].g = 0.9666141732283464f;
    representations[124].weights[0] = 0.8134132864130297f;
    representations[124].meanCosines[0] = 0.9969590951155314f;
    representations[124].kappas[0] = 329.34568100402697f;
    representations[124].normalizations[0] = 52.41699311775743f;
    representations[124].weights[1] = 0.14734309576502963f;
    representations[124].meanCosines[1] = 0.9371602294155938f;
    representations[124].kappas[1] = 16.334429702579303f;
    representations[124].normalizations[1] = 2.599705229752591f;
    representations[124].weights[2] = 0.03924361782194063f;
    representations[124].meanCosines[2] = 0.4084766247518925f;
    representations[124].kappas[2] = 1.38903995811237f;
    representations[124].normalizations[2] = 0.2357246896803882f;
    representations[124].weights[3] = 0.0f;
    representations[124].meanCosines[3] = 0.0f;
    representations[124].kappas[3] = 0.0f;
    representations[124].normalizations[3] = 0.0f;

    representations[125].K = 3;
    representations[125].g = 0.9744094488188976f;
    representations[125].weights[0] = 0.8380377885238703f;
    representations[125].meanCosines[0] = 0.9977192495345887f;
    representations[125].kappas[0] = 438.9493224499256f;
    representations[125].normalizations[0] = 69.86095443474393f;
    representations[125].weights[1] = 0.12922359501050967f;
    representations[125].meanCosines[1] = 0.9456890221956583f;
    representations[125].kappas[1] = 18.84421609415959f;
    representations[125].normalizations[1] = 2.999150140077348f;
    representations[125].weights[2] = 0.03273861646562f;
    representations[125].meanCosines[2] = 0.42761937604381417f;
    representations[125].kappas[2] = 1.4742417480145642f;
    representations[125].normalizations[2] = 0.24761249545923705f;
    representations[125].weights[3] = 0.0f;
    representations[125].meanCosines[3] = 0.0f;
    representations[125].kappas[3] = 0.0f;
    representations[125].normalizations[3] = 0.0f;

    representations[126].K = 3;
    representations[126].g = 0.9822047244094488f;
    representations[126].weights[0] = 0.86110354278221f;
    representations[126].meanCosines[0] = 0.9985077831939306f;
    representations[126].kappas[0] = 670.6420411084238f;
    representations[126].normalizations[0] = 106.73599588764372f;
    representations[126].weights[1] = 0.11170062456703932f;
    representations[126].meanCosines[1] = 0.958498099808663f;
    representations[126].kappas[1] = 24.543185034997688f;
    representations[126].normalizations[1] = 3.906169217538914f;
    representations[126].weights[2] = 0.027195832650750658f;
    representations[126].meanCosines[2] = 0.47512959398520177f;
    representations[126].kappas[2] = 1.7024552564942006f;
    representations[126].normalizations[2] = 0.28026159880811696f;
    representations[126].weights[3] = 0.0f;
    representations[126].meanCosines[3] = 0.0f;
    representations[126].kappas[3] = 0.0f;
    representations[126].normalizations[3] = 0.0f;

    representations[127].K = 3;
    representations[127].g = 0.99f;
    representations[127].weights[0] = 0.868073622158317f;
    representations[127].meanCosines[0] = 0.9994691382373244f;
    representations[127].kappas[0] = 1884.2289065113011f;
    representations[127].normalizations[0] = 299.88434438791035f;
    representations[127].weights[1] = 0.10584342660588578f;
    representations[127].meanCosines[1] = 0.9844441544134342f;
    representations[127].kappas[1] = 64.76504041838344f;
    representations[127].normalizations[1] = 10.307676322132117f;
    representations[127].weights[2] = 0.026082951235797305f;
    representations[127].meanCosines[2] = 0.7491038510925567f;
    representations[127].kappas[2] = 4.163095340893173f;
    representations[127].normalizations[2] = 0.6627376458781823f;
    representations[127].weights[3] = 0.0f;
    representations[127].meanCosines[3] = 0.0f;
    representations[127].kappas[3] = 0.0f;
    representations[127].normalizations[3] = 0.0f;
}
}  // namespace openpgl