Minutes from 94rd OpenVDB TSC meeting, June 8th, 2021, (EDT)

Attendees: *Ken* M. *Nick* A., *Jeff* L., *Dan* B., *Andre* P.

Additional Attendees: JT Nelson (Blender), Richard Jones (DNeg),
Johannes Meng (Intel), Sergio Rojas, Jeff Budsberg (DW)

Regrets: None

Agenda:

1) Confirm Quorum
2) Secretary
3) OpenEXR 3.0
4) 8.1 release
5) Sharpening PR: PR756
6) Boost Python
7) Next meeting

1) Confirm Quorum

Quorum is present.

2) Secretary

Secretary is Jeff Lait.

3) OpenEXR 3.0

Complaints about not supporting 3.0.  Fedora has moved to OpenEXR 3.0 but
OpenVDB doesn't support it.  There is no backwards compatibility for 2.0 in
3.0.  Everything has changed, we can't just select a new version via CMake.
There is the impression the ASWF has coordinated releases when it doesn't.
Should Fedora not continue to ship OpenEXR 2 for things that haven't upgraded?
Would we need #ifdef to support both 3.0 and 2.X?

Why not just turn off OpenEXR?  Currently building the renderer requires
OpenEXR.  But we can change it so that the render is opt-in for OpenEXR.

8.1 has no dependendency on half, but 8.0 still does.  So if we release 8.1 it
will support turning off the renderer and building without OpenEXR.  We should
release 8.1 as is, and consider a 8.1.1 that lets you disable OpenEXR in the
command line renderer.  Hopefully after 8.1 is released it will solve the
Fedora issue as they might not be building the renderer anyways.

This is a sign we should do more releases.  We had the changes ready earlier
but were waiting for more stuff.  It should be easy and straightforward, almost
a release per bug fix.

4) 8.1 release

Good to go, is ready as its own branch v8.1.0.  Release process is updated with
current process.  Ken will go through the mechanics of release.

5) Sharpening PR: PR756

This used boost multi array.  We can merge it as it is, or see if someone can
rip out the boost.

The std::vector<bool> problem could be fixed by templating into a
std::vector<int> or similar.

The multi array is for convolution kernels.

We would introduce net-new boost library dependencies.  These generate ragged
arrays, but that seems unnecessary.

We should commit it into a feature branch.  Then we can make PRs onto the
feature branch to fix the boost dependency.

We might want to include an unsharp mask to the the SOP version.

6) Boost Python

Request for more tools in python.  Someone commented that it is a pain to add
python support.  We've considered swapping boost::python for a lighter wrapper.
A request, Issue 1047, is for examples of how to wrap code to add more
features.  But then we should decide the future first.  We should find out
about studio python setups.  Boost python is very hard to build.  People find
it difficult to implement python bindings.  We know of PyBind11 as a potential.

Regardless of our binding, who supports it?  We've heard a lot of
interest/support for PyBind11.  We don't need to advocate to transition.  But
do we open the door for it?  Do we want to get rid of boost::python?  We can't
remove it as people might be using it?  But if we could remove it, the cost of
transition is less than maintaining boost::python.

We could state that we intend to migrate away from boost:python, but intend to
move to PyBind11.  But we need someone to pick it up?  We need a generic
agreement that we want PyBind11.  "Our preferred technology is PyBind11".  

This is not like Houdini vs Maya because both boost::python and PyBind11 will
target integrating with the same thing.   boost::python has been a long running
source of problems that we want to stop supporting.  People are looking for us
for consensus.

The hope is a new PyBind11 could be Python-compatible so the same python code
could run with boost::python or PyBind11.

We are seeing a lot of python bindings not being made because boost::python is
hard and seen as EOL.  The curent boost::python is incredibly hard to build, we
have a lot of CMake magic to get it to work.

We should hear from any projects using PyBind11.

Motion: We intend to accept a PyBind11 implementation that is API compatible with boost::python with the goal of replacing boost::python.  Passed in unanamious vote.

7) Next meeting

Next meeting is June 15th, 2021. 12pm-1pm EST (GMT-5).
