Minutes from 68th OpenVDB TSC meeting, Oct 27th, 2020, (EDT)

Attendees: *Nick* A., *Jeff* L., *Ken* M., *Dan* B.

Additional Attendees: Johannes Meng (Intel), JT Nelson (Blender),
Andre Pradhana (DW), Bruce Cherniak (Intel)

Regrets: *Peter* C.

Agenda:

1) Confirm Quorum
2) Secretary
3) Paged Array
4) AX
5) Faster Merge
6) Author Field in Headers
7) Next Meeting

1) Confirm Quorum

Quorum is present.

2) Secretary

Secretary is Jeff Lait.

3) Paged Array

Nick's concurrent unit test script manages to consistently crash the paged array test.  There was a thread-unsafe method.  The current fix is just decreasing the chance of race conditions.

There is an atomic counter checking against capacity.  But there is no barrier, so two could trigger the capacity check at once.  This is only the direct method; the accessor method doesn't have the problem as it does local insertions that it passes on demand, which is mutex locked.

The paged array has two APIs to add values.  A direct access, and an accessor-style method.  Using accessors is almost always faster than the direct method.  Having a slow method leads people to think VDB is 100x slower than a direct grid, as they don't try the accessor.  Why have an inferior method?

The direct access for paged array is not thread safe. So why do we have it?

Should we take out non-accessor methods, for this and VDB? What about a single query on a tree?  So what about an accessor type that isn't cached?  Maybe we should have a set of different accessor types to handle different caching policies?

If we lose the direct access, it is much harder for new users to get going.
But people keep going with very slow approaches.  valueOn accessor is so much
slower that it should just be removed.

Is most of the time the root hash?  Should we re-root the hash to reduce the amount of overlap?  Or replace the root hash to be faster?

a) Can we make the tree faster?
b) Should we specialize the accessor for non-caching methods?

Replacing the root hash is tricky.  We are requiring the sorting property of the root node.  We may need to change the root node behaviour depending on the number of entries - small entries could be a raw vector, for example.

4) AX

Nick has been working on it.

Modulo implementation.  Currently does C-standard method.  Will change to match on VEX/Python approach.  Done and upstreamed.

rand() uses boost::rand.  Switched to std::.  Speed is slower for 32-bit, faster for 64-bit.  Currently API is rand and rand32, considering whether 32-bit generator has better distribution than 64-bit.  Done and upstreamed.

Integer: do we remove short type for local variables?  We need to keep the syntax to access the grid types.  The same applies to int / long.  Not sure yet of performance cost.  Literals should be 64-bit.   Vec3 local variables are currently 32-bit to match grids, this could be changed to 64-bit with 32-bit as a specifier for grids.  The other big question is literals: can 32-bit AX have 64-bit literals?  Generally agreed having the L suffix is not a good idea, but how to compute intermediate values is unclear.

Short circuit boolean operations.  AX doesn't currently short circuit, so if (false && i++) would increment i.  VEX doesn't short circuit.  This surprises members of the committee, and has been submitted as a bug.

CI is now not bulding LLVM from source but using the docker containers.

Most runtime exceptions have been replaced by a logger.  The compiler will now return nulls and generate a log if logger provided.  Otherwise it will throw exceptions on errors.

5) Faster Merge

The feedback has been addressed.   Now requires references and the const vs non-const is now deep vs steal.

6) Author Field in Headers

What do we do with @author fields?  Having a prime author is useful.  You don't get that from git.  Historically files were committed by one username.  Is this an owner or primary authors?  

Some files have no names as there is no one author as too many have touched the file.

To avoid potential drama, we have drafted an ad-hoc author policty.   We will not remove people from the @author list.  If we make a substantial change to a file, we can add ourselves at our discretion.

7) Next Meeting

Next meeting is November 3rd, 2020. 12pm-1pm EST (GMT-5).
