# Oauth2️⃣ ↔

👆 💪 ⚙️ Oauth2️⃣ ↔ 🔗 ⏮️ **FastAPI**, 👫 🛠️ 👷 💎.

👉 🔜 ✔ 👆 ✔️ 🌖 👌-🧽 ✔ ⚙️, 📄 Oauth2️⃣ 🐩, 🛠️ 🔘 👆 🗄 🈸 (&amp; 🛠️ 🩺).

Oauth2️⃣ ⏮️ ↔ 🛠️ ⚙️ 📚 🦏 🤝 🐕‍🦺, 💖 👱📔, 🇺🇸🔍, 📂, 🤸‍♂, 👱📔, ♒️. 👫 ⚙️ ⚫️ 🚚 🎯 ✔ 👩‍💻 &amp; 🈸.

🔠 🕰 👆 "🕹 ⏮️" 👱📔, 🇺🇸🔍, 📂, 🤸‍♂, 👱📔, 👈 🈸 ⚙️ Oauth2️⃣ ⏮️ ↔.

👉 📄 👆 🔜 👀 ❔ 🛠️ 🤝 &amp; ✔ ⏮️ 🎏 Oauth2️⃣ ⏮️ ↔ 👆 **FastAPI** 🈸.

/// warning

👉 🌅 ⚖️ 🌘 🏧 📄. 🚥 👆 ▶️, 👆 💪 🚶 ⚫️.

👆 🚫 🎯 💪 Oauth2️⃣ ↔, &amp; 👆 💪 🍵 🤝 &amp; ✔ 👐 👆 💚.

✋️ Oauth2️⃣ ⏮️ ↔ 💪 🎆 🛠️ 🔘 👆 🛠️ (⏮️ 🗄) &amp; 👆 🛠️ 🩺.

👐, 👆 🛠️ 📚 ↔, ⚖️ 🙆 🎏 💂‍♂/✔ 📄, 👐 👆 💪, 👆 📟.

📚 💼, Oauth2️⃣ ⏮️ ↔ 💪 👹.

✋️ 🚥 👆 💭 👆 💪 ⚫️, ⚖️ 👆 😟, 🚧 👂.

///

## Oauth2️⃣ ↔ &amp; 🗄

Oauth2️⃣ 🔧 🔬 "↔" 📇 🎻 🎏 🚀.

🎚 🔠 👉 🎻 💪 ✔️ 🙆 📁, ✋️ 🔜 🚫 🔌 🚀.

👫 ↔ 🎨 "✔".

🗄 (✅ 🛠️ 🩺), 👆 💪 🔬 "💂‍♂ ⚖".

🕐❔ 1️⃣ 👫 💂‍♂ ⚖ ⚙️ Oauth2️⃣, 👆 💪 📣 &amp; ⚙️ ↔.

🔠 "↔" 🎻 (🍵 🚀).

👫 🛎 ⚙️ 📣 🎯 💂‍♂ ✔, 🖼:

* `users:read` ⚖️ `users:write` ⚠ 🖼.
* `instagram_basic` ⚙️ 👱📔 / 👱📔.
* `https://www.googleapis.com/auth/drive` ⚙️ 🇺🇸🔍.

/// info

Oauth2️⃣ "↔" 🎻 👈 📣 🎯 ✔ ✔.

⚫️ 🚫 🤔 🚥 ⚫️ ✔️ 🎏 🦹 💖 `:` ⚖️ 🚥 ⚫️ 📛.

👈 ℹ 🛠️ 🎯.

Oauth2️⃣ 👫 🎻.

///

## 🌐 🎑

🥇, ➡️ 🔜 👀 🍕 👈 🔀 ⚪️➡️ 🖼 👑 **🔰 - 👩‍💻 🦮** [Oauth2️⃣ ⏮️ 🔐 (&amp; 🔁), 📨 ⏮️ 🥙 🤝](../../tutorial/security/oauth2-jwt.md){.internal-link target=_blank}. 🔜 ⚙️ Oauth2️⃣ ↔:

{* ../../docs_src/security/tutorial005.py hl[2,4,8,12,46,64,105,107:115,121:124,128:134,139,155] *}

🔜 ➡️ 📄 👈 🔀 🔁 🔁.

## Oauth2️⃣ 💂‍♂ ⚖

🥇 🔀 👈 🔜 👥 📣 Oauth2️⃣ 💂‍♂ ⚖ ⏮️ 2️⃣ 💪 ↔, `me` &amp; `items`.

`scopes` 🔢 📨 `dict` ⏮️ 🔠 ↔ 🔑 &amp; 📛 💲:

{* ../../docs_src/security/tutorial005.py hl[62:65] *}

↩️ 👥 🔜 📣 📚 ↔, 👫 🔜 🎦 🆙 🛠️ 🩺 🕐❔ 👆 🕹-/✔.

&amp; 👆 🔜 💪 🖊 ❔ ↔ 👆 💚 🤝 🔐: `me` &amp; `items`.

👉 🎏 🛠️ ⚙️ 🕐❔ 👆 🤝 ✔ ⏪ 🚨 ⏮️ 👱📔, 🇺🇸🔍, 📂, ♒️:

<img src="/img/tutorial/security/image11.png">

## 🥙 🤝 ⏮️ ↔

🔜, 🔀 🤝 *➡ 🛠️* 📨 ↔ 📨.

👥 ⚙️ 🎏 `OAuth2PasswordRequestForm`. ⚫️ 🔌 🏠 `scopes` ⏮️ `list` `str`, ⏮️ 🔠 ↔ ⚫️ 📨 📨.

&amp; 👥 📨 ↔ 🍕 🥙 🤝.

/// danger

🦁, 📥 👥 ❎ ↔ 📨 🔗 🤝.

✋️ 👆 🈸, 💂‍♂, 👆 🔜 ⚒ 💭 👆 🕴 🚮 ↔ 👈 👩‍💻 🤙 💪 ✔️, ⚖️ 🕐 👆 ✔️ 🔁.

///

{* ../../docs_src/security/tutorial005.py hl[155] *}

## 📣 ↔ *➡ 🛠️* &amp; 🔗

🔜 👥 📣 👈 *➡ 🛠️* `/users/me/items/` 🚚 ↔ `items`.

👉, 👥 🗄 &amp; ⚙️ `Security` ⚪️➡️ `fastapi`.

👆 💪 ⚙️ `Security` 📣 🔗 (💖 `Depends`), ✋️ `Security` 📨 🔢 `scopes` ⏮️ 📇 ↔ (🎻).

👉 💼, 👥 🚶‍♀️ 🔗 🔢 `get_current_active_user` `Security` (🎏 🌌 👥 🔜 ⏮️ `Depends`).

✋️ 👥 🚶‍♀️ `list` ↔, 👉 💼 ⏮️ 1️⃣ ↔: `items` (⚫️ 💪 ✔️ 🌅).

&amp; 🔗 🔢 `get_current_active_user` 💪 📣 🎧-🔗, 🚫 🕴 ⏮️ `Depends` ✋️ ⏮️ `Security`. 📣 🚮 👍 🎧-🔗 🔢 (`get_current_user`), &amp; 🌖 ↔ 📄.

👉 💼, ⚫️ 🚚 ↔ `me` (⚫️ 💪 🚚 🌅 🌘 1️⃣ ↔).

/// note

👆 🚫 🎯 💪 🚮 🎏 ↔ 🎏 🥉.

👥 🔨 ⚫️ 📥 🎦 ❔ **FastAPI** 🍵 ↔ 📣 🎏 🎚.

///

{* ../../docs_src/security/tutorial005.py hl[4,139,168] *}

/// info | 📡 ℹ

`Security` 🤙 🏿 `Depends`, &amp; ⚫️ ✔️ 1️⃣ ➕ 🔢 👈 👥 🔜 👀 ⏪.

✋️ ⚙️ `Security` ↩️ `Depends`, **FastAPI** 🔜 💭 👈 ⚫️ 💪 📣 💂‍♂ ↔, ⚙️ 👫 🔘, &amp; 📄 🛠️ ⏮️ 🗄.

✋️ 🕐❔ 👆 🗄 `Query`, `Path`, `Depends`, `Security` &amp; 🎏 ⚪️➡️ `fastapi`, 👈 🤙 🔢 👈 📨 🎁 🎓.

///

## ⚙️ `SecurityScopes`

🔜 ℹ 🔗 `get_current_user`.

👉 1️⃣ ⚙️ 🔗 🔛.

📥 👥 ⚙️ 🎏 Oauth2️⃣ ⚖ 👥 ✍ ⏭, 📣 ⚫️ 🔗: `oauth2_scheme`.

↩️ 👉 🔗 🔢 🚫 ✔️ 🙆 ↔ 📄 ⚫️, 👥 💪 ⚙️ `Depends` ⏮️ `oauth2_scheme`, 👥 🚫 ✔️ ⚙️ `Security` 🕐❔ 👥 🚫 💪 ✔ 💂‍♂ ↔.

👥 📣 🎁 🔢 🆎 `SecurityScopes`, 🗄 ⚪️➡️ `fastapi.security`.

👉 `SecurityScopes` 🎓 🎏 `Request` (`Request` ⚙️ 🤚 📨 🎚 🔗).

{* ../../docs_src/security/tutorial005.py hl[8,105] *}

## ⚙️ `scopes`

🔢 `security_scopes` 🔜 🆎 `SecurityScopes`.

⚫️ 🔜 ✔️ 🏠 `scopes` ⏮️ 📇 ⚗ 🌐 ↔ ✔ ⚫️ &amp; 🌐 🔗 👈 ⚙️ 👉 🎧-🔗. 👈 ⛓, 🌐 "⚓️"... 👉 💪 🔊 😨, ⚫️ 🔬 🔄 ⏪ 🔛.

`security_scopes` 🎚 (🎓 `SecurityScopes`) 🚚 `scope_str` 🔢 ⏮️ 👁 🎻, 🔌 👈 ↔ 👽 🚀 (👥 🔜 ⚙️ ⚫️).

👥 ✍ `HTTPException` 👈 👥 💪 🏤-⚙️ (`raise`) ⏪ 📚 ☝.

👉 ⚠, 👥 🔌 ↔ 🚚 (🚥 🙆) 🎻 👽 🚀 (⚙️ `scope_str`). 👥 🚮 👈 🎻 ⚗ ↔ `WWW-Authenticate` 🎚 (👉 🍕 🔌).

{* ../../docs_src/security/tutorial005.py hl[105,107:115] *}

## ✔ `username` &amp; 💽 💠

👥 ✔ 👈 👥 🤚 `username`, &amp; ⚗ ↔.

&amp; ⤴️ 👥 ✔ 👈 📊 ⏮️ Pydantic 🏷 (✊ `ValidationError` ⚠), &amp; 🚥 👥 🤚 ❌ 👂 🥙 🤝 ⚖️ ⚖ 📊 ⏮️ Pydantic, 👥 🤚 `HTTPException` 👥 ✍ ⏭.

👈, 👥 ℹ Pydantic 🏷 `TokenData` ⏮️ 🆕 🏠 `scopes`.

⚖ 📊 ⏮️ Pydantic 👥 💪 ⚒ 💭 👈 👥 ✔️, 🖼, ⚫️❔ `list` `str` ⏮️ ↔ &amp; `str` ⏮️ `username`.

↩️, 🖼, `dict`, ⚖️ 🕳 🙆, ⚫️ 💪 💔 🈸 ☝ ⏪, ⚒ ⚫️ 💂‍♂ ⚠.

👥 ✔ 👈 👥 ✔️ 👩‍💻 ⏮️ 👈 🆔, &amp; 🚥 🚫, 👥 🤚 👈 🎏 ⚠ 👥 ✍ ⏭.

{* ../../docs_src/security/tutorial005.py hl[46,116:127] *}

## ✔ `scopes`

👥 🔜 ✔ 👈 🌐 ↔ ✔, 👉 🔗 &amp; 🌐 ⚓️ (🔌 *➡ 🛠️*), 🔌 ↔ 🚚 🤝 📨, ⏪ 🤚 `HTTPException`.

👉, 👥 ⚙️ `security_scopes.scopes`, 👈 🔌 `list` ⏮️ 🌐 👫 ↔ `str`.

{* ../../docs_src/security/tutorial005.py hl[128:134] *}

## 🔗 🌲 &amp; ↔

➡️ 📄 🔄 👉 🔗 🌲 &amp; ↔.

`get_current_active_user` 🔗 ✔️ 🎧-🔗 🔛 `get_current_user`, ↔ `"me"` 📣 `get_current_active_user` 🔜 🔌 📇 ✔ ↔ `security_scopes.scopes` 🚶‍♀️ `get_current_user`.

*➡ 🛠️* ⚫️ 📣 ↔, `"items"`, 👉 🔜 📇 `security_scopes.scopes` 🚶‍♀️ `get_current_user`.

📥 ❔ 🔗 🔗 &amp; ↔ 👀 💖:

*  *➡ 🛠️* `read_own_items` ✔️:
    * ✔ ↔ `["items"]` ⏮️ 🔗:
    * `get_current_active_user`:
        *  🔗 🔢 `get_current_active_user` ✔️:
            * ✔ ↔ `["me"]` ⏮️ 🔗:
            * `get_current_user`:
                * 🔗 🔢 `get_current_user` ✔️:
                    * 🙅‍♂ ↔ ✔ ⚫️.
                    * 🔗 ⚙️ `oauth2_scheme`.
                    *  `security_scopes` 🔢 🆎 `SecurityScopes`:
                        * 👉 `security_scopes` 🔢 ✔️ 🏠 `scopes` ⏮️ `list` ⚗ 🌐 👫 ↔ 📣 🔛,:
                            * `security_scopes.scopes` 🔜 🔌 `["me", "items"]` *➡ 🛠️* `read_own_items`.
                            * `security_scopes.scopes` 🔜 🔌 `["me"]` *➡ 🛠️* `read_users_me`, ↩️ ⚫️ 📣 🔗 `get_current_active_user`.
                            * `security_scopes.scopes` 🔜 🔌 `[]` (🕳) *➡ 🛠️* `read_system_status`, ↩️ ⚫️ 🚫 📣 🙆 `Security` ⏮️ `scopes`, &amp; 🚮 🔗, `get_current_user`, 🚫 📣 🙆 `scope` 👯‍♂️.

/// tip

⚠ &amp; "🎱" 👜 📥 👈 `get_current_user` 🔜 ✔️ 🎏 📇 `scopes` ✅ 🔠 *➡ 🛠️*.

🌐 ⚓️ 🔛 `scopes` 📣 🔠 *➡ 🛠️* &amp; 🔠 🔗 🔗 🌲 👈 🎯 *➡ 🛠️*.

///

## 🌖 ℹ 🔃 `SecurityScopes`

👆 💪 ⚙️ `SecurityScopes` 🙆 ☝, &amp; 💗 🥉, ⚫️ 🚫 ✔️ "🌱" 🔗.

⚫️ 🔜 🕧 ✔️ 💂‍♂ ↔ 📣 ⏮️ `Security` 🔗 &amp; 🌐 ⚓️ **👈 🎯** *➡ 🛠️* &amp; **👈 🎯** 🔗 🌲.

↩️ `SecurityScopes` 🔜 ✔️ 🌐 ↔ 📣 ⚓️, 👆 💪 ⚙️ ⚫️ ✔ 👈 🤝 ✔️ 🚚 ↔ 🇨🇫 🔗 🔢, &amp; ⤴️ 📣 🎏 ↔ 📄 🎏 *➡ 🛠️*.

👫 🔜 ✅ ➡ 🔠 *➡ 🛠️*.

## ✅ ⚫️

🚥 👆 📂 🛠️ 🩺, 👆 💪 🔓 &amp; ✔ ❔ ↔ 👆 💚 ✔.

<img src="/img/tutorial/security/image11.png">

🚥 👆 🚫 🖊 🙆 ↔, 👆 🔜 "🔓", ✋️ 🕐❔ 👆 🔄 🔐 `/users/me/` ⚖️ `/users/me/items/` 👆 🔜 🤚 ❌ 💬 👈 👆 🚫 ✔️ 🥃 ✔. 👆 🔜 💪 🔐 `/status/`.

&amp; 🚥 👆 🖊 ↔ `me` ✋️ 🚫 ↔ `items`, 👆 🔜 💪 🔐 `/users/me/` ✋️ 🚫 `/users/me/items/`.

👈 ⚫️❔ 🔜 🔨 🥉 🥳 🈸 👈 🔄 🔐 1️⃣ 👫 *➡ 🛠️* ⏮️ 🤝 🚚 👩‍💻, ⚓️ 🔛 ❔ 📚 ✔ 👩‍💻 🤝 🈸.

## 🔃 🥉 🥳 🛠️

👉 🖼 👥 ⚙️ Oauth2️⃣ "🔐" 💧.

👉 ☑ 🕐❔ 👥 🚨 👆 👍 🈸, 🎲 ⏮️ 👆 👍 🕸.

↩️ 👥 💪 💙 ⚫️ 📨 `username` &amp; `password`, 👥 🎛 ⚫️.

✋️ 🚥 👆 🏗 Oauth2️⃣ 🈸 👈 🎏 🔜 🔗 (➡, 🚥 👆 🏗 🤝 🐕‍🦺 🌓 👱📔, 🇺🇸🔍, 📂, ♒️.) 👆 🔜 ⚙️ 1️⃣ 🎏 💧.

🌅 ⚠ 🔑 💧.

🏆 🔐 📟 💧, ✋️ 🌖 🏗 🛠️ ⚫️ 🚚 🌅 📶. ⚫️ 🌅 🏗, 📚 🐕‍🦺 🔚 🆙 ✔ 🔑 💧.

/// note

⚫️ ⚠ 👈 🔠 🤝 🐕‍🦺 📛 👫 💧 🎏 🌌, ⚒ ⚫️ 🍕 👫 🏷.

✋️ 🔚, 👫 🛠️ 🎏 Oauth2️⃣ 🐩.

///

**FastAPI** 🔌 🚙 🌐 👫 Oauth2️⃣ 🤝 💧 `fastapi.security.oauth2`.

## `Security` 👨‍🎨 `dependencies`

🎏 🌌 👆 💪 🔬 `list` `Depends` 👨‍🎨 `dependencies` 🔢 (🔬 [🔗 ➡ 🛠️ 👨‍🎨](../../tutorial/dependencies/dependencies-in-path-operation-decorators.md){.internal-link target=_blank}), 👆 💪 ⚙️ `Security` ⏮️ `scopes` 📤.
