# Тестування залежностей з переписуваннями { #testing-dependencies-with-overrides }

## Переписування залежностей під час тестування { #overriding-dependencies-during-testing }

Є сценарії, коли ви можете захотіти переписати залежність під час тестування.

Ви не хочете запускати оригінальну залежність (ані будь-які її підзалежності).

Натомість ви хочете надати іншу залежність, яку буде використано лише під час тестів (можливо, тільки в окремих тестах), і яка повертатиме значення, що підставляється всюди, де раніше використовувалося значення оригінальної залежності.

### Випадки використання: зовнішній сервіс { #use-cases-external-service }

Наприклад, у вас є зовнішній постачальник автентифікації, який потрібно викликати.

Ви надсилаєте йому токен, і він повертає автентифікованого користувача.

Такий постачальник може стягувати плату за кожний запит, а виклик може займати більше часу, ніж використання фіксованого фальшивого користувача для тестів.

Ймовірно, ви хочете протестувати зовнішнього постачальника один раз, але не обов'язково викликати його для кожного тесту.

У такому разі ви можете переписати залежність, що викликає цього постачальника, і використати власну залежність, яка повертає фальшивого користувача, лише для ваших тестів.

### Використовуйте атрибут `app.dependency_overrides` { #use-the-app-dependency-overrides-attribute }

Для таких випадків ваш застосунок FastAPI має атрибут `app.dependency_overrides`, це простий `dict`.

Щоб переписати залежність для тестування, вкажіть у ключі оригінальну залежність (функцію), а значенням - ваше переписування залежності (іншу функцію).

Після цього FastAPI викликатиме це переписування замість оригінальної залежності.

{* ../../docs_src/dependency_testing/tutorial001_an_py310.py hl[26:27,30] *}

/// tip | Порада

Ви можете налаштувати переписування для залежності, яка використовується де завгодно у вашому застосунку FastAPI.

Оригінальна залежність може використовуватися у функції операції шляху, у декораторі операції шляху (коли ви не використовуєте повернуте значення), у виклику `.include_router()` тощо.

FastAPI усе одно зможе її переписати.

///

Потім ви можете скинути переписування (видалити їх), встановивши для `app.dependency_overrides` порожній `dict`:

```Python
app.dependency_overrides = {}
```

/// tip | Порада

Якщо ви хочете переписувати залежність лише під час окремих тестів, встановіть переписування на початку тесту (всередині тестової функції) і скиньте його наприкінці (в кінці тестової функції).

///
